#include "cache.h"
#include "calculator.h"

#include <drive/telematics/protocol/vega.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(Calculator) {
    Y_UNIT_TEST(CustomStringSensor) {
        NDrive::TSensorsCache cache(42);
        NDrive::TSensorCalculator calculator;
        {
            NDrive::TSensor sensor(NDrive::TSensorId(2976));
            auto derived = calculator.Derive(sensor, cache);
            UNIT_ASSERT_VALUES_EQUAL(derived.size(), 1);
            UNIT_ASSERT_VALUES_EQUAL(derived[0].Id, VEGA_ECM_DTC_LIST_SENSOR);
        }
    }
}
