#pragma once

#include <drive/telematics/server/location/heartbeat.h>
#include <drive/telematics/server/location/location.h>

#include <drive/telematics/protocol/sensor.h>

namespace NDrive {
    class TSensorsCache;

    enum class EDataValidationStatus {
        Ok,
        Future,
        OutlierValue,
        OverflownValue,
        UnexpectedValueType,
        ZeroValue,
        Invalid
    };
    struct TDataValidationOptions {
        TDuration FutureThreshold = TDuration::Minutes(1);
        double FilterOdometerThreshold = 256 * 1024;
        double FilterOdometerDeltaThreshold = 0.1;
        double FilterOdometerMinimalStep = 10;
        bool FilterOdometerEnabled = true;
        bool FilterSkipZeroEnabled = true;
    };

    std::pair<THeartbeat, EDataValidationStatus> Validate(THeartbeat&& heartbeat, const TSensorsCache& cache, const TDataValidationOptions& options = {});
    std::pair<TLocation, EDataValidationStatus> Validate(TLocation&& location, const TSensorsCache& cache, const TDataValidationOptions& options = {});
    std::pair<TSensor, EDataValidationStatus> Validate(TSensor&& sensor, const TSensorsCache& cache, const TDataValidationOptions& options = {});
}
