#pragma once

#include <drive/telematics/server/pusher/interface.h>

#include <drive/library/cpp/auth/tvm.h>

#include <util/generic/set.h>

namespace NNeh {
    class THttpClient;
    class THttpReply;
    class THttpRequest;
}

namespace NDrive {
    class TTelematicsCacheApiPusherOptions : public IPusherOptions {
    public:
        virtual THolder<IPusher> BuildPusher(const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm) const override;
        virtual TSet<NTvmAuth::TTvmId> GetDestinationClientIds() const override;

    private:
        virtual void Init(const TYandexConfig::Section& section) override;
        virtual void Print(IOutputStream& os) const override;

    private:
        static inline TFactory::TRegistrator<TTelematicsCacheApiPusherOptions> Registrator{"TelematicsCacheApi"};

    public:
        size_t TrafficPercent;
        TString Endpoint;
    };

    class TTelematicsCacheApiPusher: public IPusher {
    private:
        using TBase = IPusher;

    public:
        TTelematicsCacheApiPusher(const TTelematicsCacheApiPusherOptions& options);
        ~TTelematicsCacheApiPusher() = default;

        NThreading::TFuture<TPushResult> Push(const TString& imei, const IHandlerDescription& handler, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const THeartbeat& heartbeat, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TSensor& sensor, TInstant deadline = TInstant::Zero()) override;

        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TTelematicsHandlerPtr> handlersPtrs, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<THeartbeat> heartbeats, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TLocation> locations, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TSensor> sensors, TInstant deadline = TInstant::Zero()) override;

    private:
        template <typename TGenericPushResult, typename TValue, typename TFunction>
        NThreading::TFuture<TGenericPushResult> PushGeneric(TFunction getArrayItemFunction, const TString& imei, const TConstArrayRef<TValue> values, TInstant deadline = TInstant::Zero()) const;
        template <typename TGenericPushResult>
        NThreading::TFuture<TGenericPushResult> ProcessResponse(const NThreading::TFuture<NNeh::THttpReply>& reply) const;

    private:
        THolder<NNeh::THttpClient> Client;

        const TString Handler;
        const size_t TrafficPercent;
    };
}
