#pragma once

#include <drive/telematics/api/client.h>
#include <drive/telematics/client/car_emulator/car_emulator.h>
#include <drive/telematics/protocol/navtelecom.h>
#include <drive/telematics/protocol/wialon.h>

#include <library/cpp/testing/unittest/tests_data.h>

namespace NDrive {
    class TTelematicsConfig;
    class TTelematicsServer;
}

class TTelematicServerBuilder {
public:
    static ui16 GetTcpPort();
    static ui16 GetHttpPort();

public:
    TAtomicSharedPtr<NDrive::TTelematicsConfig> CreateConfig();
    TAtomicSharedPtr<NDrive::TTelematicsServer> CreateServer(TAtomicSharedPtr<NDrive::TTelematicsConfig> config);

public:
    TTelematicServerBuilder(ui16 index = 0, const TString& storageType = "LOCAL", bool useRemotePusher = false);
    ~TTelematicServerBuilder();

    bool IsRunning() const;
    void Run();

    TAtomicSharedPtr<NDrive::TCarEmulator> BuildEmulator(const TString& imei, TAtomicSharedPtr<NDrive::TTelematicsClientContext> context = {});

    TAtomicSharedPtr<NDrive::TTelematicsConfig> GetConfig();
    TAtomicSharedPtr<NDrive::TTelematicsServer> GetServer();
    TAtomicSharedPtr<NDrive::TTelematicsApi> GetAPI();

    bool SetSensorDoubleValue(const NDrive::TCarEmulator& emulator, const ui16 sensorId, const double value);

    template <class TValueType>
    bool SetSensorValue(const NDrive::TCarEmulator& emulator, const ui16 sensorId, const TValueType value) {
        auto handle = API->SetParameter<TValueType>(emulator.GetIMEI(), sensorId, 0, value);
        while (!API->Await(handle)) {
            Sleep(TDuration::MilliSeconds(100));
        }
        CHECK_WITH_LOG(API->GetStatus(handle) == NDrive::TTelematicsApi::EStatus::Success);
        return true;
    }

private:
    const TString StorageType;
    const bool UseRemotePusher;
    const ui16 Index;

    TAtomicSharedPtr<NDrive::TTelematicsConfig> Config;
    TAtomicSharedPtr<NDrive::TTelematicsServer> Server;
    TAtomicSharedPtr<NDrive::TTelematicsApi> API;
};

NDrive::NProtocol::TArray<NDrive::NVega::TBlackboxRecords::TRecord, ui16> Blackbox();
NDrive::NNavTelecom::TRecord NavTelecomBlackbox();
NDrive::NWialon::TShortData WialonBlackbox();
