#include <drive/telematics/server/library/navtelecom.h>
#include <drive/telematics/server/library/protocol.h>
#include <drive/telematics/server/sensors/cache.h>

#include <drive/telematics/protocol/navtelecom.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/string/hex.h>

Y_UNIT_TEST_SUITE(TelematicsProtocolSuite) {
    Y_UNIT_TEST(AutoDetect) {
        TString wialonData = "#L#2.0;869286035183933;NA;9E33\r\n";
        TString navtelecomData = HexDecode("404E544301000000000000001300474C2A3E533A383632353331303433323034333231");
        TString invalidData = HexDecode("404E54430100000000009E33");

        {
            auto protocolType = NDrive::NProtocol::TProtocolMeta::TryDetect(TBuffer(wialonData.Data(), wialonData.Size()));
            UNIT_ASSERT_EQUAL(protocolType, NDrive::NProtocol::PT_WIALON_IPS);
        }

        {
            auto protocolType = NDrive::NProtocol::TProtocolMeta::TryDetect(TBuffer(navtelecomData.Data(), navtelecomData.Size()));
            UNIT_ASSERT_EQUAL(protocolType, NDrive::NProtocol::PT_NAVTELECOM);
        }

        {
            auto protocolType = NDrive::NProtocol::TProtocolMeta::TryDetect(TBuffer(invalidData.Data(), invalidData.Size()));
            UNIT_ASSERT_EQUAL(protocolType, NDrive::NProtocol::PT_INVALID);
        }
    }

    Y_UNIT_TEST(NavTelecomConvert) {
        TVector<NDrive::NNavTelecom::TParameter> parameters;

        parameters.emplace_back(NDrive::NNavTelecom::PI_CAN_ACCELERATOR, 0, ui64(23));
        parameters.emplace_back(NDrive::NNavTelecom::PI_ANALOG_INPUT_1, 0, ui64(10234));
        parameters.emplace_back(NDrive::NNavTelecom::PI_SPEED, 0, double(23.4));

        NDrive::TSensorsCache cache(5);

        auto emptySender = [] (const NDrive::NProtocol::IMessage&) {};
        auto protocolPointer = NDrive::NProtocol::IProtocol::Create<NDrive::NNavTelecom::TNavTelecomProtocol>(emptySender);;

        NDrive::NNavTelecom::TRecord record;
        record.Parameters = std::move(parameters);

        auto sensors = cache.Add(record);

        UNIT_ASSERT_EQUAL(sensors.size(), 2);
    }
}
