#include <drive/telematics/server/library/scenarios.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TelematicsScenarios) {
    Y_UNIT_TEST(ScenarioWithTick) {
        auto task = NDrive::CreateCommand("warming", NDrive::NVega::ECommandCode::YADRIVE_WARMING, {}, Default<NDrive::TCommandOptions>());
        UNIT_ASSERT(task);

        auto condition = [](NDrive::TTelematicsConnection* connection) {
            Y_UNUSED(connection);
            return NDrive::TConditionalTask::Success("no way");
        };
        auto conditional = MakeIntrusive<NDrive::TConditionalTask>(task, condition);
        UNIT_ASSERT(conditional);

        NDrive::TMultiTask::TTasks tasks = { conditional };
        auto sequential = MakeAtomicShared<NDrive::TSequentialTask>("sequential", std::move(tasks));
        UNIT_ASSERT(sequential);

        UNIT_ASSERT(sequential->OnAfterRegister(nullptr));
        UNIT_ASSERT(sequential->OnMessage(nullptr, NDrive::NVega::TMessage()));
        UNIT_ASSERT_VALUES_EQUAL(sequential->GetStatus(), NDrive::TCommonTask::EStatus::Success);
    }
}
