PY3_PROGRAM()

OWNER(
    dbarbashin
    svshevtsov
    lyakich
)

PEERDIR(
    contrib/python/jsonschema
    contrib/python/requests
    contrib/python/Shapely
    contrib/python/validators
    drive/backend/api
    library/python/resource
)

RESOURCE(
    schemas/user_app_car_list.json /schemas/user_app_car_list.json
    schemas/user_app_radar_areas.json /schemas/user_app_radar_areas.json
    schemas/user_app_user_session.json /schemas/user_app_user_session.json
    schemas/user_app_sessions_history.json /schemas/user_app_sessions_history.json
    schemas/user_app_offers_create.json /schemas/user_app_offers_create.json
    schemas/user_app_drop_areas.json /schemas/user_app_drop_areas.json
    schemas/user_app_areas_operation_info.json /schemas/user_app_areas_operation_info.json
    schemas/support_api_chat_history_unread.json /schemas/support_api_chat_history_unread.json
    schemas/support_api_chats_list.json /schemas/support_api_chats_list.json
)

PY_SRCS(
    TOP_LEVEL
    main.py
    base.py
    events.py
    schemas.py
    tests.py
    utils/helpers.py
    utils/args.py
    utils/endpoints.py
    utils/wrappers.py
    utils/timeout.py
    suites/basic.py
    suites/basic_operations_tests.py
    suites/minutes_offer_tests.py
    suites/hourly_offer_tests.py
    suites/block_user_tests.py
    suites/radar_tests.py
    suites/fix_point_tests.py
    suites/future_car_tests.py
    suites/minimal_price_tests.py
    suites/switch_offers_tests.py
)

PY_MAIN(main)

NO_CHECK_IMPORTS()

END()
