PY3TEST(drive_functional_tests)

OWNER(
    dbarbashin
    lyakich
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/allure/recipe.inc)

TEST_SRCS(
    tests/test_api_schemas.py
    tests/test_basic_operations.py
    tests/test_block_user.py
    tests/test_hourly_offer.py
    tests/test_minutes_offer.py
    tests/test_fix_point.py
    tests/test_switch_offers.py
    tests/test_minimal_price.py
    tests/test_future_car.py
)

PY_SRCS(
    schemas.py
    conftest.py
    helpers/helpers.py
    utils/base_tests.py
    utils/proxied_backend_api.py
    utils/timeout.py
    utils/oauth.py
    utils/tus.py
    utils/yav.py
)

REQUIREMENTS(
    sb_vault:YAV_TOKEN=file:EXTMAPS:drive_functional_tests
    network:full
)

PEERDIR(
    contrib/python/flaky
    contrib/python/jsonschema
    contrib/python/Shapely
    contrib/python/pytest
    contrib/python/validators
    library/python/resource
    library/python/vault_client
    library/python/pytest/allure
    drive/backend/api
    drive/qatool/tus
)

RESOURCE(
    schemas/user_app_car_list.json /schemas/user_app_car_list.json
    schemas/user_app_radar_areas.json /schemas/user_app_radar_areas.json
    schemas/user_app_user_session.json /schemas/user_app_user_session.json
    schemas/user_app_sessions_history.json /schemas/user_app_sessions_history.json
    schemas/user_app_offers_create.json /schemas/user_app_offers_create.json
    schemas/user_app_drop_areas.json /schemas/user_app_drop_areas.json
    schemas/user_app_areas_operation_info.json /schemas/user_app_areas_operation_info.json
    schemas/support_api_chat_history_unread.json /schemas/support_api_chat_history_unread.json
    schemas/support_api_chats_list.json /schemas/support_api_chats_list.json
)

SIZE(LARGE)

NO_CHECK_IMPORTS()

TAG(
    ya:fat
    ya:external
    ya:not_autocheck
    ya:force_sandbox
)

FORK_TEST_FILES()

ENV(PYTEST_ADDOPTS=--log-format='%\(asctime\)s %\(levelname\)s %\(message\)s')

END()
