# -*- coding: utf-8 -*-
import argparse
import os
from datetime import datetime

parser = argparse.ArgumentParser()
parser.add_argument('path')
parser.add_argument('--count', type=int, default=1)
parser.add_argument('--prefix')
parser.add_argument('-y', '--apply', action='store_const', const=True, help='Apply changes')
parser.add_argument('-b', '--batch', help='Make batch')
parser.add_argument('--ya_path', default='~/ya')
parser.add_argument('--binary_path', default='~/frontend')

args = parser.parse_args()

files = os.listdir(args.path)
files = [os.path.join(args.path, file) for file in files]
if args.prefix:
    files = [file for file in files if os.path.basename(file).startswith(args.prefix)]
files = [[file, os.path.getctime(file)] for file in files if os.path.isfile(file)]
if len(files) > args.count:
    if args.batch and not os.path.exists(args.batch):
        os.makedirs(args.batch)
    sort_date_list = sorted(files, key=lambda x: x[1])
    remove_count = len(files) - args.count
    for file in sort_date_list:
        if remove_count > 0:
            remove_count-=1
            print 'remove', file[0], datetime.fromtimestamp(file[1]).strftime('%Y-%m-%d %H:%M:%S')
            if args.batch:
                os.system(
                    args.ya_path + ' tool gdb --core=' + file[0] + ' ' + args.binary_path + ' --eval-command="thread apply all bt" -batch > ' + os.path.join(args.batch, os.path.basename(file[0]))
                )
            if args.apply:
                os.remove(file[0])
        else:
            break
