#pragma once

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

enum class ESessionState : ui32 {
    NoRides = 0,
    NoReservation,
    Reservation,
    Acceptance,
    Riding,
    Parking,
    Undefined,
};

namespace NDrive::NTest {
    class TCurrentSessionSchemes {
    public:
        TCurrentSessionSchemes();
        static const NDrive::TScheme& GetScheme(ESessionState state);

    private:
        static NDrive::TScheme BuildScheme(ESessionState state);

        TVector<NDrive::TScheme> Schemes;
    };
}
