--!syntax_v1
CREATE TABLE compiled_rides (
    history_event_id Int64,
    history_user_id String,
    history_originator_id String,
    history_action String,
    history_timestamp Int32,
    history_comment String,
    session_id String,
    object_id String,
    price Int32,
    duration Int32,
    start Int32,
    finish Int32,
    meta JsonDocument,
    meta_proto String,
    hard_proto String,
    PRIMARY KEY (history_event_id),
    INDEX compiled_rides_history_user_id_index GLOBAL ON (history_user_id, history_timestamp),
    INDEX compiled_rides_session_id_index GLOBAL ON (session_id),
    INDEX compiled_rides_object_id_index GLOBAL ON (object_id, history_timestamp),
    INDEX compiled_rides_history_timestamp_index GLOBAL ON (history_timestamp),
    FAMILY default (
    COMPRESSION = "lz4"
    )
);

/* Напоминалка чтобы не забыть: в YDB таблицах не поддерживаются столбцы 
вида my_column IS NOT NULL. Данная проверка должна быть на стороне бекенда. */
