--!syntax_v1

--DROP TABLE trace_tags;
CREATE TABLE trace_tags (
    tag_id String,
    object_id String,
    tag String,
    data String,
    performer String,
    priority Int32,
    snapshot String,
    owner String,
    PRIMARY KEY (tag_id),
    FAMILY default (
    COMPRESSION = "lz4"
    )
);

ALTER TABLE `trace_tags` ADD INDEX `trace_tags_object_id_index` GLOBAL ON (`object_id`);

--DROP TABLE trace_tags_history;
CREATE TABLE trace_tags_history (
    history_event_id Int64,
    history_user_id String,
    history_action String,
    history_timestamp Int64,
    history_comment String,
    tag_id String,
    object_id String,
    tag String,
    data String,
    performer String,
    priority Int32,
    snapshot String,
    history_originator_id String,
    owner String,
    PRIMARY KEY (history_event_id),
    FAMILY default (
    COMPRESSION = "lz4"
    )
);
