param([array]$bl)

$AllConfigs = @(
    "AUDI_A3_2018_BUILD",
    "AUDI_A3_2018_HW2_BUILD",
    "AUDI_A6_2018_BUILD",
    "AUDI_A6_2018_HW2_BUILD",
    "AUDI_Q3_2018_BUILD",
    "AUDI_Q3_2018_HW2_BUILD",
    "BMW_520I_2018_BUILD",
    "BMW_520I_2018_HW2_BUILD",
    "BMW_X1_2019_HW2_BUILD",
    "CITROEN_JUMPY_2018_BUILD",
    "CITROEN_JUMPY_2018_HW2_BUILD",
    "FORD_MUSTANG_1965_BUILD",
    "FORD_MUSTANG_1969_BUILD",
    "FORD_TRANSIT_2017_BUILD",
    "FORD_TRANSIT_2017_HW2_BUILD",
    "GENESIS_2017_BUILD",
    "GENESIS_2017_HW2_BUILD",
    "HYUNDAI_CRETA_2019_BUILD",
    "HYUNDAI_CRETA_2019_HW2_BUILD",
    "JEEP_WRANGLER_2018_BUILD",
    "JEEP_WRANGLER_2018_HW2_BUILD",
    "KAPTUR_2016_BUILD",
    "KAPTUR_2016_HW2_BUILD",
    "LADA_LARGUS_2017_BUILD",
    "MB_E200_2018_BUILD",
    "MB_E200_2018_HW2_BUILD",
    "NISSAN_LEAF_2019_HW2_BUILD",
    "NISSAN_QASHQAI_2018_BUILD",
    "NISSAN_QASHQAI_2018_HW2_BUILD",
    "PORSCHE_911_2018_BUILD",
    "PORSCHE_911_2018_HW2_BUILD",
    "PORSCHE_MACAN_2018_BUILD",
    "PORSCHE_MACAN_2018_HW2_BUILD",
    "PORSCHE_PANAMERA_2019_HW2_BUILD",
    "RANGE_ROVER_VELAR_2018_BUILD",
    "RANGE_ROVER_VELAR_2018_HW2_BUILD",
    "RENAULT_DOKKER_2018_BUILD",
    "RENAULT_LOGAN_2013_BUILD",
    "RENAULT_LOGAN_2013_HW2_BUILD",
    "RENAULT_LOGAN_2018_TAXI_BUILD",
    "RENAULT_LOGAN_2018_TAXI_HW2_BUILD",
    "RIO_2017_BUILD",
    "RIO_2017_HW2_BUILD",
    "SKODA_OCTAVIA_2018_BUILD",
    "SKODA_OCTAVIA_2018_HW2_BUILD",
    "SKODA_RAPID_2013_BUILD",
    "SKODA_RAPID_2013_HW2_BUILD",
    "SKODA_RAPID_2018_BUILD",
    "SKODA_RAPID_2018_HW2_BUILD",
    "TOYOTA_RAV4_2019_HW2_BUILD",
    "VOLVO_XC40_2018_HW2_BUILD",
    "VOLVO_XC60_2018_HW2_BUILD",
    "VW_CADDY_2018_BUILD",
    "VW_CADDY_2018_HW2_BUILD",
    "VW_POLO_2018_BUILD",
    "VW_POLO_2018_HW2_BUILD",
    "VW_TRANSPORTER_2018_HW2_BUILD"
    "RENAULT_DUSTER_2021_BUILD"
    "RENAULT_DUSTER_2021_HW2_BUILD"
    "VW_POLO_2018_HW3_BUILD"
    "SKODA_RAPID_2018_HW3_BUILD"
    "MB_E200_2018_HW3_BUILD"
    "RENAULT_DUSTER_2021_HW3_BUILD"
    "NISSAN_QASHQAI_2018_HW3_BUILD"
    "RENAULT_ARKANA_2018_BUILD"
    "RENAULT_ARKANA_2018_HW2_BUILD"
    "RENAULT_ARKANA_2018_HW3_BUILD"
    "RENAULT_LOGAN_2013_HW3_BUILD"
    "LADA_LARGUS_2020_FLEET_HW3_BUILD"
)

$BuildConfigs = @()

if($bl.Count -eq 0) {
    $BuildConfigs = $AllConfigs
} else {
    foreach($item in $bl) {
        if ($AllConfigs.Contains($item)) {
            $BuildConfigs += $item
        }
    }
}

$ArcadiaRoot = "$PSScriptRoot/../.."
$BuildRoot = "$ArcadiaRoot/drive/vega/.build"

$ToolchainRoot = "C:\Program Files (x86)\IAR Systems\Embedded Workbench 8.4"
$ToolchainRevision = "850"
$ToolchainManualPostBuild = $true

$RevisionHeader = "$ArcadiaRoot/drive/vega/projects/lib/build_info/revision.h"

$SvnRevision = arc info
arc checkout $RevisionHeader

foreach ($line in $SvnRevision) {
    $line = $line.Trim()
    if($line.StartsWith("revision: ")) {
        $line = $line.Replace("revision: ", "")
        $SvnRevision = $line
        break
    } elseif ($line.StartsWith("hash: ")) {
        $line = $line.Replace("hash: ", "")
        $SvnRevision = $line.Substring(0, 7)
    }
}

"Revision: " + $SvnRevision

(Get-Content $RevisionHeader) `
    -replace 'VCSREV', $SvnRevision `
    -replace 'TC', $ToolchainRevision |
Out-File $RevisionHeader

mkdir $BuildRoot -Force

foreach($config in $BuildConfigs) {
    Write-Host $config
    Start-Process "$ToolchainRoot/common/bin/IarBuild.exe" `
        -ArgumentList "$ArcadiaRoot/drive/vega/projects/VEGA_MT-32K_LTE/IAR/VEGA_MT-32K_LTE_aplication.ewp","-build",$config,"-parallel","8" `
        -Wait `
        -RedirectStandardError "$BuildRoot/$config.err" `
        -RedirectStandardOutput "$BuildRoot/$config.out" `
        -NoNewWindow

    if ($ToolchainManualPostBuild) {
        & "$ArcadiaRoot/drive/vega/utils/mt32k_vbf_creation/encrypt_and_sign.ps1" "$ArcadiaRoot/drive/vega/projects/VEGA_MT-32K_LTE/IAR/Application/$config/Exe"
    }
}

arc checkout $RevisionHeader
