/**
  ******************************************************************************
  * @file    sf_filter_shock.
  * @author  Solovyev A.F.
  * @date    07-12-2012
  * @brief   
  *******************************************************************************
 @verbatim
*/


/* Includes ------------------------------------------------------------------*/ 
#include "Accel/Accel_sense/Accel_filtr.h"

/* Defines -------------------------------------------------------------------*/

/* Exported types ------------------------------------------------------------*/


//==============================================================================
//        
//  : in_point -   3 
//                 out_point -   3 
//                 in_fc -  
//                 in_buf -     
//                 in_buf_size -   
//  : in_fc->ready -    
//                 out_point -  ,   
bool Accel_math_ma(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t in_buf_size) //   ,   
{
   
   in_buf[in_fc->cur_idx] = in_point;     //    
   in_fc->cur_sum.X += in_point.X;          //  
   in_fc->cur_sum.Y += in_point.Y;          //  
   in_fc->cur_sum.Z += in_point.Z;          //  
   
   in_fc->cur_idx++;                     //  
   if(in_fc->cur_idx >= in_buf_size)
     {
       in_fc->cur_idx = 0;
       in_fc->ready = true;
     }

   if(in_fc->ready == true)
   {
     out_point->X = in_fc->cur_sum.X/in_buf_size;  //     X
     out_point->Y = in_fc->cur_sum.Y/in_buf_size;  //     Y
     out_point->Z = in_fc->cur_sum.Z/in_buf_size;  //     Z   
     in_fc->cur_sum.X = in_fc->cur_sum.X - in_buf[in_fc->cur_idx].X;
     in_fc->cur_sum.Y = in_fc->cur_sum.Y - in_buf[in_fc->cur_idx].Y;
     in_fc->cur_sum.Z = in_fc->cur_sum.Z - in_buf[in_fc->cur_idx].Z;
   }
   return(in_fc->ready);
}




//==============================================================================
//  
bool Accel_math_swing(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_SWING_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t  in_buf_size) 
{
  uint8_t i;
  ACCEL_POINT_16BIT max;
  ACCEL_POINT_16BIT min; 
  
  in_buf[in_fc->cur_idx] = in_point;     //    
   
  in_fc->cur_idx++;                     //  
  if(in_fc->cur_idx >= in_buf_size)
  {
    in_fc->cur_idx = 0;
    in_fc->ready = true;
  }

   if(in_fc->ready == true)
   {
     max.X = in_buf[0].X;
     min.X = in_buf[0].X;
     max.Y = in_buf[0].Y;
     min.Y = in_buf[0].Y;
     max.Z = in_buf[0].Z;
     min.Z = in_buf[0].Z;
     
     for(i=1;i<in_buf_size;i++) //      
     {
       if(in_buf[i].X>max.X)
       {max.X = in_buf[i].X;}
       if(in_buf[i].X<min.X)
       {min.X = in_buf[i].X;}  
   
       if(in_buf[i].Y>max.Y)
       {max.Y = in_buf[i].Y;}
       if(in_buf[i].Y<min.Y)
       {min.Y = in_buf[i].Y;} 
 
       if(in_buf[i].Z>max.Z)
       {max.Z = in_buf[i].Z;}
       if(in_buf[i].Z<min.Z)
       {min.Z = in_buf[i].Z;}         
     }
     
     out_point->X = max.X - min.X;
     out_point->Y = max.Y - min.Y;
     out_point->Z = max.Z - min.Z;
       
   }
   return(in_fc->ready);
}



//==============================================================================
//    
void Accel_swing_reset(ACCEL_POINT_SWING_CTRL* in_fc)
{
  in_fc->cur_idx = 0;
  in_fc->ready = false;
}


//==============================================================================
//     
bool Accel_math_power(ACCEL_POINT_16BIT in_point, uint32_t *_max_value, ACCEL_POINT_CTRL* in_fc, uint16_t  in_buf_size)
{
  // in_fc->cur_sum          
  // uint32_t complex_sum = 0x00000000;
  // complex_sum = in_point.X + in_point.Y + in_point.Z;
  
  if(in_point.X > in_fc->cur_sum.X)
  {
    in_fc->cur_sum.X = in_point.X;
  }
  if(in_point.Y > in_fc->cur_sum.Y)
  {
    in_fc->cur_sum.Y = in_point.Y;
  }
  if(in_point.Z > in_fc->cur_sum.Z)
  {
    in_fc->cur_sum.Z = in_point.Z;
  }

  //   ,         
  if(in_fc->cur_idx >= in_buf_size)
  {
    // in_fc->cur_idx = 0;
    in_fc->ready = true;                              
    *_max_value = (in_fc->cur_sum.X + in_fc->cur_sum.Y + in_fc->cur_sum.Z);
  }
  else
  {
    in_fc->cur_idx++;  
  }
  
  return(in_fc->ready);
}



     
//==============================================================================
//  
void Accel_math_reset(ACCEL_POINT_CTRL* in_fc)
{
  in_fc->cur_idx = 0;
  in_fc->cur_sum.X = 0;
  in_fc->cur_sum.Y = 0;
  in_fc->cur_sum.Z = 0;
  in_fc->ready = false;
}
     
     
//------------------------------------------------------------------------------
//  -       
//  : 12-     ( 4   )
void Accel_ConvertTwoComplement(ACCEL_POINT_16BIT* _smp_in)
{
  if((_smp_in->X&0x8000) == 0x8000) 
    {_smp_in->X = _smp_in->X & 0x7FFF;}
  else{_smp_in->X = _smp_in->X | 0x8000;}
  _smp_in->X = _smp_in->X>>4;
  
  if((_smp_in->Y&0x8000) == 0x8000) 
    {_smp_in->Y = _smp_in->Y & 0x7FFF;}
  else{_smp_in->Y = _smp_in->Y | 0x8000;}
  _smp_in->Y = _smp_in->Y>>4; 

  if((_smp_in->Z&0x8000) == 0x8000) 
    {_smp_in->Z = _smp_in->Z & 0x7FFF;}
  else{_smp_in->Z = _smp_in->Z | 0x8000;}
  _smp_in->Z = _smp_in->Z>>4;  
}
   
     

