/*
** ============================================================================
** FILE			sf_sense_moving.c
** DESCRIPTION		Contains all subroutine for LIS3DH chip
**
** TERGET		STM32L151
** CREATED		Solovyev A.F. Vega-Absolute Ltd.
** DATA			14.12.2012
** ============================================================================
*/

/* Includes ------------------------------------------------------------------*/
#include <stdbool.h>

#include "Accel_sensors_config.h"
#include "Accel\Accel_sense\Accel_move.h"
#include "Accel\Accel_sense\Accel_filtr.h"

/* Private variables ---------------------------------------------------------*/
//          LIS331DLH
//      LIS3DH
// MS_MAX_STEP_DLT = 6
// MovingThreshold[1] = 230 //  
// MovingThreshold[15] = 80 //  
//  LIS331DLH  ,       
//  .    .    
//  ,       , -.

/* Defines -------------------------------------------------------------------*/
#define MS_BUF_SIZE_SMPL                100 //120       // 100  // ~200 ms
#define MS_BUF_SIZE_MA1                  80//100        // 80   // ~200 ms
#define MS_BUF_SIZE_MA2                  80 // 80       //80   // ~200 ms
//#define MS_BUF_SIZE_MA3                80 // 80       // ~200 ms
#define MS_PERIOD_GET_SAMPLES            4        // 10 ms -     
//#define MS_BUF_DELTA_SIZE                80       //         10 ms
#define MS_BUF_SIZE_DLT                  40       //   

#define MS_DELAY_CHECK_THRESHOLD    	80 // 2080 dots // 5200 ms
#define MS_DELAY_TO_READY_BUF     	10

//ACCEL_MOVE_DELAY_TO_STOP
//#define MS_DELAY_TO_STOP		5*400 // 20*400 = 20s * 400kHz

//#define THRESHOLD_MIN                    72

//-      LIS331DLH, LIS3DH
// =0 - , [1] -   - [15] -  
#ifdef ACCEL_MEMS_TYPE_LIS331DLH  //(ACCEL_LIS_MEMS == LIS331DLH)
 #define MS_MAX_STEP_DLT                  5        //   
 //#define THRESHOLD_MAX                    ((MS_BUF_SIZE_DLT * MS_MAX_STEP_DLT)-8) // 40*5=200-8=192
 const uint16_t MovingThreshold[16] = {  0, 190, 175, 165, 157, 149, 141, 133,
   				       125, 117, 109, 101,  94,  87,  81,  75,};
#elif defined(ACCEL_MEMS_TYPE_LIS3DH)  //(ACCEL_LIS_MEMS == LIS3DH)
 #define MS_MAX_STEP_DLT                  6 //3//6        //   
 //#define THRESHOLD_MAX                    ((MS_BUF_SIZE_DLT * MS_MAX_STEP_DLT)-8) // 40*6=240-8=132
// const uint16_t MovingThreshold[16] = {  0, 240, 220, 205, 191, 178, 168, 158,
//  				       148, 138, 128, 118, 108,  98,  89,  80,};
 const uint16_t MovingThreshold[16] = {  0, 240, 220, 205, 191, 178, 168, 158,
  				       148, 138, 128, 118, 108,  98,  80,  80,};   // 98, 89, 80 // 20-40-80  idx=14
  	// 20-40       60 -    , 80 -  
#else
 //#define MS_MAX_STEP_DLT                  5        //   
 //#define THRESHOLD_MAX                    ((MS_BUF_SIZE_DLT * MS_MAX_STEP_DLT)-8) // 40*5=200-8=192
 //const uint16_t MovingThreshold[16] = {0,0,0,0,  0,0,0,0,  0,0,0,0,  0,0,0,0 };
#endif


/* Global variables ----------------------------------------------------------*/
static uint8_t AccelMoveSenseLevel = 14; 	//    -
static uint8_t AccelMoveState = 0;		//  

extern ACCEL_POINT_16BIT AcceluSmpl; //  uint16 

/* Private variables ---------------------------------------------------------*/
 typedef enum {RESET=0, SET=1} FlagStatus;
 typedef struct {
  FlagStatus climb; 	//   
  FlagStatus ready; 	//         
  uint8_t count; 	//  ,    
  uint16_t sum; 	//  ,      
  uint16_t previous; 	//  
  uint16_t delta; 	//     ,         
} GROWTH_CTRL;
GROWTH_CTRL GrowthCtrlX;
GROWTH_CTRL GrowthCtrlY;
GROWTH_CTRL GrowthCtrlZ;

//-  
uint16_t DELTA_BUF_X[MS_BUF_SIZE_DLT];
uint16_t DELTA_BUF_Y[MS_BUF_SIZE_DLT];
uint16_t DELTA_BUF_Z[MS_BUF_SIZE_DLT];

//-  
ACCEL_POINT_16BIT MS_BufSmpl[MS_BUF_SIZE_SMPL]; //   
ACCEL_POINT_CTRL MS_CtrlSmpl; //    
//-   1
ACCEL_POINT_16BIT MS_ItemMa1;
ACCEL_POINT_16BIT MS_BufMa1[MS_BUF_SIZE_MA1];
ACCEL_POINT_CTRL MS_CtrlMa1;
//-   2
ACCEL_POINT_16BIT MS_ItemMa2;
ACCEL_POINT_16BIT MS_BufMa2[MS_BUF_SIZE_MA2];
ACCEL_POINT_CTRL MS_CtrlMa2;
//-   3
ACCEL_POINT_16BIT MS_ItemMa3;
//ACCEL_POINT_16BIT MS_BufMa3[MS_BUF_SIZE_MA3];
//ACCEL_POINT_CTRL MS_CtrlMa3;
//-   4
//ACCEL_POINT_16BIT MS_ItemMa4;

ACCEL_POINT_16BIT MS_Q[2]; //    
//ACCEL_POINT_1BIT S_FLUX_DIRECTION_UP; //  -   
//ACCEL_POINT_1BIT S_BUF_FULL; //  -  
//ACCEL_POINT_16BIT MS_CurrentSum; //    
//ACCEL_POINT_8BIT MS_FluxCount; //      
//ACCEL_POINT_8BIT MS_BufDelta[MS_BUF_DELTA_SIZE]; //  
//ACCEL_POINT_16BIT MS_IntervalSwing; //     

static uint8_t Count_MsSamples = 0x00; //   
static uint16_t Count_MsDelayLoadSamples = 0x0000; //    
static uint8_t MS_StartCount = 0x00;
static uint32_t Count_MsDelayCheckStop = 0; // DEF_ACCEL_MOVE_DELAY_TO_STOP;
static uint32_t AccelMoveDelayToStop =  DEF_ACCEL_MOVE_DELAY_TO_STOP;

/* Function prototypes -------------------------------------------------------*/
void MovingSensor_Service(void);
void MovingSensor_Reset(void);
bool MovingSensor_CheckThreshold(void);
//void search_direction(void);
void growth_calc(uint16_t prev, uint16_t cur, GROWTH_CTRL* _growth_ctrl, uint16_t* in_buf, uint8_t in_buf_size, uint8_t in_max_delta_step);
void growth_reset(GROWTH_CTRL* _growth_ctrl);

/* Functions -----------------------------------------------------------------*/
//- Init
void AccelMove_Init(void)
{
  AccelMoveState=0;
  MovingSensor_Reset();
}

void SetAccelMoveDelayToStop(uint16_t seconds)
{
  AccelMoveDelayToStop=seconds*ACCEL_FRAME_RATE_kHZ;
}

uint16_t GetAccelMoveDelayToStop(void)
{
  return AccelMoveDelayToStop/ACCEL_FRAME_RATE_kHZ;
}


//-    
void AccelMove_Do(void)
{
 // Check enable if necessary here
 // Check to stop
  if(Count_MsDelayCheckStop>0)  {Count_MsDelayCheckStop--;}
  else AccelMoveState=0;
  
 //   
  if(Count_MsDelayLoadSamples>0)    {
      Count_MsDelayLoadSamples--;
  }
  else {
     //  
      if(Accel_math_ma(AcceluSmpl, &MS_ItemMa1, &MS_CtrlSmpl, MS_BufSmpl, MS_BUF_SIZE_SMPL) == true)
      {
        if(Accel_math_ma(MS_ItemMa1, &MS_ItemMa2, &MS_CtrlMa1, MS_BufMa1, MS_BUF_SIZE_MA1) == true)
        {
          if(Accel_math_ma(MS_ItemMa2, &MS_ItemMa3, &MS_CtrlMa2, MS_BufMa2, MS_BUF_SIZE_MA2) == true)
          {
// if(Accel_math_ma(MS_ItemMa3, &MS_ItemMa4, &MS_CtrlMa3, MS_BufMa3, MS_BUF_SIZE_MA3) == true)
//{
           //    10ms
            Count_MsSamples++;
            if(Count_MsSamples >= MS_PERIOD_GET_SAMPLES)    // 10ms
            {
              Count_MsSamples = 0x00;
              MS_Q[0] = MS_Q[1];
              MS_Q[1] = MS_ItemMa3; // MS_ItemMa3,4
              if(MS_StartCount == 0x00)
              {
                if(MovingSensor_CheckThreshold() == true)
                {
		  AccelMoveState=1;
		  Count_MsDelayCheckStop = AccelMoveDelayToStop; 
                  MovingSensor_Reset();

                }
              }
              else  {  MS_StartCount--; }  //   
            }
          }//math_ma
        }//math_ma
      }//math_ma
//}
  }//else
}


//-     
bool MovingSensor_CheckThreshold(void)
{
  growth_calc(MS_Q[0].X, MS_Q[1].X, &GrowthCtrlX, DELTA_BUF_X, MS_BUF_SIZE_DLT, MS_MAX_STEP_DLT);
  growth_calc(MS_Q[0].Y, MS_Q[1].Y, &GrowthCtrlY, DELTA_BUF_Y, MS_BUF_SIZE_DLT, MS_MAX_STEP_DLT);
  growth_calc(MS_Q[0].Z, MS_Q[1].Z, &GrowthCtrlZ, DELTA_BUF_Z, MS_BUF_SIZE_DLT, MS_MAX_STEP_DLT);

 uint16_t  threshold = MovingThreshold[AccelMoveSenseLevel];
  if(GrowthCtrlX.sum >= threshold) {return(true);}
  if(GrowthCtrlY.sum >= threshold) {return(true);}
  if(GrowthCtrlZ.sum >= threshold) {return(true);}
  return(false);
}


//-     
void MovingSensor_Reset(void)
{
  Accel_math_reset(&MS_CtrlSmpl);
  Accel_math_reset(&MS_CtrlMa1);
  Accel_math_reset(&MS_CtrlMa2);
  growth_reset(&GrowthCtrlX);
  growth_reset(&GrowthCtrlY);
  growth_reset(&GrowthCtrlZ);
  Count_MsSamples = 0x00;
  Count_MsDelayLoadSamples = MS_DELAY_CHECK_THRESHOLD;
  MS_StartCount = MS_DELAY_TO_READY_BUF; //      
}


//-    
void MovingSensor_ChangeSenseLevel(uint8_t _level)
{
  if(_level < 16)
  {
    AccelMoveSenseLevel = _level;  //    
    MovingSensor_Reset();  //    
  }
}

//-    
uint8_t MovingSensor_GetSenseLevel(void)
{
  return AccelMoveSenseLevel;
}

//-    
uint8_t MovingSensor_GetState(void)
{
  return AccelMoveState;
}

//==============================================================================
//   
//  :      prev -    
//                      cur -    
//                      _growth_ctrl -   
//                      in_buf[] -  , ..           
//                      in_buf_size -   
//                      in_max_delta_step -   ,      
void growth_calc(uint16_t prev, uint16_t cur, GROWTH_CTRL* _growth_ctrl, uint16_t* in_buf, uint8_t in_buf_size, uint8_t in_max_delta_step)
{
  //  
  if(_growth_ctrl->climb == SET) //  
  {
    if(prev > cur)
    {
      _growth_ctrl->climb = RESET;
      _growth_ctrl->delta = prev - cur;
      growth_reset(_growth_ctrl);
    }
    else // cur >= prev
    {
      _growth_ctrl->delta = cur - prev;
    }
  }
  else // climp == RESET //  
  {
    if(prev < cur)
    {
      _growth_ctrl->climb = SET;
      _growth_ctrl->delta = cur - prev;
      growth_reset(_growth_ctrl);
    }
    else // cur >= prev
    {
      _growth_ctrl->delta = prev-cur;
    }
  }

  //   
  if(_growth_ctrl->delta >= in_max_delta_step)
  {
    _growth_ctrl->delta = in_max_delta_step;
  }

  //   
  in_buf[_growth_ctrl->count] = _growth_ctrl->delta;      //      
  _growth_ctrl->sum = _growth_ctrl->sum + _growth_ctrl->delta - _growth_ctrl->previous; //   
  _growth_ctrl->count++;
  if(_growth_ctrl->count >= in_buf_size)
  {
    _growth_ctrl->count = 0;
    _growth_ctrl->ready = SET;
  }
  if(_growth_ctrl->ready == SET)
  {
    _growth_ctrl->previous = in_buf[_growth_ctrl->count];
  }
}


//- C    
void growth_reset(GROWTH_CTRL* _growth_ctrl)
{
  _growth_ctrl->delta = 0;

  _growth_ctrl->ready = RESET;
  _growth_ctrl->previous = 0;
  _growth_ctrl->count = 0;
  _growth_ctrl->sum = 0;
}

