/**
  ******************************************************************************
  * @file           : Accel_sensors.h
  * @brief          : Header for Accelerometer.
  ******************************************************************************
  * COPYRIGHT(c) 2016
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __ACCEL_SENSORS_H
#define __ACCEL_SENSORS_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/   
#include <stdint.h>
#include "Accel\Accel_sense\Accel_move.h"
   
/* Exported types ------------------------------------------------------------*/  
//- 
typedef struct {
  int16_t AXIS_X;
  int16_t AXIS_Y;
  int16_t AXIS_Z;
} AxesRaw_t;
   
typedef uint8_t AccelSensorState_t;

/* Defines -------------------------------------------------------------------*/
/* Global variables-----------------------------------------------------------*/
extern AxesRaw_t AccelAxes_Curr;
extern AxesRaw_t AccelRaw;
extern AccelSensorState_t AccelSensor_MoveState, AccelSensor_TiltState; 

/* Exported function prototypes -----------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

uint8_t AccelSensors_Init(uint8_t is_sleep_mode);
void AccelSensors_DeInit(void);
void AccelSensors_d(void);
uint8_t AccelSensors_Check(void);


#ifdef __cplusplus
}
#endif

#endif // __ACCEL_SENSORS_H

