/**
******************************************************************************
* File Name          : lis2hh12_registers.h
* Description        :
*
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LIS2HH12_REGISTERS_H
#define __LIS2HH12_REGISTERS_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/

/* Exported constants --------------------------------------------------------*/

//Register Definition
#define LIS2HH12_WHO_AM_I                    (0x0F)
#define LIS2HH12_WHO_AM_I_ID                 (0x41)

#define LIS2HH12_CTRL1                       (0x20)
#define LIS2HH12_CTRL1_HR                    (1<<7)
#define LIS2HH12_CTRL1_ODR2                  (1<<6)
#define LIS2HH12_CTRL1_ODR1                  (1<<5)
#define LIS2HH12_CTRL1_ODR0                  (1<<4)
#define LIS2HH12_CTRL1_BDU                   (1<<3)
#define LIS2HH12_CTRL1_ZEN                   (1<<2)
#define LIS2HH12_CTRL1_YEN                   (1<<1)
#define LIS2HH12_CTRL1_XEN                   (1<<0)

#define LIS2HH12_CTRL1_ODR_10_HZ             (LIS2HH12_CTRL1_ODR0)
#define LIS2HH12_CTRL1_ODR_50_HZ             (LIS2HH12_CTRL1_ODR1)
#define LIS2HH12_CTRL1_ODR_100_HZ            (LIS2HH12_CTRL1_ODR1 | LIS2HH12_CTRL1_ODR0)
#define LIS2HH12_CTRL1_ODR_200_HZ            (LIS2HH12_CTRL1_ODR2)
#define LIS2HH12_CTRL1_ODR_400_HZ            (LIS2HH12_CTRL1_ODR2 | LIS2HH12_CTRL1_ODR0)
#define LIS2HH12_CTRL1_ODR_800_HZ            (LIS2HH12_CTRL1_ODR2 | LIS2HH12_CTRL1_ODR1)

#define LIS2HH12_CTRL2                       (0x21)
#define LIS2HH12_CTRL2_HPIS2                 (1<<1)
#define LIS2HH12_CTRL2_HPIS1                 (1<<0)

#define LIS2HH12_CTRL3                       (0x22)
#define LIS2HH12_CTRL3_INT1_IG1              (1<<3) //INT1_IG1 Interrupt generator 1 on INT1.

#define LIS2HH12_CTRL4                       (0x23)
#define LIS2HH12_CTRL5                       (0x24)
#define LIS2HH12_CTRL5_SOFT_RESET            (1<<6)
#define LIS2HH12_CTRL6                       (0x25)

#define LIS2HH12_CTRL7                       (0x26)
#define LIS2HH12_CTRL7_DCRM2                 (1<<5)
#define LIS2HH12_CTRL7_DCRM1                 (1<<4)

#define LIS2HH12_IG_CFG1                     (0x30) //Interrupt generator 1
#define LIS2HH12_IG_CFG1_AOI                 (1<<7)
#define LIS2HH12_IG_CFG1_DETEC_6D            (1<<6)
#define LIS2HH12_IG_CFG1_ZHIE                (1<<5)
#define LIS2HH12_IG_CFG1_ZLIE                (1<<4)
#define LIS2HH12_IG_CFG1_YHIE                (1<<3)
#define LIS2HH12_IG_CFG1_YLIE                (1<<2)
#define LIS2HH12_IG_CFG1_XHIE                (1<<1)
#define LIS2HH12_IG_CFG1_XLIE                (1<<0)

#define LIS2HH12_OUT_X_L                     (0x28)
#define LIS2HH12_OUT_X_H                     (0x29)
#define LIS2HH12_OUT_Y_L                     (0x2A)
#define LIS2HH12_OUT_Y_H                     (0x2B)
#define LIS2HH12_OUT_Z_L                     (0x2C)
#define LIS2HH12_OUT_Z_H                     (0x2D)

#define LIS2HH12_IG_THS_X1                   (0x32)// Interrupt generator 1 threshold registers
#define LIS2HH12_IG_THS_Y1                   (0x33)// Interrupt generator 1 threshold registers
#define LIS2HH12_IG_THS_Z1                   (0x34)// Interrupt generator 1 threshold registers

#define LIS2HH12_IG_DUR1                     (0x35)

#define LIS2HH12_XL_REFERENCE                (0x3A)
#define LIS2HH12_XH_REFERENCE                (0x3B)
#define LIS2HH12_YL_REFERENCE                (0x3C)
#define LIS2HH12_YH_REFERENCE                (0x3D)
#define LIS2HH12_ZL_REFERENCE                (0x3E)
#define LIS2HH12_ZH_REFERENCE                (0x3F)

/* Exported macro ------------------------------------------------------------*/
//DURATION_TIME_mS время воздействия для наступления прерывания
#define LIS2HH12_DURATION_REG_VAL(DURATION_TIME_mS, ODR_FREQ)  ((DURATION_TIME_mS*ODR_FREQ)/1000)
#define LIS2HH12_ACCEL_TH_DEFAULT_VAL(mG_TH_DEFAULT, FS_MG)    ((mG_TH_DEFAULT*(255))/FS_MG)

/* Exported functions --------------------------------------------------------*/

#endif // __LIS2HH12_REGISTERS_H
