/**
  ******************************************************************************
  * File Name          : MX25L6435E.c
  * Description        : ���������� ��� ������ � ����������� ������ Macronix MX25L6435E
  *     
  *                      
  ******************************************************************************
*/

#include "MX25L6435E/MX25L6435E.h"
#include <string.h>

//#define GET_MEMORY_DUMP
#if defined(GET_MEMORY_DUMP)
#warning
#include "debug_port.h"
#endif

/* Global variables-----------------------------------------------------------*/

/* C++ code-------------------------------------------------------------------*/
CMX25L64::CMX25L64(CS_High_t CS_High, CS_Low_t CS_Low, Send_data_t Send_data, Send_byte_t Send_byte, Get_data_t Get_data, Get_byte_t Get_byte, SPI_init_t SPI_init, SPI_deinit_t SPI_deinit)
{
  this->SPI_init = SPI_init;
  this->SPI_deinit = SPI_deinit;
  this->CS_High = CS_High;
  this->CS_Low = CS_Low;
  this->Send_data = Send_data;
  this->Send_byte = Send_byte;
  this->Get_data = Get_data;
  this->Get_byte = Get_byte;
  this->ID = 0;
}

// �������������
uint8_t CMX25L64::Init(void)
{
  uint8_t status_reg;
  SE_max_time = 0;
  // ������������� SPI
  SPI_init();
  // �������� ������ ����������
  MX25L64_DELAY_MS(tPUW);
  
  // ���� �� �������� ������� ������� 0xff, �� �������� ������ ���������� � ������, ��������� ���������� �...
  CMD_RDSR(&status_reg);
  if(status_reg==0xFF)
  {
    CMD_RSTEN();
    MX25L64_DELAY_MS(1);
    CMD_RST();
    MX25L64_DELAY_MS(2);
  }
  CMD_RDSR(&status_reg);
  status_reg++;

  // ������ �������������� ����������, ���� ��������, ������� ��� ������������� �������
  CMD_RDID(&this->ID);
  // ������ ������ ��������� ����������
  addr_4byte_mode = IsFlash4Byte();
  
  if(this->ID == SST25VF064C_ID) 
  {
    // ��� ���� SST ���������� ��������� ������� ����� ����� ������ �� ������
    CMD_WRSR(0);
  }
  else if(this->ID == IS25LP256D_ID)
  {
    // ���� ������ IS25LP256D, ���������� � � ����� 4� �������� ��������� 
    CMD_WRSR(0);
    CS_Low();
    Send_byte( 0xB7 );//ENTER 4-BYTE ADDRESS MODE OPERATION
    CS_High();
  }
  else if(this->ID == MX25L25645G_ID)
  {
    // ���� ������ MX25L25645G_ID, ���������� � � ����� 4� �������� ��������� 
    //CMD_WRSR(0);
    CS_Low();
    Send_byte( 0xB7 );////ENTER 4-BYTE ADDRESS MODE OPERATION
    CS_High();
  }
  
#if defined(GET_MEMORY_DUMP)
  static uint8_t buff[MX25L64_PAGE_SIZE];
  
  __PRINTF("memory dump\nchip id: 0x%08lX, memory size: %lu bytes\n", this->ID, FlashSize);
  for(uint32_t flash_address=0; flash_address<FlashSize; flash_address+=sizeof(buff))
  {
    CMD_READ(flash_address, buff, sizeof(buff));
    
    for(uint32_t i=0; i<sizeof(buff); i++)
    {
      __PRINTF("%c", buff[i]);
    }
  }
  for(;;);
#endif
  
  return 1;
}

// ���������������
void CMX25L64::Deinit(void)
{
  // ������� ���������� � ������ �����
  CMD_DP();
  // ��������������� SPI
  SPI_deinit();
}

// ������ ������
void CMX25L64::Write_data(uint16_t sector, uint16_t address, const uint8_t* data, uint16_t size)
{
  // ������ �� ������ � ������������ ������� (������ ����������� ������ � �������� ������ �������)
  if(address+size > MX25L64_SECTOR_SIZE) while(1);
  uint32_t flash_address = sector*MX25L64_SECTOR_SIZE+address;
  uint8_t addr_on_page = address%MX25L64_PAGE_SIZE;

  // ���� ������ ���������� �� ������� ��������, �� ������ ����������
  if(addr_on_page != 0)
  {
    uint8_t write_size = 0;
    if(size > (MX25L64_PAGE_SIZE - addr_on_page)) write_size = MX25L64_PAGE_SIZE - addr_on_page;
    else write_size = size;
    CMD_PP(flash_address, data, write_size);
    size -= write_size;
    data += write_size;
    flash_address += write_size;
  }  
  // ��������������� ������ ������ � ������ �����������
  while(size)
  {
    if(size > MX25L64_PAGE_SIZE)
    {
      CMD_PP(flash_address, data, MX25L64_PAGE_SIZE);
      size -= MX25L64_PAGE_SIZE;
      data += MX25L64_PAGE_SIZE;
      flash_address += MX25L64_PAGE_SIZE;
    }
    else
    {
      CMD_PP(flash_address, data, size);
      size -= size;
    }
  }
}

// ������ �����
void CMX25L64::Read_data(uint16_t sector, uint16_t address, uint8_t* data, uint16_t size)
{
  // ������ �� ������ � ������������ ������� ������� (������ ����������� ������ �� ������ �������)
  if(address+size > MX25L64_SECTOR_SIZE) while(1);
  uint32_t flash_address = sector*MX25L64_SECTOR_SIZE+address;
  CMD_READ(flash_address, data, size);
}

// ������� �������
void CMX25L64::Erase_sector(uint16_t sector)
{
  uint32_t flash_address = sector*MX25L64_SECTOR_SIZE;
  CMD_SE(flash_address);
}

// ������� ����
bool CMX25L64::Erase_chip(void)
{
  if(CMD_CE() == FlashOperationSuccess) {return true;}
  else                                  {return false;}
}

TickType_t CMX25L64::Get_SE_max_time()
{
  return SE_max_time;
}

// ������� �� �������� ������ �� macronix///////////////////////////////////////
/*
 * Function:       IsFlashBusy
 * Arguments:      None.
 * Description:    Check status register WIP bit.
 *                 If  WIP bit = 1: return true ( Busy )
 *                             = 0: return false ( Ready ).
 * Return Message: true, false
 */
bool CMX25L64::IsFlashBusy( void )
{
    uint8_t  gDataBuffer;
    CMD_RDSR( &gDataBuffer );
    if( (gDataBuffer & MX25L64_WIP_MASK)  == MX25L64_WIP_MASK )
        return true;
    else
        return false;
}

/*
 * Function:       WaitFlashReady
 * Arguments:      ExpectTime, expected time-out value of flash operations.
 *                 No use at non-synchronous IO mode.
 * Description:    Synchronous IO:
 *                 If flash is ready return true.
 *                 If flash is time-out return false.
 *                 Non-synchronous IO:
 *                 Always return true
 * Return Message: true, false
 */
bool CMX25L64::WaitFlashReady( uint32_t ExpectTime )
{
    uint32_t temp = 0;
    while( IsFlashBusy() )
    {
        if( temp > ExpectTime )
        {
            return false;
        }
        temp = temp + 1;
        MX25L64_DELAY_MS(1);
    }
       return true;
}

/*
 * Function:       IsFlash4Byte
 * Arguments:      None
 * Description:    Check flash address is 3-byte or 4-byte.
 *                 If flash 4BYTE bit = 1: return true
 *                                    = 0: return false.
 * Return Message: true, false
 */
bool CMX25L64::IsFlash4Byte( void )
{
  // ��������� ��������� 4� ��� 3� ��������
  if(this->ID == IS25LP256D_ID || this->ID == MX25L25645G_ID) return true;
  else                                                        return false;
/*
#ifdef MX25L64_CMD_RDSCUR
    #ifdef MX25L64_4BYTE_ONLY
        return true;
    #elif MX25L64_3BYTE_ONLY
        return false;
    #else
        uint8_t  gDataBuffer;
        CMD_RDSCUR( &gDataBuffer );
        if( (gDataBuffer & MX25L64_4BYTE_MASK) == MX25L64_4BYTE_MASK )
            return true;
        else
            return false;
    #endif
#else
    return false;
#endif
 */
}

/*
 * Function:       SendFlashAddr
 * Arguments:      flash_address, 32 bit flash memory address
 *                 io_mode, I/O mode to transfer address
 *                 addr_4byte_mode,
 * Description:    Send flash address with 3-byte or 4-byte mode.
 * Return Message: None
 */
void CMX25L64::SendFlashAddr( uint32_t flash_address, bool addr_4byte_mode )
{
    /* Check flash is 3-byte or 4-byte mode.
       4-byte mode: Send 4-byte address (A31-A0)
       3-byte mode: Send 3-byte address (A23-A0) */
    if( addr_4byte_mode == true )
    {
        Send_byte( (flash_address >> 24)); // A31-A24
    }
    /* A23-A0 */
    Send_byte( (flash_address >> 16));
    Send_byte( (flash_address >> 8));
    Send_byte( (flash_address));
}

/*
 * Function:       CMD_WRSR
 * Arguments:      UpdateValue, 8/16 bit status register value to updata
 * Description:    The WRSR instruction is for changing the values of
 *                 Status Register Bits (and configuration register)
 * Return Message: FlashIsBusy, FlashTimeOut, FlashOperationSuccess
 */
#ifdef SUPPORT_WRSR_CR
ReturnMsg CMX25L64::CMD_WRSR( uint16_t UpdateValue )
#else
ReturnMsg CMX25L64::CMD_WRSR( uint8_t UpdateValue )
#endif
{
    // Check flash is busy or not
    if( IsFlashBusy() )    return FlashIsBusy;

    // Setting Write Enable Latch bit
    CMD_WREN();

    // Chip select go low to start a flash command
    CS_Low();

    // Send command and update value
    Send_byte( MX25L64_CMD_WRSR );
    Send_byte( UpdateValue );
#ifdef SUPPORT_WRSR_CR
    Send_byte( UpdateValue >> 8);    // write configuration register
#endif

    // Chip select go high to end a flash command
    CS_High();
    
    if( WaitFlashReady( WriteStatusRegCycleTime ) )
      return FlashOperationSuccess;
    else
      return FlashTimeOut;
}


/*
 * Function:       CMD_RDID
 * Arguments:      Identification, 32 bit buffer to store id
 * Description:    The RDID instruction is to read the manufacturer ID
 *                 of 1-byte and followed by Device ID of 2-byte.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_RDID( uint32_t *Identification )
{
    uint32_t temp;
    uint8_t  gDataBuffer[3];
    // Chip select go low to start a flash command
    CS_Low();
    // Send command
    Send_byte( MX25L64_CMD_RDID );
    // Get manufacturer identification, device identification
    gDataBuffer[0] = Get_byte();
    gDataBuffer[1] = Get_byte();
    gDataBuffer[2] = Get_byte();
    // Chip select go high to end a command
    CS_High();
    // Store identification
    temp =  gDataBuffer[0];
    temp =  (temp << 8) | gDataBuffer[1];
    *Identification =  (temp << 8) | gDataBuffer[2];
        if( WaitFlashReady( PageProgramCycleTime ) )
        return FlashOperationSuccess;
    else
        return FlashTimeOut;
}

/*
 * Function:       CMD_RDSR
 * Arguments:      StatusReg, 8 bit buffer to store status register value
 * Description:    The RDSR instruction is for reading Status Register Bits.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_RDSR( uint8_t *StatusReg )
{
    uint8_t  gDataBuffer;
    // Chip select go low to start a flash command
    CS_Low();
    // Send command
    Send_byte( MX25L64_CMD_RDSR );
    gDataBuffer = Get_byte();
    // Chip select go high to end a flash command
    CS_High();
    *StatusReg = gDataBuffer;
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_RDSCUR
 * Arguments:      SecurityReg, 8 bit buffer to store security register value
 * Description:    The RDSCUR instruction is for reading the value of
 *                 Security Register bits.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_RDSCUR( uint8_t *SecurityReg )
{
    uint8_t  gDataBuffer;
    // Chip select go low to start a flash command
    CS_Low();
    //Send command
    //Send_byte( MX25L64_CMD_RDSCUR );
    gDataBuffer = Get_byte();
    // Chip select go high to end a flash command
    CS_High();
    *SecurityReg = gDataBuffer;
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_READ
 * Arguments:      flash_address, 32 bit flash memory address
 *                 target_address, buffer address to store returned data
 *                 byte_length, length of returned data in byte unit
 * Description:    The READ instruction is for reading data out.
 * Return Message: FlashAddressInvalid, FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_READ( uint32_t flash_address, uint8_t *target_address, uint32_t byte_length )
{
    // Chip select go low to start a flash command
    CS_Low();
    // Write READ command and address
    Send_byte( MX25L64_CMD_READ );
    SendFlashAddr( flash_address, addr_4byte_mode );
    // Set a loop to read data into buffer
    Get_data(target_address, byte_length);
    // Chip select go high to end a flash command
    CS_High();
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_WREN
 * Arguments:      None.
 * Description:    The WREN instruction is for setting
 *                 Write Enable Latch (WEL) bit.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_WREN( void )
{
    // Chip select go low to start a flash command
    CS_Low();
    // Write Enable command = 0x06, Setting Write Enable Latch Bit
    Send_byte( MX25L64_CMD_WREN );
    // Chip select go high to end a flash command
    CS_High();
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_PP
 * Arguments:      flash_address, 32 bit flash memory address
 *                 source_address, buffer address of source data to program
 *                 byte_length, byte length of data to programm
 * Description:    The PP instruction is for programming
 *                 the memory to be "0".
 *                 The device only accept the last 256 byte ( or 32 byte ) to program.
 *                 If the page address ( flash_address[7:0] ) reach 0xFF, it will
 *                 program next at 0x00 of the same page.
 *                 Some products have smaller page size ( 32 byte )
 * Return Message: FlashAddressInvalid, FlashIsBusy, FlashOperationSuccess,
 *                 FlashTimeOut
 */
ReturnMsg CMX25L64::CMD_PP( uint32_t flash_address, const uint8_t *source_address, uint32_t byte_length )
{
    // Setting Write Enable Latch bit
    CMD_WREN();
    // Chip select go low to start a flash command
    CS_Low();
    // Write Page Program command
    Send_byte( MX25L64_CMD_PP );
    SendFlashAddr( flash_address, addr_4byte_mode );
    // Set a loop to down load whole page data into flash's buffer
    // Note: only last 256 byte ( or 32 byte ) will be programmed
    Send_data(source_address, byte_length);
    // Chip select go high to end a flash command
    CS_High();
    if( WaitFlashReady( PageProgramCycleTime ) )
        return FlashOperationSuccess;
    else
        return FlashTimeOut;
}

/*
 * Function:       CMD_SE
 * Arguments:      flash_address, 32 bit flash memory address
 * Description:    The SE instruction is for erasing the data
 *                 of the chosen sector (4KB) to be "1".
 * Return Message: FlashAddressInvalid, FlashIsBusy, FlashOperationSuccess,
 *                 FlashTimeOut
 */
ReturnMsg CMX25L64::CMD_SE( uint32_t flash_address )
{
    uint8_t  addr_4byte_mode;
    // Check flash address
    if( flash_address > FlashSize ) return FlashAddressInvalid;
    // Check flash is busy or not
    if( IsFlashBusy() )    return FlashIsBusy;
    // Check 3-byte or 4-byte mode
    if( IsFlash4Byte() )
        addr_4byte_mode = true;  // 4-byte mode
    else
        addr_4byte_mode = false; // 3-byte mode
    // Setting Write Enable Latch bit
    CMD_WREN();
    // Chip select go low to start a flash command
    CS_Low();
    //Write Sector Erase command = 0x20;
    Send_byte( MX25L64_CMD_SE );
    SendFlashAddr( flash_address, addr_4byte_mode );
    // Chip select go high to end a flash command
    CS_High();
        
    TickType_t se_time = xTaskGetTickCount();
    if( WaitFlashReady( SectorEraseCycleTime ) )
    {
      se_time = xTaskGetTickCount() - se_time;
      if(se_time > SE_max_time)
        SE_max_time = se_time;
      return FlashOperationSuccess;
    }
    else
    {
      return FlashTimeOut;
    }
}

/*
 * Function:       CMD_CE
 * Arguments:      None.
 * Description:    The CE instruction is for erasing the data
 *                 of the whole chip to be "1".
 * Return Message: FlashIsBusy, FlashOperationSuccess, FlashTimeOut
 */
ReturnMsg CMX25L64::CMD_CE( void )
{
    // Check flash is busy or not
    if( IsFlashBusy() )    return FlashIsBusy;
    // Setting Write Enable Latch bit
    CMD_WREN();
    // Chip select go low to start a flash command
    CS_Low();
    //Write Chip Erase command = 0x60;
    Send_byte( MX25L64_CMD_CE );
    // Chip select go high to end a flash command
    CS_High();

    if( WaitFlashReady( ChipEraseCycleTime ) )
      return FlashOperationSuccess;
    else
      return FlashTimeOut;
}

/*
 * Function:       CMD_DP
 * Arguments:      None.
 * Description:    The DP instruction is for setting the
 *                 device on the minimizing the power consumption.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_DP( void )
{
    // Chip select go low to start a flash command
    CS_Low();
    // Deep Power Down Mode command
    Send_byte( MX25L64_CMD_DP );
    // Chip select go high to end a flash command
    CS_High();
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_RSTEN
 * Arguments:      None.
 * Description:    Enable RST command
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_RSTEN( void )
{
    // Chip select go low to start a flash command
    CS_Low();
    // Write RSTEN command
    Send_byte( MX25L64_CMD_RSTEN );
    // Chip select go high to end a flash command
    CS_High();
    return FlashOperationSuccess;
}

/*
 * Function:       CMD_RST
 * Arguments:      fsptr, pointer of flash status structure
 * Description:    The RST instruction is used as a system (software) reset that
 *                 puts the device in normal operating Ready mode.
 * Return Message: FlashOperationSuccess
 */
ReturnMsg CMX25L64::CMD_RST( void )
{
    // Chip select go low to start a flash command
    CS_Low();
    // Write RST command = 0x99
    Send_byte(  MX25L64_CMD_RST );
    // Chip select go high to end a flash command
    CS_High();

    return FlashOperationSuccess;
}
