/**
  ******************************************************************************
  * File Name          : MX25L6435E.c
  * Description        : ���������� ��� ������ � ����������� ������ Macronix MX25L6435E
  *     
  *                      
  ******************************************************************************
*/


#ifndef    MX25L6435E_H
#define    MX25L6435E_H

#include <stdint.h>

#include    "MX25L6435E_config.h"

//ID ����� ������, ��������� � config
#define SST25VF064C_ID          0x00BF254B
#define S25FL164K_ID            0x00014017
#define MX25L6435E_ID           0x00C22017
#define IS25LP256D_ID           0x009D6019
#define AT25SF641_ID            0x001F3217
#define MX25L25645G_ID          0x00C22019

#define    MX25L64_SECTOR_SIZE   4096
#define    MX25L64_PAGE_SIZE     256

/*** MX25 series command hex code definition ***/
//ID comands
#define    MX25L64_CMD_RDID      0x9F    //RDID (Read Identification)
#define    MX25L64_CMD_RES       0xAB    //RES (Read Electronic ID)
#define    MX25L64_CMD_REMS      0x90    //REMS (Read Electronic & Device ID)

//Register comands
#define    MX25L64_CMD_WRSR      0x01    //WRSR (Write Status Register)
#define    MX25L64_CMD_RDSR      0x05    //RDSR (Read Status Register)
#define    MX25L64_CMD_WRSCUR    0x2F    //WRSCUR (Write Security Register)
//#define    MX25L64_CMD_RDSCUR    0x2B    //RDSCUR (Read Security Register)
#define    MX25L64_CMD_RDCR      0x15    //RDCR (Read Configuration Register)

//READ comands
#define    MX25L64_CMD_READ        0x03    //READ (1 x I/O)
#define    MX25L64_CMD_2READ       0xBB    //2READ (2 x I/O)
#define    MX25L64_CMD_4READ       0xEB    //4READ (4 x I/O)
#define    MX25L64_CMD_FASTREAD    0x0B    //FAST READ (Fast read data)
#define    MX25L64_CMD_DREAD       0x3B    //DREAD (1In/2 Out fast read)
#define    MX25L64_CMD_QREAD       0x6B    //QREAD (1In/4 Out fast read)
#define    MX25L64_CMD_RDSFDP      0x5A    //RDSFDP (Read SFDP)

//Program comands
#define    MX25L64_CMD_WREN     0x06    //WREN (Write Enable)
#define    MX25L64_CMD_WRDI     0x04    //WRDI (Write Disable)
#define    MX25L64_CMD_PP       0x02    //PP (page program)
#define    MX25L64_CMD_4PP      0x38    //4PP (Quad page program)

//Erase comands
#define    MX25L64_CMD_SE       0x20    //SE (Sector Erase)
#define    MX25L64_CMD_BE32K    0x52    //BE32K (Block Erase 32kb)
#define    MX25L64_CMD_BE       0xD8    //BE (Block Erase)
#define    MX25L64_CMD_CE       0x60    //CE (Chip Erase) hex code: 60 or C7

//Mode setting comands
#define    MX25L64_CMD_DP       0xB9    //DP (Deep Power Down)
#define    MX25L64_CMD_ENSO     0xB1    //ENSO (Enter Secured OTP)
#define    MX25L64_CMD_EXSO     0xC1    //EXSO  (Exit Secured OTP)

//Reset comands
#define    MX25L64_CMD_RSTEN     0x66    //RSTEN (Reset Enable)
#define    MX25L64_CMD_RST       0x99    //RST (Reset Memory)

//Suspend/Resume comands
#define    MX25L64_CMD_NOP          0x00    //NOP (No Operation)


// Flash control register mask define
// status register
#define    MX25L64_WIP_MASK         0x01
#define    MX25L64_LDSO_MASK        0x02
#define    MX25L64_QE_MASK          0x40
// security register
#define    MX25L64_OTPLOCK_MASK     0x03
#define    MX25L64_4BYTE_MASK       0x04
#define    MX25L64_WPSEL_MASK       0x80
// configuration reigster
#define    MX25L64_DC_MASK          0x80
#define    MX25L64_DC_2BIT_MASK     0xC0
// other
#define    BLOCK_PROTECT_MASK     0xff
#define    BLOCK_LOCK_MASK        0x01

#define    ElectronicID     0x16
#define    RESID0           0xc216
#define    RESID1           0x16c2

#if (!defined(FlashSize))
#define    FlashSize        0x800000       // 8 MB
#endif //(!defined(FlashSize))

//��������� ��� ����� ��������� ������
#define    CE_period        256000         // 256s for S25FL164K
#define    tW               86             // 85ms at 100K cycles for S25FL164K
#define    tPP              6              // 5ms for AT25SF641
#define    tSE              451            // 450ms for S25FL164K
#define    tPUW             16             // 15ms

/*
//unused defines
#define    tWSR             1              // 1ms
#define    tBP              100000         // 100us
#define    tBE              2000           // 3.5s
#define    tBE32            1600           // 3s
#define    tDP              10000          // 10us
*/

// Support I/O mode
#define    SIO              0
#define    DIO              1
#define    QIO              2

#define    SUPPORT_RDCR     1
#define    SUPPORT_WRSR_CR  0
#define    SUPPORT_CR_DC    1

// dummy cycle configration
#ifdef DUMMY_CONF_2

#define    DUMMY_CONF_2READ       0x08040804
#define    DUMMY_CONF_4READ       0x0A080406
#define    DUMMY_CONF_FASTREAD    0x08080808
#define    DUMMY_CONF_DREAD       0x08080808
#define    DUMMY_CONF_QREAD       0x08080808

#else

#define    DUMMY_CONF_2READ       0x0A080604
#define    DUMMY_CONF_4READ       0x0A080406
#define    DUMMY_CONF_FASTREAD    0x0A080608
#define    DUMMY_CONF_DREAD       0x0A080608
#define    DUMMY_CONF_QREAD       0x0A080608

#endif

#define    WriteStatusRegCycleTime              tW 
#define    PageProgramCycleTime                 tPP 
#define    SectorEraseCycleTime                 tSE
#define    ChipEraseCycleTime                   CE_period

/*
#define    BlockEraseCycleTime                  tBE 
#ifdef tWSR
#define    WriteSecuRegCycleTime       tWSR 
#endif
#ifdef tBE32
#define    BlockErase32KCycleTime      tBE32 
#endif
*/

// Return Message
typedef enum {
  FlashOperationSuccess,
  FlashWriteRegFailed,
  FlashTimeOut,
  FlashIsBusy,
  FlashQuadNotEnable,
  FlashAddressInvalid
}ReturnMsg;

// Flash status structure define
struct sFlashStatus{
  /* Mode Register:
  * Bit  Description
  * -------------------------
  *  7   RYBY enable
  *  6   Reserved
  *  5   Reserved
  *  4   Reserved
  *  3   Reserved
  *  2   Reserved
  *  1   Parallel mode enable
  *  0   QPI mode enable
  */
  uint8_t    ModeReg;
  uint8_t     ArrangeOpt;
};

typedef struct sFlashStatus FlashStatus;

typedef void (*SPI_init_t)(void); 
typedef void (*SPI_deinit_t)(void); 
typedef void (*CS_High_t)(void); 
typedef void (*CS_Low_t)(void); 
typedef void (*Send_data_t)(const uint8_t* data, uint16_t len); 
typedef void (*Send_byte_t)(uint8_t byte); 
typedef void (*Get_data_t)(uint8_t* data, uint16_t len); 
typedef uint8_t (*Get_byte_t)(void); 


class CMX25L64
{
  public:
  // �����������
  CMX25L64(CS_High_t CS_High, CS_Low_t CS_Low, Send_data_t Send_data, Send_byte_t Send_byte, Get_data_t Get_data, Get_byte_t Get_byte, SPI_init_t SPI_init, SPI_deinit_t SPI_deinit);
  // �������������
  uint8_t Init(void);
  // ���������������
  void Deinit(void);
  // ������ ������
  void Write_data(uint16_t sector, uint16_t address, const uint8_t* data, uint16_t size);
  // ������ �����
  void Read_data(uint16_t sector, uint16_t address, uint8_t* data, uint16_t size);
  // ������� �������
  void Erase_sector(uint16_t sector);
  // ������� ����
  bool Erase_chip(void);
  // this parameter is required to determine memory wear
  TickType_t Get_SE_max_time();
  
  private:
  bool addr_4byte_mode;
  uint32_t ID;
  TickType_t SE_max_time;
  SPI_init_t SPI_init;
  SPI_deinit_t SPI_deinit;
  CS_High_t CS_High;  
  CS_Low_t CS_Low;
  Send_data_t Send_data;
  Send_byte_t Send_byte;
  Get_data_t Get_data;
  Get_byte_t Get_byte;
  
  bool IsFlashBusy( void );
  bool WaitFlashReady( uint32_t ExpectTime );
  bool IsFlash4Byte( void );
  void SendFlashAddr( uint32_t flash_address, bool addr_4byte_mode );
  #ifdef SUPPORT_WRSR_CR
  ReturnMsg CMD_WRSR( uint16_t UpdateValue );
  #else
  ReturnMsg CMD_WRSR( uint8_t UpdateValue );
  #endif
  ReturnMsg CMD_RDID( uint32_t *Identification );
  ReturnMsg CMD_RDSR( uint8_t *StatusReg );
  ReturnMsg CMD_RDSCUR( uint8_t *SecurityReg );
  ReturnMsg CMD_READ( uint32_t flash_address, uint8_t *target_address, uint32_t byte_length );
  ReturnMsg CMD_WREN( void );
  ReturnMsg CMD_PP( uint32_t flash_address, const uint8_t *source_address, uint32_t byte_length );
  ReturnMsg CMD_SE( uint32_t flash_address );
  ReturnMsg CMD_CE( void );
  ReturnMsg CMD_DP( void );
  ReturnMsg CMD_RSTEN( void );
  ReturnMsg CMD_RST( void );
};

#endif    /* MX25L6435E_H */
