/**
  ******************************************************************************
  * File Name          : nmea_protocol_l.cpp
  * Description        :  NMEA     
  *                       
  *                      
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "nmea_protocol_l.h"
#include "ext_string_lib/ext_string.h"
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <stdio.h>
#include <math.h>

/* C++ code---------------------------------------------------------------------*/
CNMEA_protocol::CNMEA_protocol(TGNSS_state* state_struct)
{
  this->GNSS_cur_state = state_struct;
}

uint8_t CNMEA_protocol::Strfind(const uint8_t* find_in, const char* find_what, uint16_t size)
{
  uint16_t len = strlen(find_what);
  for(uint16_t i = 0; i < size - len; i++)
  {
    if(memcmp(&find_in[i], find_what, len) == 0)
    return 1;
  }
  return 0;
}

uint8_t CNMEA_protocol::parse(const uint8_t* buff, uint16_t size)
{
  //buff="$GNRMC,192034.00,A,5500.82388,N,08257.26628,E,0.000,,031018,,,A*61\r\n"; //UBLOX
  //buff="$GNRMC,120926.000,A,5502.1727,N,08254.1456,E,0.49,315.86,220620,,,A*72\r\n"; //MTK
  //buff="$GNRMC,121030.080,V,,,,,0.00,0.00,220620,,,N*5E\r\n";
  //buff="$GNRMC,114322.094,V,,,,,0.38,190.23,300720,,,N*5D\r\n"; //  ,   
  //size=strlen((char*)buff);
  
  // PRN      ,      GPS,      GLONASS  
  memset(&GNSS_cur_state->sat_prn, 0x00, sizeof(GNSS_cur_state->sat_prn));
  memset(&GNSS_cur_state->gps_satinfo, 0x00, sizeof(GNSS_cur_state->gps_satinfo));
  memset(&GNSS_cur_state->glonass_satinfo, 0x00, sizeof(GNSS_cur_state->glonass_satinfo));
  memset(&GNSS_cur_state->galileo_satinfo, 0x00, sizeof(GNSS_cur_state->galileo_satinfo));
  memset(&GNSS_cur_state->beidou_satinfo, 0x00, sizeof(GNSS_cur_state->beidou_satinfo));
  
  const uint8_t* buff_end = buff + size;
  const uint8_t* message_start = 0;
  const uint8_t* message_end = 0;
 
  uint8_t RMC_finded = 0;
  
  for(const uint8_t* ptr = buff ; ptr < buff_end; ptr++)
  {
    //   
    if(ptr[0] == '$') message_start = ptr;
    //   ,  ,   
    if(ptr[0] == '*' && message_start) 
    {
      //     
      message_end = ptr + 5;
      //  CRC
      if(this->check_crc(message_start, (message_end - message_start)))
      {
        //   
        nmeaTYPES message_type = this->check_message_type(message_start+1);
        //  
        switch (message_type)
        {
          case NMEA_GxNON: break;
          case NMEA_GxGGA: 
          {
            this->scanf((const char*)message_start+3, message_end - message_start,"GGA,%z.%z,%z,%z,%z,%z,%u,%u,%z,%f,%z,%f,%z,%i,%d*",
                                      &(GNSS_cur_state->sig), &(GNSS_cur_state->sat_inuse), &(GNSS_cur_state->alt), 
                                      &(GNSS_cur_state->diff), &(GNSS_cur_state->dgps_age), &(GNSS_cur_state->dgps_sid)); 
            break;
          }
          case NMEA_GxGSA: 
          {
            uint8_t sat_offset = 0;
            //  GSA    ,   GPS,   GLONASS.       offset.
            for(sat_offset = 0; sat_offset < (sizeof(GNSS_cur_state->sat_prn)/sizeof(GNSS_cur_state->sat_prn[0])); sat_offset++)
            {
              if(GNSS_cur_state->sat_prn[sat_offset] == 0) break;
            }
            this->scanf((const char*)message_start+3, message_end - message_start,"GSA,%z,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%f,%f,%f*",
                                      &(GNSS_cur_state->fix_type),&(GNSS_cur_state->sat_prn[sat_offset + 0]), &(GNSS_cur_state->sat_prn[sat_offset + 1]), &(GNSS_cur_state->sat_prn[sat_offset + 2]), 
                                      &(GNSS_cur_state->sat_prn[sat_offset + 3]), &(GNSS_cur_state->sat_prn[sat_offset + 4]), &(GNSS_cur_state->sat_prn[sat_offset + 5]), &(GNSS_cur_state->sat_prn[sat_offset + 6]), &(GNSS_cur_state->sat_prn[sat_offset + 7]), 
                                      &(GNSS_cur_state->sat_prn[sat_offset + 8]), &(GNSS_cur_state->sat_prn[sat_offset + 9]), &(GNSS_cur_state->sat_prn[sat_offset + 10]), &(GNSS_cur_state->sat_prn[sat_offset + 11]), 
                                      &(GNSS_cur_state->PDOP), &(GNSS_cur_state->HDOP), &(GNSS_cur_state->VDOP)); 
            break;
          }
          case NMEA_GxGSV:
          {
            TGNSS_satinfo* satinfo=NULL;
                        
            if(strncmp((const char*)message_start, "$GPGSV", sizeof("$GPGSV")-1) == 0)      {satinfo=&GNSS_cur_state->gps_satinfo;}
            else if(strncmp((const char*)message_start, "$GLGSV", sizeof("$GLGSV")-1) == 0) {satinfo=&GNSS_cur_state->glonass_satinfo;}
            else if(strncmp((const char*)message_start, "$GAGSV", sizeof("$GAGSV")-1) == 0) {satinfo=&GNSS_cur_state->galileo_satinfo;}
            else if(strncmp((const char*)message_start, "$GBGSV", sizeof("$GBGSV")-1) == 0) {satinfo=&GNSS_cur_state->beidou_satinfo;}
            else if(strncmp((const char*)message_start, "$BDGSV", sizeof("$BDGSV")-1) == 0) {satinfo=&GNSS_cur_state->beidou_satinfo;}
            
            if(satinfo != NULL)
            {
              uint8_t sat_offset = 0;
              //  GSV    ,        GPS  GLONASS.       offset.
              for(sat_offset = 0; sat_offset < GPS_MAX_SAT_VISIBLE; sat_offset++)
              {
                if(satinfo->sat[sat_offset].id == 0) break;
              }
              if(sat_offset > GPS_MAX_SAT_VISIBLE - 4) break; //     ,   
              this->scanf((const char*)message_start+3, message_end - message_start,"GSV,%z,%z,%u,%u,%u,%d,%u,%u,%u,%d,%u,%u,%u,%d,%u,%u,%u,%d,%u*",
                            &(satinfo->inview),
                            &(satinfo->sat[sat_offset+0].id), &(satinfo->sat[sat_offset+0].elv), &(satinfo->sat[sat_offset+0].azimuth), &(satinfo->sat[sat_offset+0].sig),
                            &(satinfo->sat[sat_offset+1].id), &(satinfo->sat[sat_offset+1].elv), &(satinfo->sat[sat_offset+1].azimuth), &(satinfo->sat[sat_offset+1].sig),
                            &(satinfo->sat[sat_offset+2].id), &(satinfo->sat[sat_offset+2].elv), &(satinfo->sat[sat_offset+2].azimuth), &(satinfo->sat[sat_offset+2].sig),
                            &(satinfo->sat[sat_offset+3].id), &(satinfo->sat[sat_offset+3].elv), &(satinfo->sat[sat_offset+3].azimuth), &(satinfo->sat[sat_offset+3].sig));
            }
            
            this->GNSS_cur_state->total_sat_inview = this->GNSS_cur_state->gps_satinfo.inview + this->GNSS_cur_state->glonass_satinfo.inview \
              + this->GNSS_cur_state->galileo_satinfo.inview + this->GNSS_cur_state->beidou_satinfo.inview;
            
            break;
          }
          case NMEA_GxRMC: 
          {
            RMC_finded = 1;
            uint32_t lat[2]={0,0};
            uint32_t lon[2]={0,0};
            float speed = 0.0f;
            uint8_t NS = 'N';
            uint8_t EW = 'E';
            uint8_t coord_status = 'V';
            
            memset(&GNSS_cur_state->utc, 0, sizeof(GNSS_cur_state->utc));
            GNSS_cur_state->utc.day=1;
            GNSS_cur_state->utc.mon=1;
            
            //  -     100000.  float  , double   .
            if(NULL!=strnstr((const char*)message_start+3, ",V,,,,,", message_end - (message_start+3)))
            {
              this->scanf((const char*)message_start+3, message_end - message_start,"RMC,%2u%2u%2u.%z,%C,,,,,%f,%f,%2u%2u%2d,%z,%z,%C*",
                          &(GNSS_cur_state->utc.hour),&(GNSS_cur_state->utc.min),&(GNSS_cur_state->utc.sec),
                          &(coord_status),
                          &(speed), &(GNSS_cur_state->direction),
                          &(GNSS_cur_state->utc.day), &(GNSS_cur_state->utc.mon), &(GNSS_cur_state->utc.year),
                          &(GNSS_cur_state->dgps_mode));
              
              coord_status = 'V';
            }
            else
            {
              this->scanf((const char*)message_start+3, message_end - message_start,"RMC,%2u%2u%2u.%z,%C,%i.%i,%C,%i.%i,%C,%f,%f,%2u%2u%2d,%z,%z,%C*",
                          &(GNSS_cur_state->utc.hour),&(GNSS_cur_state->utc.min),&(GNSS_cur_state->utc.sec),
                          &(coord_status), &(lat[0]), &(lat[1]), &(NS), &(lon[0]), &(lon[1]), &(EW),
                          &(speed), &(GNSS_cur_state->direction),
                          &(GNSS_cur_state->utc.day), &(GNSS_cur_state->utc.mon), &(GNSS_cur_state->utc.year),
                          &(GNSS_cur_state->dgps_mode));
            }
            
            GNSS_cur_state->lat = NMEA_to_WGS84(lat);
            GNSS_cur_state->lon = NMEA_to_WGS84(lon);
            
            //    ()          
            if(NS == 'S') GNSS_cur_state->lat = GNSS_cur_state->lat*(-1.0f);
            if(EW == 'W') GNSS_cur_state->lon = GNSS_cur_state->lon*(-1.0f);
            
            if(coord_status == 'A') GNSS_cur_state->coord_status = VALID;
            else                    GNSS_cur_state->coord_status = INVALID;
            
            GNSS_cur_state->utc.year += 2000;
            GNSS_cur_state->speed = speed*1.852f;
            break;
          }
          case NMEA_GxVTG: break;
          default: break;
        }
      }
      else
      {

      }
      //    
      message_start = 0;
    }
  }
  //   RMC  ,   0
  if(!RMC_finded) return 0;
  //      
  this->GNSS_cur_state->sat_inuse = 0;
  for(uint8_t i = 0; i < (sizeof(this->GNSS_cur_state->sat_prn)/sizeof(this->GNSS_cur_state->sat_prn[0])); i++)
  {
    if(this->GNSS_cur_state->sat_prn[i]) this->GNSS_cur_state->sat_inuse++;
    else break;
  }
  return 1;
}

float CNMEA_protocol::NMEA_to_WGS84(const uint32_t NMEA[2])
{
  uint32_t val;
  
#if defined(UBLOX_GNSS_PRESENT)
  val = NMEA[0]*(100000Ul) + NMEA[1]; //(d)ddmm.mmmmm
#elif defined(MEDIATECK_GNSS_PRESENT)
  val = NMEA[0]*(100000Ul) + NMEA[1]*10Ul; //(d)ddmm.mmmm
#else
#error
#endif //
  
  const float fval = (float)(val/10000000Ul) + \
                     (float)(val%10000000Ul)/6000000.0f;
  
  return fval;
}

//   
uint8_t CNMEA_protocol::check_crc(const uint8_t* buff, uint16_t size)
{
  uint8_t crc = 0;

  for(const uint8_t* ptr = buff+1; ptr < (buff+size); ptr++ )
  {
    if(ptr[0] == '*')
    {
      uint8_t packet_crc = strtol((const char*)&ptr[1], 0, 16);
      if(crc == packet_crc) return 1;
      else return 0;
    }
    crc ^= ptr[0]; 
  }
  return 0;
}

//     *
bool CNMEA_protocol::add_crc(char* buff)
{
  uint8_t crc=0;
  
  if(NULL==strchr(buff, '*')) {return false;}
  
  if(*buff=='$') {buff++;}
  
  while(*buff!='*')
  {
    crc^=*buff;
    buff++;
  }
  
  if(sprintf(&buff[1], "%02X\r\n", crc)>0) {return true;}
  else                                     {return false;}
}

//      NMEA
nmeaTYPES CNMEA_protocol::check_message_type(const uint8_t* buff)
{
  if(buff[0] == 'G' || buff[0] == 'B' )
  {
    if (0 == memcmp(buff+2, "GGA", 3) )     {return NMEA_GxGGA;}
    else if(0 == memcmp(buff+2, "GSA", 3) ) {return NMEA_GxGSA;}
    else if(0 == memcmp(buff+2, "GSV", 3) ) {return NMEA_GxGSV;}
    else if(0 == memcmp(buff+2, "RMC", 3) ) {return NMEA_GxRMC;}
    else if(0 == memcmp(buff+2, "VTG", 3) ) {return NMEA_GxVTG;}
  }
  
  return NMEA_GxNON;
}

//   atoi
int CNMEA_protocol::atoi(const char *str, int str_sz, int radix)
{
    char *tmp_ptr;
    char buff[NMEA_CONVSTR_BUF];
    int res = 0;

    if(str_sz < NMEA_CONVSTR_BUF)
    {
        memcpy(&buff[0], str, str_sz);
        buff[str_sz] = '\0';
        res = strtol(&buff[0], &tmp_ptr, radix);
    }

    return res;
}

//   atof
float CNMEA_protocol::atof(const char *str, int str_sz)
{
    char *tmp_ptr;
    char buff[NMEA_CONVSTR_BUF];
    float res = 0;

    if(str_sz < NMEA_CONVSTR_BUF)
    {
        memcpy(&buff[0], str, str_sz);
        buff[str_sz] = '\0';
        res = strtof(&buff[0], &tmp_ptr);
    }

    return res;
}

//    NMEA     
int CNMEA_protocol::scanf(const char *buff, int buff_sz, const char *format, ...)
{
    const char *beg_tok;
    const char *end_buf = buff + buff_sz;

    va_list arg_ptr;
    int tok_type = NMEA_TOKS_COMPARE;
    int width = 0;
    const char *beg_fmt = 0;
    int snum = 0, unum = 0;

    int tok_count = 0;
    void *parg_target;

    va_start(arg_ptr, format);
    
    for(; *format && buff < end_buf; ++format)
    {
        switch(tok_type)
        {
        case NMEA_TOKS_COMPARE:
            if('%' == *format)
                tok_type = NMEA_TOKS_PERCENT;
            else if(*buff++ != *format)
                goto fail;
            break;
        case NMEA_TOKS_PERCENT:
            width = 0;
            beg_fmt = format;
            tok_type = NMEA_TOKS_WIDTH;
        case NMEA_TOKS_WIDTH:
            if(isdigit(*format))
                break;
            {
                tok_type = NMEA_TOKS_TYPE;
                if(format > beg_fmt)
                    width = this->atoi(beg_fmt, (int)(format - beg_fmt), 10);
            }
        case NMEA_TOKS_TYPE:
            beg_tok = buff;

            if(!width && ('c' == *format || 'C' == *format) && *buff != format[1])
                width = 1;

            if(width)
            {
                if(buff + width <= end_buf)
                    buff += width;
                else
                    goto fail;
            }
            else
            {
                if(!format[1] || (0 == (buff = (char *)memchr(buff, format[1], end_buf - buff))))
                    buff = end_buf;
            }

            if(buff > end_buf)
                goto fail;

            tok_type = NMEA_TOKS_COMPARE;
            tok_count++;

            parg_target = 0; width = (int)(buff - beg_tok);

            switch(*format)
            {
            case 'c':
            case 'C':
                parg_target = (void *)va_arg(arg_ptr, char *);
                if(width && 0 != (parg_target))
                    *((char *)parg_target) = *beg_tok;
                break;
            case 's':
            case 'S':
                parg_target = (void *)va_arg(arg_ptr, char *);
                if(width && 0 != (parg_target))
                {
                    memcpy(parg_target, beg_tok, width);
                    ((char *)parg_target)[width] = '\0';
                }
                break;
            case 'f':
            case 'g':
            case 'G':
            case 'e':
            case 'E':
                parg_target = (void *)va_arg(arg_ptr, float *);
                if(width && 0 != (parg_target))
                    *((float *)parg_target) = this->atof(beg_tok, width);
                break;
            /*
            case 'g':
            case 'G':
            case 'e':
            case 'E':
                parg_target = (void *)va_arg(arg_ptr, float *);
                if(width && 0 != (parg_target))
                    *((double *)parg_target) = this->atod(beg_tok, width);
                break;
            */
            case 'z': parg_target =(void*)1; break;    
            };

            if(parg_target)
                break;
            if(0 == (parg_target = (void *)va_arg(arg_ptr, int *)))
                break;
            if(!width)
                break;

            switch(*format)
            {
            case 'i':
                snum = this->atoi(beg_tok, width, 10);
                *(uint32_t*)parg_target = (uint32_t)snum;
                //memcpy(parg_target, &snum, sizeof(uint32_t));
                break;            
            case 'd':  
                snum = this->atoi(beg_tok, width, 10);
                *(uint16_t*)parg_target = (uint16_t)snum;
                //memcpy(parg_target, &snum, sizeof(uint16_t));
                break;
            case 'u':
                unum = this->atoi(beg_tok, width, 10);
                *(uint8_t*)parg_target = (uint8_t)unum;
                //memcpy(parg_target, &unum, sizeof(uint8_t));
                break;
            case 'x':
            case 'X':
                unum = this->atoi(beg_tok, width, 16);
                memcpy(parg_target, &unum, sizeof(unsigned int));
                break;
            case 'o':
                unum = this->atoi(beg_tok, width, 8);
                memcpy(parg_target, &unum, sizeof(unsigned int));
                break;
            default:
                goto fail;
            };

            break;
        };
    }
fail:

    va_end(arg_ptr);
    return tok_count;
}

