/**
  ******************************************************************************
  * File Name          : nmea_protocol_l.h
  * Description        :  NMEA     
  *                       
  *                      
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef NMEA_PROTOCOL_L_H
#define NMEA_PROTOCOL_L_H

/* Includes ------------------------------------------------------------------*/
#include "System\system.h"

/* Defines- ------------------------------------------------------------------*/
//  
#define NMEA_TOKS_COMPARE   (1)
#define NMEA_TOKS_PERCENT   (2)
#define NMEA_TOKS_WIDTH     (3)
#define NMEA_TOKS_TYPE      (4)
#define NMEA_CONVSTR_BUF    (16)

//    NMEA
enum nmeaTYPES
{
    NMEA_GxNON  = 0x00, // Unknown packet type.
    NMEA_GxGGA  = 0x01, // GGA - Essential fix data which provide 3D location and accuracy data.
    NMEA_GxGSA  = 0x02, // GSA - GPS receiver operating mode, SVs used for navigation, and DOP values.
    NMEA_GxGSV  = 0x04, // GSV - Number of SVs in view, PRN numbers, elevation, azimuth & SNR values.
    NMEA_GxRMC  = 0x08, // RMC - Recommended Minimum Specific GPS/TRANSIT Data.
    NMEA_GxVTG  = 0x10, // VTG - Actual track made good and speed over ground.
};

/* C++ code---------------------------------------------------------------------*/
class CNMEA_protocol
{
  public:
  // 
  CNMEA_protocol(TGNSS_state* state_struct);
  //     NMEA   GNSS_info
  uint8_t parse(const uint8_t* buff, uint16_t size);
  //   GPS-
  TGNSS_state* GNSS_cur_state;
  //     *
  bool add_crc(char* buff);
  
  private:
  //   
  uint8_t check_crc(const uint8_t* buff, uint16_t size);
  //      NMEA
  nmeaTYPES check_message_type(const uint8_t* buff);
  //   atof
  float atof(const char *str, int str_sz);
  //   atod
  float atod(const char *str, int str_sz);
  //   atoi
  int atoi(const char *str, int str_sz, int radix);
  //    NMEA     
  int scanf(const char *buff, int buff_sz, const char *format, ...);
  //    NMEA  WGS84
  float NMEA_to_WGS84(const uint32_t NMEA[2]);
  //  
  uint8_t Strfind(const uint8_t* find_in, const char* find_what, uint16_t size );
};

#endif //NMEA_PROTOCOL_L_H