/**
  ******************************************************************************
  * File Name          : Soft_timers.cpp
  * Description        :   
  *                      
  *                      
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "Soft_timers/Soft_timers.h"
#include <string.h>

/* Global variables-----------------------------------------------------------*/
//   
TSoft_timers Soft_timers;

/* C++ code-------------------------------------------------------------------*/
//
// name -  ,  
// timer_empty -   Soft_timer_callback_t,    
//   .    ,    0
CSoft_timer::CSoft_timer(const char* timer_name, Soft_timer_callback_t timer_empty)
{
  for(uint8_t x=0; x<SOFT_TIMERS_COUNT; x++)
  {
    if(Soft_timers.timer_table[x].timer_name[0] == 0) 
    {
      //   
      num = x; 
      //     
      if(strlen(timer_name) > SOFT_TIMER_NAME_MAXSIZE) while(1);
      //     
      memcpy(&Soft_timers.timer_table[num].timer_name[0], timer_name, strlen(timer_name));
      //    !
      if(Soft_timers.timer_table[num].timer_name[0] == 0) while(1);
      //  callback    ,    
      Soft_timers.timer_table[num].empty = timer_empty;
      //       
      Soft_timers.timer_table[num].timer_counter = 0;
      return;
    }   
  }
  //   ,      
  while(1);
}

//  
void CSoft_timer::Start(uint32_t time) 
{
  Soft_timers.timer_table[num].timer_counter = time;
}

//  
void CSoft_timer::Stop(void)
{
  Soft_timers.timer_table[num].timer_counter = 0;
}

//  
bool CSoft_timer::Is_empty(void)
{
  if(Soft_timers.timer_table[num].timer_counter) return false;
  return true;
}

//       
uint32_t CSoft_timer::Get_time_left (Soft_timers_times divider)
{
  return Soft_timers.timer_table[num].timer_counter/divider;
}

//  
void CSoft_timer::Sleep(uint32_t time)
{
  this->Start(time);
  while(!Is_empty());
}

/* C code---------------------------------------------------------------------*/
extern "C"
{
  // -   ,   1   ,
  //     
  void Soft_timers_handler(void)
  {
    for(uint8_t x=0; x<SOFT_TIMERS_COUNT; x++)
    {
      if(Soft_timers.timer_table[x].timer_counter > 0) 
      {  
        //  
        Soft_timers.timer_table[x].timer_counter--;
        //  callback         
        if( (Soft_timers.timer_table[x].timer_counter == 0) && (Soft_timers.timer_table[x].empty != 0) ) Soft_timers.timer_table[x].empty();
      }
    }
    //       
    Soft_timers.fast_ticks++;
    if(Soft_timers.fast_ticks==SEC)
    {
      Soft_timers.seconds_from_startup++;
      Soft_timers.fast_ticks=0;
    }
  }

  //       
  // (    )
  uint32_t GetSecondsFromStartup(void)
  {
    return Soft_timers.seconds_from_startup;
  }
}