/**
  ******************************************************************************
  * File Name          : Soft_timers.h
  * Description        :   
  *                      
  *                      
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef SOFT_TIMERS_H
#define SOFT_TIMERS_H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include "Soft_timers_conf.h"

/* Defines- ------------------------------------------------------------------*/
//   callback,      
typedef void (*Soft_timer_callback_t)( void );

//     
typedef enum
{
  MS    = 1,     // 
  MS10  = 10,    // 10 
  MS100 = 100,   // 100 
  SEC   = 1000,  //  
  MIN   = 60000, // 
} Soft_timers_times;

//  .      ,     
typedef struct
{
  char timer_name[SOFT_TIMER_NAME_MAXSIZE];
  volatile uint32_t timer_counter;
  Soft_timer_callback_t empty;
} TTimer_table[SOFT_TIMERS_COUNT];

//   ,           
typedef struct
{
  TTimer_table timer_table;
  uint16_t fast_ticks;
  uint32_t seconds_from_startup;
} TSoft_timers;

/* C++ code-------------------------------------------------------------------*/
class CSoft_timer
{
  public:
    CSoft_timer(const char* timer_name, Soft_timer_callback_t timer_empty);
    void Start(uint32_t time);                                     
    void Stop(void);
    bool Is_empty(void);
    uint32_t Get_time_left (Soft_timers_times divider);
    void Sleep(uint32_t time);
  private:
    uint8_t num;
};

//   
extern TSoft_timers Soft_timers;
extern "C" {
extern uint32_t GetSecondsFromStartup(void);
}
#endif