/**
  ******************************************************************************
  * File Name          : System_settings.c
  * Description        : Настройки системы
  *
  *
  ******************************************************************************
*/

/* Includes  -----------------------------------------------------------------*/
//#ifdef __ICCARM__
#include "System/system.h"
#include <string.h>

#ifdef __ICCARM__
#include "boot_config.h"
#include "debug_port.h"
#endif

// Объект класса система
#ifdef __ICCARM__
CSystem System;
#else
static CSystem System {}; // Фигурные скобки, чтобы обнулить память под
                          // члены класса. (убираем мусор из их содержимого).
CSystem* CGetSistem::getSystemRef()
{
    return &System;
}
#endif

/* Global variables-----------------------------------------------------------*/
#ifdef __ICCARM__
// Тип устройства
const uint8_t CSystem::Dev_type = DEVICE_TYPE;
// Тип устройства
const uint8_t CSystem::Dev_type_string[] = DEV_TYPE_STRING;
#else
#include "release_configuration.h"
#include <QDebug>
#endif

#if (defined(TENZO_M_WEIGHER_PRESENT) && defined(PROCESSOR_WEIGHT_PV310_PRESENT))
#error должно быть выбранно TENZO_M_WEIGHER_PRESENT или PROCESSOR_WEIGHT_PV310_PRESENT
#endif //(defined(TENZO_M_WEIGHER_PRESENT) && defined(PROCESSOR_WEIGHT_PV310_PRESENT))

#if (defined(TPMS_PRESENT) && defined(FLOWMETER_PRESENT))
#error должно быть выбранно TPMS_PRESENT или FLOWMETER_PRESENT
#endif //(defined(TPMS_PRESENT) && defined(FLOWMETER_PRESENT))

// Текущая версия протокола VEGA
const uint8_t CSystem::Protocol_version = PROTOCOL_VERSION;
// Таблица датчиков устройства. Использовать для поиска имени датчика, его данных и их размера по id протокола вега
//#ifdef __ICCARM__

#if defined(TINY_FLASH_SYSTEM_PRESENT)
#if (__VER__ >= 7080000)
#define __SNAME(__sname) .name[0]=0
#else
#define __SNAME(__sname) .name=0
#endif //(__VER__ >= 7080000)
#define __EGTSN(__egtsn)
#else
#define __SNAME(__sname) .name=__sname
#define __EGTSN(__egtsn) .egts_param_id=__egtsn
#endif //defined(TINY_FLASH_SYSTEM_PRESENT)
#define __SPTR(__sptr) .ptr=__sptr

const TSensor_table CSystem::sensor_table[] = {
#ifdef __ICCARM__
  {VEGA_DEVICE_TYPE         , __SNAME("dev_type")       , __SPTR((void*)&Dev_type), (void*)&Dev_type, sizeof(Dev_type), UINT8_SYSTEM_T, __EGTSN(0)},
#else
  {VEGA_DEVICE_TYPE         , "dev_type"                , (void*)&System.Dev_type, (void*)&System.Dev_type, sizeof(System.Dev_type), UINT8_SYSTEM_T, 0},
#endif

  {VEGA_MCU_FIRMWARE_VERSION, __SNAME("mcu_fw")         , __SPTR(&System.syscom_state.mcu_firmware_version), &System.syscom_state_res.mcu_firmware_version, sizeof(System.syscom_state.mcu_firmware_version), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GSM_FIRMWARE_VERSION, __SNAME("gsm_fw")         , __SPTR(&System.server_state.modem_version), &System.server_state_res.modem_version, sizeof(System.server_state.modem_version), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GPS_FIRMWARE_VERSION, __SNAME("gps_fw")         , __SPTR(&System.gnss_state.receiver_version), &System.gnss_state_res.receiver_version, sizeof(System.gnss_state.receiver_version), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_DEVICE_IMEI         , __SNAME("imei")           , __SPTR(&System.server_state.IMEI), &System.server_state_res.IMEI, sizeof(System.server_state.IMEI), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_DEVICE_SERIAL       , __SNAME("serial")         , __SPTR(&System.syscom_state.serial_num), &System.syscom_state_res.serial_num, sizeof(System.syscom_state.serial_num), UINT32_SYSTEM_T, __EGTSN(1)},
  {VEGA_INPUT_BUFFER_SIZE   , __SNAME("in_buff_size")   , __SPTR(&System.server_state.input_buff_size), &System.server_state_res.input_buff_size, sizeof(System.server_state.input_buff_size), UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_SIM_ICCID           , __SNAME("sim_iccid")      , __SPTR(&System.server_state.ICCID[0]), &System.server_state_res.ICCID[0], sizeof(System.server_state.ICCID[0]), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_UPTIME              , __SNAME("uptime")         , __SPTR(&System.syscom_state.uptime), &System.syscom_state_res.uptime, sizeof(System.syscom_state.uptime), UINT32_SYSTEM_T, __EGTSN(3)},
  {VEGA_UTC                 , __SNAME("utc")            , __SPTR(&System.syscom_state.current_time), &System.syscom_state_res.current_time, sizeof(System.syscom_state.current_time), UINT32_SYSTEM_T, __EGTSN(4)},
  {VEGA_OPERATION_MODE      , __SNAME("oper_mode")      , __SPTR(&System.syscom_state.operation_mode), &System.syscom_state_res.operation_mode, sizeof(System.syscom_state.operation_mode), UINT8_SYSTEM_T, __EGTSN(5)},
  {VEGA_PROTOCOL_VERSION    , __SNAME("proto_ver")      , __SPTR((void*)&Protocol_version), (void*)&Protocol_version, sizeof(Protocol_version), UINT8_SYSTEM_T, __EGTSN(6)},
  {VEGA_BB_MESSAGE_COUNT_1  , __SNAME("mess_count_1")   , __SPTR(&System.syscom_state.message_count_in_bb[0]), &System.syscom_state_res.message_count_in_bb[0], sizeof(System.syscom_state.message_count_in_bb[0]), UINT32_SYSTEM_T, __EGTSN(7)},
  {VEGA_BB_MESSAGE_COUNT_2  , __SNAME("mess_count_2")   , __SPTR(&System.syscom_state.message_count_in_bb[1]), &System.syscom_state_res.message_count_in_bb[1], sizeof(System.syscom_state.message_count_in_bb[1]), UINT32_SYSTEM_T, __EGTSN(8)},
  {VEGA_BB_MESSAGE_COUNT_3  , __SNAME("mess_count_3")   , __SPTR(&System.syscom_state.message_count_in_bb[2]), &System.syscom_state_res.message_count_in_bb[2], sizeof(System.syscom_state.message_count_in_bb[2]), UINT32_SYSTEM_T, __EGTSN(9)},
  {VEGA_BB_MESSAGE_COUNT_4  , __SNAME("mess_count_4")   , __SPTR(&System.syscom_state.message_count_in_bb[3]), &System.syscom_state_res.message_count_in_bb[3], sizeof(System.syscom_state.message_count_in_bb[3]), UINT32_SYSTEM_T, __EGTSN(10)},
  {VEGA_TCP_STATE1          , __SNAME("tcp_state1")     , __SPTR(&System.server_state.tcp_connect_state[0]), &System.server_state_res.tcp_connect_state[0], sizeof(System.server_state.tcp_connect_state[0]), UINT8_SYSTEM_T, __EGTSN(135)},
  {VEGA_TCP_STATE2          , __SNAME("tcp_state2")     , __SPTR(&System.server_state.tcp_connect_state[1]), &System.server_state_res.tcp_connect_state[1], sizeof(System.server_state.tcp_connect_state[1]), UINT8_SYSTEM_T, __EGTSN(136)},
  {VEGA_TCP_STATE3          , __SNAME("tcp_state3")     , __SPTR(&System.server_state.tcp_connect_state[2]), &System.server_state_res.tcp_connect_state[2], sizeof(System.server_state.tcp_connect_state[2]), UINT8_SYSTEM_T, __EGTSN(137)},
  {VEGA_TCP_STATE4          , __SNAME("tcp_state4")     , __SPTR(&System.server_state.tcp_connect_state[3]), &System.server_state_res.tcp_connect_state[3], sizeof(System.server_state.tcp_connect_state[3]), UINT8_SYSTEM_T, __EGTSN(138)},
  {VEGA_OUTPUT_BUFFER_SIZE  , __SNAME("out_buff_size")  , __SPTR(&System.server_state.output_buff_size), &System.server_state_res.output_buff_size, sizeof(System.server_state.output_buff_size), UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
#if (MAX_SIM_COUNT > 1)
  {VEGA_SIM2_ICCID          , __SNAME("sim2_iccid")     , __SPTR(&System.server_state.ICCID[1]), &System.server_state_res.ICCID[1], sizeof(System.server_state.ICCID[1]), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if defined(PROD_TESTING_PRESENT)
  {VEGA_PROD_TESTS_STATE    , __SNAME("")               , __SPTR(&System.ptest_state), &System.ptest_state_res, sizeof(System.ptest_state_res), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
#endif //PROD_TESTING_PRESENT
  {VEGA_BOARD_HW_VERSION    , __SNAME("hw_vers")        , __SPTR(&System.Board_hw_version), &System.Board_hw_version, sizeof(System.Board_hw_version), UINT8_SYSTEM_T, __EGTSN(0xFFFF)},

  {VEGA_LAT                 , __SNAME("lat")            , __SPTR(&System.gnss_state.lat), &System.gnss_state_res.lat, sizeof(System.gnss_state.lat), FLOAT_SYSTEM_T, __EGTSN(11)},
  {VEGA_LON                 , __SNAME("lon")            , __SPTR(&System.gnss_state.lon), &System.gnss_state_res.lon, sizeof(System.gnss_state.lon), FLOAT_SYSTEM_T, __EGTSN(12)},
  {VEGA_SPEED               , __SNAME("speed")          , __SPTR(&System.gnss_state.speed), &System.gnss_state_res.speed, sizeof(System.gnss_state.speed), FLOAT_SYSTEM_T, __EGTSN(13)},
  {VEGA_DIR                 , __SNAME("direction")      , __SPTR(&System.gnss_state.direction), &System.gnss_state_res.direction, sizeof(System.gnss_state.direction), FLOAT_SYSTEM_T, __EGTSN(14)},
  {VEGA_ALT                 , __SNAME("altitude")       , __SPTR(&System.gnss_state.alt), &System.gnss_state_res.alt, sizeof(System.gnss_state.alt), FLOAT_SYSTEM_T, __EGTSN(15)},
  {VEGA_HDOP                , __SNAME("hdop")           , __SPTR(&System.gnss_state.HDOP), &System.gnss_state_res.HDOP, sizeof(System.gnss_state.HDOP), FLOAT_SYSTEM_T, __EGTSN(16)},
  {VEGA_PDOP                , __SNAME("pdop")           , __SPTR(&System.gnss_state.PDOP), &System.gnss_state_res.PDOP, sizeof(System.gnss_state.PDOP), FLOAT_SYSTEM_T, __EGTSN(17)},
  {VEGA_VDOP                , __SNAME("vdop")           , __SPTR(&System.gnss_state.VDOP), &System.gnss_state_res.VDOP, sizeof(System.gnss_state.VDOP), FLOAT_SYSTEM_T, __EGTSN(18)},
  {VEGA_GPS_INVIEW          , __SNAME("gps_inview")     , __SPTR(&System.gnss_state.gps_satinfo.inview), &System.gnss_state_res.gps_satinfo.inview, sizeof(System.gnss_state.gps_satinfo.inview), UINT8_SYSTEM_T, __EGTSN(19)},
  {VEGA_GLONASS_INVIEW      , __SNAME("glonass_inview") , __SPTR(&System.gnss_state.glonass_satinfo.inview), &System.gnss_state_res.glonass_satinfo.inview, sizeof(System.gnss_state.glonass_satinfo.inview), UINT8_SYSTEM_T, __EGTSN(20)},
  {VEGA_TOTAL_SAT_INVIEW    , __SNAME("total_inview")   , __SPTR(&System.gnss_state.total_sat_inview), &System.gnss_state_res.total_sat_inview, sizeof(System.gnss_state.total_sat_inview), UINT8_SYSTEM_T, __EGTSN(21)},
  {VEGA_SAT_USED            , __SNAME("sat_used")       , __SPTR(&System.gnss_state.sat_inuse), &System.gnss_state_res.sat_inuse, sizeof(System.gnss_state.sat_inuse), UINT8_SYSTEM_T, __EGTSN(22)},
  {VEGA_GPS_ODOMETER        , __SNAME("gps_odometer")   , __SPTR(&System.gnss_state.odometer), &System.gnss_state_res.odometer, sizeof(System.gnss_state.odometer), FLOAT_SYSTEM_T, __EGTSN(23)},
  {VEGA_GPS_MOVE_SENSOR     , __SNAME("gps_movesensor") , __SPTR(&System.gnss_state.in_move), &System.gnss_state_res.in_move, sizeof(System.gnss_state.in_move), BOOL_SYSTEM_T, __EGTSN(0)},
  {VEGA_TRIP_COUNTER        , __SNAME("trip_counter")   , __SPTR(&System.gnss_state.trip_counter), &System.gnss_state_res.trip_counter, sizeof(System.gnss_state.trip_counter), UINT32_SYSTEM_T, __EGTSN(24)},
  {VEGA_GPS_JAMMED          , __SNAME("gps_jammed")     , __SPTR(&System.gnss_state.jammed), &System.gnss_state_res.jammed, sizeof(System.gnss_state.jammed), BOOL_SYSTEM_T, __EGTSN(1)},
#if (MAX_GEOZONES > 0)
  {(VEGA_GEOZONE_1_ID + 0)  , __SNAME("geozone_1")      , __SPTR(&System.gnss_state.geozones[0]), &System.gnss_state_res.geozones[0], sizeof(System.gnss_state.geozones[0]), BOOL_SYSTEM_T, __EGTSN(11)},
#endif
#if (MAX_GEOZONES > 1)
  {(VEGA_GEOZONE_1_ID + 1)  , __SNAME("geozone_2")      , __SPTR(&System.gnss_state.geozones[1]), &System.gnss_state_res.geozones[1], sizeof(System.gnss_state.geozones[1]), BOOL_SYSTEM_T, __EGTSN(12)},
#endif
#if (MAX_GEOZONES > 2)
  {(VEGA_GEOZONE_1_ID + 2)  , __SNAME("geozone_3")      , __SPTR(&System.gnss_state.geozones[2]), &System.gnss_state_res.geozones[2], sizeof(System.gnss_state.geozones[2]), BOOL_SYSTEM_T, __EGTSN(13)},
#endif
#if (MAX_GEOZONES > 2)
  {(VEGA_GEOZONE_1_ID + 3)  , __SNAME("geozone_4")      , __SPTR(&System.gnss_state.geozones[3]), &System.gnss_state_res.geozones[3], sizeof(System.gnss_state.geozones[3]), BOOL_SYSTEM_T, __EGTSN(14)},
#endif
#if (MAX_GEOZONES > 4)
  {(VEGA_GEOZONE_1_ID + 4)  , __SNAME("geozone_5")      , __SPTR(&System.gnss_state.geozones[4]), &System.gnss_state_res.geozones[4], sizeof(System.gnss_state.geozones[4]), BOOL_SYSTEM_T, __EGTSN(15)},
#endif
#if (MAX_GEOZONES > 5)
  {(VEGA_GEOZONE_1_ID + 5)  , __SNAME("geozone_6")      , __SPTR(&System.gnss_state.geozones[5]), &System.gnss_state_res.geozones[5], sizeof(System.gnss_state.geozones[5]), BOOL_SYSTEM_T, __EGTSN(16)},
#endif
#if (MAX_GEOZONES > 6)
  {(VEGA_GEOZONE_1_ID + 6)  , __SNAME("geozone_7")      , __SPTR(&System.gnss_state.geozones[6]), &System.gnss_state_res.geozones[6], sizeof(System.gnss_state.geozones[6]), BOOL_SYSTEM_T, __EGTSN(17)},
#endif
#if (MAX_GEOZONES > 7)
  {(VEGA_GEOZONE_1_ID + 7)  , __SNAME("geozone_8")      , __SPTR(&System.gnss_state.geozones[7]), &System.gnss_state_res.geozones[7], sizeof(System.gnss_state.geozones[7]), BOOL_SYSTEM_T, __EGTSN(18)},
#endif
#if (MAX_GEOZONES > 8)
  {(VEGA_GEOZONE_1_ID + 8)  , __SNAME("geozone_9")      , __SPTR(&System.gnss_state.geozones[8]), &System.gnss_state_res.geozones[8], sizeof(System.gnss_state.geozones[8]), BOOL_SYSTEM_T, __EGTSN(19)},
#endif
#if (MAX_GEOZONES > 9)
  {(VEGA_GEOZONE_1_ID + 9)  , __SNAME("geozone_10")     , __SPTR(&System.gnss_state.geozones[9]), &System.gnss_state_res.geozones[9], sizeof(System.gnss_state.geozones[9]), BOOL_SYSTEM_T, __EGTSN(20)},
#endif
#if (MAX_GEOZONES > 10)
  {(VEGA_GEOZONE_1_ID + 10) , __SNAME("geozone_11")     , __SPTR(&System.gnss_state.geozones[10]), &System.gnss_state_res.geozones[10], sizeof(System.gnss_state.geozones[10]), BOOL_SYSTEM_T, __EGTSN(21)},
#endif
#if (MAX_GEOZONES > 11)
  {(VEGA_GEOZONE_1_ID + 11) , __SNAME("geozone_12")     , __SPTR(&System.gnss_state.geozones[11]), &System.gnss_state_res.geozones[11], sizeof(System.gnss_state.geozones[11]), BOOL_SYSTEM_T, __EGTSN(22)},
#endif
#if (MAX_GEOZONES > 12)
  {(VEGA_GEOZONE_1_ID + 12) , __SNAME("geozone_13")     , __SPTR(&System.gnss_state.geozones[12]), &System.gnss_state_res.geozones[12], sizeof(System.gnss_state.geozones[12]), BOOL_SYSTEM_T, __EGTSN(23)},
#endif
#if (MAX_GEOZONES > 13)
  {(VEGA_GEOZONE_1_ID + 13) , __SNAME("geozone_14")     , __SPTR(&System.gnss_state.geozones[13]), &System.gnss_state_res.geozones[13], sizeof(System.gnss_state.geozones[13]), BOOL_SYSTEM_T, __EGTSN(24)},
#endif
#if (MAX_GEOZONES > 14)
  {(VEGA_GEOZONE_1_ID + 14) , __SNAME("geozone_15")     , __SPTR(&System.gnss_state.geozones[14]), &System.gnss_state_res.geozones[14], sizeof(System.gnss_state.geozones[14]), BOOL_SYSTEM_T, __EGTSN(25)},
#endif
#if (MAX_GEOZONES > 15)
  {(VEGA_GEOZONE_1_ID + 15) , __SNAME("geozone_16")     , __SPTR(&System.gnss_state.geozones[15]), &System.gnss_state_res.geozones[15], sizeof(System.gnss_state.geozones[15]), BOOL_SYSTEM_T, __EGTSN(26)},
#endif
#if (MAX_GEOZONES > 16)
  {(VEGA_GEOZONE_1_ID + 16) , __SNAME("geozone_17")     , __SPTR(&System.gnss_state.geozones[16]), &System.gnss_state_res.geozones[16], sizeof(System.gnss_state.geozones[16]), BOOL_SYSTEM_T, __EGTSN(27)},
#endif
#if (MAX_GEOZONES > 17)
  {(VEGA_GEOZONE_1_ID + 17) , __SNAME("geozone_18")     , __SPTR(&System.gnss_state.geozones[17]), &System.gnss_state_res.geozones[17], sizeof(System.gnss_state.geozones[17]), BOOL_SYSTEM_T, __EGTSN(28)},
#endif
#if (MAX_GEOZONES > 18)
  {(VEGA_GEOZONE_1_ID + 18) , __SNAME("geozone_19")     , __SPTR(&System.gnss_state.geozones[18]), &System.gnss_state_res.geozones[18], sizeof(System.gnss_state.geozones[18]), BOOL_SYSTEM_T, __EGTSN(29)},
#endif
#if (MAX_GEOZONES > 19)
  {(VEGA_GEOZONE_1_ID + 19) , __SNAME("geozone_20")     , __SPTR(&System.gnss_state.geozones[19]), &System.gnss_state_res.geozones[19], sizeof(System.gnss_state.geozones[19]), BOOL_SYSTEM_T, __EGTSN(30)},
#endif
#if (MAX_GEOZONES > 20)
  {(VEGA_GEOZONE_1_ID + 20) , __SNAME("geozone_21")     , __SPTR(&System.gnss_state.geozones[20]), &System.gnss_state_res.geozones[20], sizeof(System.gnss_state.geozones[20]), BOOL_SYSTEM_T, __EGTSN(31)},
#endif
#if (MAX_GEOZONES > 21)
  {(VEGA_GEOZONE_1_ID + 21) , __SNAME("geozone_22")     , __SPTR(&System.gnss_state.geozones[21]), &System.gnss_state_res.geozones[21], sizeof(System.gnss_state.geozones[21]), BOOL_SYSTEM_T, __EGTSN(32)},
#endif
#if (MAX_GEOZONES > 22)
  {(VEGA_GEOZONE_1_ID + 22) , __SNAME("geozone_23")     , __SPTR(&System.gnss_state.geozones[22]), &System.gnss_state_res.geozones[22], sizeof(System.gnss_state.geozones[22]), BOOL_SYSTEM_T, __EGTSN(33)},
#endif
#if (MAX_GEOZONES > 23)
  {(VEGA_GEOZONE_1_ID + 23) , __SNAME("geozone_24")     , __SPTR(&System.gnss_state.geozones[23]), &System.gnss_state_res.geozones[23], sizeof(System.gnss_state.geozones[23]), BOOL_SYSTEM_T, __EGTSN(34)},
#endif
#if (MAX_GEOZONES > 24)
  {(VEGA_GEOZONE_1_ID + 24) , __SNAME("geozone_25")     , __SPTR(&System.gnss_state.geozones[24]), &System.gnss_state_res.geozones[24], sizeof(System.gnss_state.geozones[24]), BOOL_SYSTEM_T, __EGTSN(35)},
#endif
#if (MAX_GEOZONES > 25)
  {(VEGA_GEOZONE_1_ID + 25) , __SNAME("geozone_26")     , __SPTR(&System.gnss_state.geozones[25]), &System.gnss_state_res.geozones[25], sizeof(System.gnss_state.geozones[25]), BOOL_SYSTEM_T, __EGTSN(36)},
#endif
#if (MAX_GEOZONES > 26)
  {(VEGA_GEOZONE_1_ID + 26) , __SNAME("geozone_27")     , __SPTR(&System.gnss_state.geozones[26]), &System.gnss_state_res.geozones[26], sizeof(System.gnss_state.geozones[26]), BOOL_SYSTEM_T, __EGTSN(37)},
#endif
#if (MAX_GEOZONES > 27)
  {(VEGA_GEOZONE_1_ID + 27) , __SNAME("geozone_28")     , __SPTR(&System.gnss_state.geozones[27]), &System.gnss_state_res.geozones[27], sizeof(System.gnss_state.geozones[27]), BOOL_SYSTEM_T, __EGTSN(38)},
#endif
#if (MAX_GEOZONES > 28)
  {(VEGA_GEOZONE_1_ID + 28) , __SNAME("geozone_29")     , __SPTR(&System.gnss_state.geozones[28]), &System.gnss_state_res.geozones[28], sizeof(System.gnss_state.geozones[28]), BOOL_SYSTEM_T, __EGTSN(39)},
#endif
#if (MAX_GEOZONES > 29)
  {(VEGA_GEOZONE_1_ID + 29) , __SNAME("geozone_30")     , __SPTR(&System.gnss_state.geozones[29]), &System.gnss_state_res.geozones[29], sizeof(System.gnss_state.geozones[29]), BOOL_SYSTEM_T, __EGTSN(40)},
#endif
#if (MAX_GEOZONES > 30)
  {(VEGA_GEOZONE_1_ID + 30) , __SNAME("geozone_31")     , __SPTR(&System.gnss_state.geozones[30]), &System.gnss_state_res.geozones[30], sizeof(System.gnss_state.geozones[30]), BOOL_SYSTEM_T, __EGTSN(41)},
#endif
#if (MAX_GEOZONES > 31)
  {(VEGA_GEOZONE_1_ID + 31) , __SNAME("geozone_32")     , __SPTR(&System.gnss_state.geozones[31]), &System.gnss_state_res.geozones[31], sizeof(System.gnss_state.geozones[31]), BOOL_SYSTEM_T, __EGTSN(42)},
#endif
#if (MAX_GEOZONES > 32)
  {(VEGA_GEOZONE_1_ID + 32) , __SNAME("geozone_33")     , __SPTR(&System.gnss_state.geozones[32]), &System.gnss_state_res.geozones[32], sizeof(System.gnss_state.geozones[32]), BOOL_SYSTEM_T, __EGTSN(43)},
#endif
#if (MAX_GEOZONES > 33)
  {(VEGA_GEOZONE_1_ID + 33) , __SNAME("geozone_34")     , __SPTR(&System.gnss_state.geozones[33]), &System.gnss_state_res.geozones[33], sizeof(System.gnss_state.geozones[33]), BOOL_SYSTEM_T, __EGTSN(44)},
#endif
#if (MAX_GEOZONES > 34)
  {(VEGA_GEOZONE_1_ID + 34) , __SNAME("geozone_35")     , __SPTR(&System.gnss_state.geozones[34]), &System.gnss_state_res.geozones[34], sizeof(System.gnss_state.geozones[34]), BOOL_SYSTEM_T, __EGTSN(45)},
#endif
#if (MAX_GEOZONES > 35)
  {(VEGA_GEOZONE_1_ID + 35) , __SNAME("geozone_36")     , __SPTR(&System.gnss_state.geozones[35]), &System.gnss_state_res.geozones[35], sizeof(System.gnss_state.geozones[35]), BOOL_SYSTEM_T, __EGTSN(46)},
#endif
#if (MAX_GEOZONES > 36)
  {(VEGA_GEOZONE_1_ID + 36) , __SNAME("geozone_37")     , __SPTR(&System.gnss_state.geozones[36]), &System.gnss_state_res.geozones[36], sizeof(System.gnss_state.geozones[36]), BOOL_SYSTEM_T, __EGTSN(47)},
#endif
#if (MAX_GEOZONES > 37)
  {(VEGA_GEOZONE_1_ID + 37) , __SNAME("geozone_38")     , __SPTR(&System.gnss_state.geozones[37]), &System.gnss_state_res.geozones[37], sizeof(System.gnss_state.geozones[37]), BOOL_SYSTEM_T, __EGTSN(48)},
#endif
#if (MAX_GEOZONES > 38)
  {(VEGA_GEOZONE_1_ID + 38) , __SNAME("geozone_39")     , __SPTR(&System.gnss_state.geozones[38]), &System.gnss_state_res.geozones[38], sizeof(System.gnss_state.geozones[38]), BOOL_SYSTEM_T, __EGTSN(49)},
#endif
#if (MAX_GEOZONES > 39)
  {(VEGA_GEOZONE_1_ID + 39) , __SNAME("geozone_40")     , __SPTR(&System.gnss_state.geozones[39]), &System.gnss_state_res.geozones[39], sizeof(System.gnss_state.geozones[39]), BOOL_SYSTEM_T, __EGTSN(50)},
#endif
#if (MAX_GEOZONES > 40)
  {(VEGA_GEOZONE_1_ID + 40) , __SNAME("geozone_41")     , __SPTR(&System.gnss_state.geozones[40]), &System.gnss_state_res.geozones[40], sizeof(System.gnss_state.geozones[40]), BOOL_SYSTEM_T, __EGTSN(51)},
#endif
#if (MAX_GEOZONES > 41)
  {(VEGA_GEOZONE_1_ID + 41) , __SNAME("geozone_42")     , __SPTR(&System.gnss_state.geozones[41]), &System.gnss_state_res.geozones[41], sizeof(System.gnss_state.geozones[41]), BOOL_SYSTEM_T, __EGTSN(52)},
#endif
#if (MAX_GEOZONES > 42)
  {(VEGA_GEOZONE_1_ID + 42) , __SNAME("geozone_43")     , __SPTR(&System.gnss_state.geozones[42]), &System.gnss_state_res.geozones[42], sizeof(System.gnss_state.geozones[42]), BOOL_SYSTEM_T, __EGTSN(53)},
#endif
#if (MAX_GEOZONES > 43)
  {(VEGA_GEOZONE_1_ID + 43) , __SNAME("geozone_44")     , __SPTR(&System.gnss_state.geozones[43]), &System.gnss_state_res.geozones[43], sizeof(System.gnss_state.geozones[43]), BOOL_SYSTEM_T, __EGTSN(54)},
#endif
#if (MAX_GEOZONES > 44)
  {(VEGA_GEOZONE_1_ID + 44) , __SNAME("geozone_45")     , __SPTR(&System.gnss_state.geozones[44]), &System.gnss_state_res.geozones[44], sizeof(System.gnss_state.geozones[44]), BOOL_SYSTEM_T, __EGTSN(55)},
#endif
#if (MAX_GEOZONES > 45)
  {(VEGA_GEOZONE_1_ID + 45) , __SNAME("geozone_46")     , __SPTR(&System.gnss_state.geozones[45]), &System.gnss_state_res.geozones[45], sizeof(System.gnss_state.geozones[45]), BOOL_SYSTEM_T, __EGTSN(56)},
#endif
#if (MAX_GEOZONES > 46)
  {(VEGA_GEOZONE_1_ID + 46) , __SNAME("geozone_47")     , __SPTR(&System.gnss_state.geozones[46]), &System.gnss_state_res.geozones[46], sizeof(System.gnss_state.geozones[46]), BOOL_SYSTEM_T, __EGTSN(57)},
#endif
#if (MAX_GEOZONES > 47)
  {(VEGA_GEOZONE_1_ID + 47) , __SNAME("geozone_48")     , __SPTR(&System.gnss_state.geozones[47]), &System.gnss_state_res.geozones[47], sizeof(System.gnss_state.geozones[47]), BOOL_SYSTEM_T, __EGTSN(58)},
#endif
#if (MAX_GEOZONES > 48)
  {(VEGA_GEOZONE_1_ID + 48) , __SNAME("geozone_49")     , __SPTR(&System.gnss_state.geozones[48]), &System.gnss_state_res.geozones[48], sizeof(System.gnss_state.geozones[48]), BOOL_SYSTEM_T, __EGTSN(59)},
#endif
#if (MAX_GEOZONES > 49)
  {(VEGA_GEOZONE_1_ID + 49) , __SNAME("geozone_50")     , __SPTR(&System.gnss_state.geozones[49]), &System.gnss_state_res.geozones[49], sizeof(System.gnss_state.geozones[49]), BOOL_SYSTEM_T, __EGTSN(60)},
#endif
#if (MAX_GEOZONES > 50)
#error Нужно добавить сюда геозоны
#endif

  {VEGA_GPS_SPOOF_SENSOR, __SNAME("gps_spoof"),  __SPTR(&System.gnss_state.spoof), &System.gnss_state_res.spoof, sizeof(System.gnss_state.spoof), UINT8_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GPS_IS_ACTIVE,    __SNAME("gps_isact"),  __SPTR(&System.gnss_state.is_on), &System.gnss_state_res.is_on, sizeof(System.gnss_state.is_on), BOOL_SYSTEM_T,  __EGTSN(0xFFFF)},
  {VEGA_GALILEO_INVIEW,   __SNAME("gal_inview"), __SPTR(&System.gnss_state.galileo_satinfo.inview), &System.gnss_state_res.galileo_satinfo.inview, sizeof(System.gnss_state.galileo_satinfo.inview), UINT8_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_BEIDOU_INVIEW,    __SNAME("bei_inview"), __SPTR(&System.gnss_state.beidou_satinfo.inview),  &System.gnss_state_res.beidou_satinfo.inview,  sizeof(System.gnss_state.beidou_satinfo.inview),   UINT8_SYSTEM_T, __EGTSN(0xFFFF)},

  {VEGA_GNSS_RAW_STATE,   __SNAME("gnss_raw"),   __SPTR(&System.gnss_raw_state),             &System.gnss_raw_state,                 sizeof(System.gnss_raw_state),             ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_USED_SAT_PRN,     __SNAME("sat_prn"),    __SPTR(&System.gnss_state.sat_prn),         &System.gnss_state_res.sat_prn,         sizeof(System.gnss_state.sat_prn),         ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GPS_SAT_INFO,     __SNAME("gp_sinf"),    __SPTR(&System.gnss_state.gps_satinfo),     &System.gnss_state_res.gps_satinfo,     sizeof(System.gnss_state.gps_satinfo),     ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GLONASS_SAT_INFO, __SNAME("gl_sinf"),    __SPTR(&System.gnss_state.glonass_satinfo), &System.gnss_state_res.glonass_satinfo, sizeof(System.gnss_state.glonass_satinfo), ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GALILEO_SAT_INFO, __SNAME("ga_sinf"),    __SPTR(&System.gnss_state.galileo_satinfo), &System.gnss_state_res.galileo_satinfo, sizeof(System.gnss_state.galileo_satinfo), ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_BEIDOU_SAT_INFO,  __SNAME("be_sinf"),    __SPTR(&System.gnss_state.beidou_satinfo),  &System.gnss_state_res.beidou_satinfo,  sizeof(System.gnss_state.beidou_satinfo),  ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},

#if defined(INTERNAL_NRF_PRESENT)
  {VEGA_NRF_RELAY_ID            , "p300", &System.signal_state.nrf_state.relay_id           , &System.signal_state_res.nrf_state.relay_id           , sizeof(System.signal_state.nrf_state.relay_id)           , UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_DESIRED_RELAY_STATE , "p301", &System.signal_state.nrf_state.desired_relay_state, &System.signal_state_res.nrf_state.desired_relay_state, sizeof(System.signal_state.nrf_state.desired_relay_state), BOOL_SYSTEM_T , 0xffff},
  {VEGA_NRF_ACTUAL_RELAY_STATE  , "p302", &System.signal_state.nrf_state.actual_relay_state , &System.signal_state_res.nrf_state.actual_relay_state , sizeof(System.signal_state.nrf_state.actual_relay_state) , UINT8_SYSTEM_T , 0xffff},
  {VEGA_NRF_VISIBLE_MARKS_BF    , "p303" , &System.signal_state.nrf_state.visible_marks_bf   , &System.signal_state_res.nrf_state.visible_marks_bf   , sizeof(System.signal_state.nrf_state.visible_marks_bf)   , UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_BATTLOW_MARKS_BF    , "p304", &System.signal_state.nrf_state.battlow_marks_bf   , &System.signal_state_res.nrf_state.battlow_marks_bf   , sizeof(System.signal_state.nrf_state.battlow_marks_bf)   , UINT32_SYSTEM_T, 0xffff},
#if (MAX_INTERNAL_NRF_MARKS_COUNT <= 10)
  {VEGA_NRF_MARK_ID_1 , "p305" , &System.signal_state.nrf_state.marks_id[0], &System.signal_state_res.nrf_state.marks_id[0], sizeof(System.signal_state.nrf_state.marks_id[0]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_2 , "p306" , &System.signal_state.nrf_state.marks_id[1], &System.signal_state_res.nrf_state.marks_id[1], sizeof(System.signal_state.nrf_state.marks_id[1]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_3 , "p307" , &System.signal_state.nrf_state.marks_id[2], &System.signal_state_res.nrf_state.marks_id[2], sizeof(System.signal_state.nrf_state.marks_id[2]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_4 , "p308" , &System.signal_state.nrf_state.marks_id[3], &System.signal_state_res.nrf_state.marks_id[3], sizeof(System.signal_state.nrf_state.marks_id[3]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_5 , "p309" , &System.signal_state.nrf_state.marks_id[4], &System.signal_state_res.nrf_state.marks_id[4], sizeof(System.signal_state.nrf_state.marks_id[4]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_6 , "p310" , &System.signal_state.nrf_state.marks_id[5], &System.signal_state_res.nrf_state.marks_id[5], sizeof(System.signal_state.nrf_state.marks_id[5]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_7 , "p311" , &System.signal_state.nrf_state.marks_id[6], &System.signal_state_res.nrf_state.marks_id[6], sizeof(System.signal_state.nrf_state.marks_id[6]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_8 , "p312" , &System.signal_state.nrf_state.marks_id[7], &System.signal_state_res.nrf_state.marks_id[7], sizeof(System.signal_state.nrf_state.marks_id[7]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_9 , "p313" , &System.signal_state.nrf_state.marks_id[8], &System.signal_state_res.nrf_state.marks_id[8], sizeof(System.signal_state.nrf_state.marks_id[8]), UINT32_SYSTEM_T, 0xffff},
  {VEGA_NRF_MARK_ID_10, "p314", &System.signal_state.nrf_state.marks_id[9], &System.signal_state_res.nrf_state.marks_id[9], sizeof(System.signal_state.nrf_state.marks_id[9]), UINT32_SYSTEM_T, 0xffff},
#else
#error   MAX_INTERNAL_NRF_MARKS_COUNT != 10
#endif
  {VEGA_NRF_READY_FOR_COMMAND , "p315", &System.signal_state.nrf_state.ready_for_command, &System.signal_state_res.nrf_state.ready_for_command, sizeof(System.signal_state.nrf_state.ready_for_command), BOOL_SYSTEM_T, 0xffff},
#endif //INTERNAL_NRF_PRESENT

#if (MAX_ANALOG_INPUTS > 0)
  {(VEGA_ANALOG_INPUT_1 + 0)    , __SNAME("analog_in_1")    , __SPTR(&System.signal_state.analog_input[0]), &System.signal_state_res.analog_input[0], sizeof(System.signal_state.analog_input[0]), FLOAT_SYSTEM_T, __EGTSN(31)},
#endif
#if (MAX_ANALOG_INPUTS > 1)
  {(VEGA_ANALOG_INPUT_1 + 1)    , __SNAME("analog_in_2")    , __SPTR(&System.signal_state.analog_input[1]), &System.signal_state_res.analog_input[1], sizeof(System.signal_state.analog_input[1]), FLOAT_SYSTEM_T, __EGTSN(32)},
#endif
#if (MAX_ANALOG_INPUTS > 2)
  {(VEGA_ANALOG_INPUT_1 + 2)    , __SNAME("analog_in_3")    , __SPTR(&System.signal_state.analog_input[2]), &System.signal_state_res.analog_input[2], sizeof(System.signal_state.analog_input[2]), FLOAT_SYSTEM_T, __EGTSN(33)},
#endif
#if (MAX_ANALOG_INPUTS > 3)
  {(VEGA_ANALOG_INPUT_1 + 3)    , __SNAME("analog_in_4")    , __SPTR(&System.signal_state.analog_input[3]), &System.signal_state_res.analog_input[3], sizeof(System.signal_state.analog_input[3]), FLOAT_SYSTEM_T, __EGTSN(34)},
#endif
#if (MAX_ANALOG_INPUTS > 4)
  {(VEGA_ANALOG_INPUT_1 + 4)    , __SNAME("analog_in_5")    , __SPTR(&System.signal_state.analog_input[4]), &System.signal_state_res.analog_input[4], sizeof(System.signal_state.analog_input[4]), FLOAT_SYSTEM_T, __EGTSN(35)},
#endif
#if (MAX_ANALOG_INPUTS > 5)
  {(VEGA_ANALOG_INPUT_1 + 5)    , __SNAME("analog_in_6")    , __SPTR(&System.signal_state.analog_input[5]), &System.signal_state_res.analog_input[5], sizeof(System.signal_state.analog_input[5]), FLOAT_SYSTEM_T, __EGTSN(36)},
#endif
#if (MAX_ANALOG_INPUTS > 6)
  {(VEGA_ANALOG_INPUT_1 + 6)    , __SNAME("analog_in_7")    , __SPTR(&System.signal_state.analog_input[6]), &System.signal_state_res.analog_input[6], sizeof(System.signal_state.analog_input[6]), FLOAT_SYSTEM_T, __EGTSN(37)},
#endif
#if (MAX_ANALOG_INPUTS > 7)
  {(VEGA_ANALOG_INPUT_1 + 7)    , __SNAME("analog_in_8")    , __SPTR(&System.signal_state.analog_input[7]), &System.signal_state_res.analog_input[7], sizeof(System.signal_state.analog_input[7]), FLOAT_SYSTEM_T, __EGTSN(38)},
#endif
#if (MAX_ANALOG_INPUTS > 8)
  {(VEGA_ANALOG_INPUT_1 + 8)    , __SNAME("analog_in_9")    , __SPTR(&System.signal_state.analog_input[8]), &System.signal_state_res.analog_input[8], sizeof(System.signal_state.analog_input[8]), FLOAT_SYSTEM_T, __EGTSN(39)},
#endif
#if (MAX_ANALOG_INPUTS > 9)
  {(VEGA_ANALOG_INPUT_1 + 9)    , __SNAME("analog_in_10")    , __SPTR(&System.signal_state.analog_input[9]), &System.signal_state_res.analog_input[9], sizeof(System.signal_state.analog_input[9]), FLOAT_SYSTEM_T, __EGTSN(40)},
#endif
#if (MAX_ANALOG_INPUTS > 10)
#error Нужно добавить сюда аналоговые входы
#endif

#if (MAX_DIGITAL_INPUTS > 0)
  {VEGA_DIGITAL_INPUT_1 + 0    , __SNAME("digital_in_1")   , __SPTR(&System.signal_state.digital_input[0]), &System.signal_state_res.digital_input[0], sizeof(System.signal_state.digital_input[0]), BOOL_SYSTEM_T, __EGTSN(61)},
#endif
#if (MAX_DIGITAL_INPUTS > 1)
  {VEGA_DIGITAL_INPUT_1 + 1     , __SNAME("digital_in_2")   , __SPTR(&System.signal_state.digital_input[1]), &System.signal_state_res.digital_input[1], sizeof(System.signal_state.digital_input[1]), BOOL_SYSTEM_T, __EGTSN(62)},
#endif
#if (MAX_DIGITAL_INPUTS > 2)
  {VEGA_DIGITAL_INPUT_1 + 2     , __SNAME("digital_in_3")   , __SPTR(&System.signal_state.digital_input[2]), &System.signal_state_res.digital_input[2], sizeof(System.signal_state.digital_input[2]), BOOL_SYSTEM_T, __EGTSN(63)},
#endif
#if (MAX_DIGITAL_INPUTS > 3)
  {VEGA_DIGITAL_INPUT_1 + 3     , __SNAME("digital_in_4")   , __SPTR(&System.signal_state.digital_input[3]), &System.signal_state_res.digital_input[3], sizeof(System.signal_state.digital_input[3]), BOOL_SYSTEM_T, __EGTSN(64)},
#endif
#if (MAX_DIGITAL_INPUTS > 4)
  {VEGA_DIGITAL_INPUT_1 + 4     , __SNAME("digital_in_5")   , __SPTR(&System.signal_state.digital_input[4]), &System.signal_state_res.digital_input[4], sizeof(System.signal_state.digital_input[4]), BOOL_SYSTEM_T, __EGTSN(65)},
#endif
#if (MAX_DIGITAL_INPUTS > 5)
  {VEGA_DIGITAL_INPUT_1 + 5     , __SNAME("digital_in_6")   , __SPTR(&System.signal_state.digital_input[5]), &System.signal_state_res.digital_input[5], sizeof(System.signal_state.digital_input[5]), BOOL_SYSTEM_T, __EGTSN(66)},
#endif
#if (MAX_DIGITAL_INPUTS > 6)
  {VEGA_DIGITAL_INPUT_1 + 6     , __SNAME("digital_in_7")   , __SPTR(&System.signal_state.digital_input[6]), &System.signal_state_res.digital_input[6], sizeof(System.signal_state.digital_input[6]), BOOL_SYSTEM_T, __EGTSN(67)},
#endif
#if (MAX_DIGITAL_INPUTS > 7)
  {VEGA_DIGITAL_INPUT_1 + 7     , __SNAME("digital_in_8")   , __SPTR(&System.signal_state.digital_input[7]), &System.signal_state_res.digital_input[7], sizeof(System.signal_state.digital_input[7]), BOOL_SYSTEM_T, __EGTSN(68)},
#endif
#if (MAX_DIGITAL_INPUTS > 8)
  {VEGA_DIGITAL_INPUT_1 + 8     , __SNAME("digital_in_9")   , __SPTR(&System.signal_state.digital_input[8]), &System.signal_state_res.digital_input[8], sizeof(System.signal_state.digital_input[8]), BOOL_SYSTEM_T, __EGTSN(69)},
#endif
#if (MAX_DIGITAL_INPUTS > 9)
  {VEGA_DIGITAL_INPUT_1 + 9     , __SNAME("digital_in_10")  , __SPTR(&System.signal_state.digital_input[9]), &System.signal_state_res.digital_input[9], sizeof(System.signal_state.digital_input[9]), BOOL_SYSTEM_T, __EGTSN(70)},
#endif
#if (MAX_DIGITAL_INPUTS > 10)
#error Нужно добавить сюда цифровые входы
#endif

#if (MAX_DIGITAL_OUTPUTS > 0)
  {(VEGA_DIGITAL_OUTPUT_1+0), __SNAME("digital_out_1")  , __SPTR(&System.signal_state.digital_output[0]), &System.signal_state_res.digital_output[0], sizeof(System.signal_state.digital_output[0]), BOOL_SYSTEM_T, __EGTSN(81)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 1)
  {(VEGA_DIGITAL_OUTPUT_1+1), __SNAME("digital_out_2")  , __SPTR(&System.signal_state.digital_output[1]), &System.signal_state_res.digital_output[1], sizeof(System.signal_state.digital_output[1]), BOOL_SYSTEM_T, __EGTSN(82)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 2)
  {(VEGA_DIGITAL_OUTPUT_1+2), __SNAME("digital_out_3")  , __SPTR(&System.signal_state.digital_output[2]), &System.signal_state_res.digital_output[2], sizeof(System.signal_state.digital_output[2]), BOOL_SYSTEM_T, __EGTSN(83)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 3)
  {(VEGA_DIGITAL_OUTPUT_1+3), __SNAME("digital_out_4")  , __SPTR(&System.signal_state.digital_output[3]), &System.signal_state_res.digital_output[3], sizeof(System.signal_state.digital_output[3]), BOOL_SYSTEM_T, __EGTSN(84)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 4)
  {(VEGA_DIGITAL_OUTPUT_1+4), __SNAME("digital_out_5")  , __SPTR(&System.signal_state.digital_output[4]), &System.signal_state_res.digital_output[4], sizeof(System.signal_state.digital_output[4]), BOOL_SYSTEM_T, __EGTSN(85)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 5)
  {(VEGA_DIGITAL_OUTPUT_1+5), __SNAME("digital_out_6")  , __SPTR(&System.signal_state.digital_output[5]), &System.signal_state_res.digital_output[5], sizeof(System.signal_state.digital_output[5]), BOOL_SYSTEM_T, __EGTSN(86)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 6)
  {(VEGA_DIGITAL_OUTPUT_1+6), __SNAME("digital_out_7")  , __SPTR(&System.signal_state.digital_output[6]), &System.signal_state_res.digital_output[6], sizeof(System.signal_state.digital_output[6]), BOOL_SYSTEM_T, __EGTSN(87)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 7)
  {(VEGA_DIGITAL_OUTPUT_1+7), __SNAME("digital_out_8")  , __SPTR(&System.signal_state.digital_output[7]), &System.signal_state_res.digital_output[7], sizeof(System.signal_state.digital_output[7]), BOOL_SYSTEM_T, __EGTSN(88)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 8)
  {(VEGA_DIGITAL_OUTPUT_1+8), __SNAME("digital_out_9")  , __SPTR(&System.signal_state.digital_output[8]), &System.signal_state_res.digital_output[8], sizeof(System.signal_state.digital_output[8]), BOOL_SYSTEM_T, __EGTSN(89)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 9)
  {(VEGA_DIGITAL_OUTPUT_1+9), __SNAME("digital_out_10")  , __SPTR(&System.signal_state.digital_output[9]), &System.signal_state_res.digital_output[9], sizeof(System.signal_state.digital_output[9]), BOOL_SYSTEM_T, __EGTSN(90)},
#endif
#if (MAX_DIGITAL_OUTPUTS > 10)
  {(VEGA_DIGITAL_OUTPUT_1 + 10), __SNAME("digital_out_11")  , __SPTR(&System.signal_state.digital_output[10]), &System.signal_state_res.digital_output[10], sizeof(System.signal_state.digital_output[10]), BOOL_SYSTEM_T, 0xffff},
#endif
#if (MAX_DIGITAL_OUTPUTS > 11)
  {(VEGA_DIGITAL_OUTPUT_1 + 11), __SNAME("digital_out_12")  , __SPTR(&System.signal_state.digital_output[11]), &System.signal_state_res.digital_output[11], sizeof(System.signal_state.digital_output[11]), BOOL_SYSTEM_T, 0xffff},
#endif
#if (MAX_DIGITAL_OUTPUTS > 12)
#error Нужно добавить сюда цифровые выходы
#endif
#if (MAX_PULSE_INPUTS > 0)
  {VEGA_PULSE_INPUT_1 + 0      , __SNAME("pulse_input_1")  , __SPTR(&System.signal_state.pulse_input[0]), &System.signal_state_res.pulse_input[0], sizeof(System.signal_state.pulse_input[0]), UINT32_SYSTEM_T, __EGTSN(41)},
#endif
#if (MAX_PULSE_INPUTS > 1)
  {VEGA_PULSE_INPUT_1 + 1       , "pulse_input_2"  , &System.signal_state.pulse_input[1], &System.signal_state_res.pulse_input[1], sizeof(System.signal_state.pulse_input[1]), UINT32_SYSTEM_T, 42},
#endif
#if (MAX_PULSE_INPUTS > 2)
  {VEGA_PULSE_INPUT_1 + 2       , "pulse_input_3"  , &System.signal_state.pulse_input[2], &System.signal_state_res.pulse_input[2], sizeof(System.signal_state.pulse_input[2]), UINT32_SYSTEM_T, 43},
#endif
#if (MAX_PULSE_INPUTS > 3)
  {VEGA_PULSE_INPUT_1 + 3       , "pulse_input_4"  , &System.signal_state.pulse_input[3], &System.signal_state_res.pulse_input[3], sizeof(System.signal_state.pulse_input[3]), UINT32_SYSTEM_T, 44},
#endif
#if (MAX_PULSE_INPUTS > 4)
  {VEGA_PULSE_INPUT_1 + 4       , "pulse_input_5"  , &System.signal_state.pulse_input[4], &System.signal_state_res.pulse_input[4], sizeof(System.signal_state.pulse_input[4]), UINT32_SYSTEM_T, 45},
#endif
#if (MAX_PULSE_INPUTS > 5)
  {VEGA_PULSE_INPUT_1 + 5       , "pulse_input_6"  , &System.signal_state.pulse_input[5], &System.signal_state_res.pulse_input[5], sizeof(System.signal_state.pulse_input[5]), UINT32_SYSTEM_T, 46},
#endif
#if (MAX_PULSE_INPUTS > 6)
  {VEGA_PULSE_INPUT_1 + 6       , "pulse_input_7"  , &System.signal_state.pulse_input[6], &System.signal_state_res.pulse_input[6], sizeof(System.signal_state.pulse_input[6]), UINT32_SYSTEM_T, 47},
#endif
#if (MAX_PULSE_INPUTS > 7)
  {VEGA_PULSE_INPUT_1 + 7       , "pulse_input_8"  , &System.signal_state.pulse_input[7], &System.signal_state_res.pulse_input[7], sizeof(System.signal_state.pulse_input[7]), UINT32_SYSTEM_T, 48},
#endif
#if (MAX_PULSE_INPUTS > 8)
  {VEGA_PULSE_INPUT_1 + 8       , "pulse_input_9"  , &System.signal_state.pulse_input[8], &System.signal_state_res.pulse_input[8], sizeof(System.signal_state.pulse_input[8]), UINT32_SYSTEM_T, 49},
#endif
#if (MAX_PULSE_INPUTS > 9)
  {VEGA_PULSE_INPUT_1 + 9       , "pulse_input_10" , &System.signal_state.pulse_input[9], &System.signal_state_res.pulse_input[9], sizeof(System.signal_state.pulse_input[9]), UINT32_SYSTEM_T, 50},
#endif
#if (MAX_PULSE_INPUTS > 10)
#error Нужно добавить сюда импульсные входы
#endif

#if (MAX_FREQ_INPUTS > 0)
  {VEGA_FREQ_INPUT_1        , __SNAME("freq_input_1")   , __SPTR(&System.signal_state.freq_input[0]), &System.signal_state_res.freq_input[0], sizeof(System.signal_state.freq_input[0]), FLOAT_SYSTEM_T, __EGTSN(51)},
#endif
#if (MAX_FREQ_INPUTS > 1)
  {VEGA_FREQ_INPUT_1 + 1    , "freq_input_2"   , &System.signal_state.freq_input[1], &System.signal_state_res.freq_input[1], sizeof(System.signal_state.freq_input[1]), FLOAT_SYSTEM_T, 52},
#endif
#if (MAX_FREQ_INPUTS > 2)
  {VEGA_FREQ_INPUT_1 + 2    , "freq_input_3"   , &System.signal_state.freq_input[2], &System.signal_state_res.freq_input[2], sizeof(System.signal_state.freq_input[2]), FLOAT_SYSTEM_T, 53},
#endif
#if (MAX_FREQ_INPUTS > 3)
  {VEGA_FREQ_INPUT_1 + 3    , "freq_input_4"   , &System.signal_state.freq_input[3], &System.signal_state_res.freq_input[3], sizeof(System.signal_state.freq_input[3]), FLOAT_SYSTEM_T, 54},
#endif
#if (MAX_FREQ_INPUTS > 4)
  {VEGA_FREQ_INPUT_1 + 4    , "freq_input_5"   , &System.signal_state.freq_input[4], &System.signal_state_res.freq_input[4], sizeof(System.signal_state.freq_input[4]), FLOAT_SYSTEM_T, 55},
#endif
#if (MAX_FREQ_INPUTS > 5)
  {VEGA_FREQ_INPUT_1 + 5    , "freq_input_6"   , &System.signal_state.freq_input[5], &System.signal_state_res.freq_input[5], sizeof(System.signal_state.freq_input[5]), FLOAT_SYSTEM_T, 56},
#endif
#if (MAX_FREQ_INPUTS > 6)
  {VEGA_FREQ_INPUT_1 + 6    , "freq_input_7"   , &System.signal_state.freq_input[6], &System.signal_state_res.freq_input[6], sizeof(System.signal_state.freq_input[6]), FLOAT_SYSTEM_T, 57},
#endif
#if (MAX_FREQ_INPUTS > 7)
  {VEGA_FREQ_INPUT_1 + 7    , "freq_input_8"   , &System.signal_state.freq_input[7], &System.signal_state_res.freq_input[7], sizeof(System.signal_state.freq_input[7]), FLOAT_SYSTEM_T, 58},
#endif
#if (MAX_FREQ_INPUTS > 8)
  {VEGA_FREQ_INPUT_1 + 8    , "freq_input_9"   , &System.signal_state.freq_input[8], &System.signal_state_res.freq_input[8], sizeof(System.signal_state.freq_input[8]), FLOAT_SYSTEM_T, 59},
#endif
#if (MAX_FREQ_INPUTS > 9)
  {VEGA_FREQ_INPUT_1 + 9    , "freq_input_10"   , &System.signal_state.freq_input[9], &System.signal_state_res.freq_input[9], sizeof(System.signal_state.freq_input[9]), FLOAT_SYSTEM_T, 60},
#endif
#if (MAX_FREQ_INPUTS > 10)
#error Нужно добавить сюда частотные входы
#endif
#if (MAX_FREQ_OUTPUTS > 0)
  {(VEGA_FREQ_OUTPUT_1+0)   , __SNAME("freq_output_1")  , __SPTR(&System.signal_state.freq_output[0]), &System.signal_state_res.freq_output[0], sizeof(System.signal_state.freq_output[0]), UINT16_SYSTEM_T, __EGTSN(61)},
#endif
#if (MAX_FREQ_OUTPUTS > 1)
  {(VEGA_FREQ_OUTPUT_1+1)   , "freq_output_2"  , &System.signal_state.freq_output[1], &System.signal_state_res.freq_output[1], sizeof(System.signal_state.freq_output[1]), UINT16_SYSTEM_T, 62},
#endif
#if (MAX_FREQ_OUTPUTS > 2)
#error   Нужно добавить сюда частотные выходы
#endif

#if (MAX_DUTS > 0)
  {(VEGA_DUT_1+0)           , __SNAME("dut_1"), __SPTR(&System.signal_state.dut[0]), &System.signal_state_res.dut[0], sizeof(System.signal_state.dut[0]), FLOAT_SYSTEM_T, __EGTSN(71)},
#endif
#if (MAX_DUTS > 1)
  {(VEGA_DUT_1+1)           , __SNAME("dut_2"), __SPTR(&System.signal_state.dut[1]), &System.signal_state_res.dut[1], sizeof(System.signal_state.dut[1]), FLOAT_SYSTEM_T, __EGTSN(72)},
#endif
#if (MAX_DUTS > 2)
  {(VEGA_DUT_1+2)           , __SNAME("dut_3"), __SPTR(&System.signal_state.dut[2]), &System.signal_state_res.dut[2], sizeof(System.signal_state.dut[2]), FLOAT_SYSTEM_T, __EGTSN(73)},
#endif
#if (MAX_DUTS > 3)
  {(VEGA_DUT_1+3)           , __SNAME("dut_4"), __SPTR(&System.signal_state.dut[3]), &System.signal_state_res.dut[3], sizeof(System.signal_state.dut[3]), FLOAT_SYSTEM_T, __EGTSN(74)},
#endif
#if (MAX_DUTS > 4)
  {(VEGA_DUT_1+4)           , __SNAME("dut_5"), __SPTR(&System.signal_state.dut[4]), &System.signal_state_res.dut[4], sizeof(System.signal_state.dut[4]), FLOAT_SYSTEM_T, __EGTSN(75)},
#endif
#if (MAX_DUTS > 5)
#error   Нужно добавить сюда ДУТы
#endif

#if (MAX_DUTS > 0)
  {(VEGA_DUT_TEMP_1+0)      , __SNAME("tdut_1"), __SPTR(&System.signal_state.dut_temp[0]), &System.signal_state_res.dut_temp[0], sizeof(System.signal_state.dut_temp[0]), INT8_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if (MAX_DUTS > 1)
  {(VEGA_DUT_TEMP_1+1)      , __SNAME("tdut_2"), __SPTR(&System.signal_state.dut_temp[1]), &System.signal_state_res.dut_temp[1], sizeof(System.signal_state.dut_temp[1]), INT8_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if (MAX_DUTS > 2)
  {(VEGA_DUT_TEMP_1+2)      , __SNAME("tdut_3"), __SPTR(&System.signal_state.dut_temp[2]), &System.signal_state_res.dut_temp[2], sizeof(System.signal_state.dut_temp[2]), INT8_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if (MAX_DUTS > 3)
  {(VEGA_DUT_TEMP_1+3)      , __SNAME("tdut_4"), __SPTR(&System.signal_state.dut_temp[3]), &System.signal_state_res.dut_temp[3], sizeof(System.signal_state.dut_temp[3]), INT8_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if (MAX_DUTS > 4)
  {(VEGA_DUT_TEMP_1+4)      , __SNAME("tdut_5"), __SPTR(&System.signal_state.dut_temp[4]), &System.signal_state_res.dut_temp[4], sizeof(System.signal_state.dut_temp[4]), INT8_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#if (MAX_DUTS > 5)
#error   Нужно добавить сюда ДУТы
#endif

#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
  {VEGA_TCM_DTC_LIST_SENSOR,  "tcm_dtc",        &System.signal_state.dtc_list[1], &System.signal_state_res.dtc_list[1], sizeof(System.signal_state.dtc_list[1]), STRING_SYSTEM_T, 0xffff},
  {VEGA_YADRIVE_ALARM_SENSOR, "yadrive_alarm",  &System.signal_state.alarm, &System.signal_state_res.alarm,  sizeof(System.signal_state.alarm),  UINT8_SYSTEM_T, 0xffff},
  {VEGA_UNAUTHORIZED_START,   "ustart",         &System.signal_state.unauthorized_start_sensor, &System.signal_state_res.unauthorized_start_sensor,  sizeof(System.signal_state.unauthorized_start_sensor),  UINT8_SYSTEM_T, 0xffff},
  {VEGA_CLS_STATE_SENSOR,     "cls_state",      &System.signal_state.cls_state, &System.signal_state_res.cls_state,  sizeof(System.signal_state.cls_state),  UINT8_SYSTEM_T, 0xffff},
  {VEGA_WINDOWS_POSITION_SENSOR, "windows_pos", &System.signal_state.windows_position, &System.signal_state_res.windows_position,  sizeof(System.signal_state.windows_position),  UINT8_SYSTEM_T, 0xffff},
  {VEGA_HANDBRAKE_DRIVE_SENSOR, "hbrake_drive", &System.signal_state.drive_on_handbrake, &System.signal_state_res.drive_on_handbrake,  sizeof(System.signal_state.drive_on_handbrake),  BOOL_SYSTEM_T, 0xffff},
  {AUDIO_FILE_SENSOR,         "aud_file",       &System.signal_state.current_audio_file, &System.signal_state_res.current_audio_file, sizeof(System.signal_state.current_audio_file),       UINT16_SYSTEM_T, 0xffff},
  {AUDIO_SCENARIO_SENSOR,     "aud_scenario",   &System.signal_state.current_audio_script, &System.signal_state_res.current_audio_script, sizeof(System.signal_state.current_audio_script), UINT8_SYSTEM_T, 0xffff},
  {VEGA_VIN_SENSOR,           "vin",            &System.signal_state.vin_sensor, &System.signal_state_res.vin_sensor, sizeof(System.signal_state.vin_sensor),    STRING_SYSTEM_T, 0xffff},
  {VEGA_ECM_DTC_LIST_SENSOR,  "ecm_dtc",        &System.signal_state.dtc_list[0], &System.signal_state_res.dtc_list[0], sizeof(System.signal_state.dtc_list[0]),      STRING_SYSTEM_T, 0xffff},
  {VEGA_CAN_EMERG_LIGHT_MODE, "em_light",       &System.signal_state.emergency_lights, &System.signal_state_res.emergency_lights, sizeof(System.signal_state.emergency_lights),   BOOL_SYSTEM_T, 0xffff},
  {VEGA_CAN_ECO_MODE,         "eco_mode",       &System.signal_state.eco_mode, &System.signal_state_res.eco_mode, sizeof(System.signal_state.eco_mode),      BOOL_SYSTEM_T, 0xffff},
  {VEGA_CAN_WASHER_LIQUID,    "washer_liquid",  &System.signal_state.washer_liquid, &System.signal_state_res.washer_liquid, sizeof(System.signal_state.washer_liquid), BOOL_SYSTEM_T, 0xffff},
  {VEGA_LAUNCH_SENSOR,        "launch_sens",    &System.signal_state.launch_sensor, &System.signal_state_res.launch_sensor, sizeof(System.signal_state.launch_sensor), BOOL_SYSTEM_T, 0xffff},
  {VEGA_DRIFT_SENSOR,         "drift_sens",     &System.signal_state.drift_sensor, &System.signal_state_res.drift_sensor,  sizeof(System.signal_state.drift_sensor),  BOOL_SYSTEM_T, 0xffff},
#endif //YANDEX_EXTENDED_SENSORS_PRESENT

#if (MAX_DALLAS_TEMP_SENSORS > 0)
  {(VEGA_EXT_TEMP_SENSOR_1+0), __SNAME("ext_temp_1")    , __SPTR(&System.signal_state.ext_temp_sensor[0]), &System.signal_state_res.ext_temp_sensor[0], sizeof(System.signal_state.ext_temp_sensor[0]), FLOAT_SYSTEM_T, __EGTSN(91)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 1)
  {(VEGA_EXT_TEMP_SENSOR_1+1), __SNAME("ext_temp_2")    , __SPTR(&System.signal_state.ext_temp_sensor[1]), &System.signal_state_res.ext_temp_sensor[1], sizeof(System.signal_state.ext_temp_sensor[1]), FLOAT_SYSTEM_T, __EGTSN(92)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 2)
  {(VEGA_EXT_TEMP_SENSOR_1+2), __SNAME("ext_temp_3")    , __SPTR(&System.signal_state.ext_temp_sensor[2]), &System.signal_state_res.ext_temp_sensor[2], sizeof(System.signal_state.ext_temp_sensor[2]), FLOAT_SYSTEM_T, __EGTSN(93)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 3)
  {(VEGA_EXT_TEMP_SENSOR_1+3), __SNAME("ext_temp_4")    , __SPTR(&System.signal_state.ext_temp_sensor[3]), &System.signal_state_res.ext_temp_sensor[3], sizeof(System.signal_state.ext_temp_sensor[3]), FLOAT_SYSTEM_T, __EGTSN(94)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 4)
  {(VEGA_EXT_TEMP_SENSOR_1+4), __SNAME("ext_temp_5")    , __SPTR(&System.signal_state.ext_temp_sensor[4]), &System.signal_state_res.ext_temp_sensor[4], sizeof(System.signal_state.ext_temp_sensor[4]), FLOAT_SYSTEM_T, __EGTSN(95)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 5)
  {(VEGA_EXT_TEMP_SENSOR_1+5), __SNAME("ext_temp_6")    , __SPTR(&System.signal_state.ext_temp_sensor[5]), &System.signal_state_res.ext_temp_sensor[5], sizeof(System.signal_state.ext_temp_sensor[5]), FLOAT_SYSTEM_T, __EGTSN(96)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 6)
  {(VEGA_EXT_TEMP_SENSOR_1+6), __SNAME("ext_temp_7")    , __SPTR(&System.signal_state.ext_temp_sensor[6]), &System.signal_state_res.ext_temp_sensor[6], sizeof(System.signal_state.ext_temp_sensor[6]), FLOAT_SYSTEM_T, __EGTSN(97)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 7)
  {(VEGA_EXT_TEMP_SENSOR_1+7), __SNAME("ext_temp_8")    , __SPTR(&System.signal_state.ext_temp_sensor[7]), &System.signal_state_res.ext_temp_sensor[7], sizeof(System.signal_state.ext_temp_sensor[7]), FLOAT_SYSTEM_T, __EGTSN(98)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 8)
  {(VEGA_EXT_TEMP_SENSOR_1+8), __SNAME("ext_temp_9")    , __SPTR(&System.signal_state.ext_temp_sensor[8]), &System.signal_state_res.ext_temp_sensor[8], sizeof(System.signal_state.ext_temp_sensor[8]), FLOAT_SYSTEM_T, __EGTSN(99)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 9)
  {(VEGA_EXT_TEMP_SENSOR_1+9), __SNAME("ext_temp_10")   , __SPTR(&System.signal_state.ext_temp_sensor[9]), &System.signal_state_res.ext_temp_sensor[9], sizeof(System.signal_state.ext_temp_sensor[9]), FLOAT_SYSTEM_T, __EGTSN(100)},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 10)
#error   Нужно добавить сюда температурные датчики
#endif
#if (MAX_TAMPERS > 0)
  {VEGA_TAMPER_1             , __SNAME("tamper_1")      , __SPTR(&System.signal_state.tamper[0]), &System.signal_state_res.tamper[0], sizeof(System.signal_state.tamper[0]), BOOL_SYSTEM_T, __EGTSN(91)},
#endif
#if (MAX_TAMPERS > 1)
  {VEGA_TAMPER_1 + 1         , __SNAME("tamper_2")      , __SPTR(&System.signal_state.tamper[1]), &System.signal_state_res.tamper[1], sizeof(System.signal_state.tamper[1]), BOOL_SYSTEM_T, __EGTSN(92)},
#endif
#if (MAX_TAMPERS > 2)
  {VEGA_TAMPER_1 + 2         , __SNAME("tamper_3")      , __SPTR(&System.signal_state.tamper[2]), &System.signal_state_res.tamper[2], sizeof(System.signal_state.tamper[2]), BOOL_SYSTEM_T, __EGTSN(93)},
#endif
#if (MAX_TAMPERS > 3)//2
#error   Нужно добавить сюда тамперы
#endif

  {VEGA_IGNITION            , __SNAME("ign")            , __SPTR(&System.signal_state.ignition), &System.signal_state_res.ignition, sizeof(System.signal_state.ignition), BOOL_SYSTEM_T, __EGTSN(96)},

#ifdef GSENSOR_PRESENT
  {VEGA_GSENSOR_AXIS_X      , __SNAME("gsensor_axis_x") , __SPTR(&System.signal_state.gsensor_axis_x), &System.signal_state_res.gsensor_axis_x, sizeof(System.signal_state.gsensor_axis_x), FLOAT_SYSTEM_T, __EGTSN(112)},
  {VEGA_GSENSOR_AXIS_Y      , __SNAME("gsensor_axis_y") , __SPTR(&System.signal_state.gsensor_axis_y), &System.signal_state_res.gsensor_axis_y, sizeof(System.signal_state.gsensor_axis_y), FLOAT_SYSTEM_T, __EGTSN(113)},
  {VEGA_GSENSOR_AXIS_Z      , __SNAME("gsensor_axis_z") , __SPTR(&System.signal_state.gsensor_axis_z), &System.signal_state_res.gsensor_axis_z, sizeof(System.signal_state.gsensor_axis_z), FLOAT_SYSTEM_T, __EGTSN(114)},
  //{VEGA_GREEN_DRIVING       , __SNAME("green_driving")  , __SPTR(&System.signal_state.green_driving), &System.signal_state_res.green_driving, sizeof(System.signal_state.green_driving), FLOAT_SYSTEM_T, __EGTSN(115)},
  //{VEGA_CRASH               , __SNAME("crash")          , __SPTR(&System.signal_state.crash_sensor), &System.signal_state_res.crash_sensor, sizeof(System.signal_state.crash_sensor), BOOL_SYSTEM_T, __EGTSN(97)},
  {VEGA_EVACUATION          , __SNAME("evacuation")     , __SPTR(&System.signal_state.evacuation_sensor), &System.signal_state_res.evacuation_sensor, sizeof(System.signal_state.evacuation_sensor), BOOL_SYSTEM_T, __EGTSN(98)},
  {VEGA_GSENSOR_MOVE_SENSOR , __SNAME("gsensor_move")   , __SPTR(&System.signal_state.gsensor_move_sensor), &System.signal_state_res.gsensor_move_sensor, sizeof(System.signal_state.gsensor_move_sensor), BOOL_SYSTEM_T, __EGTSN(99)},
#endif
  {VEGA_INT_TEMP            , __SNAME("int_temp")       , __SPTR(&System.signal_state.internal_temp), &System.signal_state_res.internal_temp, sizeof(System.signal_state.internal_temp), FLOAT_SYSTEM_T, __EGTSN(116)},

#ifdef ALARM_BUTTON_PRESENT
  {VEGA_ALARM_BUTTON        , __SNAME("alarm")          , __SPTR(&System.signal_state.alarm_button), &System.signal_state_res.alarm_button, sizeof(System.signal_state.alarm_button), BOOL_SYSTEM_T, __EGTSN(100)},
#endif
  {VEGA_POWER_VOLTAGE       , __SNAME("ext_voltage")    , __SPTR(&System.signal_state.external_voltage), &System.signal_state_res.external_voltage, sizeof(System.signal_state.external_voltage), FLOAT_SYSTEM_T, __EGTSN(117)},

#ifdef INTERNAL_AKB_PRESENT
  {VEGA_ACC_VOLTAGE         , __SNAME("acc_voltage")    , __SPTR(&System.signal_state.internal_acc_voltage), &System.signal_state_res.internal_acc_voltage, sizeof(System.signal_state.internal_acc_voltage), FLOAT_SYSTEM_T, __EGTSN(118)},
#endif
#ifdef INTERNAL_AKB_CHARGE_LEVEL_PRESENT
  {VEGA_ACC_CHARGE          , __SNAME("acc_charge")     ,  __SPTR(&System.signal_state.internal_acc_charge_level), &System.signal_state_res.internal_acc_charge_level, sizeof(System.signal_state.internal_acc_charge_level), UINT8_SYSTEM_T, __EGTSN(119)},
#endif
#ifdef AUTORIZATION_PRESENT
  {VEGA_AUTORIZED           , __SNAME("autorization")   ,  __SPTR(&System.signal_state.autorization_sensor), &System.signal_state_res.autorization_sensor, sizeof(System.signal_state.autorization_sensor), BOOL_SYSTEM_T, __EGTSN(101)},
  {VEGA_AUTORIZED_KEY       , __SNAME("autorized_key")  ,  __SPTR(&System.signal_state.current_autorized_key), &System.signal_state_res.current_autorized_key, sizeof(System.signal_state.current_autorized_key), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#ifdef MOTOHOURS_PRESENT
  {VEGA_MOTOHOURS           , __SNAME("motohours")      , __SPTR(&System.signal_state.motohours), &System.signal_state_res.motohours, sizeof(System.signal_state.motohours), FLOAT_SYSTEM_T, __EGTSN(120)},
#endif
#if defined(ONEWIRE_PRESENT)
  {VEGA_OW_CURRENT_KEY      , __SNAME("curr_key")       , __SPTR(&System.signal_state.current_ow_key), &System.signal_state_res.current_ow_key, sizeof(System.signal_state.current_ow_key), STRING_SYSTEM_T, __EGTSN(0xFFFF)},
#endif //ONEWIRE_PRESENT

// Плата расширения
#if defined(BR_PRESENT)
  {(VEGA_EXT_BR_STATUS)         , __SNAME("br_ok")        , __SPTR(&System.signal_state.is_br_ok) , &System.signal_state_res.is_br_ok , sizeof(System.signal_state.is_br_ok) , UINT8_SYSTEM_T,  __EGTSN(0xffff)},
  #if (MAX_EXT_MF_INPUTS <= 15)
  {(VEGA_EXT_ANALOG_INPUT_1)    , __SNAME("ex_an_in_1")   , __SPTR(&System.signal_state.ext_analog_input[0]) , &System.signal_state_res.ext_analog_input[0] , sizeof(System.signal_state.ext_analog_input[0]) , FLOAT_SYSTEM_T,  __EGTSN(186)},
  {(VEGA_EXT_ANALOG_INPUT_1+1)  , __SNAME("ex_an_in_2")   , __SPTR(&System.signal_state.ext_analog_input[1]) , &System.signal_state_res.ext_analog_input[1] , sizeof(System.signal_state.ext_analog_input[1]) , FLOAT_SYSTEM_T,  __EGTSN(187)},
  {(VEGA_EXT_ANALOG_INPUT_1+2)  , __SNAME("ex_an_in_3")   , __SPTR(&System.signal_state.ext_analog_input[2]) , &System.signal_state_res.ext_analog_input[2] , sizeof(System.signal_state.ext_analog_input[2]) , FLOAT_SYSTEM_T,  __EGTSN(188)},
  {(VEGA_EXT_ANALOG_INPUT_1+3)  , __SNAME("ex_an_in_4")   , __SPTR(&System.signal_state.ext_analog_input[3]) , &System.signal_state_res.ext_analog_input[3] , sizeof(System.signal_state.ext_analog_input[3]) , FLOAT_SYSTEM_T,  __EGTSN(189)},
  {(VEGA_EXT_ANALOG_INPUT_1+4)  , __SNAME("ex_an_in_5")   , __SPTR(&System.signal_state.ext_analog_input[4]) , &System.signal_state_res.ext_analog_input[4] , sizeof(System.signal_state.ext_analog_input[4]) , FLOAT_SYSTEM_T,  __EGTSN(190)},
  {(VEGA_EXT_ANALOG_INPUT_1+5)  , __SNAME("ex_an_in_6")   , __SPTR(&System.signal_state.ext_analog_input[5]) , &System.signal_state_res.ext_analog_input[5] , sizeof(System.signal_state.ext_analog_input[5]) , FLOAT_SYSTEM_T,  __EGTSN(191)},
  {(VEGA_EXT_ANALOG_INPUT_1+6)  , __SNAME("ex_an_in_7")   , __SPTR(&System.signal_state.ext_analog_input[6]) , &System.signal_state_res.ext_analog_input[6] , sizeof(System.signal_state.ext_analog_input[6]) , FLOAT_SYSTEM_T,  __EGTSN(192)},
  {(VEGA_EXT_ANALOG_INPUT_1+7)  , __SNAME("ex_an_in_8")   , __SPTR(&System.signal_state.ext_analog_input[7]) , &System.signal_state_res.ext_analog_input[7] , sizeof(System.signal_state.ext_analog_input[7]) , FLOAT_SYSTEM_T,  __EGTSN(193)},
  {(VEGA_EXT_ANALOG_INPUT_1+8)  , __SNAME("ex_an_in_9")   , __SPTR(&System.signal_state.ext_analog_input[8]) , &System.signal_state_res.ext_analog_input[8] , sizeof(System.signal_state.ext_analog_input[8]) , FLOAT_SYSTEM_T,  __EGTSN(194)},
  {(VEGA_EXT_ANALOG_INPUT_1+9)  , __SNAME("ex_an_in_10")  , __SPTR(&System.signal_state.ext_analog_input[9]) , &System.signal_state_res.ext_analog_input[9] , sizeof(System.signal_state.ext_analog_input[9]) , FLOAT_SYSTEM_T,  __EGTSN(195)},
  {(VEGA_EXT_ANALOG_INPUT_1+10) , __SNAME("ex_an_in_11")  , __SPTR(&System.signal_state.ext_analog_input[10]), &System.signal_state_res.ext_analog_input[10], sizeof(System.signal_state.ext_analog_input[10]), FLOAT_SYSTEM_T,  __EGTSN(196)},
  {(VEGA_EXT_ANALOG_INPUT_1+11) , __SNAME("ex_an_in_12")  , __SPTR(&System.signal_state.ext_analog_input[11]), &System.signal_state_res.ext_analog_input[11], sizeof(System.signal_state.ext_analog_input[11]), FLOAT_SYSTEM_T,  __EGTSN(197)},
  {(VEGA_EXT_ANALOG_INPUT_1+12) , __SNAME("ex_an_in_13")  , __SPTR(&System.signal_state.ext_analog_input[12]), &System.signal_state_res.ext_analog_input[12], sizeof(System.signal_state.ext_analog_input[12]), FLOAT_SYSTEM_T,  __EGTSN(198)},
  {(VEGA_EXT_ANALOG_INPUT_1+13) , __SNAME("ex_an_in_14")  , __SPTR(&System.signal_state.ext_analog_input[13]), &System.signal_state_res.ext_analog_input[13], sizeof(System.signal_state.ext_analog_input[13]), FLOAT_SYSTEM_T,  __EGTSN(199)},
  {(VEGA_EXT_ANALOG_INPUT_1+14) , __SNAME("ex_an_in_15")  , __SPTR(&System.signal_state.ext_analog_input[14]), &System.signal_state_res.ext_analog_input[14], sizeof(System.signal_state.ext_analog_input[14]), FLOAT_SYSTEM_T,  __EGTSN(200)},

  {(VEGA_EXT_FREQ_INPUT_1)      , __SNAME("ex_fr_in_1")   , __SPTR(&System.signal_state.ext_freq_input[0]) , &System.signal_state_res.ext_freq_input[0] , sizeof(System.signal_state.ext_freq_input[0]) , FLOAT_SYSTEM_T,  __EGTSN(201)},
  {(VEGA_EXT_FREQ_INPUT_1+1)    , __SNAME("ex_fr_in_2")   , __SPTR(&System.signal_state.ext_freq_input[1]) , &System.signal_state_res.ext_freq_input[1] , sizeof(System.signal_state.ext_freq_input[1]) , FLOAT_SYSTEM_T,  __EGTSN(202)},
  {(VEGA_EXT_FREQ_INPUT_1+2)    , __SNAME("ex_fr_in_3")   , __SPTR(&System.signal_state.ext_freq_input[2]) , &System.signal_state_res.ext_freq_input[2] , sizeof(System.signal_state.ext_freq_input[2]) , FLOAT_SYSTEM_T,  __EGTSN(203)},
  {(VEGA_EXT_FREQ_INPUT_1+3)    , __SNAME("ex_fr_in_4")   , __SPTR(&System.signal_state.ext_freq_input[3]) , &System.signal_state_res.ext_freq_input[3] , sizeof(System.signal_state.ext_freq_input[3]) , FLOAT_SYSTEM_T,  __EGTSN(204)},
  {(VEGA_EXT_FREQ_INPUT_1+4)    , __SNAME("ex_fr_in_5")   , __SPTR(&System.signal_state.ext_freq_input[4]) , &System.signal_state_res.ext_freq_input[4] , sizeof(System.signal_state.ext_freq_input[4]) , FLOAT_SYSTEM_T,  __EGTSN(205)},
  {(VEGA_EXT_FREQ_INPUT_1+5)    , __SNAME("ex_fr_in_6")   , __SPTR(&System.signal_state.ext_freq_input[5]) , &System.signal_state_res.ext_freq_input[5] , sizeof(System.signal_state.ext_freq_input[5]) , FLOAT_SYSTEM_T,  __EGTSN(206)},
  {(VEGA_EXT_FREQ_INPUT_1+6)    , __SNAME("ex_fr_in_7")   , __SPTR(&System.signal_state.ext_freq_input[6]) , &System.signal_state_res.ext_freq_input[6] , sizeof(System.signal_state.ext_freq_input[6]) , FLOAT_SYSTEM_T,  __EGTSN(207)},
  {(VEGA_EXT_FREQ_INPUT_1+7)    , __SNAME("ex_fr_in_8")   , __SPTR(&System.signal_state.ext_freq_input[7]) , &System.signal_state_res.ext_freq_input[7] , sizeof(System.signal_state.ext_freq_input[7]) , FLOAT_SYSTEM_T,  __EGTSN(208)},
  {(VEGA_EXT_FREQ_INPUT_1+8)    , __SNAME("ex_fr_in_9")   , __SPTR(&System.signal_state.ext_freq_input[8]) , &System.signal_state_res.ext_freq_input[8] , sizeof(System.signal_state.ext_freq_input[8]) , FLOAT_SYSTEM_T,  __EGTSN(209)},
  {(VEGA_EXT_FREQ_INPUT_1+9)    , __SNAME("ex_fr_in_10")  , __SPTR(&System.signal_state.ext_freq_input[9]) , &System.signal_state_res.ext_freq_input[9] , sizeof(System.signal_state.ext_freq_input[9]) , FLOAT_SYSTEM_T,  __EGTSN(210)},
  {(VEGA_EXT_FREQ_INPUT_1+10)   , __SNAME("ex_fr_in_11")  , __SPTR(&System.signal_state.ext_freq_input[10]), &System.signal_state_res.ext_freq_input[10], sizeof(System.signal_state.ext_freq_input[10]), FLOAT_SYSTEM_T,  __EGTSN(211)},
  {(VEGA_EXT_FREQ_INPUT_1+11)   , __SNAME("ex_fr_in_12")  , __SPTR(&System.signal_state.ext_freq_input[11]), &System.signal_state_res.ext_freq_input[11], sizeof(System.signal_state.ext_freq_input[11]), FLOAT_SYSTEM_T,  __EGTSN(212)},
  {(VEGA_EXT_FREQ_INPUT_1+12)   , __SNAME("ex_fr_in_13")  , __SPTR(&System.signal_state.ext_freq_input[12]), &System.signal_state_res.ext_freq_input[12], sizeof(System.signal_state.ext_freq_input[12]), FLOAT_SYSTEM_T,  __EGTSN(213)},
  {(VEGA_EXT_FREQ_INPUT_1+13)   , __SNAME("ex_fr_in_14")  , __SPTR(&System.signal_state.ext_freq_input[13]), &System.signal_state_res.ext_freq_input[13], sizeof(System.signal_state.ext_freq_input[13]), FLOAT_SYSTEM_T,  __EGTSN(214)},
  {(VEGA_EXT_FREQ_INPUT_1+14)   , __SNAME("ex_fr_in_15")  , __SPTR(&System.signal_state.ext_freq_input[14]), &System.signal_state_res.ext_freq_input[14], sizeof(System.signal_state.ext_freq_input[14]), FLOAT_SYSTEM_T,  __EGTSN(215)},

  {(VEGA_EXT_PULSE_INPUT_1)     , __SNAME("ex_pulse_in_1")  , __SPTR(&System.signal_state.ext_pulse_input[0]) , &System.signal_state_res.ext_pulse_input[0] , sizeof(System.signal_state.ext_pulse_input[0]) , UINT32_SYSTEM_T,  __EGTSN(216)},
  {(VEGA_EXT_PULSE_INPUT_1+1)   , __SNAME("ex_pulse_in_2")  , __SPTR(&System.signal_state.ext_pulse_input[1]) , &System.signal_state_res.ext_pulse_input[1] , sizeof(System.signal_state.ext_pulse_input[1]) , UINT32_SYSTEM_T,  __EGTSN(217)},
  {(VEGA_EXT_PULSE_INPUT_1+2)   , __SNAME("ex_pulse_in_3")  , __SPTR(&System.signal_state.ext_pulse_input[2]) , &System.signal_state_res.ext_pulse_input[2] , sizeof(System.signal_state.ext_pulse_input[2]) , UINT32_SYSTEM_T,  __EGTSN(218)},
  {(VEGA_EXT_PULSE_INPUT_1+3)   , __SNAME("ex_pulse_in_4")  , __SPTR(&System.signal_state.ext_pulse_input[3]) , &System.signal_state_res.ext_pulse_input[3] , sizeof(System.signal_state.ext_pulse_input[3]) , UINT32_SYSTEM_T,  __EGTSN(219)},
  {(VEGA_EXT_PULSE_INPUT_1+4)   , __SNAME("ex_pulse_in_5")  , __SPTR(&System.signal_state.ext_pulse_input[4]) , &System.signal_state_res.ext_pulse_input[4] , sizeof(System.signal_state.ext_pulse_input[4]) , UINT32_SYSTEM_T,  __EGTSN(220)},
  {(VEGA_EXT_PULSE_INPUT_1+5)   , __SNAME("ex_pulse_in_6")  , __SPTR(&System.signal_state.ext_pulse_input[5]) , &System.signal_state_res.ext_pulse_input[5] , sizeof(System.signal_state.ext_pulse_input[5]) , UINT32_SYSTEM_T,  __EGTSN(221)},
  {(VEGA_EXT_PULSE_INPUT_1+6)   , __SNAME("ex_pulse_in_7")  , __SPTR(&System.signal_state.ext_pulse_input[6]) , &System.signal_state_res.ext_pulse_input[6] , sizeof(System.signal_state.ext_pulse_input[6]) , UINT32_SYSTEM_T,  __EGTSN(222)},
  {(VEGA_EXT_PULSE_INPUT_1+7)   , __SNAME("ex_pulse_in_8")  , __SPTR(&System.signal_state.ext_pulse_input[7]) , &System.signal_state_res.ext_pulse_input[7] , sizeof(System.signal_state.ext_pulse_input[7]) , UINT32_SYSTEM_T,  __EGTSN(223)},
  {(VEGA_EXT_PULSE_INPUT_1+8)   , __SNAME("ex_pulse_in_9")  , __SPTR(&System.signal_state.ext_pulse_input[8]) , &System.signal_state_res.ext_pulse_input[8] , sizeof(System.signal_state.ext_pulse_input[8]) , UINT32_SYSTEM_T,  __EGTSN(224)},
  {(VEGA_EXT_PULSE_INPUT_1+9)   , __SNAME("ex_pulse_in_10") , __SPTR(&System.signal_state.ext_pulse_input[9]) , &System.signal_state_res.ext_pulse_input[9] , sizeof(System.signal_state.ext_pulse_input[9]) , UINT32_SYSTEM_T,  __EGTSN(225)},
  {(VEGA_EXT_PULSE_INPUT_1+10)  , __SNAME("ex_pulse_in_11") , __SPTR(&System.signal_state.ext_pulse_input[10]), &System.signal_state_res.ext_pulse_input[10], sizeof(System.signal_state.ext_pulse_input[10]), UINT32_SYSTEM_T,  __EGTSN(226)},
  {(VEGA_EXT_PULSE_INPUT_1+11)  , __SNAME("ex_pulse_in_12") , __SPTR(&System.signal_state.ext_pulse_input[11]), &System.signal_state_res.ext_pulse_input[11], sizeof(System.signal_state.ext_pulse_input[11]), UINT32_SYSTEM_T,  __EGTSN(227)},
  {(VEGA_EXT_PULSE_INPUT_1+12)  , __SNAME("ex_pulse_in_13") , __SPTR(&System.signal_state.ext_pulse_input[12]), &System.signal_state_res.ext_pulse_input[12], sizeof(System.signal_state.ext_pulse_input[12]), UINT32_SYSTEM_T,  __EGTSN(228)},
  {(VEGA_EXT_PULSE_INPUT_1+13)  , __SNAME("ex_pulse_in_14") , __SPTR(&System.signal_state.ext_pulse_input[13]), &System.signal_state_res.ext_pulse_input[13], sizeof(System.signal_state.ext_pulse_input[13]), UINT32_SYSTEM_T,  __EGTSN(229)},
  {(VEGA_EXT_PULSE_INPUT_1+14)  , __SNAME("ex_pulse_in_15") , __SPTR(&System.signal_state.ext_pulse_input[14]), &System.signal_state_res.ext_pulse_input[14], sizeof(System.signal_state.ext_pulse_input[14]), UINT32_SYSTEM_T,  __EGTSN(230)},

  {(VEGA_EXT_DIGITAL_INPUT_1)     , __SNAME("ex_dig_in_1")  , __SPTR(&System.signal_state.ext_digital_input[0]) , &System.signal_state_res.ext_digital_input[0] , sizeof(System.signal_state.ext_digital_input[0]), BOOL_SYSTEM_T,  __EGTSN(206)},
  {(VEGA_EXT_DIGITAL_INPUT_1+1)   , __SNAME("ex_dig_in_2")  , __SPTR(&System.signal_state.ext_digital_input[1]) , &System.signal_state_res.ext_digital_input[1] , sizeof(System.signal_state.ext_digital_input[1]), BOOL_SYSTEM_T,  __EGTSN(207)},
  {(VEGA_EXT_DIGITAL_INPUT_1+2)   , __SNAME("ex_dig_in_3")  , __SPTR(&System.signal_state.ext_digital_input[2]) , &System.signal_state_res.ext_digital_input[2] , sizeof(System.signal_state.ext_digital_input[2]), BOOL_SYSTEM_T,  __EGTSN(208)},
  {(VEGA_EXT_DIGITAL_INPUT_1+3)   , __SNAME("ex_dig_in_4")  , __SPTR(&System.signal_state.ext_digital_input[3]) , &System.signal_state_res.ext_digital_input[3] , sizeof(System.signal_state.ext_digital_input[3]), BOOL_SYSTEM_T,  __EGTSN(209)},
  {(VEGA_EXT_DIGITAL_INPUT_1+4)   , __SNAME("ex_dig_in_5")  , __SPTR(&System.signal_state.ext_digital_input[4]) , &System.signal_state_res.ext_digital_input[4] , sizeof(System.signal_state.ext_digital_input[4]), BOOL_SYSTEM_T,  __EGTSN(210)},
  {(VEGA_EXT_DIGITAL_INPUT_1+5)   , __SNAME("ex_dig_in_6")  , __SPTR(&System.signal_state.ext_digital_input[5]) , &System.signal_state_res.ext_digital_input[5] , sizeof(System.signal_state.ext_digital_input[5]), BOOL_SYSTEM_T,  __EGTSN(211)},
  {(VEGA_EXT_DIGITAL_INPUT_1+6)   , __SNAME("ex_dig_in_7")  , __SPTR(&System.signal_state.ext_digital_input[6]) , &System.signal_state_res.ext_digital_input[6] , sizeof(System.signal_state.ext_digital_input[6]), BOOL_SYSTEM_T,  __EGTSN(212)},
  {(VEGA_EXT_DIGITAL_INPUT_1+7)   , __SNAME("ex_dig_in_8")  , __SPTR(&System.signal_state.ext_digital_input[7]) , &System.signal_state_res.ext_digital_input[7] , sizeof(System.signal_state.ext_digital_input[7]), BOOL_SYSTEM_T,  __EGTSN(213)},
  {(VEGA_EXT_DIGITAL_INPUT_1+8)   , __SNAME("ex_dig_in_9")  , __SPTR(&System.signal_state.ext_digital_input[8]) , &System.signal_state_res.ext_digital_input[8] , sizeof(System.signal_state.ext_digital_input[8]), BOOL_SYSTEM_T,  __EGTSN(214)},
  {(VEGA_EXT_DIGITAL_INPUT_1+9)   , __SNAME("ex_dig_in_10") , __SPTR(&System.signal_state.ext_digital_input[9]) , &System.signal_state_res.ext_digital_input[9] , sizeof(System.signal_state.ext_digital_input[9]), BOOL_SYSTEM_T,  __EGTSN(215)},
  {(VEGA_EXT_DIGITAL_INPUT_1+10)  , __SNAME("ex_dig_in_11") , __SPTR(&System.signal_state.ext_digital_input[10]), &System.signal_state_res.ext_digital_input[10], sizeof(System.signal_state.ext_digital_input[10]), BOOL_SYSTEM_T,  __EGTSN(216)},
  {(VEGA_EXT_DIGITAL_INPUT_1+11)  , __SNAME("ex_dig_in_12") , __SPTR(&System.signal_state.ext_digital_input[11]), &System.signal_state_res.ext_digital_input[11], sizeof(System.signal_state.ext_digital_input[11]), BOOL_SYSTEM_T,  __EGTSN(217)},
  {(VEGA_EXT_DIGITAL_INPUT_1+12)  , __SNAME("ex_dig_in_13") , __SPTR(&System.signal_state.ext_digital_input[12]), &System.signal_state_res.ext_digital_input[12], sizeof(System.signal_state.ext_digital_input[12]), BOOL_SYSTEM_T,  __EGTSN(218)},
  {(VEGA_EXT_DIGITAL_INPUT_1+13)  , __SNAME("ex_dig_in_14") , __SPTR(&System.signal_state.ext_digital_input[13]), &System.signal_state_res.ext_digital_input[13], sizeof(System.signal_state.ext_digital_input[13]), BOOL_SYSTEM_T,  __EGTSN(219)},
  {(VEGA_EXT_DIGITAL_INPUT_1+14)  , __SNAME("ex_dig_in_15") , __SPTR(&System.signal_state.ext_digital_input[14]), &System.signal_state_res.ext_digital_input[14], sizeof(System.signal_state.ext_digital_input[14]), BOOL_SYSTEM_T,  __EGTSN(220)},

  {(VEGA_EXT_DIGITAL_OUTPUT_1)     , __SNAME("ex_dig_out_1")  , __SPTR(&System.signal_state.ext_digital_output[0]) , &System.signal_state_res.ext_digital_output[0] , sizeof(System.signal_state.ext_digital_output[0]), BOOL_SYSTEM_T,  __EGTSN(221)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+1)   , __SNAME("ex_dig_out_2")  , __SPTR(&System.signal_state.ext_digital_output[1]) , &System.signal_state_res.ext_digital_output[1] , sizeof(System.signal_state.ext_digital_output[1]), BOOL_SYSTEM_T,  __EGTSN(222)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+2)   , __SNAME("ex_dig_out_3")  , __SPTR(&System.signal_state.ext_digital_output[2]) , &System.signal_state_res.ext_digital_output[2] , sizeof(System.signal_state.ext_digital_output[2]), BOOL_SYSTEM_T,  __EGTSN(223)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+3)   , __SNAME("ex_dig_out_4")  , __SPTR(&System.signal_state.ext_digital_output[3]) , &System.signal_state_res.ext_digital_output[3] , sizeof(System.signal_state.ext_digital_output[3]), BOOL_SYSTEM_T,  __EGTSN(224)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+4)   , __SNAME("ex_dig_out_5")  , __SPTR(&System.signal_state.ext_digital_output[4]) , &System.signal_state_res.ext_digital_output[4] , sizeof(System.signal_state.ext_digital_output[4]), BOOL_SYSTEM_T,  __EGTSN(225)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+5)   , __SNAME("ex_dig_out_6")  , __SPTR(&System.signal_state.ext_digital_output[5]) , &System.signal_state_res.ext_digital_output[5] , sizeof(System.signal_state.ext_digital_output[5]), BOOL_SYSTEM_T,  __EGTSN(226)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+6)   , __SNAME("ex_dig_out_7")  , __SPTR(&System.signal_state.ext_digital_output[6]) , &System.signal_state_res.ext_digital_output[6] , sizeof(System.signal_state.ext_digital_output[6]), BOOL_SYSTEM_T,  __EGTSN(227)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+7)   , __SNAME("ex_dig_out_8")  , __SPTR(&System.signal_state.ext_digital_output[7]) , &System.signal_state_res.ext_digital_output[7] , sizeof(System.signal_state.ext_digital_output[7]), BOOL_SYSTEM_T,  __EGTSN(228)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+8)   , __SNAME("ex_dig_out_9")  , __SPTR(&System.signal_state.ext_digital_output[8]) , &System.signal_state_res.ext_digital_output[8] , sizeof(System.signal_state.ext_digital_output[8]), BOOL_SYSTEM_T,  __EGTSN(229)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+9)   , __SNAME("ex_dig_out_10") , __SPTR(&System.signal_state.ext_digital_output[9]) , &System.signal_state_res.ext_digital_output[9] , sizeof(System.signal_state.ext_digital_output[9]), BOOL_SYSTEM_T,  __EGTSN(230)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+10)  , __SNAME("ex_dig_out_11") , __SPTR(&System.signal_state.ext_digital_output[10]), &System.signal_state_res.ext_digital_output[10], sizeof(System.signal_state.ext_digital_output[10]), BOOL_SYSTEM_T,  __EGTSN(231)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+11)  , __SNAME("ex_dig_out_12") , __SPTR(&System.signal_state.ext_digital_output[11]), &System.signal_state_res.ext_digital_output[11], sizeof(System.signal_state.ext_digital_output[11]), BOOL_SYSTEM_T,  __EGTSN(232)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+12)  , __SNAME("ex_dig_out_13") , __SPTR(&System.signal_state.ext_digital_output[12]), &System.signal_state_res.ext_digital_output[12], sizeof(System.signal_state.ext_digital_output[12]), BOOL_SYSTEM_T,  __EGTSN(233)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+13)  , __SNAME("ex_dig_out_14") , __SPTR(&System.signal_state.ext_digital_output[13]), &System.signal_state_res.ext_digital_output[13], sizeof(System.signal_state.ext_digital_output[13]), BOOL_SYSTEM_T,  __EGTSN(234)},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+14)  , __SNAME("ex_dig_out_15") , __SPTR(&System.signal_state.ext_digital_output[14]), &System.signal_state_res.ext_digital_output[14], sizeof(System.signal_state.ext_digital_output[14]), BOOL_SYSTEM_T,  __EGTSN(235)},
#else
#error Количество входов/выходов для платы расширения неверное
#endif  //(MAX_EXT_MF_INPUTS <= 15)
#endif //BR_PRESENT

#if defined(FRIDGE_PRESENT)
// По egts не передаем!!!
  {FRIDGE_COOMUNICATION_STATE     , "frig_ok"        , &System.signal_state.is_fridge_ok,                            &System.signal_state_res.is_fridge_ok,                          sizeof(System.signal_state.is_fridge_ok),                       UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_SERIAL                  , "frig_sn"        , &System.signal_state.fridge_state.serial_number,              &System.signal_state_res.fridge_state.serial_number,            sizeof(System.signal_state.fridge_state.serial_number),         UINT32_SYSTEM_T, 0xffff},

#if (MAX_FRIDGE_AIN > 0)
  {FRIDGE_AIN1_FLAGS              , "frig_an1_f"     , &System.signal_state.fridge_state.an_data[0].flags,           &System.signal_state_res.fridge_state.an_data[0].flags,         sizeof(System.signal_state.fridge_state.an_data[0].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN1_VALUE              , "frig_an1_v"     , &System.signal_state.fridge_state.an_data[0].value,           &System.signal_state_res.fridge_state.an_data[0].value,         sizeof(System.signal_state.fridge_state.an_data[0].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 1)
  {FRIDGE_AIN2_FLAGS              , "frig_an2_f"     , &System.signal_state.fridge_state.an_data[1].flags,           &System.signal_state_res.fridge_state.an_data[1].flags,         sizeof(System.signal_state.fridge_state.an_data[1].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN2_VALUE              , "frig_an2_v"     , &System.signal_state.fridge_state.an_data[1].value,           &System.signal_state_res.fridge_state.an_data[1].value,         sizeof(System.signal_state.fridge_state.an_data[1].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 2)
  {FRIDGE_AIN3_FLAGS              , "frig_an3_f"     , &System.signal_state.fridge_state.an_data[2].flags,           &System.signal_state_res.fridge_state.an_data[2].flags,         sizeof(System.signal_state.fridge_state.an_data[2].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN3_VALUE              , "frig_an3_v"     , &System.signal_state.fridge_state.an_data[2].value,           &System.signal_state_res.fridge_state.an_data[2].value,         sizeof(System.signal_state.fridge_state.an_data[2].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 3)
  {FRIDGE_AIN4_FLAGS              , "frig_an4_f"     , &System.signal_state.fridge_state.an_data[3].flags,           &System.signal_state_res.fridge_state.an_data[3].flags,         sizeof(System.signal_state.fridge_state.an_data[3].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN4_VALUE              , "frig_an4_v"     , &System.signal_state.fridge_state.an_data[3].value,           &System.signal_state_res.fridge_state.an_data[3].value,         sizeof(System.signal_state.fridge_state.an_data[3].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 4)
  {FRIDGE_AIN5_FLAGS              , "frig_an5_f"     , &System.signal_state.fridge_state.an_data[4].flags,           &System.signal_state_res.fridge_state.an_data[4].flags,         sizeof(System.signal_state.fridge_state.an_data[4].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN5_VALUE              , "frig_an5_v"     , &System.signal_state.fridge_state.an_data[4].value,           &System.signal_state_res.fridge_state.an_data[4].value,         sizeof(System.signal_state.fridge_state.an_data[4].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 5)
  {FRIDGE_AIN6_FLAGS              , "frig_an6_f"     , &System.signal_state.fridge_state.an_data[5].flags,           &System.signal_state_res.fridge_state.an_data[5].flags,         sizeof(System.signal_state.fridge_state.an_data[5].flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AIN6_VALUE              , "frig_an6_v"     , &System.signal_state.fridge_state.an_data[5].value,           &System.signal_state_res.fridge_state.an_data[5].value,         sizeof(System.signal_state.fridge_state.an_data[5].value),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_AIN > 6)
#error   Нужно добавить аналоговые входы терморегистратора
#endif

#if (MAX_FRIDGE_DIN > 0)
  {FRIDGE_DIN1_FLAGS              , "frig_dig1_f"    , &System.signal_state.fridge_state.dig_data[0].flags,          &System.signal_state_res.fridge_state.dig_data[0].flags,        sizeof(System.signal_state.fridge_state.dig_data[0].flags),     UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_DIN1_VALUE              , "frig_dig1_v"    , &System.signal_state.fridge_state.dig_data[0].value,          &System.signal_state_res.fridge_state.dig_data[0].value,        sizeof(System.signal_state.fridge_state.dig_data[0].value),     BOOL_SYSTEM_T,   0xffff},
#endif
#if (MAX_FRIDGE_DIN > 1)
  {FRIDGE_DIN2_FLAGS              , "frig_dig2_f"    , &System.signal_state.fridge_state.dig_data[1].flags,          &System.signal_state_res.fridge_state.dig_data[1].flags,        sizeof(System.signal_state.fridge_state.dig_data[1].flags),     UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_DIN2_VALUE              , "frig_dig2_v"    , &System.signal_state.fridge_state.dig_data[1].value,          &System.signal_state_res.fridge_state.dig_data[1].value,        sizeof(System.signal_state.fridge_state.dig_data[1].value),     BOOL_SYSTEM_T,   0xffff},
#endif
#if (MAX_FRIDGE_DIN > 2)
  {FRIDGE_DIN3_FLAGS              , "frig_dig3_f"    , &System.signal_state.fridge_state.dig_data[2].flags,          &System.signal_state_res.fridge_state.dig_data[2].flags,        sizeof(System.signal_state.fridge_state.dig_data[2].flags),     UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_DIN3_VALUE              , "frig_dig3_v"    , &System.signal_state.fridge_state.dig_data[2].value,          &System.signal_state_res.fridge_state.dig_data[2].value,        sizeof(System.signal_state.fridge_state.dig_data[2].value),     BOOL_SYSTEM_T,   0xffff},
#endif
#if (MAX_FRIDGE_DIN > 3)
  {FRIDGE_DIN4_FLAGS              , "frig_dig4_f"    , &System.signal_state.fridge_state.dig_data[3].flags,          &System.signal_state_res.fridge_state.dig_data[3].flags,        sizeof(System.signal_state.fridge_state.dig_data[3].flags),     UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_DIN4_VALUE              , "frig_dig4_v"    , &System.signal_state.fridge_state.dig_data[3].value,          &System.signal_state_res.fridge_state.dig_data[3].value,        sizeof(System.signal_state.fridge_state.dig_data[3].value),     BOOL_SYSTEM_T,   0xffff},
#endif
#if (MAX_FRIDGE_DIN > 4)
#error   Нужно добавить цифровые входы терморегистратора
#endif

  {FRIDGE_RUN_MODE                , "frig_run_m"     , &System.signal_state.fridge_state.run_mode,                   &System.signal_state_res.fridge_state.run_mode,                 sizeof(System.signal_state.fridge_state.run_mode),              UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_POWER_MODE              , "frig_pwr_m"     , &System.signal_state.fridge_state.power_mode,                 &System.signal_state_res.fridge_state.power_mode,               sizeof(System.signal_state.fridge_state.power_mode),            UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_SPEED_MODE              , "frig_spe_m"     , &System.signal_state.fridge_state.speed_mode,                 &System.signal_state_res.fridge_state.speed_mode,               sizeof(System.signal_state.fridge_state.speed_mode),            UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_BATTERY_FLAGS           , "frig_batt_f"    , &System.signal_state.fridge_state.battery_state_flags,        &System.signal_state_res.fridge_state.battery_state_flags,      sizeof(System.signal_state.fridge_state.battery_state_flags),   UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_BATTERY_VALUE           , "frig_batt_v"    , &System.signal_state.fridge_state.battery_voltage,            &System.signal_state_res.fridge_state.battery_voltage,          sizeof(System.signal_state.fridge_state.battery_voltage),       FLOAT_SYSTEM_T,  0xffff},
  {FRIDGE_FUEL_FLAGS              , "frig_fuel_f"    , &System.signal_state.fridge_state.fuel_state_flags,           &System.signal_state_res.fridge_state.fuel_state_flags,         sizeof(System.signal_state.fridge_state.fuel_state_flags),      UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_FUEL_VALUE              , "frig_fuel_v"    , &System.signal_state.fridge_state.fuel_level,                 &System.signal_state_res.fridge_state.fuel_level,               sizeof(System.signal_state.fridge_state.fuel_level),            UINT8_SYSTEM_T,  0xffff},

  {FRIDGE_ELECTRIC_HOURS_FLAGS    , "frig_e_hour_f"  , &System.signal_state.fridge_state.electric_hours.flags,       &System.signal_state_res.fridge_state.electric_hours.flags,     sizeof(System.signal_state.fridge_state.electric_hours.flags),  UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_ELECTRIC_HOURS_VALUE    , "frig_e_hour_v"  , &System.signal_state.fridge_state.electric_hours.value,       &System.signal_state_res.fridge_state.electric_hours.value,     sizeof(System.signal_state.fridge_state.electric_hours.value),  UINT32_SYSTEM_T, 0xffff},
  {FRIDGE_STANDBY_HOURS_FLAGS     , "frig_s_hour_f"  , &System.signal_state.fridge_state.standby_hours.flags,        &System.signal_state_res.fridge_state.standby_hours.flags,      sizeof(System.signal_state.fridge_state.standby_hours.flags),   UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_STANDBY_HOURS_VALUE     , "frig_s_hour_v"  , &System.signal_state.fridge_state.standby_hours.value,        &System.signal_state_res.fridge_state.standby_hours.value,      sizeof(System.signal_state.fridge_state.standby_hours.value),   UINT32_SYSTEM_T, 0xffff},
  {FRIDGE_DIESEL_HOURS_FLAGS      , "frig_d_hour_f"  , &System.signal_state.fridge_state.diesel_hours.flags,         &System.signal_state_res.fridge_state.diesel_hours.flags,       sizeof(System.signal_state.fridge_state.diesel_hours.flags),    UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_DIESEL_HOURS_VALUE      , "frig_d_hour_v"  , &System.signal_state.fridge_state.diesel_hours.value,         &System.signal_state_res.fridge_state.diesel_hours.value,       sizeof(System.signal_state.fridge_state.diesel_hours.value),    UINT32_SYSTEM_T, 0xffff},
#if (MAX_FRIDGE_MAINTENANCE > 0)
  {FRIDGE_MAINTENANCE1_FLAGS      , "frig_m1_hour_f" , &System.signal_state.fridge_state.maintenance_hours[0].flags, &System.signal_state_res.fridge_state.maintenance_hours[0].flags, sizeof(System.signal_state.fridge_state.maintenance_hours[0].flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_MAINTENANCE1_VALUE      , "frig_m1_hour_v" , &System.signal_state.fridge_state.maintenance_hours[0].value, &System.signal_state_res.fridge_state.maintenance_hours[0].value, sizeof(System.signal_state.fridge_state.maintenance_hours[0].value), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 1)
  {FRIDGE_MAINTENANCE2_FLAGS      , "frig_m2_hour_f" , &System.signal_state.fridge_state.maintenance_hours[1].flags, &System.signal_state_res.fridge_state.maintenance_hours[1].flags, sizeof(System.signal_state.fridge_state.maintenance_hours[1].flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_MAINTENANCE2_VALUE      , "frig_m2_hour_v" , &System.signal_state.fridge_state.maintenance_hours[1].value, &System.signal_state_res.fridge_state.maintenance_hours[1].value, sizeof(System.signal_state.fridge_state.maintenance_hours[1].value), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 2)
  {FRIDGE_MAINTENANCE3_FLAGS      , "frig_m3_hour_f" , &System.signal_state.fridge_state.maintenance_hours[2].flags, &System.signal_state_res.fridge_state.maintenance_hours[2].flags, sizeof(System.signal_state.fridge_state.maintenance_hours[2].flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_MAINTENANCE3_VALUE      , "frig_m3_hour_v" , &System.signal_state.fridge_state.maintenance_hours[2].value, &System.signal_state_res.fridge_state.maintenance_hours[2].value, sizeof(System.signal_state.fridge_state.maintenance_hours[2].value), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 3)
  {FRIDGE_MAINTENANCE4_FLAGS      , "frig_m4_hour_f" , &System.signal_state.fridge_state.maintenance_hours[3].flags, &System.signal_state_res.fridge_state.maintenance_hours[3].flags, sizeof(System.signal_state.fridge_state.maintenance_hours[3].flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_MAINTENANCE4_VALUE      , "frig_m4_hour_v" , &System.signal_state.fridge_state.maintenance_hours[3].value, &System.signal_state_res.fridge_state.maintenance_hours[3].value, sizeof(System.signal_state.fridge_state.maintenance_hours[3].value), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 4)
  {FRIDGE_MAINTENANCE5_FLAGS      , "frig_m5_hour_f" , &System.signal_state.fridge_state.maintenance_hours[4].flags, &System.signal_state_res.fridge_state.maintenance_hours[4].flags, sizeof(System.signal_state.fridge_state.maintenance_hours[4].flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_MAINTENANCE5_VALUE      , "frig_m5_hour_v" , &System.signal_state.fridge_state.maintenance_hours[4].value, &System.signal_state_res.fridge_state.maintenance_hours[4].value, sizeof(System.signal_state.fridge_state.maintenance_hours[4].value), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 5)
#error   По протоколу интевалов сервисного обслуживания рефрижератора максимум 5
#endif

#if (MAX_FRIDGE_COMPARTMENT > 0)
  {FRIDGE_COMPAR1_STATE             , "frig_c1_s"      , &System.signal_state.fridge_state.compartment_data[0].compartment_state,            &System.signal_state_res.fridge_state.compartment_data[0].compartment_state,            sizeof(System.signal_state.fridge_state.compartment_data[0].compartment_state),                UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_MODE              , "frig_c1_m"      , &System.signal_state.fridge_state.compartment_data[0].compartment_mode,             &System.signal_state_res.fridge_state.compartment_data[0].compartment_mode,             sizeof(System.signal_state.fridge_state.compartment_data[0].compartment_mode),                 UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SETPOINT_FLAGS    , "frig_c1_sp_f"   , &System.signal_state.fridge_state.compartment_data[0].setpoint.flags,               &System.signal_state_res.fridge_state.compartment_data[0].setpoint.flags,               sizeof(System.signal_state.fridge_state.compartment_data[0].setpoint.flags),                   UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SETPOINT_VALUE    , "frig_c1_sp_v"   , &System.signal_state.fridge_state.compartment_data[0].setpoint.value,               &System.signal_state_res.fridge_state.compartment_data[0].setpoint.value,               sizeof(System.signal_state.fridge_state.compartment_data[0].setpoint.value),                   FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SUPPLY_AIR1_FLAGS , "frig_c1_sas1_f" , &System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[0].supply_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SUPPLY_AIR1_VALUE , "frig_c1_sas1_v" , &System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[0].supply_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SUPPLY_AIR2_FLAGS , "frig_c1_sas2_f" , &System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[0].supply_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_SUPPLY_AIR2_VALUE , "frig_c1_sas2_v" , &System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[0].supply_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[0].supply_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_RETURN_AIR1_FLAGS , "frig_c1_ras1_f" , &System.signal_state.fridge_state.compartment_data[0].return_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[0].return_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[0].return_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_RETURN_AIR1_VALUE , "frig_c1_ras1_v" , &System.signal_state.fridge_state.compartment_data[0].return_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[0].return_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[0].return_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_RETURN_AIR2_FLAGS , "frig_c1_ras2_f" , &System.signal_state.fridge_state.compartment_data[0].return_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[0].return_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[0].return_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_RETURN_AIR2_VALUE , "frig_c1_ras2_v" , &System.signal_state.fridge_state.compartment_data[0].return_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[0].return_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[0].return_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_EVAPORATOR_FLAGS  , "frig_c1_eva_f"  , &System.signal_state.fridge_state.compartment_data[0].evaporator_temperature.flags, &System.signal_state_res.fridge_state.compartment_data[0].evaporator_temperature.flags, sizeof(System.signal_state.fridge_state.compartment_data[0].evaporator_temperature.flags),     UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR1_EVAPORATOR_VALUE  , "frig_c1_eva_v"  , &System.signal_state.fridge_state.compartment_data[0].evaporator_temperature.value, &System.signal_state_res.fridge_state.compartment_data[0].evaporator_temperature.value, sizeof(System.signal_state.fridge_state.compartment_data[0].evaporator_temperature.value),     FLOAT_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 1)
  {FRIDGE_COMPAR2_STATE             , "frig_c2_s"      , &System.signal_state.fridge_state.compartment_data[1].compartment_state,            &System.signal_state_res.fridge_state.compartment_data[1].compartment_state,            sizeof(System.signal_state.fridge_state.compartment_data[1].compartment_state),                UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_MODE              , "frig_c2_m"      , &System.signal_state.fridge_state.compartment_data[1].compartment_mode,             &System.signal_state_res.fridge_state.compartment_data[1].compartment_mode,             sizeof(System.signal_state.fridge_state.compartment_data[1].compartment_mode),                 UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SETPOINT_FLAGS    , "frig_c2_sp_f"   , &System.signal_state.fridge_state.compartment_data[1].setpoint.flags,               &System.signal_state_res.fridge_state.compartment_data[1].setpoint.flags,               sizeof(System.signal_state.fridge_state.compartment_data[1].setpoint.flags),                   UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SETPOINT_VALUE    , "frig_c2_sp_v"   , &System.signal_state.fridge_state.compartment_data[1].setpoint.value,               &System.signal_state_res.fridge_state.compartment_data[1].setpoint.value,               sizeof(System.signal_state.fridge_state.compartment_data[1].setpoint.value),                   FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SUPPLY_AIR1_FLAGS , "frig_c2_sas1_f" , &System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[1].supply_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SUPPLY_AIR1_VALUE , "frig_c2_sas1_v" , &System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[1].supply_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SUPPLY_AIR2_FLAGS , "frig_c2_sas2_f" , &System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[1].supply_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_SUPPLY_AIR2_VALUE , "frig_c2_sas2_v" , &System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[1].supply_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[1].supply_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_RETURN_AIR1_FLAGS , "frig_c2_ras1_f" , &System.signal_state.fridge_state.compartment_data[1].return_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[1].return_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[1].return_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_RETURN_AIR1_VALUE , "frig_c2_ras1_v" , &System.signal_state.fridge_state.compartment_data[1].return_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[1].return_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[1].return_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_RETURN_AIR2_FLAGS , "frig_c2_ras2_f" , &System.signal_state.fridge_state.compartment_data[1].return_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[1].return_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[1].return_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_RETURN_AIR2_VALUE , "frig_c2_ras2_v" , &System.signal_state.fridge_state.compartment_data[1].return_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[1].return_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[1].return_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_EVAPORATOR_FLAGS  , "frig_c2_eva_f" ,  &System.signal_state.fridge_state.compartment_data[1].evaporator_temperature.flags, &System.signal_state_res.fridge_state.compartment_data[1].evaporator_temperature.flags, sizeof(System.signal_state.fridge_state.compartment_data[1].evaporator_temperature.flags),     UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR2_EVAPORATOR_VALUE  , "frig_c2_eva_v"  , &System.signal_state.fridge_state.compartment_data[1].evaporator_temperature.value, &System.signal_state_res.fridge_state.compartment_data[1].evaporator_temperature.value, sizeof(System.signal_state.fridge_state.compartment_data[1].evaporator_temperature.value),     FLOAT_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 2)
  {FRIDGE_COMPAR3_STATE             , "frig_c3_s"      , &System.signal_state.fridge_state.compartment_data[2].compartment_state,            &System.signal_state_res.fridge_state.compartment_data[2].compartment_state,            sizeof(System.signal_state.fridge_state.compartment_data[2].compartment_state),                UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_MODE              , "frig_c3_m"      , &System.signal_state.fridge_state.compartment_data[2].compartment_mode,             &System.signal_state_res.fridge_state.compartment_data[2].compartment_mode,             sizeof(System.signal_state.fridge_state.compartment_data[2].compartment_mode),                 UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SETPOINT_FLAGS    , "frig_c3_sp_f"   , &System.signal_state.fridge_state.compartment_data[2].setpoint.flags,               &System.signal_state_res.fridge_state.compartment_data[2].setpoint.flags,               sizeof(System.signal_state.fridge_state.compartment_data[2].setpoint.flags),                   UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SETPOINT_VALUE    , "frig_c3_sp_v"   , &System.signal_state.fridge_state.compartment_data[2].setpoint.value,               &System.signal_state_res.fridge_state.compartment_data[2].setpoint.value,               sizeof(System.signal_state.fridge_state.compartment_data[2].setpoint.value),                   FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SUPPLY_AIR1_FLAGS , "frig_c3_sas1_f" , &System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[2].supply_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SUPPLY_AIR1_VALUE , "frig_c3_sas1_v" , &System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[2].supply_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SUPPLY_AIR2_FLAGS , "frig_c3_sas2_f" , &System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[2].supply_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_SUPPLY_AIR2_VALUE , "frig_c3_sas2_v" , &System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[2].supply_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[2].supply_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_RETURN_AIR1_FLAGS , "frig_c3_ras1_f" , &System.signal_state.fridge_state.compartment_data[2].return_air_sensor_1.flags,    &System.signal_state_res.fridge_state.compartment_data[2].return_air_sensor_1.flags,    sizeof(System.signal_state.fridge_state.compartment_data[2].return_air_sensor_1.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_RETURN_AIR1_VALUE , "frig_c3_ras1_v" , &System.signal_state.fridge_state.compartment_data[2].return_air_sensor_1.value,    &System.signal_state_res.fridge_state.compartment_data[2].return_air_sensor_1.value,    sizeof(System.signal_state.fridge_state.compartment_data[2].return_air_sensor_1.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_RETURN_AIR2_FLAGS , "frig_c3_ras2_f" , &System.signal_state.fridge_state.compartment_data[2].return_air_sensor_2.flags,    &System.signal_state_res.fridge_state.compartment_data[2].return_air_sensor_2.flags,    sizeof(System.signal_state.fridge_state.compartment_data[2].return_air_sensor_2.flags),        UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_RETURN_AIR2_VALUE , "frig_c3_ras2_v" , &System.signal_state.fridge_state.compartment_data[2].return_air_sensor_2.value,    &System.signal_state_res.fridge_state.compartment_data[2].return_air_sensor_2.value,    sizeof(System.signal_state.fridge_state.compartment_data[2].return_air_sensor_2.value),        FLOAT_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_EVAPORATOR_FLAGS  , "frig_c3_eva_f" ,  &System.signal_state.fridge_state.compartment_data[2].evaporator_temperature.flags, &System.signal_state_res.fridge_state.compartment_data[2].evaporator_temperature.flags, sizeof(System.signal_state.fridge_state.compartment_data[2].evaporator_temperature.flags),     UINT8_SYSTEM_T, 0xffff},
  {FRIDGE_COMPAR3_EVAPORATOR_VALUE  , "frig_c3_eva_v"  , &System.signal_state.fridge_state.compartment_data[2].evaporator_temperature.value, &System.signal_state_res.fridge_state.compartment_data[2].evaporator_temperature.value, sizeof(System.signal_state.fridge_state.compartment_data[2].evaporator_temperature.value),     FLOAT_SYSTEM_T, 0xffff},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 3)
#error   Нужно добавить отсеки рефрижератора
#endif

  {FRIDGE_AMBIENT_TEMP_FLAGS      , "frig_ambt_f"    , &System.signal_state.fridge_state.ambient_temperature.flags,  &System.signal_state_res.fridge_state.ambient_temperature.flags, sizeof(System.signal_state.fridge_state.ambient_temperature.flags), UINT8_SYSTEM_T,  0xffff},
  {FRIDGE_AMBIENT_TEMP_VALUE      , "frig_ambt_v"    , &System.signal_state.fridge_state.ambient_temperature.value,  &System.signal_state_res.fridge_state.ambient_temperature.value, sizeof(System.signal_state.fridge_state.ambient_temperature.value), FLOAT_SYSTEM_T,  0xffff},

  {FRIDGE_ALARM_LEVEL                , "frig_alev"    , &System.signal_state.fridge_state.alarm_data.alarm_level,              &System.signal_state_res.fridge_state.alarm_data.alarm_level,             sizeof(System.signal_state.fridge_state.alarm_data.alarm_level),         UINT8_SYSTEM_T,  0xffff},

#if (MAX_FRIDGE_ALARM_CODES > 0)
  {FRIDGE_ALARM_CODE1+0              , "frig_ac1"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[0],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[0],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[0]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 1)
  {FRIDGE_ALARM_CODE1+1              , "frig_ac2"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[1],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[1],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[1]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 2)
  {FRIDGE_ALARM_CODE1+2              , "frig_ac3"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[2],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[2],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[2]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 3)
  {FRIDGE_ALARM_CODE1+3              , "frig_ac4"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[3],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[3],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[3]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 4)
  {FRIDGE_ALARM_CODE1+4              , "frig_ac5"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[4],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[4],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[4]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 5)
  {FRIDGE_ALARM_CODE1+5              , "frig_ac6"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[5],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[5],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[5]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 6)
  {FRIDGE_ALARM_CODE1+6              , "frig_ac7"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[6],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[6],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[6]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 7)
  {FRIDGE_ALARM_CODE1+7              , "frig_ac8"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[7],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[7],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[7]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 8)
  {FRIDGE_ALARM_CODE1+8              , "frig_ac9"     , &System.signal_state.fridge_state.alarm_data.alarm_codes[8],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[8],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[8]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 9)
  {FRIDGE_ALARM_CODE1+9             , "frig_ac10"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[9],            &System.signal_state_res.fridge_state.alarm_data.alarm_codes[9],          sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[9]),      UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 10)
  {FRIDGE_ALARM_CODE1+10            , "frig_ac11"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[10],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[10],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[10]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 11)
  {FRIDGE_ALARM_CODE1+11            , "frig_ac12"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[11],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[11],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[11]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 12)
  {FRIDGE_ALARM_CODE1+12            , "frig_ac13"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[12],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[12],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[12]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 13)
  {FRIDGE_ALARM_CODE1+13            , "frig_ac14"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[13],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[13],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[13]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 14)
  {FRIDGE_ALARM_CODE1+14            , "frig_ac15"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[14],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[14],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[14]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 15)
  {FRIDGE_ALARM_CODE1+15            , "frig_ac16"    , &System.signal_state.fridge_state.alarm_data.alarm_codes[15],           &System.signal_state_res.fridge_state.alarm_data.alarm_codes[15],         sizeof(System.signal_state.fridge_state.alarm_data.alarm_codes[15]),    UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 16)
#error   По протоколу максимум 16 кодов тревог
#endif
#endif //FRIDGE_PRESENT

#if defined(ATOM_PRESENT)
  {ATOM_COOMUNICATION_STATE  , "atom_ok"      , &atom_state.is_ok  ,                       &atom_state_res.is_ok,                         sizeof(atom_state.is_ok),                     UINT8_SYSTEM_T, 0xffff},
  {ATOM_LAST_ERR             , "atom_err"     , &atom_state.last_error,                    &atom_state_res.last_error,                    sizeof(atom_state.last_error),                    UINT8_SYSTEM_T, 0xffff},
  {ATOM_IMAGE_PROBLEM_BF     , "atom_ip"      , &atom_state.camera_disconnected_bitfield,  &atom_state_res.camera_disconnected_bitfield,  sizeof(atom_state.camera_disconnected_bitfield),  UINT32_SYSTEM_T, 0xffff},
  {ATOM_CAM_DISC_BF          , "atom_cd"      , &atom_state.camera_image_problem_bitfield, &atom_state_res.camera_image_problem_bitfield, sizeof(atom_state.camera_image_problem_bitfield), UINT32_SYSTEM_T, 0xffff},
  {ATOM_DOOR_1_IN            , "atom_d1i"     , &atom_state.door_pass_in[0],               &atom_state_res.door_pass_in[0],               sizeof(atom_state.door_pass_in[0]),               UINT16_SYSTEM_T, 0xffff},
  {ATOM_DOOR_1_OUT           , "atom_d1o"     , &atom_state.door_pass_out[0],              &atom_state_res.door_pass_out[0],              sizeof(atom_state.door_pass_out[0]),              UINT16_SYSTEM_T, 0xffff},
  {ATOM_DOOR_2_IN            , "atom_d2i"     , &atom_state.door_pass_in[1],               &atom_state_res.door_pass_in[1],               sizeof(atom_state.door_pass_in[1]),               UINT16_SYSTEM_T, 0xffff},
  {ATOM_DOOR_2_OUT           , "atom_d2o"     , &atom_state.door_pass_out[1],              &atom_state_res.door_pass_out[1],              sizeof(atom_state.door_pass_out[1]),              UINT16_SYSTEM_T, 0xffff},
  {ATOM_DOOR_3_IN            , "atom_d3i"     , &atom_state.door_pass_in[2],               &atom_state_res.door_pass_in[2],               sizeof(atom_state.door_pass_in[2]),               UINT16_SYSTEM_T, 0xffff},
  {ATOM_DOOR_3_OUT           , "atom_d3o"     , &atom_state.door_pass_out[2],              &atom_state_res.door_pass_out[2],              sizeof(atom_state.door_pass_out[2]),              UINT16_SYSTEM_T, 0xffff},
  {ATOM_VIDEO_TIMESTAMP      , "atom_vts"     , &atom_state.video_timestamp,               &atom_state_res.video_timestamp,               sizeof(atom_state.video_timestamp),               UINT32_SYSTEM_T, 0xffff},
  {ATOM_FIX_TIMESTAMP        , "atom_fts"     , &atom_state.time_for_fix,                  &atom_state_res.time_for_fix,                  sizeof(atom_state.time_for_fix),                  UINT32_SYSTEM_T, 0xffff},
  {ATOM_VIDEO_ID             , "atom_vid"     , &atom_state.video_id,                      &atom_state_res.video_id,                      sizeof(atom_state.video_id),                      UINT32_SYSTEM_T, 0xffff},
#endif //ATOM_PRESENT

#if defined(LORA_SENSORS_PRESENT)
  {LORASENS_COOMUNICATION_STATE  , "lsens_ok"     , &System.signal_state.is_lora_sens_ok,                 &System.signal_state_res.is_lora_sens_ok,               sizeof(System.signal_state.is_lora_sens_ok),            UINT8_SYSTEM_T, 0xffff},

#if (MAX_LORA_SENSORS_COUNT > 0)
  {LORASENS_TEMP_VALUE1           , "ls_tem1"     , &System.signal_state.lora_sens[0].temperature,        &System.signal_state_res.lora_sens[0].temperature,      sizeof(System.signal_state.lora_sens[0].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS1               , "ls_ev1"      , &System.signal_state.lora_sens[0].events,             &System.signal_state_res.lora_sens[0].events,           sizeof(System.signal_state.lora_sens[0].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI1                 , "ls_rss1"     , &System.signal_state.lora_sens[0].rssi,               &System.signal_state_res.lora_sens[0].rssi,             sizeof(System.signal_state.lora_sens[0].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS1        , "ls_onl1"     , &System.signal_state.lora_sens[0].online_status,      &System.signal_state_res.lora_sens[0].online_status,    sizeof(System.signal_state.lora_sens[0].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL1         , "ls_bat1"     , &System.signal_state.lora_sens[0].charge_level,       &System.signal_state_res.lora_sens[0].charge_level,     sizeof(System.signal_state.lora_sens[0].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_TEMP_VALUE2           , "ls_tem2"    , &System.signal_state.lora_sens[1].temperature,         &System.signal_state_res.lora_sens[1].temperature,      sizeof(System.signal_state.lora_sens[1].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS2               , "ls_ev2"     , &System.signal_state.lora_sens[1].events,              &System.signal_state_res.lora_sens[1].events,           sizeof(System.signal_state.lora_sens[1].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI2                 , "ls_rss2"    , &System.signal_state.lora_sens[1].rssi,                &System.signal_state_res.lora_sens[1].rssi,             sizeof(System.signal_state.lora_sens[1].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS2        , "ls_onl2"    , &System.signal_state.lora_sens[1].online_status,       &System.signal_state_res.lora_sens[1].online_status,    sizeof(System.signal_state.lora_sens[1].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL2         , "ls_bat2"    , &System.signal_state.lora_sens[1].charge_level,        &System.signal_state_res.lora_sens[1].charge_level,     sizeof(System.signal_state.lora_sens[1].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_TEMP_VALUE3           , "ls_tem3"    , &System.signal_state.lora_sens[2].temperature,         &System.signal_state_res.lora_sens[2].temperature,      sizeof(System.signal_state.lora_sens[2].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS3               , "ls_ev3"     , &System.signal_state.lora_sens[2].events,              &System.signal_state_res.lora_sens[2].events,           sizeof(System.signal_state.lora_sens[2].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI3                 , "ls_rss3"    , &System.signal_state.lora_sens[2].rssi,                &System.signal_state_res.lora_sens[2].rssi,             sizeof(System.signal_state.lora_sens[2].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS3        , "ls_onl3"    , &System.signal_state.lora_sens[2].online_status,       &System.signal_state_res.lora_sens[2].online_status,    sizeof(System.signal_state.lora_sens[2].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL3         , "ls_bat3"    , &System.signal_state.lora_sens[2].charge_level,        &System.signal_state_res.lora_sens[2].charge_level,     sizeof(System.signal_state.lora_sens[2].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_TEMP_VALUE4           , "ls_tem4"    , &System.signal_state.lora_sens[3].temperature,         &System.signal_state_res.lora_sens[3].temperature,      sizeof(System.signal_state.lora_sens[3].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS4               , "ls_ev4"     , &System.signal_state.lora_sens[3].events,              &System.signal_state_res.lora_sens[3].events,           sizeof(System.signal_state.lora_sens[3].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI4                 , "ls_rss4"    , &System.signal_state.lora_sens[3].rssi,                &System.signal_state_res.lora_sens[3].rssi,             sizeof(System.signal_state.lora_sens[3].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS4        , "ls_onl4"    , &System.signal_state.lora_sens[3].online_status,       &System.signal_state_res.lora_sens[3].online_status,    sizeof(System.signal_state.lora_sens[3].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL4         , "ls_bat4"    , &System.signal_state.lora_sens[3].charge_level,        &System.signal_state_res.lora_sens[3].charge_level,     sizeof(System.signal_state.lora_sens[3].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_TEMP_VALUE5           , "ls_tem5"    , &System.signal_state.lora_sens[4].temperature,         &System.signal_state_res.lora_sens[4].temperature,      sizeof(System.signal_state.lora_sens[4].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS5               , "ls_ev5"     , &System.signal_state.lora_sens[4].events,              &System.signal_state_res.lora_sens[4].events,           sizeof(System.signal_state.lora_sens[4].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI5                 , "ls_rss5"    , &System.signal_state.lora_sens[4].rssi,                &System.signal_state_res.lora_sens[4].rssi,             sizeof(System.signal_state.lora_sens[4].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS5        , "ls_onl5"    , &System.signal_state.lora_sens[4].online_status,       &System.signal_state_res.lora_sens[4].online_status,    sizeof(System.signal_state.lora_sens[4].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL5         , "ls_bat5"    , &System.signal_state.lora_sens[4].charge_level,        &System.signal_state_res.lora_sens[4].charge_level,     sizeof(System.signal_state.lora_sens[4].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_TEMP_VALUE6           , "ls_tem6"    , &System.signal_state.lora_sens[5].temperature,         &System.signal_state_res.lora_sens[5].temperature,      sizeof(System.signal_state.lora_sens[5].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS6               , "ls_ev6"     , &System.signal_state.lora_sens[5].events,              &System.signal_state_res.lora_sens[5].events,           sizeof(System.signal_state.lora_sens[5].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI6                 , "ls_rss6"    , &System.signal_state.lora_sens[5].rssi,                &System.signal_state_res.lora_sens[5].rssi,             sizeof(System.signal_state.lora_sens[5].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS6        , "ls_onl6"    , &System.signal_state.lora_sens[5].online_status,       &System.signal_state_res.lora_sens[5].online_status,    sizeof(System.signal_state.lora_sens[5].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL6         , "ls_bat6"    , &System.signal_state.lora_sens[5].charge_level,        &System.signal_state_res.lora_sens[5].charge_level,     sizeof(System.signal_state.lora_sens[5].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_TEMP_VALUE7           , "ls_tem7"    , &System.signal_state.lora_sens[6].temperature,         &System.signal_state_res.lora_sens[6].temperature,      sizeof(System.signal_state.lora_sens[6].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS7               , "ls_ev7"     , &System.signal_state.lora_sens[6].events,              &System.signal_state_res.lora_sens[6].events,           sizeof(System.signal_state.lora_sens[6].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI7                 , "ls_rss7"    , &System.signal_state.lora_sens[6].rssi,                &System.signal_state_res.lora_sens[6].rssi,             sizeof(System.signal_state.lora_sens[6].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS7        , "ls_onl7"    , &System.signal_state.lora_sens[6].online_status,       &System.signal_state_res.lora_sens[6].online_status,    sizeof(System.signal_state.lora_sens[6].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL7         , "ls_bat7"    , &System.signal_state.lora_sens[6].charge_level,        &System.signal_state_res.lora_sens[6].charge_level,     sizeof(System.signal_state.lora_sens[6].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_TEMP_VALUE8           , "ls_tem8"    , &System.signal_state.lora_sens[7].temperature,         &System.signal_state_res.lora_sens[7].temperature,      sizeof(System.signal_state.lora_sens[7].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS8               , "ls_ev8"     , &System.signal_state.lora_sens[7].events,              &System.signal_state_res.lora_sens[7].events,           sizeof(System.signal_state.lora_sens[7].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI8                 , "ls_rss8"    , &System.signal_state.lora_sens[7].rssi,                &System.signal_state_res.lora_sens[7].rssi,             sizeof(System.signal_state.lora_sens[7].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS8        , "ls_onl8"    , &System.signal_state.lora_sens[7].online_status,       &System.signal_state_res.lora_sens[7].online_status,    sizeof(System.signal_state.lora_sens[7].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL8         , "ls_bat8"    , &System.signal_state.lora_sens[7].charge_level,        &System.signal_state_res.lora_sens[7].charge_level,     sizeof(System.signal_state.lora_sens[7].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_TEMP_VALUE9           , "ls_tem9"    , &System.signal_state.lora_sens[8].temperature,         &System.signal_state_res.lora_sens[8].temperature,      sizeof(System.signal_state.lora_sens[8].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS9               , "ls_ev9"     , &System.signal_state.lora_sens[8].events,              &System.signal_state_res.lora_sens[8].events,           sizeof(System.signal_state.lora_sens[8].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI9                 , "ls_rss9"    , &System.signal_state.lora_sens[8].rssi,                &System.signal_state_res.lora_sens[8].rssi,             sizeof(System.signal_state.lora_sens[8].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS9        , "ls_onl9"    , &System.signal_state.lora_sens[8].online_status,       &System.signal_state_res.lora_sens[8].online_status,    sizeof(System.signal_state.lora_sens[8].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL9         , "ls_bat9"    , &System.signal_state.lora_sens[8].charge_level,        &System.signal_state_res.lora_sens[8].charge_level,     sizeof(System.signal_state.lora_sens[8].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_TEMP_VALUE10           , "ls_tem10"    , &System.signal_state.lora_sens[9].temperature,       &System.signal_state_res.lora_sens[9].temperature,      sizeof(System.signal_state.lora_sens[9].temperature),   FLOAT_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS10               , "ls_ev10"     , &System.signal_state.lora_sens[9].events,            &System.signal_state_res.lora_sens[9].events,           sizeof(System.signal_state.lora_sens[9].events),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_RSSI10                 , "ls_rss10"    , &System.signal_state.lora_sens[9].rssi,              &System.signal_state_res.lora_sens[9].rssi,             sizeof(System.signal_state.lora_sens[9].rssi),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_ONLINE_STATUS10        , "ls_onl10"    , &System.signal_state.lora_sens[9].online_status,     &System.signal_state_res.lora_sens[9].online_status,    sizeof(System.signal_state.lora_sens[9].online_status), UINT8_SYSTEM_T, 0xffff},
  {LORASENS_CHARGE_LEVEL10         , "ls_bat10"    , &System.signal_state.lora_sens[9].charge_level,      &System.signal_state_res.lora_sens[9].charge_level,     sizeof(System.signal_state.lora_sens[9].charge_level),  UINT8_SYSTEM_T, 0xffff},
#endif

#if (MAX_LORA_SENSORS_COUNT > 10)
#error   Нужно добавить lora sensors
#endif

#if (MAX_LORA_SENSORS_COUNT > 0)
  {LORASENS_VERSION1              , "ls_ver1"     , &System.signal_state.lora_sens[0].version,            &System.signal_state_res.lora_sens[0].version,          sizeof(System.signal_state.lora_sens[0].version),       UINT8_SYSTEM_T, 0xffff},
#if (defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT) || defined(IS_BEACON_LORA_BUILD))
  {LORASENS_AXIS1                 , "ls_ax1"      , &System.signal_state.lora_sens[0].axis,               &System.signal_state_res.lora_sens[0].axis,             sizeof(System.signal_state.lora_sens[0].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE1            , "ls_hum1"     , &System.signal_state.lora_sens_hum[0],                &System.signal_state_res.lora_sens_hum[0],              sizeof(System.signal_state.lora_sens_hum[0]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_VERSION2              , "ls_ver2"    , &System.signal_state.lora_sens[1].version,             &System.signal_state_res.lora_sens[1].version,          sizeof(System.signal_state.lora_sens[1].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS2                 , "ls_ax2"     , &System.signal_state.lora_sens[1].axis,                &System.signal_state_res.lora_sens[1].axis,             sizeof(System.signal_state.lora_sens[1].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE2            , "ls_hum2"    , &System.signal_state.lora_sens_hum[1],                 &System.signal_state_res.lora_sens_hum[1],              sizeof(System.signal_state.lora_sens_hum[1]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_VERSION3              , "ls_ver3"    , &System.signal_state.lora_sens[2].version,             &System.signal_state_res.lora_sens[2].version,          sizeof(System.signal_state.lora_sens[2].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS3                 , "ls_ax3"     , &System.signal_state.lora_sens[2].axis,                &System.signal_state_res.lora_sens[2].axis,             sizeof(System.signal_state.lora_sens[2].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE3            , "ls_hum3"    , &System.signal_state.lora_sens_hum[2],                 &System.signal_state_res.lora_sens_hum[2],              sizeof(System.signal_state.lora_sens_hum[2]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_VERSION4              , "ls_ver4"    , &System.signal_state.lora_sens[3].version,             &System.signal_state_res.lora_sens[3].version,          sizeof(System.signal_state.lora_sens[3].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS4                 , "ls_ax4"     , &System.signal_state.lora_sens[3].axis,                &System.signal_state_res.lora_sens[3].axis,             sizeof(System.signal_state.lora_sens[3].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE4            , "ls_hum4"    , &System.signal_state.lora_sens_hum[3],                &System.signal_state_res.lora_sens_hum[3],              sizeof(System.signal_state.lora_sens_hum[3]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_VERSION5              , "ls_ver5"    , &System.signal_state.lora_sens[4].version,             &System.signal_state_res.lora_sens[4].version,          sizeof(System.signal_state.lora_sens[4].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS5                 , "ls_ax5"     , &System.signal_state.lora_sens[4].axis,                &System.signal_state_res.lora_sens[4].axis,             sizeof(System.signal_state.lora_sens[4].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE5            , "ls_hum5"    , &System.signal_state.lora_sens_hum[4],                 &System.signal_state_res.lora_sens_hum[4],              sizeof(System.signal_state.lora_sens_hum[4]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_VERSION6              , "ls_ver6"    , &System.signal_state.lora_sens[5].version,             &System.signal_state_res.lora_sens[5].version,          sizeof(System.signal_state.lora_sens[5].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS6                 , "ls_ax6"     , &System.signal_state.lora_sens[5].axis,                &System.signal_state_res.lora_sens[5].axis,             sizeof(System.signal_state.lora_sens[5].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE6            , "ls_hum6"    , &System.signal_state.lora_sens_hum[5],                 &System.signal_state_res.lora_sens_hum[5],              sizeof(System.signal_state.lora_sens_hum[5]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_VERSION7              , "ls_ver7"    , &System.signal_state.lora_sens[6].version,             &System.signal_state_res.lora_sens[6].version,          sizeof(System.signal_state.lora_sens[6].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS7                 , "ls_ax7"     , &System.signal_state.lora_sens[6].axis,                &System.signal_state_res.lora_sens[6].axis,             sizeof(System.signal_state.lora_sens[6].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE7            , "ls_hum7"    , &System.signal_state.lora_sens_hum[6],                 &System.signal_state_res.lora_sens_hum[6],              sizeof(System.signal_state.lora_sens_hum[6]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_VERSION8              , "ls_ver8"    , &System.signal_state.lora_sens[7].version,             &System.signal_state_res.lora_sens[7].version,          sizeof(System.signal_state.lora_sens[7].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS8                 , "ls_ax8"     , &System.signal_state.lora_sens[7].axis,                &System.signal_state_res.lora_sens[7].axis,             sizeof(System.signal_state.lora_sens[7].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE8            , "ls_hum8"    , &System.signal_state.lora_sens_hum[7],                 &System.signal_state_res.lora_sens_hum[7],              sizeof(System.signal_state.lora_sens_hum[7]),            FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_VERSION9              , "ls_ver9"    , &System.signal_state.lora_sens[8].version,             &System.signal_state_res.lora_sens[8].version,          sizeof(System.signal_state.lora_sens[8].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS9                 , "ls_ax9"     , &System.signal_state.lora_sens[8].axis,                &System.signal_state_res.lora_sens[8].axis,             sizeof(System.signal_state.lora_sens[8].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE9            , "ls_hum9"    , &System.signal_state.lora_sens_hum[8],                 &System.signal_state_res.lora_sens_hum[8],              sizeof(System.signal_state.lora_sens_hum[8]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_VERSION10              , "ls_ver10"    , &System.signal_state.lora_sens[9].version,           &System.signal_state_res.lora_sens[9].version,          sizeof(System.signal_state.lora_sens[9].version),       UINT8_SYSTEM_T, 0xffff},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS10                 , "ls_ax10"     , &System.signal_state.lora_sens[9].axis,              &System.signal_state_res.lora_sens[9].axis,             sizeof(System.signal_state.lora_sens[9].axis),          UINT8_SYSTEM_T, 0xffff},
  {LORASENS_HUM_VALUE10            , "ls_hum10"    , &System.signal_state.lora_sens_hum[9],               &System.signal_state_res.lora_sens_hum[9],              sizeof(System.signal_state.lora_sens_hum[9]),           FLOAT_SYSTEM_T, 0xffff},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 10)
#error   Нужно добавить lora sensors
#endif

  {LORASENS_COPROC_VERSION       , "cop_ver"      , &System.signal_state.lora_coproc_firmware_version,    &System.signal_state_res.lora_coproc_firmware_version,  sizeof(System.signal_state.lora_coproc_firmware_version), STRING_SYSTEM_T, 0xffff},
#endif //LORA_SENSORS_PRESENT

#if defined(REPORT_GEN_PRESENT)
#if (MAX_LORA_SENSORS_COUNT > 0)
  {LORASENS_EVENTS1_0               , "ls_ev1_0"     , &System.signal_state.lora_sens_bits[0].events_0,            &System.signal_state_res.lora_sens_bits[0].events_0,           sizeof(System.signal_state.lora_sens_bits[0].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS1_1               , "ls_ev1_1"     , &System.signal_state.lora_sens_bits[0].events_1,            &System.signal_state_res.lora_sens_bits[0].events_1,           sizeof(System.signal_state.lora_sens_bits[0].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS1_2               , "ls_ev1_2"     , &System.signal_state.lora_sens_bits[0].events_2,            &System.signal_state_res.lora_sens_bits[0].events_2,           sizeof(System.signal_state.lora_sens_bits[0].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS1_3               , "ls_ev1_3"     , &System.signal_state.lora_sens_bits[0].events_3,            &System.signal_state_res.lora_sens_bits[0].events_3,           sizeof(System.signal_state.lora_sens_bits[0].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS1_4               , "ls_ev1_4"     , &System.signal_state.lora_sens_bits[0].events_4,            &System.signal_state_res.lora_sens_bits[0].events_4,           sizeof(System.signal_state.lora_sens_bits[0].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_EVENTS2_0               , "ls_ev2_0"     , &System.signal_state.lora_sens_bits[1].events_0,            &System.signal_state_res.lora_sens_bits[1].events_0,           sizeof(System.signal_state.lora_sens_bits[1].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS2_1               , "ls_ev2_1"     , &System.signal_state.lora_sens_bits[1].events_1,            &System.signal_state_res.lora_sens_bits[1].events_1,           sizeof(System.signal_state.lora_sens_bits[1].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS2_2               , "ls_ev2_2"     , &System.signal_state.lora_sens_bits[1].events_2,            &System.signal_state_res.lora_sens_bits[1].events_2,           sizeof(System.signal_state.lora_sens_bits[1].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS2_3               , "ls_ev2_3"     , &System.signal_state.lora_sens_bits[1].events_3,            &System.signal_state_res.lora_sens_bits[1].events_3,           sizeof(System.signal_state.lora_sens_bits[1].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS2_4               , "ls_ev2_4"     , &System.signal_state.lora_sens_bits[1].events_4,            &System.signal_state_res.lora_sens_bits[1].events_4,           sizeof(System.signal_state.lora_sens_bits[1].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_EVENTS3_0               , "ls_ev3_0"     , &System.signal_state.lora_sens_bits[2].events_0,            &System.signal_state_res.lora_sens_bits[2].events_0,           sizeof(System.signal_state.lora_sens_bits[2].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS3_1               , "ls_ev3_1"     , &System.signal_state.lora_sens_bits[2].events_1,            &System.signal_state_res.lora_sens_bits[2].events_1,           sizeof(System.signal_state.lora_sens_bits[2].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS3_2               , "ls_ev3_2"     , &System.signal_state.lora_sens_bits[2].events_2,            &System.signal_state_res.lora_sens_bits[2].events_2,           sizeof(System.signal_state.lora_sens_bits[2].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS3_3               , "ls_ev3_3"     , &System.signal_state.lora_sens_bits[2].events_3,            &System.signal_state_res.lora_sens_bits[2].events_3,           sizeof(System.signal_state.lora_sens_bits[2].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS3_4               , "ls_ev3_4"     , &System.signal_state.lora_sens_bits[2].events_4,            &System.signal_state_res.lora_sens_bits[2].events_4,           sizeof(System.signal_state.lora_sens_bits[2].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_EVENTS4_0               , "ls_ev4_0"     , &System.signal_state.lora_sens_bits[3].events_0,            &System.signal_state_res.lora_sens_bits[3].events_0,           sizeof(System.signal_state.lora_sens_bits[3].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS4_1               , "ls_ev4_1"     , &System.signal_state.lora_sens_bits[3].events_1,            &System.signal_state_res.lora_sens_bits[3].events_1,           sizeof(System.signal_state.lora_sens_bits[3].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS4_2               , "ls_ev4_2"     , &System.signal_state.lora_sens_bits[3].events_2,            &System.signal_state_res.lora_sens_bits[3].events_2,           sizeof(System.signal_state.lora_sens_bits[3].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS4_3               , "ls_ev4_3"     , &System.signal_state.lora_sens_bits[3].events_3,            &System.signal_state_res.lora_sens_bits[3].events_3,           sizeof(System.signal_state.lora_sens_bits[3].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS4_4               , "ls_ev4_4"     , &System.signal_state.lora_sens_bits[3].events_4,            &System.signal_state_res.lora_sens_bits[3].events_4,           sizeof(System.signal_state.lora_sens_bits[3].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_EVENTS5_0               , "ls_ev5_0"     , &System.signal_state.lora_sens_bits[4].events_0,            &System.signal_state_res.lora_sens_bits[4].events_0,           sizeof(System.signal_state.lora_sens_bits[4].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS5_1               , "ls_ev5_1"     , &System.signal_state.lora_sens_bits[4].events_1,            &System.signal_state_res.lora_sens_bits[4].events_1,           sizeof(System.signal_state.lora_sens_bits[4].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS5_2               , "ls_ev5_2"     , &System.signal_state.lora_sens_bits[4].events_2,            &System.signal_state_res.lora_sens_bits[4].events_2,           sizeof(System.signal_state.lora_sens_bits[4].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS5_3               , "ls_ev5_3"     , &System.signal_state.lora_sens_bits[4].events_3,            &System.signal_state_res.lora_sens_bits[4].events_3,           sizeof(System.signal_state.lora_sens_bits[4].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS5_4               , "ls_ev5_4"     , &System.signal_state.lora_sens_bits[4].events_4,            &System.signal_state_res.lora_sens_bits[4].events_4,           sizeof(System.signal_state.lora_sens_bits[4].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_EVENTS6_0               , "ls_ev6_0"     , &System.signal_state.lora_sens_bits[5].events_0,            &System.signal_state_res.lora_sens_bits[5].events_0,           sizeof(System.signal_state.lora_sens_bits[5].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS6_1               , "ls_ev6_1"     , &System.signal_state.lora_sens_bits[5].events_1,            &System.signal_state_res.lora_sens_bits[5].events_1,           sizeof(System.signal_state.lora_sens_bits[5].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS6_2               , "ls_ev6_2"     , &System.signal_state.lora_sens_bits[5].events_2,            &System.signal_state_res.lora_sens_bits[5].events_2,           sizeof(System.signal_state.lora_sens_bits[5].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS6_3               , "ls_ev6_3"     , &System.signal_state.lora_sens_bits[5].events_3,            &System.signal_state_res.lora_sens_bits[5].events_3,           sizeof(System.signal_state.lora_sens_bits[5].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS6_4               , "ls_ev6_4"     , &System.signal_state.lora_sens_bits[5].events_4,            &System.signal_state_res.lora_sens_bits[5].events_4,           sizeof(System.signal_state.lora_sens_bits[5].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_EVENTS7_0               , "ls_ev7_0"     , &System.signal_state.lora_sens_bits[6].events_0,            &System.signal_state_res.lora_sens_bits[6].events_0,           sizeof(System.signal_state.lora_sens_bits[6].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS7_1               , "ls_ev7_1"     , &System.signal_state.lora_sens_bits[6].events_1,            &System.signal_state_res.lora_sens_bits[6].events_1,           sizeof(System.signal_state.lora_sens_bits[6].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS7_2               , "ls_ev7_2"     , &System.signal_state.lora_sens_bits[6].events_2,            &System.signal_state_res.lora_sens_bits[6].events_2,           sizeof(System.signal_state.lora_sens_bits[6].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS7_3               , "ls_ev7_3"     , &System.signal_state.lora_sens_bits[6].events_3,            &System.signal_state_res.lora_sens_bits[6].events_3,           sizeof(System.signal_state.lora_sens_bits[6].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS7_4               , "ls_ev7_4"     , &System.signal_state.lora_sens_bits[6].events_4,            &System.signal_state_res.lora_sens_bits[6].events_4,           sizeof(System.signal_state.lora_sens_bits[6].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_EVENTS8_0               , "ls_ev8_0"     , &System.signal_state.lora_sens_bits[7].events_0,            &System.signal_state_res.lora_sens_bits[7].events_0,           sizeof(System.signal_state.lora_sens_bits[7].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS8_1               , "ls_ev8_1"     , &System.signal_state.lora_sens_bits[7].events_1,            &System.signal_state_res.lora_sens_bits[7].events_1,           sizeof(System.signal_state.lora_sens_bits[7].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS8_2               , "ls_ev8_2"     , &System.signal_state.lora_sens_bits[7].events_2,            &System.signal_state_res.lora_sens_bits[7].events_2,           sizeof(System.signal_state.lora_sens_bits[7].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS8_3               , "ls_ev8_3"     , &System.signal_state.lora_sens_bits[7].events_3,            &System.signal_state_res.lora_sens_bits[7].events_3,           sizeof(System.signal_state.lora_sens_bits[7].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS8_4               , "ls_ev8_4"     , &System.signal_state.lora_sens_bits[7].events_4,            &System.signal_state_res.lora_sens_bits[7].events_4,           sizeof(System.signal_state.lora_sens_bits[7].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_EVENTS9_0               , "ls_ev9_0"     , &System.signal_state.lora_sens_bits[8].events_0,            &System.signal_state_res.lora_sens_bits[8].events_0,           sizeof(System.signal_state.lora_sens_bits[8].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS9_1               , "ls_ev9_1"     , &System.signal_state.lora_sens_bits[8].events_1,            &System.signal_state_res.lora_sens_bits[8].events_1,           sizeof(System.signal_state.lora_sens_bits[8].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS9_2               , "ls_ev9_2"     , &System.signal_state.lora_sens_bits[8].events_2,            &System.signal_state_res.lora_sens_bits[8].events_2,           sizeof(System.signal_state.lora_sens_bits[8].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS9_3               , "ls_ev9_3"     , &System.signal_state.lora_sens_bits[8].events_3,            &System.signal_state_res.lora_sens_bits[8].events_3,           sizeof(System.signal_state.lora_sens_bits[8].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS9_4               , "ls_ev9_4"     , &System.signal_state.lora_sens_bits[8].events_4,            &System.signal_state_res.lora_sens_bits[8].events_4,           sizeof(System.signal_state.lora_sens_bits[8].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_EVENTS10_0               , "ls_ev10_0"     , &System.signal_state.lora_sens_bits[9].events_0,            &System.signal_state_res.lora_sens_bits[9].events_0,           sizeof(System.signal_state.lora_sens_bits[9].events_0),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS10_1               , "ls_ev10_1"     , &System.signal_state.lora_sens_bits[9].events_1,            &System.signal_state_res.lora_sens_bits[9].events_1,           sizeof(System.signal_state.lora_sens_bits[9].events_1),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS10_2               , "ls_ev10_2"     , &System.signal_state.lora_sens_bits[9].events_2,            &System.signal_state_res.lora_sens_bits[9].events_2,           sizeof(System.signal_state.lora_sens_bits[9].events_2),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS10_3               , "ls_ev10_3"     , &System.signal_state.lora_sens_bits[9].events_3,            &System.signal_state_res.lora_sens_bits[9].events_3,           sizeof(System.signal_state.lora_sens_bits[9].events_3),        UINT8_SYSTEM_T, 0xffff},
  {LORASENS_EVENTS10_4               , "ls_ev10_4"     , &System.signal_state.lora_sens_bits[9].events_4,            &System.signal_state_res.lora_sens_bits[9].events_4,           sizeof(System.signal_state.lora_sens_bits[9].events_4),        UINT8_SYSTEM_T, 0xffff},
#endif
#endif //REPORT_GEN_PRESENT

#if (defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))
  {IQFREEZE_COOMUNICATION_STATE   , "iqf_ok"      , &System.signal_state.is_iqfreeze_ok,                   &System.signal_state_res.is_iqfreeze_ok,                 sizeof(System.signal_state.is_iqfreeze_ok),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_MT                    , "iqf_mt"      , &System.signal_state.iqfreeze.mt,                      &System.signal_state_res.iqfreeze.mt,                    sizeof(System.signal_state.iqfreeze.mt),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_T2                    , "iqf_t2"      , &System.signal_state.iqfreeze.t2,                      &System.signal_state_res.iqfreeze.t2,                    sizeof(System.signal_state.iqfreeze.t2),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_T3                    , "iqf_t3"      , &System.signal_state.iqfreeze.t3,                      &System.signal_state_res.iqfreeze.t3,                    sizeof(System.signal_state.iqfreeze.t3),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_SP                    , "iqf_sp"      , &System.signal_state.iqfreeze.sp,                      &System.signal_state_res.iqfreeze.sp,                    sizeof(System.signal_state.iqfreeze.sp),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_SP2                   , "iqf_sp2"     , &System.signal_state.iqfreeze.sp2,                     &System.signal_state_res.iqfreeze.sp2,                   sizeof(System.signal_state.iqfreeze.sp2),                FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_SP3                   , "iqf_sp3"     , &System.signal_state.iqfreeze.sp3,                     &System.signal_state_res.iqfreeze.sp3,                   sizeof(System.signal_state.iqfreeze.sp3),                FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AMBT                  , "iqf_ambt"    , &System.signal_state.iqfreeze.ambt,                    &System.signal_state_res.iqfreeze.ambt,                  sizeof(System.signal_state.iqfreeze.ambt),               FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AFZT                  , "iqf_afzt"    , &System.signal_state.iqfreeze.afzt,                    &System.signal_state_res.iqfreeze.afzt,                  sizeof(System.signal_state.iqfreeze.afzt),               FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_RPM                   , "iqf_rpm"     , &System.signal_state.iqfreeze.rpm,                     &System.signal_state_res.iqfreeze.rpm,                   sizeof(System.signal_state.iqfreeze.rpm),                UINT16_SYSTEM_T, 0xffff},
  {IQFREEZE_CONF                  , "iqf_conf"    , &System.signal_state.iqfreeze.conf,                    &System.signal_state_res.iqfreeze.conf,                  sizeof(System.signal_state.iqfreeze.conf),               UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_STATE                 , "iqf_state"   , &System.signal_state.iqfreeze.state,                   &System.signal_state_res.iqfreeze.state,                 sizeof(System.signal_state.iqfreeze.state),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_DR_BF                 , "iqf_drbf"    , &System.signal_state.iqfreeze.dr_bf,                   &System.signal_state_res.iqfreeze.dr_bf,                 sizeof(System.signal_state.iqfreeze.dr_bf),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_BATV                  , "iqf_batv"    , &System.signal_state.iqfreeze.batv,                    &System.signal_state_res.iqfreeze.batv,                  sizeof(System.signal_state.iqfreeze.batv),               FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_BATA                  , "iqf_bata"    , &System.signal_state.iqfreeze.bata,                    &System.signal_state_res.iqfreeze.bata,                  sizeof(System.signal_state.iqfreeze.bata),               FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_HM                    , "iqf_hm"      , &System.signal_state.iqfreeze.hm,                      &System.signal_state_res.iqfreeze.hm,                    sizeof(System.signal_state.iqfreeze.hm),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_HME                   , "iqf_hme"     , &System.signal_state.iqfreeze.hme,                     &System.signal_state_res.iqfreeze.hme,                   sizeof(System.signal_state.iqfreeze.hme),                FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_REFSN                 , "iqf_refsn"   , &System.signal_state.iqfreeze.refsn,                   &System.signal_state_res.iqfreeze.refsn,                 sizeof(System.signal_state.iqfreeze.refsn),              STRING_SYSTEM_T, 0xffff},
  {IQFREEZE_TRSN                  , "iqf_trsn"    , &System.signal_state.iqfreeze.trsn,                    &System.signal_state_res.iqfreeze.trsn,                  sizeof(System.signal_state.iqfreeze.trsn),               STRING_SYSTEM_T, 0xffff},
  {IQFREEZE_ALCOUNT               , "iqf_alc"     , &System.signal_state.iqfreeze.alcount,                 &System.signal_state_res.iqfreeze.alcount,               sizeof(System.signal_state.iqfreeze.alcount),            UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL1                   , "iqf_al1"     , &System.signal_state.iqfreeze.al1,                     &System.signal_state_res.iqfreeze.al1,                   sizeof(System.signal_state.iqfreeze.al1),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL2                   , "iqf_al2"     , &System.signal_state.iqfreeze.al2,                     &System.signal_state_res.iqfreeze.al2,                   sizeof(System.signal_state.iqfreeze.al2),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL3                   , "iqf_al3"     , &System.signal_state.iqfreeze.al3,                     &System.signal_state_res.iqfreeze.al3,                   sizeof(System.signal_state.iqfreeze.al3),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL4                   , "iqf_al4"     , &System.signal_state.iqfreeze.al4,                     &System.signal_state_res.iqfreeze.al4,                   sizeof(System.signal_state.iqfreeze.al4),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL5                   , "iqf_al5"     , &System.signal_state.iqfreeze.al5,                     &System.signal_state_res.iqfreeze.al5,                   sizeof(System.signal_state.iqfreeze.al5),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AL6                   , "iqf_al6"     , &System.signal_state.iqfreeze.al6,                     &System.signal_state_res.iqfreeze.al6,                   sizeof(System.signal_state.iqfreeze.al6),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_SN                    , "iqf_sn"      , &System.signal_state.iqfreeze.sn,                      &System.signal_state_res.iqfreeze.sn,                    sizeof(System.signal_state.iqfreeze.sn),                 STRING_SYSTEM_T, 0xffff},
  {IQFREEZE_VER                   , "iqf_ver"     , &System.signal_state.iqfreeze.ver,                     &System.signal_state_res.iqfreeze.ver,                   sizeof(System.signal_state.iqfreeze.ver),                STRING_SYSTEM_T, 0xffff},
  {IQFREEZE_REFTYPE               , "iqf_reft"    , &System.signal_state.iqfreeze.reftype,                 &System.signal_state_res.iqfreeze.reftype,               sizeof(System.signal_state.iqfreeze.reftype),            UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_NO_CONNECT            , "iqf_noc"     , &System.signal_state.iqfreeze.no_connect,              &System.signal_state_res.iqfreeze.no_connect,            sizeof(System.signal_state.iqfreeze.no_connect),         UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_ERR_BF                , "iqf_errbf"   , &System.signal_state.iqfreeze.err_bf,                  &System.signal_state_res.iqfreeze.err_bf,                sizeof(System.signal_state.iqfreeze.err_bf),             UINT16_SYSTEM_T,  0xffff},
  {IQFREEZE_IN_BF                 , "iqf_inbf"    , &System.signal_state.iqfreeze.in_bf,                   &System.signal_state_res.iqfreeze.in_bf,                 sizeof(System.signal_state.iqfreeze.in_bf),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_HMT                   , "iqf_hmt"     , &System.signal_state.iqfreeze.hmt,                     &System.signal_state_res.iqfreeze.hmt,                   sizeof(System.signal_state.iqfreeze.hmt),                FLOAT_SYSTEM_T,  0xffff},
  //{IQFREEZE_IN1                   , "iqf_in1"     , &System.signal_state.iqfreeze.in1,                     &System.signal_state_res.iqfreeze.in1,                   sizeof(System.signal_state.iqfreeze.in1),                UINT8_SYSTEM_T,  0xffff},
  //{IQFREEZE_IN2                   , "iqf_in2"     , &System.signal_state.iqfreeze.in2,                     &System.signal_state_res.iqfreeze.in2,                   sizeof(System.signal_state.iqfreeze.in2),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_LIC                   , "iqf_lic"     , &System.signal_state.iqfreeze.lic,                     &System.signal_state_res.iqfreeze.lic,                   sizeof(System.signal_state.iqfreeze.lic),                UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_UPTIME                , "iqf_upt"     , &System.signal_state.iqfreeze.uptime,                  &System.signal_state_res.iqfreeze.uptime,                sizeof(System.signal_state.iqfreeze.uptime),             UINT32_SYSTEM_T, 0xffff},
  //{IQFREEZE_TEMP_PROBE            , "iqf_tprob"   , &System.signal_state.iqfreeze.temp_probe,              &System.signal_state_res.iqfreeze.temp_probe,            sizeof(System.signal_state.iqfreeze.temp_probe),         FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_CONF2                  , "iqf_conf2"    , &System.signal_state.iqfreeze.conf2,                 &System.signal_state_res.iqfreeze.conf2,                 sizeof(System.signal_state.iqfreeze.conf2),               UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_CONF3                  , "iqf_conf3"    , &System.signal_state.iqfreeze.conf3,                 &System.signal_state_res.iqfreeze.conf3,                 sizeof(System.signal_state.iqfreeze.conf3),               UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_STATE2                 , "iqf_state2"   , &System.signal_state.iqfreeze.state2,                &System.signal_state_res.iqfreeze.state2,                sizeof(System.signal_state.iqfreeze.state2),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_STATE3                 , "iqf_state3"   , &System.signal_state.iqfreeze.state3,                &System.signal_state_res.iqfreeze.state3,                sizeof(System.signal_state.iqfreeze.state3),              UINT8_SYSTEM_T,  0xffff},
  {IQFREEZE_AD1                    , "iqf_ad1"      , &System.signal_state.iqfreeze.ad1,                   &System.signal_state_res.iqfreeze.ad1,                   sizeof(System.signal_state.iqfreeze.ad1),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AD2                    , "iqf_ad2"      , &System.signal_state.iqfreeze.ad2,                   &System.signal_state_res.iqfreeze.ad2,                   sizeof(System.signal_state.iqfreeze.ad2),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AD3                    , "iqf_ad3"      , &System.signal_state.iqfreeze.ad3,                   &System.signal_state_res.iqfreeze.ad3,                   sizeof(System.signal_state.iqfreeze.ad3),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AD4                    , "iqf_ad4"      , &System.signal_state.iqfreeze.ad4,                   &System.signal_state_res.iqfreeze.ad4,                   sizeof(System.signal_state.iqfreeze.ad4),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AD5                    , "iqf_ad5"      , &System.signal_state.iqfreeze.ad5,                   &System.signal_state_res.iqfreeze.ad5,                   sizeof(System.signal_state.iqfreeze.ad5),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_AD6                    , "iqf_ad6"      , &System.signal_state.iqfreeze.ad6,                   &System.signal_state_res.iqfreeze.ad6,                   sizeof(System.signal_state.iqfreeze.ad6),                 FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_HS                     , "iqf_hs"       , &System.signal_state.iqfreeze.hs,                    &System.signal_state_res.iqfreeze.hs,                    sizeof(System.signal_state.iqfreeze.hs),                  FLOAT_SYSTEM_T,  0xffff},
  {IQFREEZE_DEVTYPE                , "iqf_dtp"      , &System.signal_state.iqfreeze.dtp,                   &System.signal_state_res.iqfreeze.dtp,                   sizeof(System.signal_state.iqfreeze.dtp),                 UINT8_SYSTEM_T,  0xffff},
  //{IQFREEZE_TIME                   , "iqf_time"     , &System.signal_state.iqfreeze.time,                  &System.signal_state_res.iqfreeze.time,                  sizeof(System.signal_state.iqfreeze.time),                STRING_SYSTEM_T, 0xffff},
  {IQFREEZE_VRN                    , "iqf_vrn"      , &System.signal_state.iqfreeze.vrn,                   &System.signal_state_res.iqfreeze.vrn,                   sizeof(System.signal_state.iqfreeze.vrn),                 STRING_SYSTEM_T, 0xffff},
  //{IQFREEZE_REGTIME                , "iqf_rtime"    , &System.signal_state.iqfreeze.regtime,               &System.signal_state_res.iqfreeze.regtime,               sizeof(System.signal_state.iqfreeze.regtime),             STRING_SYSTEM_T, 0xffff},
#endif //(defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))

#if defined(NRF_BEACONS_SCANNER_PRESENT)
  {NRF_BEACONS_SCANNER_COMMUNICATION_STATE , "nrf_ok"      , &System.signal_state.is_nrf_beacons_scanner_ok,                          &System.signal_state_res.is_nrf_beacons_scanner_ok,                           sizeof(System.signal_state.is_nrf_beacons_scanner_ok),                       UINT8_SYSTEM_T,  0xffff},
  {NRF_BEACONS_SCANNER_AUTORIZIED          , "nrf_aut"     , &System.signal_state.nrf_beacons_scanner.is_autorized,                   &System.signal_state_res.nrf_beacons_scanner.is_autorized,                    sizeof(System.signal_state.nrf_beacons_scanner.is_autorized),                UINT8_SYSTEM_T,  0xffff},
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 0)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF1 , "nrf_vbf1"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[0],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[0],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[0]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF1 , "nrf_bbf1"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[0],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[0],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[0]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 1)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF2 , "nrf_vbf2"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[1],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[1],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[1]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF2 , "nrf_bbf2"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[1],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[1],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[1]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 2)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF3 , "nrf_vbf3"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[2],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[2],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[2]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF3 , "nrf_bbf3"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[2],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[2],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[2]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 3)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF4 , "nrf_vbf4"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[3],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[3],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[3]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF4 , "nrf_bbf4"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[3],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[3],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[3]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 4)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF5 , "nrf_vbf5"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[4],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[4],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[4]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF5 , "nrf_bbf5"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[4],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[4],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[4]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 5)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF6 , "nrf_vbf6"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[5],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[5],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[5]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF6 , "nrf_bbf6"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[5],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[5],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[5]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 6)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF7 , "nrf_vbf7"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[6],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[6],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[6]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF7 , "nrf_bbf7"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[6],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[6],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[6]), UINT32_SYSTEM_T, 0xffff},
#endif
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_STR , "nrf_bstr"   , &System.signal_state.nrf_beacons_scanner.visible_beacons_string,          &System.signal_state_res.nrf_beacons_scanner.visible_beacons_string,          sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_string),      STRING_SYSTEM_T, 0xffff},
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(TENZO_M_WEIGHER_PRESENT)
  {TENZO_M_WEIGHER_COMMUNICATION_STATE ,  "weig_ok"       , &System.signal_state.is_tenzo_m_weigher_ok,                               &System.signal_state_res.is_tenzo_m_weigher_ok,                               sizeof(System.signal_state.is_tenzo_m_weigher_ok),                           UINT8_SYSTEM_T,   0xffff},
  {TENZO_M_WEIGHER_NET_RAW ,              "weig_net"      , &System.signal_state.tenzo_m_weigher.net_raw_data,                        &System.signal_state_res.tenzo_m_weigher.net_raw_data,                        sizeof(System.signal_state.tenzo_m_weigher.net_raw_data),                    UINT32_SYSTEM_T,  0xffff},
  {TENZO_M_WEIGHER_GROSS_RAW ,            "weig_gro"      , &System.signal_state.tenzo_m_weigher.gross_raw_data,                      &System.signal_state_res.tenzo_m_weigher.gross_raw_data,                      sizeof(System.signal_state.tenzo_m_weigher.gross_raw_data),                  UINT32_SYSTEM_T,  0xffff},
#endif //TENZO_M_WEIGHER_PRESENT

#if defined(PROCESSOR_WEIGHT_PV310_PRESENT)
  {PV310_WEIGHER_COMMUNICATION_STATE ,  "pv310_ok"       , &System.signal_state.is_pv310_weigher_ok,                                  &System.signal_state_res.is_pv310_weigher_ok,                                 sizeof(System.signal_state.is_pv310_weigher_ok),                           UINT8_SYSTEM_T,   0xffff},
  {PV310_WEIGHER_NET_RAW ,              "pv310_net"      , &System.signal_state.pv310_weigher.net_raw_data,                           &System.signal_state_res.pv310_weigher.net_raw_data,                          sizeof(System.signal_state.pv310_weigher.net_raw_data),                    UINT32_SYSTEM_T,  0xffff},
#endif //PROCESSOR_WEIGHT_PV310_PRESENT

#ifdef __ICCARM__
#if (DEVICE_TYPE == DEVICE_TYPE_OBU_TACHO)
  {VEGA_KIMAX2_STRING, "kim2s"         ,&System.kimax2_string, &System.kimax2_string_res, sizeof(System.kimax2_string),   STRING_SYSTEM_T,   0xffff},
  {VEGA_FMS_TCO1_VAL,  "fms_tco1"      ,&System.fms_tco1,      &System.fms_tco1_res,      sizeof(System.fms_tco1),        UINT64_SYSTEM_T,   0xffff},
  //VEGA_CONTI_CPC1-VEGA_CONTI_CPC6 не записываются в ЧЯ через стандартный механизм, их нельзя читать через стандартный механизм!!!
  {VEGA_CONTI_CPC1,       "conti_cpc1",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
  {VEGA_CONTI_CPC2,       "conti_cpc2",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
  {VEGA_CONTI_CPC3,       "conti_cpc3",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
  {VEGA_CONTI_CPC4,       "conti_cpc4",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
  {VEGA_CONTI_CPC5,       "conti_cpc5",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
  {VEGA_CONTI_CPC6,       "conti_cpc6",   &System.cpc_dummy,   &System.cpc_dummy_res,   sizeof(uint64_t), UINT64_SYSTEM_T, 0xffff},
#endif //(DEVICE_YPE == DEVICE_TYPE_OBU_TACHO)

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_LIAZ)
  {VEGA_CAN_DM1,    "can_dm1",   &System.can_dm1,     &System.can_dm1_res,     sizeof(System.can_dm1),     STRING_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_1, "liaz_fms1", &System.liaz_fms[0], &System.liaz_fms_res[0], sizeof(System.liaz_fms[0]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_2, "liaz_fms2", &System.liaz_fms[1], &System.liaz_fms_res[1], sizeof(System.liaz_fms[1]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_3, "liaz_fms3", &System.liaz_fms[2], &System.liaz_fms_res[2], sizeof(System.liaz_fms[2]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_4, "liaz_fms4", &System.liaz_fms[3], &System.liaz_fms_res[3], sizeof(System.liaz_fms[3]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_5, "liaz_fms5", &System.liaz_fms[4], &System.liaz_fms_res[4], sizeof(System.liaz_fms[4]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_6, "liaz_fms6", &System.liaz_fms[5], &System.liaz_fms_res[5], sizeof(System.liaz_fms[5]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_7, "liaz_fms7", &System.liaz_fms[6], &System.liaz_fms_res[6], sizeof(System.liaz_fms[6]), UINT64_SYSTEM_T, 0xffff},
  {VEGA_LIAZ_FMS_8, "liaz_fms8", &System.liaz_fms[7], &System.liaz_fms_res[7], sizeof(System.liaz_fms[7]), UINT64_SYSTEM_T, 0xffff},
#endif //(DEVICE_YPE == DEVICE_TYPE_VEGA_MT_LIAZ)
#endif //__ICCARM__

#if defined(EXT_GSENSOR_PRESENT)
  {VEGA_EXT_GSENS_COMM_STATE, "g_comm" , &ext_gsens_state.communication_state,  &ext_gsens_state_res.communication_state, sizeof(ext_gsens_state.communication_state), UINT8_SYSTEM_T , 0xffff},
  {VEGA_EXT_GSENS_FLAGS     , "g_flags", &ext_gsens_state.flags              ,  &ext_gsens_state_res.flags              , sizeof(ext_gsens_state.flags)              , UINT16_SYSTEM_T, 0xffff},
  {VEGA_EXT_GSENS_MANEUVER_STR    , "g_man"  , &ext_gsens_state.maneuver           ,  &ext_gsens_state_res.maneuver           , sizeof(ext_gsens_state.maneuver)           , STRING_SYSTEM_T, 0xffff},
#endif //EXT_GSENSOR_PRESENT

#if defined(STRIZH_BS_PRESENT)
  {VEGA_STRIZH_BS_COMM_STATE, "strizhbs_comm" , &strizh_bs_state.communication_state,  &strizh_bs_state_res.communication_state, sizeof(strizh_bs_state.communication_state), UINT8_SYSTEM_T , 0xffff},
  {VEGA_STRIZH_BS_DATA      , "strizhbs_data" , &strizh_bs_state.last_data          ,  &strizh_bs_state_res.last_data          , sizeof(strizh_bs_state.last_data)          , STRING_SYSTEM_T, 0xffff},
#endif //STRIZH_BS_PRESENT

#if defined(TOUCHPRINT_PRESENT)
  {TOUCHPRINT_COOMUNICATION_STATE   , "tc_onl"     , &System.signal_state.is_touchprint_ok,                        &System.signal_state_res.is_touchprint_ok,                      sizeof(System.signal_state.is_touchprint_ok),                   UINT8_SYSTEM_T,  0xffff},

#if (MAX_TOUCHPRINT_AIN > 0)
  {TOUCHPRINT_AIN1_VALUE              , "tc_ts1"     , &System.signal_state.touchprint_state.temp_sensor1,           &System.signal_state_res.touchprint_state.temp_sensor1,         sizeof(System.signal_state.touchprint_state.temp_sensor1),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_AIN > 1)
  {TOUCHPRINT_AIN2_VALUE              , "tc_ts2"     , &System.signal_state.touchprint_state.temp_sensor2,           &System.signal_state_res.touchprint_state.temp_sensor2,         sizeof(System.signal_state.touchprint_state.temp_sensor2),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_AIN > 2)
  {TOUCHPRINT_AIN3_VALUE              , "tc_ts3"     , &System.signal_state.touchprint_state.temp_sensor3,           &System.signal_state_res.touchprint_state.temp_sensor3,         sizeof(System.signal_state.touchprint_state.temp_sensor3),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_AIN > 3)
  {TOUCHPRINT_AIN4_VALUE              , "tc_ts4"     , &System.signal_state.touchprint_state.temp_sensor4,           &System.signal_state_res.touchprint_state.temp_sensor4,         sizeof(System.signal_state.touchprint_state.temp_sensor4),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_AIN > 4)
  {TOUCHPRINT_AIN5_VALUE              , "tc_ts5"     , &System.signal_state.touchprint_state.temp_sensor5,           &System.signal_state_res.touchprint_state.temp_sensor5,         sizeof(System.signal_state.touchprint_state.temp_sensor5),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_AIN > 5)
  {TOUCHPRINT_AIN6_VALUE              , "tc_ts6"     , &System.signal_state.touchprint_state.temp_sensor6,           &System.signal_state_res.touchprint_state.temp_sensor6,         sizeof(System.signal_state.touchprint_state.temp_sensor6),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (TOUCHPRINT_TOUCHPRINT_AIN > 6)
#error   Нужно добавить аналоговые входы терморегистратора TOUCHPRINT
#endif

  {TOUCHPRINT_DIN_VALUE               , "tc_di"     , &System.signal_state.touchprint_state.dig_sensor,             &System.signal_state_res.touchprint_state.dig_sensor,          sizeof(System.signal_state.touchprint_state.dig_sensor),       UINT8_SYSTEM_T,  0xffff},

#if (MAX_TOUCHPRINT_HIN > 0)
  {TOUCHPRINT_HIN1_VALUE              , "tc_hs1"     , &System.signal_state.touchprint_state.hum_sensor1,           &System.signal_state_res.touchprint_state.hum_sensor1,         sizeof(System.signal_state.touchprint_state.hum_sensor1),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 1)
  {TOUCHPRINT_HIN2_VALUE              , "tc_hs2"     , &System.signal_state.touchprint_state.hum_sensor2,           &System.signal_state_res.touchprint_state.hum_sensor2,         sizeof(System.signal_state.touchprint_state.hum_sensor2),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 2)
  {TOUCHPRINT_HIN3_VALUE              , "tc_hs3"     , &System.signal_state.touchprint_state.hum_sensor3,           &System.signal_state_res.touchprint_state.hum_sensor3,         sizeof(System.signal_state.touchprint_state.hum_sensor3),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 3)
  {TOUCHPRINT_HIN4_VALUE              , "tc_hs4"     , &System.signal_state.touchprint_state.hum_sensor4,           &System.signal_state_res.touchprint_state.hum_sensor4,         sizeof(System.signal_state.touchprint_state.hum_sensor4),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 4)
  {TOUCHPRINT_HIN5_VALUE              , "tc_hs5"     , &System.signal_state.touchprint_state.hum_sensor5,           &System.signal_state_res.touchprint_state.hum_sensor5,         sizeof(System.signal_state.touchprint_state.hum_sensor5),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 5)
  {TOUCHPRINT_HIN6_VALUE              , "tc_hs6"     , &System.signal_state.touchprint_state.hum_sensor6,           &System.signal_state_res.touchprint_state.hum_sensor6,         sizeof(System.signal_state.touchprint_state.hum_sensor6),      FLOAT_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_HIN > 6)
#error   Нужно добавить входы датчиков влажности терморегистратора
#endif

#if (MAX_TOUCHPRINT_IN > 0)
  {TOUCHPRINT_IN1_CONF              , "tc_cfg_s1"     , &System.signal_state.touchprint_state.config_sensor1,           &System.signal_state_res.touchprint_state.config_sensor1,         sizeof(System.signal_state.touchprint_state.config_sensor1),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 1)
  {TOUCHPRINT_IN2_CONF              , "tc_cfg_s2"     , &System.signal_state.touchprint_state.config_sensor2,           &System.signal_state_res.touchprint_state.config_sensor2,         sizeof(System.signal_state.touchprint_state.config_sensor2),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 2)
  {TOUCHPRINT_IN3_CONF              , "tc_cfg_s3"     , &System.signal_state.touchprint_state.config_sensor3,           &System.signal_state_res.touchprint_state.config_sensor3,         sizeof(System.signal_state.touchprint_state.config_sensor3),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 3)
  {TOUCHPRINT_IN4_CONF              , "tc_cfg_s4"     , &System.signal_state.touchprint_state.config_sensor4,           &System.signal_state_res.touchprint_state.config_sensor4,         sizeof(System.signal_state.touchprint_state.config_sensor4),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 4)
  {TOUCHPRINT_IN5_CONF              , "tc_cfg_s5"     , &System.signal_state.touchprint_state.config_sensor5,           &System.signal_state_res.touchprint_state.config_sensor5,         sizeof(System.signal_state.touchprint_state.config_sensor5),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 5)
  {TOUCHPRINT_IN6_CONF              , "tc_cfg_s6"     , &System.signal_state.touchprint_state.config_sensor6,           &System.signal_state_res.touchprint_state.config_sensor6,         sizeof(System.signal_state.touchprint_state.config_sensor6),      UINT16_SYSTEM_T,  0xffff},
#endif
#if (MAX_TOUCHPRINT_IN > 6)
#error   Нужно добавить конфиги входов терморегистратора
#endif

  {TOUCHPRINT_DSR_STATE           , "tc_dsr_s"         , &System.signal_state.touchprint_state.dsr_var_ok,            &System.signal_state_res.touchprint_state.dsr_var_ok,          sizeof(System.signal_state.touchprint_state.dsr_var_ok),              UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_S1_PROBE            , "tc_s1_p"          , &System.signal_state.touchprint_state.s1_probe,              &System.signal_state_res.touchprint_state.s1_probe,            sizeof(System.signal_state.touchprint_state.s1_probe),                FLOAT_SYSTEM_T,   0xffff},
  {TOUCHPRINT_S2_PROBE            , "tc_s2_p"          , &System.signal_state.touchprint_state.s2_probe,              &System.signal_state_res.touchprint_state.s2_probe,            sizeof(System.signal_state.touchprint_state.s2_probe),                FLOAT_SYSTEM_T,   0xffff},
  {TOUCHPRINT_M_HOURS             , "tc_mhrs"          , &System.signal_state.touchprint_state.maintenance_hours,     &System.signal_state_res.touchprint_state.maintenance_hours,   sizeof(System.signal_state.touchprint_state.maintenance_hours),       UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_T_HOURS             , "tc_thrs"          , &System.signal_state.touchprint_state.total_hours,           &System.signal_state_res.touchprint_state.total_hours,         sizeof(System.signal_state.touchprint_state.total_hours),             UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_R_HOURS             , "tc_rhrs"          , &System.signal_state.touchprint_state.road_hours,            &System.signal_state_res.touchprint_state.road_hours,          sizeof(System.signal_state.touchprint_state.road_hours),              UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_STBY_HOURS          , "tc_shrs"          , &System.signal_state.touchprint_state.stby_hours,            &System.signal_state_res.touchprint_state.stby_hours,          sizeof(System.signal_state.touchprint_state.stby_hours),              UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_ALRM_STATUS         , "tc_alr"           , &System.signal_state.touchprint_state.alarm_status,          &System.signal_state_res.touchprint_state.alarm_status,        sizeof(System.signal_state.touchprint_state.alarm_status),            UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_SET_POINT1          , "tc_sp1"           , &System.signal_state.touchprint_state.set_point1,            &System.signal_state_res.touchprint_state.set_point1,          sizeof(System.signal_state.touchprint_state.set_point1),              FLOAT_SYSTEM_T,   0xffff},
  {TOUCHPRINT_SET_POINT2          , "tc_sp2"           , &System.signal_state.touchprint_state.set_point2,            &System.signal_state_res.touchprint_state.set_point2,          sizeof(System.signal_state.touchprint_state.set_point2),              FLOAT_SYSTEM_T,   0xffff},
  {TOUCHPRINT_DSR_DINPUT          , "tc_dsr_di"        , &System.signal_state.touchprint_state.dig_input,             &System.signal_state_res.touchprint_state.dig_input,           sizeof(System.signal_state.touchprint_state.dig_input),               UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_DSR_STATUS          , "tc_dsr_stat"      , &System.signal_state.touchprint_state.status,                &System.signal_state_res.touchprint_state.status,              sizeof(System.signal_state.touchprint_state.status),                  UINT8_SYSTEM_T,   0xffff},
  {TOUCHPRINT_DSR_MODE_C1         , "tc_dsr_c1m"  , &System.signal_state.touchprint_state.op_mode_compartment1,    &System.signal_state_res.touchprint_state.op_mode_compartment1,         sizeof(System.signal_state.touchprint_state.op_mode_compartment1),   UINT8_SYSTEM_T,  0xffff},
  {TOUCHPRINT_DSR_MODE_C2         , "tc_dsr_c2m"  , &System.signal_state.touchprint_state.op_mode_compartment2,    &System.signal_state_res.touchprint_state.op_mode_compartment2,         sizeof(System.signal_state.touchprint_state.op_mode_compartment2),   UINT8_SYSTEM_T,  0xffff},
  {TOUCHPRINT_DOUT_STATE          , "tc_do"            , &System.signal_state.touchprint_state.state_dig_output,      &System.signal_state_res.touchprint_state.state_dig_output,    sizeof(System.signal_state.touchprint_state.state_dig_output),        UINT32_SYSTEM_T,  0xffff},
  {TOUCHPRINT_FMW_VERSION         , "tc_fw"            , &System.signal_state.touchprint_state.firmware_version,      &System.signal_state_res.touchprint_state.firmware_version,    sizeof(System.signal_state.touchprint_state.firmware_version),        UINT16_SYSTEM_T,  0xffff},
  {TOUCHPRINT_FMW_RELEASE         , "tc_rel"           , &System.signal_state.touchprint_state.firmware_release,      &System.signal_state_res.touchprint_state.firmware_release,    sizeof(System.signal_state.touchprint_state.firmware_release),        UINT16_SYSTEM_T,  0xffff},
#endif //TOUCHPRINT_PRESENT

#if defined(IBOX_PRESENT)
  {IBX_COOMUNICATION_STATE         , "ibx_onl"                   , &System.signal_state.is_ibox_ok,                           &System.signal_state_res.is_ibox_ok,                              sizeof(System.signal_state.is_ibox_ok),                             UINT8_SYSTEM_T,   0xffff},
  {IBX_FUEL_LEVEL                  , "ibx_fuel_l"                , &System.signal_state.ibox_state.fuel_level,                &System.signal_state_res.ibox_state.fuel_level,                   sizeof(System.signal_state.ibox_state.fuel_level),                  FLOAT_SYSTEM_T,  0xffff},
  {IBX_BATTERY_POTENTIAL           , "ibx_bat"                   , &System.signal_state.ibox_state.battery_potential,         &System.signal_state_res.ibox_state.battery_potential,            sizeof(System.signal_state.ibox_state.battery_potential),           FLOAT_SYSTEM_T, 0xffff},
  {IBX_SOFT_IDENT                  , "ibx_s_id"                  , &System.signal_state.ibox_state.soft_ident,                &System.signal_state_res.ibox_state.soft_ident,                   sizeof(System.signal_state.ibox_state.soft_ident),                  STRING_SYSTEM_T, 0xffff},
  {IBX_TOTAL_ELECTRIC_HOURS        , "ibx_ehrs"                  , &System.signal_state.ibox_state.total_electric_hours,      &System.signal_state_res.ibox_state.total_electric_hours,         sizeof(System.signal_state.ibox_state.total_electric_hours),        FLOAT_SYSTEM_T, 0xffff},
  {IBX_COMPONENT_IDENT             , "ibx_c_id"                  , &System.signal_state.ibox_state.component_ident,           &System.signal_state_res.ibox_state.component_ident,              sizeof(System.signal_state.ibox_state.component_ident),             STRING_SYSTEM_T, 0xffff},
  {IBX_TOTAL_VEHICLE_HOURS         , "ibx_v_hrs"                 , &System.signal_state.ibox_state.total_vehicle_hours,       &System.signal_state_res.ibox_state.total_vehicle_hours,          sizeof(System.signal_state.ibox_state.total_vehicle_hours),         FLOAT_SYSTEM_T, 0xffff},
  {IBX_TOTAL_ENGINE_HOURS          , "ibx_en_hrs"                , &System.signal_state.ibox_state.total_engine_hours,        &System.signal_state_res.ibox_state.total_engine_hours,           sizeof(System.signal_state.ibox_state.total_engine_hours),          FLOAT_SYSTEM_T, 0xffff},
//Trailer1 zone1
  {IBX_T1_Z1_A_ZONES_ALRM_TYPE     , "ibx_z1_at"                 , &System.signal_state.ibox_state.t1_z1_a_zones_alrm_type,   &System.signal_state_res.ibox_state.t1_z1_a_zones_alrm_type,      sizeof(System.signal_state.ibox_state.t1_z1_a_zones_alrm_type),     UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_ALRM_CODE             , "ibx_z1_ac"                 , &System.signal_state.ibox_state.t1_z1_alrm_code,           &System.signal_state_res.ibox_state.t1_z1_alrm_code,              sizeof(System.signal_state.ibox_state.t1_z1_alrm_code),             UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_TEMP_SENSOR_ASSIGN    , "ibx_z1_t_as"               , &System.signal_state.ibox_state.t1_z1_temp_sensor_assign,  &System.signal_state_res.ibox_state.t1_z1_temp_sensor_assign,     sizeof(System.signal_state.ibox_state.t1_z1_temp_sensor_assign),    UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_RETURN_AIR1_TEMP      , "ibx_z1_rai1"               , &System.signal_state.ibox_state.t1_z1_return_air1_temp,    &System.signal_state_res.ibox_state.t1_z1_return_air1_temp,       sizeof(System.signal_state.ibox_state.t1_z1_return_air1_temp),      FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_SUPPLY1_TEMP          , "ibx_z1_s1"                 , &System.signal_state.ibox_state.t1_z1_supply1_temp,        &System.signal_state_res.ibox_state.t1_z1_supply1_temp,           sizeof(System.signal_state.ibox_state.t1_z1_supply1_temp),          FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_TEMP_SETPOINT         , "ibx_z1_sp"                 , &System.signal_state.ibox_state.t1_z1_temp_setpoint,       &System.signal_state_res.ibox_state.t1_z1_temp_setpoint,          sizeof(System.signal_state.ibox_state.t1_z1_temp_setpoint),         FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_EVAPORATOR_COIL_TEMP  , "ibx_z1_ev"                 , &System.signal_state.ibox_state.t1_z1_evaporator_coil_temp,&System.signal_state_res.ibox_state.t1_z1_evaporator_coil_temp,   sizeof(System.signal_state.ibox_state.t1_z1_evaporator_coil_temp),  FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_RETURN_AIR2_TEMP      , "ibx_z1_rai2"               , &System.signal_state.ibox_state.t1_z1_return_air2_temp,    &System.signal_state_res.ibox_state.t1_z1_return_air2_temp,       sizeof(System.signal_state.ibox_state.t1_z1_return_air2_temp),      FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_SUPPLY2_TEMP          , "ibx_z1_s2"                 , &System.signal_state.ibox_state.t1_z1_supply2_temp,        &System.signal_state_res.ibox_state.t1_z1_supply2_temp,           sizeof(System.signal_state.ibox_state.t1_z1_supply2_temp),          FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z1_OPERATING_MODE        , "ibx_z1_opm"                , &System.signal_state.ibox_state.t1_z1_operating_mode,      &System.signal_state_res.ibox_state.t1_z1_operating_mode,         sizeof(System.signal_state.ibox_state.t1_z1_operating_mode),        UINT8_SYSTEM_T,  0xffff},
//Trailer1 zone2
  {IBX_T1_Z2_ALRM_TYPE             , "ibx_z2_at"                 , &System.signal_state.ibox_state.t1_z2_alrm_type,           &System.signal_state_res.ibox_state.t1_z2_alrm_type,              sizeof(System.signal_state.ibox_state.t1_z2_alrm_type),             UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_ALRM_CODE             , "ibx_z2_ac"                 , &System.signal_state.ibox_state.t1_z2_alrm_code,           &System.signal_state_res.ibox_state.t1_z2_alrm_code,              sizeof(System.signal_state.ibox_state.t1_z2_alrm_code),             UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_TEMP_SENSOR_ASSIGN    , "ibx_z2_t_as"               , &System.signal_state.ibox_state.t1_z2_temp_sensor_assign,  &System.signal_state_res.ibox_state.t1_z2_temp_sensor_assign,     sizeof(System.signal_state.ibox_state.t1_z2_temp_sensor_assign),    UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_RETURN_AIR1_TEMP      , "ibx_z2_rai1"               , &System.signal_state.ibox_state.t1_z2_return_air1_temp,    &System.signal_state_res.ibox_state.t1_z2_return_air1_temp,       sizeof(System.signal_state.ibox_state.t1_z2_return_air1_temp),      FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_SUPPLY1_TEMP          , "ibx_z2_s1"                 , &System.signal_state.ibox_state.t1_z2_supply1_temp,        &System.signal_state_res.ibox_state.t1_z2_supply1_temp,           sizeof(System.signal_state.ibox_state.t1_z2_supply1_temp),          FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_TEMP_SETPOINT         , "ibx_z2_sp"                 , &System.signal_state.ibox_state.t1_z2_temp_setpoint,       &System.signal_state_res.ibox_state.t1_z2_temp_setpoint,          sizeof(System.signal_state.ibox_state.t1_z2_temp_setpoint),         FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_EVAPORATOR_COIL_TEMP  , "ibx_z2_ev"                 , &System.signal_state.ibox_state.t1_z2_evaporator_coil_temp,&System.signal_state_res.ibox_state.t1_z2_evaporator_coil_temp,   sizeof(System.signal_state.ibox_state.t1_z2_evaporator_coil_temp),  FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_RETURN_AIR2_TEMP      , "ibx_z2_rai2"               , &System.signal_state.ibox_state.t1_z2_return_air2_temp,    &System.signal_state_res.ibox_state.t1_z2_return_air2_temp,       sizeof(System.signal_state.ibox_state.t1_z2_return_air2_temp),      FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_SUPPLY2_TEMP          , "ibx_z2_s2"                 , &System.signal_state.ibox_state.t1_z2_supply2_temp,        &System.signal_state_res.ibox_state.t1_z2_supply2_temp,           sizeof(System.signal_state.ibox_state.t1_z2_supply2_temp),          FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_Z2_OPERATING_MODE        , "ibx_z2_opm"                , &System.signal_state.ibox_state.t1_z2_operating_mode,      &System.signal_state_res.ibox_state.t1_z2_operating_mode,         sizeof(System.signal_state.ibox_state.t1_z2_operating_mode),        UINT8_SYSTEM_T,  0xffff},
//Trailer1 zone3
  {IBX_T1_Z3_ALRM_TYPE             , "ibx_z3_at"                 , &System.signal_state.ibox_state.t1_z3_alrm_type,           &System.signal_state_res.ibox_state.t1_z3_alrm_type,              sizeof(System.signal_state.ibox_state.t1_z3_alrm_type),             UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z3_ALRM_CODE             , "ibx_z3_ac"                 , &System.signal_state.ibox_state.t1_z3_alrm_code,           &System.signal_state_res.ibox_state.t1_z3_alrm_code,              sizeof(System.signal_state.ibox_state.t1_z3_alrm_code),             UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z3_TEMP_SENSOR_ASSIGN    , "ibx_z3_t_as"               , &System.signal_state.ibox_state.t1_z3_temp_sensor_assign,  &System.signal_state_res.ibox_state.t1_z3_temp_sensor_assign,     sizeof(System.signal_state.ibox_state.t1_z3_temp_sensor_assign),    UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_Z3_RETURN_AIR1_TEMP      , "ibx_z3_rai1"               , &System.signal_state.ibox_state.t1_z3_return_air1_temp,    &System.signal_state_res.ibox_state.t1_z3_return_air1_temp,       sizeof(System.signal_state.ibox_state.t1_z3_return_air1_temp),      FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_SUPPLY1_TEMP          , "ibx_z3_s1"                 , &System.signal_state.ibox_state.t1_z3_supply1_temp,        &System.signal_state_res.ibox_state.t1_z3_supply1_temp,           sizeof(System.signal_state.ibox_state.t1_z3_supply1_temp),          FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_TEMP_SETPOINT         , "ibx_z3_sp"                 , &System.signal_state.ibox_state.t1_z3_temp_setpoint,       &System.signal_state_res.ibox_state.t1_z3_temp_setpoint,          sizeof(System.signal_state.ibox_state.t1_z3_temp_setpoint),         FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_EVAPORATOR_COIL_TEMP  , "ibx_z3_ev"                 , &System.signal_state.ibox_state.t1_z3_evaporator_coil_temp,&System.signal_state_res.ibox_state.t1_z3_evaporator_coil_temp,   sizeof(System.signal_state.ibox_state.t1_z3_evaporator_coil_temp),  FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_RETURN_AIR2_TEMP      , "ibx_z3_rai2"               , &System.signal_state.ibox_state.t1_z3_return_air2_temp,    &System.signal_state_res.ibox_state.t1_z3_return_air2_temp,       sizeof(System.signal_state.ibox_state.t1_z3_return_air2_temp),      FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_SUPPLY2_TEMP          , "ibx_z3_s2"                 , &System.signal_state.ibox_state.t1_z3_supply2_temp,        &System.signal_state_res.ibox_state.t1_z3_supply2_temp,           sizeof(System.signal_state.ibox_state.t1_z3_supply2_temp),          FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_Z3_OPERATING_MODE        , "ibx_z3_opm"                , &System.signal_state.ibox_state.t1_z3_operating_mode,      &System.signal_state_res.ibox_state.t1_z3_operating_mode,         sizeof(System.signal_state.ibox_state.t1_z3_operating_mode),        UINT8_SYSTEM_T,  0xffff},
//DAS or Cargo Watch Sensors Information
  {IBX_T1_DIN0_3                   , "ibx_din0_3"                , &System.signal_state.ibox_state.t1_din0_3,                 &System.signal_state_res.ibox_state.t1_din0_3,                    sizeof(System.signal_state.ibox_state.t1_din0_3),                   UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_SENSOR_ASSIGN            , "ibx_sens_as"               , &System.signal_state.ibox_state.t1_sens_assign,            &System.signal_state_res.ibox_state.t1_sens_assign,               sizeof(System.signal_state.ibox_state.t1_sens_assign),              UINT8_SYSTEM_T,  0xffff},
  {IBX_T1_TEMP_SENSOR1             , "ibx_t_s1"                  , &System.signal_state.ibox_state.t1_temp_sensor1,           &System.signal_state_res.ibox_state.t1_temp_sensor1,              sizeof(System.signal_state.ibox_state.t1_temp_sensor1),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_TEMP_SENSOR2             , "ibx_t_s2"                  , &System.signal_state.ibox_state.t1_temp_sensor2,           &System.signal_state_res.ibox_state.t1_temp_sensor2,              sizeof(System.signal_state.ibox_state.t1_temp_sensor2),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_TEMP_SENSOR3             , "ibx_t_s3"                  , &System.signal_state.ibox_state.t1_temp_sensor3,           &System.signal_state_res.ibox_state.t1_temp_sensor3,              sizeof(System.signal_state.ibox_state.t1_temp_sensor3),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_TEMP_SENSOR4             , "ibx_t_s4"                  , &System.signal_state.ibox_state.t1_temp_sensor4,           &System.signal_state_res.ibox_state.t1_temp_sensor4,              sizeof(System.signal_state.ibox_state.t1_temp_sensor4),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_TEMP_SENSOR5             , "ibx_t_s5"                  , &System.signal_state.ibox_state.t1_temp_sensor5,           &System.signal_state_res.ibox_state.t1_temp_sensor5,              sizeof(System.signal_state.ibox_state.t1_temp_sensor5),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_TEMP_SENSOR6             , "ibx_t_s6"                  , &System.signal_state.ibox_state.t1_temp_sensor6,           &System.signal_state_res.ibox_state.t1_temp_sensor6,              sizeof(System.signal_state.ibox_state.t1_temp_sensor6),             FLOAT_SYSTEM_T, 0xffff},
  {IBX_T1_HUMIDITY_SENSOR          , "ibx_h_s"                   , &System.signal_state.ibox_state.t1_humidity_sensor,        &System.signal_state_res.ibox_state.t1_humidity_sensor,           sizeof(System.signal_state.ibox_state.t1_humidity_sensor),          FLOAT_SYSTEM_T,  0xffff},
  {IBX_T1_FUEL_LEVEL_SENSOR        , "ibx_f_l"                   , &System.signal_state.ibox_state.t1_fuel_level_sensor,      &System.signal_state_res.ibox_state.t1_fuel_level_sensor,         sizeof(System.signal_state.ibox_state.t1_fuel_level_sensor),        FLOAT_SYSTEM_T,  0xffff},
  {IBX_MID                         , "ibx_mid"                   , &System.signal_state.ibox_state.mid_t,                     &System.signal_state_res.ibox_state.mid_t,                        sizeof(System.signal_state.ibox_state.mid_t),                       UINT8_SYSTEM_T,  0xffff},
#endif //IBOX_PRESENT

#if defined(FLOWMETER_PRESENT)
  {FLOWMETER_COOMUNICATION_STATE   , "fm_onl", &System.signal_state.is_flowmeter_ok,                 &System.signal_state_res.is_flowmeter_ok,                 sizeof(System.signal_state.is_flowmeter_ok),                 UINT8_SYSTEM_T,   0xffff},
  {FLOWMETER_FUEL_VOLUME    , "fm_f_vol"     , &System.signal_state.flowmeter_state.fuel_volume,     &System.signal_state_res.flowmeter_state.fuel_volume,     sizeof(System.signal_state.flowmeter_state.fuel_volume),     FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_FLOW_RATE      , "fm_fl_rate"   , &System.signal_state.flowmeter_state.flow_rate,       &System.signal_state_res.flowmeter_state.flow_rate,       sizeof(System.signal_state.flowmeter_state.flow_rate),       FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_STATUS         , "fm_stat"      , &System.signal_state.flowmeter_state.status,          &System.signal_state_res.flowmeter_state.status,          sizeof(System.signal_state.flowmeter_state.status),          UINT16_SYSTEM_T,  0xffff},
  {FLOWMETER_FUEL_VOLUME_FC , "fm_f_vol_fc"  , &System.signal_state.flowmeter_state.fuel_volume_fc,  &System.signal_state_res.flowmeter_state.fuel_volume_fc,  sizeof(System.signal_state.flowmeter_state.fuel_volume_fc),  FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_FLOW_RATE_FC   , "fm_fl_rate_fc", &System.signal_state.flowmeter_state.flow_rate_fc,    &System.signal_state_res.flowmeter_state.flow_rate_fc,    sizeof(System.signal_state.flowmeter_state.flow_rate_fc),    FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_TEMP_FC        , "fm_t_fc"      , &System.signal_state.flowmeter_state.temp_fc,         &System.signal_state_res.flowmeter_state.temp_fc,         sizeof(System.signal_state.flowmeter_state.temp_fc),         FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_FUEL_VOLUME_RC , "fm_f_vol_rc"  , &System.signal_state.flowmeter_state.fuel_volume_rc,  &System.signal_state_res.flowmeter_state.fuel_volume_rc,  sizeof(System.signal_state.flowmeter_state.fuel_volume_rc),  FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_FLOW_RATE_RC   , "fm_fl_rate_rc", &System.signal_state.flowmeter_state.flow_rate_rc,    &System.signal_state_res.flowmeter_state.flow_rate_rc,    sizeof(System.signal_state.flowmeter_state.flow_rate_rc),    FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_TEMP_RC        , "fm_t_rc"      , &System.signal_state.flowmeter_state.temp_rc,         &System.signal_state_res.flowmeter_state.temp_rc,         sizeof(System.signal_state.flowmeter_state.temp_rc),         FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_IDL   , "fm_a_f_idl"   , &System.signal_state.flowmeter_state.acc_fuel_idl,    &System.signal_state_res.flowmeter_state.acc_fuel_idl,    sizeof(System.signal_state.flowmeter_state.acc_fuel_idl),    FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_NOM   , "fm_a_f_nom"   , &System.signal_state.flowmeter_state.acc_fuel_nom,    &System.signal_state_res.flowmeter_state.acc_fuel_nom,    sizeof(System.signal_state.flowmeter_state.acc_fuel_nom),    FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_OVER  , "fm_a_f_ov"    , &System.signal_state.flowmeter_state.acc_fuel_over,   &System.signal_state_res.flowmeter_state.acc_fuel_over,   sizeof(System.signal_state.flowmeter_state.acc_fuel_over),   FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_CH    , "fm_a_f_ch"    , &System.signal_state.flowmeter_state.acc_fuel_ch,     &System.signal_state_res.flowmeter_state.acc_fuel_ch,     sizeof(System.signal_state.flowmeter_state.acc_fuel_ch),     FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_NEG   , "fm_a_f_neg"   , &System.signal_state.flowmeter_state.acc_fuel_neg,    &System.signal_state_res.flowmeter_state.acc_fuel_neg,    sizeof(System.signal_state.flowmeter_state.acc_fuel_neg),    FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_FC_IDL, "fm_a_f_fc_idl", &System.signal_state.flowmeter_state.acc_fuel_fc_idl, &System.signal_state_res.flowmeter_state.acc_fuel_fc_idl, sizeof(System.signal_state.flowmeter_state.acc_fuel_fc_idl), FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_FC_NOM, "fm_a_f_fc_nom", &System.signal_state.flowmeter_state.acc_fuel_fc_nom, &System.signal_state_res.flowmeter_state.acc_fuel_fc_nom, sizeof(System.signal_state.flowmeter_state.acc_fuel_fc_nom), FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_FC_OV , "fm_a_f_fc_ov" , &System.signal_state.flowmeter_state.acc_fuel_fc_over,&System.signal_state_res.flowmeter_state.acc_fuel_fc_over,sizeof(System.signal_state.flowmeter_state.acc_fuel_fc_over),FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_FC_CH , "fm_a_f_fc_ch" , &System.signal_state.flowmeter_state.acc_fuel_fc_ch,  &System.signal_state_res.flowmeter_state.acc_fuel_fc_ch,  sizeof(System.signal_state.flowmeter_state.acc_fuel_fc_ch),  FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_RC_IDL, "fm_a_f_rc_idl", &System.signal_state.flowmeter_state.acc_fuel_rc_idl, &System.signal_state_res.flowmeter_state.acc_fuel_rc_idl, sizeof(System.signal_state.flowmeter_state.acc_fuel_rc_idl), FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_RC_NOM, "fm_a_f_rc_nom", &System.signal_state.flowmeter_state.acc_fuel_rc_nom, &System.signal_state_res.flowmeter_state.acc_fuel_rc_nom, sizeof(System.signal_state.flowmeter_state.acc_fuel_rc_nom), FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_RC_OV , "fm_a_f_rc_ov" , &System.signal_state.flowmeter_state.acc_fuel_rc_over,&System.signal_state_res.flowmeter_state.acc_fuel_rc_over,sizeof(System.signal_state.flowmeter_state.acc_fuel_rc_over),FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_ACC_FUEL_RC_CH , "fm_a_f_rc_ch" , &System.signal_state.flowmeter_state.acc_fuel_rc_ch,  &System.signal_state_res.flowmeter_state.acc_fuel_rc_ch,  sizeof(System.signal_state.flowmeter_state.acc_fuel_rc_ch),  FLOAT_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_IDL       , "fm_time_idl"  , &System.signal_state.flowmeter_state.time_idl,        &System.signal_state_res.flowmeter_state.time_idl,        sizeof(System.signal_state.flowmeter_state.time_idl),        UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_NOM       , "fm_time_nom"  , &System.signal_state.flowmeter_state.time_nom,        &System.signal_state_res.flowmeter_state.time_nom,        sizeof(System.signal_state.flowmeter_state.time_nom),        UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_OV        , "fm_time_ov"   , &System.signal_state.flowmeter_state.time_over,       &System.signal_state_res.flowmeter_state.time_over,       sizeof(System.signal_state.flowmeter_state.time_over),       UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_CH        , "fm_time_ch"   , &System.signal_state.flowmeter_state.time_ch,         &System.signal_state_res.flowmeter_state.time_ch,         sizeof(System.signal_state.flowmeter_state.time_ch),         UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_NEG       , "fm_time_neg"  , &System.signal_state.flowmeter_state.time_neg,        &System.signal_state_res.flowmeter_state.time_neg,        sizeof(System.signal_state.flowmeter_state.time_neg),        UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_FC_IDL    , "fm_ti_fc_idl" , &System.signal_state.flowmeter_state.time_fc_idl,     &System.signal_state_res.flowmeter_state.time_fc_idl,     sizeof(System.signal_state.flowmeter_state.time_fc_idl),     UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_FC_NOM    , "fm_ti_fc_nom" , &System.signal_state.flowmeter_state.time_fc_nom,     &System.signal_state_res.flowmeter_state.time_fc_nom,     sizeof(System.signal_state.flowmeter_state.time_fc_nom),     UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_FC_OV     , "fm_ti_fc_ov"  , &System.signal_state.flowmeter_state.time_fc_over,    &System.signal_state_res.flowmeter_state.time_fc_over,    sizeof(System.signal_state.flowmeter_state.time_fc_over),    UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_FC_CH     , "fm_ti_fc_ch"  , &System.signal_state.flowmeter_state.time_fc_ch,      &System.signal_state_res.flowmeter_state.time_fc_ch,      sizeof(System.signal_state.flowmeter_state.time_fc_ch),      UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_RC_IDL    , "fm_ti_rc_idl" , &System.signal_state.flowmeter_state.time_rc_idl,     &System.signal_state_res.flowmeter_state.time_rc_idl,     sizeof(System.signal_state.flowmeter_state.time_rc_idl),     UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_RC_NOM    , "fm_ti_rc_nom" , &System.signal_state.flowmeter_state.time_rc_nom,     &System.signal_state_res.flowmeter_state.time_rc_nom,     sizeof(System.signal_state.flowmeter_state.time_rc_nom),     UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_RC_OV     , "fm_ti_rc_ov"  , &System.signal_state.flowmeter_state.time_rc_over,    &System.signal_state_res.flowmeter_state.time_rc_over,    sizeof(System.signal_state.flowmeter_state.time_rc_over),    UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_RC_CH     , "fm_ti_rc_ch"  , &System.signal_state.flowmeter_state.time_rc_ch,      &System.signal_state_res.flowmeter_state.time_rc_ch,      sizeof(System.signal_state.flowmeter_state.time_rc_ch),      UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_INTERV    , "fm_ti_inter"  , &System.signal_state.flowmeter_state.time_interv,     &System.signal_state_res.flowmeter_state.time_interv,     sizeof(System.signal_state.flowmeter_state.time_interv),     UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_TIME_SENS      , "fm_ti_sens"   , &System.signal_state.flowmeter_state.time_sens,       &System.signal_state_res.flowmeter_state.time_sens,       sizeof(System.signal_state.flowmeter_state.time_sens),       UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_SERIAL_NUM     , "fm_s_num"     , &System.signal_state.flowmeter_state.serial_num,      &System.signal_state_res.flowmeter_state.serial_num,      sizeof(System.signal_state.flowmeter_state.serial_num),      UINT32_SYSTEM_T,  0xffff},
  {FLOWMETER_DEVICE_TYPE    , "fm_dev_type"  , &System.signal_state.flowmeter_state.device_type,     &System.signal_state_res.flowmeter_state.device_type,     sizeof(System.signal_state.flowmeter_state.device_type),     UINT16_SYSTEM_T,  0xffff},
#endif //(FLOWMETER_PRESENT)

#if defined(TPMS_PRESENT)
  {TPMS_COMUNICATION_STATE   , "tpms_ok"        , &System.signal_state.is_tpms_ok,                     &System.signal_state_res.is_tpms_ok,                     sizeof(System.signal_state.is_tpms_ok),                   UINT8_SYSTEM_T,  0xffff},
  //{TPMS_TRAILER_ID1        , "tpms_trid1"     , &System.signal_state.tpms.trailerID1,             &System.signal_state_res.tpms.trailerID1,             sizeof(System.signal_state.tpms.trailerID1),            UINT8_SYSTEM_T,  0xffff},
  //{TPMS_TRAILER_ID2        , "tpms_trid2"     , &System.signal_state.tpms.trailerID2,             &System.signal_state_res.tpms.trailerID2,             sizeof(System.signal_state.tpms.trailerID2),            UINT8_SYSTEM_T,  0xffff},
  //{TPMS_TRAILER_ID3        , "tpms_trid3"     , &System.signal_state.tpms.trailerID3,             &System.signal_state_res.tpms.trailerID3,             sizeof(System.signal_state.tpms.trailerID3),            UINT8_SYSTEM_T,  0xffff},

#if (MAX_TPMS_DAT_COUNT > 0)
  {TPMS_ID1                 , "tpms_id1"        , &System.signal_state.tpms.id[0],                     &System.signal_state_res.tpms.id[0],                     sizeof(System.signal_state.tpms.id[0]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE1           , "tpms_pr1"        , &System.signal_state.tpms.pressure[0],               &System.signal_state_res.tpms.pressure[0],               sizeof(System.signal_state.tpms.pressure[0]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER1             , "tpms_t1"         , &System.signal_state.tpms.temper[0],                 &System.signal_state_res.tpms.temper[0],                 sizeof(System.signal_state.tpms.temper[0]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS1              , "tpms_fl1"        , &System.signal_state.tpms.flags[0],                  &System.signal_state_res.tpms.flags[0],                  sizeof(System.signal_state.tpms.flags[0]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 1)
  {TPMS_ID2                 , "tpms_id2"        , &System.signal_state.tpms.id[1],                     &System.signal_state_res.tpms.id[1],                     sizeof(System.signal_state.tpms.id[1]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE2           , "tpms_pr2"        , &System.signal_state.tpms.pressure[1],               &System.signal_state_res.tpms.pressure[1],               sizeof(System.signal_state.tpms.pressure[1]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER2             , "tpms_t2"         , &System.signal_state.tpms.temper[1],                 &System.signal_state_res.tpms.temper[1],                 sizeof(System.signal_state.tpms.temper[1]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS2              , "tpms_fl2"        , &System.signal_state.tpms.flags[1],                  &System.signal_state_res.tpms.flags[1],                  sizeof(System.signal_state.tpms.flags[1]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 2)
  {TPMS_ID3                 , "tpms_id3"        , &System.signal_state.tpms.id[2],                     &System.signal_state_res.tpms.id[2],                     sizeof(System.signal_state.tpms.id[2]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE3           , "tpms_pr3"        , &System.signal_state.tpms.pressure[2],               &System.signal_state_res.tpms.pressure[2],               sizeof(System.signal_state.tpms.pressure[2]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER3             , "tpms_t3"         , &System.signal_state.tpms.temper[2],                 &System.signal_state_res.tpms.temper[2],                 sizeof(System.signal_state.tpms.temper[2]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS3              , "tpms_fl3"        , &System.signal_state.tpms.flags[2],                  &System.signal_state_res.tpms.flags[2],                  sizeof(System.signal_state.tpms.flags[2]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 3)
  {TPMS_ID4                 , "tpms_id4"        , &System.signal_state.tpms.id[3],                     &System.signal_state_res.tpms.id[3],                     sizeof(System.signal_state.tpms.id[3]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE4           , "tpms_pr4"        , &System.signal_state.tpms.pressure[3],               &System.signal_state_res.tpms.pressure[3],               sizeof(System.signal_state.tpms.pressure[3]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER4             , "tpms_t4"         , &System.signal_state.tpms.temper[3],                 &System.signal_state_res.tpms.temper[3],                 sizeof(System.signal_state.tpms.temper[3]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS4              , "tpms_fl4"        , &System.signal_state.tpms.flags[3],                  &System.signal_state_res.tpms.flags[3],                  sizeof(System.signal_state.tpms.flags[3]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 4)
  {TPMS_ID5                 , "tpms_id5"        , &System.signal_state.tpms.id[4],                     &System.signal_state_res.tpms.id[4],                     sizeof(System.signal_state.tpms.id[4]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE5           , "tpms_pr5"        , &System.signal_state.tpms.pressure[4],               &System.signal_state_res.tpms.pressure[4],               sizeof(System.signal_state.tpms.pressure[4]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER5             , "tpms_t5"         , &System.signal_state.tpms.temper[4],                 &System.signal_state_res.tpms.temper[4],                 sizeof(System.signal_state.tpms.temper[4]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS5              , "tpms_fl5"        , &System.signal_state.tpms.flags[4],                  &System.signal_state_res.tpms.flags[4],                  sizeof(System.signal_state.tpms.flags[4]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 5)
  {TPMS_ID6                 , "tpms_id6"        , &System.signal_state.tpms.id[5],                     &System.signal_state_res.tpms.id[5],                     sizeof(System.signal_state.tpms.id[5]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE6           , "tpms_pr6"        , &System.signal_state.tpms.pressure[5],               &System.signal_state_res.tpms.pressure[5],               sizeof(System.signal_state.tpms.pressure[5]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER6             , "tpms_t6"         , &System.signal_state.tpms.temper[5],                 &System.signal_state_res.tpms.temper[5],                 sizeof(System.signal_state.tpms.temper[5]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS6              , "tpms_fl6"        , &System.signal_state.tpms.flags[5],                  &System.signal_state_res.tpms.flags[5],                  sizeof(System.signal_state.tpms.flags[5]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 6)
  {TPMS_ID7                 , "tpms_id7"        , &System.signal_state.tpms.id[6],                     &System.signal_state_res.tpms.id[6],                     sizeof(System.signal_state.tpms.id[6]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE7           , "tpms_pr7"        , &System.signal_state.tpms.pressure[6],               &System.signal_state_res.tpms.pressure[6],               sizeof(System.signal_state.tpms.pressure[6]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER7             , "tpms_t7"         , &System.signal_state.tpms.temper[6],                 &System.signal_state_res.tpms.temper[6],                 sizeof(System.signal_state.tpms.temper[6]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS7              , "tpms_fl7"        , &System.signal_state.tpms.flags[6],                  &System.signal_state_res.tpms.flags[6],                  sizeof(System.signal_state.tpms.flags[6]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 7)
  {TPMS_ID8                 , "tpms_id8"        , &System.signal_state.tpms.id[7],                     &System.signal_state_res.tpms.id[7],                     sizeof(System.signal_state.tpms.id[7]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE8           , "tpms_pr8"        , &System.signal_state.tpms.pressure[7],               &System.signal_state_res.tpms.pressure[7],               sizeof(System.signal_state.tpms.pressure[7]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER8             , "tpms_t8"         , &System.signal_state.tpms.temper[7],                 &System.signal_state_res.tpms.temper[7],                 sizeof(System.signal_state.tpms.temper[7]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS8              , "tpms_fl8"        , &System.signal_state.tpms.flags[7],                  &System.signal_state_res.tpms.flags[7],                  sizeof(System.signal_state.tpms.flags[7]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 8)
  {TPMS_ID9                 , "tpms_id9"        , &System.signal_state.tpms.id[8],                     &System.signal_state_res.tpms.id[8],                     sizeof(System.signal_state.tpms.id[8]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE9           , "tpms_pr9"        , &System.signal_state.tpms.pressure[8],               &System.signal_state_res.tpms.pressure[8],               sizeof(System.signal_state.tpms.pressure[8]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER9             , "tpms_t9"         , &System.signal_state.tpms.temper[8],                 &System.signal_state_res.tpms.temper[8],                 sizeof(System.signal_state.tpms.temper[8]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS9              , "tpms_fl9"        , &System.signal_state.tpms.flags[8],                  &System.signal_state_res.tpms.flags[8],                  sizeof(System.signal_state.tpms.flags[8]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 9)
  {TPMS_ID10                , "tpms_id10"       , &System.signal_state.tpms.id[9],                     &System.signal_state_res.tpms.id[9],                     sizeof(System.signal_state.tpms.id[9]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE10          , "tpms_pr10"       , &System.signal_state.tpms.pressure[9],               &System.signal_state_res.tpms.pressure[9],               sizeof(System.signal_state.tpms.pressure[9]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER10            , "tpms_t10"        , &System.signal_state.tpms.temper[9],                 &System.signal_state_res.tpms.temper[9],                 sizeof(System.signal_state.tpms.temper[9]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS10             , "tpms_fl10"       , &System.signal_state.tpms.flags[9],                  &System.signal_state_res.tpms.flags[9],                  sizeof(System.signal_state.tpms.flags[9]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 10)
  {TPMS_ID11                , "tpms_id11"       , &System.signal_state.tpms.id[10],                    &System.signal_state_res.tpms.id[10],                    sizeof(System.signal_state.tpms.id[10]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE11          , "tpms_pr11"       , &System.signal_state.tpms.pressure[10],              &System.signal_state_res.tpms.pressure[10],              sizeof(System.signal_state.tpms.pressure[10]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER11            , "tpms_t11"        , &System.signal_state.tpms.temper[10],                &System.signal_state_res.tpms.temper[10],                sizeof(System.signal_state.tpms.temper[10]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS11             , "tpms_fl11"       , &System.signal_state.tpms.flags[10],                 &System.signal_state_res.tpms.flags[10],                 sizeof(System.signal_state.tpms.flags[10]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 11)
  {TPMS_ID12                , "tpms_id12"       , &System.signal_state.tpms.id[11],                    &System.signal_state_res.tpms.id[11],                    sizeof(System.signal_state.tpms.id[11]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE12          , "tpms_pr12"       , &System.signal_state.tpms.pressure[11],              &System.signal_state_res.tpms.pressure[11],              sizeof(System.signal_state.tpms.pressure[11]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER12            , "tpms_t12"        , &System.signal_state.tpms.temper[11],                &System.signal_state_res.tpms.temper[11],                sizeof(System.signal_state.tpms.temper[11]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS12             , "tpms_fl12"       , &System.signal_state.tpms.flags[11],                 &System.signal_state_res.tpms.flags[11],                 sizeof(System.signal_state.tpms.flags[11]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 12)
  {TPMS_ID13                , "tpms_id13"       , &System.signal_state.tpms.id[12],                    &System.signal_state_res.tpms.id[12],                    sizeof(System.signal_state.tpms.id[12]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE13          , "tpms_pr13"       , &System.signal_state.tpms.pressure[12],              &System.signal_state_res.tpms.pressure[12],              sizeof(System.signal_state.tpms.pressure[12]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER13            , "tpms_t13"        , &System.signal_state.tpms.temper[12],                &System.signal_state_res.tpms.temper[12],                sizeof(System.signal_state.tpms.temper[12]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS13             , "tpms_fl13"       , &System.signal_state.tpms.flags[12],                 &System.signal_state_res.tpms.flags[12],                 sizeof(System.signal_state.tpms.flags[12]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 13)
  {TPMS_ID14                , "tpms_id14"       , &System.signal_state.tpms.id[13],                    &System.signal_state_res.tpms.id[13],                    sizeof(System.signal_state.tpms.id[13]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE14          , "tpms_pr14"       , &System.signal_state.tpms.pressure[13],              &System.signal_state_res.tpms.pressure[13],              sizeof(System.signal_state.tpms.pressure[13]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER14            , "tpms_t14"        , &System.signal_state.tpms.temper[13],                &System.signal_state_res.tpms.temper[13],                sizeof(System.signal_state.tpms.temper[13]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS14             , "tpms_fl14"       , &System.signal_state.tpms.flags[13],                 &System.signal_state_res.tpms.flags[13],                 sizeof(System.signal_state.tpms.flags[13]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 14)
  {TPMS_ID15                , "tpms_id15"       , &System.signal_state.tpms.id[14],                    &System.signal_state_res.tpms.id[14],                    sizeof(System.signal_state.tpms.id[14]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE15          , "tpms_pr15"       , &System.signal_state.tpms.pressure[14],              &System.signal_state_res.tpms.pressure[14],              sizeof(System.signal_state.tpms.pressure[14]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER15            , "tpms_t15"        , &System.signal_state.tpms.temper[14],                &System.signal_state_res.tpms.temper[14],                sizeof(System.signal_state.tpms.temper[14]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS15             , "tpms_fl15"       , &System.signal_state.tpms.flags[14],                 &System.signal_state_res.tpms.flags[14],                 sizeof(System.signal_state.tpms.flags[14]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 15)
  {TPMS_ID16                , "tpms_id16"       , &System.signal_state.tpms.id[15],                    &System.signal_state_res.tpms.id[15],                    sizeof(System.signal_state.tpms.id[15]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE16          , "tpms_pr16"       , &System.signal_state.tpms.pressure[15],              &System.signal_state_res.tpms.pressure[15],              sizeof(System.signal_state.tpms.pressure[15]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER16            , "tpms_t16"        , &System.signal_state.tpms.temper[15],                &System.signal_state_res.tpms.temper[15],                sizeof(System.signal_state.tpms.temper[15]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS16             , "tpms_fl16"       , &System.signal_state.tpms.flags[15],                 &System.signal_state_res.tpms.flags[15],                 sizeof(System.signal_state.tpms.flags[15]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 16)
  {TPMS_ID17                , "tpms_id17"       , &System.signal_state.tpms.id[16],                    &System.signal_state_res.tpms.id[16],                    sizeof(System.signal_state.tpms.id[16]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE17          , "tpms_pr17"       , &System.signal_state.tpms.pressure[16],              &System.signal_state_res.tpms.pressure[16],              sizeof(System.signal_state.tpms.pressure[16]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER17            , "tpms_t17"        , &System.signal_state.tpms.temper[16],                &System.signal_state_res.tpms.temper[16],                sizeof(System.signal_state.tpms.temper[16]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS17             , "tpms_fl17"       , &System.signal_state.tpms.flags[16],                 &System.signal_state_res.tpms.flags[16],                 sizeof(System.signal_state.tpms.flags[16]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 17)
  {TPMS_ID18                , "tpms_id1"        , &System.signal_state.tpms.id[17],                    &System.signal_state_res.tpms.id[17],                    sizeof(System.signal_state.tpms.id[17]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE18          , "tpms_pr18"       , &System.signal_state.tpms.pressure[17],              &System.signal_state_res.tpms.pressure[17],              sizeof(System.signal_state.tpms.pressure[17]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER18            , "tpms_t18"        , &System.signal_state.tpms.temper[17],                &System.signal_state_res.tpms.temper[17],                sizeof(System.signal_state.tpms.temper[17]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS18             , "tpms_fl18"       , &System.signal_state.tpms.flags[17],                 &System.signal_state_res.tpms.flags[17],                 sizeof(System.signal_state.tpms.flags[17]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 18)
  {TPMS_ID19                , "tpms_id19"       , &System.signal_state.tpms.id[18],                    &System.signal_state_res.tpms.id[18],                    sizeof(System.signal_state.tpms.id[18]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE19          , "tpms_pr19"       , &System.signal_state.tpms.pressure[18],              &System.signal_state_res.tpms.pressure[18],              sizeof(System.signal_state.tpms.pressure[18]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER19            , "tpms_t19"        , &System.signal_state.tpms.temper[18],                &System.signal_state_res.tpms.temper[18],                sizeof(System.signal_state.tpms.temper[18]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS19             , "tpms_fl19"       , &System.signal_state.tpms.flags[18],                 &System.signal_state_res.tpms.flags[18],                 sizeof(System.signal_state.tpms.flags[18]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 19)
  {TPMS_ID20                , "tpms_id20"       , &System.signal_state.tpms.id[19],                    &System.signal_state_res.tpms.id[19],                    sizeof(System.signal_state.tpms.id[19]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE20          , "tpms_pr20"       , &System.signal_state.tpms.pressure[19],              &System.signal_state_res.tpms.pressure[19],              sizeof(System.signal_state.tpms.pressure[19]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER20            , "tpms_t20"        , &System.signal_state.tpms.temper[19],                &System.signal_state_res.tpms.temper[19],                sizeof(System.signal_state.tpms.temper[19]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS20             , "tpms_fl20"       , &System.signal_state.tpms.flags[19],                 &System.signal_state_res.tpms.flags[19],                 sizeof(System.signal_state.tpms.flags[19]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 20)
  {TPMS_ID21                , "tpms_id21"       , &System.signal_state.tpms.id[20],                    &System.signal_state_res.tpms.id[20],                    sizeof(System.signal_state.tpms.id[20]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE21          , "tpms_pr21"       , &System.signal_state.tpms.pressure[20],              &System.signal_state_res.tpms.pressure[20],              sizeof(System.signal_state.tpms.pressure[20]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER21            , "tpms_t21"        , &System.signal_state.tpms.temper[20],                &System.signal_state_res.tpms.temper[20],                sizeof(System.signal_state.tpms.temper[20]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS21             , "tpms_fl21"       , &System.signal_state.tpms.flags[20],                 &System.signal_state_res.tpms.flags[20],                 sizeof(System.signal_state.tpms.flags[20]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 21)
  {TPMS_ID22                , "tpms_id22"       , &System.signal_state.tpms.id[21],                    &System.signal_state_res.tpms.id[21],                    sizeof(System.signal_state.tpms.id[21]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE22          , "tpms_pr22"       , &System.signal_state.tpms.pressure[21],              &System.signal_state_res.tpms.pressure[21],              sizeof(System.signal_state.tpms.pressure[21]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER22            , "tpms_t22"        , &System.signal_state.tpms.temper[21],                &System.signal_state_res.tpms.temper[21],                sizeof(System.signal_state.tpms.temper[21]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS22             , "tpms_fl22"       , &System.signal_state.tpms.flags[21],                 &System.signal_state_res.tpms.flags[21],                 sizeof(System.signal_state.tpms.flags[21]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 22)
  {TPMS_ID23                , "tpms_id23"       , &System.signal_state.tpms.id[22],                    &System.signal_state_res.tpms.id[22],                    sizeof(System.signal_state.tpms.id[22]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE23          , "tpms_pr23"       , &System.signal_state.tpms.pressure[22],              &System.signal_state_res.tpms.pressure[22],              sizeof(System.signal_state.tpms.pressure[22]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER23            , "tpms_t23"        , &System.signal_state.tpms.temper[22],                &System.signal_state_res.tpms.temper[22],                sizeof(System.signal_state.tpms.temper[22]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS23             , "tpms_fl23"       , &System.signal_state.tpms.flags[22],                 &System.signal_state_res.tpms.flags[22],                 sizeof(System.signal_state.tpms.flags[22]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 23)
  {TPMS_ID24                , "tpms_id24"       , &System.signal_state.tpms.id[23],                    &System.signal_state_res.tpms.id[23],                    sizeof(System.signal_state.tpms.id[23]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE24          , "tpms_pr24"       , &System.signal_state.tpms.pressure[23],              &System.signal_state_res.tpms.pressure[23],              sizeof(System.signal_state.tpms.pressure[23]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER24            , "tpms_t24"        , &System.signal_state.tpms.temper[23],                &System.signal_state_res.tpms.temper[23],                sizeof(System.signal_state.tpms.temper[23]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS24             , "tpms_fl24"       , &System.signal_state.tpms.flags[23],                 &System.signal_state_res.tpms.flags[23],                 sizeof(System.signal_state.tpms.flags[23]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 24)
  {TPMS_ID25                , "tpms_id25"       , &System.signal_state.tpms.id[24],                    &System.signal_state_res.tpms.id[24],                    sizeof(System.signal_state.tpms.id[24]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE25          , "tpms_pr25"       , &System.signal_state.tpms.pressure[24],              &System.signal_state_res.tpms.pressure[24],              sizeof(System.signal_state.tpms.pressure[24]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER25            , "tpms_t25"        , &System.signal_state.tpms.temper[24],                &System.signal_state_res.tpms.temper[24],                sizeof(System.signal_state.tpms.temper[24]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS25             , "tpms_fl25"       , &System.signal_state.tpms.flags[24],                 &System.signal_state_res.tpms.flags[24],                 sizeof(System.signal_state.tpms.flags[24]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 25)
  {TPMS_ID26                , "tpms_id26"       , &System.signal_state.tpms.id[25],                    &System.signal_state_res.tpms.id[25],                    sizeof(System.signal_state.tpms.id[25]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE26          , "tpms_pr26"       , &System.signal_state.tpms.pressure[25],              &System.signal_state_res.tpms.pressure[25],              sizeof(System.signal_state.tpms.pressure[25]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER26            , "tpms_t26"        , &System.signal_state.tpms.temper[25],                &System.signal_state_res.tpms.temper[25],                sizeof(System.signal_state.tpms.temper[25]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS26             , "tpms_fl26"       , &System.signal_state.tpms.flags[25],                 &System.signal_state_res.tpms.flags[25],                 sizeof(System.signal_state.tpms.flags[25]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 26)
  {TPMS_ID27                , "tpms_id27"       , &System.signal_state.tpms.id[26],                    &System.signal_state_res.tpms.id[26],                    sizeof(System.signal_state.tpms.id[26]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE27          , "tpms_pr27"       , &System.signal_state.tpms.pressure[26],              &System.signal_state_res.tpms.pressure[26],              sizeof(System.signal_state.tpms.pressure[26]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER27            , "tpms_t27"        , &System.signal_state.tpms.temper[26],                &System.signal_state_res.tpms.temper[26],                sizeof(System.signal_state.tpms.temper[26]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS27             , "tpms_fl27"       , &System.signal_state.tpms.flags[26],                 &System.signal_state_res.tpms.flags[26],                 sizeof(System.signal_state.tpms.flags[26]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 27)
  {TPMS_ID28                , "tpms_id28"       , &System.signal_state.tpms.id[27],                    &System.signal_state_res.tpms.id[27],                    sizeof(System.signal_state.tpms.id[27]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE28          , "tpms_pr28"       , &System.signal_state.tpms.pressure[27],              &System.signal_state_res.tpms.pressure[27],              sizeof(System.signal_state.tpms.pressure[27]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER28            , "tpms_t28"        , &System.signal_state.tpms.temper[27],                &System.signal_state_res.tpms.temper[27],                sizeof(System.signal_state.tpms.temper[27]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS28             , "tpms_fl28"       , &System.signal_state.tpms.flags[27],                 &System.signal_state_res.tpms.flags[27],                 sizeof(System.signal_state.tpms.flags[27]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 28)
  {TPMS_ID29                , "tpms_id29"       , &System.signal_state.tpms.id[28],                    &System.signal_state_res.tpms.id[28],                    sizeof(System.signal_state.tpms.id[28]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE29          , "tpms_pr29"       , &System.signal_state.tpms.pressure[28],              &System.signal_state_res.tpms.pressure[28],              sizeof(System.signal_state.tpms.pressure[28]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER29            , "tpms_t29"        , &System.signal_state.tpms.temper[28],                &System.signal_state_res.tpms.temper[28],                sizeof(System.signal_state.tpms.temper[28]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS29             , "tpms_fl29"       , &System.signal_state.tpms.flags[28],                 &System.signal_state_res.tpms.flags[28],                 sizeof(System.signal_state.tpms.flags[28]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 29)
  {TPMS_ID30                , "tpms_id30"       , &System.signal_state.tpms.id[29],                    &System.signal_state_res.tpms.id[29],                    sizeof(System.signal_state.tpms.id[0]),                    UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE30          , "tpms_pr30"       , &System.signal_state.tpms.pressure[29],              &System.signal_state_res.tpms.pressure[29],              sizeof(System.signal_state.tpms.pressure[0]),              FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER30            , "tpms_t30"        , &System.signal_state.tpms.temper[29],                &System.signal_state_res.tpms.temper[29],                sizeof(System.signal_state.tpms.temper[0]),                FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS30             , "tpms_fl30"       , &System.signal_state.tpms.flags[29],                 &System.signal_state_res.tpms.flags[29],                 sizeof(System.signal_state.tpms.flags[0]),                 UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 30)
  {TPMS_ID31                , "tpms_id31"       , &System.signal_state.tpms.id[30],                    &System.signal_state_res.tpms.id[30],                    sizeof(System.signal_state.tpms.id[30]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE31          , "tpms_pr31"       , &System.signal_state.tpms.pressure[30],              &System.signal_state_res.tpms.pressure[30],              sizeof(System.signal_state.tpms.pressure[30]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER31            , "tpms_t31"        , &System.signal_state.tpms.temper[30],                &System.signal_state_res.tpms.temper[30],                sizeof(System.signal_state.tpms.temper[30]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS31             , "tpms_fl31"       , &System.signal_state.tpms.flags[30],                 &System.signal_state_res.tpms.flags[30],                 sizeof(System.signal_state.tpms.flags[30]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 31)
  {TPMS_ID32                , "tpms_id32"       , &System.signal_state.tpms.id[31],                    &System.signal_state_res.tpms.id[31],                    sizeof(System.signal_state.tpms.id[31]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE32          , "tpms_pr32"       , &System.signal_state.tpms.pressure[31],              &System.signal_state_res.tpms.pressure[31],              sizeof(System.signal_state.tpms.pressure[31]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER32            , "tpms_t32"        , &System.signal_state.tpms.temper[31],                &System.signal_state_res.tpms.temper[31],                sizeof(System.signal_state.tpms.temper[31]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS32             , "tpms_fl32"       , &System.signal_state.tpms.flags[31],                 &System.signal_state_res.tpms.flags[31],                 sizeof(System.signal_state.tpms.flags[31]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 32)
  {TPMS_ID33                , "tpms_id33"       , &System.signal_state.tpms.id[32],                    &System.signal_state_res.tpms.id[32],                    sizeof(System.signal_state.tpms.id[32]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE33          , "tpms_pr33"       , &System.signal_state.tpms.pressure[32],              &System.signal_state_res.tpms.pressure[32],              sizeof(System.signal_state.tpms.pressure[32]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER33            , "tpms_t33"        , &System.signal_state.tpms.temper[32],                &System.signal_state_res.tpms.temper[32],                sizeof(System.signal_state.tpms.temper[32]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS33             , "tpms_fl33"       , &System.signal_state.tpms.flags[32],                 &System.signal_state_res.tpms.flags[32],                 sizeof(System.signal_state.tpms.flags[32]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 33)
  {TPMS_ID34                , "tpms_id34"       , &System.signal_state.tpms.id[33],                    &System.signal_state_res.tpms.id[33],                    sizeof(System.signal_state.tpms.id[33]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE34          , "tpms_pr34"       , &System.signal_state.tpms.pressure[33],              &System.signal_state_res.tpms.pressure[33],              sizeof(System.signal_state.tpms.pressure[33]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER34            , "tpms_t34"        , &System.signal_state.tpms.temper[33],                &System.signal_state_res.tpms.temper[33],                sizeof(System.signal_state.tpms.temper[33]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS34             , "tpms_fl34"       , &System.signal_state.tpms.flags[33],                 &System.signal_state_res.tpms.flags[33],                 sizeof(System.signal_state.tpms.flags[33]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 34)
  {TPMS_ID35                , "tpms_id35"       , &System.signal_state.tpms.id[34],                    &System.signal_state_res.tpms.id[34],                    sizeof(System.signal_state.tpms.id[34]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE35          , "tpms_pr35"       , &System.signal_state.tpms.pressure[34],              &System.signal_state_res.tpms.pressure[34],              sizeof(System.signal_state.tpms.pressure[34]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER35            , "tpms_t35"        , &System.signal_state.tpms.temper[34],                &System.signal_state_res.tpms.temper[34],                sizeof(System.signal_state.tpms.temper[34]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS35             , "tpms_fl35"       , &System.signal_state.tpms.flags[34],                 &System.signal_state_res.tpms.flags[34],                 sizeof(System.signal_state.tpms.flags[34]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 35)
  {TPMS_ID36                , "tpms_ID36"       , &System.signal_state.tpms.id[35],                    &System.signal_state_res.tpms.id[35],                    sizeof(System.signal_state.tpms.id[35]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE36          , "tpms_pr36"       , &System.signal_state.tpms.pressure[35],              &System.signal_state_res.tpms.pressure[35],              sizeof(System.signal_state.tpms.pressure[35]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER36            , "tpms_t36"        , &System.signal_state.tpms.temper[35],                &System.signal_state_res.tpms.temper[35],                sizeof(System.signal_state.tpms.temper[35]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS36             , "tpms_fl36"       , &System.signal_state.tpms.flags[35],                 &System.signal_state_res.tpms.flags[35],                 sizeof(System.signal_state.tpms.flags[35]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 36)
  {TPMS_ID37                , "tpms_id37"       , &System.signal_state.tpms.id[36],                    &System.signal_state_res.tpms.id[36],                    sizeof(System.signal_state.tpms.id[36]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE37          , "tpms_pr37"       , &System.signal_state.tpms.pressure[36],              &System.signal_state_res.tpms.pressure[36],              sizeof(System.signal_state.tpms.pressure[36]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER37            , "tpms_t37"        , &System.signal_state.tpms.temper[36],                &System.signal_state_res.tpms.temper[36],                sizeof(System.signal_state.tpms.temper[36]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS37             , "tpms_fl37"       , &System.signal_state.tpms.flags[36],                 &System.signal_state_res.tpms.flags[36],                 sizeof(System.signal_state.tpms.flags[36]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 37)
  {TPMS_ID38                , "tpms_id38"       , &System.signal_state.tpms.id[37],                    &System.signal_state_res.tpms.id[37],                    sizeof(System.signal_state.tpms.id[37]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE38          , "tpms_pr38"       , &System.signal_state.tpms.pressure[37],              &System.signal_state_res.tpms.pressure[37],              sizeof(System.signal_state.tpms.pressure[37]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER38            , "tpms_t38"        , &System.signal_state.tpms.temper[37],                &System.signal_state_res.tpms.temper[37],                sizeof(System.signal_state.tpms.temper[37]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS38             , "tpms_fl38"       , &System.signal_state.tpms.flags[37],                 &System.signal_state_res.tpms.flags[37],                 sizeof(System.signal_state.tpms.flags[37]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 38)
  {TPMS_ID39                , "tpms_id39"       , &System.signal_state.tpms.id[38],                    &System.signal_state_res.tpms.id[38],                    sizeof(System.signal_state.tpms.id[38]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE39          , "tpms_pr39"       , &System.signal_state.tpms.pressure[38],              &System.signal_state_res.tpms.pressure[38],              sizeof(System.signal_state.tpms.pressure[38]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER39            , "tpms_t39"        , &System.signal_state.tpms.temper[38],                &System.signal_state_res.tpms.temper[38],                sizeof(System.signal_state.tpms.temper[38]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS39             , "tpms_fl39"       , &System.signal_state.tpms.flags[38],                 &System.signal_state_res.tpms.flags[38],                 sizeof(System.signal_state.tpms.flags[38]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 39)
  {TPMS_ID40                , "tpms_id40"       , &System.signal_state.tpms.id[39],                    &System.signal_state_res.tpms.id[39],                    sizeof(System.signal_state.tpms.id[39]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE40          , "tpms_pr40"       , &System.signal_state.tpms.pressure[39],              &System.signal_state_res.tpms.pressure[39],              sizeof(System.signal_state.tpms.pressure[39]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER40            , "tpms_t40"        , &System.signal_state.tpms.temper[39],                &System.signal_state_res.tpms.temper[39],                sizeof(System.signal_state.tpms.temper[39]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS40             , "tpms_fl40"       , &System.signal_state.tpms.flags[39],                 &System.signal_state_res.tpms.flags[39],                 sizeof(System.signal_state.tpms.flags[39]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 40)
  {TPMS_ID41                , "tpms_id41"       , &System.signal_state.tpms.id[40],                    &System.signal_state_res.tpms.id[40],                    sizeof(System.signal_state.tpms.id[40]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE41          , "tpms_pr41"       , &System.signal_state.tpms.pressure[40],              &System.signal_state_res.tpms.pressure[40],              sizeof(System.signal_state.tpms.pressure[40]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER41            , "tpms_t41"        , &System.signal_state.tpms.temper[40],                &System.signal_state_res.tpms.temper[40],                sizeof(System.signal_state.tpms.temper[40]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS41             , "tpms_fl41"       , &System.signal_state.tpms.flags[40],                 &System.signal_state_res.tpms.flags[40],                 sizeof(System.signal_state.tpms.flags[40]),                UINT8_SYSTEM_T,  0xffff},
#endif
#if (MAX_TPMS_DAT_COUNT > 41)
  {TPMS_ID42                , "tpms_id42"       , &System.signal_state.tpms.id[41],                    &System.signal_state_res.tpms.id[41],                    sizeof(System.signal_state.tpms.id[41]),                   UINT32_SYSTEM_T, 0xffff},
  {TPMS_PRESSURE42          , "tpms_pr42"       , &System.signal_state.tpms.pressure[41],              &System.signal_state_res.tpms.pressure[41],              sizeof(System.signal_state.tpms.pressure[41]),             FLOAT_SYSTEM_T,  0xffff},
  {TPMS_TEMPER42            , "tpms_t42"        , &System.signal_state.tpms.temper[41],                &System.signal_state_res.tpms.temper[41],                sizeof(System.signal_state.tpms.temper[41]),               FLOAT_SYSTEM_T,  0xffff},
  {TPMS_FLAGS42             , "tpms_fl42"       , &System.signal_state.tpms.flags[41],                 &System.signal_state_res.tpms.flags[41],                 sizeof(System.signal_state.tpms.flags[41]),                UINT8_SYSTEM_T,  0xffff},
#endif
#endif //TPMS_PRESENT

#if defined(IRIDIUM_PRESENT)
  {IRIDIUM_COOMUNICATION_STATE, "ir_ok"      , &System.signal_state.is_iridium_ok,                    &System.signal_state_res.is_iridium_ok,                  sizeof(System.signal_state.is_iridium_ok),                   UINT8_SYSTEM_T,   0xffff},
  {IRIDIUM_MESS_STATE       , "ir_mes_st"    , &System.signal_state.iridium_mess_state,               &System.signal_state_res.iridium_mess_state,             sizeof(System.signal_state.iridium_mess_state),              UINT16_SYSTEM_T,  0xffff},
  {IRIDIUM_TRAFFIC          , "ir_traffic"   , &System.signal_state.iridium_traffic,                  &System.signal_state_res.iridium_traffic,                sizeof(System.signal_state.iridium_traffic),                 UINT32_SYSTEM_T,  0xffff},
#endif //IRIDIUM_PRESENT

#if defined(DISPLAY_PRESENT)
  {DISPLAY_COOMUNICATION_STATE  , "op320_ok"   , &System.signal_state.is_display_ok,                   &System.signal_state_res.is_display_ok,                  sizeof(System.signal_state.is_display_ok),                   UINT8_SYSTEM_T,   0xffff},
#endif // (DISPLAY_PRESENT)

  {VEGA_MCC                 , __SNAME("mcc")            , __SPTR(&System.server_state.serving_cell.MCC), &System.server_state_res.serving_cell.MCC, sizeof(System.server_state.serving_cell.MCC), UINT16_SYSTEM_T, __EGTSN(121)},
  {VEGA_MNC                 , __SNAME("mnc")            , __SPTR(&System.server_state.serving_cell.MNC), &System.server_state_res.serving_cell.MNC, sizeof(System.server_state.serving_cell.MNC), UINT16_SYSTEM_T, __EGTSN(122)},
  {VEGA_LAC                 , __SNAME("lac")            , __SPTR(&System.server_state.serving_cell.LAC), &System.server_state_res.serving_cell.LAC, sizeof(System.server_state.serving_cell.LAC), UINT32_SYSTEM_T, __EGTSN(123)},
  {VEGA_CELLID              , __SNAME("cell_id")        , __SPTR(&System.server_state.serving_cell.CELLID), &System.server_state_res.serving_cell.CELLID, sizeof(System.server_state.serving_cell.CELLID), UINT32_SYSTEM_T, __EGTSN(124)},
  {VEGA_GSM_SIGNAL_LEVEL    , __SNAME("gsm_sig_level")  , __SPTR(&System.server_state.signal_rssi), &System.server_state_res.signal_rssi, sizeof(System.server_state.signal_rssi), UINT8_SYSTEM_T, __EGTSN(125)},
  //{VEGA_GSM_SIM1_BALANCE    , __SNAME("balance")        , __SPTR(&System.server_state.balance[0]), &System.server_state_res.balance[0], sizeof(System.server_state.balance[0]), FLOAT_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GSM_JAMMED          , __SNAME("jammed")         , __SPTR(&System.server_state.jammed), &System.server_state_res.jammed, sizeof(System.server_state.jammed), BOOL_SYSTEM_T, __EGTSN(102)},
  {VEGA_TX_DATA_SERV1       , __SNAME("serv1_tx")       , __SPTR(&System.server_state.traffic_counter[0].tx), &System.server_state_res.traffic_counter[0].tx, sizeof(System.server_state.traffic_counter[0].tx), UINT32_SYSTEM_T, __EGTSN(127)},
  {VEGA_TX_DATA_SERV2       , __SNAME("serv2_tx")       , __SPTR(&System.server_state.traffic_counter[1].tx), &System.server_state_res.traffic_counter[1].tx, sizeof(System.server_state.traffic_counter[1].tx), UINT32_SYSTEM_T, __EGTSN(128)},
  {VEGA_TX_DATA_SERV3       , __SNAME("serv3_tx")       , __SPTR(&System.server_state.traffic_counter[2].tx), &System.server_state_res.traffic_counter[2].tx, sizeof(System.server_state.traffic_counter[2].tx), UINT32_SYSTEM_T, __EGTSN(129)},
  {VEGA_TX_DATA_SERV4       , __SNAME("serv4_tx")       , __SPTR(&System.server_state.traffic_counter[3].tx), &System.server_state_res.traffic_counter[3].tx, sizeof(System.server_state.traffic_counter[3].tx), UINT32_SYSTEM_T, __EGTSN(130)},
  {VEGA_RX_DATA_SERV1       , __SNAME("serv1_rx")       , __SPTR(&System.server_state.traffic_counter[0].rx), &System.server_state_res.traffic_counter[0].rx, sizeof(System.server_state.traffic_counter[0].rx), UINT32_SYSTEM_T, __EGTSN(131)},
  {VEGA_RX_DATA_SERV2       , __SNAME("serv2_rx")       , __SPTR(&System.server_state.traffic_counter[1].rx), &System.server_state_res.traffic_counter[1].rx, sizeof(System.server_state.traffic_counter[1].rx), UINT32_SYSTEM_T, __EGTSN(132)},
  {VEGA_RX_DATA_SERV3       , __SNAME("serv3_rx")       , __SPTR(&System.server_state.traffic_counter[2].rx), &System.server_state_res.traffic_counter[2].rx, sizeof(System.server_state.traffic_counter[2].rx), UINT32_SYSTEM_T, __EGTSN(133)},
  {VEGA_RX_DATA_SERV4       , __SNAME("serv4_rx")       , __SPTR(&System.server_state.traffic_counter[3].rx), &System.server_state_res.traffic_counter[3].rx, sizeof(System.server_state.traffic_counter[3].rx), UINT32_SYSTEM_T, __EGTSN(134)},
  {VEGA_GSM_ACT             , __SNAME("gsm_act")        , __SPTR(&System.server_state.serving_cell.AcT),      &System.server_state_res.serving_cell.AcT,      sizeof(System.server_state.serving_cell.AcT),      UINT8_SYSTEM_T, __EGTSN(0xFFFF)},
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
  {VEGA_EXT_SERVING_CELL_INF, "gsm_scell_inf"  , &System.server_state.ext_serving_cells_info, &System.server_state_res.ext_serving_cells_info, sizeof(System.server_state.ext_serving_cells_info), STRING_SYSTEM_T, 0xffff},
  {VEGA_GSM_SCAN_MODE,        "gsm_smode"      , &System.server_state.scan_mode,              &System.server_state_res.scan_mode,              sizeof(System.server_state.scan_mode),              UINT8_SYSTEM_T,  0xffff},
#endif //YANDEX_EXTENDED_SENSORS_PRESENT
  {VEGA_GSM_USED_SIM        , __SNAME("gsm_sim")        , __SPTR(&System.server_state.used_sim),              &System.server_state_res.used_sim,      sizeof(System.server_state.used_sim),      UINT8_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_GSM_LBS             , __SNAME("p2020")          , __SPTR(&System.server_lbs_state),                   &System.server_lbs_state,               sizeof(System.server_lbs_state),           ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
#if defined(BALANCE_REQUEST_PRESENT)
  {VEGA_GSM_SIM1_BALANCE    , __SNAME("p2021")          , __SPTR(&System.server_state.balance[0]), &System.server_state_res.balance[0], sizeof(System.server_state.balance[0]), FLOAT_SYSTEM_T, __EGTSN(0xFFFF)},
#if (MAX_SIM_COUNT > 1)
  {VEGA_GSM_SIM2_BALANCE    , __SNAME("p2022")          , __SPTR(&System.server_state.balance[1]), &System.server_state_res.balance[1], sizeof(System.server_state.balance[1]), FLOAT_SYSTEM_T, __EGTSN(0xFFFF)},
#endif
#endif //defined(BALANCE_REQUEST_PRESENT)

#if defined(CANPRO_PRESENT)
  // Числовые параметры
  {CAN_ENGNE_UPTIME         , "eng_uptime"     , &System.can_state.numeric_data.eng_uptime, &System.can_state_res.numeric_data.eng_uptime, sizeof(System.can_state.numeric_data.eng_uptime), UINT32_SYSTEM_T, 151},
  {CAN_ENGINE_UPTIME_P      , "eng_uptime_p"   , &System.can_state.numeric_data.eng_uptime_p, &System.can_state_res.numeric_data.eng_uptime_p, sizeof(System.can_state.numeric_data.eng_uptime_p), UINT32_SYSTEM_T, 152},
  {CAN_ODOMETER_KM          , "can_odo_km"     , &System.can_state.numeric_data.can_odo_km, &System.can_state_res.numeric_data.can_odo_km, sizeof(System.can_state.numeric_data.can_odo_km), FLOAT_SYSTEM_T, 153},
  {CAN_ODOMETER_P           , "can_odo_p"      , &System.can_state.numeric_data.can_odo_p, &System.can_state_res.numeric_data.can_odo_p, sizeof(System.can_state.numeric_data.can_odo_p), FLOAT_SYSTEM_T, 154},
  {CAN_CONSUMED_FUEL_L      , "cons_fuel_l"    , &System.can_state.numeric_data.cons_fuel_l, &System.can_state_res.numeric_data.cons_fuel_l, sizeof(System.can_state.numeric_data.cons_fuel_l), FLOAT_SYSTEM_T, 155},
  {CAN_CONSUMED_FUEL_P      , "cons_fuel_p"    , &System.can_state.numeric_data.cons_fuel_p, &System.can_state_res.numeric_data.cons_fuel_p, sizeof(System.can_state.numeric_data.cons_fuel_p), FLOAT_SYSTEM_T, 156},
  {CAN_FUEL_LEVEL_P         , "fuel_lev_p"     , &System.can_state.numeric_data.fuel_lev_p, &System.can_state_res.numeric_data.fuel_lev_p, sizeof(System.can_state.numeric_data.fuel_lev_p), UINT8_SYSTEM_T, 157},
  {CAN_FUEL_LEVEL_L         , "fuel_lev_l"     , &System.can_state.numeric_data.fuel_lev_l, &System.can_state_res.numeric_data.fuel_lev_l, sizeof(System.can_state.numeric_data.fuel_lev_l), UINT16_SYSTEM_T, 158},
  {CAN_ENGINE_RPM           , "eng_rpm"        , &System.can_state.numeric_data.eng_rpm, &System.can_state_res.numeric_data.eng_rpm, sizeof(System.can_state.numeric_data.eng_rpm), UINT16_SYSTEM_T, 159},
  {CAN_ENGINE_TEMP          , "eng_temp"       , &System.can_state.numeric_data.eng_temp, &System.can_state_res.numeric_data.eng_temp, sizeof(System.can_state.numeric_data.eng_temp), FLOAT_SYSTEM_T, 160},
  {CAN_SPEED                , "can_speed"      , &System.can_state.numeric_data.can_speed, &System.can_state_res.numeric_data.can_speed, sizeof(System.can_state.numeric_data.can_speed), UINT8_SYSTEM_T, 161},
  {CAN_AXLE_1               , "can_axel_1"     , &System.can_state.numeric_data.can_axle_1, &System.can_state_res.numeric_data.can_axle_1, sizeof(System.can_state.numeric_data.can_axle_1), UINT16_SYSTEM_T, 162},
  {CAN_AXLE_2               , "can_axel_2"     , &System.can_state.numeric_data.can_axle_2, &System.can_state_res.numeric_data.can_axle_2, sizeof(System.can_state.numeric_data.can_axle_2), UINT16_SYSTEM_T, 163},
  {CAN_AXLE_3               , "can_axel_3"     , &System.can_state.numeric_data.can_axle_3, &System.can_state_res.numeric_data.can_axle_3, sizeof(System.can_state.numeric_data.can_axle_3), UINT16_SYSTEM_T, 164},
  {CAN_AXLE_4               , "can_axel_4"     , &System.can_state.numeric_data.can_axle_4, &System.can_state_res.numeric_data.can_axle_4, sizeof(System.can_state.numeric_data.can_axle_4), UINT16_SYSTEM_T, 165},
  {CAN_AXLE_5               , "can_axel_5"     , &System.can_state.numeric_data.can_axle_5, &System.can_state_res.numeric_data.can_axle_5, sizeof(System.can_state.numeric_data.can_axle_5), UINT16_SYSTEM_T, 166},
  {CAN_FUEL_FLOW            , "fuel_flow"      , &System.can_state.numeric_data.fuel_flow, &System.can_state_res.numeric_data.fuel_flow, sizeof(System.can_state.numeric_data.fuel_flow), FLOAT_SYSTEM_T, 167},
  {CAN_ADBLUE_P             , "ad_blue_p"      , &System.can_state.numeric_data.ad_blue_p, &System.can_state_res.numeric_data.ad_blue_p, sizeof(System.can_state.numeric_data.ad_blue_p), UINT8_SYSTEM_T, 168},
  {CAN_ADBLUE_L             , "ad_blue_l"      , &System.can_state.numeric_data.ad_blue_l, &System.can_state_res.numeric_data.ad_blue_l, sizeof(System.can_state.numeric_data.ad_blue_l), UINT16_SYSTEM_T, 169},
  {CAN_HARVEST_TIME         , "harvest_time"   , &System.can_state.numeric_data.harvest_time, &System.can_state_res.numeric_data.harvest_time, sizeof(System.can_state.numeric_data.harvest_time), UINT32_SYSTEM_T, 170},
  {CAN_HARVEST_AREA         , "harvest_area"   , &System.can_state.numeric_data.harvest_area, &System.can_state_res.numeric_data.harvest_area, sizeof(System.can_state.numeric_data.harvest_area), FLOAT_SYSTEM_T, 171},
  {CAN_HARVEST_EFF          , "harvest_eff"    , &System.can_state.numeric_data.harvest_eff, &System.can_state_res.numeric_data.harvest_eff, sizeof(System.can_state.numeric_data.harvest_eff), FLOAT_SYSTEM_T, 172},
  {CAN_HARVEST_GRAIN        , "harvest_grain"  , &System.can_state.numeric_data.harvest_grain, &System.can_state_res.numeric_data.harvest_grain, sizeof(System.can_state.numeric_data.harvest_grain), UINT32_SYSTEM_T, 173},
  {CAN_BRAKE                , "brake"          , &System.can_state.numeric_data.brake, &System.can_state_res.numeric_data.brake, sizeof(System.can_state.numeric_data.brake), UINT8_SYSTEM_T, 174},
  {CAN_ACCELERATOR          , "accelerator"    , &System.can_state.numeric_data.accelerator, &System.can_state_res.numeric_data.accelerator, sizeof(System.can_state.numeric_data.accelerator), UINT8_SYSTEM_T, 175},
  {CAN_ENGINE_LOAD          , "engine_load"    , &System.can_state.numeric_data.engine_load, &System.can_state_res.numeric_data.engine_load, sizeof(System.can_state.numeric_data.engine_load), UINT8_SYSTEM_T, 176},
  {CAN_STEERING_ACCELERATION, "steering_acc"   , &System.can_state.numeric_data.thresher_rpm, &System.can_state_res.numeric_data.thresher_rpm, sizeof(System.can_state.numeric_data.thresher_rpm), UINT16_SYSTEM_T, 177},
  {CAN_CONCAVE_CLR          , "concave_clear"  , &System.can_state.numeric_data.concave_clear, &System.can_state_res.numeric_data.concave_clear, sizeof(System.can_state.numeric_data.concave_clear), UINT8_SYSTEM_T, 178},
  {CAN_ODO_BEF_SERVICE      , "bef_srvc_odo"   , &System.can_state.numeric_data.bef_srvc_odo, &System.can_state_res.numeric_data.bef_srvc_odo, sizeof(System.can_state.numeric_data.bef_srvc_odo), UINT32_SYSTEM_T, 179},
  {CAN_ODO_SERVICE_EX       , "ex_srvc_odo"    , &System.can_state.numeric_data.ex_srvc_odo, &System.can_state_res.numeric_data.ex_srvc_odo, sizeof(System.can_state.numeric_data.ex_srvc_odo), UINT32_SYSTEM_T, 180},
  {CAN_ODO_AFTER_SERVICE    , "aft_srvc_odo"   , &System.can_state.numeric_data.aft_srvc_odo, &System.can_state_res.numeric_data.aft_srvc_odo, sizeof(System.can_state.numeric_data.aft_srvc_odo), UINT32_SYSTEM_T, 181},
  {CAN_TIME_BEF_SERVICE     , "bef_srvc_time"  , &System.can_state.numeric_data.bef_srvc_time, &System.can_state_res.numeric_data.bef_srvc_time, sizeof(System.can_state.numeric_data.bef_srvc_time), UINT16_SYSTEM_T, 182},
  {CAN_TIME_SERVICE_EX      , "ex_srvc_time"   , &System.can_state.numeric_data.ex_srvc_time, &System.can_state_res.numeric_data.ex_srvc_time, sizeof(System.can_state.numeric_data.ex_srvc_time), UINT16_SYSTEM_T, 183},
  {CAN_TIME_AFTER_SERVICE   , "aft_srvc_time"   , &System.can_state.numeric_data.aft_srvc_time, &System.can_state_res.numeric_data.aft_srvc_time, sizeof(System.can_state.numeric_data.aft_srvc_time), UINT16_SYSTEM_T, 184},
  {CAN_BATTERY_CHARGE_LEVEL , "can_bat_lev"    , &System.can_state.numeric_data.battery_charge_level, &System.can_state_res.numeric_data.battery_charge_level, sizeof(System.can_state.numeric_data.battery_charge_level), FLOAT_SYSTEM_T, 0xffff},
  {CAN_BATTERY_TEMPERATURE  , "can_bat_tem"    , &System.can_state.numeric_data.battery_temperature, &System.can_state_res.numeric_data.battery_temperature, sizeof(System.can_state.numeric_data.battery_temperature), FLOAT_SYSTEM_T, 0xffff},

  // Приборная панель
  {CAN_STOP                 , "stop"           , &System.can_state.cont_flags.stop, &System.can_state_res.cont_flags.stop, sizeof(System.can_state_res.cont_flags.stop), BOOL_SYSTEM_T, 111},
  {CAN_CHECK_OIL            , "chek_oil"       , &System.can_state.cont_flags.chek_oil, &System.can_state_res.cont_flags.chek_oil, sizeof(System.can_state_res.cont_flags.chek_oil), BOOL_SYSTEM_T, 112},
  {CAN_CHECK_COOLANT        , "chek_coolant"   , &System.can_state.cont_flags.chek_coolant, &System.can_state_res.cont_flags.chek_coolant, sizeof(System.can_state_res.cont_flags.chek_coolant), BOOL_SYSTEM_T, 113},
  {CAN_CHECK_HAND_BREAK     , "check_hand_brk" , &System.can_state.cont_flags.hand_break, &System.can_state_res.cont_flags.hand_break, sizeof(System.can_state_res.cont_flags.hand_break), BOOL_SYSTEM_T, 114},
  {CAN_BATTERY              , "battery"        , &System.can_state.cont_flags.battery, &System.can_state_res.cont_flags.battery, sizeof(System.can_state_res.cont_flags.battery), BOOL_SYSTEM_T, 115},
  {CAN_AIRBAG               , "airbag"         , &System.can_state.cont_flags.airbag, &System.can_state_res.cont_flags.airbag, sizeof(System.can_state_res.cont_flags.airbag), BOOL_SYSTEM_T, 116},
  {CAN_CHECK_ENGINE         , "check_engine"   , &System.can_state.cont_flags.check_engine, &System.can_state_res.cont_flags.check_engine, sizeof(System.can_state_res.cont_flags.check_engine), BOOL_SYSTEM_T, 117},
  {CAN_FAULT_LIGHTING       , "fault_light"    , &System.can_state.cont_flags.fault_lighting, &System.can_state_res.cont_flags.fault_lighting, sizeof(System.can_state_res.cont_flags.fault_lighting), BOOL_SYSTEM_T, 118},
  {CAN_INFLATION_PRESSURE   , "infl_press"     , &System.can_state.cont_flags.inflation_pressure, &System.can_state_res.cont_flags.inflation_pressure, sizeof(System.can_state_res.cont_flags.inflation_pressure), BOOL_SYSTEM_T, 119},
  {CAN_CHECK_BRAKE_PADS     , "chek_brake"     , &System.can_state.cont_flags.chek_brake_pads, &System.can_state_res.cont_flags.chek_brake_pads, sizeof(System.can_state_res.cont_flags.chek_brake_pads), BOOL_SYSTEM_T, 120},
  {CAN_WARNING              , "warning"        , &System.can_state.cont_flags.warning, &System.can_state_res.cont_flags.warning, sizeof(System.can_state_res.cont_flags.warning), BOOL_SYSTEM_T, 121},
  {CAN_ABS                  , "abs"            , &System.can_state.cont_flags.abs, &System.can_state_res.cont_flags.abs, sizeof(System.can_state_res.cont_flags.abs), BOOL_SYSTEM_T, 122},
  {CAN_FUEL_LEVEL           , "fuel_level"     , &System.can_state.cont_flags.fuel_level, &System.can_state_res.cont_flags.fuel_level, sizeof(System.can_state_res.cont_flags.fuel_level), BOOL_SYSTEM_T, 123},
  {CAN_ESP                  , "esp"            , &System.can_state.cont_flags.esp, &System.can_state_res.cont_flags.esp, sizeof(System.can_state_res.cont_flags.esp), BOOL_SYSTEM_T, 124},
  {CAN_SPARK_PLUG           , "spark_plug"     , &System.can_state.cont_flags.spark_plug, &System.can_state_res.cont_flags.spark_plug, sizeof(System.can_state_res.cont_flags.spark_plug), BOOL_SYSTEM_T, 125},
  {CAN_FAP                  , "fap"            , &System.can_state.cont_flags.fap, &System.can_state_res.cont_flags.fap, sizeof(System.can_state_res.cont_flags.fap), BOOL_SYSTEM_T, 126},
  {CAN_PRESSURE_CONTROL     , "press_contr"    , &System.can_state.cont_flags.pressure_control, &System.can_state_res.cont_flags.pressure_control, sizeof(System.can_state_res.cont_flags.pressure_control), BOOL_SYSTEM_T, 127},
  {CAN_MARKER_LIGHTS        , "marker_lights"  , &System.can_state.cont_flags.marker_lights, &System.can_state_res.cont_flags.marker_lights, sizeof(System.can_state_res.cont_flags.marker_lights), BOOL_SYSTEM_T, 128},
  {CAN_DIPPED_BEAM          , "dipped_beam"    , &System.can_state.cont_flags.dipped_beam, &System.can_state_res.cont_flags.dipped_beam, sizeof(System.can_state_res.cont_flags.dipped_beam), BOOL_SYSTEM_T, 129},
  {CAN_HIGH_BEAM            , "high_beam"      , &System.can_state.cont_flags.high_beam, &System.can_state_res.cont_flags.high_beam, sizeof(System.can_state_res.cont_flags.high_beam), BOOL_SYSTEM_T, 130},
  {CAN_PASSENGER_SAFE_BELT  , "pass_belt"      , &System.can_state.cont_flags.passenger_safety_belt, &System.can_state_res.cont_flags.passenger_safety_belt, sizeof(System.can_state_res.cont_flags.passenger_safety_belt), BOOL_SYSTEM_T, 131},
  {CAN_DRIVER_SAFE_BELT     , "driver_belt"    , &System.can_state.cont_flags.driver_safety_belt, &System.can_state_res.cont_flags.driver_safety_belt, sizeof(System.can_state_res.cont_flags.driver_safety_belt), BOOL_SYSTEM_T, 132},
  {CAN_READY_FOR_MOTION     , "m_ready"        , &System.can_state.cont_flags.ready_for_motion, &System.can_state_res.cont_flags.ready_for_motion, sizeof(System.can_state_res.cont_flags.ready_for_motion), BOOL_SYSTEM_T, 0xffff},

  // Охрана
  {CAN_KEY_IN_IGN           , "key_in_ign"     , &System.can_state.sec_flags.key_in_ign, &System.can_state_res.sec_flags.key_in_ign, sizeof(System.can_state.sec_flags.key_in_ign), BOOL_SYSTEM_T, 133},
  {CAN_IGNITION             , "ignition"       , &System.can_state.sec_flags.ignition, &System.can_state_res.sec_flags.ignition, sizeof(System.can_state.sec_flags.ignition), BOOL_SYSTEM_T, 134},
  {CAN_DYNAMIC_IGN          , "dynamic_ign"    , &System.can_state.sec_flags.dynamic_ign, &System.can_state_res.sec_flags.dynamic_ign, sizeof(System.can_state.sec_flags.dynamic_ign), BOOL_SYSTEM_T, 135},
  {CAN_WEBASTO              , "webasto"        , &System.can_state.sec_flags.webasto, &System.can_state_res.sec_flags.webasto, sizeof(System.can_state.sec_flags.webasto), BOOL_SYSTEM_T, 136},
  {CAN_CLOSED_BY_PULT       , "closed_pult"    , &System.can_state.sec_flags.closed_by_pult, &System.can_state_res.sec_flags.closed_by_pult, sizeof(System.can_state.sec_flags.closed_by_pult), BOOL_SYSTEM_T, 137},
  {CAN_ALARM_ACT            , "alarm_act"      , &System.can_state.sec_flags.alarm_act, &System.can_state_res.sec_flags.alarm_act, sizeof(System.can_state.sec_flags.alarm_act), BOOL_SYSTEM_T, 138},
  {CAN_NATIVE_ALARM         , "native_alarm"   , &System.can_state.sec_flags.native_alarm, &System.can_state_res.sec_flags.native_alarm, sizeof(System.can_state.sec_flags.native_alarm), BOOL_SYSTEM_T, 139},
  {CAN_PARKING              , "parking"        , &System.can_state.sec_flags.parking, &System.can_state_res.sec_flags.parking, sizeof(System.can_state.sec_flags.parking), BOOL_SYSTEM_T, 140},
  {CAN_HAND_BREAK           , "hand_break"     , &System.can_state.sec_flags.hand_break, &System.can_state_res.sec_flags.hand_break, sizeof(System.can_state.sec_flags.hand_break), BOOL_SYSTEM_T, 141},
  {CAN_PEDAL_BREAK          , "pedal_break"    , &System.can_state.sec_flags.pedal_break, &System.can_state_res.sec_flags.pedal_break, sizeof(System.can_state.sec_flags.pedal_break), BOOL_SYSTEM_T, 142},
  {CAN_ENGINE_IS_ON         , "engine_is_on"   , &System.can_state.sec_flags.engine_is_on, &System.can_state_res.sec_flags.engine_is_on, sizeof(System.can_state.sec_flags.engine_is_on), BOOL_SYSTEM_T, 143},
  {CAN_REVERSE_GEAR         , "reverse_gear"   , &System.can_state.sec_flags.reverse_gear, &System.can_state_res.sec_flags.reverse_gear, sizeof(System.can_state.sec_flags.reverse_gear), BOOL_SYSTEM_T, 144},
  {CAN_DRIVER_DOOR          , "driver_door"    , &System.can_state.sec_flags.driver_door, &System.can_state_res.sec_flags.driver_door, sizeof(System.can_state.sec_flags.driver_door), BOOL_SYSTEM_T, 145},
  {CAN_PASS_DOOR            , "pass_door"      , &System.can_state.sec_flags.pass_door, &System.can_state_res.sec_flags.pass_door, sizeof(System.can_state.sec_flags.pass_door), BOOL_SYSTEM_T, 146},
  {CAN_L_REAR_DOOR          , "l_rear_door"    , &System.can_state.sec_flags.l_rear_door, &System.can_state_res.sec_flags.l_rear_door, sizeof(System.can_state.sec_flags.l_rear_door), BOOL_SYSTEM_T, 147},
  {CAN_R_REAR_DOOR          , "r_rear_door"    , &System.can_state.sec_flags.r_rear_door, &System.can_state_res.sec_flags.r_rear_door, sizeof(System.can_state.sec_flags.r_rear_door), BOOL_SYSTEM_T, 148},
  {CAN_HOOD                 , "hood"           , &System.can_state.sec_flags.hood, &System.can_state_res.sec_flags.hood, sizeof(System.can_state.sec_flags.hood), BOOL_SYSTEM_T, 149},
  {CAN_TRUNK                , "trunk"          , &System.can_state.sec_flags.trunk, &System.can_state_res.sec_flags.trunk, sizeof(System.can_state.sec_flags.trunk), BOOL_SYSTEM_T, 150},
  {CAN_REMOTE_CONTROL       , "remote_control" , &System.can_state.sec_flags.remote_control, &System.can_state_res.sec_flags.remote_control, sizeof(System.can_state.sec_flags.remote_control), BOOL_SYSTEM_T, 151},
  {CAN_IN_SLEEP             , "can_in_sleep"   , &System.can_state.sec_flags.can_in_sleep, &System.can_state_res.sec_flags.can_in_sleep, sizeof(System.can_state.sec_flags.can_in_sleep), BOOL_SYSTEM_T, 152},
  {CAN_BATTERY_CHARGING     , "can_charging"   , &System.can_state.sec_flags.battery_charging, &System.can_state_res.sec_flags.battery_charging, sizeof(System.can_state.sec_flags.battery_charging), BOOL_SYSTEM_T, 0xffff},
  {CAN_CHARGING_CABLE       , "charge_cable"   , &System.can_state.sec_flags.charge_cable_present, &System.can_state_res.sec_flags.charge_cable_present, sizeof(System.can_state.sec_flags.charge_cable_present), BOOL_SYSTEM_T, 0xffff},
  {CAN_KEY_IN_ACC           , "key_in_acc"     , &System.can_state.sec_flags.key_in_acc, &System.can_state_res.sec_flags.key_in_acc, sizeof(System.can_state.sec_flags.key_in_acc), BOOL_SYSTEM_T, 0xffff},

  // Спецтехника а агротехника
  {CAN_TRESHER_ON           , "tresher_on"     , &System.can_state.agr_flags.tresher_on, &System.can_state_res.agr_flags.tresher_on, sizeof(System.can_state.agr_flags.tresher_on), BOOL_SYSTEM_T, 153},
  {CAN_UNLOAD_TUBE_ON       , "unload_tube_on" , &System.can_state.agr_flags.unload_tube_on, &System.can_state_res.agr_flags.unload_tube_on, sizeof(System.can_state.agr_flags.unload_tube_on), BOOL_SYSTEM_T, 154},
  {CAN_REAR_PTO_UNIT_ON     , "r_pto_unit"     , &System.can_state.agr_flags.r_pto_unit, &System.can_state_res.agr_flags.r_pto_unit, sizeof(System.can_state.agr_flags.r_pto_unit), BOOL_SYSTEM_T, 163},
  {CAN_FRONT_PTO_UNIT_ON    , "f_pto_unit"     , &System.can_state.agr_flags.f_pto_unit, &System.can_state_res.agr_flags.f_pto_unit, sizeof(System.can_state.agr_flags.f_pto_unit), BOOL_SYSTEM_T, 164},
  {CAN_TRESHER_GAP          , "trasher_gap"    , &System.can_state.agr_flags.trasher_gap, &System.can_state_res.agr_flags.trasher_gap, sizeof(System.can_state.agr_flags.trasher_gap), BOOL_SYSTEM_T, 165},
  {CAN_GR_TNK_OPEN          , "gr_tnk_open"    , &System.can_state.agr_flags.gr_tnk_open, &System.can_state_res.agr_flags.gr_tnk_open, sizeof(System.can_state.agr_flags.gr_tnk_open), BOOL_SYSTEM_T, 166},
  {CAN_GR_TNK_100           , "gr_tnk_100"     , &System.can_state.agr_flags.gr_tnk_100, &System.can_state_res.agr_flags.gr_tnk_100, sizeof(System.can_state.agr_flags.gr_tnk_100), BOOL_SYSTEM_T, 167},
  {CAN_GR_TNK_70            , "gr_tnk_70"      , &System.can_state.agr_flags.gr_tnk_70, &System.can_state_res.agr_flags.gr_tnk_70, sizeof(System.can_state.agr_flags.gr_tnk_70), BOOL_SYSTEM_T, 168},
  {CAN_HYDR_FLTR_CLOG       , "hydr_fltr_clog" , &System.can_state.agr_flags.hydr_fltr_clog, &System.can_state_res.agr_flags.hydr_fltr_clog, sizeof(System.can_state.agr_flags.hydr_fltr_clog), BOOL_SYSTEM_T, 169},
  {CAN_HYDR_PRESS_LOW       , "hydr_press_low" , &System.can_state.agr_flags.hydr_press_low, &System.can_state_res.agr_flags.hydr_press_low, sizeof(System.can_state.agr_flags.hydr_press_low), BOOL_SYSTEM_T, 170},
  {CAN_HYDR_LEVEL_LOW       , "hydr_level_low" , &System.can_state.agr_flags.hydr_level_low, &System.can_state_res.agr_flags.hydr_level_low, sizeof(System.can_state.agr_flags.hydr_level_low), BOOL_SYSTEM_T, 171},
  {CAN_BR_FLTR_CLOG         , "br_fltr_clog"   , &System.can_state.agr_flags.br_fltr_clog, &System.can_state_res.agr_flags.br_fltr_clog, sizeof(System.can_state.agr_flags.br_fltr_clog), BOOL_SYSTEM_T, 172},
  {CAN_OIL_FLTR_CLOG        , "oil_fltr_clog"  , &System.can_state.agr_flags.oil_fltr_clog, &System.can_state_res.agr_flags.oil_fltr_clog, sizeof(System.can_state.agr_flags.oil_fltr_clog), BOOL_SYSTEM_T, 173},
  {CAN_FUEL_FLTR_CLOG       , "fuel_fltr_clog" , &System.can_state.agr_flags.fuel_fltr_clog, &System.can_state_res.agr_flags.fuel_fltr_clog, sizeof(System.can_state.agr_flags.fuel_fltr_clog), BOOL_SYSTEM_T, 174},
  {CAN_AIR_FLTR_CLOG        , "air_fltr_clog"  , &System.can_state.agr_flags.air_fltr_clog, &System.can_state_res.agr_flags.air_fltr_clog, sizeof(System.can_state.agr_flags.air_fltr_clog), BOOL_SYSTEM_T, 175},
  {CAN_HYDR_TEMP_ALERT      , "hydr_tmp_alert" , &System.can_state.agr_flags.hydr_temp_alert, &System.can_state_res.agr_flags.hydr_temp_alert, sizeof(System.can_state.agr_flags.hydr_temp_alert), BOOL_SYSTEM_T, 176},
  {CAN_PCH_TEMP_ALERT       , "pch_temp_alert" , &System.can_state.agr_flags.pch_temp_alert, &System.can_state_res.agr_flags.pch_temp_alert, sizeof(System.can_state.agr_flags.pch_temp_alert), BOOL_SYSTEM_T, 177},
  {CAN_OIL_PRESS_ALERT      , "oil_pres_alert" , &System.can_state.agr_flags.oil_pres_alert, &System.can_state_res.agr_flags.oil_pres_alert, sizeof(System.can_state.agr_flags.oil_pres_alert), BOOL_SYSTEM_T, 178},
  {CAN_COOLANT_ALERT        , "coolant_alert"  , &System.can_state.agr_flags.coolant_alert, &System.can_state_res.agr_flags.coolant_alert, sizeof(System.can_state.agr_flags.coolant_alert), BOOL_SYSTEM_T, 179},
  {CAN_HBLOCK_SECTION       , "hblock_section" , &System.can_state.agr_flags.hblock_section, &System.can_state_res.agr_flags.hblock_section, sizeof(System.can_state.agr_flags.hblock_section), BOOL_SYSTEM_T, 180},
  {CAN_SCREW_ALERT          , "screw_alert"    , &System.can_state.agr_flags.screw_alert, &System.can_state_res.agr_flags.screw_alert, sizeof(System.can_state.agr_flags.screw_alert), BOOL_SYSTEM_T, 181},
  {CAN_NO_OPERATOR          , "no_operator"    , &System.can_state.agr_flags.no_operator, &System.can_state_res.agr_flags.no_operator, sizeof(System.can_state.agr_flags.no_operator), BOOL_SYSTEM_T, 182},
  {CAN_STRAW_ALERT          , "straw_alert"    , &System.can_state.agr_flags.straw_alert, &System.can_state_res.agr_flags.straw_alert, sizeof(System.can_state.agr_flags.straw_alert), BOOL_SYSTEM_T, 183},
  {CAN_WATER_IN_FUEL        , "water_in_fuel"  , &System.can_state.agr_flags.water_in_fuel, &System.can_state_res.agr_flags.water_in_fuel, sizeof(System.can_state.agr_flags.water_in_fuel), BOOL_SYSTEM_T, 184},
  {CAN_CLEAR_FAN            , "clear_fan"      , &System.can_state.agr_flags.clear_fan, &System.can_state_res.agr_flags.clear_fan, sizeof(System.can_state.agr_flags.clear_fan), BOOL_SYSTEM_T, 185},
  {CAN_REEL                 , "reel"           , &System.can_state.agr_flags.reel, &System.can_state_res.agr_flags.reel, sizeof(System.can_state.agr_flags.reel), BOOL_SYSTEM_T, 186},
  {CAN_LOW_WATER            , "low_water"      , &System.can_state.agr_flags.low_water, &System.can_state_res.agr_flags.low_water, sizeof(System.can_state.agr_flags.low_water), BOOL_SYSTEM_T, 187},
  {CAN_AUTONOM_ENGINE       , "autonom_engine" , &System.can_state.agr_flags.autonom_engine, &System.can_state_res.agr_flags.autonom_engine, sizeof(System.can_state.agr_flags.autonom_engine), BOOL_SYSTEM_T, 188},
  {CAN_JOY_RIGHT_R          , "r_joy_right"    , &System.can_state.agr_flags.r_joy_right, &System.can_state_res.agr_flags.r_joy_right, sizeof(System.can_state.agr_flags.r_joy_right), BOOL_SYSTEM_T, 189},
  {CAN_JOY_LEFT_R           , "r_joy_left"     , &System.can_state.agr_flags.r_joy_left, &System.can_state_res.agr_flags.r_joy_left, sizeof(System.can_state.agr_flags.r_joy_left), BOOL_SYSTEM_T, 190},
  {CAN_JOY_FRONT_R          , "r_joy_front"    , &System.can_state.agr_flags.r_joy_front, &System.can_state_res.agr_flags.r_joy_front, sizeof(System.can_state.agr_flags.r_joy_front), BOOL_SYSTEM_T, 191},
  {CAN_JOY_BACK_R           , "r_joy_back"     , &System.can_state.agr_flags.r_joy_back, &System.can_state_res.agr_flags.r_joy_back, sizeof(System.can_state.agr_flags.r_joy_back), BOOL_SYSTEM_T, 192},

  {CAN_JOY_RIGHT_L          , "l_joy_right"    , &System.can_state.agr_flags.l_joy_right, &System.can_state_res.agr_flags.l_joy_right, sizeof(System.can_state.agr_flags.l_joy_right), BOOL_SYSTEM_T, 193},
  {CAN_JOY_LEFT_L           , "l_joy_left"     , &System.can_state.agr_flags.l_joy_left, &System.can_state_res.agr_flags.l_joy_left, sizeof(System.can_state.agr_flags.l_joy_left), BOOL_SYSTEM_T, 194},
  {CAN_JOY_FRONT_L          , "l_joy_front"    , &System.can_state.agr_flags.l_joy_front, &System.can_state_res.agr_flags.l_joy_front, sizeof(System.can_state.agr_flags.l_joy_front), BOOL_SYSTEM_T, 195},
  {CAN_JOY_BACK_L           , "l_joy_back"     , &System.can_state.agr_flags.l_joy_back, &System.can_state_res.agr_flags.l_joy_back, sizeof(System.can_state.agr_flags.l_joy_back), BOOL_SYSTEM_T, 196},

  {CAN_BRUSH_ON             , "brush_on"       , &System.can_state.agr_flags.brush_on, &System.can_state_res.agr_flags.brush_on, sizeof(System.can_state.agr_flags.brush_on), BOOL_SYSTEM_T, 197},
  {CAN_WATER_ON             , "water_on"       , &System.can_state.agr_flags.water_on, &System.can_state_res.agr_flags.water_on, sizeof(System.can_state.agr_flags.water_on), BOOL_SYSTEM_T, 198},
  {CAN_VACCLEANER           , "vaccleaner"     , &System.can_state.agr_flags.vaccleaner, &System.can_state_res.agr_flags.vaccleaner, sizeof(System.can_state.agr_flags.vaccleaner), BOOL_SYSTEM_T, 199},
  {CAN_BUNKER_UPLOAD        , "bunker_upload"  , &System.can_state.agr_flags.bunker_upload, &System.can_state_res.agr_flags.bunker_upload, sizeof(System.can_state.agr_flags.bunker_upload), BOOL_SYSTEM_T, 200},
  {CAN_KERCHER              , "kercher"        , &System.can_state.agr_flags.kercher, &System.can_state_res.agr_flags.kercher, sizeof(System.can_state.agr_flags.kercher), BOOL_SYSTEM_T, 201},
  {CAN_SALT_DIFFUSION       , "salt_diffusion" , &System.can_state.agr_flags.salt_diffusion, &System.can_state_res.agr_flags.salt_diffusion, sizeof(System.can_state.agr_flags.salt_diffusion), BOOL_SYSTEM_T, 202},
  {CAN_SALT_LOW             , "salt_low"       , &System.can_state.agr_flags.salt_low, &System.can_state_res.agr_flags.salt_low, sizeof(System.can_state.agr_flags.salt_low), BOOL_SYSTEM_T, 203},
  {CAN_FRONT_HYDR_1         , "f_hydr_1"       , &System.can_state.agr_flags.f_hydr_1, &System.can_state_res.agr_flags.f_hydr_1, sizeof(System.can_state.agr_flags.f_hydr_1), BOOL_SYSTEM_T, 155},
  {CAN_FRONT_HYDR_2         , "f_hydr_2"       , &System.can_state.agr_flags.f_hydr_2, &System.can_state_res.agr_flags.f_hydr_2, sizeof(System.can_state.agr_flags.f_hydr_2), BOOL_SYSTEM_T, 156},
  {CAN_FRONT_HYDR_3         , "f_hydr_3"       , &System.can_state.agr_flags.f_hydr_3, &System.can_state_res.agr_flags.f_hydr_3, sizeof(System.can_state.agr_flags.f_hydr_3), BOOL_SYSTEM_T, 157},
  {CAN_FRONT_HYDR_4         , "f_hydr_4"       , &System.can_state.agr_flags.f_hydr_4, &System.can_state_res.agr_flags.f_hydr_4, sizeof(System.can_state.agr_flags.f_hydr_4), BOOL_SYSTEM_T, 158},
  {CAN_REAR_HYDR_1          , "r_hydr_1"       , &System.can_state.agr_flags.r_hydr_1, &System.can_state_res.agr_flags.r_hydr_1, sizeof(System.can_state.agr_flags.r_hydr_1), BOOL_SYSTEM_T, 159},
  {CAN_REAR_HYDR_2          , "r_hydr_2"       , &System.can_state.agr_flags.r_hydr_2, &System.can_state_res.agr_flags.r_hydr_2, sizeof(System.can_state.agr_flags.r_hydr_2), BOOL_SYSTEM_T, 160},
  {CAN_REAR_HYDR_3          , "r_hydr_3"       , &System.can_state.agr_flags.r_hydr_3, &System.can_state_res.agr_flags.r_hydr_3, sizeof(System.can_state.agr_flags.r_hydr_3), BOOL_SYSTEM_T, 161},
  {CAN_REAR_HYDR_4          , "r_hydr_4"       , &System.can_state.agr_flags.r_hydr_4, &System.can_state_res.agr_flags.r_hydr_4, sizeof(System.can_state.agr_flags.r_hydr_4), BOOL_SYSTEM_T, 162},
  {CAN_FRONT_SUSP_SYS       , "f_susp_sys"     , &System.can_state.agr_flags.f_susp_sys, &System.can_state_res.agr_flags.f_susp_sys, sizeof(System.can_state.agr_flags.f_susp_sys), BOOL_SYSTEM_T, 204},
  {CAN_REAR_SUSP_SYS        , "r_susp_sys"     , &System.can_state.agr_flags.r_susp_sys, &System.can_state_res.agr_flags.r_susp_sys, sizeof(System.can_state.agr_flags.r_susp_sys), BOOL_SYSTEM_T, 205},
#ifdef __ICCARM__
#if (DEVICE_TYPE == DEVICE_TYPE_OBU_TACHO)
  {CAN_TACHO_DRIVER_1_INF,    "ta_dr_inf1",  &System.can_state.numeric_data.tacho_driver_1_inf, &System.can_state_res.numeric_data.tacho_driver_1_inf, sizeof(System.can_state.numeric_data.tacho_driver_1_inf), STRING_SYSTEM_T, 0xffff},
  {CAN_TACHO_DRIVER_2_INF,    "ta_dr_inf2",  &System.can_state.numeric_data.tacho_driver_2_inf, &System.can_state_res.numeric_data.tacho_driver_2_inf, sizeof(System.can_state.numeric_data.tacho_driver_2_inf), STRING_SYSTEM_T, 0xffff},
  {CAN_TACHO_CARD_INFO,       "ta_cr_info",  &System.can_state.numeric_data.tacho_cards_info,   &System.can_state_res.numeric_data.tacho_cards_info,   sizeof(System.can_state.numeric_data.tacho_cards_info),   UINT8_SYSTEM_T,  0xffff},
#endif //(DEVICE_YPE == DEVICE_TYPE_OBU_TACHO)
#endif  // __ICCARM__

#ifdef __ICCARM__
#if (DEVICE_TYPE == DEVICE_TYPE_PLATON_COMMERCIAL)
  //для "показать"
  {2320,    "p2320", &System.can_state.numeric_data.tacho_driver_1_inf, &System.can_state_res.numeric_data.tacho_driver_1_inf, sizeof(System.can_state.numeric_data.tacho_driver_1_inf), STRING_SYSTEM_T, 0xffff},
  {2321,    "p2321", &System.can_state.numeric_data.tacho_driver_2_inf, &System.can_state_res.numeric_data.tacho_driver_2_inf, sizeof(System.can_state.numeric_data.tacho_driver_2_inf), STRING_SYSTEM_T, 0xffff},
  {2322,    "p2322", &System.can_state.numeric_data.barcode_reader, &System.can_state_res.numeric_data.barcode_reader, sizeof(System.can_state.numeric_data.barcode_reader), STRING_SYSTEM_T, 0xffff},
#endif //(DEVICE_YPE == DEVICE_TYPE_PLATON_COMMERCIAL)
#endif  // __ICCARM__

#endif //CANPRO_PRESENT

#if !defined(EXTENDED_ADVANTUM_CAN_PRESENT)
  {CAN_STAT_TRANSMISSION          , "can_st_tr",  __SPTR(&System.signal_state.selector_position),    &System.signal_state_res.selector_position,    sizeof(System.signal_state.selector_position),   UINT8_SYSTEM_T,   0xffff},
#endif

#if defined(EXTENDED_ADVANTUM_CAN_PRESENT)
  {CAN_STAT_TRANSMISSION          , "can_st_tr",  &System.can_state.man_data.stat_transm,    &System.can_state_res.man_data.stat_transm,    sizeof(System.can_state.man_data.stat_transm),   UINT8_SYSTEM_T,   0xffff},
  {CAN_OTPUT_SPEED_KP             , "can_o_spd",  &System.can_state.man_data.outp_spd_kp,    &System.can_state_res.man_data.outp_spd_kp,    sizeof(System.can_state.man_data.outp_spd_kp),   UINT16_SYSTEM_T,  0xffff},
  {CAN_CLUTCH_SLIP                , "can_cl_sl",  &System.can_state.man_data.clutch_slip,    &System.can_state_res.man_data.clutch_slip,    sizeof(System.can_state.man_data.clutch_slip),   UINT8_SYSTEM_T,   0xffff},
  {CAN_INPUT_SPEED_KP             , "can_i_spd",  &System.can_state.man_data.input_spd_kp,   &System.can_state_res.man_data.input_spd_kp,   sizeof(System.can_state.man_data.input_spd_kp),  UINT16_SYSTEM_T,  0xffff},
  {CAN_SELECTED_GEAR              , "can_s_gear", &System.can_state.man_data.sel_gear,       &System.can_state_res.man_data.sel_gear,       sizeof(System.can_state.man_data.sel_gear),      UINT8_SYSTEM_T,   0xffff},
  {CAN_GEAR_RATIO                 , "can_gear_r", &System.can_state.man_data.gear_ratio,     &System.can_state_res.man_data.gear_ratio,     sizeof(System.can_state.man_data.gear_ratio),    UINT16_SYSTEM_T,  0xffff},
  {CAN_CURRENT_GEAR               , "can_c_gear", &System.can_state.man_data.current_gear,   &System.can_state_res.man_data.current_gear,   sizeof(System.can_state.man_data.current_gear),  UINT8_SYSTEM_T,   0xffff},
  {CAN_SHIFT_FINGER_ST            , "can_sh_f",   &System.can_state.man_data.shift_finger,   &System.can_state_res.man_data.shift_finger,   sizeof(System.can_state.man_data.shift_finger),  UINT8_SYSTEM_T,   0xffff},
  {CAN_NEUTRAL_IND_KP             , "can_n_ind",  &System.can_state.man_data.neutral_ind,    &System.can_state_res.man_data.neutral_ind,    sizeof(System.can_state.man_data.neutral_ind),   UINT8_SYSTEM_T,   0xffff},
  {CAN_NMV_STATE                  , "can_nmv_st", &System.can_state.man_data.nmv_state,      &System.can_state_res.man_data.nmv_state,      sizeof(System.can_state.man_data.nmv_state),     UINT8_SYSTEM_T,   0xffff},
  {CAN_PTO1_STATE                 , "can_pto1"  , &System.can_state.man_data.pto1_state,     &System.can_state_res.man_data.pto1_state,     sizeof(System.can_state.man_data.pto1_state),    UINT8_SYSTEM_T,   0xffff},
  {CAN_PTO2_STATE                 , "can_pto2"  , &System.can_state.man_data.pto2_state,     &System.can_state_res.man_data.pto2_state,     sizeof(System.can_state.man_data.pto2_state),    UINT8_SYSTEM_T,   0xffff},
  {CAN_PARK_BRAKE_SW              , "can_p_brk" , &System.can_state.man_data.park_brake,     &System.can_state_res.man_data.park_brake,     sizeof(System.can_state.man_data.park_brake),    UINT8_SYSTEM_T,   0xffff},
  {CAN_CLUTCH_SW                  , "can_cl_sw" , &System.can_state.man_data.clutch_sw,      &System.can_state_res.man_data.clutch_sw,      sizeof(System.can_state.man_data.clutch_sw),     UINT8_SYSTEM_T,   0xffff},
  {CAN_BRAKE_SW                   , "can_bk_sw" , &System.can_state.man_data.brake_sw,       &System.can_state_res.man_data.brake_sw,       sizeof(System.can_state.man_data.brake_sw),      UINT8_SYSTEM_T,   0xffff},
  {CAN_CC_ACTIVE                  , "can_cc_a"  , &System.can_state.man_data.cc_active,      &System.can_state_res.man_data.cc_active,      sizeof(System.can_state.man_data.cc_active),     UINT8_SYSTEM_T,   0xffff},
  {CAN_PTO_STATE                  , "can_pto"   , &System.can_state.man_data.pto_state,      &System.can_state_res.man_data.pto_state,      sizeof(System.can_state.man_data.pto_state),     UINT8_SYSTEM_T,   0xffff},
  {CAN_ABS_ACTIVE                 , "can_abs"   , &System.can_state.man_data.abs_active,     &System.can_state_res.man_data.abs_active,     sizeof(System.can_state.man_data.abs_active),    UINT8_SYSTEM_T,   0xffff},
  {CAN_BP_POSITION                , "can_brk_p" , &System.can_state.man_data.bp_position,    &System.can_state_res.man_data.bp_position,    sizeof(System.can_state.man_data.bp_position),   UINT8_SYSTEM_T,   0xffff},
  {CAN_SHIFT_REAR_ST              , "can_sh_r"  , &System.can_state.man_data.shift_rear,     &System.can_state_res.man_data.shift_rear,     sizeof(System.can_state.man_data.shift_rear),    UINT8_SYSTEM_T,   0xffff},
  {CAN_FUEL_LEVEL_LOW             , "can_f_low" , &System.can_state.man_data.fuel_low,       &System.can_state_res.man_data.fuel_low,       sizeof(System.can_state.man_data.fuel_low),      UINT8_SYSTEM_T,   0xffff},
  {CAN_EMERGENCY_SHUTDOWN         , "can_em_sh" , &System.can_state.man_data.emergency_sh,   &System.can_state_res.man_data.emergency_sh,   sizeof(System.can_state.man_data.emergency_sh),  UINT8_SYSTEM_T,   0xffff},
  {CAN_ACT_ENG_TORQUE             , "can_en_tq" , &System.can_state.man_data.act_eng_torque, &System.can_state_res.man_data.act_eng_torque, sizeof(System.can_state.man_data.act_eng_torque),UINT8_SYSTEM_T,   0xffff},
  {CAN_AP_KICKDOWN_SW             , "can_kick"  , &System.can_state.man_data.ap_kick_sw,     &System.can_state_res.man_data.ap_kick_sw,     sizeof(System.can_state.man_data.ap_kick_sw),    UINT8_SYSTEM_T,   0xffff},
  {CAN_AP_LOW_IDLE_SW             , "can_l_idl" , &System.can_state.man_data.ap_low_idle,    &System.can_state_res.man_data.ap_low_idle,    sizeof(System.can_state.man_data.ap_low_idle),   UINT8_SYSTEM_T,   0xffff},
  {CAN_LOAD_CURR_SPEED            , "can_l_cur" , &System.can_state.man_data.load_curr,      &System.can_state_res.man_data.load_curr,      sizeof(System.can_state.man_data.load_curr),     UINT8_SYSTEM_T,   0xffff},
  {CAN_ENG_OIL_PRESS              , "can_o_ps"  , &System.can_state.man_data.eng_oil_press,  &System.can_state_res.man_data.eng_oil_press,  sizeof(System.can_state.man_data.eng_oil_press), UINT8_SYSTEM_T,   0xffff},
  {CAN_FUEL_TEMP                  , "can_f_t"   , &System.can_state.man_data.fuel_temp,      &System.can_state_res.man_data.fuel_temp,      sizeof(System.can_state.man_data.fuel_temp),     FLOAT_SYSTEM_T,   0xffff},
  {CAN_ENG_OIL_TEMP               , "can_oil_t" , &System.can_state.man_data.oil_temp,       &System.can_state_res.man_data.oil_temp,       sizeof(System.can_state.man_data.oil_temp),      FLOAT_SYSTEM_T,   0xffff},
  {CAN_P_SUPPLY_PRESS             , "can_s_ps"  , &System.can_state.man_data.supply_press,   &System.can_state_res.man_data.supply_press,   sizeof(System.can_state.man_data.supply_press),  UINT8_SYSTEM_T,   0xffff},
  {CAN_PARK_TR_PRESS              , "can_pt_ps" , &System.can_state.man_data.park_press,     &System.can_state_res.man_data.park_press,     sizeof(System.can_state.man_data.park_press),    UINT8_SYSTEM_T,   0xffff},
  {CAN_SERV_BRAKE_PRESS1          , "can_b_ps1" , &System.can_state.man_data.s_brake_press1, &System.can_state_res.man_data.s_brake_press1, sizeof(System.can_state.man_data.s_brake_press1),UINT8_SYSTEM_T,   0xffff},
  {CAN_SERV_BRAKE_PRESS2          , "can_b_ps2" , &System.can_state.man_data.s_brake_press2, &System.can_state_res.man_data.s_brake_press2, sizeof(System.can_state.man_data.s_brake_press2),UINT8_SYSTEM_T,   0xffff},
  {CAN_AUX_EQUIP_PRESS            , "can_au_ps" , &System.can_state.man_data.aux_press,      &System.can_state_res.man_data.aux_press,      sizeof(System.can_state.man_data.aux_press),     UINT8_SYSTEM_T,   0xffff},
  {CAN_AIR_SUSP_PRESS             , "can_ai_ps" , &System.can_state.man_data.air_s_press,    &System.can_state_res.man_data.air_s_press,    sizeof(System.can_state.man_data.air_s_press),   UINT8_SYSTEM_T,   0xffff},
  {CAN_BAR_PRESS                  , "can_ba_ps" , &System.can_state.man_data.bar_press,      &System.can_state_res.man_data.bar_press,      sizeof(System.can_state.man_data.bar_press),     UINT8_SYSTEM_T,   0xffff},
  {CAN_AMB_AIR_TEMP               , "can_a_tmp" , &System.can_state.man_data.amb_air_temp,   &System.can_state_res.man_data.amb_air_temp,   sizeof(System.can_state.man_data.amb_air_temp),  FLOAT_SYSTEM_T,   0xffff},
  {CAN_SECONDS                    , "can_sec"   , &System.can_state.man_data.sec,            &System.can_state_res.man_data.sec,            sizeof(System.can_state.man_data.sec),           UINT8_SYSTEM_T,   0xffff},
  {CAN_MINUTES                    , "can_min"   , &System.can_state.man_data.min,            &System.can_state_res.man_data.min,            sizeof(System.can_state.man_data.min),           UINT8_SYSTEM_T,   0xffff},
  {CAN_HOURS                      , "can_hrs"   , &System.can_state.man_data.hrs,            &System.can_state_res.man_data.hrs,            sizeof(System.can_state.man_data.hrs),           UINT8_SYSTEM_T,   0xffff},
  {CAN_MONTH                      , "can_mon"   , &System.can_state.man_data.mon,            &System.can_state_res.man_data.mon,            sizeof(System.can_state.man_data.mon),           UINT8_SYSTEM_T,   0xffff},
  {CAN_DAY                        , "can_day"   , &System.can_state.man_data.day,            &System.can_state_res.man_data.day,            sizeof(System.can_state.man_data.day),           UINT8_SYSTEM_T,   0xffff},
  {CAN_YEAR                       , "can_year"  , &System.can_state.man_data.year,           &System.can_state_res.man_data.year,           sizeof(System.can_state.man_data.year),          UINT8_SYSTEM_T,   0xffff},
  {CAN_SH_MIN_GMT                 , "can_s_min" , &System.can_state.man_data.sh_min_gmt,     &System.can_state_res.man_data.sh_min_gmt,     sizeof(System.can_state.man_data.sh_min_gmt),    UINT8_SYSTEM_T,   0xffff},
  {CAN_SH_HRS_GMT                 , "can_s_hrs" , &System.can_state.man_data.sh_hrs_gmt,     &System.can_state_res.man_data.sh_hrs_gmt,     sizeof(System.can_state.man_data.sh_hrs_gmt),    UINT8_SYSTEM_T,   0xffff},
  {CAN_TRIP_DISTANCE              , "can_trip"  , &System.can_state.man_data.trip_dist,      &System.can_state_res.man_data.trip_dist,      sizeof(System.can_state.man_data.trip_dist),     UINT32_SYSTEM_T,  0xffff},
  {CAN_AXLE_LOC_EBS               , "can_l_ebs" , &System.can_state.man_data.axle_loc_ebs,   &System.can_state_res.man_data.axle_loc_ebs,   sizeof(System.can_state.man_data.axle_loc_ebs),  UINT8_SYSTEM_T,   0xffff},
  {CAN_AXLE_WEIGHT_EBS            , "can_w_ebs" , &System.can_state.man_data.axle_weight_ebs,&System.can_state_res.man_data.axle_weight_ebs,sizeof(System.can_state.man_data.axle_weight_ebs),UINT16_SYSTEM_T, 0xffff},
  {CAN_AXLE_LOC_EACS              , "can_l_eac" , &System.can_state.man_data.axle_loc_eac,   &System.can_state_res.man_data.axle_loc_eac,   sizeof(System.can_state.man_data.axle_loc_eac),  UINT8_SYSTEM_T,   0xffff},
  {CAN_AXLE_WEIGHT_EACS           , "can_w_eac" , &System.can_state.man_data.axle_weight_eac,&System.can_state_res.man_data.axle_weight_eac,sizeof(System.can_state.man_data.axle_weight_eac),UINT16_SYSTEM_T, 0xffff},
  {CAN_MOTION_DETECTION           , "can_mo_d"  , &System.can_state.man_data.motion_detect,  &System.can_state_res.man_data.motion_detect,  sizeof(System.can_state.man_data.motion_detect), UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER2_STATUS             , "can_d2_st" , &System.can_state.man_data.driver2_status, &System.can_state_res.man_data.driver2_status, sizeof(System.can_state.man_data.driver2_status),UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER1_STATUS             , "can_d1_st" , &System.can_state.man_data.driver1_status, &System.can_state_res.man_data.driver1_status, sizeof(System.can_state.man_data.driver1_status),UINT8_SYSTEM_T,   0xffff},
  {CAN_OVER_SPEED                 , "can_ov_sp" , &System.can_state.man_data.over_speed,     &System.can_state_res.man_data.over_speed,     sizeof(System.can_state.man_data.over_speed),    UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER1_CARD               , "can_d1_c"  , &System.can_state.man_data.driver1_card,   &System.can_state_res.man_data.driver1_card,   sizeof(System.can_state.man_data.driver1_card),  UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER1_DATA               , "can_d1_d"  , &System.can_state.man_data.driver1_data,   &System.can_state_res.man_data.driver1_data,   sizeof(System.can_state.man_data.driver1_data),  UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER2_CARD               , "can_d2_c"  , &System.can_state.man_data.driver2_card,   &System.can_state_res.man_data.driver2_card,   sizeof(System.can_state.man_data.driver2_card),  UINT8_SYSTEM_T,   0xffff},
  {CAN_DRIVER2_DATA               , "can_d2_d"  , &System.can_state.man_data.driver2_data,   &System.can_state_res.man_data.driver2_data,   sizeof(System.can_state.man_data.driver2_data),  UINT8_SYSTEM_T,   0xffff},
  {CAN_SYSTEM_OPER                , "can_sys_o" , &System.can_state.man_data.system_oper,    &System.can_state_res.man_data.system_oper,    sizeof(System.can_state.man_data.system_oper),   UINT8_SYSTEM_T,   0xffff},
  {CAN_SERVICE_MESS               , "can_ser_m" , &System.can_state.man_data.service_mess,   &System.can_state_res.man_data.service_mess,   sizeof(System.can_state.man_data.service_mess),  UINT8_SYSTEM_T,   0xffff},
  {CAN_SYSTEM_EVENTS              , "can_sys_e" , &System.can_state.man_data.system_events,  &System.can_state_res.man_data.system_events,  sizeof(System.can_state.man_data.system_events), UINT8_SYSTEM_T,   0xffff},
  {CAN_VEH_SPEED_MTCO             , "can_veh_s" , &System.can_state.man_data.veh_speed,      &System.can_state_res.man_data.veh_speed,      sizeof(System.can_state.man_data.veh_speed),     UINT16_SYSTEM_T,  0xffff},
  {CAN_ACT_RX_TORQUE              , "can_rx_t" ,  &System.can_state.man_data.act_rx_torque,  &System.can_state_res.man_data.act_rx_torque,  sizeof(System.can_state.man_data.act_rx_torque), UINT8_SYSTEM_T,   0xffff},
  {CAN_QUERY_SUPPORT              , "can_qu_s" ,  &System.can_state.man_data.query_support,  &System.can_state_res.man_data.query_support,  sizeof(System.can_state.man_data.query_support), UINT8_SYSTEM_T,   0xffff},
  {CAN_DIAG_SUPPORT               , "can_di_s" ,  &System.can_state.man_data.diag_support,   &System.can_state_res.man_data.diag_support,   sizeof(System.can_state.man_data.diag_support),  UINT8_SYSTEM_T,   0xffff},
  {CAN_VER_SOFT                   , "can_v_sft" , &System.can_state.man_data.ver_soft,       &System.can_state_res.man_data.ver_soft,       sizeof(System.can_state.man_data.ver_soft),      STRING_SYSTEM_T,  0xffff},
  {CAN_VIN_CAR                    , "can_vin" ,   &System.can_state.man_data.vin,            &System.can_state_res.man_data.vin,            sizeof(System.can_state.man_data.vin),           STRING_SYSTEM_T,  0xffff},
  {CAN_ACT_RET_TORQ_RE            , "can_re_to" , &System.can_state.man_data.ret_torq_re,    &System.can_state_res.man_data.ret_torq_re,    sizeof(System.can_state.man_data.ret_torq_re),   UINT8_SYSTEM_T,   0xffff},
  {CAN_ACT_RET_TORQ_RD            , "can_rd_to" , &System.can_state.man_data.ret_torq_rd,    &System.can_state_res.man_data.ret_torq_rd,    sizeof(System.can_state.man_data.ret_torq_rd),   UINT8_SYSTEM_T,   0xffff},
  {CAN_FUEL_RATE                  , "can_f_rt" ,  &System.can_state.man_data.fuel_rate,      &System.can_state_res.man_data.fuel_rate,      sizeof(System.can_state.man_data.fuel_rate),     UINT16_SYSTEM_T,  0xffff},
  {CAN_INS_FUEL_ECO               , "can_f_eco" , &System.can_state.man_data.ins_fuel_eco,   &System.can_state_res.man_data.ins_fuel_eco,   sizeof(System.can_state.man_data.ins_fuel_eco),  UINT16_SYSTEM_T,  0xffff},
  {CAN_LOW_OIL_PRESS              , "can_low_o" , &System.can_state.man_data.low_oil_press,  &System.can_state_res.man_data.low_oil_press,  sizeof(System.can_state.man_data.low_oil_press), UINT8_SYSTEM_T,   0xffff},
  {CAN_HIGH_COOLANT_T             , "can_hi_co" , &System.can_state.man_data.high_coolant_t, &System.can_state_res.man_data.high_coolant_t, sizeof(System.can_state.man_data.high_coolant_t),UINT8_SYSTEM_T,   0xffff},
#endif //EXTENDED_ADVANTUM_CAN_PRESENT

#if defined(CANLOG_V4_PRESENT)
#if defined(EXTENDED_ADVANTUM_CAN_PRESENT) // Одновременно EXTENDED_ADVANTUM_CAN_PRESENT и CANLOG_V4_PRESENT не должны быть определены
    static_assert(0, "Выбрать что-то одно CANLOG_V4_PRESENT или EXTENDED_ADVANTUM_CAN_PRESENT");
#endif
  {CAN_V4_BOOT_FRAME, "p2350", &System.can_v4_state.system_info.bootloader_frame, &System.can_v4_state_res.system_info.bootloader_frame, sizeof(System.can_v4_state.system_info.bootloader_frame), ARRAY_SYSTEM_T, 0xffff},
  {CAN_V4_PROGRAM_NUMBER, "p2351", &System.can_v4_state.system_info.program_number, &System.can_v4_state_res.system_info.program_number, sizeof(System.can_v4_state.system_info.program_number), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_FRAME_INTERVAL, "p2352", &System.can_v4_state.system_info.frame_interval, &System.can_v4_state_res.system_info.frame_interval, sizeof(System.can_v4_state.system_info.frame_interval), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_UPDATE_PERCENT, "p2353", &System.can_v4_state.system_info.fw_update_percent, &System.can_v4_state_res.system_info.fw_update_percent, sizeof(System.can_v4_state.system_info.fw_update_percent), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INCOMPLETE_DATA_FLAGS, "p2354", &System.can_v4_state.system_info.incomplete_data_flags, &System.can_v4_state_res.system_info.incomplete_data_flags, sizeof(System.can_v4_state.system_info.incomplete_data_flags), UINT16_SYSTEM_T, 0xffff},
  //reserve 8
#if defined(CANLOG_V4_CONNECTIONS_FLAGS_PRESENT)
  {CAN_V4_CONN_FLAGS_D0, "p2363", &System.can_v4_state.can_connection_flags.bytes.data[0], &System.can_v4_state_res.can_connection_flags.bytes.data[0], sizeof(System.can_v4_state.can_connection_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_CONN_FLAGS_D1, "p2364", &System.can_v4_state.can_connection_flags.bytes.data[1], &System.can_v4_state_res.can_connection_flags.bytes.data[1], sizeof(System.can_v4_state.can_connection_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_CONNECTIONS_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_SECURITY_FLAGS_PRESENT)
  {CAN_V4_SECURITY_FL_D0 , "p2370", &System.can_v4_state.security_flags.bytes.data[0], &System.can_v4_state_res.security_flags.bytes.data[0], sizeof(System.can_v4_state.security_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D1 , "p2371", &System.can_v4_state.security_flags.bytes.data[1], &System.can_v4_state_res.security_flags.bytes.data[1], sizeof(System.can_v4_state.security_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D2 , "p2372", &System.can_v4_state.security_flags.bytes.data[2], &System.can_v4_state_res.security_flags.bytes.data[2], sizeof(System.can_v4_state.security_flags.bytes.data[2]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D3 , "p2373", &System.can_v4_state.security_flags.bytes.data[3], &System.can_v4_state_res.security_flags.bytes.data[3], sizeof(System.can_v4_state.security_flags.bytes.data[3]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D4 , "p2374", &System.can_v4_state.security_flags.bytes.data[4], &System.can_v4_state_res.security_flags.bytes.data[4], sizeof(System.can_v4_state.security_flags.bytes.data[4]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D5 , "p2375", &System.can_v4_state.security_flags.bytes.data[5], &System.can_v4_state_res.security_flags.bytes.data[5], sizeof(System.can_v4_state.security_flags.bytes.data[5]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D6 , "p2376", &System.can_v4_state.security_flags.bytes.data[6], &System.can_v4_state_res.security_flags.bytes.data[6], sizeof(System.can_v4_state.security_flags.bytes.data[6]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D7 , "p2377", &System.can_v4_state.security_flags.bytes.data[7], &System.can_v4_state_res.security_flags.bytes.data[7], sizeof(System.can_v4_state.security_flags.bytes.data[7]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D8 , "p2378", &System.can_v4_state.security_flags.bytes.data[8], &System.can_v4_state_res.security_flags.bytes.data[8], sizeof(System.can_v4_state.security_flags.bytes.data[8]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D9 , "p2379", &System.can_v4_state.security_flags.bytes.data[9], &System.can_v4_state_res.security_flags.bytes.data[9], sizeof(System.can_v4_state.security_flags.bytes.data[9]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D10, "p2380", &System.can_v4_state.security_flags.bytes.data[10], &System.can_v4_state_res.security_flags.bytes.data[10], sizeof(System.can_v4_state.security_flags.bytes.data[10]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D11, "p2381", &System.can_v4_state.security_flags.bytes.data[11], &System.can_v4_state_res.security_flags.bytes.data[11], sizeof(System.can_v4_state.security_flags.bytes.data[11]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_SECURITY_FL_D12, "p2382", &System.can_v4_state.security_flags.bytes.data[12], &System.can_v4_state_res.security_flags.bytes.data[12], sizeof(System.can_v4_state.security_flags.bytes.data[12]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_SECURITY_FLAGS_PRESENT)
  //reserve 4
#if defined(CANLOG_V4_STATE_FLAGS_PRESENT)
  {CAN_V4_STATE_FL_D0, "p2387", &System.can_v4_state.state_flags.bytes.data[0], &System.can_v4_state_res.state_flags.bytes.data[0], sizeof(System.can_v4_state.state_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D1, "p2388", &System.can_v4_state.state_flags.bytes.data[1], &System.can_v4_state_res.state_flags.bytes.data[1], sizeof(System.can_v4_state.state_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D2, "p2389", &System.can_v4_state.state_flags.bytes.data[2], &System.can_v4_state_res.state_flags.bytes.data[2], sizeof(System.can_v4_state.state_flags.bytes.data[2]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D3, "p2390", &System.can_v4_state.state_flags.bytes.data[3], &System.can_v4_state_res.state_flags.bytes.data[3], sizeof(System.can_v4_state.state_flags.bytes.data[3]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D4, "p2391", &System.can_v4_state.state_flags.bytes.data[4], &System.can_v4_state_res.state_flags.bytes.data[4], sizeof(System.can_v4_state.state_flags.bytes.data[4]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D5, "p2392", &System.can_v4_state.state_flags.bytes.data[5], &System.can_v4_state_res.state_flags.bytes.data[5], sizeof(System.can_v4_state.state_flags.bytes.data[5]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D6, "p2393", &System.can_v4_state.state_flags.bytes.data[6], &System.can_v4_state_res.state_flags.bytes.data[6], sizeof(System.can_v4_state.state_flags.bytes.data[6]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D7, "p2394", &System.can_v4_state.state_flags.bytes.data[7], &System.can_v4_state_res.state_flags.bytes.data[7], sizeof(System.can_v4_state.state_flags.bytes.data[7]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_STATE_FL_D8, "p2395", &System.can_v4_state.state_flags.bytes.data[8], &System.can_v4_state_res.state_flags.bytes.data[8], sizeof(System.can_v4_state.state_flags.bytes.data[8]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_STATE_FLAGS_PRESENT)
  //reserve 3
#if defined(CANLOG_V4_INDICATORS_FLAGS_PRESENT)
  {CAN_V4_INDICATORS_FL_D0, "p2399", &System.can_v4_state.state_indicators_flags.bytes.data[0], &System.can_v4_state_res.state_indicators_flags.bytes.data[0], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D1, "p2400", &System.can_v4_state.state_indicators_flags.bytes.data[1], &System.can_v4_state_res.state_indicators_flags.bytes.data[1], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D2, "p2401", &System.can_v4_state.state_indicators_flags.bytes.data[2], &System.can_v4_state_res.state_indicators_flags.bytes.data[2], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[2]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D3, "p2402", &System.can_v4_state.state_indicators_flags.bytes.data[3], &System.can_v4_state_res.state_indicators_flags.bytes.data[3], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[3]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D4, "p2403", &System.can_v4_state.state_indicators_flags.bytes.data[4], &System.can_v4_state_res.state_indicators_flags.bytes.data[4], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[4]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D5, "p2404", &System.can_v4_state.state_indicators_flags.bytes.data[5], &System.can_v4_state_res.state_indicators_flags.bytes.data[5], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[5]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D6, "p2405", &System.can_v4_state.state_indicators_flags.bytes.data[6], &System.can_v4_state_res.state_indicators_flags.bytes.data[6], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[6]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D7, "p2406", &System.can_v4_state.state_indicators_flags.bytes.data[7], &System.can_v4_state_res.state_indicators_flags.bytes.data[7], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[7]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D8, "p2407", &System.can_v4_state.state_indicators_flags.bytes.data[8], &System.can_v4_state_res.state_indicators_flags.bytes.data[8], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[8]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_INDICATORS_FL_D9, "p2408", &System.can_v4_state.state_indicators_flags.bytes.data[9], &System.can_v4_state_res.state_indicators_flags.bytes.data[9], sizeof(System.can_v4_state.state_indicators_flags.bytes.data[9]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_INDICATORS_FLAGS_PRESENT)
  //reserve 4
#if defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_AGRICULTURAL_FL_D0 , "p2413", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[0], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[0], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D1 , "p2414", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[1], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[1], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D2 , "p2415", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[2], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[2], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[2]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D3 , "p2416", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[3], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[3], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[3]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D4 , "p2417", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[4], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[4], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[4]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D5 , "p2418", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[5], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[5], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[5]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D6 , "p2419", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[6], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[6], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[6]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D7 , "p2420", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[7], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[7], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[7]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D8 , "p2421", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[8], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[8], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[8]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D9 , "p2422", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[9], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[9], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[9]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D10, "p2423", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[10], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[10], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[10]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_UTILITY_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_UTILITY_VEHICLES_FL_D0, "p2429", &System.can_v4_state.utility_vehicles_flags.bytes.data[0], &System.can_v4_state_res.utility_vehicles_flags.bytes.data[0], sizeof(System.can_v4_state.utility_vehicles_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_UTILITY_VEHICLES_FL_D1, "p2430", &System.can_v4_state.utility_vehicles_flags.bytes.data[1], &System.can_v4_state_res.utility_vehicles_flags.bytes.data[1], sizeof(System.can_v4_state.utility_vehicles_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_UTILITY_VEHICLES_FL_D2, "p2431", &System.can_v4_state.utility_vehicles_flags.bytes.data[2], &System.can_v4_state_res.utility_vehicles_flags.bytes.data[2], sizeof(System.can_v4_state.utility_vehicles_flags.bytes.data[2]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_UTILITY_VEHICLES_FL_D3, "p2432", &System.can_v4_state.utility_vehicles_flags.bytes.data[3], &System.can_v4_state_res.utility_vehicles_flags.bytes.data[3], sizeof(System.can_v4_state.utility_vehicles_flags.bytes.data[3]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_UTILITY_VEHICLES_FL_D4, "p2433", &System.can_v4_state.utility_vehicles_flags.bytes.data[4], &System.can_v4_state_res.utility_vehicles_flags.bytes.data[4], sizeof(System.can_v4_state.utility_vehicles_flags.bytes.data[4]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_UTILITY_VEHICLES_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_CISTERN_FLAGS_PRESENT)
  {CAN_V4_CISTERNS_FL_D0, "p2439", &System.can_v4_state.cisterns_flags.bytes.data[0], &System.can_v4_state_res.cisterns_flags.bytes.data[0], sizeof(System.can_v4_state.cisterns_flags.bytes.data[0]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_CISTERNS_FL_D1, "p2440", &System.can_v4_state.cisterns_flags.bytes.data[1], &System.can_v4_state_res.cisterns_flags.bytes.data[1], sizeof(System.can_v4_state.cisterns_flags.bytes.data[1]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_CISTERN_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_NUMERIC_DATA_PRESENT)
  {CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME             , "p2446", &System.can_v4_state.numeric_data.total_eng_up_time, &System.can_v4_state_res.numeric_data.total_eng_up_time, sizeof(System.can_v4_state.numeric_data.total_eng_up_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME_COUNTED     , "p2447", &System.can_v4_state.numeric_data.total_eng_up_time_counted, &System.can_v4_state_res.numeric_data.total_eng_up_time_counted, sizeof(System.can_v4_state.numeric_data.total_eng_up_time_counted), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ODOMETER                      , "p2448", &System.can_v4_state.numeric_data.odometer, &System.can_v4_state_res.numeric_data.odometer, sizeof(System.can_v4_state.numeric_data.odometer), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ODOMETER_COUNTED              , "p2449", &System.can_v4_state.numeric_data.odometer_counted, &System.can_v4_state_res.numeric_data.odometer_counted, sizeof(System.can_v4_state.numeric_data.odometer_counted), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION        , "p2450", &System.can_v4_state.numeric_data.total_fuel_consumption, &System.can_v4_state_res.numeric_data.total_fuel_consumption, sizeof(System.can_v4_state.numeric_data.total_fuel_consumption), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION_COUNTED, "p2451", &System.can_v4_state.numeric_data.total_fuel_consumption_counted, &System.can_v4_state_res.numeric_data.total_fuel_consumption_counted, sizeof(System.can_v4_state.numeric_data.total_fuel_consumption_counted), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_FUEL_LEVEL_PERCENT            , "p2452", &System.can_v4_state.numeric_data.fuel_level_percent, &System.can_v4_state_res.numeric_data.fuel_level_percent, sizeof(System.can_v4_state.numeric_data.fuel_level_percent), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_FUEL_LEVEL_LITER              , "p2453", &System.can_v4_state.numeric_data.fuel_level_liter, &System.can_v4_state_res.numeric_data.fuel_level_liter, sizeof(System.can_v4_state.numeric_data.fuel_level_liter), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ENGINE_RPM                    , "p2454", &System.can_v4_state.numeric_data.engine_rpm, &System.can_v4_state_res.numeric_data.engine_rpm, sizeof(System.can_v4_state.numeric_data.engine_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ENGINE_TEMP                   , "p2455", &System.can_v4_state.numeric_data.engine_temp, &System.can_v4_state_res.numeric_data.engine_temp, sizeof(System.can_v4_state.numeric_data.engine_temp), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_SPEED                         , "p2456", &System.can_v4_state.numeric_data.speed, &System.can_v4_state_res.numeric_data.speed, sizeof(System.can_v4_state.numeric_data.speed), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ACCELERATOR_POSITION          , "p2457", &System.can_v4_state.numeric_data.accelerator_position, &System.can_v4_state_res.numeric_data.accelerator_position, sizeof(System.can_v4_state.numeric_data.accelerator_position), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ENGINE_LOAD                   , "p2458", &System.can_v4_state.numeric_data.engine_load, &System.can_v4_state_res.numeric_data.engine_load, sizeof(System.can_v4_state.numeric_data.engine_load), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AXLE_LOAD_1                   , "p2459", &System.can_v4_state.numeric_data.axle_load_1, &System.can_v4_state_res.numeric_data.axle_load_1, sizeof(System.can_v4_state.numeric_data.axle_load_1), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AXLE_LOAD_2                   , "p2460", &System.can_v4_state.numeric_data.axle_load_2, &System.can_v4_state_res.numeric_data.axle_load_2, sizeof(System.can_v4_state.numeric_data.axle_load_2), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AXLE_LOAD_3                   , "p2461", &System.can_v4_state.numeric_data.axle_load_3, &System.can_v4_state_res.numeric_data.axle_load_3, sizeof(System.can_v4_state.numeric_data.axle_load_3), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AXLE_LOAD_4                   , "p2462", &System.can_v4_state.numeric_data.axle_load_4, &System.can_v4_state_res.numeric_data.axle_load_4, sizeof(System.can_v4_state.numeric_data.axle_load_4), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AXLE_LOAD_5                   , "p2463", &System.can_v4_state.numeric_data.axle_load_5, &System.can_v4_state_res.numeric_data.axle_load_5, sizeof(System.can_v4_state.numeric_data.axle_load_5), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_RETARDER_LOAD                 , "p2464", &System.can_v4_state.numeric_data.retarder_load, &System.can_v4_state_res.numeric_data.retarder_load, sizeof(System.can_v4_state.numeric_data.retarder_load), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_CNG_USE                 , "p2465", &System.can_v4_state.numeric_data.total_cng_use, &System.can_v4_state_res.numeric_data.total_cng_use, sizeof(System.can_v4_state.numeric_data.total_cng_use), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_CNG_USE_COUNTED         , "p2466", &System.can_v4_state.numeric_data.total_cng_use_counted, &System.can_v4_state_res.numeric_data.total_cng_use_counted, sizeof(System.can_v4_state.numeric_data.total_cng_use_counted), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_CNG_LEVEL_PERCENT             , "p2467", &System.can_v4_state.numeric_data.cng_level_percent, &System.can_v4_state_res.numeric_data.cng_level_percent, sizeof(System.can_v4_state.numeric_data.cng_level_percent), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_CNG_LEVEL_LITER               , "p2468", &System.can_v4_state.numeric_data.cng_level_liter, &System.can_v4_state_res.numeric_data.cng_level_liter, sizeof(System.can_v4_state.numeric_data.cng_level_liter), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ADBLUE_LEVEL_PERCENT          , "p2469", &System.can_v4_state.numeric_data.adblue_level_percent, &System.can_v4_state_res.numeric_data.adblue_level_percent, sizeof(System.can_v4_state.numeric_data.adblue_level_percent), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_ADBLUE_LEVEL_LITER            , "p2470", &System.can_v4_state.numeric_data.adblue_level_liter, &System.can_v4_state_res.numeric_data.adblue_level_liter, sizeof(System.can_v4_state.numeric_data.adblue_level_liter), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_FUEL_FLOWMETER                , "p2471", &System.can_v4_state.numeric_data.fuel_flowmeter, &System.can_v4_state_res.numeric_data.fuel_flowmeter, sizeof(System.can_v4_state.numeric_data.fuel_flowmeter), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_BATTERY_TEMPERATURE           , "p2472", &System.can_v4_state.numeric_data.battery_temperature, &System.can_v4_state_res.numeric_data.battery_temperature, sizeof(System.can_v4_state.numeric_data.battery_temperature), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_BATTERY_CHARGE_LEVEL          , "p2473", &System.can_v4_state.numeric_data.battery_charge_level, &System.can_v4_state_res.numeric_data.battery_charge_level, sizeof(System.can_v4_state.numeric_data.battery_charge_level), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_BATTERY_VOLTAGE               , "p2474", &System.can_v4_state.numeric_data.battery_voltage, &System.can_v4_state_res.numeric_data.battery_voltage, sizeof(System.can_v4_state.numeric_data.battery_voltage), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_VEHICLES_RANGE                , "p2475", &System.can_v4_state.numeric_data.vehicles_range, &System.can_v4_state_res.numeric_data.vehicles_range, sizeof(System.can_v4_state.numeric_data.vehicles_range), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_BEF_SRVC_TIME                 , "p2476", &System.can_v4_state.numeric_data.bef_srvc_time, &System.can_v4_state_res.numeric_data.bef_srvc_time, sizeof(System.can_v4_state.numeric_data.bef_srvc_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_EX_SRVC_TIME                  , "p2477", &System.can_v4_state.numeric_data.ex_srvc_time, &System.can_v4_state_res.numeric_data.ex_srvc_time, sizeof(System.can_v4_state.numeric_data.ex_srvc_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AFT_SRVC_TIME                 , "p2478", &System.can_v4_state.numeric_data.aft_srvc_time, &System.can_v4_state_res.numeric_data.aft_srvc_time, sizeof(System.can_v4_state.numeric_data.aft_srvc_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_BEF_SRVC_ODO                  , "p2479", &System.can_v4_state.numeric_data.bef_srvc_odo, &System.can_v4_state_res.numeric_data.bef_srvc_odo, sizeof(System.can_v4_state.numeric_data.bef_srvc_odo), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_EX_SRVC_ODO                   , "p2480", &System.can_v4_state.numeric_data.ex_srvc_odo, &System.can_v4_state_res.numeric_data.ex_srvc_odo, sizeof(System.can_v4_state.numeric_data.ex_srvc_odo), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_AFT_SRVC_ODO                  , "p2481", &System.can_v4_state.numeric_data.aft_srvc_odo, &System.can_v4_state_res.numeric_data.aft_srvc_odo, sizeof(System.can_v4_state.numeric_data.aft_srvc_odo), UINT32_SYSTEM_T, 0xffff},

  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_1,                  "p2482", &System.can_v4_state.numeric_data.trailer_axle_load_1, &System.can_v4_state_res.numeric_data.trailer_axle_load_1, sizeof(System.can_v4_state.numeric_data.trailer_axle_load_1), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_2,                  "p2483", &System.can_v4_state.numeric_data.trailer_axle_load_2, &System.can_v4_state_res.numeric_data.trailer_axle_load_2, sizeof(System.can_v4_state.numeric_data.trailer_axle_load_2), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_3,                  "p2484", &System.can_v4_state.numeric_data.trailer_axle_load_3, &System.can_v4_state_res.numeric_data.trailer_axle_load_3, sizeof(System.can_v4_state.numeric_data.trailer_axle_load_3), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_4,                  "p2485", &System.can_v4_state.numeric_data.trailer_axle_load_4, &System.can_v4_state_res.numeric_data.trailer_axle_load_4, sizeof(System.can_v4_state.numeric_data.trailer_axle_load_4), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_1,  "p2486", &System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_1, &System.can_v4_state_res.numeric_data.pressure_in_left_first_wheel_trailer_axle_1, sizeof(System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_1), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_1, "p2487", &System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_1, &System.can_v4_state_res.numeric_data.pressure_in_right_first_wheel_trailer_axle_1, sizeof(System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_1), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_2,  "p2488", &System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_2, &System.can_v4_state_res.numeric_data.pressure_in_left_first_wheel_trailer_axle_2, sizeof(System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_2), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_2, "p2489", &System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_2, &System.can_v4_state_res.numeric_data.pressure_in_right_first_wheel_trailer_axle_2, sizeof(System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_2), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_3,  "p2490", &System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_3, &System.can_v4_state_res.numeric_data.pressure_in_left_first_wheel_trailer_axle_3, sizeof(System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_3), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_3, "p2491", &System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_3, &System.can_v4_state_res.numeric_data.pressure_in_right_first_wheel_trailer_axle_3, sizeof(System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_3), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_4,  "p2492", &System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_4, &System.can_v4_state_res.numeric_data.pressure_in_left_first_wheel_trailer_axle_4, sizeof(System.can_v4_state.numeric_data.pressure_in_left_first_wheel_trailer_axle_4), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_4, "p2493", &System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_4, &System.can_v4_state_res.numeric_data.pressure_in_right_first_wheel_trailer_axle_4, sizeof(System.can_v4_state.numeric_data.pressure_in_right_first_wheel_trailer_axle_4), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_TRAILER_VIN,                                  "p2494", &System.can_v4_state.numeric_data.trailer_vin, &System.can_v4_state_res.numeric_data.trailer_vin, sizeof(System.can_v4_state.numeric_data.trailer_vin), STRING_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_TOTAL_TRAILER_AXLE_LOAD,              "p2495", &System.can_v4_state.numeric_data.total_trailer_axle_load, &System.can_v4_state_res.numeric_data.total_trailer_axle_load, sizeof(System.can_v4_state.numeric_data.total_trailer_axle_load), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_NUMERIC_CARGO_WEIGHT,                         "p2496", &System.can_v4_state.numeric_data.cargo_weight, &System.can_v4_state_res.numeric_data.cargo_weight, sizeof(System.can_v4_state.numeric_data.cargo_weight), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_MAIN_FUEL_UP_TIME,                            "p2497", &System.can_v4_state.numeric_data.main_fuel_up_time, &System.can_v4_state_res.numeric_data.main_fuel_up_time, sizeof(System.can_v4_state.numeric_data.main_fuel_up_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_DUAL_FUEL_UP_TIME,                            "p2498", &System.can_v4_state.numeric_data.dual_fuel_up_time, &System.can_v4_state_res.numeric_data.dual_fuel_up_time, sizeof(System.can_v4_state.numeric_data.dual_fuel_up_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_CNG_PRESSURE,                                 "p2499", &System.can_v4_state.numeric_data.cng_pressure, &System.can_v4_state_res.numeric_data.cng_pressure, sizeof(System.can_v4_state.numeric_data.cng_pressure), UINT16_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_NUMERIC_DATA_PRESENT)
  //reserve 7
#if defined(CANLOG_V4_AGR_NUMERIC_DATA_PRESENT)
  {CAN_V4_AGR_NUMERIC_HARVEST_TIME                , "p2507", &System.can_v4_state.agr_numeric_data.harvest_time, &System.can_v4_state_res.agr_numeric_data.harvest_time, sizeof(System.can_v4_state.agr_numeric_data.harvest_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_HARVEST_AREA                , "p2508", &System.can_v4_state.agr_numeric_data.harvest_area, &System.can_v4_state_res.agr_numeric_data.harvest_area, sizeof(System.can_v4_state.agr_numeric_data.harvest_area), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_HARVEST_EFFICIENCY          , "p2509", &System.can_v4_state.agr_numeric_data.harvest_efficiency, &System.can_v4_state_res.agr_numeric_data.harvest_efficiency, sizeof(System.can_v4_state.agr_numeric_data.harvest_efficiency), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_HARVESTED_GRAIN             , "p2510", &System.can_v4_state.agr_numeric_data.harvested_grain, &System.can_v4_state_res.agr_numeric_data.harvested_grain, sizeof(System.can_v4_state.agr_numeric_data.harvested_grain), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_GRAIN_MOISTURE              , "p2511", &System.can_v4_state.agr_numeric_data.grain_moisture, &System.can_v4_state_res.agr_numeric_data.grain_moisture, sizeof(System.can_v4_state.agr_numeric_data.grain_moisture), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_THRESHER_RPM                , "p2512", &System.can_v4_state.agr_numeric_data.thresher_rpm, &System.can_v4_state_res.agr_numeric_data.thresher_rpm, sizeof(System.can_v4_state.agr_numeric_data.thresher_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_CONCAVE_CLEARANCE           , "p2513", &System.can_v4_state.agr_numeric_data.concave_clearance, &System.can_v4_state_res.agr_numeric_data.concave_clearance, sizeof(System.can_v4_state.agr_numeric_data.concave_clearance), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_ENGINE_PRESSURE             , "p2514", &System.can_v4_state.agr_numeric_data.engine_pressure, &System.can_v4_state_res.agr_numeric_data.engine_pressure, sizeof(System.can_v4_state.agr_numeric_data.engine_pressure), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_CHASSIS_TEMP                , "p2515", &System.can_v4_state.agr_numeric_data.chassis_temp, &System.can_v4_state_res.agr_numeric_data.chassis_temp, sizeof(System.can_v4_state.agr_numeric_data.chassis_temp), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_AUGER_RPM                   , "p2516", &System.can_v4_state.agr_numeric_data.auger_rpm, &System.can_v4_state_res.agr_numeric_data.auger_rpm, sizeof(System.can_v4_state.agr_numeric_data.auger_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_GRAIN_RPM                   , "p2517", &System.can_v4_state.agr_numeric_data.grain_rpm, &System.can_v4_state_res.agr_numeric_data.grain_rpm, sizeof(System.can_v4_state.agr_numeric_data.grain_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_SHREDDER_RPM                , "p2518", &System.can_v4_state.agr_numeric_data.shredder_rpm, &System.can_v4_state_res.agr_numeric_data.shredder_rpm, sizeof(System.can_v4_state.agr_numeric_data.shredder_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_RACK_RPM                    , "p2519", &System.can_v4_state.agr_numeric_data.rack_rpm, &System.can_v4_state_res.agr_numeric_data.rack_rpm, sizeof(System.can_v4_state.agr_numeric_data.rack_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_FAN_RPM                     , "p2520", &System.can_v4_state.agr_numeric_data.fan_rpm, &System.can_v4_state_res.agr_numeric_data.fan_rpm, sizeof(System.can_v4_state.agr_numeric_data.fan_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_FEED_ELEVATOR_RPM           , "p2521", &System.can_v4_state.agr_numeric_data.feed_elevator_rpm, &System.can_v4_state_res.agr_numeric_data.feed_elevator_rpm, sizeof(System.can_v4_state.agr_numeric_data.feed_elevator_rpm), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_REEL_SPEED                  , "p2522", &System.can_v4_state.agr_numeric_data.reel_speed, &System.can_v4_state_res.agr_numeric_data.reel_speed, sizeof(System.can_v4_state.agr_numeric_data.reel_speed), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_TAILINGS_ELEVATOR_PERCENT   , "p2523", &System.can_v4_state.agr_numeric_data.tailings_elevator_percent, &System.can_v4_state_res.agr_numeric_data.tailings_elevator_percent, sizeof(System.can_v4_state.agr_numeric_data.tailings_elevator_percent), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_THRESHER_ON_CURRENT_TIME    , "p2524", &System.can_v4_state.agr_numeric_data.thresher_on_current_time, &System.can_v4_state_res.agr_numeric_data.thresher_on_current_time, sizeof(System.can_v4_state.agr_numeric_data.thresher_on_current_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_THRESHER_ON_TOTAL_TIME      , "p2525", &System.can_v4_state.agr_numeric_data.thresher_on_total_time, &System.can_v4_state_res.agr_numeric_data.thresher_on_total_time, sizeof(System.can_v4_state.agr_numeric_data.thresher_on_total_time), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE        , "p2526", &System.can_v4_state.agr_numeric_data.agr_current_distance, &System.can_v4_state_res.agr_numeric_data.agr_current_distance, sizeof(System.can_v4_state.agr_numeric_data.agr_current_distance), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_AGR_TOTAL_DISTANCE          , "p2527", &System.can_v4_state.agr_numeric_data.agr_total_distance, &System.can_v4_state_res.agr_numeric_data.agr_total_distance, sizeof(System.can_v4_state.agr_numeric_data.agr_total_distance), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE_ON_WORK, "p2528", &System.can_v4_state.agr_numeric_data.agr_current_distance_on_work, &System.can_v4_state_res.agr_numeric_data.agr_current_distance_on_work, sizeof(System.can_v4_state.agr_numeric_data.agr_current_distance_on_work), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_CURRENT_HARVEST_AREA        , "p2529", &System.can_v4_state.agr_numeric_data.current_harvest_area, &System.can_v4_state_res.agr_numeric_data.current_harvest_area, sizeof(System.can_v4_state.agr_numeric_data.current_harvest_area), UINT32_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_NUMERIC_TOTAL_HARVEST_AREA          , "p2530", &System.can_v4_state.agr_numeric_data.total_harvest_area, &System.can_v4_state_res.agr_numeric_data.total_harvest_area, sizeof(System.can_v4_state.agr_numeric_data.total_harvest_area), UINT32_SYSTEM_T, 0xffff},

  {CAN_V4_AGR_TOTAL_TREATED_AREA                 , "p2531", &System.can_v4_state.agr_numeric_data.total_treated_area, &System.can_v4_state_res.agr_numeric_data.total_treated_area, sizeof(System.can_v4_state.agr_numeric_data.total_treated_area), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_LEVEL_OF_LIQUID_IN_TANK            , "p2532", &System.can_v4_state.agr_numeric_data.level_of_liquid_in_tank, &System.can_v4_state_res.agr_numeric_data.level_of_liquid_in_tank, sizeof(System.can_v4_state.agr_numeric_data.level_of_liquid_in_tank), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_SPRAY_PRESSURE                     , "p2533", &System.can_v4_state.agr_numeric_data.spray_pressure, &System.can_v4_state_res.agr_numeric_data.spray_pressure, sizeof(System.can_v4_state.agr_numeric_data.spray_pressure), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_ACTUAL_NORM_OF_LIQUID              , "p2534", &System.can_v4_state.agr_numeric_data.actual_norm_of_liquid, &System.can_v4_state_res.agr_numeric_data.actual_norm_of_liquid, sizeof(System.can_v4_state.agr_numeric_data.actual_norm_of_liquid), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_TOTAL_AMOUNT_OF_LIQUID_USED        , "p2535", &System.can_v4_state.agr_numeric_data.total_amount_of_liquid_used, &System.can_v4_state_res.agr_numeric_data.total_amount_of_liquid_used, sizeof(System.can_v4_state.agr_numeric_data.total_amount_of_liquid_used), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_AREA_THAT_CAN_BE_TREATED_UNTIL_TANK_IS_EMPTY, "p2536", &System.can_v4_state.agr_numeric_data.area_that_can_be_treated_until_tank_is_empty, &System.can_v4_state_res.agr_numeric_data.area_that_can_be_treated_until_tank_is_empty, sizeof(System.can_v4_state.agr_numeric_data.area_that_can_be_treated_until_tank_is_empty), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_DISTANCE_REMAINING_UNTIL_TANK_IS_EMPTY,       "p2537", &System.can_v4_state.agr_numeric_data.distance_remaining_until_tank_is_empty, &System.can_v4_state_res.agr_numeric_data.distance_remaining_until_tank_is_empty, sizeof(System.can_v4_state.agr_numeric_data.distance_remaining_until_tank_is_empty), FLOAT_SYSTEM_T, 0xffff},
  {CAN_V4_AGR_TOTAL_WEIGHT_OF_SPREAD_MATERIAL,     "p2538", &System.can_v4_state.agr_numeric_data.total_weight_of_spread_material, &System.can_v4_state_res.agr_numeric_data.total_weight_of_spread_material, sizeof(System.can_v4_state.agr_numeric_data.total_weight_of_spread_material), UINT32_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_AGR_NUMERIC_DATA_PRESENT)
  //reserve 3
#if defined(CANLOG_V4_TACHO_PRESENT)
  {CAN_V4_TACHO_SYSTEM_INFO                            , "p2542", &System.can_v4_state.tacho_data.tacho_info.bytes, &System.can_v4_state_res.tacho_data.cards_info.bytes.data, sizeof(System.can_v4_state.tacho_data.tacho_info.bytes.data), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_CARDS_INFO                             , "p2543", &System.can_v4_state.tacho_data.cards_info.bytes.data, &System.can_v4_state_res.tacho_data.cards_info.bytes.data, sizeof(System.can_v4_state.tacho_data.cards_info.bytes.data), UINT8_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_FIRST_NAME                , "p2544", &System.can_v4_state.tacho_data.driver_info[0].first_name, &System.can_v4_state_res.tacho_data.driver_info[0].first_name, sizeof(System.can_v4_state.tacho_data.driver_info[0].first_name), STRING_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_FIRST_NAME                , "p2545", &System.can_v4_state.tacho_data.driver_info[1].first_name, &System.can_v4_state_res.tacho_data.driver_info[1].first_name, sizeof(System.can_v4_state.tacho_data.driver_info[1].first_name), STRING_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_LAST_NAME                 , "p2546", &System.can_v4_state.tacho_data.driver_info[0].last_name, &System.can_v4_state_res.tacho_data.driver_info[0].last_name, sizeof(System.can_v4_state.tacho_data.driver_info[0].last_name), STRING_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_LAST_NAME                 , "p2547", &System.can_v4_state.tacho_data.driver_info[1].last_name, &System.can_v4_state_res.tacho_data.driver_info[1].last_name, sizeof(System.can_v4_state.tacho_data.driver_info[1].last_name), STRING_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_ID                        , "p2548", &System.can_v4_state.tacho_data.driver_info[0].id, &System.can_v4_state_res.tacho_data.driver_info[0].id, sizeof(System.can_v4_state.tacho_data.driver_info[0].id), STRING_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_ID                        , "p2549", &System.can_v4_state.tacho_data.driver_info[1].id, &System.can_v4_state_res.tacho_data.driver_info[1].id, sizeof(System.can_v4_state.tacho_data.driver_info[1].id), STRING_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_STATE                     , "p2550", &System.can_v4_state.tacho_data.driver_info[0].state, &System.can_v4_state_res.tacho_data.driver_info[0].state, sizeof(System.can_v4_state.tacho_data.driver_info[0].state), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_STATE                     , "p2551", &System.can_v4_state.tacho_data.driver_info[1].state, &System.can_v4_state_res.tacho_data.driver_info[1].state, sizeof(System.can_v4_state.tacho_data.driver_info[1].state), UINT8_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_WORK_TIME                 , "p2552", &System.can_v4_state.tacho_data.driver_info[0].work_time, &System.can_v4_state_res.tacho_data.driver_info[0].work_time, sizeof(System.can_v4_state.tacho_data.driver_info[0].work_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_WORK_TIME                 , "p2553", &System.can_v4_state.tacho_data.driver_info[1].work_time, &System.can_v4_state_res.tacho_data.driver_info[1].work_time, sizeof(System.can_v4_state.tacho_data.driver_info[1].work_time), UINT16_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_TOTAL_RELAX_TIME          , "p2554", &System.can_v4_state.tacho_data.driver_info[0].total_relax_time, &System.can_v4_state_res.tacho_data.driver_info[0].total_relax_time, sizeof(System.can_v4_state.tacho_data.driver_info[0].total_relax_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_TOTAL_RELAX_TIME          , "p2555", &System.can_v4_state.tacho_data.driver_info[1].total_relax_time, &System.can_v4_state_res.tacho_data.driver_info[1].total_relax_time, sizeof(System.can_v4_state.tacho_data.driver_info[1].total_relax_time), UINT16_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_CURR_ACTIVITY_TIME        , "p2556", &System.can_v4_state.tacho_data.driver_info[0].curr_activity_time, &System.can_v4_state_res.tacho_data.driver_info[0].curr_activity_time, sizeof(System.can_v4_state.tacho_data.driver_info[0].curr_activity_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_CURR_ACTIVITY_TIME        , "p2557", &System.can_v4_state.tacho_data.driver_info[1].curr_activity_time, &System.can_v4_state_res.tacho_data.driver_info[1].curr_activity_time, sizeof(System.can_v4_state.tacho_data.driver_info[1].curr_activity_time), UINT16_SYSTEM_T, 0xffff},

  {CAN_V4_TACHO_DRIVER1_INFO_ACTIVITY_AT_LAST_WEEK_TIME, "p2558", &System.can_v4_state.tacho_data.driver_info[0].activity_at_last_week_time, &System.can_v4_state_res.tacho_data.driver_info[0].activity_at_last_week_time, sizeof(System.can_v4_state.tacho_data.driver_info[0].activity_at_last_week_time), UINT16_SYSTEM_T, 0xffff},
  {CAN_V4_TACHO_DRIVER2_INFO_ACTIVITY_AT_LAST_WEEK_TIME, "p2559", &System.can_v4_state.tacho_data.driver_info[1].activity_at_last_week_time, &System.can_v4_state_res.tacho_data.driver_info[1].activity_at_last_week_time, sizeof(System.can_v4_state.tacho_data.driver_info[1].activity_at_last_week_time), UINT16_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_TACHO_PRESENT)
  //no reserve
#endif  //defined(CANLOG_V4_PRESENT)

#if defined(CARRIER_PRESENT)
  {CARRIER_COOMUNICATION_STATE, "carr_ok"    , &System.signal_state.is_carrier_ok,                    &System.signal_state_res.is_carrier_ok,                  sizeof(System.signal_state.is_carrier_ok),                   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OVERALL_STATUS     , "carr_os"    , &System.signal_state.carrier_state.over_stat,          &System.signal_state_res.carrier_state.over_stat,        sizeof(System.signal_state.carrier_state.over_stat),         UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OP_COMP1           , "carr_op_c1" , &System.signal_state.carrier_state.mode_op_comp1,      &System.signal_state_res.carrier_state.mode_op_comp1,    sizeof(System.signal_state.carrier_state.mode_op_comp1),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OP_COMP2           , "carr_op_c2" , &System.signal_state.carrier_state.mode_op_comp2,      &System.signal_state_res.carrier_state.mode_op_comp2,    sizeof(System.signal_state.carrier_state.mode_op_comp2),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OP_COMP3           , "carr_op_c3" , &System.signal_state.carrier_state.mode_op_comp3,      &System.signal_state_res.carrier_state.mode_op_comp3,    sizeof(System.signal_state.carrier_state.mode_op_comp3),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ENG_STAT           , "carr_e_st"  , &System.signal_state.carrier_state.engine_status,      &System.signal_state_res.carrier_state.engine_status,    sizeof(System.signal_state.carrier_state.engine_status),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM_STAT          , "carr_a_st"  , &System.signal_state.carrier_state.alarm_status,       &System.signal_state_res.carrier_state.alarm_status,     sizeof(System.signal_state.carrier_state.alarm_status),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_NUM_ALRMS          , "carr_num_a" , &System.signal_state.carrier_state.num_act_alarms,     &System.signal_state_res.carrier_state.num_act_alarms,   sizeof(System.signal_state.carrier_state.num_act_alarms),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM1              , "carr_a1"    , &System.signal_state.carrier_state.alarm_byte1,        &System.signal_state_res.carrier_state.alarm_byte1,      sizeof(System.signal_state.carrier_state.alarm_byte1),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM2              , "carr_a2"    , &System.signal_state.carrier_state.alarm_byte2,        &System.signal_state_res.carrier_state.alarm_byte2,      sizeof(System.signal_state.carrier_state.alarm_byte2),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM3              , "carr_a3"    , &System.signal_state.carrier_state.alarm_byte3,        &System.signal_state_res.carrier_state.alarm_byte3,      sizeof(System.signal_state.carrier_state.alarm_byte3),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM4              , "carr_a4"    , &System.signal_state.carrier_state.alarm_byte4,        &System.signal_state_res.carrier_state.alarm_byte4,      sizeof(System.signal_state.carrier_state.alarm_byte4),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM5              , "carr_a5"    , &System.signal_state.carrier_state.alarm_byte5,        &System.signal_state_res.carrier_state.alarm_byte5,      sizeof(System.signal_state.carrier_state.alarm_byte5),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM6              , "carr_a6"    , &System.signal_state.carrier_state.alarm_byte6,        &System.signal_state_res.carrier_state.alarm_byte6,      sizeof(System.signal_state.carrier_state.alarm_byte6),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM7              , "carr_a7"    , &System.signal_state.carrier_state.alarm_byte7,        &System.signal_state_res.carrier_state.alarm_byte7,      sizeof(System.signal_state.carrier_state.alarm_byte7),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM8              , "carr_a8"    , &System.signal_state.carrier_state.alarm_byte8,        &System.signal_state_res.carrier_state.alarm_byte8,      sizeof(System.signal_state.carrier_state.alarm_byte8),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM9              , "carr_a9"    , &System.signal_state.carrier_state.alarm_byte9,        &System.signal_state_res.carrier_state.alarm_byte9,      sizeof(System.signal_state.carrier_state.alarm_byte9),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM10             , "carr_a10"   , &System.signal_state.carrier_state.alarm_byte10,       &System.signal_state_res.carrier_state.alarm_byte10,     sizeof(System.signal_state.carrier_state.alarm_byte10),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM11             , "carr_a11"   , &System.signal_state.carrier_state.alarm_byte11,       &System.signal_state_res.carrier_state.alarm_byte11,     sizeof(System.signal_state.carrier_state.alarm_byte11),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM12             , "carr_a12"   , &System.signal_state.carrier_state.alarm_byte12,       &System.signal_state_res.carrier_state.alarm_byte12,     sizeof(System.signal_state.carrier_state.alarm_byte12),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM13             , "carr_a13"   , &System.signal_state.carrier_state.alarm_byte13,       &System.signal_state_res.carrier_state.alarm_byte13,     sizeof(System.signal_state.carrier_state.alarm_byte13),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM14             , "carr_a14"   , &System.signal_state.carrier_state.alarm_byte14,       &System.signal_state_res.carrier_state.alarm_byte14,     sizeof(System.signal_state.carrier_state.alarm_byte14),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM15             , "carr_a15"   , &System.signal_state.carrier_state.alarm_byte15,       &System.signal_state_res.carrier_state.alarm_byte15,     sizeof(System.signal_state.carrier_state.alarm_byte15),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ALRM16             , "carr_a16"   , &System.signal_state.carrier_state.alarm_byte16,       &System.signal_state_res.carrier_state.alarm_byte16,     sizeof(System.signal_state.carrier_state.alarm_byte16),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_NUM_INA_ALRMS      , "carr_n_i_a" , &System.signal_state.carrier_state.num_inact_alarms,   &System.signal_state_res.carrier_state.num_inact_alarms, sizeof(System.signal_state.carrier_state.num_inact_alarms),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM1          , "carr_i_a1"  , &System.signal_state.carrier_state.ina_alarm_byte1,    &System.signal_state_res.carrier_state.ina_alarm_byte1,  sizeof(System.signal_state.carrier_state.ina_alarm_byte1),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM2          , "carr_i_a2"  , &System.signal_state.carrier_state.ina_alarm_byte2,    &System.signal_state_res.carrier_state.ina_alarm_byte2,  sizeof(System.signal_state.carrier_state.ina_alarm_byte2),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM3          , "carr_i_a3"  , &System.signal_state.carrier_state.ina_alarm_byte3,    &System.signal_state_res.carrier_state.ina_alarm_byte3,  sizeof(System.signal_state.carrier_state.ina_alarm_byte3),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM4          , "carr_i_a4"  , &System.signal_state.carrier_state.ina_alarm_byte4,    &System.signal_state_res.carrier_state.ina_alarm_byte4,  sizeof(System.signal_state.carrier_state.ina_alarm_byte4),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM5          , "carr_i_a5"  , &System.signal_state.carrier_state.ina_alarm_byte5,    &System.signal_state_res.carrier_state.ina_alarm_byte5,  sizeof(System.signal_state.carrier_state.ina_alarm_byte5),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM6          , "carr_i_a6"  , &System.signal_state.carrier_state.ina_alarm_byte6,    &System.signal_state_res.carrier_state.ina_alarm_byte6,  sizeof(System.signal_state.carrier_state.ina_alarm_byte6),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM7          , "carr_i_a7"  , &System.signal_state.carrier_state.ina_alarm_byte7,    &System.signal_state_res.carrier_state.ina_alarm_byte7,  sizeof(System.signal_state.carrier_state.ina_alarm_byte7),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM8          , "carr_i_a8"  , &System.signal_state.carrier_state.ina_alarm_byte8,    &System.signal_state_res.carrier_state.ina_alarm_byte8,  sizeof(System.signal_state.carrier_state.ina_alarm_byte8),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM9          , "carr_i_a9"  , &System.signal_state.carrier_state.ina_alarm_byte9,    &System.signal_state_res.carrier_state.ina_alarm_byte9,  sizeof(System.signal_state.carrier_state.ina_alarm_byte9),   UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM10         , "carr_i_a10" , &System.signal_state.carrier_state.ina_alarm_byte10,   &System.signal_state_res.carrier_state.ina_alarm_byte10, sizeof(System.signal_state.carrier_state.ina_alarm_byte10),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM11         , "carr_i_a11" , &System.signal_state.carrier_state.ina_alarm_byte11,   &System.signal_state_res.carrier_state.ina_alarm_byte11, sizeof(System.signal_state.carrier_state.ina_alarm_byte11),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM12         , "carr_i_a12" , &System.signal_state.carrier_state.ina_alarm_byte12,   &System.signal_state_res.carrier_state.ina_alarm_byte12, sizeof(System.signal_state.carrier_state.ina_alarm_byte12),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM13         , "carr_i_a13" , &System.signal_state.carrier_state.ina_alarm_byte13,   &System.signal_state_res.carrier_state.ina_alarm_byte13, sizeof(System.signal_state.carrier_state.ina_alarm_byte13),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM14         , "carr_i_a14" , &System.signal_state.carrier_state.ina_alarm_byte14,   &System.signal_state_res.carrier_state.ina_alarm_byte14, sizeof(System.signal_state.carrier_state.ina_alarm_byte14),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM15         , "carr_i_a15" , &System.signal_state.carrier_state.ina_alarm_byte15,   &System.signal_state_res.carrier_state.ina_alarm_byte15, sizeof(System.signal_state.carrier_state.ina_alarm_byte15),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INA_ALRM16         , "carr_i_a16" , &System.signal_state.carrier_state.ina_alarm_byte16,   &System.signal_state_res.carrier_state.ina_alarm_byte16, sizeof(System.signal_state.carrier_state.ina_alarm_byte16),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_TRAILER_ID         , "carr_t_id"  , &System.signal_state.carrier_state.trailer_id,         &System.signal_state_res.carrier_state.trailer_id,       sizeof(System.signal_state.carrier_state.trailer_id),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_UNIT_SN            , "carr_u_sn"  , &System.signal_state.carrier_state.unit_sn,            &System.signal_state_res.carrier_state.unit_sn,          sizeof(System.signal_state.carrier_state.unit_sn),           STRING_SYSTEM_T,  0xffff},
  {CARRIER_SOFT_REV           , "carr_s_rev" , &System.signal_state.carrier_state.soft_rev,           &System.signal_state_res.carrier_state.soft_rev,         sizeof(System.signal_state.carrier_state.soft_rev),          STRING_SYSTEM_T,  0xffff},
  {CARRIER_COMP_SP1           , "carr_c_sp1" , &System.signal_state.carrier_state.comp1_sp,           &System.signal_state_res.carrier_state.comp1_sp,         sizeof(System.signal_state.carrier_state.comp1_sp),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_COMP_SP2           , "carr_c_sp2" , &System.signal_state.carrier_state.comp2_sp,           &System.signal_state_res.carrier_state.comp2_sp,         sizeof(System.signal_state.carrier_state.comp2_sp),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_COMP_SP3           , "carr_c_sp3" , &System.signal_state.carrier_state.comp3_sp,           &System.signal_state_res.carrier_state.comp3_sp,         sizeof(System.signal_state.carrier_state.comp3_sp),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_AMBIENT            , "carr_amb"   , &System.signal_state.carrier_state.ambient,            &System.signal_state_res.carrier_state.ambient,          sizeof(System.signal_state.carrier_state.ambient),           FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP1_RET     , "carr_c1_r"  , &System.signal_state.carrier_state.comp1_ret,          &System.signal_state_res.carrier_state.comp1_ret,        sizeof(System.signal_state.carrier_state.comp1_ret),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP1_SUPL    , "carr_c1_s"  , &System.signal_state.carrier_state.comp1_sup,          &System.signal_state_res.carrier_state.comp1_sup,        sizeof(System.signal_state.carrier_state.comp1_sup),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP2_RET     , "carr_c2_r"  , &System.signal_state.carrier_state.comp2_ret,          &System.signal_state_res.carrier_state.comp2_ret,        sizeof(System.signal_state.carrier_state.comp2_ret),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP2_SUPL    , "carr_c2_s"  , &System.signal_state.carrier_state.comp2_sup,          &System.signal_state_res.carrier_state.comp2_sup,        sizeof(System.signal_state.carrier_state.comp2_sup),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP3_RET     , "carr_c3_r"  , &System.signal_state.carrier_state.comp3_ret,          &System.signal_state_res.carrier_state.comp3_ret,        sizeof(System.signal_state.carrier_state.comp3_ret),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_COMP3_SUPL    , "carr_c3_s"  , &System.signal_state.carrier_state.comp3_sup,          &System.signal_state_res.carrier_state.comp3_sup,        sizeof(System.signal_state.carrier_state.comp3_sup),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SENS1       , "carr_r_s1"  , &System.signal_state.carrier_state.rem_sens1,          &System.signal_state_res.carrier_state.rem_sens1,        sizeof(System.signal_state.carrier_state.rem_sens1),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SENS2       , "carr_r_s2"  , &System.signal_state.carrier_state.rem_sens2,          &System.signal_state_res.carrier_state.rem_sens2,        sizeof(System.signal_state.carrier_state.rem_sens2),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SENS3       , "carr_r_s3"  , &System.signal_state.carrier_state.rem_sens3,          &System.signal_state_res.carrier_state.rem_sens3,        sizeof(System.signal_state.carrier_state.rem_sens3),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_BATTERY_VOL        , "carr_b_vol" , &System.signal_state.carrier_state.bat_vol,            &System.signal_state_res.carrier_state.bat_vol,          sizeof(System.signal_state.carrier_state.bat_vol),           FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_FUEL_LEVEL         , "carr_f_l"   , &System.signal_state.carrier_state.fuel_level,         &System.signal_state_res.carrier_state.fuel_level,       sizeof(System.signal_state.carrier_state.fuel_level),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_DOOR_SW            , "carr_d_sw"  , &System.signal_state.carrier_state.door_sw,            &System.signal_state_res.carrier_state.door_sw,          sizeof(System.signal_state.carrier_state.door_sw),           UINT8_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SW1         , "carr_r_sw1" , &System.signal_state.carrier_state.remote_sw1,         &System.signal_state_res.carrier_state.remote_sw1,       sizeof(System.signal_state.carrier_state.remote_sw1),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SW2         , "carr_r_sw2" , &System.signal_state.carrier_state.remote_sw2,         &System.signal_state_res.carrier_state.remote_sw2,       sizeof(System.signal_state.carrier_state.remote_sw2),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ENG_COOLANT        , "carr_e_cl"  , &System.signal_state.carrier_state.eng_coolant,        &System.signal_state_res.carrier_state.eng_coolant,      sizeof(System.signal_state.carrier_state.eng_coolant),       FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_RPM                , "carr_rpm"   , &System.signal_state.carrier_state.rpm,                &System.signal_state_res.carrier_state.rpm,              sizeof(System.signal_state.carrier_state.rpm),               FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SW3         , "carr_r_sw3" , &System.signal_state.carrier_state.remote_sw3,         &System.signal_state_res.carrier_state.remote_sw3,       sizeof(System.signal_state.carrier_state.remote_sw3),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_REMOTE_SW4         , "carr_r_sw4" , &System.signal_state.carrier_state.remote_sw4,         &System.signal_state_res.carrier_state.remote_sw4,       sizeof(System.signal_state.carrier_state.remote_sw4),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_ENG_HOURS          , "carr_en_h"  , &System.signal_state.carrier_state.eng_hours,          &System.signal_state_res.carrier_state.eng_hours,        sizeof(System.signal_state.carrier_state.eng_hours),         UINT32_SYSTEM_T,  0xffff},
  {CARRIER_STBY_HOURS         , "carr_st_h"  , &System.signal_state.carrier_state.stby_hours,         &System.signal_state_res.carrier_state.stby_hours,       sizeof(System.signal_state.carrier_state.stby_hours),        UINT32_SYSTEM_T,  0xffff},
  {CARRIER_SW_ON_HOURS        , "carr_sw_h"  , &System.signal_state.carrier_state.sw_on_hours,        &System.signal_state_res.carrier_state.sw_on_hours,      sizeof(System.signal_state.carrier_state.sw_on_hours),       UINT32_SYSTEM_T,  0xffff},
  {CARRIER_PREV_HOUR_M1       , "carr_p_m1"  , &System.signal_state.carrier_state.prev_hour_m1,       &System.signal_state_res.carrier_state.prev_hour_m1,     sizeof(System.signal_state.carrier_state.prev_hour_m1),      UINT32_SYSTEM_T,  0xffff},
  {CARRIER_PREV_HOUR_M2       , "carr_p_m2"  , &System.signal_state.carrier_state.prev_hour_m2,       &System.signal_state_res.carrier_state.prev_hour_m2,     sizeof(System.signal_state.carrier_state.prev_hour_m2),      UINT32_SYSTEM_T,  0xffff},
  {CARRIER_PREV_HOUR_M3       , "carr_p_m3"  , &System.signal_state.carrier_state.prev_hour_m3,       &System.signal_state_res.carrier_state.prev_hour_m3,     sizeof(System.signal_state.carrier_state.prev_hour_m3),      UINT32_SYSTEM_T,  0xffff},
  {CARRIER_PREV_HOUR_M4       , "carr_p_m4"  , &System.signal_state.carrier_state.prev_hour_m4,       &System.signal_state_res.carrier_state.prev_hour_m4,     sizeof(System.signal_state.carrier_state.prev_hour_m4),      UINT32_SYSTEM_T,  0xffff},
  {CARRIER_PREV_HOUR_M5       , "carr_p_m5"  , &System.signal_state.carrier_state.prev_hour_m5,       &System.signal_state_res.carrier_state.prev_hour_m5,     sizeof(System.signal_state.carrier_state.prev_hour_m5),      UINT32_SYSTEM_T,  0xffff},
  {CARRIER_ACT_INTELLISET     , "carr_a_int" , &System.signal_state.carrier_state.act_int_set,        &System.signal_state_res.carrier_state.act_int_set,      sizeof(System.signal_state.carrier_state.act_int_set),       STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET_FNAME   , "carr_int_f" , &System.signal_state.carrier_state.act_int_fn,         &System.signal_state_res.carrier_state.act_int_fn,       sizeof(System.signal_state.carrier_state.act_int_fn),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_NUM_INTELLISET     , "carr_n_int" , &System.signal_state.carrier_state.act_nm_int,         &System.signal_state_res.carrier_state.act_nm_int,       sizeof(System.signal_state.carrier_state.act_nm_int),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_INTELLISET1_NAME   , "carr_int1_n", &System.signal_state.carrier_state.int1_name,          &System.signal_state_res.carrier_state.int1_name,        sizeof(System.signal_state.carrier_state.int1_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET2_NAME   , "carr_int2_n", &System.signal_state.carrier_state.int2_name,          &System.signal_state_res.carrier_state.int2_name,        sizeof(System.signal_state.carrier_state.int2_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET3_NAME   , "carr_int3_n", &System.signal_state.carrier_state.int3_name,          &System.signal_state_res.carrier_state.int3_name,        sizeof(System.signal_state.carrier_state.int3_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET4_NAME   , "carr_int4_n", &System.signal_state.carrier_state.int4_name,          &System.signal_state_res.carrier_state.int4_name,        sizeof(System.signal_state.carrier_state.int4_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET5_NAME   , "carr_int5_n", &System.signal_state.carrier_state.int5_name,          &System.signal_state_res.carrier_state.int5_name,        sizeof(System.signal_state.carrier_state.int5_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET6_NAME   , "carr_int6_n", &System.signal_state.carrier_state.int6_name,          &System.signal_state_res.carrier_state.int6_name,        sizeof(System.signal_state.carrier_state.int6_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET7_NAME   , "carr_int7_n", &System.signal_state.carrier_state.int7_name,          &System.signal_state_res.carrier_state.int7_name,        sizeof(System.signal_state.carrier_state.int7_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET8_NAME   , "carr_int8_n", &System.signal_state.carrier_state.int8_name,          &System.signal_state_res.carrier_state.int8_name,        sizeof(System.signal_state.carrier_state.int8_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET9_NAME   , "carr_int9_n", &System.signal_state.carrier_state.int9_name,          &System.signal_state_res.carrier_state.int9_name,        sizeof(System.signal_state.carrier_state.int9_name),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET10_NAME  , "carr_int10_n",&System.signal_state.carrier_state.int10_name,         &System.signal_state_res.carrier_state.int10_name,       sizeof(System.signal_state.carrier_state.int10_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET11_NAME  , "carr_int11_n",&System.signal_state.carrier_state.int11_name,         &System.signal_state_res.carrier_state.int11_name,       sizeof(System.signal_state.carrier_state.int11_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET12_NAME  , "carr_int12_n",&System.signal_state.carrier_state.int12_name,         &System.signal_state_res.carrier_state.int12_name,       sizeof(System.signal_state.carrier_state.int12_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET13_NAME  , "carr_int13_n",&System.signal_state.carrier_state.int13_name,         &System.signal_state_res.carrier_state.int13_name,       sizeof(System.signal_state.carrier_state.int13_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET14_NAME  , "carr_int14_n",&System.signal_state.carrier_state.int14_name,         &System.signal_state_res.carrier_state.int14_name,       sizeof(System.signal_state.carrier_state.int14_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET15_NAME  , "carr_int15_n",&System.signal_state.carrier_state.int15_name,         &System.signal_state_res.carrier_state.int15_name,       sizeof(System.signal_state.carrier_state.int15_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET16_NAME  , "carr_int16_n",&System.signal_state.carrier_state.int16_name,         &System.signal_state_res.carrier_state.int16_name,       sizeof(System.signal_state.carrier_state.int16_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET17_NAME  , "carr_int17_n",&System.signal_state.carrier_state.int17_name,         &System.signal_state_res.carrier_state.int17_name,       sizeof(System.signal_state.carrier_state.int17_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET18_NAME  , "carr_int18_n",&System.signal_state.carrier_state.int18_name,         &System.signal_state_res.carrier_state.int18_name,       sizeof(System.signal_state.carrier_state.int18_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET19_NAME  , "carr_int19_n",&System.signal_state.carrier_state.int19_name,         &System.signal_state_res.carrier_state.int19_name,       sizeof(System.signal_state.carrier_state.int19_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET20_NAME  , "carr_int20_n",&System.signal_state.carrier_state.int20_name,         &System.signal_state_res.carrier_state.int20_name,       sizeof(System.signal_state.carrier_state.int20_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET21_NAME  , "carr_int21_n",&System.signal_state.carrier_state.int21_name,         &System.signal_state_res.carrier_state.int21_name,       sizeof(System.signal_state.carrier_state.int21_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET22_NAME  , "carr_int22_n",&System.signal_state.carrier_state.int22_name,         &System.signal_state_res.carrier_state.int22_name,       sizeof(System.signal_state.carrier_state.int22_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET23_NAME  , "carr_int23_n",&System.signal_state.carrier_state.int23_name,         &System.signal_state_res.carrier_state.int23_name,       sizeof(System.signal_state.carrier_state.int23_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET24_NAME  , "carr_int24_n",&System.signal_state.carrier_state.int24_name,         &System.signal_state_res.carrier_state.int24_name,       sizeof(System.signal_state.carrier_state.int24_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET25_NAME  , "carr_int25_n",&System.signal_state.carrier_state.int25_name,         &System.signal_state_res.carrier_state.int25_name,       sizeof(System.signal_state.carrier_state.int25_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET26_NAME  , "carr_int26_n",&System.signal_state.carrier_state.int26_name,         &System.signal_state_res.carrier_state.int26_name,       sizeof(System.signal_state.carrier_state.int26_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET27_NAME  , "carr_int27_n",&System.signal_state.carrier_state.int27_name,         &System.signal_state_res.carrier_state.int27_name,       sizeof(System.signal_state.carrier_state.int27_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET28_NAME  , "carr_int28_n",&System.signal_state.carrier_state.int28_name,         &System.signal_state_res.carrier_state.int28_name,       sizeof(System.signal_state.carrier_state.int28_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET29_NAME  , "carr_int29_n",&System.signal_state.carrier_state.int29_name,         &System.signal_state_res.carrier_state.int29_name,       sizeof(System.signal_state.carrier_state.int29_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET30_NAME  , "carr_int30_n",&System.signal_state.carrier_state.int30_name,         &System.signal_state_res.carrier_state.int30_name,       sizeof(System.signal_state.carrier_state.int30_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_INTELLISET31_NAME  , "carr_int31_n",&System.signal_state.carrier_state.int31_name,         &System.signal_state_res.carrier_state.int31_name,       sizeof(System.signal_state.carrier_state.int31_name),        STRING_SYSTEM_T,  0xffff},
  {CARRIER_C1_CONTR_PROBE     , "carr_c1_cp" , &System.signal_state.carrier_state.c1_contr_probe,     &System.signal_state_res.carrier_state.c1_contr_probe,   sizeof(System.signal_state.carrier_state.c1_contr_probe),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_TEMP_UNITS         , "carr_t_un"  , &System.signal_state.carrier_state.temp_units,         &System.signal_state_res.carrier_state.temp_units,       sizeof(System.signal_state.carrier_state.temp_units),        UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRESS_UNITS        , "carr_p_un"  , &System.signal_state.carrier_state.press_units,        &System.signal_state_res.carrier_state.press_units,      sizeof(System.signal_state.carrier_state.press_units),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_AIR_FLOW           , "carr_air"   , &System.signal_state.carrier_state.air_flow,           &System.signal_state_res.carrier_state.air_flow,         sizeof(System.signal_state.carrier_state.air_flow),          UINT8_SYSTEM_T,   0xffff},
  {CARRIER_DEFROST_INTERV     , "carr_def_i" , &System.signal_state.carrier_state.defrost_int,        &System.signal_state_res.carrier_state.defrost_int,      sizeof(System.signal_state.carrier_state.defrost_int),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_FRESH_PROTECT      , "carr_fr_pr" , &System.signal_state.carrier_state.fresh_protect,      &System.signal_state_res.carrier_state.fresh_protect,    sizeof(System.signal_state.carrier_state.fresh_protect),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_C2_CONTR_PROBE     , "carr_c2_cp" , &System.signal_state.carrier_state.c2_contr_probe,     &System.signal_state_res.carrier_state.c2_contr_probe,   sizeof(System.signal_state.carrier_state.c2_contr_probe),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_AFAX_STATUS        , "carr_af_st" , &System.signal_state.carrier_state.afax_status,        &System.signal_state_res.carrier_state.afax_status,      sizeof(System.signal_state.carrier_state.afax_status),       UINT8_SYSTEM_T,   0xffff},
  {CARRIER_AFAX_SETTING       , "carr_af_se" , &System.signal_state.carrier_state.afax_setting,       &System.signal_state_res.carrier_state.afax_setting,     sizeof(System.signal_state.carrier_state.afax_setting),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_AFAX_CFM_CONTR     , "carr_cfm"   , &System.signal_state.carrier_state.afax_cfm_contr,     &System.signal_state_res.carrier_state.afax_cfm_contr,   sizeof(System.signal_state.carrier_state.afax_cfm_contr),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST_NUM      , "carr_t_num" , &System.signal_state.carrier_state.pret_test_num,      &System.signal_state_res.carrier_state.pret_test_num,    sizeof(System.signal_state.carrier_state.pret_test_num),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_SUBTEST_N     , "carr_st_n"  , &System.signal_state.carrier_state.pret_subtest_num,   &System.signal_state_res.carrier_state.pret_subtest_num, sizeof(System.signal_state.carrier_state.pret_subtest_num),  UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TIME_DISP     , "carr_tim_d" , &System.signal_state.carrier_state.pret_time_disp,     &System.signal_state_res.carrier_state.pret_time_disp,   sizeof(System.signal_state.carrier_state.pret_time_disp),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_PRET_TYPE          , "carr_p_typ" , &System.signal_state.carrier_state.pret_type,          &System.signal_state_res.carrier_state.pret_type,        sizeof(System.signal_state.carrier_state.pret_type),         UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OVER_PRET_STAT     , "carr_p_sta" , &System.signal_state.carrier_state.over_pret_stat,     &System.signal_state_res.carrier_state.over_pret_stat,   sizeof(System.signal_state.carrier_state.over_pret_stat),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST1         , "carr_pt1"   , &System.signal_state.carrier_state.pret_test[0],       &System.signal_state_res.carrier_state.pret_test[0],     sizeof(System.signal_state.carrier_state.pret_test[0]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST2         , "carr_pt2"   , &System.signal_state.carrier_state.pret_test[1],       &System.signal_state_res.carrier_state.pret_test[1],     sizeof(System.signal_state.carrier_state.pret_test[1]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST3         , "carr_pt3"   , &System.signal_state.carrier_state.pret_test[2],       &System.signal_state_res.carrier_state.pret_test[2],     sizeof(System.signal_state.carrier_state.pret_test[2]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST4         , "carr_pt4"   , &System.signal_state.carrier_state.pret_test[3],       &System.signal_state_res.carrier_state.pret_test[3],     sizeof(System.signal_state.carrier_state.pret_test[3]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST5         , "carr_pt5"   , &System.signal_state.carrier_state.pret_test[4],       &System.signal_state_res.carrier_state.pret_test[4],     sizeof(System.signal_state.carrier_state.pret_test[4]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST6         , "carr_pt6"   , &System.signal_state.carrier_state.pret_test[5],       &System.signal_state_res.carrier_state.pret_test[5],     sizeof(System.signal_state.carrier_state.pret_test[5]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST7         , "carr_pt7"   , &System.signal_state.carrier_state.pret_test[6],       &System.signal_state_res.carrier_state.pret_test[6],     sizeof(System.signal_state.carrier_state.pret_test[6]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST8         , "carr_pt8"   , &System.signal_state.carrier_state.pret_test[7],       &System.signal_state_res.carrier_state.pret_test[7],     sizeof(System.signal_state.carrier_state.pret_test[7]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST9         , "carr_pt9"   , &System.signal_state.carrier_state.pret_test[8],       &System.signal_state_res.carrier_state.pret_test[8],     sizeof(System.signal_state.carrier_state.pret_test[8]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST10        , "carr_pt10"  , &System.signal_state.carrier_state.pret_test[9],       &System.signal_state_res.carrier_state.pret_test[9],     sizeof(System.signal_state.carrier_state.pret_test[9]),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST11        , "carr_pt11"  , &System.signal_state.carrier_state.pret_test[10],      &System.signal_state_res.carrier_state.pret_test[10],    sizeof(System.signal_state.carrier_state.pret_test[10]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST12        , "carr_pt12"  , &System.signal_state.carrier_state.pret_test[11],      &System.signal_state_res.carrier_state.pret_test[11],    sizeof(System.signal_state.carrier_state.pret_test[11]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST13        , "carr_pt13"  , &System.signal_state.carrier_state.pret_test[12],      &System.signal_state_res.carrier_state.pret_test[12],    sizeof(System.signal_state.carrier_state.pret_test[12]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST14        , "carr_pt14"  , &System.signal_state.carrier_state.pret_test[13],      &System.signal_state_res.carrier_state.pret_test[13],    sizeof(System.signal_state.carrier_state.pret_test[13]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST15        , "carr_pt15"  , &System.signal_state.carrier_state.pret_test[14],      &System.signal_state_res.carrier_state.pret_test[14],    sizeof(System.signal_state.carrier_state.pret_test[14]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST16        , "carr_pt16"  , &System.signal_state.carrier_state.pret_test[15],      &System.signal_state_res.carrier_state.pret_test[15],    sizeof(System.signal_state.carrier_state.pret_test[15]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST17        , "carr_pt17"  , &System.signal_state.carrier_state.pret_test[16],      &System.signal_state_res.carrier_state.pret_test[16],    sizeof(System.signal_state.carrier_state.pret_test[16]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST18        , "carr_pt18"  , &System.signal_state.carrier_state.pret_test[17],      &System.signal_state_res.carrier_state.pret_test[17],    sizeof(System.signal_state.carrier_state.pret_test[17]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST19        , "carr_pt19"  , &System.signal_state.carrier_state.pret_test[18],      &System.signal_state_res.carrier_state.pret_test[18],    sizeof(System.signal_state.carrier_state.pret_test[18]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST20        , "carr_pt20"  , &System.signal_state.carrier_state.pret_test[19],      &System.signal_state_res.carrier_state.pret_test[19],    sizeof(System.signal_state.carrier_state.pret_test[19]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST21        , "carr_pt21"  , &System.signal_state.carrier_state.pret_test[20],      &System.signal_state_res.carrier_state.pret_test[20],    sizeof(System.signal_state.carrier_state.pret_test[20]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST22        , "carr_pt22"  , &System.signal_state.carrier_state.pret_test[21],      &System.signal_state_res.carrier_state.pret_test[21],    sizeof(System.signal_state.carrier_state.pret_test[21]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST23        , "carr_pt23"  , &System.signal_state.carrier_state.pret_test[22],      &System.signal_state_res.carrier_state.pret_test[22],    sizeof(System.signal_state.carrier_state.pret_test[22]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST24        , "carr_pt24"  , &System.signal_state.carrier_state.pret_test[23],      &System.signal_state_res.carrier_state.pret_test[23],    sizeof(System.signal_state.carrier_state.pret_test[23]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_PRET_TEST25        , "carr_pt25"  , &System.signal_state.carrier_state.pret_test[24],      &System.signal_state_res.carrier_state.pret_test[24],    sizeof(System.signal_state.carrier_state.pret_test[24]),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_MODEL_NUM          , "carr_m_num" , &System.signal_state.carrier_state.model_num,          &System.signal_state_res.carrier_state.model_num,        sizeof(System.signal_state.carrier_state.model_num),         STRING_SYSTEM_T,  0xffff},
  {CARRIER_OPER_MODE          , "carr_op_m"  , &System.signal_state.carrier_state.oper_mode,          &System.signal_state_res.carrier_state.oper_mode,        sizeof(System.signal_state.carrier_state.oper_mode),         UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OPER_MODE_LOCK     , "carr_op_ml" , &System.signal_state.carrier_state.oper_mode_lock,     &System.signal_state_res.carrier_state.oper_mode_lock,   sizeof(System.signal_state.carrier_state.oper_mode_lock),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_C_PIEK_OV_STAT     , "carr_pi_ov" , &System.signal_state.carrier_state.c_piek_ov_stat,     &System.signal_state_res.carrier_state.c_piek_ov_stat,   sizeof(System.signal_state.carrier_state.c_piek_ov_stat),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_C_PIEK_M_STAT      , "carr_pi_m"  , &System.signal_state.carrier_state.c_piek_m_stat,      &System.signal_state_res.carrier_state.c_piek_m_stat,    sizeof(System.signal_state.carrier_state.c_piek_m_stat),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_SUCT_PRESS         , "carr_su_pr" , &System.signal_state.carrier_state.suct_press,         &System.signal_state_res.carrier_state.suct_press,       sizeof(System.signal_state.carrier_state.suct_press),        FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_DISCH_PRESS        , "carr_di_pr" , &System.signal_state.carrier_state.disch_press,        &System.signal_state_res.carrier_state.disch_press,      sizeof(System.signal_state.carrier_state.disch_press),       FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_DISCH_TEMP         , "carr_di_t"  , &System.signal_state.carrier_state.disch_temp,         &System.signal_state_res.carrier_state.disch_temp,       sizeof(System.signal_state.carrier_state.disch_temp),        FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_SMV_POS            , "carr_smv"   , &System.signal_state.carrier_state.smv_pos,            &System.signal_state_res.carrier_state.smv_pos,          sizeof(System.signal_state.carrier_state.smv_pos),           UINT8_SYSTEM_T,   0xffff},
  {CARRIER_EXP_VALVE_POS      , "carr_ex_p"  , &System.signal_state.carrier_state.exp_valve_pos,      &System.signal_state_res.carrier_state.exp_valve_pos,    sizeof(System.signal_state.carrier_state.exp_valve_pos),     UINT8_SYSTEM_T,   0xffff},
  {CARRIER_OUTL_TEMP          , "carr_out_t" , &System.signal_state.carrier_state.outl_temp,          &System.signal_state_res.carrier_state.outl_temp,        sizeof(System.signal_state.carrier_state.outl_temp),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_OUTL_PRESS         , "carr_out_p" , &System.signal_state.carrier_state.outl_press,         &System.signal_state_res.carrier_state.outl_press,       sizeof(System.signal_state.carrier_state.outl_press),        FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_DTT1               , "carr_dtt1"  , &System.signal_state.carrier_state.dtt1,               &System.signal_state_res.carrier_state.dtt1,             sizeof(System.signal_state.carrier_state.dtt2),              FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_DTT2               , "carr_dtt2"  , &System.signal_state.carrier_state.dtt2,               &System.signal_state_res.carrier_state.dtt2,             sizeof(System.signal_state.carrier_state.dtt2),              FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_COMP2_DTT          , "carr_c2_dt" , &System.signal_state.carrier_state.comp2_dtt,          &System.signal_state_res.carrier_state.comp2_dtt,        sizeof(System.signal_state.carrier_state.comp2_dtt),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_COMP3_DTT          , "carr_c3_dt" , &System.signal_state.carrier_state.comp3_dtt,          &System.signal_state_res.carrier_state.comp3_dtt,        sizeof(System.signal_state.carrier_state.comp3_dtt),         FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_BAT_CURR           , "carr_bat_c" , &System.signal_state.carrier_state.bat_curr,           &System.signal_state_res.carrier_state.bat_curr,         sizeof(System.signal_state.carrier_state.bat_curr),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_AC_CURR1           , "carr_ac_c1" , &System.signal_state.carrier_state.ac_curr1,           &System.signal_state_res.carrier_state.ac_curr1,         sizeof(System.signal_state.carrier_state.ac_curr1),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_AC_CURR2           , "carr_ac_c2" , &System.signal_state.carrier_state.ac_curr2,           &System.signal_state_res.carrier_state.ac_curr2,         sizeof(System.signal_state.carrier_state.ac_curr2),          FLOAT_SYSTEM_T,   0xffff},
  {CARRIER_MAP_SENS           , "carr_map"   , &System.signal_state.carrier_state.map_sens,           &System.signal_state_res.carrier_state.map_sens,         sizeof(System.signal_state.carrier_state.map_sens),          UINT16_SYSTEM_T,  0xffff},
  {CARRIER_LEN_A_ALARMS       , "carr_l_alr" , &System.signal_state.carrier_state.len_act_alarms,     &System.signal_state_res.carrier_state.len_act_alarms,   sizeof(System.signal_state.carrier_state.len_act_alarms),    UINT8_SYSTEM_T,   0xffff},
  {CARRIER_A_ALRM1            , "carr_a_a1"  , &System.signal_state.carrier_state.a_alarm_byte1,      &System.signal_state_res.carrier_state.a_alarm_byte1,    sizeof(System.signal_state.carrier_state.a_alarm_byte1),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM2            , "carr_a_a2"  , &System.signal_state.carrier_state.a_alarm_byte2,      &System.signal_state_res.carrier_state.a_alarm_byte2,    sizeof(System.signal_state.carrier_state.a_alarm_byte2),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM3            , "carr_a_a3"  , &System.signal_state.carrier_state.a_alarm_byte3,      &System.signal_state_res.carrier_state.a_alarm_byte3,    sizeof(System.signal_state.carrier_state.a_alarm_byte3),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM4            , "carr_a_a4"  , &System.signal_state.carrier_state.a_alarm_byte4,      &System.signal_state_res.carrier_state.a_alarm_byte4,    sizeof(System.signal_state.carrier_state.a_alarm_byte4),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM5            , "carr_a_a5"  , &System.signal_state.carrier_state.a_alarm_byte5,      &System.signal_state_res.carrier_state.a_alarm_byte5,    sizeof(System.signal_state.carrier_state.a_alarm_byte5),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM6            , "carr_a_a6"  , &System.signal_state.carrier_state.a_alarm_byte6,      &System.signal_state_res.carrier_state.a_alarm_byte6,    sizeof(System.signal_state.carrier_state.a_alarm_byte6),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM7            , "carr_a_a7"  , &System.signal_state.carrier_state.a_alarm_byte7,      &System.signal_state_res.carrier_state.a_alarm_byte7,    sizeof(System.signal_state.carrier_state.a_alarm_byte7),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM8            , "carr_a_a8"  , &System.signal_state.carrier_state.a_alarm_byte8,      &System.signal_state_res.carrier_state.a_alarm_byte8,    sizeof(System.signal_state.carrier_state.a_alarm_byte8),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM9            , "carr_a_a9"  , &System.signal_state.carrier_state.a_alarm_byte9,      &System.signal_state_res.carrier_state.a_alarm_byte9,    sizeof(System.signal_state.carrier_state.a_alarm_byte9),     UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM10           , "carr_a_a10" , &System.signal_state.carrier_state.a_alarm_byte10,     &System.signal_state_res.carrier_state.a_alarm_byte10,   sizeof(System.signal_state.carrier_state.a_alarm_byte10),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM11           , "carr_a_a11" , &System.signal_state.carrier_state.a_alarm_byte11,     &System.signal_state_res.carrier_state.a_alarm_byte11,   sizeof(System.signal_state.carrier_state.a_alarm_byte11),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM12           , "carr_a_a12" , &System.signal_state.carrier_state.a_alarm_byte12,     &System.signal_state_res.carrier_state.a_alarm_byte12,   sizeof(System.signal_state.carrier_state.a_alarm_byte12),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM13           , "carr_a_a13" , &System.signal_state.carrier_state.a_alarm_byte13,     &System.signal_state_res.carrier_state.a_alarm_byte13,   sizeof(System.signal_state.carrier_state.a_alarm_byte13),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM14           , "carr_a_a14" , &System.signal_state.carrier_state.a_alarm_byte14,     &System.signal_state_res.carrier_state.a_alarm_byte14,   sizeof(System.signal_state.carrier_state.a_alarm_byte14),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM15           , "carr_a_a15" , &System.signal_state.carrier_state.a_alarm_byte15,     &System.signal_state_res.carrier_state.a_alarm_byte15,   sizeof(System.signal_state.carrier_state.a_alarm_byte15),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_A_ALRM16           , "carr_a_a16" , &System.signal_state.carrier_state.a_alarm_byte16,     &System.signal_state_res.carrier_state.a_alarm_byte16,   sizeof(System.signal_state.carrier_state.a_alarm_byte16),    UINT16_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD1       , "carr_pc1"   , &System.signal_state.carrier_state.kohler_pcod1,       &System.signal_state_res.carrier_state.kohler_pcod1,     sizeof(System.signal_state.carrier_state.kohler_pcod1),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD2       , "carr_pc2"   , &System.signal_state.carrier_state.kohler_pcod2,       &System.signal_state_res.carrier_state.kohler_pcod2,     sizeof(System.signal_state.carrier_state.kohler_pcod2),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD3       , "carr_pc3"   , &System.signal_state.carrier_state.kohler_pcod3,       &System.signal_state_res.carrier_state.kohler_pcod3,     sizeof(System.signal_state.carrier_state.kohler_pcod3),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD4       , "carr_pc4"   , &System.signal_state.carrier_state.kohler_pcod4,       &System.signal_state_res.carrier_state.kohler_pcod4,     sizeof(System.signal_state.carrier_state.kohler_pcod4),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD5       , "carr_pc5"   , &System.signal_state.carrier_state.kohler_pcod5,       &System.signal_state_res.carrier_state.kohler_pcod5,     sizeof(System.signal_state.carrier_state.kohler_pcod5),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD6       , "carr_pc6"   , &System.signal_state.carrier_state.kohler_pcod6,       &System.signal_state_res.carrier_state.kohler_pcod6,     sizeof(System.signal_state.carrier_state.kohler_pcod6),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD7       , "carr_pc7"   , &System.signal_state.carrier_state.kohler_pcod7,       &System.signal_state_res.carrier_state.kohler_pcod7,     sizeof(System.signal_state.carrier_state.kohler_pcod7),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD8       , "carr_pc8"   , &System.signal_state.carrier_state.kohler_pcod8,       &System.signal_state_res.carrier_state.kohler_pcod8,     sizeof(System.signal_state.carrier_state.kohler_pcod8),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD9       , "carr_pc9"   , &System.signal_state.carrier_state.kohler_pcod9,       &System.signal_state_res.carrier_state.kohler_pcod9,     sizeof(System.signal_state.carrier_state.kohler_pcod9),      STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD10      , "carr_pc10"  , &System.signal_state.carrier_state.kohler_pcod10,      &System.signal_state_res.carrier_state.kohler_pcod10,    sizeof(System.signal_state.carrier_state.kohler_pcod10),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD11      , "carr_pc11"  , &System.signal_state.carrier_state.kohler_pcod11,      &System.signal_state_res.carrier_state.kohler_pcod11,    sizeof(System.signal_state.carrier_state.kohler_pcod11),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD12      , "carr_pc12"  , &System.signal_state.carrier_state.kohler_pcod12,      &System.signal_state_res.carrier_state.kohler_pcod12,    sizeof(System.signal_state.carrier_state.kohler_pcod12),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD13      , "carr_pc13"  , &System.signal_state.carrier_state.kohler_pcod13,      &System.signal_state_res.carrier_state.kohler_pcod13,    sizeof(System.signal_state.carrier_state.kohler_pcod13),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD14      , "carr_pc14"  , &System.signal_state.carrier_state.kohler_pcod14,      &System.signal_state_res.carrier_state.kohler_pcod14,    sizeof(System.signal_state.carrier_state.kohler_pcod14),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD15      , "carr_pc15"  , &System.signal_state.carrier_state.kohler_pcod15,      &System.signal_state_res.carrier_state.kohler_pcod15,    sizeof(System.signal_state.carrier_state.kohler_pcod15),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_KOHLER_PCOD16      , "carr_pc16"  , &System.signal_state.carrier_state.kohler_pcod16,      &System.signal_state_res.carrier_state.kohler_pcod16,    sizeof(System.signal_state.carrier_state.kohler_pcod16),     STRING_SYSTEM_T,  0xffff},
  {CARRIER_TYPE_MP            , "carr_t_mp"  , &System.signal_state.carrier_state.type_mp,            &System.signal_state_res.carrier_state.type_mp,          sizeof(System.signal_state.carrier_state.type_mp),           UINT8_SYSTEM_T,   0xffff},
  {CARRIER_FUEL_LEVEL_AN      , "carr_f_l_a" , &System.signal_state.carrier_state.fuel_level_a,       &System.signal_state_res.carrier_state.fuel_level_a,     sizeof(System.signal_state.carrier_state.fuel_level_a),      UINT8_SYSTEM_T,   0xffff},
  {CARRIER_COMMAND            , "carr_comm"  , &System.signal_state.carrier_state.command,            &System.signal_state_res.carrier_state.command,          sizeof(System.signal_state.carrier_state.command),            ARRAY_SYSTEM_T,   0xffff},
  {CARRIER_COMMAND_ANS        , "carr_comm_а", &System.signal_state.carrier_state.command_ans,        &System.signal_state_res.carrier_state.command_ans,      sizeof(System.signal_state.carrier_state.command),            ARRAY_SYSTEM_T,   0xffff},
#endif // (CARRIER_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT) || defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 0)
  {CUSTOM_CAN_SENSOR_FIRST_ID+0, "p2800", &System.custom_can_sensor[0], &System.custom_can_sensor_res[0], sizeof(System.custom_can_sensor[0]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 1)
  {CUSTOM_CAN_SENSOR_FIRST_ID+1, "p2801", &System.custom_can_sensor[1], &System.custom_can_sensor_res[1], sizeof(System.custom_can_sensor[1]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 2)
  {CUSTOM_CAN_SENSOR_FIRST_ID+2, "p2802", &System.custom_can_sensor[2], &System.custom_can_sensor_res[2], sizeof(System.custom_can_sensor[2]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 3)
  {CUSTOM_CAN_SENSOR_FIRST_ID+3, "p2803", &System.custom_can_sensor[3], &System.custom_can_sensor_res[3], sizeof(System.custom_can_sensor[3]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 4)
  {CUSTOM_CAN_SENSOR_FIRST_ID+4, "p2804", &System.custom_can_sensor[4], &System.custom_can_sensor_res[4], sizeof(System.custom_can_sensor[4]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 5)
  {CUSTOM_CAN_SENSOR_FIRST_ID+5, "p2805", &System.custom_can_sensor[5], &System.custom_can_sensor_res[5], sizeof(System.custom_can_sensor[5]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 6)
  {CUSTOM_CAN_SENSOR_FIRST_ID+6, "p2806", &System.custom_can_sensor[6], &System.custom_can_sensor_res[6], sizeof(System.custom_can_sensor[6]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 7)
  {CUSTOM_CAN_SENSOR_FIRST_ID+7, "p2807", &System.custom_can_sensor[7], &System.custom_can_sensor_res[7], sizeof(System.custom_can_sensor[7]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 8)
  {CUSTOM_CAN_SENSOR_FIRST_ID+8, "p2808", &System.custom_can_sensor[8], &System.custom_can_sensor_res[8], sizeof(System.custom_can_sensor[8]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 9)
  {CUSTOM_CAN_SENSOR_FIRST_ID+9, "p2809", &System.custom_can_sensor[9], &System.custom_can_sensor_res[9], sizeof(System.custom_can_sensor[9]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 10)
  {CUSTOM_CAN_SENSOR_FIRST_ID+10, "p2810", &System.custom_can_sensor[10], &System.custom_can_sensor_res[10], sizeof(System.custom_can_sensor[10]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 11)
  {CUSTOM_CAN_SENSOR_FIRST_ID+11, "p2811", &System.custom_can_sensor[11], &System.custom_can_sensor_res[11], sizeof(System.custom_can_sensor[11]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 12)
  {CUSTOM_CAN_SENSOR_FIRST_ID+12, "p2812", &System.custom_can_sensor[12], &System.custom_can_sensor_res[12], sizeof(System.custom_can_sensor[12]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 13)
  {CUSTOM_CAN_SENSOR_FIRST_ID+13, "p2813", &System.custom_can_sensor[13], &System.custom_can_sensor_res[13], sizeof(System.custom_can_sensor[13]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 14)
  {CUSTOM_CAN_SENSOR_FIRST_ID+14, "p2814", &System.custom_can_sensor[14], &System.custom_can_sensor_res[14], sizeof(System.custom_can_sensor[14]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 15)
  {CUSTOM_CAN_SENSOR_FIRST_ID+15, "p2815", &System.custom_can_sensor[15], &System.custom_can_sensor_res[15], sizeof(System.custom_can_sensor[15]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 16)
  {CUSTOM_CAN_SENSOR_FIRST_ID+16, "p2816", &System.custom_can_sensor[16], &System.custom_can_sensor_res[16], sizeof(System.custom_can_sensor[16]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 17)
  {CUSTOM_CAN_SENSOR_FIRST_ID+17, "p2817", &System.custom_can_sensor[17], &System.custom_can_sensor_res[17], sizeof(System.custom_can_sensor[17]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 18)
  {CUSTOM_CAN_SENSOR_FIRST_ID+18, "p2818", &System.custom_can_sensor[18], &System.custom_can_sensor_res[18], sizeof(System.custom_can_sensor[18]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 19)
  {CUSTOM_CAN_SENSOR_FIRST_ID+19, "p2819", &System.custom_can_sensor[19], &System.custom_can_sensor_res[19], sizeof(System.custom_can_sensor[19]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 20)
  {CUSTOM_CAN_SENSOR_FIRST_ID+20, "p2820", &System.custom_can_sensor[20], &System.custom_can_sensor_res[20], sizeof(System.custom_can_sensor[20]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 21)
  {CUSTOM_CAN_SENSOR_FIRST_ID+21, "p2821", &System.custom_can_sensor[21], &System.custom_can_sensor_res[21], sizeof(System.custom_can_sensor[21]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 22)
  {CUSTOM_CAN_SENSOR_FIRST_ID+22, "p2822", &System.custom_can_sensor[22], &System.custom_can_sensor_res[22], sizeof(System.custom_can_sensor[22]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 23)
  {CUSTOM_CAN_SENSOR_FIRST_ID+23, "p2823", &System.custom_can_sensor[23], &System.custom_can_sensor_res[23], sizeof(System.custom_can_sensor[23]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 24)
  {CUSTOM_CAN_SENSOR_FIRST_ID+24, "p2824", &System.custom_can_sensor[24], &System.custom_can_sensor_res[24], sizeof(System.custom_can_sensor[24]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 25)
  {CUSTOM_CAN_SENSOR_FIRST_ID+25, "p2825", &System.custom_can_sensor[25], &System.custom_can_sensor_res[25], sizeof(System.custom_can_sensor[25]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 26)
  {CUSTOM_CAN_SENSOR_FIRST_ID+26, "p2826", &System.custom_can_sensor[26], &System.custom_can_sensor_res[26], sizeof(System.custom_can_sensor[26]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 27)
  {CUSTOM_CAN_SENSOR_FIRST_ID+27, "p2827", &System.custom_can_sensor[27], &System.custom_can_sensor_res[27], sizeof(System.custom_can_sensor[27]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 28)
  {CUSTOM_CAN_SENSOR_FIRST_ID+28, "p2828", &System.custom_can_sensor[28], &System.custom_can_sensor_res[28], sizeof(System.custom_can_sensor[28]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 29)
  {CUSTOM_CAN_SENSOR_FIRST_ID+29, "p2829", &System.custom_can_sensor[29], &System.custom_can_sensor_res[29], sizeof(System.custom_can_sensor[29]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 30)
  {CUSTOM_CAN_SENSOR_FIRST_ID+30, "p2830", &System.custom_can_sensor[30], &System.custom_can_sensor_res[30], sizeof(System.custom_can_sensor[30]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 31)
  {CUSTOM_CAN_SENSOR_FIRST_ID+31, "p2831", &System.custom_can_sensor[31], &System.custom_can_sensor_res[31], sizeof(System.custom_can_sensor[31]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 32)
  {CUSTOM_CAN_SENSOR_FIRST_ID+32, "p2832", &System.custom_can_sensor[32], &System.custom_can_sensor_res[32], sizeof(System.custom_can_sensor[32]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 33)
  {CUSTOM_CAN_SENSOR_FIRST_ID+33, "p2833", &System.custom_can_sensor[33], &System.custom_can_sensor_res[33], sizeof(System.custom_can_sensor[33]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 34)
  {CUSTOM_CAN_SENSOR_FIRST_ID+34, "p2834", &System.custom_can_sensor[34], &System.custom_can_sensor_res[34], sizeof(System.custom_can_sensor[34]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 35)
  {CUSTOM_CAN_SENSOR_FIRST_ID+35, "p2835", &System.custom_can_sensor[35], &System.custom_can_sensor_res[35], sizeof(System.custom_can_sensor[35]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 36)
  {CUSTOM_CAN_SENSOR_FIRST_ID+36, "p2836", &System.custom_can_sensor[36], &System.custom_can_sensor_res[36], sizeof(System.custom_can_sensor[36]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 37)
  {CUSTOM_CAN_SENSOR_FIRST_ID+37, "p2837", &System.custom_can_sensor[37], &System.custom_can_sensor_res[37], sizeof(System.custom_can_sensor[37]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 38)
  {CUSTOM_CAN_SENSOR_FIRST_ID+38, "p2838", &System.custom_can_sensor[38], &System.custom_can_sensor_res[38], sizeof(System.custom_can_sensor[38]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 39)
  {CUSTOM_CAN_SENSOR_FIRST_ID+39, "p2839", &System.custom_can_sensor[39], &System.custom_can_sensor_res[39], sizeof(System.custom_can_sensor[39]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 40)
  {CUSTOM_CAN_SENSOR_FIRST_ID+40, "p2840", &System.custom_can_sensor[40], &System.custom_can_sensor_res[40], sizeof(System.custom_can_sensor[40]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 41)
  {CUSTOM_CAN_SENSOR_FIRST_ID+41, "p2841", &System.custom_can_sensor[41], &System.custom_can_sensor_res[41], sizeof(System.custom_can_sensor[41]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 42)
  {CUSTOM_CAN_SENSOR_FIRST_ID+42, "p2842", &System.custom_can_sensor[42], &System.custom_can_sensor_res[42], sizeof(System.custom_can_sensor[42]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 43)
  {CUSTOM_CAN_SENSOR_FIRST_ID+43, "p2843", &System.custom_can_sensor[43], &System.custom_can_sensor_res[43], sizeof(System.custom_can_sensor[43]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 44)
  {CUSTOM_CAN_SENSOR_FIRST_ID+44, "p2844", &System.custom_can_sensor[44], &System.custom_can_sensor_res[44], sizeof(System.custom_can_sensor[44]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 45)
  {CUSTOM_CAN_SENSOR_FIRST_ID+45, "p2845", &System.custom_can_sensor[45], &System.custom_can_sensor_res[45], sizeof(System.custom_can_sensor[45]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 46)
  {CUSTOM_CAN_SENSOR_FIRST_ID+46, "p2846", &System.custom_can_sensor[46], &System.custom_can_sensor_res[46], sizeof(System.custom_can_sensor[46]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 47)
  {CUSTOM_CAN_SENSOR_FIRST_ID+47, "p2847", &System.custom_can_sensor[47], &System.custom_can_sensor_res[47], sizeof(System.custom_can_sensor[47]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 48)
  {CUSTOM_CAN_SENSOR_FIRST_ID+48, "p2848", &System.custom_can_sensor[48], &System.custom_can_sensor_res[48], sizeof(System.custom_can_sensor[48]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 49)
  {CUSTOM_CAN_SENSOR_FIRST_ID+49, "p2849", &System.custom_can_sensor[49], &System.custom_can_sensor_res[49], sizeof(System.custom_can_sensor[49]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 50)
  {CUSTOM_CAN_SENSOR_FIRST_ID+50, "p2850", &System.custom_can_sensor[50], &System.custom_can_sensor_res[50], sizeof(System.custom_can_sensor[50]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 51)
  {CUSTOM_CAN_SENSOR_FIRST_ID+51, "p2851", &System.custom_can_sensor[51], &System.custom_can_sensor_res[51], sizeof(System.custom_can_sensor[51]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 52)
  {CUSTOM_CAN_SENSOR_FIRST_ID+52, "p2852", &System.custom_can_sensor[52], &System.custom_can_sensor_res[52], sizeof(System.custom_can_sensor[52]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 53)
  {CUSTOM_CAN_SENSOR_FIRST_ID+53, "p2853", &System.custom_can_sensor[53], &System.custom_can_sensor_res[53], sizeof(System.custom_can_sensor[53]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 54)
  {CUSTOM_CAN_SENSOR_FIRST_ID+54, "p2854", &System.custom_can_sensor[54], &System.custom_can_sensor_res[54], sizeof(System.custom_can_sensor[54]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 55)
  {CUSTOM_CAN_SENSOR_FIRST_ID+55, "p2855", &System.custom_can_sensor[55], &System.custom_can_sensor_res[55], sizeof(System.custom_can_sensor[55]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 56)
  {CUSTOM_CAN_SENSOR_FIRST_ID+56, "p2856", &System.custom_can_sensor[56], &System.custom_can_sensor_res[56], sizeof(System.custom_can_sensor[56]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 57)
  {CUSTOM_CAN_SENSOR_FIRST_ID+57, "p2857", &System.custom_can_sensor[57], &System.custom_can_sensor_res[57], sizeof(System.custom_can_sensor[57]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 58)
  {CUSTOM_CAN_SENSOR_FIRST_ID+58, "p2858", &System.custom_can_sensor[58], &System.custom_can_sensor_res[58], sizeof(System.custom_can_sensor[58]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 59)
  {CUSTOM_CAN_SENSOR_FIRST_ID+59, "p2859", &System.custom_can_sensor[59], &System.custom_can_sensor_res[59], sizeof(System.custom_can_sensor[59]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 60)
  {CUSTOM_CAN_SENSOR_FIRST_ID+60, "p2860", &System.custom_can_sensor[60], &System.custom_can_sensor_res[60], sizeof(System.custom_can_sensor[60]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 61)
  {CUSTOM_CAN_SENSOR_FIRST_ID+61, "p2861", &System.custom_can_sensor[61], &System.custom_can_sensor_res[61], sizeof(System.custom_can_sensor[61]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 62)
  {CUSTOM_CAN_SENSOR_FIRST_ID+62, "p2862", &System.custom_can_sensor[62], &System.custom_can_sensor_res[62], sizeof(System.custom_can_sensor[62]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 63)
  {CUSTOM_CAN_SENSOR_FIRST_ID+63, "p2863", &System.custom_can_sensor[63], &System.custom_can_sensor_res[63], sizeof(System.custom_can_sensor[63]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 64)
  {CUSTOM_CAN_SENSOR_FIRST_ID+64, "p2864", &System.custom_can_sensor[64], &System.custom_can_sensor_res[64], sizeof(System.custom_can_sensor[64]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 65)
  {CUSTOM_CAN_SENSOR_FIRST_ID+65, "p2865", &System.custom_can_sensor[65], &System.custom_can_sensor_res[65], sizeof(System.custom_can_sensor[65]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 66)
  {CUSTOM_CAN_SENSOR_FIRST_ID+66, "p2866", &System.custom_can_sensor[66], &System.custom_can_sensor_res[66], sizeof(System.custom_can_sensor[66]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 67)
  {CUSTOM_CAN_SENSOR_FIRST_ID+67, "p2867", &System.custom_can_sensor[67], &System.custom_can_sensor_res[67], sizeof(System.custom_can_sensor[67]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 68)
  {CUSTOM_CAN_SENSOR_FIRST_ID+68, "p2868", &System.custom_can_sensor[68], &System.custom_can_sensor_res[68], sizeof(System.custom_can_sensor[68]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 69)
  {CUSTOM_CAN_SENSOR_FIRST_ID+69, "p2869", &System.custom_can_sensor[69], &System.custom_can_sensor_res[69], sizeof(System.custom_can_sensor[69]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 70)
  {CUSTOM_CAN_SENSOR_FIRST_ID+70, "p2870", &System.custom_can_sensor[70], &System.custom_can_sensor_res[70], sizeof(System.custom_can_sensor[70]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 71)
  {CUSTOM_CAN_SENSOR_FIRST_ID+71, "p2871", &System.custom_can_sensor[71], &System.custom_can_sensor_res[71], sizeof(System.custom_can_sensor[71]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 72)
  {CUSTOM_CAN_SENSOR_FIRST_ID+72, "p2872", &System.custom_can_sensor[72], &System.custom_can_sensor_res[72], sizeof(System.custom_can_sensor[72]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 73)
  {CUSTOM_CAN_SENSOR_FIRST_ID+73, "p2873", &System.custom_can_sensor[73], &System.custom_can_sensor_res[73], sizeof(System.custom_can_sensor[73]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 74)
  {CUSTOM_CAN_SENSOR_FIRST_ID+74, "p2874", &System.custom_can_sensor[74], &System.custom_can_sensor_res[74], sizeof(System.custom_can_sensor[74]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 75)
  {CUSTOM_CAN_SENSOR_FIRST_ID+75, "p2875", &System.custom_can_sensor[75], &System.custom_can_sensor_res[75], sizeof(System.custom_can_sensor[75]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 76)
  {CUSTOM_CAN_SENSOR_FIRST_ID+76, "p2876", &System.custom_can_sensor[76], &System.custom_can_sensor_res[76], sizeof(System.custom_can_sensor[76]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 77)
  {CUSTOM_CAN_SENSOR_FIRST_ID+77, "p2877", &System.custom_can_sensor[77], &System.custom_can_sensor_res[77], sizeof(System.custom_can_sensor[77]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 78)
  {CUSTOM_CAN_SENSOR_FIRST_ID+78, "p2878", &System.custom_can_sensor[78], &System.custom_can_sensor_res[78], sizeof(System.custom_can_sensor[78]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 79)
  {CUSTOM_CAN_SENSOR_FIRST_ID+79, "p2879", &System.custom_can_sensor[79], &System.custom_can_sensor_res[79], sizeof(System.custom_can_sensor[79]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 80)
  {CUSTOM_CAN_SENSOR_FIRST_ID+80, "p2880", &System.custom_can_sensor[80], &System.custom_can_sensor_res[80], sizeof(System.custom_can_sensor[80]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 81)
  {CUSTOM_CAN_SENSOR_FIRST_ID+81, "p2881", &System.custom_can_sensor[81], &System.custom_can_sensor_res[81], sizeof(System.custom_can_sensor[81]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 82)
  {CUSTOM_CAN_SENSOR_FIRST_ID+82, "p2882", &System.custom_can_sensor[82], &System.custom_can_sensor_res[82], sizeof(System.custom_can_sensor[82]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 83)
  {CUSTOM_CAN_SENSOR_FIRST_ID+83, "p2883", &System.custom_can_sensor[83], &System.custom_can_sensor_res[83], sizeof(System.custom_can_sensor[83]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 84)
  {CUSTOM_CAN_SENSOR_FIRST_ID+84, "p2884", &System.custom_can_sensor[84], &System.custom_can_sensor_res[84], sizeof(System.custom_can_sensor[84]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 85)
  {CUSTOM_CAN_SENSOR_FIRST_ID+85, "p2885", &System.custom_can_sensor[85], &System.custom_can_sensor_res[85], sizeof(System.custom_can_sensor[85]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 86)
  {CUSTOM_CAN_SENSOR_FIRST_ID+86, "p2886", &System.custom_can_sensor[86], &System.custom_can_sensor_res[86], sizeof(System.custom_can_sensor[86]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 87)
  {CUSTOM_CAN_SENSOR_FIRST_ID+87, "p2887", &System.custom_can_sensor[87], &System.custom_can_sensor_res[87], sizeof(System.custom_can_sensor[87]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 88)
  {CUSTOM_CAN_SENSOR_FIRST_ID+88, "p2888", &System.custom_can_sensor[88], &System.custom_can_sensor_res[88], sizeof(System.custom_can_sensor[88]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 89)
  {CUSTOM_CAN_SENSOR_FIRST_ID+89, "p2889", &System.custom_can_sensor[89], &System.custom_can_sensor_res[89], sizeof(System.custom_can_sensor[89]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 90)
  {CUSTOM_CAN_SENSOR_FIRST_ID+90, "p2890", &System.custom_can_sensor[90], &System.custom_can_sensor_res[90], sizeof(System.custom_can_sensor[90]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 91)
  {CUSTOM_CAN_SENSOR_FIRST_ID+91, "p2891", &System.custom_can_sensor[91], &System.custom_can_sensor_res[91], sizeof(System.custom_can_sensor[91]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 92)
  {CUSTOM_CAN_SENSOR_FIRST_ID+92, "p2892", &System.custom_can_sensor[92], &System.custom_can_sensor_res[92], sizeof(System.custom_can_sensor[92]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 93)
  {CUSTOM_CAN_SENSOR_FIRST_ID+93, "p2893", &System.custom_can_sensor[93], &System.custom_can_sensor_res[93], sizeof(System.custom_can_sensor[93]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 94)
  {CUSTOM_CAN_SENSOR_FIRST_ID+94, "p2894", &System.custom_can_sensor[94], &System.custom_can_sensor_res[94], sizeof(System.custom_can_sensor[94]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 95)
  {CUSTOM_CAN_SENSOR_FIRST_ID+95, "p2895", &System.custom_can_sensor[95], &System.custom_can_sensor_res[95], sizeof(System.custom_can_sensor[95]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 96)
  {CUSTOM_CAN_SENSOR_FIRST_ID+96, "p2896", &System.custom_can_sensor[96], &System.custom_can_sensor_res[96], sizeof(System.custom_can_sensor[96]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 97)
  {CUSTOM_CAN_SENSOR_FIRST_ID+97, "p2897", &System.custom_can_sensor[97], &System.custom_can_sensor_res[97], sizeof(System.custom_can_sensor[97]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 98)
  {CUSTOM_CAN_SENSOR_FIRST_ID+98, "p2898", &System.custom_can_sensor[98], &System.custom_can_sensor_res[98], sizeof(System.custom_can_sensor[98]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 99)
  {CUSTOM_CAN_SENSOR_FIRST_ID+99, "p2899", &System.custom_can_sensor[99], &System.custom_can_sensor_res[99], sizeof(System.custom_can_sensor[99]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 100)
  {CUSTOM_CAN_SENSOR_FIRST_ID+100, "p2900", &System.custom_can_sensor[100], &System.custom_can_sensor_res[100], sizeof(System.custom_can_sensor[100]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 101)
  {CUSTOM_CAN_SENSOR_FIRST_ID+101, "p2901", &System.custom_can_sensor[101], &System.custom_can_sensor_res[101], sizeof(System.custom_can_sensor[101]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 102)
  {CUSTOM_CAN_SENSOR_FIRST_ID+102, "p2902", &System.custom_can_sensor[102], &System.custom_can_sensor_res[102], sizeof(System.custom_can_sensor[102]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 103)
  {CUSTOM_CAN_SENSOR_FIRST_ID+103, "p2903", &System.custom_can_sensor[103], &System.custom_can_sensor_res[103], sizeof(System.custom_can_sensor[103]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 104)
  {CUSTOM_CAN_SENSOR_FIRST_ID+104, "p2904", &System.custom_can_sensor[104], &System.custom_can_sensor_res[104], sizeof(System.custom_can_sensor[104]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 105)
  {CUSTOM_CAN_SENSOR_FIRST_ID+105, "p2905", &System.custom_can_sensor[105], &System.custom_can_sensor_res[105], sizeof(System.custom_can_sensor[105]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 106)
  {CUSTOM_CAN_SENSOR_FIRST_ID+106, "p2906", &System.custom_can_sensor[106], &System.custom_can_sensor_res[106], sizeof(System.custom_can_sensor[106]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 107)
  {CUSTOM_CAN_SENSOR_FIRST_ID+107, "p2907", &System.custom_can_sensor[107], &System.custom_can_sensor_res[107], sizeof(System.custom_can_sensor[107]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 108)
  {CUSTOM_CAN_SENSOR_FIRST_ID+108, "p2908", &System.custom_can_sensor[108], &System.custom_can_sensor_res[108], sizeof(System.custom_can_sensor[108]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 109)
  {CUSTOM_CAN_SENSOR_FIRST_ID+109, "p2909", &System.custom_can_sensor[109], &System.custom_can_sensor_res[109], sizeof(System.custom_can_sensor[109]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 110)
  {CUSTOM_CAN_SENSOR_FIRST_ID+110, "p2910", &System.custom_can_sensor[110], &System.custom_can_sensor_res[110], sizeof(System.custom_can_sensor[110]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 111)
  {CUSTOM_CAN_SENSOR_FIRST_ID+111, "p2911", &System.custom_can_sensor[111], &System.custom_can_sensor_res[111], sizeof(System.custom_can_sensor[111]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 112)
  {CUSTOM_CAN_SENSOR_FIRST_ID+112, "p2912", &System.custom_can_sensor[112], &System.custom_can_sensor_res[112], sizeof(System.custom_can_sensor[112]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 113)
  {CUSTOM_CAN_SENSOR_FIRST_ID+113, "p2913", &System.custom_can_sensor[113], &System.custom_can_sensor_res[113], sizeof(System.custom_can_sensor[113]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 114)
  {CUSTOM_CAN_SENSOR_FIRST_ID+114, "p2914", &System.custom_can_sensor[114], &System.custom_can_sensor_res[114], sizeof(System.custom_can_sensor[114]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 115)
  {CUSTOM_CAN_SENSOR_FIRST_ID+115, "p2915", &System.custom_can_sensor[115], &System.custom_can_sensor_res[115], sizeof(System.custom_can_sensor[115]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 116)
  {CUSTOM_CAN_SENSOR_FIRST_ID+116, "p2916", &System.custom_can_sensor[116], &System.custom_can_sensor_res[116], sizeof(System.custom_can_sensor[116]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 117)
  {CUSTOM_CAN_SENSOR_FIRST_ID+117, "p2917", &System.custom_can_sensor[117], &System.custom_can_sensor_res[117], sizeof(System.custom_can_sensor[117]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 118)
  {CUSTOM_CAN_SENSOR_FIRST_ID+118, "p2918", &System.custom_can_sensor[118], &System.custom_can_sensor_res[118], sizeof(System.custom_can_sensor[118]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 119)
  {CUSTOM_CAN_SENSOR_FIRST_ID+119, "p2919", &System.custom_can_sensor[119], &System.custom_can_sensor_res[119], sizeof(System.custom_can_sensor[119]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 120)
  {CUSTOM_CAN_SENSOR_FIRST_ID+120, "p2920", &System.custom_can_sensor[120], &System.custom_can_sensor_res[120], sizeof(System.custom_can_sensor[120]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 121)
  {CUSTOM_CAN_SENSOR_FIRST_ID+121, "p2921", &System.custom_can_sensor[121], &System.custom_can_sensor_res[121], sizeof(System.custom_can_sensor[121]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 122)
  {CUSTOM_CAN_SENSOR_FIRST_ID+122, "p2922", &System.custom_can_sensor[122], &System.custom_can_sensor_res[122], sizeof(System.custom_can_sensor[122]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 123)
  {CUSTOM_CAN_SENSOR_FIRST_ID+123, "p2923", &System.custom_can_sensor[123], &System.custom_can_sensor_res[123], sizeof(System.custom_can_sensor[123]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 124)
  {CUSTOM_CAN_SENSOR_FIRST_ID+124, "p2924", &System.custom_can_sensor[124], &System.custom_can_sensor_res[124], sizeof(System.custom_can_sensor[124]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 125)
  {CUSTOM_CAN_SENSOR_FIRST_ID+125, "p2925", &System.custom_can_sensor[125], &System.custom_can_sensor_res[125], sizeof(System.custom_can_sensor[125]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 126)
  {CUSTOM_CAN_SENSOR_FIRST_ID+126, "p2926", &System.custom_can_sensor[126], &System.custom_can_sensor_res[126], sizeof(System.custom_can_sensor[126]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 127)
  {CUSTOM_CAN_SENSOR_FIRST_ID+127, "p2927", &System.custom_can_sensor[127], &System.custom_can_sensor_res[127], sizeof(System.custom_can_sensor[127]), UNITED_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_SENSORS_COUNT > 128)
#error Нужно добавить сюда custom_can_sensor
#endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT) || defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
#if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 0)
  {CUSTOM_CAN_STR_SENSOR_FIRST_ID+0, "p2975", &System.custom_can_str_sensor[0], &System.custom_can_str_sensor_res[0], sizeof(System.custom_can_str_sensor[0]), STRING_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 1)
  {CUSTOM_CAN_STR_SENSOR_FIRST_ID+1, "p2976", &System.custom_can_str_sensor[1], &System.custom_can_str_sensor_res[1], sizeof(System.custom_can_str_sensor[1]), STRING_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 2)
  {CUSTOM_CAN_STR_SENSOR_FIRST_ID+2, "p2977", &System.custom_can_str_sensor[2], &System.custom_can_str_sensor_res[2], sizeof(System.custom_can_str_sensor[2]), STRING_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 3)
  {CUSTOM_CAN_STR_SENSOR_FIRST_ID+3, "p2978", &System.custom_can_str_sensor[3], &System.custom_can_str_sensor_res[3], sizeof(System.custom_can_str_sensor[3]), STRING_SYSTEM_T, 0xffff},
#endif
#if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 4)
#error Нужно добавить сюда custom_can_str_sensor
#endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
  {CAN_CUSTOM_SENSOR_BAD_CRC_BF, "p2985", System.canCustomSensors_bad_crc_bf, System.canCustomSensors_bad_crc_bf, sizeof(System.canCustomSensors_bad_crc_bf), ARRAY_SYSTEM_T, 0xffff},
  {ISOTP_CAN_CUSTOM_SENSOR_BAD_CRC_BF, "p2986", System.IsoTpcanCustomSensors_bad_crc_bf, System.IsoTpcanCustomSensors_bad_crc_bf, sizeof(System.IsoTpcanCustomSensors_bad_crc_bf), ARRAY_SYSTEM_T, 0xffff},
  {CAN_CUSTOM_SENSOR_SETTINGS_KEY_HASH, "p2987", System.can_sensor_setting_key_hash, System.can_sensor_setting_key_hash, sizeof(System.can_sensor_setting_key_hash), ARRAY_SYSTEM_T, 0xffff},
#ifdef __ICCARM__
  {ISOTP_CAN_SENSOR_SETTINGS_VERS, "p2988", (void*)&can_isotp_sensors_setting_version, (void*)&can_isotp_sensors_setting_version, sizeof(can_isotp_sensors_setting_version), UINT8_SYSTEM_T, 0xffff},
#else
  {ISOTP_CAN_SENSOR_SETTINGS_VERS, "p2988", (void*)&System.can_isotp_sensors_setting_version, (void*)&System.can_isotp_sensors_setting_version, sizeof(System.can_isotp_sensors_setting_version), UINT8_SYSTEM_T, 0xffff},
#endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(VEGA_CAN_PRESENT)
#if (MAX_CAN_INTERFACES > 0)
  {CAN1_HW_STATE + 0, "can1hw", &System.can_hw_state[0], &System.can_hw_state[0], sizeof(System.can_hw_state[0]), ARRAY_SYSTEM_T, 0xffff},
#endif
#if (MAX_CAN_INTERFACES > 1)
  {CAN1_HW_STATE + 1, "can2hw", &System.can_hw_state[1], &System.can_hw_state[1], sizeof(System.can_hw_state[1]), ARRAY_SYSTEM_T, 0xffff},
#endif
#if (MAX_CAN_INTERFACES > 2)
  {CAN1_HW_STATE + 2, "can3hw", &System.can_hw_state[2], &System.can_hw_state[2], sizeof(System.can_hw_state[2]), ARRAY_SYSTEM_T, 0xffff},
#endif
#if (MAX_CAN_INTERFACES > 3)
  {CAN1_HW_STATE + 3, "can4hw", &System.can_hw_state[3], &System.can_hw_state[3], sizeof(System.can_hw_state[3]), ARRAY_SYSTEM_T, 0xffff},
#endif
#if (MAX_CAN_INTERFACES > 4)
#error
#endif
#endif //defined(VEGA_CAN_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
#ifdef __ICCARM__
  {CUSTOM_CAN_SENSOR_SETTINGS_VERS, "p2993", (void*)&can_custom_sensors_setting_version, (void*)&can_custom_sensors_setting_version, sizeof(can_custom_sensors_setting_version), UINT8_SYSTEM_T, 0xffff},
#else
  {CUSTOM_CAN_SENSOR_SETTINGS_VERS, "p2993", (void*)&System.can_custom_sensors_setting_version, (void*)&System.can_custom_sensors_setting_version, sizeof(System.can_custom_sensors_setting_version), UINT8_SYSTEM_T, 0xffff},
#endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CANPRO_PRESENT)
  {CAN_SPECIAL_FLAGS_BITFIELD     , "can_spec_bf"     ,  &System.can_state.spec_flags,       &System.can_state_res.spec_flags,       sizeof(System.can_state.spec_flags),        UINT32_SYSTEM_T, 0xffff},
  {CAN_SECURITY_NAVIS_BITFIELD    , "can_sec_nvsbf"    , &System.can_state.sec_navis_flags,  &System.can_state_res.sec_navis_flags,  sizeof(System.can_state.sec_navis_flags),   UINT32_SYSTEM_T, 0xffff},
  {CAN_CONTROL_NAVIS_BITFIELD     , "can_cont_nvsbf"   , &System.can_state.cont_navis_flags, &System.can_state_res.cont_navis_flags, sizeof(System.can_state.cont_navis_flags),  UINT32_SYSTEM_T, 0xffff},
  {CAN_AGRO_NAVIS_BITFIELD        , "can_agrb_nvsbf"   , &System.can_state.agr_navis_flags,  &System.can_state_res.agr_navis_flags,  sizeof(System.can_state.agr_navis_flags),   UINT64_SYSTEM_T, 0xffff},

  {CAN_SYS_INF              , "can_boot_inf"   , &System.can_state.sys_inf.boot_inf, &System.can_state_res.sys_inf.boot_inf, sizeof(System.can_state.sys_inf.boot_inf), ARRAY_SYSTEM_T, 0xffff},
  {CAN_UPD_PCT              , "can_upd_pct"    , &System.can_state.fw_update_pct, &System.can_state_res.fw_update_pct, sizeof(System.can_state.fw_update_pct), FLOAT_SYSTEM_T, 185},
#endif //CANPRO_PRESENT

#if defined(MDAS9_PRESENT)
  {MDAS9_COOMUNICATION_STATE  , "mdas9_ok"   , &System.signal_state.is_mdas9_ok,                      &System.signal_state_res.is_mdas9_ok,                    sizeof(System.signal_state.is_mdas9_ok),                     UINT8_SYSTEM_T,   0xffff},
  {MDAS9_SPEED                , "mdas9_spd"  , &System.signal_state.mdas9_state.speed,                &System.signal_state_res.mdas9_state.speed,              sizeof(System.signal_state.mdas9_state.speed),               UINT8_SYSTEM_T,   0xffff},
  {MDAS9_LEFT_TURN_SIGNAL     , "mdas9_lt"   , &System.signal_state.mdas9_state.left_turn,            &System.signal_state_res.mdas9_state.left_turn,          sizeof(System.signal_state.mdas9_state.left_turn),           UINT8_SYSTEM_T,   0xffff},
  {MDAS9_RIGHT_TURN_SIGNAL    , "mdas9_rt"   , &System.signal_state.mdas9_state.right_turn,           &System.signal_state_res.mdas9_state.right_turn,         sizeof(System.signal_state.mdas9_state.right_turn),          UINT8_SYSTEM_T,   0xffff},
  {MDAS9_BRAKE_SIGNAL         , "mdas9_brk"  , &System.signal_state.mdas9_state.brake,                &System.signal_state_res.mdas9_state.brake,              sizeof(System.signal_state.mdas9_state.brake),               UINT8_SYSTEM_T,   0xffff},
  {MDAS9_RPM                  , "mdas9_rpm"  , &System.signal_state.mdas9_state.rpm,                  &System.signal_state_res.mdas9_state.rpm,                sizeof(System.signal_state.mdas9_state.rpm),                 UINT16_SYSTEM_T,  0xffff},
  {MDAS9_LDW_LEFT             , "mdas9_ldw_l", &System.signal_state.mdas9_state.ldw_left,             &System.signal_state_res.mdas9_state.ldw_left,           sizeof(System.signal_state.mdas9_state.ldw_left),            UINT8_SYSTEM_T,   0xffff},
  {MDAS9_LDW_RIGHT            , "mdas9_ldw_r", &System.signal_state.mdas9_state.ldw_right,            &System.signal_state_res.mdas9_state.ldw_right,          sizeof(System.signal_state.mdas9_state.ldw_right),           UINT8_SYSTEM_T,   0xffff},
  {MDAS9_LEFT_DISTANCE        , "mdas9_l_d"  , &System.signal_state.mdas9_state.left_dist,            &System.signal_state_res.mdas9_state.left_dist,          sizeof(System.signal_state.mdas9_state.left_dist),           UINT16_SYSTEM_T,  0xffff},
  {MDAS9_RIGHT_DISTANCE       , "mdas9_r_d"  , &System.signal_state.mdas9_state.right_dist,           &System.signal_state_res.mdas9_state.right_dist,         sizeof(System.signal_state.mdas9_state.right_dist),          UINT16_SYSTEM_T,  0xffff},
  {MDAS9_TTC                  , "mdas9_ttc"  , &System.signal_state.mdas9_state.ttc,                  &System.signal_state_res.mdas9_state.ttc,                sizeof(System.signal_state.mdas9_state.ttc),                 UINT8_SYSTEM_T,   0xffff},
  {MDAS9_SDA                  , "mdas9_sda"  , &System.signal_state.mdas9_state.sda,                  &System.signal_state_res.mdas9_state.sda,                sizeof(System.signal_state.mdas9_state.sda),                 UINT8_SYSTEM_T,   0xffff},
  {MDAS9_FVSA                 , "mdas9_fvsa" , &System.signal_state.mdas9_state.fvsa,                 &System.signal_state_res.mdas9_state.fvsa,               sizeof(System.signal_state.mdas9_state.fvsa),                UINT8_SYSTEM_T,   0xffff},
  {MDAS9_FPW                  , "mdas9_fpw"  , &System.signal_state.mdas9_state.fpw,                  &System.signal_state_res.mdas9_state.fpw,                sizeof(System.signal_state.mdas9_state.fpw),                 UINT8_SYSTEM_T,   0xffff},
  {MDAS9_FCW                  , "mdas9_fcw"  , &System.signal_state.mdas9_state.fcw,                  &System.signal_state_res.mdas9_state.fcw,                sizeof(System.signal_state.mdas9_state.fcw),                 UINT8_SYSTEM_T,   0xffff},
  {MDAS9_PCW                  , "mdas9_pcw"  , &System.signal_state.mdas9_state.pcw,                  &System.signal_state_res.mdas9_state.pcw,                sizeof(System.signal_state.mdas9_state.pcw),                 UINT8_SYSTEM_T,   0xffff},
  {MDAS9_RECORD               , "mdas9_rec"  , &System.signal_state.mdas9_state.record,               &System.signal_state_res.mdas9_state.record,             sizeof(System.signal_state.mdas9_state.record),              UINT8_SYSTEM_T,   0xffff},
  {MDAS9_ERROR                , "mdas9_err"  , &System.signal_state.mdas9_state.error_code,           &System.signal_state_res.mdas9_state.error_code,         sizeof(System.signal_state.mdas9_state.error_code),          UINT8_SYSTEM_T,   0xffff},
  {MDAS9_AHEAD_DISTANSE       , "mdas9_a_d"  , &System.signal_state.mdas9_state.ahead_dist,           &System.signal_state_res.mdas9_state.ahead_dist,         sizeof(System.signal_state.mdas9_state.ahead_dist),          UINT16_SYSTEM_T,  0xffff},
  {MDAS9_AHEAD_SPEED          , "mdas9_a_s"  , &System.signal_state.mdas9_state.ahead_speed,          &System.signal_state_res.mdas9_state.ahead_speed,        sizeof(System.signal_state.mdas9_state.ahead_speed),         UINT16_SYSTEM_T,  0xffff},
  {MDAS9_SLR_STATE            , "mdas9_slr_s", &System.signal_state.mdas9_state.slr_state,            &System.signal_state_res.mdas9_state.slr_state,          sizeof(System.signal_state.mdas9_state.slr_state),           UINT8_SYSTEM_T,   0xffff},
  {MDAS9_SLR_RECOGNIZE        , "mdas9_slr_r", &System.signal_state.mdas9_state.slr_recog,            &System.signal_state_res.mdas9_state.slr_recog,          sizeof(System.signal_state.mdas9_state.slr_recog),           UINT8_SYSTEM_T,   0xffff},
  {MDAS9_SLR_SENSITIVITY      , "mdas9_sl_sn", &System.signal_state.mdas9_state.slr_sensit,           &System.signal_state_res.mdas9_state.slr_sensit,         sizeof(System.signal_state.mdas9_state.slr_sensit),          UINT8_SYSTEM_T,   0xffff},
#endif // (MDAS9_PRESENT)

#if defined(MDSM7_PRESENT)
  {MDSM7_COOMUNICATION_STATE  , "mdsm7_ok"   , &System.signal_state.is_mdsm7_ok,                      &System.signal_state_res.is_mdsm7_ok,                    sizeof(System.signal_state.is_mdsm7_ok),                     UINT8_SYSTEM_T,   0xffff},
  {MDSM7_SPEED                , "mdsm7_spd"  , &System.signal_state.mdsm7_state.speed,                &System.signal_state_res.mdsm7_state.speed,              sizeof(System.signal_state.mdsm7_state.speed),               UINT8_SYSTEM_T,   0xffff},
  {MDSM7_DUMMY_CARINFO        , "mdsm7_dummy", &System.signal_state.mdsm7_state.car_info,             &System.signal_state_res.mdsm7_state.car_info,           sizeof(System.signal_state.mdsm7_state.car_info),            STRING_SYSTEM_T,  0xffff},
  {MDSM7_DSM_EVENT            , "mdsm7_event", &System.signal_state.mdsm7_state.event,                &System.signal_state_res.mdsm7_state.event,              sizeof(System.signal_state.mdsm7_state.event),               UINT8_SYSTEM_T,   0xffff},
  {MDSM7_DRIVER_NAME          , "mdsm7_dname", &System.signal_state.mdsm7_state.driver_name,          &System.signal_state_res.mdsm7_state.driver_name,        sizeof(System.signal_state.mdsm7_state.driver_name),         STRING_SYSTEM_T,  0xffff},
  {MDSM7_RECORD_STATUS        , "mdsm7_rec_s", &System.signal_state.mdsm7_state.record_status,        &System.signal_state_res.mdsm7_state.record_status,      sizeof(System.signal_state.mdsm7_state.record_status),       UINT8_SYSTEM_T,   0xffff},
  {MDSM7_GPS_STATUS           , "mdsm7_gps_s", &System.signal_state.mdsm7_state.gps_status,           &System.signal_state_res.mdsm7_state.gps_status,         sizeof(System.signal_state.mdsm7_state.gps_status),          UINT8_SYSTEM_T,   0xffff},
  {MDSM7_LATITUDE             , "mdsm7_lat"  , &System.signal_state.mdsm7_state.latitude,             &System.signal_state_res.mdsm7_state.latitude,           sizeof(System.signal_state.mdsm7_state.latitude),            UINT32_SYSTEM_T,  0xffff},
  {MDSM7_LONGITUDE            , "mdsm7_lon"  , &System.signal_state.mdsm7_state.longitude,            &System.signal_state_res.mdsm7_state.longitude,          sizeof(System.signal_state.mdsm7_state.longitude),           UINT32_SYSTEM_T,  0xffff},
  {MDSM7_ERROR_CODE           , "mdsm7_err"  , &System.signal_state.mdsm7_state.error_code,           &System.signal_state_res.mdsm7_state.error_code,         sizeof(System.signal_state.mdsm7_state.error_code),          UINT8_SYSTEM_T,   0xffff},
  {MDSM7_YEAR                 , "mdsm7_y"    , &System.signal_state.mdsm7_state.year,                 &System.signal_state_res.mdsm7_state.year,               sizeof(System.signal_state.mdsm7_state.year),                UINT16_SYSTEM_T,  0xffff},
  {MDSM7_MON                  , "mdsm7_mon"  , &System.signal_state.mdsm7_state.mon,                  &System.signal_state_res.mdsm7_state.mon,                sizeof(System.signal_state.mdsm7_state.mon),                 UINT8_SYSTEM_T,   0xffff},
  {MDSM7_DAY                  , "mdsm7_d"    , &System.signal_state.mdsm7_state.day,                  &System.signal_state_res.mdsm7_state.day,                sizeof(System.signal_state.mdsm7_state.day),                 UINT8_SYSTEM_T,   0xffff},
  {MDSM7_HOUR                 , "mdsm7_h"    , &System.signal_state.mdsm7_state.hour,                 &System.signal_state_res.mdsm7_state.hour,               sizeof(System.signal_state.mdsm7_state.hour),                UINT8_SYSTEM_T,   0xffff},
  {MDSM7_MIN                  , "mdsm7_min"  , &System.signal_state.mdsm7_state.min,                  &System.signal_state_res.mdsm7_state.min,                sizeof(System.signal_state.mdsm7_state.min),                 UINT8_SYSTEM_T,   0xffff},
  {MDSM7_SEC                  , "mdsm7_s"    , &System.signal_state.mdsm7_state.sec,                  &System.signal_state_res.mdsm7_state.sec,                sizeof(System.signal_state.mdsm7_state.sec),                 UINT8_SYSTEM_T,   0xffff},
  {MDSM7_G_SENSOR             , "mdsm7_g_sns", &System.signal_state.mdsm7_state.g_sensor,             &System.signal_state_res.mdsm7_state.g_sensor,           sizeof(System.signal_state.mdsm7_state.g_sensor),            UINT8_SYSTEM_T,   0xffff},
#endif // (MDSM7_PRESENT)

#if defined(HUM_SENSOR_IAKM_PRESENT)
  {IAKM_COOMUNICATION_STATE   , "iakm_ok"   ,  &System.signal_state.is_hum_iakm_ok,                   &System.signal_state_res.is_hum_iakm_ok,                  sizeof(System.signal_state.is_hum_iakm_ok),                  UINT8_SYSTEM_T,   0xffff},
  {IAKM_TEMP_SENS             , "iakm_temp",   &System.signal_state.hum_iakm_state.temp_sensor,       &System.signal_state_res.hum_iakm_state.temp_sensor,      sizeof(System.signal_state.hum_iakm_state.temp_sensor),      FLOAT_SYSTEM_T,   0xffff},
  {IAKM_TEMP_ERROR            , "iakm_t_err",  &System.signal_state.hum_iakm_state.temp_error_sensor, &System.signal_state_res.hum_iakm_state.temp_error_sensor,sizeof(System.signal_state.hum_iakm_state.temp_error_sensor),UINT8_SYSTEM_T,   0xffff},
  {IAKM_HUM_SENS              , "iakm_hum",    &System.signal_state.hum_iakm_state.hum_sensor,        &System.signal_state_res.hum_iakm_state.hum_sensor,       sizeof(System.signal_state.hum_iakm_state.hum_sensor),       FLOAT_SYSTEM_T,   0xffff},
  {IAKM_HUM_ERROR             , "iakm_h_err",  &System.signal_state.hum_iakm_state.hum_error_sensor,  &System.signal_state_res.hum_iakm_state.hum_error_sensor, sizeof(System.signal_state.hum_iakm_state.hum_error_sensor), UINT8_SYSTEM_T,   0xffff},
#endif //(HUM_SENSOR_IAKM_PRESENT)

#if defined(SCD30_PRESENT)
  {SCD30_COOMUNICATION_STATE   , "scd30_ok"   ,  &System.signal_state.is_scd30_ok,                   &System.signal_state_res.is_scd30_ok,                      sizeof(System.signal_state.is_scd30_ok),                     UINT8_SYSTEM_T,   0xffff},
  {SCD30_TEMP_SENS             , "scd30_temp",   &System.signal_state.scd30_state.temp_sensor,       &System.signal_state_res.scd30_state.temp_sensor,          sizeof(System.signal_state.scd30_state.temp_sensor),         FLOAT_SYSTEM_T,   0xffff},
  {SCD30_HUM_SENS              , "scd30_hum",    &System.signal_state.scd30_state.hum_sensor,        &System.signal_state_res.scd30_state.hum_sensor,           sizeof(System.signal_state.scd30_state.hum_sensor),          FLOAT_SYSTEM_T,   0xffff},
  {SCD30_CO2_SENS              , "scd30_co2",    &System.signal_state.scd30_state.co2_sensor,        &System.signal_state_res.scd30_state.co2_sensor,           sizeof(System.signal_state.scd30_state.co2_sensor),          FLOAT_SYSTEM_T,   0xffff},
#endif //(SCD30_PRESENT)

#if defined(CANLOG_V4_PRESENT)
//вторая часть датчиков CANLOG_V4
#if defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_AGRICULTURAL_FL_D11 , "p7000", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[11], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[11], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[11]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D12 , "p7001", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[12], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[12], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[12]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D13 , "p7002", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[13], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[13], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[13]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D14 , "p7003", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[14], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[14], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[14]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D15 , "p7004", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[15], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[15], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[15]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D16 , "p7005", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[16], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[16], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[16]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D17 , "p7006", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[17], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[17], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[17]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D18 , "p7007", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[18], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[18], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[18]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D19 , "p7008", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[19], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[19], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[19]), UINT8_SYSTEM_T, 0xffff},
  {CAN_V4_AGRICULTURAL_FL_D20 , "p7009", &System.can_v4_state.agricultural_vehicles_flags.bytes.data[20], &System.can_v4_state_res.agricultural_vehicles_flags.bytes.data[20], sizeof(System.can_v4_state.agricultural_vehicles_flags.bytes.data[20]), UINT8_SYSTEM_T, 0xffff},
#endif //defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
#endif //defined(CANLOG_V4_PRESENT)

#if defined(BLE_SENSORS_PRESENT)

#if (MAX_BLE_SENSORS_COUNT > 0)
  {BLE_SENSOR1_VISIBLE,  __SNAME("p8000"), __SPTR(&System.ble_sensor_data[0].visible),         &System.ble_sensor_data_res[0].visible,         sizeof(System.ble_sensor_data[0].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR1_TIMER,    __SNAME("p8001"), __SPTR(&System.ble_sensor_data[0].timer),           &System.ble_sensor_data_res[0].timer,           sizeof(System.ble_sensor_data[0].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR1_RSSI,     __SNAME("p8002"), __SPTR(&System.ble_sensor_data[0].rssi),            &System.ble_sensor_data_res[0].rssi,            sizeof(System.ble_sensor_data[0].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR1_BATT,     __SNAME("p8003"), __SPTR(&System.ble_sensor_data[0].batt_lev),        &System.ble_sensor_data_res[0].batt_lev,        sizeof(System.ble_sensor_data[0].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR1_U8,       __SNAME("p8004"), __SPTR(&System.ble_sensor_data[0].u8_data),         &System.ble_sensor_data_res[0].u8_data,         sizeof(System.ble_sensor_data[0].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR1_I16_1,    __SNAME("p8005"), __SPTR(&System.ble_sensor_data[0].i16_data_1),      &System.ble_sensor_data_res[0].i16_data_1,      sizeof(System.ble_sensor_data[0].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR1_I16_2,    __SNAME("p8006"), __SPTR(&System.ble_sensor_data[0].i16_data_2),      &System.ble_sensor_data_res[0].i16_data_2,      sizeof(System.ble_sensor_data[0].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR1_U16_1,    __SNAME("p8007"), __SPTR(&System.ble_sensor_data[0].u16_data_1),      &System.ble_sensor_data_res[0].u16_data_1,      sizeof(System.ble_sensor_data[0].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR1_U16_2,    __SNAME("p8008"), __SPTR(&System.ble_sensor_data[0].u16_data_2),      &System.ble_sensor_data_res[0].u16_data_2,      sizeof(System.ble_sensor_data[0].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 1)
  {BLE_SENSOR2_VISIBLE,  __SNAME("p8013"), __SPTR(&System.ble_sensor_data[1].visible),         &System.ble_sensor_data_res[1].visible,         sizeof(System.ble_sensor_data[1].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR2_TIMER,    __SNAME("p8014"), __SPTR(&System.ble_sensor_data[1].timer),           &System.ble_sensor_data_res[1].timer,           sizeof(System.ble_sensor_data[1].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR2_RSSI,     __SNAME("p8015"), __SPTR(&System.ble_sensor_data[1].rssi),            &System.ble_sensor_data_res[1].rssi,            sizeof(System.ble_sensor_data[1].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR2_BATT,     __SNAME("p8016"), __SPTR(&System.ble_sensor_data[1].batt_lev),        &System.ble_sensor_data_res[1].batt_lev,        sizeof(System.ble_sensor_data[1].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR2_U8,       __SNAME("p8017"), __SPTR(&System.ble_sensor_data[1].u8_data),         &System.ble_sensor_data_res[1].u8_data,         sizeof(System.ble_sensor_data[1].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR2_I16_1,    __SNAME("p8018"), __SPTR(&System.ble_sensor_data[1].i16_data_1),      &System.ble_sensor_data_res[1].i16_data_1,      sizeof(System.ble_sensor_data[1].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR2_I16_2,    __SNAME("p8019"), __SPTR(&System.ble_sensor_data[1].i16_data_2),      &System.ble_sensor_data_res[1].i16_data_2,      sizeof(System.ble_sensor_data[1].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR2_U16_1,    __SNAME("p8020"), __SPTR(&System.ble_sensor_data[1].u16_data_1),      &System.ble_sensor_data_res[1].u16_data_1,      sizeof(System.ble_sensor_data[1].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR2_U16_2,    __SNAME("p8021"), __SPTR(&System.ble_sensor_data[1].u16_data_2),      &System.ble_sensor_data_res[1].u16_data_2,      sizeof(System.ble_sensor_data[1].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 2)
  {BLE_SENSOR3_VISIBLE,  __SNAME("p8026"), __SPTR(&System.ble_sensor_data[2].visible),         &System.ble_sensor_data_res[2].visible,         sizeof(System.ble_sensor_data[2].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR3_TIMER,    __SNAME("p8027"), __SPTR(&System.ble_sensor_data[2].timer),           &System.ble_sensor_data_res[2].timer,           sizeof(System.ble_sensor_data[2].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR3_RSSI,     __SNAME("p8028"), __SPTR(&System.ble_sensor_data[2].rssi),            &System.ble_sensor_data_res[2].rssi,            sizeof(System.ble_sensor_data[2].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR3_BATT,     __SNAME("p8029"), __SPTR(&System.ble_sensor_data[2].batt_lev),        &System.ble_sensor_data_res[2].batt_lev,        sizeof(System.ble_sensor_data[2].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR3_U8,       __SNAME("p8030"), __SPTR(&System.ble_sensor_data[2].u8_data),         &System.ble_sensor_data_res[2].u8_data,         sizeof(System.ble_sensor_data[2].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR3_I16_1,    __SNAME("p8031"), __SPTR(&System.ble_sensor_data[2].i16_data_1),      &System.ble_sensor_data_res[2].i16_data_1,      sizeof(System.ble_sensor_data[2].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR3_I16_2,    __SNAME("p8032"), __SPTR(&System.ble_sensor_data[2].i16_data_2),      &System.ble_sensor_data_res[2].i16_data_2,      sizeof(System.ble_sensor_data[2].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR3_U16_1,    __SNAME("p8033"), __SPTR(&System.ble_sensor_data[2].u16_data_1),      &System.ble_sensor_data_res[2].u16_data_1,      sizeof(System.ble_sensor_data[2].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR3_U16_2,    __SNAME("p8034"), __SPTR(&System.ble_sensor_data[2].u16_data_2),      &System.ble_sensor_data_res[2].u16_data_2,      sizeof(System.ble_sensor_data[2].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 3)
  {BLE_SENSOR4_VISIBLE,  __SNAME("p8039"), __SPTR(&System.ble_sensor_data[3].visible),         &System.ble_sensor_data_res[3].visible,         sizeof(System.ble_sensor_data[3].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR4_TIMER,    __SNAME("p8040"), __SPTR(&System.ble_sensor_data[3].timer),           &System.ble_sensor_data_res[3].timer,           sizeof(System.ble_sensor_data[3].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR4_RSSI,     __SNAME("p8041"), __SPTR(&System.ble_sensor_data[3].rssi),            &System.ble_sensor_data_res[3].rssi,            sizeof(System.ble_sensor_data[3].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR4_BATT,     __SNAME("p8042"), __SPTR(&System.ble_sensor_data[3].batt_lev),        &System.ble_sensor_data_res[3].batt_lev,        sizeof(System.ble_sensor_data[3].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR4_U8,       __SNAME("p8043"), __SPTR(&System.ble_sensor_data[3].u8_data),         &System.ble_sensor_data_res[3].u8_data,         sizeof(System.ble_sensor_data[3].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR4_I16_1,    __SNAME("p8044"), __SPTR(&System.ble_sensor_data[3].i16_data_1),      &System.ble_sensor_data_res[3].i16_data_1,      sizeof(System.ble_sensor_data[3].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR4_I16_2,    __SNAME("p8045"), __SPTR(&System.ble_sensor_data[3].i16_data_2),      &System.ble_sensor_data_res[3].i16_data_2,      sizeof(System.ble_sensor_data[3].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR4_U16_1,    __SNAME("p8046"), __SPTR(&System.ble_sensor_data[3].u16_data_1),      &System.ble_sensor_data_res[3].u16_data_1,      sizeof(System.ble_sensor_data[3].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR4_U16_2,    __SNAME("p8047"), __SPTR(&System.ble_sensor_data[3].u16_data_2),      &System.ble_sensor_data_res[3].u16_data_2,      sizeof(System.ble_sensor_data[3].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 4)
  {BLE_SENSOR5_VISIBLE,  __SNAME("p8052"), __SPTR(&System.ble_sensor_data[4].visible),         &System.ble_sensor_data_res[4].visible,         sizeof(System.ble_sensor_data[4].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR5_TIMER,    __SNAME("p8053"), __SPTR(&System.ble_sensor_data[4].timer),           &System.ble_sensor_data_res[4].timer,           sizeof(System.ble_sensor_data[4].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR5_RSSI,     __SNAME("p8054"), __SPTR(&System.ble_sensor_data[4].rssi),            &System.ble_sensor_data_res[4].rssi,            sizeof(System.ble_sensor_data[4].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR5_BATT,     __SNAME("p8055"), __SPTR(&System.ble_sensor_data[4].batt_lev),        &System.ble_sensor_data_res[4].batt_lev,        sizeof(System.ble_sensor_data[4].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR5_U8,       __SNAME("p8056"), __SPTR(&System.ble_sensor_data[4].u8_data),         &System.ble_sensor_data_res[4].u8_data,         sizeof(System.ble_sensor_data[4].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR5_I16_1,    __SNAME("p8057"), __SPTR(&System.ble_sensor_data[4].i16_data_1),      &System.ble_sensor_data_res[4].i16_data_1,      sizeof(System.ble_sensor_data[4].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR5_I16_2,    __SNAME("p8058"), __SPTR(&System.ble_sensor_data[4].i16_data_2),      &System.ble_sensor_data_res[4].i16_data_2,      sizeof(System.ble_sensor_data[4].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR5_U16_1,    __SNAME("p8059"), __SPTR(&System.ble_sensor_data[4].u16_data_1),      &System.ble_sensor_data_res[4].u16_data_1,      sizeof(System.ble_sensor_data[4].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR5_U16_2,    __SNAME("p8060"), __SPTR(&System.ble_sensor_data[4].u16_data_2),      &System.ble_sensor_data_res[4].u16_data_2,      sizeof(System.ble_sensor_data[4].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 5)
  {BLE_SENSOR6_VISIBLE,  __SNAME("p8065"), __SPTR(&System.ble_sensor_data[5].visible),         &System.ble_sensor_data_res[5].visible,         sizeof(System.ble_sensor_data[5].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR6_TIMER,    __SNAME("p8066"), __SPTR(&System.ble_sensor_data[5].timer),           &System.ble_sensor_data_res[5].timer,           sizeof(System.ble_sensor_data[5].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR6_RSSI,     __SNAME("p8067"), __SPTR(&System.ble_sensor_data[5].rssi),            &System.ble_sensor_data_res[5].rssi,            sizeof(System.ble_sensor_data[5].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR6_BATT,     __SNAME("p8068"), __SPTR(&System.ble_sensor_data[5].batt_lev),        &System.ble_sensor_data_res[5].batt_lev,        sizeof(System.ble_sensor_data[5].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR6_U8,       __SNAME("p8069"), __SPTR(&System.ble_sensor_data[5].u8_data),         &System.ble_sensor_data_res[5].u8_data,         sizeof(System.ble_sensor_data[5].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR6_I16_1,    __SNAME("p8070"), __SPTR(&System.ble_sensor_data[5].i16_data_1),      &System.ble_sensor_data_res[5].i16_data_1,      sizeof(System.ble_sensor_data[5].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR6_I16_2,    __SNAME("p8071"), __SPTR(&System.ble_sensor_data[5].i16_data_2),      &System.ble_sensor_data_res[5].i16_data_2,      sizeof(System.ble_sensor_data[5].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR6_U16_1,    __SNAME("p8072"), __SPTR(&System.ble_sensor_data[5].u16_data_1),      &System.ble_sensor_data_res[5].u16_data_1,      sizeof(System.ble_sensor_data[5].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR6_U16_2,    __SNAME("p8073"), __SPTR(&System.ble_sensor_data[5].u16_data_2),      &System.ble_sensor_data_res[5].u16_data_2,      sizeof(System.ble_sensor_data[5].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 6)
  {BLE_SENSOR7_VISIBLE,  __SNAME("p8078"), __SPTR(&System.ble_sensor_data[6].visible),         &System.ble_sensor_data_res[6].visible,         sizeof(System.ble_sensor_data[6].visible),         UINT64_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_TIMER,    __SNAME("p8079"), __SPTR(&System.ble_sensor_data[6].timer),           &System.ble_sensor_data_res[6].timer,           sizeof(System.ble_sensor_data[6].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_RSSI,     __SNAME("p8080"), __SPTR(&System.ble_sensor_data[6].rssi),            &System.ble_sensor_data_res[6].rssi,            sizeof(System.ble_sensor_data[6].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR7_BATT,     __SNAME("p8081"), __SPTR(&System.ble_sensor_data[6].batt_lev),        &System.ble_sensor_data_res[6].batt_lev,        sizeof(System.ble_sensor_data[6].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_U8,       __SNAME("p8082"), __SPTR(&System.ble_sensor_data[6].u8_data),         &System.ble_sensor_data_res[6].u8_data,         sizeof(System.ble_sensor_data[6].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_I16_1,    __SNAME("p8083"), __SPTR(&System.ble_sensor_data[6].i16_data_1),      &System.ble_sensor_data_res[6].i16_data_1,      sizeof(System.ble_sensor_data[6].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_I16_2,    __SNAME("p8084"), __SPTR(&System.ble_sensor_data[6].i16_data_2),      &System.ble_sensor_data_res[6].i16_data_2,      sizeof(System.ble_sensor_data[6].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR7_U16_1,    __SNAME("p8085"), __SPTR(&System.ble_sensor_data[6].u16_data_1),      &System.ble_sensor_data_res[6].u16_data_1,      sizeof(System.ble_sensor_data[6].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR7_U16_2,    __SNAME("p8086"), __SPTR(&System.ble_sensor_data[6].u16_data_2),      &System.ble_sensor_data_res[6].u16_data_2,      sizeof(System.ble_sensor_data[6].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 7)
  {BLE_SENSOR8_VISIBLE,  __SNAME("p8091"), __SPTR(&System.ble_sensor_data[7].visible),         &System.ble_sensor_data_res[7].visible,         sizeof(System.ble_sensor_data[7].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR8_TIMER,    __SNAME("p8092"), __SPTR(&System.ble_sensor_data[7].timer),           &System.ble_sensor_data_res[7].timer,           sizeof(System.ble_sensor_data[7].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR8_RSSI,     __SNAME("p8093"), __SPTR(&System.ble_sensor_data[7].rssi),            &System.ble_sensor_data_res[7].rssi,            sizeof(System.ble_sensor_data[7].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR8_BATT,     __SNAME("p8094"), __SPTR(&System.ble_sensor_data[7].batt_lev),        &System.ble_sensor_data_res[7].batt_lev,        sizeof(System.ble_sensor_data[7].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR8_U8,       __SNAME("p8095"), __SPTR(&System.ble_sensor_data[7].u8_data),         &System.ble_sensor_data_res[7].u8_data,         sizeof(System.ble_sensor_data[7].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR8_I16_1,    __SNAME("p8096"), __SPTR(&System.ble_sensor_data[7].i16_data_1),      &System.ble_sensor_data_res[7].i16_data_1,      sizeof(System.ble_sensor_data[7].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR8_I16_2,    __SNAME("p8097"), __SPTR(&System.ble_sensor_data[7].i16_data_2),      &System.ble_sensor_data_res[7].i16_data_2,      sizeof(System.ble_sensor_data[7].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR8_U16_1,    __SNAME("p8098"), __SPTR(&System.ble_sensor_data[7].u16_data_1),      &System.ble_sensor_data_res[7].u16_data_1,      sizeof(System.ble_sensor_data[7].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR8_U16_2,    __SNAME("p8099"), __SPTR(&System.ble_sensor_data[7].u16_data_2),      &System.ble_sensor_data_res[7].u16_data_2,      sizeof(System.ble_sensor_data[7].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 8)
  {BLE_SENSOR9_VISIBLE,  __SNAME("p8104"), __SPTR(&System.ble_sensor_data[8].visible),         &System.ble_sensor_data_res[8].visible,         sizeof(System.ble_sensor_data[8].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR9_TIMER,    __SNAME("p8105"), __SPTR(&System.ble_sensor_data[8].timer),           &System.ble_sensor_data_res[8].timer,           sizeof(System.ble_sensor_data[8].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR9_RSSI,     __SNAME("p8106"), __SPTR(&System.ble_sensor_data[8].rssi),            &System.ble_sensor_data_res[8].rssi,            sizeof(System.ble_sensor_data[8].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR9_BATT,     __SNAME("p8107"), __SPTR(&System.ble_sensor_data[8].batt_lev),        &System.ble_sensor_data_res[8].batt_lev,        sizeof(System.ble_sensor_data[8].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR9_U8,       __SNAME("p8108"), __SPTR(&System.ble_sensor_data[8].u8_data),         &System.ble_sensor_data_res[8].u8_data,         sizeof(System.ble_sensor_data[8].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR9_I16_1,    __SNAME("p8109"), __SPTR(&System.ble_sensor_data[8].i16_data_1),      &System.ble_sensor_data_res[8].i16_data_1,      sizeof(System.ble_sensor_data[8].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR9_I16_2,    __SNAME("p8110"), __SPTR(&System.ble_sensor_data[8].i16_data_2),      &System.ble_sensor_data_res[8].i16_data_2,      sizeof(System.ble_sensor_data[8].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR9_U16_1,    __SNAME("p8111"), __SPTR(&System.ble_sensor_data[8].u16_data_1),      &System.ble_sensor_data_res[8].u16_data_1,      sizeof(System.ble_sensor_data[8].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR9_U16_2,    __SNAME("p8112"), __SPTR(&System.ble_sensor_data[8].u16_data_2),      &System.ble_sensor_data_res[8].u16_data_2,      sizeof(System.ble_sensor_data[8].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 9)
  {BLE_SENSOR10_VISIBLE, __SNAME("p8117"), __SPTR(&System.ble_sensor_data[9].visible),         &System.ble_sensor_data_res[9].visible,         sizeof(System.ble_sensor_data[9].visible),         UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR10_TIMER,   __SNAME("p8118"), __SPTR(&System.ble_sensor_data[9].timer),           &System.ble_sensor_data_res[9].timer,           sizeof(System.ble_sensor_data[9].timer),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR10_RSSI,    __SNAME("p8119"), __SPTR(&System.ble_sensor_data[9].rssi),            &System.ble_sensor_data_res[9].rssi,            sizeof(System.ble_sensor_data[9].rssi),            INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR10_BATT,    __SNAME("p8120"), __SPTR(&System.ble_sensor_data[9].batt_lev),        &System.ble_sensor_data_res[9].batt_lev,        sizeof(System.ble_sensor_data[9].batt_lev),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR10_U8,      __SNAME("p8121"), __SPTR(&System.ble_sensor_data[9].u8_data),         &System.ble_sensor_data_res[9].u8_data,         sizeof(System.ble_sensor_data[9].u8_data),         UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR10_I16_1,   __SNAME("p8122"), __SPTR(&System.ble_sensor_data[9].i16_data_1),      &System.ble_sensor_data_res[9].i16_data_1,      sizeof(System.ble_sensor_data[9].i16_data_1),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR10_I16_2,   __SNAME("p8123"), __SPTR(&System.ble_sensor_data[9].i16_data_2),      &System.ble_sensor_data_res[9].i16_data_2,      sizeof(System.ble_sensor_data[9].i16_data_2),      INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR10_U16_1,   __SNAME("p8124"), __SPTR(&System.ble_sensor_data[9].u16_data_1),      &System.ble_sensor_data_res[9].u16_data_1,      sizeof(System.ble_sensor_data[9].u16_data_1),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR10_U16_2,   __SNAME("p8125"), __SPTR(&System.ble_sensor_data[9].u16_data_2),      &System.ble_sensor_data_res[9].u16_data_2,      sizeof(System.ble_sensor_data[9].u16_data_2),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 10)
  {BLE_SENSOR11_VISIBLE, __SNAME("p8130"), __SPTR(&System.ble_sensor_data[10].visible),        &System.ble_sensor_data_res[10].visible,        sizeof(System.ble_sensor_data[10].visible),        UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR11_TIMER,   __SNAME("p8131"), __SPTR(&System.ble_sensor_data[10].timer),          &System.ble_sensor_data_res[10].timer,          sizeof(System.ble_sensor_data[10].timer),          UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR11_RSSI,    __SNAME("p8132"), __SPTR(&System.ble_sensor_data[10].rssi),           &System.ble_sensor_data_res[10].rssi,           sizeof(System.ble_sensor_data[10].rssi),           INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR11_BATT,    __SNAME("p8133"), __SPTR(&System.ble_sensor_data[10].batt_lev),       &System.ble_sensor_data_res[10].batt_lev,       sizeof(System.ble_sensor_data[10].batt_lev),       UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR11_U8,      __SNAME("p8134"), __SPTR(&System.ble_sensor_data[10].u8_data),        &System.ble_sensor_data_res[10].u8_data,        sizeof(System.ble_sensor_data[10].u8_data),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR11_I16_1,   __SNAME("p8135"), __SPTR(&System.ble_sensor_data[10].i16_data_1),     &System.ble_sensor_data_res[10].i16_data_1,     sizeof(System.ble_sensor_data[10].i16_data_1),     INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR11_I16_2,   __SNAME("p8136"), __SPTR(&System.ble_sensor_data[10].i16_data_2),     &System.ble_sensor_data_res[10].i16_data_2,     sizeof(System.ble_sensor_data[10].i16_data_2),     INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR11_U16_1,   __SNAME("p8137"), __SPTR(&System.ble_sensor_data[10].u16_data_1),     &System.ble_sensor_data_res[10].u16_data_1,     sizeof(System.ble_sensor_data[10].u16_data_1),     UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR11_U16_2,   __SNAME("p8138"), __SPTR(&System.ble_sensor_data[10].u16_data_2),     &System.ble_sensor_data_res[10].u16_data_2,     sizeof(System.ble_sensor_data[10].u16_data_2),     UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 11)
  {BLE_SENSOR12_VISIBLE, __SNAME("p8143"), __SPTR(&System.ble_sensor_data[11].visible),        &System.ble_sensor_data_res[11].visible,        sizeof(System.ble_sensor_data[11].visible),        UINT64_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR12_TIMER,   __SNAME("p8144"), __SPTR(&System.ble_sensor_data[11].timer),          &System.ble_sensor_data_res[11].timer,          sizeof(System.ble_sensor_data[11].timer),          UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR12_RSSI,    __SNAME("p8145"), __SPTR(&System.ble_sensor_data[11].rssi),           &System.ble_sensor_data_res[11].rssi,           sizeof(System.ble_sensor_data[11].rssi),           INT8_SYSTEM_T,   __EGTSN(0xFFFF)},
  {BLE_SENSOR12_BATT,    __SNAME("p8146"), __SPTR(&System.ble_sensor_data[11].batt_lev),       &System.ble_sensor_data_res[11].batt_lev,       sizeof(System.ble_sensor_data[11].batt_lev),       UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR12_U8,      __SNAME("p8147"), __SPTR(&System.ble_sensor_data[11].u8_data),        &System.ble_sensor_data_res[11].u8_data,        sizeof(System.ble_sensor_data[11].u8_data),        UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR12_I16_1,   __SNAME("p8148"), __SPTR(&System.ble_sensor_data[11].i16_data_1),     &System.ble_sensor_data_res[11].i16_data_1,     sizeof(System.ble_sensor_data[11].i16_data_1),     INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR12_I16_2,   __SNAME("p8149"), __SPTR(&System.ble_sensor_data[11].i16_data_2),     &System.ble_sensor_data_res[11].i16_data_2,     sizeof(System.ble_sensor_data[11].i16_data_2),     INT16_SYSTEM_T,  __EGTSN(0xFFFF)},
  {BLE_SENSOR12_U16_1,   __SNAME("p8150"), __SPTR(&System.ble_sensor_data[11].u16_data_1),     &System.ble_sensor_data_res[11].u16_data_1,     sizeof(System.ble_sensor_data[11].u16_data_1),     UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {BLE_SENSOR12_U16_2,   __SNAME("p8151"), __SPTR(&System.ble_sensor_data[11].u16_data_2),     &System.ble_sensor_data_res[11].u16_data_2,     sizeof(System.ble_sensor_data[11].u16_data_2),     UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  //reserve4
#endif
#if (MAX_BLE_SENSORS_COUNT > 12)
#error
#endif
#endif //defined(BLE_SENSORS_PRESENT)

#if defined(SAVER2021_PRESENT)
  {SAVER2021_RAW_STATE,           __SNAME("p8350"), __SPTR(&System.saver2021_state.main),                 &System.saver2021_state_res.main,                 sizeof(System.saver2021_state.main),   ARRAY_SYSTEM_T,   __EGTSN(0xFFFF)},
  {SAVER2021_DTC_STR,             __SNAME("p8351"), __SPTR(&System.saver2021_state.dtc),                  &System.saver2021_state_res.dtc,                  sizeof(System.saver2021_state.dtc),    STRING_SYSTEM_T,  __EGTSN(0xFFFF)},
#endif //defined(SAVER2021_PRESENT)

#if defined(BASE_STATION_BT_PRESENT)
  {BASE_STATION_BT,      "p31000", &System.base_station_bt_state.comm_state,    &System.base_station_bt_state_res.comm_state,    sizeof(System.base_station_bt_state.comm_state),    UINT8_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+1,    "p31001", &System.base_station_bt_state.mac_addres_bs, &System.base_station_bt_state_res.mac_addres_bs, sizeof(System.base_station_bt_state.mac_addres_bs), ARRAY_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+2,    "p31002", &System.base_station_bt_state.timestamp,     &System.base_station_bt_state_res.timestamp,     sizeof(System.base_station_bt_state.timestamp),     UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+3,    "p31003", &System.base_station_bt_state.status_bs,     &System.base_station_bt_state_res.status_bs,     sizeof(System.base_station_bt_state.status_bs),     UINT32_SYSTEM_T,0xffff},
#if (MAX_BT_SENSORS > 0)
  {BASE_STATION_BT+4+0, "p31004", &System.bt_sensor_state[0].u64_sensor,      &System.bt_sensor_state_res[0].u64_sensor,      sizeof(System.bt_sensor_state[0].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+1, "p31005", &System.bt_sensor_state[0].timestamp,       &System.bt_sensor_state_res[0].timestamp,       sizeof(System.bt_sensor_state[0].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+2, "p31006", &System.bt_sensor_state[0].data[0],         &System.bt_sensor_state_res[0].data[0],         sizeof(System.bt_sensor_state[0].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+3, "p31007", &System.bt_sensor_state[0].data[1],         &System.bt_sensor_state_res[0].data[1],         sizeof(System.bt_sensor_state[0].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+4, "p31008", &System.bt_sensor_state[0].data[2],         &System.bt_sensor_state_res[0].data[2],         sizeof(System.bt_sensor_state[0].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+5, "p31009", &System.bt_sensor_state[0].data[3],         &System.bt_sensor_state_res[0].data[3],         sizeof(System.bt_sensor_state[0].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+6, "p31010", &System.bt_sensor_state[0].data[4],         &System.bt_sensor_state_res[0].data[4],         sizeof(System.bt_sensor_state[0].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+7, "p31011", &System.bt_sensor_state[0].data[5],         &System.bt_sensor_state_res[0].data[5],         sizeof(System.bt_sensor_state[0].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+8, "p31012", &System.bt_sensor_state[0].limt1,           &System.bt_sensor_state_res[0].limt1,           sizeof(System.bt_sensor_state[0].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+9, "p31013", &System.bt_sensor_state[0].limb1,           &System.bt_sensor_state_res[0].limb1,           sizeof(System.bt_sensor_state[0].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+10,"p31014", &System.bt_sensor_state[0].limt2,           &System.bt_sensor_state_res[0].limt2,           sizeof(System.bt_sensor_state[0].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+11,"p31015", &System.bt_sensor_state[0].limb2,           &System.bt_sensor_state_res[0].limb2,           sizeof(System.bt_sensor_state[0].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+12,"p31016", &System.bt_sensor_state[0].t_meas,          &System.bt_sensor_state_res[0].t_meas,          sizeof(System.bt_sensor_state[0].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+13,"p31017", &System.bt_sensor_state[0].timer_k,         &System.bt_sensor_state_res[0].timer_k,         sizeof(System.bt_sensor_state[0].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+14,"p31018", &System.bt_sensor_state[0].battery,         &System.bt_sensor_state_res[0].battery,         sizeof(System.bt_sensor_state[0].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 1)
  {BASE_STATION_BT+4+15*1+0, "p31019", &System.bt_sensor_state[1].u64_sensor,      &System.bt_sensor_state_res[1].u64_sensor,      sizeof(System.bt_sensor_state[1].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*1+1, "p31020", &System.bt_sensor_state[1].timestamp,       &System.bt_sensor_state_res[1].timestamp,       sizeof(System.bt_sensor_state[1].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*1+2, "p31021", &System.bt_sensor_state[1].data[0],         &System.bt_sensor_state_res[1].data[0],         sizeof(System.bt_sensor_state[1].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+3, "p31022", &System.bt_sensor_state[1].data[1],         &System.bt_sensor_state_res[1].data[1],         sizeof(System.bt_sensor_state[1].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+4, "p31023", &System.bt_sensor_state[1].data[2],         &System.bt_sensor_state_res[1].data[2],         sizeof(System.bt_sensor_state[1].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+5, "p31024", &System.bt_sensor_state[1].data[3],         &System.bt_sensor_state_res[1].data[3],         sizeof(System.bt_sensor_state[1].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+6, "p31025", &System.bt_sensor_state[1].data[4],         &System.bt_sensor_state_res[1].data[4],         sizeof(System.bt_sensor_state[1].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+7, "p31026", &System.bt_sensor_state[1].data[5],         &System.bt_sensor_state_res[1].data[5],         sizeof(System.bt_sensor_state[1].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+8, "p31027", &System.bt_sensor_state[1].limt1,           &System.bt_sensor_state_res[1].limt1,           sizeof(System.bt_sensor_state[1].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+9, "p31028", &System.bt_sensor_state[1].limb1,           &System.bt_sensor_state_res[1].limb1,           sizeof(System.bt_sensor_state[1].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+10,"p31029", &System.bt_sensor_state[1].limt2,           &System.bt_sensor_state_res[1].limt2,           sizeof(System.bt_sensor_state[1].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+11,"p31030", &System.bt_sensor_state[1].limb2,           &System.bt_sensor_state_res[1].limb2,           sizeof(System.bt_sensor_state[1].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*1+12,"p31031", &System.bt_sensor_state[1].t_meas,          &System.bt_sensor_state_res[1].t_meas,          sizeof(System.bt_sensor_state[1].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*1+13,"p31032", &System.bt_sensor_state[1].timer_k,         &System.bt_sensor_state_res[1].timer_k,         sizeof(System.bt_sensor_state[1].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*1+14,"p31033", &System.bt_sensor_state[1].battery,         &System.bt_sensor_state_res[1].battery,         sizeof(System.bt_sensor_state[1].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 2)
  {BASE_STATION_BT+4+15*2+0, "p31034", &System.bt_sensor_state[2].u64_sensor,      &System.bt_sensor_state_res[2].u64_sensor,      sizeof(System.bt_sensor_state[2].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*2+1, "p31035", &System.bt_sensor_state[2].timestamp,       &System.bt_sensor_state_res[2].timestamp,       sizeof(System.bt_sensor_state[2].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*2+2, "p31036", &System.bt_sensor_state[2].data[0],         &System.bt_sensor_state_res[2].data[0],         sizeof(System.bt_sensor_state[2].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+3, "p31037", &System.bt_sensor_state[2].data[1],         &System.bt_sensor_state_res[2].data[1],         sizeof(System.bt_sensor_state[2].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+4, "p31038", &System.bt_sensor_state[2].data[2],         &System.bt_sensor_state_res[2].data[2],         sizeof(System.bt_sensor_state[2].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+5, "p31039", &System.bt_sensor_state[2].data[3],         &System.bt_sensor_state_res[2].data[3],         sizeof(System.bt_sensor_state[2].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+6, "p31040", &System.bt_sensor_state[2].data[4],         &System.bt_sensor_state_res[2].data[4],         sizeof(System.bt_sensor_state[2].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+7, "p31041", &System.bt_sensor_state[2].data[5],         &System.bt_sensor_state_res[2].data[5],         sizeof(System.bt_sensor_state[2].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+8, "p31042", &System.bt_sensor_state[2].limt1,           &System.bt_sensor_state_res[2].limt1,           sizeof(System.bt_sensor_state[2].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+9, "p31043", &System.bt_sensor_state[2].limb1,           &System.bt_sensor_state_res[2].limb1,           sizeof(System.bt_sensor_state[2].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+10,"p31044", &System.bt_sensor_state[2].limt2,           &System.bt_sensor_state_res[2].limt2,           sizeof(System.bt_sensor_state[2].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+11,"p31045", &System.bt_sensor_state[2].limb2,           &System.bt_sensor_state_res[2].limb2,           sizeof(System.bt_sensor_state[2].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*2+12,"p31046", &System.bt_sensor_state[2].t_meas,          &System.bt_sensor_state_res[2].t_meas,          sizeof(System.bt_sensor_state[2].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*2+13,"p31047", &System.bt_sensor_state[2].timer_k,         &System.bt_sensor_state_res[2].timer_k,         sizeof(System.bt_sensor_state[2].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*2+14,"p31048", &System.bt_sensor_state[2].battery,         &System.bt_sensor_state_res[2].battery,         sizeof(System.bt_sensor_state[2].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 3)
  {BASE_STATION_BT+4+15*3+0, "p31049", &System.bt_sensor_state[3].u64_sensor,      &System.bt_sensor_state_res[3].u64_sensor,      sizeof(System.bt_sensor_state[3].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*3+1, "p31050", &System.bt_sensor_state[3].timestamp,       &System.bt_sensor_state_res[3].timestamp,       sizeof(System.bt_sensor_state[3].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*3+2, "p31051", &System.bt_sensor_state[3].data[0],         &System.bt_sensor_state_res[3].data[0],         sizeof(System.bt_sensor_state[3].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+3, "p31052", &System.bt_sensor_state[3].data[1],         &System.bt_sensor_state_res[3].data[1],         sizeof(System.bt_sensor_state[3].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+4, "p31053", &System.bt_sensor_state[3].data[2],         &System.bt_sensor_state_res[3].data[2],         sizeof(System.bt_sensor_state[3].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+5, "p31054", &System.bt_sensor_state[3].data[3],         &System.bt_sensor_state_res[3].data[3],         sizeof(System.bt_sensor_state[3].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+6, "p31055", &System.bt_sensor_state[3].data[4],         &System.bt_sensor_state_res[3].data[4],         sizeof(System.bt_sensor_state[3].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+7, "p31056", &System.bt_sensor_state[3].data[5],         &System.bt_sensor_state_res[3].data[5],         sizeof(System.bt_sensor_state[3].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+8, "p31057", &System.bt_sensor_state[3].limt1,           &System.bt_sensor_state_res[3].limt1,           sizeof(System.bt_sensor_state[3].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+9, "p31058", &System.bt_sensor_state[3].limb1,           &System.bt_sensor_state_res[3].limb1,           sizeof(System.bt_sensor_state[3].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+10,"p31059", &System.bt_sensor_state[3].limt2,           &System.bt_sensor_state_res[3].limt2,           sizeof(System.bt_sensor_state[3].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+11,"p31060", &System.bt_sensor_state[3].limb2,           &System.bt_sensor_state_res[3].limb2,           sizeof(System.bt_sensor_state[3].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*3+12,"p31061", &System.bt_sensor_state[3].t_meas,          &System.bt_sensor_state_res[3].t_meas,          sizeof(System.bt_sensor_state[3].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*3+13,"p31062", &System.bt_sensor_state[3].timer_k,         &System.bt_sensor_state_res[3].timer_k,         sizeof(System.bt_sensor_state[3].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*3+14,"p31063", &System.bt_sensor_state[3].battery,         &System.bt_sensor_state_res[3].battery,         sizeof(System.bt_sensor_state[3].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 4)
  {BASE_STATION_BT+4+15*4+0, "p31064", &System.bt_sensor_state[4].u64_sensor,      &System.bt_sensor_state_res[4].u64_sensor,      sizeof(System.bt_sensor_state[4].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*4+1, "p31065", &System.bt_sensor_state[4].timestamp,       &System.bt_sensor_state_res[4].timestamp,       sizeof(System.bt_sensor_state[4].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*4+2, "p31066", &System.bt_sensor_state[4].data[0],         &System.bt_sensor_state_res[4].data[0],         sizeof(System.bt_sensor_state[4].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+3, "p31067", &System.bt_sensor_state[4].data[1],         &System.bt_sensor_state_res[4].data[1],         sizeof(System.bt_sensor_state[4].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+4, "p31068", &System.bt_sensor_state[4].data[2],         &System.bt_sensor_state_res[4].data[2],         sizeof(System.bt_sensor_state[4].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+5, "p31069", &System.bt_sensor_state[4].data[3],         &System.bt_sensor_state_res[4].data[3],         sizeof(System.bt_sensor_state[4].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+6, "p31070", &System.bt_sensor_state[4].data[4],         &System.bt_sensor_state_res[4].data[4],         sizeof(System.bt_sensor_state[4].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+7, "p31071", &System.bt_sensor_state[4].data[5],         &System.bt_sensor_state_res[4].data[5],         sizeof(System.bt_sensor_state[4].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+8, "p31072", &System.bt_sensor_state[4].limt1,           &System.bt_sensor_state_res[4].limt1,           sizeof(System.bt_sensor_state[4].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+9, "p31073", &System.bt_sensor_state[4].limb1,           &System.bt_sensor_state_res[4].limb1,           sizeof(System.bt_sensor_state[4].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+10,"p31074", &System.bt_sensor_state[4].limt2,           &System.bt_sensor_state_res[4].limt2,           sizeof(System.bt_sensor_state[4].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+11,"p31075", &System.bt_sensor_state[4].limb2,           &System.bt_sensor_state_res[4].limb2,           sizeof(System.bt_sensor_state[4].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*4+12,"p31076", &System.bt_sensor_state[4].t_meas,          &System.bt_sensor_state_res[4].t_meas,          sizeof(System.bt_sensor_state[4].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*4+13,"p31077", &System.bt_sensor_state[4].timer_k,         &System.bt_sensor_state_res[4].timer_k,         sizeof(System.bt_sensor_state[4].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*4+14,"p31078", &System.bt_sensor_state[4].battery,         &System.bt_sensor_state_res[4].battery,         sizeof(System.bt_sensor_state[4].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 5)
  {BASE_STATION_BT+4+15*5+0, "p31079", &System.bt_sensor_state[5].u64_sensor,      &System.bt_sensor_state_res[5].u64_sensor,      sizeof(System.bt_sensor_state[5].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*5+1, "p31080", &System.bt_sensor_state[5].timestamp,       &System.bt_sensor_state_res[5].timestamp,       sizeof(System.bt_sensor_state[5].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*5+2, "p31081", &System.bt_sensor_state[5].data[0],         &System.bt_sensor_state_res[5].data[0],         sizeof(System.bt_sensor_state[5].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+3, "p31082", &System.bt_sensor_state[5].data[1],         &System.bt_sensor_state_res[5].data[1],         sizeof(System.bt_sensor_state[5].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+4, "p31083", &System.bt_sensor_state[5].data[2],         &System.bt_sensor_state_res[5].data[2],         sizeof(System.bt_sensor_state[5].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+5, "p31084", &System.bt_sensor_state[5].data[3],         &System.bt_sensor_state_res[5].data[3],         sizeof(System.bt_sensor_state[5].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+6, "p31085", &System.bt_sensor_state[5].data[4],         &System.bt_sensor_state_res[5].data[4],         sizeof(System.bt_sensor_state[5].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+7, "p31086", &System.bt_sensor_state[5].data[5],         &System.bt_sensor_state_res[5].data[5],         sizeof(System.bt_sensor_state[5].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+8, "p31087", &System.bt_sensor_state[5].limt1,           &System.bt_sensor_state_res[5].limt1,           sizeof(System.bt_sensor_state[5].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+9, "p31088", &System.bt_sensor_state[5].limb1,           &System.bt_sensor_state_res[5].limb1,           sizeof(System.bt_sensor_state[5].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+10,"p31089", &System.bt_sensor_state[5].limt2,           &System.bt_sensor_state_res[5].limt2,           sizeof(System.bt_sensor_state[5].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+11,"p31090", &System.bt_sensor_state[5].limb2,           &System.bt_sensor_state_res[5].limb2,           sizeof(System.bt_sensor_state[5].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*5+12,"p31091", &System.bt_sensor_state[5].t_meas,          &System.bt_sensor_state_res[5].t_meas,          sizeof(System.bt_sensor_state[5].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*5+13,"p31092", &System.bt_sensor_state[5].timer_k,         &System.bt_sensor_state_res[5].timer_k,         sizeof(System.bt_sensor_state[5].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*5+14,"p31093", &System.bt_sensor_state[5].battery,         &System.bt_sensor_state_res[5].battery,         sizeof(System.bt_sensor_state[5].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 6)
  {BASE_STATION_BT+4+15*6+0, "p31094", &System.bt_sensor_state[6].u64_sensor,      &System.bt_sensor_state_res[6].u64_sensor,      sizeof(System.bt_sensor_state[6].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*6+1, "p31095", &System.bt_sensor_state[6].timestamp,       &System.bt_sensor_state_res[6].timestamp,       sizeof(System.bt_sensor_state[6].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*6+2, "p31096", &System.bt_sensor_state[6].data[0],         &System.bt_sensor_state_res[6].data[0],         sizeof(System.bt_sensor_state[6].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+3, "p31097", &System.bt_sensor_state[6].data[1],         &System.bt_sensor_state_res[6].data[1],         sizeof(System.bt_sensor_state[6].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+4, "p31098", &System.bt_sensor_state[6].data[2],         &System.bt_sensor_state_res[6].data[2],         sizeof(System.bt_sensor_state[6].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+5, "p31099", &System.bt_sensor_state[6].data[3],         &System.bt_sensor_state_res[6].data[3],         sizeof(System.bt_sensor_state[6].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+6, "p31100", &System.bt_sensor_state[6].data[4],         &System.bt_sensor_state_res[6].data[4],         sizeof(System.bt_sensor_state[6].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+7, "p31101", &System.bt_sensor_state[6].data[5],         &System.bt_sensor_state_res[6].data[5],         sizeof(System.bt_sensor_state[6].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+8, "p31102", &System.bt_sensor_state[6].limt1,           &System.bt_sensor_state_res[6].limt1,           sizeof(System.bt_sensor_state[6].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+9, "p31103", &System.bt_sensor_state[6].limb1,           &System.bt_sensor_state_res[6].limb1,           sizeof(System.bt_sensor_state[6].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+10,"p31104", &System.bt_sensor_state[6].limt2,           &System.bt_sensor_state_res[6].limt2,           sizeof(System.bt_sensor_state[6].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+11,"p31105", &System.bt_sensor_state[6].limb2,           &System.bt_sensor_state_res[6].limb2,           sizeof(System.bt_sensor_state[6].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*6+12,"p31106", &System.bt_sensor_state[6].t_meas,          &System.bt_sensor_state_res[6].t_meas,          sizeof(System.bt_sensor_state[6].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*6+13,"p31107", &System.bt_sensor_state[6].timer_k,         &System.bt_sensor_state_res[6].timer_k,         sizeof(System.bt_sensor_state[6].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*6+14,"p31108", &System.bt_sensor_state[6].battery,         &System.bt_sensor_state_res[6].battery,         sizeof(System.bt_sensor_state[6].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 7)
  {BASE_STATION_BT+4+15*7+0, "p31109", &System.bt_sensor_state[7].u64_sensor,      &System.bt_sensor_state_res[7].u64_sensor,      sizeof(System.bt_sensor_state[7].u64_sensor),      UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+1, "p31110", &System.bt_sensor_state[7].timestamp,       &System.bt_sensor_state_res[7].timestamp,       sizeof(System.bt_sensor_state[7].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*7+2, "p31111", &System.bt_sensor_state[7].data[0],         &System.bt_sensor_state_res[7].data[0],         sizeof(System.bt_sensor_state[7].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+3, "p31112", &System.bt_sensor_state[7].data[1],         &System.bt_sensor_state_res[7].data[1],         sizeof(System.bt_sensor_state[7].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+4, "p31113", &System.bt_sensor_state[7].data[2],         &System.bt_sensor_state_res[7].data[2],         sizeof(System.bt_sensor_state[7].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+5, "p31114", &System.bt_sensor_state[7].data[3],         &System.bt_sensor_state_res[7].data[3],         sizeof(System.bt_sensor_state[7].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+6, "p31115", &System.bt_sensor_state[7].data[4],         &System.bt_sensor_state_res[7].data[4],         sizeof(System.bt_sensor_state[7].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+7, "p31116", &System.bt_sensor_state[7].data[5],         &System.bt_sensor_state_res[7].data[5],         sizeof(System.bt_sensor_state[7].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+8, "p31117", &System.bt_sensor_state[7].limt1,           &System.bt_sensor_state_res[7].limt1,           sizeof(System.bt_sensor_state[7].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+9, "p31118", &System.bt_sensor_state[7].limb1,           &System.bt_sensor_state_res[7].limb1,           sizeof(System.bt_sensor_state[7].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+10,"p31119", &System.bt_sensor_state[7].limt2,           &System.bt_sensor_state_res[7].limt2,           sizeof(System.bt_sensor_state[7].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+11,"p31120", &System.bt_sensor_state[7].limb2,           &System.bt_sensor_state_res[7].limb2,           sizeof(System.bt_sensor_state[7].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*7+12,"p31121", &System.bt_sensor_state[7].t_meas,          &System.bt_sensor_state_res[7].t_meas,          sizeof(System.bt_sensor_state[7].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*7+13,"p31122", &System.bt_sensor_state[7].timer_k,         &System.bt_sensor_state_res[7].timer_k,         sizeof(System.bt_sensor_state[7].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*7+14,"p31123", &System.bt_sensor_state[7].battery,         &System.bt_sensor_state_res[7].battery,         sizeof(System.bt_sensor_state[7].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 8)
  {BASE_STATION_BT+4+15*8+0, "p31124", &System.bt_sensor_state[8].u64_sensor,      &System.bt_sensor_state_res[8].u64_sensor,      sizeof(System.bt_sensor_state[8].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*8+1, "p31125", &System.bt_sensor_state[8].timestamp,       &System.bt_sensor_state_res[8].timestamp,       sizeof(System.bt_sensor_state[8].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*8+2, "p31126", &System.bt_sensor_state[8].data[0],         &System.bt_sensor_state_res[8].data[0],         sizeof(System.bt_sensor_state[8].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+3, "p31127", &System.bt_sensor_state[8].data[1],         &System.bt_sensor_state_res[8].data[1],         sizeof(System.bt_sensor_state[8].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+4, "p31128", &System.bt_sensor_state[8].data[2],         &System.bt_sensor_state_res[8].data[2],         sizeof(System.bt_sensor_state[8].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+5, "p31129", &System.bt_sensor_state[8].data[3],         &System.bt_sensor_state_res[8].data[3],         sizeof(System.bt_sensor_state[8].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+6, "p31130", &System.bt_sensor_state[8].data[4],         &System.bt_sensor_state_res[8].data[4],         sizeof(System.bt_sensor_state[8].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+7, "p31131", &System.bt_sensor_state[8].data[5],         &System.bt_sensor_state_res[8].data[5],         sizeof(System.bt_sensor_state[8].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+8, "p31132", &System.bt_sensor_state[8].limt1,           &System.bt_sensor_state_res[8].limt1,           sizeof(System.bt_sensor_state[8].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+9, "p31133", &System.bt_sensor_state[8].limb1,           &System.bt_sensor_state_res[8].limb1,           sizeof(System.bt_sensor_state[8].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+10,"p31134", &System.bt_sensor_state[8].limt2,           &System.bt_sensor_state_res[8].limt2,           sizeof(System.bt_sensor_state[8].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+11,"p31135", &System.bt_sensor_state[8].limb2,           &System.bt_sensor_state_res[8].limb2,           sizeof(System.bt_sensor_state[8].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*8+12,"p31136", &System.bt_sensor_state[8].t_meas,          &System.bt_sensor_state_res[8].t_meas,          sizeof(System.bt_sensor_state[8].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*8+13,"p31137", &System.bt_sensor_state[8].timer_k,         &System.bt_sensor_state_res[8].timer_k,         sizeof(System.bt_sensor_state[8].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*8+14,"p31138", &System.bt_sensor_state[8].battery,         &System.bt_sensor_state_res[8].battery,         sizeof(System.bt_sensor_state[8].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 9)
  {BASE_STATION_BT+4+15*9+0, "p31139", &System.bt_sensor_state[9].u64_sensor,      &System.bt_sensor_state_res[9].u64_sensor,      sizeof(System.bt_sensor_state[9].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*9+1, "p31140", &System.bt_sensor_state[9].timestamp,       &System.bt_sensor_state_res[9].timestamp,       sizeof(System.bt_sensor_state[9].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*9+2, "p31141", &System.bt_sensor_state[9].data[0],         &System.bt_sensor_state_res[9].data[0],         sizeof(System.bt_sensor_state[9].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+3, "p31142", &System.bt_sensor_state[9].data[1],         &System.bt_sensor_state_res[9].data[1],         sizeof(System.bt_sensor_state[9].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+4, "p31143", &System.bt_sensor_state[9].data[2],         &System.bt_sensor_state_res[9].data[2],         sizeof(System.bt_sensor_state[9].data[2]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+5, "p31144", &System.bt_sensor_state[9].data[3],         &System.bt_sensor_state_res[9].data[3],         sizeof(System.bt_sensor_state[9].data[3]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+6, "p31145", &System.bt_sensor_state[9].data[4],         &System.bt_sensor_state_res[9].data[4],         sizeof(System.bt_sensor_state[9].data[4]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+7, "p31146", &System.bt_sensor_state[9].data[5],         &System.bt_sensor_state_res[9].data[5],         sizeof(System.bt_sensor_state[9].data[5]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+8, "p31147", &System.bt_sensor_state[9].limt1,           &System.bt_sensor_state_res[9].limt1,           sizeof(System.bt_sensor_state[9].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+9, "p31148", &System.bt_sensor_state[9].limb1,           &System.bt_sensor_state_res[9].limb1,           sizeof(System.bt_sensor_state[9].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+10,"p31149", &System.bt_sensor_state[9].limt2,           &System.bt_sensor_state_res[9].limt2,           sizeof(System.bt_sensor_state[9].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+11,"p31150", &System.bt_sensor_state[9].limb2,           &System.bt_sensor_state_res[9].limb2,           sizeof(System.bt_sensor_state[9].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*9+12,"p31151", &System.bt_sensor_state[9].t_meas,          &System.bt_sensor_state_res[9].t_meas,          sizeof(System.bt_sensor_state[9].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*9+13,"p31152", &System.bt_sensor_state[9].timer_k,         &System.bt_sensor_state_res[9].timer_k,         sizeof(System.bt_sensor_state[9].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*9+14,"p31153", &System.bt_sensor_state[9].battery,         &System.bt_sensor_state_res[9].battery,         sizeof(System.bt_sensor_state[9].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 10)   // для акселерометров заложены 1-е 10 датчиков по 6 пармаетров далее будет по 2
  {BASE_STATION_BT+4+15*10+0, "p31154", &System.bt_sensor_state[10].u64_sensor,      &System.bt_sensor_state_res[10].u64_sensor,      sizeof(System.bt_sensor_state[10].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+1, "p31155", &System.bt_sensor_state[10].timestamp,       &System.bt_sensor_state_res[10].timestamp,       sizeof(System.bt_sensor_state[10].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+2, "p31156", &System.bt_sensor_state[10].data[0],         &System.bt_sensor_state_res[10].data[0],         sizeof(System.bt_sensor_state[10].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+3, "p31157", &System.bt_sensor_state[10].data[1],         &System.bt_sensor_state_res[10].data[1],         sizeof(System.bt_sensor_state[10].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+4, "p31158", &System.bt_sensor_state[10].limt1,           &System.bt_sensor_state_res[10].limt1,           sizeof(System.bt_sensor_state[10].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+5, "p31159", &System.bt_sensor_state[10].limb1,           &System.bt_sensor_state_res[10].limb1,           sizeof(System.bt_sensor_state[10].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+6, "p31160", &System.bt_sensor_state[10].limt2,           &System.bt_sensor_state_res[10].limt2,           sizeof(System.bt_sensor_state[10].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+7, "p31161", &System.bt_sensor_state[10].limb2,           &System.bt_sensor_state_res[10].limb2,           sizeof(System.bt_sensor_state[10].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+8, "p31162", &System.bt_sensor_state[10].t_meas,          &System.bt_sensor_state_res[10].t_meas,          sizeof(System.bt_sensor_state[10].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+9, "p31163", &System.bt_sensor_state[10].timer_k,         &System.bt_sensor_state_res[10].timer_k,         sizeof(System.bt_sensor_state[10].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+10,"p31164", &System.bt_sensor_state[10].battery,         &System.bt_sensor_state_res[10].battery,         sizeof(System.bt_sensor_state[10].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 11)
  {BASE_STATION_BT+4+15*10+11+0, "p31165", &System.bt_sensor_state[11].u64_sensor,      &System.bt_sensor_state_res[11].u64_sensor,      sizeof(System.bt_sensor_state[11].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11+1, "p31166", &System.bt_sensor_state[11].timestamp,       &System.bt_sensor_state_res[11].timestamp,       sizeof(System.bt_sensor_state[11].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11+2, "p31167", &System.bt_sensor_state[11].data[0],         &System.bt_sensor_state_res[11].data[0],         sizeof(System.bt_sensor_state[11].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+3, "p31168", &System.bt_sensor_state[11].data[1],         &System.bt_sensor_state_res[11].data[1],         sizeof(System.bt_sensor_state[11].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+4, "p31169", &System.bt_sensor_state[11].limt1,           &System.bt_sensor_state_res[11].limt1,           sizeof(System.bt_sensor_state[11].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+5, "p31170", &System.bt_sensor_state[11].limb1,           &System.bt_sensor_state_res[11].limb1,           sizeof(System.bt_sensor_state[11].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+6, "p31171", &System.bt_sensor_state[11].limt2,           &System.bt_sensor_state_res[11].limt2,           sizeof(System.bt_sensor_state[11].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+7, "p31172", &System.bt_sensor_state[11].limb2,           &System.bt_sensor_state_res[11].limb2,           sizeof(System.bt_sensor_state[11].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11+8, "p31173", &System.bt_sensor_state[11].t_meas,          &System.bt_sensor_state_res[11].t_meas,          sizeof(System.bt_sensor_state[11].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11+9, "p31174", &System.bt_sensor_state[11].timer_k,         &System.bt_sensor_state_res[11].timer_k,         sizeof(System.bt_sensor_state[11].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11+10,"p31175", &System.bt_sensor_state[11].battery,         &System.bt_sensor_state_res[11].battery,         sizeof(System.bt_sensor_state[11].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 12)
  {BASE_STATION_BT+4+15*10+11*2+0, "p31176", &System.bt_sensor_state[12].u64_sensor,      &System.bt_sensor_state_res[12].u64_sensor,      sizeof(System.bt_sensor_state[12].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*2+1, "p31177", &System.bt_sensor_state[12].timestamp,       &System.bt_sensor_state_res[12].timestamp,       sizeof(System.bt_sensor_state[12].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*2+2, "p31178", &System.bt_sensor_state[12].data[0],         &System.bt_sensor_state_res[12].data[0],         sizeof(System.bt_sensor_state[12].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+3, "p31179", &System.bt_sensor_state[12].data[1],         &System.bt_sensor_state_res[12].data[1],         sizeof(System.bt_sensor_state[12].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+4, "p31180", &System.bt_sensor_state[12].limt1,           &System.bt_sensor_state_res[12].limt1,           sizeof(System.bt_sensor_state[12].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+5, "p31181", &System.bt_sensor_state[12].limb1,           &System.bt_sensor_state_res[12].limb1,           sizeof(System.bt_sensor_state[12].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+6, "p31182", &System.bt_sensor_state[12].limt2,           &System.bt_sensor_state_res[12].limt2,           sizeof(System.bt_sensor_state[12].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+7, "p31183", &System.bt_sensor_state[12].limb2,           &System.bt_sensor_state_res[12].limb2,           sizeof(System.bt_sensor_state[12].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*2+8, "p31184", &System.bt_sensor_state[12].t_meas,          &System.bt_sensor_state_res[12].t_meas,          sizeof(System.bt_sensor_state[12].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*2+9, "p31185", &System.bt_sensor_state[12].timer_k,         &System.bt_sensor_state_res[12].timer_k,         sizeof(System.bt_sensor_state[12].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*2+10,"p31186", &System.bt_sensor_state[12].battery,         &System.bt_sensor_state_res[12].battery,         sizeof(System.bt_sensor_state[12].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 13)
  {BASE_STATION_BT+4+15*10+11*3+0, "p31187", &System.bt_sensor_state[13].u64_sensor,      &System.bt_sensor_state_res[13].u64_sensor,      sizeof(System.bt_sensor_state[13].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*3+1, "p31188", &System.bt_sensor_state[13].timestamp,       &System.bt_sensor_state_res[13].timestamp,       sizeof(System.bt_sensor_state[13].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*3+2, "p31189", &System.bt_sensor_state[13].data[0],         &System.bt_sensor_state_res[13].data[0],         sizeof(System.bt_sensor_state[13].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+3, "p31190", &System.bt_sensor_state[13].data[1],         &System.bt_sensor_state_res[13].data[1],         sizeof(System.bt_sensor_state[13].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+4, "p31191", &System.bt_sensor_state[13].limt1,           &System.bt_sensor_state_res[13].limt1,           sizeof(System.bt_sensor_state[13].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+5, "p31192", &System.bt_sensor_state[13].limb1,           &System.bt_sensor_state_res[13].limb1,           sizeof(System.bt_sensor_state[13].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+6, "p31193", &System.bt_sensor_state[13].limt2,           &System.bt_sensor_state_res[13].limt2,           sizeof(System.bt_sensor_state[13].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+7, "p31194", &System.bt_sensor_state[13].limb2,           &System.bt_sensor_state_res[13].limb2,           sizeof(System.bt_sensor_state[13].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*3+8, "p31195", &System.bt_sensor_state[13].t_meas,          &System.bt_sensor_state_res[13].t_meas,          sizeof(System.bt_sensor_state[13].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*3+9, "p31196", &System.bt_sensor_state[13].timer_k,         &System.bt_sensor_state_res[13].timer_k,         sizeof(System.bt_sensor_state[13].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*3+10,"p31197", &System.bt_sensor_state[13].battery,         &System.bt_sensor_state_res[13].battery,         sizeof(System.bt_sensor_state[13].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 14)
  {BASE_STATION_BT+4+15*10+11*4+0, "p31198", &System.bt_sensor_state[14].u64_sensor,      &System.bt_sensor_state_res[14].u64_sensor,      sizeof(System.bt_sensor_state[14].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*4+1, "p31199", &System.bt_sensor_state[14].timestamp,       &System.bt_sensor_state_res[14].timestamp,       sizeof(System.bt_sensor_state[14].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*4+2, "p31200", &System.bt_sensor_state[14].data[0],         &System.bt_sensor_state_res[14].data[0],         sizeof(System.bt_sensor_state[14].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+3, "p31201", &System.bt_sensor_state[14].data[1],         &System.bt_sensor_state_res[14].data[1],         sizeof(System.bt_sensor_state[14].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+4, "p31202", &System.bt_sensor_state[14].limt1,           &System.bt_sensor_state_res[14].limt1,           sizeof(System.bt_sensor_state[14].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+5, "p31203", &System.bt_sensor_state[14].limb1,           &System.bt_sensor_state_res[14].limb1,           sizeof(System.bt_sensor_state[14].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+6, "p31204", &System.bt_sensor_state[14].limt2,           &System.bt_sensor_state_res[14].limt2,           sizeof(System.bt_sensor_state[14].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+7, "p31205", &System.bt_sensor_state[14].limb2,           &System.bt_sensor_state_res[14].limb2,           sizeof(System.bt_sensor_state[14].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*4+8, "p31206", &System.bt_sensor_state[14].t_meas,          &System.bt_sensor_state_res[14].t_meas,          sizeof(System.bt_sensor_state[14].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*4+9, "p31207", &System.bt_sensor_state[14].timer_k,         &System.bt_sensor_state_res[14].timer_k,         sizeof(System.bt_sensor_state[14].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*4+10,"p31208", &System.bt_sensor_state[14].battery,         &System.bt_sensor_state_res[14].battery,         sizeof(System.bt_sensor_state[14].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 15)
  {BASE_STATION_BT+4+15*10+11*5+0, "p31209", &System.bt_sensor_state[15].u64_sensor,      &System.bt_sensor_state_res[15].u64_sensor,      sizeof(System.bt_sensor_state[15].u64_sensor),      UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+1, "p31210", &System.bt_sensor_state[15].timestamp,       &System.bt_sensor_state_res[15].timestamp,       sizeof(System.bt_sensor_state[15].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*5+2, "p31211", &System.bt_sensor_state[15].data[0],         &System.bt_sensor_state_res[15].data[0],         sizeof(System.bt_sensor_state[15].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+3, "p31212", &System.bt_sensor_state[15].data[1],         &System.bt_sensor_state_res[15].data[1],         sizeof(System.bt_sensor_state[15].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+4, "p31213", &System.bt_sensor_state[15].limt1,           &System.bt_sensor_state_res[15].limt1,           sizeof(System.bt_sensor_state[15].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+5, "p31214", &System.bt_sensor_state[15].limb1,           &System.bt_sensor_state_res[15].limb1,           sizeof(System.bt_sensor_state[15].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+6, "p31215", &System.bt_sensor_state[15].limt2,           &System.bt_sensor_state_res[15].limt2,           sizeof(System.bt_sensor_state[15].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+7, "p31216", &System.bt_sensor_state[15].limb2,           &System.bt_sensor_state_res[15].limb2,           sizeof(System.bt_sensor_state[15].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*5+8, "p31217", &System.bt_sensor_state[15].t_meas,          &System.bt_sensor_state_res[15].t_meas,          sizeof(System.bt_sensor_state[15].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*5+9, "p31218", &System.bt_sensor_state[15].timer_k,         &System.bt_sensor_state_res[15].timer_k,         sizeof(System.bt_sensor_state[15].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*5+10,"p31219", &System.bt_sensor_state[15].battery,         &System.bt_sensor_state_res[15].battery,         sizeof(System.bt_sensor_state[15].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 16)
  {BASE_STATION_BT+4+15*10+11*6+0, "p31220", &System.bt_sensor_state[16].u64_sensor,      &System.bt_sensor_state_res[16].u64_sensor,      sizeof(System.bt_sensor_state[16].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*6+1, "p31221", &System.bt_sensor_state[16].timestamp,       &System.bt_sensor_state_res[16].timestamp,       sizeof(System.bt_sensor_state[16].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*6+2, "p31222", &System.bt_sensor_state[16].data[0],         &System.bt_sensor_state_res[16].data[0],         sizeof(System.bt_sensor_state[16].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+3, "p31223", &System.bt_sensor_state[16].data[1],         &System.bt_sensor_state_res[16].data[1],         sizeof(System.bt_sensor_state[16].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+4, "p31224", &System.bt_sensor_state[16].limt1,           &System.bt_sensor_state_res[16].limt1,           sizeof(System.bt_sensor_state[16].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+5, "p31225", &System.bt_sensor_state[16].limb1,           &System.bt_sensor_state_res[16].limb1,           sizeof(System.bt_sensor_state[16].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+6, "p31226", &System.bt_sensor_state[16].limt2,           &System.bt_sensor_state_res[16].limt2,           sizeof(System.bt_sensor_state[16].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+7, "p31227", &System.bt_sensor_state[16].limb2,           &System.bt_sensor_state_res[16].limb2,           sizeof(System.bt_sensor_state[16].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*6+8, "p31228", &System.bt_sensor_state[16].t_meas,          &System.bt_sensor_state_res[16].t_meas,          sizeof(System.bt_sensor_state[16].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*6+9, "p31229", &System.bt_sensor_state[16].timer_k,         &System.bt_sensor_state_res[16].timer_k,         sizeof(System.bt_sensor_state[16].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*6+10,"p31230", &System.bt_sensor_state[16].battery,         &System.bt_sensor_state_res[16].battery,         sizeof(System.bt_sensor_state[16].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 17)
  {BASE_STATION_BT+4+15*10+11*7+0, "p31231", &System.bt_sensor_state[17].u64_sensor,      &System.bt_sensor_state_res[17].u64_sensor,      sizeof(System.bt_sensor_state[17].u64_sensor),      UINT64_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*7+1, "p31232", &System.bt_sensor_state[17].timestamp,       &System.bt_sensor_state_res[17].timestamp,       sizeof(System.bt_sensor_state[17].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*7+2, "p31233", &System.bt_sensor_state[17].data[0],         &System.bt_sensor_state_res[17].data[0],         sizeof(System.bt_sensor_state[17].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+3, "p31234", &System.bt_sensor_state[17].data[1],         &System.bt_sensor_state_res[17].data[1],         sizeof(System.bt_sensor_state[17].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+4, "p31235", &System.bt_sensor_state[17].limt1,           &System.bt_sensor_state_res[17].limt1,           sizeof(System.bt_sensor_state[17].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+5, "p31236", &System.bt_sensor_state[17].limb1,           &System.bt_sensor_state_res[17].limb1,           sizeof(System.bt_sensor_state[17].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+6, "p31237", &System.bt_sensor_state[17].limt2,           &System.bt_sensor_state_res[17].limt2,           sizeof(System.bt_sensor_state[17].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+7, "p31238", &System.bt_sensor_state[17].limb2,           &System.bt_sensor_state_res[17].limb2,           sizeof(System.bt_sensor_state[17].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*7+8, "p31239", &System.bt_sensor_state[17].t_meas,          &System.bt_sensor_state_res[17].t_meas,          sizeof(System.bt_sensor_state[17].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*7+9, "p31240", &System.bt_sensor_state[17].timer_k,         &System.bt_sensor_state_res[17].timer_k,         sizeof(System.bt_sensor_state[17].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*7+10,"p31241", &System.bt_sensor_state[17].battery,         &System.bt_sensor_state_res[17].battery,         sizeof(System.bt_sensor_state[17].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 18)
  {BASE_STATION_BT+4+15*10+11*8+0, "p31242", &System.bt_sensor_state[18].u64_sensor,     &System.bt_sensor_state_res[18].u64_sensor,     sizeof(System.bt_sensor_state[18].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+1, "p31243", &System.bt_sensor_state[18].timestamp,       &System.bt_sensor_state_res[18].timestamp,       sizeof(System.bt_sensor_state[18].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*8+2, "p31244", &System.bt_sensor_state[18].data[0],         &System.bt_sensor_state_res[18].data[0],         sizeof(System.bt_sensor_state[18].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+3, "p31245", &System.bt_sensor_state[18].data[1],         &System.bt_sensor_state_res[18].data[1],         sizeof(System.bt_sensor_state[18].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+4, "p31246", &System.bt_sensor_state[18].limt1,           &System.bt_sensor_state_res[18].limt1,           sizeof(System.bt_sensor_state[18].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+5, "p31247", &System.bt_sensor_state[18].limb1,           &System.bt_sensor_state_res[18].limb1,           sizeof(System.bt_sensor_state[18].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+6, "p31248", &System.bt_sensor_state[18].limt2,           &System.bt_sensor_state_res[18].limt2,           sizeof(System.bt_sensor_state[18].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+7, "p31249", &System.bt_sensor_state[18].limb2,           &System.bt_sensor_state_res[18].limb2,           sizeof(System.bt_sensor_state[18].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*8+8, "p31250", &System.bt_sensor_state[18].t_meas,          &System.bt_sensor_state_res[18].t_meas,          sizeof(System.bt_sensor_state[18].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*8+9, "p31251", &System.bt_sensor_state[18].timer_k,         &System.bt_sensor_state_res[18].timer_k,         sizeof(System.bt_sensor_state[18].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*8+10,"p31252", &System.bt_sensor_state[18].battery,         &System.bt_sensor_state_res[18].battery,         sizeof(System.bt_sensor_state[18].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 19)
  {BASE_STATION_BT+4+15*10+11*9+0, "p31253", &System.bt_sensor_state[19].u64_sensor,     &System.bt_sensor_state_res[19].u64_sensor,     sizeof(System.bt_sensor_state[19].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+1, "p31254", &System.bt_sensor_state[19].timestamp,       &System.bt_sensor_state_res[19].timestamp,       sizeof(System.bt_sensor_state[19].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*9+2, "p31255", &System.bt_sensor_state[19].data[0],         &System.bt_sensor_state_res[19].data[0],         sizeof(System.bt_sensor_state[19].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+3, "p31256", &System.bt_sensor_state[19].data[1],         &System.bt_sensor_state_res[19].data[1],         sizeof(System.bt_sensor_state[19].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+4, "p31257", &System.bt_sensor_state[19].limt1,           &System.bt_sensor_state_res[19].limt1,           sizeof(System.bt_sensor_state[19].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+5, "p31258", &System.bt_sensor_state[19].limb1,           &System.bt_sensor_state_res[19].limb1,           sizeof(System.bt_sensor_state[19].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+6, "p31259", &System.bt_sensor_state[19].limt2,           &System.bt_sensor_state_res[19].limt2,           sizeof(System.bt_sensor_state[19].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+7, "p31260", &System.bt_sensor_state[19].limb2,           &System.bt_sensor_state_res[19].limb2,           sizeof(System.bt_sensor_state[19].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*9+8, "p31261", &System.bt_sensor_state[19].t_meas,          &System.bt_sensor_state_res[19].t_meas,          sizeof(System.bt_sensor_state[19].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*9+9, "p31262", &System.bt_sensor_state[19].timer_k,         &System.bt_sensor_state_res[19].timer_k,         sizeof(System.bt_sensor_state[19].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*9+10,"p31263", &System.bt_sensor_state[19].battery,         &System.bt_sensor_state_res[19].battery,         sizeof(System.bt_sensor_state[19].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 20)
  {BASE_STATION_BT+4+15*10+11*10+0, "p31264", &System.bt_sensor_state[20].u64_sensor,     &System.bt_sensor_state_res[20].u64_sensor,     sizeof(System.bt_sensor_state[20].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+1, "p31265", &System.bt_sensor_state[20].timestamp,       &System.bt_sensor_state_res[20].timestamp,       sizeof(System.bt_sensor_state[20].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*10+2, "p31266", &System.bt_sensor_state[20].data[0],         &System.bt_sensor_state_res[20].data[0],         sizeof(System.bt_sensor_state[20].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+3, "p31267", &System.bt_sensor_state[20].data[1],         &System.bt_sensor_state_res[20].data[1],         sizeof(System.bt_sensor_state[20].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+4, "p31268", &System.bt_sensor_state[20].limt1,           &System.bt_sensor_state_res[20].limt1,           sizeof(System.bt_sensor_state[20].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+5, "p31269", &System.bt_sensor_state[20].limb1,           &System.bt_sensor_state_res[20].limb1,           sizeof(System.bt_sensor_state[20].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+6, "p31270", &System.bt_sensor_state[20].limt2,           &System.bt_sensor_state_res[20].limt2,           sizeof(System.bt_sensor_state[20].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+7, "p31271", &System.bt_sensor_state[20].limb2,           &System.bt_sensor_state_res[20].limb2,           sizeof(System.bt_sensor_state[20].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*10+8, "p31272", &System.bt_sensor_state[20].t_meas,          &System.bt_sensor_state_res[20].t_meas,          sizeof(System.bt_sensor_state[20].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*10+9, "p31273", &System.bt_sensor_state[20].timer_k,         &System.bt_sensor_state_res[20].timer_k,         sizeof(System.bt_sensor_state[20].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*10+10,"p31274", &System.bt_sensor_state[20].battery,         &System.bt_sensor_state_res[20].battery,         sizeof(System.bt_sensor_state[20].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 21)
  {BASE_STATION_BT+4+15*10+11*11+0, "p31275", &System.bt_sensor_state[21].u64_sensor,     &System.bt_sensor_state_res[21].u64_sensor,     sizeof(System.bt_sensor_state[21].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+1, "p31276", &System.bt_sensor_state[21].timestamp,       &System.bt_sensor_state_res[21].timestamp,       sizeof(System.bt_sensor_state[21].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*11+2, "p31277", &System.bt_sensor_state[21].data[0],         &System.bt_sensor_state_res[21].data[0],         sizeof(System.bt_sensor_state[21].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+3, "p31278", &System.bt_sensor_state[21].data[1],         &System.bt_sensor_state_res[21].data[1],         sizeof(System.bt_sensor_state[21].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+4, "p31279", &System.bt_sensor_state[21].limt1,           &System.bt_sensor_state_res[21].limt1,           sizeof(System.bt_sensor_state[21].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+5, "p31280", &System.bt_sensor_state[21].limb1,           &System.bt_sensor_state_res[21].limb1,           sizeof(System.bt_sensor_state[21].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+6, "p31281", &System.bt_sensor_state[21].limt2,           &System.bt_sensor_state_res[21].limt2,           sizeof(System.bt_sensor_state[21].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+7, "p31282", &System.bt_sensor_state[21].limb2,           &System.bt_sensor_state_res[21].limb2,           sizeof(System.bt_sensor_state[21].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*11+8, "p31283", &System.bt_sensor_state[21].t_meas,          &System.bt_sensor_state_res[21].t_meas,          sizeof(System.bt_sensor_state[21].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*11+9, "p31284", &System.bt_sensor_state[21].timer_k,         &System.bt_sensor_state_res[21].timer_k,         sizeof(System.bt_sensor_state[21].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*11+10,"p31285", &System.bt_sensor_state[21].battery,         &System.bt_sensor_state_res[21].battery,         sizeof(System.bt_sensor_state[21].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 22)
  {BASE_STATION_BT+4+15*10+11*12+0, "p31286", &System.bt_sensor_state[22].u64_sensor,     &System.bt_sensor_state_res[22].u64_sensor,     sizeof(System.bt_sensor_state[22].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+1, "p31287", &System.bt_sensor_state[22].timestamp,       &System.bt_sensor_state_res[22].timestamp,       sizeof(System.bt_sensor_state[22].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*12+2, "p31288", &System.bt_sensor_state[22].data[0],         &System.bt_sensor_state_res[22].data[0],         sizeof(System.bt_sensor_state[22].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+3, "p31289", &System.bt_sensor_state[22].data[1],         &System.bt_sensor_state_res[22].data[1],         sizeof(System.bt_sensor_state[22].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+4, "p31290", &System.bt_sensor_state[22].limt1,           &System.bt_sensor_state_res[22].limt1,           sizeof(System.bt_sensor_state[22].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+5, "p31291", &System.bt_sensor_state[22].limb1,           &System.bt_sensor_state_res[22].limb1,           sizeof(System.bt_sensor_state[22].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+6, "p31292", &System.bt_sensor_state[22].limt2,           &System.bt_sensor_state_res[22].limt2,           sizeof(System.bt_sensor_state[22].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+7, "p31293", &System.bt_sensor_state[22].limb2,           &System.bt_sensor_state_res[22].limb2,           sizeof(System.bt_sensor_state[22].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*12+8, "p31294", &System.bt_sensor_state[22].t_meas,          &System.bt_sensor_state_res[22].t_meas,          sizeof(System.bt_sensor_state[22].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*12+9, "p31295", &System.bt_sensor_state[22].timer_k,         &System.bt_sensor_state_res[22].timer_k,         sizeof(System.bt_sensor_state[22].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*12+10,"p31296", &System.bt_sensor_state[22].battery,         &System.bt_sensor_state_res[22].battery,         sizeof(System.bt_sensor_state[22].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 23)
  {BASE_STATION_BT+4+15*10+11*13+0, "p31297", &System.bt_sensor_state[23].u64_sensor,     &System.bt_sensor_state_res[23].u64_sensor,     sizeof(System.bt_sensor_state[23].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+1, "p31298", &System.bt_sensor_state[23].timestamp,       &System.bt_sensor_state_res[23].timestamp,       sizeof(System.bt_sensor_state[23].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*13+2, "p31299", &System.bt_sensor_state[23].data[0],         &System.bt_sensor_state_res[23].data[0],         sizeof(System.bt_sensor_state[23].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+3, "p31300", &System.bt_sensor_state[23].data[1],         &System.bt_sensor_state_res[23].data[1],         sizeof(System.bt_sensor_state[23].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+4, "p31301", &System.bt_sensor_state[23].limt1,           &System.bt_sensor_state_res[23].limt1,           sizeof(System.bt_sensor_state[23].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+5, "p31302", &System.bt_sensor_state[23].limb1,           &System.bt_sensor_state_res[23].limb1,           sizeof(System.bt_sensor_state[23].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+6, "p31303", &System.bt_sensor_state[23].limt2,           &System.bt_sensor_state_res[23].limt2,           sizeof(System.bt_sensor_state[23].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+7, "p31304", &System.bt_sensor_state[23].limb2,           &System.bt_sensor_state_res[23].limb2,           sizeof(System.bt_sensor_state[23].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*13+8, "p31305", &System.bt_sensor_state[23].t_meas,          &System.bt_sensor_state_res[23].t_meas,          sizeof(System.bt_sensor_state[23].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*13+9, "p31306", &System.bt_sensor_state[23].timer_k,         &System.bt_sensor_state_res[23].timer_k,         sizeof(System.bt_sensor_state[23].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*13+10,"p31307", &System.bt_sensor_state[23].battery,         &System.bt_sensor_state_res[23].battery,         sizeof(System.bt_sensor_state[23].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 24)
  {BASE_STATION_BT+4+15*10+11*14+0, "p31308", &System.bt_sensor_state[24].u64_sensor,     &System.bt_sensor_state_res[24].u64_sensor,     sizeof(System.bt_sensor_state[24].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+1, "p31309", &System.bt_sensor_state[24].timestamp,       &System.bt_sensor_state_res[24].timestamp,       sizeof(System.bt_sensor_state[24].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*14+2, "p31310", &System.bt_sensor_state[24].data[0],         &System.bt_sensor_state_res[24].data[0],         sizeof(System.bt_sensor_state[24].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+3, "p31311", &System.bt_sensor_state[24].data[1],         &System.bt_sensor_state_res[24].data[1],         sizeof(System.bt_sensor_state[24].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+4, "p31312", &System.bt_sensor_state[24].limt1,           &System.bt_sensor_state_res[24].limt1,           sizeof(System.bt_sensor_state[24].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+5, "p31313", &System.bt_sensor_state[24].limb1,           &System.bt_sensor_state_res[24].limb1,           sizeof(System.bt_sensor_state[24].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+6, "p31314", &System.bt_sensor_state[24].limt2,           &System.bt_sensor_state_res[24].limt2,           sizeof(System.bt_sensor_state[24].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+7, "p31315", &System.bt_sensor_state[24].limb2,           &System.bt_sensor_state_res[24].limb2,           sizeof(System.bt_sensor_state[24].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*14+8, "p31316", &System.bt_sensor_state[24].t_meas,          &System.bt_sensor_state_res[24].t_meas,          sizeof(System.bt_sensor_state[24].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*14+9, "p31317", &System.bt_sensor_state[24].timer_k,         &System.bt_sensor_state_res[24].timer_k,         sizeof(System.bt_sensor_state[24].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*14+10,"p31318", &System.bt_sensor_state[24].battery,         &System.bt_sensor_state_res[24].battery,         sizeof(System.bt_sensor_state[24].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 25)
  {BASE_STATION_BT+4+15*10+11*15+0, "p31319", &System.bt_sensor_state[25].u64_sensor,     &System.bt_sensor_state_res[25].u64_sensor,     sizeof(System.bt_sensor_state[25].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+1, "p31320", &System.bt_sensor_state[25].timestamp,       &System.bt_sensor_state_res[25].timestamp,       sizeof(System.bt_sensor_state[25].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*15+2, "p31321", &System.bt_sensor_state[25].data[0],         &System.bt_sensor_state_res[25].data[0],         sizeof(System.bt_sensor_state[25].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+3, "p31322", &System.bt_sensor_state[25].data[1],         &System.bt_sensor_state_res[25].data[1],         sizeof(System.bt_sensor_state[25].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+4, "p31323", &System.bt_sensor_state[25].limt1,           &System.bt_sensor_state_res[25].limt1,           sizeof(System.bt_sensor_state[25].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+5, "p31324", &System.bt_sensor_state[25].limb1,           &System.bt_sensor_state_res[25].limb1,           sizeof(System.bt_sensor_state[25].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+6, "p31325", &System.bt_sensor_state[25].limt2,           &System.bt_sensor_state_res[25].limt2,           sizeof(System.bt_sensor_state[25].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+7, "p31326", &System.bt_sensor_state[25].limb2,           &System.bt_sensor_state_res[25].limb2,           sizeof(System.bt_sensor_state[25].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*15+8, "p31327", &System.bt_sensor_state[25].t_meas,          &System.bt_sensor_state_res[25].t_meas,          sizeof(System.bt_sensor_state[25].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*15+9, "p31328", &System.bt_sensor_state[25].timer_k,         &System.bt_sensor_state_res[25].timer_k,         sizeof(System.bt_sensor_state[25].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*15+10,"p31329", &System.bt_sensor_state[25].battery,         &System.bt_sensor_state_res[25].battery,         sizeof(System.bt_sensor_state[25].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 26)
  {BASE_STATION_BT+4+15*10+11*16+0, "p31330", &System.bt_sensor_state[26].u64_sensor,     &System.bt_sensor_state_res[26].u64_sensor,     sizeof(System.bt_sensor_state[26].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+1, "p31331", &System.bt_sensor_state[26].timestamp,       &System.bt_sensor_state_res[26].timestamp,       sizeof(System.bt_sensor_state[26].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*16+2, "p31332", &System.bt_sensor_state[26].data[0],         &System.bt_sensor_state_res[26].data[0],         sizeof(System.bt_sensor_state[26].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+3, "p31333", &System.bt_sensor_state[26].data[1],         &System.bt_sensor_state_res[26].data[1],         sizeof(System.bt_sensor_state[26].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+4, "p31334", &System.bt_sensor_state[26].limt1,           &System.bt_sensor_state_res[26].limt1,           sizeof(System.bt_sensor_state[26].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+5, "p31335", &System.bt_sensor_state[26].limb1,           &System.bt_sensor_state_res[26].limb1,           sizeof(System.bt_sensor_state[26].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+6, "p31336", &System.bt_sensor_state[26].limt2,           &System.bt_sensor_state_res[26].limt2,           sizeof(System.bt_sensor_state[26].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+7, "p31337", &System.bt_sensor_state[26].limb2,           &System.bt_sensor_state_res[26].limb2,           sizeof(System.bt_sensor_state[26].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*16+8, "p31338", &System.bt_sensor_state[26].t_meas,          &System.bt_sensor_state_res[26].t_meas,          sizeof(System.bt_sensor_state[26].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*16+9, "p31339", &System.bt_sensor_state[26].timer_k,         &System.bt_sensor_state_res[26].timer_k,         sizeof(System.bt_sensor_state[26].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*16+10,"p31340", &System.bt_sensor_state[26].battery,         &System.bt_sensor_state_res[26].battery,         sizeof(System.bt_sensor_state[26].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 27)
  {BASE_STATION_BT+4+15*10+11*17+0, "p31341", &System.bt_sensor_state[27].u64_sensor,     &System.bt_sensor_state_res[27].u64_sensor,     sizeof(System.bt_sensor_state[27].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+1, "p31342", &System.bt_sensor_state[27].timestamp,       &System.bt_sensor_state_res[27].timestamp,       sizeof(System.bt_sensor_state[27].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*17+2, "p31343", &System.bt_sensor_state[27].data[0],         &System.bt_sensor_state_res[27].data[0],         sizeof(System.bt_sensor_state[27].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+3, "p31344", &System.bt_sensor_state[27].data[1],         &System.bt_sensor_state_res[27].data[1],         sizeof(System.bt_sensor_state[27].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+4, "p31345", &System.bt_sensor_state[27].limt1,           &System.bt_sensor_state_res[27].limt1,           sizeof(System.bt_sensor_state[27].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+5, "p31346", &System.bt_sensor_state[27].limb1,           &System.bt_sensor_state_res[27].limb1,           sizeof(System.bt_sensor_state[27].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+6, "p31347", &System.bt_sensor_state[27].limt2,           &System.bt_sensor_state_res[27].limt2,           sizeof(System.bt_sensor_state[27].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+7, "p31348", &System.bt_sensor_state[27].limb2,           &System.bt_sensor_state_res[27].limb2,           sizeof(System.bt_sensor_state[27].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*17+8, "p31349", &System.bt_sensor_state[27].t_meas,          &System.bt_sensor_state_res[27].t_meas,          sizeof(System.bt_sensor_state[27].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*17+9, "p31350", &System.bt_sensor_state[27].timer_k,         &System.bt_sensor_state_res[27].timer_k,         sizeof(System.bt_sensor_state[27].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*17+10,"p31351", &System.bt_sensor_state[27].battery,         &System.bt_sensor_state_res[27].battery,         sizeof(System.bt_sensor_state[27].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 28)
  {BASE_STATION_BT+4+15*10+11*18+0, "p31352", &System.bt_sensor_state[28].u64_sensor,     &System.bt_sensor_state_res[28].u64_sensor,     sizeof(System.bt_sensor_state[28].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+1, "p31353", &System.bt_sensor_state[28].timestamp,       &System.bt_sensor_state_res[28].timestamp,       sizeof(System.bt_sensor_state[28].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*18+2, "p31354", &System.bt_sensor_state[28].data[0],         &System.bt_sensor_state_res[28].data[0],         sizeof(System.bt_sensor_state[28].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+3, "p31355", &System.bt_sensor_state[28].data[1],         &System.bt_sensor_state_res[28].data[1],         sizeof(System.bt_sensor_state[28].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+4, "p31356", &System.bt_sensor_state[28].limt1,           &System.bt_sensor_state_res[28].limt1,           sizeof(System.bt_sensor_state[28].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+5, "p31357", &System.bt_sensor_state[28].limb1,           &System.bt_sensor_state_res[28].limb1,           sizeof(System.bt_sensor_state[28].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+6, "p31358", &System.bt_sensor_state[28].limt2,           &System.bt_sensor_state_res[28].limt2,           sizeof(System.bt_sensor_state[28].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+7, "p31359", &System.bt_sensor_state[28].limb2,           &System.bt_sensor_state_res[28].limb2,           sizeof(System.bt_sensor_state[28].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*18+8, "p31360", &System.bt_sensor_state[28].t_meas,          &System.bt_sensor_state_res[28].t_meas,          sizeof(System.bt_sensor_state[28].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*18+9, "p31361", &System.bt_sensor_state[28].timer_k,         &System.bt_sensor_state_res[28].timer_k,         sizeof(System.bt_sensor_state[28].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*18+10,"p31362", &System.bt_sensor_state[28].battery,         &System.bt_sensor_state_res[28].battery,         sizeof(System.bt_sensor_state[28].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 29)
  {BASE_STATION_BT+4+15*10+11*19+0, "p31363", &System.bt_sensor_state[29].u64_sensor,     &System.bt_sensor_state_res[29].u64_sensor,     sizeof(System.bt_sensor_state[29].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+1, "p31364", &System.bt_sensor_state[29].timestamp,       &System.bt_sensor_state_res[29].timestamp,       sizeof(System.bt_sensor_state[29].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*19+2, "p31365", &System.bt_sensor_state[29].data[0],         &System.bt_sensor_state_res[29].data[0],         sizeof(System.bt_sensor_state[29].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+3, "p31366", &System.bt_sensor_state[29].data[1],         &System.bt_sensor_state_res[29].data[1],         sizeof(System.bt_sensor_state[29].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+4, "p31367", &System.bt_sensor_state[29].limt1,           &System.bt_sensor_state_res[29].limt1,           sizeof(System.bt_sensor_state[29].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+5, "p31368", &System.bt_sensor_state[29].limb1,           &System.bt_sensor_state_res[29].limb1,           sizeof(System.bt_sensor_state[29].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+6, "p31369", &System.bt_sensor_state[29].limt2,           &System.bt_sensor_state_res[29].limt2,           sizeof(System.bt_sensor_state[29].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+7, "p31370", &System.bt_sensor_state[29].limb2,           &System.bt_sensor_state_res[29].limb2,           sizeof(System.bt_sensor_state[29].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*19+8, "p31371", &System.bt_sensor_state[29].t_meas,          &System.bt_sensor_state_res[29].t_meas,          sizeof(System.bt_sensor_state[29].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*19+9, "p31372", &System.bt_sensor_state[29].timer_k,         &System.bt_sensor_state_res[29].timer_k,         sizeof(System.bt_sensor_state[29].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*19+10,"p31373", &System.bt_sensor_state[29].battery,         &System.bt_sensor_state_res[29].battery,         sizeof(System.bt_sensor_state[29].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 30)
  {BASE_STATION_BT+4+15*10+11*20+0, "p31374", &System.bt_sensor_state[30].u64_sensor,     &System.bt_sensor_state_res[30].u64_sensor,     sizeof(System.bt_sensor_state[30].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+1, "p31375", &System.bt_sensor_state[30].timestamp,       &System.bt_sensor_state_res[30].timestamp,       sizeof(System.bt_sensor_state[30].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*20+2, "p31376", &System.bt_sensor_state[30].data[0],         &System.bt_sensor_state_res[30].data[0],         sizeof(System.bt_sensor_state[30].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+3, "p31377", &System.bt_sensor_state[30].data[1],         &System.bt_sensor_state_res[30].data[1],         sizeof(System.bt_sensor_state[30].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+4, "p31378", &System.bt_sensor_state[30].limt1,           &System.bt_sensor_state_res[30].limt1,           sizeof(System.bt_sensor_state[30].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+5, "p31379", &System.bt_sensor_state[30].limb1,           &System.bt_sensor_state_res[30].limb1,           sizeof(System.bt_sensor_state[30].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+6, "p31380", &System.bt_sensor_state[30].limt2,           &System.bt_sensor_state_res[30].limt2,           sizeof(System.bt_sensor_state[30].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+7, "p31381", &System.bt_sensor_state[30].limb2,           &System.bt_sensor_state_res[30].limb2,           sizeof(System.bt_sensor_state[30].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*20+8, "p31382", &System.bt_sensor_state[30].t_meas,          &System.bt_sensor_state_res[30].t_meas,          sizeof(System.bt_sensor_state[30].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*20+9, "p31383", &System.bt_sensor_state[30].timer_k,         &System.bt_sensor_state_res[30].timer_k,         sizeof(System.bt_sensor_state[30].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*20+10,"p31384", &System.bt_sensor_state[30].battery,         &System.bt_sensor_state_res[30].battery,         sizeof(System.bt_sensor_state[30].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 31)
  {BASE_STATION_BT+4+15*10+11*21+0, "p31385", &System.bt_sensor_state[31].u64_sensor,     &System.bt_sensor_state_res[31].u64_sensor,     sizeof(System.bt_sensor_state[31].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+1, "p31386", &System.bt_sensor_state[31].timestamp,       &System.bt_sensor_state_res[31].timestamp,       sizeof(System.bt_sensor_state[31].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*21+2, "p31387", &System.bt_sensor_state[31].data[0],         &System.bt_sensor_state_res[31].data[0],         sizeof(System.bt_sensor_state[31].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+3, "p31388", &System.bt_sensor_state[31].data[1],         &System.bt_sensor_state_res[31].data[1],         sizeof(System.bt_sensor_state[31].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+4, "p31389", &System.bt_sensor_state[31].limt1,           &System.bt_sensor_state_res[31].limt1,           sizeof(System.bt_sensor_state[31].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+5, "p31390", &System.bt_sensor_state[31].limb1,           &System.bt_sensor_state_res[31].limb1,           sizeof(System.bt_sensor_state[31].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+6, "p31391", &System.bt_sensor_state[31].limt2,           &System.bt_sensor_state_res[31].limt2,           sizeof(System.bt_sensor_state[31].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+7, "p31392", &System.bt_sensor_state[31].limb2,           &System.bt_sensor_state_res[31].limb2,           sizeof(System.bt_sensor_state[31].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*21+8, "p31393", &System.bt_sensor_state[31].t_meas,          &System.bt_sensor_state_res[31].t_meas,          sizeof(System.bt_sensor_state[31].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*21+9, "p31394", &System.bt_sensor_state[31].timer_k,         &System.bt_sensor_state_res[31].timer_k,         sizeof(System.bt_sensor_state[31].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*21+10,"p31395", &System.bt_sensor_state[31].battery,         &System.bt_sensor_state_res[31].battery,         sizeof(System.bt_sensor_state[31].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 32)
  {BASE_STATION_BT+4+15*10+11*22+0, "p31396", &System.bt_sensor_state[32].u64_sensor,     &System.bt_sensor_state_res[32].u64_sensor,     sizeof(System.bt_sensor_state[32].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+1, "p31397", &System.bt_sensor_state[32].timestamp,       &System.bt_sensor_state_res[32].timestamp,       sizeof(System.bt_sensor_state[32].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*22+2, "p31398", &System.bt_sensor_state[32].data[0],         &System.bt_sensor_state_res[32].data[0],         sizeof(System.bt_sensor_state[32].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+3, "p31399", &System.bt_sensor_state[32].data[1],         &System.bt_sensor_state_res[32].data[1],         sizeof(System.bt_sensor_state[32].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+4, "p31400", &System.bt_sensor_state[32].limt1,           &System.bt_sensor_state_res[32].limt1,           sizeof(System.bt_sensor_state[32].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+5, "p31401", &System.bt_sensor_state[32].limb1,           &System.bt_sensor_state_res[32].limb1,           sizeof(System.bt_sensor_state[32].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+6, "p31402", &System.bt_sensor_state[32].limt2,           &System.bt_sensor_state_res[32].limt2,           sizeof(System.bt_sensor_state[32].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+7, "p31403", &System.bt_sensor_state[32].limb2,           &System.bt_sensor_state_res[32].limb2,           sizeof(System.bt_sensor_state[32].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*22+8, "p31404", &System.bt_sensor_state[32].t_meas,          &System.bt_sensor_state_res[32].t_meas,          sizeof(System.bt_sensor_state[32].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*22+9, "p31405", &System.bt_sensor_state[32].timer_k,         &System.bt_sensor_state_res[32].timer_k,         sizeof(System.bt_sensor_state[32].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*22+10,"p31406", &System.bt_sensor_state[32].battery,         &System.bt_sensor_state_res[32].battery,         sizeof(System.bt_sensor_state[32].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 33)
  {BASE_STATION_BT+4+15*10+11*23+0, "p31407", &System.bt_sensor_state[33].u64_sensor,     &System.bt_sensor_state_res[33].u64_sensor,     sizeof(System.bt_sensor_state[33].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+1, "p31408", &System.bt_sensor_state[33].timestamp,       &System.bt_sensor_state_res[33].timestamp,       sizeof(System.bt_sensor_state[33].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*23+2, "p31409", &System.bt_sensor_state[33].data[0],         &System.bt_sensor_state_res[33].data[0],         sizeof(System.bt_sensor_state[33].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+3, "p31410", &System.bt_sensor_state[33].data[1],         &System.bt_sensor_state_res[33].data[1],         sizeof(System.bt_sensor_state[33].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+4, "p31411", &System.bt_sensor_state[33].limt1,           &System.bt_sensor_state_res[33].limt1,           sizeof(System.bt_sensor_state[33].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+5, "p31412", &System.bt_sensor_state[33].limb1,           &System.bt_sensor_state_res[33].limb1,           sizeof(System.bt_sensor_state[33].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+6, "p31413", &System.bt_sensor_state[33].limt2,           &System.bt_sensor_state_res[33].limt2,           sizeof(System.bt_sensor_state[33].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+7, "p31414", &System.bt_sensor_state[33].limb2,           &System.bt_sensor_state_res[33].limb2,           sizeof(System.bt_sensor_state[33].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*23+8, "p31415", &System.bt_sensor_state[33].t_meas,          &System.bt_sensor_state_res[33].t_meas,          sizeof(System.bt_sensor_state[33].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*23+9, "p31416", &System.bt_sensor_state[33].timer_k,         &System.bt_sensor_state_res[33].timer_k,         sizeof(System.bt_sensor_state[33].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*23+10,"p31417", &System.bt_sensor_state[33].battery,         &System.bt_sensor_state_res[33].battery,         sizeof(System.bt_sensor_state[33].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 34)
  {BASE_STATION_BT+4+15*10+11*24+0, "p31418", &System.bt_sensor_state[34].u64_sensor,     &System.bt_sensor_state_res[34].u64_sensor,     sizeof(System.bt_sensor_state[34].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+1, "p31419", &System.bt_sensor_state[34].timestamp,       &System.bt_sensor_state_res[34].timestamp,       sizeof(System.bt_sensor_state[34].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*24+2, "p31420", &System.bt_sensor_state[34].data[0],         &System.bt_sensor_state_res[34].data[0],         sizeof(System.bt_sensor_state[34].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+3, "p31421", &System.bt_sensor_state[34].data[1],         &System.bt_sensor_state_res[34].data[1],         sizeof(System.bt_sensor_state[34].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+4, "p31422", &System.bt_sensor_state[34].limt1,           &System.bt_sensor_state_res[34].limt1,           sizeof(System.bt_sensor_state[34].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+5, "p31423", &System.bt_sensor_state[34].limb1,           &System.bt_sensor_state_res[34].limb1,           sizeof(System.bt_sensor_state[34].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+6, "p31424", &System.bt_sensor_state[34].limt2,           &System.bt_sensor_state_res[34].limt2,           sizeof(System.bt_sensor_state[34].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+7, "p31425", &System.bt_sensor_state[34].limb2,           &System.bt_sensor_state_res[34].limb2,           sizeof(System.bt_sensor_state[34].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*24+8, "p31426", &System.bt_sensor_state[34].t_meas,          &System.bt_sensor_state_res[34].t_meas,          sizeof(System.bt_sensor_state[34].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*24+9, "p31427", &System.bt_sensor_state[34].timer_k,         &System.bt_sensor_state_res[34].timer_k,         sizeof(System.bt_sensor_state[34].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*24+10,"p31428", &System.bt_sensor_state[34].battery,         &System.bt_sensor_state_res[34].battery,         sizeof(System.bt_sensor_state[34].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 35)
  {BASE_STATION_BT+4+15*10+11*25+0, "p31429", &System.bt_sensor_state[35].u64_sensor,     &System.bt_sensor_state_res[35].u64_sensor,     sizeof(System.bt_sensor_state[35].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+1, "p31430", &System.bt_sensor_state[35].timestamp,       &System.bt_sensor_state_res[35].timestamp,       sizeof(System.bt_sensor_state[35].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*25+2, "p31431", &System.bt_sensor_state[35].data[0],         &System.bt_sensor_state_res[35].data[0],         sizeof(System.bt_sensor_state[35].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+3, "p31432", &System.bt_sensor_state[35].data[1],         &System.bt_sensor_state_res[35].data[1],         sizeof(System.bt_sensor_state[35].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+4, "p31433", &System.bt_sensor_state[35].limt1,           &System.bt_sensor_state_res[35].limt1,           sizeof(System.bt_sensor_state[35].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+5, "p31434", &System.bt_sensor_state[35].limb1,           &System.bt_sensor_state_res[35].limb1,           sizeof(System.bt_sensor_state[35].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+6, "p31435", &System.bt_sensor_state[35].limt2,           &System.bt_sensor_state_res[35].limt2,           sizeof(System.bt_sensor_state[35].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+7, "p31436", &System.bt_sensor_state[35].limb2,           &System.bt_sensor_state_res[35].limb2,           sizeof(System.bt_sensor_state[35].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*25+8, "p31437", &System.bt_sensor_state[35].t_meas,          &System.bt_sensor_state_res[35].t_meas,          sizeof(System.bt_sensor_state[35].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*25+9, "p31438", &System.bt_sensor_state[35].timer_k,         &System.bt_sensor_state_res[35].timer_k,         sizeof(System.bt_sensor_state[35].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*25+10,"p31439", &System.bt_sensor_state[35].battery,         &System.bt_sensor_state_res[35].battery,         sizeof(System.bt_sensor_state[35].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 36)
  {BASE_STATION_BT+4+15*10+11*26+0, "p31440", &System.bt_sensor_state[36].u64_sensor,     &System.bt_sensor_state_res[36].u64_sensor,     sizeof(System.bt_sensor_state[36].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+1, "p31441", &System.bt_sensor_state[36].timestamp,       &System.bt_sensor_state_res[36].timestamp,       sizeof(System.bt_sensor_state[36].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*26+2, "p31442", &System.bt_sensor_state[36].data[0],         &System.bt_sensor_state_res[36].data[0],         sizeof(System.bt_sensor_state[36].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+3, "p31443", &System.bt_sensor_state[36].data[1],         &System.bt_sensor_state_res[36].data[1],         sizeof(System.bt_sensor_state[36].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+4, "p31444", &System.bt_sensor_state[36].limt1,           &System.bt_sensor_state_res[36].limt1,           sizeof(System.bt_sensor_state[36].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+5, "p31445", &System.bt_sensor_state[36].limb1,           &System.bt_sensor_state_res[36].limb1,           sizeof(System.bt_sensor_state[36].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+6, "p31446", &System.bt_sensor_state[36].limt2,           &System.bt_sensor_state_res[36].limt2,           sizeof(System.bt_sensor_state[36].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+7, "p31447", &System.bt_sensor_state[36].limb2,           &System.bt_sensor_state_res[36].limb2,           sizeof(System.bt_sensor_state[36].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*26+8, "p31448", &System.bt_sensor_state[36].t_meas,          &System.bt_sensor_state_res[36].t_meas,          sizeof(System.bt_sensor_state[36].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*26+9, "p31449", &System.bt_sensor_state[36].timer_k,         &System.bt_sensor_state_res[36].timer_k,         sizeof(System.bt_sensor_state[36].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*26+10,"p31450", &System.bt_sensor_state[36].battery,         &System.bt_sensor_state_res[36].battery,         sizeof(System.bt_sensor_state[36].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 37)
  {BASE_STATION_BT+4+15*10+11*27+0, "p31451", &System.bt_sensor_state[37].u64_sensor,     &System.bt_sensor_state_res[37].u64_sensor,     sizeof(System.bt_sensor_state[37].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+1, "p31452", &System.bt_sensor_state[37].timestamp,       &System.bt_sensor_state_res[37].timestamp,       sizeof(System.bt_sensor_state[37].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*27+2, "p31453", &System.bt_sensor_state[37].data[0],         &System.bt_sensor_state_res[37].data[0],         sizeof(System.bt_sensor_state[37].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+3, "p31454", &System.bt_sensor_state[37].data[1],         &System.bt_sensor_state_res[37].data[1],         sizeof(System.bt_sensor_state[37].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+4, "p31455", &System.bt_sensor_state[37].limt1,           &System.bt_sensor_state_res[37].limt1,           sizeof(System.bt_sensor_state[37].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+5, "p31456", &System.bt_sensor_state[37].limb1,           &System.bt_sensor_state_res[37].limb1,           sizeof(System.bt_sensor_state[37].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+6, "p31457", &System.bt_sensor_state[37].limt2,           &System.bt_sensor_state_res[37].limt2,           sizeof(System.bt_sensor_state[37].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+7, "p31458", &System.bt_sensor_state[37].limb2,           &System.bt_sensor_state_res[37].limb2,           sizeof(System.bt_sensor_state[37].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*27+8, "p31459", &System.bt_sensor_state[37].t_meas,          &System.bt_sensor_state_res[37].t_meas,          sizeof(System.bt_sensor_state[37].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*27+9, "p31460", &System.bt_sensor_state[37].timer_k,         &System.bt_sensor_state_res[37].timer_k,         sizeof(System.bt_sensor_state[37].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*27+10,"p31461", &System.bt_sensor_state[37].battery,         &System.bt_sensor_state_res[37].battery,         sizeof(System.bt_sensor_state[37].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 38)
  {BASE_STATION_BT+4+15*10+11*28+0, "p31462", &System.bt_sensor_state[38].u64_sensor,     &System.bt_sensor_state_res[38].u64_sensor,     sizeof(System.bt_sensor_state[38].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+1, "p31463", &System.bt_sensor_state[38].timestamp,       &System.bt_sensor_state_res[38].timestamp,       sizeof(System.bt_sensor_state[38].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*28+2, "p31464", &System.bt_sensor_state[38].data[0],         &System.bt_sensor_state_res[38].data[0],         sizeof(System.bt_sensor_state[38].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+3, "p31465", &System.bt_sensor_state[38].data[1],         &System.bt_sensor_state_res[38].data[1],         sizeof(System.bt_sensor_state[38].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+4, "p31466", &System.bt_sensor_state[38].limt1,           &System.bt_sensor_state_res[38].limt1,           sizeof(System.bt_sensor_state[38].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+5, "p31467", &System.bt_sensor_state[38].limb1,           &System.bt_sensor_state_res[38].limb1,           sizeof(System.bt_sensor_state[38].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+6, "p31468", &System.bt_sensor_state[38].limt2,           &System.bt_sensor_state_res[38].limt2,           sizeof(System.bt_sensor_state[38].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+7, "p31469", &System.bt_sensor_state[38].limb2,           &System.bt_sensor_state_res[38].limb2,           sizeof(System.bt_sensor_state[38].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*28+8, "p31470", &System.bt_sensor_state[38].t_meas,          &System.bt_sensor_state_res[38].t_meas,          sizeof(System.bt_sensor_state[38].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*28+9, "p31471", &System.bt_sensor_state[38].timer_k,         &System.bt_sensor_state_res[38].timer_k,         sizeof(System.bt_sensor_state[38].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*28+10,"p31472", &System.bt_sensor_state[38].battery,         &System.bt_sensor_state_res[38].battery,         sizeof(System.bt_sensor_state[38].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 39)
  {BASE_STATION_BT+4+15*10+11*29+0, "p31473", &System.bt_sensor_state[39].u64_sensor,     &System.bt_sensor_state_res[39].u64_sensor,     sizeof(System.bt_sensor_state[39].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+1, "p31474", &System.bt_sensor_state[39].timestamp,       &System.bt_sensor_state_res[39].timestamp,       sizeof(System.bt_sensor_state[39].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*29+2, "p31475", &System.bt_sensor_state[39].data[0],         &System.bt_sensor_state_res[39].data[0],         sizeof(System.bt_sensor_state[39].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+3, "p31476", &System.bt_sensor_state[39].data[1],         &System.bt_sensor_state_res[39].data[1],         sizeof(System.bt_sensor_state[39].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+4, "p31477", &System.bt_sensor_state[39].limt1,           &System.bt_sensor_state_res[39].limt1,           sizeof(System.bt_sensor_state[39].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+5, "p31478", &System.bt_sensor_state[39].limb1,           &System.bt_sensor_state_res[39].limb1,           sizeof(System.bt_sensor_state[39].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+6, "p31479", &System.bt_sensor_state[39].limt2,           &System.bt_sensor_state_res[39].limt2,           sizeof(System.bt_sensor_state[39].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+7, "p31480", &System.bt_sensor_state[39].limb2,           &System.bt_sensor_state_res[39].limb2,           sizeof(System.bt_sensor_state[39].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*29+8, "p31481", &System.bt_sensor_state[39].t_meas,          &System.bt_sensor_state_res[39].t_meas,          sizeof(System.bt_sensor_state[39].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*29+9, "p31482", &System.bt_sensor_state[39].timer_k,         &System.bt_sensor_state_res[39].timer_k,         sizeof(System.bt_sensor_state[39].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*29+10,"p31483", &System.bt_sensor_state[39].battery,         &System.bt_sensor_state_res[39].battery,         sizeof(System.bt_sensor_state[39].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 40)
  {BASE_STATION_BT+4+15*10+11*30+0, "p31484", &System.bt_sensor_state[40].u64_sensor,     &System.bt_sensor_state_res[40].u64_sensor,     sizeof(System.bt_sensor_state[40].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+1, "p31485", &System.bt_sensor_state[40].timestamp,       &System.bt_sensor_state_res[40].timestamp,       sizeof(System.bt_sensor_state[40].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*30+2, "p31486", &System.bt_sensor_state[40].data[0],         &System.bt_sensor_state_res[40].data[0],         sizeof(System.bt_sensor_state[40].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+3, "p31487", &System.bt_sensor_state[40].data[1],         &System.bt_sensor_state_res[40].data[1],         sizeof(System.bt_sensor_state[40].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+4, "p31488", &System.bt_sensor_state[40].limt1,           &System.bt_sensor_state_res[40].limt1,           sizeof(System.bt_sensor_state[40].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+5, "p31489", &System.bt_sensor_state[40].limb1,           &System.bt_sensor_state_res[40].limb1,           sizeof(System.bt_sensor_state[40].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+6, "p31490", &System.bt_sensor_state[40].limt2,           &System.bt_sensor_state_res[40].limt2,           sizeof(System.bt_sensor_state[40].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+7, "p31491", &System.bt_sensor_state[40].limb2,           &System.bt_sensor_state_res[40].limb2,           sizeof(System.bt_sensor_state[40].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*30+8, "p31492", &System.bt_sensor_state[40].t_meas,          &System.bt_sensor_state_res[40].t_meas,          sizeof(System.bt_sensor_state[40].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*30+9, "p31493", &System.bt_sensor_state[40].timer_k,         &System.bt_sensor_state_res[40].timer_k,         sizeof(System.bt_sensor_state[40].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*30+10,"p31494", &System.bt_sensor_state[40].battery,         &System.bt_sensor_state_res[40].battery,         sizeof(System.bt_sensor_state[40].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 41)
  {BASE_STATION_BT+4+15*10+11*31+0, "p31495", &System.bt_sensor_state[41].u64_sensor,     &System.bt_sensor_state_res[41].u64_sensor,     sizeof(System.bt_sensor_state[41].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+1, "p31496", &System.bt_sensor_state[41].timestamp,       &System.bt_sensor_state_res[41].timestamp,       sizeof(System.bt_sensor_state[41].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*31+2, "p31497", &System.bt_sensor_state[41].data[0],         &System.bt_sensor_state_res[41].data[0],         sizeof(System.bt_sensor_state[41].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+3, "p31498", &System.bt_sensor_state[41].data[1],         &System.bt_sensor_state_res[41].data[1],         sizeof(System.bt_sensor_state[41].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+4, "p31499", &System.bt_sensor_state[41].limt1,           &System.bt_sensor_state_res[41].limt1,           sizeof(System.bt_sensor_state[41].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+5, "p31500", &System.bt_sensor_state[41].limb1,           &System.bt_sensor_state_res[41].limb1,           sizeof(System.bt_sensor_state[41].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+6, "p31501", &System.bt_sensor_state[41].limt2,           &System.bt_sensor_state_res[41].limt2,           sizeof(System.bt_sensor_state[41].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+7, "p31502", &System.bt_sensor_state[41].limb2,           &System.bt_sensor_state_res[41].limb2,           sizeof(System.bt_sensor_state[41].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*31+8, "p31503", &System.bt_sensor_state[41].t_meas,          &System.bt_sensor_state_res[41].t_meas,          sizeof(System.bt_sensor_state[41].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*31+9, "p31504", &System.bt_sensor_state[41].timer_k,         &System.bt_sensor_state_res[41].timer_k,         sizeof(System.bt_sensor_state[41].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*31+10,"p31505", &System.bt_sensor_state[41].battery,         &System.bt_sensor_state_res[41].battery,         sizeof(System.bt_sensor_state[41].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 42)
  {BASE_STATION_BT+4+15*10+11*32+0, "p31506", &System.bt_sensor_state[42].u64_sensor,     &System.bt_sensor_state_res[42].u64_sensor,     sizeof(System.bt_sensor_state[42].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+1, "p31507", &System.bt_sensor_state[42].timestamp,       &System.bt_sensor_state_res[42].timestamp,       sizeof(System.bt_sensor_state[42].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*32+2, "p31508", &System.bt_sensor_state[42].data[0],         &System.bt_sensor_state_res[42].data[0],         sizeof(System.bt_sensor_state[42].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+3, "p31509", &System.bt_sensor_state[42].data[1],         &System.bt_sensor_state_res[42].data[1],         sizeof(System.bt_sensor_state[42].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+4, "p31510", &System.bt_sensor_state[42].limt1,           &System.bt_sensor_state_res[42].limt1,           sizeof(System.bt_sensor_state[42].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+5, "p31511", &System.bt_sensor_state[42].limb1,           &System.bt_sensor_state_res[42].limb1,           sizeof(System.bt_sensor_state[42].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+6, "p31512", &System.bt_sensor_state[42].limt2,           &System.bt_sensor_state_res[42].limt2,           sizeof(System.bt_sensor_state[42].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+7, "p31513", &System.bt_sensor_state[42].limb2,           &System.bt_sensor_state_res[42].limb2,           sizeof(System.bt_sensor_state[42].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*32+8, "p31514", &System.bt_sensor_state[42].t_meas,          &System.bt_sensor_state_res[42].t_meas,          sizeof(System.bt_sensor_state[42].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*32+9, "p31515", &System.bt_sensor_state[42].timer_k,         &System.bt_sensor_state_res[42].timer_k,         sizeof(System.bt_sensor_state[42].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*32+10,"p31516", &System.bt_sensor_state[42].battery,         &System.bt_sensor_state_res[42].battery,         sizeof(System.bt_sensor_state[42].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 43)
  {BASE_STATION_BT+4+15*10+11*33+0, "p31517", &System.bt_sensor_state[43].u64_sensor,     &System.bt_sensor_state_res[43].u64_sensor,     sizeof(System.bt_sensor_state[43].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+1, "p31518", &System.bt_sensor_state[43].timestamp,       &System.bt_sensor_state_res[43].timestamp,       sizeof(System.bt_sensor_state[43].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*33+2, "p31519", &System.bt_sensor_state[43].data[0],         &System.bt_sensor_state_res[43].data[0],         sizeof(System.bt_sensor_state[43].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+3, "p31520", &System.bt_sensor_state[43].data[1],         &System.bt_sensor_state_res[43].data[1],         sizeof(System.bt_sensor_state[43].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+4, "p31521", &System.bt_sensor_state[43].limt1,           &System.bt_sensor_state_res[43].limt1,           sizeof(System.bt_sensor_state[43].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+5, "p31522", &System.bt_sensor_state[43].limb1,           &System.bt_sensor_state_res[43].limb1,           sizeof(System.bt_sensor_state[43].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+6, "p31523", &System.bt_sensor_state[43].limt2,           &System.bt_sensor_state_res[43].limt2,           sizeof(System.bt_sensor_state[43].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+7, "p31524", &System.bt_sensor_state[43].limb2,           &System.bt_sensor_state_res[43].limb2,           sizeof(System.bt_sensor_state[43].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*33+8, "p31525", &System.bt_sensor_state[43].t_meas,          &System.bt_sensor_state_res[43].t_meas,          sizeof(System.bt_sensor_state[43].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*33+9, "p31526", &System.bt_sensor_state[43].timer_k,         &System.bt_sensor_state_res[43].timer_k,         sizeof(System.bt_sensor_state[43].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*33+10,"p31527", &System.bt_sensor_state[43].battery,         &System.bt_sensor_state_res[43].battery,         sizeof(System.bt_sensor_state[43].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 44)
  {BASE_STATION_BT+4+15*10+11*34+0, "p31528", &System.bt_sensor_state[44].u64_sensor,     &System.bt_sensor_state_res[44].u64_sensor,     sizeof(System.bt_sensor_state[44].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+1, "p31529", &System.bt_sensor_state[44].timestamp,       &System.bt_sensor_state_res[44].timestamp,       sizeof(System.bt_sensor_state[44].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*34+2, "p31530", &System.bt_sensor_state[44].data[0],         &System.bt_sensor_state_res[44].data[0],         sizeof(System.bt_sensor_state[44].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+3, "p31531", &System.bt_sensor_state[44].data[1],         &System.bt_sensor_state_res[44].data[1],         sizeof(System.bt_sensor_state[44].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+4, "p31532", &System.bt_sensor_state[44].limt1,           &System.bt_sensor_state_res[44].limt1,           sizeof(System.bt_sensor_state[44].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+5, "p31533", &System.bt_sensor_state[44].limb1,           &System.bt_sensor_state_res[44].limb1,           sizeof(System.bt_sensor_state[44].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+6, "p31534", &System.bt_sensor_state[44].limt2,           &System.bt_sensor_state_res[44].limt2,           sizeof(System.bt_sensor_state[44].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+7, "p31535", &System.bt_sensor_state[44].limb2,           &System.bt_sensor_state_res[44].limb2,           sizeof(System.bt_sensor_state[44].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*34+8, "p31536", &System.bt_sensor_state[44].t_meas,          &System.bt_sensor_state_res[44].t_meas,          sizeof(System.bt_sensor_state[44].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*34+9, "p31537", &System.bt_sensor_state[44].timer_k,         &System.bt_sensor_state_res[44].timer_k,         sizeof(System.bt_sensor_state[44].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*34+10,"p31538", &System.bt_sensor_state[44].battery,         &System.bt_sensor_state_res[44].battery,         sizeof(System.bt_sensor_state[44].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 45)
  {BASE_STATION_BT+4+15*10+11*35+0, "p31539", &System.bt_sensor_state[45].u64_sensor,     &System.bt_sensor_state_res[45].u64_sensor,     sizeof(System.bt_sensor_state[45].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+1, "p31540", &System.bt_sensor_state[45].timestamp,       &System.bt_sensor_state_res[45].timestamp,       sizeof(System.bt_sensor_state[45].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*35+2, "p31541", &System.bt_sensor_state[45].data[0],         &System.bt_sensor_state_res[45].data[0],         sizeof(System.bt_sensor_state[45].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+3, "p31542", &System.bt_sensor_state[45].data[1],         &System.bt_sensor_state_res[45].data[1],         sizeof(System.bt_sensor_state[45].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+4, "p31543", &System.bt_sensor_state[45].limt1,           &System.bt_sensor_state_res[45].limt1,           sizeof(System.bt_sensor_state[45].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+5, "p31544", &System.bt_sensor_state[45].limb1,           &System.bt_sensor_state_res[45].limb1,           sizeof(System.bt_sensor_state[45].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+6, "p31545", &System.bt_sensor_state[45].limt2,           &System.bt_sensor_state_res[45].limt2,           sizeof(System.bt_sensor_state[45].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+7, "p31546", &System.bt_sensor_state[45].limb2,           &System.bt_sensor_state_res[45].limb2,           sizeof(System.bt_sensor_state[45].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*35+8, "p31547", &System.bt_sensor_state[45].t_meas,          &System.bt_sensor_state_res[45].t_meas,          sizeof(System.bt_sensor_state[45].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*35+9, "p31548", &System.bt_sensor_state[45].timer_k,         &System.bt_sensor_state_res[45].timer_k,         sizeof(System.bt_sensor_state[45].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*35+10,"p31549", &System.bt_sensor_state[45].battery,         &System.bt_sensor_state_res[45].battery,         sizeof(System.bt_sensor_state[45].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 46)
  {BASE_STATION_BT+4+15*10+11*36+0, "p31550", &System.bt_sensor_state[46].u64_sensor,     &System.bt_sensor_state_res[46].u64_sensor,     sizeof(System.bt_sensor_state[46].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+1, "p31551", &System.bt_sensor_state[46].timestamp,       &System.bt_sensor_state_res[46].timestamp,       sizeof(System.bt_sensor_state[46].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*36+2, "p31552", &System.bt_sensor_state[46].data[0],         &System.bt_sensor_state_res[46].data[0],         sizeof(System.bt_sensor_state[46].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+3, "p31553", &System.bt_sensor_state[46].data[1],         &System.bt_sensor_state_res[46].data[1],         sizeof(System.bt_sensor_state[46].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+4, "p31554", &System.bt_sensor_state[46].limt1,           &System.bt_sensor_state_res[46].limt1,           sizeof(System.bt_sensor_state[46].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+5, "p31555", &System.bt_sensor_state[46].limb1,           &System.bt_sensor_state_res[46].limb1,           sizeof(System.bt_sensor_state[46].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+6, "p31556", &System.bt_sensor_state[46].limt2,           &System.bt_sensor_state_res[46].limt2,           sizeof(System.bt_sensor_state[46].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+7, "p31557", &System.bt_sensor_state[46].limb2,           &System.bt_sensor_state_res[46].limb2,           sizeof(System.bt_sensor_state[46].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*36+8, "p31558", &System.bt_sensor_state[46].t_meas,          &System.bt_sensor_state_res[46].t_meas,          sizeof(System.bt_sensor_state[46].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*36+9, "p31559", &System.bt_sensor_state[46].timer_k,         &System.bt_sensor_state_res[46].timer_k,         sizeof(System.bt_sensor_state[46].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*36+10,"p31560", &System.bt_sensor_state[46].battery,         &System.bt_sensor_state_res[46].battery,         sizeof(System.bt_sensor_state[46].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 47)
  {BASE_STATION_BT+4+15*10+11*37+0, "p31561", &System.bt_sensor_state[47].u64_sensor,     &System.bt_sensor_state_res[47].u64_sensor,     sizeof(System.bt_sensor_state[47].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+1, "p31562", &System.bt_sensor_state[47].timestamp,       &System.bt_sensor_state_res[47].timestamp,       sizeof(System.bt_sensor_state[47].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*37+2, "p31563", &System.bt_sensor_state[47].data[0],         &System.bt_sensor_state_res[47].data[0],         sizeof(System.bt_sensor_state[47].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+3, "p31564", &System.bt_sensor_state[47].data[1],         &System.bt_sensor_state_res[47].data[1],         sizeof(System.bt_sensor_state[47].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+4, "p31565", &System.bt_sensor_state[47].limt1,           &System.bt_sensor_state_res[47].limt1,           sizeof(System.bt_sensor_state[47].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+5, "p31566", &System.bt_sensor_state[47].limb1,           &System.bt_sensor_state_res[47].limb1,           sizeof(System.bt_sensor_state[47].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+6, "p31567", &System.bt_sensor_state[47].limt2,           &System.bt_sensor_state_res[47].limt2,           sizeof(System.bt_sensor_state[47].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+7, "p31568", &System.bt_sensor_state[47].limb2,           &System.bt_sensor_state_res[47].limb2,           sizeof(System.bt_sensor_state[47].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*37+8, "p31569", &System.bt_sensor_state[47].t_meas,          &System.bt_sensor_state_res[47].t_meas,          sizeof(System.bt_sensor_state[47].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*37+9, "p31570", &System.bt_sensor_state[47].timer_k,         &System.bt_sensor_state_res[47].timer_k,         sizeof(System.bt_sensor_state[47].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*37+10,"p31571", &System.bt_sensor_state[47].battery,         &System.bt_sensor_state_res[47].battery,         sizeof(System.bt_sensor_state[47].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 48)
  {BASE_STATION_BT+4+15*10+11*38+0, "p31572", &System.bt_sensor_state[48].u64_sensor,     &System.bt_sensor_state_res[48].u64_sensor,     sizeof(System.bt_sensor_state[48].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+1, "p31573", &System.bt_sensor_state[48].timestamp,       &System.bt_sensor_state_res[48].timestamp,       sizeof(System.bt_sensor_state[48].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*38+2, "p31574", &System.bt_sensor_state[48].data[0],         &System.bt_sensor_state_res[48].data[0],         sizeof(System.bt_sensor_state[48].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+3, "p31575", &System.bt_sensor_state[48].data[1],         &System.bt_sensor_state_res[48].data[1],         sizeof(System.bt_sensor_state[48].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+4, "p31576", &System.bt_sensor_state[48].limt1,           &System.bt_sensor_state_res[48].limt1,           sizeof(System.bt_sensor_state[48].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+5, "p31577", &System.bt_sensor_state[48].limb1,           &System.bt_sensor_state_res[48].limb1,           sizeof(System.bt_sensor_state[48].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+6, "p31578", &System.bt_sensor_state[48].limt2,           &System.bt_sensor_state_res[48].limt2,           sizeof(System.bt_sensor_state[48].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+7, "p31579", &System.bt_sensor_state[48].limb2,           &System.bt_sensor_state_res[48].limb2,           sizeof(System.bt_sensor_state[48].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*38+8, "p31580", &System.bt_sensor_state[48].t_meas,          &System.bt_sensor_state_res[48].t_meas,          sizeof(System.bt_sensor_state[48].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*38+9, "p31581", &System.bt_sensor_state[48].timer_k,         &System.bt_sensor_state_res[48].timer_k,         sizeof(System.bt_sensor_state[48].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*38+10,"p31582", &System.bt_sensor_state[48].battery,         &System.bt_sensor_state_res[48].battery,         sizeof(System.bt_sensor_state[48].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 49)
  {BASE_STATION_BT+4+15*10+11*39+0, "p31583", &System.bt_sensor_state[49].u64_sensor,     &System.bt_sensor_state_res[49].u64_sensor,     sizeof(System.bt_sensor_state[49].u64_sensor),     UINT64_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+1, "p31584", &System.bt_sensor_state[49].timestamp,       &System.bt_sensor_state_res[49].timestamp,       sizeof(System.bt_sensor_state[49].timestamp),       UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*39+2, "p31585", &System.bt_sensor_state[49].data[0],         &System.bt_sensor_state_res[49].data[0],         sizeof(System.bt_sensor_state[49].data[0]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+3, "p31586", &System.bt_sensor_state[49].data[1],         &System.bt_sensor_state_res[49].data[1],         sizeof(System.bt_sensor_state[49].data[1]),         FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+4, "p31587", &System.bt_sensor_state[49].limt1,           &System.bt_sensor_state_res[49].limt1,           sizeof(System.bt_sensor_state[49].limt1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+5, "p31588", &System.bt_sensor_state[49].limb1,           &System.bt_sensor_state_res[49].limb1,           sizeof(System.bt_sensor_state[49].limb1),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+6, "p31589", &System.bt_sensor_state[49].limt2,           &System.bt_sensor_state_res[49].limt2,           sizeof(System.bt_sensor_state[49].limt2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+7, "p31590", &System.bt_sensor_state[49].limb2,           &System.bt_sensor_state_res[49].limb2,           sizeof(System.bt_sensor_state[49].limb2),           FLOAT_SYSTEM_T, 0xffff},
  {BASE_STATION_BT+4+15*10+11*39+8, "p31591", &System.bt_sensor_state[49].t_meas,          &System.bt_sensor_state_res[49].t_meas,          sizeof(System.bt_sensor_state[49].t_meas),          UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*39+9, "p31592", &System.bt_sensor_state[49].timer_k,         &System.bt_sensor_state_res[49].timer_k,         sizeof(System.bt_sensor_state[49].timer_k),         UINT32_SYSTEM_T,0xffff},
  {BASE_STATION_BT+4+15*10+11*39+10,"p31593", &System.bt_sensor_state[49].battery,         &System.bt_sensor_state_res[49].battery,         sizeof(System.bt_sensor_state[49].battery),         UINT16_SYSTEM_T,0xffff},
#endif
#if (MAX_BT_SENSORS > 50)
#error Нужно добавить сюда bt_sensors
#endif
#endif //defined(BASE_STATION_BT_PRESENT)

#if defined(NRF_BEACONS_SCANNER_PRESENT)
//вторая часть nrf биконов
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 7)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF8 , "nrf_vbf8"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[7],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[7],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[7]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF8 , "nrf_bbf8"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[7],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[7],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[7]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 8)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF9 , "nrf_vbf9"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[8],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[8],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[8]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF9 , "nrf_bbf9"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[8],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[8],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[8]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 9)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF10 , "nrf_vbf10"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[9],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[9],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[9]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF10 , "nrf_bbf10"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[9],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[9],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[9]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 10)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF11 , "nrf_vbf11"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[10],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[10],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[10]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF11 , "nrf_bbf11"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[10],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[10],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[10]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 11)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF12 , "nrf_vbf12"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[11],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[11],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[11]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF12 , "nrf_bbf12"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[11],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[11],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[11]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 12)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF13 , "nrf_vbf13"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[12],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[12],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[12]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF13 , "nrf_bbf13"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[12],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[12],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[12]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 13)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF14 , "nrf_vbf14"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[13],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[13],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[13]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF14 , "nrf_bbf14"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[13],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[13],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[13]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 14)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF15 , "nrf_vbf15"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[14],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[14],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[14]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF15 , "nrf_bbf15"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[14],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[14],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[14]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 15)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF16 , "nrf_vbf16"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[15],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[15],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[15]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF16 , "nrf_bbf16"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[15],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[15],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[15]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 16)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF17 , "nrf_vbf17"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[16],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[16],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[16]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF17 , "nrf_bbf17"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[16],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[16],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[16]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 17)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF18 , "nrf_vbf18"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[17],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[17],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[17]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF18 , "nrf_bbf18"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[17],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[17],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[17]), UINT32_SYSTEM_T, 0xffff},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 18)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF19 , "nrf_vbf19"    , &System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[18],    &System.signal_state_res.nrf_beacons_scanner.visible_beacons_bitfield[18],     sizeof(System.signal_state.nrf_beacons_scanner.visible_beacons_bitfield[18]), UINT32_SYSTEM_T, 0xffff},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF19 , "nrf_bbf19"    , &System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[18],    &System.signal_state_res.nrf_beacons_scanner.battlow_beacons_bitfield[18],     sizeof(System.signal_state.nrf_beacons_scanner.battlow_beacons_bitfield[18]), UINT32_SYSTEM_T, 0xffff},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 19)
#error Нужно добавить NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF
#endif
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(RS_TACHO_PRESENT)
  {TACHO_COMMAND,                     __SNAME("p31699"), __SPTR(&System.tacho_state.command),                            &System.tacho_state.command,                                sizeof(System.tacho_state.command),                            UINT8_SYSTEM_T,  __EGTSN(0xFFFF)}, //основное поле и поле res совпадают

  {TACHO_COMMUNICATION_STATE,         __SNAME("p31700"), __SPTR(&System.tacho_state.comm_state_raw),                     &System.tacho_state_res.comm_state_raw,                     sizeof(System.tacho_state.comm_state_raw),                     UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_DATETIME,                    __SNAME("p31701"), __SPTR(&System.tacho_state.DateTime),                           &System.tacho_state_res.DateTime,                           sizeof(System.tacho_state.DateTime),                           UINT32_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_VRN,                         __SNAME("p31702"), __SPTR(&System.tacho_state.VRN),                                &System.tacho_state_res.VRN,                                sizeof(System.tacho_state.VRN),                                STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_VIN,                         __SNAME("p31703"), __SPTR(&System.tacho_state.VIN),                                &System.tacho_state_res.VIN,                                sizeof(System.tacho_state.VIN),                                STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_DISTANCE,                    __SNAME("p31704"), __SPTR(&System.tacho_state.Distance),                           &System.tacho_state_res.Distance,                           sizeof(System.tacho_state.Distance),                           UINT32_SYSTEM_T, __EGTSN(0xFFFF)},

  {TACHO_STATE_FLAGS,                 __SNAME("p31705"), __SPTR(&System.tacho_state.StateFlags),                         &System.tacho_state_res.StateFlags,                         sizeof(System.tacho_state.StateFlags),                         UINT16_SYSTEM_T, __EGTSN(0xFFFF)},

  {TACHO_CARD1_STATE,                 __SNAME("p31706"), __SPTR(&System.tacho_state.Driver_Info[0].CardState),           &System.tacho_state_res.Driver_Info[0].CardState,           sizeof(System.tacho_state.Driver_Info[0].CardState),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD1_TYPE,                  __SNAME("p31707"), __SPTR(&System.tacho_state.Driver_Info[0].CardType),            &System.tacho_state_res.Driver_Info[0].CardType,            sizeof(System.tacho_state.Driver_Info[0].CardType),            UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD1_ACTIVITY,              __SNAME("p31708"), __SPTR(&System.tacho_state.Driver_Info[0].Activity),            &System.tacho_state_res.Driver_Info[0].Activity,            sizeof(System.tacho_state.Driver_Info[0].Activity),            UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD1_NUMBER,                __SNAME("p31709"), __SPTR(&System.tacho_state.Driver_Info[0].CardNum),             &System.tacho_state_res.Driver_Info[0].CardNum,             sizeof(System.tacho_state.Driver_Info[0].CardNum),             STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD1_IDENT1,                __SNAME("p31710"), __SPTR(&System.tacho_state.Driver_Info[0].IdString[0]),         &System.tacho_state_res.Driver_Info[0].IdString[0],         sizeof(System.tacho_state.Driver_Info[0].IdString[0]),         STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD1_IDENT2,                __SNAME("p31711"), __SPTR(&System.tacho_state.Driver_Info[0].IdString[1]),         &System.tacho_state_res.Driver_Info[0].IdString[1],         sizeof(System.tacho_state.Driver_Info[0].IdString[1]),         STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD1_TIME_IN_CURRENT_MODE,  __SNAME("p31712"), __SPTR(&System.tacho_state.Driver_Info[0].TimeInCurrentMode),   &System.tacho_state_res.Driver_Info[0].TimeInCurrentMode,   sizeof(System.tacho_state.Driver_Info[0].TimeInCurrentMode),   UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD1_DRIVE_TIME_OF_DAY,     __SNAME("p31713"), __SPTR(&System.tacho_state.Driver_Info[0].DriveTimeOfDay),      &System.tacho_state_res.Driver_Info[0].DriveTimeOfDay,      sizeof(System.tacho_state.Driver_Info[0].DriveTimeOfDay),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD1_CONTINUIUS_DRIVE_TIME, __SNAME("p31714"), __SPTR(&System.tacho_state.Driver_Info[0].ContinuousDriveTime), &System.tacho_state_res.Driver_Info[0].ContinuousDriveTime, sizeof(System.tacho_state.Driver_Info[0].ContinuousDriveTime), UINT16_SYSTEM_T, __EGTSN(0xFFFF)},

  {TACHO_CARD2_STATE,                 __SNAME("p31715"), __SPTR(&System.tacho_state.Driver_Info[1].CardState),           &System.tacho_state_res.Driver_Info[1].CardState,           sizeof(System.tacho_state.Driver_Info[1].CardState),           UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD2_TYPE,                  __SNAME("p31716"), __SPTR(&System.tacho_state.Driver_Info[1].CardType),            &System.tacho_state_res.Driver_Info[1].CardType,            sizeof(System.tacho_state.Driver_Info[1].CardType),            UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD2_ACTIVITY,              __SNAME("p31717"), __SPTR(&System.tacho_state.Driver_Info[1].Activity),            &System.tacho_state_res.Driver_Info[1].Activity,            sizeof(System.tacho_state.Driver_Info[1].Activity),            UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
  {TACHO_CARD2_NUMBER,                __SNAME("p31718"), __SPTR(&System.tacho_state.Driver_Info[1].CardNum),             &System.tacho_state_res.Driver_Info[1].CardNum,             sizeof(System.tacho_state.Driver_Info[1].CardNum),             STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD2_IDENT1,                __SNAME("p31719"), __SPTR(&System.tacho_state.Driver_Info[1].IdString[0]),         &System.tacho_state_res.Driver_Info[1].IdString[0],         sizeof(System.tacho_state.Driver_Info[1].IdString[0]),         STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD2_IDENT2,                __SNAME("p31720"), __SPTR(&System.tacho_state.Driver_Info[1].IdString[1]),         &System.tacho_state_res.Driver_Info[1].IdString[1],         sizeof(System.tacho_state.Driver_Info[1].IdString[1]),         STRING_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD2_TIME_IN_CURRENT_MODE,  __SNAME("p31721"), __SPTR(&System.tacho_state.Driver_Info[1].TimeInCurrentMode),   &System.tacho_state_res.Driver_Info[1].TimeInCurrentMode,   sizeof(System.tacho_state.Driver_Info[1].TimeInCurrentMode),   UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD2_DRIVE_TIME_OF_DAY,     __SNAME("p31722"), __SPTR(&System.tacho_state.Driver_Info[1].DriveTimeOfDay),      &System.tacho_state_res.Driver_Info[1].DriveTimeOfDay,      sizeof(System.tacho_state.Driver_Info[1].DriveTimeOfDay),      UINT16_SYSTEM_T, __EGTSN(0xFFFF)},
  {TACHO_CARD2_CONTINUIUS_DRIVE_TIME, __SNAME("p31723"), __SPTR(&System.tacho_state.Driver_Info[1].ContinuousDriveTime), &System.tacho_state_res.Driver_Info[1].ContinuousDriveTime, sizeof(System.tacho_state.Driver_Info[1].ContinuousDriveTime), UINT16_SYSTEM_T, __EGTSN(0xFFFF)},

  {TACHO_CARD_UPLOAD_STATE,           __SNAME("p31724"), __SPTR(&System.tacho_state.file_upload_state),                  &System.tacho_state_res.file_upload_state,                  sizeof(System.tacho_state.file_upload_state),                  UINT8_SYSTEM_T,  __EGTSN(0xFFFF)},
#endif //defined(RS_TACHO_PRESENT)

#if defined(EXTERNAL_BLE_BOARD_PRESENT)
 {BLE_EXT_BOARD_COMMUNICATION_STATE, "p33000", &System.ext_board_ble_state.inteface_state, &System.ext_board_ble_state_res.inteface_state, sizeof(System.ext_board_ble_state.inteface_state), UINT8_SYSTEM_T, 0xffff},
 {BLE_EXT_BOARD_BOOT_VERS,           "p33001", &System.ext_board_ble_state.boot_vers, &System.ext_board_ble_state_res.boot_vers, sizeof(System.ext_board_ble_state.boot_vers), STRING_SYSTEM_T, 0xffff},
 {BLE_EXT_BOARD_APP_VERS,            "p33002", &System.ext_board_ble_state.app_vers, &System.ext_board_ble_state_res.app_vers, sizeof(System.ext_board_ble_state.app_vers), STRING_SYSTEM_T, 0xffff},
 {BLE_EXT_BOARD_MAC,                 "p33003", &System.ext_board_ble_state.board_mac.addr, &System.ext_board_ble_state_res.board_mac.addr, sizeof(System.ext_board_ble_state.board_mac.addr), ARRAY_SYSTEM_T, 0xffff},
 {BLE_EXT_BOARD_CONN_BLE_STATE,      "p33004", &System.ext_board_ble_state.ble_conn_status, &System.ext_board_ble_state.ble_conn_status, sizeof(System.ext_board_ble_state.ble_conn_status), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
 {BLE_EXT_BOARD_FW_UPD_PCT,          "p33005", &System.ext_board_ble_state.firmware_download_pct, &System.ext_board_ble_state_res.firmware_download_pct, sizeof(System.ext_board_ble_state.firmware_download_pct), UINT8_SYSTEM_T, 0xffff},
 {BLE_EXT_BOARD_VEGA_BLE_SESSION_SECURE_KEY, "p33007", &System.ext_board_ble_state.session_key, &System.ext_board_ble_state.session_key, sizeof(System.ext_board_ble_state.session_key), ARRAY_SYSTEM_T, 0xffff},

#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 0)
 {BLE_EXT_BOARD_BEACONS_INFO1, "p33016", &System.ext_board_ble_state.beacons_info[0], &System.ext_board_ble_state.beacons_info[0], sizeof(System.ext_board_ble_state.beacons_info[0]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 1)
 {BLE_EXT_BOARD_BEACONS_INFO2, "p33017", &System.ext_board_ble_state.beacons_info[1], &System.ext_board_ble_state.beacons_info[1], sizeof(System.ext_board_ble_state.beacons_info[1]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 2)
 {BLE_EXT_BOARD_BEACONS_INFO3, "p33018", &System.ext_board_ble_state.beacons_info[2], &System.ext_board_ble_state.beacons_info[2], sizeof(System.ext_board_ble_state.beacons_info[2]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 3)
 {BLE_EXT_BOARD_BEACONS_INFO4, "p33019", &System.ext_board_ble_state.beacons_info[3], &System.ext_board_ble_state.beacons_info[3], sizeof(System.ext_board_ble_state.beacons_info[3]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 4)
 {BLE_EXT_BOARD_BEACONS_INFO5, "p33020", &System.ext_board_ble_state.beacons_info[4], &System.ext_board_ble_state.beacons_info[4], sizeof(System.ext_board_ble_state.beacons_info[4]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 5)
 {BLE_EXT_BOARD_BEACONS_INFO6, "p33021", &System.ext_board_ble_state.beacons_info[5], &System.ext_board_ble_state.beacons_info[5], sizeof(System.ext_board_ble_state.beacons_info[5]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 6)
 {BLE_EXT_BOARD_BEACONS_INFO7, "p33022", &System.ext_board_ble_state.beacons_info[6], &System.ext_board_ble_state.beacons_info[6], sizeof(System.ext_board_ble_state.beacons_info[6]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 7)
 {BLE_EXT_BOARD_BEACONS_INFO8, "p33023", &System.ext_board_ble_state.beacons_info[7], &System.ext_board_ble_state.beacons_info[7], sizeof(System.ext_board_ble_state.beacons_info[7]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 8)
 {BLE_EXT_BOARD_BEACONS_INFO9, "p33024", &System.ext_board_ble_state.beacons_info[8], &System.ext_board_ble_state.beacons_info[8], sizeof(System.ext_board_ble_state.beacons_info[8]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 9)
 {BLE_EXT_BOARD_BEACONS_INFO10, "p33025", &System.ext_board_ble_state.beacons_info[9], &System.ext_board_ble_state.beacons_info[9], sizeof(System.ext_board_ble_state.beacons_info[9]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 10)
 {BLE_EXT_BOARD_BEACONS_INFO11, "p33026", &System.ext_board_ble_state.beacons_info[10], &System.ext_board_ble_state.beacons_info[10], sizeof(System.ext_board_ble_state.beacons_info[10]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 11)
 {BLE_EXT_BOARD_BEACONS_INFO12, "p33027", &System.ext_board_ble_state.beacons_info[11], &System.ext_board_ble_state.beacons_info[11], sizeof(System.ext_board_ble_state.beacons_info[11]), ARRAY_SYSTEM_T, 0xffff}, //ptr == ptr_bkp
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 12)
#error
#endif
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

#if defined(DM5002X_MANOMETR_PRESENT)
 {DM5002X_FIRST_SENSOR+0,  "p33200", &System.dm5002x_state, &System.dm5002x_state_res, sizeof(System.dm5002x_state), ARRAY_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+1,  "p33201", &System.dm5002x_state.pressure, &System.dm5002x_state_res.pressure, sizeof(System.dm5002x_state.pressure), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+2,  "p33202", &System.dm5002x_state.current, &System.dm5002x_state_res.current, sizeof(System.dm5002x_state.current), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+3,  "p33203", &System.dm5002x_state.um, &System.dm5002x_state_res.um, sizeof(System.dm5002x_state.um), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+4,  "p33204", &System.dm5002x_state.udif, &System.dm5002x_state_res.udif, sizeof(System.dm5002x_state.udif), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+5,  "p33205", &System.dm5002x_state.damping, &System.dm5002x_state_res.damping, sizeof(System.dm5002x_state.damping), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+6,  "p33206", &System.dm5002x_state.upper_additional_range, &System.dm5002x_state_res.upper_additional_range, sizeof(System.dm5002x_state.upper_additional_range), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+7,  "p33207", &System.dm5002x_state.lower_additional_range, &System.dm5002x_state_res.lower_additional_range, sizeof(System.dm5002x_state.lower_additional_range), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+8,  "p33208", &System.dm5002x_state.upper_main_range, &System.dm5002x_state_res.upper_main_range, sizeof(System.dm5002x_state.upper_main_range), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+9,  "p33209", &System.dm5002x_state.lower_main_range, &System.dm5002x_state_res.lower_main_range, sizeof(System.dm5002x_state.lower_main_range), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+10, "p33210", &System.dm5002x_state.lower_set_point, &System.dm5002x_state_res.lower_set_point, sizeof(System.dm5002x_state.lower_set_point), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+11, "p33211", &System.dm5002x_state.upper_set_point, &System.dm5002x_state_res.upper_set_point, sizeof(System.dm5002x_state.upper_set_point), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+12, "p33212", &System.dm5002x_state.set_point_hysteresis, &System.dm5002x_state_res.set_point_hysteresis, sizeof(System.dm5002x_state.set_point_hysteresis), FLOAT_SYSTEM_T, 0xffff},
 {DM5002X_FIRST_SENSOR+13, "p33213", &System.dm5002x_state.signaling_device_variant, &System.dm5002x_state_res.signaling_device_variant, sizeof(System.dm5002x_state.signaling_device_variant), FLOAT_SYSTEM_T, 0xffff},
#endif //defined(DM5002X_MANOMETR_PRESENT)

#if defined(MODEM_FTP_PRESENT)
  {VEGA_MODEM_FTP_DWN_STATE, __SNAME("p33219"), __SPTR(&System.ftp_dwn_state), &System.ftp_dwn_state, sizeof(System.ftp_dwn_state), ARRAY_SYSTEM_T, __EGTSN(0xFFFF)}, //поле res не используется!
#endif //defined(MODEM_FTP_PRESENT)

#if defined(ONEWIRE_PRESENT)
  {VEGA_OW_ANY_KEY_PRESENT, __SNAME("p33220"), __SPTR(&System.signal_state.any_ow_key_present), &System.signal_state_res.any_ow_key_present, sizeof(System.signal_state.any_ow_key_present), BOOL_SYSTEM_T, __EGTSN(0xFFFF)},
#endif //defined(ONEWIRE_PRESENT)

#if defined(IMMO_FLANKER_PRESENT)
  {VEGA_IMMO_FLANKER_CMD, __SNAME("p33221"), __SPTR(&System.immoLearnFlankerCmd), &System.immoLearnFlankerCmd, sizeof(System.immoLearnFlankerCmd), UINT8_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_IMMO_FLANKER_LEARN_STATE, __SNAME("p33222"), __SPTR(&System.immoFlankerLearn), &System.immoFlankerLearn, sizeof(System.immoFlankerLearn), ARRAY_SYSTEM_T, __EGTSN(0xFFFF)},
#endif //defined(IMMO_FLANKER_PRESENT)

/*
#ifdef __ICCARM__
  //for LAT debug
  {33221, "p", &LAT[0],   &LAT[0],   192, ARRAY_SYSTEM_T, 0xffff},
  {33222, "p", &LAT[96],  &LAT[96],  192, ARRAY_SYSTEM_T, 0xffff},
  {33223, "p", &LAT[192], &LAT[192], 192, ARRAY_SYSTEM_T, 0xffff},
  {33224, "p", &LAT[288], &LAT[288], 192, ARRAY_SYSTEM_T, 0xffff},
  {33225, "p", &LAT[384], &LAT[384], 192, ARRAY_SYSTEM_T, 0xffff},
  {33226, "p", &LAT[480], &LAT[480], 192, ARRAY_SYSTEM_T, 0xffff},
  {33227, "p", &LAT[576], &LAT[576], 192, ARRAY_SYSTEM_T, 0xffff},
  {33228, "p", &LAT[672], &LAT[672], 192, ARRAY_SYSTEM_T, 0xffff},
#endif //__ICCARM__
*/

#if defined(NAVITERM_PRESENT)
  {NT_DOOR_STATE               , "nt_door"    , &System.signal_state.door_opened,                   &System.signal_state_res.door_opened,                      sizeof(System.signal_state.door_opened),                     UINT8_SYSTEM_T,   0xffff},
  {NT_IN_BTN_STATE             , "nt_in_btn"  , &System.signal_state.in_btn,                        &System.signal_state_res.in_btn,                           sizeof(System.signal_state.in_btn),                          UINT8_SYSTEM_T,   0xffff},
  {NT_V_SENS_STATE             , "nt_v_sens"  , &System.signal_state.vsense,                        &System.signal_state_res.vsense,                           sizeof(System.signal_state.vsense),                          UINT8_SYSTEM_T,   0xffff},
  {NT_A_START_STATE            , "nt_a_start" , &System.signal_state.in_auto,                       &System.signal_state_res.in_auto,                          sizeof(System.signal_state.in_auto),                         UINT8_SYSTEM_T,   0xffff},
  {NT_SOFT_MODE_STATE          , "nt_s_mode"  , &System.signal_state.s_mode,                        &System.signal_state_res.s_mode,                           sizeof(System.signal_state.s_mode),                          UINT8_SYSTEM_T,   0xffff},
  {NT_HARD_MODE_STATE          , "nt_h_mode"  , &System.signal_state.h_mode,                        &System.signal_state_res.h_mode,                           sizeof(System.signal_state.h_mode),                          UINT8_SYSTEM_T,   0xffff},
#endif //(NAVITERM_PRESENT)

#if defined(THERMALMASTER_PRESENT)
  {THERMALMASTER_COOMUNICATION_STATE , "tmast_ok"    , &System.signal_state.is_thermalmaster_ok,            &System.signal_state_res.is_thermalmaster_ok,              sizeof(System.signal_state.is_thermalmaster_ok),             UINT8_SYSTEM_T,   0xffff},
  {THERMALMASTER_INSTEMP             , "tmast_in_t"  , &System.signal_state.thermalmaster_state.instemp,    &System.signal_state_res.thermalmaster_state.instemp,      sizeof(System.signal_state.thermalmaster_state.instemp),     UINT16_SYSTEM_T,   0xffff},
  {THERMALMASTER_OUTIND              , "tmast_ind"   , &System.signal_state.thermalmaster_state.outind,     &System.signal_state_res.thermalmaster_state.outind,       sizeof(System.signal_state.thermalmaster_state.outind),      UINT16_SYSTEM_T,  0xffff},
  {THERMALMASTER_VOLTAGE             , "tmast_volt"  , &System.signal_state.thermalmaster_state.voltage,    &System.signal_state_res.thermalmaster_state.voltage,      sizeof(System.signal_state.thermalmaster_state.voltage),     UINT16_SYSTEM_T,  0xffff},
  {THERMALMASTER_REFTEMP             , "tmast_r_t"   , &System.signal_state.thermalmaster_state.reftemp,    &System.signal_state_res.thermalmaster_state.reftemp,      sizeof(System.signal_state.thermalmaster_state.reftemp),     UINT16_SYSTEM_T,   0xffff},
  {THERMALMASTER_OPHOURSW            , "tmast_hw"    , &System.signal_state.thermalmaster_state.ophoursw,   &System.signal_state_res.thermalmaster_state.ophoursw,     sizeof(System.signal_state.thermalmaster_state.ophoursw),    UINT16_SYSTEM_T,  0xffff},
  {THERMALMASTER_DEFRTEMP            , "tmast_d_t"   , &System.signal_state.thermalmaster_state.defrtemp,   &System.signal_state_res.thermalmaster_state.defrtemp,     sizeof(System.signal_state.thermalmaster_state.defrtemp),    UINT16_SYSTEM_T,   0xffff},
  {THERMALMASTER_SETTEMP             , "tmast_s_t"   , &System.signal_state.thermalmaster_state.settemp,    &System.signal_state_res.thermalmaster_state.settemp,      sizeof(System.signal_state.thermalmaster_state.settemp),     UINT16_SYSTEM_T,   0xffff},
  {THERMALMASTER_DEFRCYCLE           , "tmast_d_c"   , &System.signal_state.thermalmaster_state.defrcycle,  &System.signal_state_res.thermalmaster_state.defrcycle,    sizeof(System.signal_state.thermalmaster_state.defrcycle),   UINT8_SYSTEM_T,   0xffff},
  {THERMALMASTER_DEFRTIME            , "tmast_d_tim" , &System.signal_state.thermalmaster_state.defrtime,   &System.signal_state_res.thermalmaster_state.defrtime,     sizeof(System.signal_state.thermalmaster_state.defrtime),    UINT8_SYSTEM_T,   0xffff},
  {THERMALMASTER_ONOFF               , "tmast_on"    , &System.signal_state.thermalmaster_state.onoff,      &System.signal_state_res.thermalmaster_state.onoff,        sizeof(System.signal_state.thermalmaster_state.onoff),       UINT8_SYSTEM_T,   0xffff},
  {THERMALMASTER_TEMPCORR            , "tmast_t_cor" , &System.signal_state.thermalmaster_state.tempcorr,   &System.signal_state_res.thermalmaster_state.tempcorr,     sizeof(System.signal_state.thermalmaster_state.tempcorr),    UINT16_SYSTEM_T,   0xffff},
  {THERMALMASTER_STATUS              , "tmast_stat"  , &System.signal_state.thermalmaster_state.status,     &System.signal_state_res.thermalmaster_state.status,       sizeof(System.signal_state.thermalmaster_state.status),      UINT8_SYSTEM_T,   0xffff},
#endif //defined(THERMALMASTER_PRESENT)

#if (defined(ZANOTTI_MODBUS_PRESENT))
  {ZANOTTI_COOMUNICATION_STATE    , "zan_ok"      , &System.signal_state.is_zanotti_ok,                         &System.signal_state_res.is_zanotti_ok,                       sizeof(System.signal_state.is_zanotti_ok),                    UINT8_SYSTEM_T,  0xffff},
  {ZANOTTI_MODE                   , "zan_rm"      , &System.signal_state.zanotti_state.regmode,                 &System.signal_state_res.zanotti_state.regmode,               sizeof(System.signal_state.zanotti_state.regmode),            UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_RTEMP                  , "zan_rt"      , &System.signal_state.zanotti_state.realtemp,                &System.signal_state_res.zanotti_state.realtemp,              sizeof(System.signal_state.zanotti_state.realtemp),           FLOAT_SYSTEM_T,  0xffff},
  {ZANOTTI_TTEMP                  , "zan_tt"      , &System.signal_state.zanotti_state.targtemp,                &System.signal_state_res.zanotti_state.targtemp,              sizeof(System.signal_state.zanotti_state.targtemp),           FLOAT_SYSTEM_T,  0xffff},
  {ZANOTTI_TIME_UPD               , "zan_tu"      , &System.signal_state.zanotti_state.timeupdate,              &System.signal_state_res.zanotti_state.timeupdate,            sizeof(System.signal_state.zanotti_state.timeupdate),         UINT32_SYSTEM_T, 0xffff},
  {ZANOTTI_TIME_CURR              , "zan_tc"      , &System.signal_state.zanotti_state.timecurrent,             &System.signal_state_res.zanotti_state.timecurrent,           sizeof(System.signal_state.zanotti_state.timecurrent),        UINT32_SYSTEM_T, 0xffff},
  {ZANOTTI_ERR_CNT                , "zan_errc"    , &System.signal_state.zanotti_state.commerrorcnt,            &System.signal_state_res.zanotti_state.commerrorcnt,          sizeof(System.signal_state.zanotti_state.commerrorcnt),       UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR1             , "zan_err1"    , &System.signal_state.zanotti_state.regerror1,               &System.signal_state_res.zanotti_state.regerror1,             sizeof(System.signal_state.zanotti_state.regerror1),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR2             , "zan_err2"    , &System.signal_state.zanotti_state.regerror2,               &System.signal_state_res.zanotti_state.regerror2,             sizeof(System.signal_state.zanotti_state.regerror2),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR3             , "zan_err3"    , &System.signal_state.zanotti_state.regerror3,               &System.signal_state_res.zanotti_state.regerror3,             sizeof(System.signal_state.zanotti_state.regerror3),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR4             , "zan_err4"    , &System.signal_state.zanotti_state.regerror4,               &System.signal_state_res.zanotti_state.regerror4,             sizeof(System.signal_state.zanotti_state.regerror4),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR5             , "zan_err5"    , &System.signal_state.zanotti_state.regerror5,               &System.signal_state_res.zanotti_state.regerror5,             sizeof(System.signal_state.zanotti_state.regerror5),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR6             , "zan_err6"    , &System.signal_state.zanotti_state.regerror6,               &System.signal_state_res.zanotti_state.regerror6,             sizeof(System.signal_state.zanotti_state.regerror6),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR7             , "zan_err7"    , &System.signal_state.zanotti_state.regerror7,               &System.signal_state_res.zanotti_state.regerror7,             sizeof(System.signal_state.zanotti_state.regerror7),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_REG_ERROR8             , "zan_err8"    , &System.signal_state.zanotti_state.regerror8,               &System.signal_state_res.zanotti_state.regerror8,             sizeof(System.signal_state.zanotti_state.regerror8),          UINT16_SYSTEM_T, 0xffff},
  {ZANOTTI_FLAGS                  , "zan_flgs"    , &System.signal_state.zanotti_state.flags,                   &System.signal_state_res.zanotti_state.flags,                 sizeof(System.signal_state.zanotti_state.flags),              UINT32_SYSTEM_T, 0xffff},
#endif //ZANOTTI_MODBUS_PRESENT

#if (defined(SR3_PRESENT))
  {SR3_COOMUNICATION_STATE       , "sr3_ok"      , &System.signal_state.is_sr3_ok,                              &System.signal_state_res.is_sr3_ok,                          sizeof(System.signal_state.is_sr3_ok),                         UINT8_SYSTEM_T,  0xffff},
  {SR3_OP_COMP1                  , "sr3_op_c1"   , &System.signal_state.sr3_state.mode_op_comp1,                &System.signal_state_res.sr3_state.mode_op_comp1,            sizeof(System.signal_state.sr3_state.mode_op_comp1),           UINT8_SYSTEM_T,  0xffff},
  {SR3_OP_COMP2                  , "sr3_op_c2"   , &System.signal_state.sr3_state.mode_op_comp2,                &System.signal_state_res.sr3_state.mode_op_comp2,            sizeof(System.signal_state.sr3_state.mode_op_comp2),           UINT8_SYSTEM_T,  0xffff},
  {SR3_ENG_STAT                  , "sr3_e_st"    , &System.signal_state.sr3_state.engine_status,                &System.signal_state_res.sr3_state.engine_status,            sizeof(System.signal_state.sr3_state.engine_status),           UINT8_SYSTEM_T,  0xffff},
  {SR3_RUN_MODE                  , "sr3_r_m"     , &System.signal_state.sr3_state.run_mode,                     &System.signal_state_res.sr3_state.run_mode,                 sizeof(System.signal_state.sr3_state.run_mode),                UINT8_SYSTEM_T,  0xffff},
  {SR3_SPEED_MODE                , "sr3_spd_m"   , &System.signal_state.sr3_state.speed_mode,                   &System.signal_state_res.sr3_state.speed_mode,               sizeof(System.signal_state.sr3_state.speed_mode),              UINT8_SYSTEM_T,  0xffff},
  {SR3_ENG_COOLANT               , "sr3_e_cl"    , &System.signal_state.sr3_state.eng_coolant,                  &System.signal_state_res.sr3_state.eng_coolant,              sizeof(System.signal_state.sr3_state.eng_coolant),             FLOAT_SYSTEM_T,  0xffff},
  {SR3_ENG_RPM                   , "sr3_rpm"     , &System.signal_state.sr3_state.rpm,                          &System.signal_state_res.sr3_state.rpm,                      sizeof(System.signal_state.sr3_state.rpm),                     UINT16_SYSTEM_T, 0xffff},
  {SR3_ALRM_STAT                 , "sr3_a_st"    , &System.signal_state.sr3_state.alarm_status,                 &System.signal_state_res.sr3_state.alarm_status,             sizeof(System.signal_state.sr3_state.alarm_status),            UINT8_SYSTEM_T,  0xffff},
  {SR3_NUM_ALRMS                 , "sr3_num_a"   , &System.signal_state.sr3_state.num_act_alarms,               &System.signal_state_res.sr3_state.num_act_alarms,           sizeof(System.signal_state.sr3_state.num_act_alarms),          UINT8_SYSTEM_T,  0xffff},
  {SR3_SIGNAL1                   , "sr3_a1"      , &System.signal_state.sr3_state.signal1,                      &System.signal_state_res.sr3_state.signal1,                  sizeof(System.signal_state.sr3_state.signal1),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_SIGNAL2                   , "sr3_a2"      , &System.signal_state.sr3_state.signal2,                      &System.signal_state_res.sr3_state.signal2,                  sizeof(System.signal_state.sr3_state.signal2),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_SIGNAL3                   , "sr3_a3"      , &System.signal_state.sr3_state.signal3,                      &System.signal_state_res.sr3_state.signal3,                  sizeof(System.signal_state.sr3_state.signal3),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_SIGNAL4                   , "sr3_a4"      , &System.signal_state.sr3_state.signal4,                      &System.signal_state_res.sr3_state.signal4,                  sizeof(System.signal_state.sr3_state.signal4),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_SIGNAL5                   , "sr3_a5"      , &System.signal_state.sr3_state.signal5,                      &System.signal_state_res.sr3_state.signal5,                  sizeof(System.signal_state.sr3_state.signal5),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_COMP_SP1                  , "sr3_c_sp1"   , &System.signal_state.sr3_state.comp1_sp,                     &System.signal_state_res.sr3_state.comp1_sp,                 sizeof(System.signal_state.sr3_state.comp1_sp),                FLOAT_SYSTEM_T,  0xffff},
  {SR3_COMP_SP2                  , "sr3_c_sp2"   , &System.signal_state.sr3_state.comp2_sp,                     &System.signal_state_res.sr3_state.comp2_sp,                 sizeof(System.signal_state.sr3_state.comp2_sp),                FLOAT_SYSTEM_T,  0xffff},
  {SR3_AMBIENT_TEMP              , "sr3_amb"     , &System.signal_state.sr3_state.ambient,                      &System.signal_state_res.sr3_state.ambient,                  sizeof(System.signal_state.sr3_state.ambient),                 FLOAT_SYSTEM_T,  0xffff},
  {SR3_TEMP_COMP1_SUPL           , "sr3_c1_s"    , &System.signal_state.sr3_state.comp1_sup,                    &System.signal_state_res.sr3_state.comp1_sup,                sizeof(System.signal_state.sr3_state.comp1_sup),               FLOAT_SYSTEM_T,  0xffff},
  {SR3_TEMP_COMP1_RET            , "sr3_c1_r"    , &System.signal_state.sr3_state.comp1_ret,                    &System.signal_state_res.sr3_state.comp1_ret,                sizeof(System.signal_state.sr3_state.comp1_ret),               FLOAT_SYSTEM_T,  0xffff},
  {SR3_TEMP_COMP2_SUPL           , "sr3_c2_s"    , &System.signal_state.sr3_state.comp2_sup,                    &System.signal_state_res.sr3_state.comp2_sup,                sizeof(System.signal_state.sr3_state.comp2_sup),               FLOAT_SYSTEM_T,  0xffff},
  {SR3_TEMP_COMP2_RET            , "sr3_c2_r"    , &System.signal_state.sr3_state.comp2_ret,                    &System.signal_state_res.sr3_state.comp2_ret,                sizeof(System.signal_state.sr3_state.comp2_ret),               FLOAT_SYSTEM_T,  0xffff},
  {SR3_DOOR_SW1                  , "sr3_d_sw1"   , &System.signal_state.sr3_state.door_sw1,                     &System.signal_state_res.sr3_state.door_sw1,                 sizeof(System.signal_state.sr3_state.door_sw1),                UINT8_SYSTEM_T,  0xffff},
  {SR3_DOOR_SW2                  , "sr3_d_sw2"   , &System.signal_state.sr3_state.door_sw2,                     &System.signal_state_res.sr3_state.door_sw2,                 sizeof(System.signal_state.sr3_state.door_sw2),                UINT8_SYSTEM_T,  0xffff},
  {SR3_SW_ON_HOURS               , "sr3_sw_h"    , &System.signal_state.sr3_state.sw_on_hours,                  &System.signal_state_res.sr3_state.sw_on_hours,              sizeof(System.signal_state.sr3_state.sw_on_hours),             UINT32_SYSTEM_T, 0xffff},
  {SR3_ENG_HOURS                 , "sr3_en_h"    , &System.signal_state.sr3_state.eng_hours,                    &System.signal_state_res.sr3_state.eng_hours,                sizeof(System.signal_state.sr3_state.eng_hours),               UINT32_SYSTEM_T, 0xffff},
  {SR3_STBY_HOURS                , "sr3_st_h"    , &System.signal_state.sr3_state.stby_hours,                   &System.signal_state_res.sr3_state.stby_hours,               sizeof(System.signal_state.sr3_state.stby_hours),              UINT32_SYSTEM_T, 0xffff},
  {SR3_PREV_HOUR_M_1             , "sr3_p_m1"    , &System.signal_state.sr3_state.prev_hour_m1,                 &System.signal_state_res.sr3_state.prev_hour_m1,             sizeof(System.signal_state.sr3_state.prev_hour_m1),            UINT16_SYSTEM_T, 0xffff},
  {SR3_PREV_HOUR_M_2             , "sr3_p_m2"    , &System.signal_state.sr3_state.prev_hour_m2,                 &System.signal_state_res.sr3_state.prev_hour_m2,             sizeof(System.signal_state.sr3_state.prev_hour_m2),            UINT16_SYSTEM_T, 0xffff},
  {SR3_LIM_HOUR_M_1              , "sr3_lm1"     , &System.signal_state.sr3_state.lim_hour_m1,                  &System.signal_state_res.sr3_state.lim_hour_m1,              sizeof(System.signal_state.sr3_state.lim_hour_m1),             UINT16_SYSTEM_T, 0xffff},
  {SR3_LIM_HOUR_M_2              , "sr3_lm2"     , &System.signal_state.sr3_state.lim_hour_m2,                  &System.signal_state_res.sr3_state.lim_hour_m2,              sizeof(System.signal_state.sr3_state.lim_hour_m2),             UINT16_SYSTEM_T, 0xffff},
  {SR3_SUCT_PRESS                , "sr3_su_pr"   , &System.signal_state.sr3_state.suct_press,                   &System.signal_state_res.sr3_state.suct_press,               sizeof(System.signal_state.sr3_state.suct_press),              UINT16_SYSTEM_T, 0xffff},
  {SR3_DISCH_PRESS               , "sr3_di_pr"   , &System.signal_state.sr3_state.disch_press,                  &System.signal_state_res.sr3_state.disch_press,              sizeof(System.signal_state.sr3_state.disch_press),             UINT16_SYSTEM_T, 0xffff},
  {SR3_LEVEL_COOLANT             , "sr3_l_cl"    , &System.signal_state.sr3_state.lev_coolant,                  &System.signal_state_res.sr3_state.lev_coolant,              sizeof(System.signal_state.sr3_state.lev_coolant),             UINT8_SYSTEM_T,  0xffff},
  {SR3_LEVEL_OIL                 , "sr3_oil"     , &System.signal_state.sr3_state.lev_oil,                      &System.signal_state_res.sr3_state.lev_oil,                  sizeof(System.signal_state.sr3_state.lev_oil),                 UINT8_SYSTEM_T,  0xffff},
  {SR3_OIL_PRESS                 , "sr3_oil_p"   , &System.signal_state.sr3_state.oil_press,                    &System.signal_state_res.sr3_state.oil_press,                sizeof(System.signal_state.sr3_state.oil_press),               UINT8_SYSTEM_T,  0xffff},
  {SR3_ON_EL                     , "sr3_el"      , &System.signal_state.sr3_state.on_el,                        &System.signal_state_res.sr3_state.on_el,                    sizeof(System.signal_state.sr3_state.on_el),                   UINT8_SYSTEM_T,  0xffff},
  {SR3_MAX_DEFROST               , "sr3_m_def"   , &System.signal_state.sr3_state.max_defrost,                  &System.signal_state_res.sr3_state.max_defrost,              sizeof(System.signal_state.sr3_state.max_defrost),             UINT8_SYSTEM_T,  0xffff},
  {SR3_BATT_CURRENT              , "sr3_bat_c"   , &System.signal_state.sr3_state.bat_curr,                     &System.signal_state_res.sr3_state.bat_curr,                 sizeof(System.signal_state.sr3_state.bat_curr),                FLOAT_SYSTEM_T,  0xffff},
  {SR3_BATTERY_VOL               , "sr3_bat_v"   , &System.signal_state.sr3_state.bat_vol,                      &System.signal_state_res.sr3_state.bat_vol,                  sizeof(System.signal_state.sr3_state.bat_vol),                 UINT16_SYSTEM_T, 0xffff},
  {SR3_OUTL_TEMP1                , "sr3_o_t1"    , &System.signal_state.sr3_state.outlet_temp1,                 &System.signal_state_res.sr3_state.outlet_temp1,             sizeof(System.signal_state.sr3_state.outlet_temp1),            FLOAT_SYSTEM_T,  0xffff},
  {SR3_OUTL_TEMP2                , "sr3_o_t2"    , &System.signal_state.sr3_state.outlet_temp2,                 &System.signal_state_res.sr3_state.outlet_temp2,             sizeof(System.signal_state.sr3_state.outlet_temp2),            FLOAT_SYSTEM_T,  0xffff},
  {SR3_SOFT_REV                  , "sr3_s_rev"   , &System.signal_state.sr3_state.soft_rev,                     &System.signal_state_res.sr3_state.soft_rev,                 sizeof(System.signal_state.sr3_state.soft_rev),                UINT16_SYSTEM_T, 0xffff},
  {SR3_SOFT_RELEASE              , "sr3_s_rel"   , &System.signal_state.sr3_state.soft_rel,                     &System.signal_state_res.sr3_state.soft_rel,                 sizeof(System.signal_state.sr3_state.soft_rel),                UINT16_SYSTEM_T, 0xffff},
  {SR3_TYPE_MP                   , "sr3_mp"      , &System.signal_state.sr3_state.mp,                           &System.signal_state_res.sr3_state.mp,                       sizeof(System.signal_state.sr3_state.mp),                      UINT8_SYSTEM_T,  0xffff},
#endif //SR3_PRESENT
#if !defined(FLOWMETER_PRESENT) && !defined(TPMS_PRESENT)
  {VEGA_CAN_1_LAST_ACTIVITY      , __SNAME("can1_last_activity")         , __SPTR(&System.syscom_state.can1_last_activity), &System.syscom_state_res.can1_last_activity, sizeof(System.syscom_state.can1_last_activity), UINT32_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_CAN_2_LAST_ACTIVITY      , __SNAME("can2_last_activity")         , __SPTR(&System.syscom_state.can2_last_activity), &System.syscom_state_res.can2_last_activity, sizeof(System.syscom_state.can2_last_activity), UINT32_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_CAN_3_LAST_ACTIVITY      , __SNAME("can3_last_activity")         , __SPTR(&System.syscom_state.can3_last_activity), &System.syscom_state_res.can3_last_activity, sizeof(System.syscom_state.can3_last_activity), UINT32_SYSTEM_T, __EGTSN(0xFFFF)},
  {VEGA_OVERALL_WEAR_CONDITION   , __SNAME("overall_wear_condition")     , __SPTR(&System.syscom_state.wear_condition),     &System.syscom_state_res.wear_condition,     sizeof(System.syscom_state.wear_condition),     FLOAT_SYSTEM_T,  __EGTSN(0xFFFF)},
  {VEGA_FLASH_WEAR_CONDITION     , __SNAME("flash_wear_condition")       , __SPTR(&System.syscom_state.flash_se_max_time),  &System.syscom_state_res.flash_se_max_time,  sizeof(System.syscom_state.flash_se_max_time),  UINT32_SYSTEM_T, __EGTSN(0xFFFF)},
#endif //FLOWMETER_PRESENT
};

//#else
#ifndef __ICCARM__
const TSensor_table_add CSystem::sensor_table_add[] = {
  {VEGA_DEVICE_TYPE         , "Тип устройства" , "Device type"},
  {VEGA_MCU_FIRMWARE_VERSION, "Версия прошивки", "Firmware version"},
  {VEGA_GSM_FIRMWARE_VERSION, "Версия прошивки GSM", "GSM firmware version"},
  {VEGA_GPS_FIRMWARE_VERSION, "Версия прошивки GPS", "GPS firmware version"},
  {VEGA_DEVICE_IMEI         , "IMEI", "IMEI"},
  {VEGA_DEVICE_SERIAL       , "Серийный номер", "Serial"},
  {VEGA_INPUT_BUFFER_SIZE   , "in_buff_size", "in_buff_size"},
  {VEGA_SIM_ICCID           , "ICCID SIM-карты", "SIM ICCID"},
  {VEGA_UPTIME              , "Время работы устройства", "Uptime"},
  {VEGA_UTC                 , "Текущее время", "Current time"},
  {VEGA_OPERATION_MODE      , "Режим работы", "Operation mode"},
  {VEGA_PROTOCOL_VERSION    , "proto_ver", "proto_ver"},
  {VEGA_BB_MESSAGE_COUNT_1  , "Сообщений в ЧЯ 1", "Black box 1 message count"},
  {VEGA_BB_MESSAGE_COUNT_2  , "Сообщений в ЧЯ 2", "Black box 2 message count"},
  {VEGA_BB_MESSAGE_COUNT_3  , "Сообщений в ЧЯ 3", "Black box 3 message count"},
  {VEGA_BB_MESSAGE_COUNT_4  , "Сообщений в ЧЯ 4", "Black box 4 message count"},
  {VEGA_TCP_STATE1          , "Соединение с сервером 1", "Server 1 connection status"},
  {VEGA_TCP_STATE2          , "Соединение с сервером 2", "Server 2 connection status"},
  {VEGA_TCP_STATE3          , "Соединение с сервером 3", "Server 3 connection status"},
  {VEGA_TCP_STATE4          , "Соединение с сервером 4", "Server 4 connection status"},
  {VEGA_OUTPUT_BUFFER_SIZE  , "out_buff_size", "out_buff_size"},
#if (MAX_SIM_COUNT > 1)
    {VEGA_SIM2_ICCID        , "ICCID SIM-карты 2", "SIM2 ICCID"},
#endif
#if defined(PROD_TESTING_PRESENT)
  {VEGA_PROD_TESTS_STATE    , "" , ""},
#endif //PROD_TESTING_PRESENT

  {VEGA_BOARD_HW_VERSION    , "Ревизия платы", "Board revision"},
  {VEGA_LAT                 , "Широта", "Latitude"},
  {VEGA_LON                 , "Долгота", "Longitude"},
  {VEGA_SPEED               , "Скорость", "Speed"},
  {VEGA_DIR                 , "Курс", "Direction"},
  {VEGA_ALT                 , "Высота", "Heading"},
  {VEGA_HDOP                , "HDOP", "HDOP"},
  {VEGA_PDOP                , "PDOP", "PDOP"},
  {VEGA_VDOP                , "VDOP", "VDOP"},
  {VEGA_GPS_INVIEW          , "Видимых спутников GPS", "GPS satellites in view"},
  {VEGA_GLONASS_INVIEW      , "Видимых спутников ГЛОНАСС", "GLONASS satellites in view"},
  {VEGA_TOTAL_SAT_INVIEW    , "Всего видимых спутников", "Total visible satellites"},
  {VEGA_SAT_USED            , "Используемых спутников", "Satellites in use"},
  {VEGA_GPS_ODOMETER        , "Одометр GPS", "GPS odometer"},
  {VEGA_GPS_MOVE_SENSOR     , "Датчик движения GPS", "GPS moving sensor"},
  {VEGA_TRIP_COUNTER        , "Счетчик поездок", "Trip counter"},
  {VEGA_GPS_JAMMED          , "Датчик глушения GPS", "GPS jamming detector"},
#if (MAX_GEOZONES > 0)
  {(VEGA_GEOZONE_1_ID + 0)  , "Геозона 1", "Geozone 1" },
#endif
#if (MAX_GEOZONES > 1)
  {(VEGA_GEOZONE_1_ID + 1)  , "Геозона 2", "Geozone 2"},
#endif
#if (MAX_GEOZONES > 2)
  {(VEGA_GEOZONE_1_ID + 2)  , "Геозона 3", "Geozone 3"},
#endif
#if (MAX_GEOZONES > 2)
  {(VEGA_GEOZONE_1_ID + 3)  , "Геозона 4", "Geozone 4"},
#endif
#if (MAX_GEOZONES > 4)
  {(VEGA_GEOZONE_1_ID + 4)  , "Геозона 5", "Geozone 5"},
#endif
#if (MAX_GEOZONES > 5)
  {(VEGA_GEOZONE_1_ID + 5)  , "Геозона 6", "Geozone 6"},
#endif
#if (MAX_GEOZONES > 6)
  {(VEGA_GEOZONE_1_ID + 6)  , "Геозона 7", "Geozone 7"},
#endif
#if (MAX_GEOZONES > 7)
  {(VEGA_GEOZONE_1_ID + 7)  , "Геозона 8", "Geozone 8"},
#endif
#if (MAX_GEOZONES > 8)
  {(VEGA_GEOZONE_1_ID + 8)  , "Геозона 9", "Geozone 9"},
#endif
#if (MAX_GEOZONES > 9)
  {(VEGA_GEOZONE_1_ID + 9)  , "Геозона 10", "Geozone 10"},
#endif
#if (MAX_GEOZONES > 10)
  {(VEGA_GEOZONE_1_ID + 10) , "Геозона 11", "Geozone 11"},
#endif
#if (MAX_GEOZONES > 11)
  {(VEGA_GEOZONE_1_ID + 11) , "Геозона 12", "Geozone 12"},
#endif
#if (MAX_GEOZONES > 12)
  {(VEGA_GEOZONE_1_ID + 12) , "Геозона 13", "Geozone 13"},
#endif
#if (MAX_GEOZONES > 13)
  {(VEGA_GEOZONE_1_ID + 13) , "Геозона 14", "Geozone 14"},
#endif
#if (MAX_GEOZONES > 14)
  {(VEGA_GEOZONE_1_ID + 14) , "Геозона 15", "Geozone 15"},
#endif
#if (MAX_GEOZONES > 15)
  {(VEGA_GEOZONE_1_ID + 15) , "Геозона 16", "Geozone 16"},
#endif
#if (MAX_GEOZONES > 16)
  {(VEGA_GEOZONE_1_ID + 16) , "Геозона 17", "Geozone 17"},
#endif
#if (MAX_GEOZONES > 17)
  {(VEGA_GEOZONE_1_ID + 17) , "Геозона 18", "Geozone 18"},
#endif
#if (MAX_GEOZONES > 18)
  {(VEGA_GEOZONE_1_ID + 18) , "Геозона 19", "Geozone 19"},
#endif
#if (MAX_GEOZONES > 19)
  {(VEGA_GEOZONE_1_ID + 19) , "Геозона 20", "Geozone 20"},
#endif
#if (MAX_GEOZONES > 20)
  {(VEGA_GEOZONE_1_ID + 20) , "Геозона 21", "Geozone 21"},
#endif
#if (MAX_GEOZONES > 21)
  {(VEGA_GEOZONE_1_ID + 21) , "Геозона 22", "Geozone 22"},
#endif
#if (MAX_GEOZONES > 22)
  {(VEGA_GEOZONE_1_ID + 22) , "Геозона 23", "Geozone 23"},
#endif
#if (MAX_GEOZONES > 23)
  {(VEGA_GEOZONE_1_ID + 23) , "Геозона 24", "Geozone 24"},
#endif
#if (MAX_GEOZONES > 24)
  {(VEGA_GEOZONE_1_ID + 24) , "Геозона 25", "Geozone 25"},
#endif
#if (MAX_GEOZONES > 25)
  {(VEGA_GEOZONE_1_ID + 25) , "Геозона 26", "Geozone 26"},
#endif
#if (MAX_GEOZONES > 26)
  {(VEGA_GEOZONE_1_ID + 26) , "Геозона 27", "Geozone 27"},
#endif
#if (MAX_GEOZONES > 27)
  {(VEGA_GEOZONE_1_ID + 27) , "Геозона 28", "Geozone 28"},
#endif
#if (MAX_GEOZONES > 28)
  {(VEGA_GEOZONE_1_ID + 28) , "Геозона 29", "Geozone 29"},
#endif
#if (MAX_GEOZONES > 29)
  {(VEGA_GEOZONE_1_ID + 29) , "Геозона 30", "Geozone 30"},
#endif
#if (MAX_GEOZONES > 30)
  {(VEGA_GEOZONE_1_ID + 30) , "Геозона 31", "Geozone 31"},
#endif
#if (MAX_GEOZONES > 31)
  {(VEGA_GEOZONE_1_ID + 31) , "Геозона 32", "Geozone 32"},
#endif
#if (MAX_GEOZONES > 32)
  {(VEGA_GEOZONE_1_ID + 32) , "Геозона 33", "Geozone 33"},
#endif
#if (MAX_GEOZONES > 33)
  {(VEGA_GEOZONE_1_ID + 33) , "Геозона 34", "Geozone 34"},
#endif
#if (MAX_GEOZONES > 34)
  {(VEGA_GEOZONE_1_ID + 34) , "Геозона 35", "Geozone 35"},
#endif
#if (MAX_GEOZONES > 35)
  {(VEGA_GEOZONE_1_ID + 35) , "Геозона 36", "Geozone 36"},
#endif
#if (MAX_GEOZONES > 36)
  {(VEGA_GEOZONE_1_ID + 36) , "Геозона 37", "Geozone 37"},
#endif
#if (MAX_GEOZONES > 37)
  {(VEGA_GEOZONE_1_ID + 37) , "Геозона 38", "Geozone 38"},
#endif
#if (MAX_GEOZONES > 38)
  {(VEGA_GEOZONE_1_ID + 38) , "Геозона 39", "Geozone 39"},
#endif
#if (MAX_GEOZONES > 39)
  {(VEGA_GEOZONE_1_ID + 39) , "Геозона 40", "Geozone 40"},
#endif
#if (MAX_GEOZONES > 40)
  {(VEGA_GEOZONE_1_ID + 40) , "Геозона 41", "Geozone 41"},
#endif
#if (MAX_GEOZONES > 41)
  {(VEGA_GEOZONE_1_ID + 41) , "Геозона 42", "Geozone 42"},
#endif
#if (MAX_GEOZONES > 42)
  {(VEGA_GEOZONE_1_ID + 42) , "Геозона 43", "Geozone 43"},
#endif
#if (MAX_GEOZONES > 43)
  {(VEGA_GEOZONE_1_ID + 43) , "Геозона 44", "Geozone 44"},
#endif
#if (MAX_GEOZONES > 44)
  {(VEGA_GEOZONE_1_ID + 44) , "Геозона 45", "Geozone 45"},
#endif
#if (MAX_GEOZONES > 45)
  {(VEGA_GEOZONE_1_ID + 45) , "Геозона 46", "Geozone 46"},
#endif
#if (MAX_GEOZONES > 46)
  {(VEGA_GEOZONE_1_ID + 46) , "Геозона 47", "Geozone 47"},
#endif
#if (MAX_GEOZONES > 47)
  {(VEGA_GEOZONE_1_ID + 47) , "Геозона 48", "Geozone 48"},
#endif
#if (MAX_GEOZONES > 48)
  {(VEGA_GEOZONE_1_ID + 48) , "Геозона 49", "Geozone 49"},
#endif
#if (MAX_GEOZONES > 49)
  {(VEGA_GEOZONE_1_ID + 49) , "Геозона 50", "Geozone 50"},
#endif
#if (MAX_GEOZONES > 50)
#error Нужно добавить сюда геозоны
#endif

    {VEGA_GPS_SPOOF_SENSOR, "Датчик подмены GPS сигнала", "GPS spoofing sensor"},
    {VEGA_GPS_IS_ACTIVE,    "GPS приёмник активен",       "GPS receiver is active"},
    {VEGA_GALILEO_INVIEW,   "Видимых спутников Galileo",  "Galileo satellites in view"},
    {VEGA_BEIDOU_INVIEW,    "Видимых спутников BeiDou",   "BeiDou satellites in view"},

    {VEGA_GNSS_RAW_STATE,   "GNSS RAW",                   "GNSS RAW"},
    {VEGA_USED_SAT_PRN,     "Used sat PRN",               "Used sat PRN"},
    {VEGA_GPS_SAT_INFO,     "GPS satellites info",        "GPS satellites info"},
    {VEGA_GLONASS_SAT_INFO, "GLONASS satellites info",    "GLONASS satellites info"},
    {VEGA_GALILEO_SAT_INFO, "Galileo satellites info",    "Galileo satellites info"},
    {VEGA_BEIDOU_SAT_INFO,  "BeiDou satellites info",     "BeiDou satellites info"},

#if defined(INTERNAL_NRF_PRESENT)
    {VEGA_NRF_RELAY_ID            , "С/Н реле", "Relay S/N"},
    {VEGA_NRF_DESIRED_RELAY_STATE , "Заданное состояние реле", "Relay set state"},
    {VEGA_NRF_ACTUAL_RELAY_STATE  , "Текущее состояние реле", "Current state of the relay"},
    {VEGA_NRF_VISIBLE_MARKS_BF    , "Видимость радиометок" , "Marks visibility"},
    {VEGA_NRF_BATTLOW_MARKS_BF    , "Низкий заряд батарей радиометок", "Mark low battery charges"},
#if (MAX_INTERNAL_NRF_MARKS_COUNT <= 10)
    {VEGA_NRF_MARK_ID_1 , "С/Н радиометки 1" , "nRF 1"},
    {VEGA_NRF_MARK_ID_2 , "С/Н радиометки 2" , "nRF 2"},
    {VEGA_NRF_MARK_ID_3 , "С/Н радиометки 3" , "nRF 3"},
    {VEGA_NRF_MARK_ID_4 , "С/Н радиометки 4" , "nRF 4"},
    {VEGA_NRF_MARK_ID_5 , "С/Н радиометки 5" , "nRF 5"},
    {VEGA_NRF_MARK_ID_6 , "С/Н радиометки 6" , "nRF 6"},
    {VEGA_NRF_MARK_ID_7 , "С/Н радиометки 7" , "nRF 7"},
    {VEGA_NRF_MARK_ID_8 , "С/Н радиометки 8" , "nRF 8"},
    {VEGA_NRF_MARK_ID_9 , "С/Н радиометки 9" , "nRF 9"},
    {VEGA_NRF_MARK_ID_10, "С/Н радиометки 10", "nRF 10"},
#else
#error   MAX_INTERNAL_NRF_MARKS_COUNT != 10
#endif
    {VEGA_NRF_READY_FOR_COMMAND , "Готовность к приему команд", "Ready for command"},
#endif //INTERNAL_NRF_PRESENT

#if (MAX_ANALOG_INPUTS > 0)
  {(VEGA_ANALOG_INPUT_1)    , "Аналоговый вход 1", "Analog input 1"},
#endif
#if (MAX_ANALOG_INPUTS > 1)
  {(VEGA_ANALOG_INPUT_1 + 1) , "Аналоговый вход 2", "Analog input 2"},
#endif
#if (MAX_ANALOG_INPUTS > 2)
  {(VEGA_ANALOG_INPUT_1 + 2) , "Аналоговый вход 3", "Analog input 3"},
#endif
#if (MAX_ANALOG_INPUTS > 3)
  {(VEGA_ANALOG_INPUT_1 + 3) , "Аналоговый вход 4", "Analog input 4"},
#endif
#if (MAX_ANALOG_INPUTS > 4)
  {(VEGA_ANALOG_INPUT_1 + 4) , "Аналоговый вход 5", "Analog input 5"},
#endif
#if (MAX_ANALOG_INPUTS > 5)
  {(VEGA_ANALOG_INPUT_1 + 5) , "Аналоговый вход 6", "Analog input 6"},
#endif
#if (MAX_ANALOG_INPUTS > 6)
  {(VEGA_ANALOG_INPUT_1 + 6) , "Аналоговый вход 7", "Analog input 7"},
#endif
#if (MAX_ANALOG_INPUTS > 7)
  {(VEGA_ANALOG_INPUT_1 + 7) , "Аналоговый вход 8", "Analog input 8"},
#endif
#if (MAX_ANALOG_INPUTS > 8)
  {(VEGA_ANALOG_INPUT_1 + 8) , "Аналоговый вход 9", "Analog input 9"},
#endif
#if (MAX_ANALOG_INPUTS > 9)
  {(VEGA_ANALOG_INPUT_1 + 9) , "Аналоговый вход 10", "Analog input 10"},
#endif
#if (MAX_ANALOG_INPUTS > 10)
  #error Нужно добавить сюда аналоговые входы
#endif

#if (MAX_DIGITAL_INPUTS > 0)
  {VEGA_DIGITAL_INPUT_1 + 0    , "Цифровой вход 1", "Digital input 1"},
#endif
#if (MAX_DIGITAL_INPUTS > 1)
  {VEGA_DIGITAL_INPUT_1 + 1     , "Цифровой вход 2", "Digital input 2"},
#endif
#if (MAX_DIGITAL_INPUTS > 2)
  {VEGA_DIGITAL_INPUT_1 + 2     , "Цифровой вход 3", "Digital input 3"},
#endif
#if (MAX_DIGITAL_INPUTS > 3)
  {VEGA_DIGITAL_INPUT_1 + 3     , "Цифровой вход 4", "Digital input 4"},
#endif
#if (MAX_DIGITAL_INPUTS > 4)
  {VEGA_DIGITAL_INPUT_1 + 4     , "Цифровой вход 5", "Digital input 5"},
#endif
#if (MAX_DIGITAL_INPUTS > 5)
  {VEGA_DIGITAL_INPUT_1 + 5     , "Цифровой вход 6", "Digital input 6"},
#endif
#if (MAX_DIGITAL_INPUTS > 6)
  {VEGA_DIGITAL_INPUT_1 + 6     , "Цифровой вход 7", "Digital input 7"},
#endif
#if (MAX_DIGITAL_INPUTS > 7)
  {VEGA_DIGITAL_INPUT_1 + 7     , "Цифровой вход 8", "Digital input 8"},
#endif
#if (MAX_DIGITAL_INPUTS > 8)
  {VEGA_DIGITAL_INPUT_1 + 8     , "Цифровой вход 9", "Digital input 9"},
#endif
#if (MAX_DIGITAL_INPUTS > 9)
  {VEGA_DIGITAL_INPUT_1 + 9     , "Цифровой вход 10", "Digital input 10"},
#endif
#if (MAX_DIGITAL_INPUTS > 10)
#error Нужно добавить сюда цифровые входы
#endif


#if (MAX_DIGITAL_OUTPUTS > 0)
  {(VEGA_DIGITAL_OUTPUT_1+0), "Цифровой выход 1", "Digital output 1"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 1)
  {(VEGA_DIGITAL_OUTPUT_1+1), "Цифровой выход 2", "Digital output 2"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 2)
  {(VEGA_DIGITAL_OUTPUT_1+2), "Цифровой выход 3", "Digital output 3"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 3)
  {(VEGA_DIGITAL_OUTPUT_1+3), "Цифровой выход 4", "Digital output 4"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 4)
  {(VEGA_DIGITAL_OUTPUT_1+4), "Цифровой выход 5", "Digital output 5"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 5)
  {(VEGA_DIGITAL_OUTPUT_1+5), "Цифровой выход 6", "Digital output 6"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 6)
  {(VEGA_DIGITAL_OUTPUT_1+6), "Цифровой выход 7", "Digital output 7"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 7)
  {(VEGA_DIGITAL_OUTPUT_1+7), "Цифровой выход 8", "Digital output 8"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 8)
  {(VEGA_DIGITAL_OUTPUT_1+8), "Цифровой выход 9", "Digital output 9"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 9)
  {(VEGA_DIGITAL_OUTPUT_1+9), "Цифровой выход 10", "Digital output 10"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 10)
  {(VEGA_DIGITAL_OUTPUT_1 + 10), "Цифровой выход 11", "Digital output 11"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 11)
  {(VEGA_DIGITAL_OUTPUT_1 + 11), "Цифровой выход 12", "Digital output 12"},
#endif
#if (MAX_DIGITAL_OUTPUTS > 12)
#error Нужно добавить сюда цифровые выходы
#endif
#if (MAX_PULSE_INPUTS > 0)
  {VEGA_PULSE_INPUT_1 + 0      , "Импульсный вход 1", "Pulse input 1"},
#endif
#if (MAX_PULSE_INPUTS > 1)
  {VEGA_PULSE_INPUT_1 + 1       , "Импульсный вход 2", "Pulse input 2"},
#endif
#if (MAX_PULSE_INPUTS > 2)
  {VEGA_PULSE_INPUT_1 + 2       , "Импульсный вход 3", "Pulse input 3"},
#endif
#if (MAX_PULSE_INPUTS > 3)
  {VEGA_PULSE_INPUT_1 + 3       , "Импульсный вход 4", "Pulse input 4"},
#endif
#if (MAX_PULSE_INPUTS > 4)
  {VEGA_PULSE_INPUT_1 + 4       , "Импульсный вход 5", "Pulse input 5"},
#endif
#if (MAX_PULSE_INPUTS > 5)
  {VEGA_PULSE_INPUT_1 + 5       , "Импульсный вход 6", "Pulse input 6"},
#endif
#if (MAX_PULSE_INPUTS > 6)
  {VEGA_PULSE_INPUT_1 + 6       , "Импульсный вход 7", "Pulse input 7"},
#endif
#if (MAX_PULSE_INPUTS > 7)
  {VEGA_PULSE_INPUT_1 + 7       , "Импульсный вход 8", "Pulse input 8"},
#endif
#if (MAX_PULSE_INPUTS > 8)
  {VEGA_PULSE_INPUT_1 + 8       , "Импульсный вход 9", "Pulse input 9"},
#endif
#if (MAX_PULSE_INPUTS > 9)
  {VEGA_PULSE_INPUT_1 + 9       , "Импульсный вход 10", "Pulse input 10"},
#endif
#if (MAX_PULSE_INPUTS > 10)
#error Нужно добавить сюда импульсные входы
#endif
#if (MAX_FREQ_INPUTS > 0)
  {VEGA_FREQ_INPUT_1        , "Частотный вход 1", "Frequency input 1"},
#endif
#if (MAX_FREQ_INPUTS > 1)
  {VEGA_FREQ_INPUT_1 + 1    , "Частотный вход 2", "Frequency input 2"},
#endif
#if (MAX_FREQ_INPUTS > 2)
  {VEGA_FREQ_INPUT_1 + 2    , "Частотный вход 3", "Frequency input 3"},
#endif
#if (MAX_FREQ_INPUTS > 3)
  {VEGA_FREQ_INPUT_1 + 3    , "Частотный вход 4", "Frequency input 4"},
#endif
#if (MAX_FREQ_INPUTS > 4)
  {VEGA_FREQ_INPUT_1 + 4    , "Частотный вход 5", "Frequency input 5"},
#endif
#if (MAX_FREQ_INPUTS > 5)
  {VEGA_FREQ_INPUT_1 + 5    , "Частотный вход 6", "Frequency input 6"},
#endif
#if (MAX_FREQ_INPUTS > 6)
  {VEGA_FREQ_INPUT_1 + 6    , "Частотный вход 7", "Frequency input 7"},
#endif
#if (MAX_FREQ_INPUTS > 7)
  {VEGA_FREQ_INPUT_1 + 7    , "Частотный вход 8", "Frequency input 8"},
#endif
#if (MAX_FREQ_INPUTS > 8)
  {VEGA_FREQ_INPUT_1 + 8    , "Частотный вход 9", "Frequency input 9"},
#endif
#if (MAX_FREQ_INPUTS > 9)
  {VEGA_FREQ_INPUT_1 + 9    , "Частотный вход 10", "Frequency input 10"},
#endif
#if (MAX_FREQ_INPUTS > 10)
#error Нужно добавить сюда частотные входы
#endif
#if (MAX_FREQ_OUTPUTS > 0)
  {(VEGA_FREQ_OUTPUT_1+0)   , "Частотный выход 1", "Frequency output 1"},
#endif
#if (MAX_FREQ_OUTPUTS > 1)
  {(VEGA_FREQ_OUTPUT_1+1)   , "Частотный выход 2", "Frequency output 2"},
#endif
#if (MAX_FREQ_OUTPUTS > 2)
#error   Нужно добавить сюда частотные выходы
#endif

#if (MAX_DUTS > 0)
  {(VEGA_DUT_1+0)           , "Датчик уровня топлива 1", "Fuel level sensor 1"},
#endif
#if (MAX_DUTS > 1)
  {(VEGA_DUT_1+1)           , "Датчик уровня топлива 2", "Fuel level sensor 2"},
#endif
#if (MAX_DUTS > 2)
  {(VEGA_DUT_1+2)           , "Датчик уровня топлива 3", "Fuel level sensor 3"},
#endif
#if (MAX_DUTS > 3)
  {(VEGA_DUT_1+3)           , "Датчик уровня топлива 4", "Fuel level sensor 4"},
#endif
#if (MAX_DUTS > 4)
  {(VEGA_DUT_1+4)           , "Датчик уровня топлива 5", "Fuel level sensor 5"},
#endif
#if (MAX_DUTS > 5)
#error   Нужно добавить сюда ДУТы
#endif

#if (MAX_DUTS > 0)
  {(VEGA_DUT_TEMP_1+0)      , "Температура датчика уровня топлива 1", "Fuel level sensor 1 temperature"},
#endif
#if (MAX_DUTS > 1)
  {(VEGA_DUT_TEMP_1+1)      , "Температура датчика уровня топлива 2", "Fuel level sensor 2 temperature"},
#endif
#if (MAX_DUTS > 2)
  {(VEGA_DUT_TEMP_1+2)      , "Температура датчика уровня топлива 3", "Fuel level sensor 3 temperature"},
#endif
#if (MAX_DUTS > 3)
  {(VEGA_DUT_TEMP_1+3)      , "Температура датчика уровня топлива 4", "Fuel level sensor 4 temperature"},
#endif
#if (MAX_DUTS > 4)
  {(VEGA_DUT_TEMP_1+4)      , "Температура датчика уровня топлива 5", "Fuel level sensor 5 temperature"},
#endif
#if (MAX_DUTS > 5)
#error   Нужно добавить сюда ДУТы
#endif

#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
  {VEGA_TCM_DTC_LIST_SENSOR, "TCM DTC", "TCM DTC"},
  {VEGA_YADRIVE_ALARM_SENSOR, "Тревога", "Alarm"},
  {VEGA_UNAUTHORIZED_START, "Неавторизованный запуск двигателя", "Unauthorized engine start"},
  {VEGA_CLS_STATE_SENSOR, "Состояние центрального замка", "Central lock status"},
  {VEGA_WINDOWS_POSITION_SENSOR, "Состояние окон", "Windows position"},
  {VEGA_HANDBRAKE_DRIVE_SENSOR, "Езда на ручнике", "Drive on handbrake"},
  {AUDIO_FILE_SENSOR, "Проигрываемый аудио файл, номер файла", "Current audio file, file number"},
  {AUDIO_SCENARIO_SENSOR, "Выполняемый аудио сценарий, номер сценария", "Current audio script, script number"},
  {VEGA_VIN_SENSOR, "VIN", "VIN"},
  {VEGA_ECM_DTC_LIST_SENSOR, "ECM DTC", "ECM DTC"},
  {VEGA_CAN_EMERG_LIGHT_MODE, "Аварийные огни", "Emerg. lights"},
  {VEGA_CAN_ECO_MODE, "ECO mode", "ECO mode"},
  {VEGA_CAN_WASHER_LIQUID, "Низкий уровень омывающей жидкости",  "Washer liquid"},
  {VEGA_LAUNCH_SENSOR, "Датчик Launch", "Launch sensor"},
  {VEGA_DRIFT_SENSOR,  "Датчик Drift" , "Drift sensor"},
#endif //YANDEX_EXTENDED_SENSORS_PRESENT

#if (MAX_DALLAS_TEMP_SENSORS > 0)
  {(VEGA_EXT_TEMP_SENSOR_1+0), "Внешний датчик температуры 1", "External temperature sensor 1"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 1)
  {(VEGA_EXT_TEMP_SENSOR_1+1), "Внешний датчик температуры 2", "External temperature sensor 2"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 2)
  {(VEGA_EXT_TEMP_SENSOR_1+2), "Внешний датчик температуры 3", "External temperature sensor 3"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 3)
  {(VEGA_EXT_TEMP_SENSOR_1+3), "Внешний датчик температуры 4", "External temperature sensor 4"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 4)
  {(VEGA_EXT_TEMP_SENSOR_1+4), "Внешний датчик температуры 5", "External temperature sensor 5"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 5)
  {(VEGA_EXT_TEMP_SENSOR_1+5), "Внешний датчик температуры 6", "External temperature sensor 6"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 6)
  {(VEGA_EXT_TEMP_SENSOR_1+6), "Внешний датчик температуры 7", "External temperature sensor 7"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 7)
  {(VEGA_EXT_TEMP_SENSOR_1+7), "Внешний датчик температуры 8", "External temperature sensor 8"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 8)
  {(VEGA_EXT_TEMP_SENSOR_1+8), "Внешний датчик температуры 9", "External temperature sensor 9"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 9)
  {(VEGA_EXT_TEMP_SENSOR_1+9), "Внешний датчик температуры 10", "External temperature sensor 10"},
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 10)
#error   Нужно добавить сюда температурные датчики
#endif
#if (MAX_TAMPERS > 0)
  {VEGA_TAMPER_1             , "Датчик вскрытия корпуса 1", "Tamper 1"},
#endif
#if (MAX_TAMPERS > 1)
  {VEGA_TAMPER_1 + 1         , "Датчик вскрытия корпуса 2", "Tamper 2"},
#endif
#if (MAX_TAMPERS > 2)
  {VEGA_TAMPER_1 + 2         , "Датчик вскрытия корпуса 2", "Tamper 2"},
#endif
#if (MAX_TAMPERS > 3)
#error   Нужно добавить сюда тамперы
#endif

  {VEGA_IGNITION            , "Зажигание", "Ignition"},

#ifdef GSENSOR_PRESENT
  {VEGA_GSENSOR_AXIS_X      , "Ось акселерометра X", "Accelerometer axis X"},
  {VEGA_GSENSOR_AXIS_Y      , "Ось акселерометра Y", "Accelerometer axis Y"},
  {VEGA_GSENSOR_AXIS_Z      , "Ось акселерометра Z", "Accelerometer axis Z"},
  //{VEGA_GREEN_DRIVING       , "Датчик качества вождения", "Green driving sensor"},
  //{VEGA_CRASH               , "Датчик аварии", "Crash sensor"},
  {VEGA_EVACUATION          , "Датчик эвакуации", "Evacuation sensor"},
  {VEGA_GSENSOR_MOVE_SENSOR , "Датчик движения акселерометра", "Accelerometer moving sensor"},
#endif
  {VEGA_INT_TEMP            , "Внутренний датчик температуры", "Internal temperature"},

#ifdef ALARM_BUTTON_PRESENT
  {VEGA_ALARM_BUTTON        , "Тревожная кнопка", "Alarm button"},
#endif
  {VEGA_POWER_VOLTAGE       , "Напряжение бортовой сети", "External voltage"},

#ifdef INTERNAL_AKB_PRESENT
  {VEGA_ACC_VOLTAGE         , "Напряжение встроенной АКБ", "Battery voltage"},
#endif
#ifdef INTERNAL_AKB_CHARGE_LEVEL_PRESENT
  {VEGA_ACC_CHARGE          , "Заряд встроенной АКБ", "Battery charge"},
#endif
#ifdef AUTORIZATION_PRESENT
  {VEGA_AUTORIZED           , "Датчик авторизации", "Authorization sensor"},
  {VEGA_AUTORIZED_KEY       , "Текущий авторизованный ключ", "Current authorized key"},
#endif
#ifdef MOTOHOURS_PRESENT
  {VEGA_MOTOHOURS           , "Датчик моточасов", "Machinery hours"},
#endif

#if defined(ONEWIRE_PRESENT)
  {VEGA_OW_CURRENT_KEY       , "Текущий ключ 1-Wire", "Current key 1-Wire"},
#endif //ONEWIRE_PRESENT

  // Плата расширения
#if defined(BR_PRESENT)
  {(VEGA_EXT_BR_STATUS)    , "Состояние платы расширения", "Extension unit state"},
#if (MAX_EXT_MF_INPUTS <= 15)
  {(VEGA_EXT_ANALOG_INPUT_1)    , "Внешний аналоговый вход 1", "External analog input 1"},
  {(VEGA_EXT_ANALOG_INPUT_1+1)  , "Внешний аналоговый вход 2", "External analog input 2"},
  {(VEGA_EXT_ANALOG_INPUT_1+2)  , "Внешний аналоговый вход 3", "External analog input 3"},
  {(VEGA_EXT_ANALOG_INPUT_1+3)  , "Внешний аналоговый вход 4", "External analog input 4"},
  {(VEGA_EXT_ANALOG_INPUT_1+4)  , "Внешний аналоговый вход 5", "External analog input 5"},
  {(VEGA_EXT_ANALOG_INPUT_1+5)  , "Внешний аналоговый вход 6", "External analog input 6"},
  {(VEGA_EXT_ANALOG_INPUT_1+6)  , "Внешний аналоговый вход 7", "External analog input 7"},
  {(VEGA_EXT_ANALOG_INPUT_1+7)  , "Внешний аналоговый вход 8", "External analog input 8"},
  {(VEGA_EXT_ANALOG_INPUT_1+8)  , "Внешний аналоговый вход 9", "External analog input 9"},
  {(VEGA_EXT_ANALOG_INPUT_1+9)  , "Внешний аналоговый вход 10", "External analog input 10"},
  {(VEGA_EXT_ANALOG_INPUT_1+10) , "Внешний аналоговый вход 11", "External analog input 11"},
  {(VEGA_EXT_ANALOG_INPUT_1+11) , "Внешний аналоговый вход 12", "External analog input 12"},
  {(VEGA_EXT_ANALOG_INPUT_1+12) , "Внешний аналоговый вход 13", "External analog input 13"},
  {(VEGA_EXT_ANALOG_INPUT_1+13) , "Внешний аналоговый вход 14", "External analog input 14"},
  {(VEGA_EXT_ANALOG_INPUT_1+14) , "Внешний аналоговый вход 15", "External analog input 15"},

  {(VEGA_EXT_FREQ_INPUT_1)      , "Внешний частотный вход 1", "External frequency input 1"},
  {(VEGA_EXT_FREQ_INPUT_1+1)    , "Внешний частотный вход 2", "External frequency input 2"},
  {(VEGA_EXT_FREQ_INPUT_1+2)    , "Внешний частотный вход 3", "External frequency input 3"},
  {(VEGA_EXT_FREQ_INPUT_1+3)    , "Внешний частотный вход 4", "External frequency input 4"},
  {(VEGA_EXT_FREQ_INPUT_1+4)    , "Внешний частотный вход 5", "External frequency input 5"},
  {(VEGA_EXT_FREQ_INPUT_1+5)    , "Внешний частотный вход 6", "External frequency input 6"},
  {(VEGA_EXT_FREQ_INPUT_1+6)    , "Внешний частотный вход 7", "External frequency input 7"},
  {(VEGA_EXT_FREQ_INPUT_1+7)    , "Внешний частотный вход 8", "External frequency input 8"},
  {(VEGA_EXT_FREQ_INPUT_1+8)    , "Внешний частотный вход 9", "External frequency input 9"},
  {(VEGA_EXT_FREQ_INPUT_1+9)    , "Внешний частотный вход 10", "External frequency input 10"},
  {(VEGA_EXT_FREQ_INPUT_1+10)   , "Внешний частотный вход 11", "External frequency input 11"},
  {(VEGA_EXT_FREQ_INPUT_1+11)   , "Внешний частотный вход 12", "External frequency input 12"},
  {(VEGA_EXT_FREQ_INPUT_1+12)   , "Внешний частотный вход 13", "External frequency input 13"},
  {(VEGA_EXT_FREQ_INPUT_1+13)   , "Внешний частотный вход 14", "External frequency input 14"},
  {(VEGA_EXT_FREQ_INPUT_1+14)   , "Внешний частотный вход 15", "External frequency input 15"},

  {(VEGA_EXT_PULSE_INPUT_1)     , "Внешний импульсный вход 1", "External pulse input 1"},
  {(VEGA_EXT_PULSE_INPUT_1+1)   , "Внешний импульсный вход 2", "External pulse input 2"},
  {(VEGA_EXT_PULSE_INPUT_1+2)   , "Внешний импульсный вход 3", "External pulse input 3"},
  {(VEGA_EXT_PULSE_INPUT_1+3)   , "Внешний импульсный вход 4", "External pulse input 4"},
  {(VEGA_EXT_PULSE_INPUT_1+4)   , "Внешний импульсный вход 5", "External pulse input 5"},
  {(VEGA_EXT_PULSE_INPUT_1+5)   , "Внешний импульсный вход 6", "External pulse input 6"},
  {(VEGA_EXT_PULSE_INPUT_1+6)   , "Внешний импульсный вход 7", "External pulse input 7"},
  {(VEGA_EXT_PULSE_INPUT_1+7)   , "Внешний импульсный вход 8", "External pulse input 8"},
  {(VEGA_EXT_PULSE_INPUT_1+8)   , "Внешний импульсный вход 9", "External pulse input 9"},
  {(VEGA_EXT_PULSE_INPUT_1+9)   , "Внешний импульсный вход 10", "External pulse input 10"},
  {(VEGA_EXT_PULSE_INPUT_1+10)  , "Внешний импульсный вход 11", "External pulse input 11"},
  {(VEGA_EXT_PULSE_INPUT_1+11)  , "Внешний импульсный вход 12", "External pulse input 12"},
  {(VEGA_EXT_PULSE_INPUT_1+12)  , "Внешний импульсный вход 13", "External pulse input 13"},
  {(VEGA_EXT_PULSE_INPUT_1+13)  , "Внешний импульсный вход 14", "External pulse input 14"},
  {(VEGA_EXT_PULSE_INPUT_1+14)  , "Внешний импульсный вход 15", "External pulse input 15"},

  {(VEGA_EXT_DIGITAL_INPUT_1)     , "Внешний цифровой вход 1", "External digital input 1"},
  {(VEGA_EXT_DIGITAL_INPUT_1+1)   , "Внешний цифровой вход 2", "External digital input 2"},
  {(VEGA_EXT_DIGITAL_INPUT_1+2)   , "Внешний цифровой вход 3", "External digital input 3"},
  {(VEGA_EXT_DIGITAL_INPUT_1+3)   , "Внешний цифровой вход 4", "External digital input 4"},
  {(VEGA_EXT_DIGITAL_INPUT_1+4)   , "Внешний цифровой вход 5", "External digital input 5"},
  {(VEGA_EXT_DIGITAL_INPUT_1+5)   , "Внешний цифровой вход 6", "External digital input 6"},
  {(VEGA_EXT_DIGITAL_INPUT_1+6)   , "Внешний цифровой вход 7", "External digital input 7"},
  {(VEGA_EXT_DIGITAL_INPUT_1+7)   , "Внешний цифровой вход 8", "External digital input 8"},
  {(VEGA_EXT_DIGITAL_INPUT_1+8)   , "Внешний цифровой вход 9", "External digital input 9"},
  {(VEGA_EXT_DIGITAL_INPUT_1+9)   , "Внешний цифровой вход 10", "External digital input 10"},
  {(VEGA_EXT_DIGITAL_INPUT_1+10)  , "Внешний цифровой вход 11", "External digital input 11"},
  {(VEGA_EXT_DIGITAL_INPUT_1+11)  , "Внешний цифровой вход 12", "External digital input 12"},
  {(VEGA_EXT_DIGITAL_INPUT_1+12)  , "Внешний цифровой вход 13", "External digital input 13"},
  {(VEGA_EXT_DIGITAL_INPUT_1+13)  , "Внешний цифровой вход 14", "External digital input 14"},
  {(VEGA_EXT_DIGITAL_INPUT_1+14)  , "Внешний цифровой вход 15", "External digital input 15"},

  {(VEGA_EXT_DIGITAL_OUTPUT_1)     , "Внешний цифровой выход 1", "External digital output 1"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+1)   , "Внешний цифровой выход 2", "External digital output 2"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+2)   , "Внешний цифровой выход 3", "External digital output 3"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+3)   , "Внешний цифровой выход 4", "External digital output 4"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+4)   , "Внешний цифровой выход 5", "External digital output 5"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+5)   , "Внешний цифровой выход 6", "External digital output 6"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+6)   , "Внешний цифровой выход 7", "External digital output 7"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+7)   , "Внешний цифровой выход 8", "External digital output 8"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+8)   , "Внешний цифровой выход 9", "External digital output 9"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+9)   , "Внешний цифровой выход 10", "External digital output 10"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+10)  , "Внешний цифровой выход 11", "External digital output 11"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+11)  , "Внешний цифровой выход 12", "External digital output 12"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+12)  , "Внешний цифровой выход 13", "External digital output 13"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+13)  , "Внешний цифровой выход 14", "External digital output 14"},
  {(VEGA_EXT_DIGITAL_OUTPUT_1+14)  , "Внешний цифровой выход 15", "External digital output 15"},
#else
#error Количество входов/выходов для платы расширения неверное
#endif  //(MAX_EXT_MF_INPUTS <= 15)
#endif //BR_PRESENT

#if defined(FRIDGE_PRESENT)
// По egts не передаем!!!
  {FRIDGE_COOMUNICATION_STATE     , "Cвязь с терморегистратором", "Datacold online"},
  {FRIDGE_SERIAL                  , "Серийный номер терморегистратора", "Datacold serial"},

#if (MAX_FRIDGE_AIN > 0)
  {FRIDGE_AIN1_FLAGS              , "Состояние аналогового входа 1", "Datacold analog input 1 state"},
  {FRIDGE_AIN1_VALUE              , "Показания аналогового входа 1", "Datacold analog input 1"},
#endif
#if (MAX_FRIDGE_AIN > 1)
  {FRIDGE_AIN2_FLAGS              , "Состояние аналогового входа 2", "Datacold analog input 2 state"},
  {FRIDGE_AIN2_VALUE              , "Показания аналогового входа 2", "Datacold analog input 2"},
#endif
#if (MAX_FRIDGE_AIN > 2)
  {FRIDGE_AIN3_FLAGS              , "Состояние аналогового входа 3", "Datacold analog input 3 state"},
  {FRIDGE_AIN3_VALUE              , "Показания аналогового входа 3", "Datacold analog input 3"},
#endif
#if (MAX_FRIDGE_AIN > 3)
  {FRIDGE_AIN4_FLAGS              , "Состояние аналогового входа 4", "Datacold analog input 4 state"},
  {FRIDGE_AIN4_VALUE              , "Показания аналогового входа 4", "Datacold analog input 4"},
#endif
#if (MAX_FRIDGE_AIN > 4)
  {FRIDGE_AIN5_FLAGS              , "Состояние аналогового входа 5", "Datacold analog input 5 state"},
  {FRIDGE_AIN5_VALUE              , "Показания аналогового входа 5", "Datacold analog input 5"},
#endif
#if (MAX_FRIDGE_AIN > 5)
  {FRIDGE_AIN6_FLAGS              , "Состояние аналогового входа 6", "Datacold analog input 6 state"},
  {FRIDGE_AIN6_VALUE              , "Показания аналогового входа 6", "Datacold analog input 6"},
#endif
#if (MAX_FRIDGE_AIN > 6)
#error   Нужно добавить аналоговые входы терморегистратора
#endif

#if (MAX_FRIDGE_DIN > 0)
  {FRIDGE_DIN1_FLAGS              , "Состояние цифрового входа 1", "Datacold digital input 1 state"},
  {FRIDGE_DIN1_VALUE              , "Показания цифрового входа 1", "Datacold digital input 1"},
#endif
#if (MAX_FRIDGE_DIN > 1)
  {FRIDGE_DIN2_FLAGS              , "Состояние цифрового входа 2", "Datacold digital input 2 state"},
  {FRIDGE_DIN2_VALUE              , "Показания цифрового входа 2", "Datacold digital input 2"},
#endif
#if (MAX_FRIDGE_DIN > 2)
  {FRIDGE_DIN3_FLAGS              , "Состояние цифрового входа 3", "Datacold digital input 3 state"},
  {FRIDGE_DIN3_VALUE              , "Показания цифрового входа 3", "Datacold digital input 3"},
#endif
#if (MAX_FRIDGE_DIN > 3)
  {FRIDGE_DIN4_FLAGS              , "Состояние цифрового входа 4", "Datacold digital input 4 state"},
  {FRIDGE_DIN4_VALUE              , "Показания цифрового входа 4", "Datacold digital input 4"},
#endif
#if (MAX_FRIDGE_DIN > 4)
#error   Нужно добавить цифровые входы терморегистратора
#endif

  {FRIDGE_RUN_MODE                , "Рабочий режим", "Datacold run mode"},
  {FRIDGE_POWER_MODE              , "Режим питания", "Datacold power mode"},
  {FRIDGE_SPEED_MODE              , "Скоростной режим", "Datacold speed mode"},
  {FRIDGE_BATTERY_FLAGS           , "Состояние аккумулятора", "Datacold battery state"},
  {FRIDGE_BATTERY_VALUE           , "Напряжение аккумулятора", "Datacold battery voltage"},
  {FRIDGE_FUEL_FLAGS              , "Флаги уровня топлива", "Datacold fuel level flags"},
  {FRIDGE_FUEL_VALUE              , "Уровень топлива", "Datacold fuel level"},

  {FRIDGE_ELECTRIC_HOURS_FLAGS    , "Флаги электро-часов", "Datacold electric hours flags"},
  {FRIDGE_ELECTRIC_HOURS_VALUE    , "Электро-часы", "Datacold electric hours"},
  {FRIDGE_STANDBY_HOURS_FLAGS     , "Флаги часов в режиме ожидания", "Datacold standby hours flags"},
  {FRIDGE_STANDBY_HOURS_VALUE     , "Время в режиме ожидания", "Datacold standby hours"},
  {FRIDGE_DIESEL_HOURS_FLAGS      , "Флаги дизель-часов", "Datacold diesel hours flags"},
  {FRIDGE_DIESEL_HOURS_VALUE      , "Дизель-часы", "Datacold diesel hours"},
#if (MAX_FRIDGE_MAINTENANCE > 0)
  {FRIDGE_MAINTENANCE1_FLAGS      , "Флаги часов сервисного обслуживания 1", "Datacold maintenance hours 1 flags"},
  {FRIDGE_MAINTENANCE1_VALUE      , "Часы сервисного обслуживания 1", "Datacold maintenance hours 1"},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 1)
  {FRIDGE_MAINTENANCE2_FLAGS      , "Флаги часов сервисного обслуживания 2", "Datacold maintenance hours 2 flags"},
  {FRIDGE_MAINTENANCE2_VALUE      , "Часы сервисного обслуживания 2", "Datacold maintenance hours 2"},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 2)
  {FRIDGE_MAINTENANCE3_FLAGS      , "Флаги часов сервисного обслуживания 3", "Datacold maintenance hours 3 flags"},
  {FRIDGE_MAINTENANCE3_VALUE      , "Часы сервисного обслуживания 3", "Datacold maintenance hours 3"},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 3)
  {FRIDGE_MAINTENANCE4_FLAGS      , "Флаги часов сервисного обслуживания 4", "Datacold maintenance hours 4 flags"},
  {FRIDGE_MAINTENANCE4_VALUE      , "Часы сервисного обслуживания 4", "Datacold maintenance hours 4"},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 4)
  {FRIDGE_MAINTENANCE5_FLAGS      , "Флаги часов сервисного обслуживания 5", "Datacold maintenance hours 5 flags"},
  {FRIDGE_MAINTENANCE5_VALUE      , "Часы сервисного обслуживания 5", "Datacold maintenance hours 5"},
#endif
#if (MAX_FRIDGE_MAINTENANCE > 5)
#error   По протоколу интевалов сервисного обслуживания рефрижератора максимум 5
#endif

#if (MAX_FRIDGE_COMPARTMENT > 0)
  {FRIDGE_COMPAR1_STATE             , "Состояние отсека 1", "Datacold compartment 1 state"},
  {FRIDGE_COMPAR1_MODE              , "Режим отсека 1", "Datacold compartment 1 mode"},
  {FRIDGE_COMPAR1_SETPOINT_FLAGS    , "Флаги установленной температуры, отсек 1", "Datacold compartment 1 setpoint flags"},
  {FRIDGE_COMPAR1_SETPOINT_VALUE    , "Установленная температура, отсек 1", "Datacold compartment 1 setpoint"},
  {FRIDGE_COMPAR1_SUPPLY_AIR1_FLAGS , "Флаги датчика приточного воздуха 1, отсека 1", "Datacold compartment 1 supply air sensor 1 flags"},
  {FRIDGE_COMPAR1_SUPPLY_AIR1_VALUE , "Показания датчика приточного воздуха 1, отсек 1", "Datacold compartment 1 supply air sensor 1"},
  {FRIDGE_COMPAR1_SUPPLY_AIR2_FLAGS , "Флаги датчика приточного воздуха 2, отсека 1", "Datacold compartment 1 supply air sensor 2 flags"},
  {FRIDGE_COMPAR1_SUPPLY_AIR2_VALUE , "Показания датчика приточного воздуха 2, отсек 1", "Datacold compartment 1 supply air sensor 2"},
  {FRIDGE_COMPAR1_RETURN_AIR1_FLAGS , "Флаги датчика отточного воздуха 1, отсека 1", "Datacold compartment 1 return air sensor 1 flags"},
  {FRIDGE_COMPAR1_RETURN_AIR1_VALUE , "Показания датчика отточного воздуха 1, отсек 1", "Datacold compartment 1 return air sensor 1"},
  {FRIDGE_COMPAR1_RETURN_AIR2_FLAGS , "Флаги датчика отточного воздуха 2, отсека 1", "Datacold compartment 1 return air sensor 2 flags"},
  {FRIDGE_COMPAR1_RETURN_AIR2_VALUE , "Показания датчика отточного воздуха 2, отсек 1", "Datacold compartment 1 return air sensor 2"},
  {FRIDGE_COMPAR1_EVAPORATOR_FLAGS  , "Флаги температуры испарителя отсека 1", "Datacold compartment 1 evaporator temperature flags"},
  {FRIDGE_COMPAR1_EVAPORATOR_VALUE  , "Температура испарителя, отсек 1", "Datacold compartment 1 evaporator temperature"},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 1)
  {FRIDGE_COMPAR2_STATE             , "Состояние отсека 2", "Datacold compartment 2 state"},
  {FRIDGE_COMPAR2_MODE              , "Режим отсека 2", "Datacold compartment 2 mode"},
  {FRIDGE_COMPAR2_SETPOINT_FLAGS    , "Флаги установленной температуры, отсек 2", "Datacold compartment 2 setpoint flags"},
  {FRIDGE_COMPAR2_SETPOINT_VALUE    , "Установленная температура, отсек 2", "Datacold compartment 2 setpoint"},
  {FRIDGE_COMPAR2_SUPPLY_AIR1_FLAGS , "Флаги датчика приточного воздуха 1, отсека 2", "Datacold compartment 2 supply air sensor 1 flags"},
  {FRIDGE_COMPAR2_SUPPLY_AIR1_VALUE , "Показания датчика приточного воздуха 1, отсек 2", "Datacold compartment 2 supply air sensor 1"},
  {FRIDGE_COMPAR2_SUPPLY_AIR2_FLAGS , "Флаги датчика приточного воздуха 2, отсека 2", "Datacold compartment 2 supply air sensor 2 flags"},
  {FRIDGE_COMPAR2_SUPPLY_AIR2_VALUE , "Показания датчика приточного воздуха 2, отсек 2", "Datacold compartment 2 supply air sensor 2"},
  {FRIDGE_COMPAR2_RETURN_AIR1_FLAGS , "Флаги датчика отточного воздуха 1, отсека 2", "Datacold compartment 2 return air sensor 1 flags"},
  {FRIDGE_COMPAR2_RETURN_AIR1_VALUE , "Показания датчика отточного воздуха 1, отсек 2", "Datacold compartment 2 return air sensor 1"},
  {FRIDGE_COMPAR2_RETURN_AIR2_FLAGS , "Флаги датчика отточного воздуха 2, отсека 2", "Datacold compartment 2 return air sensor 2 flags"},
  {FRIDGE_COMPAR2_RETURN_AIR2_VALUE , "Показания датчика отточного воздуха 2, отсек 2", "Datacold compartment 2 return air sensor 2"},
  {FRIDGE_COMPAR2_EVAPORATOR_FLAGS  , "Флаги температуры испарителя отсека 2", "Datacold compartment 2 evaporator temperature flags"},
  {FRIDGE_COMPAR2_EVAPORATOR_VALUE  , "Температура испарителя, отсек 2", "Datacold compartment 2 evaporator temperature"},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 2)
  {FRIDGE_COMPAR3_STATE             , "Состояние отсека 3", "Datacold compartment 3 state"},
  {FRIDGE_COMPAR3_MODE              , "Режим отсека 3", "Datacold compartment 3 mode"},
  {FRIDGE_COMPAR3_SETPOINT_FLAGS    , "Флаги установленной температуры, отсек 3", "Datacold compartment 3 setpoint flags"},
  {FRIDGE_COMPAR3_SETPOINT_VALUE    , "Установленная температура, отсек 3", "Datacold compartment 3 setpoint"},
  {FRIDGE_COMPAR3_SUPPLY_AIR1_FLAGS , "Флаги датчика приточного воздуха 1, отсека 3", "Datacold compartment 3 supply air sensor 1 flags"},
  {FRIDGE_COMPAR3_SUPPLY_AIR1_VALUE , "Показания датчика приточного воздуха 1, отсек 3", "Datacold compartment 3 supply air sensor 1"},
  {FRIDGE_COMPAR3_SUPPLY_AIR2_FLAGS , "Флаги датчика приточного воздуха 2, отсека 3", "Datacold compartment 3 supply air sensor 2 flags"},
  {FRIDGE_COMPAR3_SUPPLY_AIR2_VALUE , "Показания датчика приточного воздуха 2, отсек 3", "Datacold compartment 3 supply air sensor 2"},
  {FRIDGE_COMPAR3_RETURN_AIR1_FLAGS , "Флаги датчика отточного воздуха 1, отсека 3", "Datacold compartment 3 return air sensor 1 flags"},
  {FRIDGE_COMPAR3_RETURN_AIR1_VALUE , "Показания датчика отточного воздуха 1, отсек 3", "Datacold compartment 3 return air sensor 1"},
  {FRIDGE_COMPAR3_RETURN_AIR2_FLAGS , "Флаги датчика отточного воздуха 2, отсека 3", "Datacold compartment 3 return air sensor 2 flags"},
  {FRIDGE_COMPAR3_RETURN_AIR2_VALUE , "Показания датчика отточного воздуха 2, отсек 3", "Datacold compartment 3 return air sensor 2"},
  {FRIDGE_COMPAR3_EVAPORATOR_FLAGS  , "Флаги температуры испарителя отсека 3", "Datacold compartment 3 evaporator temperature flags"},
  {FRIDGE_COMPAR3_EVAPORATOR_VALUE  , "Температура испарителя, отсек 3", "Datacold compartment 3 evaporator temperature"},
#endif
#if (MAX_FRIDGE_COMPARTMENT > 3)
#error   Нужно добавить отсеки рефрижератора
#endif

  {FRIDGE_AMBIENT_TEMP_FLAGS      , "Состояние датчика наружной температуры", "Datacold ambient temperature state"},
  {FRIDGE_AMBIENT_TEMP_VALUE      , "Показания датчика наружной температуры", "Datacold ambient temperature"},

  {FRIDGE_ALARM_LEVEL                , "Уровень тревоги", "Datacold alarm level"},

#if (MAX_FRIDGE_ALARM_CODES > 0)
  {FRIDGE_ALARM_CODE1+0              , "Код тревоги 1", "Datacold alarm code 1"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 1)
  {FRIDGE_ALARM_CODE1+1              , "Код тревоги 2", "Datacold alarm code 2"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 2)
  {FRIDGE_ALARM_CODE1+2              , "Код тревоги 3", "Datacold alarm code 3"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 3)
  {FRIDGE_ALARM_CODE1+3              , "Код тревоги 4", "Datacold alarm code 4"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 4)
  {FRIDGE_ALARM_CODE1+4              , "Код тревоги 5", "Datacold alarm code 5"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 5)
  {FRIDGE_ALARM_CODE1+5              , "Код тревоги 6", "Datacold alarm code 6"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 6)
  {FRIDGE_ALARM_CODE1+6              , "Код тревоги 7", "Datacold alarm code 7"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 7)
  {FRIDGE_ALARM_CODE1+7              , "Код тревоги 8", "Datacold alarm code 8"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 8)
  {FRIDGE_ALARM_CODE1+8              , "Код тревоги 9", "Datacold alarm code 9"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 9)
  {FRIDGE_ALARM_CODE1+9             , "Код тревоги 10", "Datacold alarm code 10"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 10)
  {FRIDGE_ALARM_CODE1+10            , "Код тревоги 11", "Datacold alarm code 11"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 11)
  {FRIDGE_ALARM_CODE1+11            , "Код тревоги 12", "Datacold alarm code 12"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 12)
  {FRIDGE_ALARM_CODE1+12            , "Код тревоги 13", "Datacold alarm code 13"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 13)
  {FRIDGE_ALARM_CODE1+13            , "Код тревоги 14", "Datacold alarm code 14"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 14)
  {FRIDGE_ALARM_CODE1+14            , "Код тревоги 15", "Datacold alarm code 15"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 15)
  {FRIDGE_ALARM_CODE1+15            , "Код тревоги 16", "Datacold alarm code 16"},
#endif
#if (MAX_FRIDGE_ALARM_CODES > 16)
#error   По протоколу максимум 16 кодов тревог
#endif

#endif //FRIDGE_PRESENT

#if defined(ATOM_PRESENT)
    {ATOM_COOMUNICATION_S, "", ""},
    {ATOM_LAST_ERR     ,   "", ""},
    {ATOM_IMAGE_PROBLEM_B, "", ""},
    {ATOM_CAM_DISC_BF    , "", ""},
    {ATOM_DOOR_1_IN      , "", ""},
    {ATOM_DOOR_1_OUT     , "", ""},
    {ATOM_DOOR_2_IN      , "", ""},
    {ATOM_DOOR_2_OUT     , "", ""},
    {ATOM_DOOR_3_IN      , "", ""},
    {ATOM_DOOR_3_OUT     , "", ""},
    {ATOM_VIDEO_TIMESTAMP, "", ""},
    {ATOM_FIX_TIMESTAMP  , "", ""},
    {ATOM_VIDEO_ID       , "", ""},
#endif //ATOM_PRESENT

#if defined(LORA_SENSORS_PRESENT)
  {LORASENS_COOMUNICATION_STATE  , "Состояние связи со шлюзом LoRa", "Lora gateway communication state"},

#if (MAX_LORA_SENSORS_COUNT > 0)
  {LORASENS_TEMP_VALUE1           , "Температура беспроводного датчика 1 (°C)", "Wireless sensor 1 temperature (°C)"},
  {LORASENS_EVENTS1               , "Тревожные события беспроводного датчика 1", "Wireless sensor 1 alarm events"},
  {LORASENS_RSSI1                 , "Уровень сигнала беспроводного датчика 1 (дБм)", "Wireless sensor 1 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS1        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 1 (минуты)", "Time after last wireless sensor 1 data (m)"},
  {LORASENS_CHARGE_LEVEL1         , "Уровень заряда батареи беспроводного датчика 1", "Wireless sensor 1 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_TEMP_VALUE2           , "Температура беспроводного датчика 2 (°C)", "Wireless sensor 2 temperature (°C)"},
  {LORASENS_EVENTS2               , "Тревожные события беспроводного датчика 2", "Wireless sensor 2 alarm events"},
  {LORASENS_RSSI2                 , "Уровень сигнала беспроводного датчика 2 (дБм)", "Wireless sensor 2 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS2        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 2 (минуты)", "Time after last wireless sensor 2 data (m)"},
  {LORASENS_CHARGE_LEVEL2         , "Уровень заряда батареи беспроводного датчика 2", "Wireless sensor 2 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_TEMP_VALUE3           , "Температура беспроводного датчика 3 (°C)", "Wireless sensor 3 temperature (°C)"},
  {LORASENS_EVENTS3               , "Тревожные события беспроводного датчика 3", "Wireless sensor 3 alarm events"},
  {LORASENS_RSSI3                 , "Уровень сигнала беспроводного датчика 3 (дБм)", "Wireless sensor 3 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS3        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 3 (минуты)", "Time after last wireless sensor 3 data (m)"},
  {LORASENS_CHARGE_LEVEL3         , "Уровень заряда батареи беспроводного датчика 3", "Wireless sensor 3 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_TEMP_VALUE4           , "Температура беспроводного датчика 4 (°C)", "Wireless sensor 4 temperature (°C)"},
  {LORASENS_EVENTS4               , "Тревожные события беспроводного датчика 4", "Wireless sensor 4 alarm events"},
  {LORASENS_RSSI4                 , "Уровень сигнала беспроводного датчика 4 (дБм)", "Wireless sensor 4 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS4        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 4 (минуты)", "Time after last wireless sensor 4 data (m)"},
  {LORASENS_CHARGE_LEVEL4         , "Уровень заряда батареи беспроводного датчика 4", "Wireless sensor 4 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_TEMP_VALUE5           , "Температура беспроводного датчика 5 (°C)", "Wireless sensor 5 temperature (°C)"},
  {LORASENS_EVENTS5               , "Тревожные события беспроводного датчика 5", "Wireless sensor 5 alarm events"},
  {LORASENS_RSSI5                 , "Уровень сигнала беспроводного датчика 5 (дБм)", "Wireless sensor 5 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS5        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 5 (минуты)", "Time after last wireless sensor 5 data (m)"},
  {LORASENS_CHARGE_LEVEL5         , "Уровень заряда батареи беспроводного датчика 5", "Wireless sensor 5 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_TEMP_VALUE6           , "Температура беспроводного датчика 6 (°C)", "Wireless sensor 6 temperature (°C)"},
  {LORASENS_EVENTS6               , "Тревожные события беспроводного датчика 6", "Wireless sensor 6 alarm events"},
  {LORASENS_RSSI6                 , "Уровень сигнала беспроводного датчика 6 (дБм)", "Wireless sensor 6 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS6        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 6 (минуты)", "Time after last wireless sensor 6 data (m)"},
  {LORASENS_CHARGE_LEVEL6         , "Уровень заряда батареи беспроводного датчика 6", "Wireless sensor 6 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_TEMP_VALUE7           , "Температура беспроводного датчика 7 (°C)", "Wireless sensor 7 temperature (°C)"},
  {LORASENS_EVENTS7               , "Тревожные события беспроводного датчика 7", "Wireless sensor 7 alarm events"},
  {LORASENS_RSSI7                 , "Уровень сигнала беспроводного датчика 7 (дБм)", "Wireless sensor 7 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS7        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 7 (минуты)", "Time after last wireless sensor 7 data (m)"},
  {LORASENS_CHARGE_LEVEL7         , "Уровень заряда батареи беспроводного датчика 7", "Wireless sensor 7 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_TEMP_VALUE8           , "Температура беспроводного датчика 8 (°C)", "Wireless sensor 8 temperature (°C)"},
  {LORASENS_EVENTS8               , "Тревожные события беспроводного датчика 8", "Wireless sensor 8 alarm events"},
  {LORASENS_RSSI8                 , "Уровень сигнала беспроводного датчика 8 (дБм)", "Wireless sensor 8 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS8        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 8 (минуты)", "Time after last wireless sensor 8 data (m)"},
  {LORASENS_CHARGE_LEVEL8         , "Уровень заряда батареи беспроводного датчика 8", "Wireless sensor 8 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_TEMP_VALUE9           , "Температура беспроводного датчика 9 (°C)", "Wireless sensor 9 temperature (°C)"},
  {LORASENS_EVENTS9               , "Тревожные события беспроводного датчика 9", "Wireless sensor 9 alarm events"},
  {LORASENS_RSSI9                 , "Уровень сигнала беспроводного датчика 9 (дБм)", "Wireless sensor 9 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS9        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 9 (минуты)", "Time after last wireless sensor 9 data (m)"},
  {LORASENS_CHARGE_LEVEL9         , "Уровень заряда батареи беспроводного датчика 9", "Wireless sensor 9 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_TEMP_VALUE10           , "Температура беспроводного датчика 10 (°C)", "Wireless sensor 10 temperature (°C)"},
  {LORASENS_EVENTS10               , "Тревожные события беспроводного датчика 10", "Wireless sensor 10 alarm events"},
  {LORASENS_RSSI10                 , "Уровень сигнала беспроводного датчика 10 (дБм)", "Wireless sensor 10 rssi (dBm)"},
  {LORASENS_ONLINE_STATUS10        , "Время, прошедшее с последнего радиообмена с беспроводным датчиком 10 (минуты)", "Time after last wireless sensor 10 data (m)"},
  {LORASENS_CHARGE_LEVEL10         , "Уровень заряда батареи беспроводного датчика 10", "Wireless sensor 10 battery charge"},
#endif

#if (MAX_LORA_SENSORS_COUNT > 10)
#error   Нужно добавить lora sensors
#endif

#if (MAX_LORA_SENSORS_COUNT > 0)
  {LORASENS_VERSION1              , "Версия прошивки  беспроводного датчика 1", "Firmware version wireless sensor 1"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS1                 , "Рабочая ось акселерометра датчика 1", "Wireless sensor 1 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE1            , "Влажность, беспроводной датчик 1 (%)","Humidity, Wireless Sensor 1 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_VERSION2              , "Версия прошивки  беспроводного датчика 2", "Firmware version wireless sensor 2"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS2                 , "Рабочая ось акселерометра датчика 2", "Wireless sensor 2 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE2            , "Влажность, беспроводной датчик 2 (%)","Humidity, Wireless Sensor 2 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_VERSION3              , "Версия прошивки  беспроводного датчика 3", "Firmware version wireless sensor 3"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS3                 , "Рабочая ось акселерометра датчика 3", "Wireless sensor 3 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE3            , "Влажность, беспроводной датчик 3 (%)","Humidity, Wireless Sensor 3 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_VERSION4              , "Версия прошивки  беспроводного датчика 4", "Firmware version wireless sensor 4"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS4                 , "Рабочая ось акселерометра датчика 4", "Wireless sensor 4 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE4            , "Влажность, беспроводной датчик 4 (%)","Humidity, Wireless Sensor 4 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_VERSION5              , "Версия прошивки  беспроводного датчика 5", "Firmware version wireless sensor 5"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS5                 , "Рабочая ось акселерометра датчика 5", "Wireless sensor 5 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE5            , "Влажность, беспроводной датчик 5 (%)","Humidity, Wireless Sensor 5 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_VERSION6              , "Версия прошивки  беспроводного датчика 6", "Firmware version wireless sensor 6"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS6                 , "Рабочая ось акселерометра датчика 6", "Wireless sensor 6 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE6            , "Влажность, беспроводной датчик 6 (%)","Humidity, Wireless Sensor 6 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_VERSION7              , "Версия прошивки  беспроводного датчика 7", "Firmware version wireless sensor 7"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS7                 , "Рабочая ось акселерометра датчика 7", "Wireless sensor 7 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE7            , "Влажность, беспроводной датчик 7 (%)","Humidity, Wireless Sensor 7 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_VERSION8              , "Версия прошивки  беспроводного датчика 8", "Firmware version wireless sensor 8"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS8                 , "Рабочая ось акселерометра датчика 8", "Wireless sensor 8 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE8            , "Влажность, беспроводной датчик 8 (%)","Humidity, Wireless Sensor 8 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_VERSION9              , "Версия прошивки  беспроводного датчика 9", "Firmware version wireless sensor 9"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS9                 , "Рабочая ось акселерометра датчика 9", "Wireless sensor 9 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE9            , "Влажность, беспроводной датчик 9 (%)","Humidity, Wireless Sensor 9 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_VERSION10              , "Версия прошивки беспроводного датчика 10", "Firmware version wireless sensor 10"},
#if defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT)
  {LORASENS_AXIS10                 , "Рабочая ось акселерометра датчика 10", "Wireless sensor 10 working axis of the accelerometer"},
  {LORASENS_HUM_VALUE10            , "Влажность, беспроводной датчик 10 (%)","Humidity, Wireless Sensor 10 (%)"},
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT
#endif

#if (MAX_LORA_SENSORS_COUNT > 10)
#error   Нужно добавить lora sensors
#endif

  {LORASENS_COPROC_VERSION       , "Версия прошивки сопроцессора LoRa", "Firmware version coprocessor LoRa"},
#endif //LORA_SENSORS_PRESENT

#if defined(REPORT_GEN_PRESENT)
#if (MAX_LORA_SENSORS_COUNT > 0)//bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
  {LORASENS_EVENTS1_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS1_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS1_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS1_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS1_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 1)
  {LORASENS_EVENTS2_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS2_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS2_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS2_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS2_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 2)
  {LORASENS_EVENTS3_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS3_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS3_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS3_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS3_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 3)
  {LORASENS_EVENTS4_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS4_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS4_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS4_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS4_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 4)
  {LORASENS_EVENTS5_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS5_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS5_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS5_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS5_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 5)
  {LORASENS_EVENTS6_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS6_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS6_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS6_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS6_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 6)
  {LORASENS_EVENTS7_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS7_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS7_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS7_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS7_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 7)
  {LORASENS_EVENTS8_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS8_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS8_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS8_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS8_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 8)
  {LORASENS_EVENTS9_0               , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS9_1               , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS9_2               , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS9_3               , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS9_4               , "Датчик отрыва","Breakaway sensor"},
#endif
#if (MAX_LORA_SENSORS_COUNT > 9)
  {LORASENS_EVENTS10_0              , "Внешний геркон","External reed switch"},
  {LORASENS_EVENTS10_1              , "Датчик Холла 1","Hall sensor 1"},
  {LORASENS_EVENTS10_2              , "Датчик Холла 2","Hall sensor 2"},
  {LORASENS_EVENTS10_3              , "Вскрыие корпуса","Case opening"},
  {LORASENS_EVENTS10_4              , "Датчик отрыва","Breakaway sensor"},
#endif
#endif //REPORT_GEN_PRESENT

#if (defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))
  {IQFREEZE_COOMUNICATION_STATE   , "Cвязь с IQFreeze", "IQFreeze connection state"},
  {IQFREEZE_MT                    , "Температура рефрижератора в секции 1, °С", "Fridge compartment 1 temperature, °С"},
  {IQFREEZE_T2                    , "Температура рефрижератора в секции 2, °С", "Fridge compartment 2 temperature, °С"},
  {IQFREEZE_T3                    , "Температура рефрижератора в секции 3, °С", "Fridge compartment 3 temperature, °С"},
  {IQFREEZE_SP                    , "Установл. температура в секции 1, °С", "Compartment 1 setpoint, °С"},
  {IQFREEZE_SP2                   , "Установл. температура в секции 2, °С", "Compartment 2 setpoint, °С"},
  {IQFREEZE_SP3                   , "Установл. температура в секции 3, °С", "Compartment 3 setpoint, °С"},
  {IQFREEZE_AMBT                  , "Температура окр. воздуха, °С", "Ambient temperature, °С"},
  {IQFREEZE_AFZT                  , "Температура охлаждающей жидкости, °С", "Coolant temperature, °С"},
  {IQFREEZE_RPM                   , "Обороты двигателя, об/мин", "Engine rpm"},
  {IQFREEZE_CONF                  , "Конфигурация компрессора 1", "Compressor configuration 1"},
  {IQFREEZE_STATE                 , "Состояние ХОУ 1", "Fridge state 1"},
  //  {IQFREEZE_DR                    , "Состояние двери", "Door state"},
  {IQFREEZE_DR_BF                    , "Состояние двери", "Door state"},
  {IQFREEZE_BATV                  , "Напряжение аккумулятора ХОУ, В", "Fridge battery voltage, V"},
  {IQFREEZE_BATA                  , "Сила тока аккумулятора ХОУ, А", "Fridge battery current, A"},
  {IQFREEZE_HM                    , "Моточасы работы от двигателя, часы", "Fridge engine motohours, h"},
  {IQFREEZE_HME                   , "Моточасы работы от сети, часы", "Fridge electric hours, h"},
  {IQFREEZE_REFSN                 , "Серийный номер установки", "Fridge serial number"},
  {IQFREEZE_TRSN                  , "Серийный номер прицепа", "Trailer serial number"},
  {IQFREEZE_ALCOUNT               , "Количество ошибок ХОУ", "Fridge errors count"},
  {IQFREEZE_AL1                   , "Код самой важной ошибки", "Most important error code"},
  {IQFREEZE_AL2                   , "Код 2-й по важности ошибки", "2nd important error code"},
  {IQFREEZE_AL3                   , "Код 3-й по важности ошибки", "3rd important error code"},
  {IQFREEZE_AL4                   , "Код 4-й по важности ошибки", "4th important error code"},
  {IQFREEZE_AL5                   , "Код 5-й по важности ошибки", "5th important error code"},
  {IQFREEZE_AL6                   , "Код 6-й по важности ошибки", "6th important error code"},
  {IQFREEZE_SN                    , "Серийный номер iQFreeze", "IQFreeze serial number"},
  {IQFREEZE_VER                   , "Версия прошивки iQFreeze", "IQFreeze firmware version"},
  {IQFREEZE_REFTYPE               , "Тип ХОУ", "Fridge type"},
  {IQFREEZE_NO_CONNECT            , "Связь с ХОУ", "Fridge connection state"},
  {IQFREEZE_ERR_BF                , "Ошибки", "Errors"},
  //  {IQFREEZE_IN1                 , "Цифровой вход iQfreeze 1", "IQFreeze digital input 1"},
  //  {IQFREEZE_IN2                 , "Цифровой вход iQfreeze 2", "IQFreeze digital input 2"},
  {IQFREEZE_IN_BF                 , "Цифровые входы iQfreeze", "IQFreeze digital inputs"},
  {IQFREEZE_HMT                   , "Моточасы общие, час", "common motohours, hour"},
  {IQFREEZE_LIC                   , "Тип лицензии", "IQFreeze licension type"},
  {IQFREEZE_UPTIME                , "Время с включения iQfreeze, с", "IQFreeze uptime, s"},

  {IQFREEZE_CONF2                 , "Конфигурация компрессора 2", "Compressor Configuration 2"},
  {IQFREEZE_CONF3                 , "Конфигурация компрессора 3", "Compressor Configuration 3"},
  {IQFREEZE_STATE2                , "Состояние системы 2", "System state 2"},
  {IQFREEZE_STATE3                , "Состояние системы 3", "System state 3"},
  {IQFREEZE_AD1                   , "Датчик температуры 1, °С", "temperature sensor 1, °С"},
  {IQFREEZE_AD2                   , "Датчик температуры 2, °С", "temperature sensor 2, °С"},
  {IQFREEZE_AD3                   , "Датчик температуры 3, °С", "temperature sensor 3, °С"},
  {IQFREEZE_AD4                   , "Датчик температуры 4, °С", "temperature sensor 4, °С"},
  {IQFREEZE_AD5                   , "Датчик температуры 5, °С", "temperature sensor 5, °С"},
  {IQFREEZE_AD6                   , "Датчик температуры 6, °С", "temperature sensor 6, °С"},
  {IQFREEZE_HS                    , "Датчик влажности, %", "Humidity sensor, %"},
  {IQFREEZE_DEVTYPE               , "Тип устройства iQFreeze", "Device type iQFreeze"},
//{IQFREEZE_TIME                  , "Время по UTC", "UTC time"},
  {IQFREEZE_VRN                   , "Гос. номер iQFreeze", "State number iQFreeze"},
//{IQFREEZE_REGTIME               , "Время регистрации последней записи (UTC)", "Last recorded time (UTC)"},

//  {IQFREEZE_TEMP_PROBE            , "Аналоговый вход iQfreeze", "IQFreeze analog input"},
#endif //(defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))

#if defined(NRF_BEACONS_SCANNER_PRESENT)
  {NRF_BEACONS_SCANNER_COMMUNICATION_STATE , "Сканнер радиометок на связи", "NRF beacon scanner online"},
  {NRF_BEACONS_SCANNER_AUTORIZIED          , "Хотя бы одна авторизованная метка в поле видимости", "Authorized NRF beacon(s) is visible"},
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 0)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF1 , "Группа радиометок 1", "NRF beacons group 1"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF1 , "Состояние батарей группы радиометок 1", "NRF beacons group 1 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 1)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF2 , "Группа радиометок 2", "NRF beacons group 2"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF2 , "Состояние батарей группы радиометок 2", "NRF beacons group 2 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 2)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF3 , "Группа радиометок 3", "NRF beacons group 3"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF3 , "Состояние батарей группы радиометок 3", "NRF beacons group 3 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 3)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF4 , "Группа радиометок 4", "NRF beacons group 4"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF4 , "Состояние батарей группы радиометок 4", "NRF beacons group 4 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 4)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF5 , "Группа радиометок 5", "NRF beacons group 5"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF5 , "Состояние батарей группы радиометок 5", "NRF beacons group 5 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 5)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF6 , "Группа радиометок 6", "NRF beacons group 6"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF6 , "Состояние батарей группы радиометок 6", "NRF beacons group 6 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 6)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF7 , "Группа радиометок 7", "NRF beacons group 7"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF7 , "Состояние батарей группы радиометок 7", "NRF beacons group 7 battry state"},
#endif
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_STR , "SN видимых радиометок", "Visible beacons SN"},
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(TENZO_M_WEIGHER_PRESENT)
  {TENZO_M_WEIGHER_COMMUNICATION_STATE ,  "Весы Тензо-М на связи", "Tenzo-M weight online"},
  {TENZO_M_WEIGHER_NET_RAW ,              "Тензо-М вес нетто (сырые данные)", "Tenzo-M netto (raw data)"},
  {TENZO_M_WEIGHER_GROSS_RAW ,            "Тензо-М вес брутто (сырые данные)", "Tenzo-M gross (raw data)"},
#endif //TENZO_M_WEIGHER_PRESENT

#if defined(PROCESSOR_WEIGHT_PV310_PRESENT)
  {PV310_WEIGHER_COMMUNICATION_STATE ,  "ПВ-310 на связи", "PV-310 online"},
  {PV310_WEIGHER_NET_RAW ,              "ПВ-310 вес текущий, кг", "PV-310 weight current, kg"},
#endif //PROCESSOR_WEIGHT_PV310_PRESENT

#if defined(TOUCHPRINT_PRESENT)
  {TOUCHPRINT_COOMUNICATION_STATE     , "Cвязь с ТР TOUCHPRINT", "TOUCHPRINT online"},
#if (MAX_TOUCHPRINT_AIN > 0)
  {TOUCHPRINT_AIN1_VALUE              , "TOUCHPRINT датчик температуры 1, °С", "TOUCHPRINT temperature sensor 1, °С"},
#endif
#if (MAX_TOUCHPRINT_AIN > 1)
  {TOUCHPRINT_AIN2_VALUE              , "TOUCHPRINT датчик температуры 2, °С", "TOUCHPRINT temperature sensor 2, °С"},
#endif
#if (MAX_TOUCHPRINT_AIN > 2)
  {TOUCHPRINT_AIN3_VALUE              , "TOUCHPRINT датчик температуры 3, °С", "TOUCHPRINT temperature sensor 3, °С"},
#endif
#if (MAX_TOUCHPRINT_AIN > 3)
  {TOUCHPRINT_AIN4_VALUE              , "TOUCHPRINT датчик температуры 4, °С", "TOUCHPRINT temperature sensor 4, °С"},
#endif
#if (MAX_TOUCHPRINT_AIN > 4)
  {TOUCHPRINT_AIN5_VALUE              , "TOUCHPRINT датчик температуры 5, °С", "TOUCHPRINT temperature sensor 5, °С"},
#endif
#if (MAX_TOUCHPRINT_AIN > 5)
  {TOUCHPRINT_AIN6_VALUE              , "TOUCHPRINT датчик температуры 6, °С", "TOUCHPRINT temperature sensor 6, °С"},
#endif
#if (TOUCHPRINT_TOUCHPRINT_AIN > 6)
#error   Нужно добавить аналоговые входы терморегистратора TOUCHPRINT
#endif
  {TOUCHPRINT_DIN_VALUE               , "TOUCHPRINT цифровые входы 1..6", "TOUCHPRINT digital inputs 1..6"},

#if (MAX_TOUCHPRINT_HIN > 0)
  {TOUCHPRINT_HIN1_VALUE              , "TOUCHPRINT датчик влажности 1, %", "TOUCHPRINT humidity sensor 1, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 1)
  {TOUCHPRINT_HIN2_VALUE              , "TOUCHPRINT датчик влажности 2, %", "TOUCHPRINT humidity sensor 2, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 2)
  {TOUCHPRINT_HIN3_VALUE              , "TOUCHPRINT датчик влажности 3, %", "TOUCHPRINT humidity sensor 3, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 3)
  {TOUCHPRINT_HIN4_VALUE              , "TOUCHPRINT датчик влажности 4, %", "TOUCHPRINT humidity sensor 4, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 4)
  {TOUCHPRINT_HIN5_VALUE              , "TOUCHPRINT датчик влажности 5, %", "TOUCHPRINT humidity sensor 5, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 5)
  {TOUCHPRINT_HIN6_VALUE              , "TOUCHPRINT датчик влажности 6, %", "TOUCHPRINT humidity sensor 6, %"},
#endif
#if (MAX_TOUCHPRINT_HIN > 6)
#error   Нужно добавить входы датчиков влажности терморегистратора
#endif

#if (MAX_TOUCHPRINT_IN > 0)
  {TOUCHPRINT_IN1_CONF              , "TOUCHPRINT конфигурация входа 1", "TOUCHPRINT config sensor 1"},
#endif
#if (MAX_TOUCHPRINT_IN > 1)
  {TOUCHPRINT_IN2_CONF              , "TOUCHPRINT конфигурация входа 2", "TOUCHPRINT config sensor 2"},
#endif
#if (MAX_TOUCHPRINT_IN > 2)
  {TOUCHPRINT_IN3_CONF              , "TOUCHPRINT конфигурация входа 3", "TOUCHPRINT config sensor 3"},
#endif
#if (MAX_TOUCHPRINT_IN > 3)
  {TOUCHPRINT_IN4_CONF              , "TOUCHPRINT конфигурация входа 4", "TOUCHPRINT config sensor 4"},
#endif
#if (MAX_TOUCHPRINT_IN > 4)
  {TOUCHPRINT_IN5_CONF              , "TOUCHPRINT конфигурация входа 5", "TOUCHPRINT config sensor 5"},
#endif
#if (MAX_TOUCHPRINT_IN > 5)
  {TOUCHPRINT_IN6_CONF              , "TOUCHPRINT конфигурация входа 6", "TOUCHPRINT config sensor 6"},
#endif
#if (MAX_TOUCHPRINT_IN > 6)
#error   Нужно добавить входы датчиков влажности терморегистратора
#endif

  {TOUCHPRINT_DSR_STATE           , "Состояние DSR",              "DSR state"},
  {TOUCHPRINT_S1_PROBE            , "Датчик температуры щуп S1, °С", "Temperature S1_PROBE, °С"},
  {TOUCHPRINT_S2_PROBE            , "Датчик температуры щуп S2, °С", "Temperature S2_PROBE, °С"},
  {TOUCHPRINT_M_HOURS             , "Часы сервисного обслуживания", "Maintenance Hours"},
  {TOUCHPRINT_T_HOURS             , "Общее время", "Total Hours"},
  {TOUCHPRINT_R_HOURS             , "Время в пути", "Road Hours"},
  {TOUCHPRINT_STBY_HOURS          , "Время в режиме ожидания", "Stand-By Hours"},
  {TOUCHPRINT_ALRM_STATUS         , "Статусы тревог", "Alarms status"},
  {TOUCHPRINT_SET_POINT1          , "Установленная температура SP1, °С", "Set temperature SP1, °С"},
  {TOUCHPRINT_SET_POINT2          , "Установленная температура SP2, °С", "Set temperature SP2, °С"},
  {TOUCHPRINT_DSR_DINPUT          , "DSR цифровые входы 1 2", "Digital Inputs 1 2"},
  {TOUCHPRINT_DSR_STATUS          , "Статус DSR", "DSR status"},
  {TOUCHPRINT_DSR_MODE_C1         , "Режим отсека 1", "Mode compartment #1"},
  {TOUCHPRINT_DSR_MODE_C2         , "Режим отсека 2", "Mode compartment #2"},
  {TOUCHPRINT_DOUT_STATE          , "DSR цифровые выходы 1..4", "State Digital outputs 1..4"},
  {TOUCHPRINT_FMW_VERSION         , "Версия прошивки TOUCHPRINT", "Firmware version TOUCHPRINT"},
  {TOUCHPRINT_FMW_RELEASE         , "Релиз прошивки", "Firmware release"},
#endif //TOUCHPRINT_PRESENT

#if defined(IBOX_PRESENT)
  {IBX_COOMUNICATION_STATE         , "Cвязь с i-BOX",                           "IBOX online"},
  {IBX_FUEL_LEVEL                  , "Уровень топлива, %",                      "IBOX Fuel Level, %"},
  {IBX_BATTERY_POTENTIAL           , "Напряжение батареи, В",                   "IBOX_Battery Potential, V"},
  {IBX_SOFT_IDENT                  , "Версия прошивки IBOX",                         "IBOX Software Ident"},
  {IBX_TOTAL_ELECTRIC_HOURS        , "Моточасы работы от сети, ч",              "IBOX Total El Hours, h"},
  {IBX_COMPONENT_IDENT             , "Марка, модель и сер. номер",             "IBOX Component Ident"},
  {IBX_TOTAL_VEHICLE_HOURS         , "Моточасы работы автомобиля, ч",           "IBOX Total Vehicle Hours,h"},
  {IBX_TOTAL_ENGINE_HOURS          , "Моточасы работы двигателя, ч",            "IBOX Total Engine Hours, h"},
//Trailer1 zone1
  {IBX_T1_Z1_A_ZONES_ALRM_TYPE     , "Активные зоны, тип тревоги Зона1",        "IBOX Active/Alarm Z1"},
  {IBX_T1_Z1_ALRM_CODE             , "Код аварийной сигнализации Зона1",        "IBOX Alarm Code Z1"},
  {IBX_T1_Z1_TEMP_SENSOR_ASSIGN    , "Настройки датчиков температуры Зона1",    "IBOX Temp Sens Assign Z1"},
  {IBX_T1_Z1_RETURN_AIR1_TEMP      , "Температура отточного воздуха1 Зона1,°С", "IBOX Return Air1Temp Z1,°С"},
  {IBX_T1_Z1_SUPPLY1_TEMP          , "Температура приточного воздуха1 Зона1,°С","IBOX Supply1 Temp Z1,°С"},
  {IBX_T1_Z1_TEMP_SETPOINT         , "Установленная температура Зона1,°С",      "IBOX Temp Setpoint Z1,°С"},
  {IBX_T1_Z1_EVAPORATOR_COIL_TEMP  , "Температура испарителя Зона1,°С",         "IBOX Evap Coil Temp Z1,°С"},
  {IBX_T1_Z1_RETURN_AIR2_TEMP      , "Температура отточного воздуха2 Зона1,°С", "IBOX Return Air2Temp Z1,°С"},
  {IBX_T1_Z1_SUPPLY2_TEMP          , "Температура приточного воздуха2 Зона1,°С","IBOX Supply2 Temp Z1,°С"},
  {IBX_T1_Z1_OPERATING_MODE        , "Режим работы Зона1",                      "IBOX Operating Mode Z1"},
//Trailer1 zone2
  {IBX_T1_Z2_ALRM_TYPE             , "Тип тревоги Зона2",                       "IBOX Alarm Type Z2"},
  {IBX_T1_Z2_ALRM_CODE             , "Код аварийной сигнализации Зона2",        "IBOX Alarm Code Z2"},
  {IBX_T1_Z2_TEMP_SENSOR_ASSIGN    , "Настройки датчиков температуры Зона2",    "IBOX Temp Sens Assign Z2"},
  {IBX_T1_Z2_RETURN_AIR1_TEMP      , "Температура отточного воздуха1 Зона2,°С", "IBOX Return Air1Temp Z2,°С"},
  {IBX_T1_Z2_SUPPLY1_TEMP          , "Температура приточного воздуха1 Зона2,°С","IBOX Supply1 Temp Z2,°С"},
  {IBX_T1_Z2_TEMP_SETPOINT         , "Установленная температура Зона2,°С",      "IBOX Temp Setpoint Z2,°С"},
  {IBX_T1_Z2_EVAPORATOR_COIL_TEMP  , "Температура испарителя Зона2,°С",         "IBOX Evap Coil Temp Z2,°С"},
  {IBX_T1_Z2_RETURN_AIR2_TEMP      , "Температура отточного воздуха2 Зона2,°С", "IBOX Return Air2Temp Z2,°С"},
  {IBX_T1_Z2_SUPPLY2_TEMP          , "Температура приточного воздуха2 Зона2,°С","IBOX Supply2 Temp Z2,°С"},
  {IBX_T1_Z2_OPERATING_MODE        , "Режим работы Зона2",                      "IBOX Operating Mode Z2"},
//Trailer1 zone3
  {IBX_T1_Z3_ALRM_TYPE             , "Тип тревоги Зона3",                       "IBOX Alarm Type Z3"},
  {IBX_T1_Z3_ALRM_CODE             , "Код аварийной сигнализации Зона3",        "IBOX Alarm Code Z3"},
  {IBX_T1_Z3_TEMP_SENSOR_ASSIGN    , "Настройки датчиков температуры Зона3",    "IBOX Temp Sens Assign Z3"},
  {IBX_T1_Z3_RETURN_AIR1_TEMP      , "Температура отточного воздуха1 Зона3,°С", "IBOX Return Air1Temp Z3,°С"},
  {IBX_T1_Z3_SUPPLY1_TEMP          , "Температура приточного воздуха1 Зона3,°С","IBOX Supply1 Temp Z3,°С"},
  {IBX_T1_Z3_TEMP_SETPOINT         , "Установленная температура Зона3,°С",      "IBOX Temp Setpoint Z3,°С"},
  {IBX_T1_Z3_EVAPORATOR_COIL_TEMP  , "Температура испарителя Зона3,°С",         "IBOX Evap Coil Temp Z3,°С"},
  {IBX_T1_Z3_RETURN_AIR2_TEMP      , "Температура отточного воздуха2 Зона3,°С", "IBOX Return Air2Temp Z3,°С"},
  {IBX_T1_Z3_SUPPLY2_TEMP          , "Температура приточного воздуха2 Зона3,°С","IBOX Supply2 Temp Z3,°С"},
  {IBX_T1_Z3_OPERATING_MODE        , "Режим работы Зона3",                     "IBOX Operating Mode Z3"},
//DAS or Cargo Watch Sensors Information
  {IBX_T1_DIN0_3                   , "Цифровые входы",                         "IBOX Digital Inputs"},
  {IBX_T1_SENSOR_ASSIGN            , "Настр датч. темп./влажн./уровня топлива","IBOX T/H/FLev Sens Assign"},
  {IBX_T1_TEMP_SENSOR1             , "Датчик температуры 1, °С ",              "IBOX Sensor1 Temp, °С "},
  {IBX_T1_TEMP_SENSOR2             , "Датчик температуры 2, °С ",              "IBOX Sensor2 Temp, °С "},
  {IBX_T1_TEMP_SENSOR3             , "Датчик температуры 3, °С ",              "IBOX Sensor3 Temp, °С "},
  {IBX_T1_TEMP_SENSOR4             , "Датчик температуры 4, °С ",              "IBOX Sensor4 Temp, °С "},
  {IBX_T1_TEMP_SENSOR5             , "Датчик температуры 5, °С ",              "IBOX Sensor5 Temp, °С "},
  {IBX_T1_TEMP_SENSOR6             , "Датчик температуры 6, °С ",              "IBOX Sensor6 Temp, °С "},
  {IBX_T1_HUMIDITY_SENSOR          , "Датчик влажности IBOX, %",               "IBOX Humidity Sensor, %"},
  {IBX_T1_FUEL_LEVEL_SENSOR        , "Датчик уровня топлива, %",               "IBOX DAS Fuel Level, %"},
  {IBX_MID                         , "Идентификационный код сообщения",        "Identification code of the message"},

#endif //IBOX_PRESENT

#if defined(FLOWMETER_PRESENT)
  {FLOWMETER_COOMUNICATION_STATE   ,"Cвязь с Delta RS", "Delta RS online"},
  {FLOWMETER_FUEL_VOLUME    , "Объем топлива от момента включения, л","Fuel volume from the moment of switching on, l"},
  {FLOWMETER_FLOW_RATE      , "Текущая скорость потока, л/ч","Current flow rate, l/h"},
  {FLOWMETER_STATUS         , "Статус","Status" },
  {FLOWMETER_FUEL_VOLUME_FC , "Объем топлива камеры подачи от момента включения, л","Fuel supply chamber fuel from the moment of switching on, l"},
  {FLOWMETER_FLOW_RATE_FC   , "Текущая скорость потока камеры подачи, л/ч","Current flow rate of feed chamber, l/h"},
  {FLOWMETER_TEMP_FC        , "Температура камеры подачи, °С","Feed chamber temperature, °C"},
  {FLOWMETER_FUEL_VOLUME_RC , "Объем топлива камеры обратки от момента включения, л", "Fuel volume of the chamber of the return flow from the moment of switching on, l"},
  {FLOWMETER_FLOW_RATE_RC   , "Текущая скорость потока камеры обратки, л/ч", "Current flow rate of the return flow chamber, l/h"},
  {FLOWMETER_TEMP_RC        , "Температура камеры обратки, °С", "Return chamber temperature, °C"},
  {FLOWMETER_ACC_FUEL_IDL   , "Накоп. объем топлива в режиме Холостой ход, л","Accumulated fuel volume in idle, l"},
  {FLOWMETER_ACC_FUEL_NOM   , "Накоп. объем топлива в режиме Номинальный, л","Accumulated fuel volume in Nominal mode, l"},
  {FLOWMETER_ACC_FUEL_OVER  , "Накоп. объем топлива в режиме Перегрузка, л", "Accumulated fuel volume in Overload mode, l"},
  {FLOWMETER_ACC_FUEL_CH    , "Накоп. объем топлива в режиме Накрутка, л", "Accumulated fuel volume in the Cheat mode, l"},
  {FLOWMETER_ACC_FUEL_NEG   , "Накоп. объем топлива в режиме Отрицательный, л", "Accumulated fuel volume in Negative mode, l"},
  {FLOWMETER_ACC_FUEL_FC_IDL, "Накоп. объем топлива камеры подачи в режиме Холостой ход, л", "Accumulated fuel volume of the feed chamber in idle, l"},
  {FLOWMETER_ACC_FUEL_FC_NOM, "Накоп. объем топлива камеры подачи в режиме Номинальный, л", "Accumulated fuel volume of the feed chamber in Nominal mode, l"},
  {FLOWMETER_ACC_FUEL_FC_OV , "Накоп. объем топлива камеры подачи в режиме Перегрузка, л",  "Accumulated fuel volume of the feed chamber in Overload mode, l"},
  {FLOWMETER_ACC_FUEL_FC_CH , "Накоп. объем топлива камеры подачи в режиме Накрутка, л", "Accumulated fuel volume of the feed chamber in the Cheat mode, l"},
  {FLOWMETER_ACC_FUEL_RC_IDL, "Накоп. объем топлива камеры обратки в режиме Холостой ход, л", "Accumulated fuel volume of the return chamber in idle, l"},
  {FLOWMETER_ACC_FUEL_RC_NOM, "Накоп. объем топлива камеры обратки в режиме Номинальный, л", "Accumulated fuel volume of the return chamber in the Nominal mode, l"},
  {FLOWMETER_ACC_FUEL_RC_OV , "Накоп. объем топлива камеры обратки в режиме Перегрузка, л",  "Accumulated fuel volume of the return chamber in the Overload mode, l"},
  {FLOWMETER_ACC_FUEL_RC_CH , "Накоп. объем топлива камеры обратки в режиме Накрутка, л",  "Accumulated fuel volume of the return chamber in the Cheat mode, l"},
  {FLOWMETER_TIME_IDL       , "Время нахождения в режиме Холостой ход, сек", "Time spent in idle, sec"},
  {FLOWMETER_TIME_NOM       , "Время нахождения в режиме Номинальный, сек", "Time spent in Nominal mode, sec"},
  {FLOWMETER_TIME_OV        , "Время нахождения в режиме Перегрузка, сек", "Time spent in Overload mode, sec"},
  {FLOWMETER_TIME_CH        , "Время нахождения в режиме Накрутка, сек", "Time spent in the Cheat mode, sec"},
  {FLOWMETER_TIME_NEG       , "Время нахождения в режиме Отрицательный, сек", "Time spent in Negative mode, sec"},
  {FLOWMETER_TIME_FC_IDL    , "Время нахождения камеры подачи в режиме Холостой ход, сек", "The time of the feed chamber in the mode Idling, sec"},
  {FLOWMETER_TIME_FC_NOM    , "Время нахождения камеры подачи в режиме Номинальный, сек", "The time of the feed chamber in the Nominal mode, sec"},
  {FLOWMETER_TIME_FC_OV     , "Время нахождения камеры подачи в режиме Перегрузка, сек" ,"The time of the feed chamber in the Overload mode, sec"},
  {FLOWMETER_TIME_FC_CH     , "Время нахождения камеры подачи в режиме Накрутка, сек","The time of the feed chamber in the Cheat mode, sec"},
  {FLOWMETER_TIME_RC_IDL    , "Время нахождения камеры обратки в режиме Холостой ход, сек","The time of the return chamber in the mode Idling, sec"},
  {FLOWMETER_TIME_RC_NOM    , "Время нахождения камеры обратки в режиме Номинальный, сек" ,"The time of the return chamber in the Nominal mode, sec"},
  {FLOWMETER_TIME_RC_OV     , "Время нахождения камеры обратки в режиме Перегрузка, сек" ,"The time of the return chamber in the Overload mode, sec"},
  {FLOWMETER_TIME_RC_CH     , "Время нахождения камеры обратки в режиме Накрутка, сек" ,"The time of the return chamber in the Cheat mode, sec"},
  {FLOWMETER_TIME_INTERV    , "Время нахождения в режиме Вмешательство, сек" ,"Time spent in the Intervention, sec"},
  {FLOWMETER_TIME_SENS      , "Время работы датчика, сек", "Sensor operating time, s"},
  {FLOWMETER_SERIAL_NUM     , "Серийный номер прибора","Serial number of the device"},
  {FLOWMETER_DEVICE_TYPE    , "Тип прибора","Device type"},
#endif //(FLOWMETER_PRESENT)

#if defined(TPMS_PRESENT)
  {TPMS_COMUNICATION_STATE   , "Cвязь с TPMS 6-13", "TPMS 6-13 connection state"},
#if (MAX_TPMS_DAT_COUNT > 0)
  {TPMS_ID1                 ,"ID датчика 1", "Sensor 1 ID" },
  {TPMS_PRESSURE1           ,"Давление, датчик 1, кПа", "Pressure sensor 1, kPa" },
  {TPMS_TEMPER1             ,"Температура, датчик 1, °С", "Temperature sensor 1, °С"},
  {TPMS_FLAGS1              ,"Флаги датчика 1", "Sensor flags 1" },
#endif
#if (MAX_TPMS_DAT_COUNT > 1)
  {TPMS_ID2                 ,"ID датчика 2", "Sensor 2 ID" },
  {TPMS_PRESSURE2           ,"Давление, датчик 2, кПа", "Pressure sensor 2, kPa" },
  {TPMS_TEMPER2             ,"Температура, датчик 2, °С", "Temperature sensor 2, °С"},
  {TPMS_FLAGS2              ,"Флаги датчика 2", "Sensor flags 2" },
#endif
#if (MAX_TPMS_DAT_COUNT > 2)
  {TPMS_ID3                 ,"ID датчика 3", "Sensor 3 ID" },
  {TPMS_PRESSURE3           ,"Давление, датчик 3, кПа", "Pressure sensor 3, kPa" },
  {TPMS_TEMPER3             ,"Температура, датчик 3, °С", "Temperature sensor 3, °С"},
  {TPMS_FLAGS3              ,"Флаги датчика 3", "Sensor flags 3" },
#endif
#if (MAX_TPMS_DAT_COUNT > 3)
  {TPMS_ID4                 ,"ID датчика 4", "Sensor 4 ID" },
  {TPMS_PRESSURE4           ,"Давление, датчик 4, кПа", "Pressure sensor 4, kPa" },
  {TPMS_TEMPER4             ,"Температура, датчик 4, °С", "Temperature sensor 4, °С"},
  {TPMS_FLAGS4              ,"Флаги датчика 4", "Sensor flags 4" },
#endif
#if (MAX_TPMS_DAT_COUNT > 4)
  {TPMS_ID5                 ,"ID датчика 5", "Sensor 5 ID" },
  {TPMS_PRESSURE5           ,"Давление, датчик 5, кПа", "Pressure sensor 5, kPa" },
  {TPMS_TEMPER5             ,"Температура, датчик 5, °С", "Temperature sensor 5, °С"},
  {TPMS_FLAGS5              ,"Флаги датчика 5", "Sensor flags 5" },
#endif
#if (MAX_TPMS_DAT_COUNT > 5)
  {TPMS_ID6                 ,"ID датчика 6", "Sensor 6 ID" },
  {TPMS_PRESSURE6           ,"Давление, датчик 6, кПа", "Pressure sensor 6, kPa" },
  {TPMS_TEMPER6             ,"Температура, датчик 6, °С", "Temperature sensor 6, °С"}
  {TPMS_FLAGS6              ,"Флаги датчика 6", "Sensor flags 6" },
#endif
#if (MAX_TPMS_DAT_COUNT > 6)
  {TPMS_ID7                 ,"ID датчика 7", "Sensor 7 ID" },
  {TPMS_PRESSURE7           ,"Давление, датчик 7, кПа", "Pressure sensor 7, kPa" },
  {TPMS_TEMPER7             ,"Температура, датчик 7, °С", "Temperature sensor 7, °С"},
  {TPMS_FLAGS7              ,"Флаги датчика 7", "Sensor flags 7" },
#endif
#if (MAX_TPMS_DAT_COUNT > 7)
  {TPMS_ID8                 ,"ID датчика 8", "Sensor 8 ID" },
  {TPMS_PRESSURE8           ,"Давление, датчик 8, кПа", "Pressure sensor 8, kPa" },
  {TPMS_TEMPER8             ,"Температура, датчик 8, °С", "Temperature sensor 8, °С"},
  {TPMS_FLAGS8              ,"Флаги датчика 8", "Sensor flags 8" },
#endif
#if (MAX_TPMS_DAT_COUNT > 8)
  {TPMS_ID9                 ,"ID датчика 9", "Sensor 9 ID" },
  {TPMS_PRESSURE9           ,"Давление, датчик 9, кПа", "Pressure sensor 9, kPa" },
  {TPMS_TEMPER9             ,"Температура, датчик 9, °С", "Temperature sensor 9, °С"},
  {TPMS_FLAGS9              ,"Флаги датчика 9", "Sensor flags 9" },
#endif
#if (MAX_TPMS_DAT_COUNT > 9)
  {TPMS_ID10                ,"ID датчика 10", "Sensor 10 ID" },
  {TPMS_PRESSURE10          ,"Давление, датчик 10, кПа", "Pressure sensor 10, kPa" },
  {TPMS_TEMPER10            ,"Температура, датчик 10, °С", "Temperature sensor 10, °С"},
  {TPMS_FLAGS10             ,"Флаги датчика 10", "Sensor flags 10" },
#endif
#if (MAX_TPMS_DAT_COUNT > 10
  {TPMS_ID11                ,"ID датчика 11", "Sensor 11 ID" },
  {TPMS_PRESSURE11          ,"Давление, датчик 11, кПа", "Pressure sensor 11, kPa" },
  {TPMS_TEMPER11            ,"Температура, датчик 11, °С", "Temperature sensor 11, °С"},
  {TPMS_FLAGS11             ,"Флаги датчика 11", "Sensor flags 11" },
#endif
#if (MAX_TPMS_DAT_COUNT > 11
  {TPMS_ID12                ,"ID датчика 12", "Sensor 12 ID" },
  {TPMS_PRESSURE12          ,"Давление, датчик 12, кПа", "Pressure sensor 12, kPa" },
  {TPMS_TEMPER12            ,"Температура, датчик 12, °С", "Temperature sensor 12, °С"},
  {TPMS_FLAGS12             ,"Флаги датчика 12", "Sensor flags 12" },
#endif
#if (MAX_TPMS_DAT_COUNT > 12
  {TPMS_ID13                ,"ID датчика 13", "Sensor 13 ID" },
  {TPMS_PRESSURE13          ,"Давление, датчик 13, кПа", "Pressure sensor 13, kPa" },
  {TPMS_TEMPER13            ,"Температура, датчик 13, °С", "Temperature sensor 13, °С"},
  {TPMS_FLAGS13             ,"Флаги датчика 13", "Sensor flags 13" },
#endif
#if (MAX_TPMS_DAT_COUNT > 13
  {TPMS_ID14                ,"ID датчика 14", "Sensor 14 ID" },
  {TPMS_PRESSURE14          ,"Давление, датчик 14, кПа", "Pressure sensor 14, kPa" },
  {TPMS_TEMPER14            ,"Температура, датчик 14, °С", "Temperature sensor 14, °С"},
  {TPMS_FLAGS14             ,"Флаги датчика 14", "Sensor flags 14" },
#endif
#if (MAX_TPMS_DAT_COUNT > 14
  {TPMS_ID15                ,"ID датчика 15", "Sensor 15 ID" },
  {TPMS_PRESSURE15          ,"Давление, датчик 15, кПа", "Pressure sensor 15, kPa" },
  {TPMS_TEMPER15            ,"Температура, датчик 15, °С", "Temperature sensor 15, °С"},
  {TPMS_FLAGS15             ,"Флаги датчика 15", "Sensor flags 15" },
#endif
#if (MAX_TPMS_DAT_COUNT > 15
  {TPMS_ID16                ,"ID датчика 16", "Sensor 16 ID" },
  {TPMS_PRESSURE16          ,"Давление, датчик 16, кПа", "Pressure sensor 16, kPa" },
  {TPMS_TEMPER16            ,"Температура, датчик 16, °С", "Temperature sensor 16, °С"},
  {TPMS_FLAGS16             ,"Флаги датчика 16", "Sensor flags 16" },
#endif
#if (MAX_TPMS_DAT_COUNT > 16
  {TPMS_ID17                ,"ID датчика 17", "Sensor 17 ID" },
  {TPMS_PRESSURE17          ,"Давление, датчик 17, кПа", "Pressure sensor 17, kPa" },
  {TPMS_TEMPER17            ,"Температура, датчик 17, °С", "Temperature sensor 17, °С"},
  {TPMS_FLAGS17             ,"Флаги датчика 17", "Sensor flags 17" },
#endif
#if (MAX_TPMS_DAT_COUNT > 17
  {TPMS_ID18                ,"ID датчика 18", "Sensor 18 ID" },
  {TPMS_PRESSURE18          ,"Давление, датчик 18, кПа", "Pressure sensor 18, kPa" },
  {TPMS_TEMPER18            ,"Температура, датчик 18, °С", "Temperature sensor 18, °С"},
  {TPMS_FLAGS18             ,"Флаги датчика 18", "Sensor flags 18" },
#endif
#if (MAX_TPMS_DAT_COUNT > 18
  {TPMS_ID19                ,"ID датчика 19", "Sensor 19 ID" },
  {TPMS_PRESSURE19          ,"Давление, датчик 19, кПа", "Pressure sensor 19, kPa" },
  {TPMS_TEMPER19            ,"Температура, датчик 19, °С", "Temperature sensor 19, °С"},
  {TPMS_FLAGS19             ,"Флаги датчика 19", "Sensor flags 19" },
#endif
#if (MAX_TPMS_DAT_COUNT > 19
  {TPMS_ID20                ,"ID датчика 20", "Sensor 20 ID" },
  {TPMS_PRESSURE20          ,"Давление, датчик 20, кПа", "Pressure sensor 20, kPa" },
  {TPMS_TEMPER20            ,"Температура, датчик 20, °С", "Temperature sensor 20, °С"},
  {TPMS_FLAGS20             ,"Флаги датчика 20", "Sensor flags 20" },
#endif
#if (MAX_TPMS_DAT_COUNT > 20
  {TPMS_ID21                ,"ID датчика 21", "Sensor 21 ID" },
  {TPMS_PRESSURE21          ,"Давление, датчик 21, кПа", "Pressure sensor 21, kPa" },
  {TPMS_TEMPER21            ,"Температура, датчик 21, °С", "Temperature sensor 21, °С"},
  {TPMS_FLAGS21             ,"Флаги датчика 21", "Sensor flags 21" },
#endif
#if (MAX_TPMS_DAT_COUNT > 21
  {TPMS_ID22                ,"ID датчика 22", "Sensor 22 ID" },
  {TPMS_PRESSURE22          ,"Давление, датчик 22, кПа", "Pressure sensor 22, kPa" },
  {TPMS_TEMPER22            ,"Температура, датчик 22, °С", "Temperature sensor 22, °С"},
  {TPMS_FLAGS22             ,"Флаги датчика 22", "Sensor flags 22" },
#endif
#if (MAX_TPMS_DAT_COUNT > 22
  {TPMS_ID23                ,"ID датчика 23", "Sensor 23 ID" },
  {TPMS_PRESSURE23          ,"Давление, датчик 23, кПа", "Pressure sensor 23, kPa" },
  {TPMS_TEMPER23            ,"Температура, датчик 23, °С", "Temperature sensor 23, °С"},
  {TPMS_FLAGS23             ,"Флаги датчика 23", "Sensor flags 23" },
#endif
#if (MAX_TPMS_DAT_COUNT > 23
  {TPMS_ID24                ,"ID датчика 24", "Sensor 24 ID" },
  {TPMS_PRESSURE24          ,"Давление, датчик 24, кПа", "Pressure sensor 24, kPa" },
  {TPMS_TEMPER24            ,"Температура, датчик 24, °С", "Temperature sensor 24, °С"},
  {TPMS_FLAGS24             ,"Флаги датчика 24", "Sensor flags 24" },
#endif
#if (MAX_TPMS_DAT_COUNT > 24
  {TPMS_ID25                ,"ID датчика 25", "Sensor 25 ID" },
  {TPMS_PRESSURE25          ,"Давление, датчик 25, кПа", "Pressure sensor 25, kPa" },
  {TPMS_TEMPER25            ,"Температура, датчик 25, °С", "Temperature sensor 25, °С"}
  {TPMS_FLAGS25             ,"Флаги датчика 25", "Sensor flags 25" },
#endif
#if (MAX_TPMS_DAT_COUNT > 25
  {TPMS_ID26                ,"ID датчика 26", "Sensor 26 ID" },
  {TPMS_PRESSURE26          ,"Давление, датчик 26, кПа", "Pressure sensor 26, kPa" },
  {TPMS_TEMPER26            ,"Температура, датчик 26, °С", "Temperature sensor 26, °С"},
  {TPMS_FLAGS26             ,"Флаги датчика 26", "Sensor flags 26" },
#endif
#if (MAX_TPMS_DAT_COUNT > 26
  {TPMS_ID27                ,"ID датчика 27", "Sensor 27 ID" },
  {TPMS_PRESSURE27          ,"Давление, датчик 27, кПа", "Pressure sensor 27, kPa" },
  {TPMS_TEMPER27            ,"Температура, датчик 27, °С", "Temperature sensor 27, °С"},
  {TPMS_FLAGS27             ,"Флаги датчика 27", "Sensor flags 27" },
#endif
#if (MAX_TPMS_DAT_COUNT > 27
  {TPMS_ID28                ,"ID датчика 28", "Sensor 28 ID" },
  {TPMS_PRESSURE28          ,"Давление, датчик 28, кПа", "Pressure sensor 28, kPa" },
  {TPMS_TEMPER28            ,"Температура, датчик 28, °С", "Temperature sensor 28, °С"},
  {TPMS_FLAGS28             ,"Флаги датчика 28", "Sensor flags 28" },
#endif
#if (MAX_TPMS_DAT_COUNT > 28
  {TPMS_ID29                ,"ID датчика 29", "Sensor 29 ID" },
  {TPMS_PRESSURE29          ,"Давление, датчик 29, кПа", "Pressure sensor 29, kPa" },
  {TPMS_TEMPER29            ,"Температура, датчик 29, °С", "Temperature sensor 29, °С"},
  {TPMS_FLAGS29             ,"Флаги датчика 29", "Sensor flags 29" },
#endif
#if (MAX_TPMS_DAT_COUNT > 29
  {TPMS_ID30                ,"ID датчика 30", "Sensor 30 ID" },
  {TPMS_PRESSURE30          ,"Давление, датчик 30, кПа", "Pressure sensor 30, kPa" },
  {TPMS_TEMPER30            ,"Температура, датчик 30, °С", "Temperature sensor 30, °С"},
  {TPMS_FLAGS30             ,"Флаги датчика 30", "Sensor flags 30" },
#endif
#if (MAX_TPMS_DAT_COUNT > 30
  {TPMS_ID31                ,"ID датчика 31", "Sensor 31 ID" },
  {TPMS_PRESSURE31          ,"Давление, датчик 31, кПа", "Pressure sensor 31, kPa" },
  {TPMS_TEMPER31            ,"Температура, датчик 31, °С", "Temperature sensor 31, °С"},
  {TPMS_FLAGS31             ,"Флаги датчика 31", "Sensor flags 31" },
#endif
#if (MAX_TPMS_DAT_COUNT > 31
  {TPMS_ID32                ,"ID датчика 32", "Sensor 32 ID" },
  {TPMS_PRESSURE32          ,"Давление, датчик 32, кПа", "Pressure sensor 32, kPa" },
  {TPMS_TEMPER32            ,"Температура, датчик 32, °С", "Temperature sensor 32, °С"},
  {TPMS_FLAGS32             ,"Флаги датчика 32", "Sensor flags 32" },
#endif
#if (MAX_TPMS_DAT_COUNT > 32
  {TPMS_ID33                ,"ID датчика 33", "Sensor 33 ID" },
  {TPMS_PRESSURE33          ,"Давление, датчик 33, кПа", "Pressure sensor 33, kPa" },
  {TPMS_TEMPER33            ,"Температура, датчик 33, °С", "Temperature sensor 33, °С"},
  {TPMS_FLAGS33             ,"Флаги датчика 33", "Sensor flags 33" },
#endif
#if (MAX_TPMS_DAT_COUNT > 33
  {TPMS_ID34                ,"ID датчика 34", "Sensor 34 ID" },
  {TPMS_PRESSURE34          ,"Давление, датчик 34, кПа", "Pressure sensor 34, kPa" },
  {TPMS_TEMPER34            ,"Температура, датчик 34, °С", "Temperature sensor 34, °С"},
  {TPMS_FLAGS34             ,"Флаги датчика 34", "Sensor flags 34" },
#endif
#if (MAX_TPMS_DAT_COUNT > 34
  {TPMS_ID35                ,"ID датчика 35", "Sensor 35 ID" },
  {TPMS_PRESSURE35          ,"Давление, датчик 35, кПа", "Pressure sensor 35, kPa" },
  {TPMS_TEMPER35            ,"Температура, датчик 35, °С", "Temperature sensor 35, °С"},
  {TPMS_FLAGS35             ,"Флаги датчика 35", "Sensor flags 35" },
#endif
#if (MAX_TPMS_DAT_COUNT > 35
  {TPMS_ID36                ,"ID датчика 36", "Sensor 36 ID" },
  {TPMS_PRESSURE36          ,"Давление, датчик 36, кПа", "Pressure sensor 36, kPa" },
  {TPMS_TEMPER36            ,"Температура, датчик 36, °С", "Temperature sensor 36, °С"},
  {TPMS_FLAGS36             ,"Флаги датчика 36", "Sensor flags 36" },
#endif
#if (MAX_TPMS_DAT_COUNT > 36
  {TPMS_ID37                ,"ID датчика 37", "Sensor 37 ID" },
  {TPMS_PRESSURE37          ,"Давление, датчик 37, кПа", "Pressure sensor 37, kPa" },
  {TPMS_TEMPER37            ,"Температура, датчик 37, °С", "Temperature sensor 37, °С"},
  {TPMS_FLAGS37             ,"Флаги датчика 37", "Sensor flags 37" },
#endif
#if (MAX_TPMS_DAT_COUNT > 37
  {TPMS_ID38                ,"ID датчика 38", "Sensor 38 ID" },
  {TPMS_PRESSURE38          ,"Давление, датчик 38, кПа", "Pressure sensor 38, kPa" },
  {TPMS_TEMPER38            ,"Температура, датчик 38, °С", "Temperature sensor 38, °С"},
  {TPMS_FLAGS38             ,"Флаги датчика 38", "Sensor flags 38" },
#endif
#if (MAX_TPMS_DAT_COUNT > 38
  {TPMS_ID39                ,"ID датчика 39", "Sensor 39 ID" },
  {TPMS_PRESSURE39          ,"Давление, датчик 39, кПа", "Pressure sensor 39, kPa" },
  {TPMS_TEMPER39            ,"Температура, датчик 39, °С", "Temperature sensor 39, °С"},
  {TPMS_FLAGS39             ,"Флаги датчика 39", "Sensor flags 39" },
#endif
#if (MAX_TPMS_DAT_COUNT > 39
  {TPMS_ID40                ,"ID датчика 40", "Sensor 40 ID" },
  {TPMS_PRESSURE40          ,"Давление, датчик 40, кПа", "Pressure sensor 40, kPa" },
  {TPMS_TEMPER40            ,"Температура, датчик 40, °С", "Temperature sensor 40, °С"},
  {TPMS_FLAGS40             ,"Флаги датчика 40", "Sensor flags 40" },
#endif
#if (MAX_TPMS_DAT_COUNT > 40
  {TPMS_ID41                ,"ID датчика 41", "Sensor 41 ID" },
  {TPMS_PRESSURE41          ,"Давление, датчик 41, кПа", "Pressure sensor 41, kPa" },
  {TPMS_TEMPER41            ,"Температура, датчик 41, °С", "Temperature sensor 41, °С"},
  {TPMS_FLAGS41             ,"Флаги датчика 41", "Sensor flags 41" },
#endif
#if (MAX_TPMS_DAT_COUNT > 41
  {TPMS_ID42                ,"ID датчика 42", "Sensor 42 ID" },
  {TPMS_PRESSURE42          ,"Давление, датчик 42, кПа", "Pressure sensor 42, kPa" },
  {TPMS_TEMPER42            ,"Температура, датчик 42, °С", "Temperature sensor 42, °С"},
  {TPMS_FLAGS42             ,"Флаги датчика 42", "Sensor flags 42" },
#endif
#endif //TPMS_PRESENT

#if defined(IRIDIUM_PRESENT)
  {IRIDIUM_COOMUNICATION_STATE     , "Cвязь с IRIDIUM", "IRIDIUM online"},
  {IRIDIUM_MESS_STATE       , "Статус передачи через Iridium","The status of the transfer by Iridium" },
  {IRIDIUM_TRAFFIC          , "Передано байт на IRIDIUM", "TX bytes to IRIDIUM" },
#endif //IRIDIUM_PRESENT

#if defined(DISPLAY_PRESENT)
  {DISPLAY_COOMUNICATION_STATE  , "Cвязь с OP320", "OP320 online"},
#endif // (DISPLAY_PRESENT)

    {VEGA_MCC                 , "MCC", "MCC"},
    {VEGA_MNC                 , "MNC", "MNC"},
    {VEGA_LAC                 , "LAC", "LAC"},
    {VEGA_CELLID              , "CELLID", "CELLID"},
    {VEGA_GSM_SIGNAL_LEVEL    , "Уровень сигнала GSM", "GSM signal level"},
    //{VEGA_GSM_BALANCE         , "Баланс SIM", "SIM balance"},
    {VEGA_GSM_JAMMED          , "Датчик глушения GSM", "GSM jamming sensor"},
    {VEGA_TX_DATA_SERV1       , "Передано Кб на сервер 1", "Server 1 TX kbytes"},
    {VEGA_TX_DATA_SERV2       , "Передано Кб на сервер 2", "Server 2 TX kbytes"},
    {VEGA_TX_DATA_SERV3       , "Передано Кб на сервер 3", "Server 3 TX kbytes"},
    {VEGA_TX_DATA_SERV4       , "Передано Кб на сервер 4", "Server 4 TX kbytes"},
    {VEGA_RX_DATA_SERV1       , "Принято Кб от сервера 1", "Server 1 RX kbytes"},
    {VEGA_RX_DATA_SERV2       , "Принято Кб от сервера 2", "Server 2 RX kbytes"},
    {VEGA_RX_DATA_SERV3       , "Принято Кб от сервера 3", "Server 3 RX kbytes"},
    {VEGA_RX_DATA_SERV4       , "Принято Кб от сервера 4", "Server 4 RX kbytes"},
    {VEGA_GSM_ACT             , "Технология доступа", "Access technology"},
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
    {VEGA_EXT_SERVING_CELL_INF, "Информация о БС" , "Serving cells info"},
    {VEGA_GSM_SCAN_MODE,        "Режим сканирования сети" , "Scan mode"},
#endif //YANDEX_EXTENDED_SENSORS_PRESENT
    {VEGA_GSM_USED_SIM        , "Используемая SIM", "Used SIM" },
    {VEGA_GSM_LBS             , "GSM LBS",          "GSM LBS"  },
#if defined(BALANCE_REQUEST_PRESENT)
    {VEGA_GSM_SIM1_BALANCE    , "Баланс SIM1", "SIM1 balance"},
#if (MAX_SIM_COUNT > 1)
    {VEGA_GSM_SIM2_BALANCE    , "Баланс SIM2", "SIM2 balance"},
#endif
#endif //defined(BALANCE_REQUEST_PRESENT)
#if defined(CANPRO_PRESENT)
    // Числовые параметры
    {CAN_ENGNE_UPTIME         , "CAN: Суммарное время работы двигателя, мин.", "CAN engine uptime, min."},
    {CAN_ENGINE_UPTIME_P      , "CAN: Суммарное время работы двигателя (до сброса), мин.", "CAN engine uptime before reset, min."},
    {CAN_ODOMETER_KM          , "CAN: Полный пробег, км.", "CAN odometer, km."},
    {CAN_ODOMETER_P           , "CAN: Полный пробег, (до сброса), км", "CAN odometer before reset, km."},
    {CAN_CONSUMED_FUEL_L      , "CAN: Общее потребление топлива, л.", "CAN fuel consumption, l."},
    {CAN_CONSUMED_FUEL_P      , "CAN: Общее потребление топлива (до сброса), л.", "CAN fuel consumption before reset, l."},
    {CAN_FUEL_LEVEL_P         , "CAN: Уровень топлива, %", "CAN fuel level, %"},
    #if defined(RELEASE_TYPE_YANDEX)
    {CAN_FUEL_LEVEL_L         , "CAN: Запас хода, км", "CAN fuel distance, km"},
    #else
    {CAN_FUEL_LEVEL_L         , "CAN: Уровень топлива, л", "CAN fuel level, l"},
    #endif
    {CAN_ENGINE_RPM           , "CAN: Обороты двигателя, rpm", "CAN RPM"},
    {CAN_ENGINE_TEMP          , "CAN: Температура двигателя", "CAN engine temperature"},
    {CAN_SPEED                , "CAN: Скорость", "CAN vehicle speed"},
    {CAN_AXLE_1               , "CAN: Нагрузка на ось 1, кг", "CAN axle 1 load"},
    {CAN_AXLE_2               , "CAN: Нагрузка на ось 2, кг", "CAN axle 2 load"},
    {CAN_AXLE_3               , "CAN: Нагрузка на ось 3, кг", "CAN axle 3 load"},
    {CAN_AXLE_4               , "CAN: Нагрузка на ось 4, кг", "CAN axle 4 load"},
    {CAN_AXLE_5               , "CAN: Нагрузка на ось 5, кг", "CAN axle 5 load"},
    #if defined(RELEASE_TYPE_YANDEX)
    {CAN_FUEL_FLOW            , "CAN: Расход топлива, л/100км", "CAN fuel consumption, l/100km"},
    #else
    {CAN_FUEL_FLOW            , "CAN: Мгновенный расход топлива, л/ч", "CAN instant fuel consumption, l/h"},
    #endif

    {CAN_ADBLUE_P             , "CAN: Уровень жидкости AdBlue, %", "CAN AdBlue level, %"},
    {CAN_ADBLUE_L             , "CAN: Уровень жидкости AdBlue, л", "CAN AdBlue level, l."},
    {CAN_HARVEST_TIME         , "CAN: Время сбора урожая, мин.", "CAN harvesting time, min."},
    {CAN_HARVEST_AREA         , "CAN: Убранная площадь, Га", "CAN harvested area, hectare"},
    {CAN_HARVEST_EFF          , "CAN: Эффективность уборки, Га/ч", "CAN harvesting efficiency"},
    {CAN_HARVEST_GRAIN        , "CAN: Количество убранного зерна, кг.", "CAN harvested grain, kg"},
    {CAN_GRAIN_MOISTURE       , "CAN: Влажность зерна, %", "CAN grain moisture, %"},
    {CAN_ACCELERATOR          , "CAN: Положение педали акселератора, %", "CAN accelerator, %"},
    {CAN_ENGINE_LOAD          , "CAN: Нагрузка двигателя, %", "CAN engine load, %"},
    {CAN_THRESHER_RPM         , "CAN: Обороты молотильного барабана, rpm", "CAN tresher rpm"},
    {CAN_CONCAVE_CLR          , "CAN: Отброшенное состояние подбарабанья, мм", "CAN concave dropped, mm"},

    {CAN_ODO_BEF_SERVICE      , "CAN: Пробег до сервисного обслуживания", "CAN mileage before maintanence, km"},
    {CAN_ODO_SERVICE_EX       , "CAN: Превышение пробега до сервисного обслуживания", "CAN mileage exceeding, km"},
    {CAN_ODO_AFTER_SERVICE    , "CAN: Пробег после сервисного обслуживания", "CAN mileage after maintanence, km"},
    {CAN_TIME_BEF_SERVICE     , "CAN: Время до сервисного обслуживания", "CAN time before maintanence"},
    {CAN_TIME_SERVICE_EX      , "CAN: Время превышения сервисного обслуживания", "CAN maintanence exceeding time"},
    {CAN_TIME_AFTER_SERVICE   , "CAN: Время после сервисного обслуживания", "CAN time after last maintanence"},
    {CAN_BATTERY_CHARGE_LEVEL , "CAN: Уровень заряда батареи, %", "CAN battery level, %"},
    {CAN_BATTERY_TEMPERATURE  , "CAN: Температура батареи, °C", "CAN battery temperature, °C"},

    // Приборная панель
    {CAN_STOP                 , "CAN: СТОП", "CAN STOP indicator"},
    {CAN_CHECK_OIL            , "CAN: Давление/уровень масла", "CAN oil pressure/level indicator"},
    {CAN_CHECK_COOLANT        , "CAN: Температура/уровень хладагента", "CAN antifreeze indicator"},
    {CAN_CHECK_HAND_BREAK     , "CAN: Система ручного тормоза", "CAN hand break indicator"},
    {CAN_BATTERY              , "CAN: Заряд батареи", "CAN battery indicator"},
    {CAN_AIRBAG               , "CAN: AIRBAG", "CAN airbag indicator"},
    {CAN_CHECK_ENGINE         , "CAN: Check engine", "CAN check engine indicator"},
    {CAN_FAULT_LIGHTING       , "CAN: Неисправность освещения", "CAN light fault indicator"},
    {CAN_INFLATION_PRESSURE   , "CAN: Низкое давление воздуха в шинах", "CAN low tire pressure"},
    {CAN_CHECK_BRAKE_PADS     , "CAN: Изношенные тормозные колодки", "CAN brake pads indicator"},
    {CAN_WARNING              , "CAN: Предупреждение", "CAN warning"},
    {CAN_ABS                  , "CAN: ABS (антиблокировочная система)", "CAN ABS indicator"},
    {CAN_FUEL_LEVEL           , "CAN: Низкий уровень топлива", "CAN low fuel level indicator"},
    {CAN_ESP                  , "CAN: ESP", "CAN ESP indicator"},
    {CAN_SPARK_PLUG           , "CAN: Индикатор запальной свечи", "CAN spark plug indicator"},
    {CAN_FAP                  , "CAN: FAP (Фильтр макрочастиц)", "CAN FAP indicator"},
    {CAN_PRESSURE_CONTROL     , "CAN: Электрическая регулировка давления", "CAN electronic pressure control indicator"},
    {CAN_MARKER_LIGHTS        , "CAN: Габаритные огни", "CAN parking lights indicator"},
    {CAN_DIPPED_BEAM          , "CAN: Ближний свет фар", "CAN dipped headlights"},
    {CAN_HIGH_BEAM            , "CAN: Дальний свет фар", "CAN high beam headlights"},
    {CAN_PASSENGER_SAFE_BELT  , "CAN: Ремень безопасности пассажира", "CAN passengers safety belt indicator"},
    {CAN_DRIVER_SAFE_BELT     , "CAN: Ремень безопасности водителя", "CAN drivers safety belt indicator"},
    {CAN_READY_FOR_MOTION     , "CAN: Готовность начать движение", "CAN ready for motion"},

    // Охрана
    {CAN_KEY_IN_IGN           , "CAN: Ключ в замке зажигания ", "CAN key in ignition lock"},
    {CAN_IGNITION             , "CAN: Зажигание", "CAN ignition"},
    {CAN_DYNAMIC_IGN          , "CAN: Динамическое зажигание", "CAN dynamic ignition"},
    {CAN_WEBASTO              , "CAN: Webasto", "CAN webasto"},
    {CAN_CLOSED_BY_PULT       , "CAN: Автомобиль закрыт с заводского пульта управления", "CAN car is closed with the remote control"},
    {CAN_ALARM_ACT            , "CAN: Тревога заводской сигнализации", "CAN car alarm"},
    {CAN_NATIVE_ALARM         , "CAN: Заводская сигнализация эмулируется модулем", "CAN car alarm emulated by module"},
    {CAN_PARKING              , "CAN: Коробка передач в положение P", "CAN gearbox in position P"},
    {CAN_HAND_BREAK           , "CAN: Задействован ручной тормоз", "CAN hand brake"},
    {CAN_PEDAL_BREAK          , "CAN: Задействован ножной тормоз", "CAN brake pedal"},
    {CAN_ENGINE_IS_ON         , "CAN: Двигатель заведен", "CAN engine is on"},
    {CAN_REVERSE_GEAR         , "CAN: Включена задняя передача", "CAN rear gear"},
    {CAN_DRIVER_DOOR          , "CAN: Дверь водителя открыта", "CAN drivers door opened"},
    {CAN_PASS_DOOR            , "CAN: Пассажирская дверь открыта", "CAN passengers door open"},
    {CAN_L_REAR_DOOR          , "CAN: Левая задняя дверь открыта", "CAN rear left door opened"},
    {CAN_R_REAR_DOOR          , "CAN: Правая задняя дверь открыта", "CAN rear right door opened"},
    {CAN_HOOD                 , "CAN: Капот открыт", "CAN hood opened"},
    {CAN_TRUNK                , "CAN: Крышка багажника открыта", "CAN trunk opened"},
    {CAN_REMOTE_CONTROL       , "CAN: Состояние заводской сигнализации", "CAN car alarm state"},
    {CAN_IN_SLEEP             , "CAN: CAN-модуль вошел в режим «sleep»", "CAN module in sleep mode"},
    {CAN_BATTERY_CHARGING     , "CAN: Зарядка аккумулятора", "CAN battery charging"},
    {CAN_CHARGING_CABLE       , "CAN: Подключен кабель для зарядки", "CAN connected charging cable"},

    // Спецтехника а агротехника
    {CAN_TRESHER_ON           , "CAN: Молотильный барабан включён", "CAN tresher on"},
    {CAN_UNLOAD_TUBE_ON       , "CAN: Включена выгрузная труба", "CAN unload pipe on"},
    {CAN_REAR_PTO_UNIT_ON     , "CAN: Включен задний блок отбора мощности", "CAN rear power takeoff is on"},
    {CAN_FRONT_PTO_UNIT_ON    , "CAN: Включен передний блок отбора мощности", "CAN front power takeoff is on"},
    {CAN_TRESHER_GAP          , "CAN: Чрезмерный люфт под молотильным барабаном", "CAN excessive gap under tresher"},
    {CAN_GR_TNK_OPEN          , "CAN: Открыт вход в зерновой бункер", "CAN entrance to the grain bunker is opened"},
    {CAN_GR_TNK_100           , "CAN: Бункер зерна 100%", "CAN grain bunker 100%"},
    {CAN_GR_TNK_70            , "CAN: Бункер зерна 70%", "CAN grain bunker 70%"},
    {CAN_HYDR_FLTR_CLOG       , "CAN: Засорен фильтр масла гидравлической системы", "CAN hydraulic system oil filter is clogged"},
    {CAN_HYDR_PRESS_LOW       , "CAN: Низкое давление масла гидравлической системы", "CAN hydraulic system low oil pressure"},
    {CAN_HYDR_LEVEL_LOW       , "CAN: Низкий уровень масла гидравлического", "CAN hydraulic system oil level is low"},
    {CAN_BR_FLTR_CLOG         , "CAN: Засорен фильтр гидросистемы тормозов", "CAN brake hydraulic system filter is clogged"},
    {CAN_OIL_FLTR_CLOG        , "CAN: Засорен масляный фильтр двигателя", "CAN engine oil filter is clogged"},
    {CAN_FUEL_FLTR_CLOG       , "CAN: Засорен топливный фильтр", "CAN fuel filter is clogged"},
    {CAN_AIR_FLTR_CLOG        , "CAN: Засорен воздушный фильтр", "CAN air filter is clogged"},
    {CAN_HYDR_TEMP_ALERT      , "CAN: Аварийная температура масла в гидросистеме ходовой части", "CAN chassis hydraulic system oil temperature alarm"},
    {CAN_PCH_TEMP_ALERT       , "CAN: Аварийная температура масла в гидросистеме силовых цилиндров", "CAN power cylinders hydraulic system oil temperature alarm"},
    {CAN_OIL_PRESS_ALERT      , "CAN: Аварийное давление масла в двигателе", "CAN engine oil pressure alarm"},
    {CAN_COOLANT_ALERT        , "CAN: Аварийный уровень охлаждающей жидкости", "CAN coolant level alarm"},
    {CAN_HBLOCK_SECTION       , "CAN: Переливная секция гидроблока", "CAN hydraulic unit transfusion section"},
    {CAN_SCREW_ALERT          , "CAN: Включен привод выгрузного шнека при слож. выгрузн. трубе", "CAN unload auger gear is on"},
    {CAN_NO_OPERATOR          , "CAN: Оператор отсутствует", "CAN no operator"},
    {CAN_STRAW_ALERT          , "CAN: Забивание соломотряса", "CAN straw rake is clogged"},
    {CAN_WATER_IN_FUEL        , "CAN: Наличие воды в топливе", "CAN water in fuel"},
    {CAN_CLEAR_FAN            , "CAN: Обороты вентилятора очистки", "CAN cleaning fan is on"},
    {CAN_REEL                 , "CAN: Обороты барабана", "CAN drum is on"},
    {CAN_LOW_WATER            , "CAN: Низкий уровень воды в баке", "CAN water level in tank is low"},
    {CAN_AUTONOM_ENGINE       , "CAN: Автономный двигатель заведен", "CAN autonomous engine is on"},
    {CAN_JOY_RIGHT_R          , "CAN: Правый джойстик вправо", "CAN right joystick in right position"},
    {CAN_JOY_LEFT_R           , "CAN: Правый джойстик влево", "CAN right joystick in left position"},
    {CAN_JOY_FRONT_R          , "CAN: Правый джойстик вперед", "CAN right joystick in front position"},
    {CAN_JOY_BACK_R           , "CAN: Правый джойстик назад", "CAN right joystick in rear position"},
    {CAN_JOY_RIGHT_L          , "CAN: Левый джойстик вправо", "CAN left joystick in right position"},
    {CAN_JOY_LEFT_L           , "CAN: Левый джойстик влево", "CAN left joystick in left position"},
    {CAN_JOY_FRONT_L          , "CAN: Левый джойстик вперед", "CAN left joystick in front position"},
    {CAN_JOY_BACK_L           , "CAN: Левый джойстик назад", "CAN left joystick in rear position"},
    {CAN_BRUSH_ON             , "CAN: Щетка включена", "CAN brush is on"},
    {CAN_WATER_ON             , "CAN: Подача воды включена", "CAN water supply is on"},
    {CAN_VACCLEANER           , "CAN: Пылесос", "CAN vacuum cleaner is on"},
    {CAN_BUNKER_UPLOAD        , "CAN: Выгрузка из бункера", "CAN unloading from the bunker"},
    {CAN_KERCHER              , "CAN: Мойка высокого давления (Kерхер)", "CAN karcher is on"},
    {CAN_SALT_DIFFUSION       , "CAN: Рассеивание соли (песка) включено", "CAN salt diffusion"},
    {CAN_SALT_LOW             , "CAN: Низкий уровень соли (песка) в баке", "CAN salt low level"},
    {CAN_FRONT_HYDR_1         , "CAN: Включена первая передняя гидравлика", "CAN first front hydraulics is on"},
    {CAN_FRONT_HYDR_2         , "CAN: Включена вторая передняя гидравлика", "CAN second front hydraulics is on"},
    {CAN_FRONT_HYDR_3         , "CAN: Включена трятья передняя гидравлика", "CAN third front hydraulics is on"},
    {CAN_FRONT_HYDR_4         , "CAN: Включена четвертая передняя гидравлика", "CAN four front hydraulics is on"},
    {CAN_REAR_HYDR_1          , "CAN: Включена первая задняя гидравлика", "CAN first rear hydraulics is on"},
    {CAN_REAR_HYDR_2          , "CAN: Включена вторая задняя гидравлика", "CAN second rear hydraulics is on"},
    {CAN_REAR_HYDR_3          , "CAN: Включена третья задняя гидравлика", "CAN third rear hydraulics is on"},
    {CAN_REAR_HYDR_4          , "CAN: Включена четвертая задняя гидравлика", "CAN four rear hydraulics is on"},
    {CAN_FRONT_SUSP_SYS       , "CAN: Включёна передняя трехточечная система подвески", "CAN front three-point suspension system is on"},
    {CAN_REAR_SUSP_SYS        , "CAN: Включёна задняя трехточечная система подвески", "CAN rear three-point suspension system"},
#endif  //CANPRO_PRESENT

#if defined(EXTENDED_ADVANTUM_CAN_PRESENT)
    {CAN_STAT_TRANSMISSION          , "CAN: Статус трансмиссии", "CAN: Special flags"},
    {CAN_OTPUT_SPEED_KP             , "CAN: Частота вращения выходного вала КП, об/мин", "CAN: Special flags, rpm"},
    {CAN_CLUTCH_SLIP                , "CAN: Пробуксовка сцепления, %", "CAN: Special flags"},
    {CAN_INPUT_SPEED_KP             , "CAN: Частота вращения первичного вала КП, об/мин", "CAN: Special flags, rpm"},
    {CAN_SELECTED_GEAR              , "CAN: Выбранная передача", "CAN: Special flags"},
    {CAN_GEAR_RATIO                 , "CAN: Текущее передаточное число КП", "CAN: Special flags"},
    {CAN_CURRENT_GEAR               , "CAN: Текущая/последняя передача", "CAN: Special flags"},
    {CAN_SHIFT_FINGER_ST            , "CAN: Передача включена", "CAN: Special flags"},
    {CAN_NEUTRAL_IND_KP             , "CAN: Индикатор нейтрали КПП", "CAN: Transmission Neutral Indicator"},
    {CAN_NMV_STATE                  , "CAN: Статус механизма отбора мощности NMV", "CAN: NMV state"},
    {CAN_PTO1_STATE                 , "CAN: Статус механизма отбора мощности NA1", "CAN: PTO1 state"},
    {CAN_PTO2_STATE                 , "CAN: Статус механизма отбора мощности NA2", "CAN: PTO2 state"},
    {CAN_PARK_BRAKE_SW              , "CAN: Включение стояночного тормоза", "CAN: Activate the parking brake"},
    {CAN_CLUTCH_SW                  , "CAN: Нажатие педали сцепления", "CAN: Pushing the clutch pedal"},
    {CAN_BRAKE_SW                   , "CAN: Нажатие педали тормоза", "CAN: Pressing the brake pedal"},
    {CAN_CC_ACTIVE                  , "CAN: Круиз-контроль активен", "CAN: Cruise control active"},
    {CAN_PTO_STATE                  , "CAN: Статус механизмов отбора мощности", "CAN: PTO state"},
    {CAN_ABS_ACTIVE                 , "CAN: АБС активна", "CAN: ABS active"},
    {CAN_BP_POSITION                , "CAN: Положение педали тормоза, %", "CAN: Brake pedal position, %"},
    {CAN_SHIFT_REAR_ST              , "CAN: Задняя передача включена", "CAN: Reverse gear included"},
    {CAN_FUEL_LEVEL_LOW             , "CAN: Cлишком низкий уровень топлива в баке", "CAN: Fuel level too low"},
    {CAN_EMERGENCY_SHUTDOWN         , "CAN: Аварийное отключение", "CAN: Emergency shutdown"},
    {CAN_ACT_ENG_TORQUE             , "CAN: Крутящий момент двигателя", "CAN: Engine torque"},
    {CAN_AP_KICKDOWN_SW             , "CAN: Режим Kickdown", "CAN: Kickdown mode"},
    {CAN_AP_LOW_IDLE_SW             , "CAN: Режим холостого хода", "CAN: Idle mode"},
    {CAN_LOAD_CURR_SPEED            , "CAN: Степень использования двигателя по мощности, % ", "CAN: Power utilization rate, %"},
    {CAN_ENG_OIL_PRESS              , "CAN: Давление масла, бар", "CAN: Oil pressure, bar"},
    {CAN_FUEL_TEMP                  , "CAN: Температура топлива, °C", "CAN: Fuel temperature, °C"},
    {CAN_ENG_OIL_TEMP               , "CAN: Температура моторного масла, °C", "CAN: Engine oil temperature, °C"},
    {CAN_P_SUPPLY_PRESS             , "CAN: Давление воздуха, бар", "CAN: Special flags, bar"},
    {CAN_PARK_TR_PRESS              , "CAN: Давление воздуха в системе стояночного тормоза, бар", "CAN: Air pressure in the parking brake system, bar"},
    {CAN_SERV_BRAKE_PRESS1          , "CAN: Давление в рабочей тормозной системе, контур #1, бар", "CAN: Working brake pressure, circuit # 1, bar"},
    {CAN_SERV_BRAKE_PRESS2          , "CAN: Давление в рабочей тормозной системе, контур #2, бар", "CAN: Working brake pressure, circuit # 2, bar"},
    {CAN_AUX_EQUIP_PRESS            , "CAN: Давление воздуха для дополнительного оборудования , бар", "CAN: Air pressure for additional equipment, bar"},
    {CAN_AIR_SUSP_PRESS             , "CAN: Давление в пневмоподвеске, бар ", "CAN: Air suspension pressure, bar"},
    {CAN_BAR_PRESS                  , "CAN: Атмосферное давление, бар", "CAN: Atmosphere pressure, bar"},
    {CAN_AMB_AIR_TEMP               , "CAN: Температура атмосферного воздуха, °C", "CAN: Air temperature, °C"},
    {CAN_SECONDS                    , "CAN: Секунды", "CAN: Seconds"},
    {CAN_MINUTES                    , "CAN: Минуты", "CAN: Minutes"},
    {CAN_HOURS                      , "CAN: Часы", "CAN: Hours"},
    {CAN_MONTH                      , "CAN: Месяц", "CAN: Mounth"},
    {CAN_DAY                        , "CAN: День", "CAN: Day"},
    {CAN_YEAR                       , "CAN: Год", "CAN: Year"},
    {CAN_SH_MIN_GMT                 , "CAN: Отличие местного времени от GMT(минуты)", "CAN: Difference of local time from GMT (minutes)"},
    {CAN_SH_HRS_GMT                 , "CAN: Отличие местного времени от GMT(часы)", "CAN: Difference of local time from GMT (hours)"},
    {CAN_TRIP_DISTANCE              , "CAN: Счетчик суточного пробега, км", "CAN: Trip distance, km"},
    {CAN_AXLE_LOC_EBS               , "CAN: EBS. Расположение оси", "CAN: EBS. Axis location"},
    {CAN_AXLE_WEIGHT_EBS            , "CAN: EBS. Нагрузка на ось, кг", "CAN: EBS. Axle weight, kg"},
    {CAN_AXLE_LOC_EACS              , "CAN: EACS. Расположение оси", "CAN: EACS. Axis location"},
    {CAN_AXLE_WEIGHT_EACS           , "CAN: EACS. Нагрузка на ось, кг", "CAN: EACS. Axle weight, kg"},
    {CAN_MOTION_DETECTION           , "CAN: Распознавание движения ", "CAN: Motion detection"},
    {CAN_DRIVER2_STATUS             , "CAN: Статус водителя 2", "CAN: Driver 2 status"},
    {CAN_DRIVER1_STATUS             , "CAN: Статус водителя 1", "CAN: Driver 1 status"},
    {CAN_OVER_SPEED                 , "CAN: Превышение скорости", "CAN: Over speed"},
    {CAN_DRIVER1_CARD               , "CAN: Карта водителя 1", "CAN: Driver 1 card"},
    {CAN_DRIVER1_DATA               , "CAN: Данные, связанные со временем работы водителя 1", "CAN: Data associated with the time of the driver 1"},
    {CAN_DRIVER2_CARD               , "CAN: Карта водителя 2", "CAN: Driver 2 card"},
    {CAN_DRIVER2_DATA               , "CAN: Данные, связанные со временем работы водителя 2", "CAN: Data associated with the time of the driver 2"},
    {CAN_SYSTEM_OPER                , "CAN: Работа системы", "CAN: System operation"},
    {CAN_SERVICE_MESS               , "CAN: Служебные сообщения", "CAN: Service messages"},
    {CAN_SYSTEM_EVENTS              , "CAN: Системные события", "CAN: System events"},
    {CAN_VEH_SPEED_MTCO             , "CAN: Скорость автомобиля, записанная тахографом, км/ч", "CAN: Vehicle speed recorded by tachograph, km/h"},
    {CAN_ACT_RX_TORQUE              , "CAN: Текущий тормозной момент, %", "CAN: Current braking torque, %"},
    {CAN_QUERY_SUPPORT              , "CAN: Поддержка запросов", "CAN: Query support"},
    {CAN_DIAG_SUPPORT               , "CAN: Поддержка диагностики", "CAN: Diagnostic support"},
    {CAN_VER_SOFT                   , "CAN: Поддерживаемая версия ПО", "CAN: Supported Software Version"},
    {CAN_VIN_CAR                    , "CAN: VIN. Идентификационный номер автомобиля", "CAN: VIN"},
    {CAN_ACT_RET_TORQ_RE            , "CAN: Первичный ретардер Текущий тормозной момент, %", "CAN: Primary retarder Current braking moment, %"},
    {CAN_ACT_RET_TORQ_RD            , "CAN: Вторичный ретардер Текущий тормозной момент, %", "CAN: Secondary retarder Current braking moment, %"},
    {CAN_FUEL_RATE                  , "CAN: Удельный расход топлива, л/ч", "CAN: Fuel rate, l/h"},
    {CAN_INS_FUEL_ECO               , "CAN: Путевой расход топлива", "CAN: Instant fuel, km/l"},
    {CAN_LOW_OIL_PRESS              , "CAN: Слишком низкое давление масла", "CAN: Oil pressure too low"},
    {CAN_HIGH_COOLANT_T             , "CAN: Слишком высокая температура охлаждающей жидкости", "CAN: Coolant temperature too high"},
#endif //EXTENDED_ADVANTUM_CAN_PRESENT

#if defined(CANLOG_V4_PRESENT)

  {CAN_V4_BOOT_FRAME, "p2350", "ru_p2350"},
  {CAN_V4_PROGRAM_NUMBER, "Номер программы", "Program number"},
  {CAN_V4_FRAME_INTERVAL, "Интервал CAN-кадров", "CAN frame interval"},
  {CAN_V4_UPDATE_PERCENT, "Прогресс обновления прошивки, %", "The progress of the firmware update, %"},
  {CAN_V4_INCOMPLETE_DATA_FLAGS, "Флаги неполных данных", "Incomplete Data Flags"},
  //{2353, "", ""},
  //{2354, "", ""},
  //{2355, "", ""},
  //reserve 8
#if defined(CANLOG_V4_CONNECTIONS_FLAGS_PRESENT)
  {CAN_V4_CONN_FLAGS_D0,
   "Флаги подключения CAN (0):\n"
        "\tСоединение CAN1\n"
        "\tСоединение CAN2",
   "CAN connect flags (0)\n"
        "\tCAN1 connection\n"
        "\tCAN2 connection"},
  {CAN_V4_CONN_FLAGS_D1,
   "Флаги подключения CAN (1) \n"
       "\tСоединение CAN3"
   ,
   "CAN connect flags (1) \n"
        "\tCAN3 connection"
    },
#endif //defined(CANLOG_V4_CONNECTIONS_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_SECURITY_FLAGS_PRESENT)
  {CAN_V4_SECURITY_FL_D0,
   "Флаги безопасности (0)\n"
        "\tЗажигание\n"
        "\tКлюч в замке зажигания\n"
        "\tWebasto"
   ,
   "Security flags (0)\n"
        "\tIgnition\n"
        "\tIgnition key\n"
        "\tWebasto"
    },
  {CAN_V4_SECURITY_FL_D1,
   "Флаги безопасности (1)\n"
        "\tСостояние двигателя\n"
        "\tСостояние дополнительного двигателя\n"
        "\tГотовность транспортного средства\n"
        "\tПоддержка двигателем СПГ"
   ,
   "Security flags (1)\n"
        "\tEngine state\n"
        "\tThe state of the auxiliary engine\n"
        "\tVehicle readiness\n"
        "\tLNG engine support"},
  {CAN_V4_SECURITY_FL_D2,
   "Флаги безопасности (2)\n"
        "\tРежим работы (частный/корпоративный)\n"
        "\tПрисутствие оператора\n"
        "\tБлокировка"
   ,
   "Security flags (2)\n"
        "\tMode of operation (private / corporate)\n"
        "\tOperator presence\n"
        "\tLock"},
  {CAN_V4_SECURITY_FL_D3,
   "Флаги безопасности (3)\n"
        "\tНажата одна из исполнительных кнопок в транспортном средстве\n"
        "\tИммобилайзер в сервисном режиме\n"
        "\tИммобилайзер. Была введена последовательность кнопок для программирования"
   ,
   "Security flags (3)\n"
        "\tThe appearance of a bit while pressing any executive button in the vehicle\n"
        "\tThe appearance of a bit when the immobilizer is in service mode\n"
        "\tThe appearance of a bit when you enter a previously programmed sequence of a combination of buttons in the car"
  },
  {CAN_V4_SECURITY_FL_D4,
   "Флаги безопасности (4)\n"
        "\tРучной тормоз\n"
        "\tНожной тормоз\n"
        "\tСцепление"
   ,
   "Security flags (4)\n"
        "\tHand brake\n"
        "\tFoot brake\n"
        "\tClutch"
    },
  {CAN_V4_SECURITY_FL_D5,
   "Флаги безопасности (5)\n"
        "\tПередняя левая дверь\n"
        "\tПередняя правая дверь\n"
        "\tЗадняя левая дверь\n"
        "\tЗадняя правая дверь"
   ,
   "Security flags (5)\n"
        "\tFront left door\n"
        "\tFront right door\n"
        "\tRear left door\n"
        "\tRear right door"},
  {CAN_V4_SECURITY_FL_D6,
   "Флаги безопасности (6)\n"
        "\tБагажник\n"
        "\tКапот"
   ,
   "Security flags (6)\n"
        "\tTrunk\n"
        "\tHood"
    },
  {CAN_V4_SECURITY_FL_D7,
   "Флаги безопасности (7)\n"
        "\tПровод зарядки\n"
        "\tЗарядка аккумуляторной батареи"
   ,
   "Security flags (7)\n"
        "\tCharging wire\n"
        "\tBattery Charging"
    },
  {CAN_V4_SECURITY_FL_D8,
   "Флаги безопасности (8)\n"
        "\tАвтомобиль закрыт заводским пультом дистанционного управления\n"
        "\tСостояние дверей автомобиля\n"
        "\tЗаводская сигнализация (активирована или нет)\n"
        "\tЭмуляция заводской сигнализации (активирована или нет)"
   ,
   "Security flags (8)\n"
        "\tThe car is closed by the factory remote control\n"
        "\tVehicle door condition\n"
        "\tFactory alarm (activated or not)\n"
        "\tFactory alarm emulation (activated or not)"},
  {CAN_V4_SECURITY_FL_D9,
   "Флаги безопасности (9)\n"
        "\tСигнал закрытия с помощью заводского пульта дистанционного управления\n"
        "\tСигнал открытия с помощью заводского пульта дистанционного управления\n"
        "\tСигнал перепостановки\n"
        "\tБыл ли открыт багажник пультом ДУ в течение 2-х секунд"
   ,
   "Security flags (9)\n"
        "\tSignal closure using factory remote control\n"
        "\tOpening signal using factory remote control\n"
        "\tRemasking signal\n"
        "\tWas the trunk open with the remote control for 2 seconds"},
  {CAN_V4_SECURITY_FL_D10,
   "Флаги безопасности (10)\n"
        "\tНаходится ли CAN-модуль в спящем режиме\n"
        "\tСигнал закрытия с помощью заводского пульта дистанционного управления был отправлен трехкратно"
   ,
   "Security flags (10)\n"
        "\tIs the CAN module in sleep mode?\n"
        "\tThe close signal was sent three times by the factory remote control"},
  {CAN_V4_SECURITY_FL_D11,
   "Флаги безопасности (11)\n"
        "\tРычаг КПП в режиме \"P\"\n"
        "\tРычаг КПП в режиме \"R\"\n"
        "\tРычаг КПП в режиме \"N\"\n"
        "\tРычаг КПП в режиме \"D\""
   ,
   "Security flags (11)\n"
        "\tGearshift lever in \"P\"\n"
        "\tGearshift in \"R\"\n"
        "\tGearshift in \"N\"\n"
        "\tGearshift in \"D\""},
   {CAN_V4_SECURITY_FL_D12,
   "Флаги безопасности (12)\n"
        "\tДвигатель работает на двойном топливе"
   ,
   "Security flags (12)\n"
        "\tEngine runs on dual fuel"},
#endif //defined(CANLOG_V4_SECURITY_FLAGS_PRESENT)
  //reserve 4
#if defined(CANLOG_V4_STATE_FLAGS_PRESENT)
  {CAN_V4_STATE_FL_D0,
   "Флаги состояния (0)\n"
        "\tПарковочные огни\n"
        "\tФары ближнего света\n"
        "\tФары дальнего света\n"
        "\tЗадние противотуманные фонари"
   ,
   "Status flags (0)\n"
        "\tParking lights\n"
        "\tDim lights\n"
        "\tHeadlights\n"
        "\tRear fog lights"},
  {CAN_V4_STATE_FL_D1,
   "Флаги состояния (1)\n"
        "\tПередние противотуманные фары"
   ,
   "Status flags (1)\n"
        "\tFront fog lights"
    },
  {CAN_V4_STATE_FL_D2,
   "Флаги состояния (2)\n"
        "\tДополнительное переднее освещение\n"
        "\tДополнительное заднее освещение\n"
        "\tСветовые сигналы\n"
        "\tПрицеп"
   ,
   "Status flags (2)\n"
        "\tOptional front lighting\n"
        "\tExtra back light\n"
        "\tLight signals\n"
        "\Trailer"
    },
  {CAN_V4_STATE_FL_D3,
   "Флаги состояния (3)\n"
        "\tКондиционер\n"
        "\tКруиз-контроль\n"
        "\tАвтоматический замедлитель\n"
        "\tРучной замедлитель"
   ,
   "Status flags (3)\n"
        "\tAir conditioning\n"
        "\tCruise control\n"
        "\tAutomatic retarder\n"
        "\tManual retarder"},
  {CAN_V4_STATE_FL_D4,
   "Флаги состояния (4)\n"
        "\tЗарезервированы"
   ,
   "Status flags (4)\n"
        "\tReserved"
    },
  {CAN_V4_STATE_FL_D5,
   "Флаги состояния (5)\n"
        "\tВодительский ремень безопасности\n"
        "\tПередний пассажирский ремень\n"
        "\tЗадний левый пассажирский ремень\n"
        "\tЗадний правый пассажирский ремень"
   ,
   "Status flags (5)\n"
        "\tDriving belt\n"
        "\tFront passenger seat belt\n"
        "\tRear left passenger belt\n"
        "\tRear right seat belt"},
  {CAN_V4_STATE_FL_D6,
   "Флаги состояния (6)\n"
        "\tЗадний центральный пассажирский ремень\n"
        "\tПередний пассажирский ремень"
   ,
   "Status flags (6)\n"
        "\tRear center passenger belt\n"
        "\tFront passenger seat belt"
    },
    {CAN_V4_STATE_FL_D7,
     "Флаги состояния (7)\n"
     ,
     "Status flags (7)\n"
    },
    {CAN_V4_STATE_FL_D8,
     "Флаги состояния (8)\n"
          "\tПодъем оси прицепа 1\n"
          "\tПодъем оси прицепа 2\n"
          "\tПодъем оси прицепа 3\n"
          "\tПодъем оси прицепа 4\n"
     ,
     "Status flags (8)\n"
          "\tTrailer axle lift 1\n"
          "\tTrailer axle lift 2\n"
          "\tTrailer axle lift 3\n"
          "\tTrailer axle lift 4\n"
    },
#endif //defined(CANLOG_V4_STATE_FLAGS_PRESENT)
  //reserve 3
#if defined(CANLOG_V4_INDICATORS_FLAGS_PRESENT)
  {CAN_V4_INDICATORS_FL_D0,
   "Индикаторы (0)\n"
        "\tИндикатор CHECK ENGINE\n"
        "\tИндикатор ABS\n"
        "\tИндикатор ESP (электронная система динамической стабилизации)\n"
        "\tESP"
   ,
   "Indicators (0)\n"
        "\tCHECK ENGINE indicator\n"
        "\tABS indicator\n"
        "\tIndicator ESP (Electronic Dynamic Stabilization System)\n"
        "\tESP"
    },
  {CAN_V4_INDICATORS_FL_D1,
   "Индикаторы (1)\n"
        "\tИндикатор STOP\n"
        "\tИндикатор давления\n"
        "\tИндикатор температуры\n"
        "\tИндикатор отсутствия зарядки аккумуляторной батареи"
   ,
   "Indicators (1)\n"
        "\tSTOP indicator\n"
        "\tPressure indicator\n"
        "\tTemperature indicator\n"
        "\tBattery no charge indicator"
    },
  {CAN_V4_INDICATORS_FL_D2,
   "Индикаторы (2)\n"
        "\tИндикатор системы стояночного тормоза\n"
        "\tИндикатор AIRBAG\n"
        "\tИндикатор EPS\n"
        "\tИндикатор предупреждения"
   ,
   "Indicators (2)\n"
        "\tParking Brake Indicator\n"
        "\tAIRBAG indicator\n"
        "\tEPS indicator\n"
        "\tWarning indicator"},
  {CAN_V4_INDICATORS_FL_D3,
   "Индикаторы (3)\n"
        "\tИндикатор неисправности внешних световых приборов\n"
        "\tИндикатор низкого давления в шинах\n"
        "\tИндикатор износа тормозных колодок\n"
        "\tИндикатор низкого уровня топлива"
   ,
   "Indicators (3)\n"
        "\tIndicator of malfunction of external light devices\n"
        "\tLow Tire Pressure Indicator\n"
        "\tBrake pad wear indicator\n"
        "\tLow fuel indicator"},
  {CAN_V4_INDICATORS_FL_D4,
   "Индикаторы (4)\n"
        "\tИндикатор наступления времени технического обслуживания\n"
        "\tИндикатор свечей накаливания\n"
        "\tИндикатор FAP (сажевый фильтр)\n"
        "\tИндикатор EPC (электронный контроль мощности)"
   ,
   "Indicators (4)\n"
        "\tService Time Indicator\n"
        "\tGlow indicator\n"
        "\tFAP (Particulate Filter) Indicator\n"
        "\tEPC (electronic power control) indicator"},
  {CAN_V4_INDICATORS_FL_D5,
   "Индикаторы (5)\n"
        "\tИндикатор засорения фильтра масляной гидравлической системы\n"
        "\tИндикатор низкого давления масла в двигателе\n"
        "\tИндикатор чрезмерно высокого давления масла в двигателе\n"
        "\tИндикатор низкого уровня охлаждающей жидкости"
   ,
   "Indicators (5)\n"
        "\tIndicator clogging filter oil hydraulic system\n"
        "\tLow engine oil pressure indicator\n"
        "\tIndicator of excessively high engine oil pressure\n"
        "\tLow Coolant Indicator"},
  {CAN_V4_INDICATORS_FL_D6,
   "Индикаторы (6)\n"
        "\tИндикатор засорения масляного фильтра гидравлической системы\n"
        "\tИндикатор низкого давления масла в гидросистеме\n"
        "\tИндикатор низкого уровня масла в гидросистеме\n"
        "\tИндикатор высокой температуры в гидросистеме"
   ,
   "Indicators (6)\n"
        "\tHydraulic oil filter clogged indicator\n"
        "\tLow oil pressure indicator in hydraulic system\n"
        "\tLow oil level indicator in hydraulic system\n"
        "\tHydraulic high temperature indicator"},
  {CAN_V4_INDICATORS_FL_D7,
   "Индикаторы (7)\n"
        "\tИндикатор перелива масла в баке гидросистемы\n"
        "\tИндикатор засорения воздушного фильтра\n"
        "\tИндикатор засорения топливного фильтра\n"
        "\tИндикатор присутствия воды в топливе"
   ,
   "Indicators (7)\n"
        "\tHydraulic tank overflow indicator\n"
        "\tAir filter clogging indicator\n"
        "\tFuel Filter Clogged Indicator\n"
        "\tIndicator of the presence of water in the fuel"},
  {CAN_V4_INDICATORS_FL_D8,
   "Индикаторы (8)\n"
        "\tИндикатор засорения фильтра тормозной системы"
   ,
   "Indicators (8)\n"
        "\tBrake Filter Clogging Indicator"
    },
{CAN_V4_INDICATORS_FL_D9,
   "Индикаторы (9)\n"
        "\tИндикатор низкого давления в шинах прицепа\n"
        "\tИндикатор износа тормозных накладок прицепа\n"
        "\tИндикатор высокой температуры тормозной системы прицепа\n"
        "\tИндикатор неправильного давления в тормозной системе прицепа"
   ,
   "Indicators (9)\n"
        "\tTrailer tyre low pressure indicator\n" //todo
        "\tTrailer brake lining assemblies wear indicator\n"
        "\tTrailer brake system high temperature indicator\n"
        "\tTrailer indicator of wrong pressure in brake system"
    },
#endif //defined(CANLOG_V4_INDICATORS_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_AGRICULTURAL_FL_D0 ,
   "Сельскохозяйственные (0)\n"
        "\tПравый джойстик вправо\n"
        "\tПравый джойстик влево\n"
        "\tПравый джойстик вперед\n"
        "\tПравый джойстик назад"
   ,
   "Agricultural (0)\n"
        "\tRight stick to the right\n"
        "\tRight stick left\n"
        "\tRight joystick forward\n"
        "\tRight joystick back"},
  {CAN_V4_AGRICULTURAL_FL_D1 ,
   "Сельскохозяйственные (1)\n"
        "\tЛевый джойстик вправо\n"
        "\tЛевый джойстик влево\n"
        "\tЛевый джойстик вперед\n"
        "\tЛевый джойстик назад"
   ,
   "Agricultural (1)\n"
        "\tLeft stick to the right\n"
        "\tLeft stick left\n"
        "\tLeft stick forward\n"
        "\tLeft stick back"},
  {CAN_V4_AGRICULTURAL_FL_D2 ,
   "Сельскохозяйственные (2)\n"
        "\tПервый задний гидропривод\n"
        "\tВторой задний гидропривод\n"
        "\tТретий задний гидропривод\n"
        "\tЧетвертый задний гидропривод"
   ,
   "Agricultural (2)\n"
        "\tThe first rear hydraulic drive\n"
        "\tSecond rear hydraulic drive\n"
        "\tThe third rear hydraulic drive\n"
        "\tFourth rear hydraulic drive"},
  {CAN_V4_AGRICULTURAL_FL_D3 ,
   "Сельскохозяйственные (3)\n"
        "\tПервый передний гидропривод\n"
        "\tВторой передний гидропривод\n"
        "\tТретий передний гидропривод\n"
        "\tЧетвертый передний гидропривод"
   ,
   "Agricultural (3)\n"
        "\tThe first front hydraulic drive\n"
        "\tSecond front hydraulic drive\n"
        "\tThird front hydraulic drive\n"
        "\tFourth front hydraulic drive"},
  {CAN_V4_AGRICULTURAL_FL_D4 ,
   "Сельскохозяйственные (4)\n"
        "\tПередняя трехточечная система навески\n"
        "\tЗадняя трехточечная система навески\n"
        "\tПередний механизм отбора мощности\n"
        "\tЗадний механизм отбора мощности"
   ,
   "Agricultural (4)\n"
        "\tFront three-point linkage\n"
        "\tRear three-point linkage\n"
        "\tFront PTO\n"
        "\tRear PTO"},
  {CAN_V4_AGRICULTURAL_FL_D5 ,
   "Сельскохозяйственные (5)\n"
        "\tПокос\n"
        "\tМолотьба\n"
        "\tРазгрузка зерна из бункера"
   ,
   "Agricultural (5)\n"
        "\tMowing\n"
        "\tThreshing\n"
        "\tUnloading grain from the hopper"},
  {CAN_V4_AGRICULTURAL_FL_D6 ,
   "Сельскохозяйственные (6)\n"
        "\tЗерновой бункер заполнен на 100%\n"
        "\tЗерновой бункер заполнен на 70%\n"
        "\tСостояние зернового бункера\n"
        "\tПривод выгрузного механизма при сложенной выгрузной трубе"
   ,
   "Agricultural (6)\n"
        "\tThe grain tank is 100% full\n"
        "\tGrain bunker is 70% full\n"
        "\tGrain Bin Condition\n"
        "\tDrive unloading mechanism with folded unloading pipe"},
  {CAN_V4_AGRICULTURAL_FL_D7 ,
   "Сельскохозяйственные (7)\n"
        "\tУправление вентилятором очистки\n"
        "\tУправление молотильным барабаном\n"
        "\tСоломотряс в рабочем состоянии\n"
        "\tИзбыточный зазор под молотильным барабаном"
   ,
   "Agricultural (7)\n"
        "\tFan cleaning control\n"
        "\tThreshing drum control\n"
        "\tStraw shooter in working condition\n"
        "\tExcess clearance under the threshing drum"},
  {CAN_V4_AGRICULTURAL_FL_D8 ,
   "Сельскохозяйственные (8)"
        "\tНизкая температура ГС ходовой части (< 5°C)\n"
        "\tВысокая температура ГС ходовой части (>86°C)\n"
        "\tОбороты колосового шнека\n"
        "\tОбороты зернового шнека"
   ,
   "Agricultural (8)\n"
        "\tLow running temperature (< 5°C)\n"
        "\tHigh running gear temperature (> 86 ° C)\n"
        "\tSpinner screw turns\n"
        "\tGrain Auger Turns"},
  {CAN_V4_AGRICULTURAL_FL_D9 ,
   "Сельскохозяйственные (9)\n"
        "\tОбороты измельчителя соломы\n"
        "\tОбороты соломотряса\n"
        "\tОбороты наклонной камеры\n"
        "\tСостояние измельчителя соломы (включен/выключен)"
   ,
   "Agricultural (9)\n"
        "\tStraw chopper speed\n"
        "\tStraw walkers\n"
        "\tTilt camera RPM\n"
        "\tStraw chopper state"},
  {CAN_V4_AGRICULTURAL_FL_D10,
   "Сельскохозяйственные (10)\n"
        "\tСостояние кукурузной жатки (подключена/не подключена)\n"
        "\tСостояние зерновой жатки (подключена/не подключена)\n"
        "\tРеверс наклонной камеры (включен / выключен)\n"
        "\tСостояние напорного фильтра гидронасоса привода хода (засорен/ не засорен)"
   ,
   "Agricultural (10)\n"
        "\tCorn header status (connected / not connected)\n"
        "\tGrain header status (connected / not connected)\n"
        "\tReverse tilt camera (on / off)\n"
        "\tThe state of the pressure filter of the hydraulic pump drive stroke (clogged / not clogged)"
    },
#endif //defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_UTILITY_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_UTILITY_VEHICLES_FL_D0,
   "Флаги муниципальной техники (0)\n"
        "\tРаспылитель соли (песка)\n"
        "\tРазливка реагентов\n"
        "\tКонвейерный ремень\n"
        "\tПриводное колесо солеразбрасывателя"
   ,
   "Utility vehicles flags (0)\n"
        "\tSalt sprayer (sand)\n"
        "\tReagent casting\n"
        "\tConveyor belt\n"
        "\tSalt Spreader Drive Wheel"},
  {CAN_V4_UTILITY_VEHICLES_FL_D1,
   "Флаги муниципальной техники (1)\n"
        "\tЩетки\n"
        "\tПылесос\n"
        "\tПодача воды\n"
        "\tМоющий аппарат высокого давления (Karcher)"
   ,
   "Utility vehicles flags (1)\n"
        "\tBrushes\n"
        "\tVacuum cleaner\n"
        "\tWater supply\n"
        "\tThe washing high-pressure apparatus (Karcher)"},
  {CAN_V4_UTILITY_VEHICLES_FL_D2,
   "Флаги муниципальной техники (2)\n"
        "\tНасос подачи жидкости\n"
        "\tВыгрузка из бункера\n"
        "\tИндикатор низкого уровня соли (песка) в баке\n"
        "\tИндикатор низкого уровня воды в баке"
   ,
   "Utility vehicles flags (2)\n"
        "\tFluid pump\n"
        "\tUnloading from bunker\n"
        "\tLow salt indicator (sand) in tank\n"
        "\tLow Tank Water Level Indicator"},
  {CAN_V4_UTILITY_VEHICLES_FL_D3,
   "Флаги муниципальной техники (3)\n"
        "\tИспользование реагентов\n"
        "\tКомпрессор\n"
        "\tВодяной клапан"
   ,
   "Utility vehicles flags (3)\n"
        "\tReagent use\n"
        "\tCompressor\n"
        "\tWater valve"
    },
  {CAN_V4_UTILITY_VEHICLES_FL_D4,
   "Флаги муниципальной техники (4)\n"
        "\tCтатус \"кабина перемещена вверх\"\n"
        "\tСтатус \"кабина перемещена вниз\""
   ,
   "Utility vehicles flags (4)\n"
        "\tStatus \"cabin moved up\"\n"
        "\tStatus \"cabin moved down\""
    },
#endif //defined(CANLOG_V4_UTILITY_VEHICLES_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_CISTERN_FLAGS_PRESENT)
  {CAN_V4_CISTERNS_FL_D0,
   "Флаги цистерн (0)\n"
        "\tВ отводной трубе жидкость\n"
        "\tЗаполненность секции\n"
        "\tПереполненность секции"
   ,
   "Cisterns flags (0)\n"
        "\tLiquid in the discharge pipe\n"
        "\tSection fullness\n"
        "\tSection overflow"
    },
  {CAN_V4_CISTERNS_FL_D1,
   "Флаги цистерн (1)\n"
        "\tЗарезервировано"
   ,
   "Cisterns flags (1)\n"
        "\tReserved"
    },
#endif //defined(CANLOG_V4_CISTERN_FLAGS_PRESENT)
  //reserve 5
#if defined(CANLOG_V4_NUMERIC_DATA_PRESENT)
  {CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME             , "Суммарное время работы двигателя, с", "Total engine running time"},
  {CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME_COUNTED     , "Суммарное время работы двигателя (подсчитано), с", "Total engine running time (estimated), s"},
  {CAN_V4_NUMERIC_ODOMETER                      , "Полный пробег транспортного средства, км", "Full vehicle mileage, km"},
  {CAN_V4_NUMERIC_ODOMETER_COUNTED              , "Полный пробег транспортного средства (подсчитано), км", "Full vehicle mileage (calculated), km"},
  {CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION        , "Общее потребление топлива, л ", "Total fuel consumption, l"},
  {CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION_COUNTED, "Общее потребление топлива (подсчитано), л", "Total fuel consumption (calculated), l"},
  {CAN_V4_NUMERIC_FUEL_LEVEL_PERCENT            , "Уровень топлива, %", "Fuel level, %"},
  {CAN_V4_NUMERIC_FUEL_LEVEL_LITER              , "Уровень топлива, л", "Fuel level, l"},
  {CAN_V4_NUMERIC_ENGINE_RPM                    , "Обороты двигателя, RPM", "Engine RPM"},
  {CAN_V4_NUMERIC_ENGINE_TEMP                   , "Температура двигателя, C°", "Engine temperature, C°"},
  {CAN_V4_NUMERIC_SPEED                         , "Скорость транспортного средства, км/ч", "Vehicle speed, km/h"},
  {CAN_V4_NUMERIC_ACCELERATOR_POSITION          , "Положение педали акселератора, %", "Accelerator pedal position, %"},
  {CAN_V4_NUMERIC_ENGINE_LOAD                   , "Нагрузка двигателя, %", "Engine load, %"},
  {CAN_V4_NUMERIC_AXLE_LOAD_1                   , "Нагрузка на ось 1, кг", "Load on axle 1, kg"},
  {CAN_V4_NUMERIC_AXLE_LOAD_2                   , "Нагрузка на ось 2, кг", "Load on axle 2, kg"},
  {CAN_V4_NUMERIC_AXLE_LOAD_3                   , "Нагрузка на ось 3, кг", "Load on axle 3, kg"},
  {CAN_V4_NUMERIC_AXLE_LOAD_4                   , "Нагрузка на ось 4, кг", "Load on axle 4, kg"},
  {CAN_V4_NUMERIC_AXLE_LOAD_5                   , "Нагрузка на ось 5, кг", "Load on axle 5, kg"},
  {CAN_V4_NUMERIC_RETARDER_LOAD                 , "Нагрузка ретардера (замедлителя), %", "Load retarder (moderator), %"},
  {CAN_V4_NUMERIC_TOTAL_CNG_USE                 , "Полный расход СПГ, кг", "Full consumption of LNG, kg"},
  {CAN_V4_NUMERIC_TOTAL_CNG_USE_COUNTED         , "Полный расход СПГ (подсчитано), кг", "Total LNG consumption (calculated), kg"},
  {CAN_V4_NUMERIC_CNG_LEVEL_PERCENT             , "Уровень СПГ, %", "LNG level, %"},
  {CAN_V4_NUMERIC_CNG_LEVEL_LITER               , "Уровень СПГ, кг", "LNG level, kg"},
  {CAN_V4_NUMERIC_ADBLUE_LEVEL_PERCENT          , "Уровень жидкости AdBlue, %", "AdBlue fluid level, %"},
  {CAN_V4_NUMERIC_ADBLUE_LEVEL_LITER            , "Уровень жидкости AdBlue, л", "AdBlue fluid level, l"},
  {CAN_V4_NUMERIC_FUEL_FLOWMETER                , "Текущий (мгновенный) расход топлива, л/ч", "Current (instantaneous) fuel consumption, l/h"},
  {CAN_V4_NUMERIC_BATTERY_TEMPERATURE           , "Температура батареи, C°", "Battery temperature, C°"},
  {CAN_V4_NUMERIC_BATTERY_CHARGE_LEVEL          , "Уровень заряда батареи, %", "Battery level, %"},
  {CAN_V4_NUMERIC_BATTERY_VOLTAGE               , "Напряжение аккумуляторной батареи, В", "Battery voltage, V"},
  {CAN_V4_NUMERIC_VEHICLES_RANGE                , "Запас хода автомобиля, км", "Power reserve, km"},
  {CAN_V4_NUMERIC_BEF_SRVC_TIME                 , "Сервис. Время до очередного ТО", "Service. Time until the next MOT"},
  {CAN_V4_NUMERIC_EX_SRVC_TIME                  , "Сервис. Превышение времени проведения ТО", "Service. Exceeding the time of MOT"},
  {CAN_V4_NUMERIC_AFT_SRVC_TIME                 , "Сервис. Время после ТО", "Service. Time after MOT"},
  {CAN_V4_NUMERIC_BEF_SRVC_ODO                  , "Сервис. Пробег до очередного ТО, км", "Service. Mileage to the next MOT, km"},
  {CAN_V4_NUMERIC_EX_SRVC_ODO                   , "Сервис. Превышение пробега до ТО, км", "Service. Excess of run to MOT, km"},
  {CAN_V4_NUMERIC_AFT_SRVC_ODO                  , "Сервис. Пробег после ТО, км", "Service. Run after MOT, km"},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_1           , "Нагрузка на ось 1 прицепа, кг", "Trailer axle 1 load, kg"},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_2           , "Нагрузка на ось 2 прицепа, кг", "Trailer axle 2 load, kg"},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_3           , "Нагрузка на ось 3 прицепа, кг", "Trailer axle 3 load, kg"},
  {CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_4           , "Нагрузка на ось 4 прицепа, кг", "Trailer axle 4 load, kg"},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_1 ,  "Давление в левом первом колесе оси 1 прицепа, 10e-1 бар", "Trailer axle 1, first left wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_1, "Давление в правом первом колесе оси 1 прицепа, 10e-1 бар", "Trailer axle 1, first right wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_2 , "Давление в левом первом колесе оси 2 прицепа, 10e-1 бар", "Trailer axle 2, first left wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_2, "Давление в правом первом колесе оси 2 прицепа, 10e-1 бар", "Trailer axle 2, first right wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_3 , "Давление в левом первом колесе оси 3 прицепа, 10e-1 бар", "Trailer axle 3, first left wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_3, "Давление в правом первом колесе оси 3 прицепа, 10e-1 бар", "Trailer axle 3, first right wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_4 , "Давление в левом первом колесе оси 4 прицепа, 10e-1 бар", "Trailer axle 4, first left wheel pressure, 10e-1 bar"},
  {CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_4, "Давление в правом первом колесе оси 4 прицепа, 10e-1 бар", "Trailer axle 4, first right wheel pressure, 10e-1 bar"},
  {CAN_V4_TRAILER_VIN, "VIN прицепа", "Trailer VIN"},
  {CAN_V4_NUMERIC_TOTAL_TRAILER_AXLE_LOAD, "Сумма нагрузок на оси прицепа, кг", "Total trailer axle load, kg"},
  {CAN_V4_NUMERIC_CARGO_WEIGHT, "Масса груза, кг", "Cargo weight, kg"},
  {CAN_V4_MAIN_FUEL_UP_TIME, "Время работы двигателя на основном топливе, с", "Main fuel eng up time, s"},
  {CAN_V4_DUAL_FUEL_UP_TIME, "Время работы двигателя на двойном топливе, с", "Dual fuel eng up time, s"},
  {CAN_V4_CNG_PRESSURE, "Давление CNG, 10e-2 бар", "CNG pressure, 10e-2 bar"},
#endif //defined(CANLOG_V4_NUMERIC_DATA_PRESENT)
  //reserve 7
#if defined(CANLOG_V4_AGR_NUMERIC_DATA_PRESENT)
  {CAN_V4_AGR_NUMERIC_HARVEST_TIME                , "Время сбора урожая, мин.", "Harvest time, min."},
  {CAN_V4_AGR_NUMERIC_HARVEST_AREA                , "Убранная площадь, Га", "Cleaned area, ha"},
  {CAN_V4_AGR_NUMERIC_HARVEST_EFFICIENCY          , "Эффективность уборки, Га/ч", "Cleaning efficiency, ha / h"},
  {CAN_V4_AGR_NUMERIC_HARVESTED_GRAIN             , "Количество убранного зерна, кг", "Quantity of harvested grain, kg"},
  {CAN_V4_AGR_NUMERIC_GRAIN_MOISTURE              , "Влажность зерна, %", "Grain moisture, %"},
  {CAN_V4_AGR_NUMERIC_THRESHER_RPM                , "Обороты молотильного барабана, RPM", "Threshing drum speed, RPM"},
  {CAN_V4_AGR_NUMERIC_CONCAVE_CLEARANCE           , "Отброшенное состояние подбарабанья (зазор подбарабанья), мм", "Discarded condition of concave (concave clearance), mm"},
  {CAN_V4_AGR_NUMERIC_ENGINE_PRESSURE             , "Давление двигателя, бар", "Engine pressure, bar"},
  {CAN_V4_AGR_NUMERIC_CHASSIS_TEMP                , "Температура ходовой, C°", "Running temperature, C °"},
  {CAN_V4_AGR_NUMERIC_AUGER_RPM                   , "Обороты колосового шнека, RPM", "Spike Worm RPM"},
  {CAN_V4_AGR_NUMERIC_GRAIN_RPM                   , "Обороты зернового шнека, RPM", "Grain Auger RPM"},
  {CAN_V4_AGR_NUMERIC_SHREDDER_RPM                , "Обороты измельчителя, RPM", "Shredder RPM"},
  {CAN_V4_AGR_NUMERIC_RACK_RPM                    , "Обороты ротора/соломотряса, RPM", "Rotor / straw walker RPM"},
  {CAN_V4_AGR_NUMERIC_FAN_RPM                     , "Обороты вентилятора, RPM", "Fan RPM"},
  {CAN_V4_AGR_NUMERIC_FEED_ELEVATOR_RPM           , "Обороты наклонной камеры, RPM", "Tilt camera speed, RPM"},
  {CAN_V4_AGR_NUMERIC_REEL_SPEED                  , "Скорость мотовила, км/ч", "Reel speed, km / h"},
  {CAN_V4_AGR_NUMERIC_TAILINGS_ELEVATOR_PERCENT   , "Количество материала в колосовом элеваторе, %", "The amount of material in the grain elevator, %"},
  {CAN_V4_AGR_NUMERIC_THRESHER_ON_CURRENT_TIME    , "Часы работы комбайна с включенной молотилкой текущие, с", "The working hours of the combine with the included thresher are current, with"},
  {CAN_V4_AGR_NUMERIC_THRESHER_ON_TOTAL_TIME      , "Общее количество отработанных часов комбайна со включенной молотилкой, с", "The total number of hours worked combine with the included threshing machine, s"},
  {CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE        , "Пройденный путь текущий, км", "The current path, km"},
  {CAN_V4_AGR_NUMERIC_AGR_TOTAL_DISTANCE          , "Пройденный путь суммарный при работe, км", "Total path traveled when operating, km"},
  {CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE_ON_WORK, "Пройденный путь текущий при работе, км", "Path traveled during operation, km"},
  {CAN_V4_AGR_NUMERIC_CURRENT_HARVEST_AREA        , "Убранная площадь текущая, м2", "Harvest current area, m2"},
  {CAN_V4_AGR_NUMERIC_TOTAL_HARVEST_AREA          , "Убранная площадь суммарная, м2", "Total area cleaned, m2"},

  {CAN_V4_AGR_TOTAL_TREATED_AREA                 , "Общая обработанная площадь, Га", "Total treated area, ha"},
  {CAN_V4_AGR_LEVEL_OF_LIQUID_IN_TANK            , "Уровень жидкости в баке, 10e-1 л", "Level of liquid in tank, 10e-1 l"},
  {CAN_V4_AGR_SPRAY_PRESSURE                     , "Давление распылителя, 10e-2 Бар", "Spray pressure, 10e-2 bar"},
  {CAN_V4_AGR_ACTUAL_NORM_OF_LIQUID              , "Норма фактическая жидкости, 10e-1 л/Га", "Actual norm of liquid, 10e-1 l/ha"},
  {CAN_V4_AGR_TOTAL_AMOUNT_OF_LIQUID_USED        , "Общее количество использованного топлива, л", "Total amount of liquid used, l"},
  {CAN_V4_AGR_AREA_THAT_CAN_BE_TREATED_UNTIL_TANK_IS_EMPTY, "Площадь, которую можно обработать до опустошения бака с жидкостью, Га"  , "Area that can be treated until tank is empty, ha"},
  {CAN_V4_AGR_DISTANCE_REMAINING_UNTIL_TANK_IS_EMPTY,       "Расстояние до опустошения бака с жидкостью, м2", "Distance remaining until tank is empty, m2"},
  {CAN_V4_AGR_TOTAL_WEIGHT_OF_SPREAD_MATERIAL    , "Общий вес внеснного материала, кг"  , "Total weight of spread material, kg"},
#endif //defined(CANLOG_V4_AGR_NUMERIC_DATA_PRESENT)
  //reserve 3
#if defined(CANLOG_V4_TACHO_PRESENT)
  {CAN_V4_TACHO_SYSTEM_INFO, "Tacho, системная информация", "Tacho, system info"},
  {CAN_V4_TACHO_CARDS_INFO, "Наличие карточки водителя", "Driver's card"},

  {CAN_V4_TACHO_DRIVER1_INFO_FIRST_NAME, "Имя водителя 1", "Driver 1 First Name"},
  {CAN_V4_TACHO_DRIVER2_INFO_FIRST_NAME, "Имя водителя 2", "Driver 2 First Name"},

  {CAN_V4_TACHO_DRIVER1_INFO_LAST_NAME, "Фамилия водителя 1", "Driver 1 Last Name"},
  {CAN_V4_TACHO_DRIVER2_INFO_LAST_NAME, "Фамилия водителя 2", "Driver 2 Last Name"},

  {CAN_V4_TACHO_DRIVER1_INFO_ID, "ID водителя 1", "Driver 1 ID"},
  {CAN_V4_TACHO_DRIVER2_INFO_ID, "ID водителя 2", "Driver 2 ID"},

  {CAN_V4_TACHO_DRIVER1_INFO_STATE, "Состояние водителя 1", "Driver 1 condition"},
  {CAN_V4_TACHO_DRIVER2_INFO_STATE, "Состояние водителя 2", "Driver 2 condition"},
  //2368
  //2369

  {CAN_V4_TACHO_DRIVER1_INFO_WORK_TIME, "Отработанное время водителем 1", "Driver 1 work time"},
  {CAN_V4_TACHO_DRIVER2_INFO_WORK_TIME, "Отработанное время водителем 2", "Driver 2 work time"},

  {CAN_V4_TACHO_DRIVER1_INFO_TOTAL_RELAX_TIME, "Количество времени отсутствия активности водителя 1", "Driver 1 relax time"},
  {CAN_V4_TACHO_DRIVER2_INFO_TOTAL_RELAX_TIME, "Количество времени отсутствия активности водителя 2", "Driver 2 relax time"},

  {CAN_V4_TACHO_DRIVER1_INFO_CURR_ACTIVITY_TIME, "Количество времени активности водителя 1", "Driver 1 activity time"},
  {CAN_V4_TACHO_DRIVER2_INFO_CURR_ACTIVITY_TIME, "Количество времени активности водителя 2", "Driver 2 activity time"},

  {CAN_V4_TACHO_DRIVER1_INFO_ACTIVITY_AT_LAST_WEEK_TIME, "Количество времени активности водителя 1 за последнюю неделю", "Driver 1 activity for the last week"},
  {CAN_V4_TACHO_DRIVER2_INFO_ACTIVITY_AT_LAST_WEEK_TIME, "Количество времени активности водителя 2 за последнюю неделю", "Driver 2 activity for the last week"},
  //2378
  //2379
#endif //defined(CANLOG_V4_TACHO_PRESENT)
  //reserve 25
#endif  //defined(CANLOG_V4_PRESENT)

#if defined(CARRIER_PRESENT)
// По egts не передаем!!!
  {CARRIER_COOMUNICATION_STATE     , "Cвязь с ХОУ", "Carrier online"},
  {CARRIER_OVERALL_STATUS   ,"Общее состояние ХОУ" ,"Overall unit status"   },
  {CARRIER_OP_COMP1         ,"Режим отсека №1" ,"Mode of Operation – Compartment 1"   },
  {CARRIER_OP_COMP2         ,"Режим отсека №2" ,"Mode of Operation – Compartment 2"    },
  {CARRIER_OP_COMP3         ,"Режим отсека №3" ,"Mode of Operation – Compartment 3"    },
  {CARRIER_ENG_STAT         ,"Статус работы ХОУ"  ,"Engine / Standby Status"   },
  {CARRIER_ALRM_STAT        ,"Статус сигналов ХОУ" ,"Alarm Status"   },
  {CARRIER_NUM_ALRMS        ,"Количество активных сигналов" ,"Number of Active Alarms"   },
  {CARRIER_ALRM1            , "Сигнал №1","Alarm Number 1"   },
  {CARRIER_ALRM2            , "Сигнал №2","Alarm Number 2"   },
  {CARRIER_ALRM3            , "Сигнал №3","Alarm Number 3"   },
  {CARRIER_ALRM4            , "Сигнал №4","Alarm Number 4"   },
  {CARRIER_ALRM5            , "Сигнал №5","Alarm Number 5"   },
  {CARRIER_ALRM6            , "Сигнал №6","Alarm Number 6"   },
  {CARRIER_ALRM7            , "Сигнал №7","Alarm Number 7"   },
  {CARRIER_ALRM8            , "Сигнал №8","Alarm Number 8"   },
  {CARRIER_ALRM9            , "Сигнал №9","Alarm Number 9"   },
  {CARRIER_ALRM10           , "Сигнал №10","Alarm Number 10"   },
  {CARRIER_ALRM11           , "Сигнал №11","Alarm Number 11"   },
  {CARRIER_ALRM12           , "Сигнал №12","Alarm Number 12"   },
  {CARRIER_ALRM13           , "Сигнал №13","Alarm Number 13"   },
  {CARRIER_ALRM14           , "Сигнал №14","Alarm Number 14"   },
  {CARRIER_ALRM15           , "Сигнал №15","Alarm Number 15"   },
  {CARRIER_ALRM16           , "Сигнал №16","Alarm Number 16"   },
  {CARRIER_NUM_INA_ALRMS    , "Количество неактивных сигналов","Number of Inactive Alarms"   },
  {CARRIER_INA_ALRM1        , "Неактивный сигнал №1","Inactive Alarm Number 1"   },
  {CARRIER_INA_ALRM2        , "Неактивный сигнал №2","Inactive Alarm Number 2"    },
  {CARRIER_INA_ALRM3        , "Неактивный сигнал №3","Inactive Alarm Number 3"    },
  {CARRIER_INA_ALRM4        , "Неактивный сигнал №4","Inactive Alarm Number 4"    },
  {CARRIER_INA_ALRM5        , "Неактивный сигнал №5","Inactive Alarm Number 5"    },
  {CARRIER_INA_ALRM6        , "Неактивный сигнал №6","Inactive Alarm Number 6"    },
  {CARRIER_INA_ALRM7        , "Неактивный сигнал №7","Inactive Alarm Number 7"    },
  {CARRIER_INA_ALRM8        , "Неактивный сигнал №8","Inactive Alarm Number 8"    },
  {CARRIER_INA_ALRM9        , "Неактивный сигнал №9","Inactive Alarm Number 9"    },
  {CARRIER_INA_ALRM10       , "Неактивный сигнал №10","Inactive Alarm Number 10"    },
  {CARRIER_INA_ALRM11       , "Неактивный сигнал №11","Inactive Alarm Number 11"    },
  {CARRIER_INA_ALRM12       , "Неактивный сигнал №12","Inactive Alarm Number 12"    },
  {CARRIER_INA_ALRM13       , "Неактивный сигнал №13","Inactive Alarm Number 13"    },
  {CARRIER_INA_ALRM14       , "Неактивный сигнал №14","Inactive Alarm Number 14"    },
  {CARRIER_INA_ALRM15       , "Неактивный сигнал №15","Inactive Alarm Number 15"    },
  {CARRIER_INA_ALRM16       , "Неактивный сигнал №16","Inactive Alarm Number 16"    },
  {CARRIER_TRAILER_ID       , "ID кузова","Trailer Id"  },
  {CARRIER_UNIT_SN          , "Серийный номер ХОУ","Unit Serial Number"  },
  {CARRIER_SOFT_REV         , "Версия ПО ХОУ","Software Revision"  },
  {CARRIER_COMP_SP1         , "Заданная температура отсек №1","Compartment 1 Setpoint"   },
  {CARRIER_COMP_SP2         , "Заданная температура отсек №2","Compartment 2 Setpoint"   },
  {CARRIER_COMP_SP3         , "Заданная температура отсек №3","Compartment 3 Setpoint"   },
  {CARRIER_AMBIENT          , "Наружная температура","Temperature Sensor Ambient"   },
  {CARRIER_TEMP_COMP1_RET   , "Температура возврата отсек №1","Temperature Sensor Compartment 1 Return"    },
  {CARRIER_TEMP_COMP1_SUPL  , "Температура подачи отсек №1","Temperature Sensor Compartment 1 Supply"    },
  {CARRIER_TEMP_COMP2_RET   , "Температура возврата отсек №2","Temperature Sensor Compartment 2 Return"    },
  {CARRIER_TEMP_COMP2_SUPL  , "Температура подачи отсек №2","Temperature Sensor Compartment 2 Supply"    },
  {CARRIER_TEMP_COMP3_RET   , "Температура возврата отсек №3","Temperature Sensor Compartment 3 Return"    },
  {CARRIER_TEMP_COMP3_SUPL  , "Температура подачи отсек №3","Temperature Sensor Compartment 3 Supply"    },
  {CARRIER_REMOTE_SENS1     , "Дополнительный датчик Т №1","Remote Sensor 1"   },
  {CARRIER_REMOTE_SENS2     , "Дополнительный датчик Т №2","Remote Sensor 2"   },
  {CARRIER_REMOTE_SENS3     , "Дополнительный датчик Т №3","Remote Sensor 3"   },
  {CARRIER_BATTERY_VOL      , "Напряжение АКБ ХОУ","Battery Voltage"   },
  {CARRIER_FUEL_LEVEL       , "Уровень топлива цифр.","Fuel Level digital"   },
  {CARRIER_DOOR_SW          , "Датчик двери","Door Switch Status"   },
  {CARRIER_REMOTE_SW1       , "Дополнительный датчик цепи №1","Remote Switch 1"   },
  {CARRIER_REMOTE_SW2       , "Дополнительный датчик цепи №2","Remote Switch 2"   },
  {CARRIER_ENG_COOLANT      , "Температура  двигателя","Engine Coolant"   },
  {CARRIER_RPM              , "Обороты двигателя","RPM"   },
  {CARRIER_REMOTE_SW3       , "Дополнительный датчик цепи №3","Remote Switch 3"   },
  {CARRIER_REMOTE_SW4       , "Дополнительный датчик цепи №4","Remote Switch 4"   },
  {CARRIER_ENG_HOURS        , "Дизель-часы ХОУ","Total Engine Hours, h"  },
  {CARRIER_STBY_HOURS       , "Электро-часы ХОУ","Total Standby Hours, h"  },
  {CARRIER_SW_ON_HOURS      , "Общие часы ХОУ","Total Switch On Hours, h"  },
  {CARRIER_PREV_HOUR_M1     , "Часов до ТО №1","Preventative Maintenance Hour Meter 1, h"  },
  {CARRIER_PREV_HOUR_M2     , "Часов до ТО №2","Preventative Maintenance Hour Meter 2, h"  },
  {CARRIER_PREV_HOUR_M3     , "Часов до ТО №3","Preventative Maintenance Hour Meter 3, h"  },
  {CARRIER_PREV_HOUR_M4     , "Часов до ТО №4","Preventative Maintenance Hour Meter 4, h"  },
  {CARRIER_PREV_HOUR_M5     , "Часов до ТО №5","Preventative Maintenance Hour Meter 5, h"  },
  {CARRIER_ACT_INTELLISET   , "Активный IntelliSet","Active IntelliSet Name"  },
  {CARRIER_INTELLISET_FNAME , "Имя файла IntelliSet","IntelliSet File Name"  },
  {CARRIER_NUM_INTELLISET   , "Количество конфигураций IntelliSet","Number of Intellisets"  },
  {CARRIER_INTELLISET1_NAME , "Имя IntelliSet №1","Intelliset 1 Name"  },
  {CARRIER_INTELLISET2_NAME , "Имя IntelliSet №2","Intelliset 2 Name"  },
  {CARRIER_INTELLISET3_NAME , "Имя IntelliSet №3","Intelliset 3 Name"  },
  {CARRIER_INTELLISET4_NAME , "Имя IntelliSet №4","Intelliset 4 Name"  },
  {CARRIER_INTELLISET5_NAME , "Имя IntelliSet №5","Intelliset 5 Name"  },
  {CARRIER_INTELLISET6_NAME , "Имя IntelliSet №6","Intelliset 6 Name"  },
  {CARRIER_INTELLISET7_NAME , "Имя IntelliSet №7","Intelliset 7 Name"  },
  {CARRIER_INTELLISET8_NAME , "Имя IntelliSet №8","Intelliset 8 Name"  },
  {CARRIER_INTELLISET9_NAME , "Имя IntelliSet №9","Intelliset 9 Name"  },
  {CARRIER_INTELLISET10_NAME , "Имя IntelliSet №10","Intelliset 10 Name"  },
  {CARRIER_INTELLISET11_NAME , "Имя IntelliSet №11","Intelliset 11 Name"  },
  {CARRIER_INTELLISET12_NAME , "Имя IntelliSet №12","Intelliset 12 Name"  },
  {CARRIER_INTELLISET13_NAME , "Имя IntelliSet №13","Intelliset 13 Name"  },
  {CARRIER_INTELLISET14_NAME , "Имя IntelliSet №14","Intelliset 14 Name"  },
  {CARRIER_INTELLISET15_NAME , "Имя IntelliSet №15","Intelliset 15 Name"  },
  {CARRIER_INTELLISET16_NAME , "Имя IntelliSet №16","Intelliset 16 Name"  },
  {CARRIER_INTELLISET17_NAME , "Имя IntelliSet №17","Intelliset 17 Name"  },
  {CARRIER_INTELLISET18_NAME , "Имя IntelliSet №18","Intelliset 18 Name"  },
  {CARRIER_INTELLISET19_NAME , "Имя IntelliSet №19","Intelliset 19 Name"  },
  {CARRIER_INTELLISET20_NAME , "Имя IntelliSet №20","Intelliset 20 Name"  },
  {CARRIER_INTELLISET21_NAME , "Имя IntelliSet №21","Intelliset 21 Name"  },
  {CARRIER_INTELLISET22_NAME , "Имя IntelliSet №22","Intelliset 22 Name"  },
  {CARRIER_INTELLISET23_NAME , "Имя IntelliSet №23","Intelliset 23 Name"  },
  {CARRIER_INTELLISET24_NAME , "Имя IntelliSet №24","Intelliset 24 Name"  },
  {CARRIER_INTELLISET25_NAME , "Имя IntelliSet №25","Intelliset 25 Name"  },
  {CARRIER_INTELLISET26_NAME , "Имя IntelliSet №26","Intelliset 26 Name"  },
  {CARRIER_INTELLISET27_NAME , "Имя IntelliSet №27","Intelliset 27 Name"  },
  {CARRIER_INTELLISET28_NAME , "Имя IntelliSet №28","Intelliset 28 Name"  },
  {CARRIER_INTELLISET29_NAME , "Имя IntelliSet №29","Intelliset 29 Name"  },
  {CARRIER_INTELLISET30_NAME , "Имя IntelliSet №30","Intelliset 30 Name"  },
  {CARRIER_INTELLISET31_NAME , "Имя IntelliSet №31","Intelliset 31 Name"  },
  {CARRIER_C1_CONTR_PROBE   , "Управляющий датчик отсека №1","C1 Control Probe"   },
  {CARRIER_TEMP_UNITS       , "Ед. изм. T","Temperature Units"   },
  {CARRIER_PRESS_UNITS      , "Ед. изм. Давления","Pressure Units"   },
  {CARRIER_AIR_FLOW         , "Обдув (запрет низких оборотов)","Air Flow"   },
  {CARRIER_DEFROST_INTERV   , "Интервал оттайки","Defrost Interval"   },
  {CARRIER_FRESH_PROTECT    , "Защита свежего груза","Fresh Protect"   },
  {CARRIER_C2_CONTR_PROBE   , "Управляющий датчик отсека №2","C2 Control Probe"   },
  {CARRIER_AFAX_STATUS      , "Статус автоматической подачи свежего воздуха","AFAX status"   },
  {CARRIER_AFAX_SETTING     , "Настройка автоматической подачи свежего воздуха","AFAX setting"   },
  {CARRIER_AFAX_CFM_CONTR   , "Воздушный поток, фт3/мин","AFAX CFM control"   },
  {CARRIER_PRET_TEST_NUM    , "Номер теста самодиагностики","Pretrip Test Number"   },
  {CARRIER_PRET_SUBTEST_N   , "Номер этапа теста самодиагностики","Pretrip Sub-test Number"   },
  {CARRIER_PRET_TIME_DISP   , "Длительность теста, сек","Pretrip Time Display Value, sec"   },
  {CARRIER_PRET_TYPE        , "Тип предрейсового теста","Pretrip Type"  },
  {CARRIER_OVER_PRET_STAT   , "Статус теста самодиагностики","Overall Pretrip Status"   },
  {CARRIER_PRET_TEST1       , "Тест самодиагностики №1","Pretrip Test 1"   },
  {CARRIER_PRET_TEST2       , "Тест самодиагностики №2","Pretrip Test 2"   },
  {CARRIER_PRET_TEST3       , "Тест самодиагностики №3","Pretrip Test 3"   },
  {CARRIER_PRET_TEST4       , "Тест самодиагностики №4","Pretrip Test 4"   },
  {CARRIER_PRET_TEST5       , "Тест самодиагностики №5","Pretrip Test 5"   },
  {CARRIER_PRET_TEST6       , "Тест самодиагностики №6","Pretrip Test 6"   },
  {CARRIER_PRET_TEST7       , "Тест самодиагностики №7","Pretrip Test 7"   },
  {CARRIER_PRET_TEST8       , "Тест самодиагностики №8","Pretrip Test 8"   },
  {CARRIER_PRET_TEST9       , "Тест самодиагностики №9","Pretrip Test 9"   },
  {CARRIER_PRET_TEST10      , "Тест самодиагностики №10","Pretrip Test 10"   },
  {CARRIER_PRET_TEST11      , "Тест самодиагностики №11","Pretrip Test 11"   },
  {CARRIER_PRET_TEST12      , "Тест самодиагностики №12","Pretrip Test 12"   },
  {CARRIER_PRET_TEST13      , "Тест самодиагностики №13","Pretrip Test 13"   },
  {CARRIER_PRET_TEST14      , "Тест самодиагностики №14","Pretrip Test 14"   },
  {CARRIER_PRET_TEST15      , "Тест самодиагностики №15","Pretrip Test 15"   },
  {CARRIER_PRET_TEST16      , "Тест самодиагностики №16","Pretrip Test 16"   },
  {CARRIER_PRET_TEST17      , "Тест самодиагностики №17","Pretrip Test 17"   },
  {CARRIER_PRET_TEST18      , "Тест самодиагностики №18","Pretrip Test 18"   },
  {CARRIER_PRET_TEST19      , "Тест самодиагностики №19","Pretrip Test 19"   },
  {CARRIER_PRET_TEST20      , "Тест самодиагностики №20","Pretrip Test 20"   },
  {CARRIER_PRET_TEST21      , "Тест самодиагностики №21","Pretrip Test 21"   },
  {CARRIER_PRET_TEST22      , "Тест самодиагностики №22","Pretrip Test 22"   },
  {CARRIER_PRET_TEST23      , "Тест самодиагностики №23","Pretrip Test 23"   },
  {CARRIER_PRET_TEST24      , "Тест самодиагностики №24","Pretrip Test 24"   },
  {CARRIER_PRET_TEST25      , "Тест самодиагностики №25","Pretrip Test 25"   },
  {CARRIER_MODEL_NUM        , "Номер модели ХОУ","Model Number"   },
  {CARRIER_OPER_MODE        , "Баланс настроек ХОУ","Operating Mode"   },
  {CARRIER_OPER_MODE_LOCK   , "Запрет изменения баланса настроек ХОУ","Operating Mode Lock"   },
  {CARRIER_C_PIEK_OV_STAT   , "Запрет изменения уровня шума (City Piek)","City Piek Mode Override Status"   },
  {CARRIER_C_PIEK_M_STAT    , "Уровень шума (City Piek)","Current City Piek Mode Status"   },
  {CARRIER_SUCT_PRESS       , "Давление всасывания","Compressor Sensor Suction Pressure"   },
  {CARRIER_DISCH_PRESS      , "Давление нагнетания","Compressor Sensor Discharge Pressure"   },
  {CARRIER_DISCH_TEMP       , "Температура нагнетания","Compressor Sensor Discharge Temperature"  },
  {CARRIER_SMV_POS          , "Положение клапана всасывания","Compressor Sensor SMV position"   },
  {CARRIER_EXP_VALVE_POS    , "Положение ТРВ","Evaporator Sensor Expansion Valve Position"   },
  {CARRIER_OUTL_TEMP        , "Температура на выходе","Evaporator Sensor Outlet Temperature"    },
  {CARRIER_OUTL_PRESS       , "Давление на выходе","Evaporator Sensor Outlet Pressure"    },
  {CARRIER_DTT1             , "Температура оттайки №1 Отсек №1","Defrost Termination Temperature 1"   },
  {CARRIER_DTT2             , "Температура оттайки №2 Отсек №1","Defrost Termination Temperature 2"   },
  {CARRIER_COMP2_DTT        , "Температура оттайки Отсек №2","Compartment 2 DTT"   },
  {CARRIER_COMP3_DTT        , "Температура оттайки Отсек №3","Compartment 3 DTT"   },
  {CARRIER_BAT_CURR         , "Ток АКБ","Battery DC Current"   },
  {CARRIER_AC_CURR1         , "Ток АС1","Total AC Current 1"   },
  {CARRIER_AC_CURR2         , "Ток АС2","Total AC Current 2"   },
  {CARRIER_MAP_SENS         , "Датчик атмосферного давления","Manifold Atmospheric Pressure"   },
  {CARRIER_LEN_A_ALARMS     , "Количество активных тревог","Length of Active Alarm Queue/Index of Inactive Alarm Queue"   },
  {CARRIER_A_ALRM1          , "Сигнал №1 (APX)","APX/Zenith Alarm Number 1"  },
  {CARRIER_A_ALRM2          , "Сигнал №2 (APX)","APX/Zenith Alarm Number 2"  },
  {CARRIER_A_ALRM3          , "Сигнал №3 (APX)","APX/Zenith Alarm Number 3"  },
  {CARRIER_A_ALRM4          , "Сигнал №4 (APX)","APX/Zenith Alarm Number 4"  },
  {CARRIER_A_ALRM5          , "Сигнал №5 (APX)","APX/Zenith Alarm Number 5"  },
  {CARRIER_A_ALRM6          , "Сигнал №6 (APX)","APX/Zenith Alarm Number 6"  },
  {CARRIER_A_ALRM7          , "Сигнал №7 (APX)","APX/Zenith Alarm Number 7"  },
  {CARRIER_A_ALRM8          , "Сигнал №8 (APX)","APX/Zenith Alarm Number 8"  },
  {CARRIER_A_ALRM9          , "Сигнал №9 (APX)","APX/Zenith Alarm Number 9"  },
  {CARRIER_A_ALRM10         , "Сигнал №10 (APX)","APX/Zenith Alarm Number 10"  },
  {CARRIER_A_ALRM11         , "Сигнал №11 (APX)","APX/Zenith Alarm Number 11"  },
  {CARRIER_A_ALRM12         , "Сигнал №12 (APX)","APX/Zenith Alarm Number 12"  },
  {CARRIER_A_ALRM13         , "Сигнал №13 (APX)","APX/Zenith Alarm Number 13"  },
  {CARRIER_A_ALRM14         , "Сигнал №14 (APX)","APX/Zenith Alarm Number 14"  },
  {CARRIER_A_ALRM15         , "Сигнал №15 (APX)","APX/Zenith Alarm Number 15"  },
  {CARRIER_A_ALRM16         , "Сигнал №16 (APX)","APX/Zenith Alarm Number 16"  },
  {CARRIER_KOHLER_PCOD1     , "Kohler сигнал №1" ,"Kohler PCodes 1" },
  {CARRIER_KOHLER_PCOD2     , "Kohler сигнал №2" ,"Kohler PCodes 2" },
  {CARRIER_KOHLER_PCOD3     , "Kohler сигнал №3" ,"Kohler PCodes 3" },
  {CARRIER_KOHLER_PCOD4     , "Kohler сигнал №4" ,"Kohler PCodes 4" },
  {CARRIER_KOHLER_PCOD5     , "Kohler сигнал №5" ,"Kohler PCodes 5" },
  {CARRIER_KOHLER_PCOD6     , "Kohler сигнал №6" ,"Kohler PCodes 6" },
  {CARRIER_KOHLER_PCOD7     , "Kohler сигнал №7" ,"Kohler PCodes 7" },
  {CARRIER_KOHLER_PCOD8     , "Kohler сигнал №8" ,"Kohler PCodes 8" },
  {CARRIER_KOHLER_PCOD9     , "Kohler сигнал №9" ,"Kohler PCodes 9" },
  {CARRIER_KOHLER_PCOD10    , "Kohler сигнал №10","Kohler PCodes 10"},
  {CARRIER_KOHLER_PCOD11    , "Kohler сигнал №11","Kohler PCodes 11"},
  {CARRIER_KOHLER_PCOD12    , "Kohler сигнал №12","Kohler PCodes 12"},
  {CARRIER_KOHLER_PCOD13    , "Kohler сигнал №13","Kohler PCodes 13"},
  {CARRIER_KOHLER_PCOD14    , "Kohler сигнал №14","Kohler PCodes 14"},
  {CARRIER_KOHLER_PCOD15    , "Kohler сигнал №15","Kohler PCodes 15"},
  {CARRIER_KOHLER_PCOD16    , "Kohler сигнал №16","Kohler PCodes 16"},
  {CARRIER_TYPE_MP          , "Тип МП ХОУ","Type MP"},
  {CARRIER_FUEL_LEVEL_AN    , "Уровень топлива аналог.","Fuel Level analog"   },
  {CARRIER_COMMAND          , "Команда ХОУ","Command MP"},
  {CARRIER_COMMAND_ANS      , "Статус команды ХОУ","Status command MP"},
#endif // (CARRIER_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT) || defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 0)
    {CUSTOM_CAN_SENSOR_FIRST_ID+0, "Пользовательский CAN-датчик №1", "Custom CAN-sensor #1"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 1)
    {CUSTOM_CAN_SENSOR_FIRST_ID+1, "Пользовательский CAN-датчик №2", "Custom CAN-sensor #2"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 2)
    {CUSTOM_CAN_SENSOR_FIRST_ID+2, "Пользовательский CAN-датчик №3", "Custom CAN-sensor #3"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 3)
    {CUSTOM_CAN_SENSOR_FIRST_ID+3, "Пользовательский CAN-датчик №4", "Custom CAN-sensor #4"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 4)
    {CUSTOM_CAN_SENSOR_FIRST_ID+4, "Пользовательский CAN-датчик №5", "Custom CAN-sensor #5"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 5)
    {CUSTOM_CAN_SENSOR_FIRST_ID+5, "Пользовательский CAN-датчик №6", "Custom CAN-sensor #6"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 6)
    {CUSTOM_CAN_SENSOR_FIRST_ID+6, "Пользовательский CAN-датчик №7", "Custom CAN-sensor #7"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 7)
    {CUSTOM_CAN_SENSOR_FIRST_ID+7, "Пользовательский CAN-датчик №8", "Custom CAN-sensor #8"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 8)
    {CUSTOM_CAN_SENSOR_FIRST_ID+8, "Пользовательский CAN-датчик №9", "Custom CAN-sensor #9"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 9)
    {CUSTOM_CAN_SENSOR_FIRST_ID+9, "Пользовательский CAN-датчик №10", "Custom CAN-sensor #10"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 10)
    {CUSTOM_CAN_SENSOR_FIRST_ID+10, "Пользовательский CAN-датчик №11", "Custom CAN-sensor #11"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 11)
    {CUSTOM_CAN_SENSOR_FIRST_ID+11, "Пользовательский CAN-датчик №12", "Custom CAN-sensor #12"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 12)
    {CUSTOM_CAN_SENSOR_FIRST_ID+12, "Пользовательский CAN-датчик №13", "Custom CAN-sensor #13"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 13)
    {CUSTOM_CAN_SENSOR_FIRST_ID+13, "Пользовательский CAN-датчик №14", "Custom CAN-sensor #14"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 14)
    {CUSTOM_CAN_SENSOR_FIRST_ID+14, "Пользовательский CAN-датчик №15", "Custom CAN-sensor #15"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 15)
    {CUSTOM_CAN_SENSOR_FIRST_ID+15, "Пользовательский CAN-датчик №16", "Custom CAN-sensor #16"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 16)
    {CUSTOM_CAN_SENSOR_FIRST_ID+16, "Пользовательский CAN-датчик №17", "Custom CAN-sensor #17"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 17)
    {CUSTOM_CAN_SENSOR_FIRST_ID+17, "Пользовательский CAN-датчик №18", "Custom CAN-sensor #18"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 18)
    {CUSTOM_CAN_SENSOR_FIRST_ID+18, "Пользовательский CAN-датчик №19", "Custom CAN-sensor #19"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 19)
    {CUSTOM_CAN_SENSOR_FIRST_ID+19, "Пользовательский CAN-датчик №20", "Custom CAN-sensor #20"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 20)
    {CUSTOM_CAN_SENSOR_FIRST_ID+20, "Пользовательский CAN-датчик №21", "Custom CAN-sensor #21"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 21)
    {CUSTOM_CAN_SENSOR_FIRST_ID+21, "Пользовательский CAN-датчик №22", "Custom CAN-sensor #22"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 22)
    {CUSTOM_CAN_SENSOR_FIRST_ID+22, "Пользовательский CAN-датчик №23", "Custom CAN-sensor #23"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 23)
    {CUSTOM_CAN_SENSOR_FIRST_ID+23, "Пользовательский CAN-датчик №24", "Custom CAN-sensor #24"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 24)
    {CUSTOM_CAN_SENSOR_FIRST_ID+24, "Пользовательский CAN-датчик №25", "Custom CAN-sensor #25"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 25)
    {CUSTOM_CAN_SENSOR_FIRST_ID+25, "Пользовательский CAN-датчик №26", "Custom CAN-sensor #26"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 26)
    {CUSTOM_CAN_SENSOR_FIRST_ID+26, "Пользовательский CAN-датчик №27", "Custom CAN-sensor #27"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 27)
    {CUSTOM_CAN_SENSOR_FIRST_ID+27, "Пользовательский CAN-датчик №28", "Custom CAN-sensor #28"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 28)
    {CUSTOM_CAN_SENSOR_FIRST_ID+28, "Пользовательский CAN-датчик №29", "Custom CAN-sensor #29"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 29)
    {CUSTOM_CAN_SENSOR_FIRST_ID+29, "Пользовательский CAN-датчик №30", "Custom CAN-sensor #30"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 30)
    {CUSTOM_CAN_SENSOR_FIRST_ID+30, "Пользовательский CAN-датчик №31", "Custom CAN-sensor #31"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 31)
    {CUSTOM_CAN_SENSOR_FIRST_ID+31, "Пользовательский CAN-датчик №32", "Custom CAN-sensor #32"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 32)
    {CUSTOM_CAN_SENSOR_FIRST_ID+32, "Пользовательский CAN-датчик №33", "Custom CAN-sensor #33"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 33)
    {CUSTOM_CAN_SENSOR_FIRST_ID+33, "Пользовательский CAN-датчик №34", "Custom CAN-sensor #34"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 34)
    {CUSTOM_CAN_SENSOR_FIRST_ID+34, "Пользовательский CAN-датчик №35", "Custom CAN-sensor #35"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 35)
    {CUSTOM_CAN_SENSOR_FIRST_ID+35, "Пользовательский CAN-датчик №36", "Custom CAN-sensor #36"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 36)
    {CUSTOM_CAN_SENSOR_FIRST_ID+36, "Пользовательский CAN-датчик №37", "Custom CAN-sensor #37"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 37)
    {CUSTOM_CAN_SENSOR_FIRST_ID+37, "Пользовательский CAN-датчик №38", "Custom CAN-sensor #38"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 38)
    {CUSTOM_CAN_SENSOR_FIRST_ID+38, "Пользовательский CAN-датчик №39", "Custom CAN-sensor #39"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 39)
    {CUSTOM_CAN_SENSOR_FIRST_ID+39, "Пользовательский CAN-датчик №40", "Custom CAN-sensor #40"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 40)
    {CUSTOM_CAN_SENSOR_FIRST_ID+40, "Пользовательский CAN-датчик №41", "Custom CAN-sensor #41"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 41)
    {CUSTOM_CAN_SENSOR_FIRST_ID+41, "Пользовательский CAN-датчик №42", "Custom CAN-sensor #42"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 42)
    {CUSTOM_CAN_SENSOR_FIRST_ID+42, "Пользовательский CAN-датчик №43", "Custom CAN-sensor #43"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 43)
    {CUSTOM_CAN_SENSOR_FIRST_ID+43, "Пользовательский CAN-датчик №44", "Custom CAN-sensor #44"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 44)
    {CUSTOM_CAN_SENSOR_FIRST_ID+44, "Пользовательский CAN-датчик №45", "Custom CAN-sensor #45"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 45)
    {CUSTOM_CAN_SENSOR_FIRST_ID+45, "Пользовательский CAN-датчик №46", "Custom CAN-sensor #46"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 46)
    {CUSTOM_CAN_SENSOR_FIRST_ID+46, "Пользовательский CAN-датчик №47", "Custom CAN-sensor #47"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 47)
    {CUSTOM_CAN_SENSOR_FIRST_ID+47, "Пользовательский CAN-датчик №48", "Custom CAN-sensor #48"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 48)
    {CUSTOM_CAN_SENSOR_FIRST_ID+48, "Пользовательский CAN-датчик №49", "Custom CAN-sensor #49"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 49)
    {CUSTOM_CAN_SENSOR_FIRST_ID+49, "Пользовательский CAN-датчик №50", "Custom CAN-sensor #50"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 50)
    {CUSTOM_CAN_SENSOR_FIRST_ID+50, "Пользовательский CAN-датчик №51", "Custom CAN-sensor #51"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 51)
    {CUSTOM_CAN_SENSOR_FIRST_ID+51, "Пользовательский CAN-датчик №52", "Custom CAN-sensor #52"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 52)
    {CUSTOM_CAN_SENSOR_FIRST_ID+52, "Пользовательский CAN-датчик №53", "Custom CAN-sensor #53"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 53)
    {CUSTOM_CAN_SENSOR_FIRST_ID+53, "Пользовательский CAN-датчик №54", "Custom CAN-sensor #54"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 54)
    {CUSTOM_CAN_SENSOR_FIRST_ID+54, "Пользовательский CAN-датчик №55", "Custom CAN-sensor #55"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 55)
    {CUSTOM_CAN_SENSOR_FIRST_ID+55, "Пользовательский CAN-датчик №56", "Custom CAN-sensor #56"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 56)
    {CUSTOM_CAN_SENSOR_FIRST_ID+56, "Пользовательский CAN-датчик №57", "Custom CAN-sensor #57"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 57)
    {CUSTOM_CAN_SENSOR_FIRST_ID+57, "Пользовательский CAN-датчик №58", "Custom CAN-sensor #58"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 58)
    {CUSTOM_CAN_SENSOR_FIRST_ID+58, "Пользовательский CAN-датчик №59", "Custom CAN-sensor #59"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 59)
    {CUSTOM_CAN_SENSOR_FIRST_ID+59, "Пользовательский CAN-датчик №60", "Custom CAN-sensor #60"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 60)
    {CUSTOM_CAN_SENSOR_FIRST_ID+60, "Пользовательский CAN-датчик №61", "Custom CAN-sensor #61"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 61)
    {CUSTOM_CAN_SENSOR_FIRST_ID+61, "Пользовательский CAN-датчик №62", "Custom CAN-sensor #62"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 62)
    {CUSTOM_CAN_SENSOR_FIRST_ID+62, "Пользовательский CAN-датчик №63", "Custom CAN-sensor #63"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 63)
    {CUSTOM_CAN_SENSOR_FIRST_ID+63, "Пользовательский CAN-датчик №64", "Custom CAN-sensor #64"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 64)
    {CUSTOM_CAN_SENSOR_FIRST_ID+64, "Пользовательский CAN-датчик №65", "Custom CAN-sensor #65"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 65)
    {CUSTOM_CAN_SENSOR_FIRST_ID+65, "Пользовательский CAN-датчик №66", "Custom CAN-sensor #66"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 66)
    {CUSTOM_CAN_SENSOR_FIRST_ID+66, "Пользовательский CAN-датчик №67", "Custom CAN-sensor #67"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 67)
    {CUSTOM_CAN_SENSOR_FIRST_ID+67, "Пользовательский CAN-датчик №68", "Custom CAN-sensor #68"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 68)
    {CUSTOM_CAN_SENSOR_FIRST_ID+68, "Пользовательский CAN-датчик №69", "Custom CAN-sensor #69"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 69)
    {CUSTOM_CAN_SENSOR_FIRST_ID+69, "Пользовательский CAN-датчик №70", "Custom CAN-sensor #70"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 70)
    {CUSTOM_CAN_SENSOR_FIRST_ID+70, "Пользовательский CAN-датчик №71", "Custom CAN-sensor #71"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 71)
    {CUSTOM_CAN_SENSOR_FIRST_ID+71, "Пользовательский CAN-датчик №72", "Custom CAN-sensor #72"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 72)
    {CUSTOM_CAN_SENSOR_FIRST_ID+72, "Пользовательский CAN-датчик №73", "Custom CAN-sensor #73"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 73)
    {CUSTOM_CAN_SENSOR_FIRST_ID+73, "Пользовательский CAN-датчик №74", "Custom CAN-sensor #74"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 74)
    {CUSTOM_CAN_SENSOR_FIRST_ID+74, "Пользовательский CAN-датчик №75", "Custom CAN-sensor #75"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 75)
    {CUSTOM_CAN_SENSOR_FIRST_ID+75, "Пользовательский CAN-датчик №76", "Custom CAN-sensor #76"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 76)
    {CUSTOM_CAN_SENSOR_FIRST_ID+76, "Пользовательский CAN-датчик №77", "Custom CAN-sensor #77"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 77)
    {CUSTOM_CAN_SENSOR_FIRST_ID+77, "Пользовательский CAN-датчик №78", "Custom CAN-sensor #78"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 78)
    {CUSTOM_CAN_SENSOR_FIRST_ID+78, "Пользовательский CAN-датчик №79", "Custom CAN-sensor #79"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 79)
    {CUSTOM_CAN_SENSOR_FIRST_ID+79, "Пользовательский CAN-датчик №80", "Custom CAN-sensor #80"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 80)
    {CUSTOM_CAN_SENSOR_FIRST_ID+80, "Пользовательский CAN-датчик №81", "Custom CAN-sensor #81"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 81)
    {CUSTOM_CAN_SENSOR_FIRST_ID+81, "Пользовательский CAN-датчик №82", "Custom CAN-sensor #82"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 82)
    {CUSTOM_CAN_SENSOR_FIRST_ID+82, "Пользовательский CAN-датчик №83", "Custom CAN-sensor #83"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 83)
    {CUSTOM_CAN_SENSOR_FIRST_ID+83, "Пользовательский CAN-датчик №84", "Custom CAN-sensor #84"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 84)
    {CUSTOM_CAN_SENSOR_FIRST_ID+84, "Пользовательский CAN-датчик №85", "Custom CAN-sensor #85"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 85)
    {CUSTOM_CAN_SENSOR_FIRST_ID+85, "Пользовательский CAN-датчик №86", "Custom CAN-sensor #86"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 86)
    {CUSTOM_CAN_SENSOR_FIRST_ID+86, "Пользовательский CAN-датчик №87", "Custom CAN-sensor #87"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 87)
    {CUSTOM_CAN_SENSOR_FIRST_ID+87, "Пользовательский CAN-датчик №88", "Custom CAN-sensor #88"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 88)
    {CUSTOM_CAN_SENSOR_FIRST_ID+88, "Пользовательский CAN-датчик №89", "Custom CAN-sensor #89"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 89)
    {CUSTOM_CAN_SENSOR_FIRST_ID+89, "Пользовательский CAN-датчик №90", "Custom CAN-sensor #90"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 90)
    {CUSTOM_CAN_SENSOR_FIRST_ID+90, "Пользовательский CAN-датчик №91", "Custom CAN-sensor #91"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 91)
    {CUSTOM_CAN_SENSOR_FIRST_ID+91, "Пользовательский CAN-датчик №92", "Custom CAN-sensor #92"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 92)
    {CUSTOM_CAN_SENSOR_FIRST_ID+92, "Пользовательский CAN-датчик №93", "Custom CAN-sensor #93"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 93)
    {CUSTOM_CAN_SENSOR_FIRST_ID+93, "Пользовательский CAN-датчик №94", "Custom CAN-sensor #94"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 94)
    {CUSTOM_CAN_SENSOR_FIRST_ID+94, "Пользовательский CAN-датчик №95", "Custom CAN-sensor #95"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 95)
    {CUSTOM_CAN_SENSOR_FIRST_ID+95, "Пользовательский CAN-датчик №96", "Custom CAN-sensor #96"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 96)
    {CUSTOM_CAN_SENSOR_FIRST_ID+96, "Пользовательский CAN-датчик №97", "Custom CAN-sensor #97"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 97)
    {CUSTOM_CAN_SENSOR_FIRST_ID+97, "Пользовательский CAN-датчик №98", "Custom CAN-sensor #98"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 98)
    {CUSTOM_CAN_SENSOR_FIRST_ID+98, "Пользовательский CAN-датчик №99", "Custom CAN-sensor #99"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 99)
    {CUSTOM_CAN_SENSOR_FIRST_ID+99, "Пользовательский CAN-датчик №100", "Custom CAN-sensor #100"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 100)
    {CUSTOM_CAN_SENSOR_FIRST_ID+100, "Пользовательский CAN-датчик №101", "Custom CAN-sensor #101"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 101)
    {CUSTOM_CAN_SENSOR_FIRST_ID+101, "Пользовательский CAN-датчик №102", "Custom CAN-sensor #102"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 102)
    {CUSTOM_CAN_SENSOR_FIRST_ID+102, "Пользовательский CAN-датчик №103", "Custom CAN-sensor #103"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 103)
    {CUSTOM_CAN_SENSOR_FIRST_ID+103, "Пользовательский CAN-датчик №104", "Custom CAN-sensor #104"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 104)
    {CUSTOM_CAN_SENSOR_FIRST_ID+104, "Пользовательский CAN-датчик №105", "Custom CAN-sensor #105"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 105)
    {CUSTOM_CAN_SENSOR_FIRST_ID+105, "Пользовательский CAN-датчик №106", "Custom CAN-sensor #106"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 106)
    {CUSTOM_CAN_SENSOR_FIRST_ID+106, "Пользовательский CAN-датчик №107", "Custom CAN-sensor #107"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 107)
    {CUSTOM_CAN_SENSOR_FIRST_ID+107, "Пользовательский CAN-датчик №108", "Custom CAN-sensor #108"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 108)
    {CUSTOM_CAN_SENSOR_FIRST_ID+108, "Пользовательский CAN-датчик №109", "Custom CAN-sensor #109"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 109)
    {CUSTOM_CAN_SENSOR_FIRST_ID+109, "Пользовательский CAN-датчик №110", "Custom CAN-sensor #110"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 110)
    {CUSTOM_CAN_SENSOR_FIRST_ID+110, "Пользовательский CAN-датчик №111", "Custom CAN-sensor #111"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 111)
    {CUSTOM_CAN_SENSOR_FIRST_ID+111, "Пользовательский CAN-датчик №112", "Custom CAN-sensor #112"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 112)
    {CUSTOM_CAN_SENSOR_FIRST_ID+112, "Пользовательский CAN-датчик №113", "Custom CAN-sensor #113"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 113)
    {CUSTOM_CAN_SENSOR_FIRST_ID+113, "Пользовательский CAN-датчик №114", "Custom CAN-sensor #114"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 114)
    {CUSTOM_CAN_SENSOR_FIRST_ID+114, "Пользовательский CAN-датчик №115", "Custom CAN-sensor #115"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 115)
    {CUSTOM_CAN_SENSOR_FIRST_ID+115, "Пользовательский CAN-датчик №116", "Custom CAN-sensor #116"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 116)
    {CUSTOM_CAN_SENSOR_FIRST_ID+116, "Пользовательский CAN-датчик №117", "Custom CAN-sensor #117"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 117)
    {CUSTOM_CAN_SENSOR_FIRST_ID+117, "Пользовательский CAN-датчик №118", "Custom CAN-sensor #118"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 118)
    {CUSTOM_CAN_SENSOR_FIRST_ID+118, "Пользовательский CAN-датчик №119", "Custom CAN-sensor #119"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 119)
    {CUSTOM_CAN_SENSOR_FIRST_ID+119, "Пользовательский CAN-датчик №120", "Custom CAN-sensor #120"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 120)
    {CUSTOM_CAN_SENSOR_FIRST_ID+120, "Пользовательский CAN-датчик №121", "Custom CAN-sensor #121"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 121)
    {CUSTOM_CAN_SENSOR_FIRST_ID+121, "Пользовательский CAN-датчик №122", "Custom CAN-sensor #122"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 122)
    {CUSTOM_CAN_SENSOR_FIRST_ID+122, "Пользовательский CAN-датчик №123", "Custom CAN-sensor #123"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 123)
    {CUSTOM_CAN_SENSOR_FIRST_ID+123, "Пользовательский CAN-датчик №124", "Custom CAN-sensor #124"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 124)
    {CUSTOM_CAN_SENSOR_FIRST_ID+124, "Пользовательский CAN-датчик №125", "Custom CAN-sensor #125"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 125)
    {CUSTOM_CAN_SENSOR_FIRST_ID+125, "Пользовательский CAN-датчик №126", "Custom CAN-sensor #126"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 126)
    {CUSTOM_CAN_SENSOR_FIRST_ID+126, "Пользовательский CAN-датчик №127", "Custom CAN-sensor #127"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 127)
    {CUSTOM_CAN_SENSOR_FIRST_ID+127, "Пользовательский CAN-датчик №128", "Custom CAN-sensor #128"},
    #endif
    #if (MAX_CUSTOM_CAN_SENSORS_COUNT > 128)
    #error Нужно добавить сюда custom_can_sensor
    #endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT) || defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
    #if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 0)
    {CUSTOM_CAN_STR_SENSOR_FIRST_ID+0, "Пользовательский строковый CAN-датчик №1", "Custom string CAN-sensor #1"},
    #endif
    #if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 1)
    {CUSTOM_CAN_STR_SENSOR_FIRST_ID+1, "Пользовательский строковый CAN-датчик №2", "Custom string CAN-sensor #2"},
    #endif
    #if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 2)
    {CUSTOM_CAN_STR_SENSOR_FIRST_ID+2, "Пользовательский строковый CAN-датчик №3", "Custom string CAN-sensor #3"},
    #endif
    #if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 3)
    {CUSTOM_CAN_STR_SENSOR_FIRST_ID+3, "Пользовательский строковый CAN-датчик №4", "Custom string CAN-sensor #4"},
    #endif
    #if (MAX_CUSTOM_CAN_STR_SENSORS_COUNT > 4)
    #error Нужно добавить сюда custom_can_str_sensor
    #endif
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
    {CAN_CUSTOM_SENSOR_BAD_CRC_BF, "CAN-sensor bad crc bf", "CAN-sensor bad crc bf"},
    {ISOTP_CAN_CUSTOM_SENSOR_BAD_CRC_BF, "ISO TP CAN-sensor bad crc bf", "ISO TP CAN-sensor bad crc bf"},
    {CAN_CUSTOM_SENSOR_SETTINGS_KEY_HASH, "CAN-sensor key hash", "CAN-sensor key hash"},
    {ISOTP_CAN_SENSOR_SETTINGS_VERS, "Версия настроек ISOTP CAN-датчиков", "ISOTP CAN-sensor settings version"},
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(VEGA_CAN_PRESENT)
    #if (MAX_CAN_INTERFACES > 0)
    {CAN1_HW_STATE + 0, "Состояние CAN1",  "CAN1 State"},
    #endif
    #if (MAX_CAN_INTERFACES > 1)
    {CAN1_HW_STATE + 1, "Состояние CAN2",  "CAN2 State"},
    #endif
    #if (MAX_CAN_INTERFACES > 2)
    {CAN1_HW_STATE + 2, "Состояние CAN3",  "CAN3 State"},
    #endif
    #if (MAX_CAN_INTERFACES > 3)
    {CAN1_HW_STATE + 3, "Состояние CAN4",  "CAN4 State"},
    #endif
    #if (MAX_CAN_INTERFACES > 4)
    #error
    #endif
#endif //defined(VEGA_CAN_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
    {CUSTOM_CAN_SENSOR_SETTINGS_VERS, "Версия настроек пользовательских CAN-датчиков", "Custom CAN-sensor settings version"},
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CANPRO_PRESENT)
    {CAN_SPECIAL_FLAGS_BITFIELD     , "CAN: Специальные флаги", "CAN: Special flags"},
    {CAN_SECURITY_NAVIS_BITFIELD    , "CAN: Флаги охраны", "CAN: Security flags"},
    {CAN_CONTROL_NAVIS_BITFIELD     , "CAN: Флаги контроля", "CAN: Control flags"},
    {CAN_AGRO_NAVIS_BITFIELD        , "CAN: Флаги агротехники", "CAN: Agrotechnics flags"},

    {CAN_SYS_INF              , "CAN: Инфо о загрузчике", "CAN bootloader info"},
    {CAN_UPD_PCT              , "CAN: Процент обновления CAN", "CAN FW updating percent"},
#endif  //CANPRO_PRESENT

#if defined(MDAS9_PRESENT)
  {MDAS9_COOMUNICATION_STATE  , "Cвязь с MDAS-9", "MDAS-9 online"},
  {MDAS9_SPEED                , "Скорость", "Speed"},
  {MDAS9_LEFT_TURN_SIGNAL     , "Указатель левого поворота", "Left turn signal"},
  {MDAS9_RIGHT_TURN_SIGNAL    , "Указатель правого поворота", "Right turn signal"},
  {MDAS9_BRAKE_SIGNAL         , "Сигнал тормоза", "Brake signal"},
  {MDAS9_RPM                  , "Обороты двигателя", "RPM"},
  {MDAS9_LDW_LEFT             , "Сближение c линией разметки слева", "LDW(Line Departure Warning) left"},
  {MDAS9_LDW_RIGHT            , "Сближение c линией разметки справа", "LDW(Line Departure Warning) right"},
  {MDAS9_LEFT_DISTANCE        , "Дистанция до левой линии, см", "Length of left lane, cm "},
  {MDAS9_RIGHT_DISTANCE       , "Дистанция до правой линии, см", "Length of right lane, cm"},
  {MDAS9_TTC                  , "Время TTC, сек", "TTC time, sec"},
  {MDAS9_SDA                  , "Сближение с передним автомобилем", "SDA(Safety Distance Alert)"},
  {MDAS9_FVSA                 , "Начало движения автомобиля спереди", "FVSA(Front Vehicle Start Alarm)"},
  {MDAS9_FPW                  , "Приближение автомобиля спереди", "FPW(Forward Proximity Warning)"},
  {MDAS9_FCW                  , "Возможное столкновение", "FCW (Forward Collision Warning)"},
  {MDAS9_PCW                  , "Сближение с пешеходом", "PCW (Pedestrian Collision Warning)"},
  {MDAS9_RECORD               , "Включение записи", "Record"},
  {MDAS9_ERROR                , "Код ошибки", "Error code"},
  {MDAS9_AHEAD_DISTANSE       , "Дистанция спереди, м", "Ahead Distance, m"},
  {MDAS9_AHEAD_SPEED          , "Cкорость cпереди едущего, км/ч", "Ahead Speed, km/h"},
  {MDAS9_SLR_STATE            , "Состояние ограничителя скорости", "SLR(Speed Limit Recongnition) State"},
  {MDAS9_SLR_RECOGNIZE        , "Уставка ограничителя скорости, км/ч", "SLR(Speed Limit Recongnition) Recognize, km/h"},
  {MDAS9_SLR_SENSITIVITY      , "Чувствительность ограничителя скорости, %", "SLR(Speed Limit Recongnition) Sensitivity, %"},
#endif // (MDAS9_PRESENT)

#if defined(MDSM7_PRESENT)
  {MDSM7_COOMUNICATION_STATE  , "Cвязь с MDSM-7", "MDSM-7 online"},
  {MDSM7_SPEED                , "Скорость", "Speed"},
  {MDSM7_DUMMY_CARINFO        , "Информация об авто","Dummy CARINFO"},
  {MDSM7_DSM_EVENT            , "Статус DSM","DSM Event"},
  {MDSM7_DRIVER_NAME          , "Имя водителя","Driver Name"},
  {MDSM7_RECORD_STATUS        , "Включение записи","Record Status"},
  {MDSM7_GPS_STATUS           , "Cтатус GPS","GPS Status"},
  {MDSM7_LATITUDE             , "Широта","GPS Latitude"},
  {MDSM7_LONGITUDE            , "Долгота","GPS Longitude"},
  {MDSM7_ERROR_CODE           , "Код ошибки","Error Code"},
  {MDSM7_YEAR                 , "Год","Year"},
  {MDSM7_MON                  , "Месяц","Month"},
  {MDSM7_DAY                  , "День","Day"},
  {MDSM7_HOUR                 , "Час","Hour"},
  {MDSM7_MIN                  , "Минута","Min"},
  {MDSM7_SEC                  , "Cекунда","Sec"},
  {MDSM7_G_SENSOR             , "G-сенсор","G-Sensor Event"},
#endif // (MDSM7_PRESENT)

#if defined(HUM_SENSOR_IAKM_PRESENT)
  {IAKM_COOMUNICATION_STATE  , "Cвязь с IAKM", "IAKM online"},
  {IAKM_TEMP_SENS       , "Температура,°C","Temperature,°C"},
  {IAKM_TEMP_ERROR      , "Код ошибки канала температуры","Temperature channel error code"},
  {IAKM_HUM_SENS        , "Относительная влажность, %","Relative humidity, %"},
  {IAKM_HUM_ERROR       , "Код ошибки канала относительной влажности","Relative humidity channel error code"},
#endif //HUM_SENSOR_IAKM_PRESENT

#if defined(SCD30_PRESENT)
  {SCD30_COOMUNICATION_STATE   ,  "Cвязь с IAKM", "IAKM online"},
  {SCD30_TEMP_SENS             ,  "Температура,°C","Temperature,°C"},
  {SCD30_HUM_SENS              ,  "Относительная влажность, %","Relative humidity, %"},
  {SCD30_CO2_SENS              ,  "C02, ppm","C02, ppm"},
#endif //(SCD30_PRESENT)

#if defined(CANLOG_V4_PRESENT)
//вторая часть датчиков CANLOG_V4
#if defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
  {CAN_V4_AGRICULTURAL_FL_D11 ,
   "Сельскохозяйственные (11)\n"
        "\tРезерв"
   ,
   "Agricultural (11)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D12 ,
   "Сельскохозяйственные (12)\n"
        "\tРезерв"
   ,
   "Agricultural (12)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D13 ,
   "Сельскохозяйственные (13)\n"
        "\tРезерв"
   ,
   "Agricultural (13)\n"
        "\tРезерв"},

  {CAN_V4_AGRICULTURAL_FL_D14 ,
   "Сельскохозяйственные (14)\n"
        "\tReserve"
   ,
   "Agricultural (14)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D15 ,
   "Сельскохозяйственные (15)\n"
        "\tРезерв"
   ,
   "Agricultural (15)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D16 ,
   "Сельскохозяйственные (16)\n"
        "\tРезерв"
   ,
   "Agricultural (16)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D17 ,
   "Сельскохозяйственные (17)\n"
        "\tРезерв"
   ,
   "Agricultural (17)\n"
        "\tReserve"},

  {CAN_V4_AGRICULTURAL_FL_D18 ,
   "Сельскохозяйственные (18)\n"
        "\tОпрыскиватель, сегмент 1"
   ,
   "Agricultural (18)\n"
        "\tSpraying, segment 1"},

  {CAN_V4_AGRICULTURAL_FL_D19 ,
   "Сельскохозяйственные (19)\n"
        "\tОпрыскиватель, сегмент 2\n"
        "\tОпрыскиватель, сегмент 3\n"
        "\tОпрыскиватель, сегмент 4\n"
        "\tОпрыскиватель, сегмент 5"
   ,
   "Agricultural (19)\n"
        "\tSpraying, segment 2\n"
        "\tSpraying, segment 3\n"
        "\tSpraying, segment 4\n"
        "\tSpraying, segment 5"},

  {CAN_V4_AGRICULTURAL_FL_D20 ,
   "Сельскохозяйственные (20)\n"
        "\tОпрыскиватель, сегмент 6\n"
        "\tОпрыскиватель, сегмент 7\n"
        "\tОпрыскиватель, сегмент 8\n"
        "\tОпрыскиватель, сегмент 9"
   ,
   "Agricultural (20)\n"
        "\tSpraying, segment 6\n"
        "\tSpraying, segment 7\n"
        "\tSpraying, segment 8\n"
        "\tSpraying, segment 9"},
#endif //defined(CANLOG_V4_AGRICULTURAL_VEHICLES_FLAGS_PRESENT)
#endif //defined(CANLOG_V4_PRESENT)

#if defined(BLE_SENSORS_PRESENT)

    #if (MAX_BLE_SENSORS_COUNT > 0)
    {BLE_SENSOR1_VISIBLE,  "BLE датчик 1: Видимость", "BLE sensor 1: Visible"},
    {BLE_SENSOR1_TIMER,    "BLE датчик 1: Был на связи, секунд назад", "BLE sensor 1: Was online, seconds ago"},
    {BLE_SENSOR1_RSSI,     "BLE датчик 1: Уровень сигнала", "BLE sensor 1: RSSI"},
    {BLE_SENSOR1_BATT,     "BLE датчик 1: Уровень заряда батареи", "BLE sensor 1: Battery level"},
    {BLE_SENSOR1_U8,       "BLE датчик 1: DATA 1", "BLE sensor 1: DATA 1"},
    {BLE_SENSOR1_I16_1,    "BLE датчик 1: DATA 2", "BLE sensor 1: DATA 2"},
    {BLE_SENSOR1_I16_2,    "BLE датчик 1: DATA 3", "BLE sensor 1: DATA 3"},
    {BLE_SENSOR1_U16_1,    "BLE датчик 1: DATA 4", "BLE sensor 1: DATA 4"},
    {BLE_SENSOR1_U16_2,    "BLE датчик 1: DATA 5", "BLE sensor 1: DATA 5"},
    //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 1)
    {BLE_SENSOR2_VISIBLE,  "BLE датчик 2: Видимость", "BLE sensor 2: Visible"},
    {BLE_SENSOR2_TIMER,    "BLE датчик 2: Был на связи, секунд назад", "BLE sensor 2: Was online, seconds ago"},
    {BLE_SENSOR2_RSSI,     "BLE датчик 2: Уровень сигнала", "BLE sensor 2: RSSI"},
    {BLE_SENSOR2_BATT,     "BLE датчик 2: Уровень заряда батареи", "BLE sensor 2: Battery level"},
    {BLE_SENSOR2_U8,       "BLE датчик 2: DATA 1", "BLE sensor 2: DATA 1"},
    {BLE_SENSOR2_I16_1,    "BLE датчик 2: DATA 2", "BLE sensor 2: DATA 2"},
    {BLE_SENSOR2_I16_2,    "BLE датчик 2: DATA 3", "BLE sensor 2: DATA 3"},
    {BLE_SENSOR2_U16_1,    "BLE датчик 2: DATA 4", "BLE sensor 2: DATA 4"},
    {BLE_SENSOR2_U16_2,    "BLE датчик 2: DATA 5", "BLE sensor 2: DATA 5"},
    //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 2)
    {BLE_SENSOR3_VISIBLE,  "BLE датчик 3: Видимость", "BLE sensor 3: Visible"},
    {BLE_SENSOR3_TIMER,    "BLE датчик 3: Был на связи, секунд назад", "BLE sensor 3: Was online, seconds ago"},
    {BLE_SENSOR3_RSSI,     "BLE датчик 3: Уровень сигнала", "BLE sensor 3: RSSI"},
    {BLE_SENSOR3_BATT,     "BLE датчик 3: Уровень заряда батареи", "BLE sensor 3: Battery level"},
    {BLE_SENSOR3_U8,       "BLE датчик 3: DATA 1", "BLE sensor 3: DATA 1"},
    {BLE_SENSOR3_I16_1,    "BLE датчик 3: DATA 2", "BLE sensor 3: DATA 2"},
    {BLE_SENSOR3_I16_2,    "BLE датчик 3: DATA 3", "BLE sensor 3: DATA 3"},
    {BLE_SENSOR3_U16_1,    "BLE датчик 3: DATA 4", "BLE sensor 3: DATA 4"},
    {BLE_SENSOR3_U16_2,    "BLE датчик 3: DATA 5", "BLE sensor 3: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 3)
    {BLE_SENSOR4_VISIBLE,  "BLE датчик 4: Видимость", "BLE sensor 4: Visible"},
    {BLE_SENSOR4_TIMER,    "BLE датчик 4: Был на связи, секунд назад", "BLE sensor 4: Was online, seconds ago"},
    {BLE_SENSOR4_RSSI,     "BLE датчик 4: Уровень сигнала", "BLE sensor 4: RSSI"},
    {BLE_SENSOR4_BATT,     "BLE датчик 4: Уровень заряда батареи", "BLE sensor 4: Battery level"},
    {BLE_SENSOR4_U8,       "BLE датчик 4: DATA 1", "BLE sensor 4: DATA 1"},
    {BLE_SENSOR4_I16_1,    "BLE датчик 4: DATA 2", "BLE sensor 4: DATA 2"},
    {BLE_SENSOR4_I16_2,    "BLE датчик 4: DATA 3", "BLE sensor 4: DATA 3"},
    {BLE_SENSOR4_U16_1,    "BLE датчик 4: DATA 4", "BLE sensor 4: DATA 4"},
    {BLE_SENSOR4_U16_2,    "BLE датчик 4: DATA 5", "BLE sensor 4: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 4)
    {BLE_SENSOR5_VISIBLE,  "BLE датчик 5: Видимость", "BLE sensor 5: Visible"},
    {BLE_SENSOR5_TIMER,    "BLE датчик 5: Был на связи, секунд назад", "BLE sensor 5: Was online, seconds ago"},
    {BLE_SENSOR5_RSSI,     "BLE датчик 5: Уровень сигнала", "BLE sensor 5: RSSI"},
    {BLE_SENSOR5_BATT,     "BLE датчик 5: Уровень заряда батареи", "BLE sensor 5: Battery level"},
    {BLE_SENSOR5_U8,       "BLE датчик 5: DATA 1", "BLE sensor 5: DATA 1"},
    {BLE_SENSOR5_I16_1,    "BLE датчик 5: DATA 2", "BLE sensor 5: DATA 2"},
    {BLE_SENSOR5_I16_2,    "BLE датчик 5: DATA 3", "BLE sensor 5: DATA 3"},
    {BLE_SENSOR5_U16_1,    "BLE датчик 5: DATA 4", "BLE sensor 5: DATA 4"},
    {BLE_SENSOR5_U16_2,    "BLE датчик 5: DATA 5", "BLE sensor 5: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 5)
    {BLE_SENSOR6_VISIBLE,  "BLE датчик 6: Видимость", "BLE sensor 6: Visible"},
    {BLE_SENSOR6_TIMER,    "BLE датчик 6: Был на связи, секунд назад", "BLE sensor 6: Was online, seconds ago"},
    {BLE_SENSOR6_RSSI,     "BLE датчик 6: Уровень сигнала", "BLE sensor 6: RSSI"},
    {BLE_SENSOR6_BATT,     "BLE датчик 6: Уровень заряда батареи", "BLE sensor 6: Battery level"},
    {BLE_SENSOR6_U8,       "BLE датчик 6: DATA 1", "BLE sensor 6: DATA 1"},
    {BLE_SENSOR6_I16_1,    "BLE датчик 6: DATA 2", "BLE sensor 6: DATA 2"},
    {BLE_SENSOR6_I16_2,    "BLE датчик 6: DATA 3", "BLE sensor 6: DATA 3"},
    {BLE_SENSOR6_U16_1,    "BLE датчик 6: DATA 4", "BLE sensor 6: DATA 4"},
    {BLE_SENSOR6_U16_2,    "BLE датчик 6: DATA 5", "BLE sensor 6: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 6)
    {BLE_SENSOR7_VISIBLE,  "BLE датчик 7: Видимость", "BLE sensor 7: Visible"},
    {BLE_SENSOR7_TIMER,    "BLE датчик 7: Был на связи, секунд назад", "BLE sensor 7: Was online, seconds ago"},
    {BLE_SENSOR7_RSSI,     "BLE датчик 7: Уровень сигнала", "BLE sensor 7: RSSI"},
    {BLE_SENSOR7_BATT,     "BLE датчик 7: Уровень заряда батареи", "BLE sensor 7: Battery level"},
    {BLE_SENSOR7_U8,       "BLE датчик 7: DATA 1", "BLE sensor 7: DATA 1"},
    {BLE_SENSOR7_I16_1,    "BLE датчик 7: DATA 2", "BLE sensor 7: DATA 2"},
    {BLE_SENSOR7_I16_2,    "BLE датчик 7: DATA 3", "BLE sensor 7: DATA 3"},
    {BLE_SENSOR7_U16_1,    "BLE датчик 7: DATA 4", "BLE sensor 7: DATA 4"},
    {BLE_SENSOR7_U16_2,    "BLE датчик 7: DATA 5", "BLE sensor 7: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 7)
    {BLE_SENSOR8_VISIBLE,  "BLE датчик 8: Видимость", "BLE sensor 8: Visible"},
    {BLE_SENSOR8_TIMER,    "BLE датчик 8: Был на связи, секунд назад", "BLE sensor 8: Was online, seconds ago"},
    {BLE_SENSOR8_RSSI,     "BLE датчик 8: Уровень сигнала", "BLE sensor 8: RSSI"},
    {BLE_SENSOR8_BATT,     "BLE датчик 8: Уровень заряда батареи", "BLE sensor 8: Battery level"},
    {BLE_SENSOR8_U8,       "BLE датчик 8: DATA 1", "BLE sensor 8: DATA 1"},
    {BLE_SENSOR8_I16_1,    "BLE датчик 8: DATA 2", "BLE sensor 8: DATA 2"},
    {BLE_SENSOR8_I16_2,    "BLE датчик 8: DATA 3", "BLE sensor 8: DATA 3"},
    {BLE_SENSOR8_U16_1,    "BLE датчик 8: DATA 4", "BLE sensor 8: DATA 4"},
    {BLE_SENSOR8_U16_2,    "BLE датчик 8: DATA 5", "BLE sensor 8: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 8)
    {BLE_SENSOR9_VISIBLE,  "BLE датчик 9: Видимость", "BLE sensor 9: Visible"},
    {BLE_SENSOR9_TIMER,    "BLE датчик 9: Был на связи, секунд назад", "BLE sensor 9: Was online, seconds ago"},
    {BLE_SENSOR9_RSSI,     "BLE датчик 9: Уровень сигнала", "BLE sensor 9: RSSI"},
    {BLE_SENSOR9_BATT,     "BLE датчик 9: Уровень заряда батареи", "BLE sensor 9: Battery level"},
    {BLE_SENSOR9_U8,       "BLE датчик 9: DATA 1", "BLE sensor 9: DATA 1"},
    {BLE_SENSOR9_I16_1,    "BLE датчик 9: DATA 2", "BLE sensor 9: DATA 2"},
    {BLE_SENSOR9_I16_2,    "BLE датчик 9: DATA 3", "BLE sensor 9: DATA 3"},
    {BLE_SENSOR9_U16_1,    "BLE датчик 9: DATA 4", "BLE sensor 9: DATA 4"},
    {BLE_SENSOR9_U16_2,    "BLE датчик 9: DATA 5", "BLE sensor 9: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 9)
    {BLE_SENSOR10_VISIBLE,  "BLE датчик 10: Видимость", "BLE sensor 10: Visible"},
    {BLE_SENSOR10_TIMER,    "BLE датчик 10: Был на связи, секунд назад", "BLE sensor 10: Was online, seconds ago"},
    {BLE_SENSOR10_RSSI,     "BLE датчик 10: Уровень сигнала", "BLE sensor 10: RSSI"},
    {BLE_SENSOR10_BATT,     "BLE датчик 10: Уровень заряда батареи", "BLE sensor 10: Battery level"},
    {BLE_SENSOR10_U8,       "BLE датчик 10: DATA 1", "BLE sensor 10: DATA 1"},
    {BLE_SENSOR10_I16_1,    "BLE датчик 10: DATA 2", "BLE sensor 10: DATA 2"},
    {BLE_SENSOR10_I16_2,    "BLE датчик 10: DATA 3", "BLE sensor 10: DATA 3"},
    {BLE_SENSOR10_U16_1,    "BLE датчик 10: DATA 4", "BLE sensor 10: DATA 4"},
    {BLE_SENSOR10_U16_2,    "BLE датчик 10: DATA 5", "BLE sensor 10: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 10)
    {BLE_SENSOR11_VISIBLE,  "BLE датчик 11: Видимость", "BLE sensor 11: Visible"},
    {BLE_SENSOR11_TIMER,    "BLE датчик 11: Был на связи, секунд назад", "BLE sensor 11: Was online, seconds ago"},
    {BLE_SENSOR11_RSSI,     "BLE датчик 11: Уровень сигнала", "BLE sensor 11: RSSI"},
    {BLE_SENSOR11_BATT,     "BLE датчик 11: Уровень заряда батареи", "BLE sensor 11: Battery level"},
    {BLE_SENSOR11_U8,       "BLE датчик 11: DATA 1", "BLE sensor 11: DATA 1"},
    {BLE_SENSOR11_I16_1,    "BLE датчик 11: DATA 2", "BLE sensor 11: DATA 2"},
    {BLE_SENSOR11_I16_2,    "BLE датчик 11: DATA 3", "BLE sensor 11: DATA 3"},
    {BLE_SENSOR11_U16_1,    "BLE датчик 11: DATA 4", "BLE sensor 11: DATA 4"},
    {BLE_SENSOR11_U16_2,    "BLE датчик 11: DATA 5", "BLE sensor 11: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 11)
    {BLE_SENSOR12_VISIBLE,  "BLE датчик 12: Видимость", "BLE sensor 12: Visible"},
    {BLE_SENSOR12_TIMER,    "BLE датчик 12: Был на связи, секунд назад", "BLE sensor 12: Was online, seconds ago"},
    {BLE_SENSOR12_RSSI,     "BLE датчик 12: Уровень сигнала", "BLE sensor 12: RSSI"},
    {BLE_SENSOR12_BATT,     "BLE датчик 12: Уровень заряда батареи", "BLE sensor 12: Battery level"},
    {BLE_SENSOR12_U8,       "BLE датчик 12: DATA 1", "BLE sensor 12: DATA 1"},
    {BLE_SENSOR12_I16_1,    "BLE датчик 12: DATA 2", "BLE sensor 12: DATA 2"},
    {BLE_SENSOR12_I16_2,    "BLE датчик 12: DATA 3", "BLE sensor 12: DATA 3"},
    {BLE_SENSOR12_U16_1,    "BLE датчик 12: DATA 4", "BLE sensor 12: DATA 4"},
    {BLE_SENSOR12_U16_2,    "BLE датчик 12: DATA 5", "BLE sensor 12: DATA 5"},
      //reserve4
    #endif
    #if (MAX_BLE_SENSORS_COUNT > 12)
    #error
    #endif
#endif //defined(BLE_SENSORS_PRESENT)

#if defined(BASE_STATION_BT_PRESENT)
//#error откуда здесь LORASENS_AXIS1?
  //{LORASENS_AXIS1                 , "Рабочая ось акселерометра датчика 1", "Wireless sensor 1 working axis of the accelerometer"},

  {BASE_STATION_BT,       "Связь с БС",  "BS connection state"},
  {BASE_STATION_BT+1,     "MAC-адрес БС", "BS MAC" },
  {BASE_STATION_BT+2,     "Текущее время БС", "Current time BS" },
  {BASE_STATION_BT+3,     "Статус БС", "Status BS"  },
#if (MAX_BT_SENSORS > 0)
  {BASE_STATION_BT+4+0, "Тип и MAC-адрес сенсора 1", "Sensor 1 type&MAC"},
  {BASE_STATION_BT+4+1, "Timestap сенсора 1", "Sensor 1 timestamp"},
  {BASE_STATION_BT+4+2, "Параметр 1 сенсора 1", "Sensor 1 parameter 1"},
  {BASE_STATION_BT+4+3, "Параметр 2 сенсора 1", "Sensor 1 parameter 2"},
  {BASE_STATION_BT+4+4, "Параметр 3 сенсора 1", "Sensor 1 parameter 3"},
  {BASE_STATION_BT+4+5, "Параметр 4 сенсора 1", "Sensor 1 parameter 4"},
  {BASE_STATION_BT+4+6, "Параметр 5 сенсора 1", "Sensor 1 parameter 5"},
  {BASE_STATION_BT+4+7, "Параметр 6 сенсора 1", "Sensor 1 parameter 6"},
  {BASE_STATION_BT+4+8, "Верхний предел 1 сенсора 1", "Sensor 1 upper limit 1"},
  {BASE_STATION_BT+4+9, "Нижний предел 1 сенсора 1", "Sensor 1 lower limit 1"},
  {BASE_STATION_BT+4+10,"Верхний предел 2 сенсора 1", "Sensor 1 upper limit 2"},
  {BASE_STATION_BT+4+11,"Нижний предел 2 сенсора 1", "Sensor 1 lower limit 2"},
  {BASE_STATION_BT+4+12,"Интервал измерений в сенсоре 1, в сек", "Measurement interval in the sensor 1, sec" },
  {BASE_STATION_BT+4+13,"Коэффициент периода времени сенсора 1", "Sensor 1 time period ratio"},
  {BASE_STATION_BT+4+14,"Напряжение батареи сенсора 1", "Sensor 1 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 1)
  {BASE_STATION_BT+4+15*1+0, "Тип и MAC-адрес сенсора 2", "Sensor 2 type&MAC"},
  {BASE_STATION_BT+4+15*1+1, "Timestap сенсора 2", "Sensor 2 timestamp"},
  {BASE_STATION_BT+4+15*1+2, "Параметр 1 сенсора 2", "Sensor 2 parameter 1"},
  {BASE_STATION_BT+4+15*1+3, "Параметр 2 сенсора 2", "Sensor 2 parameter 2"},
  {BASE_STATION_BT+4+15*1+4, "Параметр 3 сенсора 2", "Sensor 2 parameter 3"},
  {BASE_STATION_BT+4+15*1+5, "Параметр 4 сенсора 2", "Sensor 2 parameter 4"},
  {BASE_STATION_BT+4+15*1+6, "Параметр 5 сенсора 2", "Sensor 2 parameter 5"},
  {BASE_STATION_BT+4+15*1+7, "Параметр 6 сенсора 2", "Sensor 2 parameter 6"},
  {BASE_STATION_BT+4+15*1+8, "Верхний предел 1 сенсора 2", "Sensor 2 upper limit 1"},
  {BASE_STATION_BT+4+15*1+9, "Нижний предел 1 сенсора 2", "Sensor 2 lower limit 1"},
  {BASE_STATION_BT+4+15*1+10,"Верхний предел 2 сенсора 2", "Sensor 2 upper limit 2"},
  {BASE_STATION_BT+4+15*1+11,"Нижний предел 2 сенсора 2", "Sensor 2 lower limit 2"},
  {BASE_STATION_BT+4+15*1+12,"Интервал измерений в сенсоре 2, в сек", "Measurement interval in the sensor 2, sec" },
  {BASE_STATION_BT+4+15*1+13,"Коэффициент периода времени сенсора 2", "Sensor 2 time period ratio"},
  {BASE_STATION_BT+4+15*1+14,"Напряжение батареи сенсора 2", "Sensor 2 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 2)
  {BASE_STATION_BT+4+15*2+0, "Тип и MAC-адрес сенсора 3", "Sensor 3 type&MAC"},
  {BASE_STATION_BT+4+15*2+1, "Timestap сенсора 3", "Sensor 3 timestamp"},
  {BASE_STATION_BT+4+15*2+2, "Параметр 1 сенсора 3", "Sensor 3 parameter 1"},
  {BASE_STATION_BT+4+15*2+3, "Параметр 2 сенсора 3", "Sensor 3 parameter 2"},
  {BASE_STATION_BT+4+15*2+4, "Параметр 3 сенсора 3", "Sensor 3 parameter 3"},
  {BASE_STATION_BT+4+15*2+5, "Параметр 4 сенсора 3", "Sensor 3 parameter 4"},
  {BASE_STATION_BT+4+15*2+6, "Параметр 5 сенсора 3", "Sensor 3 parameter 5"},
  {BASE_STATION_BT+4+15*2+7, "Параметр 6 сенсора 3", "Sensor 3 parameter 6"},
  {BASE_STATION_BT+4+15*2+8, "Верхний предел 1 сенсора 3", "Sensor 3 upper limit 1"},
  {BASE_STATION_BT+4+15*2+9, "Нижний предел 1 сенсора 3", "Sensor 3 lower limit 1"},
  {BASE_STATION_BT+4+15*2+10,"Верхний предел 2 сенсора 3", "Sensor 3 upper limit 2"},
  {BASE_STATION_BT+4+15*2+11,"Нижний предел 2 сенсора 3", "Sensor 3 lower limit 2"},
  {BASE_STATION_BT+4+15*2+12,"Интервал измерений в сенсоре 3, в сек", "Measurement interval in the sensor 3, sec" },
  {BASE_STATION_BT+4+15*2+13,"Коэффициент периода времени сенсора 3", "Sensor 3 time period ratio"},
  {BASE_STATION_BT+4+15*2+14,"Напряжение батареи сенсора 3", "Sensor 3 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 3)
  {BASE_STATION_BT+4+15*3+0, "Тип и MAC-адрес сенсора 4", "Sensor 4 type&MAC"},
  {BASE_STATION_BT+4+15*3+1, "Timestap сенсора 4", "Sensor 4 timestamp"},
  {BASE_STATION_BT+4+15*3+2, "Параметр 1 сенсора 4", "Sensor 4 parameter 1"},
  {BASE_STATION_BT+4+15*3+3, "Параметр 2 сенсора 4", "Sensor 4 parameter 2"},
  {BASE_STATION_BT+4+15*3+4, "Параметр 3 сенсора 4", "Sensor 4 parameter 3"},
  {BASE_STATION_BT+4+15*3+5, "Параметр 4 сенсора 4", "Sensor 4 parameter 4"},
  {BASE_STATION_BT+4+15*3+6, "Параметр 5 сенсора 4", "Sensor 4 parameter 5"},
  {BASE_STATION_BT+4+15*3+7, "Параметр 6 сенсора 4", "Sensor 4 parameter 6"},
  {BASE_STATION_BT+4+15*3+8, "Верхний предел 1 сенсора 4", "Sensor 4 upper limit 1"},
  {BASE_STATION_BT+4+15*3+9, "Нижний предел 1 сенсора 4", "Sensor 4 lower limit 1"},
  {BASE_STATION_BT+4+15*3+10,"Верхний предел 2 сенсора 4", "Sensor 4 upper limit 2"},
  {BASE_STATION_BT+4+15*3+11,"Нижний предел 2 сенсора 4", "Sensor 4 lower limit 2"},
  {BASE_STATION_BT+4+15*3+12,"Интервал измерений в сенсоре 4, в сек", "Measurement interval in the sensor 4, sec" },
  {BASE_STATION_BT+4+15*3+13,"Коэффициент периода времени сенсора 4", "Sensor 4 time period ratio"},
  {BASE_STATION_BT+4+15*3+14,"Напряжение батареи сенсора 4", "Sensor 4 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 4)
  {BASE_STATION_BT+4+15*4+0, "Тип и MAC-адрес сенсора 5", "Sensor 5 type&MAC"},
  {BASE_STATION_BT+4+15*4+1, "Timestap сенсора 5", "Sensor 5 timestamp"},
  {BASE_STATION_BT+4+15*4+2, "Параметр 1 сенсора 5", "Sensor 5 parameter 1"},
  {BASE_STATION_BT+4+15*4+3, "Параметр 2 сенсора 5", "Sensor 5 parameter 2"},
  {BASE_STATION_BT+4+15*4+4, "Параметр 3 сенсора 5", "Sensor 5 parameter 3"},
  {BASE_STATION_BT+4+15*4+5, "Параметр 4 сенсора 5", "Sensor 5 parameter 4"},
  {BASE_STATION_BT+4+15*4+6, "Параметр 5 сенсора 5", "Sensor 5 parameter 5"},
  {BASE_STATION_BT+4+15*4+7, "Параметр 6 сенсора 5", "Sensor 5 parameter 6"},
  {BASE_STATION_BT+4+15*4+8, "Верхний предел 1 сенсора 5", "Sensor 5 upper limit 1"},
  {BASE_STATION_BT+4+15*4+9, "Нижний предел 1 сенсора 5", "Sensor 5 lower limit 1"},
  {BASE_STATION_BT+4+15*4+10,"Верхний предел 2 сенсора 5", "Sensor 5 upper limit 2"},
  {BASE_STATION_BT+4+15*4+11,"Нижний предел 2 сенсора 5", "Sensor 5 lower limit 2"},
  {BASE_STATION_BT+4+15*4+12,"Интервал измерений в сенсоре 5, в сек", "Measurement interval in the sensor 5, sec" },
  {BASE_STATION_BT+4+15*4+13,"Коэффициент периода времени сенсора 5", "Sensor 5 time period ratio"},
  {BASE_STATION_BT+4+15*4+14,"Напряжение батареи сенсора 5", "Sensor 5 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 5)
  {BASE_STATION_BT+4+15*5+0, "Тип и MAC-адрес сенсора 6", "Sensor 6 type&MAC"},
  {BASE_STATION_BT+4+15*5+1, "Timestap сенсора 6", "Sensor 6 timestamp"},
  {BASE_STATION_BT+4+15*5+2, "Параметр 1 сенсора 6", "Sensor 6 parameter 1"},
  {BASE_STATION_BT+4+15*5+3, "Параметр 2 сенсора 6", "Sensor 6 parameter 2"},
  {BASE_STATION_BT+4+15*5+4, "Параметр 3 сенсора 6", "Sensor 6 parameter 3"},
  {BASE_STATION_BT+4+15*5+5, "Параметр 4 сенсора 6", "Sensor 6 parameter 4"},
  {BASE_STATION_BT+4+15*5+6, "Параметр 5 сенсора 6", "Sensor 6 parameter 5"},
  {BASE_STATION_BT+4+15*5+7, "Параметр 6 сенсора 6", "Sensor 6 parameter 6"},
  {BASE_STATION_BT+4+15*5+8, "Верхний предел 1 сенсора 6", "Sensor 6 upper limit 1"},
  {BASE_STATION_BT+4+15*5+9, "Нижний предел 1 сенсора 6", "Sensor 6 lower limit 1"},
  {BASE_STATION_BT+4+15*5+10,"Верхний предел 2 сенсора 6", "Sensor 6 upper limit 2"},
  {BASE_STATION_BT+4+15*5+11,"Нижний предел 2 сенсора 6", "Sensor 6 lower limit 2"},
  {BASE_STATION_BT+4+15*5+12,"Интервал измерений в сенсоре 6, в сек", "Measurement interval in the sensor 6, sec" },
  {BASE_STATION_BT+4+15*5+13,"Коэффициент периода времени сенсора 6", "Sensor 6 time period ratio"},
  {BASE_STATION_BT+4+15*5+14,"Напряжение батареи сенсора 6", "Sensor 6 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 6)
  {BASE_STATION_BT+4+15*6+0, "Тип и MAC-адрес сенсора 7", "Sensor 7 type&MAC"},
  {BASE_STATION_BT+4+15*6+1, "Timestap сенсора 7", "Sensor 7 timestamp"},
  {BASE_STATION_BT+4+15*6+2, "Параметр 1 сенсора 7", "Sensor 7 parameter 1"},
  {BASE_STATION_BT+4+15*6+3, "Параметр 2 сенсора 7", "Sensor 7 parameter 2"},
  {BASE_STATION_BT+4+15*6+4, "Параметр 3 сенсора 7", "Sensor 7 parameter 3"},
  {BASE_STATION_BT+4+15*6+5, "Параметр 4 сенсора 7", "Sensor 7 parameter 4"},
  {BASE_STATION_BT+4+15*6+6, "Параметр 5 сенсора 7", "Sensor 7 parameter 5"},
  {BASE_STATION_BT+4+15*6+7, "Параметр 6 сенсора 7", "Sensor 7 parameter 6"},
  {BASE_STATION_BT+4+15*6+8, "Верхний предел 1 сенсора 7", "Sensor 7 upper limit 1"},
  {BASE_STATION_BT+4+15*6+9, "Нижний предел 1 сенсора 7", "Sensor 7 lower limit 1"},
  {BASE_STATION_BT+4+15*6+10,"Верхний предел 2 сенсора 7", "Sensor 7 upper limit 2"},
  {BASE_STATION_BT+4+15*6+11,"Нижний предел 2 сенсора 7", "Sensor 7 lower limit 2"},
  {BASE_STATION_BT+4+15*6+12,"Интервал измерений в сенсоре 7, в сек", "Measurement interval in the sensor 7, sec" },
  {BASE_STATION_BT+4+15*6+13,"Коэффициент периода времени сенсора 7", "Sensor 7 time period ratio"},
  {BASE_STATION_BT+4+15*6+14,"Напряжение батареи сенсора 7", "Sensor 7 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 7)
  {BASE_STATION_BT+4+15*7+0, "Тип и MAC-адрес сенсора8", "Sensor 8 type&MAC"},
  {BASE_STATION_BT+4+15*7+1, "Timestap сенсора 8", "Sensor 8 timestamp"},
  {BASE_STATION_BT+4+15*7+2, "Параметр 1 сенсора 8", "Sensor 8 parameter 1"},
  {BASE_STATION_BT+4+15*7+3, "Параметр 2 сенсора 8", "Sensor 8 parameter 2"},
  {BASE_STATION_BT+4+15*7+4, "Параметр 3 сенсора 8", "Sensor 8 parameter 3"},
  {BASE_STATION_BT+4+15*7+5, "Параметр 4 сенсора 8", "Sensor 8 parameter 4"},
  {BASE_STATION_BT+4+15*7+6, "Параметр 5 сенсора 8", "Sensor 8 parameter 5"},
  {BASE_STATION_BT+4+15*7+7, "Параметр 6 сенсора 8", "Sensor 8 parameter 6"},
  {BASE_STATION_BT+4+15*7+8, "Верхний предел 1 сенсора 8", "Sensor 8 upper limit 1"},
  {BASE_STATION_BT+4+15*7+9, "Нижний предел 1 сенсора 8", "Sensor 8 lower limit 1"},
  {BASE_STATION_BT+4+15*7+10,"Верхний предел 2 сенсора 8", "Sensor 8 upper limit 2"},
  {BASE_STATION_BT+4+15*7+11,"Нижний предел 2 сенсора 8", "Sensor 8 lower limit 2"},
  {BASE_STATION_BT+4+15*7+12,"Интервал измерений в сенсоре 8, в сек", "Measurement interval in the sensor 8, sec" },
  {BASE_STATION_BT+4+15*7+13,"Коэффициент периода времени сенсора 8", "Sensor 8 time period ratio"},
  {BASE_STATION_BT+4+15*7+14,"Напряжение батареи сенсора 8", "Sensor 8 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 8)
  {BASE_STATION_BT+4+15*8+0, "Тип и MAC-адрес сенсора 9", "Sensor 9 type&MAC"},
  {BASE_STATION_BT+4+15*8+1, "Timestap сенсора 9", "Sensor 9 timestamp"},
  {BASE_STATION_BT+4+15*8+2, "Параметр 1 сенсора 9", "Sensor 9 parameter 1"},
  {BASE_STATION_BT+4+15*8+3, "Параметр 2 сенсора 9", "Sensor 9 parameter 2"},
  {BASE_STATION_BT+4+15*8+4, "Параметр 3 сенсора 9", "Sensor 9 parameter 3"},
  {BASE_STATION_BT+4+15*8+5, "Параметр 4 сенсора 9", "Sensor 9 parameter 4"},
  {BASE_STATION_BT+4+15*8+6, "Параметр 5 сенсора 9", "Sensor 9 parameter 5"},
  {BASE_STATION_BT+4+15*8+7, "Параметр 6 сенсора 9", "Sensor 9 parameter 6"},
  {BASE_STATION_BT+4+15*8+8, "Верхний предел 1 сенсора 9", "Sensor 9 upper limit 1"},
  {BASE_STATION_BT+4+15*8+9, "Нижний предел 1 сенсора 9", "Sensor 9 lower limit 1"},
  {BASE_STATION_BT+4+15*8+10,"Верхний предел 2 сенсора 9", "Sensor 9 upper limit 2"},
  {BASE_STATION_BT+4+15*8+11,"Нижний предел 2 сенсора 9", "Sensor 9 lower limit 2"},
  {BASE_STATION_BT+4+15*8+12,"Интервал измерений в сенсоре 9, в сек", "Measurement interval in the sensor 9, sec" },
  {BASE_STATION_BT+4+15*8+13,"Коэффициент периода времени сенсора 9", "Sensor 9 time period ratio"},
  {BASE_STATION_BT+4+15*8+14,"Напряжение батареи сенсора 9", "Sensor 9 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 9)
  {BASE_STATION_BT+4+15*9+0, "Тип и MAC-адрес сенсора 10", "Sensor 10 type&MAC"},
  {BASE_STATION_BT+4+15*9+1, "Timestap сенсора 10", "Sensor 10 timestamp"},
  {BASE_STATION_BT+4+15*9+2, "Параметр 1 сенсора 10", "Sensor 10 parameter 1"},
  {BASE_STATION_BT+4+15*9+3, "Параметр 2 сенсора 10", "Sensor 10 parameter 2"},
  {BASE_STATION_BT+4+15*9+4, "Параметр 3 сенсора 10", "Sensor 10 parameter 3"},
  {BASE_STATION_BT+4+15*9+5, "Параметр 4 сенсора 10", "Sensor 10 parameter 4"},
  {BASE_STATION_BT+4+15*9+6, "Параметр 5 сенсора 10", "Sensor 10 parameter 5"},
  {BASE_STATION_BT+4+15*9+7, "Параметр 6 сенсора 10", "Sensor 10 parameter 6"},
  {BASE_STATION_BT+4+15*9+8, "Верхний предел 1 сенсора 10", "Sensor 10 upper limit 1"},
  {BASE_STATION_BT+4+15*9+9, "Нижний предел 1 сенсора 10", "Sensor 10 lower limit 1"},
  {BASE_STATION_BT+4+15*9+10,"Верхний предел 2 сенсора 10", "Sensor 10 upper limit 2"},
  {BASE_STATION_BT+4+15*9+11,"Нижний предел 2 сенсора 10", "Sensor 10 lower limit 2"},
  {BASE_STATION_BT+4+15*9+12,"Интервал измерений в сенсоре 10, в сек", "Measurement interval in the sensor 10, sec" },
  {BASE_STATION_BT+4+15*9+13,"Коэффициент периода времени сенсора 10", "Sensor 10 time period ratio"},
  {BASE_STATION_BT+4+15*9+14,"Напряжение батареи сенсора 10", "Sensor 10 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 10)
  {BASE_STATION_BT+4+15*10+0, "Тип и MAC-адрес сенсора 11", "Sensor 11 type&MAC"},
  {BASE_STATION_BT+4+15*10+1, "Timestap сенсора 11", "Sensor 11 timestamp"},
  {BASE_STATION_BT+4+15*10+2, "Параметр 1 сенсора 11", "Sensor 11 parameter 1"},
  {BASE_STATION_BT+4+15*10+3, "Параметр 2 сенсора 11", "Sensor 11 parameter 2"},
  {BASE_STATION_BT+4+15*10+4, "Верхний предел 1 сенсора 11", "Sensor 11 upper limit 1"},
  {BASE_STATION_BT+4+15*10+5, "Нижний предел 1 сенсора 11", "Sensor 11 lower limit 1"},
  {BASE_STATION_BT+4+15*10+6, "Верхний предел 2 сенсора 11", "Sensor 11 upper limit 2"},
  {BASE_STATION_BT+4+15*10+7, "Нижний предел 2 сенсора 11", "Sensor 11 lower limit 2"},
  {BASE_STATION_BT+4+15*10+8, "Интервал измерений в сенсоре 11, в сек", "Measurement interval in the sensor 11, sec" },
  {BASE_STATION_BT+4+15*10+9, "Коэффициент периода времени сенсора 11", "Sensor 11 time period ratio"},
  {BASE_STATION_BT+4+15*10+10,"Напряжение батареи сенсора 11", "Sensor 11 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 11)
  {BASE_STATION_BT+4+15*10+11+0, "Тип и MAC-адрес сенсора 12", "Sensor 12 type&MAC"},
  {BASE_STATION_BT+4+15*10+11+1, "Timestap сенсора 12", "Sensor 12 timestamp"},
  {BASE_STATION_BT+4+15*10+11+2, "Параметр 1 сенсора 12", "Sensor 12 parameter 1"},
  {BASE_STATION_BT+4+15*10+11+3, "Параметр 2 сенсора 12", "Sensor 12 parameter 2"},
  {BASE_STATION_BT+4+15*10+11+4, "Верхний предел 1 сенсора 12", "Sensor 12 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11+5, "Нижний предел 1 сенсора 12", "Sensor 12 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11+6, "Верхний предел 2 сенсора 12", "Sensor 12 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11+7, "Нижний предел 2 сенсора 12", "Sensor 12 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11+8, "Интервал измерений в сенсоре 12, в сек", "Measurement interval in the sensor 12, sec" },
  {BASE_STATION_BT+4+15*10+11+9, "Коэффициент периода времени сенсора 12", "Sensor 12 time period ratio"},
  {BASE_STATION_BT+4+15*10+11+10,"Напряжение батареи сенсора 12", "Sensor 12 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 12)
  {BASE_STATION_BT+4+15*10+11*2+0, "Тип и MAC-адрес сенсора 13", "Sensor 13 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*2+1, "Timestap сенсора 13", "Sensor 13 timestamp"},
  {BASE_STATION_BT+4+15*10+11*2+2, "Параметр 1 сенсора 13", "Sensor 13 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*2+3, "Параметр 2 сенсора 13", "Sensor 13 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*2+4, "Верхний предел 1 сенсора 13", "Sensor 13 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*2+5, "Нижний предел 1 сенсора 13", "Sensor 13 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*2+6, "Верхний предел 2 сенсора 13", "Sensor 13 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*2+7, "Нижний предел 2 сенсора 13", "Sensor 13 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*2+8, "Интервал измерений в сенсоре 13, в сек", "Measurement interval in the sensor 13, sec" },
  {BASE_STATION_BT+4+15*10+11*2+9, "Коэффициент периода времени сенсора 13", "Sensor 13 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*2+10,"Напряжение батареи сенсора 13", "Sensor 13 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 13)
  {BASE_STATION_BT+4+15*10+11*3+0, "Тип и MAC-адрес сенсора 14", "Sensor 14 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*3+1, "Timestap сенсора 14", "Sensor 14 timestamp"},
  {BASE_STATION_BT+4+15*10+11*3+2, "Параметр 1 сенсора 14", "Sensor 14 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*3+3, "Параметр 2 сенсора 14", "Sensor 14 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*3+4, "Верхний предел 1 сенсора 14", "Sensor 14 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*3+5, "Нижний предел 1 сенсора 14", "Sensor 14 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*3+6, "Верхний предел 2 сенсора 14", "Sensor 14 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*3+7, "Нижний предел 2 сенсора 14", "Sensor 14 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*3+8, "Интервал измерений в сенсоре 14, в сек", "Measurement interval in the sensor 14, sec" },
  {BASE_STATION_BT+4+15*10+11*3+9, "Коэффициент периода времени сенсора 14", "Sensor 14 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*3+10,"Напряжение батареи сенсора 14", "Sensor 14 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 14)
  {BASE_STATION_BT+4+15*10+11*4+0, "Тип и MAC-адрес сенсора 15", "Sensor 15 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*4+1, "Timestap сенсора 15", "Sensor 15 timestamp"},
  {BASE_STATION_BT+4+15*10+11*4+2, "Параметр 1 сенсора 15", "Sensor 15 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*4+3, "Параметр 2 сенсора 15", "Sensor 15 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*4+4, "Верхний предел 1 сенсора 15", "Sensor 15 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*4+5, "Нижний предел 1 сенсора 15", "Sensor 15 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*4+6, "Верхний предел 2 сенсора 15", "Sensor 15 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*4+7, "Нижний предел 2 сенсора 15", "Sensor 15 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*4+8, "Интервал измерений в сенсоре 15, в сек", "Measurement interval in the sensor 15, sec" },
  {BASE_STATION_BT+4+15*10+11*4+9, "Коэффициент периода времени сенсора 15", "Sensor 15 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*4+10,"Напряжение батареи сенсора 15", "Sensor 15 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 15)
  {BASE_STATION_BT+4+15*10+11*5+0, "Тип и MAC-адрес сенсора 16", "Sensor 16 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*5+1, "Timestap сенсора 16", "Sensor 16 timestamp"},
  {BASE_STATION_BT+4+15*10+11*5+2, "Параметр 1 сенсора 16", "Sensor 16 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*5+3, "Параметр 2 сенсора 16", "Sensor 16 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*5+4, "Верхний предел 1 сенсора 16", "Sensor 16 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*5+5, "Нижний предел 1 сенсора 16", "Sensor 16 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*5+6, "Верхний предел 2 сенсора 16", "Sensor 16 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*5+7, "Нижний предел 2 сенсора 16", "Sensor 16 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*5+8, "Интервал измерений в сенсоре 16, в сек", "Measurement interval in the sensor 16, sec" },
  {BASE_STATION_BT+4+15*10+11*5+9, "Коэффициент периода времени сенсора 16", "Sensor 16 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*5+10,"Напряжение батареи сенсора 16", "Sensor 16 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 16)
  {BASE_STATION_BT+4+15*10+11*6+0, "Тип и MAC-адрес сенсора 17", "Sensor 17 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*6+1, "Timestap сенсора 17", "Sensor 17 timestamp"},
  {BASE_STATION_BT+4+15*10+11*6+2, "Параметр 1 сенсора 17", "Sensor 17 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*6+3, "Параметр 2 сенсора 17", "Sensor 17 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*6+4, "Верхний предел 1 сенсора 17", "Sensor 17 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*6+5, "Нижний предел 1 сенсора 17", "Sensor 17 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*6+6, "Верхний предел 2 сенсора 17", "Sensor 17 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*6+7, "Нижний предел 2 сенсора 17", "Sensor 17 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*6+8, "Интервал измерений в сенсоре 17, в сек", "Measurement interval in the sensor 17, sec" },
  {BASE_STATION_BT+4+15*10+11*6+9, "Коэффициент периода времени сенсора 17", "Sensor 17 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*6+10,"Напряжение батареи сенсора 17", "Sensor 17 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 17)
  {BASE_STATION_BT+4+15*10+11*7+0, "Тип и MAC-адрес сенсора 18", "Sensor 18 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*7+1, "Timestap сенсора 18", "Sensor 18 timestamp"},
  {BASE_STATION_BT+4+15*10+11*7+2, "Параметр 1 сенсора 18", "Sensor 18 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*7+3, "Параметр 2 сенсора 18", "Sensor 18 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*7+4, "Верхний предел 1 сенсора 18", "Sensor 18 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*7+5, "Нижний предел 1 сенсора 18", "Sensor 18 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*7+6, "Верхний предел 2 сенсора 18", "Sensor 18 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*7+7, "Нижний предел 2 сенсора 18", "Sensor 18 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*7+8, "Интервал измерений в сенсоре 18, в сек", "Measurement interval in the sensor 18, sec" },
  {BASE_STATION_BT+4+15*10+11*7+9, "Коэффициент периода времени сенсора 18", "Sensor 18 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*7+10,"Напряжение батареи сенсора 18", "Sensor 18 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 18)
  {BASE_STATION_BT+4+15*10+11*8+0, "Тип и MAC-адрес сенсора 19", "Sensor 19 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*8+1, "Timestap сенсора 19", "Sensor 19 timestamp"},
  {BASE_STATION_BT+4+15*10+11*8+2, "Параметр 1 сенсора 19", "Sensor 19 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*8+3, "Параметр 2 сенсора 19", "Sensor 19 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*8+4, "Верхний предел 1 сенсора 19", "Sensor 19 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*8+5, "Нижний предел 1 сенсора 19", "Sensor 19 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*8+6, "Верхний предел 2 сенсора 19", "Sensor 19 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*8+7, "Нижний предел 2 сенсора 19", "Sensor 19 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*8+8, "Интервал измерений в сенсоре 19, в сек", "Measurement interval in the sensor 19, sec" },
  {BASE_STATION_BT+4+15*10+11*8+9, "Коэффициент периода времени сенсора 19", "Sensor 19 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*8+10,"Напряжение батареи сенсора 19", "Sensor 19 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 19)
  {BASE_STATION_BT+4+15*10+11*9+0, "Тип и MAC-адрес сенсора 20", "Sensor 20 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*9+1, "Timestap сенсора 20", "Sensor 20 timestamp"},
  {BASE_STATION_BT+4+15*10+11*9+2, "Параметр 1 сенсора 20", "Sensor 20 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*9+3, "Параметр 2 сенсора 20", "Sensor 20 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*9+4, "Верхний предел 1 сенсора 20", "Sensor 20 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*9+5, "Нижний предел 1 сенсора 20", "Sensor 20 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*9+6, "Верхний предел 2 сенсора 20", "Sensor 20 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*9+7, "Нижний предел 2 сенсора 20", "Sensor 20 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*9+8, "Интервал измерений в сенсоре 20, в сек", "Measurement interval in the sensor 20, sec" },
  {BASE_STATION_BT+4+15*10+11*9+9, "Коэффициент периода времени сенсора 20", "Sensor 20 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*9+10,"Напряжение батареи сенсора 20", "Sensor 20 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 20)
  {BASE_STATION_BT+4+15*10+11*10+0, "Тип и MAC-адрес сенсора 21", "Sensor 21 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*10+1, "Timestap сенсора 21", "Sensor 21 timestamp"},
  {BASE_STATION_BT+4+15*10+11*10+2, "Параметр 1 сенсора 21", "Sensor 21 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*10+3, "Параметр 2 сенсора 21", "Sensor 21 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*10+4, "Верхний предел 1 сенсора 21", "Sensor 21 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*10+5, "Нижний предел 1 сенсора 21", "Sensor 21 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*10+6, "Верхний предел 2 сенсора 21", "Sensor 21 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*10+7, "Нижний предел 2 сенсора 21", "Sensor 21 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*10+8, "Интервал измерений в сенсоре 21, в сек", "Measurement interval in the sensor 21, sec" },
  {BASE_STATION_BT+4+15*10+11*10+9, "Коэффициент периода времени сенсора 21", "Sensor 21 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*10+10,"Напряжение батареи сенсора 21", "Sensor 21 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 21)
  {BASE_STATION_BT+4+15*10+11*11+0, "Тип и MAC-адрес сенсора 22", "Sensor 22 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*11+1, "Timestap сенсора 22", "Sensor 22 timestamp"},
  {BASE_STATION_BT+4+15*10+11*11+2, "Параметр 1 сенсора 22", "Sensor 22 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*11+3, "Параметр 2 сенсора 22", "Sensor 22 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*11+4, "Верхний предел 1 сенсора 22", "Sensor 22 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*11+5, "Нижний предел 1 сенсора 22", "Sensor 22 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*11+6, "Верхний предел 2 сенсора 22", "Sensor 22 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*11+7, "Нижний предел 2 сенсора 22", "Sensor 22 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*11+8, "Интервал измерений в сенсоре 22, в сек", "Measurement interval in the sensor 22, sec" },
  {BASE_STATION_BT+4+15*10+11*11+9, "Коэффициент периода времени сенсора 22", "Sensor 22 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*11+10,"Напряжение батареи сенсора 22", "Sensor 22 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 22)
  {BASE_STATION_BT+4+15*10+11*12+0, "Тип и MAC-адрес сенсора 23", "Sensor 23 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*12+1, "Timestap сенсора 23", "Sensor 23 timestamp"},
  {BASE_STATION_BT+4+15*10+11*12+2, "Параметр 1 сенсора 23", "Sensor 23 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*12+3, "Параметр 2 сенсора 23", "Sensor 23 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*12+4, "Верхний предел 1 сенсора 23", "Sensor 23 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*12+5, "Нижний предел 1 сенсора 23", "Sensor 23 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*12+6, "Верхний предел 2 сенсора 23", "Sensor 23 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*12+7, "Нижний предел 2 сенсора 23", "Sensor 23 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*12+8, "Интервал измерений в сенсоре 23, в сек", "Measurement interval in the sensor 23, sec" },
  {BASE_STATION_BT+4+15*10+11*12+9, "Коэффициент периода времени сенсора 23", "Sensor 23 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*12+10,"Напряжение батареи сенсора 23", "Sensor 23 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 23)
  {BASE_STATION_BT+4+15*10+11*13+0, "Тип и MAC-адрес сенсора 24", "Sensor 24 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*13+1, "Timestap сенсора 24", "Sensor 24 timestamp"},
  {BASE_STATION_BT+4+15*10+11*13+2, "Параметр 1 сенсора 24", "Sensor 24 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*13+3, "Параметр 2 сенсора 24", "Sensor 24 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*13+4, "Верхний предел 1 сенсора 24", "Sensor 24 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*13+5, "Нижний предел 1 сенсора 24", "Sensor 24 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*13+6, "Верхний предел 2 сенсора 24", "Sensor 24 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*13+7, "Нижний предел 2 сенсора 24", "Sensor 24 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*13+8, "Интервал измерений в сенсоре 24, в сек", "Measurement interval in the sensor 24, sec" },
  {BASE_STATION_BT+4+15*10+11*13+9, "Коэффициент периода времени сенсора 24", "Sensor 24 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*13+10,"Напряжение батареи сенсора 24", "Sensor 24 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 24)
  {BASE_STATION_BT+4+15*10+11*14+0, "Тип и MAC-адрес сенсора 25", "Sensor 25 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*14+1, "Timestap сенсора 25", "Sensor 25 timestamp"},
  {BASE_STATION_BT+4+15*10+11*14+2, "Параметр 1 сенсора 25", "Sensor 25 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*14+3, "Параметр 2 сенсора 25", "Sensor 25 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*14+4, "Верхний предел 1 сенсора 25", "Sensor 25 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*14+5, "Нижний предел 1 сенсора 25", "Sensor 25 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*14+6, "Верхний предел 2 сенсора 25", "Sensor 25 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*14+7, "Нижний предел 2 сенсора 25", "Sensor 25 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*14+8, "Интервал измерений в сенсоре 25, в сек", "Measurement interval in the sensor 25, sec" },
  {BASE_STATION_BT+4+15*10+11*14+9, "Коэффициент периода времени сенсора 25", "Sensor 25 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*14+10,"Напряжение батареи сенсора 25", "Sensor 25 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 25)
  {BASE_STATION_BT+4+15*10+11*15+0, "Тип и MAC-адрес сенсора 26", "Sensor 26 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*15+1, "Timestap сенсора 26", "Sensor 26 timestamp"},
  {BASE_STATION_BT+4+15*10+11*15+2, "Параметр 1 сенсора 26", "Sensor 26 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*15+3, "Параметр 2 сенсора 26", "Sensor 26 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*15+4, "Верхний предел 1 сенсора 26", "Sensor 26 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*15+5, "Нижний предел 1 сенсора 26", "Sensor 26 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*15+6, "Верхний предел 2 сенсора 26", "Sensor 26 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*15+7, "Нижний предел 2 сенсора 26", "Sensor 26 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*15+8, "Интервал измерений в сенсоре 26, в сек", "Measurement interval in the sensor 26, sec" },
  {BASE_STATION_BT+4+15*10+11*15+9, "Коэффициент периода времени сенсора 26", "Sensor 26 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*15+10,"Напряжение батареи сенсора 26", "Sensor 26 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 26)
  {BASE_STATION_BT+4+15*10+11*16+0, "Тип и MAC-адрес сенсора 27", "Sensor 27 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*16+1, "Timestap сенсора 27", "Sensor 27 timestamp"},
  {BASE_STATION_BT+4+15*10+11*16+2, "Параметр 1 сенсора 27", "Sensor 27 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*16+3, "Параметр 2 сенсора 27", "Sensor 27 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*16+4, "Верхний предел 1 сенсора 27", "Sensor 27 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*16+5, "Нижний предел 1 сенсора 27", "Sensor 27 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*16+6, "Верхний предел 2 сенсора 27", "Sensor 27 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*16+7, "Нижний предел 2 сенсора 27", "Sensor 27 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*16+8, "Интервал измерений в сенсоре 27, в сек", "Measurement interval in the sensor 27, sec" },
  {BASE_STATION_BT+4+15*10+11*16+9, "Коэффициент периода времени сенсора 27", "Sensor 27 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*16+10,"Напряжение батареи сенсора 27", "Sensor 27 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 27)
  {BASE_STATION_BT+4+15*10+11*17+0, "Тип и MAC-адрес сенсора 28", "Sensor 28 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*17+1, "Timestap сенсора 28", "Sensor 28 timestamp"},
  {BASE_STATION_BT+4+15*10+11*17+2, "Параметр 1 сенсора 28", "Sensor 28 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*17+3, "Параметр 2 сенсора 28", "Sensor 28 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*17+4, "Верхний предел 1 сенсора 28", "Sensor 28 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*17+5, "Нижний предел 1 сенсора 28", "Sensor 28 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*17+6, "Верхний предел 2 сенсора 28", "Sensor 28 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*17+7, "Нижний предел 2 сенсора 28", "Sensor 28 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*17+8, "Интервал измерений в сенсоре 28, в сек", "Measurement interval in the sensor 28, sec" },
  {BASE_STATION_BT+4+15*10+11*17+9, "Коэффициент периода времени сенсора 28", "Sensor 28 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*17+10,"Напряжение батареи сенсора 28", "Sensor 28 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 28)
  {BASE_STATION_BT+4+15*10+11*18+0, "Тип и MAC-адрес сенсора 29", "Sensor 29 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*18+1, "Timestap сенсора 29", "Sensor 29 timestamp"},
  {BASE_STATION_BT+4+15*10+11*18+2, "Параметр 1 сенсора 29", "Sensor 29 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*18+3, "Параметр 2 сенсора 29", "Sensor 29 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*18+4, "Верхний предел 1 сенсора 29", "Sensor 29 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*18+5, "Нижний предел 1 сенсора 29", "Sensor 29 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*18+6, "Верхний предел 2 сенсора 29", "Sensor 29 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*18+7, "Нижний предел 2 сенсора 29", "Sensor 29 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*18+8, "Интервал измерений в сенсоре 29, в сек", "Measurement interval in the sensor 29, sec" },
  {BASE_STATION_BT+4+15*10+11*18+9, "Коэффициент периода времени сенсора 29", "Sensor 29 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*18+10,"Напряжение батареи сенсора 29", "Sensor 29 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 29)
  {BASE_STATION_BT+4+15*10+11*19+0, "Тип и MAC-адрес сенсора 30", "Sensor 30 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*19+1, "Timestap сенсора 30", "Sensor 30 timestamp"},
  {BASE_STATION_BT+4+15*10+11*19+2, "Параметр 1 сенсора 30", "Sensor 30 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*19+3, "Параметр 2 сенсора 30", "Sensor 30 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*19+4, "Верхний предел 1 сенсора 30", "Sensor 30 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*19+5, "Нижний предел 1 сенсора 30", "Sensor 30 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*19+6, "Верхний предел 2 сенсора 30", "Sensor 30 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*19+7, "Нижний предел 2 сенсора 30", "Sensor 30 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*19+8, "Интервал измерений в сенсоре 30, в сек", "Measurement interval in the sensor 30, sec" },
  {BASE_STATION_BT+4+15*10+11*19+9, "Коэффициент периода времени сенсора 30", "Sensor 30 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*19+10,"Напряжение батареи сенсора 30", "Sensor 30 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 30)
  {BASE_STATION_BT+4+15*10+11*20+0, "Тип и MAC-адрес сенсора 31", "Sensor 31 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*20+1, "Timestap сенсора 31", "Sensor 31 timestamp"},
  {BASE_STATION_BT+4+15*10+11*20+2, "Параметр 1 сенсора 31", "Sensor 31 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*20+3, "Параметр 2 сенсора 31", "Sensor 31 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*20+4, "Верхний предел 1 сенсора 31", "Sensor 31 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*20+5, "Нижний предел 1 сенсора 31", "Sensor 31 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*20+6, "Верхний предел 2 сенсора 31", "Sensor 31 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*20+7, "Нижний предел 2 сенсора 31", "Sensor 31 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*20+8, "Интервал измерений в сенсоре 31, в сек", "Measurement interval in the sensor 31, sec" },
  {BASE_STATION_BT+4+15*10+11*20+9, "Коэффициент периода времени сенсора 31", "Sensor 31 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*20+10,"Напряжение батареи сенсора 31", "Sensor 31 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 31)
  {BASE_STATION_BT+4+15*10+11*21+0, "Тип и MAC-адрес сенсора 32", "Sensor 32 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*21+1, "Timestap сенсора 32", "Sensor 32 timestamp"},
  {BASE_STATION_BT+4+15*10+11*21+2, "Параметр 1 сенсора 32", "Sensor 32 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*21+3, "Параметр 2 сенсора 32", "Sensor 32 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*21+4, "Верхний предел 1 сенсора 32", "Sensor 32 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*21+5, "Нижний предел 1 сенсора 32", "Sensor 32 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*21+6, "Верхний предел 2 сенсора 32", "Sensor 32 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*21+7, "Нижний предел 2 сенсора 32", "Sensor 32 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*21+8, "Интервал измерений в сенсоре 32, в сек", "Measurement interval in the sensor 32, sec" },
  {BASE_STATION_BT+4+15*10+11*21+9, "Коэффициент периода времени сенсора 32", "Sensor 32 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*21+10,"Напряжение батареи сенсора 32", "Sensor 32 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 32)
  {BASE_STATION_BT+4+15*10+11*22+0, "Тип и MAC-адрес сенсора 33", "Sensor 33 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*22+1, "Timestap сенсора 33", "Sensor 33 timestamp"},
  {BASE_STATION_BT+4+15*10+11*22+2, "Параметр 1 сенсора 33", "Sensor 33 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*22+3, "Параметр 2 сенсора 33", "Sensor 33 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*22+4, "Верхний предел 1 сенсора 33", "Sensor 33 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*22+5, "Нижний предел 1 сенсора 33", "Sensor 33 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*22+6, "Верхний предел 2 сенсора 33", "Sensor 33 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*22+7, "Нижний предел 2 сенсора 33", "Sensor 33 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*22+8, "Интервал измерений в сенсоре 33, в сек", "Measurement interval in the sensor 33, sec" },
  {BASE_STATION_BT+4+15*10+11*22+9, "Коэффициент периода времени сенсора 33", "Sensor 33 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*22+10,"Напряжение батареи сенсора 33", "Sensor 33 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 33)
  {BASE_STATION_BT+4+15*10+11*23+0, "Тип и MAC-адрес сенсора 34", "Sensor 34 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*23+1, "Timestap сенсора 34", "Sensor 34 timestamp"},
  {BASE_STATION_BT+4+15*10+11*23+2, "Параметр 1 сенсора 34", "Sensor 34 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*23+3, "Параметр 2 сенсора 34", "Sensor 34 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*23+4, "Верхний предел 1 сенсора 34", "Sensor 34 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*23+5, "Нижний предел 1 сенсора 34", "Sensor 34 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*23+6, "Верхний предел 2 сенсора 34", "Sensor 34 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*23+7, "Нижний предел 2 сенсора 34", "Sensor 34 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*23+8, "Интервал измерений в сенсоре 34, в сек", "Measurement interval in the sensor 34, sec" },
  {BASE_STATION_BT+4+15*10+11*23+9, "Коэффициент периода времени сенсора 34", "Sensor 34 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*23+10,"Напряжение батареи сенсора 34", "Sensor 34 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 34)
  {BASE_STATION_BT+4+15*10+11*24+0, "Тип и MAC-адрес сенсора 35", "Sensor 35 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*24+1, "Timestap сенсора 35", "Sensor 35 timestamp"},
  {BASE_STATION_BT+4+15*10+11*24+2, "Параметр 1 сенсора 35", "Sensor 35 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*24+3, "Параметр 2 сенсора 35", "Sensor 35 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*24+4, "Верхний предел 1 сенсора 35", "Sensor 35 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*24+5, "Нижний предел 1 сенсора 35", "Sensor 35 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*24+6, "Верхний предел 2 сенсора 35", "Sensor 35 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*24+7, "Нижний предел 2 сенсора 35", "Sensor 35 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*24+8, "Интервал измерений в сенсоре 35, в сек", "Measurement interval in the sensor 35, sec" },
  {BASE_STATION_BT+4+15*10+11*24+9, "Коэффициент периода времени сенсора 35", "Sensor 35 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*24+10,"Напряжение батареи сенсора 35", "Sensor 35 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 35)
  {BASE_STATION_BT+4+15*10+11*25+0, "Тип и MAC-адрес сенсора 36", "Sensor 36 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*25+1, "Timestap сенсора 36", "Sensor 36 timestamp"},
  {BASE_STATION_BT+4+15*10+11*25+2, "Параметр 1 сенсора 36", "Sensor 36 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*25+3, "Параметр 2 сенсора 36", "Sensor 36 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*25+4, "Верхний предел 1 сенсора 36", "Sensor 36 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*25+5, "Нижний предел 1 сенсора 36", "Sensor 36 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*25+6, "Верхний предел 2 сенсора 36", "Sensor 36 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*25+7, "Нижний предел 2 сенсора 36", "Sensor 36 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*25+8, "Интервал измерений в сенсоре 36, в сек", "Measurement interval in the sensor 36, sec" },
  {BASE_STATION_BT+4+15*10+11*25+9, "Коэффициент периода времени сенсора 36", "Sensor 36 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*25+10,"Напряжение батареи сенсора 36", "Sensor 36 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 36)
  {BASE_STATION_BT+4+15*10+11*26+0, "Тип и MAC-адрес сенсора 37", "Sensor 37 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*26+1, "Timestap сенсора 37", "Sensor 37 timestamp"},
  {BASE_STATION_BT+4+15*10+11*26+2, "Параметр 1 сенсора 37", "Sensor 37 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*26+3, "Параметр 2 сенсора 37", "Sensor 37 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*26+4, "Верхний предел 1 сенсора 37", "Sensor 37 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*26+5, "Нижний предел 1 сенсора 37", "Sensor 37 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*26+6, "Верхний предел 2 сенсора 37", "Sensor 37 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*26+7, "Нижний предел 2 сенсора 37", "Sensor 37 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*26+8, "Интервал измерений в сенсоре 37, в сек", "Measurement interval in the sensor 37, sec" },
  {BASE_STATION_BT+4+15*10+11*26+9, "Коэффициент периода времени сенсора 37", "Sensor 37 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*26+10,"Напряжение батареи сенсора 37", "Sensor 37 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 37)
  {BASE_STATION_BT+4+15*10+11*27+0, "Тип и MAC-адрес сенсора 38", "Sensor 38 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*27+1, "Timestap сенсора 38", "Sensor 38 timestamp"},
  {BASE_STATION_BT+4+15*10+11*27+2, "Параметр 1 сенсора 38", "Sensor 38 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*27+3, "Параметр 2 сенсора 38", "Sensor 38 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*27+4, "Верхний предел 1 сенсора 38", "Sensor 38 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*27+5, "Нижний предел 1 сенсора 38", "Sensor 38 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*27+6, "Верхний предел 2 сенсора 38", "Sensor 38 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*27+7, "Нижний предел 2 сенсора 38", "Sensor 38 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*27+8, "Интервал измерений в сенсоре 38, в сек", "Measurement interval in the sensor 38, sec" },
  {BASE_STATION_BT+4+15*10+11*27+9, "Коэффициент периода времени сенсора 38", "Sensor 38 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*27+10,"Напряжение батареи сенсора 38", "Sensor 38 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 38)
  {BASE_STATION_BT+4+15*10+11*28+0, "Тип и MAC-адрес сенсора 39", "Sensor 39 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*28+1, "Timestap сенсора 39", "Sensor 39 timestamp"},
  {BASE_STATION_BT+4+15*10+11*28+2, "Параметр 1 сенсора 39", "Sensor 39 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*28+3, "Параметр 2 сенсора 39", "Sensor 39 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*28+4, "Верхний предел 1 сенсора 39", "Sensor 39 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*28+5, "Нижний предел 1 сенсора 39", "Sensor 39 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*28+6, "Верхний предел 2 сенсора 39", "Sensor 39 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*28+7, "Нижний предел 2 сенсора 39", "Sensor 39 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*28+8, "Интервал измерений в сенсоре 39, в сек", "Measurement interval in the sensor 39, sec" },
  {BASE_STATION_BT+4+15*10+11*28+9, "Коэффициент периода времени сенсора 39", "Sensor 39 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*28+10,"Напряжение батареи сенсора 39", "Sensor 39 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 39)
  {BASE_STATION_BT+4+15*10+11*29+0, "Тип и MAC-адрес сенсора 40", "Sensor 40 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*29+1, "Timestap сенсора 40", "Sensor 40 timestamp"},
  {BASE_STATION_BT+4+15*10+11*29+2, "Параметр 1 сенсора 40", "Sensor 40 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*29+3, "Параметр 2 сенсора 40", "Sensor 40 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*29+4, "Верхний предел 1 сенсора 40", "Sensor 40 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*29+5, "Нижний предел 1 сенсора 40", "Sensor 40 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*29+6, "Верхний предел 2 сенсора 40", "Sensor 40 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*29+7, "Нижний предел 2 сенсора 40", "Sensor 40 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*29+8, "Интервал измерений в сенсоре 40, в сек", "Measurement interval in the sensor 40, sec" },
  {BASE_STATION_BT+4+15*10+11*29+9, "Коэффициент периода времени сенсора 40", "Sensor 40 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*29+10,"Напряжение батареи сенсора 40", "Sensor 40 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 40)
  {BASE_STATION_BT+4+15*10+11*30+0, "Тип и MAC-адрес сенсора 41", "Sensor 41 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*30+1, "Timestap сенсора 41", "Sensor 41 timestamp"},
  {BASE_STATION_BT+4+15*10+11*30+2, "Параметр 1 сенсора 41", "Sensor 41 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*30+3, "Параметр 2 сенсора 41", "Sensor 41 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*30+4, "Верхний предел 1 сенсора 41", "Sensor 41 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*30+5, "Нижний предел 1 сенсора 41", "Sensor 41 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*30+6, "Верхний предел 2 сенсора 41", "Sensor 41 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*30+7, "Нижний предел 2 сенсора 41", "Sensor 41 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*30+8, "Интервал измерений в сенсоре 41, в сек", "Measurement interval in the sensor 41, sec" },
  {BASE_STATION_BT+4+15*10+11*30+9, "Коэффициент периода времени сенсора 41", "Sensor 41 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*30+10,"Напряжение батареи сенсора 41", "Sensor 41 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 41)
  {BASE_STATION_BT+4+15*10+11*31+0, "Тип и MAC-адрес сенсора 42", "Sensor 42 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*31+1, "Timestap сенсора 42", "Sensor 42 timestamp"},
  {BASE_STATION_BT+4+15*10+11*31+2, "Параметр 1 сенсора 42", "Sensor 42 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*31+3, "Параметр 2 сенсора 42", "Sensor 42 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*31+4, "Верхний предел 1 сенсора 42", "Sensor 42 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*31+5, "Нижний предел 1 сенсора 42", "Sensor 42 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*31+6, "Верхний предел 2 сенсора 42", "Sensor 42 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*31+7, "Нижний предел 2 сенсора 42", "Sensor 42 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*31+8, "Интервал измерений в сенсоре 42, в сек", "Measurement interval in the sensor 42, sec" },
  {BASE_STATION_BT+4+15*10+11*31+9, "Коэффициент периода времени сенсора 42", "Sensor 42 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*31+10,"Напряжение батареи сенсора 42", "Sensor 42 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 42)
  {BASE_STATION_BT+4+15*10+11*32+0, "Тип и MAC-адрес сенсора 43", "Sensor 43 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*32+1, "Timestap сенсора 43", "Sensor 43 timestamp"},
  {BASE_STATION_BT+4+15*10+11*32+2, "Параметр 1 сенсора 43", "Sensor 43 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*32+3, "Параметр 2 сенсора 43", "Sensor 43 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*32+4, "Верхний предел 1 сенсора 43", "Sensor 43 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*32+5, "Нижний предел 1 сенсора 43", "Sensor 43 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*32+6, "Верхний предел 2 сенсора 43", "Sensor 43 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*32+7, "Нижний предел 2 сенсора 43", "Sensor 43 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*32+8, "Интервал измерений в сенсоре 43, в сек", "Measurement interval in the sensor 43, sec" },
  {BASE_STATION_BT+4+15*10+11*32+9, "Коэффициент периода времени сенсора 43", "Sensor 43 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*32+10,"Напряжение батареи сенсора 43", "Sensor 43 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 43)
  {BASE_STATION_BT+4+15*10+11*33+0, "Тип и MAC-адрес сенсора 44", "Sensor 44 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*33+1, "Timestap сенсора 44", "Sensor 44 timestamp"},
  {BASE_STATION_BT+4+15*10+11*33+2, "Параметр 1 сенсора 44", "Sensor 44 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*33+3, "Параметр 2 сенсора 44", "Sensor 44 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*33+4, "Верхний предел 1 сенсора 44", "Sensor 44 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*33+5, "Нижний предел 1 сенсора 44", "Sensor 44 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*33+6, "Верхний предел 2 сенсора 44", "Sensor 44 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*33+7, "Нижний предел 2 сенсора 44", "Sensor 44 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*33+8, "Интервал измерений в сенсоре 44, в сек", "Measurement interval in the sensor 44, sec" },
  {BASE_STATION_BT+4+15*10+11*33+9, "Коэффициент периода времени сенсора 44", "Sensor 44 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*33+10,"Напряжение батареи сенсора 44", "Sensor 44 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 44)
  {BASE_STATION_BT+4+15*10+11*34+0, "Тип и MAC-адрес сенсора 45", "Sensor 45 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*34+1, "Timestap сенсора 45", "Sensor 45 timestamp"},
  {BASE_STATION_BT+4+15*10+11*34+2, "Параметр 1 сенсора 45", "Sensor 45 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*34+3, "Параметр 2 сенсора 45", "Sensor 45 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*34+4, "Верхний предел 1 сенсора 45", "Sensor 45 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*34+5, "Нижний предел 1 сенсора 45", "Sensor 45 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*34+6, "Верхний предел 2 сенсора 45", "Sensor 45 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*34+7, "Нижний предел 2 сенсора 45", "Sensor 45 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*34+8, "Интервал измерений в сенсоре 45, в сек", "Measurement interval in the sensor 45, sec" },
  {BASE_STATION_BT+4+15*10+11*34+9, "Коэффициент периода времени сенсора 45", "Sensor 45 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*34+10,"Напряжение батареи сенсора 45", "Sensor 45 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 45)
  {BASE_STATION_BT+4+15*10+11*35+0, "Тип и MAC-адрес сенсора 46", "Sensor 46 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*35+1, "Timestap сенсора 46", "Sensor 46 timestamp"},
  {BASE_STATION_BT+4+15*10+11*35+2, "Параметр 1 сенсора 46", "Sensor 46 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*35+3, "Параметр 2 сенсора 46", "Sensor 46 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*35+4, "Верхний предел 1 сенсора 46", "Sensor 46 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*35+5, "Нижний предел 1 сенсора 46", "Sensor 46 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*35+6, "Верхний предел 2 сенсора 46", "Sensor 46 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*35+7, "Нижний предел 2 сенсора 46", "Sensor 46 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*35+8, "Интервал измерений в сенсоре 46, в сек", "Measurement interval in the sensor 46, sec" },
  {BASE_STATION_BT+4+15*10+11*35+9, "Коэффициент периода времени сенсора 46", "Sensor 46 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*35+10,"Напряжение батареи сенсора 46", "Sensor 46 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 46)
  {BASE_STATION_BT+4+15*10+11*36+0, "Тип и MAC-адрес сенсора 47", "Sensor 47 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*36+1, "Timestap сенсора 47", "Sensor 47 timestamp"},
  {BASE_STATION_BT+4+15*10+11*36+2, "Параметр 1 сенсора 47", "Sensor 47 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*36+3, "Параметр 2 сенсора 47", "Sensor 47 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*36+4, "Верхний предел 1 сенсора 47", "Sensor 47 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*36+5, "Нижний предел 1 сенсора 47", "Sensor 47 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*36+6, "Верхний предел 2 сенсора 47", "Sensor 47 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*36+7, "Нижний предел 2 сенсора 47", "Sensor 47 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*36+8, "Интервал измерений в сенсоре 47, в сек", "Measurement interval in the sensor 47, sec" },
  {BASE_STATION_BT+4+15*10+11*36+9, "Коэффициент периода времени сенсора 47", "Sensor 47 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*36+10,"Напряжение батареи сенсора 47", "Sensor 47 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 47)
  {BASE_STATION_BT+4+15*10+11*37+0, "Тип и MAC-адрес сенсора 48", "Sensor 48 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*37+1, "Timestap сенсора 48", "Sensor 48 timestamp"},
  {BASE_STATION_BT+4+15*10+11*37+2, "Параметр 1 сенсора 48", "Sensor 48 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*37+3, "Параметр 2 сенсора 48", "Sensor 48 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*37+4, "Верхний предел 1 сенсора 48", "Sensor 48 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*37+5, "Нижний предел 1 сенсора 48", "Sensor 48 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*37+6, "Верхний предел 2 сенсора 48", "Sensor 48 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*37+7, "Нижний предел 2 сенсора 48", "Sensor 48 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*37+8, "Интервал измерений в сенсоре 48, в сек", "Measurement interval in the sensor 48, sec" },
  {BASE_STATION_BT+4+15*10+11*37+9, "Коэффициент периода времени сенсора 48", "Sensor 48 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*37+10,"Напряжение батареи сенсора 48", "Sensor 48 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 48)
  {BASE_STATION_BT+4+15*10+11*38+0, "Тип и MAC-адрес сенсора 49", "Sensor 49 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*38+1, "Timestap сенсора 49", "Sensor 49 timestamp"},
  {BASE_STATION_BT+4+15*10+11*38+2, "Параметр 1 сенсора 49", "Sensor 49 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*38+3, "Параметр 2 сенсора 49", "Sensor 49 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*38+4, "Верхний предел 1 сенсора 49", "Sensor 49 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*38+5, "Нижний предел 1 сенсора 49", "Sensor 49 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*38+6, "Верхний предел 2 сенсора 49", "Sensor 49 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*38+7, "Нижний предел 2 сенсора 49", "Sensor 49 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*38+8, "Интервал измерений в сенсоре 49, в сек", "Measurement interval in the sensor 49, sec" },
  {BASE_STATION_BT+4+15*10+11*38+9, "Коэффициент периода времени сенсора 49", "Sensor 49 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*38+10,"Напряжение батареи сенсора 49", "Sensor 49 battery voltage"},
#endif
#if (MAX_BT_SENSORS > 49)
  {BASE_STATION_BT+4+15*10+11*39+0, "Тип и MAC-адрес сенсора 50", "Sensor 50 type&MAC"},
  {BASE_STATION_BT+4+15*10+11*39+1, "Timestap сенсора 50", "Sensor 50 timestamp"},
  {BASE_STATION_BT+4+15*10+11*39+2, "Параметр 1 сенсора 50", "Sensor 50 parameter 1"},
  {BASE_STATION_BT+4+15*10+11*39+3, "Параметр 2 сенсора 50", "Sensor 50 parameter 2"},
  {BASE_STATION_BT+4+15*10+11*39+4, "Верхний предел 1 сенсора 50", "Sensor 50 upper limit 1"},
  {BASE_STATION_BT+4+15*10+11*39+5, "Нижний предел 1 сенсора 50", "Sensor 50 lower limit 1"},
  {BASE_STATION_BT+4+15*10+11*39+6, "Верхний предел 2 сенсора 50", "Sensor 50 upper limit 2"},
  {BASE_STATION_BT+4+15*10+11*39+7, "Нижний предел 2 сенсора 50", "Sensor 50 lower limit 2"},
  {BASE_STATION_BT+4+15*10+11*39+8, "Интервал измерений в сенсоре 50, в сек", "Measurement interval in the sensor 50, sec" },
  {BASE_STATION_BT+4+15*10+11*39+9, "Коэффициент периода времени сенсора 50", "Sensor 50 time period ratio"},
  {BASE_STATION_BT+4+15*10+11*39+10,"Напряжение батареи сенсора 50", "Sensor 50 battery voltage"},
#endif
  #if (MAX_BT_SENSORS > 50)
#error Нужно добавить сюда bt_sensors
#endif
#endif //defined(BASE_STATION_BT_PRESENT)

#if defined(NRF_BEACONS_SCANNER_PRESENT)
//вторая часть nrf биконов
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 7)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF8 , "Группа радиометок 8", "NRF beacons group 8"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF8 , "Состояние батарей группы радиометок 8", "NRF beacons group 8 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 8)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF9 , "Группа радиометок 9", "NRF beacons group 9"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF9 , "Состояние батарей группы радиометок 9", "NRF beacons group 9 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 9)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF10 , "Группа радиометок 10", "NRF beacons group 10"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF10 , "Состояние батарей группы радиометок 10", "NRF beacons group 10 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 10)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF11 , "Группа радиометок 11", "NRF beacons group 11"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF11 , "Состояние батарей группы радиометок 11", "NRF beacons group 11 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 11)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF12 , "Группа радиометок 12", "NRF beacons group 12"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF12 , "Состояние батарей группы радиометок 12", "NRF beacons group 12 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 12)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF13 , "Группа радиометок 13", "NRF beacons group 13"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF13 , "Состояние батарей группы радиометок 13", "NRF beacons group 13 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 13)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF14 , "Группа радиометок 14", "NRF beacons group 14"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF14 , "Состояние батарей группы радиометок 14", "NRF beacons group 14 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 14)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF15 , "Группа радиометок 15", "NRF beacons group 15"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF15 , "Состояние батарей группы радиометок 15", "NRF beacons group 15 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 15)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF16 , "Группа радиометок 16", "NRF beacons group 16"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF16 , "Состояние батарей группы радиометок 16", "NRF beacons group 16 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 16)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF17 , "Группа радиометок 17", "NRF beacons group 17"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF17 , "Состояние батарей группы радиометок 17", "NRF beacons group 17 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 17)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF18 , "Группа радиометок 18", "NRF beacons group 18"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF18 , "Состояние батарей группы радиометок 18", "NRF beacons group 18 battry state"},
#endif
  #if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 18)
  {NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF19 , "Группа радиометок 19", "NRF beacons group 19"},
  {NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF19 , "Состояние батарей группы радиометок 19", "NRF beacons group 19 battry state"},
#endif
#if (MAX_NRF_AUTORIZED_BEACONS_COUNT/32 > 19)
#error   Нужно добавить NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF
#endif
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(RS_TACHO_PRESENT)
      {TACHO_COMMAND, "Команды тахометра", "Tacho commands"},

      {TACHO_COMMUNICATION_STATE, "Состояние и тип тахографа", "Status and type of tachograph"},
      {TACHO_DATETIME, "Дата и время создания записи", "Date and time the entry was created"},
      {TACHO_VRN, "Регистрационный номер ТС", "Vehicle registration number"},
      {TACHO_VIN, "VIN номер TC", "VIN number"},
      {TACHO_DISTANCE, "Показания одометра", "Odometer reading"},

      {TACHO_STATE_FLAGS, "Флаги состояния тахографа", "Tachograph status flags"},

      {TACHO_CARD1_STATE, "Состояние карты 1", "Card 1 status"},
      {TACHO_CARD1_TYPE, "Тип карты в слоте 1", "Card type in slot 1"},
      {TACHO_CARD1_ACTIVITY, "Деятельность, карта 1", "Activity card 1"},
      {TACHO_CARD1_NUMBER, "Номер карты в слоте 1", "Card number in slot 1"},
      {TACHO_CARD1_IDENT1, "Водитель 1, cтока идентификации 1", "Driver 1, current identification 1"},
      {TACHO_CARD1_IDENT2, "Водитель 1, cтока идентификации 2", "Driver 1, current identification 2"},
      {TACHO_CARD1_TIME_IN_CURRENT_MODE, "Водитель 1, время нахождения в текущем режиме", "Driver 1, time in current mode"},
      {TACHO_CARD1_DRIVE_TIME_OF_DAY, "Водитель 1, общее время управления за сутки", "Driver 1, total driving time per day"},
      {TACHO_CARD1_CONTINUIUS_DRIVE_TIME, "Водитель 1, непрерывное время управления", "Driver 1, continuous driving time"},

      {TACHO_CARD2_STATE, "Состояние карты 2", "Card 2 status"},
      {TACHO_CARD2_TYPE, "Тип карты в слоте 2", "Card type in slot 2"},
      {TACHO_CARD2_ACTIVITY, "Деятельность, карта 2", "Activity card 2"},
      {TACHO_CARD2_NUMBER, "Номер карты в слоте 2", "Card number in slot 2"},
      {TACHO_CARD2_IDENT1, "Водитель 2, cтока идентификации 1", "Driver 2, current identification 1"},
      {TACHO_CARD2_IDENT2, "Водитель 2, cтока идентификации 2", "Driver 2, current identification 2"},
      {TACHO_CARD2_TIME_IN_CURRENT_MODE, "Водитель 2, время нахождения в текущем режиме", "Driver 2, time in current mode"},
      {TACHO_CARD2_DRIVE_TIME_OF_DAY, "Водитель 2, общее время управления за сутки", "Driver 2, total driving time per day"},
      {TACHO_CARD2_CONTINUIUS_DRIVE_TIME, "Водитель 2, непрерывное время управления", "Driver 2, continuous driving time"},

      {TACHO_CARD_UPLOAD_STATE, "Статус выгрузки файла на блок", "File upload to block status"},
#endif //defined(RS_TACHO_PRESENT)

#if defined(EXTERNAL_BLE_BOARD_PRESENT)
  {BLE_EXT_BOARD_COMMUNICATION_STATE, "Состояние подключения платы BLE", "BLE board communication state"},
  {BLE_EXT_BOARD_BOOT_VERS, "Версия загрузчика платы BLE", "BLE board boot version"},
  {BLE_EXT_BOARD_APP_VERS, "Версия прошивки платы BLE", "BLE board firmware version"},
  {BLE_EXT_BOARD_MAC, "MAC адрес платы BLE", "BLE board MAC"},
  {BLE_EXT_BOARD_CONN_BLE_STATE, "Состояние подключения BLE", "BLE connection state"},
  {BLE_EXT_BOARD_FW_UPD_PCT, "Процент обновления прошивки BLE платы", "BLE board update percent"},
  {BLE_EXT_BOARD_VEGA_BLE_SESSION_SECURE_KEY, "p33007", "p33007"},

#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 0)
  {BLE_EXT_BOARD_BEACONS_INFO1, "Видимые маячки BLE 1", "BLE visible beacons 1"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 1)
  {BLE_EXT_BOARD_BEACONS_INFO2, "Видимые маячки BLE 2", "BLE visible beacons 2"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 2)
  {BLE_EXT_BOARD_BEACONS_INFO3, "Видимые маячки BLE 3", "BLE visible beacons 3"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 3)
  {BLE_EXT_BOARD_BEACONS_INFO4, "Видимые маячки BLE 4", "BLE visible beacons 4"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 4)
  {BLE_EXT_BOARD_BEACONS_INFO5, "Видимые маячки BLE 5", "BLE visible beacons 5"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 5)
  {BLE_EXT_BOARD_BEACONS_INFO6, "Видимые маячки BLE 6", "BLE visible beacons 6"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 6)
  {BLE_EXT_BOARD_BEACONS_INFO7, "Видимые маячки BLE 7", "BLE visible beacons 7"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 7)
  {BLE_EXT_BOARD_BEACONS_INFO8, "Видимые маячки BLE 8", "BLE visible beacons 8"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 8)
  {BLE_EXT_BOARD_BEACONS_INFO9, "Видимые маячки BLE 9", "BLE visible beacons 9"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 9)
  {BLE_EXT_BOARD_BEACONS_INFO10, "Видимые маячки BLE 10", "BLE visible beacons 10"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 10)
  {BLE_EXT_BOARD_BEACONS_INFO11, "Видимые маячки BLE 11", "BLE visible beacons 11"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 11)
  {BLE_EXT_BOARD_BEACONS_INFO12, "Видимые маячки BLE 12", "BLE visible beacons 12"},
#endif
#if (MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT > 12)
#error
#endif
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

#if defined(DM5002X_MANOMETR_PRESENT)
  {DM5002X_FIRST_SENSOR+0, "Состояние датчика DM5002X", "DM5002X sensor state"},
  {DM5002X_FIRST_SENSOR+1, "DM5002X значение давления", "DM5002X pressure value"},
  {DM5002X_FIRST_SENSOR+2, "DM5002X значение силы тока", "DM5002X current strength"},
  {DM5002X_FIRST_SENSOR+3, "DM5002X значение Um", "DM5002X Um value"},
  {DM5002X_FIRST_SENSOR+4, "DM5002X значение Udif", "DM5002X Udif value"},
  {DM5002X_FIRST_SENSOR+5, "DM5002X значение демпфирования", "DM5002X damping value"},
  {DM5002X_FIRST_SENSOR+6, "DM5002X верхнее значение дополнительного диапазона измерений", "DM5002X upper additional range"},
  {DM5002X_FIRST_SENSOR+7, "DM5002X нижнее значение дополнительного диапазона измерений", "DM5002X lower additional range"},
  {DM5002X_FIRST_SENSOR+8, "DM5002X верхнее значение основного диапазона измерений", "DM5002X upper main range"},
  {DM5002X_FIRST_SENSOR+9, "DM5002X нижнее значение основного диапазона измерений", "DM5002X lower main range"},
  {DM5002X_FIRST_SENSOR+10, "DM5002X нижнее значение диапазона уставок для сигнализации (уставка 1)", "DM5002X lower set point"},
  {DM5002X_FIRST_SENSOR+11, "DM5002X верхнее значение диапазона уставок для сигнализации (уставка 2)", "DM5002X upper set point"},
  {DM5002X_FIRST_SENSOR+12, "DM5002X значение гистерезиса уставок", "DM5002X set point hysteresis"},
  {DM5002X_FIRST_SENSOR+13, "DM5002X исполнение сигнализирующего устройства", "DM5002X signaling device variant"},
#endif //defined(DM5002X_MANOMETR_PRESENT)

#if defined(MODEM_FTP_PRESENT)
  {VEGA_MODEM_FTP_DWN_STATE, "Состояние FTP", "FTP state"},
#endif //defined(MODEM_FTP_PRESENT)

#if defined(ONEWIRE_PRESENT)
  {VEGA_OW_ANY_KEY_PRESENT, "Поднесен любой ключ 1-Wire", "Any 1-Wire key has been presented"},
#endif //defined(ONEWIRE_PRESENT)

#if defined(IMMO_FLANKER_PRESENT)
  {VEGA_IMMO_FLANKER_CMD, "Команда обучения immo", "Immo learn cmd"},
  {VEGA_IMMO_FLANKER_LEARN_STATE, "Состояние обучения immo", "Immo learn state"},
#endif //defined(IMMO_FLANKER_PRESENT)

#if defined(NAVITERM_PRESENT)
  {NT_DOOR_STATE               , "Состояние дверей", "Door status"},
  {NT_IN_BTN_STATE             , "Кнопка подтверждения", "Confirmation button"},
  {NT_V_SENS_STATE             , "Датчик объема", "Volume sensor"},
  {NT_A_START_STATE            , "Состояние автозапуска", "Startup status"},
  {NT_SOFT_MODE_STATE          , "Программный режим"  ,"Program mode" },
  {NT_HARD_MODE_STATE          , "Аппаратный режим"  , "Hardware mode" },
#endif //(NAVITERM_PRESENT)

#if defined(THERMALMASTER_PRESENT)
  {THERMALMASTER_COOMUNICATION_STATE , "Cвязь с THERMAL MASTER", "THERMALMASTER connection state"},
  {THERMALMASTER_INSTEMP             , "Температура управляющего датчика (канал 1), °С", "Inside temperature, °С"},
  {THERMALMASTER_OUTIND              , "Состояние реле", "Output indication"},
  {THERMALMASTER_VOLTAGE             , "Напряжение бортовой сети, В", "Voltage, V"},
  {THERMALMASTER_REFTEMP             , "Температура управляющего датчика (канал 2), °С", "Current refrigerated temperature, °С"},
  {THERMALMASTER_OPHOURSW            , "Общее время наработки, ч", "Current operation hours, h"},
  {THERMALMASTER_DEFRTEMP            , "Температура датчика оттайки, °С", "Current defrost temperature, °С"},
  {THERMALMASTER_SETTEMP             , "Установл. температура, °С", "Setpoint temperature, °С"},
  {THERMALMASTER_DEFRCYCLE           , "Цикл оттайки", "Defrost cycle"},
  {THERMALMASTER_DEFRTIME            , "Длительность оттайки, мин", "Defrost time, min"},
  {THERMALMASTER_ONOFF               , "Температурный дифференциал, °С", "Value on/off"},
  {THERMALMASTER_TEMPCORR            , "Шаг температурного дифференциала, °С", "Temperature correction, °С"},
  {THERMALMASTER_STATUS              , "Статус ХОУ ", "Status of refrigerator "},
#endif //(THERMALMASTER_PRESENT)

#if (defined(ZANOTTI_MODBUS_PRESENT))
  {ZANOTTI_COOMUNICATION_STATE       , "Cвязь с ZANOTTI", "ZANOTTI connection state"},
  {ZANOTTI_MODE                      , "Режим работы", "Mode of Operation"}, //3.4.1. Режим работы (Нагрев, Охлаждение, Разморозка в какой камере по байтам).
  {ZANOTTI_RTEMP                     , "Текущая температура, °С", "Current temperature, °С"},
  {ZANOTTI_TTEMP                     , "Заданная температура, °С", "Setpoint temperature, °С"},
  {ZANOTTI_TIME_UPD                  , "Время последнего обновления", "Last update time"},
  {ZANOTTI_TIME_CURR                 , "Время текущее", "Current time"},
  {ZANOTTI_ERR_CNT                   , "Количество ошибок на линии", "The number of errors on the line"},
  {ZANOTTI_REG_ERROR1                , "Код ошибки 1", "Error Code 1"},
  {ZANOTTI_REG_ERROR2                , "Код ошибки 2", "Error Code 2"},
  {ZANOTTI_REG_ERROR3                , "Код ошибки 3", "Error Code 3"},
  {ZANOTTI_REG_ERROR4                , "Код ошибки 4", "Error Code 4"},
  {ZANOTTI_REG_ERROR5                , "Код ошибки 5", "Error Code 5"},
  {ZANOTTI_REG_ERROR6                , "Код ошибки 6", "Error Code 6"},
  {ZANOTTI_REG_ERROR7                , "Код ошибки 7", "Error Code 7"},
  {ZANOTTI_REG_ERROR8                , "Код ошибки 8", "Error Code 8"},
  {ZANOTTI_FLAGS                     , "Флаги состояний", "State flags"},
#endif //ZANOTTI_MODBUS_PRESENT


#if (defined(SR3_PRESENT))
  {SR3_COOMUNICATION_STATE        , "Cвязь с ХОУ", "TK SLX connection state"},
  {SR3_OP_COMP1                   , "Режим отсека №1", "Mode of Operation – Compartment 1"},
  {SR3_OP_COMP2                   , "Режим отсека №2", "Mode of Operation – Compartment 2"},
  {SR3_ENG_STAT                   , "Статус работы ХОУ", "Engine / Standby Status"},
  {SR3_RUN_MODE                   , "Режим поддержания температуры", "Temperature Support Mode"},
  {SR3_SPEED_MODE                 , "Скорость двигателя", "Motor Speed"},
  {SR3_ENG_COOLANT                , "Температура  двигателя","Engine Coolant"},
  {SR3_ENG_RPM                    , "Обороты двигателя","RPM"},
  {SR3_ALRM_STAT                  , "Статус сигналов ХОУ" ,"Alarm Status"},
  {SR3_NUM_ALRMS                  , "Количество активных сигналов" ,"Number of Active Alarms"},
  {SR3_SIGNAL1                    , "Сигнал №1", "Signal №1"},
  {SR3_SIGNAL2                    , "Сигнал №2", "Signal №2"},
  {SR3_SIGNAL3                    , "Сигнал №3", "Signal №3"},
  {SR3_SIGNAL4                    , "Сигнал №4", "Signal №4"},
  {SR3_SIGNAL5                    , "Сигнал №5", "Signal №5"},
  {SR3_COMP_SP1                   , "Заданная температура отсек №1","Compartment 1 Setpoint"},
  {SR3_COMP_SP2                   , "Заданная температура отсек №2","Compartment 2 Setpoint"},
  {SR3_AMBIENT_TEMP               , "Показания датчика наружной температуры", "Ambient temperature"},
  {SR3_TEMP_COMP1_SUPL            , "Температура подачи отсек №1","Temperature Sensor Compartment 1 Supply"},
  {SR3_TEMP_COMP1_RET             , "Температура возврата отсек №1","Temperature Sensor Compartment 1 Return"},
  {SR3_TEMP_COMP2_SUPL            , "Температура подачи отсек №2","Temperature Sensor Compartment 2 Supply"},
  {SR3_TEMP_COMP2_RET             , "Температура возврата отсек №2","Temperature Sensor Compartment 2 Return"},
  {SR3_DOOR_SW1                   , "Датчик двери 1","Door Switch 1 Status"},
  {SR3_DOOR_SW2                   , "Датчик двери 2","Door Switch 2 Status"},
  {SR3_SW_ON_HOURS                , "Общие часы ХОУ","Total Switch On Hours, h"},
  {SR3_ENG_HOURS                  , "Дизель-часы ХОУ","Total Engine Hours, h"},
  {SR3_STBY_HOURS                 , "Электро-часы ХОУ","Total Standby Hours, h"},
  {SR3_PREV_HOUR_M_1              , "ТО по счетчику №1","Preventative Maintenance Hour Meter 1, h"},
  {SR3_PREV_HOUR_M_2              , "ТО по счетчику №2","Preventative Maintenance Hour Meter 2, h"},
  {SR3_LIM_HOUR_M_1               , "Выставленный предел в М\Ч до ТО счётчик №1","Limit Maintenance Hour Meter 1, h"},
  {SR3_LIM_HOUR_M_2               , "Выставленный предел в М\Ч до ТО счётчик №2","Limit Maintenance Hour Meter 2, h"},
  {SR3_SUCT_PRESS                 , "Давление всасывания","Compressor Sensor Suction Pressure"},
  {SR3_DISCH_PRESS                , "Давление нагнетания","Compressor Sensor Discharge Pressure"},
  {SR3_LEVEL_COOLANT              , "Уровень ОЖ ДВС","Level Coolant"},
  {SR3_LEVEL_OIL                  , "Уровень масла","Level Oil"},
  {SR3_OIL_PRESS                  , "Давление масла","Oil Pressure"},
  {SR3_ON_EL                      , "Электросеть подключена","Electricity Grid Connected"},
  {SR3_MAX_DEFROST                , "Максимальное время оттайки","Maximum Defrost Time, h"},
  {SR3_BATT_CURRENT               , "Ток АКБ","Battery DC Current"},
  {SR3_BATTERY_VOL                , "Напряжение АКБ","Battery DC Voltage"},
  {SR3_OUTL_TEMP1                 , "Температура испарителя 1","Evaporator Temperature 1"},
  {SR3_OUTL_TEMP2                 , "Температура испарителя 2","Evaporator Temperature 2"},
  {SR3_SOFT_REV                   , "Версия ПО ХОУ","Software Revision" },
  {SR3_SOFT_RELEASE               , "Релиз ПО ХОУ","Software Release" },
  {SR3_TYPE_MP                    , "Тип МП ХОУ","Type MP" },
#endif //SR3_PRESENT
};
#endif // #ifndef __ICCARM__

// Таблица настроек устройства. Использовать для поиска указателей на настройки
const TSettings_table CSystem::settings_table[] = {
#ifdef __ICCARM__
  //не перемещать! только для блока!
  {VEGA_SETTINGS_INFO               ,0    , &System.settings_info, sizeof(System.settings_info)},
#endif //__ICCARM__

  {VEGA_SETTING_SERVER_ADDR         ,0    , &System.connection_settings.server[0], sizeof(System.connection_settings.server[0])},
  {VEGA_SETTING_SERVER_ADDR         ,1    , &System.connection_settings.server[1], sizeof(System.connection_settings.server[1])},
  {VEGA_SETTING_SERVER_ADDR         ,2    , &System.connection_settings.server[2], sizeof(System.connection_settings.server[2])},
  {VEGA_SETTING_SERVER_ADDR         ,3    , &System.connection_settings.server[3], sizeof(System.connection_settings.server[3])},
  {VEGA_SETTING_NDTP_ADDRESS        ,0    , &System.connection_settings.ndtp_address[0], sizeof(System.connection_settings.ndtp_address[0])},
  {VEGA_SETTING_NDTP_ADDRESS        ,1    , &System.connection_settings.ndtp_address[1], sizeof(System.connection_settings.ndtp_address[1])},
  {VEGA_SETTING_NDTP_ADDRESS        ,2    , &System.connection_settings.ndtp_address[2], sizeof(System.connection_settings.ndtp_address[2])},
  {VEGA_SETTING_NDTP_ADDRESS        ,3    , &System.connection_settings.ndtp_address[3], sizeof(System.connection_settings.ndtp_address[3])},
  {VEGA_SETTING_USE_SERVER_PIN      ,0    , &System.connection_settings.security[0].pin_cfg, sizeof(System.connection_settings.security[0].pin_cfg)},
  {VEGA_SETTING_USE_SERVER_PIN      ,1    , &System.connection_settings.security[1].pin_cfg, sizeof(System.connection_settings.security[1].pin_cfg)},
  {VEGA_SETTING_USE_SERVER_PIN      ,2    , &System.connection_settings.security[2].pin_cfg, sizeof(System.connection_settings.security[2].pin_cfg)},
  {VEGA_SETTING_USE_SERVER_PIN      ,3    , &System.connection_settings.security[3].pin_cfg, sizeof(System.connection_settings.security[3].pin_cfg)},

  {VEGA_SETTING_SERVER_PIN          ,0    , &System.connection_settings.security[0].pin, sizeof(System.connection_settings.security[0].pin)},
  {VEGA_SETTING_SERVER_PIN          ,1    , &System.connection_settings.security[1].pin, sizeof(System.connection_settings.security[1].pin)},
  {VEGA_SETTING_SERVER_PIN          ,2    , &System.connection_settings.security[2].pin, sizeof(System.connection_settings.security[2].pin)},
  {VEGA_SETTING_SERVER_PIN          ,3    , &System.connection_settings.security[3].pin, sizeof(System.connection_settings.security[3].pin)},

  {VEGA_SETTING_BLACKBOX            ,0    , &System.blackbox_settings.disable_priority_messages, sizeof(System.blackbox_settings.disable_priority_messages)},
  {VEGA_SETTING_BLACKBOX            ,1    , &System.blackbox_settings.vega_protocol_bblox_enable, sizeof(System.blackbox_settings.vega_protocol_bblox_enable)},
  {VEGA_SETTING_BLACKBOX            ,2    , &System.blackbox_settings.add_lbs_param, sizeof(System.blackbox_settings.add_lbs_param)},

  {VEGA_SETTING_TRACK_RECORD        ,0    , &System.track_settings.track_param, sizeof(System.track_settings.track_param)},
  {VEGA_SETTING_TRACK_RECORD        ,1    , &System.track_settings.time_step_with_ign_off, sizeof(System.track_settings.time_step_with_ign_off)},
  {VEGA_SETTING_TRACK_RECORD        ,2    , &System.track_settings.translate_with_change_option, sizeof(System.track_settings.translate_with_change_option)},
#if defined(NMEA_TO_SERIAL_PORT_TRANSLATE_PRESENT)
  {VEGA_SETTING_TRACK_RECORD        ,3    , &System.track_settings.nmea_to_serial_port_translate, sizeof(System.track_settings.nmea_to_serial_port_translate)},
#endif //defined(NMEA_TO_SERIAL_PORT_TRANSLATE_PRESENT)
  {VEGA_SETTING_STOP_FILTER         ,0    , &System.track_settings.filter_track_on_stop, sizeof(System.track_settings.filter_track_on_stop)},
  {VEGA_SETTING_INERTIAL_NAV        ,0    , &System.track_settings.use_inertial_navigation, sizeof(System.track_settings.use_inertial_navigation)},
  {VEGA_SETTING_HDOP_FILTER         ,0    , &System.track_settings.filter_track_hdop, sizeof(System.track_settings.filter_track_hdop)},
  {VEGA_SETTING_GPS_ODOMETER        ,0    , &System.track_settings.reset_odometer_on_stop, sizeof(System.track_settings.reset_odometer_on_stop)},
  {VEGA_SETTING_GPS_ALWAYS_LOCATE   ,0    , &System.track_settings.always_locate, sizeof(System.track_settings.always_locate)},
  {VEGA_SETTING_ODOMETER_BY_IGN     ,0    , &System.track_settings.odometer_by_ign, sizeof(System.track_settings.odometer_by_ign)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,0    , &System.track_settings.nav_systems.gps, sizeof(System.track_settings.nav_systems.gps)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,1    , &System.track_settings.nav_systems.glonass, sizeof(System.track_settings.nav_systems.glonass)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,2    , &System.track_settings.nav_systems.galileo, sizeof(System.track_settings.nav_systems.galileo)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,3    , &System.track_settings.nav_systems.beidou, sizeof(System.track_settings.nav_systems.beidou)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,4    , &System.track_settings.nav_systems.sbass, sizeof(System.track_settings.nav_systems.sbass)},
  {VEGA_SETTING_USED_NAV_SYSTEM     ,5    , &System.track_settings.nav_systems.qzss, sizeof(System.track_settings.nav_systems.qzss)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,0    , &System.track_settings.extended_filters.cno_thresh, sizeof(System.track_settings.extended_filters.cno_thresh)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,1    , &System.track_settings.extended_filters.cno_thresh_num_svs, sizeof(System.track_settings.extended_filters.cno_thresh_num_svs)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,2    , &System.track_settings.extended_filters.min_elev, sizeof(System.track_settings.extended_filters.min_elev)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,3    , &System.track_settings.extended_filters.static_hold_thresh, sizeof(System.track_settings.extended_filters.static_hold_thresh)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,4    , &System.track_settings.extended_filters.static_hold_max_dist, sizeof(System.track_settings.extended_filters.static_hold_max_dist)},
  {VEGA_SETTING_NAV_EXT_FILTERS     ,5    , &System.track_settings.extended_filters.p_acc, sizeof(System.track_settings.extended_filters.p_acc)},

  {VEGA_SETTING_POWER_SAVING        ,0    , &System.power_settings, sizeof(System.power_settings)},
  {VEGA_SETTING_POWER_SAVING        ,1    , &System.power_settings_2.wake_by_dig_in, sizeof(System.power_settings_2.wake_by_dig_in)},
#if defined(GNSS_PSAVE_PRESENT)
  {VEGA_SETTING_POWER_SAVING        ,2    , &System.gnss_psave_settings, sizeof(System.gnss_psave_settings)},
#endif //defined(GNSS_PSAVE_PRESENT)
#if defined(MODEM_PSAVE_PRESENT)
  {VEGA_SETTING_POWER_SAVING        ,3    , &System.gsm_psave_settings, sizeof(System.gsm_psave_settings)},
#endif //defined(MODEM_PSAVE_PRESENT)
  {VEGA_SETTING_PIN_CODE            ,0    , &System.security_settings.pin, sizeof(System.security_settings.pin)},
  {VEGA_SETTING_USE_PIN_CODE        ,0    , &System.security_settings.use_pin, sizeof(System.security_settings.use_pin)},
  {VEGA_SETTING_IGNITION            ,0    , &System.sensor_settings.ignition, sizeof(System.sensor_settings.ignition)},

#ifdef GSENSOR_PRESENT
  {VEGA_SETTING_GSENSOR_MOVE        ,0    , &System.sensor_settings.gsensor_movesensor, sizeof(System.sensor_settings.gsensor_movesensor)},
  {VEGA_SETTING_GSENSOR_MOVE        ,1    , &System.sensor_settings.gsensor_senslevel,  sizeof(System.sensor_settings.gsensor_senslevel)},
#endif
  {VEGA_SETTING_GPS_MOVE            ,0    , &System.sensor_settings.gps_movesensor, sizeof(System.sensor_settings.gps_movesensor)},
#ifdef ALARM_BUTTON_PRESENT
  {VEGA_SETTING_ALARM_BUTTON        ,0    , &System.sensor_settings.alarm_button.din_num, sizeof(System.sensor_settings.alarm_button.din_num)},
  {VEGA_SETTING_ALARM_BUTTON_TIMEOUT ,0   , &System.sensor_settings.alarm_button.alarm_button_timeout, sizeof(System.sensor_settings.alarm_button.alarm_button_timeout)},
#endif
#ifdef AUTORIZATION_PRESENT
  {VEGA_SETTING_AUTORIZATION        ,0    , &System.sensor_settings.autorization, sizeof(System.sensor_settings.autorization)},
  {VEGA_SETTING_AUTORIZATION        ,1    , &System.sensor_settings.autorization_2, sizeof(System.sensor_settings.autorization_2)},
#endif
#ifdef MOTOHOURS_PRESENT
  {VEGA_SETTING_MOTOHOURS           ,0    , &System.sensor_settings.motohours, sizeof(System.sensor_settings.motohours)},
#endif
  {VEGA_SETTING_KEYS_ADD_MODE       ,0    , &System.sensor_settings.keys_add_mode, sizeof(System.sensor_settings.keys_add_mode)},
#ifdef CAMERA_PRESENT
  {VEGA_SETTING_CAMERA              ,0    , &System.sensor_settings.camera[0], sizeof(System.sensor_settings.camera[0])},
  {VEGA_SETTING_CAMERA_TYPE         ,0    , &System.sensor_settings.camera_type[0], sizeof(System.sensor_settings.camera_type[0])},
#endif
#if (MAX_CAMERAS > 1)
#error Нужно добавить сюда камеру
#endif
#if (MAX_DALLAS_TEMP_SENSORS > 0)
  {VEGA_SETTING_TEMP_ADD_MODE       ,0    , &System.sensor_settings.temp_add_mode, sizeof(System.sensor_settings.temp_add_mode)},
#endif

#if (defined(CANPRO_PRESENT) ||  defined(CANLOG_V4_PRESENT))
  {VEGA_SETTING_CAN                 ,0    , &System.can_settings, sizeof(System.can_settings)},
#endif //(defined(CANPRO_PRESENT) ||  defined(CANLOG_V4_PRESENT))

#if (defined(CANPRO_PRESENT) ||  defined(CANLOG_V4_PRESENT) || defined(VEGA_CAN_PRESENT))
  {VEGA_SETTING_WAKEUP_BY_CAN       ,0    , &System.wakeup_by_can_activity, sizeof(System.wakeup_by_can_activity)},
  {VEGA_SETTING_USE_CAN_IGN         ,0    , &System.sensor_settings.use_can_ignition, sizeof(System.sensor_settings.use_can_ignition)},
#endif //(defined(CANPRO_PRESENT) ||  defined(CANLOG_V4_PRESENT) || defined(VEGA_CAN_PRESENT))

#ifdef BR_PRESENT
#if (MAX_EXT_MF_INPUTS <= 15)
  {VEGA_SETTING_EXT_MFI_1_TYPE      ,0    , &System.sensor_settings.ext_mfi[0].input_type, sizeof(System.sensor_settings.ext_mfi[0].input_type)},
  {VEGA_SETTING_EXT_MFI_2_TYPE      ,0    , &System.sensor_settings.ext_mfi[1].input_type, sizeof(System.sensor_settings.ext_mfi[1].input_type)},
  {VEGA_SETTING_EXT_MFI_3_TYPE      ,0    , &System.sensor_settings.ext_mfi[2].input_type, sizeof(System.sensor_settings.ext_mfi[2].input_type)},
  {VEGA_SETTING_EXT_MFI_4_TYPE      ,0    , &System.sensor_settings.ext_mfi[3].input_type, sizeof(System.sensor_settings.ext_mfi[3].input_type)},
  {VEGA_SETTING_EXT_MFI_5_TYPE      ,0    , &System.sensor_settings.ext_mfi[4].input_type, sizeof(System.sensor_settings.ext_mfi[4].input_type)},
  {VEGA_SETTING_EXT_MFI_6_TYPE      ,0    , &System.sensor_settings.ext_mfi[5].input_type, sizeof(System.sensor_settings.ext_mfi[5].input_type)},
  {VEGA_SETTING_EXT_MFI_7_TYPE      ,0    , &System.sensor_settings.ext_mfi[6].input_type, sizeof(System.sensor_settings.ext_mfi[6].input_type)},
  {VEGA_SETTING_EXT_MFI_8_TYPE      ,0    , &System.sensor_settings.ext_mfi[7].input_type, sizeof(System.sensor_settings.ext_mfi[7].input_type)},
  {VEGA_SETTING_EXT_MFI_9_TYPE      ,0    , &System.sensor_settings.ext_mfi[8].input_type, sizeof(System.sensor_settings.ext_mfi[8].input_type)},
  {VEGA_SETTING_EXT_MFI_10_TYPE     ,0    , &System.sensor_settings.ext_mfi[9].input_type, sizeof(System.sensor_settings.ext_mfi[9].input_type)},
  {VEGA_SETTING_EXT_MFI_11_TYPE     ,0    , &System.sensor_settings.ext_mfi[10].input_type, sizeof(System.sensor_settings.ext_mfi[10].input_type)},
  {VEGA_SETTING_EXT_MFI_12_TYPE     ,0    , &System.sensor_settings.ext_mfi[11].input_type, sizeof(System.sensor_settings.ext_mfi[11].input_type)},
  {VEGA_SETTING_EXT_MFI_13_TYPE     ,0    , &System.sensor_settings.ext_mfi[12].input_type, sizeof(System.sensor_settings.ext_mfi[12].input_type)},
  {VEGA_SETTING_EXT_MFI_14_TYPE     ,0    , &System.sensor_settings.ext_mfi[13].input_type, sizeof(System.sensor_settings.ext_mfi[13].input_type)},
  {VEGA_SETTING_EXT_MFI_15_TYPE     ,0    , &System.sensor_settings.ext_mfi[14].input_type, sizeof(System.sensor_settings.ext_mfi[14].input_type)},

  {VEGA_SETTING_EXT_MFI_1_POLARITY   ,0    , &System.sensor_settings.ext_mfi[0].polarity, sizeof(System.sensor_settings.ext_mfi[0].polarity)},
  {VEGA_SETTING_EXT_MFI_2_POLARITY   ,0    , &System.sensor_settings.ext_mfi[1].polarity, sizeof(System.sensor_settings.ext_mfi[1].polarity)},
  {VEGA_SETTING_EXT_MFI_3_POLARITY   ,0    , &System.sensor_settings.ext_mfi[2].polarity, sizeof(System.sensor_settings.ext_mfi[2].polarity)},
  {VEGA_SETTING_EXT_MFI_4_POLARITY   ,0    , &System.sensor_settings.ext_mfi[3].polarity, sizeof(System.sensor_settings.ext_mfi[3].polarity)},
  {VEGA_SETTING_EXT_MFI_5_POLARITY   ,0    , &System.sensor_settings.ext_mfi[4].polarity, sizeof(System.sensor_settings.ext_mfi[4].polarity)},
  {VEGA_SETTING_EXT_MFI_6_POLARITY   ,0    , &System.sensor_settings.ext_mfi[5].polarity, sizeof(System.sensor_settings.ext_mfi[5].polarity)},
  {VEGA_SETTING_EXT_MFI_7_POLARITY   ,0    , &System.sensor_settings.ext_mfi[6].polarity, sizeof(System.sensor_settings.ext_mfi[6].polarity)},
  {VEGA_SETTING_EXT_MFI_8_POLARITY   ,0    , &System.sensor_settings.ext_mfi[7].polarity, sizeof(System.sensor_settings.ext_mfi[7].polarity)},
  {VEGA_SETTING_EXT_MFI_9_POLARITY   ,0    , &System.sensor_settings.ext_mfi[8].polarity, sizeof(System.sensor_settings.ext_mfi[8].polarity)},
  {VEGA_SETTING_EXT_MFI_10_POLARITY  ,0    , &System.sensor_settings.ext_mfi[9].polarity, sizeof(System.sensor_settings.ext_mfi[9].polarity)},
  {VEGA_SETTING_EXT_MFI_11_POLARITY  ,0    , &System.sensor_settings.ext_mfi[10].polarity, sizeof(System.sensor_settings.ext_mfi[10].polarity)},
  {VEGA_SETTING_EXT_MFI_12_POLARITY  ,0    , &System.sensor_settings.ext_mfi[11].polarity, sizeof(System.sensor_settings.ext_mfi[11].polarity)},
  {VEGA_SETTING_EXT_MFI_13_POLARITY  ,0    , &System.sensor_settings.ext_mfi[12].polarity, sizeof(System.sensor_settings.ext_mfi[12].polarity)},
  {VEGA_SETTING_EXT_MFI_14_POLARITY  ,0    , &System.sensor_settings.ext_mfi[13].polarity, sizeof(System.sensor_settings.ext_mfi[13].polarity)},
  {VEGA_SETTING_EXT_MFI_15_POLARITY  ,0    , &System.sensor_settings.ext_mfi[14].polarity, sizeof(System.sensor_settings.ext_mfi[14].polarity)},

#else
#error Неверное количество фходов/выходов платы расширения
#endif  //(MAX_EXT_MF_INPUTS <= 15)
  {VEGA_SETTING_EXT_BR_INTERFACE     ,0    , &System.sensor_settings.br_settings.interface, sizeof(System.sensor_settings.br_settings.interface)},

#endif //BR_PRESENT

#if defined(FRIDGE_PRESENT)
  {VEGA_SETTING_FRIDGE_INTERFACE  ,0    , &System.sensor_settings.fridge.interface, sizeof(System.sensor_settings.fridge.interface)},
  {VEGA_SETTING_FRIDGE_PROTOCOL   ,0    , &System.sensor_settings.fridge.protocol, sizeof(System.sensor_settings.fridge.protocol)},
#endif //FRIDGE_PRESENT

#if defined(NRF_BEACONS_SCANNER_PRESENT)
  {VEGA_SETTING_NRF_BEACONS_READER_INTERFACE  ,0    , &System.sensor_settings.nrf_beacons_scanner.interface, sizeof(System.sensor_settings.nrf_beacons_scanner.interface)},
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(TENZO_M_WEIGHER_PRESENT)
  {VEGA_SETTING_TENZO_M_INTERFACE  ,0    , &System.sensor_settings.tenzo_m_weigher.interface, sizeof(System.sensor_settings.tenzo_m_weigher.interface)},
  {VEGA_SETTING_TENZO_M_ADDRESS  ,0    , &System.sensor_settings.tenzo_m_weigher.addr, sizeof(System.sensor_settings.tenzo_m_weigher.addr)},
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(PROCESSOR_WEIGHT_PV310_PRESENT)
#if defined(TENZO_M_WEIGHER_PRESENT)
    static_assert(false) // Не должны быть одновременно определены TENZO_M_WEIGHER_PRESENT и PROCESSOR_WEIGHT_PV310_PRESENT
#endif
  {VEGA_SETTING_PV310_INTERFACE  ,0    , &System.sensor_settings.pv310_weigher.interface, sizeof(System.sensor_settings.pv310_weigher.interface)},
  {VEGA_SETTING_PV310_ADDRESS  ,0    , &System.sensor_settings.pv310_weigher.addr, sizeof(System.sensor_settings.pv310_weigher.addr)},
#endif //PROCESSOR_WEIGHT_PV310_PRESENT

#if defined(REPORT_GEN_PRESENT)
  {VEGA_SETTING_TYPE_DAT                  ,0    , &System.sensor_settings.Type_dat, sizeof(System.sensor_settings.Type_dat)},//uint32_t Type_dat;//тип темературных датчиков 1-LORA, 2-DALLAS, 3-аналоговый (терморезистор)
  {VEGA_SETTING_MAXNUMCOMPARTMENT         ,0    , &System.sensor_settings.MaxNumCompartment, sizeof(System.sensor_settings.MaxNumCompartment)},//uint32_t MaxNumCompartment;//макс.кол-во отсеков
  {VEGA_SETTING_SENS_COMPARTMENT          ,0    , &System.sensor_settings.SensCompartment, sizeof(System.sensor_settings.SensCompartment)},
  {VEGA_SETTING_PERIOD_BB_TR_TIME         ,0    , &System.sensor_settings.Period_BB_TR_TIME, sizeof(System.sensor_settings.Period_BB_TR_TIME)},//uint32_t Period_BB_TR_TIME;   //периодичность считывания темп.датчиков 1...60мин
  {VEGA_SETTING_VIN_AUTO                  ,0    , &System.sensor_settings.VIN_auto, sizeof(System.sensor_settings.VIN_auto)},//uint8_t VIN_auto[16];//VIN автомобиля
  {VEGA_SETTING_TR_HEADER                 ,0    , &System.sensor_settings.TR_header, sizeof(System.sensor_settings.TR_header)}, //uint8_t TR_header[32];//Текст заголовка
  {VEGA_SETTING_ID_OWNER                  ,0    , &System.sensor_settings.ID_owner, sizeof(System.sensor_settings.ID_owner)},//uint8_t ID_owner[16];//ID владельца
  {VEGA_SETTING_LORA_DDAT                 ,0    , &System.sensor_settings.Lora_ddat[0], sizeof(System.sensor_settings.Lora_ddat[0])},//Настройки цифровых датчиков LORA 0
  {VEGA_SETTING_LORA_DDAT                 ,1    , &System.sensor_settings.Lora_ddat[1], sizeof(System.sensor_settings.Lora_ddat[1])},//Настройки цифровых датчиков LORA 1
  {VEGA_SETTING_LORA_DDAT                 ,2    , &System.sensor_settings.Lora_ddat[2], sizeof(System.sensor_settings.Lora_ddat[2])},//Настройки цифровых датчиков LORA 2
  {VEGA_SETTING_LORA_DDAT                 ,3    , &System.sensor_settings.Lora_ddat[3], sizeof(System.sensor_settings.Lora_ddat[3])},//Настройки цифровых датчиков LORA 3
  {VEGA_SETTING_LORA_DDAT                 ,4    , &System.sensor_settings.Lora_ddat[4], sizeof(System.sensor_settings.Lora_ddat[4])},//Настройки цифровых датчиков LORA 4
  {VEGA_SETTING_LORA_DDAT                 ,5    , &System.sensor_settings.Lora_ddat[5], sizeof(System.sensor_settings.Lora_ddat[5])},//Настройки цифровых датчиков LORA 5
  {VEGA_SETTING_LORA_DDAT                 ,6    , &System.sensor_settings.Lora_ddat[6], sizeof(System.sensor_settings.Lora_ddat[6])},//Настройки цифровых датчиков LORA 6
  {VEGA_SETTING_LORA_DDAT                 ,7    , &System.sensor_settings.Lora_ddat[7], sizeof(System.sensor_settings.Lora_ddat[7])},//Настройки цифровых датчиков LORA 7
  {VEGA_SETTING_LORA_DDAT                 ,8    , &System.sensor_settings.Lora_ddat[8], sizeof(System.sensor_settings.Lora_ddat[8])},//Настройки цифровых датчиков LORA 8
  {VEGA_SETTING_LORA_DDAT                 ,9    , &System.sensor_settings.Lora_ddat[9], sizeof(System.sensor_settings.Lora_ddat[9])},//Настройки цифровых датчиков LORA 9
#endif//REPORT_GEN_PRESENT

#if defined(LORA_SENSORS_PRESENT)
  {VEGA_SETTING_LORASENS_INTERFACE   ,0    , &System.sensor_settings.lora_sens.interface, sizeof(System.sensor_settings.lora_sens.interface)},
  {VEGA_SETTING_LORASENS             ,0    , &System.sensor_settings.lora_sens.sensors[0], sizeof(System.sensor_settings.lora_sens.sensors[0])},
  {VEGA_SETTING_LORASENS             ,1    , &System.sensor_settings.lora_sens.sensors[1], sizeof(System.sensor_settings.lora_sens.sensors[1])},
  {VEGA_SETTING_LORASENS             ,2    , &System.sensor_settings.lora_sens.sensors[2], sizeof(System.sensor_settings.lora_sens.sensors[2])},
  {VEGA_SETTING_LORASENS             ,3    , &System.sensor_settings.lora_sens.sensors[3], sizeof(System.sensor_settings.lora_sens.sensors[3])},
  {VEGA_SETTING_LORASENS             ,4    , &System.sensor_settings.lora_sens.sensors[4], sizeof(System.sensor_settings.lora_sens.sensors[4])},
  {VEGA_SETTING_LORASENS             ,5    , &System.sensor_settings.lora_sens.sensors[5], sizeof(System.sensor_settings.lora_sens.sensors[5])},
  {VEGA_SETTING_LORASENS             ,6    , &System.sensor_settings.lora_sens.sensors[6], sizeof(System.sensor_settings.lora_sens.sensors[6])},
  {VEGA_SETTING_LORASENS             ,7    , &System.sensor_settings.lora_sens.sensors[7], sizeof(System.sensor_settings.lora_sens.sensors[7])},
  {VEGA_SETTING_LORASENS             ,8    , &System.sensor_settings.lora_sens.sensors[8], sizeof(System.sensor_settings.lora_sens.sensors[8])},
  {VEGA_SETTING_LORASENS             ,9    , &System.sensor_settings.lora_sens.sensors[9], sizeof(System.sensor_settings.lora_sens.sensors[9])},

#endif //LORA_SENSORS_PRESENT

#if (defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))
  {VEGA_SETTING_IQFREEZE_INTERFACE    ,0    , &System.sensor_settings.iqfreeze.interface, sizeof(System.sensor_settings.iqfreeze.interface)},
  {VEGA_SETTING_IQFREEZE_POLLL_PERIOD ,0    , &System.sensor_settings.iqfreeze.poll_time_s, sizeof(System.sensor_settings.iqfreeze.poll_time_s)},
#endif //(defined(IQFREEZE_PRESENT)||(defined(IQFREEZE_MODBUS_PRESENT)))

#if defined(TPMS_PRESENT)
  {VEGA_SETTING_TPMS_INTERFACE        ,0    ,&System.sensor_settings.tpms.interface, sizeof(System.sensor_settings.tpms.interface)},
  {VEGA_SETTING_TPMS_POLL_PERIOD      ,0    , &System.sensor_settings.tpms.poll_time_s, sizeof(System.sensor_settings.tpms.poll_time_s)},
#endif //TPMS_PRESENT

#if defined(TOUCHPRINT_PRESENT)
  {VEGA_SETTING_TOUCHPRINT_INTERFACE    ,0    , &System.sensor_settings.touchprint.interface, sizeof(System.sensor_settings.touchprint.interface)},
#endif //TOUCHPRINT_PRESENT

#if defined(IBOX_PRESENT)
  {VEGA_SETTING_IBOX_INTERFACE    ,0    , &System.sensor_settings.ibox.interface, sizeof(System.sensor_settings.ibox.interface)},
#endif //IBOX_PRESENT

#if defined(VOICE_CALL_PRESENT)
  {VEGA_SETTING_VOICE_CALL ,0 , &System.voicecall_settings.spk_volume,           sizeof(System.voicecall_settings.spk_volume)},
  {VEGA_SETTING_VOICE_CALL ,1 , &System.voicecall_settings.mic_gain,             sizeof(System.voicecall_settings.mic_gain)},
  {VEGA_SETTING_VOICE_CALL ,2 , &System.voicecall_settings.allow_all_incoming,   sizeof(System.voicecall_settings.allow_all_incoming)},
#endif //VOICE_CALL_PRESENT

#if defined(FLOWMETER_PRESENT)
  {VEGA_SETTING_FLOWMETER_INTERFACE  ,0    , &System.sensor_settings.flowmeter.interface, sizeof(System.sensor_settings.flowmeter.interface)},
  {VEGA_SETTING_FLOWMETER_ADDRESS  ,0    , &System.sensor_settings.flowmeter.addr, sizeof(System.sensor_settings.flowmeter.addr)},
#endif //FLOWMETER_PRESENT

#if defined(CARRIER_PRESENT)
  {VEGA_SETTING_CARRIER_INTERFACE  ,0    , &System.sensor_settings.carrier.interface, sizeof(System.sensor_settings.carrier.interface)},
  {VEGA_SETTING_CARRIER_TYPE  ,0    , &System.sensor_settings.carrier.type, sizeof(System.sensor_settings.carrier.type)},
#endif //CARRIER_PRESENT

#if defined(MDAS9_PRESENT)
  {VEGA_SETTING_MDAS9_INTERFACE   ,0    , &System.sensor_settings.mdas9.interface, sizeof(System.sensor_settings.mdas9.interface)},
#endif //MDAS9_PRESENT

#if defined(MDSM7_PRESENT)
  {VEGA_SETTING_MDSM7_INTERFACE   ,0    , &System.sensor_settings.mdsm7.interface, sizeof(System.sensor_settings.mdsm7.interface)},
#endif //MDSM7_PRESENT

#if defined(OMNICOMM_ICON_PRESENT)
  {VEGA_SETTING_OMNICOMM_ICON    ,0     , &System.sensor_settings.omnicomm.interface, sizeof(System.sensor_settings.omnicomm.interface)},
#endif //OMNICOMM_ICON_PRESENT

#if defined(RS232_2_PRESENT)
  {VEGA_SETTING_RS232_2   ,0    , &System.sensor_settings.rs232_2.assign, sizeof(System.sensor_settings.rs232_2.assign)},
  {VEGA_SETTING_USE_READ_PARAM   ,0    , &System.sensor_settings.rs232_2.read_param, sizeof(System.sensor_settings.rs232_2.read_param)},
  {VEGA_SETTING_USE_SET_PARAM    ,0    , &System.sensor_settings.rs232_2.set_param, sizeof(System.sensor_settings.rs232_2.set_param)},
  {VEGA_SETTING_USE_SET_REFRIDGE ,0    , &System.sensor_settings.rs232_2.set_ref, sizeof(System.sensor_settings.rs232_2.set_ref)},
#endif //RS232_2_PRESENT

#if defined(HUM_SENSOR_IAKM_PRESENT)
  {VEGA_SETTING_HUM_SENSOR_IAKM_INTERFACE  ,0    , &System.sensor_settings.hum_iakm.interface, sizeof(System.sensor_settings.hum_iakm.interface)},
  {VEGA_SETTING_HUM_SENSOR_IAKM_ADDRESS  ,0    , &System.sensor_settings.hum_iakm.addr, sizeof(System.sensor_settings.hum_iakm.addr)},
#endif //HUM_SENSOR_IAKM_PRESENT

#if defined(SCD30_PRESENT)
  {VEGA_SETTING_SCD30_INTERFACE  ,0    , &System.sensor_settings.scd30.interface, sizeof(System.sensor_settings.scd30.interface)},
#endif //SCD30_PRESENT

#if defined(ADJ_SLEEP_MODE_PRESENT)
  {VEGA_SETTING_VOLTAGE_TRESHOLD  ,0    , &System.sensor_settings.adj_sleep.voltage, sizeof(System.sensor_settings.adj_sleep.voltage)},
  {VEGA_SETTING_TIMER_SLEEPING_MODE  ,0 , &System.sensor_settings.adj_sleep.timer, sizeof(System.sensor_settings.adj_sleep.timer)},
#endif //ADJ_SLEEP_MODE_PRESENT

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
  {VEGA_SETTING_CAN_CUSTOM_SENSORS_GROUP_NAME, 0 , &System.canCustomSettingsGroupName, sizeof(System.canCustomSettingsGroupName)},
#if defined(TRANS_CUSTOM_CAN_SENSORS_PRESENT)
  {VEGA_SETTING_CAN_CUSTOM_SENSORS_TRANS_TABLE, 0, &System.canCustomSensorsTransIdTable, sizeof(System.canCustomSensorsTransIdTable)},
#endif //defined(TRANS_CUSTOM_CAN_SENSORS_PRESENT)
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CAN_RS485_UNITED_PRESENT)
  {VEGA_SETTING_CAN_EXTENDED_MODE, 0, &System.use_can_as_rs485_setting, sizeof(System.use_can_as_rs485_setting)},
#endif //defined(CAN_RS485_UNITED_PRESENT)

#if defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
  {VEGA_SETTING_CANLOG_V4_CUSTOM_SENSORS_EXT, 0, &System.canlogv4CustomSettingsGroupName, sizeof(System.canlogv4CustomSettingsGroupName)},
#endif //defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)

#if defined(EXTERNAL_BLE_BOARD_PRESENT)
  {VEGA_SETTING_BLE_EXT_BOARD, 0 , &System.ext_board_ble_settings.ble_name, sizeof(System.ext_board_ble_settings.ble_name)},
  {VEGA_SETTING_BLE_EXT_BOARD, 1 , &System.ext_board_ble_settings.ble_passkey, sizeof(System.ext_board_ble_settings.ble_passkey)},
  {VEGA_SETTING_BLE_EXT_BOARD, 2 , &System.ext_board_ble_settings.ble_min_security_conn_level, sizeof(System.ext_board_ble_settings.ble_min_security_conn_level)},
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

#if defined(DM5002X_MANOMETR_PRESENT)
  {VEGA_SETTING_DM5002X, 0 , &System.dm5002x_interface_setting, sizeof(System.dm5002x_interface_setting)},
#endif //defined(DM5002X_MANOMETR_PRESENT)

#if defined(BASE_STATION_BT_PRESENT)
  {VEGA_SETTING_BS_BT, 0 , &System.bs_bt_interface_setting, sizeof(System.bs_bt_interface_setting)},
  {VEGA_SETTING_BS_BT, 1 , &System.mac_bt_sensor[0], sizeof(System.mac_bt_sensor[0])},
  {VEGA_SETTING_BS_BT, 2 , &System.mac_bt_sensor[1], sizeof(System.mac_bt_sensor[1])},
  {VEGA_SETTING_BS_BT, 3 , &System.mac_bt_sensor[2], sizeof(System.mac_bt_sensor[2])},
  {VEGA_SETTING_BS_BT, 4 , &System.mac_bt_sensor[3], sizeof(System.mac_bt_sensor[3])},
  {VEGA_SETTING_BS_BT, 5 , &System.mac_bt_sensor[4], sizeof(System.mac_bt_sensor[4])},
  {VEGA_SETTING_BS_BT, 6 , &System.mac_bt_sensor[5], sizeof(System.mac_bt_sensor[5])},
  {VEGA_SETTING_BS_BT, 7 , &System.mac_bt_sensor[6], sizeof(System.mac_bt_sensor[6])},
  {VEGA_SETTING_BS_BT, 8 , &System.mac_bt_sensor[7], sizeof(System.mac_bt_sensor[7])},
  {VEGA_SETTING_BS_BT, 9 , &System.mac_bt_sensor[8], sizeof(System.mac_bt_sensor[8])},
  {VEGA_SETTING_BS_BT, 10 , &System.mac_bt_sensor[9], sizeof(System.mac_bt_sensor[9])},
  {VEGA_SETTING_BS_BT, 11 , &System.mac_bt_sensor[10], sizeof(System.mac_bt_sensor[10])},
  {VEGA_SETTING_BS_BT, 12 , &System.mac_bt_sensor[11], sizeof(System.mac_bt_sensor[11])},
  {VEGA_SETTING_BS_BT, 13 , &System.mac_bt_sensor[12], sizeof(System.mac_bt_sensor[12])},
  {VEGA_SETTING_BS_BT, 14 , &System.mac_bt_sensor[13], sizeof(System.mac_bt_sensor[13])},
  {VEGA_SETTING_BS_BT, 15 , &System.mac_bt_sensor[14], sizeof(System.mac_bt_sensor[14])},
  {VEGA_SETTING_BS_BT, 16 , &System.mac_bt_sensor[15], sizeof(System.mac_bt_sensor[15])},
  {VEGA_SETTING_BS_BT, 17 , &System.mac_bt_sensor[16], sizeof(System.mac_bt_sensor[16])},
  {VEGA_SETTING_BS_BT, 18 , &System.mac_bt_sensor[17], sizeof(System.mac_bt_sensor[17])},
  {VEGA_SETTING_BS_BT, 19 , &System.mac_bt_sensor[18], sizeof(System.mac_bt_sensor[18])},
  {VEGA_SETTING_BS_BT, 20 , &System.mac_bt_sensor[19], sizeof(System.mac_bt_sensor[19])},
  {VEGA_SETTING_BS_BT, 21 , &System.mac_bt_sensor[20], sizeof(System.mac_bt_sensor[20])},
  {VEGA_SETTING_BS_BT, 22 , &System.mac_bt_sensor[21], sizeof(System.mac_bt_sensor[21])},
  {VEGA_SETTING_BS_BT, 23 , &System.mac_bt_sensor[22], sizeof(System.mac_bt_sensor[22])},
  {VEGA_SETTING_BS_BT, 24 , &System.mac_bt_sensor[23], sizeof(System.mac_bt_sensor[23])},
  {VEGA_SETTING_BS_BT, 25 , &System.mac_bt_sensor[24], sizeof(System.mac_bt_sensor[24])},
  {VEGA_SETTING_BS_BT, 26 , &System.mac_bt_sensor[25], sizeof(System.mac_bt_sensor[25])},
  {VEGA_SETTING_BS_BT, 27 , &System.mac_bt_sensor[26], sizeof(System.mac_bt_sensor[26])},
  {VEGA_SETTING_BS_BT, 28 , &System.mac_bt_sensor[27], sizeof(System.mac_bt_sensor[27])},
  {VEGA_SETTING_BS_BT, 29 , &System.mac_bt_sensor[28], sizeof(System.mac_bt_sensor[28])},
  {VEGA_SETTING_BS_BT, 30 , &System.mac_bt_sensor[29], sizeof(System.mac_bt_sensor[29])},
  {VEGA_SETTING_BS_BT, 31 , &System.mac_bt_sensor[30], sizeof(System.mac_bt_sensor[30])},
  {VEGA_SETTING_BS_BT, 32 , &System.mac_bt_sensor[31], sizeof(System.mac_bt_sensor[31])},
  {VEGA_SETTING_BS_BT, 33 , &System.mac_bt_sensor[32], sizeof(System.mac_bt_sensor[32])},
  {VEGA_SETTING_BS_BT, 34 , &System.mac_bt_sensor[33], sizeof(System.mac_bt_sensor[33])},
  {VEGA_SETTING_BS_BT, 35 , &System.mac_bt_sensor[34], sizeof(System.mac_bt_sensor[34])},
  {VEGA_SETTING_BS_BT, 36 , &System.mac_bt_sensor[35], sizeof(System.mac_bt_sensor[35])},
  {VEGA_SETTING_BS_BT, 37 , &System.mac_bt_sensor[36], sizeof(System.mac_bt_sensor[36])},
  {VEGA_SETTING_BS_BT, 38 , &System.mac_bt_sensor[37], sizeof(System.mac_bt_sensor[37])},
  {VEGA_SETTING_BS_BT, 39 , &System.mac_bt_sensor[38], sizeof(System.mac_bt_sensor[38])},
  {VEGA_SETTING_BS_BT, 40 , &System.mac_bt_sensor[39], sizeof(System.mac_bt_sensor[39])},
  {VEGA_SETTING_BS_BT, 41 , &System.mac_bt_sensor[40], sizeof(System.mac_bt_sensor[40])},
  {VEGA_SETTING_BS_BT, 42 , &System.mac_bt_sensor[41], sizeof(System.mac_bt_sensor[41])},
  {VEGA_SETTING_BS_BT, 43 , &System.mac_bt_sensor[42], sizeof(System.mac_bt_sensor[42])},
  {VEGA_SETTING_BS_BT, 44 , &System.mac_bt_sensor[43], sizeof(System.mac_bt_sensor[43])},
  {VEGA_SETTING_BS_BT, 45 , &System.mac_bt_sensor[44], sizeof(System.mac_bt_sensor[44])},
  {VEGA_SETTING_BS_BT, 46 , &System.mac_bt_sensor[45], sizeof(System.mac_bt_sensor[45])},
  {VEGA_SETTING_BS_BT, 47 , &System.mac_bt_sensor[46], sizeof(System.mac_bt_sensor[46])},
  {VEGA_SETTING_BS_BT, 48 , &System.mac_bt_sensor[47], sizeof(System.mac_bt_sensor[47])},
  {VEGA_SETTING_BS_BT, 49 , &System.mac_bt_sensor[48], sizeof(System.mac_bt_sensor[48])},
  {VEGA_SETTING_BS_BT, 50 , &System.mac_bt_sensor[49], sizeof(System.mac_bt_sensor[49])},
#endif //defined(BASE_STATION_BT_PRESENT)

#if defined(MODEM_BT_PRESENT)
  {VEGA_SETTINGS_GSM_MODEM, 0 , &System.modem_bt_settings, sizeof(System.modem_bt_settings)}, //Общие настройки BT модема
#endif //defined(MODEM_BT_PRESENT)

#if defined(BLE_SENSORS_PRESENT)
#if (MAX_BLE_SENSORS_COUNT > 0)
  {VEGA_SETTINGS_BLE_SENSORS,  0,  &System.ble_sensor_settings[0], sizeof(System.ble_sensor_settings[0])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 1)
  {VEGA_SETTINGS_BLE_SENSORS,  1,  &System.ble_sensor_settings[1], sizeof(System.ble_sensor_settings[1])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 2)
  {VEGA_SETTINGS_BLE_SENSORS,  2,  &System.ble_sensor_settings[2], sizeof(System.ble_sensor_settings[2])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 3)
  {VEGA_SETTINGS_BLE_SENSORS,  3,  &System.ble_sensor_settings[3], sizeof(System.ble_sensor_settings[3])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 4)
  {VEGA_SETTINGS_BLE_SENSORS,  4,  &System.ble_sensor_settings[4], sizeof(System.ble_sensor_settings[4])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 5)
  {VEGA_SETTINGS_BLE_SENSORS,  5,  &System.ble_sensor_settings[5], sizeof(System.ble_sensor_settings[5])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 6)
  {VEGA_SETTINGS_BLE_SENSORS,  6,  &System.ble_sensor_settings[6], sizeof(System.ble_sensor_settings[6])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 7)
  {VEGA_SETTINGS_BLE_SENSORS,  7,  &System.ble_sensor_settings[7], sizeof(System.ble_sensor_settings[7])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 8)
  {VEGA_SETTINGS_BLE_SENSORS,  8,  &System.ble_sensor_settings[8], sizeof(System.ble_sensor_settings[8])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 9)
  {VEGA_SETTINGS_BLE_SENSORS,  9,  &System.ble_sensor_settings[9], sizeof(System.ble_sensor_settings[9])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 10)
  {VEGA_SETTINGS_BLE_SENSORS,  10, &System.ble_sensor_settings[10], sizeof(System.ble_sensor_settings[10])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 11)
  {VEGA_SETTINGS_BLE_SENSORS,  11, &System.ble_sensor_settings[11], sizeof(System.ble_sensor_settings[11])},
#endif
#if (MAX_BLE_SENSORS_COUNT > 12)
#error
#endif
#endif //defined(BLE_SENSORS_PRESENT)

#if defined(THERMALMASTER_PRESENT)
  {VEGA_SETTING_THERMALMASTER_INTERFACE, 0 , &System.sensor_settings.thermalmaster.interface, sizeof(System.sensor_settings.thermalmaster.interface)},
#endif //defined(THERMALMASTER_PRESENT)

#if defined(IMMO_FLANKER_PRESENT)
  {VEGA_SETTING_IMMO_FLANKER_SETTINGS, 0 , &System.immoFlankerSettings, sizeof(System.immoFlankerSettings)},
#endif //defined(IMMO_FLANKER_PRESENT)

#if defined(RS_TACHO_PRESENT)
  {VEGA_SETTING_RS_TACHO_SETTINGS, 0 , &System.tacho_settings, sizeof(System.tacho_settings)},
#endif //defined(RS_TACHO_PRESENT)

#if defined(SAVER2021_PRESENT)
  {VEGA_SETTING_SAVER_SETTINGS, 0 , &System.saver_settings, sizeof(System.saver_settings)},
#endif //defined(SAVER2021_PRESENT)

#if defined(TOUCHPRINT_PRESENT)
  {VEGA_SETTING_TOUCHPRINT_INTERFACE    ,0    , &System.sensor_settings.touchprint.interface, sizeof(System.sensor_settings.touchprint.interface)},
#endif //TOUCHPRINT_PRESENT

#if defined(ZANOTTI_MODBUS_PRESENT)
  {VEGA_SETTING_ZANOTTI_INTERFACE    ,0    , &System.sensor_settings.zanotti.interface, sizeof(System.sensor_settings.zanotti.interface)},
#endif //ZANOTTI_MODBUS_PRESENT

#if defined(SR3_PRESENT)
  {VEGA_SETTING_SR3_INTERFACE    ,0    , &System.sensor_settings.sr3.interface, sizeof(System.sensor_settings.sr3.interface)},
#endif //SR3_PRESENT
  {VEGA_MAIN_YANDEX_SERVER_ID           ,0    , &System.connection_settings.main_yandex_server_id, sizeof(System.connection_settings.main_yandex_server_id)},
};

#ifndef __ICCARM__
const uint16_t CSystem::add_sensor_table_size = (sizeof(sensor_table_add)/sizeof(TSensor_table_add));
#endif

// Общее количество датчиков в системе
const uint16_t CSystem::Total_sensor_count = (sizeof(sensor_table)/sizeof(TSensor_table));
// Общее количество настроек в системе
const uint16_t CSystem::Total_settings_count = (sizeof(settings_table)/sizeof(TSettings_table));

#ifdef __ICCARM__
  const uint8_t CSystem::sim_count = MAX_SIM_COUNT;

  const uint8_t CSystem::din_count = MAX_DIGITAL_INPUTS;
  const uint8_t CSystem::fin_count = MAX_FREQ_INPUTS;
  const uint8_t CSystem::pin_count = MAX_PULSE_INPUTS;
  const uint8_t CSystem::ain_count = MAX_ANALOG_INPUTS;

  const uint8_t CSystem::mfi_count = MAX_MF_INPUTS;

  const uint8_t CSystem::dout_count = MAX_DIGITAL_OUTPUTS;
  const uint8_t CSystem::aout_count = MAX_ANALOG_OUTPUTS;

  #if defined(BR_PRESENT)
  const uint8_t CSystem::ext_mfi_count = MAX_EXT_MF_INPUTS;
  const uint8_t CSystem::ext_dout_count = MAX_EXT_DIGITAL_OUTPUTS;
  #endif //BR_PRESENT

  const uint8_t CSystem::fout_count = MAX_FREQ_OUTPUTS;
  const uint8_t CSystem::dut_count = MAX_DUTS;
  const uint8_t CSystem::dallas_tm_count = MAX_AUTORIZED_KEYS;
  const uint8_t CSystem::dallas_temp_count = MAX_DALLAS_TEMP_SENSORS;
  const uint8_t CSystem::phones_count = MAX_AUTORIZED_PHONES;
  const uint8_t CSystem::geozones_count = MAX_GEOZONES;
  const uint8_t CSystem::scenaries_count = MAX_SCENARIES;
  const uint8_t CSystem::tampers_count = MAX_TAMPERS;
  const uint8_t CSystem::servers_count = MAX_SERVERS_COUNT;
  #if defined(IRIDIUM_PRESENT)
  const uint8_t CSystem::scenaries_count_i = MAX_SCENARIES_I;
  #endif //IRIDIUM_PRESENT
  #if defined(NRF_BEACONS_SCANNER_PRESENT)
  const uint16_t CSystem::nrf_beacons_count = MAX_NRF_AUTORIZED_BEACONS_COUNT;
  #else
  const uint16_t CSystem::nrf_beacons_count = 0;
  #endif //NRF_BEACONS_SCANNER_PRESENT

  #if defined(CUSTOM_CAN_SENSORS_PRESENT)
  const uint8_t CSystem::custom_can_sensors_count = MAX_CUSTOM_CAN_SENSORS_COUNT;
  const uint8_t CSystem::custom_can_sensors_settnigs_number = MAX_CUSTOM_CAN_SENSORS_COUNT;
  const uint8_t CSystem::stm_can_modul_count = MAX_CAN_INTERFACES;
  const uint8_t CSystem::can_custom_sensors_setting_version = CUSTOM_CAN_SENSORS_SETTINGS_VERSION;
  const uint8_t CSystem::can_isotp_sensors_setting_version = ISOTP_CAN_SENSORS_SETTINGS_VERSION;
  const uint8_t CSystem::can_tx_script_count_count = MAX_CAN_TX_SCRIPT_COUNT;
  const uint8_t CSystem::isotp_can_sensors_count = MAX_ISOTP_CAN_SENSORS_SETTINGS_COUNT;
  #endif //(CUSTOM_CAN_SENSORS_PRESENT)

  #if defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
  const uint8_t CSystem::custom_canlogv4_sensors_count=MAX_CUSTOM_CAN_SENSORS_COUNT;
  const uint8_t CSystem::custom_canlogv4_sensors_settings_number=MAX_CUSTOM_CAN_SENSORS_COUNT;
  #endif //defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)

  #if defined(BLE_SENSORS_PRESENT)
  const uint8_t CSystem::ble_sensors_count = MAX_BLE_SENSORS_COUNT;
  #endif //defined(BLE_SENSORS_PRESENT)
#endif

/* C++ code-------------------------------------------------------------------*/
// Конструктор
CSystem::CSystem(void)
{
  // Создание семафора
#ifdef USE_FREERTOS
  this->busy = xSemaphoreCreateMutex();
  #ifdef DEBUG
  vQueueAddToRegistry(this->busy, "settings_busy");
  #endif
#endif
  this->first_start = 0;
  this->settings_version = 1;

#ifdef __ICCARM__
  #if (!defined(IS_ADVANTUM_MT2X_DATACOLD_BUILD)&&(DEVICE_TYPE != DEVICE_TYPE_VEGA_NT_10)&&(!defined(IS_BEACON_LORA_BUILD)))
  this->Board_hw_version=__get_board_hw_version();
  #endif
#endif

#ifdef __ICCARM__
  System.settings_info.counter=1;
  System.settings_info.crc=crc32_fast_full((const uint8_t*)&System.settings_info.counter, sizeof(System.settings_info.counter));
#endif

#ifndef __ICCARM__
    can_present = 0;

    canV4_present = 0;
    canv4_conections_flags_present = 0;
    canv4_security_flags_present = 0;
    canv4_state_flags_present = 0;
    canv4_indicators_flags_present = 0;
    canv4_agricultural_vehicles_present = 0;
    canv4_utility_vehicles_present = 0;
    canv4_cistern_flags_present = 0;
    canv4_numeric_data_present = 0;
    canv4_agr_numeric_present = 0;
    canv4_tacho_present = 0;

    autorization_present = 0;
    gsensor_present = 0;
    motohours_present = 0;
    camera_present = 0;
    alarm_button_present = 0;
    ignition_present = 0;
    internal_akb_present = 0;
    internal_akb_charge_level_present = 0;
    can_agro_present = 0;
    can_guard_present = 0;
    can_numeric_present = 0;
    can_dash_present = 0;
    mfi_present = 0;
    inertial_navigation_present = 0;
    ext_mfi_count = 0;
    ext_dout_count = 0;
    ext_br_present = false;
    fridge_present = false;
    nrf_beacons_present = false;
    tenzo_m_present = false;
    iqfreeze_present = false;
    ibox_present = false;
    pv310_present = false;
    flowmeter_present = false;
    security_settings.pin[0] = 0;
    tpms_present = false;
    iridium_present = false;
    carrier_present = false;
    mdas9_present = false;
    can_man_present = 0;
    custom_cansensor_present = 0;
    alarm_button_timeout_present = false;
    nt_present = false;
    modem_bt_present = false;
    modem_ble_present = false;
    ble_sensors_present = false;
    mdsm7_present = false;
    icon_present = false;
    thermalmaster_present = false;
    rs_tacho_present = false;
    zanotti_present = false;
    sr3_present = false;
#endif

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
  for(uint16_t i=0; i<MAX_CUSTOM_CAN_SENSORS_COUNT; i++)
  {
    canCustomSensorsSettings[i].version=1;
    canCustomSensorsSettings[i].type=0;
    canCustomSensorsSettings[i].can_id_type=EMPTY_ID_TYPE;
    canCustomSensorsSettings_shadow[i].version=1;
    canCustomSensorsSettings_shadow[i].type=0;
    canCustomSensorsSettings_shadow[i].can_id_type=EMPTY_ID_TYPE;
  }

  for(uint16_t i=0; i<MAX_ISOTP_CAN_SENSORS_SETTINGS_COUNT; i++)
  {
    IsoTpCanSensorsSettings[i].version=0;
    IsoTpCanSensorsSettings[i].type=0;
    IsoTpCanSensorsSettings[i].can_id_type=EMPTY_ID_TYPE;
    IsoTpCanSensorsSettings_shadow[i].version=0;
    IsoTpCanSensorsSettings_shadow[i].type=0;
    IsoTpCanSensorsSettings_shadow[i].can_id_type=EMPTY_ID_TYPE;
  }

  for(uint16_t i=0; i<sizeof(System.canCustomSensors_bad_crc_bf)/sizeof(System.canCustomSensors_bad_crc_bf[0]); i++)
  {
    System.canCustomSensors_bad_crc_bf[i]=0;
  }

  for(uint16_t i=0; i<sizeof(System.IsoTpcanCustomSensors_bad_crc_bf)/sizeof(System.IsoTpcanCustomSensors_bad_crc_bf[0]); i++)
  {
    System.IsoTpcanCustomSensors_bad_crc_bf[i]=0;
  }

#if defined(CUSTOM_CAN_SENSORS_TRANS_TABLE_PRESENT)
  memset(&canCustomSensorsTransIdTable, 0, sizeof(canCustomSensorsTransIdTable));
#endif //defined(CUSTOM_CAN_SENSORS_TRANS_TABLE_PRESENT)
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
  for(uint16_t i=0; i<MAX_CUSTOM_CAN_SENSORS_COUNT; i++)
  {
    memset(&canlogv4CustomSensorsSettings[i], 0, sizeof(canlogv4CustomSensorsSettings[i]));
  }
#endif //defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
}

#ifdef USE_FREERTOS
// Захватить состояние системы
bool CSystem::Grab(TickType_t xTicksToWait)
{
  if(xSemaphoreTake(this->busy, xTicksToWait)) return true;
  else                                         return false;
}

// Отпустить состояние системы
void CSystem::Release(void)
{
  xSemaphoreGive(this->busy);
}
#endif

// Найти датчик
uint8_t CSystem::Find_sensor(uint16_t sensor_id,
                             const char** sensor_name,
                             void** sensor_data_address,
#ifndef __ICCARM__
                             void** sensor_bckp_address,
#endif
                             TSensor_data_type* data_type,
                             uint16_t* egts_param_id) const
{
  static bool is_sensor_table_sorted = System.Is_sensor_table_sorted(false);

#ifdef __ICCARM__
  if(true)
  {
    static uint8_t dummy=0;
    if(sensor_id==VEGA_MESSAGE_SRC_EVENT)
    {
      if(NULL!=sensor_name)             *sensor_name = "p25";
      if(NULL!=sensor_data_address)     *sensor_data_address = &dummy;
      if(NULL!=data_type)               *data_type = UINT8_SYSTEM_T;
      if(NULL!=egts_param_id)           *egts_param_id = 0xFFFF;

      return sizeof(dummy);
    }
    else if(sensor_id==VEGA_CMD_TEXT_ANS)
    {
      if(NULL!=sensor_name)             *sensor_name = "cmd";
      if(NULL!=sensor_data_address)     *sensor_data_address = &dummy;
      if(NULL!=data_type)               *data_type = STRING_SYSTEM_T;
      if(NULL!=egts_param_id)           *egts_param_id = 0xFFFF;

      return sizeof(dummy);
    }
    else if(sensor_id==VEGA_PROMASAT_SERVICE)
    {
      if(NULL!=sensor_name)             *sensor_name = "service";
      if(NULL!=sensor_data_address)     *sensor_data_address = &dummy;
      if(NULL!=data_type)               *data_type = STRING_SYSTEM_T;
      if(NULL!=egts_param_id)           *egts_param_id = 0xFFFF;

      return sizeof(dummy);
    }
  }
#endif

  if(is_sensor_table_sorted)
  {
    return Find_sensor_fast(&sensor_id, sensor_name, sensor_data_address,
#ifndef __ICCARM__
                            sensor_bckp_address,
#endif
                            data_type, egts_param_id);
  }
  else
  {
    for(uint16_t i = 0; i < Total_sensor_count; i++)
    {
      if(sensor_table[i].id == sensor_id)
      {
#ifdef __ICCARM__
#if defined(TINY_FLASH_SYSTEM_PRESENT)
      if(NULL!=sensor_name)               *sensor_name = Get_tiny_flash_wips_name(&sensor_id);
#else
      if(NULL!=sensor_name)               *sensor_name = sensor_table[i].name;
#endif //defined(TINY_FLASH_SYSTEM_PRESENT)
#else
        if(NULL!=sensor_name)             *sensor_name = sensor_table_add[i].rus_name;
#endif

        if(NULL!=sensor_data_address)     *sensor_data_address = sensor_table[i].ptr;

#ifndef __ICCARM__
        if(NULL!=sensor_bckp_address)     *sensor_bckp_address = sensor_table[i].ptr_bkp;
#endif

        if(NULL!=data_type)               *data_type = sensor_table[i].data_type;
#if defined(TINY_FLASH_SYSTEM_PRESENT)
        if(NULL!=egts_param_id)           *egts_param_id = 0xFFFF;
#else
        if(NULL!=egts_param_id)           *egts_param_id = sensor_table[i].egts_param_id;
#endif //defined(TINY_FLASH_SYSTEM_PRESENT)

        return sensor_table[i].size;
      }
    }

    return 0;
  }
}

const char* CSystem::Get_tiny_flash_wips_name(const uint16_t* const sensor_id) const
{
  static char sname[8];

  if(sensor_id[0]==VEGA_HDOP)                  {return "hdop";}
  else if(sensor_id[0]==VEGA_MCC)              {return "mcc";}
  else if(sensor_id[0]==VEGA_MNC)              {return "mnc";}
  else if(sensor_id[0]==VEGA_LAC)              {return "lac";}
  else if(sensor_id[0]==VEGA_CELLID)           {return "cell_id";}
  else if(sensor_id[0]==VEGA_PROMASAT_SERVICE) {return "service";}

  snprintf(sname, sizeof(sname), "p%hu", sensor_id[0]);

  return sname;
}

// Найти датчик. Быстрый поиск в отсортированной таблице
uint8_t CSystem::Find_sensor_fast(const uint16_t* const sensor_id,
                             const char** sensor_name,
                             void** sensor_data_address,
#ifndef __ICCARM__
                             void** sensor_bckp_address,
#endif
                             TSensor_data_type* data_type,
                             uint16_t* egts_param_id) const
{
  int32_t left = 0;
  int32_t right = Total_sensor_count - 1;

  for(;;)//(uint16_t j = 0; j < Total_sensor_count; j++)
  {
    if(left > right)
    {
      break; //значение не найдено
    }

    int32_t i = left + (right - left) / 2;

    if(sensor_table[i].id < sensor_id[0])
    {
      left = i + 1;
    }

    if(sensor_table[i].id > sensor_id[0])
    {
      right = i - 1;
    }

    if(sensor_table[i].id == sensor_id[0])
    {
#ifdef __ICCARM__
#if defined(TINY_FLASH_SYSTEM_PRESENT)
      if(NULL!=sensor_name)             *sensor_name = Get_tiny_flash_wips_name(sensor_id);
#else
      if(NULL!=sensor_name)             *sensor_name = sensor_table[i].name;
#endif //defined(TINY_FLASH_SYSTEM_PRESENT)
#else
      if(NULL!=sensor_name)             *sensor_name = sensor_table_add[i].rus_name;
#endif

      if(NULL!=sensor_data_address)     *sensor_data_address = sensor_table[i].ptr;

#ifndef __ICCARM__
      if(NULL!=sensor_bckp_address)     *sensor_bckp_address = sensor_table[i].ptr_bkp;
#endif

      if(NULL!=data_type)               *data_type = sensor_table[i].data_type;
#if defined(TINY_FLASH_SYSTEM_PRESENT)
      if(NULL!=egts_param_id)           *egts_param_id = 0xFFFF;
#else
      if(NULL!=egts_param_id)           *egts_param_id = sensor_table[i].egts_param_id;
#endif //defined(TINY_FLASH_SYSTEM_PRESENT)

      return sensor_table[i].size;
    }
  }

  return 0;
}

bool CSystem::Find_sensor_fast_self_test(const bool is_verbose)
{
  bool is_pass = true;

  for(uint16_t i = 0; i < Total_sensor_count; i++)
  {
    if(!Find_sensor_fast(&sensor_table[i].id, NULL, NULL,
#ifndef __ICCARM__
                         NULL,
#endif
                         NULL, NULL))
    {
      if(is_verbose)
      {
#ifdef __ICCARM__
        __PRINTF("sensor \"%s\", %u not find!!!\n", sensor_table[i].name, sensor_table[i].id);
#else
        qDebug("sensor \"%s\", %u not find!!!\n", sensor_table[i].name, sensor_table[i].id);
#endif
      }

      is_pass = false;

      if(!is_verbose) break;
    }
  }

  if(is_verbose)
  {
#ifdef __ICCARM__
    __PRINTF("%s result %s\n", __FUNCTION__, (is_pass)?("ok"):("failed"));
#else
    qDebug("%s result %s\n", __FUNCTION__, (is_pass)?("ok"):("failed"));
#endif
  }

  return is_pass;
}

// Проверка на сортировку ID в таблице датчиков
bool CSystem::Is_sensor_table_sorted(const bool is_verbose)
{
  bool is_sorted = true;
  uint16_t sensor_id = sensor_table[0].id;

#ifdef __ICCARM__
  if((const uint32_t)sensor_table>=0x20000000UL)
  {
    if(is_verbose) {__PRINTF("Warning, sensor_table not on flash!\n");}
  }
#endif

  for(uint16_t i = 1; i < Total_sensor_count; i++)
  {
    if(sensor_table[i].id <= sensor_id)
    {
      if(is_verbose)
      {
#ifdef __ICCARM__
        __PRINTF("order err in index %u: \"%s\" %u \"%s\" %u\n", i, sensor_table[i-1].name, sensor_table[i-1].id,
                 sensor_table[i].name, sensor_table[i].id);
#else
        qDebug("order err in index %u: \"%s\" %u \"%s\" %u\n", i, sensor_table[i-1].name, sensor_table[i-1].id,
               sensor_table[i].name, sensor_table[i].id);
#endif
      }

      is_sorted = false;

      if(!is_verbose) break;
    }

    sensor_id = sensor_table[i].id;
  }

  if(is_verbose)
  {
#ifdef __ICCARM__
    __PRINTF("%s result %s\n", __FUNCTION__, (is_sorted)?("true"):("false"));
#else
    qDebug("%s result %s\n", __FUNCTION__, (is_sorted)?("true"):("false"));
#endif
  }

  return is_sorted;
}

// Быстрый поиск в таблице датчиков пользовательского CAN-датчика
uint8_t CSystem::FindCustomCanSensor(const uint16_t sensor_id, void** sensor_data_address, TSensor_data_type* data_type)
{
  (void)sensor_id;
  (void)data_type;

  return 0;
}

uint8_t CSystem::GetSensorTypeSize(const sensor_type_t sensor_type)
{
  switch(sensor_type)
  {
  case UINT8_SYSTEM_T:
  case INT8_SYSTEM_T:
  case BOOL_SYSTEM_T:
    return 1;

  case UINT16_SYSTEM_T:
  case INT16_SYSTEM_T:
    return 2;

  case UINT32_SYSTEM_T:
  case INT32_SYSTEM_T:
  case FLOAT_SYSTEM_T:
    return 4;

  case UINT64_SYSTEM_T:
  case INT64_SYSTEM_T:
  case DOUBLE_SYSTEM_T:
    return 8;

  default:
    return 0;
  }
}

//Коррекция фактического типа и размера пользовательского CAN-датчика на фактический
uint8_t CSystem::FindCustomCanSensorWithCorrectTypeAndSize(const uint16_t sensor_id, TSensor_data_type* data_type)
{
  return 0;
}

//Обнулить настройку передачи пользовательских CAN датчиков для отключенных сенсоров
void CSystem::DisableTranslateSettingForEmtyCanSensors(void)
{
  //
}

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
const can_sensor_setting_v1_t* CSystem::Get_can_sensor_settings_from_index(const uint16_t index)
{
#ifdef __ICCARM__
  return &canCustomSensorsSettings_shadow[index];
#else
  return &canCustomSensorsSettings[index];
#endif
}
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CUSTOM_CAN_SENSORS_PRESENT)
const isotp_can_sensor_setting_t* CSystem::Get_isotp_can_sensor_settings_from_index(const uint16_t index)
{
#ifdef __ICCARM__
  return &IsoTpCanSensorsSettings_shadow[index];
#else
  return &IsoTpCanSensorsSettings[index];
#endif
}
#endif //defined(CUSTOM_CAN_SENSORS_PRESENT)

#if defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
const canlog_v4_custom_sensor_setting_t* CSystem::Get_canlog_v4_custom_sensor_settings_from_index(const uint16_t index)
{
  return &canlogv4CustomSensorsSettings[index];
}
#endif //defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)

#ifndef __ICCARM__
// Найти датчик по английски
uint8_t CSystem::Find_eng_sensor(uint16_t sensor_id,
                                 const char** sensor_name,
                                 void** sensor_data_address,
                                 void** sensor_bckp_address,
                                 TSensor_data_type* data_type,
                                 uint16_t* egts_param_id) const
{
  for(uint16_t i = 0; i < Total_sensor_count; i++)
  {
    if(sensor_table[i].id == sensor_id)
    {
      *sensor_name = sensor_table_add[i].eng_name;
      *sensor_data_address = sensor_table[i].ptr;
      *sensor_bckp_address = sensor_table[i].ptr_bkp;
      *data_type = sensor_table[i].data_type;
      if(egts_param_id) *egts_param_id = sensor_table[i].egts_param_id;
      return sensor_table[i].size;
    }
  }
  return 0;
}
#endif

uint16_t CSystem::Get_custom_can_sensors_trans_id(const uint16_t id)
{
  return id;
}

#ifdef __ICCARM__
#pragma diag_suppress=Pe186
#endif

// Найти настройки
// Возвращает размер настройки (Б), если настройка найдена, 0 - если такой настройки не найдено
// Натройки не отсеиваются признаками наличия сущностей (например, System.alarm_button_present)
uint16_t CSystem::Find_setting(uint16_t setting_id, uint16_t setting_subid, uint8_t** setting_data_address)
{
  // Настройки APN
  if( setting_id == VEGA_SETTING_APN)
  {
    if(setting_subid >= sim_count) return 0;
    *setting_data_address = (uint8_t*)&this->connection_settings.APN[setting_subid];
    return sizeof(this->connection_settings.APN[setting_subid]);
  }
  // Код запроса баланса
  else if( setting_id == VEGA_SETTING_BALANCE_CODE)
  {
    if(setting_subid >= sim_count) return 0;
    *setting_data_address = (uint8_t*)&this->connection_settings.balance_request_settings[setting_subid];
    return sizeof(this->connection_settings.balance_request_settings[setting_subid]);
  }
  // Настройки регулярной трансляции датчиков
  else if( setting_id == VEGA_SETTING_TRANSLATE_SENSORS)
  {
    int16_t sensor_num = -1;
    for(uint16_t i = 0; i < this->Total_sensor_count; i++)
    {
      if(this->sensor_table[i].id == setting_subid) {
          sensor_num = i;
          break;
      }
    }
    if(sensor_num == -1) return 0;
// TODO
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                       // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(!Is_sensor_present(this->sensor_table[sensor_num].id))
        return 0;
#endif
    *setting_data_address = (uint8_t*)&this->connection_settings.regular_translation[sensor_num];
    return sizeof(connection_settings.regular_translation[sensor_num]);
  }

  // Настройки цифровых входов
  else if( setting_id == VEGA_SETTING_DIGITAL_INPUTS)
  {
    if(setting_subid >= din_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.digital_in[setting_subid];
    return sizeof(this->sensor_settings.digital_in[setting_subid]);
  }

  // Настройки импульсных входов
  else if( setting_id == VEGA_SETTING_PULSE_INPUT)
  {
    if(setting_subid >= pin_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.pulse_in[setting_subid];
    return sizeof(this->sensor_settings.pulse_in[setting_subid]);
  }

  // Настройки частотных входов
  else if( setting_id == VEGA_SETTING_FREQ_INPUT)
  {
    if(setting_subid >= fin_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.freq_in[setting_subid];
    return sizeof(this->sensor_settings.freq_in[setting_subid]);
  }

  // Настройки мультифункциональных входов
  else if( setting_id == VEGA_SETTING_MFI)
  {
    if(setting_subid >= mfi_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.mfi[setting_subid];
    return sizeof(this->sensor_settings.mfi[setting_subid]);
  }

  // Настройки частотных выходов
#if (MAX_FREQ_OUTPUTS > 0)
  else if( setting_id == VEGA_SETTING_FREQ_OUTPUT)
  {
    if(setting_subid >= fout_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.freq_out[setting_subid];
    return sizeof(this->sensor_settings.freq_out[setting_subid]);
  }
#endif //(MAX_FREQ_OUTPUTS > 0)

  // Настройки ДУТов
  else if( setting_id == VEGA_SETTING_FUEL_LEVEL)
  {
    if(setting_subid >= dut_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.dut[setting_subid];
    return sizeof(this->sensor_settings.dut[setting_subid]);
  }
#if (MAX_DALLAS_TEMP_SENSORS > 0)
  // Внешние датчики температуры
  else if( setting_id == VEGA_SETTING_EXT_TEMP)
  {
    if(setting_subid >= dallas_temp_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.ext_temp[setting_subid];
    return sizeof(this->sensor_settings.ext_temp[setting_subid]);
  }
#endif
  // Геозоны
  else if( setting_id == VEGA_SETTING_GEOZONE)
  {
    if(setting_subid >= geozones_count) return 0;
    *setting_data_address = (uint8_t*)&this->geozone_settings.geozone[setting_subid];
    return sizeof(this->geozone_settings.geozone[setting_subid]);
  }

  // Авторизованные телефоны
  else if( setting_id == VEGA_SETTING_AUTORIZED_PHONE)
  {
    if(setting_subid >= phones_count) return 0;
    *setting_data_address = (uint8_t*)this->security_settings.autorized_phones[setting_subid];
    return sizeof(this->security_settings.autorized_phones[setting_subid]);
  }
  // Авторизованные ключи
  else if( setting_id == VEGA_SETTING_AUTORIZED_KEY)
  {
    if(setting_subid >= dallas_tm_count) return 0;
    *setting_data_address = this->security_settings.autorized_keys[setting_subid];
    return sizeof(this->security_settings.autorized_keys[setting_subid]);
  }
  // Сценарии
  else if( setting_id == VEGA_SETTING_SCENARIES)
  {
    if(setting_subid >= scenaries_count) return 0;
    *setting_data_address = (uint8_t*)&this->scenario_settings.scenario[setting_subid];
    return sizeof(this->scenario_settings.scenario[setting_subid]);
  }
  // Сценарии IRIDIUM
#if defined(IRIDIUM_PRESENT)
  else if( setting_id == VEGA_SETTING_SCENARIES_I)
  {
    if(setting_subid >= scenaries_count_i) return 0;
    *setting_data_address = (uint8_t*)&this->scenario_settings_i.scenario_i[setting_subid];
    return sizeof(this->scenario_settings_i.scenario_i[setting_subid]);
  }
#endif //IRIDIUM_PRESENT
  // CAN
#if defined(CANPRO_PRESENT) ||  defined(CANLOG_V4_PRESENT)
  else if( setting_id == VEGA_SETTING_CAN)
  {
    #ifndef __ICCARM__
    if(!(this->can_present || this->canV4_present))
    {
        return 0;
    }
    if(setting_subid>0) return 0;
    #endif
    *setting_data_address = (uint8_t*)&this->can_settings;
    return sizeof(this->can_settings);
  }
#endif  //CANPRO_PRESENT || CANLOG_V4_PRESENT
  // Сброс одометра
  else if( setting_id == VEGA_GPS_ODOMETER)
  {
// TODO
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->gnss_state.odometer;
    return sizeof(gnss_state.odometer);
  }
  // Сброса счетчика поездок
  else if( setting_id == VEGA_TRIP_COUNTER)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->gnss_state.trip_counter;
    return sizeof(gnss_state.trip_counter);
  }
  // Сброса счетчика моточасов
  else if( setting_id == VEGA_MOTOHOURS)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->signal_state.motohours;
    return sizeof(signal_state.motohours);
  }
  // Сброса счетчика трафика 1
  else if( setting_id == VEGA_TX_DATA_SERV1)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[0].tx;
    return sizeof(server_state.traffic_counter[0].tx);
  }
  else if( setting_id == VEGA_RX_DATA_SERV1)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[0].rx;
    return sizeof(server_state.traffic_counter[0].rx);
  }
  // Сброса счетчика трафика 2
  else if( setting_id == VEGA_TX_DATA_SERV2)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[1].tx;
    return sizeof(server_state.traffic_counter[1].tx);
  }
  else if( setting_id == VEGA_RX_DATA_SERV2)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[1].rx;
    return sizeof(server_state.traffic_counter[1].rx);
  }
  // Сброса счетчика трафика 3
  else if( setting_id == VEGA_TX_DATA_SERV3)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[2].tx;
    return sizeof(server_state.traffic_counter[2].tx);
  }
  else if( setting_id == VEGA_RX_DATA_SERV3)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[2].rx;
    return sizeof(server_state.traffic_counter[2].rx);
  }
  // Сброса счетчика трафика 1
  else if( setting_id == VEGA_TX_DATA_SERV4)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[3].tx;
    return sizeof(server_state.traffic_counter[3].tx);
  }
  else if( setting_id == VEGA_RX_DATA_SERV4)
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->server_state.traffic_counter[3].rx;
    return sizeof(server_state.traffic_counter[3].rx);
  }
  // Управление встроенными выходами
  else if( setting_id >= VEGA_DIGITAL_OUTPUT_1 && setting_id <= (VEGA_DIGITAL_OUTPUT_1 + System.dout_count - 1))
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->signal_state.digital_output[setting_id-VEGA_DIGITAL_OUTPUT_1];
    return sizeof(signal_state.digital_output[setting_id-VEGA_DIGITAL_OUTPUT_1]);
  }

  #if defined(BR_PRESENT)
  // Управление выходами платы расширения
  else if( setting_id >= VEGA_EXT_DIGITAL_OUTPUT_1 && setting_id <= (VEGA_EXT_DIGITAL_OUTPUT_1 + System.ext_dout_count - 1))
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
                   // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->signal_state.ext_digital_output[setting_id-VEGA_EXT_DIGITAL_OUTPUT_1];
    return sizeof(signal_state.ext_digital_output[setting_id-VEGA_EXT_DIGITAL_OUTPUT_1]);
  }
  #endif //BR_PRESENT

  #if defined(INTERNAL_NRF_PRESENT)
  // Управление NRF реле
  else if( setting_id == VEGA_NRF_DESIRED_RELAY_STATE )
  {
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
    // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
#endif
    *setting_data_address = (uint8_t*)&this->signal_state.nrf_state.desired_relay_state;
    return sizeof(signal_state.nrf_state.desired_relay_state);
  }
  #endif //INTERNAL_NRF_PRESENT

  #if defined(NRF_BEACONS_SCANNER_PRESENT)
  // Радиометки
  else if(setting_id == VEGA_SETTING_NRF_BEACON_ID)
  {
    if(setting_subid >= nrf_beacons_count) return 0;
    *setting_data_address = (uint8_t*)&this->sensor_settings.nrf_beacons_scanner.autorized_beacons[setting_subid];
    return sizeof(this->sensor_settings.nrf_beacons_scanner.autorized_beacons[setting_subid]);
  }
  #endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(IMMO_FLANKER_PRESENT)
// Управление NRF реле
else if( setting_id == VEGA_IMMO_FLANKER_CMD )
{
#ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
  // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
  if(setting_subid>0) return 0;
#endif
  *setting_data_address = (uint8_t*)&this->immoLearnFlankerCmd;
  return sizeof(immoLearnFlankerCmd);
}
#endif //IMMO_FLANKER_PRESENT
#ifdef RS_TACHO_PRESENT
  else if( setting_id == TACHO_COMMAND )
  {
  #ifndef __ICCARM__ // Добавил эту строку пока только в конфигуратор,
    // т.к. не хочу сломать проект в IAR. Видима только настройка с subid=0
    if(setting_subid>0) return 0;
  #endif
    *setting_data_address = (uint8_t*)&this->tacho_state.command;
    return sizeof(tacho_state.command);
  }
#endif
#if defined(CUSTOM_CAN_SENSORS_PRESENT)
  else if(setting_id == VEGA_SETTING_CAN_CUSTOM_SENSORS)
  {
    if(setting_subid >= custom_can_sensors_settnigs_number)
    {
        return 0;
    }
    *setting_data_address = (uint8_t*)&this->canCustomSensorsSettings[setting_subid];
    return sizeof(this->canCustomSensorsSettings[setting_subid]);
  }
  else if(setting_id == VEGA_SETTING_CAN_MODULS_SETTINGS)
  {
    if(setting_subid >= stm_can_modul_count)
    {
        return 0;
    }
    *setting_data_address = (uint8_t*)&this->stmCanSettings[setting_subid];
    return sizeof(this->stmCanSettings[setting_subid]);
  }
  else if(setting_id == VEGA_SETTING_CAN_TX_SCRIPT_SETTINGS)
  {
    if(setting_subid >= can_tx_script_count_count)
    {
      return 0;
    }
    *setting_data_address = (uint8_t*)&this->canTxScriptSettings[setting_subid];
    return sizeof(this->canTxScriptSettings[setting_subid]);
  }
  else if(setting_id == VEGA_SETTING_ISOTP_CAN_SENSORS_SETTINGS)
  {
    if(setting_subid >= isotp_can_sensors_count)
    {
      return 0;
    }
    *setting_data_address = (uint8_t*)&this->IsoTpCanSensorsSettings[setting_subid];
    return sizeof(this->IsoTpCanSensorsSettings[setting_subid]);
  }
#endif // CUSTOM_CAN_SENSORS_PRESENT

#if defined(CANLOG_V4_CUSTOM_SENSORS_PRESENT)
  else if(setting_id == VEGA_SETTING_CANLOG_V4_CUSTOM_SENSORS)
  {
    if(setting_subid >= custom_canlogv4_sensors_settings_number)
    {
        return 0;
    }
    *setting_data_address = (uint8_t*)&this->canlogv4CustomSensorsSettings[setting_subid];
    return sizeof(this->canlogv4CustomSensorsSettings[setting_subid]);
  }
#endif

  // TODO
  /*#ifndef __ICCARM__
  if(setting_id == VEGA_SETTING_IGNITION ) {
    if(System.ignition_present)
        return 0;
  }
  #endif*/
  // Датчики из таблицы (корторые в единственном числе)
  for(uint16_t i = 0; i < (sizeof(settings_table)/sizeof(TSettings_table)); i++)
  {
    if(settings_table[i].id == setting_id && settings_table[i].subid == setting_subid)
    {
      *setting_data_address = (uint8_t*)settings_table[i].ptr;
      return settings_table[i].size;
    }
  }
  return 0;
}

#ifdef __ICCARM__
#pragma diag_default=Pe186
#endif


// Получение настройку используя ее порядковый номер (используется для формирования файла с настройками)
// Натройки отсеиваются признаками наличия сущностей (например, System.alarm_button_present)
// Функция возвращает: 0 - если достигнут конец таблицы, (т.е. настройки по заданному и последующим индексам настройки (setting_num) не существует)
//                     0xFFFF - настройка не найдена (отсеяна сущностями)
//                     остальные значения - размер настройки
uint16_t CSystem::Get_setting(uint16_t setting_num, uint16_t *setting_id, uint16_t *setting_subid, uint8_t** setting_data_address) const
{

  // Если у нас нету классических цифровых входов, то временно обнуляем эти переменные, чтобы в файл настроек не попали лишние параметры
  uint16_t settings_table_size = (sizeof(settings_table)/sizeof(TSettings_table));
  // Если номер настройки входит в таблицу настроек, то берем оттуда
  if(setting_num < settings_table_size)
  {
    *setting_id = settings_table[setting_num].id;
    *setting_subid = settings_table[setting_num].subid;
    *setting_data_address = (uint8_t*)settings_table[setting_num].ptr;
    #ifndef __ICCARM__
    if(settings_table[setting_num].id == VEGA_SETTING_ALARM_BUTTON && !System.alarm_button_present) return 0xFFFF;
    if(settings_table[setting_num].id == VEGA_SETTING_AUTORIZATION && !System.autorization_present) return 0xFFFF;
    if(settings_table[setting_num].id == VEGA_SETTING_MOTOHOURS && !System.motohours_present) return 0xFFFF;
    if(settings_table[setting_num].id == VEGA_SETTING_KEYS_ADD_MODE && !System.dallas_tm_count) return 0xFFFF;
    if(settings_table[setting_num].id == VEGA_SETTING_TEMP_ADD_MODE && !System.dallas_temp_count) return 0xFFFF;
    if(settings_table[setting_num].id == VEGA_SETTING_CAMERA && !System.camera_present) return 0xFFFF;
    if(settings_table