/**
  ******************************************************************************
  * @file    usb_hw_config.h
  * @author  MCD Application Team
  * @version V4.0.0
  * @date    21-January-2013
  * @brief   Hardware Configuration & Setup
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2013 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_HW_CONFIG_H
#define __USB_HW_CONFIG_H

#ifdef __cplusplus
 extern "C" {
#endif 

/* Includes ------------------------------------------------------------------*/
#include "usbd_cdc_config.h"
//#include "usb_type.h"
   
#ifdef USE_FREERTOS
#include "FreeRTOS.h"
#include "semphr.h" 
#endif
    
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported define -----------------------------------------------------------*/

/* Exported functions ------------------------------------------------------- */
void USB_GpioConfig(void);
void Set_USBClock(void);
void Enter_LowPowerMode(void);
void Leave_LowPowerMode(void);
void USB_Interrupts_Config(void);
void USB_Cable_Config (FunctionalState NewState);
void Get_SerialNum(void);

int16_t usb_read(uint8_t* mem, uint16_t len, uint32_t timeout);
int16_t usb_write(uint8_t *mem, uint16_t len, uint32_t timeout);


/* External variables --------------------------------------------------------*/
#ifdef USE_FREERTOS
extern SemaphoreHandle_t UsbTxBinSemaphore;
extern SemaphoreHandle_t UsbRxBinSemaphore;
#else
extern volatile uint8_t UsbTxBinSemaphore;
extern volatile uint8_t UsbRxBinSemaphore;
#endif

#ifdef __cplusplus
 }
#endif 

#endif  /*__USB_HW_CONFIG_H*/

