/**
  ******************************************************************************
  * @file    USB_Device/CDC_Standalone/Src/usbd_cdc_interface.c
  * @author  MCD Application Team
  * @version V1.2.0
  * @date    31-July-2015
  * @brief   Source file for USBD CDC interface
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
//#include "usbd_cdc_interface.h"
//#include <string.h>
#include "USB_CDC_STM32/STM32_USB-FS-Device_Driver/inc/usb_init.h"
#include "USB_CDC_STM32/usbd_cdc_interface.h"
#include "USB_CDC_STM32/usb_pwr.h"

//-  USB CDC
void USB_CDC_Init(void)
{
#ifdef USE_FREERTOS
 //   
  if(UsbTxBinSemaphore == NULL) vSemaphoreCreateBinary( UsbTxBinSemaphore );
  xSemaphoreTake(UsbTxBinSemaphore, 0);
  if(UsbRxBinSemaphore == NULL) vSemaphoreCreateBinary( UsbRxBinSemaphore );
  xSemaphoreTake(UsbRxBinSemaphore, 0); 
#else
  UsbTxBinSemaphore=0;
  UsbRxBinSemaphore=0;
#endif
  
  USB_GpioConfig();
  Set_USBClock();
  USB_Interrupts_Config();
  USB_Init();
}

//-  USB CDC
void USB_CDC_Deinit(void)
{
  USB_Cable_Config(DISABLE);
  /* Disable the USB clock */
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_USB, DISABLE);
}

//-     
int16_t USB_CDC_Send(uint8_t* data, uint16_t size, uint32_t xTicksToWait)
{
  if(bDeviceState!= CONFIGURED) return -1;
  return usb_write(data, size, xTicksToWait);
}

//-     
int16_t USB_CDC_Receive(uint8_t* data, uint16_t size, uint32_t xTicksToWait)
{
 if(bDeviceState!= CONFIGURED) return -1;
 return usb_read(data, size, xTicksToWait);
}

//-
DEVICE_STATE USB_CDC_State(void)
{
  return bDeviceState; 
}
