/**
  ******************************************************************************
  * @file    USB_Device/CDC_Standalone/Inc/usbd_cdc_interface.h
  * @author  MCD Application Team
  * @version V1.2.0
  * @date    31-July-2015
  * @brief   Header for usbd_cdc_interface.c file.
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USBD_CDC_INTERFACE_H
#define __USBD_CDC_INTERFACE_H

#ifdef __cplusplus
 extern "C" {
#endif 

/* Includes ------------------------------------------------------------------*/
#include "FreeRTOS.h"
#include "USB_CDC_STM32/STM32_USB-FS-Device_Driver/inc/usb_lib.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */


//-  USB CDC
void USB_CDC_Init(void);
//-  USB CDC
void USB_CDC_Deinit(void);

//-     
int16_t USB_CDC_Send(uint8_t* data, uint16_t size, uint32_t xTicksToWait);
//-     
int16_t USB_CDC_Receive(uint8_t* data, uint16_t size, uint32_t xTicksToWait);
// -
DEVICE_STATE USB_CDC_State(void);

#ifdef __cplusplus
 }
#endif 

#endif /* __USBD_CDC_INTERFACE_H */

