/**
  ******************************************************************************
  * File Name          : br_protocol.h
  * Description        : 
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __BR_PROTOCOL_H
#define __BR_PROTOCOL_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include <string.h>
#include "debug_port.h"
  
#include "crc_lib/crc_lib.h"

#define ODEBUG_L                                0//off debug
#define LDEBUG_L                                1//low level (err only)
#define MDEBUG_L                                2//medium level
#define HDEBUG_L                                3//high level
  
#define BR_DEBUG_LEVEL                          HDEBUG_L    
  
    
#define PING_BR_MESS_TYPE                       1
#define PING_BR_ACK_MESS_TYPE                   2
#define GOTOSLEEP_BR_MESS_TYPE                  3  
#define GOTOSLEEP_BR_ACK_MESS_TYPE              4  
  
#define GET_DEV_TYPE_BR_MESS_TYPE               10  
#define GET_DEV_TYPE_BR_ACK_MESS_TYPE           11   
#define GET_EXT_MFI_SETTINGS_BR_MESS_TYPE       12  
#define GET_EXT_MFI_SETTINGS_BR_ACK_MESS_TYPE   13 
#define GET_EXT_MFI_FULL_STATE_BR_MESS_TYPE     14  
#define GET_EXT_MFI_FULL_STATE_BR_ACK_MESS_TYPE 15
#define GET_EXT_OUTPUTS_STATE_BR_MESS_TYPE      16  
#define GET_EXT_OUTPUTS_STATE_BR_ACK_MESS_TYPE  17
  
#define SET_EXT_MFI_SETTINGS_BR_MESS_TYPE       50    
#define SET_EXT_MFI_SETTINGS_BR_ACK_MESS_TYPE   51    
#define SET_EXT_OUTPUTS_STATE_BR_MESS_TYPE      52   
#define SET_EXT_OUTPUTS_STATE_BR_ACK_MESS_TYPE  53  
  
#define SET_EXT_FIRST_PULSE_COUNTER_BR_MESS_TYPE   200
#define SET_EXT_LAST_PULSE_COUNTER_BR_MESS_TYPE    (SET_EXT_FIRST_PULSE_COUNTER_BR_MESS_TYPE+15-1)  
#define SET_EXT_PULSE_COUNTER_BR_ACK_MESS_TYPE     (SET_EXT_LAST_PULSE_COUNTER_BR_MESS_TYPE+1) 
  
#define SYNC_BYTE                               0xAA
  
typedef __packed struct
{
  uint8_t sync_byte; // SYNC_BYTE
  uint16_t len;      //   
  uint8_t  type;     //  
}br_header_t;

typedef struct
{
  uint8_t* parse_buff;                       //  ,    (    )
  uint16_t parse_len;                        // ,    (    )
    
  uint16_t rx_mem_size;                      //   
  
  uint8_t* tx_mem;                           //   
  uint16_t tx_mem_size;                      // 
    
  uint8_t is_wait_ping_ack;
   
  void (*get_state_callback)(uint8_t param_type, uint8_t* ansver, uint16_t* ansver_len, uint16_t max_ansver_size);
  
  void (*set_state_callback)(uint8_t param_type, uint8_t* param, uint16_t param_len);
  
  void (*write)(const uint8_t* buff, uint16_t len);
  
}br_ctx_t;

void BrResetCtxState(br_ctx_t* ctx);
void BrDeInitCtx(br_ctx_t* ctx);
int16_t BrRxProcessing(br_ctx_t* ctx);

#define BR_PACKET_LEN(payload_len)                (sizeof(br_header_t)+payload_len+sizeof(uint16_t))
#define BR_PACKET_CRC_OFFSET(payload_len)         (sizeof(br_header_t)+payload_len)
#define BR_PACKET_CRC_CALC_LEN(payload_len)       (BR_PACKET_CRC_OFFSET(payload_len))
#define BR_PACKET_PAYLOAD_OFFSET()                (sizeof(br_header_t))

#define GET_EXT_MFI_FULL_STATE_BR_ACK_MESS_LEN  (BR_PACKET_LEN(sizeof(System.signal_state.ext_digital_input)+sizeof(System.signal_state.ext_analog_input)+sizeof(System.signal_state.ext_pulse_input)+sizeof(System.signal_state.ext_freq_input)))
#define GET_DEV_TYPE_BR_ACK_MESS_LEN            (BR_PACKET_LEN(sizeof(uint8_t)))
#define SET_EXT_MFI_SETTINGS_BR_ACK_MESS_LEN    (BR_PACKET_LEN(0))      
#define SET_EXT_OUTPUTS_STATE_BR_ACK_MESS_LEN   (BR_PACKET_LEN(0))  
#define SET_EXT_OUTPUTS_STATE_BR_ACK_MESS_LEN   (BR_PACKET_LEN(0))
#define SET_EXT_PULSE_CONTER_BR_ACK_MESS_LEN    (BR_PACKET_LEN(0))
#define GOTOSLEEP_BR_ACK_MESS_TYPE_LEN          (BR_PACKET_LEN(0))

#ifdef __cplusplus
}
#endif 

#endif /*__BR_PROTOCOL_H*/
