/**
  ******************************************************************************
  * File Name          :
  * Description        :
  *
  *
  ******************************************************************************
*/

#ifndef __SYSTEM_CANLOG_V2_H
#define __SYSTEM_CANLOG_V2_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include "system_config.h"

#pragma pack(1)

// Заголовок фрейма загрузчика
typedef struct
{
  uint8_t marker;
  uint8_t cmd;
  uint8_t len;
}TCan_header;

typedef struct
{
  uint16_t token;
  uint8_t task;
}TCan_data_header;

// Фрейм загрузчика
typedef struct
{
  TCan_header       mheader;
  TCan_data_header  sheader;
  uint16_t program_no;
  uint8_t software_date[3];
  uint8_t hw_version;
  uint8_t soft_version;
  uint8_t soft_option;
  uint8_t device_sn[8];
  uint8_t boot_version;
  uint8_t reserve[12];
  uint8_t crc;
}TCan_boot_inf;

typedef struct
{
  TCan_boot_inf boot_inf;             //Полный фрейм загрузчика
  uint16_t prog_num;                  //Номер программы
  uint8_t  curr_frame_interval;       //Интервал времени между кадрами, секунды
}TCan_sys_inf;

// Текущее состояние CAN-шины автомобиля
typedef struct
{
  uint8_t stop;                     //СТОП
  uint8_t chek_oil;                 //Давление/уровень масла
  uint8_t chek_coolant;             //Температура/уровень хладагента
  uint8_t hand_break;               //Система ручного тормоза
  uint8_t battery;                  //Зарядка батареи
  uint8_t airbag;                   //AIRBAG (подушка безопасности)
  uint8_t check_engine;             //ПРОВЕРЬТЕ ДВИГАТЕЛЬ
  uint8_t fault_lighting;           //Неисправность освещения
  uint8_t inflation_pressure;       //Низкое давление воздуха в шине
  uint8_t chek_brake_pads;          //Изношенные тормозные колодки
  uint8_t warning;                  //Предупреждение
  uint8_t abs;                      //ABS (антиблокировочная система)
  uint8_t fuel_level;               //Низкий уровень топлива
  uint8_t serv_maint;               //Предстоит сервисное обслуживание
  uint8_t esp;                      //ESP (Электронный регулятор устойчивости)
  uint8_t spark_plug;               //Индикатор запальной свечи
  uint8_t fap;                      //FAP (Фильтр макрочастиц)
  uint8_t pressure_control;         //Электрическая регулировка давления
  uint8_t marker_lights;            //Габаритные огни
  uint8_t dipped_beam;              //Ближний свет фар
  uint8_t high_beam;                //Дальний свет фар
  uint8_t ready_for_motion;         //Готовность начать движение
  uint8_t passenger_safety_belt;    //Ремень безопасности пассажира
  uint8_t driver_safety_belt;       //Ремень безопасности водителя
}TCan_controls_flags;

typedef struct
{
  uint8_t battery_charging;     //зарядка аккумулятора
  uint8_t charge_cable_present; //подключен кабель для зарядки
  uint8_t butt;              //бит появляется при нажатии любой из подержанных кнопок в машине +++
  uint8_t immo_in_sev;       //бит появляется в тот момент, когда функция иммобилайзер находится в сервисным режиме +++
  uint8_t immo;              //иммобилайзер, бит появляется после правильного введения запрограммированнейсеквенции кнопок в машине +++ ---
  uint8_t key_in_ign;        //ключ в замке зажигания
  uint8_t ignition;          //зажигание
  uint8_t dynamic_ign;       //динамическое зажигание
  uint8_t webasto;           //Webasto
  uint8_t closed_by_pult;    //автомобиль закрыт с заводского пульта управления
  uint8_t alarm_act;         //заводская сигнализация активирована (находится в режиме тревоги)
  uint8_t native_alarm;      //заводская сигнализация эмулируется модулем
  uint8_t parking;           //рукоятка коробки переложения передачи переведена в положение «Парк» (для автоматических коробок переложения)
  uint8_t hand_break;        //задействован ручной тормоз (информация доступна только с вкл. зажиг.)
  uint8_t pedal_break;       //задействован ножной тормоз (информация доступна только с вкл. зажиг.)
  uint8_t engine_is_on;      //двигатель работает (информация доступна только с вкл. зажиганием)
  uint8_t reverse_gear;      //включена задняя передача
  uint8_t driver_door;       //дверь водителя открыта
  uint8_t pass_door;         //пассажирская дверь открыта
  uint8_t l_rear_door;       //левая задняя дверь открыта
  uint8_t r_rear_door;       //правая задняя дверь открыта
  uint8_t hood;              //капот открыт
  uint8_t trunk;             //крышка багажника открыта
  uint8_t remote_control;
  //0x01 – автомобиль был закрыт с заводского пульта управления,
  //0x02 – автомобиль был открыт с заводского пульта управления,
  //0x03 – крышка багажника была открыта с заводского пульта управления,
  //0x04 – модуль отправил сигнал перепостановки в охрану,
  //0x05 – автомобиль был троекратно закрыт штатным пультом
  uint8_t can_in_sleep;             //CAN-модуль вошел в режим «sleep»
  uint8_t key_in_acc;         //key is in ingection in ACC
}TCan_security_flags;

typedef struct
{
  uint8_t tresher_on;      //Молотильный барабан включён
  uint8_t unload_tube_on;  //Включена выгрузная труба
  uint8_t f_hydr_1;        //Включена первая передняя гидравлика
  uint8_t r_pto_unit;      //Включенный задний блок отбора мощности

  uint8_t trasher_gap;     //Чрезмерный люфт под молотильным барабаном
  uint8_t gr_tnk_open;     //Открыт вход в зерновой бункер
  uint8_t gr_tnk_100;      //Бункер зерна 100%
  uint8_t gr_tnk_70;       //Бункер зерна 70%
  uint8_t hydr_fltr_clog;  //Засорен фильтр масла гидравлической системы
  uint8_t hydr_press_low;  //Низкое давление масла гидравлической системы
  uint8_t hydr_level_low;  //Низкий уровень масла гидравлического
  uint8_t br_fltr_clog;    //Засорен фильтр гидросистемы тормозов

  uint8_t oil_fltr_clog;   //Засорен масляный фильтр двигателя
  uint8_t fuel_fltr_clog;  //Засорен топливный фильтр
  uint8_t air_fltr_clog;   //Засорен воздушный фильтр
  uint8_t hydr_temp_alert;  //Аварийная температура масла в гидросистеме ходовой части
  uint8_t pch_temp_alert;  //Аварийная температура масла в гидросистеме силовых цилиндров
  uint8_t oil_pres_alert;  //Аварийное давление масла в двигателе
  uint8_t coolant_alert;   //Аварийный уровень охлаждающей жидкости
  uint8_t hblock_section;  //Переливная секция гидроблока

  uint8_t screw_alert;     //Включен привод выгрузного шнека при слож. выгрузн. трубе
  uint8_t no_operator;     //Оператор отсутствует!
  uint8_t straw_alert;     //Забивание соломотряса
  uint8_t water_in_fuel;   //Наличие воды в топливе
  uint8_t clear_fan;       //Обороты вентилятора очистки
  uint8_t reel;            //Обороты барабана

  uint8_t low_water;       //Низкий уровень воды в баке
  uint8_t r_hydr_1;        //Включена первая задняя гидравлика
  uint8_t autonom_engine;  //Автономный двигатель заведен
  uint8_t r_joy_right;     //Правый джойстик вправо
  uint8_t r_joy_left;      //Правый джойстик влево
  uint8_t r_joy_front;     //Правый джойстик вперед
  uint8_t r_joy_back;      //Правый джойстик назад

  uint8_t brush_on;        //Щетка включена
  uint8_t water_on;        //Подача воды включена
  uint8_t vaccleaner;      //Пылесос
  uint8_t bunker_upload;   //Выгрузка из бункера
  uint8_t kercher;         //Мойка высокого давления (Kерхер)
  uint8_t salt_diffusion;  //Рассеивание соли (песка) включено
  uint8_t salt_low;        //Низкий уровень соли (песка) в баке

  //+++
  uint8_t f_hydr_2;        //Включена вторая передняя гидравлика
  uint8_t f_hydr_3;        //Включена третья передняя гидравлика
  uint8_t f_hydr_4;        //Включена четвёртая передняя гидравлика
  uint8_t r_hydr_2;        //Включена вторая задняя гидравлика
  uint8_t r_hydr_3;        //Включена третья задняя гидравлика
  uint8_t r_hydr_4;        //Включена четвёртая задняя гидравлика
  uint8_t f_susp_sys;      //Включёна передняя трехточечная система подвески
  uint8_t r_susp_sys;      //Включёна задняя трехточечная система подвески

  //+++
  uint8_t l_joy_right;     //Левый джойстик вправо
  uint8_t l_joy_left;      //Левый джойстик влево
  uint8_t l_joy_front;     //Левый джойстик вперед
  uint8_t l_joy_back;      //Левый джойстик назад
  uint8_t f_pto_unit;      //Включен передний блок отбора мощности
}TCan_agriculture_flags;


typedef struct
{
  uint32_t eng_uptime;                  //Суммарное время работы двигателя, минуты
  uint32_t eng_uptime_p;                //Суммарное время работы двигателя (до сброса), минуты
  float    can_odo_km;                  //Полный пробег транспортного средства, км
  float    can_odo_p;                   //Полный пробег транспортного средства (до сброса), км
  float    cons_fuel_l;                 //Общее потребление топлива, л
  float    cons_fuel_p;                 //Общее потребление топлива (до сброса), л
  uint8_t  fuel_lev_p;                  //Уровень топлива, в процентах
  uint16_t fuel_lev_l;                  //Уровень топлива, в литрах
  uint16_t eng_rpm;                     //Обороты двигателя RPM
  float    eng_temp;                    //Температура двигателя
  uint8_t  can_speed;                   //Скорость транспортного средства
  uint16_t can_axle_1;                  //Нагрузка на ось 1, кг
  uint16_t can_axle_2;                  //Нагрузка на ось 2, кг
  uint16_t can_axle_3;                  //Нагрузка на ось 3, кг
  uint16_t can_axle_4;                  //Нагрузка на ось 4, кг
  uint16_t can_axle_5;                  //Нагрузка на ось 5, кг
  float    fuel_flow;                   //Текущий (мгновенный) расход топлива, л/ч
  uint8_t  ad_blue_p;                   //Уровень жидкости AdBlue, в процентах (мочевина)
  uint16_t ad_blue_l;                   //Уровень жидкости AdBlue, в литрах (мочевина)
  uint32_t harvest_time;                //Время сбора урожая, минуты
  float    harvest_area;                //Убранная площадь, Га
  float    harvest_eff;                 //Эффективность уборки, Га/ч
  uint32_t harvest_grain;               //Количество убранного зерна, кг
  uint8_t  brake;                       //Положение педали тормоза
  uint8_t  accelerator;                 //Положение педали акселератора в процентах
  uint8_t  engine_load;                 //Нагрузка двигателя в процентах. Может быть отрицательным?
  uint16_t thresher_rpm;                //Частота вращения (обороты) молотильного барабана RPM
  uint8_t  concave_clear;               //Отброшенное состояние подбарабанья (зазор подбарабанья)

  uint32_t bef_srvc_odo;                //Пробег до очередного сервисного обслуживания, км.
  uint32_t ex_srvc_odo;                 //Превышение пробега до очередного сервисного обслуживания, км.
  uint32_t aft_srvc_odo;                //Пробег после обслуживания, км.

  uint16_t bef_srvc_time;               //Время до очередного обслуживания, дни.
  uint16_t ex_srvc_time;                //Время превышения очередного обслуживания, дни.
  uint16_t aft_srvc_time;               //Время после обслуживания, дни.

  float battery_temperature;            //Температура батареи
  float battery_charge_level;           //Уровень заряда батареи

#ifdef __ICCARM__
#if (DEVICE_TYPE == DEVICE_TYPE_OBU_TACHO)
  char tacho_driver_1_inf[64];
  char tacho_driver_2_inf[64];
  uint8_t tacho_cards_info;
#endif //(DEVICE_YPE == DEVICE_TYPE_OBU_TACHO)
#endif  // __ICCARM__

#ifdef __ICCARM__
#if (DEVICE_TYPE == DEVICE_TYPE_PLATON_COMMERCIAL)
  //для "показать"
  char tacho_driver_1_inf[64];
  char tacho_driver_2_inf[64];
  uint8_t tacho_cards_info;
  char barcode_reader[96];
#endif //(DEVICE_YPE == DEVICE_TYPE_PLATON_COMMERCIAL)
#endif  // __ICCARM__
}TCan_numeric_data;

#pragma pack()

#ifdef __cplusplus
}
#endif

#endif /*__SYSTEM_CANLOG_V2_H*/