/**
  ******************************************************************************
  * File Name          : cbuff.h
  * Description        :      
  *                      
  *                      
  ******************************************************************************
*/

#ifndef __CBUFF_H
#define __CBUFF_H

#ifdef __cplusplus
extern "C" {
#endif 
  
  /* Includes -----------------------------------------------------------------*/  
  #include <stdint.h>
  
  /* Exported types -----------------------------------------------------------*/
  typedef struct
  {
    uint8_t* buff;
    uint16_t buff_size;
    uint16_t buff_mask;
    uint16_t in_idx;
    uint16_t out_idx;
  }cbuff_t;
  
  /* Exported constants -------------------------------------------------------*/ 
  /* Exported functions ------------------------------------------------------ */ 
  /*
   cbuff
  */
  void cbuff_init(cbuff_t* const cbuff, uint8_t* const mem, const uint16_t mem_size);
    
  /*
    cbuff   src  len
  */
  void write_to_cbuff(cbuff_t* const cbuf, uint8_t* const src, const uint16_t len);
  
  /*
     cbuff
  */
  void write_byte_to_cbuff(cbuff_t* const cbuff, const uint8_t src_byte);
  
  /*
    cbuff x  dst  len   ( !!!)
  */
  void peek_from_cbuff(cbuff_t* const cbuff, uint8_t* const dst, const uint16_t len);
  
  /*
     in_idx  cbuff,     DMA    cbuff
  */
  void force_set_cbuff_in_idx(cbuff_t* const cbuff, const uint16_t dma_curr_data_pointer);
  
  /*
    cbuff x  dst  len
  */
  void read_from_cbuff(cbuff_t* const cbuff, uint8_t* const dst, const uint16_t len);
  /*
  
     cbuff
  */
  uint8_t read_byte_from_cbuff(cbuff_t* const cbuff);

  /*
   len   cbuff 
  */
  void clean_cbuff_len_from_reader(cbuff_t* const cbuff, const uint16_t len);
  
  /*
     cbuff 
  */
  uint16_t filled_cbuff_len(cbuff_t* const cbuff);
  
  /*
    cbuff 
  */
  uint16_t free_cbuff_len(cbuff_t* const cbuff);
  /*
  
    
  */
  void clear_cbuff_from_writter(cbuff_t* const cbuff);
  
  /*
    cbuff 
  */
  void clear_cbuff_from_reader(cbuff_t* const cbuff);
    
  /*
  ,    ref_buff  cmp_len    cbuff?
  !  !
  */
  uint8_t is_cbuf_ends_with_ref_buff(cbuff_t* const cbuff, const uint8_t* const ref_buff, const uint16_t cmp_len);
  
#ifdef __cplusplus
}
#endif 

#endif /*__CBUFF_H*/