/**
******************************************************************************
* File Name          : sfifo.c
* Description        : 
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "cbuff/sfifo.h"
#include <string.h> 

/* C code---------------------------------------------------------------------*/

bool sfifo_init(sfifo_t* sfifo, void* heap, const uint32_t heap_size, const uint8_t cell_size)
{
  uint16_t sfifo_len;
  
  sfifo->is_init=0;
  
  if(!cell_size)  return false;
  
  sfifo_len=heap_size/cell_size;
  
  if(sfifo_len<8) return false;
    
  while(sfifo_len&(sfifo_len-1)) {sfifo_len--;}
  
  sfifo->heap=(uint8_t*)heap;
  sfifo->cell_size=cell_size;
  sfifo->idx_mask=sfifo_len-1;
  sfifo->in_idx=0;
  sfifo->out_idx=(sfifo->in_idx)&(sfifo->idx_mask);
  sfifo->is_full=0;
  sfifo->drop_counter=0;
  sfifo->is_init=1;
  
  return true;
}

#pragma optimize=speed
inline uint16_t filled_count_in_sfifo(sfifo_t* sfifo)
{
  return ((sfifo->in_idx-sfifo->out_idx)&(sfifo->idx_mask));
}

#pragma optimize=speed
inline uint16_t free_count_in_sfifo(sfifo_t* sfifo)
{
  return (sfifo->idx_mask-((sfifo->in_idx-sfifo->out_idx)&(sfifo->idx_mask)));
}

#pragma optimize=speed
inline bool read_from_sfifo(sfifo_t* sfifo, void* data)
{
  if(!sfifo->is_init) return false;
  
  memcpy(data, &sfifo->heap[sfifo->cell_size*sfifo->out_idx], sfifo->cell_size);
  sfifo->out_idx++;
  sfifo->out_idx&=sfifo->idx_mask;
  
  if(sfifo->is_full) 
  {
    sfifo->is_full=0;
    return false;
  }
  else
  {
    return true;
  }
}

#pragma optimize=speed
inline bool write_to_sfifo(sfifo_t* sfifo, const void* data)
{
  if(!sfifo->is_init) return false;
  
  if(!sfifo->is_full)
  {
    if(free_count_in_sfifo(sfifo)>0)
    {
      memcpy(&sfifo->heap[sfifo->cell_size*sfifo->in_idx], data, sfifo->cell_size);
      sfifo->in_idx++;
      sfifo->in_idx&=sfifo->idx_mask;
      return true;
    }
    else
    {
      sfifo->is_full=1;
      sfifo->drop_counter++;
    }
  }
  
  return false;
}

#pragma optimize=speed
inline void clean_sfifo_from_writter(sfifo_t* sfifo)
{
  if(!sfifo->is_init) return;
  
  sfifo->in_idx=(sfifo->out_idx)&(sfifo->idx_mask);
}

#pragma optimize=speed
inline void clean_sfifo_from_reader(sfifo_t* sfifo)
{
  if(!sfifo->is_init) return;
  
  sfifo->out_idx=(sfifo->in_idx)&(sfifo->idx_mask);
}
