/**
  ******************************************************************************
  * File Name          : sfifo.h
  * Description        :
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __SFIFO_H
#define __SFIFO_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h> 
#include <stdbool.h>

typedef struct
{
  uint8_t* heap;
  uint8_t  cell_size;
  
  uint16_t in_idx;
  uint16_t out_idx;
  uint16_t idx_mask;
  uint8_t is_full;
  uint8_t is_init;
  uint32_t drop_counter;
}sfifo_t;

bool sfifo_init(sfifo_t* sfifo, void* heap, const uint32_t heap_size, const uint8_t cell_size);
uint16_t filled_count_in_sfifo(sfifo_t* sfifo);
uint16_t free_count_in_sfifo(sfifo_t* sfifo);
bool read_from_sfifo(sfifo_t* sfifo, void* data);
bool write_to_sfifo(sfifo_t* sfifo, const void* data);
void clean_sfifo_from_writter(sfifo_t* sfifo);
void clean_sfifo_from_reader(sfifo_t* sfifo);

#ifdef __cplusplus
}
#endif

#endif /*__SFIFO_H*/