/**
  ******************************************************************************
  * File Name          : 
  * Description        : 
  *                      
  *                      
  ******************************************************************************
*/

#include "ext_string_lib/ext_string.h"

/*
 * Find the first occurrence of find in s, where the search is limited to the
 * first slen characters of s.
 * https://github.com/freebsd/freebsd/blob/1d6e4247415d264485ee94b59fdbc12e0c566fd0/lib/libc/string/strnstr.c
*/
char *strnstr(const char *s, const char *find, size_t slen)
{
  char c, sc;
  size_t len;
  
  if ((c = *find++) != '\0') {
    len = strlen(find);
    do {
      do {
        if (slen-- < 1 || (sc = *s++) == '\0')
          return (NULL);
      } while (sc != c);
      if (len > slen)
        return (NULL);
    } while (strncmp(s, find, len) != 0);
    s--;
  }
  return ((char *)s);
}

int memfillcmp(const void *s, int c, size_t size)
{
  for( size_t i = 0; i < size; i++ )
  {
    if( *((const uint8_t*)s + i) != (uint8_t)c )
    {
      return 1;
    }
  }
  
  return 0;
}

//     (    )
void mem_move_to_tail(uint8_t* dst, uint8_t* src, uint16_t len) 
{
  if(!len) return;
  
  dst+=len-1; src+=len-1;
  
  while (len--)
  { 
    *dst = *src;
    dst--; src--;
  }
}


//     (    )
void mem_move_to_head(uint8_t* dst, uint8_t* src, uint16_t len) 
{
  if(!len) return;
  
  while (len--)
  {
    *dst = *src;
    dst++; src++;
  }
}

//     c   s
uint16_t sym_cnt_in_str(const char *s, char c)
{
  uint16_t cnt=0;
  
  while(*s!='\0')
  {
    if(*(s++)==c) cnt++;
  }
  return cnt;
}


//  Win1251  UCS2
uint16_t Win1251ToUCS2(const char *src, char *dst)
{
  uint16_t code;
  uint16_t n=0;
  uint16_t len = strlen(src);
  //Win1251 to UCS2 
  while (len && *src) 
  {
    if (*src=='') code=0x0415;         //code=0x0401;
    else if (*src=='') code=0x0435;    //code=0x0451;
    else if (! (*src&0x80)) code=*src;
    else code=*src+0x0350;
    sprintf(&dst[n], "%4.4X", code);
    n+=4;
    src++, len--;
  }
  dst[n]=0;
  return n;      
}


//  UCS2  Win1251
uint16_t UCS2toWin1251(const char *src, char *dst)
{
  uint16_t code;
  uint16_t src_len;
  uint16_t dst_len=0;
  char buf[5];
  
  src_len=strlen(src);
  if(src_len%4!=0)
  {
    src_len=0;
  }
  
  while(src_len--)
  {
    
    if( !((*src>='0' && *src<='9') || (*src>='A' && *src<='F')) || 
       !((*(src+1)>='0' && *(src+1)<='9') || (*(src+1)>='A' && *(src+1)<='F')) ||
         !((*(src+2)>='0' && *(src+2)<='9') || (*(src+2)>='A' && *(src+2)<='F')) ||
           !((*(src+3)>='0' && *(src+3)<='9') || (*(src+3)>='A' && *(src+3)<='F'))
             )
    {
      break;
    }
    
    buf[0]=*(src+0);
    buf[1]=*(src+1);
    buf[2]=*(src+2);
    buf[3]=*(src+3);
    buf[4]='\0'; 
    
    code=(uint16_t)strtoul( buf, NULL, 16 );
    
    if( code>=0x0020 && code<0x007F )// 
    {
      *dst=(char)code;
    }
    else if ( code>=0x0410 && code<=0x044F ) //
    {
      *dst=(char)(code-0x0350);
    }
    else if ( code==0x0451 )//''
    {
      *dst='';
      //*dst='';
    }
    else if ( code>=0x0401 )//''
    {
      *dst='';
      //*dst='';
    }
    else
    {
      break;
    }
    src+=4;
    dst+=1;
    dst_len++;
  }
  
  *dst='\0';
  return dst_len;       
}

//   find_what  find_in  size 
const uint8_t* strfind(const uint8_t* find_in, const char* find_what, uint16_t find_in_size)
{
  uint16_t len;
  len = strlen(find_what);
  
  if(!len || !find_in_size || find_in_size<len) return NULL;
  find_in_size-=len;
  
  for(uint16_t i=0; i<=find_in_size; i++)
  {
    if(memcmp(&find_in[i], find_what, len) == 0)
    return &find_in[i];
  }
  
  return NULL;
}

uint8_t char_to_hex(const char c)
{
  uint8_t h = 0;
  
  if('0' <= c  &&  c <= '9')
  {
    h = c - '0';
  }
  else if('A' <= c  &&  c <= 'F')
  {
    h = c - 'A' + 10;
  }
  else if('a' <= c  &&  c <= 'f')
  {
    h = c - 'a' + 10;
  }
  else
  {
    //  
  }
  return h;
}
