/**
  ******************************************************************************
  * File Name          : quectel_modem_lib.c
  * Description        : Библиотека для работы с gsm модемами QUECTEL
  *
  *
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "gsm_modems_lib/quectel/quectel_modem_lib.h"
#include "time_utilities/time_utilities.h"

/* Private define ------------------------------------------------------------*/
#if (PARSE_RX_BUFF_SIZE < 3*512)
#error PARSE_RX_BUFF_SIZE err
#endif //(PARSE_RX_BUFF_SIZE < 3*512)

/* Private variables ---------------------------------------------------------*/
//#define CMGR_DEBUG
#if defined(CMGR_DEBUG)
#warning CMGR_DEBUG
static char cmgr_buff[128*3]={0};
#endif //defined(CMGR_DEBUG)

static modem_at_flags_t modem_at_flags={0};
static modem_parse_t modem_parse;
static bt_gprs_flow_t bt_gprs_flow;
static sms_read_flow_t sms_read_flow;
static ctx_conn_state_t ctx_conn_state;
static modem_fwd_t modem_fwd;
static modem_state_t modem_state;
static modem_network_time_t modem_time;
static aux_data_t aux_data;
static char cmd_buff[96];

//static char pin_code[5];
static uint8_t num_bt_device;

#if defined(__UC200T__)
#error
//работа с файловой системой завершается ошибкой
//формат sms при чтении отличается
#endif //defined(__UC200T__)

#if defined(__MC60__)
#if BLE_SCAN_TABLE_SIZE > 0
static bt_gat_scan_t ble_scan_table[BLE_SCAN_TABLE_SIZE]={0};
static uint16_t ble_scan_gat_id;
static uint8_t ble_scan_table_idx;
#endif //BLE_SCAN_TABLE_SIZE > 0
#endif //defined(__MC60__)

#if defined(__EC21_X__)
static fota_state_t fota_state;
#endif //defined(__EC21_X__)
/* Private constants ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/

/* Private functions ---------------------------------------------------------*/
static uint8_t is_bluetooth_present(void)
{
#if defined(__MC60__)
  return 1;
#else
  return 0;
#endif //defined(__MC60__)
}

static void parse_aux_data(char* src)
{
  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  if(aux_data.dst_mem!=NULL && aux_data.dst_mem_size!=0)
  {
    uint16_t offset;

    if(!aux_data.is_append_with_lf) offset=0;
    else                            offset=strnlen(aux_data.dst_mem, aux_data.dst_mem_size);

    for(; offset<(aux_data.dst_mem_size-1); offset++)
    {
      if(!aux_data.is_append_with_lf)
      {
        if(*src=='\r' || *src=='\n') {break;}
      }
      else
      {
        if(*src=='\r')      {aux_data.dst_mem[offset]='\n'; src++; continue;}
        else if(*src=='\n') {break;}
      }
      aux_data.dst_mem[offset]=*(src++);
    }
    aux_data.dst_mem[offset]='\0';
  }
  xSemaphoreGive( modem_at_flags.lock_obj );
}

#if defined(QUECTEL_MODEM_FTP_PRESENT)
#if defined(__MC60__)
static void ftp_strtol_handle(const char* p)
{
  modem_state.ftp_res=INT32_MIN;

  if(!(p[0]=='\r' || (p[0]==' ' && p[1]=='\r')))
  {
    modem_state.ftp_res=(int32_t)strtol(p, NULL, 10);
  }

  SetModemAtFlag(FTP_FLAG_FGSM);
}
#endif //defined(__MC60__)

#if (defined(__EC21_X__) || defined(__UG95__))
static void ftp_strtoul_handle(const char* p)
{
  char* next;
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));

  modem_state.ftp_res[0]=strtoul(p, &next, 10);
  modem_state.ftp_res[1]=strtoul(next+1, NULL, 10);

  SetModemAtFlag(FTP_FLAG_FGSM);
}
#endif //(defined(__EC21_X__) || defined(__UG95__))
#endif //defined(QUECTEL_QUECTEL_MODEM_FTP_PRESENT)

static void QuectelAtParse(char* buff, uint16_t buff_len)
{
  //static uint16_t max_parse_len=0; if(buff_len>max_parse_len) max_parse_len=buff_len;
  if(sms_read_flow.is_wait_data)
  {
    if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)//есть куда копировать
    {
      uint16_t src_len=0;
      uint8_t data_offset=0;
      char* rn_ptr=strstr(buff, "\r\n");

      if(NULL!=rn_ptr && rn_ptr>buff)
      {
        src_len=rn_ptr-buff;
      }

      buff[src_len]='\0';

      if(sms_read_flow.decoding_inf==DATA_IN_UCS2_WO_HEADER || sms_read_flow.decoding_inf==DATA_IN_UCS2_W_HEADER ||
         sms_read_flow.decoding_inf==DATA_IN_WIN1251_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_WIN1251_WO_HEADER ||
           sms_read_flow.decoding_inf==DATA_IN_8BIT_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_8BIT_WO_HEADER)
      {
        if(sms_read_flow.decoding_inf==DATA_IN_UCS2_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_8BIT_W_HEADER)
        {
          /*
          uint8_t idx=0;
          uint8_t udhl=0;
          char conv_buff[3];
          conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
          udhl=(uint8_t)strtoul(conv_buff, NULL, 16);

          data_offset=(1+udhl)*2;

          if(sms_read_flow.chunks_inf!=NULL)
          {
            idx+=2*2;
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->uid=(uint8_t)strtoul(conv_buff, NULL, 16);
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->total=(uint8_t)strtoul(conv_buff, NULL, 16);
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->current=(uint8_t)strtoul(conv_buff, NULL, 16);
          }
          */
          if(sms_read_flow.chunks_inf!=NULL)
          {
            //simcom не шлет эту информацию
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }
        else  if(sms_read_flow.decoding_inf==DATA_IN_WIN1251_W_HEADER)
        {
          /*
          //"тонкое" место с UDH при кодеолвке 7bit, до конца не ясно
          if(memcmp(buff, "00E9", 4)==0)
            data_offset=4+5*4+4;//+padding, 7 septets in length
          else if(memcmp(buff, "00F9", 4)==0)
            data_offset=4+6*4;//7 septets in length
          else //смещение не 5 и не 6
            src_len=0;
          */
          if(sms_read_flow.chunks_inf!=NULL)
          {
            //simcom не шлет эту информацию
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }
        else
        {
          if(sms_read_flow.chunks_inf!=NULL)
          {
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }

        if(data_offset+4<=src_len) //в src как минимум один символ UCS2
        {
          if((src_len-data_offset)/4+1<=sms_read_flow.recv_mem_size)
            src_len=UCS2toWin1251(&buff[data_offset], sms_read_flow.recv_mem_ptr);
          else
            src_len=0;
        }
        else
        {
          src_len=0;
        }

        sms_read_flow.recv_mem_ptr[src_len]='\0';
        sms_read_flow.received_len=src_len;
      }
    }
    sms_read_flow.is_wait_data=0;
  }
  else if(__STRNCMP(buff, "\r\n")==0 ||
     __STRNCMP(buff, "\r")==0 ||
       __STRNCMP(buff, "\r\r\n")==0 ||
         __STRNCMP(buff, "\n")==0
           )
  {
#if EN_MODEM_DEBUG > 0
    //if(modem_rx_log_out_en) printf_en=0;
#endif
  }
  else if(__STRNCMP(buff, ">")==0)
  {
    SetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM);
  }
  else if(__STRNCMP(buff, "OK\r\n")==0)
  {
    SetModemAtFlag(OK_FGSM);
  }
  else if(__STRNCMP(buff, "ERROR\r\n")==0)
  {
    SetModemAtFlag(ERROR_FGSM);
  }
  else if(__STRNCMP(buff, "+QIURC: \"recv\"")==0)
  {
    tcp_socket_new_data_recv(strtoul(&buff[sizeof("+QIURC: \"recv\",")-1], NULL, 10));
  }
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QIRD: ")==0)
  {
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль
    modem_parse.bt_gprs_len_wait=(int16_t)strtol(&buff[7], NULL, 10);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные gprs
    }
  }
  else if(__STRNCMP(buff, "+QISTATE: ")==0 && (buff[10]>='0' && buff[10]<=MAX_CONN_CTX_ID+'0') && sym_cnt_in_str(buff, ',')==9 && strstr(buff, ",,")==NULL)
  {
    ctx_conn_state.ctx=buff[10]-0x30;

    uint16_t offset;
    uint8_t sym_cnt;

    for(offset=11, sym_cnt=0; offset<buff_len; offset++)
    {
      if(buff[offset]==',') sym_cnt++;
      if(sym_cnt==5) break;
    }

    if(sym_cnt==5)
    {
      offset++;
      uint8_t socket_state=(uint8_t)strtoul(&buff[offset], NULL, 10);//(uint8_t)atoi(&buff[offset]);

      if(socket_state==0) ctx_conn_state.state=INITIAL_CONN_STATE;
      else if(socket_state==1) ctx_conn_state.state=CONNECTING_CONN_STATE;
      else if(socket_state==2) ctx_conn_state.state=CONNECTED_CONN_STATE;
      else if(socket_state==3) ctx_conn_state.state=UP_OR_LISTENNING_CONN_STATE;
      else if(socket_state==4) ctx_conn_state.state=CLOSING_CONN_STATE;

      //if(socket_state<=4) SetModemAtFlag(CIPSTATUS_FGSM);
    }
  }
  else if(__STRNCMP(buff, "+QIACT: 1,")==0)
  {
    char* ach=(char*)(buff+(sizeof("+QIACT: 1,")-1));

    if(*ach=='0') modem_state.pdp_context_state=PDP_CONTEXT_DEACTIVATED_STATE;
    else if(*ach=='1') modem_state.pdp_context_state=PDP_CONTEXT_ACTIVATED_STATE;
  }
#else
  else if(__STRNCMP(buff, "+QIRD: ")==0 && sym_cnt_in_str(buff, ',')==2 && strstr(buff, ",,")==NULL)
  {
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль

    char* ach=(char*)buff+sizeof("+QIRD: ");
    ach=strchr(ach, ',');
    ach++;
    ach=strchr(ach, ',');
    ach++;

    modem_parse.bt_gprs_len_wait=(int16_t)strtol(ach, NULL, 10);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные gprs
    }
  }
  else if(__STRNCMP(buff, "+QIRDI: ")==0)
  {
    tcp_socket_new_data_recv(strtoul(&buff[sizeof("+QIRDI: 0,1,")-1], NULL, 10));
  }
  else if(__STRNCMP(buff, "+QISTATE: ")==0 && (buff[10]>='0' && buff[10]<=MAX_CONN_CTX_ID+'0'))
  {
    if(ctx_conn_state.ctx+0x30==buff[10])
    {
      ResetModemAtFlag(OK_FGSM);
      if(NULL!=strstr(buff, "INITIAL"))
      {
        ctx_conn_state.state=INITIAL_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
      else if(NULL!=strstr(buff, "CONNECTING"))
      {
        ctx_conn_state.state=CONNECTING_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
      else if(NULL!=strstr(buff, "CONNECTED"))
      {
        ctx_conn_state.state=CONNECTED_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
      else if(NULL!=strstr(buff, "REMOTE CLOSING"))
      {
        ctx_conn_state.state=REMOTE_CLOSING_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
      else if(NULL!=strstr(buff, "CLOSING"))
      {
        ctx_conn_state.state=CLOSING_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
      else if(NULL!=strstr(buff, "CLOSED"))
      {
        ctx_conn_state.state=CLOSED_CONN_STATE;
        SetModemAtFlag(CIPSTATUS_FGSM);
      }
    }
  }
  else if(__STRNCMP(buff, "+PDP DEACT\r\n")==0)
  {
    modem_state.pdp_deact_event=1;
    modem_state.pdp_context_state=PDP_CONTEXT_DEACTIVATED_STATE;
  }
  else if(__STRNCMP(buff+1, ", CLOSE OK\r\n")==0 && (buff[0]>='0' && buff[0]<=MAX_CONN_CTX_ID+'0'))
  {
    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
    {
      SetModemAtFlag(CLOSE_OK_FGSM);
    }
  }
  else if(__STRNCMP(buff, "+QDSIM: ")==0)
  {
    char* ach=(char*)buff+sizeof("+QDSIM: ")-1;
    modem_state.perf_sim_id=(uint8_t)strtoul(ach, NULL, 10);//atoi(ach);
  }
#endif
  else if(__STRNCMP(buff, "SEND OK\r\n")==0)
  {
      SetModemAtFlag(CIPSEND_SEND_OK_FGSM);
  }
  else if(__STRNCMP(buff, "SEND FAIL\r\n")==0)
  {
      SetModemAtFlag(CIPSEND_SEND_FAIL_FGSM);
  }
//todo: ниже закоментирован режим с контролем id соединения при передаче (если такой режим, почему было сделано так?)
//  else if(__STRNCMP(buff+1, ", BT SEND OK\r\n")==0 && (buff[0]>=BT_CONN_CTX_FIRST_ID+'0' && buff[0]<=BT_CONN_CTX_LAST_ID+'0'))
//  {
//    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
//    {
//      SetModemAtFlag(BT_SEND_OK_FGSM);
//    }
//  }
//  else if(__STRNCMP(buff+1, ", BT SEND FAIL\r\n")==0 && (buff[0]>=BT_CONN_CTX_FIRST_ID+'0' && buff[0]<=BT_CONN_CTX_LAST_ID+'0'))
//  {
//    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
//    {
//      SetModemAtFlag(BT_SEND_FAIL_FGSM);
//    }
//  }
  else if(__STRNCMP(buff, "+CPMS: ")==0 && sym_cnt_in_str(buff, ',')==8)
  {
    //+CPMS: "MT",35,35,"MT",35,35,"MT",35,35
    char* ach=(char*)(buff+sizeof("+CPMS: ")-1);

    uint8_t used;
    uint8_t total;

    ach=strchr(ach,',')+1;
    used=(uint8_t)strtoul(ach, NULL, 10);//(uint8_t)atoi(ach);
    ach=strchr(ach,',')+1;
    total=(uint8_t)strtoul(ach, NULL, 10);//(uint8_t)atoi(ach);

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.sms_inf.used=used;
    modem_state.sms_inf.total=total;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
#if defined(__EC21_X__)
   else if(__STRNCMP(buff, "+QISEND: ")==0 && sym_cnt_in_str(buff, ',')==2)
   {
     //+QISEND: <total_send_length>,<ackedbytes>,<unackedbytes>
     if(!bt_gprs_flow.conn_data_trans_state.is_updated)
     {
       char* src=(char*)(buff+sizeof("+QISEND: ")-1);
       char* next;

       bt_gprs_flow.conn_data_trans_state.txlen=strtoul(src, &next, 10);
       src=next+1;
       bt_gprs_flow.conn_data_trans_state.acklen=strtoul(src, &next, 10);
       src=next+1;
       bt_gprs_flow.conn_data_trans_state.nacklen=strtoul(src, &next, 10);

       bt_gprs_flow.conn_data_trans_state.is_updated=1;
     }
   }
#elif defined(__MC60__)
   else if(__STRNCMP(buff, "+QISACK: ")==0 && sym_cnt_in_str(buff, ',')==2)
   {
     //+QISACK: <sent>, <acked>, <nAcked>
     if(!bt_gprs_flow.conn_data_trans_state.is_updated)
     {
       char* src=(char*)(buff+sizeof("+QISACK: ")-1);
       char* next;

       bt_gprs_flow.conn_data_trans_state.txlen=strtoul(src, &next, 10);
       src=next+1;
       bt_gprs_flow.conn_data_trans_state.acklen=strtoul(src, &next, 10);
       src=next+1;
       bt_gprs_flow.conn_data_trans_state.nacklen=strtoul(src, &next, 10);

       bt_gprs_flow.conn_data_trans_state.is_updated=1;
     }
   }
#endif //(defined(__EC21_X__) || defined(__MC60__))
  else if(__STRNCMP(buff, "+CMGR: ")==0)
  {
#if defined(CMGR_DEBUG)
    snprintf(cmgr_buff, sizeof(cmgr_buff), "%.*s\n",buff_len, buff);
#endif //defined(CMGR_DEBUG)
    //+CMGR: "REC READ","VTB\11BMoskvy",,"16/06/06,17:13:52+24",208,64,0,8,"+79139869990",145,121//AT+CSDH=1
    //+CMGR: "REC READ","VTB\11BMoskvy",,"16/06/06,17:13:52+24"//AT+CSDH=0
    //+CMGR: 0,,0//AT+CSDH=0, AT+CSDH=1
    //MC60:   +CMGR: "REC UNREAD","002B00370039003200330031003700380030003600360031","","2019/07/22 07:33:55+12",145,4,0,0,"002B00370039003000340033003400390030003000300030",145,11
    //UC200T: +CMGR: "REC UNREAD",002B00370039003200330031003700380030003600360031,,"20/05/06,12:55:12+12",145,4,1,0,11
    //For SMS-DELIVER:+CMGR: <stat>,<oa>,[<alpha>],<scts>[,<tooa>,<fo>,<pid>,<dcs>,       <sca>,<tosca>,<length>]<CR><LF><data>
    //For SMS-SUBMIT: +CMGR: <stat>,<da>,[<alpha>]       [,<toda>,<fo>,<pid>,<dcs>,[<vp>],<sca>,<tosca>,<length>]<CR><LF><data>

    sms_stat_t stat;
    char* ach=(char*)(buff+sizeof("+CMGR: ")-1);
    if(__STRNCMP(ach, "0,,0")==0)
    {
      //пустая запись
      stat=SMS_REC_EMTY;
    }
    else if(strstr(ach, "\"REC UNREAD\""))
    {
      stat=SMS_REC_UNREAD;
    }
    else if(strstr(ach, "\"REC READ\""))
    {
      stat=SMS_REC_READ;
    }
    else
    {
      stat=SMS_REC_OTHER;
    }

    if(stat==SMS_REC_READ || stat==SMS_REC_UNREAD)
    {
     //SMS-DELIVER и SMS-SUBMIT отличаются по количеству запятых,
     //в SMS-DELIVER обязательно поле даты <scts>, там дополнительная запятая
     //как отличить для MC60?
#if (defined(__MC60__))
      static const uint8_t comma_cnt=10;//в дате отсутвует запятая
      static const uint8_t skip_cnt=4;
#else
#if (defined(__UG95__))
#warning не проверялось
#endif
#if (defined(__UC200T__))
#warning не проверялось, формат другой. После первого удаления, смс больше не принимаются, всегда +CPMS: "ME",0,180,"ME",0,180,"ME",0,180
#endif
      static const uint8_t comma_cnt=10+1;//+1 запятая в дате
      static const uint8_t skip_cnt=4+1;
#endif

      if((sym_cnt_in_str(buff, ',')==comma_cnt)
#if (defined(__MC60__))
         && (sym_cnt_in_str(buff, '/')==2)//в дате <scts> должны быть '/'
#endif //(defined(__MC60__))
           )
      {
        for(uint8_t i=0; i<1; i++) ach=strchr(ach, ',')+1;
        if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        {
          uint8_t phone_len=0;
          char* phone=NULL;

          if(*ach=='"')
          {
            phone=ach+1;
            if(strchr(phone, '"')!=NULL) phone_len=strchr(phone, '"')-phone;
          }

          if(phone!=NULL && phone_len/4+1<=sms_read_flow.phone_mem_size)
          {
            //memcpy(sms_read_flow.phone, phone, phone_len);
            //sms_read_flow.phone[phone_len]='\0';
            phone[phone_len]='\0';
            UCS2toWin1251(phone, sms_read_flow.phone);
            phone[phone_len]='"';
            sms_read_flow.phone[sms_read_flow.phone_mem_size-1]='\0';
          }
          else
          {
            *sms_read_flow.phone='\0';
          }
        }

        for(uint8_t i=0; i<skip_cnt; i++) ach=strchr(ach, ',')+1;
        uint8_t fo=(uint8_t)strtoul(ach, NULL, 10);
        for(uint8_t i=0; i<2; i++) ach=strchr(ach, ',')+1;
        uint8_t dcs=(uint8_t)strtoul(ach, NULL, 10);
        for(uint8_t i=0; i<3; i++) ach=strchr(ach, ',')+1;
        uint8_t plength=(uint8_t)strtoul(ach, NULL, 10);

        //пришло смс, но длина нулевая
        if(!plength)
        {
          sms_read_flow.is_wait_data=0;

          if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
            *sms_read_flow.phone='\0';
          if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
            *sms_read_flow.recv_mem_ptr='\0';

          sms_read_flow.is_emty=0;

          goto cmgr_exit;
        }

        if(((dcs&SMS_DCS_MASK)==SMS_DCS_DEFAULT_GSM))
        {
          //GSM Default alphabet
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
          {
            sms_read_flow.decoding_inf=DATA_IN_WIN1251_W_HEADER;
          }
          else
          {
            sms_read_flow.decoding_inf=DATA_IN_WIN1251_WO_HEADER;
          }
        }
        else if((dcs&SMS_DCS_MASK)==SMS_DCS_USC2_GSM)
        {
          //USC2 (16 бит)
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
            sms_read_flow.decoding_inf=DATA_IN_UCS2_W_HEADER;
          else
            sms_read_flow.decoding_inf=DATA_IN_UCS2_WO_HEADER;
        }
        else if((dcs&SMS_DCS_MASK)==SMS_DCS_8BIT_GSM)
        {
          //8бит
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
            sms_read_flow.decoding_inf=DATA_IN_8BIT_W_HEADER;
          else
            sms_read_flow.decoding_inf=DATA_IN_8BIT_WO_HEADER;
        }
        else
        {
          //reserve или что-то не то с форматоматом, не умеем конвертировать, читаем в "пустую"
          if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
            *sms_read_flow.recv_mem_ptr='\0';

          sms_read_flow.recv_mem_ptr=NULL;
        }
      }
      else
      {
        //что-то не то с форматом, читаем в "пустую"
        sms_read_flow.recv_mem_ptr=NULL;
      }
      sms_read_flow.is_wait_data=1;
      sms_read_flow.is_emty=0;
    }
    else if(stat==SMS_REC_EMTY)
    {
      //ожидаем OK
      sms_read_flow.is_wait_data=0;

     if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        *sms_read_flow.phone='\0';
      if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
        *sms_read_flow.recv_mem_ptr='\0';

      sms_read_flow.is_emty=1;
    }
    else
    {
      //читаем в "пустую"
      sms_read_flow.is_wait_data=1;

      if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        *sms_read_flow.phone='\0';
      if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
        *sms_read_flow.recv_mem_ptr='\0';

      sms_read_flow.recv_mem_ptr=NULL;
      sms_read_flow.is_emty=0;
    }
  cmgr_exit: {}
  }
  else if(__STRNCMP(buff, "+CFUN: ")==0)
  {
    modem_state.cfun_state=buff[sizeof("+CFUN: ")-1]-0x30;
    SetModemAtFlag(CFUN_X_FGSM);
  }
  else if(__STRNCMP(buff, "+CPIN: READY\r\n")==0)
  {
    SetModemAtFlag(SIMREADY_FGSM);
  }
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QIND: PB DONE\r\n")==0)
#else
  else if(__STRNCMP(buff, "Call Ready\r\n")==0)
#endif
  {
    SetModemAtFlag(CALL_READY_FGSM);
  }
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QIND: SMS DONE\r\n")==0)
#else
  else if(__STRNCMP(buff, "SMS Ready\r\n")==0)
#endif
  {
    SetModemAtFlag(SMS_READY_FGSM);
  }
#if defined(__SIM800_DS__)
  else if(__STRNCMP(buff, "+CPINDS: READY\r\n")==0)
  {
    SetModemAtFlag(SIMREADY_DS_FGSM);
  }
  else if(__STRNCMP(buff, "Call Ready DS\r\n")==0)
  {
    SetModemAtFlag(CALL_READY_DS_FGSM);
  }
  else if(__STRNCMP(buff, "SMS Ready DS\r\n")==0)
  {
    SetModemAtFlag(SMS_READY_DS_FGSM);
  }
#endif //__SIM800_DS__
  else if(__STRNCMP(buff, "+CME ERROR: ")==0)
  {
    const char* ach=(const char*)(buff+(sizeof("+CME ERROR: ")-1));

    modem_state.last_cme_error=(uint16_t)strtoul(ach, NULL, 10);

    if(modem_state.last_cme_error==10 || modem_state.last_cme_error==11 ||
       modem_state.last_cme_error==12 || modem_state.last_cme_error==13 ||
       modem_state.last_cme_error==310 || modem_state.last_cme_error==313)
    {
      modem_state.is_sim_failure=1;
    }

    SetModemAtFlag(ERROR_FGSM);
  }
  else if(__STRNCMP(buff, "+CMS ERROR: ")==0)
  {
    SetModemAtFlag(ERROR_FGSM);
  }
  //todo: проверить на запрос принудительно через AT+CREG? Не тестировалось на модемах QUECTEL
  else if((__STRNCMP(buff, "+CREG: ")==0 && (buff[7]>='0' && buff[7]<='5' && buff[7]!='4'))
#if defined(__SIM800_DS__)
          || (__STRNCMP(buff, "+CREGDS: ")==0 && (buff[9]>='0' && buff[9]<='5' && buff[9]!='4'))
#endif //__SIM800_DS__
          )
  {
    //e.g. +CREG: d,"hhhh","hhhhhhhh",d or +CREG: 2
    //or +CREG: 2,d,"hhhh,"hhhhhhhh",d if response from AT+CREG?

    //может ли быть такое URC?
    //e.g. +CREGDS: d,"hhhh","hhhhhhhh",d or +CREGDS: 2
    //or +CREGDS: 2,d,"hhhh,"hhhhhhhh",d if response from AT+CREG?

    creg_state_t* creg;
    uint8_t is_urc;
    uint8_t offset=0;

    creg=(creg_state_t*)(2+strchr((char*)buff,'\r'));

#if defined(__SIM800_DS__)
    if(__STRNCMP(buff, "+CREGDS: ")==0) offset=2;
#endif //__SIM800_DS__

    //определяем ответ на команду или urc
    char* ach=(char*)buff;
    char* next;

    if(__STRNCMP(ach+strlen("+CREG: d")+offset, "\r\n")==0)
      is_urc=1;
    else if(__STRNCMP(ach+strlen("+CREG: d")+offset, ",\"")==0)
      is_urc=1;
    else if(__STRNCMP(ach+strlen("+CREG: 2,d")+offset, "\r\n")==0)
      is_urc=0;
    else if(__STRNCMP(ach+strlen("+CREG: 2,d")+offset, ",\"")==0)
      is_urc=0;
    else //неизвестное, пропускаем
      is_urc=2;

    if(2>is_urc)
    {
      if(is_urc)
        ach+=(sizeof("+CREG: ")-1)+offset;
      else
        ach+=(sizeof("+CREG: 2,")-1)+offset;

      creg->regStatus=(uint8_t)strtoul(ach, &next, 10);

      if(*(next+0)==',' && *(next+1)=='"' && (creg->regStatus==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || creg->regStatus==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS))
      {
        ach=next+2;
        creg->netLac=(uint16_t)strtoul(ach, &next, 16);

        if(*(next+0)=='"' && *(next+1)==',' && *(next+2)=='"')
        {
          ach=next+3;
          creg->netCellId=(uint32_t)strtoul(ach, &next, 16);

          if(*(next+0)=='"' && *(next+1)==',')
          {
            ach=next+2;
            creg->AcT=(uint8_t)strtoul(ach, NULL, 10);
          }
          else
          {
            creg->AcT=UNKNOWN_ACT_STATUS;
          }
        }
        else
        {
          creg->netCellId=0;
          creg->AcT=UNKNOWN_ACT_STATUS;
        }
      }
      else
      {
        creg->netLac=0;
        creg->netCellId=0;
        creg->AcT=UNKNOWN_ACT_STATUS;
      }

      if(offset==0)
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        modem_state.creg_state.regStatus = creg->regStatus;
        modem_state.creg_state.netLac = creg->netLac;
        modem_state.creg_state.netCellId = creg->netCellId;
        modem_state.creg_state.AcT = creg->AcT;
        xSemaphoreGive( modem_at_flags.lock_obj );

        if(!is_urc) SetModemAtFlag(CREG_FGSM);//if not URC
      }
#if defined(__SIM800_DS__)
      else
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        modem_state.ds_creg_state.regStatus = creg->regStatus;
        modem_state.ds_creg_state.netLac = creg->netLac;
        modem_state.ds_creg_state.netCellId = creg->netCellId;
        modem_state.ds_creg_state.AcT = creg->AcT;
        xSemaphoreGive( modem_at_flags.lock_obj );

        if(!is_urc) SetModemAtFlag(CREG_DS_FGSM);//if not URC
      }
#endif //__SIM800_DS__
    }
  }
  else if(__STRNCMP(buff, "+CPIN: NOT INSERTED\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_INSERTED_FGSM);
  }
  else if(__STRNCMP(buff, "+CPIN: NOT READY\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_READY_FGSM);
  }
#if defined(__SIM800_DS__)
  else if(__STRNCMP(buff, "+CPINDS: NOT INSERTED\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_INSERTED_DS_FGSM);
  }
#endif //__SIM800_DS__
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "POWERED DOWN\r\n")==0)
#else
  else if(__STRNCMP(buff, "NORMAL POWER DOWN\r\n")==0 || __STRNCMP(buff, "NORMAL POWER DOWN \r\n")==0)
#endif
  {
    SetModemAtFlag(NORMAL_POWER_DOWN_FGSM);
  }
  else if(__STRNCMP(buff, "+CSQ: ")==0 && (buff[6]>='0' && buff[6]<='9') )
  {
    char* ach=(char*)(buff+(sizeof("+CSQ: ")-1));
    uint8_t var;
    var=(uint8_t)strtoul(ach, NULL, 10);//(uint8_t)atoi(ach);
    if(var<=31 || var==99)
      modem_state.rssi_level=var;
    else
      modem_state.rssi_level=99;
  }
  else if(__STRNCMP(buff, "+COPS: ")==0 && (buff[11]=='"' && (buff[17]=='"' ||  buff[18]=='"')))
  {
    //+COPS: 0,2,"25002"
    char* ach=(char*)&buff[12];

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.operator_inf.mnc=(uint16_t)strtoul(ach+3, NULL, 10);//(uint16_t)atoi(ach+3);
    *(ach+3)='\0';
    modem_state.operator_inf.mcc=(uint16_t)strtoul(ach, NULL, 10);//(uint16_t)atoi(ach);
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "RDY\r\n")==0
          || __STRNCMP((buff+1), "RDYr\n") == 0
            || __STRNCMP((buff+2), "RDY\r\n") == 0
              )
  {
    SetModemAtFlag(RDY_FGSM);
  }
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QNTP: 0,\"")==0)
#else
  else if(__STRNCMP(buff, "+QNTP: 0\r\n")==0)
#endif
  {
     modem_time.is_ntp_synced=1;
  }
  else if(__STRNCMP(buff, "+CCLK: \"")==0)
  {
    //+CCLK: "16/03/30,13:14:05+24"
    if(modem_time.is_ntp_synced)
    {//если было событие сихронизации со временем сети
      const char* src=&buff[sizeof("+CCLK: \"")-1];
      char* next;
      time_struct_t time;
      uint32_t utime;
      uint8_t s_gmt;
      uint32_t gmt;

      uint8_t is_fmt_ok=0;
      for(;;)
      {
        time.year=(uint8_t)strtoul(src, &next, 10);
        time.year+=2000;
        if(time.year<2016) break;
        if(*next!='/') break;
        src=next+1;
        time.mon=(uint8_t)strtoul(src, &next, 10);
        if(*next!='/') break;
        src=next+1;
        time.day=(uint8_t)strtoul(src, &next, 10);
        if(*next!=',') break;
        src=next+1;
        time.hour=(uint8_t)strtoul(src, &next, 10);
        if(*next!=':') break;
        src=next+1;
        time.min=(uint8_t)strtoul(src, &next, 10);
        if(*next!=':') break;
        src=next+1;
        time.sec=(uint8_t)strtoul(src, &next, 10);
        if(*next=='+') s_gmt=0;
        else if(*next=='-') s_gmt=1;
        else break;
        src=next+1;
        gmt=(uint32_t)strtoul(src, NULL, 10);
        if(gmt>48) break;

        is_fmt_ok=1;
        break;
      }

      if(is_fmt_ok)
      {
        utime=conv_time_to_unixtime(&time);
        gmt=(gmt*60*60)/4;
        if(s_gmt) utime+=gmt;
        else utime-=gmt;

        modem_time.modem_utime=utime;
        //SetModemAtFlag(OK_FGSM);
      }
      else
      {
        modem_time.modem_utime=0;
        //SetModemAtFlag(ERROR_FGSM);
      }
    }
    else
    {
      modem_time.modem_utime=0;
      //SetModemAtFlag(ERROR_FGSM);
    }
  }
  /*
  else if(__STRNCMP(buff, "*PSUTTZ: ")==0 && sym_cnt_in_str(buff, ',')==7 && strstr(buff, ",,")==NULL)
  {
    *PSUTTZ: 2016,3,30,7,13,58,"+24",0
    const char* src=&buff[sizeof("*PSUTTZ: ")-1];
    char* next;
    time_struct_t time;

    time.year=(uint16_t)strtoul(src, &next, 10);
    src=next+1;
    time.mon=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.day=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.hour=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.min=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.sec=(uint8_t)strtoul(src, NULL, 10);

    if(time.year<2016)
    {
      modem_time.last_sync_utime=0;
    }
    else
    {
      modem_time.last_sync_utime=conv_time_to_unixtime(&time);
    }
  }
  else if(__STRNCMP(buff, "UNDER-VOLTAGE POWER DOWN")==0 || __STRNCMP(buff, "UNDER-VOLTAGE WARNNING")==0)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.power_status=UNDERVOLTAGE_MODEM_POWER_STATUS;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "OVER-VOLTAGE POWER DOWN")==0 || __STRNCMP(buff, "OVER-VOLTAGE WARNNING")==0)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.power_status=OVERVOLTAGE_MODEM_POWER_STATUS;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  */
  else if(__STRNCMP(buff, "+QJDR: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    const char* ach=(const char*)(buff+(sizeof("+QJDR: ")-1));

    if(__STRNCMP(ach, "NOJAMMING")==0)       {modem_state.jamming_state=NO_JAMMING;}
    else if(__STRNCMP(ach, "NO JAMMING")==0) {modem_state.jamming_state=NO_JAMMING;}
    else if(__STRNCMP(ach, "JAMMED")==0)     {modem_state.jamming_state=JAMMING_DETECTED;}
  }
  /*
  else if(__STRNCMP(buff, "+CMTE: ")==0)
  {
    const char* ach=(const char*)(buff+(sizeof("+CMTE: ")-1));

    int8_t var=(int8_t)strtol(ach, NULL, 10);

    //xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    if(var==0)
      modem_state.temp_status=NORMAL_MODEM_TEMP_STATUS;
    else if(var==1)
      modem_state.temp_status=UPPER_MODEM_TEMP_STATUS;
    else if(var==2)
      modem_state.temp_status=UPPERMOST_MODEM_TEMP_STATUS;
    else if(var==-1)
      modem_state.temp_status=LOW_MODEM_TEMP_STATUS;
    else if(var==-2)
      modem_state.temp_status=LOWEST_MODEM_TEMP_STATUS;
    //xSemaphoreGive( modem_at_flags.lock_obj );
  }
  */
  else if(__STRNCMP(buff, "RING\r\n")==0)
  {
    //modem_state.is_ready_to_ata_cmd=1;
  }
  else if(__STRNCMP(buff, "+CLIP: \"")==0)
  {
//    //+CLIP: "+79231780661",145,"",0,"",0
//    char* phone=(char*)(buff+strlen("+CLIP: \""));
//    char* end_str=strstr(phone, "\",");
//
//    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
//    memset(modem_state.incoming_call_number, 0, sizeof(modem_state.incoming_call_number));
//    modem_state.incoming_call_indicator=1;
//    if(end_str!=NULL)
//    {
//      uint16_t copy_len=end_str-phone;
//      if(copy_len<sizeof(modem_state.incoming_call_number) && copy_len>=7)
//      {
//      memcpy(modem_state.incoming_call_number, phone, copy_len);
//      }
//    }
//    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "+CLCC: ")==0 && (sym_cnt_in_str(buff, ',')==6 || sym_cnt_in_str(buff, ',')==4) && strstr(buff, ",,")==NULL)
  {
    //+CLCC: 1,1,4,0,0,"+79231780661",145
    const char* ach=(const char*)(buff+(sizeof("+CLCC: ")-1));
    char* next;

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.call_state.is_call_present=1;

    uint8_t id=(uint8_t)strtoul(ach, &next, 10);//id
    ach=next+1;
    //обрабатываем только звонок с id=1, другие звонки будут удержаны, после завершения работы с id=1, последующие будут отключены
    if(id==1)
    {
    modem_state.call_state.dir=(call_dir_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.call_state.stat=(call_stat_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.call_state.mode=(call_mode_t)strtoul(ach, &next, 10);
    ach=next+1;
    strtoul(ach, &next, 10);//empty
    ach=next;

    //есть номер
    if(ach[0]==',' && ach[1]=='"')
    {
      ach+=2;
      for(uint8_t i=0; i<(sizeof(modem_state.call_state.number)-1); i++)
      {
        modem_state.call_state.number[i]=ach[i];
        modem_state.call_state.number[i+1]='\0';
        if(ach[i+1]=='"' || ach[i+1]==',') break;
      }
    }
  }
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "NO CARRIER\r\n")==0)
  {
    //xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    //modem_state.incoming_call_indicator=0;
    //memset(modem_state.incoming_call_number, 0, sizeof(modem_state.incoming_call_number));
    //xSemaphoreGive( modem_at_flags.lock_obj );
  }

#if defined(QUECTEL_MODEM_FTP_PRESENT)
#if defined(__MC60__)
  //могу быть с пробелом и без после :
  else if(__STRNCMP(buff, "+QFTPPATH:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPPATH:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPCFG:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPCFG:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPOPEN:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPOPEN:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPGET:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPGET:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPCLOSE:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPCLOSE:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPSIZE:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPSIZE:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPLIST:")==0)
  {
    ftp_strtol_handle(&buff[sizeof("+QFTPLIST:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPSTAT:")==0)
  {
    modem_state.ftp_res=INT32_MIN;
    const char* ach=(const char*)(&buff[sizeof("+QFTPSTAT:")-1]);
    if(ach[0]==' ') {ach++;}

    if(__STRNCMP(ach, "IDLE")==0)          {modem_state.ftp_res=0;}
    else if(__STRNCMP(ach, "OPENING")==0)  {modem_state.ftp_res=1;}
    else if(__STRNCMP(ach, "OPENED")==0)   {modem_state.ftp_res=2;}
    else if(__STRNCMP(ach, "WORKING")==0)  {modem_state.ftp_res=3;}
    else if(__STRNCMP(ach, "TRANSFER")==0) {modem_state.ftp_res=4;}
    else if(__STRNCMP(ach, "CLOSING")==0)  {modem_state.ftp_res=5;}
    else if(__STRNCMP(ach, "CLOSED")==0)   {modem_state.ftp_res=6;}
  }
  else if(__STRNCMP(buff, "+QFTPREAD:")==0)
  {
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль
    modem_parse.bt_gprs_len_wait=(int16_t)strtol(&buff[sizeof("+QFTPREAD:")-1], NULL, 10);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные
    }
  }
#endif //defined(__MC60__)

#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QFTPCWD:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPCWD:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPOPEN:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPOPEN:")-1]);
  }
  else if(__STRNCMP(buff, "+:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPCLOSE:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPSIZE:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPSIZE:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPLIST:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPLIST:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPSTAT:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+QFTPSTAT:")-1]);
  }
  else if(__STRNCMP(buff, "+QFTPGET:")==0)
  {
    //после CONNECT может прийти меньше данных, в этом случае CIPRXGET_BTSPPGET_ENDDATA_FGSM выставляем в потоке
    char* next;
    memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
    modem_state.ftp_res[0]=strtoul(&buff[sizeof("+QFTPGET:")-1], &next, 10);
    modem_state.ftp_res[1]=strtoul(next+1, NULL, 10);
    SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
  }
#endif //(defined(__EC21_X__) || defined(__UG95__))
#endif //defined(QUECTEL_MODEM_FTP_PRESENT)

  else if(__STRNCMP(buff, "+CGEV: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  else if(__STRNCMP(buff, "Revision: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("Revision: ")-1));
  }
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QCCID: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QCCID: ")-1));
  }
#else
  else if(__STRNCMP(buff, "+CCID: \"")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+CCID: \"")-1));
  }
#endif
#if (defined(__EC21_X__) || defined(__UG95__))
  else if(__STRNCMP(buff, "+QENG: \"servingcell\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"servingcell\",")-1));
  }
  else if(__STRNCMP(buff, "+QENG: \"neighbourcell\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"neighbourcell\",")-1));
  }
  else if(__STRNCMP(buff, "+QENG: \"neighbourcell intra\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"neighbourcell intra\",")-1));
  }
  else if(__STRNCMP(buff, "+QENG: \"neighbourcell inter\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"neighbourcell inter\",")-1));
  }
  else if(__STRNCMP(buff, "+QENG: \"3gcomm\",\"servingcell\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"3gcomm\",\"servingcell\",")-1));
  }
  else if(__STRNCMP(buff, "+QENG: \"3gcomm\",\"neighbourcell\",")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QENG: \"3gcomm\",\"neighbourcell\",")-1));
  }
#else
  //
#endif
//->FILES->
  else if(__STRNCMP(buff, "CONNECT ")==0)
  {
    //данные файла
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль
    modem_parse.bt_gprs_len_wait=(int16_t)strtol(&buff[sizeof("CONNECT ")-1], NULL, 10);//atoi(&buff[sizeof("CONNECT ")-1]);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные файла
    }
  }
#if defined(QUECTEL_MODEM_FTP_PRESENT)
#if (defined(__EC21_X__) || defined(__UG95__))
  //FTP загрузка. Не перемещать
  else if(bt_gprs_flow.rx_ctx==0xFFFFFFF0 && __STRNCMP(buff, "CONNECT\r\n")==0)
  {
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль
    modem_parse.bt_gprs_len_wait=bt_gprs_flow.ftp_expect_rx_len;
  }
#endif //(defined(__EC21_X__) || defined(__UG95__))
#endif //defined(QUECTEL_MODEM_FTP_PRESENT)
  else if(__STRNCMP(buff, "CONNECT\r\n")==0)
  {
    SetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM);
  }
  else if(__STRNCMP(buff, "+QFLST: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QFLST: ")-1));
  }
  else if(__STRNCMP(buff, "+QFLDS: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+QFLDS: ")-1));
  }
  else if(__STRNCMP(buff, "+QFOPEN: ")==0)
  {
    bt_gprs_flow.rx_ctx=strtoul(&buff[sizeof("+QFOPEN: ")-1], NULL, 10);//(uint8_t)atoi(&buff[sizeof("+QFOPEN: ")-1]);
    parse_aux_data((char*)(buff+sizeof("+QFOPEN: ")-1));
  }
//<-FILES<-
#if (defined(__MC60__))
  else if(__STRNCMP(buff, "+QSPPREAD: ")==0)
  {
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//костыль
    modem_parse.bt_gprs_len_wait=(int16_t)strtol(&buff[sizeof("+QSPPREAD: ")-1], NULL, 10);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные bt
    }
  }
  else if(__STRNCMP(buff, "+QBTACPT: ")==0 && (buff[10]==1+'0' && buff[11]>=',') && strstr(buff, "\"SPP\"")!=NULL) //+QBTACPT: 1, 2,“btd_left”,656261222B10,“SPP” //After connecting successfully, MCU can send and
  {
    if(buff[12] == 1+'0')
    {
      bt_gprs_flow.bt_spp_ctx=buff[13]-0x30;
      bt_gprs_flow.is_spp_conn_available=1;
    }
    else
    {
      bt_gprs_flow.bt_spp_ctx=0xff;
    }
  }
  else if((__STRNCMP(buff, "+QBTSTATE:")==0) && (buff[11]==1+'0') && (buff[12]>=',') && (strstr(buff, "\"SPP\"")!=NULL)) //+QBTSTATE: 1,2,"Galaxy A6+",74EB8020DDC1,"SPP"
  {
    bt_gprs_flow.bt_spp_ctx=buff[13]-0x30;
    bt_gprs_flow.is_spp_conn_available=1;
  }
  else if((__STRNCMP(buff, "+QBTSTATE:")==0) && (buff[11]=='0') && (buff[12]>=',')) //+QBTSTATE: 0,2,"Galaxy A6+",74EB8020DDC1
  {
    num_bt_device++;
  }
  else if(__STRNCMP(buff, "+QBTBTDISCONN: ")==0 && strstr(buff, "\"SPP\"")!=NULL)
  {
    //+BTDISCONN: "Lenovo P780",ac:38:70:68:80:4e,"SPP"
    bt_gprs_flow.bt_spp_ctx=0xff;
  }
  else if(__STRNCMP(buff, "+QBTPWR: ")==0)
  {
    //+QBTPWR: <power_status>
    bt_gprs_flow.bt_status=(uint8_t)strtoul(&buff[sizeof("+QBTPWR: ")-1], NULL, 10);
  }
  else if(__STRNCMP(buff, "+QBTIND: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    buff+=(sizeof("+QBTIND: ")-1);

    if(__STRNCMP(buff, "\"pair\",")==0)
    {
      buff+=(sizeof("\"pair\",")-1);

      SetModemAtFlag(BT_PAIR_REQUEST_FGSM);
    }
    else if(__STRNCMP(buff, "\"conn\",")==0)
    {
      buff+=(sizeof("\"conn\",")-1);

      if(strstr(buff, "\"SPP\"")!=NULL)  SetModemAtFlag(BT_SPP_CONNECTING_FGSM);

      tcp_socket_new_data_recv(0xFF);
    }
    else if(__STRNCMP(buff, "\"disc\",")==0)
    {
      buff+=(sizeof("\"disc\",")-1);

      tcp_socket_new_data_recv(0xFF);
    }
    else if(__STRNCMP(buff, "\"recv\",")==0)
    {
      buff+=(sizeof("\"recv\",")-1);

      tcp_socket_new_data_recv(0xFF);
    }
    else if(__STRNCMP(buff, "\"ring\",")==0)
    {
      buff+=(sizeof("\"ring\",")-1);

    }
  }
  else if(__STRNCMP(buff, "+QBTPAIRCNF: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    buff+=(sizeof("+QBTPAIRCNF: ")-1);

  }
  else if(__STRNCMP(buff, "+QBTGATCSCAN: ")==0)
  {
    //__PRINTF("%.*s", buff_len, buff);

#if BLE_SCAN_TABLE_SIZE > 0
    if(sym_cnt_in_str(buff, ',')==3 && strstr(buff, ",,")==NULL && buff[buff_len-2]=='\r' && buff[buff_len-1]=='\n')
    {
      const uint16_t len=buff_len-(sizeof("\r\n")-1);
      uint16_t offset=sizeof("+QBTGATCSCAN: \"")-1;

      const uint16_t gserv_id=(uint16_t)strtoul(&buff[offset], NULL, 16);

      if(ble_scan_gat_id==gserv_id && ble_scan_table_idx<BLE_SCAN_TABLE_SIZE)
      {
        bt_gat_scan_t* const lescan=&ble_scan_table[ble_scan_table_idx];

        for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}

        for(uint8_t i=0; i<sizeof(lescan->mac); i++)
        {
          lescan->mac[sizeof(lescan->mac)-1-i]=(char_to_hex(buff[offset++])<<4);
          lescan->mac[sizeof(lescan->mac)-1-i]|=(char_to_hex(buff[offset++])<<0);
        }

        if(IsBleMacScanIgnore(lescan->mac))
        {
          memset(lescan->mac, 0, sizeof(lescan->mac));
        }
        else
        {
          for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}

          lescan->rssi=(int8_t)(strtol(&buff[offset], NULL, 10)-127);

          for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}

          for(lescan->eir_len=0; lescan->eir_len<sizeof(lescan->eir); lescan->eir_len++)
          {
            if(offset>=len) break;
            lescan->eir[lescan->eir_len]=(char_to_hex(buff[offset++])<<4);
            if(offset>=len) break;
            lescan->eir[lescan->eir_len]|=(char_to_hex(buff[offset++])<<0);
          }

          ble_scan_table_idx++;
        }
      }
    }
#endif //BLE_SCAN_TABLE_SIZE > 0
  }
  else if(__STRNCMP(buff, "+QBTGATCREG: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  else if(__STRNCMP(buff, "+QGATCFGSCAN: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  else if(__STRNCMP(buff, "+QBTLETXPWR: ")==0 || __STRNCMP(buff, "+QBTGATRFPWR: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }

  //->testing->
  /*
  //Connect/Disconnect GATT Client to Remote LE Device
  else if(__STRNCMP(buff, "+QBTGATCCON: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    buff+=(sizeof("+QBTGATCCON: ")-1);

    if(strstr(buff, ",,")==NULL)
    {
      const uint16_t delim_count = sym_cnt_in_str(buff, ',');

      if(delim_count==1)
      {
        //AT+QBTGATCCON?
        //+QBTGATCCON: 1,E8CF31FA02E8
        //OK

      }
      else if(delim_count==4)
      {
        //AT+QBTGATCCON=1,"0666",E8CF31FA02E8,1
        //OK
        //+QBTGATCCON: 1,0,"0666",E8CF31FA02E8,1
        //...
        //AT+QBTGATCCON=0,"0666",1
        //OK
        //+QBTGATCCON: 0,0,"0666",E8CF31FA02E8,1
      }
    }
  }
  // Search and Enumerate Peer’s Service
  else if(__STRNCMP(buff, "+QBTGATCSS: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  //Search and Enumerate Peer’s Characteristic of the Service
  else if(__STRNCMP(buff, "+AT+QBTGATCGC: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  //Write Peer’s Descriptor of the Service with UUID
  else if(__STRNCMP(buff, "+QBTGATCWD: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
  //Read Peer’s Descriptor of the Service with UUID
  else if(__STRNCMP(buff, "+QBTGATCRD: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    buff+=(sizeof("+QBTGATCRD: ")-1);

    if(strstr(buff, ",,")==NULL && sym_cnt_in_str(buff, ',')==8)
    {
      //AT+QBTGATCRC="0666",1,"33D1BCEA5F78A015DEEF1212A0150000",0,1,"33D1BCEA5F78A015DEEF121200150000",0,0
      //OK
      //+QBTGATCRC: 0,"0666",1,"33D1BCEA5F78A015DEEF1212A0150000",0,1,"33D1BCEA5F78A015DEEF121200150000",0,"8209"

    }
  }
  */
  //<-testing<-
#endif //(defined(__MC60__))
#if defined(__EC21_X__)
  else if(__STRNCMP(buff, "+QIND: \"FOTA\",")==0)
  {
    const char* ach=(const char*)(buff+(sizeof("+QIND: \"FOTA\",")-1));

    xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
    if(__STRNCMP(ach, "\"FTPSTART\"")==0)
    {
      fota_state.flags=FTPSTART_FOTA_FLAG;
    }
    else if(__STRNCMP(ach, "\"FTPEND\",")==0)
    {
      ach+=(sizeof("\"FTPEND\",")-1);

      fota_state.ftp_end_result=(uint16_t)strtoul(ach, NULL, 10);
      fota_state.flags|=FTPEND_FOTA_FLAG;
    }
    else if(__STRNCMP(ach, "\"START\"")==0)
    {
      fota_state.flags|=START_FOTA_FLAG;
    }
    else if(__STRNCMP(ach, "\"UPDATING\",")==0)
    {
      ach+=(sizeof("\"UPDATING\",")-1);

      fota_state.updating_percent=(uint8_t)strtoul(ach, NULL, 10);
      fota_state.flags|=UPDATING_FOTA_FLAG;
    }
    else if(__STRNCMP(ach, "\"END\",")==0)
    {
      ach+=(sizeof("\"END\",")-1);

      fota_state.fota_end_result=(uint16_t)strtoul(ach, NULL, 10);
      fota_state.flags|=END_FOTA_END;
    }
    xSemaphoreGive(modem_at_flags.lock_obj);
  }
#endif //defined(__EC21_X__)
  else if(__STRNCMP(buff, "DEACT OK\r\n")==0)
  {
    SetModemAtFlag(DEACT_OK_FGSM);
  }
  else if(__STRNCMP(buff, "+CUSD: ")==0)
  {
#if defined(__MC60__)
  if(__STRNCMP(buff, "+CUSD: 2,\"")==0)
#endif //defined(__MC60__)
#if defined(__EC21_X__)
  if(__STRNCMP(buff, "+CUSD: 0,\"")==0)
#endif //defined(__EC21_X__)
  {
    //+CUSD: 2,"002D00320032003600350037002E0032003600200440002E000A0020",72\r\n //MC60 -22657.26 р.
    //+CUSD: 0,"002D00320032003600370033002E0030003500200440002E000A0020",72\r\n //EC21, приходит асинхронно после OK
    if(buff_len>16 && buff[buff_len-1]=='\n' && buff[buff_len-2]=='\r' && buff[buff_len-5]==',' && buff[buff_len-6]=='"')
    {
      buff[buff_len-6]='\0';
      const char* ach=(const char*)(buff+(sizeof("+CUSD: 2,\"")-1));
      const uint16_t ach_len=strlen(ach);

      xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
      if(aux_data.dst_mem!=NULL && aux_data.dst_mem_size!=0)
      {
        if(ach_len%4==0 && ach_len/4<aux_data.dst_mem_size)
        {
          UCS2toWin1251(ach, aux_data.dst_mem);
        }
      }
      xSemaphoreGive( modem_at_flags.lock_obj );
    }
  }
#if defined(__EC21_X__)
  SetModemAtFlag(CUSD_FGSM);
#endif //defined(__EC21_X__)
  }
  else
  {
    //SetModemAtFlag(empty_FGSM);
  }
}

void ResetQuectelLibState(void)
{
  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;
  bt_gprs_flow.tx_ctx=0xff;
  bt_gprs_flow.bt_spp_ctx=0xff;
  bt_gprs_flow.bt_status=0;
  bt_gprs_flow.req_spp_timer=xTaskGetTickCount();
  modem_at_flags.flags=0;

  modem_state.creg_state.netLac=0;
  modem_state.creg_state.netCellId=0;
  modem_state.creg_state.regStatus=UNKNOWN_CREG_STATUS;
  modem_state.creg_state.AcT=UNKNOWN_ACT_STATUS;

  modem_state.operator_inf.mcc=0;
  modem_state.operator_inf.mnc=0;

#if defined(__SIM800_DS__)
  modem_state.ds_creg_state.netLac=0;
  modem_state.ds_creg_state.netCellId=0;
  modem_state.ds_creg_state.regStatus=UNKNOWN_CREG_STATUS;
  modem_state.ds_creg_state.AcT=UNKNOWN_ACT_STATUS;
#endif

  sms_read_flow.is_wait_data=0;
  sms_read_flow.recv_mem_ptr=NULL;
  sms_read_flow.phone=NULL;
  sms_read_flow.chunks_inf=NULL;

  modem_state.sms_inf.used=0;
  modem_state.sms_inf.total=0;

  modem_state.is_sim_failure=0;
  modem_state.rssi_level=99;
  modem_state.jamming_state=NO_JAMMING;
  modem_state.last_cme_error=0;
  modem_state.last_fctx=0xFFFFFFFF;

  memset(&modem_state.call_state, 0, sizeof(modem_state.call_state));

  modem_state.cfun_state=0;
  modem_state.pdp_deact_event=0;
  modem_state.pdp_context_state=PDP_CONTEXT_UNKNOWN_STATE;

#if defined(__MC60__)
  modem_state.perf_sim_id=0xff;
#endif //defined(__MC60__)

  modem_state.power_status=UNKNOWN_MODEM_POWER_STATUS;
  modem_state.temp_status=UNKNOWN_MODEM_TEMP_STATUS;

/*
#if USE_MODEM_UART_DMA_RX > 0
  DMA_SetCurrDataCounter(, MODEM_RX_MEM_SIZE);
#endif
*/

  //reset parse vars:
  modem_parse.buff_idx=0;
  modem_parse.bt_gprs_len_wait=0;
  modem_parse.buff_full_flag=0;

  modem_fwd.state=FORWARDING_DISABLED;
  modem_fwd.rx_ptr=NULL;

  modem_time.is_ntp_synced=0;
  modem_time.modem_utime=0;
  modem_time.ntp_req_timer=GetSecondsFromStartup()+15;

  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;

#if defined(__EC21_X__)
  memset(&fota_state, 0, sizeof(fota_state));
#endif //defined(__EC21_X__)

#if defined(__MC60__)
#if BLE_SCAN_TABLE_SIZE > 0
  memset(ble_scan_table, 0, sizeof(ble_scan_table));
  ble_scan_table_idx=0;
  ble_scan_gat_id=0;
#endif //BLE_SCAN_TABLE_SIZE > 0
#endif //defined(__MC60__)

  ClearAllModemAtFlags();
}

//int16_t voice_call_config(void)
//{
//  int16_t at_res;
//
//  clear_call_indicator();
//
//  at_res=send_simple_at("AT+CLIP=1\r", 2000);//Calling Line Identification Presentation
//  if(GSM_RES_OK==at_res)
//  {
//    at_res=send_simple_at("AT+CRC=1\r", 2000);//Incoming Call Indication Format
//  }
//
//  return at_res;
//}

int16_t voice_call_answer(void)
{
  int16_t at_res=GSM_NOTDONE_ERR;

  //оправляем команду ответить несколько раз
  for(uint8_t i=0; i<3; i++)
  {
    if(GSM_NOTDONE_ERR==at_res)
    {
      at_res=send_simple_at("ATA\r", 20*1000);
      if(GSM_NOTDONE_ERR==at_res)
      {
        vTaskDelay(1000);
        continue;
      }
      else
      {
        break;
      }
    }
  }

  return at_res;
}

int16_t voice_call(const char* phone)
{
  int16_t at_res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "ATD%s;\r", phone);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  at_res=send_simple_at(cmd_buff, 20*1000);

  return at_res;
}

int16_t voice_call_disconnect(void)
{
  int16_t at_res;

  at_res=send_simple_at("ATH\r", 20*1000);

  return at_res;
}

int16_t get_call_state(call_state_t* call_state)
{
  //send_simple_at("AT+QJDR?\r", 2000);
  int16_t at_res;

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  memset(&modem_state.call_state, 0, sizeof(modem_state.call_state));
  xSemaphoreGive( modem_at_flags.lock_obj );

  at_res=send_simple_at("AT+CLCC\r", 2000);
  if(GSM_RES_OK==at_res)
  {
#if defined(__EC21_X__)
    /*
    //костыль, на LTE всегда в состоянии DATACALL
    if(modem_state.call_state.is_call_present && modem_state.call_state.mode==DATA_CALL_MODE)
    {
      modem_state.call_state.is_call_present=0;
    }
    */
#endif //defined(__EC21_X__)

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(call_state, &modem_state.call_state, sizeof(call_state_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  return at_res;
}

void QuectelParse_cycle(void)
{
  uint16_t parse_len;
  modem_uart_rx_t* modem_uart_rx;
#if EN_MODEM_DEBUG > 0
  uint8_t printf_en;
#endif

  if(modem_at_flags.lock_obj==NULL) modem_at_flags.lock_obj=xSemaphoreCreateMutex();

#if defined(GSM_FORCED_WAIT_FLAG)
  if(modem_at_flags.sync_obj==NULL) vSemaphoreCreateBinary(modem_at_flags.sync_obj);
  xSemaphoreTake(modem_at_flags.sync_obj, 0);
#endif //defined(GSM_FORCED_WAIT_FLAG)

  modem_uart_rx=GetModemUartRxStructPtr();

  for(;;)
  {
    while(!modem_uart_rx->is_init)
    {
      vTaskDelay(10);
    }

#if USE_PARSE_WAIT_UNTIL > 1
    static uint32_t ParseTimeWait=0;

    ParseTimeWait=((uint32_t)xTaskGetTickCount()-ParseTimeWait);
    if(FILLING_TIME_1_2>ParseTimeWait) ParseTimeWait=MODEM_UART_BUFF_FILLING_TIME_1_2-ParseTimeWait;
    else                               ParseTimeWait=0;
    xSemaphoreTake(modem_uart_rx->sync_obj[0], ParseTimeWait);
    ParseTimeWait=xTaskGetTickCount();
#else
    xSemaphoreTake(modem_uart_rx->sync_obj[0], MODEM_UART_BUFF_FILLING_TIME_1_2);
#endif

/*
#if USE_MODEM_UART_DMA_RX > 0
    force_set_cbuff_in_idx();
#endif
*/

    if(modem_fwd.state==FORWARDING_DISABLE_CMD)
    {
      modem_fwd.state=FORWARDING_DISABLE_ACK;
      modem_parse.buff_full_flag=0;
      modem_parse.buff_idx=0;
    }

    uint16_t filled_len=filled_cbuff_len(&modem_uart_rx->cbuff);

    while(filled_len)
    {
      parse_len=0;
#if EN_MODEM_DEBUG > 0
      if(modem_rx_log_out_en) printf_en=1;
#endif
      if(filled_len)//если что-то есть в кольцевом буфере
      {
        if(modem_parse.bt_gprs_len_wait>0)//если данные gprs
        {
          uint16_t read_len;
          if(filled_len>modem_parse.bt_gprs_len_wait) read_len=modem_parse.bt_gprs_len_wait;
          else                                        read_len=filled_len;

          if(bt_gprs_flow.rx_write_ptr!=NULL && bt_gprs_flow.rx_ctx==modem_parse.bt_gprs_ctx)//есть куда писать
          {
            read_from_cbuff(&modem_uart_rx->cbuff, bt_gprs_flow.rx_write_ptr, read_len);
            bt_gprs_flow.rx_write_ptr+=read_len;
          }
          else
          {
            clean_cbuff_len_from_reader(&modem_uart_rx->cbuff, read_len);
          }

          //if(filled_len==0){filled_len++;filled_len--;}//не должны сюда попадать
          filled_len-=read_len;
          modem_parse.bt_gprs_len_wait-=read_len;

          if(modem_parse.bt_gprs_len_wait==0)
          {
#if defined(__MC60__)
            SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
#endif //defined(__MC60__)

#if (defined(__EC21_X__) || defined(__UG95__))
            if(bt_gprs_flow.rx_ctx!=0xFFFFFFF0)
            {
              SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
            }
#endif //(defined(__EC21_X__) || defined(__UG95__))

            //все данные GPRS приняты, далее нужно дождаться OK, перед тем как что-то слать
          }

#if defined(QUECTEL_MODEM_FTP_PRESENT)
#if (defined(__EC21_X__) || defined(__UG95__))
          //проверяем, возможно пришло меньше данных, чем запрашивали.
          //костыль, но по другому никак.
          //приходит CONNECT, потом данные, а потом уже QFTPGET с фактической длинной.
          //в текстовом режиме между OK и QFTPGET приходило другое URC, соотвственно все ломается. В бинарном такого небыло замечено.
          //нужно запрашивать именно ту длинну, которая фактически есть.
          if(modem_parse.bt_gprs_len_wait>0 && bt_gprs_flow.rx_ctx==0xFFFFFFF0)
          {
            //<CR><LF>OK<CR><LF><CR><LF>+QFTPGET: 0,2025<CR><LF>
            if(memcmp(bt_gprs_flow.rx_write_ptr-2, "\r\n", sizeof("\r\n")-1)==0) //заканчиваетс переносом строк
            {
              uint8_t offset=0;
              if(memcmp(bt_gprs_flow.rx_write_ptr-26, "\r\nOK\r\n\r\n+QFTPGET: ", sizeof("\r\nOK\r\n\r\n+QFTPGET: ")-1)==0)
              {
                offset=26;
              }
              else if(memcmp(bt_gprs_flow.rx_write_ptr-25, "\r\nOK\r\n\r\n+QFTPGET: ", sizeof("\r\nOK\r\n\r\n+QFTPGET: ")-1)==0)
              {
                offset=25;
              }
              else if(memcmp(bt_gprs_flow.rx_write_ptr-24, "\r\nOK\r\n\r\n+QFTPGET: ", sizeof("\r\nOK\r\n\r\n+QFTPGET: ")-1)==0)
              {
                offset=24;
              }
              else if(memcmp(bt_gprs_flow.rx_write_ptr-23, "\r\nOK\r\n\r\n+QFTPGET: ", sizeof("\r\nOK\r\n\r\n+QFTPGET: ")-1)==0)
              {
                offset=23;
              }

              if(offset)
              {
                bt_gprs_flow.rx_write_ptr-=offset;

#if EN_MODEM_DEBUG > 0
                if(modem_rx_log_out_en)
                {
                  __CHAR_BUFF_PRINTF(bt_gprs_flow.rx_write_ptr, offset, "ModemRxLog, len: %hhu\n", offset);

                }
#endif
                modem_parse.bt_gprs_len_wait=0;
                char* next;
                memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
                modem_state.ftp_res[0]=strtoul((const char*)&bt_gprs_flow.rx_write_ptr[sizeof("\r\nOK\r\n\r\n+QFTPGET: ")-1], &next, 10);
                modem_state.ftp_res[1]=strtoul(next+1, NULL, 10);
                SetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM);
              }
            }
          }
#endif //(defined(__EC21_X__) || defined(__UG95__))
#endif //defined(QUECTEL_MODEM_FTP_PRESENT)
        }
        else if(modem_fwd.state==FORWARDING_ENABLE)//если данные перенаправленные
        {
          uint16_t can_recv;
          uint16_t read_len;
          can_recv=modem_fwd.rx_end-modem_fwd.rx_ptr+1;;
          if(filled_len>can_recv) read_len=can_recv;
          else                    read_len=filled_len;

          if(read_len)//есть что писать
          {
            if(modem_fwd.rx_ptr!=NULL)//есть куда писать
            {
              read_from_cbuff(&modem_uart_rx->cbuff, modem_fwd.rx_ptr, read_len);
              modem_fwd.rx_ptr+=read_len;
            }
          }
          //оставшееся стираем, иначе повиснем в цикле
          if(filled_len>read_len)
          {
            clean_cbuff_len_from_reader(&modem_uart_rx->cbuff, filled_len-read_len);
            //тут можно установить признак переполнения буфера куда перенаправляем
          }
          filled_len=0;
        }
        else
        {
          while(filled_len)//копируем пока не найдены \r\n
          {
            modem_parse.buff[modem_parse.buff_idx]=read_byte_from_cbuff(&modem_uart_rx->cbuff);
            modem_parse.buff_idx++;
            filled_len--;

            if(modem_parse.buff_full_flag)//если было переполнение локального буфера, ждем '\n'
            {
              if(modem_parse.buff[modem_parse.buff_idx-1]=='\n')
              {
                modem_parse.buff_full_flag=0;
              }
              modem_parse.buff_idx=0;
            }
            else if(modem_parse.buff_idx>=sizeof(modem_parse.buff)-1)//локальный буфер заполнен, если последние два символа \r\n отправлем¤ в парсер, иначе ждем '\n'
            {
              if(modem_parse.buff[modem_parse.buff_idx-2]=='\r' && modem_parse.buff[modem_parse.buff_idx-1]=='\n')
              {
                parse_len=modem_parse.buff_idx;
                modem_parse.buff[modem_parse.buff_idx]='\0';
                modem_parse.buff_idx=0;
                break;//идем в парсер
              }
              else
              {
#if EN_MODEM_DEBUG > 0
                if(modem_rx_log_out_en)
                {
                  __CHAR_BUFF_PRINTF(modem_parse.buff, modem_parse.buff_idx, "ModemRxLog: Overflow modem_parse.buff\n");
                }
#endif
                modem_parse.buff_idx=0;
                modem_parse.buff_full_flag=1;
                __PRINTF("Overflow modem_parse.buff\n");
              }
            }
            else if(modem_parse.buff_idx>=2 && modem_parse.buff[modem_parse.buff_idx-2]=='\r' && modem_parse.buff[modem_parse.buff_idx-1]=='\n')
            {
              if(modem_parse.buff_idx==2)//в строке только \r\n
              {
                modem_parse.buff_idx=0;
              }
              else
              {
                parse_len=modem_parse.buff_idx;
                modem_parse.buff[modem_parse.buff_idx]='\0';
                modem_parse.buff_idx=0;
                break;//идем в парсер
              }
            }
            else if(modem_parse.buff_idx==1 && modem_parse.buff[modem_parse.buff_idx-1]=='>')
            {
              parse_len=modem_parse.buff_idx;
              modem_parse.buff[modem_parse.buff_idx]='\0';
              modem_parse.buff_idx=0;
              break;//идем в парсер
            }
          }
        }
      }

      if(parse_len)
      {
        /*parse input data*/
        QuectelAtParse((char*)modem_parse.buff, parse_len);
        force_wakeup_if_sleep();

#if EN_MODEM_DEBUG > 0
        if(modem_rx_log_out_en)
        {
          if(printf_en)
          {
            __CHAR_BUFF_PRINTF(modem_parse.buff, parse_len, "ModemRxLog, len: %hu\n", parse_len);
          }
        }
#endif
      }

/*
#if USE_MODEM_UART_DMA_RX > 0
      force_set_cbuff_in_idx();
#else
*/
      if(modem_uart_rx->full_flag==1)
      {
        clear_cbuff_from_reader(&modem_uart_rx->cbuff);
        modem_uart_rx->full_flag=2;
        __PRINTF("ModemRxLog: Переполнение кольцевого буфера, ovf err...\n");
      }
      if(modem_uart_rx->ore_flag==1)
      {
        modem_uart_rx->ore_flag=0;
        __PRINTF("ModemRxLog: потерян байт, ore err...\n");
      }
/*
#endif
*/
      if(free_cbuff_len(&modem_uart_rx->cbuff)>MODEM_RX_BUFF_WM)
      {
        __MODEM_UART_SOFT_RTS_PIN_LOW();
      }
    }
  }
}

// Функции работы с флагами событий модема
void SetModemAtFlag(uint32_t flags_mask)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags|=flags_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);

#if defined(GSM_FORCED_WAIT_FLAG)
  xSemaphoreGive(modem_at_flags.sync_obj);
#endif //defined(GSM_FORCED_WAIT_FLAG)
}

void ResetModemAtFlag(uint32_t flag_mask)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags&=~flag_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);
}

 uint32_t ReadModemAtFlag(uint32_t flags_mask)
{
  uint32_t flags;
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  flags=modem_at_flags.flags&flags_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);
  return flags;
}

void ClearAllModemAtFlags(void)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags=0;
  xSemaphoreGive(modem_at_flags.lock_obj);
}

uint32_t WaitModemFlags(uint32_t flags_mask, uint32_t timeout)
{
  timeout+=xTaskGetTickCount();

  do
  {
#if defined(GSM_FORCED_WAIT_FLAG)
    xSemaphoreTake(modem_at_flags.sync_obj, GSM_WAIT_FLAG_DEF_TICK);
#else
    vTaskDelay(GSM_WAIT_FLAG_DEF_TICK);
#endif //defined(GSM_FORCED_WAIT_FLAG)

    if(timeAfter(xTaskGetTickCount(), timeout)) break;
  }while(!ReadModemAtFlag(flags_mask));

  return (ReadModemAtFlag(flags_mask));
}


// Послать AT команду с ожиданием указанных флагов (логичеcкое или) или ERROR
int16_t extended_send_simple_at(const char* at, uint32_t wait_flags, uint32_t wait_resp_timeout)
{
  int16_t res;
  uint32_t flags;

  ResetModemAtFlag(wait_flags|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)at, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    if(!wait_resp_timeout) return GSM_TIMEOUT_ERR;//если команда без ожидания ответа, то сразу возвращаем ошибку таймаута

    flags=WaitModemFlags(wait_flags|ERROR_FGSM, wait_resp_timeout);
    if(flags&wait_flags) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  return GSM_RES_OK;
}

// Послать AT команду с ожиданием OK или ERROR
int16_t send_simple_at(const char* at, uint32_t wait_resp_timeout)
{
  return extended_send_simple_at(at, OK_FGSM, wait_resp_timeout);
}

// Очистить флаги OK, ERROR, послать данные без команду без ожидания
int16_t send_data_in_fwd_mode(const char* s, uint16_t slen)
{
  int16_t res;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)s, slen, GSM_TX_DEF_TIMEOUT);
  if(res!=MODEM_UART_TX_OK) {return GSM_NOTDONE_ERR;}
  else                      {return GSM_RES_OK;}
}

int16_t jamming_detect_config(void)
{
#if defined(__MC60__)
  //return GSM_RES_OK;

  int16_t res;

  res=send_simple_at("AT+QJDR=1\r", 2000);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+QJDCFG=\"URC\",1\r", 2000);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+QJDCFG=\"period\",60\r", 2000);
  if(res!=GSM_RES_OK) return res;

  return res;
#else
  /*
  int16_t res;

  res=send_simple_at("AT+QJDR=1\r", 2000);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+QJDCFG=\"URC\",1\r", 2000);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+QJDCFG=\"period\",60\r", 2000);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+MEDCR=0,56,1\r", 2000); //для тестовой прошивки UC200T
  if(res!=GSM_RES_OK) return res;
  */
  return GSM_RES_OK;
#endif //defined(__MC60__)
}

jamming_state_t get_jamming_state(uint8_t is_reset_after_read)
{
  jamming_state_t res=modem_state.jamming_state;
  if(is_reset_after_read) modem_state.jamming_state=NO_JAMMING;
  return res;
}

int16_t gprs_event_report_config(uint8_t is_enable)
{
  int16_t res;

  if(is_enable)
  {
    res=send_simple_at("AT+CGEREP=1\r", 2000);
  }
  else
  {
    res=send_simple_at("AT+CGEREP=0\r", 2000);
  }

  return res;
}

int16_t cfun_config(uint8_t fun, uint8_t rst)
{
  int s_len;

  if(rst && !(fun==1)) return GSM_WRONG_IN_PARAM;
  if(!(fun==0 || fun==1 || fun==4)) return GSM_WRONG_IN_PARAM;

  if(rst)
  {
    snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFUN=1,1\r");
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFUN=%hhu\r", fun);
  }
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 15000);
}

uint8_t is_enable_set_minimum_functionality_for_set_apn(void)
{
#if defined(__EC21_X__)
  return 1;
#else
  return 0;
#endif //defined(__EC21_X__)
}

int16_t gprs_config(const char* user, const char* passwd,  const char* apn)
{
  int s_len;

  if(apn==NULL) return GSM_WRONG_IN_PARAM;

#if (defined(__EC21_X__) || defined(__UG95__))
  if(!(user==NULL || passwd==NULL))
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICSGP=1,1,\"%s\",\"%s\",\"%s\"\r", apn, user, passwd);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICSGP=1,1,\"%s\",\"\",\"\"\r", apn);
  }
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
#else
  int16_t res;

  //не уверен что нужно именно эту команду подавать
  extended_send_simple_at("AT+QIDEACT\r", DEACT_OK_FGSM, 45000);

  if(!(user==NULL || passwd==NULL))
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICSGP=1,\"%s\",\"%s\",\"%s\"\r", apn, user, passwd);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICSGP=1,\"%s\",\"\",\"\"\r", apn);
  }
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 2000);

  if(res!=GSM_RES_OK) return res;

  return send_simple_at("AT+QIREGAPP\r", 2000);
#endif
}

int16_t pdp_context_activate(void)
{
  int16_t res;

#if (defined(__EC21_X__) || defined(__UG95__))
  modem_state.pdp_context_state=PDP_CONTEXT_UNKNOWN_STATE;
  res=send_simple_at("AT+QIACT?\r", 2000);
  if(res!=GSM_RES_OK) return res;
  else
  {
#warning проверить!
    if(modem_state.pdp_context_state!=PDP_CONTEXT_ACTIVATED_STATE)
    {
      res=send_simple_at("AT+QIACT=1\r", 150000);
      if(res!=GSM_RES_OK) return res;

      modem_state.pdp_context_state=PDP_CONTEXT_UNKNOWN_STATE;
      res=send_simple_at("AT+QIACT?\r", 2000);
      if(res!=GSM_RES_OK) return res;

      if(modem_state.pdp_context_state!=PDP_CONTEXT_ACTIVATED_STATE)
      {
        return GSM_NOTDONE_ERR;
      }
    }

    res=GSM_RES_OK;
  }
#else
  if(modem_state.pdp_context_state!=PDP_CONTEXT_ACTIVATED_STATE)
  {
    res=send_simple_at("AT+QIACT\r", 150000);
    if(res!=GSM_RES_OK) return res;
    modem_state.pdp_context_state=PDP_CONTEXT_ACTIVATED_STATE;
  }

  res=GSM_RES_OK;
#endif //__EC21_X__ || __UG95__

  return res;
}


int16_t tcp_socket_open(uint8_t ctx, const char* addr)
{
  //AT+CIPSTART=<n>,<mode>,<address>,<port>
  int s_len;
  int16_t res;
  const char* port;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;
  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(port==NULL) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5) return GSM_WRONG_IN_PARAM;

  res=pdp_context_activate();
  if(res!=GSM_RES_OK) return res;

#if (defined(__EC21_X__) || defined(__UG95__))
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QIOPEN=1,%hhu,\"TCP\",\"%.*s\",%.*s\r", ctx, port-addr-1, addr, 5, port);
#else
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QIOPEN=%hhu,\"TCP\",\"%.*s\",%.*s\r", ctx, port-addr-1, addr, 5, port);
#endif
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 5000);
}

int16_t tcp_socket_close(uint8_t ctx)
{//проверить данную функцию
#if (defined(__EC21_X__) || defined(__UG95__))
  int s_len;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICLOSE=%hhu\r", ctx);

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 10500);
#else
  int s_len;
  int16_t res;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QICLOSE=%hhu\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.tx_ctx=ctx;
  res=extended_send_simple_at(cmd_buff, CLOSE_OK_FGSM, 5500);
  bt_gprs_flow.tx_ctx=0xff;
  return res;
#endif
}

static int16_t tcp_polling_mode(void)
{
#if (defined(__EC21_X__) || defined(__UG95__))
  return GSM_RES_OK;
#else
  return send_simple_at("AT+QINDI=1\r", 1000);
#endif
  //return send_simple_at("AT+CIPRXGET=1\r", 5000);
}

static int16_t tcp_multiconn_mode(void)
{
#if (defined(__EC21_X__) || defined(__UG95__))
  return GSM_RES_OK;
#else
  return send_simple_at("AT+QIMUX=1\r", 1000);
#endif
}

static int16_t tcp_data_transmit_mode(void)
{
  return GSM_RES_OK;
#if (!defined(USE_QUICK_SEND_MODE))
  //return send_simple_at("AT+CIPQSEND=0\r", 5000);
#else
  //return send_simple_at("AT+CIPQSEND=1\r", 5000);
#endif
}

int16_t config_modem_tcpip_stack()
{
  int16_t res;
  res=tcp_polling_mode();
  if(res!=GSM_RES_OK) return res;
  res=tcp_multiconn_mode();
  if(res!=GSM_RES_OK) return res;
  res=tcp_data_transmit_mode();

#if (defined(__EC21_X__) || defined(__UG95__))
  //
#else
  if(res!=GSM_RES_OK) return res;
  res=send_simple_at("AT+QIDNSIP=1\r", 500);//The address of the remote server is a domain name
#endif

  return res;
}


/*
return values:
<0 standard GSM_ERR
INITIAL_CONN_STATE
CONNECTING_CONN_STATE
CONNECTED_CONN_STATE
REMOTE_CLOSING_CONN_STATE
CLOSING_CONN_STATE
CLOSED_CONN_STATE
*/
int16_t tcp_socket_state(uint8_t ctx)
{
  int16_t res;
  uint32_t flags;
  int s_len;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

#if (defined(__EC21_X__) || defined(__UG95__))
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QISTATE=1,%hhu\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  ctx_conn_state.ctx=ctx;
  ctx_conn_state.state=CLOSED_CONN_STATE;//этот статус не приходит, если соединения нет, то в ответ придет только OK_FGSM
  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);

  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&(OK_FGSM))
    {
      if(ctx_conn_state.ctx==ctx) return ctx_conn_state.state;
      else return GSM_NOTDONE_ERR;
    }
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
#else
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QISTATE\r");
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  ctx_conn_state.ctx=ctx;
  ResetModemAtFlag(CIPSTATUS_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(CIPSTATUS_FGSM|ERROR_FGSM, 5000);
    if(flags&CIPSTATUS_FGSM)
    {
      WaitModemFlags(OK_FGSM, 1500);//ждем OK, первый OK сброситься при получении CIPSTATUS_FGSM
      if(ctx_conn_state.ctx==ctx) return ctx_conn_state.state;
      else return GSM_NOTDONE_ERR;
    }
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
#endif
}

// Функция возвращает длину отправленных не подтвержденных данных либо ошибку
int16_t data_len_in_way(uint8_t ctx)
{//для совместимостисти с CINTERION
  (void) ctx;
  return 0;
}

// Ожидание подтверждения получения отправленных данных
int16_t wait_data_len_in_way_acked(uint8_t ctx, uint16_t time_wait)
{
  //для совместимостисти с CINTERION
  (void) ctx;
  (void) time_wait;
  return 0;
}

// В отличии от gprs_send ограничение на len 32767 байт
int16_t tcp_socket_write(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  return tcp_or_bt_write(0, ctx, data_out, len);
}

static int16_t tcp_or_bt_write(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  int16_t res;
  uint16_t chain_count;
  uint16_t chain_modulo;
  uint16_t max_len;

  if(is_bt) max_len=1024;
  else      max_len=1460;

  if(len>0xffff/2) return GSM_WRONG_IN_PARAM;

  chain_count=(len)/max_len;
  chain_modulo=(len)%max_len;

  for(uint16_t j=0; j<chain_count; j++)
  {
    res=tcp_or_bt_write_chunk(is_bt, ctx, data_out, max_len, 0);
    if(res!=max_len) return res;
    data_out+=max_len;
  }
  if(chain_modulo)
  {
    res=tcp_or_bt_write_chunk(is_bt, ctx, data_out, chain_modulo, 0);
    if(res!=chain_modulo) return res;
  }

  return (int16_t)len;
}


/*записывает в *data_out доступные данные, не более len байт;
return: считанное количество байт, меньше нуля ошибка;*/
int16_t tcp_socket_read(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  return tcp_or_bt_read(0, ctx, data_out, len);
}

// tcp_socket_read с ожиданием
int16_t tcp_socket_read_blocked(uint8_t ctx, uint8_t *data_out, uint16_t len, uint16_t time_wait)
{
  uint16_t tot_recv_len;
  uint32_t EndWaitTickCount;
  int16_t recv_len;

  if(len>0xffff/2) return GSM_WRONG_IN_PARAM;

  tot_recv_len=0;
  EndWaitTickCount = time_wait + xTaskGetTickCount();
  while(!timeAfter(xTaskGetTickCount(), EndWaitTickCount) && tot_recv_len<len)
  {
    vTaskDelay(50);
    recv_len = tcp_socket_read(ctx, &data_out[tot_recv_len], len-tot_recv_len);
    if(recv_len>=0) tot_recv_len+=recv_len;
    else
    {
      break;
    }
  }

  if(recv_len>=0) return tot_recv_len;
  else return (int16_t)recv_len;//вернуть ошибку полученную в tcp_socket_read
}


// Функции состояния/мониторинга
uint8_t get_rssi_level(void)
{
  return modem_state.rssi_level;
}

int16_t get_creg_state(creg_state_t* state, uint8_t force)
{
  int16_t res;

  if(force)
  {
    ResetModemAtFlag(CREG_FGSM);
    res=send_simple_at("AT+CREG?\r", 6000);

    if(res==GSM_RES_OK)
    {
      if(ReadModemAtFlag(CREG_FGSM))
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        memcpy(state, &modem_state.creg_state, sizeof(creg_state_t));
        xSemaphoreGive( modem_at_flags.lock_obj );
        res=GSM_RES_OK;
      }
      else
      {
        res=GSM_NOTDONE_ERR;
      }
    }
  }
  else
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(state, &modem_state.creg_state, sizeof(creg_state_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
    res=GSM_RES_OK;
  }

  if(res!=GSM_RES_OK)
  {
    state->AcT=0;
    state->netCellId=0;
    state->netLac=0;
    state->regStatus=UNKNOWN_CREG_STATUS;
  }

  return res;
}

int16_t creg_urc_extended_mode(void)
{
  return send_simple_at("AT+CREG=2\r", 2000);//Activate extended URC mode
}

int16_t operator_present_config(void)
{
  int16_t res;

  res=send_simple_at("AT+COPS=0,2\r", 180000);

  if(res==GSM_RES_OK)
  {
    send_simple_at("AT+COPS=3,2\r", 1000);//Для UC200T. Формат в первой команде не применяется
  }

  return res;
}

int16_t get_operator_inf(operator_inf_t* operator_inf)
{
  int16_t res;
  res=send_simple_at("AT+COPS?\r", 4000);

  if(res==GSM_RES_OK)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(operator_inf, &modem_state.operator_inf, sizeof(operator_inf_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else
  {
    memset(operator_inf, 0, sizeof(operator_inf_t));
  }
  return res;
}

int16_t set_network_sync_time(void)
{
  return GSM_RES_OK;
}

int16_t ntp_sync_time(const char* server, uint16_t port)
{
  int s_len;

  if(!timeAfter(GetSecondsFromStartup(), modem_time.ntp_req_timer)) return GSM_NOTDONE_ERR;

  if(modem_state.pdp_context_state!=PDP_CONTEXT_ACTIVATED_STATE) return GSM_NOTDONE_ERR;

  modem_time.ntp_req_timer=GetSecondsFromStartup()+3*60;
#if (defined(__EC21_X__) || defined(__UG95__))
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QNTP=1,\"%s\",%hu\r", server, port);
#else
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QNTP=\"%s\",%hu\r", server, port);
#endif
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 125000);
}

int16_t get_network_time(uint32_t* unix_time)
{
  if(!modem_time.is_ntp_synced) return GSM_NOTDONE_ERR;

  modem_time.modem_utime=0;
  if(GSM_RES_OK==send_simple_at("AT+CCLK?\r", 2000))
  {
    *unix_time=modem_time.modem_utime;
    return GSM_RES_OK;
  }
  else
  {
    *unix_time=0;
    return GSM_NOTDONE_ERR;
  }
}

int16_t get_modem_imie(char mem[16], uint16_t mem_size)
{
  int16_t res;

  if(mem_size<16) res=GSM_NOTDONE_ERR;

  fwd_modem_rx_enabele(modem_parse.buff, sizeof(modem_parse.buff));
  send_simple_at("AT+CGSN\r", 0);

  if(25!=wait_fwd_modem_rx_len(25, 1000))
  {
    mem[0]=NULL;
    res=GSM_NOTDONE_ERR;
  }
  else
  {
    if(__STRNCMP((char const*)modem_parse.buff, "\r\n")==0 && __STRNCMP((char const*)modem_parse.buff+17, "\r\n\r\nOK\r\n")==0)
    {
      *(modem_parse.buff+17)=NULL;
      memcpy(mem, modem_parse.buff+2, 16);
      res=GSM_RES_OK;
    }
    else
    {
      mem[0]=NULL;
      res=GSM_NOTDONE_ERR;
    }
  }
  vTaskDelay(200);
  fwd_modem_rx_disable();
  return res;
}

static int16_t get_aux_data(const char* cmd, char* mem, uint16_t mem_size, uint8_t is_append_with_lf)
{
  int16_t res;

  if(!mem_size) res=GSM_NOTDONE_ERR;

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=mem;
  aux_data.dst_mem_size=mem_size;
  aux_data.is_append_with_lf=is_append_with_lf;
  xSemaphoreGive( modem_at_flags.lock_obj );

  *mem='\0';

  res=send_simple_at((char*)cmd, 2000);

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  return res;
}

#if (defined(__EC21_X__) || defined(__UG95__))
int16_t network_search_mode_configuration(network_scanmode_t scanmode)
{
  int s_len;

#if (defined(__EC21_X__))
  if(scanmode>CDMA_AND_HDR_ONLY_SCAN_MODE) return GSM_WRONG_IN_PARAM;
#elif (defined(__UG95__))
  if(scanmode>UMTS_ONLY_SCAN_MODE)         return GSM_WRONG_IN_PARAM;
#endif

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QCFG=\"nwscanmode\",%hhu,1\r", (uint8_t)scanmode);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);;
}
#endif

int16_t get_cells_inf(char* mem, uint16_t mem_size)
{
#if (defined(__EC21_X__) || defined(__UG95__))
  int16_t res;

  if(!mem_size) res=GSM_NOTDONE_ERR;

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=mem;
  aux_data.dst_mem_size=mem_size;
  aux_data.is_append_with_lf=1;
  xSemaphoreGive( modem_at_flags.lock_obj );

  *mem='\0';

  static const char* const qeng_req_list[] =
  {
    "AT+QENG=\"servingcell\"\r",
    "AT+QENG=\"neighbourcell\"\r",
    //"AT+QENG=\"3gcomm\"\r",
  };

  for(uint8_t i=0; i<sizeof(qeng_req_list)/sizeof(const char* const); i++)
  {
    res=send_simple_at((char*)qeng_req_list[i], 4000);
    if(GSM_RES_OK!=res) break;
  }

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  return res;
#else
  if(mem_size) *mem='\0';
  return GSM_RES_OK;
#endif
}

int16_t get_software_inf(char* mem, uint16_t mem_size)
{
  return get_aux_data("ATI\r", mem, mem_size, 0);
}

//модем возвращает iccid длиной 20 (c дополнением f/F, если длина меньше xx)
int16_t get_iccid(char* mem, uint16_t mem_size)
{
  int16_t res;

#if (defined(__EC21_X__) || defined(__UG95__))
  res=get_aux_data("AT+QCCID\r", mem, mem_size, 0);
#else
  res=get_aux_data("AT+CCID\r", mem, mem_size, 0);
#endif

  if(GSM_RES_OK==res)
  {
    uint16_t len=strlen(mem);

    for(uint16_t i=0; i<len; i++) {if(mem[i]=='f' || mem[i]=='F' || mem[i]=='"') mem[i]='\0';}
  }

  return res;
}

uint8_t get_sim_failure_status(void)
{
  if(ReadModemAtFlag(CPIN_NOT_INSERTED_FGSM|CPIN_NOT_READY_FGSM)) return 1;

  return modem_state.is_sim_failure;
}

// Функции для перенаправления потоков
void fwd_modem_rx_enabele(uint8_t* dst, uint16_t len)
{
  if(modem_fwd.state!=FORWARDING_DISABLED)//не должны сюда попадать со велюченвм перенаправлением
  {
    fwd_modem_rx_disable();
  }

  memset(dst, 0, len);
  modem_fwd.rx_start=dst;
  modem_fwd.rx_ptr=modem_fwd.rx_start;
  modem_fwd.rx_end=dst+len-1;
  modem_fwd.state=FORWARDING_ENABLE;
}

void fwd_modem_rx_disable(void)
{
    modem_fwd.state=FORWARDING_DISABLE_CMD;//говорим что не нужно больше перенаправлять
    while(modem_fwd.state!=FORWARDING_DISABLE_ACK) vTaskDelay(10);
    modem_fwd.state=FORWARDING_DISABLED;
}

uint16_t get_fwd_recv_len(void)
{
  return modem_fwd.rx_ptr-modem_fwd.rx_start;
}

uint16_t wait_fwd_modem_rx_len(uint16_t len_wait, uint32_t time_wait)
{
  uint32_t end_timeMS_wait;

  if(modem_fwd.state!=FORWARDING_ENABLE) return 0;

  end_timeMS_wait=time_wait+xTaskGetTickCount();

  for(;;)
  {
    uint16_t fwd_recv_len=get_fwd_recv_len();
    if(fwd_recv_len>=len_wait) return len_wait;
    else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait)) return fwd_recv_len;
    vTaskDelay(10);
  }
}

int16_t soft_switch_off_modem(void)
{
  int16_t at_res;
  for(uint8_t att=0; att<3; att++)
  {
    at_res=extended_send_simple_at("AT+QPOWD=1\r", NORMAL_POWER_DOWN_FGSM, 6000);//Switch Off
    if(GSM_RES_OK==at_res) break;
    if(att!=3-1) vTaskDelay(1000*(att+1));
  }
  vTaskDelay(2000);
  return at_res;
}

// Bluetooth API

int16_t GetBtPowerStatus(uint8_t* const status)
{
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  bt_gprs_flow.bt_status=0;
  res=send_simple_at("AT+QBTPWR?\r",2000);
  if(res!=GSM_RES_OK) return res;

  status[0]=bt_gprs_flow.bt_status;

  return GSM_RES_OK;
}

int16_t BtPower(const uint8_t is_on)
{
  int16_t res;
  int s_len;
  uint8_t status;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(is_on>1) return GSM_WRONG_IN_PARAM;

  res=GetBtPowerStatus(&status);
  if(res!=GSM_RES_OK) return res;

  if((is_on && !status) || (!is_on && status))
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTPWR=%u\r", is_on);
    if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

    return send_simple_at(cmd_buff, 20000);
  }
  else
  {
    return GSM_RES_OK;
  }
}

/*
<op>: 0 - Stop, 1 - Start
*/
int16_t BtStartStopScanningLE(const uint8_t op, const uint16_t gclient_id)
{
#if BLE_SCAN_TABLE_SIZE > 0
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(op>1) return GSM_WRONG_IN_PARAM;

  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  if(op)
  {
    memset(ble_scan_table, 0, sizeof(ble_scan_table));
    ble_scan_table_idx=0;
    ble_scan_gat_id=gclient_id;
  }
  else
  {
    ble_scan_gat_id=0;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTGATCSCAN=%u,\"%s%hX\"\r", op, odd_even, gclient_id);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
#else
  return GSM_NOTDONE_ERR;
#endif //BLE_SCAN_TABLE_SIZE > 0
}

/*
ret: scanned count
*/
uint8_t GetScanTableLE(const bt_gat_scan_t* table[])
{
#if BLE_SCAN_TABLE_SIZE > 0
  if(table!=NULL)
  {
    table[0]=&ble_scan_table[0];
  }

  return ble_scan_table_idx;
#else
  return 0;
#endif //BLE_SCAN_TABLE_SIZE > 0
}

/*
<op>: 0 - Deregister, 1 - Register
*/
int16_t BtRegDeregGattClientLE(const uint8_t op, const uint16_t gclient_id)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(op>1) return GSM_WRONG_IN_PARAM;

  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTGATCREG=%u,\"%s%hX\"\r", op, odd_even, gclient_id);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

//->testing->


/*
<direct>: 0 - Non-direct connection, 1 - Direct connection
*/
int16_t BtConnectGattClientLE(const uint16_t gclient_id, const uint8_t peer_addr[6], const uint8_t direct)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(direct>1) return GSM_WRONG_IN_PARAM;

  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTGATCCON=1,\"%s%hX\",%02hhX%02hhX%02hhX%02hhX%02hhX%02hhX,%hhu\r",
                 odd_even, gclient_id, peer_addr[5], peer_addr[4], peer_addr[3], peer_addr[2], peer_addr[1], peer_addr[0], direct);

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

/*
<conn_id>: ID of current connection. The range is 0-255
*/
int16_t BtDisconnectGattClientLE(const uint16_t gclient_id, const uint8_t conn_id)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTGATCCON=0,\"%s%hX\",%hhu\r", odd_even, gclient_id, conn_id);

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

int16_t BtConnectGattListClientLE(void)
{
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  res=send_simple_at("AT+QBTGATCCON?\r", 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

int16_t BtReadPeersCharacteristiOfServiceUuidLE(const uint16_t gclient_id, const uint8_t conn_id, const peer_charact_args_t* args, uint8_t* heap, const uint16_t heap_size)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  if(args->service_is_primary>1) return GSM_WRONG_IN_PARAM;

  if(args->auth_req>4) return GSM_WRONG_IN_PARAM;

  const uint16_t service_uuid_len=strlen((const char*)args->service_uuid);
  if(service_uuid_len>32 || service_uuid_len<4) return GSM_WRONG_IN_PARAM;

  const uint16_t char_uuid_len=strlen((const char*)args->char_uuid);
  if(char_uuid_len>32 || char_uuid_len<4) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  s_len=snprintf((char*)heap, heap_size, "AT+QBTGATCRC=\"%s%hX\",%hhu,\"%s\",%hhu,%hhu,\"%s\",%hhu,%hhu\r",
                                          odd_even, gclient_id, conn_id, args->service_uuid, args->service_inst, args->service_is_primary, args->char_uuid, args->char_inst, args->auth_req);

  if(s_len<0 || s_len>=heap_size) return GSM_WRONG_IN_PARAM;

  res=send_simple_at((const char*)heap, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}



//<-testing<-

/*
<tx_level>: 0 - 7
This command takes effect after BT function is restarted.
responce +QBTGATRFPWR
*/
int16_t SetBtLeTxPwr(const uint8_t tx_level)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(tx_level>7) return GSM_WRONG_IN_PARAM;

  res=send_simple_at("AT+QBTLETXPWR?\r", 1000);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTLETXPWR=%u\r", tx_level);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

/*
scan_interval, scan_window in ms
*/
int16_t BtSetScanIntervalandScanWindow(uint16_t scan_interval, uint16_t scan_window, uint8_t is_ms)
{
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(scan_window>scan_interval) return GSM_WRONG_IN_PARAM;

  if(is_ms) scan_interval=(scan_interval*16)/10;
  if(scan_interval<4 || scan_interval>16384) return GSM_WRONG_IN_PARAM;

  if(is_ms) scan_window=(scan_window*16)/10;
  if(scan_window<4 || scan_window>16384) return GSM_WRONG_IN_PARAM;

  res=send_simple_at("AT+QGATCFGSCAN?\r", 1000);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QGATCFGSCAN=%u,%u\r", scan_interval, scan_window);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 1000);
  if(res!=GSM_RES_OK) return res;

  /*res=*/send_simple_at("AT+QGATCFGSCAN?\r", 1000);
  //if(res!=GSM_RES_OK) return res;

  return res;
}

/*
mode: 0 - invisible, 1 - visible forever, 2 - visible time (1-255) second
*/
int16_t BtVisibleMode(const uint8_t mode, const uint8_t time)
{
  int s_len;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(mode>2)           return GSM_WRONG_IN_PARAM;
  if(mode==2 && !time) return GSM_WRONG_IN_PARAM;

  if(mode<2)
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTVISB=%u\r", mode);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTVISB=2,%u\r", time);
  }

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 1000);
}

/*
Start/Stop BLE Advertising
op: 0 - Stop, 1 - Start
The command is only valid when AT+QBTVISB=0
*/
int16_t BtLEVisibleMode(const uint8_t op, const uint16_t gclient_id)
{
  int s_len;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(op>1)      return GSM_WRONG_IN_PARAM;
  if(!gclient_id) return GSM_WRONG_IN_PARAM;

  char odd_even[2]={0, 0};

  if(gclient_id<=0x000F) odd_even[0]='0';
  else if(gclient_id>0x00FF && gclient_id<=0x0FFF) odd_even[0]='0';

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTGATSL=\"%s%hX\",%u\r",  odd_even, gclient_id, op);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 1000);
}

//отключить режим at команд для bluetooth
int16_t BtDisableSppAtMode(void)
{
  return GSM_RES_OK;
  //return send_simple_at("AT+BTSPPCFD=\"\"\r", 2000);
}

int16_t BtSetDevName(const char* name)
{
  int s_len;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTNAME=\"%.54s\"\r", name);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}


int16_t SavePinCode(const char* pin)
{
  /*
  memcpy((char*)pin_code, pin, sizeof(pin_code));
  pin_code[sizeof(pin_code)-1]='\0';
  return sizeof(pin_code);
  */
  return GSM_RES_OK;
}

int16_t SetPairingPinCode(const char* pin)
{
  int s_len;

  if(strnlen(pin, 5)!=4) return GSM_WRONG_IN_PARAM;

  //s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTPAIRCNF=1,\"%s\"\r", pin);
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTPAIRCNF=1\r");
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

int16_t BtGetPariedDevice(void)
{
  int s_len;
  int16_t res;

  num_bt_device = 0;

  res=send_simple_at("AT+QBTSTATE\r", 2000);

  if(num_bt_device > 1)
  {
    for(uint8_t i=1; i<(num_bt_device+1); i++)
    {
      s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTUNPAIR=%hhu\r", i);
      if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

      send_simple_at(cmd_buff, 2000);
    }
  }

  return res;
}

int16_t BtConfigPairingMode(void)
{
  int16_t res;
  //res=send_simple_at("AT+QBTCFG?\r", 2000);
  res=send_simple_at("AT+QBTCFG=\"pair\",1\r", 2000);
  return res;
}

int16_t BtSppAcceptHandle(void)
{
  uint32_t flags;
  int16_t res;
  uint8_t ctx;

  flags=WaitModemFlags(BT_PAIR_REQUEST_FGSM, 0);
  if(flags&BT_PAIR_REQUEST_FGSM)
  {
    ResetModemAtFlag(BT_PAIR_REQUEST_FGSM);
    res=SetPairingPinCode("1234");

    return res;
  }

  ctx=bt_gprs_flow.bt_spp_ctx;
  if(timeAfter(xTaskGetTickCount(), bt_gprs_flow.req_spp_timer))
  {
    bt_gprs_flow.is_spp_conn_available=0;
    res=send_simple_at("AT+QBTSTATE\r", 1000);//2000
    bt_gprs_flow.req_spp_timer=2000+xTaskGetTickCount();//2000
    if(res!=GSM_RES_OK) return res;
    if(!bt_gprs_flow.is_spp_conn_available) bt_gprs_flow.bt_spp_ctx=0xff;//если при запросе QBTSTATE, нет активных spp
  }
  if(ctx!=bt_gprs_flow.bt_spp_ctx)
  {//spp id изменился
    //none
  }

  if(bt_gprs_flow.bt_spp_ctx==0xff)
  { //если нет активного spp соединения
    flags=WaitModemFlags(BT_SPP_CONNECTING_FGSM, 0);
    if(flags&BT_SPP_CONNECTING_FGSM)
    {
      //BtSppDisconnect();
      ResetModemAtFlag(BT_SPP_CONNECTING_FGSM);
      return send_simple_at("AT+QBTACPT=1,1\r", 2000);//accept
    }
    return GSM_RES_OK;
  }
  return GSM_RES_OK;
}

uint8_t BtIsSppConnectExist(void)
{
  if(bt_gprs_flow.bt_spp_ctx==0xff) return 0;
  else return 1;
}

int16_t BtSppDisconnect(void)
{
  uint8_t ctx;
  int16_t res;
  uint32_t end_timeMS_wait;

  if(!BtIsSppConnectExist()) return GSM_RES_OK;

  ctx=bt_gprs_flow.bt_spp_ctx;

  if(!((ctx<=BT_CONN_CTX_LAST_ID) || ctx==0xff)) return GSM_NOTDONE_ERR;

  if(ctx!=0xff)
  {
    snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTDISCONN=%hhu\r", ctx);
  }

  res=send_simple_at(cmd_buff, 2000);
  if(res!=GSM_RES_OK) return res;

  end_timeMS_wait=3000+xTaskGetTickCount();

  for(;;)
  {
    ctx=bt_gprs_flow.bt_spp_ctx;
    if(ctx==0xff) break;
    else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait)) break;
    vTaskDelay(50);
  }

  if(ctx!=0xff) return GSM_NOTDONE_ERR;
  else return GSM_RES_OK;
}

/*записывает в *data_out доступные данные, не более len байт;
return: считанное количество байт, меньше нуля ошибка;*/
int16_t BtSppRead(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  ctx=bt_gprs_flow.bt_spp_ctx;
  if(ctx==0xff)
  {
    //нет активного соединения
    return GSM_NOTDONE_ERR;
  }
  return tcp_or_bt_read(1, ctx, data_out, len);
}

int16_t BtSppWrite(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  ctx=bt_gprs_flow.bt_spp_ctx;
  if(ctx==0xff)
  {
    //нет активного соединения
    return GSM_NOTDONE_ERR;
  }
  return tcp_or_bt_write(1, ctx, data_out, len);
}

//not tested
uint8_t BtSppRecvDataSignal(void)
{
  uint8_t recv_event=0;

  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  if(modem_at_flags.flags&BT_BTSPPMAN_FGSM)
  {
    recv_event=1;
    modem_at_flags.flags&=~BT_BTSPPMAN_FGSM;
  }
  xSemaphoreGive(modem_at_flags.lock_obj);
  return recv_event;
}

/*записывает в *data_out доступные данные, не более len байт;
return: считанное количество байт, меньше нуля ошибка;*/
static int16_t tcp_or_bt_read(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  int s_len;
  int16_t res;
  uint32_t flags;

  if(is_bt && !is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(!is_bt)
  {
    if(ctx>MAX_CONN_CTX_ID || len>1460) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(!(ctx>=BT_CONN_CTX_FIRST_ID && ctx<=BT_CONN_CTX_LAST_ID) || len>1024) return GSM_WRONG_IN_PARAM;
  }
  if(len==0) return 0;

#if (defined(__EC21_X__) || defined(__UG95__))
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QIRD=%hhu,%hu\r", ctx, len);
#else
  if(!is_bt)
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QIRD=0,1,%hhu,%hu\r", ctx, len);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QSPPREAD=%hhu,%hu\r", ctx, len);
  }
#endif
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data_out;
  bt_gprs_flow.rx_ctx=ctx;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 8000);//сначало приходит CIPRXGET_BTSPPGET_ENDDATA_FGSM, затем OK_FGSM, поэтому ждем OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data_out;//actual recv len //должно быть установленно end_data_flag и OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;
  return res;
}

static int16_t tcp_or_bt_write_chunk(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len, uint8_t eod_flag)
{
  (void) eod_flag;
  int s_len;
  int16_t res;
  uint32_t flags;

  if(is_bt && !is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(!is_bt)
  {
    if(ctx>MAX_CONN_CTX_ID || len>1460) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(!(ctx>=BT_CONN_CTX_FIRST_ID && ctx<=BT_CONN_CTX_LAST_ID) || len>1024) return GSM_WRONG_IN_PARAM;
  }

  /*
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QISACK=%hhu\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;
  res=send_simple_at(cmd_buff, 500);
  if(res!=GSM_RES_OK) return res;
  */

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "%s%hhu,%hu\r", (is_bt)?("AT+QSPPSEND="):("AT+QISEND="), ctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.tx_ctx=ctx;
  ResetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM, 3000);
    if(flags&READY_FOR_DATA_ENTRY_FGSM) {}
    else if(flags&ERROR_FGSM) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
    else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
  }
  else
  {
   bt_gprs_flow.tx_ctx=0xff;
   return GSM_TIMEOUT_ERR;//???
  }

  if(!is_bt)
  {
#if (!defined(USE_QUICK_SEND_MODE))
    ResetModemAtFlag(CIPSEND_SEND_OK_FGSM|CIPSEND_SEND_FAIL_FGSM|ERROR_FGSM);
#else
    bt_gprs_flow.accepted_len=0;
    ResetModemAtFlag(CIPSEND_DATA_ACCEPT_FGSM|ERROR_FGSM);
#endif
    res=WriteToModemUart(data_out, len, GSM_TX_DEF_TIMEOUT*2);
    if(res==MODEM_UART_TX_OK)
    {
#if (!defined(USE_QUICK_SEND_MODE))
      flags=WaitModemFlags(CIPSEND_SEND_OK_FGSM|CIPSEND_SEND_FAIL_FGSM|ERROR_FGSM, 4000);
      if(flags&CIPSEND_SEND_OK_FGSM) {bt_gprs_flow.tx_ctx=0xff; return len;}
      else if(flags&CIPSEND_SEND_FAIL_FGSM || flags&ERROR_FGSM ) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
#else
      flags=WaitModemFlags(CIPSEND_DATA_ACCEPT_FGSM|ERROR_FGSM, 4000);
      if(flags&CIPSEND_DATA_ACCEPT_FGSM)
      {
        if(bt_gprs_flow.accepted_len==len) {bt_gprs_flow.tx_ctx=0xff; return len;}
        else {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      }
      else if(flags&ERROR_FGSM ) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
#endif
    }
    else
    {
      bt_gprs_flow.tx_ctx=0xff;
      return GSM_TIMEOUT_ERR;//???
    }
  }
  else
  {
    ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
    res=WriteToModemUart(data_out, len, GSM_TX_DEF_TIMEOUT*2);
    if(res==MODEM_UART_TX_OK)
    {
      flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 4000);
      if(flags&OK_FGSM) {bt_gprs_flow.tx_ctx=0xff; return len;}
      else if(flags&ERROR_FGSM) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
    }
    else
    {
      bt_gprs_flow.tx_ctx=0xff;
      return GSM_TIMEOUT_ERR;//???
    }
  }
}

int16_t SendSmsInTextMode(const char *phone, char *sms, uint8_t is_ucs2, uint8_t* mem, uint16_t mem_size)
{
  int16_t res;
  uint16_t len;
  uint32_t flags;
  int s_len;

  len=strnlen(phone, MAX_PHONE_LEN+1);
  if(len>MAX_PHONE_LEN) return GSM_WRONG_IN_PARAM;

  uint8_t idx=0;
  if(phone[0]=='+') idx++;
  for(; idx<len; idx++)
  {
    if(phone[idx]<'0' || phone[idx]>'9') return GSM_WRONG_IN_PARAM;
  }

  //проверяем смс
  len=strnlen(sms, MAX_SMS_LEN_IN_PDU_UCS2+1);
  if(is_ucs2)
  {
    if(len>MAX_SMS_LEN_IN_PDU_UCS2) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(len>MAX_SMS_LEN_IN_TEXTMODE_7BIT) return GSM_WRONG_IN_PARAM;
  }

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CMGF=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);//TEXT MODE
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  if(is_ucs2)
  {
    res=WriteToModemUart("AT+CSMP=17,167,0,8\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }
  else
  {
    res=WriteToModemUart("AT+CSMP=17,167,0,0\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);

    for(uint16_t i=0; i<len; i++)
    {
      if(sms[i]==0x5f) sms[i]=0x11;//'_'
      //else if (sms[i]==0x40) sms[i]=0x00;//'@'нельзя
      else if (sms[i]==0x24) sms[i]=0x02;//'$'
    }
  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  if(is_ucs2)
  {
    res=WriteToModemUart("AT+CSCS=\"UCS2\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }
  else
  {
    res=WriteToModemUart("AT+CSCS=\"GSM\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  if(is_ucs2)
  {
    if((4*strlen(sms)+1)>mem_size)      return GSM_MEM_ERR;
    if((4*MAX_PHONE_LEN+1)>mem_size)    return GSM_MEM_ERR;

    mem[0]='\0';
    strcat((char*)mem, "AT+CMGS=\"");
    Win1251ToUCS2(phone, (char*)mem+strlen("AT+CMGS=\""));//кодируем номер вместе с +7
    strcat((char*)mem, "\"\r");
  }
  else
  {
    s_len=snprintf((char*)mem, mem_size, "AT+CMGS=\"%s\"\r", phone);
    if(s_len<0 || s_len>=mem_size) return GSM_MEM_ERR;
  }

  ResetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)mem, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM, 10000);

    if(flags&READY_FOR_DATA_ENTRY_FGSM)
    {
      ResetModemAtFlag(OK_FGSM|ERROR_FGSM);

      if(is_ucs2)
      {
        len=Win1251ToUCS2(sms, (char*)mem);//кодируем смс
        res=WriteToModemUart(mem, len, GSM_TX_DEF_TIMEOUT);
      }
      else
      {
        res=WriteToModemUart((const uint8_t*)sms, STRING_LEN, GSM_TX_DEF_TIMEOUT);
      }

      if(res>0)
      {
        ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
        res=WriteToModemUart("\x1a", 1, GSM_TX_DEF_TIMEOUT);
        if(res==MODEM_UART_TX_OK)
        {
          flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 60000);

          if(flags&OK_FGSM) res=1;//
          else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
          else res=GSM_TIMEOUT_ERR;
        }
        else res=GSM_TIMEOUT_ERR;
      }
    }
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  return res;
}

int16_t QuerySms(sms_inf_t* sms_inf)
{
  int16_t res;
  uint32_t flags;

  sms_inf->used=0;
  sms_inf->total=0;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);

  res=WriteToModemUart("AT+CPMS?\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM)
    {
      xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
      sms_inf->used=modem_state.sms_inf.used;
      sms_inf->total=modem_state.sms_inf.total;
      xSemaphoreGive( modem_at_flags.lock_obj );
      return GSM_RES_OK;
    }
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
}

int16_t DeleteSms(uint8_t idx)
{
  int16_t res;
  uint32_t flags;
  int s_len;

  if(idx==0) return GSM_WRONG_IN_PARAM;

#if defined(__EC21_X__)
  idx--;//у Quectel EC21 нумерация с 0, что будет, если количество смс 255?
  //у UG95 так-же как у остальных
#endif

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMGD=%hhu\r", idx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 15000);
    if(flags&OK_FGSM) return GSM_RES_OK;
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
}

int16_t ReadSmsConfig(void)
{
  int16_t res;
  uint32_t flags;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CMGF=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
//  if(is_ucs2)
//  {
    res=WriteToModemUart("AT+CSCS=\"UCS2\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
//  }
//  else
//  {
    //res=WriteToModemUart("AT+CSCS=\"GSM\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
//  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;


  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CSDH=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  return GSM_RES_OK;
}

int16_t ReadSms(uint8_t idx, char* sms_data, uint16_t sms_data_mem_size, uint8_t* is_emty, char* phone, uint8_t phone_mem_size, sms_udh_chunks_inf_t* chunks_inf)
{
  int16_t res;
  uint32_t flags;
  int s_len;

  *is_emty=1;
  *phone='\0';
  memset(chunks_inf, 0, sizeof(*chunks_inf));

  if(idx==0 || sms_data==NULL || sms_data_mem_size<sizeof("")) return GSM_WRONG_IN_PARAM;

  *sms_data='\0';

#if defined(__EC21_X__)
  idx--;//у Quectel EC21 нумерация с 0, что будет, если количество смс 255?
  //у UG95 так-же как у остальных
#endif

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMGR=%hhu\r", idx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  sms_read_flow.is_emty=1;
  sms_read_flow.recv_mem_ptr=sms_data;
  sms_read_flow.recv_mem_size=sms_data_mem_size;
  sms_read_flow.phone=phone;
  sms_read_flow.phone_mem_size=phone_mem_size;
  sms_read_flow.received_len=0;
  sms_read_flow.chunks_inf=chunks_inf;
  if(sms_read_flow.chunks_inf!=NULL) memset(sms_read_flow.chunks_inf, 0, sizeof(sms_udh_chunks_inf_t));

#if defined(CMGR_DEBUG)
  extern void LOG(const char* string, ...);
  LOG("%s", cmd_buff);
  cmgr_buff[0]='\0';
#endif //defined(CMGR_DEBUG)

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
#if defined(CMGR_DEBUG)
    LOG("%u %s", flags, cmgr_buff);
#endif //defined(CMGR_DEBUG)
    if(flags&OK_FGSM) res=GSM_RES_OK;
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  sms_read_flow.recv_mem_ptr=NULL;
  sms_read_flow.recv_mem_size=0;

  if(res==GSM_RES_OK)
  {
    *is_emty=sms_read_flow.is_emty;
    return (int16_t)sms_read_flow.received_len;
  }
  else
    return res;
}

int16_t SendUssdRequest(const char* phone, char* answer, const uint16_t answer_max_size)
{
  int16_t res;

  answer[0]='\0';

  if(sizeof("AT+CUSD=1,\"")-1 + sizeof("\"\r")-1 + 4*strlen(phone) >= sizeof(cmd_buff))
  {
    return GSM_MEM_ERR;
  }

  res=send_simple_at("AT+CSCS=\"UCS2\"\r", 5000);
  if(res!=GSM_RES_OK) return res;

  cmd_buff[0]='\0';
  strcat(cmd_buff, "AT+CUSD=1,\"");
  Win1251ToUCS2(phone, &cmd_buff[sizeof("AT+CUSD=1,\"")-1]);
  strcat(cmd_buff, "\"\r");

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem_size=answer_max_size;
  aux_data.dst_mem=answer;
  xSemaphoreGive( modem_at_flags.lock_obj );

#if defined(__MC60__)
  res=send_simple_at(cmd_buff, 120000);
#endif //defined(__MC60__)

#if defined(__EC21_X__)
  res=extended_send_simple_at(cmd_buff, CUSD_FGSM, 120000);
#endif //defined(__EC21_X__)

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  if(GSM_RES_OK!=send_simple_at("AT+CUSD=0\r", 60000))
  {
    send_simple_at("AT+CUSD=0\r", 60000);
  }

  return res;
}


int16_t enable_modem_ext_temp_monitoring(void)
{
  return GSM_RES_OK;
  //return send_simple_at("AT+CMTE=1\r", 2000);
}

operate_modem_temp_status_t get_modem_temp_status(void)
{
  return modem_state.temp_status;
}

operate_modem_power_status_t get_modem_power_status(void)
{
  operate_modem_power_status_t res;
  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  res=modem_state.power_status;
  modem_state.power_status=UNKNOWN_MODEM_POWER_STATUS;
  xSemaphoreGive( modem_at_flags.lock_obj );
  return res;
}

int16_t tcp_socket_transmitting_state(uint8_t ctx, uint32_t* txlen, uint32_t* acklen, uint32_t* nacklen)
{
  int s_len;
  int16_t res;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

#if defined(__EC21_X__)
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QISEND=%hhu,0\r", ctx);
#elif defined(__MC60__)
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QISACK=%hhu\r", ctx);
#else
#error проверить для __UG95__
#endif

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.conn_data_trans_state.is_updated=0;
  res=send_simple_at(cmd_buff, 1500);
  if(res!=GSM_RES_OK) return res;

  if(bt_gprs_flow.conn_data_trans_state.is_updated)
  {
    if(txlen!=NULL)   *txlen=bt_gprs_flow.conn_data_trans_state.txlen;
    if(acklen!=NULL)  *acklen=bt_gprs_flow.conn_data_trans_state.acklen;
    if(nacklen!=NULL) *nacklen=bt_gprs_flow.conn_data_trans_state.nacklen;
  }
  else
  {
    res=GSM_NOTDONE_ERR;
  }

  return res;
}

#if (defined(__EC21_X__) || defined(__UG95__))
//
#else
int16_t get_current_sim_id(uint8_t* current_sim_id)
{
  int16_t res;
  res=send_simple_at("AT+QDSIM?\r", 800);
  if(res!=GSM_RES_OK) return res;

  *current_sim_id=modem_state.perf_sim_id;
  return GSM_RES_OK;
}

//<desired_sim_id>
//0 Switch to SIM card 1
//1 Switch to SIM card 2
int16_t change_sim_card(uint8_t desired_sim_id)
{
  int s_len;
  int16_t res;
  uint8_t current_sim_id;

  if(desired_sim_id>1) return GSM_NOTDONE_ERR;

  res=get_current_sim_id(&current_sim_id);
  if(res!=GSM_RES_OK) return res;

  if(desired_sim_id!=current_sim_id)
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QDSIM=%hhu\r", desired_sim_id);
    if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

    return send_simple_at(cmd_buff, 500);
  }
  else
  {
    return GSM_RES_OK;
  }
}
#endif

int16_t get_cfun_stae(uint8_t* cfun, uint8_t force)
{
  if(force)
  {
    int16_t res;

    res=send_simple_at("AT+CFUN?\r", 2000);
    *cfun=modem_state.cfun_state;

    return res;
  }
  else
  {
    *cfun=modem_state.cfun_state;
    return GSM_RES_OK;
  }
}

int16_t set_voice_call_mode(void)
{
  int s_len;

  //send_simple_at("AT+QAUDMOD=2\r", 1000);
  //send_simple_at("AT+QMIC=0,12\r", 1000);

  //send_simple_at("AT+QAUDCFG=\"max9860/dlgain\",87\r", 1000);

  //send_simple_at("AT+QAUDCFG=\"handfree/eec\",\"1.1.150.150.150.1.1.1.2.1.32113.16384.10240.16384.1.1800.80.8192.0.0.6144.12288.256.282.307.1.0\"\r", 350);

  //send_simple_at("AT+SIDET=-450\r", 350);

  //analog output (max9860)
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QDAC=4\r");
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 1000);
}

//volume: 0% – 100%
int16_t set_speaker_volume(uint8_t volume)
{
  int s_len;

  if(volume>100) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CLVL=%hhu\r", volume);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 350);
}

//gain: 0 – 15
int16_t set_mic_gain(uint8_t gain)
{
  int s_len;

  if(gain>15) return GSM_WRONG_IN_PARAM;

  //0(0dB) – 15(+22.5dB)
  //gain=(15Ul*gain)/100Ul;

#if defined(__SIM800_DS__)
  if(gain<3) gain=3;//почему-то при меньшем микрафон совсем отключается
#endif

  gain=(100Ul*gain)/15Ul;
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QAUDCFG=\"max9860/ulgain\",%hhu\r", gain);

  //s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMIC=%hhu,%hhu\r", audio_chanel, gain);//main audio channel
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 350);
}

int16_t echo_cancellation_control(uint16_t nlp, uint16_t aec, uint16_t nr, uint16_t ns)
{
  return GSM_RES_OK;
}

int16_t set_uart_urcport(void)
{
#if defined(__MC60__)
  return GSM_RES_OK;
#else
  return send_simple_at("AT+QURCCFG=\"urcport\",\"uart1\"\r", 2000);
#endif //defined(__MC60__)
}

/*
fopt:
0 - If the file does not exist, it will be created; if the file exists, it will be directly
opened. And both of them can be read and written
1 - If the file does not exist, it will be created; If the file exists, the file will be
overwritten and cleared. And both of them can be read and written
2 - If the file exists, open it and it can be read only. When the file doesn’t exist, it will respond with error
*/
int16_t m_fopen(const char* fname, uint32_t* fctx, uint8_t fopt)
{
  int s_len;
  int16_t res;

  if(fopt>2) return GSM_WRONG_IN_PARAM;

  //есть не закрытый файл, пытаемся его закрыть
  if(modem_state.last_fctx!=0xFFFFFFFF)
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFCLOSE=%lu\r", modem_state.last_fctx);
    if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

    res=send_simple_at(cmd_buff, 800);

    if(res==GSM_RES_OK)
    {
      modem_state.last_fctx=0xFFFFFFFF;
    }
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFOPEN=\"%s\",%hhu\r", fname, fopt);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.last_cme_error=0;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;
  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK)
  {
    if(modem_state.last_cme_error==426)//файл уже открыт, какой fctx не ясно
    {
      //
    }

    bt_gprs_flow.rx_ctx=0xFFFFFFFF;
    return res;
  }

  if(bt_gprs_flow.rx_ctx<0xFFFFFFFF)
  {
    *fctx=bt_gprs_flow.rx_ctx;
  }
  else
  {
    res=GSM_NOTDONE_ERR;
  }

  return res;
}

int16_t m_fwrite(uint32_t fctx, uint8_t* data, uint16_t len)
{
  int s_len;
  int16_t res;

  if(fctx==0xFFFFFFFF) return GSM_WRONG_IN_PARAM;

  if(!len) return len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFWRITE=%lu,%hu,6\r", fctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=extended_send_simple_at(cmd_buff, READY_FOR_DATA_ENTRY_FGSM, 1500);
  if(res!=GSM_RES_OK) return res;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  const uint32_t timer=xTaskGetTickCount();
  res=WriteToModemUart(data, len, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    //тайм-аут должен быть не меньше чем в QFWRITE
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 7000);//У UC200T сильно тормозит
    __PRINTF("-------\nQFWRITE %u ms\n-------\n", xTaskGetTickCount()-timer);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  return len;
}

int16_t m_fseek(uint32_t fctx, uint32_t offset)
{
  int s_len;

  if(fctx==0xFFFFFFFF) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFSEEK=%lu,%u,0\r", fctx, offset);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 800);
}

int16_t m_fread(uint32_t fctx, uint8_t* data, uint16_t len)
{
  int s_len;
  int16_t res;

  if(!len) return len;

  if(fctx==0xFFFFFFFF) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFREAD=%lu,%hu\r", fctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data;
  bt_gprs_flow.rx_ctx=fctx;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 800);//сначало приходит CIPRXGET_BTSPPGET_ENDDATA_FGSM, затем OK_FGSM, поэтому ждем OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data;//actual recv len //должно быть установленно end_data_flag и OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;

  return res;
}

int16_t m_fclose(uint32_t fctx)
{
  int16_t res;
  int s_len;

  if(fctx==0xFFFFFFFF) return GSM_WRONG_IN_PARAM;

  for(uint8_t i=0; i<3; i++)
  {
    res=send_simple_at("AT\r", 1000);
    if(res==GSM_RES_OK) break;
  }
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFCLOSE=%lu\r", fctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);

  //Не всегда работает. OK приходит на QFWRITE
  if(res==GSM_RES_OK)
  {
    if(fctx==modem_state.last_fctx)//если этот файл был не закрыт
    {
      modem_state.last_fctx=0xFFFFFFFF;
    }
  }
  else
  {
    modem_state.last_fctx=fctx;
  }

  return res;
}

int16_t m_fdelete(const char* fname)
{
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFDEL=\"%s\"\r", fname);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 800);
}

int16_t m_file_list(char* mem, uint16_t mem_size)
{
  return get_aux_data("AT+QFLST\r", mem, mem_size, 1);
}

int16_t m_storage_inf(char* mem, uint16_t mem_size)
{
  return get_aux_data("AT+QFLDS=\"UFS\"\r", mem, mem_size, 0);
}

int16_t m_open_files_list(char* mem, uint16_t mem_size)
{
  return get_aux_data("AT+QFOPEN?\r", mem, mem_size, 1);
}

int16_t m_fsize(const char* fname, uint32_t* size, char* mem, uint16_t mem_size)
{
  int s_len;
  int16_t res;

  *size=0;

  res=m_file_list(mem, mem_size);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "\"%s\"", fname);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  const char* ptr=strstr(mem, cmd_buff);

  if(ptr==NULL || ptr[strlen(cmd_buff)]!=',')
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "\"UFS:%s\"", fname); //для UC200T и EC21 (на новых прошивках)
    if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

    ptr=strstr(mem, cmd_buff);

    if(ptr==NULL || ptr[strlen(cmd_buff)]!=',') return GSM_RES_OK;
  }

  *size=strtoul(&ptr[strlen(cmd_buff)+1], NULL, 10);

  return GSM_RES_OK;
}

int16_t m_fs_init(void)
{
  return GSM_RES_OK;
}

const char* get_act_verbose(uint8_t act)
{
  static const char* const act_verbose[] =
  {
    "GSM (0)",
    "Unknown (1)",
    "UTRAN (2)",
    "GSM w/EGPRS (3)",
    "UTRAN w/HSDPA (4)",
    "UTRAN w/HSUPA (5)",
    "UTRAN w/HSDPA and w/HSUPA (6)",
    "E-UTRAN (7)",
  };

  if(act<sizeof(act_verbose)/sizeof(act_verbose[0])) return act_verbose[act];

  return "Unknown";
}

const char* get_reg_status_verbose(uint8_t reg_status)
{
  const char* const reg_status_verbose[] =
  {
    "Not registered, ME is currently not searching for new operator (0)",
    "Registered, home network (1)",
    "Not registered, but MT is currently searching a new operator to register to (2)",
    "Registration denied (3)",
    "Unknown (4)",
    "Registered, roaming (5)"
  };

  if(reg_status<sizeof(reg_status_verbose)/sizeof(reg_status_verbose[0])) return reg_status_verbose[reg_status];

  return "Unknown";
}

#if defined(__EC21_X__)
int16_t fota_handler(const char* addr, uint8_t* const is_reinit_enable)
{
  static const char* const log_header="FOTA";
  extern void LOG(const char* string, ...);

  is_reinit_enable[0]=0;

  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  memset(&fota_state, 0, sizeof(fota_state));
  xSemaphoreGive(modem_at_flags.lock_obj);

  int s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFOTADL=\"%s\"\r", addr);
  if(s_len<0 || s_len>=sizeof(cmd_buff))
  {
    LOG("%s: bad addr\n", log_header);
    return GSM_WRONG_IN_PARAM;
  }

  LOG("%s: QFOTADL=\"%s\"\n", log_header, addr);

  int16_t res=send_simple_at(cmd_buff, 1000);
  if(res!=GSM_RES_OK)
  {
    LOG("%s: QFOTADL err\n", log_header);
    return res;
  }

  uint32_t end_timeMS_wait=5*1000+xTaskGetTickCount();

  fota_state_t state;
  fota_state_t state_prev={0};

  res=GSM_NOTDONE_ERR;

  for(;;)
  {
    xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
    memcpy(&state, &fota_state, sizeof(state));
    xSemaphoreGive(modem_at_flags.lock_obj);

    if(ReadModemAtFlag(RDY_FGSM))
    {
      is_reinit_enable[0]=1;
      LOG("%s: RDY\n", log_header);
      return res;
    }

    if(memcmp(&state, &state_prev, sizeof(state)!=0))
    {
      if(state.flags&FTPSTART_FOTA_FLAG && !(state_prev.flags&FTPSTART_FOTA_FLAG))
      {
        LOG("%s: FTPSTART\n", log_header);
        end_timeMS_wait=3*60*1000+xTaskGetTickCount();
      }

      if(state.flags&FTPEND_FOTA_FLAG && !(state_prev.flags&FTPEND_FOTA_FLAG))
      {
        LOG("%s: FTPEND, result: %hu\n", log_header, state.ftp_end_result);

        if(state.fota_end_result!=0) break;
      }

      if(state.flags&START_FOTA_FLAG && !(state_prev.flags&START_FOTA_FLAG))
      {
        is_reinit_enable[0]=1;

        LOG("%s: START\n", log_header);
        end_timeMS_wait=20*1000+xTaskGetTickCount();
      }

      if((state.flags&UPDATING_FOTA_FLAG && !(state_prev.flags&UPDATING_FOTA_FLAG)) || (state.flags&UPDATING_FOTA_FLAG && state.updating_percent!=state_prev.updating_percent))
      {
        if(state.updating_percent%10==0)
        {
          LOG("%s: UPDATING: %hhu%%\n", log_header, state.updating_percent);
        }
        end_timeMS_wait=20*1000+xTaskGetTickCount();
      }

      if(state.flags&END_FOTA_END && !(state_prev.flags&END_FOTA_END))
      {
        LOG("%s: END, result: %hu\n", log_header, state.fota_end_result);

        if(state.fota_end_result==0)
        {
          res=GSM_RES_OK;
          break;
        }
        else if(state.fota_end_result==504 || state.fota_end_result==505)
        {
          state.flags&=~END_FOTA_END;
          xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
          fota_state.flags&=~END_FOTA_END;
          xSemaphoreGive(modem_at_flags.lock_obj);

          //продолжаем, пока не получим RDY
          end_timeMS_wait=30*1000+xTaskGetTickCount();
        }
        else
        {
        break;
        }
      }

      memcpy(&state_prev, &state, sizeof(state_prev));
    }

    if(timeAfter(xTaskGetTickCount(), end_timeMS_wait))
    {
      LOG("%s: timeout err", log_header);
      res=GSM_TIMEOUT_ERR;
      break;
    }

    vTaskDelay(5);
  }

  return res;
}
#endif //defined(__EC21_X__)

#if defined(QUECTEL_MODEM_FTP_PRESENT)

//ftp://[username[:password]@]server[:port]/path/resource
int parse_ftp_link(const char* link, char* username, char* password, char* server, char* path, char* file)
{
  static const uint8_t PARSE_FTP_LINK_DBG = 0;

  if(PARSE_FTP_LINK_DBG)
  {
    __PRINTF("\n%s\n", link);
  }

  if(memcmp(link, "ftp://", sizeof("ftp://")-1)!=0) return -1;

  uint8_t st_end[2]={sizeof("ftp://")-1, 0};
  uint8_t slash[2]={0, 0};
  uint8_t colon[2]={0, 0};
  uint8_t at=0;

  for(uint8_t i=st_end[0]; ; i++)
  {
    if(link[i]==':')
    {
      if(!i) return -1;

      if(colon[0] && colon[1]) return -1; //только два двоеточия

      if(colon[0]) {colon[1]=i;}
      else         {colon[0]=i;}
    }
    else if(link[i]=='@')
    {
      if(!i) return -1;

      if(at) return -1; //только одна собака

      at=i;
    }
    else if(link[i]=='/')
    {
      if(!i) return -1;

      if(slash[0]) {slash[1]=i;}
      else         {slash[0]=i;}
    }
    else if(link[i]=='\r' || link[i]=='\n' || link[i]=='\0')
    {
      if(!i) return -1;

      st_end[1]=i;
      break;
    }

    if(i==0xFF) break;
  }

  if(!st_end[1]) return -1;

  if(!slash[0]) return -1;
  if(slash[0]==slash[1]+1) return -1;
  if(!slash[1]) slash[1]=slash[0];

  if(slash[0]==colon[0]+1) return -1;
  if(slash[0]==colon[1]+1) return -1;

  if(st_end[1]==slash[1]+1) return -1;

  //логин и пароль
  //ftp://username:password@server[:port]/resource.ext
  if(at && colon[0] && colon[1] && colon[0]<at && colon[1]>at ||
     at && colon[0] && !colon[1] && colon[0]<at)
  {
    const char* const port=(at && colon[0] && !colon[1] && colon[0]<at)?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", colon[0]-st_end[0], &link[st_end[0]]);}
    if(password!=NULL) {sprintf(password, "%.*s", at-(colon[0]+1), &link[colon[0]+1]);}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-(at+1), &link[at+1], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", colon[0]-st_end[0], &link[st_end[0]]);
      __PRINTF("password: %.*s\n", at-(colon[0]+1), &link[colon[0]+1]);
      __PRINTF("server:port: %.*s%s\n", slash[0]-(at+1), &link[at+1], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  //только логин
  //ftp://username@server[:port]/resource.ext
  if(at && colon[0] && at<colon[0] ||
     at && !colon[0])
  {
    const char* const port=(at && !colon[0])?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", at-st_end[0], &link[st_end[0]]);}
    if(password!=NULL) {sprintf(password, "%.*s", 0, "");}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-(at+1), &link[at+1], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", at-st_end[0], &link[st_end[0]]);
      __PRINTF("password: %.*s\n", 0, "");
      __PRINTF("server:port: %.*s%s\n", slash[0]-(at+1), &link[at+1], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  //без логина и пароля
  //ftp://server[:port]/resource.ext
  if(!at && colon[0] ||
     !at && !colon[0])
  {
    const char* const port=(!at && !colon[0])?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", 0, "");}
    if(password!=NULL) {sprintf(password, "%.*s", 0, "");}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-st_end[0], &link[st_end[0]], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", 0, "");
      __PRINTF("password: %.*s\n", 0, "");
      __PRINTF("server:port: %.*s%s\n", slash[0]-st_end[0], &link[st_end[0]], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  return -1;
}

#if defined(__MC60__)
//state: 0 - UNKNOWN, 1 - IDLE, 2 - OPENING, 3 - OPENED, 4 - WORKING, 5 - TRANSFER, 6 - CLOSING, 7 - CLOSED
int16_t m_get_ftp_state(uint8_t* state)
{
  int16_t res;

  state[0]=0;

  modem_state.ftp_res=INT32_MIN;
  res=send_simple_at("AT+QFTPSTAT\r", 800);
  if(res!=GSM_RES_OK) return res;

  if(modem_state.ftp_res!=INT32_MIN)
  {
    state[0]=modem_state.ftp_res+1;
  }

  return res;
}

int16_t m_ftp_close(void)
{
  //придет OK или ERROR. Если OK, то будет еще +QFTPCLOSE: 0 или +QFTPCLOSE: <err>, 60s
  int16_t res;

  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at("AT+QFTPCLOSE\r", FTP_FLAG_FGSM, 60000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
}

int16_t m_ftp_open(const char* user, const char* pass, const char* addr)
{
  int16_t res;
  int s_len;
  const char* port;

  res=pdp_context_activate();
  if(res!=GSM_RES_OK) return res;

  //для AT+QFTPCFG приходит OK и +QFTPCFG:0
  //перенаправляем в COM
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at("AT+QFTPCFG=4,\"/COM/\"\r", FTP_FLAG_FGSM, 2000);
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  //binary
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at("AT+QFTPCFG=2,0\r", FTP_FLAG_FGSM, 2000);
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  //no transaprent mode
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at("AT+QFTPCFG=5,1\r", FTP_FLAG_FGSM, 2000);
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  //если вдруг открыто
  m_ftp_close();

  if(user==NULL || pass==NULL || addr==NULL)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(port==NULL) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPUSER=\"%s\"\r", user);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPPASS=\"%s\"\r", pass);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPOPEN=\"%.*s\",%.*s\r", port-addr-1, addr, 5, port);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK или ERROR. Если OK, то будет еще +QFTPOPEN: 0 или +QFTPOPEN: <err>, 150s
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 150000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
}

//todo: возможно нужен дополнительный слэш, как в SIMCOM
int16_t m_ftp_set_path(const char* path)
{
  int16_t res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPPATH=\"%s\"\r", path);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK или ERROR. Если OK, то будет еще +QFTPPATH: 0 или +QFTPPATH: <err>, 0.3s
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 2000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
}

int16_t m_ftp_get_file_size(const char* file, uint32_t* fsize)
{
  int16_t res;
  int s_len;

  fsize[0]=0;

  //читаем в пустоту список файлов из текущей директории
  //если этого не сделать, то на некоторых ftp на запрос размера приходит +QFTPSIZE: -550
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at("AT+QFTPLIST\r", FTP_FLAG_FGSM, 150000);
  if(res!=GSM_RES_OK) return res;
  //if(modem_state.ftp_res<0) return GSM_NOTDONE_ERR;

  //если не сднлать задержку, бывает приходит пустой +QFTPSIZE:
  //какая она должна быть?
  vTaskDelay(500);

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPSIZE=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK или ERROR. Если OK, то будет еще +QFTPSIZE: <size> или +QFTPSIZE: <err>, 150s
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 150000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res<0) return GSM_NOTDONE_ERR;

  fsize[0]=modem_state.ftp_res;

  return res;
}

int16_t m_ftp_open_file_for_read(const char* file)
{
  int16_t res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPGET=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK или ERROR. Если OK, то будет еще +QFTPGET: 0 или +QFTPGET: <err>, 120s
  modem_state.ftp_res=INT32_MIN;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 120000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
}

// может вернуть 0, значит данные еще не готовы
int16_t m_ftp_get_file_chunk(uint8_t* data, uint16_t chunk_len)
{
  int16_t res;
  int s_len;

  if(!chunk_len) return 0;

  if(chunk_len>1460) chunk_len=1460;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPREAD=%hu\r", chunk_len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data;
  bt_gprs_flow.rx_ctx=0xFFFFFFF0;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 32000);//сначало приходит CIPRXGET_BTSPPGET_ENDDATA_FGSM, затем OK_FGSM, поэтому ждем OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data;//actual recv len //должно быть установленно end_data_flag и OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;

#warning нужно дождаться +QFTPGET:y на последенем куске?

  return res;
  //+QFTPREAD: x
  //data
  //OK
  //+QFTPGET:y //на последенем куске
}
#endif //defined(__MC60__)

const char* m_get_verbose_ftp_state(const uint8_t state)
{
  switch(state)
  {
  case 0:  return "unknown(0)";
  case 1:  return "idle(1)";
  case 2:  return "opening(2)";
  case 3:  return "opened(3)";
  case 4:  return "working(4)";
  case 5:  return "transfer(5)";
  case 6:  return "closing(6)";
  case 7:  return "closed(7)";
  default: return "unknown(-)";
  }
}

#if (defined(__EC21_X__) || defined(__UG95__))
//state: 0 - UNKNOWN, 1 - IDLE(-), 2 - OPENING, 3 - OPENED, 4 - WORKING(-), 5 - TRANSFER, 6 - CLOSING, 7 - CLOSED
int16_t m_get_ftp_state(uint8_t* state)
{
  int16_t res;

  state[0]=0; //UNKNOWN
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));

  res=extended_send_simple_at("AT+QFTPSTAT\r", FTP_FLAG_FGSM, 800);
  if(res!=GSM_RES_OK) return res;

  if(modem_state.ftp_res[0]!=0) return GSM_NOTDONE_ERR;

  //{state[0]=1;}                                  //IDLE
  if(modem_state.ftp_res[1]==0)      {state[0]=2;} //OPENING
  else if(modem_state.ftp_res[1]==1) {state[0]=3;} //OPENED
  //{state[0]=4;}                                  //WORKING
  else if(modem_state.ftp_res[1]==2) {state[0]=5;} //TRANSFER
  else if(modem_state.ftp_res[1]==3) {state[0]=6;} //CLOSING
  else if(modem_state.ftp_res[1]==4) {state[0]=7;} //CLOSED

  return res;
}

int16_t m_ftp_close(void)
{
  //придет OK, затем +QFTPOPEN:  <err>,<protocol_error> или +CME ERROR: <err>, 90s
  int16_t res;

  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  res=extended_send_simple_at("AT+QFTPCLOSE\r", FTP_FLAG_FGSM, 60000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res[0]!=0 || modem_state.ftp_res[1]!=0) return GSM_NOTDONE_ERR;

  return res;
}

//todo: возможно нужен дополнительный слэш, как в SIMCOM
int16_t m_ftp_set_path(const char* path)
{
  int16_t res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPCWD=\"%s\"\r", path);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK, затем +QFTPOPEN:  <err>,<protocol_error> или +CME ERROR: <err>
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 800);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res[0]!=0 || modem_state.ftp_res[1]!=0) return GSM_NOTDONE_ERR;

  return res;
}

int16_t m_ftp_get_file_size(const char* file, uint32_t* fsize)
{
  int16_t res;
  int s_len;

  fsize[0]=0;

  //читаем в пустоту список файлов из текущей директории
  //если этого не сделать, то на некоторых ftp на запрос размера приходит +QFTPSIZE: 627,550
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  res=extended_send_simple_at("AT+QFTPLIST=\".\",\"COM:\"\r", FTP_FLAG_FGSM, 90000);

  if(res!=GSM_RES_OK) return res;
  //if(modem_state.ftp_res[0]!=0) return GSM_NOTDONE_ERR;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPSIZE=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK, затем +QFTPOPEN:  <err>,<protocol_error> или +CME ERROR: <err>, 90s
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 90000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res[0]!=0) return GSM_NOTDONE_ERR;

  fsize[0]=modem_state.ftp_res[1];

  return res;
}

int16_t m_ftp_open(const char* user, const char* pass, const char* addr)
{
  int16_t res;
  int s_len;
  const char* port;

  res=pdp_context_activate();
  if(res!=GSM_RES_OK) return res;

  //Set file type as binary.
  res=send_simple_at("AT+QFTPCFG=\"filetype\",0\r", 800);
  if(res!=GSM_RES_OK) return res;

  //Set transfer mode as passive mode.
  res=send_simple_at("AT+QFTPCFG=\"transmode\",1\r", 800);
  if(res!=GSM_RES_OK) return res;

  //Set response timeout value
  res=send_simple_at("AT+QFTPCFG=\"rsptimeout\",30\r", 800);
  if(res!=GSM_RES_OK) return res;

  //Configure the PDP context ID as 1. The PDP context ID must be activated first
  res=send_simple_at("AT+QFTPCFG=\"contextid\",1\r", 800);
  if(res!=GSM_RES_OK) return res;

  //Configure transmode
  res=send_simple_at("AT+QFTPCFG=\"transmode\",1\r", 800);
  if(res!=GSM_RES_OK) return res;

  //если вдруг открыто
  m_ftp_close();

  if(user==NULL || pass==NULL || addr==NULL)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(port==NULL) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPCFG=\"account\",\"%s\",\"%s\"\r", user, pass);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPOPEN=\"%.*s\",%.*s\r", port-addr-1, addr, 5, port);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //придет OK, затем +QFTPOPEN:  <err>,<protocol_error> или +CME ERROR: <err>, 30s
  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 32000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res[0]!=0 || modem_state.ftp_res[1]!=0) return GSM_NOTDONE_ERR;

  return res;
}

int16_t m_ftp_open_file_for_read(const char* file)
{
  (void)file;
  int s_len;

  modem_state.ftp_read_pos=0;

  s_len=snprintf(modem_state.ftp_fname, sizeof(modem_state.ftp_fname), "%s", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return GSM_RES_OK;
}

int16_t m_ftp_get_file_chunk(uint8_t* data, uint16_t chunk_len)
{
  //CONNECT
  //<Output file data>
  //OK
  //+QFTPGET: 0,xxx

  //а может так
  //CONNECT
  //OK
  //+QIURC: "recv",3
  //+QFTPGET: 0,0

  int16_t res;
  int s_len;

  if(!chunk_len) return 0;

  //if(chunk_len>1460) chunk_len=1460;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QFTPGET=\"%s\",\"COM:\",%u,%hu\r", modem_state.ftp_fname, modem_state.ftp_read_pos, chunk_len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  memset(modem_state.ftp_res, 0xFF, sizeof(modem_state.ftp_res));
  bt_gprs_flow.rx_write_ptr=data;
  bt_gprs_flow.rx_ctx=0xFFFFFFF0;
  bt_gprs_flow.ftp_expect_rx_len=chunk_len;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM, 32000);//сначало приходит OK_FGSM, затем CIPRXGET_BTSPPGET_ENDDATA_FGSM, поэтому ждем CIPRXGET_BTSPPGET_ENDDATA_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data;//actual recv len //должно быть установленно end_data_flag и OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  modem_parse.bt_gprs_len_wait=0;
  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFFFFFFFF;

  if(res>=0)
  {
    if(modem_state.ftp_res[0]!=0 || modem_state.ftp_res[1]>chunk_len || modem_state.ftp_res[1]!=res) return GSM_NOTDONE_ERR;

    modem_state.ftp_read_pos+=modem_state.ftp_res[1];
  }

  return res;
}

#endif //(defined(__EC21_X__) || defined(__UG95__))
#endif //defined(QUECTEL_MODEM_FTP_PRESENT)

#if defined(__MC60__)
uint8_t get_pdp_deact_event(void)
{
  return modem_state.pdp_deact_event;
}

void reset_pdp_deact_event(void)
{
  modem_state.pdp_deact_event=0;
}
#endif //defined(__MC60__)

//0 Disable slow clock
//1 Enable slow clock, and it is controlled by DTR
//2 When there is no data on serial port in 5 seconds, module will enter into sleep mode. Otherwise, it will exit from sleep mode.
int16_t modem_psave_mode_cfg(uint8_t mode)
{
  int s_len;

  //send_simple_at("AT+QSCLK?\r", 800);

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QSCLK=%u\r", mode);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 800);
}