/**
  ******************************************************************************
  * File Name          : simcom_modem_lib.c
  * Description        : Библиотека для работы с gsm модемами SIMCOM
  *
  *
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "gsm_modems_lib/simcom/simcom_modem_lib.h"
#include "time_utilities/time_utilities.h"
#include "macro_utils.h"

/* Private define ------------------------------------------------------------*/
#define MAX_MODEM_FILES_CTX 1

#if (PARSE_RX_BUFF_SIZE < 3*512)
#error PARSE_RX_BUFF_SIZE err
#endif //(PARSE_RX_BUFF_SIZE < 3*512)

extern void LOG(const char* string, ...);

/* Private variables ---------------------------------------------------------*/
static modem_at_flags_t modem_at_flags={0};
static modem_parse_t modem_parse;
static bt_gprs_flow_t bt_gprs_flow;
static sms_read_flow_t sms_read_flow;
NOT_USED(static ctx_conn_state_t ctx_conn_state;)
static modem_fwd_t modem_fwd;
static modem_state_t modem_state;
static modem_network_time_t modem_time;
static aux_data_t aux_data;
static char cmd_buff[64];

#if defined(USE_BT_HFG)
static struct
{
  uint32_t timer;
  uint8_t device_id;
  uint8_t pair_ctx_state;
  uint8_t pair_mac_cmp_state;
  uint8_t mac[6];
  uint8_t pin[4];
}hfg_pair_ctx;
#endif //defined(USE_BT_HFG)

#if (defined(__SIM800__) || defined(__SIM800_DS__))
static uint16_t ble_scan_gat_id;
#if BLE_SCAN_TABLE_SIZE > 0
static bt_gat_scan_t ble_scan_table[BLE_SCAN_TABLE_SIZE]={0};
static uint8_t ble_scan_table_idx;
#endif //BLE_SCAN_TABLE_SIZE > 0
#endif //(defined(__SIM800__) || defined(__SIM800_DS__))

#if defined(__A7670E__)
static uint32_t cops_req_timer;
static const uint16_t COPS_REQ_MAX_PERIOD_MS = 10000;
#endif //defined(__A7670E__)

static struct
{
  char drive;
  struct
  {
    char fname[23];
    uint8_t is_open:1;
    uint8_t is_write_allowed:1;
    uint32_t read_offset;
    uint32_t fsize;
  }ctx[MAX_MODEM_FILES_CTX];
}m_fs;

/* Private constants ---------------------------------------------------------*/
static const uint8_t audio_chanel=0;//main audio channel
//static const uint8_t audio_chanel=2;//hand free mode

/* Private function prototypes -----------------------------------------------*/

/* Private functions ---------------------------------------------------------*/
static uint8_t is_bluetooth_present(void)
{
#if (defined(__SIM800__) || defined(__SIM800_DS__))
  return 1;
#else
  return 0;
#endif //#endif //(defined(__SIM800__) || defined(__SIM800_DS__))
}

static int16_t get_aux_data(const char* cmd, char* mem, uint16_t mem_size, uint8_t is_append_with_lf)
{
  int16_t res;

  if(!mem_size) res=GSM_NOTDONE_ERR;

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=mem;
  aux_data.dst_mem_size=mem_size;
  aux_data.is_append_with_lf=is_append_with_lf;
  xSemaphoreGive( modem_at_flags.lock_obj );

  *mem='\0';

  res=send_simple_at((char*)cmd, 2000);

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  return res;
}

static void parse_aux_data(char* src)
{
  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  if(aux_data.dst_mem!=NULL && aux_data.dst_mem_size!=0)
  {
    uint16_t offset;

    if(!aux_data.is_append_with_lf) offset=0;
    else                            offset=strnlen(aux_data.dst_mem, aux_data.dst_mem_size);

    for(; offset<(aux_data.dst_mem_size-1); offset++)
    {
      if(!aux_data.is_append_with_lf)
      {
        if(*src=='\r' || *src=='\n') {break;}
      }
      else
      {
        if(*src=='\r')      {aux_data.dst_mem[offset]='\n'; src++; continue;}
        else if(*src=='\n') {break;}
      }
      aux_data.dst_mem[offset]=*(src++);
    }
    aux_data.dst_mem[offset]='\0';
  }
  xSemaphoreGive( modem_at_flags.lock_obj );
}

#if defined(SIMCOM_MODEM_FTP_PRESENT)
#if defined(__A7670E__)
static void ftp_strtoul_handle(const char* p)
{
  modem_state.ftp_res = 0xFFFFFFFF;

  modem_state.ftp_res=strtoul(p, NULL, 10);

  SetModemAtFlag(FTP_FLAG_FGSM);
}
#endif //defined(__A7670E__)
#endif //defined(QUECTEL_QUECTEL_MODEM_FTP_PRESENT)

//#pragma optimize=low
static void SimcomAtParse(char* buff, uint16_t buff_len)
{
  //static uint16_t max_parse_len=0; if(buff_len>max_parse_len) max_parse_len=buff_len;
  if(sms_read_flow.is_wait_data)
  {
    if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)//есть куда копировать
    {
      uint16_t src_len=0;
      uint8_t data_offset=0;
      char* rn_ptr=strstr(buff, "\r\n");

      if(NULL!=rn_ptr && rn_ptr>buff)
      {
        src_len=rn_ptr-buff;
      }

      buff[src_len]='\0';

      if(sms_read_flow.decoding_inf==DATA_IN_UCS2_WO_HEADER || sms_read_flow.decoding_inf==DATA_IN_UCS2_W_HEADER ||
         sms_read_flow.decoding_inf==DATA_IN_WIN1251_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_WIN1251_WO_HEADER ||
           sms_read_flow.decoding_inf==DATA_IN_8BIT_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_8BIT_WO_HEADER)
      {
        if(sms_read_flow.decoding_inf==DATA_IN_UCS2_W_HEADER || sms_read_flow.decoding_inf==DATA_IN_8BIT_W_HEADER)
        {
          /*
          uint8_t idx=0;
          uint8_t udhl=0;
          char conv_buff[3];
          conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
          udhl=(uint8_t)strtoul(conv_buff, NULL, 16);

          data_offset=(1+udhl)*2;

          if(sms_read_flow.chunks_inf!=NULL)
          {
            idx+=2*2;
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->uid=(uint8_t)strtoul(conv_buff, NULL, 16);
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->total=(uint8_t)strtoul(conv_buff, NULL, 16);
            conv_buff[0]=buff[idx++]; conv_buff[1]=buff[idx++]; conv_buff[2]='\0';
            sms_read_flow.chunks_inf->current=(uint8_t)strtoul(conv_buff, NULL, 16);
          }
          */
          if(sms_read_flow.chunks_inf!=NULL)
          {
            //simcom не шлет эту информацию
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }
        else  if(sms_read_flow.decoding_inf==DATA_IN_WIN1251_W_HEADER)
        {
          /*
          //"������" ����� � UDH ��� ��������� 7bit, �� ����� �� ����
          if(memcmp(buff, "00E9", 4)==0)
            data_offset=4+5*4+4;//+padding, 7 septets in length
          else if(memcmp(buff, "00F9", 4)==0)
            data_offset=4+6*4;//7 septets in length
          else //�������� �� 5 � �� 6
            src_len=0;
          */
          if(sms_read_flow.chunks_inf!=NULL)
          {
            //simcom не шлет эту информацию
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }
        else
        {
          if(sms_read_flow.chunks_inf!=NULL)
          {
            sms_read_flow.chunks_inf->uid=0; sms_read_flow.chunks_inf->total=1; sms_read_flow.chunks_inf->current=1;
          }
        }

        if(data_offset+4<=src_len) //в src как минимум один символ UCS2
        {
          if((src_len-data_offset)/4+1<=sms_read_flow.recv_mem_size)
            src_len=UCS2toWin1251(&buff[data_offset], sms_read_flow.recv_mem_ptr);
          else
            src_len=0;
        }
        else
        {
          src_len=0;
        }

        sms_read_flow.recv_mem_ptr[src_len]='\0';
        sms_read_flow.received_len=src_len;
      }
    }
    sms_read_flow.is_wait_data=0;
  }
  else if(__STRNCMP(buff, "\r\n")==0 ||
     __STRNCMP(buff, "\r")==0 ||
       __STRNCMP(buff, "\r\r\n")==0 ||
         __STRNCMP(buff, "\n")==0
           )
  {
#if EN_MODEM_DEBUG > 0
    //if(modem_rx_log_out_en) printf_en=0;
#endif
  }
  else if(__STRNCMP(buff, ">")==0)
  {
    SetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM);
  }
  else if(modem_state.is_wait_local_ip_responce && 3==sym_cnt_in_str(buff, '.'))
  {//ждём ответ с ip модуля
    uint16_t len;
    uint16_t idx;
    for(idx=0, len=strlen(buff)-strlen("\r\n"); idx<len; idx++)
    {
      uint8_t sym=buff[idx];
      if(!((sym>='0' && sym<='9') || sym=='.')) break;
    }
    if(idx==len)
    {
      SetModemAtFlag(OK_FGSM);
      modem_state.is_wait_local_ip_responce=0;
    }
  }
  else if(!modem_state.is_wait_local_ip_responce && __STRNCMP(buff, "OK\r\n")==0)
  {
    SetModemAtFlag(OK_FGSM);
  }
  else if(__STRNCMP(buff, "ERROR\r\n")==0)
  {
    SetModemAtFlag(ERROR_FGSM);
  }

#if defined(__A7670E__)
  else if(__STRNCMP(buff, "*ATREADY: 1\r\n")==0)
  {
    SetModemAtFlag(RDY_FGSM);
    SetModemAtFlag(CFUN_X_FGSM);
  }
  else if(__STRNCMP(buff, "SMS DONE\r\n")==0)
  {
    SetModemAtFlag(SMS_READY_FGSM);
  }
  else if(__STRNCMP(buff, "PB DONE\r\n")==0)
  {
    SetModemAtFlag(CALL_READY_FGSM);
  }
  else if(__STRNCMP(buff, "+CPIN: SIM REMOVED\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_INSERTED_FGSM);
  }
  else if((__STRNCMP(buff, "+CEREG: ")==0 && (buff[8]>='0' && buff[8]<='8')))
  {
    //+CEREG: 5,3c29,0a80fa20,7 if URC
    //+CEREG: 2,5,3C29,0A80FA20 //if Req, ��� AcT
    //+CEREG: 2,1,3C29,0A80FA20
    //+CEREG: 2,1,0162,08568306
    //+CEREG: 1,0162,08568309,7

    creg_state_t* creg;
    uint8_t is_urc;

    creg=(creg_state_t*)(2+strchr((char*)buff,'\r'));

    //���������� ����� �� ������� ��� urc
    const char* ach=(const char*)buff;

    static const uint8_t offset = sizeof("+CEREG: ")-1;

    if(strchr(&ach[offset], '\"') != NULL)
      is_urc=2; //������� �� ������ ����, ����������
    else if(ach[offset + 1] == '\r' && ach[offset + 2] == '\n')
      is_urc=1;
    else if(ach[offset + 1] == ',' && ach[offset + 3] != ',' && ach[offset + 6] == ',')
      is_urc=1;
    else if(ach[offset + 0] == '2' && ach[offset + 1] == ',' && ach[offset + 3] == '\r' && ach[offset + 4] == '\n')
      is_urc=0;
    else if(ach[offset + 0] == '2' && ach[offset + 1] == ',' && ach[offset + 3] == ',' && ach[offset + 8] == ',')
      is_urc=0;
    else //�����������, ����������
      is_urc=2;

    if(2>is_urc)
    {
      if(is_urc)
        ach+=sizeof("+CEREG: ")-1;
      else
        ach+=sizeof("+CEREG: 2,")-1;

      creg->regStatus=(uint8_t)strtoul(ach, NULL, 10);

      if(creg->regStatus==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || creg->regStatus==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
        ach+=2;
        creg->netLac=(uint16_t)strtoul(ach, NULL, 16);
        ach+=6;
        creg->netCellId=(uint32_t)strtoul(ach, NULL, 16);

        if(*(ach+7)==',')
        {
          ach+=8;
          creg->AcT=(uint8_t)strtoul(ach, NULL, 10);
        }
        else
        {
          creg->AcT=UNKNOWN_ACT_STATUS;
        }
      }
      else
      {
        creg->netLac=0;
        creg->netCellId=0;
        creg->AcT=UNKNOWN_ACT_STATUS;
      }

      xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
      modem_state.creg_state.regStatus = creg->regStatus;
      modem_state.creg_state.netLac = creg->netLac;
      modem_state.creg_state.netCellId = creg->netCellId;
      if(is_urc || creg->regStatus == NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS) {modem_state.creg_state.AcT = creg->AcT;}
      xSemaphoreGive( modem_at_flags.lock_obj );

      if(!is_urc) SetModemAtFlag(CREG_FGSM);//if not URC
    }
  }
  else if((__STRNCMP(buff, "+CREG: ")==0 && (buff[7]>='0' && buff[7]<='8')))
  {
    //+CREG: 1,0162,08568306 if URC, ��� AcT
    //+CREG: 2,1,0162,08568306 //if Req, ��� AcT

    creg_state_t* creg;
    uint8_t is_urc;

    creg=(creg_state_t*)(2+strchr((char*)buff,'\r'));

    //���������� ����� �� ������� ��� urc
    const char* ach=(const char*)buff;

    static const uint8_t offset = sizeof("+CREG: ")-1;

    if(strchr(&ach[offset], '\"') != NULL)
      is_urc=2; //������� �� ������ ����, ����������
    else if(ach[offset + 1] == '\r' && ach[offset + 2] == '\n')
      is_urc=1;
    else if(ach[offset + 1] == ',' && ach[offset + 3] != ',' && ach[offset + 6] == ',')
      is_urc=1;
    else if(ach[offset + 0] == '2' && ach[offset + 1] == ',' && ach[offset + 3] == '\r' && ach[offset + 4] == '\n')
      is_urc=0;
    else if(ach[offset + 0] == '2' && ach[offset + 1] == ',' && ach[offset + 3] == ',' && ach[offset + 8] == ',')
      is_urc=0;
    else //�����������, ����������
      is_urc=2;

    if(2>is_urc)
    {
      if(is_urc)
        ach+=sizeof("+CREG: ")-1;
      else
        ach+=sizeof("+CREG: 2,")-1;

      creg->regStatus=(uint8_t)strtoul(ach, NULL, 10);

      if(creg->regStatus==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || creg->regStatus==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
        ach+=2;
        creg->netLac=(uint16_t)strtoul(ach, NULL, 16);
        ach+=6;
        creg->netCellId=(uint32_t)strtoul(ach, NULL, 16);
      }
      else
      {
        creg->netLac=0;
        creg->netCellId=0;
      }

      xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
      modem_state.creg_state.regStatus = creg->regStatus;
      modem_state.creg_state.netLac = creg->netLac;
      modem_state.creg_state.netCellId = creg->netCellId;
      xSemaphoreGive( modem_at_flags.lock_obj );

      if(!is_urc) SetModemAtFlag(CREG_FGSM);//if not URC
    }
  }
  else if(__STRNCMP(buff, "+CGMR: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+CGMR: ")-1));
  }
  else if(__STRNCMP(buff, "+CSUB: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+CSUB: ")-1));
  }
  //else if(__STRNCMP(buff, "Revision: ")==0)
  //{
  //  parse_aux_data((char*)(buff+sizeof("Revision: ")-1));
  //}
  else if(__STRNCMP(buff, "+ICCID: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+ICCID: ")-1));
  }
  else if(__STRNCMP(buff, "+CIPCLOSE: ")==0 && sym_cnt_in_str(buff, ',') == 9)
  {
    //AT+CIPCLOSE?
    //+CIPCLOSE: 0,1,0,0,0,0,0,0,0,0
    const char* ach = &buff[sizeof("+CIPCLOSE: ")-1];

    modem_state.conn_state = 0;

    for(uint8_t i = 0; i < 10; i++)
    {
      if(ach[0] == '1') {modem_state.conn_state |= (1<<i);}

      ach += 2;
    }
  }
  else if(__STRNCMP(buff, "+IP ERROR: No data\r\n")==0)
  {
    SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
  }
  else if(__STRNCMP(buff, "+NETCLOSE: ")==0)
  {
    SetModemAtFlag(CIPSHUT_OK_FGSM);
  }
  else if(__STRNCMP(buff, "+CTZV: ")==0)
  {
  }
#if defined(SIMCOM_MODEM_FTP_PRESENT)
  else if(__STRNCMP(buff, "+CFTPSSTART:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSSTART:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSTYPE:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSTYPE:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSLOGIN:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSLOGIN:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSLOGOUT:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSLOGOUT:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSSTART:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSSTART:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSSTOP:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSSTOP:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSCWD:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSCWD:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSSIZE:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSSIZE:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSGETFILE:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSGETFILE:")-1]);
  }
  else if(__STRNCMP(buff, "+CFTPSGET: DATA,")==0)
  {
    const uint16_t file_chunk=(uint16_t)strtoul(&buff[sizeof("+CFTPSGET: DATA,")-1], NULL, 10);

    //������ � �������
    bt_gprs_flow.rx_write_ptr=NULL;
    modem_parse.bt_gprs_len_wait = (int16_t)file_chunk;
  }
  else if(__STRNCMP(buff, "+CFTPSGET:")==0)
  {
    ftp_strtoul_handle(&buff[sizeof("+CFTPSGET:")-1]);
  }

#endif //defined(SIMCOM_MODEM_FTP_PRESENT)
#endif //defined(__A7670E__)
  else if(__STRNCMP(buff, "+CIPRXGET: 1,")==0)
  {
    tcp_socket_new_data_recv(strtoul(&buff[sizeof("+CIPRXGET: 1,")-1], NULL, 10));
  }
  else if(__STRNCMP(buff, "+CIPRXGET: 2,")==0 && (buff[13]>='0' && buff[13]<=MAX_CONN_CTX_ID+'0') && buff[14]==',' && (buff[15]>='0' && buff[15]<='9'))
  {//проверяем на заголовок gprs данных
    //+CIPRXGET: 2,1,0,0r\n
    modem_parse.bt_gprs_ctx=(uint8_t)atoi(&buff[13]);
    modem_parse.bt_gprs_len_wait=atoi(&buff[15]);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные gprs
    }
  }
  else if(__STRNCMP(buff, "+CIPSTATUS: ")==0 && (buff[12]>='0' && buff[12]<=MAX_CONN_CTX_ID+'0'))
  {
    ctx_conn_state.ctx=buff[12]-0x30;

    if(NULL!=strstr(buff, "INITIAL"))
    {
      ctx_conn_state.state=INITIAL_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
    else if(NULL!=strstr(buff, "CONNECTING"))
    {
      ctx_conn_state.state=CONNECTING_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
    else if(NULL!=strstr(buff, "CONNECTED"))
    {
      ctx_conn_state.state=CONNECTED_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
    else if(NULL!=strstr(buff, "REMOTE CLOSING"))
    {
      ctx_conn_state.state=REMOTE_CLOSING_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
    else if(NULL!=strstr(buff, "CLOSING"))
    {
      ctx_conn_state.state=CLOSING_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
    else if(NULL!=strstr(buff, "CLOSED"))
    {
      ctx_conn_state.state=CLOSED_CONN_STATE;
      SetModemAtFlag(CIPSTATUS_FGSM);
    }
  }
  else if(__STRNCMP(buff, "+PDP: DEACT\r\n")==0)
  {
    modem_state.pdp_deact_event=1;
    //modem_state.pdp_context_state=PDP_CONTEXT_DEACTIVATED_STATE;
  }
  else if(__STRNCMP(buff, "+CIPSEND: ")==0 && (buff[10]>='0' && buff[10]<=MAX_CONN_CTX_ID+'0') && buff[11]==',' && (buff[12]>='0' && buff[12]<='9'))
  {
    if(bt_gprs_flow.tx_ctx==buff[10]-0x30)
    {
      bt_gprs_flow.tx_availeble_len_write_to_modem=(uint16_t)atoi(&buff[12]);
      SetModemAtFlag(CIPSEND_QUERY_LEN_FGSM);
    }
  }
  else if(__STRNCMP(buff+1, ", CLOSE OK\r\n")==0 && (buff[0]>='0' && buff[0]<=MAX_CONN_CTX_ID+'0'))
  {
    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
    {
      SetModemAtFlag(CLOSE_OK_FGSM);
    }
  }
#if (!defined(USE_QUICK_SEND_MODE))
  else if(__STRNCMP(buff+1, ", SEND OK\r\n")==0 && (buff[0]>='0' && buff[0]<=MAX_CONN_CTX_ID+'0'))
  {
    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
    {
      SetModemAtFlag(CIPSEND_SEND_OK_FGSM);
    }
  }
  else if(__STRNCMP(buff+1, ", SEND FAIL\r\n")==0 && (buff[0]>='0' && buff[0]<=MAX_CONN_CTX_ID+'0'))
  {
    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
    {
      SetModemAtFlag(CIPSEND_SEND_FAIL_FGSM);
    }
  }
#else
  else if(__STRNCMP(buff, "DATA ACCEPT:")==0 && (buff[12]>='0' && buff[12]<=MAX_CONN_CTX_ID+'0'))
  {
    if(bt_gprs_flow.tx_ctx==buff[12]-0x30)
    {
      bt_gprs_flow.accepted_len=(uint16_t)atoi(&buff[14]);
      SetModemAtFlag(CIPSEND_DATA_ACCEPT_FGSM);
    }
  }
#endif
//todo: ���� �������������� ����� � ��������� id ���������� ��� �������� (���� ����� �����, ������ ���� ������� ���?)
//  else if(__STRNCMP(buff+1, ", BT SEND OK\r\n")==0 && (buff[0]>=BT_CONN_CTX_FIRST_ID+'0' && buff[0]<=BT_CONN_CTX_LAST_ID+'0'))
//  {
//    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
//    {
//      SetModemAtFlag(BT_SEND_OK_FGSM);
//    }
//  }
//  else if(__STRNCMP(buff+1, ", BT SEND FAIL\r\n")==0 && (buff[0]>=BT_CONN_CTX_FIRST_ID+'0' && buff[0]<=BT_CONN_CTX_LAST_ID+'0'))
//  {
//    if(bt_gprs_flow.tx_ctx==buff[0]-0x30)
//    {
//      SetModemAtFlag(BT_SEND_FAIL_FGSM);
//    }
//  }
  else if(__STRNCMP(buff, "BT SEND OK\r\n")==0)
  {
      SetModemAtFlag(BT_SEND_OK_FGSM);
  }
  else if(__STRNCMP(buff, "BT SEND FAIL\r\n")==0)
  {
      SetModemAtFlag(BT_SEND_FAIL_FGSM);
  }

  else if(__STRNCMP(buff, "+BTCONNECTING: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
    //+BTCONNECTING: "ac:38:70:68:80:4e","SPP"
    //+BTCONNECTING: 00:11:67:00:0a:3c,"HFG"
    if(strstr(buff, "\"SPP\"")!=NULL)
    {
      SetModemAtFlag(BT_SPP_CONNECTING_FGSM);
    }
    else if(strstr(buff, "\"HFG\"")!=NULL)
    {
      SetModemAtFlag(BT_HFG_CONNECTING_FGSM);
    }
  }
  else if(__STRNCMP(buff, "+BTCONNECT: ")==0 && (buff[12]>=BT_CONN_CTX_FIRST_ID+'0' && buff[12]<=BT_CONN_CTX_LAST_ID+'0' && buff[13]>=',') && strstr(buff, "\"SPP\"")!=NULL)
  {
    //+BTCONNECT: 2,"Lenovo P780",ac:38:70:68:80:4e,"SPP"
    bt_gprs_flow.bt_spp_ctx=(uint8_t)atoi(&buff[12]);
  }
  else if(__STRNCMP(buff, "+BTDISCONN: ")==0 && strstr(buff, "\"SPP\"")!=NULL)
  {
    //+BTDISCONN: "Lenovo P780",ac:38:70:68:80:4e,"SPP"
    bt_gprs_flow.bt_spp_ctx=0xff;
  }
  else if(__STRNCMP(buff, "+BTSTATUS: ")==0)
  {
    //AT+BTSTATUS?
    //+BTSTATUS: <status>
    bt_gprs_flow.bt_status=(uint8_t)atoi(&buff[11]);
  }
#if defined(USE_BT_HFG)
  /*
  else if(__STRNCMP(buff, "+BTCONNECT: ")==0 && strstr(buff, "\"HFG\"")!=NULL)
  {
    //+BTCONNECT: 1,"BH-109",00:11:67:00:0a:3c,"HFG"
  }
  else if(__STRNCMP(buff, "+BTDISCONN: ")==0 && strstr(buff, "\"HFG\"")!=NULL)
  {
    //+BTDISCONN: "BH-109",00:11:67:00:0a:3c,"HFG"
    //+BTDISCONN: "BH-109",00:11:67:00:0a:3c,"HFP"
  }
  */
  else if(__STRNCMP(buff, "P: ") == 0 && sym_cnt_in_str(buff, ',') == 2 && strstr(buff, ",,") == NULL)
  {
    //AT+BTSTATUS?
    //+BTSTATUS: 5
    //P: 1,"BH-109",00:11:67:00:0a:3c
    //C: 1,"BH-109",00:11:67:00:0a:3c,"HFG"
    //OK

    if(hfg_pair_ctx.pair_mac_cmp_state == 1)
    {
      const char* ach = &buff[sizeof("P: ")-1];

      for(uint8_t i=0; i<2; i++) ach = strchr(ach, ',') + 1;

      uint8_t i;

      for(i = 0; i < 6; i++)
      {
        if(hfg_pair_ctx.mac[i] != strtoul(ach, NULL, 16))
        {
          break;
        }

        ach+=3;
      }

      if(i >= 6)
      {
        ach = &buff[sizeof("P: ")-1];
        hfg_pair_ctx.device_id = (uint8_t)strtoul(ach, NULL, 10);
      }
    }
  }
  else if(__STRNCMP(buff, "+BTSCAN: 0,") == 0 && sym_cnt_in_str(buff, ',') == 4 && strstr(buff, ",,") == NULL)
  {
    //AT+BTSCAN=1
    //OK
    //+BTSCAN: 0,1,"BH-109",00:11:67:00:0a:3c,-50
    //+BTSCAN: 1

    if(hfg_pair_ctx.pair_mac_cmp_state == 2)
    {
      const char* ach = &buff[sizeof("+BTSCAN: 0,")-1];
      for(uint8_t i=0; i<2; i++) ach = strchr(ach, ',') + 1;

      uint8_t i;

      for(i = 0; i < 6; i++)
      {
        if(hfg_pair_ctx.mac[i] != strtoul(ach, NULL, 16))
        {
          break;
        }

        ach+=3;
      }

      if(i >= 6)
      {
        ach = &buff[sizeof("+BTSCAN: 0,")-1];
        hfg_pair_ctx.device_id = (uint8_t)strtoul(ach, NULL, 10);
      }
    }
  }
  else if(__STRNCMP(buff, "+BTPAIRING: ") == 0 && sym_cnt_in_str(buff, ',') == 1)
  {
    //+BTPAIRING: "BH-109",00:11:67:00:0a:3c

    if(hfg_pair_ctx.pair_mac_cmp_state == 3)
    {
      const char* ach = &buff[sizeof("+BTPAIRING: ")-1];
      for(uint8_t i=0; i<1; i++) ach = strchr(ach, ',') + 1;

      uint8_t i;

      for(i = 0; i < 6; i++)
      {
        if(hfg_pair_ctx.mac[i] != strtoul(ach, NULL, 16))
        {
          break;
        }

        ach+=3;
      }

      if(i >= 6)
      {
        hfg_pair_ctx.pair_mac_cmp_state = 4;
      }
    }
  }
  else if(__STRNCMP(buff, "+BTPAIR: ") == 0 && sym_cnt_in_str(buff, ',') == 2)
  {
    //+BTPAIR: 1,"BH-109",00:11:67:00:0a:3c

    if(hfg_pair_ctx.pair_mac_cmp_state == 5)
    {
      const char* ach = &buff[sizeof("+BTPAIR: ")-1];
      for(uint8_t i=0; i<2; i++) ach = strchr(ach, ',') + 1;

      uint8_t i;

      for(i = 0; i < 6; i++)
      {
        if(hfg_pair_ctx.mac[i] != strtoul(ach, NULL, 16))
        {
          break;
        }

        ach+=3;
      }

      if(i >= 6)
      {
        hfg_pair_ctx.pair_mac_cmp_state = 6;
      }
    }
  }
#endif //defined(USE_BT_HFG)
  else if(__STRNCMP(buff, "C: ")==0 && (buff[3]>=BT_CONN_CTX_FIRST_ID+'0' && buff[3]<=BT_CONN_CTX_LAST_ID+'0' && buff[4]>=',') && strstr(buff, "\"SPP\"")!=NULL)
  {
    //AT+BTSTATUS?
    //C: 1,"Lenovo P780",ac:38:70:68:80:4e,"SPP"
    bt_gprs_flow.bt_spp_ctx=buff[3]-0x30;
    bt_gprs_flow.is_spp_conn_available=1;
  }
  else if(__STRNCMP(buff, "+BTSPPMAN: ")==0)
  {
    //module receives data by SPP
    //+BTSPPMAN: <connectId>
    if(bt_gprs_flow.bt_spp_ctx==buff[11]-0x30)
    {
      SetModemAtFlag(BT_BTSPPMAN_FGSM);
    }
  }
   else if(__STRNCMP(buff, "+CPMS: ")==0 && sym_cnt_in_str(buff, ',')==8)
  {
    //+CPMS: "MT",35,35,"MT",35,35,"MT",35,35
    char* ach=(char*)(buff+sizeof("+CPMS: ")-1);

    uint8_t used;
    uint8_t total;

    ach=strchr(ach,',')+1;
    used=(uint8_t)atoi(ach);
    ach=strchr(ach,',')+1;
    total=(uint8_t)atoi(ach);

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.sms_inf.used=used;
    modem_state.sms_inf.total=total;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
   else if(__STRNCMP(buff, "+CIPACK: ")==0 && sym_cnt_in_str(buff, ',')==2)
   {
     //+CIPACK: <txlen>, <acklen>, <nacklen>
     if(!bt_gprs_flow.conn_data_trans_state.is_updated)
     {
       char* src=(char*)(buff+sizeof("+CIPACK: ")-1);
       char* next;

       bt_gprs_flow.conn_data_trans_state.txlen=strtoul(src, &next, 10);
       src=next+1;
       bt_gprs_flow.conn_data_trans_state.acklen=strtoul(src, &next, 10);
       src=next+1;
#if defined(__A7670E__)
       bt_gprs_flow.conn_data_trans_state.nacklen=bt_gprs_flow.conn_data_trans_state.txlen-bt_gprs_flow.conn_data_trans_state.acklen;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
       bt_gprs_flow.conn_data_trans_state.nacklen=strtoul(src, &next, 10);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)

       bt_gprs_flow.conn_data_trans_state.is_updated=1;
     }
   }
  else if(__STRNCMP(buff, "+CMGR: ")==0)
  {
    //+CMGR: "REC READ","VTB\11BMoskvy",,"16/06/06,17:13:52+24",208,64,0,8,"+79139869990",145,121//AT+CSDH=1
    //+CMGR: "REC READ","VTB\11BMoskvy",,"16/06/06,17:13:52+24"//AT+CSDH=0
    //+CMGR: 0,,0//AT+CSDH=0, AT+CSDH=1
    sms_stat_t stat;
    char* ach=(char*)(buff+sizeof("+CMGR: ")-1);
    if(__STRNCMP(ach, "0,,0")==0)
    {
      //пустая запись
      stat=SMS_REC_EMTY;
    }
    else if(strstr(ach, "\"REC UNREAD\""))
    {
      stat=SMS_REC_UNREAD;
    }
    else if(strstr(ach, "\"REC READ\""))
    {
      stat=SMS_REC_READ;
    }
    else
    {
      stat=SMS_REC_OTHER;
    }

    if(stat==SMS_REC_READ || stat==SMS_REC_UNREAD)
    {
      if(sym_cnt_in_str(buff, ',')==10+1/*+1 в дате*/)
      {
        for(uint8_t i=0; i<1; i++) ach=strchr(ach, ',')+1;
        if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        {
          uint8_t phone_len=0;
          char* phone=NULL;

          if(*ach=='"')
          {
            phone=ach+1;
            if(strchr(phone, '"')!=NULL) phone_len=strchr(phone, '"')-phone;
          }

          if(phone!=NULL && phone_len/4+1<=sms_read_flow.phone_mem_size)
          {
            //memcpy(sms_read_flow.phone, phone, phone_len);
            //sms_read_flow.phone[phone_len]='\0';
            phone[phone_len]='\0';
            UCS2toWin1251(phone, sms_read_flow.phone);
            phone[phone_len]='"';
            sms_read_flow.phone[sms_read_flow.phone_mem_size-1]='\0';
          }
          else
          {
            *sms_read_flow.phone='\0';
          }
        }

        for(uint8_t i=0; i<5; i++) ach=strchr(ach, ',')+1;
        uint8_t fo=(uint8_t)strtoul(ach, NULL, 10);
        for(uint8_t i=0; i<2; i++) ach=strchr(ach, ',')+1;
        uint8_t dcs=(uint8_t)strtoul(ach, NULL, 10);
        for(uint8_t i=0; i<3; i++) ach=strchr(ach, ',')+1;
        uint8_t plength=(uint8_t)strtoul(ach, NULL, 10);

        //пришло смс, но длина нулевая
        if(!plength)
        {
          sms_read_flow.is_wait_data=0;

          if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
            *sms_read_flow.phone='\0';
          if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
            *sms_read_flow.recv_mem_ptr='\0';

          sms_read_flow.is_emty=0;

          goto cmgr_exit;
        }

        if(((dcs&SMS_DCS_MASK)==SMS_DCS_DEFAULT_GSM))
        {
          //GSM Default alphabet
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
          {
            sms_read_flow.decoding_inf=DATA_IN_WIN1251_W_HEADER;
          }
          else
          {
            sms_read_flow.decoding_inf=DATA_IN_WIN1251_WO_HEADER;
          }
        }
        else if((dcs&SMS_DCS_MASK)==SMS_DCS_USC2_GSM)
        {
          //USC2 (16 бит)
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
            sms_read_flow.decoding_inf=DATA_IN_UCS2_W_HEADER;
          else
            sms_read_flow.decoding_inf=DATA_IN_UCS2_WO_HEADER;
        }
        else if((dcs&SMS_DCS_MASK)==SMS_DCS_8BIT_GSM)
        {
          //8бит
          if(fo&SMS_USER_DATA_HEDER_INDICATION)
            sms_read_flow.decoding_inf=DATA_IN_8BIT_W_HEADER;
          else
            sms_read_flow.decoding_inf=DATA_IN_8BIT_WO_HEADER;
        }
        else
        {
          //reserve или что-то не то с форматоматом, не умеем конвертировать, читаем в "пустую"
          if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
            *sms_read_flow.recv_mem_ptr='\0';

          sms_read_flow.recv_mem_ptr=NULL;
        }
      }
      else
      {
        //что-то не то с форматом, читаем в "пустую"
        sms_read_flow.recv_mem_ptr=NULL;
      }
      sms_read_flow.is_wait_data=1;
      sms_read_flow.is_emty=0;
    }
    else if(stat==SMS_REC_EMTY)
    {
      //ожидаем OK
      sms_read_flow.is_wait_data=0;

     if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        *sms_read_flow.phone='\0';
     if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
        *sms_read_flow.recv_mem_ptr='\0';

      sms_read_flow.is_emty=1;
    }
    else
    {
      //читаем в "пустую"
      sms_read_flow.is_wait_data=1;

      if(sms_read_flow.phone!=NULL && sms_read_flow.phone_mem_size!=0)
        *sms_read_flow.phone='\0';
      if(sms_read_flow.recv_mem_ptr!=NULL && sms_read_flow.recv_mem_size!=0)
        *sms_read_flow.recv_mem_ptr='\0';

      sms_read_flow.recv_mem_ptr=NULL;
      sms_read_flow.is_emty=0;
    }
    cmgr_exit: {}
  }
  else if(__STRNCMP(buff, "+CFUN: ")==0)
  {
    modem_state.cfun_state=buff[sizeof("+CFUN: ")-1]-0x30;
    SetModemAtFlag(CFUN_X_FGSM);
  }
  else if(__STRNCMP(buff, "+CPIN: READY\r\n")==0)
  {
    SetModemAtFlag(SIMREADY_FGSM);
  }
  else if(__STRNCMP(buff, "Call Ready\r\n")==0)
  {
    SetModemAtFlag(CALL_READY_FGSM);
  }
  else if(__STRNCMP(buff, "SMS Ready\r\n")==0)
  {
    SetModemAtFlag(SMS_READY_FGSM);
  }
#if defined(__SIM800_DS__)
  else if(__STRNCMP(buff, "+CPINDS: READY\r\n")==0)
  {
    SetModemAtFlag(SIMREADY_DS_FGSM);
  }
  else if(__STRNCMP(buff, "Call Ready DS\r\n")==0)
  {
    SetModemAtFlag(CALL_READY_DS_FGSM);
  }
  else if(__STRNCMP(buff, "SMS Ready DS\r\n")==0)
  {
    SetModemAtFlag(SMS_READY_DS_FGSM);
  }
#endif //__SIM800_DS__
  else if(__STRNCMP(buff, "+CME ERROR: ")==0)
  {
    char* ach=(char*)(buff+strlen("+CME ERROR: "));
    if(*ach>='0' && *ach<='9')
    {
      int16_t var;
      var=atoi(ach);
      if(var==10 || var== 11 || var==12 || var==13 || var==310 || var==313)
      {
        modem_state.is_sim_failure=1;
      }
    }
    SetModemAtFlag(ERROR_FGSM);
  }
  else if(__STRNCMP(buff, "+CMS ERROR: ")==0)
  {
    SetModemAtFlag(ERROR_FGSM);
  }
  //todo: ��������� �� ������ ������������� ����� AT+CREG? �� ������������� �� ������� SIMCOM
#if !defined(__A7670E__)
  else if((__STRNCMP(buff, "+CREG: ")==0 && (buff[7]>='0' && buff[7]<='5' && buff[7]!='4'))
#if defined(__SIM800_DS__)
          || (__STRNCMP(buff, "+CREGDS: ")==0 && (buff[9]>='0' && buff[9]<='5' && buff[9]!='4'))
#endif //__SIM800_DS__
          )
  {
    //e.g. +CREG: d,"hhhh","hhhhhhhh",d or +CREG: 2
    //or +CREG: 2,d,"hhhh,"hhhhhhhh",d if response from AT+CREG?

    //может ли быть такое URC?
    //e.g. +CREGDS: d,"hhhh","hhhhhhhh",d or +CREGDS: 2
    //or +CREGDS: 2,d,"hhhh,"hhhhhhhh",d if response from AT+CREG?

    creg_state_t* creg;
    uint8_t is_urc;
    uint8_t offset=0;

    creg=(creg_state_t*)(2+strchr((char*)buff,'\r'));

#if defined(__SIM800_DS__)
    if(__STRNCMP(buff, "+CREGDS: ")==0) offset=2;
#endif //__SIM800_DS__

    //определяем ответ на команду или urc
    char* ach=(char*)buff;

    if(__STRNCMP(ach+strlen("+CREG: d")+offset, "\r\n")==0)
      is_urc=1;
    else if(__STRNCMP(ach+strlen("+CREG: d")+offset, ",\"")==0)
      is_urc=1;
    else if(__STRNCMP(ach+strlen("+CREG: 2,d")+offset, "\r\n")==0)
      is_urc=0;
    else if(__STRNCMP(ach+strlen("+CREG: 2,d")+offset, ",\"")==0)
      is_urc=0;
    else //неизвестное, пропускаем
      is_urc=2;

    if(2>is_urc)
    {
      if(is_urc)
        ach+=strlen("+CREG: ")+offset;
      else
        ach+=strlen("+CREG: 2,")+offset;

      creg->regStatus=(uint8_t)strtoul(ach, NULL, 10);

      if(creg->regStatus==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || creg->regStatus==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
        ach+=3;
        creg->netLac=(uint16_t)strtoul(ach, NULL, 16);
        ach+=7;
        creg->netCellId=(uint32_t)strtoul(ach, NULL, 16);
        if(*(ach+8)=='"' && *(ach+9)==',')
        {
          ach+=10;
          creg->AcT=(uint8_t)strtoul(ach, NULL, 10);
        }
        else
        {
          creg->AcT=UNKNOWN_ACT_STATUS;
        }
      }
      else
      {
        creg->netLac=0;
        creg->netCellId=0;
        creg->AcT=UNKNOWN_ACT_STATUS;
      }

      if(offset==0)
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        modem_state.creg_state.regStatus = creg->regStatus;
        modem_state.creg_state.netLac = creg->netLac;
        modem_state.creg_state.netCellId = creg->netCellId;
        modem_state.creg_state.AcT = creg->AcT;
        xSemaphoreGive( modem_at_flags.lock_obj );

        if(!is_urc) SetModemAtFlag(CREG_FGSM);//if not URC
      }
#if defined(__SIM800_DS__)
      else
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        modem_state.ds_creg_state.regStatus = creg->regStatus;
        modem_state.ds_creg_state.netLac = creg->netLac;
        modem_state.ds_creg_state.netCellId = creg->netCellId;
        modem_state.ds_creg_state.AcT = creg->AcT;
        xSemaphoreGive( modem_at_flags.lock_obj );

        if(!is_urc) SetModemAtFlag(CREG_DS_FGSM);//if not URC
      }
#endif //__SIM800_DS__
    }
  }
  else if(__STRNCMP(buff, "+DTMF: ")==0)
  {
    dtmf_recv_callback(buff[sizeof("+DTMF: ")-1]);
  }
  else if(__STRNCMP(buff, "+CPIN: NOT INSERTED\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_INSERTED_FGSM);
  }
#endif //!defined(__A7670E__)
  else if(__STRNCMP(buff, "+CPIN: SIM PIN\r\n")==0)
  {
    SetModemAtFlag(CPIN_SIM_PIN_FGSM);
  }
#if defined(__SIM800_DS__)
  else if(__STRNCMP(buff, "+CPINDS: NOT INSERTED\r\n")==0)
  {
    SetModemAtFlag(CPIN_NOT_INSERTED_DS_FGSM);
  }
  else if(__STRNCMP(buff, "+CPINDS: SIM PIN\r\n")==0)
  {
    SetModemAtFlag(CPIN_SIM_PIN_DS_FGSM);
  }
  else if(__STRNCMP(buff, "+CDSDS: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+CDSDS: ")-1));
  }
#endif //__SIM800_DS__
  else if(__STRNCMP(buff, "NORMAL POWER DOWN\r\n")==0)
  {
    SetModemAtFlag(NORMAL_POWER_DOWN_FGSM);
  }
  else if(__STRNCMP(buff, "+CSQ: ")==0 && (buff[6]>='0' && buff[6]<='9') )
  {
    char* ach=(char*)(buff+strlen("+CSQ: "));
    uint8_t var;
    var=(uint8_t)atoi(ach);
    if(var<=31 || var==99)
      modem_state.rssi_level=var;
    else
      modem_state.rssi_level=99;
  }
  else if(__STRNCMP(buff, "+COPS: ")==0 && (buff[11]=='"' && (buff[17]=='"' ||  buff[18]=='"')))
  {
    //+COPS: 0,2,"25002"
    //+COPS: 0,2,"25099",7 //A7670
    char* ach=(char*)&buff[sizeof("+COPS: 0,2,\"")-1];

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.operator_inf.mnc=(uint16_t)strtoul(ach+3, NULL, 10);
    *(ach+3)='\0';
    modem_state.operator_inf.mcc=(uint16_t)strtoul(ach, NULL, 10);

#if defined(__A7670E__)
    if(buff[18]==',')
    {
      modem_state.creg_state.AcT = (uint8_t)strtoul(&buff[19], NULL, 10);
    }
    else if(buff[19]==',')
    {
      modem_state.creg_state.AcT = (uint8_t)strtoul(&buff[20], NULL, 10);
    }
#endif //defined(__A7670E__)
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "+CGATT: ")==0)
  {
    modem_state.cgatt_state=buff[sizeof("+CGATT: ")-1]-0x30;
  }
  else if(__STRNCMP(buff, "SHUT OK")==0)
  {
    SetModemAtFlag(CIPSHUT_OK_FGSM);
  }
  else if(__STRNCMP(buff, "RDY\r\n")==0
          || __STRNCMP((buff+1), "RDYr\n") == 0
            || __STRNCMP((buff+2), "RDY\r\n") == 0
              )
  {
    SetModemAtFlag(RDY_FGSM);
  }
  else if(__STRNCMP(buff, "+CCLK: \"")==0)
  {
    //+CCLK: "16/03/30,13:14:05+24"
    //+CCLK: "70/01/01,00:00:19+28"
    if(is_modem_time_synchronized())
    {//если было событие сихронизации со временем сети
      const char* src=&buff[sizeof("+CCLK: \"")-1];
      char* next;
      time_struct_t time;
      uint32_t utime;
      uint8_t s_gmt;
      uint32_t gmt;

      uint8_t is_fmt_ok=0;
      for(;;)
      {
        time.year=(uint8_t)strtoul(src, &next, 10);
        time.year+=2000;
        if(time.year<=2020 || time.year>=2070) break;
        if(*next!='/') break;
        src=next+1;
        time.mon=(uint8_t)strtoul(src, &next, 10);
        if(*next!='/') break;
        src=next+1;
        time.day=(uint8_t)strtoul(src, &next, 10);
        if(*next!=',') break;
        src=next+1;
        time.hour=(uint8_t)strtoul(src, &next, 10);
        if(*next!=':') break;
        src=next+1;
        time.min=(uint8_t)strtoul(src, &next, 10);
        if(*next!=':') break;
        src=next+1;
        time.sec=(uint8_t)strtoul(src, &next, 10);
        if(*next=='+') s_gmt=0;
        else if(*next=='-') s_gmt=1;
        else break;
        src=next+1;
        gmt=(uint32_t)strtoul(src, NULL, 10);
        if(gmt>48) break;

        is_fmt_ok=1;
        break;
      }

      if(is_fmt_ok)
      {
        utime=conv_time_to_unixtime(&time);
        gmt=(gmt*60*60)/4;
        if(s_gmt) utime+=gmt;
        else utime-=gmt;

        if(utime>=modem_time.last_sync_utime)
        {
          modem_time.network_utime=utime;
          modem_time.cclk_result = 1;
          //SetModemAtFlag(OK_FGSM);
        }
        else
        {
          modem_time.network_utime=0;
          modem_time.cclk_result = 0;
          //SetModemAtFlag(ERROR_FGSM);
        }
      }
      else
      {
        modem_time.network_utime=0;
        modem_time.cclk_result = 0;
        //SetModemAtFlag(ERROR_FGSM);
      }
    }
    else
    {
      modem_time.network_utime=0;
      modem_time.cclk_result = 0;
      //SetModemAtFlag(ERROR_FGSM);
    }
  }
  else if(__STRNCMP(buff, "*PSUTTZ: ")==0 && sym_cnt_in_str(buff, ',')==7 && strstr(buff, ",,")==NULL)
  {
    //*PSUTTZ: 2016,3,30,7,13,58,"+24",0
    const char* src=&buff[sizeof("*PSUTTZ: ")-1];
    char* next;
    time_struct_t time;

    time.year=(uint16_t)strtoul(src, &next, 10);
    src=next+1;
    time.mon=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.day=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.hour=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.min=(uint8_t)strtoul(src, &next, 10);
    src=next+1;
    time.sec=(uint8_t)strtoul(src, NULL, 10);

    if(time.year<2016)
    {
      modem_time.last_sync_utime=0;
    }
    else
    {
      modem_time.last_sync_utime=conv_time_to_unixtime(&time);
    }
  }
  else if(__STRNCMP(buff, "+SJDR: ")==0)
  {
    char* ach=(char*)(buff+strlen("+SJDR: "));

    if(__STRNCMP(ach, "NO JAMMING")==0)                     modem_state.jamming_state=NO_JAMMING;
    else if(__STRNCMP(ach, "JAMMING DETECTED")==0)          modem_state.jamming_state=JAMMING_DETECTED;
    else if(__STRNCMP(ach, "INTERFERENCE DETECTED")==0)     modem_state.jamming_state=INTERFERENCE_DETECTED;
  }
  else if(__STRNCMP(buff, "UNDER-VOLTAGE POWER DOWN")==0 || __STRNCMP(buff, "UNDER-VOLTAGE WARNNING")==0)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.power_status=UNDERVOLTAGE_MODEM_POWER_STATUS;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "OVER-VOLTAGE POWER DOWN")==0 || __STRNCMP(buff, "OVER-VOLTAGE WARNNING")==0)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.power_status=OVERVOLTAGE_MODEM_POWER_STATUS;
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "+CMTE: ")==0)
  {
    char* ach=(char*)(buff+sizeof("+CMTE: ")-1);
    int8_t var;
    var=(int8_t)atoi(ach);

    //xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    if(var==0)
      modem_state.temp_status=NORMAL_MODEM_TEMP_STATUS;
    else if(var==1)
      modem_state.temp_status=UPPER_MODEM_TEMP_STATUS;
    else if(var==2)
      modem_state.temp_status=UPPERMOST_MODEM_TEMP_STATUS;
    else if(var==-1)
      modem_state.temp_status=LOW_MODEM_TEMP_STATUS;
    else if(var==-2)
      modem_state.temp_status=LOWEST_MODEM_TEMP_STATUS;
    //xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "RING\r\n")==0)
  {
    //modem_state.is_ready_to_ata_cmd=1;
  }
  else if(__STRNCMP(buff, "+CLIP: \"")==0)
  {
    //
  }
  else if((__STRNCMP(buff, "+CLCC: ")==0 || __STRNCMP(buff, "+CLCCDS: ")==0) && (sym_cnt_in_str(buff, ',')==7 || sym_cnt_in_str(buff, ',')==4) && strstr(buff, ",,")==NULL)
  {
    //+CLCC: 1,1,0,0,0,"+79231780661",145,""
    char* ach;
    char* next;

    if(__STRNCMP(buff, "+CLCC: ")==0)   ach=(char*)(buff+strlen("+CLCC: "));
    else                                ach=(char*)(buff+strlen("+CLCCDS: "));

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    modem_state.call_state.is_call_present=1;

    uint8_t id=(uint8_t)strtoul(ach, &next, 10);//id
    ach=next+1;
    //обрабатываем только звонок с id=1, другие звонки будут удержаны, после завершения работы с id=1, последующие будут отключены
    if(id==1)
    {
    modem_state.call_state.dir=(call_dir_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.call_state.stat=(call_stat_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.call_state.mode=(call_mode_t)strtoul(ach, &next, 10);
    ach=next+1;
    strtoul(ach, &next, 10);//mpty
    ach=next;

    //есть номер
    if(ach[0]==',' && ach[1]=='"')
    {
      ach+=2;
      for(uint8_t i=0; i<(sizeof(modem_state.call_state.number)-1); i++)
      {
        modem_state.call_state.number[i]=ach[i];
        modem_state.call_state.number[i+1]='\0';
        if(ach[i+1]=='"' || ach[i+1]==',') break;
      }
    }
  }
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "NO CARRIER\r\n")==0)
  {
    //xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    //modem_state.incoming_call_indicator=0;
    //memset(modem_state.incoming_call_number, 0, sizeof(modem_state.incoming_call_number));
    //xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else if(__STRNCMP(buff, "Revision:")==0)
  {
    parse_aux_data((char*)(buff+sizeof("Revision:")-1));
  }
  else if(__STRNCMP(buff, "+CENG: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+CENG: ")-1));
  }
  else if(__STRNCMP(buff, "+FSFLSIZE: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+FSFLSIZE: ")-1));
  }
  else if(__STRNCMP(buff, "+FSMEM: ")==0)
  {
    parse_aux_data((char*)(buff+sizeof("+FSMEM: ")-1));
  }
  else if(__STRNCMP(buff, "AT+FSREAD=")==0  && sym_cnt_in_str(buff, ',')==3 && strstr(buff, ",,")==NULL)
  {
    //������ �����
    modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//�������

    const char* ach=strchr(strchr(buff, ',')+1, ',')+1;

    modem_parse.bt_gprs_len_wait=atoi(ach);

    if(modem_parse.bt_gprs_len_wait<=0)
    {//нет данных
      SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
    }
    else
    {
      //дальше будут данные файла
    }
  }
//>---------------------------------->
#if (defined(__SIM800__) || defined(__SIM800_DS__))
  else if(__STRNCMP(buff, "+BLESCANRST: ")==0)
  {
    //__PRINTF("%.*s", buff_len, buff);

#if BLE_SCAN_TABLE_SIZE > 0
    if(sym_cnt_in_str(buff, ',')==4 && strstr(buff, ",,")==NULL && buff[buff_len-2]=='\r' && buff[buff_len-1]=='\n')
    {
      const uint16_t len=buff_len-(sizeof("\r\n")-1);
      uint16_t offset=sizeof("+BLESCANRST: ")-1;

      const uint32_t user_id=(uint32_t)strtoul(&buff[offset], NULL, 16);

      if(/*ble_scan_gat_id== && */ble_scan_table_idx<BLE_SCAN_TABLE_SIZE)
      {
        bt_gat_scan_t* const lescan=&ble_scan_table[ble_scan_table_idx];

        //��� <user_id>
        for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}
        //��� <scan_index>
        for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}
        //��� <rssi>
        lescan->rssi=(int8_t)(strtol(&buff[offset], NULL, 10)-127);

        for(; offset<len; offset++) {if(buff[offset]==',') {offset++; break;}}

        for(uint8_t i=0; i<sizeof(lescan->mac); i++)
        {
          lescan->mac[i]=(char_to_hex(buff[offset++])<<4);
          lescan->mac[i]|=(char_to_hex(buff[offset++])<<0);
          offset++; //skip '\:'
        }

        if(IsBleMacScanIgnore(lescan->mac))
        {
          memset(lescan->mac, 0, sizeof(lescan->mac));
        }
        else
        {
          for(lescan->eir_len=0; lescan->eir_len<sizeof(lescan->eir); lescan->eir_len++)
          {
            if(offset>=len) break;
            lescan->eir[lescan->eir_len]=(char_to_hex(buff[offset++])<<4);
            if(offset>=len) break;
            lescan->eir[lescan->eir_len]|=(char_to_hex(buff[offset++])<<0);
          }

          ble_scan_table_idx++;
        }
      }
    }
#endif //BLE_SCAN_TABLE_SIZE > 0
  }
  else if(__STRNCMP(buff, "+BLECREG: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    const char* ach=&buff[sizeof("+BLECREG: ")-1];

    ble_scan_gat_id = (uint16_t)strtoul(ach, NULL, 16);
  }
  else if(__STRNCMP(buff, "+BLECDREG: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);

    const char* ach=&buff[sizeof("+BLECDREG: ")-1];

    if(ble_scan_gat_id == (uint16_t)strtoul(ach, NULL, 16))
    {
      ble_scan_gat_id = 0xFFFF;
    }
  }
  //else if(__STRNCMP(buff, "+QGATCFGSCAN: ")==0)
  //{
  //  __PRINTF("%.*s", buff_len, buff);
  //}
  //else if(__STRNCMP(buff, "+QBTLETXPWR: ")==0 || __STRNCMP(buff, "+QBTGATRFPWR: ")==0)
  //{
  //  __PRINTF("%.*s", buff_len, buff);
  //}
//<----------------------------------<
#if defined(SIMCOM_MODEM_FTP_PRESENT)
  else if(__STRNCMP(buff, "+FTPGET:")==0 && sym_cnt_in_str(buff, ',')==1 && strstr(buff, ",,")==NULL)
  {
    const char* ach=&buff[sizeof("+FTPGET:")-1];
    char* next;

    modem_state.ftp_res_1=(uint8_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.ftp_res_2=(uint16_t)strtoul(ach, NULL, 10);

    if(modem_state.ftp_res_1 == 2)
    {
      //������ FTP
      modem_parse.bt_gprs_ctx=bt_gprs_flow.rx_ctx;//�������

      modem_parse.bt_gprs_len_wait = (int16_t)modem_state.ftp_res_2;

      if(modem_parse.bt_gprs_len_wait<=0)
      {//��� ������
        SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
      }
      else
      {
        //������ ����� ������ FTP
      }
    }
    else
    {
      SetModemAtFlag(FTP_FLAG_FGSM);
    }
  }
  else if(__STRNCMP(buff, "+FTPSIZE:")==0 && strstr(buff, ",,")==NULL)
  {
    const char* ach=&buff[sizeof("+FTPSIZE:")-1];
    char* next;

    modem_state.ftp_res_1=(uint8_t)strtoul(ach, &next, 10);
    ach=next+1;
    modem_state.ftp_res_2=(uint16_t)strtoul(ach, &next, 10);
    if(modem_state.ftp_res_1 == 1 && modem_state.ftp_res_2 == 0)
    {
      ach=next+1;
      modem_state.ftp_fsize=(uint32_t)strtoul(ach, NULL, 10);
    }
    else
    {
      modem_state.ftp_fsize=0;
    }

    SetModemAtFlag(FTP_FLAG_FGSM);
  }
#endif //defined(SIMCOM_MODEM_FTP_PRESENT)
#endif //(defined(__SIM800__) || defined(__SIM800_DS__))
  else if(__STRNCMP(buff, "+CUSD: ")==0 || __STRNCMP(buff, "+CUSDDS: ")==0)
  {
    const char* ach = NULL;

    if(__STRNCMP(buff, "+CUSD: 0, \"")==0)        {ach = (const char*)(buff + (sizeof("+CUSD: 0, \"")-1));} //SIMCOM
    else if(__STRNCMP(buff, "+CUSDDS: 0, \"")==0) {ach = (const char*)(buff + (sizeof("+CUSDDS: 0, \"")-1));} //SIMCOM
    else if(__STRNCMP(buff, "+CUSD: 0,\"")==0)    {ach = (const char*)(buff + (sizeof("+CUSD: 0,\"")-1));} //Quectel
    else if(__STRNCMP(buff, "+CUSDDS: 0,\"")==0)  {ach = (const char*)(buff + (sizeof("+CUSDDS: 0,\"")-1));} //???

    if(ach != NULL)
    {
      //+CUSD: 2,"002D00320032003600350037002E0032003600200440002E000A0020",72\r\n //MC60 -22657.26 �.
      //+CUSD: 0,"002D00320032003600370033002E0030003500200440002E000A0020",72\r\n //EC21, �������� ���������� ����� OK
      //+CUSD: 0, "0412043004480430002004370430044F0432043A04300020043F04400438043D044F04420430002E00200414043E043604340438044204350441044C00200053004D0053002D0443043204350434043E043C043B0435043D0438044F0020043E0431002004380441043F043E043B043D0435043D04380438002004370430044F0432043A0438002E", 72\r\n //SIM868, �������� ���������� ����� OK
      //+CUSDDS: 0, "04110430043B0430043D0441003A00310035003600300032002C003900310440002C041B0438043C04380442003A0033003000370030003004400020", 72\r\n //SIM868

      if(buff_len>16 && buff[buff_len-1]=='\n' && buff[buff_len-2]=='\r')
      {
        uint8_t end_offset = 0;

        if(buff[buff_len-5]==' ' && buff[buff_len-6]==',' && buff[buff_len-7]=='"') {end_offset = 7;} //SIMCOM
        else if(buff[buff_len-5]==',' && buff[buff_len-6]=='"') {end_offset = 6;}; //Quectel

        if(end_offset)
        {
          buff[buff_len-end_offset]='\0';
          const uint16_t ach_len=strlen(ach);

          xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
          if(aux_data.dst_mem!=NULL && aux_data.dst_mem_size!=0)
          {
            if(ach_len%4==0 && ach_len/4<aux_data.dst_mem_size)
            {
              UCS2toWin1251(ach, aux_data.dst_mem);
            }
          }
          xSemaphoreGive( modem_at_flags.lock_obj );
        }
      }
    }

    SetModemAtFlag(CUSD_FGSM);
  }
  else
  {
    //SetModemAtFlag(empty_FGSM);
  }

#if defined(USE_BT_HFG)
  //debug
  if(__STRNCMP(buff, "+BTCONNECT: ")==0 || __STRNCMP(buff, "+BTDISCONN: ")==0 || __STRNCMP(buff, "+BTSCAN: ")==0)
  {
    __PRINTF("%.*s", buff_len, buff);
  }
#endif //defined(USE_BT_HFG)
}

void ResetSimcomLibState(void)
{
  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xff;
  bt_gprs_flow.tx_ctx=0xff;
  bt_gprs_flow.bt_spp_ctx=0xff;
  bt_gprs_flow.bt_status=0;
  bt_gprs_flow.req_spp_timer=xTaskGetTickCount();
  modem_at_flags.flags=0;

  modem_state.creg_state.netLac=0;
  modem_state.creg_state.netCellId=0;
  modem_state.creg_state.regStatus=UNKNOWN_CREG_STATUS;
  modem_state.creg_state.AcT=UNKNOWN_ACT_STATUS;

  modem_state.operator_inf.mcc=0;
  modem_state.operator_inf.mnc=0;

#if defined(__SIM800_DS__)
  modem_state.ds_creg_state.netLac=0;
  modem_state.ds_creg_state.netCellId=0;
  modem_state.ds_creg_state.regStatus=UNKNOWN_CREG_STATUS;
  modem_state.ds_creg_state.AcT=UNKNOWN_ACT_STATUS;
#endif

  sms_read_flow.is_wait_data=0;
  sms_read_flow.recv_mem_ptr=NULL;
  sms_read_flow.phone=NULL;
  sms_read_flow.chunks_inf=NULL;

  modem_state.sms_inf.used=0;
  modem_state.sms_inf.total=0;

  modem_state.is_sim_failure=0;
  modem_state.rssi_level=99;
  modem_state.jamming_state=NO_JAMMING;

  memset(&modem_state.call_state, 0, sizeof(modem_state.call_state));

  modem_state.cfun_state=0;
  modem_state.pdp_deact_event=0;
  modem_state.cgatt_state=0;
  modem_state.is_wait_local_ip_responce=0;

  modem_state.power_status=UNKNOWN_MODEM_POWER_STATUS;
  modem_state.temp_status=UNKNOWN_MODEM_TEMP_STATUS;

/*
#if USE_MODEM_UART_DMA_RX > 0
  DMA_SetCurrDataCounter(, MODEM_RX_MEM_SIZE);
#endif
*/

  //reset parse vars:
  modem_parse.buff_idx=0;
  modem_parse.bt_gprs_len_wait=0;
  modem_parse.buff_full_flag=0;

  modem_fwd.state=FORWARDING_DISABLED;
  modem_fwd.rx_ptr=NULL;

  modem_time.last_sync_utime=0;
  modem_time.network_utime=0;

  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;

#if (defined(__SIM800__) || defined(__SIM800_DS__))
#if BLE_SCAN_TABLE_SIZE > 0
  memset(ble_scan_table, 0, sizeof(ble_scan_table));
  ble_scan_table_idx=0;
  ble_scan_gat_id=0xFFFF;
#endif //BLE_SCAN_TABLE_SIZE > 0
#endif //(defined(__SIM800__) || defined(__SIM800_DS__))

#if defined(USE_BT_HFG)
  hfg_pair_ctx.pair_ctx_state = 0;
  hfg_pair_ctx.pair_mac_cmp_state = 0;
#endif //defined(USE_BT_HFG)

#if defined(__A7670E__)
  cops_req_timer = xTaskGetTickCount();
#endif //defined(__A7670E__)

  ClearAllModemAtFlags();
}

//int16_t voice_call_config(void)
//{
//  int16_t at_res;
//
//  clear_call_indicator();
//
//  at_res=send_simple_at("AT+CLIP=1\r", 2000);//Calling Line Identification Presentation
//  if(GSM_RES_OK==at_res)
//  {
//    at_res=send_simple_at("AT+CRC=1\r", 2000);//Incoming Call Indication Format
//  }
//
//  return at_res;
//}

int16_t voice_call_answer(void)
{
  int16_t at_res=GSM_NOTDONE_ERR;

  //оправляем команду ответить нескольуо раз
  for(uint8_t i=0; i<3; i++)
  {
    if(GSM_NOTDONE_ERR==at_res)
    {
      at_res=send_simple_at("ATA\r", 20*1000);
      if(GSM_NOTDONE_ERR==at_res)
      {
      vTaskDelay(1000);
      continue;
      }
      else
      {
        break;
      }
    }
  }

  return at_res;
}

int16_t voice_call(const char* phone)
{
  int16_t at_res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "ATD%s;\r", phone);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  at_res=send_simple_at(cmd_buff, 20*1000);

  return at_res;
}

int16_t voice_call_disconnect(void)
{
  int16_t at_res;

  at_res=send_simple_at("ATH\r", 20*1000);

  return at_res;
}

int16_t get_call_state(call_state_t* call_state)
{
  int16_t at_res;

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  memset(&modem_state.call_state, 0, sizeof(modem_state.call_state));
  xSemaphoreGive( modem_at_flags.lock_obj );

  at_res=send_simple_at("AT+CLCC\r", 2000);
  if(GSM_RES_OK==at_res)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(call_state, &modem_state.call_state, sizeof(call_state_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  return at_res;
}

void SimcomParse_cycle(void)
{
  uint16_t parse_len;
  modem_uart_rx_t* modem_uart_rx;
#if EN_MODEM_DEBUG > 0
  uint8_t printf_en;
#endif

  if(modem_at_flags.lock_obj==NULL) modem_at_flags.lock_obj=xSemaphoreCreateMutex();
  modem_uart_rx=GetModemUartRxStructPtr();

  for(;;)
  {
    while(!modem_uart_rx->is_init)
    {
      vTaskDelay(10);
    }

#if USE_PARSE_WAIT_UNTIL > 1
    static uint32_t ParseTimeWait=0;

    ParseTimeWait=((uint32_t)xTaskGetTickCount()-ParseTimeWait);
    if(FILLING_TIME_1_2>ParseTimeWait) ParseTimeWait=MODEM_UART_BUFF_FILLING_TIME_1_2-ParseTimeWait;
    else                               ParseTimeWait=0;
    xSemaphoreTake(*modem_uart_rx->sync_obj, ParseTimeWait);
    ParseTimeWait=xTaskGetTickCount();
#else
    xSemaphoreTake(*modem_uart_rx->sync_obj, MODEM_UART_BUFF_FILLING_TIME_1_2);
#endif

/*
#if USE_MODEM_UART_DMA_RX > 0
    force_set_cbuff_in_idx();
#endif
*/

    if(modem_fwd.state==FORWARDING_DISABLE_CMD)
    {
      modem_fwd.state=FORWARDING_DISABLE_ACK;
      modem_parse.buff_full_flag=0;
      modem_parse.buff_idx=0;
    }

    uint16_t filled_len=filled_cbuff_len(&modem_uart_rx->cbuff);

    while(filled_len)
    {
      parse_len=0;
#if EN_MODEM_DEBUG > 0
      if(modem_rx_log_out_en) printf_en=1;
#endif
      if(filled_len)//если что-то есть в кольцевом буфере
      {
        if(modem_parse.bt_gprs_len_wait>0)//если данные gprs
        {
          uint16_t read_len;
          if(filled_len>modem_parse.bt_gprs_len_wait) read_len=modem_parse.bt_gprs_len_wait;
          else                                        read_len=filled_len;

          if(bt_gprs_flow.rx_write_ptr!=NULL && bt_gprs_flow.rx_ctx==modem_parse.bt_gprs_ctx)//есть куда писать
          {
            read_from_cbuff(&modem_uart_rx->cbuff, bt_gprs_flow.rx_write_ptr, read_len);
            bt_gprs_flow.rx_write_ptr+=read_len;
          }
          else
          {
            clean_cbuff_len_from_reader(&modem_uart_rx->cbuff, read_len);
          }

          //if(filled_len==0){filled_len++;filled_len--;}//не должны сюда попадать
          filled_len-=read_len;
          modem_parse.bt_gprs_len_wait-=read_len;

          if(modem_parse.bt_gprs_len_wait==0)
          {
            SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
            //все данные GPRS приняты, далее нужно дождаться OK, перед тем как что-то слать
          }
        }
        else if(modem_fwd.state==FORWARDING_ENABLE)//если данные перенаправленные
        {
          uint16_t can_recv;
          uint16_t read_len;
          can_recv=modem_fwd.rx_end-modem_fwd.rx_ptr+1;;
          if(filled_len>can_recv) read_len=can_recv;
          else                    read_len=filled_len;

          if(read_len)//есть что писать
          {
            if(modem_fwd.rx_ptr!=NULL)//есть куда писать
            {
              read_from_cbuff(&modem_uart_rx->cbuff, modem_fwd.rx_ptr, read_len);
              modem_fwd.rx_ptr+=read_len;
            }
          }
          //оставшееся стираем, иначе повиснем в цикле
          if(filled_len>read_len)
          {
            clean_cbuff_len_from_reader(&modem_uart_rx->cbuff, filled_len-read_len);
            //тут можно установить признак переполнения буфера куда перенаправляем
          }
          filled_len=0;
        }
        else
        {
          while(filled_len)//копируем пока не найдены \r\n
          {
            modem_parse.buff[modem_parse.buff_idx]=read_byte_from_cbuff(&modem_uart_rx->cbuff);
            modem_parse.buff_idx++;
            filled_len--;

            if(modem_parse.buff_full_flag)//если было переполнение локального буфера, ждем '\n'
            {
              if(modem_parse.buff[modem_parse.buff_idx-1]=='\n')
              {
                modem_parse.buff_full_flag=0;
              }
              modem_parse.buff_idx=0;
            }
            else if(modem_parse.buff_idx>=sizeof(modem_parse.buff)-1)//локальный буфер заполнен, если последние два символа \r\n отправлем¤ в парсер, иначе ждем '\n'
            {
              if(modem_parse.buff[modem_parse.buff_idx-2]=='\r' && modem_parse.buff[modem_parse.buff_idx-1]=='\n')
              {
                parse_len=modem_parse.buff_idx;
                modem_parse.buff[modem_parse.buff_idx]='\0';
                modem_parse.buff_idx=0;
                break;//идем в парсер
              }
              else
              {
#if EN_MODEM_DEBUG > 0
                if(modem_rx_log_out_en)
                {
                  __CHAR_BUFF_PRINTF(modem_parse.buff, modem_parse.buff_idx, "ModemRxLog: Overflow modem_parse.buff\n");
                }
#endif
                modem_parse.buff_idx=0;
                modem_parse.buff_full_flag=1;
                __PRINTF("Overflow modem_parse.buff\n");
              }
            }

            //получение заголовка bt пришлось вынести из AtParse, из-за того, что между данными и заголовком нет \r\n
            else if((modem_parse.buff[modem_parse.buff_idx-1]==',' || modem_parse.buff[modem_parse.buff_idx-1]=='\n')
                    && modem_parse.buff_idx>=sizeof("+BTSPPGET: x,y")-1 &&__STRNCMP((char*)modem_parse.buff, "+BTSPPGET: ")==0)
            {//проверяем на заголовок bt данных
              modem_parse.buff[modem_parse.buff_idx]='\0';
              if(modem_parse.buff[modem_parse.buff_idx-1]=='\n')
              {
                //нет данных
                modem_parse.bt_gprs_ctx=(uint8_t)atoi((char*)&modem_parse.buff[11]);
                modem_parse.bt_gprs_len_wait=0;
                SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
              }
              else
              {
                modem_parse.bt_gprs_ctx=(uint8_t)atoi((char*)&modem_parse.buff[11]);
                modem_parse.bt_gprs_len_wait=atoi((char*)&modem_parse.buff[13]);

                if(modem_parse.bt_gprs_len_wait<=0)
                {//нет данных
                  SetModemAtFlag(CIPRXGET_BTSPPGET_ENDDATA_FGSM);
                }
                else
                {
                  //дальше будут данные bt
                }
              }
#if EN_MODEM_DEBUG > 0
              if(modem_rx_log_out_en)
              {
                if (printf_en)
                {
                  __CHAR_BUFF_PRINTF(modem_parse.buff, modem_parse.buff_idx, "ModemRxLog, len: %hu\n", modem_parse.buff_idx);
                }
              }
#endif
               modem_parse.buff_idx=0;
               break;//идем в парсер (будет пропущен)
            }
            else if(modem_parse.buff_idx>=2 && modem_parse.buff[modem_parse.buff_idx-2]=='\r' && modem_parse.buff[modem_parse.buff_idx-1]=='\n')
            {
              if(modem_parse.buff_idx==2)//в строке только \r\n
              {
                modem_parse.buff_idx=0;
              }
              else
              {
                parse_len=modem_parse.buff_idx;
                modem_parse.buff[modem_parse.buff_idx]='\0';
                modem_parse.buff_idx=0;
                break;//идем в парсер
              }
            }
            else if(modem_parse.buff_idx==1 && modem_parse.buff[modem_parse.buff_idx-1]=='>')
            {
              parse_len=modem_parse.buff_idx;
              modem_parse.buff[modem_parse.buff_idx]='\0';
              modem_parse.buff_idx=0;
              break;//идем в парсер
            }
          }
        }
      }

      if(parse_len)
      {
        /*parse input data*/
        SimcomAtParse((char*)modem_parse.buff, parse_len);
        force_wakeup_if_sleep();

#if EN_MODEM_DEBUG > 0
        if(modem_rx_log_out_en)
        {
          if (printf_en)
          {
            __CHAR_BUFF_PRINTF(modem_parse.buff, parse_len, "ModemRxLog, len: %hu\n", parse_len);
          }
        }
#endif
      }

/*
#if USE_MODEM_UART_DMA_RX > 0
      force_set_cbuff_in_idx();
#else
      */
      if(modem_uart_rx->full_flag==1)
      {
        clear_cbuff_from_reader(&modem_uart_rx->cbuff);
        modem_uart_rx->full_flag=2;
        __PRINTF("ModemRxLog: Переполнение кольцевого буфера, ovf err...\n");
      }
      if(modem_uart_rx->ore_flag==1)
      {
        modem_uart_rx->ore_flag=0;
        __PRINTF("ModemRxLog: потерян байт, ore err...\n");
      }
      /*
#endif
      */
      if(free_cbuff_len(&modem_uart_rx->cbuff)>MODEM_RX_BUFF_WM)
      {
        __MODEM_UART_SOFT_RTS_PIN_LOW();
      }
    }
  }
}

// Функции работы с флагами событий модема
void SetModemAtFlag(uint32_t flags_mask)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags|=flags_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);
}

void ResetModemAtFlag(uint32_t flag_mask)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags&=~flag_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);
}

uint32_t ReadModemAtFlag(uint32_t flags_mask)
{
  uint32_t flags;
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  flags=modem_at_flags.flags&flags_mask;
  xSemaphoreGive(modem_at_flags.lock_obj);
  return flags;
}

void ClearAllModemAtFlags(void)
{
  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  modem_at_flags.flags=0;
  xSemaphoreGive(modem_at_flags.lock_obj);
}

uint32_t WaitModemFlags(uint32_t flags_mask, uint32_t timeout)
{
  uint32_t end_wait_timeMS;

  end_wait_timeMS=timeout+xTaskGetTickCount();

  do{
    vTaskDelay(GSM_WAIT_FLAG_DEF_TICK);
    if(timeAfter(xTaskGetTickCount(), end_wait_timeMS)) break;
  }while(!ReadModemAtFlag(flags_mask));

  return (ReadModemAtFlag(flags_mask));
}

// Послать AT команду с ожиданием указанных флагов (логичеcкое или) или ERROR
int16_t extended_send_simple_at(const char* at, uint32_t wait_flags, uint32_t wait_resp_timeout)
{
  int16_t res;
  uint32_t flags;

  ResetModemAtFlag(wait_flags|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)at, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    if(!wait_resp_timeout) return GSM_TIMEOUT_ERR;//если команда без ожидания ответа, то сразу возвращаем ошибку таймаута

    flags=WaitModemFlags(wait_flags|ERROR_FGSM, wait_resp_timeout);
    if(flags&wait_flags) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  return GSM_RES_OK;
}

// Послать AT команду с ожиданием OK или ERROR
int16_t send_simple_at(const char* at, uint32_t wait_resp_timeout)
{
  return extended_send_simple_at(at, OK_FGSM, wait_resp_timeout);
}

// �������� ����� OK, ERROR, ������� ������ ��� ������� ��� ��������
int16_t send_data_in_fwd_mode(const char* s, uint16_t slen)
{
  int16_t res;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)s, slen, GSM_TX_DEF_TIMEOUT);
  if(res!=MODEM_UART_TX_OK) {return GSM_NOTDONE_ERR;}
  else                      {return GSM_RES_OK;}
}

// API ��� ������ � GPRS � TCP
//Bring Up Wireless Connection with GPRS or CSD
NOT_USED(static int16_t bring_up_gprs_wireless_connection(void))
{//���
  return send_simple_at("AT+CIICR\r", 85000);
}

int16_t jamming_detect_config(void)
{
#if defined(__A7670E__)
  return GSM_RES_OK;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  return send_simple_at("AT+SJDR=1,1,255,1\r", 2000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

jamming_state_t get_jamming_state(uint8_t is_reset_after_read)
{
  jamming_state_t res=modem_state.jamming_state;
  if(is_reset_after_read) modem_state.jamming_state=NO_JAMMING;
  return res;
}

NOT_USED(static int16_t is_local_ip_obtained(void))
{//���
  int16_t res;

  modem_state.is_wait_local_ip_responce=1;
  res=send_simple_at("AT+CIFSR\r", 2000);//Get Local IP Address
  modem_state.is_wait_local_ip_responce=0;
  return res;
}

int16_t cfun_config(uint8_t fun, uint8_t rst)
{
  int s_len;

  if(rst && !(fun==1)) return GSM_WRONG_IN_PARAM;
  if(!(fun==0 || fun==1 || fun==4)) return GSM_WRONG_IN_PARAM;

  if(rst)
  {
    snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFUN=1,1\r");
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFUN=%hhu\r", fun);
  }
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 15000);
}

uint8_t is_enable_set_minimum_functionality_for_set_apn(void)
{
  return 0;
}

int16_t gprs_config(const char* user, const char* passwd, const char* apn)
{
#if defined(__A7670E__)
  int s_len;
  int16_t res;

  send_simple_at("AT+CGDCONT?\r", 9000);
  send_simple_at("AT+CGAUTH?\r", 9000);

  if(apn==NULL)
  {
    return GSM_WRONG_IN_PARAM;
  }

  extended_send_simple_at("AT+NETCLOSE\r", CIPSHUT_OK_FGSM, 120000);

  //extended_send_simple_at("AT+CIPSHUT\r", CIPSHUT_OK_FGSM, 65000);
  //send_simple_at("AT+CIPSTATUS\r", 2000);

  if(apn[0] != '\0')
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CGDCONT=1,\"IP\",\"%s\"\r", apn);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CGDCONT=1,\"IP\"\r");
  }

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res = send_simple_at(cmd_buff, 9000);
  if(res!=GSM_RES_OK) return res;


  if(user != NULL && passwd != NULL && user[0]!= '\0' && passwd[0] != '\0')
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CGAUTH=1,1,\"%s\",\"%s\"\r", passwd, user); //PAP
  }
  else if(passwd != NULL && passwd[0] != '\0')
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CGAUTH=1,2,\"%s\"\r", passwd); //CHAP
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CGAUTH=1,0\r"); //NONE
  }

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res = send_simple_at(cmd_buff, 9000);
  if(res!=GSM_RES_OK) return res;

  send_simple_at("AT+CGDCONT?\r", 9000);
  send_simple_at("AT+CGAUTH?\r", 9000);

  res = send_simple_at("AT+NETOPEN\r", 120000);
  if(res!=GSM_RES_OK) return res;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int s_len;

  if(apn==NULL) return GSM_WRONG_IN_PARAM;

  extended_send_simple_at("AT+CIPSHUT\r", CIPSHUT_OK_FGSM, 65000);

  //send_simple_at("AT+CIPSTATUS\r", 2000);

  if(!(user==NULL || passwd==NULL))
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CSTT=\"%s\",\"%s\",\"%s\"\r", apn, user, passwd);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CSTT=\"%s\"\r", apn);
  }
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t tcp_socket_open(uint8_t ctx, const char* addr)
{
#if defined(__A7670E__)
  int s_len;

  int16_t res;
  char* port;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;
  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(NULL==port) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5)return GSM_WRONG_IN_PARAM;

  res = send_simple_at("AT+NETOPEN\r", 120000);

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPOPEN=%u,\"TCP\",\"%.*s\",%.*s\r", ctx, port-addr-1, addr, 5, port);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.cgatt_state=0;
  res=send_simple_at("AT+CGATT?\r", 10000);
  if(res!=GSM_RES_OK) return res;

  return send_simple_at(cmd_buff, 120000); //Range: 3000ms-120000ms
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  //AT+CIPSTART=<n>,<mode>,<address>,<port>
  int s_len;

  int16_t res;
  char* port;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;
  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(NULL==port) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5)return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPSTART=%hhu,\"TCP\",\"%.*s\",\"%.*s\"\r", ctx, port-addr-1, addr, 5, port);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.cgatt_state=0;
  res=send_simple_at("AT+CGATT?\r", 10000);
  if(res!=GSM_RES_OK) return res;

  if(!modem_state.cgatt_state)
  {
#warning ��������� ������� AT+CGATT=1?
    uint32_t cgatt_timer = xTaskGetTickCount();

    res=send_simple_at("AT+CGATT=1\r", 76000);

    cgatt_timer = xTaskGetTickCount() - cgatt_timer;
    if(cgatt_timer >= 30000)
    {
      LOG("warn: AT+CGATT=1 was executed %u s\n", cgatt_timer/1000);
    }

    if(res!=GSM_RES_OK) return res;

    res=send_simple_at("AT+CGATT?\r", 10000);
    if(res!=GSM_RES_OK) return res;
  }

  res=is_local_ip_obtained();
  if(res!=GSM_RES_OK)
  {
    res=bring_up_gprs_wireless_connection();
    if(res!=GSM_RES_OK) return res;

    res=is_local_ip_obtained();
    if(res!=GSM_RES_OK) return res;
  }

  /*
  Ждем получения только: OK или +CME ERROR <err>.
  Статусы ниже после OK не обрабатываются.
  <n>,ALREADY CONNECT
  <n>,CONNECT OK
  <n>,CONNECT FAIL
  Нужно ли их дожидаться? Или можно работать асинхронно?
  */

  return send_simple_at(cmd_buff, 5000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t tcp_socket_close(uint8_t ctx)
{//��������� ������ �������
#if defined(__A7670E__)
  int s_len;
  int16_t res;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  //bt_gprs_flow.tx_ctx=ctx;

  tcp_socket_state(ctx);

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPCLOSE=%u\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 10000);
  if(res!=GSM_RES_OK) return res;

  tcp_socket_state(ctx);

  //bt_gprs_flow.tx_ctx=0xff;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int s_len;
  int16_t res;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPCLOSE=%hhu,1\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.tx_ctx=ctx;
  res=extended_send_simple_at(cmd_buff, CLOSE_OK_FGSM, 5500);
  bt_gprs_flow.tx_ctx=0xff;
  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

static int16_t tcp_polling_mode(void)
{
  return send_simple_at("AT+CIPRXGET=1\r", 5000);
}

static int16_t tcp_multiconn_mode(void)
{
#if defined(__A7670E__)
  return GSM_RES_OK;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  return send_simple_at("AT+CIPMUX=1\r", 5000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

static int16_t tcp_data_transmit_mode(void)
{
#if defined(__A7670E__)
  return GSM_RES_OK;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
#if (!defined(USE_QUICK_SEND_MODE))
  return send_simple_at("AT+CIPQSEND=0\r", 5000);
#else
  return send_simple_at("AT+CIPQSEND=1\r", 5000);
#endif
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t config_modem_tcpip_stack()
{
  int16_t res;
  res=tcp_polling_mode();
  if(res!=GSM_RES_OK) return res;
  res=tcp_multiconn_mode();
  if(res!=GSM_RES_OK) return res;
  res=tcp_data_transmit_mode();

  return res;
}


/*
return values:
<0 standard GSM_ERR
INITIAL_CONN_STATE
CONNECTING_CONN_STATE
CONNECTED_CONN_STATE
REMOTE_CLOSING_CONN_STATE
CLOSING_CONN_STATE
CLOSED_CONN_STATE
*/
int16_t tcp_socket_state(uint8_t ctx)
{
#if defined(__A7670E__)
  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  modem_state.conn_state = 0;

  int16_t res=send_simple_at("AT+CIPCLOSE?\r", 10000);
  if(res!=GSM_RES_OK) return res;

  if(modem_state.conn_state & (1<<ctx)) {return CONNECTED_CONN_STATE;}
  else                                  {return INITIAL_CONN_STATE;}
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  uint32_t flags;
  int s_len;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPSTATUS=%hhu\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  ResetModemAtFlag(CIPSTATUS_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(CIPSTATUS_FGSM|ERROR_FGSM, 5000);
    if(flags&CIPSTATUS_FGSM)
    {
      WaitModemFlags(OK_FGSM, 1500);//ждем OK
      if(ctx_conn_state.ctx==ctx) return ctx_conn_state.state;
      else return GSM_NOTDONE_ERR;
    }
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

// Функция возвращает длину отправленных не подтвержденных данных либо ошибку
int16_t data_len_in_way(uint8_t ctx)
{//для совместимостисти с CINTERION
  (void) ctx;
  return 0;
}

// Ожидание подтверждения получения отправленных данных
int16_t wait_data_len_in_way_acked(uint8_t ctx, uint16_t time_wait)
{
  //для совместимостисти с CINTERION
  (void) ctx;
  (void) time_wait;
  return 0;
}

// В отличии от gprs_send ограничение на len 32767 байт
int16_t tcp_socket_write(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  return tcp_or_bt_write(0, ctx, data_out, len);
}

static int16_t tcp_or_bt_write(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  int16_t res;
  uint16_t chain_count;
  uint16_t chain_modulo;
  uint16_t max_len;

  if(is_bt) max_len=1024;
  else      max_len=1460;

  if(len>0xffff/2) return GSM_WRONG_IN_PARAM;

  chain_count=(len)/max_len;
  chain_modulo=(len)%max_len;

  for(uint16_t j=0; j<chain_count; j++)
  {
    res=tcp_or_bt_write_chunk(is_bt, ctx, data_out, max_len, 0);
    if(res!=max_len) return res;
    data_out+=max_len;
  }
  if(chain_modulo)
  {
    res=tcp_or_bt_write_chunk(is_bt, ctx, data_out, chain_modulo, 0);
    if(res!=chain_modulo) return res;
  }

  return (int16_t)len;
}


/*записывает в *data_out доступные данные, не более len байт;
return: считанное количество байт, меньше нуля ошибка;*/
int16_t tcp_socket_read(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  return tcp_or_bt_read(0, ctx, data_out, len);
}

// tcp_socket_read с ожиданием
int16_t tcp_socket_read_blocked(uint8_t ctx, uint8_t *data_out, uint16_t len, uint16_t time_wait)
{
  uint16_t tot_recv_len;
  uint32_t EndWaitTickCount;
  int16_t recv_len;

  if(len>0xffff/2) return GSM_WRONG_IN_PARAM;

  tot_recv_len=0;
  EndWaitTickCount = time_wait + xTaskGetTickCount();
  while(!timeAfter(xTaskGetTickCount(), EndWaitTickCount) && tot_recv_len<len)
  {
    vTaskDelay(50);
    recv_len = tcp_socket_read(ctx, &data_out[tot_recv_len], len-tot_recv_len);
    if(recv_len>=0) tot_recv_len+=recv_len;
    else
    {
      break;
    }
  }

  if(recv_len>=0) return tot_recv_len;
  else return (int16_t)recv_len;//вернуть ошибку полученную в tcp_socket_read
}


// Функции состояния/мониторинга
uint8_t get_rssi_level(void)
{
  return modem_state.rssi_level;
}

int16_t get_creg_state(creg_state_t* state, uint8_t force)
{
  int16_t res;

  if(force)
  {
    ResetModemAtFlag(CREG_FGSM);

#if defined(__A7670E__)
    res=send_simple_at("AT+CREG?\r", 6000);
#else //defined(__SIM800__) || defined(__SIM800_DS__)
    res=send_simple_at("AT+CREG?\r", 6000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)

    if(res==GSM_RES_OK)
    {
      if(ReadModemAtFlag(CREG_FGSM))
      {
#if defined(__A7670E__)
        if(modem_state.creg_state.regStatus == REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS ||
           modem_state.creg_state.regStatus == REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
        {
          send_simple_at("AT+COPS?\r", 6000); // ����� �������� AcT
        }

        cops_req_timer = xTaskGetTickCount() + COPS_REQ_MAX_PERIOD_MS;
#endif //defined(__A7670E__)

        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        memcpy(state, &modem_state.creg_state, sizeof(creg_state_t));
        xSemaphoreGive( modem_at_flags.lock_obj );
      }
      else
      {
        res=GSM_NOTDONE_ERR;
      }
    }
  }
  else
  {
#if defined(__A7670E__)
    if(timeAfter(xTaskGetTickCount(), cops_req_timer))
    {
      if(modem_state.creg_state.regStatus == REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS ||
         modem_state.creg_state.regStatus == REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
        send_simple_at("AT+COPS?\r", 6000); // ����� �������� AcT
      }

      cops_req_timer = xTaskGetTickCount() + COPS_REQ_MAX_PERIOD_MS;
    }
#endif //defined(__A7670E__)

    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(state, &modem_state.creg_state, sizeof(creg_state_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
    res=GSM_RES_OK;
  }

  if(res!=GSM_RES_OK)
  {
    state->AcT=0;
    state->netCellId=0;
    state->netLac=0;
    state->regStatus=UNKNOWN_CREG_STATUS;
  }

  return res;
}

#if defined(__SIM800_DS__)
int16_t get_ds_creg_state(creg_state_t* state_1, creg_state_t* state_2, uint8_t force)
{
  int16_t res;

  if(force)
  {
    ResetModemAtFlag(CREG_DS_FGSM);

    res=send_simple_at("AT+CREGDS?\r", 4000);
    if(res==GSM_RES_OK)
    {
      if(ReadModemAtFlag(CREG_DS_FGSM))
      {
        xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
        if(state_1!=NULL) memcpy(state_1, &modem_state.creg_state, sizeof(creg_state_t));
        if(state_2!=NULL) memcpy(state_2, &modem_state.ds_creg_state, sizeof(creg_state_t));
        xSemaphoreGive( modem_at_flags.lock_obj );
      }
      else
       {
        res=GSM_NOTDONE_ERR;
      }
    }
  }
  else
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    if(state_1!=NULL) memcpy(state_1, &modem_state.creg_state, sizeof(creg_state_t));
    if(state_2!=NULL) memcpy(state_2, &modem_state.ds_creg_state, sizeof(creg_state_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
    res=GSM_RES_OK;
  }

  if(res!=GSM_RES_OK)
  {
    if(state_1!=NULL)
    {
      state_1->AcT=0;
      state_1->netCellId=0;
      state_1->netLac=0;
      state_1->regStatus=UNKNOWN_CREG_STATUS;
    }
    if(state_2!=NULL)
    {
      state_2->AcT=0;
      state_2->netCellId=0;
      state_2->netLac=0;
      state_2->regStatus=UNKNOWN_CREG_STATUS;
    }
  }

  return res;
}

//sim: 1 or 2
int16_t select_default_sim(uint8_t default_sim)
{
  int s_len;

  if(default_sim==0 || default_sim>2) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CDSDS=%hhu\r", default_sim);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

int16_t get_sim_status(uint8_t* default_sim, uint8_t* first_sim, uint8_t* second_sim)
{
  int16_t res;

  *default_sim=0;
  *first_sim=0;
  *second_sim=0;

  res=get_aux_data("AT+CDSDS?\r", cmd_buff, sizeof(cmd_buff), 0);
  if(GSM_RES_OK!=res)
  {
    return res;
  }

  if(!(cmd_buff[0]=='S' && cmd_buff[1]=='I' && cmd_buff[2]=='M' && (cmd_buff[3]=='1' || cmd_buff[3]=='2') && cmd_buff[4]==',' && \
      (cmd_buff[5]=='0' || cmd_buff[5]=='1') &&  cmd_buff[6]==',' && \
      (cmd_buff[7]=='0' || cmd_buff[7]=='1')))
  {
    return GSM_NOTDONE_ERR;
  }

  *default_sim=cmd_buff[3]-0x30;
  *first_sim=cmd_buff[5]-0x30;
  *second_sim=cmd_buff[7]-0x30;

  return GSM_RES_OK;
}
#endif //__SIM800_DS__

int16_t creg_urc_extended_mode(void)
{
#if defined(__A7670E__)
  return send_simple_at("AT+CREG=2\r", 2000);//Activate extended URC mode
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  return send_simple_at("AT+CREG=2\r", 2000);//Activate extended URC mode
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t operator_present_config(void)
{
  int16_t res;

  res=send_simple_at("AT+COPS=0,2\r", 180000);

  if(res==GSM_RES_OK)
  {
    send_simple_at("AT+COPS=3,2\r", 1000);//Для UC200T. Формат в первой команде не применяется
  }

  return res;
}

//for debug
int16_t get_operator_list(void)
{
  return send_simple_at("AT+COPS=?\r", 180000);
}

//op_code: e.g. "25001", "25002", "25099"
int16_t manual_operator_select(const char* op_code)
{
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+COPS=1,2,\"%s\"\r", op_code);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 180000);
}

int16_t get_operator_inf(operator_inf_t* operator_inf)
{
  int16_t res;
  res=send_simple_at("AT+COPS?\r", 4000);

  if(res==GSM_RES_OK)
  {
    xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
    memcpy(operator_inf, &modem_state.operator_inf, sizeof(operator_inf_t));
    xSemaphoreGive( modem_at_flags.lock_obj );
  }
  else
  {
    memset(operator_inf, 0, sizeof(operator_inf_t));
  }
  return res;
}

//эта команда должна быть оправлена до регистрации в сети
//либо после команды нужно послать AT+CFUN=0,0...AT+CFUN=1,0
//либо сохранить настройку командой AT&W (отработает при следующем включении модема), но могут возникнуть проблемы со скоростью порта по умолчанию.
int16_t set_network_sync_time(void)
{
#if defined(__A7670E__)
  int16_t res;

  res = send_simple_at("AT+CTZU=1\r", 9000);
  if(res!=GSM_RES_OK) return res;

  res = send_simple_at("AT+CTZR=1\r", 9000);
  if(res!=GSM_RES_OK) return res;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  return send_simple_at("AT+CLTS=1\r", 2000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

uint8_t is_modem_time_synchronized(void)
{
  if(modem_time.last_sync_utime==0) return 0;
  else return 1;
}

int16_t get_network_time(uint32_t* unix_time)
{
#if defined(__A7670E__)
  int16_t res;

  modem_time.cclk_result = 0;
  modem_time.last_sync_utime = 1;

  res = send_simple_at("AT+CCLK?\r", 9000);
  if(GSM_RES_OK!=res) return res;

  if(modem_time.cclk_result == 1 && modem_time.network_utime<1621074917)
  {
    return GSM_NOTDONE_ERR;
  }

  *unix_time=modem_time.network_utime;

  return GSM_RES_OK;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;

  if(!is_modem_time_synchronized()) return GSM_NOTDONE_ERR;

  modem_time.cclk_result = 0;

  res = send_simple_at("AT+CCLK?\r", 2000);
  if(GSM_RES_OK!=res) return res;

  if(modem_time.cclk_result == 1)
  {
    *unix_time=modem_time.network_utime;
    return GSM_RES_OK;
  }
  else
  {
    *unix_time=0;
    return GSM_NOTDONE_ERR;
  }
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t get_modem_imie(char mem[16], uint16_t mem_size)
{
  int16_t res;

  if(mem_size<16) res=GSM_NOTDONE_ERR;

  fwd_modem_rx_enabele(modem_parse.buff, sizeof(modem_parse.buff));
  send_simple_at("AT+CGSN\r", 0);

  if(25!=wait_fwd_modem_rx_len(25, 1000))
  {
    mem[0]=NULL;
    res=GSM_NOTDONE_ERR;
  }
  else
  {
    if(__STRNCMP((char const*)modem_parse.buff, "\r\n")==0 && __STRNCMP((char const*)modem_parse.buff+17, "\r\n\r\nOK\r\n")==0)
    {
      *(modem_parse.buff+17)=NULL;
      memcpy(mem, modem_parse.buff+2, 16);
      res=GSM_RES_OK;
    }
    else
    {
      mem[0]=NULL;
      res=GSM_NOTDONE_ERR;
    }
  }
  vTaskDelay(200);
  fwd_modem_rx_disable();
  return res;
}

int16_t get_modem_inf(char mem[14], uint16_t mem_size)
{
  int16_t res;

  if(mem_size<14) res=GSM_NOTDONE_ERR;

  fwd_modem_rx_enabele(modem_parse.buff, sizeof(modem_parse.buff));
  send_simple_at("ATI\r", 0);

  if(23!=wait_fwd_modem_rx_len(23, 1000))
  {
    mem[0]=NULL;
    res=GSM_NOTDONE_ERR;
  }
  else
  {
    if(__STRNCMP((char const*)modem_parse.buff, "\r\n")==0 && __STRNCMP((char const*)modem_parse.buff+15, "\r\n\r\nOK\r\n")==0)
    {
      *(modem_parse.buff+15)=NULL;
      memcpy(mem, modem_parse.buff+2, 14);
      res=GSM_RES_OK;
    }
    else
    {
      mem[0]=NULL;
      res=GSM_NOTDONE_ERR;
    }
  }
  vTaskDelay(200);
  fwd_modem_rx_disable();
  return res;
}

int16_t get_software_inf(char* mem, uint16_t mem_size)
{
#if defined(__A7670E__)
  int16_t res;

  res = get_aux_data("AT+CGMR\r", mem, mem_size, 0);
  if(res != GSM_RES_OK) return res;

  uint16_t len = strnlen(mem, mem_size);

  if(len + 3 >= mem_size)
  {
    return GSM_MEM_ERR;
  }

  mem[len] = ' ';
  len++;

  mem += len;
  mem_size -= len;

  res = get_aux_data("AT+CSUB\r", mem, mem_size, 0);
  if(res != GSM_RES_OK) return res;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  return get_aux_data("AT+CGMR\r", mem, mem_size, 0);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t get_cells_inf(char* mem, uint16_t mem_size)
{
  int16_t res;

  if(!mem_size) res=GSM_NOTDONE_ERR;

  res=send_simple_at("AT+CENG=3\r", 2000);

  if(GSM_RES_OK!=res)
  {
    *mem='\0';
    return res;
  }

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=mem;
  aux_data.dst_mem_size=mem_size;
  aux_data.is_append_with_lf=1;
  xSemaphoreGive( modem_at_flags.lock_obj );

  *mem='\0';

  static const char* const ceng_req_list[] =
  {
    "AT+CENG?\r"
  };

  for(uint8_t i=0; i<sizeof(ceng_req_list)/sizeof(const char* const); i++)
  {
    res=send_simple_at((char*)ceng_req_list[i], 4000);
    if(GSM_RES_OK!=res) break;
  }

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  return res;
}

//модем возвращает iccid длиной 20 (c дополнением f, если длина меньше 20)
int16_t get_iccid(char mem[21], uint16_t mem_size)
{
#if defined(__A7670E__)
  int16_t res;

  res = get_aux_data("AT+CICCID\r", mem, mem_size, 0);
  if(res != GSM_RES_OK) return res;

  for(uint16_t i = 0; i < mem_size; i++)
  {
    if(mem[i] == 'F' || mem[i] == 'f') {mem[i] = '\0'; break;}
    if(mem[i] == '\0')                 {break;}
  }

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;

  if(mem_size<21) res=GSM_NOTDONE_ERR;

  fwd_modem_rx_enabele(modem_parse.buff, sizeof(modem_parse.buff));
  send_simple_at("AT+CCID\r", 0);

  if(30!=wait_fwd_modem_rx_len(30, 2000))
  {
    mem[0]=NULL;
    res=GSM_NOTDONE_ERR;
  }
  else
  {
    if(__STRNCMP((char const*)modem_parse.buff, "\r\n")==0 && __STRNCMP((char const*)modem_parse.buff+22, "\r\n\r\nOK\r\n")==0)
    {
      *(modem_parse.buff+22)=NULL;
      memcpy(mem, modem_parse.buff+2, 21);
      for(uint8_t i=0; i<21; i++)
      {
        if(mem[i]=='f') mem[i]='\0';
      }
      res=GSM_RES_OK;
    }
    else
    {
      mem[0]=NULL;
      res=GSM_NOTDONE_ERR;
    }
  }
  vTaskDelay(200);
  fwd_modem_rx_disable();
  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

uint8_t get_sim_failure_status(void)
{
#if defined(__A7670E__)
  if(ReadModemAtFlag(CPIN_NOT_INSERTED_FGSM)) return 1;
#endif //defined(__A7670E__)

  return modem_state.is_sim_failure;
}

// Функции для перенаправления потоков
void fwd_modem_rx_enabele(uint8_t* dst, uint16_t len)
{
  if(modem_fwd.state!=FORWARDING_DISABLED)//не должны сюда попадать со велюченвм перенаправлением
  {
    fwd_modem_rx_disable();
  }

  memset(dst, 0, len);
  modem_fwd.rx_start=dst;
  modem_fwd.rx_ptr=modem_fwd.rx_start;
  modem_fwd.rx_end=dst+len-1;
  modem_fwd.state=FORWARDING_ENABLE;
}

void fwd_modem_rx_disable(void)
{
    modem_fwd.state=FORWARDING_DISABLE_CMD;//говорим что не нужно больше перенаправлять
    while(modem_fwd.state!=FORWARDING_DISABLE_ACK) vTaskDelay(10);
    modem_fwd.state=FORWARDING_DISABLED;
}

uint16_t get_fwd_recv_len(void)
{
  return modem_fwd.rx_ptr-modem_fwd.rx_start;
}

uint16_t wait_fwd_modem_rx_len(uint16_t len_wait, uint32_t time_wait)
{
  uint32_t end_timeMS_wait;

  if(modem_fwd.state!=FORWARDING_ENABLE) return 0;

  end_timeMS_wait=time_wait+xTaskGetTickCount();

  for(;;)
  {
    uint16_t fwd_recv_len=get_fwd_recv_len();
    if(fwd_recv_len>=len_wait) return len_wait;
    else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait)) return fwd_recv_len;
    vTaskDelay(10);
  }
}

int16_t soft_switch_off_modem(void)
{
  int16_t at_res;

  for(uint8_t att=0; att<3; att++)
  {
#if defined(__A7670E__)
    at_res=send_simple_at("AT+CPOF\r", 9000);//Power down the module
#else //defined(__SIM800__) || defined(__SIM800_DS__)
    at_res=extended_send_simple_at("AT+CPOWD=1\r", NORMAL_POWER_DOWN_FGSM, 5000);//Switch Off
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
    if(GSM_RES_OK==at_res) break;
    if(att!=3-1) vTaskDelay(200*(att+1));
  }

#if defined(__A7670E__)
  //���������� ����� �������������� �� pin STATUS
  vTaskDelay(200);
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  vTaskDelay(2000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)

  return at_res;
}

// Bluetooth API
int16_t GetBtPowerStatus(uint8_t* const status)
{
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  bt_gprs_flow.bt_status=0;
  res=send_simple_at("AT+BTSTATUS?\r", 2000);
  if(res!=GSM_RES_OK) return res;

  status[0]=bt_gprs_flow.bt_status;

  return GSM_RES_OK;
}

int16_t BtPower(uint8_t is_on)
{
  int16_t res;
  uint32_t end_timeMS_wait;
  uint8_t status;

  res=GetBtPowerStatus(&status);
  if(res!=GSM_RES_OK) return res;

  if((is_on && status) || (!is_on && !status))
  {
    //���
    return GSM_RES_OK;
  }

  if(is_on)
  {
    res=send_simple_at("AT+BTPOWER=1\r", 20000);//Power up BT
    if(res!=GSM_RES_OK) return res;

    end_timeMS_wait=15000+xTaskGetTickCount();
    for(;;)
    {
      res=GetBtPowerStatus(&status);
      if(res!=GSM_RES_OK) return res;

      if(status!=0) break;
      else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait))
      {
        send_simple_at("AT+BTPOWER=0\r", 2000);
        return GSM_TIMEOUT_ERR;
      }
      vTaskDelay(200);
    }

    res=send_simple_at("AT+BTSPPURC=1\r", 2000);//Special URC of BT data mode
    if(res!=GSM_RES_OK) return res;
    res=send_simple_at("AT+BTSPPCFG=\"MC\",1\r", 2000);//Enable multi-connection (для совместимости с командами gprs)
    if(res!=GSM_RES_OK) return res;
    res=send_simple_at("AT+BTSPPGET=1\r", 2000);//Set getting data in manual mode
    if(res!=GSM_RES_OK) return res;
  }
  else
  {
    res=send_simple_at("AT+BTPOWER=0\r", 2000);//Power down BT
    if(res!=GSM_RES_OK) return res;

    end_timeMS_wait=15000+xTaskGetTickCount();
    for(;;)
    {
      res=GetBtPowerStatus(&status);
      if(res!=GSM_RES_OK) return res;

      if(status==0) return GSM_RES_OK;
      else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait)) return GSM_TIMEOUT_ERR;
      vTaskDelay(200);
    }
  }

  return GSM_RES_OK;
}

//отключить режим at команд для bluetooth
int16_t BtDisableSppAtMode(void)
{
  return send_simple_at("AT+BTSPPCFD=\"\"\r", 2000);
}

/*
mode: 0 - invisible, 1 - visible forever
time: unused
*/
int16_t BtVisibleMode(const uint8_t mode, const uint8_t time)
{
  (void)time;

  int s_len;

  if(mode>1) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTVIS=%u\r", mode);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 1000);
}

int16_t BtSetDevName(const char* name)
{
  int s_len;

  if(strlen(name)==0) return GSM_WRONG_IN_PARAM; //18 символов в utf-8

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTHOST=%.18s\r", name);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);;
}

int16_t SetPairingPinCode(const char* pin)
{
  int s_len;

  if(strnlen(pin, 5)!=4) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTPAIRCFG=1,%s\r", pin);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

int16_t BtSppAcceptHandle(void)
{
  int16_t res;
  uint8_t ctx;

  ctx=bt_gprs_flow.bt_spp_ctx;
  if(timeAfter(xTaskGetTickCount(), bt_gprs_flow.req_spp_timer))
  {
    bt_gprs_flow.is_spp_conn_available=0;
    res=send_simple_at("AT+BTSTATUS?\r", 2000);
    bt_gprs_flow.req_spp_timer=2000-1+xTaskGetTickCount();
    if(res!=GSM_RES_OK) return res;
    if(!bt_gprs_flow.is_spp_conn_available) bt_gprs_flow.bt_spp_ctx=0xff;//если при запросе BTSTATUS, нет активных spp
  }
  if(ctx!=bt_gprs_flow.bt_spp_ctx)
  {//spp id изменился
    //none
  }

  if(bt_gprs_flow.bt_spp_ctx==0xff)
  { //���� ��� ��������� spp ����������
    if(ReadModemAtFlag(BT_SPP_CONNECTING_FGSM))
    {
      ResetModemAtFlag(BT_SPP_CONNECTING_FGSM);
      return send_simple_at("AT+BTACPT=1\r", 2000);//accept
    }
    return GSM_RES_OK;
  }

  return GSM_RES_OK;
}

int16_t BtHfgAcceptHandle(void)
{
  if(ReadModemAtFlag(BT_HFG_CONNECTING_FGSM))
  {
    ResetModemAtFlag(BT_HFG_CONNECTING_FGSM);
    return send_simple_at("AT+BTACPT=1\r", 2000);//accept
  }

  return GSM_RES_OK;
}

int16_t Bt3Scan(uint8_t is_start, uint8_t timeout)
{
  int s_len;

  if(is_start)
  {
    if(timeout == 0) {timeout = 20;}

    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTSCAN=1,%u\r", timeout);
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTSCAN=0\r");
  }

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

//dev_id: 0 - Delete all the paired device
int16_t Bt3Unpair(uint8_t dev_id)
{
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTUNPAIR=%u\r", dev_id);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

int16_t Bt3Pair(uint8_t dev_id)
{
  int s_len;

  if(dev_id == 0) {return GSM_WRONG_IN_PARAM;}

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTPAIR=0,%u\r", dev_id);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

int16_t Bt3PairAns(const uint8_t passkey[4])
{
  int s_len;

  if(passkey[0] < '0' || passkey[0] > '9' ||
     passkey[1] < '0' || passkey[1] > '9' ||
     passkey[2] < '0' || passkey[2] > '9' ||
     passkey[3] < '0' || passkey[3] > '9' )
  {
    return GSM_WRONG_IN_PARAM;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTPAIR=2,%.*s\r", 4, passkey);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 2000);
}

#if defined(USE_BT_HFG)
//cmd: 1 - �������, 2 - ���������, 3 - ��������� ���
//state: 0 - unknown, 1 - paired, 2 - not paired, 3 - error, 4 - in progress
int16_t BtHfgPairHandler(uint8_t cmd, const char mac[6], const char pin[4], uint8_t* state)
{
  static const uint8_t SCAN_TIMEOUT_S = 20;

  int16_t res;

  if(cmd && hfg_pair_ctx.pair_ctx_state != 0)
  {
    //������
    return GSM_NOTDONE_ERR;
  }

  if(cmd == 1 || cmd == 2)
  {
    state[0] = 0; //unknown

    for(uint8_t i = 0; i<6; i++ )
    {
      hfg_pair_ctx.mac[i] = mac[i];
    }

    for(uint8_t i = 0; i<4; i++ )
    {
      hfg_pair_ctx.pin[i] = pin[i];
    }

    if(cmd == 1)
    {
      hfg_pair_ctx.pair_ctx_state = 1;
    }
    else
    {
      hfg_pair_ctx.pair_ctx_state = 6;
    }
  }
  else if(cmd == 3)
  {
    state[0] = 0; //unknown

    hfg_pair_ctx.pair_ctx_state = 255;
  }

  if(hfg_pair_ctx.pair_ctx_state != 0)
  {
    state[0] = 4; //in progress
  }

  if(hfg_pair_ctx.pair_ctx_state == 0)
  {
    return GSM_RES_OK;
  }

  else if(hfg_pair_ctx.pair_ctx_state == 255)
  {
    //��������� ��� ����������
    res = Bt3Unpair(0);
    if(res!=GSM_RES_OK) {goto ret_w_err;}

    hfg_pair_ctx.device_id = 0;
    hfg_pair_ctx.pair_ctx_state = 0;
    hfg_pair_ctx.pair_mac_cmp_state = 0;

    state[0] = 2; //not paired
    return GSM_RES_OK;
  }

  else if(hfg_pair_ctx.pair_ctx_state == 1 ||
          hfg_pair_ctx.pair_ctx_state == 6)
  {
    hfg_pair_ctx.device_id = 0;

    //���� mac � ������ ��������� ���������
    hfg_pair_ctx.pair_mac_cmp_state = 1;
    res=send_simple_at("AT+BTSTATUS?\r", 2000);
    hfg_pair_ctx.pair_mac_cmp_state = 0;
    if(res!=GSM_RES_OK) {goto ret_w_err;}

    if(hfg_pair_ctx.device_id)
    {
      //���������� ��� ��������
      hfg_pair_ctx.device_id = 0;
      hfg_pair_ctx.pair_ctx_state = 0;
      hfg_pair_ctx.pair_mac_cmp_state = 0;

      state[0] = 1; //paired
      return GSM_RES_OK;
    }

    if(hfg_pair_ctx.pair_ctx_state == 1)
    {
      //����������� ��� ����������, ��������� �� ���������, �.�. ���� ��� ���������, ������ ������
      res = Bt3Unpair(0);
      //if(res!=GSM_RES_OK) {goto ret_w_err;}

      hfg_pair_ctx.pair_ctx_state = 2;
      return GSM_RES_OK;
    }
    else //if(hfg_pair_ctx.pair_ctx_state == 6)
    {
      // ���������� �� ��������
      hfg_pair_ctx.device_id = 0;
      hfg_pair_ctx.pair_ctx_state = 0;
      hfg_pair_ctx.pair_mac_cmp_state = 0;

      state[0] = 2; //not paired
      return GSM_RES_OK;
    }
  }

  else if(hfg_pair_ctx.pair_ctx_state == 2)
  {
    //��������� ������������ �� SCAN_TIMEOUT_S ������
    hfg_pair_ctx.pair_mac_cmp_state = 2;
    res = Bt3Scan(1, SCAN_TIMEOUT_S);
    if(res!=GSM_RES_OK) {goto ret_w_err;}

    hfg_pair_ctx.timer = xTaskGetTickCount() + SCAN_TIMEOUT_S*1000 + 2000;
    hfg_pair_ctx.pair_ctx_state = 3;
    return GSM_RES_OK;
  }

  else if(hfg_pair_ctx.pair_ctx_state == 3)
  {
    //������� ��������� ������������
    if(hfg_pair_ctx.device_id)
    {
      hfg_pair_ctx.pair_mac_cmp_state = 3;
      res = Bt3Pair(hfg_pair_ctx.device_id);
      if(res!=GSM_RES_OK) {goto ret_w_err;}

      hfg_pair_ctx.timer = xTaskGetTickCount() + 10000;
      hfg_pair_ctx.pair_ctx_state = 4;
    }
    else if(timeAfter(xTaskGetTickCount(), hfg_pair_ctx.timer))
    {
      res = GSM_TIMEOUT_ERR;
      goto ret_w_err;
    }

    return GSM_RES_OK;
  }

  else if(hfg_pair_ctx.pair_ctx_state == 4)
  {
    //���� ������� �� ���� �������
    if(hfg_pair_ctx.pair_mac_cmp_state == 4)
    {
      hfg_pair_ctx.pair_mac_cmp_state = 5;
      res = Bt3PairAns(hfg_pair_ctx.pin);
      if(res!=GSM_RES_OK) {goto ret_w_err;}

      hfg_pair_ctx.timer = xTaskGetTickCount() + 5000;
      hfg_pair_ctx.pair_ctx_state = 5;
      return GSM_RES_OK;
    }
    else if(timeAfter(xTaskGetTickCount(), hfg_pair_ctx.timer))
    {
      res = GSM_TIMEOUT_ERR;
      goto ret_w_err;
    }

    return GSM_RES_OK;
  }

  else if(hfg_pair_ctx.pair_ctx_state == 5)
  {
    if(hfg_pair_ctx.pair_mac_cmp_state == 6)
    {
      hfg_pair_ctx.device_id = 0;
      hfg_pair_ctx.pair_ctx_state = 0;
      hfg_pair_ctx.pair_mac_cmp_state = 0;

      state[0] = 1; //paired
      return GSM_RES_OK;
    }
    else if(timeAfter(xTaskGetTickCount(), hfg_pair_ctx.timer))
    {
      // ���������� �� ���������...
      res = GSM_TIMEOUT_ERR;
      goto ret_w_err;
    }

    return GSM_RES_OK;
  }

  else
  {
    res = GSM_NOTDONE_ERR;
    goto ret_w_err;
  }

ret_w_err:
  hfg_pair_ctx.device_id = 0;
  hfg_pair_ctx.pair_ctx_state = 0;
  hfg_pair_ctx.pair_mac_cmp_state = 0;

  state[0] = 3; //error

  return res;
}
#endif//defined(USE_BT_HFG)

uint8_t BtIsSppConnectExist(void)
{
  if(bt_gprs_flow.bt_spp_ctx==0xff) return 0;
  else return 1;
}

int16_t BtSppDisconnect(void)
{
  uint8_t ctx;
  int16_t res;
  uint32_t end_timeMS_wait;

  if(!BtIsSppConnectExist()) return GSM_RES_OK;

  ctx=bt_gprs_flow.bt_spp_ctx;

  if(!((ctx>=BT_CONN_CTX_FIRST_ID && ctx<=BT_CONN_CTX_LAST_ID) || ctx==0xff)) return GSM_NOTDONE_ERR;

  if(ctx!=0xff)
  {
    snprintf(cmd_buff, sizeof(cmd_buff), "AT+BTDISCONN=%hhu\r", ctx);
  }

  res=send_simple_at(cmd_buff, 2000);
  if(res!=GSM_RES_OK) return res;

  end_timeMS_wait=3000+xTaskGetTickCount();

  for(;;)
  {
    ctx=bt_gprs_flow.bt_spp_ctx;
    if(ctx==0xff) break;
    else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait)) break;
    vTaskDelay(50);
  }

  if(ctx!=0xff) return GSM_NOTDONE_ERR;
  else return GSM_RES_OK;
}

/*записывает в *data_out доступные данные, не более len байт;
return: считанное количество байт, меньше нуля ошибка;*/
/*todo:
Периодически возникает проблема при работе с буфером 1024 байт, например при запросе куска файла прошивки, в ответ ожидается 1020 байт, но приходит 988, а при повторном запросе приходит не остаток 32 байта, а начало и перыдущего сообщения.
AT+BTSPPGET=3,1,1024
+BTSPPGET: 1,988,хFIRMWAREеюglKfЯп7 Оќ6Ў-·>еЖЩ9g...
OK
AT+BTSPPGET=3,1,36
+CIPRXGET: 2,3,0,0
OK
+BTSPPGET: 1,32,хFIRMWAREеюglKfЯп7 
OK
при работе с буфером 256 байт, такой проблемы не возникает или возникает очень редко.
*/
int16_t BtSppRead(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  ctx=bt_gprs_flow.bt_spp_ctx;
  if(ctx==0xff)
  {
    //нет активного соединения
    return GSM_NOTDONE_ERR;
  }
  return tcp_or_bt_read(1, ctx, data_out, len);
}

int16_t BtSppWrite(uint8_t ctx, uint8_t *data_out, uint16_t len)
{
  ctx=bt_gprs_flow.bt_spp_ctx;
  if(ctx==0xff)
  {
    //нет активного соединения
    return GSM_NOTDONE_ERR;
  }
  return tcp_or_bt_write(1, ctx, data_out, len);
}

//not tested
uint8_t BtSppRecvDataSignal(void)
{
  uint8_t recv_event=0;

  xSemaphoreTake(modem_at_flags.lock_obj, portMAX_DELAY);
  if(modem_at_flags.flags&BT_BTSPPMAN_FGSM)
  {
    recv_event=1;
    modem_at_flags.flags&=~BT_BTSPPMAN_FGSM;
  }
  xSemaphoreGive(modem_at_flags.lock_obj);
  return recv_event;
}

//>---------------------------------->
#if (defined(__SIM800__) || defined(__SIM800_DS__))
/*
<op>: 0 - Stop, 1 - Start
*/
int16_t BtStartStopScanningLE(const uint8_t op, const uint16_t gclient_id)
{
  (void)gclient_id;
#if BLE_SCAN_TABLE_SIZE > 0
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(op>1) return GSM_WRONG_IN_PARAM;

  if(ble_scan_gat_id == 0) return GSM_NOTDONE_ERR;

  if(op)
  {
    memset(ble_scan_table, 0, sizeof(ble_scan_table));
    ble_scan_table_idx=0;
    //ble_scan_gat_id=gclient_id;
  }
  else
  {
    //ble_scan_gat_id=0;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BLESCAN=%u,%u\r", ble_scan_gat_id, op);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
#else
  return GSM_NOTDONE_ERR;
#endif //BLE_SCAN_TABLE_SIZE > 0
}

/*
ret: scanned count
*/
uint8_t GetScanTableLE(const bt_gat_scan_t* table[])
{
#if BLE_SCAN_TABLE_SIZE > 0
  if(table!=NULL)
  {
    table[0]=&ble_scan_table[0];
  }

  return ble_scan_table_idx;
#else
  return 0;
#endif //BLE_SCAN_TABLE_SIZE > 0
}

/*
<op>: 0 - Deregister, 1 - Register
*/
int16_t BtRegDeregGattClientLE(const uint8_t op, const uint16_t gclient_id)
{
  (void)gclient_id;
  int s_len;
  int16_t res;

  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;

  if(op>1) return GSM_WRONG_IN_PARAM;

  if(op == 0 && ble_scan_gat_id == 0xFFFF)
  {
    //yet
    return GSM_RES_OK;
  }

  if(op == 1 && ble_scan_gat_id != 0xFFFF)
  {
    //yet
    return GSM_RES_OK;
  }

  if(op)
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BLECREG\r");
  }
  else
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+BLECDREG=%u\r", ble_scan_gat_id);
  }

  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 5000);
  if(res!=GSM_RES_OK) return res;

  return res;
}

/*
<tx_level>: 0 - 7
This command takes effect after BT function is restarted.
responce +QBTGATRFPWR
*/
int16_t SetBtLeTxPwr(const uint8_t tx_level)
{
  //todo
  return GSM_RES_OK;

//  int s_len;
//  int16_t res;
//
//  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;
//
//  if(tx_level>7) return GSM_WRONG_IN_PARAM;
//
//  res=send_simple_at("AT+QBTLETXPWR?\r", 1000);
//  if(res!=GSM_RES_OK) return res;
//
//  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QBTLETXPWR=%u\r", tx_level);
//  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;
//
//  res=send_simple_at(cmd_buff, 5000);
//  if(res!=GSM_RES_OK) return res;
//
//  return res;
}

/*
scan_interval, scan_window in ms
*/
int16_t BtSetScanIntervalandScanWindow(uint16_t scan_interval, uint16_t scan_window, uint8_t is_ms)
{
  return GSM_RES_OK;

//  int s_len;
//  int16_t res;
//
//  if(!is_bluetooth_present()) return GSM_NOTDONE_ERR;
//
//  if(scan_window>scan_interval) return GSM_WRONG_IN_PARAM;
//
//  if(is_ms) scan_interval=(scan_interval*16)/10;
//  if(scan_interval<4 || scan_interval>16384) return GSM_WRONG_IN_PARAM;
//
//  if(is_ms) scan_window=(scan_window*16)/10;
//  if(scan_window<4 || scan_window>16384) return GSM_WRONG_IN_PARAM;
//
//  res=send_simple_at("AT+QGATCFGSCAN?\r", 1000);
//  if(res!=GSM_RES_OK) return res;
//
//  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+QGATCFGSCAN=%u,%u\r", scan_interval, scan_window);
//  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;
//
//  res=send_simple_at(cmd_buff, 1000);
//  if(res!=GSM_RES_OK) return res;
//
//  /*res=*/send_simple_at("AT+QGATCFGSCAN?\r", 1000);
//  //if(res!=GSM_RES_OK) return res;
//
//  return res;
}
#endif //(defined(__SIM800__) || defined(__SIM800_DS__))
//<----------------------------------<

/*���������� � *data_out ��������� ������, �� ����� len ����;
return: ��������� ���������� ����, ������ ���� ������;*/
static int16_t tcp_or_bt_read(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len)
{
#if defined(__A7670E__)
  int s_len;
  int16_t res;
  uint32_t flags;

  if(is_bt)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(ctx>MAX_CONN_CTX_ID || len>1460)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(CONNECTED_CONN_STATE != tcp_socket_state(ctx))
  {
    return GSM_NOTDONE_ERR;
  }

  if(len==0)
  {
   return 0;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPRXGET=2,%u,%u\r", ctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data_out;
  bt_gprs_flow.rx_ctx=ctx;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 8000);//������� �������� CIPRXGET_BTSPPGET_ENDDATA_FGSM, ����� OK_FGSM, ������� ���� OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM))         res=bt_gprs_flow.rx_write_ptr-data_out;//actual recv len //������ ���� ������������ end_data_flag � OK_FGSM
    else if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM)) res=0;//+IP ERROR: No data
    else if(flags&ERROR_FGSM)                                  res=GSM_NOTDONE_ERR;
    else                                                       res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xff;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  static const char* const bt_cmd_header  = "AT+BTSPPGET=3";
  static const char* const tcp_cmd_header = "AT+CIPRXGET=2";

  int s_len;
  int16_t res;
  uint32_t flags;

  if(!is_bt)
  {
    if(ctx>MAX_CONN_CTX_ID || len>1460) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(!(ctx>=BT_CONN_CTX_FIRST_ID && ctx<=BT_CONN_CTX_LAST_ID) || len>1024) return GSM_WRONG_IN_PARAM;
  }
  if(len==0) return 0;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "%s,%hhu,%hu\r", is_bt ? bt_cmd_header : tcp_cmd_header, ctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data_out;
  bt_gprs_flow.rx_ctx=ctx;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 8000);//������� �������� CIPRXGET_BTSPPGET_ENDDATA_FGSM, ����� OK_FGSM, ������� ���� OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data_out;//actual recv len //������ ���� ������������ end_data_flag � OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xff;
  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

static int16_t tcp_or_bt_write_chunk(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len, uint8_t eod_flag)
{
#if defined(__A7670E__)
  (void) eod_flag;
  int s_len;
  int16_t res;
  uint32_t flags;

  if(is_bt)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(ctx>MAX_CONN_CTX_ID || len>1460)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(len==0)
  {
    return 0;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPSEND=%u,%u\r", ctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.tx_ctx=ctx;
  ResetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM, 3000);
    if(flags&READY_FOR_DATA_ENTRY_FGSM) {}
    else if(flags&ERROR_FGSM) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
    else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
  }
  else
  {
   bt_gprs_flow.tx_ctx=0xff;
   return GSM_TIMEOUT_ERR;//???
  }

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart(data_out, len, GSM_TX_DEF_TIMEOUT*2);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 4000);
    if(flags&OK_FGSM) {bt_gprs_flow.tx_ctx=0xff; return len;}
    else if(flags&ERROR_FGSM) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
    else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
  }
  else
  {
    bt_gprs_flow.tx_ctx=0xff;
    return GSM_TIMEOUT_ERR;//???
  }
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  static const char* const bt_cmd_header  = "AT+BTSPPSEND=";
  static const char* const tcp_cmd_header = "AT+CIPSEND=";

  (void) eod_flag;
  int s_len;
  int16_t res;
  uint32_t flags;

  if(!is_bt)
  {
    if(ctx>MAX_CONN_CTX_ID || len>1460) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(!(ctx>=BT_CONN_CTX_FIRST_ID && ctx<=BT_CONN_CTX_LAST_ID) || len>1024) return GSM_WRONG_IN_PARAM;
  }

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "%s%hhu,%hu\r", is_bt ? bt_cmd_header : tcp_cmd_header, ctx, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.tx_ctx=ctx;
  ResetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM, 3000);
    if(flags&READY_FOR_DATA_ENTRY_FGSM) {}
    else if(flags&ERROR_FGSM) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
    else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
  }
  else
  {
   bt_gprs_flow.tx_ctx=0xff;
   return GSM_TIMEOUT_ERR;//???
  }

  if(!is_bt)
  {
#if (!defined(USE_QUICK_SEND_MODE))
    ResetModemAtFlag(CIPSEND_SEND_OK_FGSM|CIPSEND_SEND_FAIL_FGSM|ERROR_FGSM);
#else
    bt_gprs_flow.accepted_len=0;
    ResetModemAtFlag(CIPSEND_DATA_ACCEPT_FGSM|ERROR_FGSM);
#endif
    res=WriteToModemUart(data_out, len, GSM_TX_DEF_TIMEOUT*2);
    if(res==MODEM_UART_TX_OK)
    {
#if (!defined(USE_QUICK_SEND_MODE))
      flags=WaitModemFlags(CIPSEND_SEND_OK_FGSM|CIPSEND_SEND_FAIL_FGSM|ERROR_FGSM, 4000);
      if(flags&CIPSEND_SEND_OK_FGSM) {bt_gprs_flow.tx_ctx=0xff; return len;}
      else if(flags&CIPSEND_SEND_FAIL_FGSM || flags&ERROR_FGSM ) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
#else
      flags=WaitModemFlags(CIPSEND_DATA_ACCEPT_FGSM|ERROR_FGSM, 4000);
      if(flags&CIPSEND_DATA_ACCEPT_FGSM)
      {
        if(bt_gprs_flow.accepted_len==len) {bt_gprs_flow.tx_ctx=0xff; return len;}
        else {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      }
      else if(flags&ERROR_FGSM ) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
#endif
    }
    else
    {
      bt_gprs_flow.tx_ctx=0xff;
      return GSM_TIMEOUT_ERR;//???
    }
  }
  else
  {
    ResetModemAtFlag(BT_SEND_OK_FGSM|BT_SEND_FAIL_FGSM|ERROR_FGSM);
    res=WriteToModemUart(data_out, len, GSM_TX_DEF_TIMEOUT*2);
    if(res==MODEM_UART_TX_OK)
    {
      flags=WaitModemFlags(BT_SEND_OK_FGSM|BT_SEND_FAIL_FGSM|ERROR_FGSM, 4000);
      if(flags&BT_SEND_OK_FGSM) {bt_gprs_flow.tx_ctx=0xff; return len;}
      else if(flags&BT_SEND_FAIL_FGSM || flags&ERROR_FGSM ) {bt_gprs_flow.tx_ctx=0xff; return GSM_NOTDONE_ERR;}
      else {bt_gprs_flow.tx_ctx=0xff; return GSM_TIMEOUT_ERR;}
    }
    else
    {
      bt_gprs_flow.tx_ctx=0xff;
      return GSM_TIMEOUT_ERR;//???
    }
  }
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t SendSmsInTextMode(const char *phone, char *sms, uint8_t is_ucs2, uint8_t* mem, uint16_t mem_size)
{
#if defined(__A7670E__)
  //todo: � UCS2 ������ �� ����������. � ������ GSM ��������� ������������, ������� ������� �������������
  //���������� � A818B06A7670M7
  //is_ucs2 = 0;
#endif //defined(__A7670E__)

  int16_t res;
  uint16_t len;
  uint32_t flags;
  int s_len;

  len=strnlen(phone, MAX_PHONE_LEN+1);
  if(len>MAX_PHONE_LEN) return GSM_WRONG_IN_PARAM;

  uint8_t idx=0;
  if(phone[0]=='+') idx++;
  for(; idx<len; idx++)
  {
    if(phone[idx]<'0' || phone[idx]>'9') return GSM_WRONG_IN_PARAM;
  }

  //проверяем смс
  len=strnlen(sms, MAX_SMS_LEN_IN_PDU_UCS2+1);
  if(is_ucs2)
  {
    if(len>MAX_SMS_LEN_IN_PDU_UCS2) return GSM_WRONG_IN_PARAM;
  }
  else
  {
    if(len>MAX_SMS_LEN_IN_TEXTMODE_7BIT) return GSM_WRONG_IN_PARAM;
  }

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CMGF=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);//TEXT MODE
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  if(is_ucs2)
  {
    res=WriteToModemUart("AT+CSMP=17,167,0,8\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }
  else
  {
    res=WriteToModemUart("AT+CSMP=17,167,0,0\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  if(is_ucs2)
  {
    res=WriteToModemUart("AT+CSCS=\"UCS2\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }
  else
  {
    res=WriteToModemUart("AT+CSCS=\"GSM\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  if(is_ucs2)
  {
    if((4*strlen(sms)+1)>mem_size)      return GSM_MEM_ERR;
    if((4*MAX_PHONE_LEN+1)>mem_size)    return GSM_MEM_ERR;

    mem[0]='\0';
    strcat((char*)mem, "AT+CMGS=\"");
    Win1251ToUCS2(phone, (char*)mem+strlen("AT+CMGS=\""));//кодируем номер вместе с +7
    strcat((char*)mem, "\"\r");
  }
  else
  {
    s_len=snprintf((char*)mem, mem_size, "AT+CMGS=\"%s\"\r", phone);
    if(s_len<0 || s_len>=mem_size) return GSM_MEM_ERR;
  }

  ResetModemAtFlag(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)mem, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(READY_FOR_DATA_ENTRY_FGSM|ERROR_FGSM, 10000);

    if(flags&READY_FOR_DATA_ENTRY_FGSM)
    {
      ResetModemAtFlag(OK_FGSM|ERROR_FGSM);

      if(is_ucs2)
      {
        len=Win1251ToUCS2(sms, (char*)mem);//кодируем смс
        res=WriteToModemUart(mem, len, GSM_TX_DEF_TIMEOUT);
      }
      else
      {
        res=WriteToModemUart((uint8_t*)sms, STRING_LEN, GSM_TX_DEF_TIMEOUT);
      }

      if(res>0)
      {
        ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
        res=WriteToModemUart("\x1a", 1, GSM_TX_DEF_TIMEOUT);
        if(res==MODEM_UART_TX_OK)
        {
          flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 60000);

          if(flags&OK_FGSM) res=1;//
          else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
          else res=GSM_TIMEOUT_ERR;
        }
        else res=GSM_TIMEOUT_ERR;
      }
    }
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  return res;
}

int16_t QuerySms(sms_inf_t* sms_inf)
{
  int16_t res;
  uint32_t flags;

  sms_inf->used=0;
  sms_inf->total=0;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);

  res=WriteToModemUart("AT+CPMS?\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM)
    {
      xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
      sms_inf->used=modem_state.sms_inf.used;
      sms_inf->total=modem_state.sms_inf.total;
      xSemaphoreGive( modem_at_flags.lock_obj );
      return GSM_RES_OK;
    }
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
}

int16_t DeleteSms(uint8_t idx)
{
  int16_t res;
  uint32_t flags;
  int s_len;

  if(idx==0) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMGD=%hhu\r", idx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 15000);
    if(flags&OK_FGSM) return GSM_RES_OK;
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;
}

int16_t ReadSmsConfig(void)
{
  int16_t res;
  uint32_t flags;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CMGF=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
//  if(is_ucs2)
//  {
    res=WriteToModemUart("AT+CSCS=\"UCS2\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
//  }
//  else
//  {
    //res=WriteToModemUart("AT+CSCS=\"GSM\"\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
//  }

  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;


  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart("AT+CSDH=1\r", STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  return GSM_RES_OK;
}

int16_t ReadSms(uint8_t idx, char* sms_data, uint16_t sms_data_mem_size, uint8_t* is_emty, char* phone, uint8_t phone_mem_size, sms_udh_chunks_inf_t* chunks_inf)
{
  int16_t res;
  uint32_t flags;
  int s_len;

  *is_emty=1;
  *phone='\0';
  memset(chunks_inf, 0, sizeof(*chunks_inf));

  if(idx==0 || sms_data==NULL || sms_data_mem_size<sizeof("")) return GSM_WRONG_IN_PARAM;

  *sms_data='\0';

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMGR=%hhu\r", idx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  sms_read_flow.is_emty=1;
  sms_read_flow.recv_mem_ptr=sms_data;
  sms_read_flow.recv_mem_size=sms_data_mem_size;
  sms_read_flow.phone=phone;
  sms_read_flow.phone_mem_size=phone_mem_size;
  sms_read_flow.received_len=0;
  sms_read_flow.chunks_inf=chunks_inf;
  if(sms_read_flow.chunks_inf!=NULL) memset(sms_read_flow.chunks_inf, 0, sizeof(sms_udh_chunks_inf_t));

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 5000);
    if(flags&OK_FGSM) res=GSM_RES_OK;
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  sms_read_flow.recv_mem_ptr=NULL;
  sms_read_flow.recv_mem_size=0;

  if(res==GSM_RES_OK)
  {
    *is_emty=sms_read_flow.is_emty;
    return (int16_t)sms_read_flow.received_len;
  }
  else
    return res;
}

int16_t SendUssdRequest(const char* phone, char* answer, const uint16_t answer_max_size)
{
#if defined(__A7670E__)
  //todo: ���� �������� � USC2
  //+CUSD: 2,"Unknown Alphabet", 0
  return GSM_NOTDONE_ERR;
#endif //defined(__A7670E__)

  int16_t res;

  answer[0]='\0';

  if(sizeof("AT+CUSD=1,\"")-1 + sizeof("\"\r")-1 + 4*strlen(phone) >= sizeof(cmd_buff))
  {
    return GSM_MEM_ERR;
  }

  //res=send_simple_at("AT+CSMP=17,167,0,8\r", 5000);
  //if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+CSCS=\"UCS2\"\r", 5000);
  if(res!=GSM_RES_OK) return res;

  cmd_buff[0]='\0';
  strcat(cmd_buff, "AT+CUSD=1,\"");
  Win1251ToUCS2(phone, &cmd_buff[sizeof("AT+CUSD=1,\"")-1]);
  strcat(cmd_buff, "\"\r");

  //snprintf(cmd_buff, sizeof(cmd_buff), "AT+CUSD=1,\"%s\"\r", phone);

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem_size=answer_max_size;
  aux_data.dst_mem=answer;
  xSemaphoreGive( modem_at_flags.lock_obj );

//#if defined(__MC60__)
  //res=send_simple_at(cmd_buff, 120000);
//#endif //defined(__MC60__)

//#if defined(__EC21_X__)
  res=extended_send_simple_at(cmd_buff, CUSD_FGSM, 120000);
//#endif //defined(__EC21_X__)

  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  aux_data.dst_mem=NULL;
  aux_data.dst_mem_size=0;
  xSemaphoreGive( modem_at_flags.lock_obj );

  if(GSM_RES_OK!=send_simple_at("AT+CUSD=0\r", 60000))
  {
    send_simple_at("AT+CUSD=0\r", 60000);
  }

  return res;
}

int16_t enable_modem_ext_temp_monitoring(void)
{
  return send_simple_at("AT+CMTE=1\r", 2000);
}

operate_modem_temp_status_t get_modem_temp_status(void)
{
  return modem_state.temp_status;
}

operate_modem_power_status_t get_modem_power_status(void)
{
  operate_modem_power_status_t res;
  xSemaphoreTake( modem_at_flags.lock_obj, portMAX_DELAY );
  res=modem_state.power_status;
  modem_state.power_status=UNKNOWN_MODEM_POWER_STATUS;
  xSemaphoreGive( modem_at_flags.lock_obj );
  return res;
}

int16_t tcp_socket_transmitting_state(uint8_t ctx, uint32_t* txlen, uint32_t* acklen, uint32_t* nacklen)
{
  int s_len;
  int16_t res;

  if(ctx>MAX_CONN_CTX_ID) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CIPACK=%hhu\r", ctx);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.conn_data_trans_state.is_updated=0;
  res=send_simple_at(cmd_buff, 2000);
  if(res!=GSM_RES_OK) return res;

  if(bt_gprs_flow.conn_data_trans_state.is_updated)
  {
    if(txlen!=NULL)   *txlen=bt_gprs_flow.conn_data_trans_state.txlen;
    if(acklen!=NULL)  *acklen=bt_gprs_flow.conn_data_trans_state.acklen;
    if(nacklen!=NULL) *nacklen=bt_gprs_flow.conn_data_trans_state.nacklen;
  }
  else
  {
    res=GSM_NOTDONE_ERR;
  }

  return res;
}

int16_t get_cfun_stae(uint8_t* cfun, uint8_t force)
{
  if(force)
  {
    int16_t res;

    res=send_simple_at("AT+CFUN?\r", 2000);
    *cfun=modem_state.cfun_state;

    return res;
  }
  else
  {
    *cfun=modem_state.cfun_state;
    return GSM_RES_OK;
  }
}

int16_t set_voice_call_mode(void)
{
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CHFA=%hhu\r", audio_chanel);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 1000);
}

//volume: 0% – 100%
int16_t set_speaker_volume(uint8_t volume)
{
  int s_len;

  if(volume>100) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CLVL=%hhu\r", volume);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 300);
}

//gain: 0 – 15
int16_t set_mic_gain(uint8_t gain)
{
  int s_len;

  if(gain>15) return GSM_WRONG_IN_PARAM;

  //0(0dB) – 15(+22.5dB)
  //gain=(15Ul*gain)/100Ul;

#if defined(__SIM800_DS__)
  if(gain<3) gain=3;//почему-то при меньшем микрафон совсем отключается
#endif

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CMIC=%hhu,%hhu\r", audio_chanel, gain);//main audio channel
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 300);
}

int16_t echo_cancellation_control(uint16_t nlp, uint16_t aec, uint16_t nr, uint16_t ns)
{
  //default: +ECHO: (0,96,253,16388,20488),(1,96,224,5256,20488)
  int s_len;
  uint8_t mic;

  if(audio_chanel==0) mic=0;//main audio handset channel
  else                mic=1;//main audio handfree channel

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+ECHO=%hhu,%hu,%hu,%hu,%hu,1\r", mic, nlp, aec, nr, ns);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 300);
}

// Files
int16_t m_fs_init(void)
{
  int16_t res;

  res=send_simple_at("AT+FSHEX=0\r", 500); //The file path or file name is ASCII format
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+FSDRIVE=0\r", 500); //Local drive
  if(res!=GSM_RES_OK) return res;

  char mem[3];
  res=m_storage_inf(mem, sizeof(mem));
  if(res!=GSM_RES_OK) return res;

  m_fs.drive='C';
  if(mem[1]!=':') return GSM_NOTDONE_ERR;

  m_fs.drive=mem[0];

  return GSM_RES_OK;
}

int16_t m_file_list(char* mem, uint16_t mem_size)
{
  /*
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSLS=%c:\\\r", m_drive);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return get_aux_data(cmd_buff, mem, mem_size, 1);
  */
  return GSM_NOTDONE_ERR;
}

int16_t m_fsize(const char* fname, uint32_t* size, char* mem, uint16_t mem_size)
{
  int s_len;
  int16_t res;

  *size=0;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSFLSIZE=%c:\\%s\r", m_fs.drive, fname);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=get_aux_data(cmd_buff, mem, mem_size, 0);
  if(res!=GSM_RES_OK) return res;

  if(mem[0]<'0' || mem[0]>'9') return GSM_NOTDONE_ERR;

  *size=strtoul(mem, NULL, 10);

  return GSM_RES_OK;
}

/*
fopt:
0 - If the file does not exist, it will be created; if the file exists, it will be directly
opened. And both of them can be read and written
1 - If the file does not exist, it will be created; If the file exists, the file will be
overwritten and cleared. And both of them can be read and written
2 - If the file exists, open it and it can be read only. When the file doesn’t exist, it will respond with error
todo: fopt не проверялись на совместимость с аналогичнвми опциями библиотеки Quectel
*/
int16_t m_fopen(const char* fname, uint32_t* fctx, uint8_t fopt)
{
  int s_len;
  int16_t res;

  if(fopt>1) return GSM_WRONG_IN_PARAM;

  *fctx=0;

  m_fs.ctx[*fctx].is_open=0;
  m_fs.ctx[*fctx].read_offset=0;
  m_fs.ctx[*fctx].fsize=0;
  if(fopt==2) m_fs.ctx[*fctx].is_write_allowed=0;
  else        m_fs.ctx[*fctx].is_write_allowed=1;

  s_len=snprintf(m_fs.ctx[*fctx].fname, sizeof(m_fs.ctx[*fctx].fname), "%s", fname);
  if(s_len<0 || s_len>=sizeof(m_fs.ctx[*fctx].fname)) return GSM_WRONG_IN_PARAM;

  uint8_t is_file_exists=0;

  char mem[8];
  res=m_fsize(m_fs.ctx[*fctx].fname, &m_fs.ctx[*fctx].fsize, mem, sizeof(mem));

  if(res==GSM_RES_OK) is_file_exists=1;

  if(fopt==1 || (fopt==0 && !is_file_exists))
  {
    s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSCREATE=%c:\\%s\r", m_fs.drive, m_fs.ctx[*fctx].fname);
    if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

    res=send_simple_at(cmd_buff, 800);

    if(res!=GSM_RES_OK) return res;

    m_fs.ctx[*fctx].is_open=1;
  }
  else if(fopt==2 && !is_file_exists)
  {
    return GSM_NOTDONE_ERR;
  }

  return GSM_RES_OK;
}

int16_t m_fwrite(uint32_t fctx, uint8_t* data, uint16_t len)
{
  int s_len;
  int16_t res;

  if(fctx>=MAX_MODEM_FILES_CTX) return GSM_WRONG_IN_PARAM;

  if(!m_fs.ctx[fctx].is_write_allowed) return GSM_NOTDONE_ERR;

  if(!len) return len;

  if(len>10240) return GSM_WRONG_IN_PARAM;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSWRITE=%c:\\%s,1,%hu,10\r", m_fs.drive, m_fs.ctx[fctx].fname, len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=extended_send_simple_at(cmd_buff, READY_FOR_DATA_ENTRY_FGSM, 800);
  if(res!=GSM_RES_OK) return res;

  ResetModemAtFlag(OK_FGSM|ERROR_FGSM);
  res=WriteToModemUart(data, len, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 800);
    if(flags&OK_FGSM) {}
    else if(flags&ERROR_FGSM) return GSM_NOTDONE_ERR;
    else return GSM_TIMEOUT_ERR;
  }
  else return GSM_TIMEOUT_ERR;

  m_fs.ctx[fctx].fsize+=len;

  return len;
}

int16_t m_fseek(uint32_t fctx, uint32_t offset)
{
  if(m_fs.ctx[fctx].fsize<offset) return GSM_NOTDONE_ERR;

  m_fs.ctx[fctx].read_offset=offset;

  return GSM_RES_OK;
}

int16_t m_fread(uint32_t fctx, uint8_t* data, uint16_t len)
{
  int s_len;
  int16_t res;

  if(!len) return len;

  if(fctx>=MAX_MODEM_FILES_CTX) return GSM_WRONG_IN_PARAM;

  if(len>10240) return GSM_WRONG_IN_PARAM;

  if((m_fs.ctx[fctx].read_offset+len)>m_fs.ctx[fctx].fsize) return GSM_WRONG_IN_PARAM;

  //строка должна заканчиваться именнно на \r, чтобы парсер корректно обработал эхо и выбросил лишнии \r\n
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSREAD=%c:\\%s,1,%hu,%u\r", m_fs.drive,m_fs.ctx[fctx].fname, len, m_fs.ctx[fctx].read_offset);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  //без эхо модуль шлет \r\n и следом данные
  //включаем эхо, по его приему начентся прием данных
  //todo: не ясно может ли URC вклиниться между эхо от команды и данными?
  for(uint8_t i=0; i<3; i++)
  {
    if(GSM_RES_OK==send_simple_at("ATE1\r", 500))  break; //enable echo
    vTaskDelay(200*(i+1));
  }

  bt_gprs_flow.rx_write_ptr=data;
  bt_gprs_flow.rx_ctx=(uint8_t)fctx;

  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 1500);

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM))
    {
      res=bt_gprs_flow.rx_write_ptr-data;//actual recv len //должно быть установленно end_data_flag и OK_FGSM
      m_fs.ctx[fctx].read_offset+=res;
    }
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xff;

  for(uint8_t i=0; i<3; i++)
  {
    if(GSM_RES_OK==send_simple_at("ATE0\r", 500))  break; //disable echo
    vTaskDelay(200*(i+1));
  }

  return res;
}

int16_t m_fclose(uint32_t fctx)
{
  m_fs.ctx[fctx].is_open=0;
  m_fs.ctx[fctx].read_offset=0;
  return GSM_RES_OK;
}

int16_t m_fdelete(const char* fname)
{
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FSDEL=%c:\\%s\r", m_fs.drive, fname);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 800);
}

int16_t m_storage_inf(char* mem, uint16_t mem_size)
{
  //+FSMEM: C:81920bytes
  return get_aux_data("AT+FSMEM\r", mem, mem_size, 0);
}

/*
int16_t m_open_files_list(char* mem, uint16_t mem_size)
{
  return get_aux_data("AT+QFOPEN?\r", mem, mem_size, 1);
}
*/

const char* get_act_verbose(uint8_t act)
{
  static const char* const act_verbose[] =
  {
    "GSM (0)",
    "Unknown (1)",
    "UTRAN (2)",
    "GSM w/EGPRS (3)",
    "UTRAN w/HSDPA (4)",
    "UTRAN w/HSUPA (5)",
    "UTRAN w/HSDPA and w/HSUPA (6)",
    "E-UTRAN (7)",
  };

  if(act<sizeof(act_verbose)/sizeof(act_verbose[0])) return act_verbose[act];

  return "Unknown";
}

const char* get_reg_status_verbose(uint8_t reg_status)
{
  const char* const reg_status_verbose[] =
  {
    "Not registered, ME is currently not searching for new operator (0)",
    "Registered, home network (1)",
    "Not registered, but MT is currently searching a new operator to register to (2)",
    "Registration denied (3)",
    "Unknown (4)",
    "Registered, roaming (5)"
  };

  if(reg_status<sizeof(reg_status_verbose)/sizeof(reg_status_verbose[0])) return reg_status_verbose[reg_status];

  return "Unknown";
}

uint8_t get_pdp_deact_event(void)
{
 return modem_state.pdp_deact_event;
}

void reset_pdp_deact_event(void)
{
 modem_state.pdp_deact_event=0;
}

#if defined(SIMCOM_MODEM_FTP_PRESENT)
//�������� FTP A7670E:
//��� ���� � ����� ����� ���� �������, ������ ������ ������.
//������ ��� ���������� ������ ������������ ������ �����, ������ ���� ��� ���� ������ ��� ��������� (���� ����������� ������������� ���������� ��������), ���� ����� ��������� � ����.
//��� ������ FTP, �������������� �� ��������.

//ftp://[username[:password]@]server[:port]/path/resource
int parse_ftp_link(const char* link, char* username, char* password, char* server, char* path, char* file)
{
  static const uint8_t PARSE_FTP_LINK_DBG = 0;

  if(PARSE_FTP_LINK_DBG)
  {
    __PRINTF("\n%s\n", link);
  }

  if(memcmp(link, "ftp://", sizeof("ftp://")-1)!=0) return -1;

  uint8_t st_end[2]={sizeof("ftp://")-1, 0};
  uint8_t slash[2]={0, 0};
  uint8_t colon[2]={0, 0};
  uint8_t at=0;

  for(uint8_t i=st_end[0]; ; i++)
  {
    if(link[i]==':')
    {
      if(!i) return -1;

      if(colon[0] && colon[1]) return -1; //������ ��� ���������

      if(colon[0]) {colon[1]=i;}
      else         {colon[0]=i;}
    }
    else if(link[i]=='@')
    {
      if(!i) return -1;

      if(at) return -1; //������ ���� ������

      at=i;
    }
    else if(link[i]=='/')
    {
      if(!i) return -1;

      if(slash[0]) {slash[1]=i;}
      else         {slash[0]=i;}
    }
    else if(link[i]=='\r' || link[i]=='\n' || link[i]=='\0')
    {
      if(!i) return -1;

      st_end[1]=i;
      break;
    }

    if(i==0xFF) break;
  }

  if(!st_end[1]) return -1;

  if(!slash[0]) return -1;
  if(slash[0]==slash[1]+1) return -1;
  if(!slash[1]) slash[1]=slash[0];

  if(slash[0]==colon[0]+1) return -1;
  if(slash[0]==colon[1]+1) return -1;

  if(st_end[1]==slash[1]+1) return -1;

  //����� � ������
  //ftp://username:password@server[:port]/resource.ext
  if(at && colon[0] && colon[1] && colon[0]<at && colon[1]>at ||
     at && colon[0] && !colon[1] && colon[0]<at)
  {
    const char* const port=(at && colon[0] && !colon[1] && colon[0]<at)?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", colon[0]-st_end[0], &link[st_end[0]]);}
    if(password!=NULL) {sprintf(password, "%.*s", at-(colon[0]+1), &link[colon[0]+1]);}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-(at+1), &link[at+1], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", colon[0]-st_end[0], &link[st_end[0]]);
      __PRINTF("password: %.*s\n", at-(colon[0]+1), &link[colon[0]+1]);
      __PRINTF("server:port: %.*s%s\n", slash[0]-(at+1), &link[at+1], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  //������ �����
  //ftp://username@server[:port]/resource.ext
  if(at && colon[0] && at<colon[0] ||
     at && !colon[0])
  {
    const char* const port=(at && !colon[0])?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", at-st_end[0], &link[st_end[0]]);}
    if(password!=NULL) {sprintf(password, "%.*s", 0, "");}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-(at+1), &link[at+1], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", at-st_end[0], &link[st_end[0]]);
      __PRINTF("password: %.*s\n", 0, "");
      __PRINTF("server:port: %.*s%s\n", slash[0]-(at+1), &link[at+1], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  //��� ������ � ������
  //ftp://server[:port]/resource.ext
  if(!at && colon[0] ||
     !at && !colon[0])
  {
    const char* const port=(!at && !colon[0])?(":21"):("");

    if(username!=NULL) {sprintf(username, "%.*s", 0, "");}
    if(password!=NULL) {sprintf(password, "%.*s", 0, "");}
    if(server!=NULL)   {sprintf(server, "%.*s%s", slash[0]-st_end[0], &link[st_end[0]], port);}
    if(path!=NULL)     {sprintf(path, "%.*s", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);}
    if(file!=NULL)     {sprintf(file, "%.*s", st_end[1]-(slash[1]+1), &link[slash[1]+1]);}

    if(PARSE_FTP_LINK_DBG)
    {
      __PRINTF("username: %.*s\n", 0, "");
      __PRINTF("password: %.*s\n", 0, "");
      __PRINTF("server:port: %.*s%s\n", slash[0]-st_end[0], &link[st_end[0]], port);
      __PRINTF("path: %.*s\n", (slash[1]==slash[0])?(1):(slash[1]-slash[0]), &link[slash[0]]);
      __PRINTF("file: %.*s\n", st_end[1]-(slash[1]+1), &link[slash[1]+1]);
    }

    return 0;
  }

  return -1;
}

int16_t m_ftp_open(const char* user, const char* pass, const char* addr)
{
#if defined(__A7670E__)
  int16_t res;
  const char* port;
  int s_len;

  //���� ����� �������
  m_ftp_close();

  if(user==NULL || pass==NULL || addr==NULL)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(port==NULL) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5) return GSM_WRONG_IN_PARAM;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at("AT+CFTPSSTART\r", FTP_FLAG_FGSM, 9000);
  //wait +CFTPSSTART: 0
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  //modem_state.ftp_res=0xFFFFFFFF;
  //res=extended_send_simple_at("AT+CFTPSTYPE=I\r", FTP_FLAG_FGSM, 9000);
  //wait +CFTPSTYPE: 0
  //if(res!=GSM_RES_OK) return res;
  //if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  send_simple_at("AT+CFTPSTYPE?\r", 800);

  if(user[0]=='\0') {user = "anonymous";}
  if(pass[0]=='\0') {pass = "anonymous";}

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTPSLOGIN=\"%.*s\",%.*s,\"%s\",\"%s\",0\r", port-addr-1, addr, 5, port, user, pass);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 120000);
  //wait +CFTPSLOGIN: 0
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  int s_len;
  const char* port;

  res=send_simple_at("AT+SAPBR=4,1\r", 800);
  if(res!=GSM_RES_OK) return res;

  //�� ������ APN, �� ��������� ���������
  res=send_simple_at("AT+SAPBR=1,1\r", 180000);
  //if(res!=GSM_RES_OK) return res;

  //���� ����� �������
  m_ftp_close();

  if(user==NULL || pass==NULL || addr==NULL)
  {
    return GSM_WRONG_IN_PARAM;
  }

  if(strlen(addr)<4) return GSM_WRONG_IN_PARAM;
  port=strrchr(addr, ':');
  if(port==addr) return GSM_WRONG_IN_PARAM;
  if(port==NULL) return GSM_WRONG_IN_PARAM;
  port++;
  if(strlen(port)>5) return GSM_WRONG_IN_PARAM;

  //Passive FTP mode
  res=send_simple_at("AT+FTPMODE=1\r", 800);
  if(res!=GSM_RES_OK) return res;

  //Set FTP Bearer Profile Identifier
  res=send_simple_at("AT+FTPCID=1\r", 800);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPSERV=\"%.*s\"\r", port-addr-1, addr);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPPORT=\"%.*s\"\r", 5, port);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  if(user[0]=='\0') {user = "anonymous";}
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPUN=\"%s\"\r", user);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  if(pass[0]=='\0') {pass = "anonymous";}
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPPW=\"%s\"\r", pass);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t m_ftp_set_path(const char* path)
{
#if defined(__A7670E__)
  int16_t res;
  int s_len;

  //����� ���������� ������ ���� �������������� ����, ���� � �������� ��� ����
  const char* add_slash = "/";

  if(path[0] == '/' && path[1] == '\0') {add_slash = "";}

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTPSCWD=\"%s%s\"\r", path, add_slash);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 9000);
  //wait +CFTPSCWD: 0
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  int s_len;

  //����� ���������� ������ ���� �������������� ����, ���� � �������� ��� ����
  const char* add_slash = "/";

  if(path[0] == '/' && path[1] == '\0') {add_slash = "";}

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPGETPATH=\"%s%s\"\r", path, add_slash);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

// 0 - Idle, 1 - FTPGET, FTPPUT, FTPDELE
int16_t m_get_ftp_state(uint8_t* state)
{
#if defined(__A7670E__)
  state[0] = 0;

  return GSM_RES_OK;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  //not used
  int16_t res;

  res=send_simple_at("AT+FTPSTATE\r", 800);
  if(res!=GSM_RES_OK) return res;

  state[0] = 0;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

const char* m_get_verbose_ftp_state(const uint8_t state)
{
#if defined(__A7670E__)
  return "";
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  switch(state)
  {
  case 0:  return "idle(0)";
  case 1:  return "in the ftp session(1)";
  default: return "unknown(-)";
  }
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t m_ftp_get_file_size(const char* file, uint32_t* fsize)
{
#if defined(__A7670E__)
  int16_t res;
  int s_len;

  fsize[0]=0;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTPSSIZE=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 9000);
  //wait OK +CFTPSSIZE: <filesize>
  //or ERROR +CFTPSSIZE: <errcode>
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res == 0 || modem_state.ftp_res == 0xFFFFFFFF) return GSM_NOTDONE_ERR;

  fsize[0] = modem_state.ftp_res;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  int s_len;

  fsize[0]=0;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPGETNAME=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  modem_state.ftp_res_1=0xFF;
  modem_state.ftp_res_2=0xFFFF;
  modem_state.ftp_fsize=0;
  res=extended_send_simple_at("AT+FTPSIZE\r", FTP_FLAG_FGSM, 80000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res_1!=1 || modem_state.ftp_res_2!=0) return GSM_NOTDONE_ERR;

  fsize[0]=modem_state.ftp_fsize;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t m_ftp_open_file_for_read(const char* file)
{
#if defined(__A7670E__)
  int16_t res;
  int s_len;

  //s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTPSGETFILE=\"%s\",1\r", file);
  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTPSGET=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at(cmd_buff, FTP_FLAG_FGSM, 120000);
  //if FS, wait +CFTPSGETFILE: 0
  //if Serial, wait +CFTPSGET: 0
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPGETNAME=\"%s\"\r", file);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;

  modem_state.ftp_res_1=0xFF;
  modem_state.ftp_res_2=0xFFFF;
  res=extended_send_simple_at("AT+FTPGET=1\r", FTP_FLAG_FGSM, 80000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res_1!=1 || modem_state.ftp_res_2!=1) return GSM_NOTDONE_ERR;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t m_ftp_get_file_chunk(uint8_t* data, uint16_t chunk_len)
{
#if defined(__A7670E__)
  /*
  int16_t res;
  int s_len;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CFTRANTX=\"%s\",%u,%u\r", file, offset, chunk_len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  res=send_simple_at(cmd_buff, 800);
  if(res!=GSM_RES_OK) return res;
  */
  return -1;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;
  int s_len;

  if(!chunk_len) return 0;

  if(chunk_len>1460) chunk_len=1460;

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+FTPGET=2,%hu\r", chunk_len);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  bt_gprs_flow.rx_write_ptr=data;
  bt_gprs_flow.rx_ctx=0xFE;
  ResetModemAtFlag(OK_FGSM|CIPRXGET_BTSPPGET_ENDDATA_FGSM|ERROR_FGSM);
  res=WriteToModemUart((const uint8_t*)cmd_buff, STRING_LEN, GSM_TX_DEF_TIMEOUT);
  if(res==MODEM_UART_TX_OK)
  {
    uint32_t flags=WaitModemFlags(OK_FGSM|ERROR_FGSM, 32000);//������� �������� CIPRXGET_BTSPPGET_ENDDATA_FGSM, ����� OK_FGSM, ������� ���� OK_FGSM

    if(flags&(CIPRXGET_BTSPPGET_ENDDATA_FGSM|OK_FGSM)) res=bt_gprs_flow.rx_write_ptr-data;//actual recv len //������ ���� ������������ end_data_flag � OK_FGSM
    else if(flags&ERROR_FGSM) res=GSM_NOTDONE_ERR;
    else res=GSM_TIMEOUT_ERR;
  }
  else res=GSM_TIMEOUT_ERR;

  bt_gprs_flow.rx_write_ptr=NULL;
  bt_gprs_flow.rx_ctx=0xFF;

#warning ����� ��������� +FTPGET:1,0 �� ���������� �����?

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}

int16_t m_ftp_close(void)
{
#if defined(__A7670E__)
  int16_t res;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at("AT+CFTPSLOGOUT\r", FTP_FLAG_FGSM, 9000);
  //wait +CFTPSLOGIN: 0
  //if(res!=GSM_RES_OK) return res;
  //if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  modem_state.ftp_res=0xFFFFFFFF;
  res=extended_send_simple_at("AT+CFTPSSTOP\r", FTP_FLAG_FGSM, 9000);
  //wait +CFTPSSTOP: 0
  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res!=0) return GSM_NOTDONE_ERR;

  return res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
  int16_t res;

  //AT+FTPQUIT
  //OK
  //+FTPGET: 1,86
  //Quit FTP session
  //Manual quit FTP session

  modem_state.ftp_res_1 = 0xFF;
  modem_state.ftp_res_2 = 0xFFFF;
  res=extended_send_simple_at("AT+FTPQUIT\r", FTP_FLAG_FGSM, 60000);

  if(res!=GSM_RES_OK) return res;
  if(modem_state.ftp_res_1!=1 || modem_state.ftp_res_2!=86) return GSM_NOTDONE_ERR;

  return res;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
}
#endif //defined(SIMCOM_MODEM_FTP_PRESENT)

#if defined(__SIM800__) || defined(__SIM800_DS__)
int16_t dtmf_config(void)
{
  int16_t res;

  res=send_simple_at("AT+DDET=1,0,0,0\r", 1500);
  if(res!=GSM_RES_OK) return res;

  res=send_simple_at("AT+DTAM=1\r", 1500);
  if(res!=GSM_RES_OK) return res;

  return res;
}
#endif //defined(__SIM800__) || defined(__SIM800_DS__)

//0 Disable slow clock, module will not enter sleep mode.
//1 Enable slow clock, it is controlled by DTR. When DTR is high, module can enter sleep mode. When DTR changes to low level, module can quit sleep mode.
//2 Enable slow clock automatically. When there is no interrupt (on air and hardware such as GPIO interrupt or data in serial port), module can enter sleep mode. Otherwise, it will quit sleep mode.
int16_t modem_psave_mode_cfg(uint8_t mode)
{
  int s_len;

  //send_simple_at("AT+CSCLK?\r", 800);

  s_len=snprintf(cmd_buff, sizeof(cmd_buff), "AT+CSCLK=%u\r", mode);
  if(s_len<0 || s_len>=sizeof(cmd_buff)) return GSM_WRONG_IN_PARAM;

  return send_simple_at(cmd_buff, 800);
}