/**
******************************************************************************
* File Name          : simcom_modem_lib.h
* Description        :
*
*
******************************************************************************
*/
#ifndef __SIMCOM_MODEM_LIB_H
#define __SIMCOM_MODEM_LIB_H

#ifdef __cplusplus
extern "C" {
#endif

  /* Includes -----------------------------------------------------------------*/
#include "simcom_modem_conf.h"
#include "modem_uart.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "semphr.h"
#include <stdlib.h>
#include <string.h>
#include "ext_string_lib/ext_string.h"

#if     PARSE_RX_BUFF_SIZE < MODEM_RX_MEM_SIZE+1
#error  PARSE_RX_BUFF_SIZE должен быть не меньше MODEM_RX_MEM_SIZE+1
#endif

#if (!(defined(__SIM800__)||(defined(__SIM800_DS__)||defined(__A7670E__))))
#error  ������ ���� ������ ����� __SIM800__ ��� __SIM800_DS__ ��� __A7670E__
#endif

#define MAX_SMS_LEN_IN_PDU_UCS2         (70)
#define MAX_PHONE_LEN                   (13)//with '+'

#define MAX_SMS_LEN_IN_TEXTMODE_7BIT    (160)//for 7bit coding

  /* Exported types -----------------------------------------------------------*/
  typedef struct
  {
    uint32_t netCellId;
    uint16_t netLac;
    uint8_t AcT;
    uint8_t regStatus;
  }creg_state_t;

  typedef struct
  {
    uint16_t mcc;
    uint16_t mnc;
  }operator_inf_t;

  typedef struct
  {
    uint8_t used;
    uint8_t total;
  }sms_inf_t;

  typedef enum
  {
    DATA_IN_WIN1251_WO_HEADER = 0,
    DATA_IN_WIN1251_W_HEADER,
    DATA_IN_8BIT_WO_HEADER,
    DATA_IN_8BIT_W_HEADER,
    DATA_IN_UCS2_WO_HEADER,
    DATA_IN_UCS2_W_HEADER
  }
  sms_decoding_inf_t;

  typedef enum
  {
    UNKNOWN_MODEM_TEMP_STATUS = 0,
    NORMAL_MODEM_TEMP_STATUS,         //Normal operating temperature
    LOWEST_MODEM_TEMP_STATUS,         //Below lowest temperature limit (causes immediate switch-off)
    LOW_MODEM_TEMP_STATUS,            //Below low temperature alert limit
    UPPER_MODEM_TEMP_STATUS,          //Above upper temperature alert limit
    UPPERMOST_MODEM_TEMP_STATUS       //Above uppermost temperature limit (causes immediate switch-off)
  }
  operate_modem_temp_status_t;

  typedef enum
  {
    UNKNOWN_MODEM_POWER_STATUS = 0,
    UNDERVOLTAGE_MODEM_POWER_STATUS, //ME is close to the undervoltage threshold
    OVERVOLTAGE_MODEM_POWER_STATUS   //e ME is close to the overvoltage threshold
  }
  operate_modem_power_status_t;

  typedef struct
  {
    uint8_t uid;
    uint8_t total;
    uint8_t current;
  }
  sms_udh_chunks_inf_t;

  typedef struct
  {
    sms_decoding_inf_t decoding_inf;
    uint8_t is_wait_data;
    char* recv_mem_ptr;
    uint16_t recv_mem_size;
    uint16_t received_len;
    char* phone;
    uint8_t phone_mem_size;
    uint8_t is_emty;
    sms_udh_chunks_inf_t* chunks_inf;
  }sms_read_flow_t;

  typedef enum
  {
    SMS_REC_EMTY = 0,
    SMS_REC_UNREAD,
    SMS_REC_READ,
    SMS_REC_OTHER
  }
  sms_stat_t;

  typedef struct
  {
    uint8_t  buff[PARSE_RX_BUFF_SIZE];
    uint16_t buff_idx;
    int16_t  bt_gprs_len_wait;
    uint8_t  bt_gprs_ctx;
    uint8_t  buff_full_flag;
  }modem_parse_t;

  typedef enum
  {
    FORWARDING_DISABLED = 0,
    FORWARDING_ENABLE  = 1,
    FORWARDING_DISABLE_CMD = 2,
    FORWARDING_DISABLE_ACK = 3
  }rx_fwd_state_t;

  typedef enum
  {
    NO_JAMMING = 0,
    JAMMING_DETECTED  = 1,
    INTERFERENCE_DETECTED = 2
  }jamming_state_t;

  typedef struct
  {
    rx_fwd_state_t state;
    uint8_t* rx_ptr;
    uint8_t* rx_start;
    uint8_t* rx_end;
  }modem_fwd_t;

  typedef struct
  {
    uint8_t ctx;
    uint8_t state;
  }ctx_conn_state_t;

  typedef enum
  {
    MO_CALL_DIR = 0,
    MT_CALL_DIR = 1
  }call_dir_t;

  typedef enum
  {
    ACTIVE_CALL_STATE = 0,
    HELD_CALL_STATE  = 1,
    DIALING_MO_CALL_STATE = 2,
    ALERTING_MO_CAL_STATE = 3,
    INCOMING_MT_CALL_STATE = 4,
    WAIIING_MT_CALL_STATE = 5,
    DISCONNECT_CALL_STATE = 6
  }call_stat_t;

  typedef enum
  {
    VOICE_CALL_MODE = 0,
    DATA_CALL_MODE  = 1,
    FAX_CALL_MODE = 2
  }call_mode_t;

  typedef struct
  {
    //uint8_t is_ready_to_ata_cmd;
    uint8_t is_call_present;
    call_dir_t dir;
    call_stat_t stat;
    call_mode_t mode;
    char number[MAX_PHONE_LEN+1];
  }
  call_state_t;

  typedef struct
  {
    uint8_t is_updated;
    uint32_t txlen;
    uint32_t acklen;
    uint32_t nacklen;
  }prev_conn_data_trans_state_t;

  typedef struct
  {
    creg_state_t creg_state;
#if defined(__SIM800_DS__)
    creg_state_t ds_creg_state;
#endif //__SIM800_DS__

    operator_inf_t operator_inf;

    sms_inf_t sms_inf;
    uint8_t rssi_level;
    uint8_t is_sim_failure;
    jamming_state_t jamming_state;
    operate_modem_temp_status_t temp_status;
    operate_modem_power_status_t power_status;

    call_state_t call_state;

    uint8_t cfun_state;
    uint8_t pdp_deact_event;
    uint8_t cgatt_state;
    uint8_t is_wait_local_ip_responce;//������� �������� ������ � local ip

#if defined(__A7670E__)
    uint16_t conn_state;
#endif //defined(__A7670E__)

#if defined(SIMCOM_MODEM_FTP_PRESENT)
#if defined(__A7670E__)
    uint32_t ftp_res;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
    uint8_t  ftp_res_1;
    uint16_t ftp_res_2;
    uint32_t ftp_fsize;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)
#endif //defined(SIMCOM_MODEM_FTP_PRESENT)
  }modem_state_t;

  typedef struct
  {
    SemaphoreHandle_t lock_obj;
    uint32_t flags;
  }modem_at_flags_t;

  typedef struct
  {
    uint8_t* rx_write_ptr;
    uint8_t  rx_ctx;

    uint8_t tx_ctx;
    uint16_t tx_availeble_len_write_to_modem;
#if (defined(USE_QUICK_SEND_MODE))
    uint16_t accepted_len;
#endif
    uint8_t bt_spp_ctx;
    uint8_t is_spp_conn_available;
    uint8_t bt_status;
    uint32_t req_spp_timer;

    prev_conn_data_trans_state_t conn_data_trans_state;
  }bt_gprs_flow_t;

  typedef struct
  {
    uint8_t cclk_result;
    uint32_t last_sync_utime;
    uint32_t network_utime;
  }modem_network_time_t;

  typedef struct
  {
    char* dst_mem;
    uint16_t dst_mem_size;
    uint8_t is_append_with_lf;//допиѝать и заменить \r\n на \n
  }aux_data_t;

  typedef __packed struct
  {
    uint8_t mac[6];
    int8_t  rssi;
    uint8_t eir_len;
    uint8_t eir[2*31];
  }bt_gat_scan_t;

  /* Exported constants --------------------------------------------------------*/

#define MAX_CONN_CTX_QT                                         (6)//������������ ���������� �����������/�������� �������������� �������
#define MAX_CONN_CTX_ID                                         (MAX_CONN_CTX_QT-1)

#define BT_CONN_CTX_FIRST_ID                                    (1)
#define BT_CONN_CTX_LAST_ID                                     (2)

#define GSM_TX_DEF_TIMEOUT                                      (3000)
#define GSM_WAIT_FLAG_DEF_TICK                                  (10)
#define USE_PARSE_WAIT_UNTIL                                    (0)

  // коды ошибок выполнениѝ команд
#define GSM_TIMEOUT_ERR                                         (-10)
#define GSM_MEM_ERR                                             (-9)
#define GSM_WRONG_IN_PARAM                                      (-2)
#define GSM_NOTDONE_ERR                                         (-1)
#define GSM_RES_OK                                              (0)

  // Radio access technology:
  // creg_state_t AcT:
#define GSM_ACT_STATUS                                          0 //GSM
#define UNKNOWN_ACT_STATUS                                      1 //Unknown (reset state)
#define UTRAN_ACT_STATUS                                        2 //UTRAN
#define GSM_W_EGPRS_ACT_STATUS                                  3 //GSM w/EGPRS
#define UTRAN_W_HSDPA_ACT_STATUS                                4 //UTRAN w/HSDPA
#define UTRAN_W_HSUPA_ACT_STATUS                                5 //UTRAN w/HSUPA
#define UTRAN_W_HSDPA_W_HSUPA_ACT_STATUS                        6 //UTRAN w/HSDPA and w/HSUPA
#define E_UTRAN_ACT_STATUS                                      7 //E-UTRAN

  //creg_state_t regStatus:
#define NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS    0 //Not registered, ME is currently not searching for new operator
#define REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS               1 //Registered to home network
#define NOT_REGISTERED_ME_SEARCHING_OPERATOR_CREG_STATUS        2 //Not registered, but ME is currently searching for a new operator.
#define REGISTRATION_DENIED_CREG_STATUS                         3 //Registration denied
#define UNKNOWN_CREG_STATUS                                     4 //Unknown (reset state)
#define REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS            5 //Registered, roaming? ME is registered at a foreign network (national or international network)

  //sim status:
//#define UNKNOWN_SIM_STATUS                                      0xff
//#define REMOVED_SIM_STATUS                                      0
//#define INSERTED_SIM_STATUS                                     1
//#define DIACTIVATED_SIM_STATUS                                  2

//����� ������� gsm ������
#define OK_FGSM                                                 ((uint32_t)(1<<0))
#define ERROR_FGSM                                              ((uint32_t)(1<<1))
#define READY_FOR_DATA_ENTRY_FGSM                               ((uint32_t)(1<<2))
#define RDY_FGSM                                                ((uint32_t)(1<<3))
#define SIMREADY_FGSM                                           ((uint32_t)(1<<4))
#define CREG_FGSM                                               ((uint32_t)(1<<5))
#define NORMAL_POWER_DOWN_FGSM                                  ((uint32_t)(1<<6))
#define CFUN_X_FGSM                                             ((uint32_t)(1<<7))
#define SMS_READY_FGSM                                          ((uint32_t)(1<<8))
#define CALL_READY_FGSM                                         ((uint32_t)(1<<9))
#define CLOSE_OK_FGSM                                           ((uint32_t)(1<<10))
#define CIPSEND_QUERY_LEN_FGSM                                  ((uint32_t)(1<<11))
#if (!defined(USE_QUICK_SEND_MODE))
#define CIPSEND_SEND_OK_FGSM                                    ((uint32_t)(1<<12))
#define CIPSEND_SEND_FAIL_FGSM                                  ((uint32_t)(1<<13))
#else
#define CIPSEND_DATA_ACCEPT_FGSM                                ((uint32_t)(1<<12))
#endif
#define CIPRXGET_BTSPPGET_ENDDATA_FGSM                          ((uint32_t)(1<<14))
#define CIPSTATUS_FGSM                                          ((uint32_t)(1<<15))
#define BT_SEND_OK_FGSM                                         ((uint32_t)(1<<16))
#define BT_SEND_FAIL_FGSM                                       ((uint32_t)(1<<17))
#define BT_SPP_CONNECTING_FGSM                                  ((uint32_t)(1<<18))
#define BT_BTSPPMAN_FGSM                                        ((uint32_t)(1<<19))

#define SIMREADY_DS_FGSM                                        ((uint32_t)(1<<20))
#define CALL_READY_DS_FGSM                                      ((uint32_t)(1<<21))
#define SMS_READY_DS_FGSM                                       ((uint32_t)(1<<22))
#define CREG_DS_FGSM                                            ((uint32_t)(1<<23))

#define CPIN_NOT_INSERTED_FGSM                                  ((uint32_t)(1<<24))
#define CPIN_NOT_INSERTED_DS_FGSM                               ((uint32_t)(1<<25))

#define CPIN_SIM_PIN_FGSM                                       ((uint32_t)(1<<26))
#define CPIN_SIM_PIN_DS_FGSM                                    ((uint32_t)(1<<27))
#define CIPSHUT_OK_FGSM                                         ((uint32_t)(1<<28))
#define CUSD_FGSM                                               ((uint32_t)(1<<29))
#define FTP_FLAG_FGSM                                           ((uint32_t)(1<<30))
#define BT_HFG_CONNECTING_FGSM                                  ((uint32_t)(1<<31))

//??????? con_state
#define INITIAL_CONN_STATE                                      1
#define CONNECTING_CONN_STATE                                   2
#define CONNECTED_CONN_STATE                                    3
#define REMOTE_CLOSING_CONN_STATE                               4
#define CLOSING_CONN_STATE                                      5
#define CLOSED_CONN_STATE                                       6
//длѝ ѝовмеѝтимоѝти ѝ CINTERION
#define ALLOCATED_CONN_STATE                                    INITIAL_CONN_STATE
#define UP_OR_LISTENNING_CONN_STATE                             CONNECTED_CONN_STATE
#define DOWN_CONN_STATE                                         CLOSED_CONN_STATE
//#define ALERTING_CONN_STATE                                     7
//#define RELEASED_CONN_STATE                                     9

#define SMS_DCS_MASK                                            ((1<<3)|(1<<2))
#define SMS_DCS_DEFAULT_GSM                                     (0)
#define SMS_DCS_8BIT_GSM                                        (4)
#define SMS_DCS_USC2_GSM                                        (8)

#define SMS_USER_DATA_HEDER_INDICATION                          (1<<6)

  /* Exported macro ------------------------------------------------------------*/
  #define __STRNCMP(__s1, __s2)                                 (strncmp(__s1, __s2, strlen(__s2)))

  /* Exported functions ------------------------------------------------------- */
  void ResetSimcomLibState(void);

  // Функциѝ разбора кольцевого буфера uart'a, управлениѝ потоками (пользовательѝкие, gprs), формирование флагов ѝобытиѝ модема
  // Длѝ данной фукции менеджером должен быть ѝоздан отдельный поток, ѝ приоритетом, выше приоритета менеджера
  void SimcomParse_cycle(void);


  // ������� AT ������� � ��������� ��������� ������ (���������� �) ��� ERROR
  int16_t extended_send_simple_at(const char* at, uint32_t wait_flags, uint32_t wait_resp_timeout);
  // Поѝлать AT команду ѝ ожиданием OK или ERROR
  int16_t send_simple_at(const char* at, uint32_t wait_resp_timeout);
  // Функции длѝ работы ѝ флагами ѝобытий модема
  int16_t send_data_in_fwd_mode(const char* s, uint16_t slen);

  // Функции длѝ работы ѝ флагами ѝобытий модема
  void SetModemAtFlag(uint32_t flags_mask);
  void ResetModemAtFlag(uint32_t flag_mask);
  void ClearAllModemAtFlags(void);
  uint32_t ReadModemAtFlag(uint32_t flags_mask);
  uint32_t WaitModemFlags(uint32_t flags_mask, uint32_t timeout);

  int16_t set_network_sync_time(void);
  int16_t get_network_time(uint32_t* unix_time);
  uint8_t is_modem_time_synchronized(void);

  // API длѝ работы ѝ gprs и tcp ѝоеднинениѝми
  int16_t tcp_socket_close(uint8_t ctx);
  int16_t tcp_socket_open(uint8_t ctx, const char* addr);
  int16_t tcp_socket_state(uint8_t ctx);
  int16_t tcp_socket_read(uint8_t ctx, uint8_t *data_out, uint16_t len);
  int16_t tcp_socket_read_blocked(uint8_t ctx, uint8_t *data_out, uint16_t len, uint16_t time_wait);//ждать макѝимум 32767 байт в течении небольшого временного интервала
  int16_t tcp_socket_write(uint8_t ctx, uint8_t *data_out, uint16_t len);// в отличии от gprs_send ограничениt на len 32767 байт
  int16_t tcp_socket_transmitting_state(uint8_t ctx, uint32_t* txlen, uint32_t* acklen, uint32_t* nacklen);

  int16_t bt_read(uint8_t ctx, uint8_t *data_out, uint16_t len);
  int16_t bt_write(uint8_t ctx, uint8_t *data_out, uint16_t len);

  int16_t cfun_config(uint8_t fun, uint8_t rst);
  int16_t get_cfun_stae(uint8_t* cfun, uint8_t force);
  uint8_t is_enable_set_minimum_functionality_for_set_apn(void);
  int16_t gprs_config(const char* user, const char* passwd, const char* apn);
  int16_t data_len_in_way(uint8_t ctx);//длина данных не подтверждённаѝ host'ом
  int16_t wait_data_len_in_way_acked(uint8_t ctx, uint16_t time_wait);//ждать пока данные не будут подтверждены хоѝтом
  int16_t con_state(uint8_t ctx);
  int16_t config_modem_tcpip_stack();
  int16_t jamming_detect_config(void);

  int16_t QuerySms(sms_inf_t* sms_inf);
  int16_t DeleteSms(uint8_t idx);
  int16_t ReadSmsConfig(void);
  int16_t ReadSms(uint8_t idx, char* sms_data, uint16_t sms_data_mem_size, uint8_t* is_emty, char* phone, uint8_t phone_mem_size, sms_udh_chunks_inf_t* chunks_inf);

  int16_t SendSmsInTextMode(const char *phone, char *sms, uint8_t is_ucs2, uint8_t* mem, uint16_t mem_size);

  int16_t SendUssdRequest(const char* phone, char* answer, const uint16_t answer_max_size);

  static int16_t tcp_data_transmit_mode(void);
  static int16_t tcp_polling_mode(void);
  static int16_t tcp_multiconn_mode(void);
  static int16_t tcp_or_bt_write(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len);
  static int16_t tcp_or_bt_write_chunk(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len, uint8_t eod_flag);
  static int16_t tcp_or_bt_read(uint8_t is_bt, uint8_t ctx, uint8_t *data_out, uint16_t len);

  int16_t select_default_sim(uint8_t default_sim);
  int16_t get_sim_status(uint8_t* default_sim, uint8_t* first_sim, uint8_t* second_sim);

  // API ��� ������ � sms
  /*
  todo
  int16_t SendSmsInPDU(char *phone, char *sms, uint8_t is_ucs2);
  int16_t SendSmsInTextMode(char *phone, char *sms, uint8_t is_ucs2);
  */
  int16_t operator_present_config(void);
  int16_t get_operator_list(void);
  int16_t manual_operator_select(const char* op_code);
  int16_t get_operator_inf(operator_inf_t* operator_inf);
  int16_t creg_urc_extended_mode(void);
  int16_t get_creg_state(creg_state_t* state, uint8_t force);
  int16_t get_ds_creg_state(creg_state_t* state_1, creg_state_t* state_2, uint8_t force);
  uint8_t get_rssi_level(void);
  jamming_state_t get_jamming_state(uint8_t is_reset_after_read);
  operate_modem_temp_status_t get_modem_temp_status(void);
  operate_modem_power_status_t get_modem_power_status(void);
  int16_t enable_modem_ext_temp_monitoring(void);
  int16_t get_software_inf(char* mem, uint16_t mem_size);

  //int16_t voice_call_config(void);
  int16_t voice_call_answer(void);
  int16_t voice_call_disconnect(void);
  int16_t get_call_state(call_state_t* call_state);
  int16_t voice_call(const char* phone);

  // Запроѝ imei
  // Пользватьѝѝ аккуратно, иѝпользует перенаправление потоков
  int16_t get_modem_imie(char mem[16], uint16_t mem_size);
  // Запроѝ производителѝ, модель и ревизию модема
  // Пользватьѝѝ аккуратно, иѝпользует перенаправление потоков
  int16_t get_modem_inf(char mem[14], uint16_t mem_size);
  // Запроѝ ICCID
  int16_t get_iccid(char mem[21], uint16_t mem_size);
  // Query the information of serving and neighbour cells
  int16_t get_cells_inf(char* mem, uint16_t mem_size);

  uint8_t get_sim_failure_status(void);
  int16_t soft_switch_off_modem(void);

  // Функции длѝ управлениѝ потоками
  void fwd_modem_rx_enabele(uint8_t* dst, uint16_t len);
  void fwd_modem_rx_disable(void);
  uint16_t get_fwd_recv_len(void);
  uint16_t wait_fwd_modem_rx_len(uint16_t len_wait, uint32_t time_wait);

  // Bluetooth API
  int16_t BtDisableSppAtMode(void);
  int16_t BtPower(uint8_t on_off);
  int16_t BtSppAcceptHandle(void);
  int16_t BtHfgAcceptHandle(void);
  int16_t BtHfgPairHandler(uint8_t cmd, const char mac[6], const char pin[4], uint8_t* state);
  uint8_t BtIsSppConnectExist(void);
  int16_t BtSetDevName(const char* name);
  int16_t BtVisibleMode(const uint8_t mode, const uint8_t time);
  int16_t SetPairingPinCode(const char* pin);
  int16_t BtSppRead(uint8_t ctx, uint8_t *data_out, uint16_t len);
  int16_t BtSppWrite(uint8_t ctx, uint8_t *data_out, uint16_t len);
  int16_t BtSppDisconnect(void);
  uint8_t BtIsSppConnectExist(void);
  uint8_t BtSppRecvDataSignal(void);
  int16_t Bt3Unpair(uint8_t dev_id);

  int16_t BtRegDeregGattClientLE(const uint8_t op, const uint16_t gclient_id);
  int16_t BtStartStopScanningLE(const uint8_t op, const uint16_t gclient_id);
  uint8_t GetScanTableLE(const bt_gat_scan_t* table[]);
  int16_t BtSetScanIntervalandScanWindow(uint16_t scan_interval, uint16_t scan_window, uint8_t is_ms);
  //int16_t BtVisibleMode(const uint8_t mode, uint8_t const time);
  //int16_t BtLEVisibleMode(const uint8_t op, const uint16_t gclient_id);
  int16_t SetBtLeTxPwr(const uint8_t tx_level);
  extern uint8_t IsBleMacScanIgnore(const uint8_t mac[6]);

  // Voice
  int16_t set_voice_call_mode(void);
  int16_t set_speaker_volume(uint8_t volume);
  int16_t set_mic_gain(uint8_t gain);
  int16_t echo_cancellation_control(uint16_t nlp, uint16_t aec, uint16_t nr, uint16_t ns);

  // Files
  int16_t m_fs_init(void);
  int16_t m_fopen(const char* fname, uint32_t* fctx, uint8_t fopt);
  int16_t m_fwrite(uint32_t fctx, uint8_t* data, uint16_t len);
  int16_t m_fseek(uint32_t fctx, uint32_t offset);
  int16_t m_fread(uint32_t fctx, uint8_t* data, uint16_t len);
  int16_t m_fclose(uint32_t fctx);
  int16_t m_fdelete(const char* fname);
  int16_t m_file_list(char* mem, uint16_t mem_size);
  int16_t m_storage_inf(char* mem, uint16_t mem_size);
  //int16_t m_open_files_list(char* mem, uint16_t mem_size);
  int16_t m_fsize(const char* fname, uint32_t* size, char* mem, uint16_t mem_size);

  //
  const char* get_act_verbose(uint8_t act);
  const char* get_reg_status_verbose(uint8_t reg_status);

  //for pdp deact watchdog
  uint8_t get_pdp_deact_event(void);
  void reset_pdp_deact_event(void);

  //ftp
  int parse_ftp_link(const char* link, char* username, char* password, char* server, char* path, char* file);
  int16_t m_ftp_open(const char* user, const char* pass, const char* addr);
  int16_t m_ftp_set_path(const char* path);
  int16_t m_get_ftp_state(uint8_t* state);
  const char* m_get_verbose_ftp_state(const uint8_t state);
  int16_t m_ftp_get_file_size(const char* file, uint32_t* fsize);
  int16_t m_ftp_open_file_for_read(const char* file);
  int16_t m_ftp_get_file_chunk(uint8_t* data, uint16_t chunk_len);
  int16_t m_ftp_close(void);

  //
  int16_t dtmf_config(void);
  int16_t modem_psave_mode_cfg(uint8_t mode);

  //external implementation
  void tcp_socket_new_data_recv(uint8_t ctx);
  void force_wakeup_if_sleep(void);
  void dtmf_recv_callback(char val);

  /* External variables --------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* __SIMCOM_MODEM_LIB_H */

