/**
******************************************************************************
* File Name          : saver2021_lib.h
* Description        :
*
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __SAVER2021_LIB_H
#define __SAVER2021_LIB_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <stdbool.h>

#pragma pack(1)

typedef struct
{
  uint8_t type:5;           // 0 - saver2021
  uint8_t interface_type:3; // 0 - выкл, 1 - RS232, 2 - RS485 (не используется), 3 - UART
}saver_settings_t;

typedef struct
{
  struct
  {
    uint8_t poll_state;           //Состояние опроса: 0 - отключен в настройках, 1 - ok, 2 - ошибка свзязи, 3 - внутренняя ошибка

    uint64_t sn;                  //Серийный номер блока управления
    uint16_t eng_rpm;             //Обороты двигателя, об/мин
    uint16_t sens_volt;           //Бортовое напряжение, В*10
    uint16_t map;                 //Давление впускного коллектора, атм*100
    uint16_t p_sys;               //Давление газа, атм*100
    int16_t t_red;                //Температура редуктора, С*10
    int16_t t_gas;                //Температура газа, С*10
    int16_t t_pcb;                //Температура PCB, С*10
    uint8_t load_petrol;          //Нагрузка бензиновых форсунок, %
    uint8_t load_gas;             //Нагрузка газовых форсунок, %
    uint8_t eng_load;             //Расчетная нагрузка на двигатель, %
    uint8_t ecu_state;            //Состояние блока управления: 0 - сон, 1 - зажигание, 2 - неисправность, 3 - бензин, 4 - ожидание, 5 - газ/отключен, 6... - неизвестно
    uint8_t tank_level_avg;       //Средний уровень в баке, В*10
    uint8_t dtc_count;            //Кол-во активных ошибок

    uint8_t ecu_reset_counter;    //Кол-во сбросов/запусков
    uint8_t emerg_starts_counter; //Кол-во аварийных запусков
    int16_t max_pcb_temp;         //Максимальная зарегистрированная температура PCB, С*10
    uint32_t working_on_petrol;   //Работа на бензине, с
    uint32_t working_on_gas;      //Работа на газе, с
    uint16_t distance_left;       //Расстояние до сервисного обслуживания, км

    //новые параметры добавлять только в конец!
  }main;

  char dtc[63];                   //Коды ошибок, формат: "Exxx/err_count/active_flag Eyyy/count/active_flag...", где err_count - кол-во ошибок, active_flag - флаг активности ошибки
                                  //"no DTC" - нет ошибок
}saver2021_state_t;

#pragma pack()

#ifdef __ICCARM__
typedef struct
{
  void (*set_param)(int baudrate, int timeout, const char* param_string);
  uint16_t (*txrx)(const uint8_t* sbuf, uint16_t slen, uint8_t* rbuf, uint16_t rlen);
  void (*lock)(void);
  void (*unlock)(void);
}saver2021_itf_driver_t;

typedef struct
{
  uint8_t* const rx_buff;
  uint16_t rx_buff_size;

  saver2021_state_t* const state;
  void (*state_lock_unlock)(const uint8_t is_lock);
}saver2021_pconst_t;

typedef struct
{
  uint32_t poll_timer;

  union
  {
    struct
    {
      uint8_t got_sys_info:1;
    };

    uint8_t flags;
  };

  const saver2021_pconst_t* const pconst;
  const saver2021_itf_driver_t* itf;
}saver2021_ctx_t;

int saver2121_handler(saver2021_ctx_t* const ctx);
#endif //ICCARM

#ifdef __cplusplus
}
#endif

#endif //__SAVER2021_LIB_H
