/**
******************************************************************************
* File Name          : can_vega_fwd.c
* Description        : 
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "serv_protocols_lib/can_vega_fwd.h"
#include "serv_protocol_handler_conf.h"
#include "cbuff/sfifo.h"

/* C code---------------------------------------------------------------------*/
#if !defined(FWD_CAN_SFIFO_TX_LEN)
#define FWD_CAN_SFIFO_TX_LEN          32
#endif //!defined(FWD_CAN_SFIFO_TX_LEN)

#if !defined(FWD_CAN_SFIFO_RX_LEN)
#define FWD_CAN_SFIFO_RX_LEN          64
#endif //!defined(FWD_CAN_SFIFO_RX_LEN)

/* Global variables-----------------------------------------------------------*/
static sfifo_t tx_fwd_sfifo;
static sfifo_t rx_fwd_sfifo;
static TVega_tx_can_frame tx_heap[FWD_CAN_SFIFO_TX_LEN];
static TVega_rx_can_frame rx_heap[FWD_CAN_SFIFO_RX_LEN];

void can_tx_fwd_sfifo_init(void)
{
  sfifo_init(&tx_fwd_sfifo, tx_heap, sizeof(tx_heap), sizeof(tx_heap[0]));
}

void can_rx_fwd_sfifo_init(void)
{
  sfifo_init(&rx_fwd_sfifo, rx_heap, sizeof(rx_heap), sizeof(rx_heap[0]));
}

uint16_t filled_count_in_tx_can_fwd_sfifo(void)
{
  return filled_count_in_sfifo(&tx_fwd_sfifo);
}

inline uint16_t filled_count_in_rx_can_fwd_sfifo(void)
{
  return filled_count_in_sfifo(&rx_fwd_sfifo);
}

inline void read_from_rx_can_fwd_sfifo(TVega_rx_can_frame* frame)
{
  read_from_sfifo(&rx_fwd_sfifo, frame);
}

inline void clean_rx_can_fwd_sfifo_from_reader(void)
{
  clean_sfifo_from_reader(&rx_fwd_sfifo);
}

void write_to_rx_can_fwd_sfifo(uint8_t can_id, const can_rx_frame_t* frame)
{
  if(!free_count_in_sfifo(&rx_fwd_sfifo)) return;
  
  TVega_rx_can_frame vega_frame;
  
  vega_frame.time=frame->time;
  vega_frame.id=frame->id;
  vega_frame.itf_idx=can_id;
  if(frame->id_type==EXT_ID_TYPE) {vega_frame.id_type=1;}
  else                            {vega_frame.id_type=0;}
  vega_frame.rtr=frame->rtr;
  vega_frame.reserved=0;
  vega_frame.dlen=frame->dlen;
  memcpy(vega_frame.data, frame->data, sizeof(vega_frame.data));
  
  write_to_sfifo(&rx_fwd_sfifo, &vega_frame);
  
  can_fwd_new_data_event(true);
}

void write_to_tx_can_fwd_sfifo(const TVega_tx_can_frame* frame)
{
  write_to_sfifo(&tx_fwd_sfifo, frame);
  can_fwd_new_data_event(false);
}

void read_from_tx_can_fwd_sfifo(uint8_t* can_id, can_tx_frame_t* frame)
{
  TVega_tx_can_frame vega_frame;

  read_from_sfifo(&tx_fwd_sfifo, &vega_frame);
  
  can_id[0]=vega_frame.itf_idx;
  frame->id=vega_frame.id;
  if(vega_frame.id_type) {frame->id_type=EXT_ID_TYPE;}
  else                   {frame->id_type=STD_ID_TYPE;}
  frame->rtr=vega_frame.rtr;
  frame->dlen=vega_frame.dlen;
  memcpy(frame->data, vega_frame.data, sizeof(frame->data));
 }
