/**
  ******************************************************************************
  * File Name          : can_vega_fwd.h
  * Description        :
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __CAN_VEGA_FWD_H
#define __CAN_VEGA_FWD_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include <stdint.h> 
#include <stdio.h>
#include <stdbool.h>

#include "can_signals/vega_can_typedefs.h"
#include "serv_protocols_lib/vega/vega_protocol.h"

void can_tx_fwd_sfifo_init(void);
void can_rx_fwd_sfifo_init(void);
uint16_t filled_count_in_tx_can_fwd_sfifo(void);
uint16_t filled_count_in_rx_can_fwd_sfifo(void);
void write_to_tx_can_fwd_sfifo(const TVega_tx_can_frame* frame);
void write_to_rx_can_fwd_sfifo(uint8_t can_id, const can_rx_frame_t* frame);
void read_from_tx_can_fwd_sfifo(uint8_t* can_id, can_tx_frame_t* frame);
void read_from_rx_can_fwd_sfifo(TVega_rx_can_frame* frame);
void clean_rx_can_fwd_sfifo_from_reader(void);
void can_fwd_new_data_event(const bool is_rx);
//void write_to_tx_can_fwd_direct(const uint8_t can_id, const can_tx_frame_t* frame);

#ifdef __cplusplus
}
#endif 

#endif /*__CAN_VEGA_FWD_H*/