/**
******************************************************************************
* File Name          : fast_data_upload.c
* Description        : 
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "serv_protocols_lib/fast_data_upload.h"
#include "serv_protocol_handler_conf.h"
#include "cbuff/sfifo.h"

/* C code---------------------------------------------------------------------*/
#define SFIFO_LEN          1024

/* Global variables-----------------------------------------------------------*/
static sfifo_t fast_data_sfifo;
static TVega_fast_data heap[SFIFO_LEN];

void fast_data_sfifo_init(void)
{
  sfifo_init(&fast_data_sfifo, heap, sizeof(heap), sizeof(heap[0]));
}

uint16_t filled_count_in_fast_data_sfifo(void)
{
  return filled_count_in_sfifo(&fast_data_sfifo);
}

void read_from_fast_data_sfifo(TVega_fast_data* data)
{
  read_from_sfifo(&fast_data_sfifo, data);
}

void clean_fast_data_sfifo_from_reader(void)
{
  clean_sfifo_from_reader(&fast_data_sfifo);
}

bool write_to_fast_data_sfifo(const TVega_fast_data* data)
{
  if(!free_count_in_sfifo(&fast_data_sfifo)) return false;
  
  write_to_sfifo(&fast_data_sfifo, data);
  
  return true;
}
