/**
  ******************************************************************************
  * File Name          : serv_protocol_common.h
  * Description        : 
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __SERV_PROTOCOL_COMMON_H
#define __SERV_PROTOCOL_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include "serv_protocol_handler_conf.h"
#include "serv_protocols_lib/protocols_err.h"
#include "serv_protocols_lib/wialon_text_can_cmd.h"

  typedef enum
  {
    INTERNAL_ERR_CSTATE=0,
    CONNECTED_CSTATE,
    DOWN_CSTATE,
    WAIT_CONNECTED_CSTATE,
  }cstate_t;
  
  typedef enum
  {
    BOOL_PARAM_TYPE=0,
    UINT8_PARAM_TYPE,
    INT8_PARAM_TYPE,
    UINT16_PARAM_TYPE,
    INT16_PARAM_TYPE,
    UINT32_PARAM_TYPE,
    INT32_PARAM_TYPE,
    UINT64_PARAM_TYPE,
    INT64_PARAM_TYPE,
    FLOAT_PARAM_TYPE,
    DOUBLE_PARAM_TYPE,
    STRING_PARAM_TYPE,
    ARRAY_PARAM_TYPE,
  }param_types_t;
  
  typedef enum
  {
    TOFACTORY_CMD_TYPE=1,
    BBOX_CLEAR_CMD_TYPE,
    MAKE_PHOTO_CMD_TYPE,
    SET_OUT_STATE,
    SET_EXT_OUT_STATE,
    SERVER_CFG_INFO,
    REBOOT_MODEM_CMD_TYPE,
    REBOOT_CMD_TYPE,
    GET_LAST_LOG_CHUNK_CMD_TYPE,
    CAN_CONTROL_CMD_TYPE, // wialon_text_can_cmd.h
    CAN_CONTROL_CMD_W_UUID_TYPE,
    REBOOT_GNSS_CMD_TYPE,
    STOP_CAN_SCRIPTS,
    RUN_CAN_SCRIPT,
    CHANGE_SIM_CARD_CMD_TYPE,
    UPD_BALANCE_CMD_TYPE,
    MAKE_DDD_FILE_CMD_TYPE,
    FTP_LINK_CMD_TYPE,
  }ext_cmd_t;
        
  typedef struct
  { 
    uint8_t pin;
    uint8_t state;
  }ext_cmd_set_out_param_t;
  
  typedef struct
  {
    uint32_t (*get_unix_time)                   (void); //        unix time
    
    int16_t  (*socket_write)                    (uint8_t conn_id, uint8_t* buff, uint16_t len);
    int16_t  (*socket_read)                     (uint8_t conn_id, uint8_t* buff, uint16_t len);
    int16_t  (*socket_open)                     (uint8_t conn_id, const char* addr);
    cstate_t (*socket_state)                    (uint8_t conn_id);
    int16_t  (*socket_close)                    (uint8_t conn_id);
    int16_t  (*socket_get_nack_len)             (uint8_t conn_id, uint32_t* naclen);
    
    void     (*grab_mess)                       (uint8_t type);
    void     (*release_mess)                    (uint8_t type);
    int8_t   (*get_mess_count)                  (uint8_t type, uint8_t receiver, uint32_t* mess_count);
    uint8_t* (*read_message)                    (uint8_t type, uint8_t receiver, uint16_t message_offset);
    int8_t   (*delete_messages)                 (uint8_t type, uint8_t receiver, uint8_t message_count);
    int8_t   (*get_message_param_name_type)     (uint16_t param_id, uint16_t* trans_param_id, const uint8_t* param_type_in_pack, const char** param_name, param_types_t* param_type, uint16_t* egts_param_id);
    
    int8_t    (*photo_inf)                      (uint8_t conn_id, const char** fname, uint32_t* size, uint32_t* time_stamp, uint8_t* busy_status);
    int8_t    (*photo_read_chunk)               (uint8_t conn_id, const char* fname, uint8_t* dst_buff, uint16_t read_len, uint32_t read_offset);
    int8_t    (*photo_delete)                   (uint8_t conn_id, const char* fname);
    int8_t    (*file_write_chunk)               (uint8_t conn_id, const char** fname, uint8_t* chunk, uint16_t chunk_len, uint8_t is_first_chunk, uint8_t is_cert_verify);
    void      (*file_downloaded_signal)         (uint8_t conn_id, const char** fname);
    int8_t    (*file_clean)                     (const char* fname);
    
    int8_t    (*file_read_chunk)                (uint8_t conn_id, const char* fname, uint32_t* fsize, uint8_t* dst_buff, uint16_t* readed_len , uint16_t req_len, uint32_t read_offset);
    
    int8_t    (*common_cmd_callback)            (uint8_t conn_id, ext_cmd_t cmd, uint8_t post_delay_in_seconds, const void* param);
    
#if defined(ITF_TRANSPORT_PRESENT)
    uint16_t (*itf_tx_rx_callback)              (const void* itf_header, uint8_t* tx_data, uint8_t* rx_data, uint16_t rx_len);
#endif //defined(ITF_TRANSPORT_PRESENT)
  
#if defined(CAN_VEGA_FWD_PRESENT)
    uint8_t (*is_can_fwd_enabled_callback)      (const uint8_t conn_id, uint32_t* const max_nack_len_for_send);
#endif //defined(CAN_VEGA_FWD_PRESENT)
    
#if defined(FASTDATA_PRESENT)
    uint8_t (*is_fastdata_fwd_enabled_callback) (const uint8_t conn_id, uint32_t* const max_nack_len_for_send);
#endif //defined(FASTDATA_PRESENT)
    
    const char* (*get_device_imei)              (void);
    
#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
    void (*got_valid_vega_packet)               (const uint8_t conn_id, const void* packet);
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
  }common_prot_const_t;

#ifdef __cplusplus
}
#endif 

#endif /*__SERV_PROTOCOL_COMMON_H*/