/**
******************************************************************************
* File Name          : serv_protocol_handler.c
* Description        : 
*                      
*                      
******************************************************************************
*/

#include "serv_protocols_lib/serv_protocol_handler.h"
#include "debug_port.h"

#if (!defined(USE_WIALON_PROTOCOL_LIB) &&  !defined(USE_EGTS_PROTOCOL_LIB) && !defined(USE_VEGA_PROTOCOL_LIB) && !defined(USE_NDTP_PROTOCOL_LIB) && !defined(USE_WIALON_BIN_PROTOCOL_LIB) && !defined(USE_TACHO_ARM_PROTOCOL_LIB) && !defined(USE_NAVIS_PROTOCOL_LIB))
#error     
#endif   

const char* const prot_type_name[]={"off", "vega", "egts", "egts_l1", "egts_l2", "wips", "ndtp", "teltonika", "wcombine", "tacho_arm", "navis"};
const uint16_t prot_type_name_cnt=sizeof(prot_type_name)/sizeof(const char* const);

static inline bool is_ble_conn_id(conn_ctx_t* ctx)
{
  if(ctx->conn_ctx_id==5 && ctx->conn_ctx_id==6) {return true;}
  else                                           {return false;}
}

void server_conn_handler(conn_ctx_t* ctx, char const* name)
{
  //    
  uint32_t timeout_after_next_session_MS=5000;
   
  for(;;)
  {
    if (ctx->protocol_type==VOID_PROTOCOL_TYPE) return;
    else if(!(ctx->protocol_type==EGTS_PROTOCOL_TYPE || ctx->protocol_type==EGTS_LIGHT_1_PROTOCOL_TYPE || ctx->protocol_type==EGTS_LIGHT_2_PROTOCOL_TYPE || ctx->protocol_type==WIALON_PROTOCOL_TYPE || ctx->protocol_type==NDTP_PROTOCOL_TYPE || ctx->protocol_type==VEGA_PROTOCOL_TYPE || ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE || ctx->protocol_type==TACHO_ARM_PROTOCOL_TYPE || ctx->protocol_type==NAVIS_PROTOCOL_TYPE)) 
    {
      if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("not support protocol type (%hhu) in server_conn_handler\n", ctx->protocol_type);}
      vTaskDelay(100);
      return;
    }
    
    if(ctx->server_ctx_state==WAIT_NEXT_SESSION)
    {
      if(timeAfter(xTaskGetTickCount(), ctx->start_next_session_timeMS))
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L && !is_ble_conn_id(ctx)) {__PRINTF("%s: %s, start new session...\n", name, ctx->server_ctx_name);}
        
        ctx->server_ctx_state=DO_CONNECTING;
      }
      else 
        return;
    }//end WAIT_NEXT_SESSION
    
    if(ctx->server_ctx_state==DO_CONNECTING)
    {
      if(ctx->common_const->socket_open(ctx->conn_ctx_id, ctx->server_addr)<0)
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L && !is_ble_conn_id(ctx)) {__PRINTF("%s: %s, open socket/conn from %s fail\n", name, ctx->server_ctx_name, ctx->server_addr);}
        if(ctx->conn_fail_counter<UINT16_MAX) ctx->conn_fail_counter++;
        break;//goto close conn and wait new session
      }
      else
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, open socket/conn from %s succes, wait connected\n", name, ctx->server_ctx_name, ctx->server_addr);}
        ctx->server_ctx_state=WAIT_CONNECTED;
        ctx->common_timer_1=WAIT_CONNECTING_TIMEOUT_MS+xTaskGetTickCount()-1;// 
        return;
      }
    }//end DO_CONNECTING  
    
    if(ctx->server_ctx_state==WAIT_CONNECTED)
    {
      cstate_t cstate;
      cstate=ctx->common_const->socket_state(ctx->conn_ctx_id);
      if(cstate==CONNECTED_CSTATE) 
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, connected ok\n", name, ctx->server_ctx_name);}
        ctx->common_timer_1=xTaskGetTickCount();
        ctx->server_ctx_state=DO_AUTORIZATION;
      }
      else if(cstate==DOWN_CSTATE || timeAfter(xTaskGetTickCount(), ctx->common_timer_1))        
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L && !is_ble_conn_id(ctx)) {__PRINTF("%s: %s, connected fail\n", name, ctx->server_ctx_name);}
        if(ctx->conn_fail_counter<UINT16_MAX) ctx->conn_fail_counter++;
        break;//goto close conn and wait new session
      }
      else return;
    }//end WAIT_CONNECTED
    
    if(ctx->server_ctx_state==DO_AUTORIZATION)
    {
      ctx->conn_fail_counter=0;
      //reset val
      ctx->prev_rx_buff_filled_len=0;
      //update keepalive timer
      ctx->end_keepalive_timeMS=ctx->keepalive_timeoutS*1000+xTaskGetTickCount()-1;
      ctx->server_ctx_state=CONTINUE_COMMUNICATION;
      
      int16_t res;
      if(0);
#if defined(USE_VEGA_PROTOCOL_LIB)
      else if(ctx->protocol_type==VEGA_PROTOCOL_TYPE)
      {
        if(!(ctx->protocol.vega.bbox_receiver<=4))
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, wrong bbox_receiver\n", name, ctx->server_ctx_name);}
          break;//goto close conn and wait new session
        }
        
        ctx->protocol.vega.common_const=ctx->common_const;
        ctx->protocol.vega.conn_ctx_id=ctx->conn_ctx_id;
        ctx->protocol.vega.rx_mem_size=ctx->rx_buff_size;
        VegaResetCtxState(&ctx->protocol.vega);
        
#if defined(VEGA_SECURE_PRESENT)
        //
#endif //defined(VEGA_SECURE_PRESENT)
        
#if defined(VEGA_ESECURE_PRESENT)
        ctx->protocol.vega.esecure=ctx->esecure;
        vega_esecure_init(ctx);
#endif //defined(VEGA_ESECURE_PRESENT)
        
        res=0;
      }
#endif //defined(USE_VEGA_PROTOCOL_LIB)
      
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
      else if(ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE)
      {
        if(!(ctx->protocol.wialon_bin.bbox_receiver<=4))
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, wrong bbox_receiver\n", name, ctx->server_ctx_name);}
          break;//goto close conn and wait new session
        }
        
        ctx->protocol.wialon_bin.common_const=ctx->common_const;
        ctx->protocol.wialon_bin.conn_ctx_id=ctx->conn_ctx_id;
        ctx->protocol.wialon_bin.rx_mem_size=ctx->rx_buff_size;
        WialonBinResetCtxState(&ctx->protocol.wialon_bin);
        res=WialonBinSendAuthRequest(&ctx->protocol.wialon_bin);
      }
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)
      
      if(res<0)
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
        break;//goto close conn and wait new session
      }
    }//end DO_AUTORIZATION
    
    if(ctx->server_ctx_state==CONTINUE_COMMUNICATION)
    {
      uint16_t free_len=ctx->rx_buff_size-ctx->prev_rx_buff_filled_len;
      if(free_len>1460) free_len=1460;
      int16_t recv_len = ctx->common_const->socket_read(ctx->conn_ctx_id, ctx->rx_buff+ctx->prev_rx_buff_filled_len, free_len);
      
#if defined(USE_VEGA_PROTOCOL_LIB)
#if defined(VEGA_SECURE_PRESENT)
      //
#endif //defined(VEGA_SECURE_PRESENT)
#endif //defined(USE_VEGA_PROTOCOL_LIB)
      
      if(recv_len==0)//  
      {
        if(timeAfter(xTaskGetTickCount(), ctx->end_keepalive_timeMS))
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, keepalive timer triggered\n", name, ctx->server_ctx_name);}
          break;//goto close conn and wait new session
        }
        
        if(ctx->connection_periodM)
        {
          uint8_t is_check_available_mess_for_end_session=0;
          uint8_t bbox_receiver;
          
          if(0);
#if defined(USE_VEGA_PROTOCOL_LIB)
          else if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && /*ctx->protocol.vega.is_wait_ping_ack && */ctx->protocol.vega.is_authenticated && ctx->protocol.vega.streaming_dwn.wait_data_len==0 && ctx->protocol.vega.dwn_wait_chunk_num==0 && !ctx->protocol.vega.bbox.is_wait_ack\
            //     MIN_SESSION_LIVE_BEFORE_END_SESSION_S 
            && timeAfter(xTaskGetTickCount(), ctx->common_timer_1+MIN_SESSION_LIVE_BEFORE_END_SESSION_S*1000-1))
          {
            bbox_receiver=ctx->protocol.vega.bbox_receiver;
            is_check_available_mess_for_end_session=1;
          }
#endif //defined(USE_VEGA_PROTOCOL_LIB)
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
          else if(ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE && /*ctx->protocol.wialon_bin.is_wait_ping_ack && */ctx->protocol.wialon_bin.is_authenticated && ctx->protocol.wialon_bin.dwn.wait_data_len==0 && !ctx->protocol.wialon_bin.bbox.is_wait_ack && !ctx->protocol.wialon_bin.upl.is_wait_ack \
            //     MIN_SESSION_LIVE_BEFORE_END_SESSION_S 
            && timeAfter(xTaskGetTickCount(), ctx->common_timer_1+MIN_SESSION_LIVE_BEFORE_END_SESSION_S*1000-1))
          {
            bbox_receiver=ctx->protocol.wialon_bin.bbox_receiver;
            is_check_available_mess_for_end_session=1;
          }
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)
          
          if(is_check_available_mess_for_end_session)
          {
            uint32_t available_mess=0;
            if(bbox_receiver!=0)
            {
              int8_t res;
              ctx->common_const->grab_mess(NULL);
              res=ctx->common_const->get_mess_count(NULL, bbox_receiver, &available_mess);
              ctx->common_const->release_mess(NULL);
              if(res<0)
              {
                if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(PROTOCOL_CTX_BBOX_ERR));}
                break;//goto close conn and wait new session
              }
            }
            
            if(available_mess<BBOX_MESS_COUNT_TH_FOR_END_SESSION)
            {
              timeout_after_next_session_MS=60*1000*ctx->connection_periodM;
              if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, end of session (next session will be upped after %hu minutes)\n", name, ctx->server_ctx_name, ctx->connection_periodM);}
              break;//goto close conn and wait new session
            }
          }
        }
      }
      else if(recv_len<0)//conn err
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, read from socket/conn err\n", name, ctx->server_ctx_name);}
        break;//goto close conn and wait new session
      }
      else//recv_len>0
      {
        uint16_t filled_len;
        int16_t processed_len;
        
        //update keepalive timer
        ctx->end_keepalive_timeMS=ctx->keepalive_timeoutS*1000+xTaskGetTickCount()-1;
        
        filled_len=recv_len+ctx->prev_rx_buff_filled_len;
        
        if(CONN_DEBUG_LEVEL==MDEBUG_L) {__PRINTF("%s: %s, recv %hu bytes, tot len in rx buff %hu bytes\n", name, ctx->server_ctx_name, recv_len, filled_len);}
        if(0);
        else
        {
          if(CONN_DEBUG_LEVEL>=HDEBUG_L) __BIN_BUFF_PRINTF(ctx->rx_buff, filled_len, "%s: %s, recv %hu bytes, tot len in rx buff %hu bytes\n", name, ctx->server_ctx_name, recv_len, filled_len);
        }
        
        if(0);
#if defined(USE_VEGA_PROTOCOL_LIB)
        else if (ctx->protocol_type==VEGA_PROTOCOL_TYPE)
        {
          bool is_skip_rx_processing=false;
          
#if defined(VEGA_SECURE_PRESENT)
          //
#endif //defined(VEGA_SECURE_PRESENT)
          
#if defined(VEGA_ESECURE_PRESENT)
          if(ctx->esecure!=NULL)
          {
            is_skip_rx_processing=true;
          }
#endif //defined(VEGA_ESECURE_PRESENT)
          
          if(!is_skip_rx_processing)
          {
            ctx->protocol.vega.parse_buff=ctx->rx_buff;
            ctx->protocol.vega.parse_len=filled_len;
            processed_len=VegaRxProcessing(&ctx->protocol.vega);
          }
          else
          {
            processed_len=0;
          }
          
#if defined(VEGA_ESECURE_PRESENT)
          if(ctx->esecure!=NULL)
          {
            processed_len=vega_esecure_rx(ctx, filled_len);
          }
#endif //defined(VEGA_ESECURE_PRESENT)
        }
#endif //defined(USE_VEGA_PROTOCOL_LIB)
        
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
        else if(ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE)
        {
          ctx->protocol.wialon_bin.parse_buff=ctx->rx_buff;
          ctx->protocol.wialon_bin.parse_len=filled_len;
          processed_len=WialonBinRxProcessing(&ctx->protocol.wialon_bin);
        }
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB) 
        
        if(processed_len<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(processed_len));}
          if(processed_len==PROTOCOL_CTX_AUTH_ERR) timeout_after_next_session_MS=30000; 
          break;//goto close conn and wait new session
        }
        else 
        {
          filled_len-=processed_len;
        }
        
        if(filled_len>=ctx->rx_buff_size)// 
        {        
          //if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, rx_buff ovflow...\n", name, ctx->server_ctx_name);}
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, rx_buff ovflow...\n", name, ctx->server_ctx_name);}
          break;//goto close conn and wait new session
        }
        else if(processed_len>0 && filled_len>0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, mem_move_to_head %hu bytes in rx_buff\n", name, ctx->server_ctx_name, filled_len);}
          mem_move_to_head(ctx->rx_buff, ctx->rx_buff+processed_len, filled_len);
          ctx->prev_rx_buff_filled_len=filled_len;
        }
        else if(filled_len>0)
        {
          ctx->prev_rx_buff_filled_len=filled_len;
        }
        else
        {
          ctx->prev_rx_buff_filled_len=0;
        }
      }
      
      if(0);
#if defined(USE_VEGA_PROTOCOL_LIB)
      else if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.streaming_dwn.wait_data_len && timeAfter(xTaskGetTickCount(), ctx->protocol.vega.streaming_dwn.last_recv_chunk_time+20000))
      {
        if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, streaming download timeout, close session...\n", name, ctx->server_ctx_name);}
        break;//goto close conn and wait new session
      }
      else if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.is_authenticated && ctx->protocol.vega.is_bbox_upload_enable && ctx->protocol.vega.streaming_dwn.wait_data_len==0)
      {//  vega           ( )
        if(!ctx->protocol.vega.bbox.is_wait_ack)
        {
          int16_t res;
          res=VegaBboxUploadHandle(&ctx->protocol.vega);
          if(res<0)
          {
            if(res==PROTOCOL_CTX_BBOX_ERR)
            {
              if(CONN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, %s in VegaBboxUploadHandler\n", name, ctx->server_ctx_name, prot_err_str(res));}
            }
            else
            {
              if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
            }
            break;//goto close conn and wait new session
          }
        }
        else if(ctx->protocol.vega.bbox.is_wait_ack && timeAfter(xTaskGetTickCount(), ctx->protocol.vega.bbox.end_wait_ack_time))
        {
          ctx->protocol.vega.bbox.not_ack_counter++;
          
          if(VEGA_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, we don't recv bbox ack (out_cnt=%hhu), not_ack_counter=%hhu\n", name, ctx->server_ctx_name, ctx->protocol.vega.bbox.mess_cnt_out, ctx->protocol.vega.bbox.not_ack_counter);}
          if(!ctx->protocol.vega.bbox.find_wrong_mess_fmt_mode && ctx->protocol.vega.bbox.not_ack_counter>=VEGA_MAX_SEND_ATT_MESS_IN_NORMAL_MODE)
          {
            if(VEGA_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, not_ack_counter is overflow (counter=%hhu), activate \"find wrong mess fmt mode\"\n", name, ctx->server_ctx_name, ctx->protocol.vega.bbox.not_ack_counter);}
            ctx->protocol.vega.bbox.find_wrong_mess_fmt_mode=1;
            ctx->protocol.vega.bbox.mess_counter_in_wrong_fmt_mode=ctx->protocol.vega.bbox.mess_cnt_out;
            ctx->protocol.vega.bbox.not_ack_counter=0;
          }
          else if(ctx->protocol.vega.bbox.find_wrong_mess_fmt_mode && ctx->protocol.vega.bbox.not_ack_counter>=VEGA_MAX_SEND_ATT_MESS_IN_EMERG_MODE)
          { 
            if(VEGA_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, not_ack_counter is overflow (counter=%hhu) in \"find wrong mess fmt mode\", deleting message...\n", name, ctx->server_ctx_name, ctx->protocol.vega.bbox.not_ack_counter);}
            
            ctx->common_const->grab_mess(NULL);
            if(ctx->protocol.vega.common_const->delete_messages(NULL, ctx->protocol.vega.bbox_receiver, 1)<0)
            {//      
              if(VEGA_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, bbox delete_messages fail\n", name, ctx->server_ctx_name);}
            }
            ctx->protocol.vega.common_const->release_mess(NULL); 
            
            ctx->protocol.vega.bbox.find_wrong_mess_fmt_mode=0;
            ctx->protocol.vega.bbox.not_ack_counter=0;
          }
          
          if(ctx->protocol.vega.bbox.is_wait_ack==2)//   ,   
          {
            ctx->protocol.vega.bbox.is_wait_ack=0;
          }
          else// "" 
          {
            timeout_after_next_session_MS=2000;
            break;//goto close conn and wait new session
          }
        }
      }
      
#if defined(USE_SERVER_NOTIFY_IN_VEGA)
      if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.is_authenticated && ctx->protocol.vega.streaming_dwn.wait_data_len==0)
      {
        int16_t res;
        res=VegaNotifiesUploadHandle(&ctx->protocol.vega);
        if(res<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
          break;//goto close conn and wait new session
        }
      }
#endif //defined(USE_SERVER_NOTIFY_IN_VEGA)
      
#if defined(CAN_VEGA_FWD_PRESENT)
      if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.is_authenticated && ctx->protocol.vega.streaming_dwn.wait_data_len==0)
      {
        int16_t res;
        res=VegaCanMessUploadHandle(&ctx->protocol.vega);
        if(res<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
          break;//goto close conn and wait new session
        }
      }
#endif //defined(CAN_VEGA_FWD_PRESENT)
      
#if defined(FASTDATA_PRESENT)
      if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.is_authenticated && ctx->protocol.vega.streaming_dwn.wait_data_len==0)
      {
        int16_t res;
        res=VegaFastDataUploadHandle(&ctx->protocol.vega);
        if(res<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
          break;//goto close conn and wait new session
        }
      }
#endif //defined(FASTDATA_PRESENT)
#endif //defined(USE_VEGA_PROTOCOL_LIB)
      
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
      else if(ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE && ctx->protocol.wialon_bin.is_authenticated && ctx->protocol.wialon_bin.dwn.wait_data_len==0)
      {//  wialon bin          
        uint32_t send_ping_timeMS;
        send_ping_timeMS=(ctx->keepalive_timeoutS*1000>2*WAIT_PING_ACK_TIMEOUT_MS) ? (ctx->end_keepalive_timeMS-WAIT_PING_ACK_TIMEOUT_MS) : (ctx->end_keepalive_timeMS-ctx->keepalive_timeoutS*(1000/2));
        if(ctx->protocol.wialon_bin.is_wait_ping_ack==0 && timeAfter(xTaskGetTickCount(), send_ping_timeMS))
        {
          if(CONN_DEBUG_LEVEL>=MDEBUG_L) {__PRINTF("%s: %s, sent ping packet\n", name, ctx->server_ctx_name);}
          
          int16_t res;
          res=WialonBinSendPing(&ctx->protocol.wialon_bin);
          if(res<0)
          {
            if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
            break;//goto close conn and wait new session
          }
          ctx->protocol.wialon_bin.is_wait_ping_ack=1;
        }
        
        if(!ctx->protocol.wialon_bin.bbox.is_wait_ack)
        {
          int16_t res;
          //res=WialonBinBboxUploadHandle(wialon_bin_ctx);
          res=WialonBinBboxUploadHandle(&ctx->protocol.wialon_bin);
          if(res<0)
          {
            if(res==PROTOCOL_CTX_BBOX_ERR)
            {
              if(CONN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, %s in WialonBinBboxUploadHandler\n", name, ctx->server_ctx_name, prot_err_str(res));}
            }
            else
            {
              if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
            }
            break;//goto close conn and wait new session
          }
        }
        else if(ctx->protocol.wialon_bin.bbox.is_wait_ack && timeAfter(xTaskGetTickCount(), ctx->protocol.wialon_bin.bbox.end_wait_ack_time))
        {
          ctx->protocol.wialon_bin.bbox.not_ack_counter++;
          
          if(WIALON_BIN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, we don't recv bbox ack (out_cnt=%hhu), not_ack_counter=%hhu\n", name, ctx->server_ctx_name, ctx->protocol.wialon_bin.bbox.mess_cnt_out, ctx->protocol.wialon_bin.bbox.not_ack_counter);}
          if(!ctx->protocol.wialon_bin.bbox.find_wrong_mess_fmt_mode && ctx->protocol.wialon_bin.bbox.not_ack_counter>=WIALON_BIN_MAX_SEND_ATT_MESS_IN_NORMAL_MODE)
          {
            if(WIALON_BIN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, not_ack_counter is overflow (counter=%hhu), activate \"find wrong mess fmt mode\"\n", name, ctx->server_ctx_name, ctx->protocol.wialon_bin.bbox.not_ack_counter);}
            ctx->protocol.wialon_bin.bbox.find_wrong_mess_fmt_mode=1;
            ctx->protocol.wialon_bin.bbox.mess_counter_in_wrong_fmt_mode=ctx->protocol.wialon_bin.bbox.mess_cnt_out;
            ctx->protocol.wialon_bin.bbox.not_ack_counter=0;
          }
          else if(ctx->protocol.wialon_bin.bbox.find_wrong_mess_fmt_mode && ctx->protocol.wialon_bin.bbox.not_ack_counter>=WIALON_BIN_MAX_SEND_ATT_MESS_IN_EMERG_MODE)
          { 
            if(WIALON_BIN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, not_ack_counter is overflow (counter=%hhu) in \"find wrong mess fmt mode\", deleting message...\n", name, ctx->server_ctx_name, ctx->protocol.wialon_bin.bbox.not_ack_counter);}

            ctx->common_const->grab_mess(NULL);
            if(ctx->protocol.wialon_bin.common_const->delete_messages(NULL, ctx->protocol.wialon_bin.bbox_receiver, 1)<0)
            {//      
              if(WIALON_BIN_DEBUG_LEVEL>=LDEBUG_L) {LOG("%s: %s, bbox delete_messages fail\n", name, ctx->server_ctx_name);}
            }
            ctx->protocol.wialon_bin.common_const->release_mess(NULL); 
            
            ctx->protocol.wialon_bin.bbox.find_wrong_mess_fmt_mode=0;
            ctx->protocol.wialon_bin.bbox.not_ack_counter=0;
          }
          
          if(ctx->protocol.wialon_bin.bbox.is_wait_ack==2)//   ,   
          {
            ctx->protocol.wialon_bin.bbox.is_wait_ack=0;
          }
          else// "" 
          {
            timeout_after_next_session_MS=2000;
            break;//goto close conn and wait new session
          }
        }
        
#if !defined(TINY_SERV_PROTOCOLS)
        int16_t res;
        res=WialonBinFileUploadHandle(&ctx->protocol.wialon_bin);
        if(res<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
          break;//goto close conn and wait new session
        }
        if(ctx->protocol.wialon_bin.upl.is_wait_ack && timeAfter(xTaskGetTickCount(), ctx->protocol.wialon_bin.upl.end_wait_ack_time))
        {
          if(WIALON_BIN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s,        ack  file upl\n", name, ctx->server_ctx_name);}
          break;//goto close conn and wait new session
        }
#endif //!defined(TINY_SERV_PROTOCOLS)
        
#if defined(USE_SERVER_NOTIFY_IN_WCOMBINE)
        res=WialonBinNotifiesUploadHandle(&ctx->protocol.wialon_bin);
        if(res<0)
        {
          if(CONN_DEBUG_LEVEL>=LDEBUG_L) {__PRINTF("%s: %s, %s\n", name, ctx->server_ctx_name, prot_err_str(res));}
          break;//goto close conn and wait new session
        }
#endif //defined(USE_SERVER_NOTIFY_IN_WCOMBINE)
      }
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)
    }//end CONTINUE_COMMUNICATION
    return;
  }//end for(;;)
  
//#warning for ble
  if(is_ble_conn_id(ctx)) timeout_after_next_session_MS=500;
  
  ctx->common_const->socket_close(ctx->conn_ctx_id);
  ctx->start_next_session_timeMS=timeout_after_next_session_MS+xTaskGetTickCount()-1;
  ctx->server_ctx_state=WAIT_NEXT_SESSION;
  return;
}

uint8_t server_conn_check_if_need_wakeup(conn_ctx_t* ctx)
{
  if (ctx->protocol_type==VOID_PROTOCOL_TYPE)
  {
    return 0;
  }
  
  if(ctx->server_ctx_state!=CONTINUE_COMMUNICATION)
  {
    return 0;
  }
    
  if(0);
  
#if defined(USE_WIALON_PROTOCOL_LIB)
  else if(ctx->protocol_type==WIALON_PROTOCOL_TYPE && ctx->protocol.wialon.is_authenticated && ctx->protocol.wialon.dwn.wait_data_len==0)
  {//  wialon         
    uint32_t send_ping_timeMS;
    send_ping_timeMS=(ctx->keepalive_timeoutS*1000>2*WAIT_PING_ACK_TIMEOUT_MS) ? (ctx->end_keepalive_timeMS-WAIT_PING_ACK_TIMEOUT_MS) : (ctx->end_keepalive_timeMS-ctx->keepalive_timeoutS*(1000/2));
    if(ctx->protocol.wialon.is_wait_ping_ack==0 && timeAfter(xTaskGetTickCount(), send_ping_timeMS))
    {
      return 1;
    }
  }
#endif //defined(USE_WIALON_PROTOCOL_LIB)
  
#if defined(USE_VEGA_PROTOCOL_LIB)
  else if(ctx->protocol_type==VEGA_PROTOCOL_TYPE && ctx->protocol.vega.is_authenticated && ctx->protocol.vega.is_bbox_upload_enable && ctx->protocol.vega.streaming_dwn.wait_data_len==0)
  {
    //todo
  }
#endif //defined(USE_VEGA_PROTOCOL_LIB)
  
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
  else if(ctx->protocol_type==WIALON_BIN_PROTOCOL_TYPE && ctx->protocol.wialon_bin.is_authenticated && ctx->protocol.wialon_bin.dwn.wait_data_len==0)
  {//  wialon bin          
    uint32_t send_ping_timeMS;
    send_ping_timeMS=(ctx->keepalive_timeoutS*1000>2*WAIT_PING_ACK_TIMEOUT_MS) ? (ctx->end_keepalive_timeMS-WAIT_PING_ACK_TIMEOUT_MS) : (ctx->end_keepalive_timeMS-ctx->keepalive_timeoutS*(1000/2));
    if(ctx->protocol.wialon_bin.is_wait_ping_ack==0 && timeAfter(xTaskGetTickCount(), send_ping_timeMS))
    {
      return 1;
    }
  }
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)
  
  return 0;
}