/**
  ******************************************************************************
  * File Name          : serv_protocol_handler.h
  * Description        : 
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __SERV_PROTOCOL_HANDLER_H
#define __SERV_PROTOCOL_HANDLER_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include <stdint.h>
#include <stdbool.h>
#include "serv_protocols_lib/serv_protocol_common.h"
#include "ext_string_lib/ext_string.h"
#include "time_utilities/time_utilities.h"

#include "serv_protocols_lib/vega/vega_protocol.h"

#if defined(USE_EGTS_PROTOCOL_LIB)
#include "serv_protocols_lib/egts/egts_protocol.h"
#endif //defined(USE_EGTS_PROTOCOL_LIB)

#if defined(USE_WIALON_PROTOCOL_LIB)
#include "serv_protocols_lib/wialon/wialon_protocol.h"
#endif //defined(USE_WIALON_PROTOCOL_LIB)

#if defined(USE_NDTP_PROTOCOL_LIB)
#include "serv_protocols_lib/ndtp/ndtp_protocol.h"
#include "serv_protocols_lib/ndtp/vega_to_ndtp.h"
#endif //defined(USE_NDTP_PROTOCOL_LIB)

#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
#include "serv_protocols_lib/wialon_binary/wialon_binary_protocol.h"
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)

#if defined(USE_TACHO_ARM_PROTOCOL_LIB)
#include "serv_protocols_lib/tacho_arm/tacho_arm_protocol.h"
#endif //defined(USE_TACHO_ARM_PROTOCOL_LIB)

#if defined(USE_NAVIS_PROTOCOL_LIB)
#include "serv_protocols_lib/navis/navis_protocol.h"
#endif //defined(USE_NAVIS_PROTOCOL_LIB)

  typedef union
  {
#if defined(USE_EGTS_PROTOCOL_LIB)
    egts_ctx_t egts; 
#endif //defined(USE_EGTS_PROTOCOL_LIB)
    
#if defined(USE_WIALON_PROTOCOL_LIB)
    wialon_ctx_t wialon; 
#endif //defined(USE_WIALON_PROTOCOL_LIB)
    
#if defined(USE_NDTP_PROTOCOL_LIB)
    ndtp_ctx_t ndtp; 
#endif //defined(USE_NDTP_PROTOCOL_LIB)
    
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
    wialon_bin_ctx_t wialon_bin; 
#endif //defined(USE_WIALON_BIN_PROTOCOL_LIB)
    
#if defined(USE_TACHO_ARM_PROTOCOL_LIB)
    tacho_arm_ctx_t tacho_arm; 
#endif //defined(USE_TACHO_ARM_PROTOCOL_LIB)
    
#if defined(USE_NAVIS_PROTOCOL_LIB)
    navis_ctx_t navis; 
#endif //defined(USE_NAVIS_PROTOCOL_LIB)
    
    vega_ctx_t vega;
  }serv_protocols_ctx_t;
  
  typedef enum
  {
    WAIT_NEXT_SESSION=0,
    DO_CONNECTING,
    WAIT_CONNECTED,          
    DO_AUTORIZATION,                       
    CONTINUE_COMMUNICATION,                  
  }server_ctx_state_t;
  
  typedef enum
  {
    VOID_PROTOCOL_TYPE=0,
    VEGA_PROTOCOL_TYPE,
    EGTS_PROTOCOL_TYPE,
    EGTS_LIGHT_1_PROTOCOL_TYPE,
    EGTS_LIGHT_2_PROTOCOL_TYPE,
    WIALON_PROTOCOL_TYPE,
    NDTP_PROTOCOL_TYPE,
    TELTONIKA_PROTOCOL_TYPE, 
    WIALON_BIN_PROTOCOL_TYPE,
    TACHO_ARM_PROTOCOL_TYPE,
    NAVIS_PROTOCOL_TYPE,
  }serv_ctx_prot_type_t;
  
  typedef struct
  {
    uint8_t*                    rx_buff;                        //    
    uint16_t                    rx_buff_size;                   //  
    uint16_t                    prev_rx_buff_filled_len;        //      
    
    uint16_t                    keepalive_timeoutS;             //      
    
    const char*                 server_addr;                    // ,    ip:port
    const char*                 server_ctx_name;                //    
    server_ctx_state_t          server_ctx_state;               // 
    uint8_t                     conn_ctx_id;                    //id 
    uint16_t                    conn_fail_counter;
    
    // 
    uint32_t                    common_timer_1;
    
    uint32_t                    start_next_session_timeMS;
    uint32_t                    end_keepalive_timeMS;        
    uint16_t                    connection_periodM;
    
    const common_prot_const_t*  common_const;                   //   
      
    serv_ctx_prot_type_t        protocol_type;                  // 
    serv_protocols_ctx_t        protocol;                       // ,     protocol_type

#if defined(VEGA_SECURE_PRESENT)
    vega_secure_ctx_t*          secure;
#endif //defined(VEGA_SECURE_PRESENT)
    
#if defined(VEGA_ESECURE_PRESENT)
    vega_esecure_ctx_t*         esecure;
#endif //defined(VEGA_ESECURE_PRESENT)
  }conn_ctx_t;

  void server_conn_handler(conn_ctx_t* ctx, char const* name);
  uint8_t server_conn_check_if_need_wakeup(conn_ctx_t* ctx);
  
#if defined(VEGA_SECURE_PRESENT)
  void vega_secure_init(conn_ctx_t* ctx);
  int16_t vega_secure_auth(conn_ctx_t* ctx, const uint16_t new_data_len);
  int16_t vega_secure_rx(conn_ctx_t* ctx, const uint16_t new_data_len);
#endif //defined(VEGA_SECURE_PRESENT)
  
#if defined(VEGA_ESECURE_PRESENT)
  void vega_esecure_init(conn_ctx_t* ctx);
  int16_t vega_esecure_rx(conn_ctx_t* ctx, uint16_t parse_len);
#endif //defined(VEGA_ESECURE_PRESENT)
  
  extern const char* const prot_type_name[];
  extern const uint16_t prot_type_name_cnt;
#ifdef __cplusplus
}
#endif 

#endif //__SERV_PROTOCOL_HANDLER_H
