/**
  ******************************************************************************
  * File Name          : server_notifies.h
  * Description        :
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __SERVER_NOTIFIES_H
#define __SERVER_NOTIFIES_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include <stdint.h> 
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>  
#include <stdbool.h>
  
typedef enum
{
  IN_PROCESS_NOTIFY_STATE    = 0x00,
  IS_LAST_NOTIFY_STATE       = 0x01,
  IS_BUSY_NOTIFY_STATE       = 0x02,  
  UNKNOWN_ARGS_NOTIFY_STATE  = 0x03,
  ERROR_NOTIFY_STATE         = 0x04,
}notify_state_t;
  
bool add_server_notify(const uint8_t server_id, const uint32_t notify_uid, const uint8_t nonce[8], const notify_state_t notify_state, const char* notify_mess, ...);
bool get_server_notify(const uint8_t server_id, uint32_t* notify_uid, const uint8_t* nonce[8], notify_state_t* notify_state, const char** notify_mess);
bool delete_server_notify(const uint8_t server_id);
void clear_server_notifies(const uint8_t server_id);
void init_server_notifies(void);

#ifdef __cplusplus
}
#endif 

#endif /*__SERVER_NOTIFIES_H*/