/**
  ******************************************************************************
  * File Name          : vega_protocol.h
  * Description        : Протокол обмена данными VEGA
  *
  *
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef VEGA_PROTOCOL_H
#define VEGA_PROTOCOL_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <string.h>
#include <drive/vega/lib/trunk/vega_libs/crc_lib/crc_lib.h>
#ifdef __ICCARM__
#include "serv_protocols_lib/serv_protocol_common.h"
#endif

/* defines ------------------------------------------------------------------*/
////// Текущее состояние датчиков //////////////////////////////////////////////
// Системные датчики
#define VEGA_DEVICE_TYPE             1	//Тип устройства
#define VEGA_MCU_FIRMWARE_VERSION    2	//Версия прошивки MCU
#define VEGA_GSM_FIRMWARE_VERSION    3	//Версия прошивки модема
#define VEGA_GPS_FIRMWARE_VERSION    4	//Версия прошивки GPS приемника
#define VEGA_DEVICE_IMEI             5	//IMEI
#define VEGA_DEVICE_SERIAL           6	//Серийный номер
#define VEGA_INPUT_BUFFER_SIZE       7	//Размер входящего буфера
#define VEGA_SIM_ICCID               8	//ICCID SIM карты
#define VEGA_UPTIME                  9	//Время с последнейперезагрузки
#define VEGA_UTC                     10	//Текущее время
#define VEGA_OPERATION_MODE          11	//Режим работы устройства
#define VEGA_PROTOCOL_VERSION        12	//Версия протокола обмена
#define VEGA_BB_MESSAGE_COUNT_1      13	//Количество записей в черном ящике 1
#define VEGA_BB_MESSAGE_COUNT_2      14	//Количество записей в черном ящике 2
#define VEGA_BB_MESSAGE_COUNT_3      15	//Количество записей в черном ящике 3
#define VEGA_BB_MESSAGE_COUNT_4      16	//Количество записей в черном ящике 4
#define VEGA_TCP_STATE1              17 //Состояние соединения 1
#define VEGA_TCP_STATE2              18 //Состояние соединения 2
#define VEGA_TCP_STATE3              19 //Состояние соединения 3
#define VEGA_TCP_STATE4              20 //Состояние соединения 4
#define VEGA_OUTPUT_BUFFER_SIZE      21	//Размер исходящего буфера
#define VEGA_SIM2_ICCID              22	//ICCID SIM карты 2
#define VEGA_PROD_TESTS_STATE        23 //Статус выполнения производственных тестов
#define VEGA_BOARD_HW_VERSION        24 //Версия платы (нумерация с нуля)
#define VEGA_MESSAGE_SRC_EVENT       25 //Источник формирования записи. //0 - точка трека, 1 - таймер, 2 - изменение параметра, 3 - сообщения для протокола NDTP. В таблице System отсутсвует.
#define VEGA_CMD_TEXT_ANS            26 //Текстовые ответы на команды для Григория CSAT SPB. В таблице System отсутсвует.
#define VEGA_PROMASAT_SERVICE        27 //Признак promasat service:3:promosat. В таблице System отсутсвует.

// additional sensors
#define VEGA_OVERALL_WEAR_CONDITION     1801 //flash + battery + ...
#define VEGA_FLASH_WEAR_CONDITION       1802 //maximum block cleaning time
//#define VEGA_BATTERY_WEAR_CONDITION     1803 //
///////////////////////////////////     1810 max
#define VEGA_CAN_1_LAST_ACTIVITY        1831 //
#define VEGA_CAN_2_LAST_ACTIVITY        1832 //
#define VEGA_CAN_3_LAST_ACTIVITY        1833 //

// Навигация
#define VEGA_LAT                101	//Широта
#define VEGA_LON                102	//Долгота
#define VEGA_SPEED              103	//Скорость
#define VEGA_DIR                104	//Курс
#define VEGA_ALT                105	//Высота
#define VEGA_HDOP               106	//HDOP
#define VEGA_PDOP               107	//PDOP
#define VEGA_VDOP               108	//VDOP
#define VEGA_GPS_INVIEW         109	//Видимых спутников GPS
#define VEGA_GLONASS_INVIEW     110	//Видимых спутников GLONASS
#define VEGA_TOTAL_SAT_INVIEW   111	//Видимых спутников всего
#define VEGA_SAT_USED           112	//Используемых спутников
#define VEGA_GPS_ODOMETER       113	//Одометр GPS
#define VEGA_GPS_MOVE_SENSOR    114	//Датчик движения GPS
#define VEGA_TRIP_COUNTER       115	//Счетчик поездок
#define VEGA_GPS_JAMMED         116	//Датчик глушения GPS (0 - норма, 1 - глушение)
#define VEGA_GEOZONE_1_ID       117     //ID первой геозоны
#define VEGA_GEOZONE_100_ID     217     //ID сотой геозоны
#define VEGA_GPS_SPOOF_SENSOR   218	//Датчик подмены GPS сигнала (Датчик подмены сигнала (0 - неизвестно или выключен, 1 - не обнаружено, 2 - подмена, 3 - множественная подмена)
#define VEGA_GPS_IS_ACTIVE      219	//Датчик активного состояния GPS приемника
#define VEGA_GALILEO_INVIEW     220	//Видимых спутников Galileo
#define VEGA_BEIDOU_INVIEW      221	//Видимых спутников BeiDou
#define VEGA_GNSS_RAW_STATE     222 //Стукртура основных датчиков GNSS без обработки
#define VEGA_USED_SAT_PRN       223	//PRN спутников, используемых в навигационном решении
#define VEGA_GPS_SAT_INFO       224	//Информация о видимых спутниках GPS
#define VEGA_GLONASS_SAT_INFO   225	//Информация о видимых спутниках GLONASS
#define VEGA_GALILEO_SAT_INFO   226	//Информация о видимых спутниках GALILEO
#define VEGA_BEIDOU_SAT_INFO    227	//Информация о видимых спутниках BEIDOU
#define VEGA_GPS_IS_VALID       228 //Достоверность координат GPS

#define VEGA_NRF_RELAY_ID               300 //ID радио реле
#define	VEGA_NRF_DESIRED_RELAY_STATE    301 //Заданное состояние реле (0 - выкл, 1 -вкл)
#define	VEGA_NRF_ACTUAL_RELAY_STATE     302 //Текущее состояние реле (0 - выкл, 1 -вкл, 0xff - неизвестно)
#define	VEGA_NRF_VISIBLE_MARKS_BF       303 //Битовое поле видимых меток
#define	VEGA_NRF_BATTLOW_MARKS_BF       304 //Битовое поле заряда батареек меток (0-ok, 1-замените батарейку)
#define	VEGA_NRF_MARK_ID_1              305 //ID радио метки 1
#define	VEGA_NRF_MARK_ID_2              306 //ID радио метки 2
#define	VEGA_NRF_MARK_ID_3              307 //ID радио метки 3
#define	VEGA_NRF_MARK_ID_4              308 //ID радио метки 4
#define	VEGA_NRF_MARK_ID_5              309 //ID радио метки 5
#define	VEGA_NRF_MARK_ID_6              310 //ID радио метки 6
#define	VEGA_NRF_MARK_ID_7              311 //ID радио метки 7
#define	VEGA_NRF_MARK_ID_8              312 //ID радио метки 8
#define	VEGA_NRF_MARK_ID_9              313 //ID радио метки 9
#define	VEGA_NRF_MARK_ID_10             314 //ID радио метки 10
#define VEGA_NRF_READY_FOR_COMMAND      315 //Cчитватель готов для принятия команды (0 - занят, 1 - готов для команды)

// Входы/выходы
#define VEGA_ANALOG_INPUT_1          1001    //Аналоговый вход 1
#define VEGA_ANALOG_INPUT_20         1020    //Аналоговый вход 20
#define VEGA_ANALOG_OUTPUT_1         1021    //Аналоговый выход 1
#define VEGA_ANALOG_OUTPUT_20        1040    //Аналоговый выход 20
#define VEGA_DIGITAL_INPUT_1         1041    //Цифровой вход 1
#define VEGA_DIGITAL_INPUT_20        1060    //Цифровой вход 20
#define VEGA_DIGITAL_OUTPUT_1        1061    //Цифровой выход 1
#define VEGA_DIGITAL_OUTPUT_20       1080    //Цифровой выход 20
#define VEGA_PULSE_INPUT_1           1081    //Импульсный вход 1
#define VEGA_PULSE_INPUT_20          1100    //Импульсный вход 20
#define VEGA_FREQ_INPUT_1            1101    //Частотный вход 1
#define VEGA_FREQ_INPUT_20           1120    //частотный вход 20
#define VEGA_FREQ_OUTPUT_1           1121    //Частотный выход 1
#define VEGA_FREQ_OUTPUT_20          1140    //частотный выход 20
#define VEGA_DUT_1                   1141    //Датчик уровня топлива 1
#define VEGA_DUT_10                  1150    //Датчик уровня топлива 10
#define VEGA_DUT_TEMP_1              1151    //Датчик уровня топлива 1, температура
#define VEGA_DUT_TEMP_10             1160    //Датчик уровня топлива 10, температура

#define NT_DOOR_STATE                1161 // Состояние дверей
#define NT_IN_BTN_STATE              1162 // Кнопка подтверждения
#define NT_V_SENS_STATE              1163 // Датчик объема
#define NT_A_START_STATE             1164 // Состояние автозапуска
#define NT_SOFT_MODE_STATE           1165 // Программный режим
#define NT_HARD_MODE_STATE           1166 // Аппаратный режим

#define VEGA_TCM_DTC_LIST_SENSOR     1166    //TCM Diagnostic trouble code
#define VEGA_YADRIVE_ALARM_SENSOR    1167    //Сигнализация, 0 - норма, 1 - сработка по водительской двери, 2 - по пассажирской, 3 - по задней левой, 4 - по задней правой, 5 - по капоту, 6 - по багажнику
#define VEGA_UNAUTHORIZED_START      1168    //Неавторизованный запуск двигателя
#define VEGA_CLS_STATE_SENSOR        1169    //Состояние окон
#define VEGA_WINDOWS_POSITION_SENSOR 1170    //Состояние центрального замка
#define VEGA_HANDBRAKE_DRIVE_SENSOR  1171    //Датчик езды на ручнике
#define AUDIO_FILE_SENSOR            1172    //Проигрываемый аудио файл, номер файла,
#define AUDIO_SCENARIO_SENSOR        1173    //Выполняемый аудио сценарий, номер сценария
#define VEGA_VIN_SENSOR              1174    //Vehicle identification number
#define VEGA_ECM_DTC_LIST_SENSOR     1175    //ECM Diagnostic trouble code
#define VEGA_CAN_EMERG_LIGHT_MODE    1176    //"Аварийка"
#define VEGA_CAN_ECO_MODE            1177    //Режим ECO
#define VEGA_CAN_WASHER_LIQUID       1178    //Датчик низкого уровня омывающей жидкости
#define VEGA_LAUNCH_SENSOR           1179    //Датчик Lauch
#define VEGA_DRIFT_SENSOR            1180    //Датчик Drift
#define VEGA_EXT_TEMP_SENSOR_1       1181    //Датчик температуры внешний 1
#define VEGA_EXT_TEMP_SENSOR_20      1200    //Датчик температуры внешний 20
#define VEGA_TAMPER_1                1201    //Датчик вскрытия 1
#define VEGA_TAMPER_20               1220    //Датчик вскрытия 20
#define VEGA_AXLE_LOAD_SENSOR_1      1221    //Датчик нагрузки на ось 1
#define VEGA_AXLE_LOAD_SENSOR_20     1240    //Датчик нагрузки на ось 20
#define VEGA_IGNITION                1241    //Зажигание
#define VEGA_GSENSOR_AXIS_X          1243    //Датчик оси акселерометра X
#define VEGA_GSENSOR_AXIS_Y          1244    //Датчик оси акселерометра Y
#define VEGA_GSENSOR_AXIS_Z          1245    //Датчик оси акселерометра Z
#define VEGA_GREEN_DRIVING           1246    //Датчик качества вождения
#define VEGA_CRASH                   1247    //Датчик аварии
#define VEGA_EVACUATION              1248    //Датчик эвакуации
#define VEGA_GSENSOR_MOVE_SENSOR     1249    //Датчик движения акселерометра
#define VEGA_INT_TEMP                1250    //Датчик температуры внутренний
#define VEGA_ALARM_BUTTON            1251    //Тревожная кнопка
#define VEGA_POWER_VOLTAGE           1252    //Датчик напряжения бортовой сети
#define VEGA_ACC_VOLTAGE             1253    //Датчик напряжения встроенного аккумулятора
#define VEGA_ACC_CHARGE              1255    //Датчик заряда встроенного аккумулятора
#define VEGA_AUTORIZED               1256    //Датчик авторизации
#define VEGA_AUTORIZED_KEY           1257    //Текущий авторизованный ключ
#define VEGA_MOTOHOURS               1258    //Датчик моточасов
#define VEGA_OW_CURRENT_KEY          1259    //Текущий ключ OneWire

#define VEGA_EXT_BR_STATUS           1260    //Состояние внешней платы расширения
#define VEGA_EXT_ANALOG_INPUT_1      1261    //Внешний аналоговый вход 1
#define VEGA_EXT_ANALOG_INPUT_20     1280    //Внешний аналоговый вход 20
#define VEGA_EXT_FREQ_INPUT_1        1281    //Внешний частотный вход 1
#define VEGA_EXT_FREQ_INPUT_20       1300    //Внешний частотный вход 20
#define VEGA_EXT_PULSE_INPUT_1       1301    //Внешний импульсный вход 1
#define VEGA_EXT_PULSE_INPUT_20      1320    //Внешний импульсный вход 20
#define VEGA_EXT_DIGITAL_INPUT_1     1321    //Внешний цифровой вход 1
#define VEGA_EXT_DIGITAL_INPUT_20    1340    //Внешний цифровой вход 20
#define VEGA_EXT_DIGITAL_OUTPUT_1    1341    //Внешний цифровой вход 1
#define VEGA_EXT_DIGITAL_OUTPUT_20   1360    //Внешний цифровой вход 20

// Терморегистратор Carrier Data cold 600
#define FRIDGE_COOMUNICATION_STATE              1401 //Cвязь с терморегистратором: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define FRIDGE_SERIAL                           1402 //Серийный номер терморегистратора
#define FRIDGE_AIN1_FLAGS                       1403 //Флаги аналогового входа 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN1_VALUE                       1404 //Показание аналогового входа 1
#define FRIDGE_AIN2_FLAGS                       1405 //Флаги аналогового входа 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN2_VALUE                       1406 //Показание аналогового входа 2
#define FRIDGE_AIN3_FLAGS                       1407 //Флаги аналогового входа 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN3_VALUE                       1408 //Показание аналогового входа 3
#define FRIDGE_AIN4_FLAGS                       1409 //Флаги аналогового входа 4: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN4_VALUE                       1410 //Показание аналогового входа 4
#define FRIDGE_AIN5_FLAGS                       1411 //Флаги аналогового входа 5: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN5_VALUE                       1412 //Показание аналогового входа 5
#define FRIDGE_AIN6_FLAGS                       1413 //Флаги аналогового входа 6: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AIN6_VALUE                       1414 //Показание аналогового входа 6
//reserve 5114-5125
#define FRIDGE_DIN1_FLAGS                       1415 //Флаги цифрового входа 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_DIN1_VALUE                       1416 //Показание цифрового входа 1
#define FRIDGE_DIN2_FLAGS                       1417 //Флаги цифрового входа 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_DIN2_VALUE                       1418 //Показание цифрового входа 2
#define FRIDGE_DIN3_FLAGS                       1419 //Флаги цифрового входа 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_DIN3_VALUE                       1420 //Показание цифрового входа 3
#define FRIDGE_DIN4_FLAGS                       1421 //Флаги цифрового входа 4: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_DIN4_VALUE                       1422 //Показание цифрового входа 4
//reserve 5134-5141
#define FRIDGE_RUN_MODE                         1423 //Рабочий режим: 0: start/stop (SS), 1: continuous, 2: cycle-sentry (CS), 7: неизввестно
#define FRIDGE_POWER_MODE                       1424 //Режим питания: 0: двигатель, 1: электрический (режим ожидания)
#define FRIDGE_SPEED_MODE                       1425 //Скоростной режим: 0: нормальный, 1: высокоскоростной
#define FRIDGE_BATTERY_FLAGS                    1426 //Флаги аккумулятора: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога, Bit 3: цифровой датчик(?не выводить)
#define FRIDGE_BATTERY_VALUE                    1427 //Напряжение аккумулятора
#define FRIDGE_FUEL_FLAGS                       1428 //Флаги уровня топлива: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога, Bit 3: цифровой датчик(?не выводить)
#define FRIDGE_FUEL_VALUE                       1429 //Уровень топлива, %
#define FRIDGE_ELECTRIC_HOURS_FLAGS             1430 //Флаги электро-часов: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_ELECTRIC_HOURS_VALUE             1431 //Электро-часы
#define FRIDGE_STANDBY_HOURS_FLAGS              1432 //Флаги часов в режиме ожидания: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_STANDBY_HOURS_VALUE              1433 //Время в режиме ожидания
#define FRIDGE_DIESEL_HOURS_FLAGS               1434 //Флаги дизель-часов: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_DIESEL_HOURS_VALUE               1435 //Дизель-часы
#define FRIDGE_MAINTENANCE1_FLAGS               1436 //Флаги часов сервисного обслуживания 1: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_MAINTENANCE1_VALUE               1437 //Часы сервисного обслуживания 1
#define FRIDGE_MAINTENANCE2_FLAGS               1438 //Флаги часов сервисного обслуживания 2: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_MAINTENANCE2_VALUE               1439 //Часы сервисного обслуживания 2
#define FRIDGE_MAINTENANCE3_FLAGS               1440 //Флаги часов сервисного обслуживания 3: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_MAINTENANCE3_VALUE               1441 //Часы сервисного обслуживания 3
#define FRIDGE_MAINTENANCE4_FLAGS               1442 //Флаги часов сервисного обслуживания 4: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_MAINTENANCE4_VALUE               1443 //Часы сервисного обслуживания 4
#define FRIDGE_MAINTENANCE5_FLAGS               1444 //Флаги часов сервисного обслуживания 5: Bit 0: наличие, Bit 1: ошибка, Bit 2: тревога
#define FRIDGE_MAINTENANCE5_VALUE               1445 //Часы сервисного обслуживания 5
#define FRIDGE_COMPAR1_STATE                    1446 //Состояние отсека 1: Bit 0: наличие, Bit 1: отсек включен, Bit 2: размораживание, Bit 3: в предстартовой проверке
#define FRIDGE_COMPAR1_MODE                     1447 //Режим отсека 1: 0: выкл, 1: нагрев, 2: охлаждение, 3: бездействие, 4: размораживание, 5: предрейсовая проверка, 15: неизвестно
#define FRIDGE_COMPAR1_SETPOINT_FLAGS           1448 //Флаги установленной температуры, отсек 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_SETPOINT_VALUE           1449 //Установленная температура, отсек 1
#define FRIDGE_COMPAR1_SUPPLY_AIR1_FLAGS        1450 //Флаги датчика приточного воздуха 1, отсека 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_SUPPLY_AIR1_VALUE        1451 //Показание датчика приточного воздуха 1, отсек 1
#define FRIDGE_COMPAR1_SUPPLY_AIR2_FLAGS        1452 //Флаги датчика приточного воздуха 2, отсека 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_SUPPLY_AIR2_VALUE        1453 //Показание датчика приточного воздуха 2, отсек 1
#define FRIDGE_COMPAR1_RETURN_AIR1_FLAGS        1454 //Флаги датчика отточного воздуха 1, отсека 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_RETURN_AIR1_VALUE        1455 //Показание датчика отточного воздуха 1, отсек 1
#define FRIDGE_COMPAR1_RETURN_AIR2_FLAGS        1456 //Флаги датчика отточного воздуха 2, отсека 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_RETURN_AIR2_VALUE        1457 //Показание датчика отточного воздуха 2, отсек 1
#define FRIDGE_COMPAR1_EVAPORATOR_FLAGS         1458 //Флаги датчика испарителя отсека 1: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR1_EVAPORATOR_VALUE         1459 //Показание датчика испарителя, отсек 1
#define FRIDGE_COMPAR2_STATE                    1460 //Состояние отсека 2: Bit 0: наличие, Bit 1: отсек включен, Bit 2: размораживание, Bit 3: в предстартовой проверке
#define FRIDGE_COMPAR2_MODE                     1461 //Режим отсека 2: 0: выкл, 1: нагрев, 2: охлаждение, 3: бездействие, 4: размораживание, 5: предрейсовая проверка, 15: неизвестно
#define FRIDGE_COMPAR2_SETPOINT_FLAGS           1462 //Флаги установленной температуры, отсек 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_SETPOINT_VALUE           1463 //Установленная температура, отсек 2
#define FRIDGE_COMPAR2_SUPPLY_AIR1_FLAGS        1464 //Флаги датчика приточного воздуха 1, отсека 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_SUPPLY_AIR1_VALUE        1465 //Показание датчика приточного воздуха 1, отсек 2
#define FRIDGE_COMPAR2_SUPPLY_AIR2_FLAGS        1466 //Флаги датчика приточного воздуха 2, отсека 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_SUPPLY_AIR2_VALUE        1467 //Показание датчика приточного воздуха 2, отсек 2
#define FRIDGE_COMPAR2_RETURN_AIR1_FLAGS        1468 //Флаги датчика отточного воздуха 1, отсека 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_RETURN_AIR1_VALUE        1469 //Показание датчика отточного воздуха 1, отсек 2
#define FRIDGE_COMPAR2_RETURN_AIR2_FLAGS        1470 //Флаги датчика отточного воздуха 2, отсека 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_RETURN_AIR2_VALUE        1471 //Показание датчика отточного воздуха 2, отсек 2
#define FRIDGE_COMPAR2_EVAPORATOR_FLAGS         1472 //Флаги датчика испарителя отсека 2: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR2_EVAPORATOR_VALUE         1473 //Показание датчика испарителя, отсек 2
//
#define FRIDGE_COMPAR3_STATE                    1474 //Состояние отсека 3: Bit 0: наличие, Bit 1: отсек включен, Bit 2: размораживание, Bit 3: в предстартовой проверке
#define FRIDGE_COMPAR3_MODE                     1475 //Режим отсека 3: 0: выкл, 1: нагрев, 2: охлаждение, 3: бездействие, 4: размораживание, 5: предрейсовая проверка, 15: неизвестно
#define FRIDGE_COMPAR3_SETPOINT_FLAGS           1476 //Флаги установленной температуры, отсек 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_SETPOINT_VALUE           1477 //Установленная температура, отсек 3
#define FRIDGE_COMPAR3_SUPPLY_AIR1_FLAGS        1478 //Флаги датчика приточного воздуха 1, отсека 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_SUPPLY_AIR1_VALUE        1479 //Показание датчика приточного воздуха 1, отсек 3
#define FRIDGE_COMPAR3_SUPPLY_AIR2_FLAGS        1480 //Флаги датчика приточного воздуха 2, отсека 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_SUPPLY_AIR2_VALUE        1481 //Показание датчика приточного воздуха 2, отсек 3
#define FRIDGE_COMPAR3_RETURN_AIR1_FLAGS        1482 //Флаги датчика отточного воздуха 1, отсека 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_RETURN_AIR1_VALUE        1483 //Показание датчика отточного воздуха 1, отсек 3
#define FRIDGE_COMPAR3_RETURN_AIR2_FLAGS        1484 //Флаги датчика отточного воздуха 2, отсека 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_RETURN_AIR2_VALUE        1485 //Показание датчика отточного воздуха 2, отсек 3
#define FRIDGE_COMPAR3_EVAPORATOR_FLAGS         1486 //Флаги датчика испарителя отсека 3: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_COMPAR3_EVAPORATOR_VALUE         1487 //Показание датчика испарителя, отсек 3
#define FRIDGE_AMBIENT_TEMP_FLAGS               1488 //Состояние датчика наружной температуры: Bit 0: вкл/выкл, Bit 1: валидность, Bit 2: тревога, Bit 3: ошибка
#define FRIDGE_AMBIENT_TEMP_VALUE               1489 //Показания датчика наружной температуры
//
#define FRIDGE_ALARM_LEVEL                      1490 //Уровень тревоги
#define FRIDGE_ALARM_CODE1                      1491 //Код тревоги 1
#define FRIDGE_ALARM_CODE2                      1492 //Код тревоги 2
#define FRIDGE_ALARM_CODE3                      1493 //Код тревоги 3
#define FRIDGE_ALARM_CODE4                      1494 //Код тревоги 4
#define FRIDGE_ALARM_CODE5                      1495 //Код тревоги 5
#define FRIDGE_ALARM_CODE6                      1496 //Код тревоги 6
#define FRIDGE_ALARM_CODE7                      1497 //Код тревоги 7
#define FRIDGE_ALARM_CODE8                      1498 //Код тревоги 8
#define FRIDGE_ALARM_CODE9                      1499 //Код тревоги 9
#define FRIDGE_ALARM_CODE10                     1500 //Код тревоги 10
#define FRIDGE_ALARM_CODE11                     1501 //Код тревоги 11
#define FRIDGE_ALARM_CODE12                     1502 //Код тревоги 12
#define FRIDGE_ALARM_CODE13                     1503 //Код тревоги 13
#define FRIDGE_ALARM_CODE14                     1504 //Код тревоги 14
#define FRIDGE_ALARM_CODE15                     1505 //Код тревоги 15
#define FRIDGE_ALARM_CODE16                     1506 //Код тревоги 16

///*
//Временно!!!
#define ATOM_COOMUNICATION_STATE                1500
#define ATOM_LAST_ERR                           1501
#define ATOM_IMAGE_PROBLEM_BF                   1502
#define ATOM_CAM_DISC_BF                        1503
#define ATOM_DOOR_1_IN                          1504
#define ATOM_DOOR_1_OUT                         1505
#define ATOM_DOOR_2_IN                          1506
#define ATOM_DOOR_2_OUT                         1507
#define ATOM_DOOR_3_IN                          1508
#define ATOM_DOOR_3_OUT                         1509
#define ATOM_VIDEO_TIMESTAMP                    1510
#define ATOM_FIX_TIMESTAMP                      1511
#define ATOM_VIDEO_ID                           1512
//*/

#define LORASENS_COOMUNICATION_STATE            1520 //Cвязь с блоком расширения беспроводных датчиков: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define LORASENS_TEMP_VALUE1                    1521 //Температура беспроводного датчика 1 (%)
#define LORASENS_EVENTS1                        1522 //Тревожные события беспроводного датчика 1: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога; bit 5, 6, 7 - идентификатор рабочей оси акселерометра 0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_RSSI1                          1523 //Уровень сигнала беспроводного датчика 1 (дБм)
#define LORASENS_ONLINE_STATUS1                 1524 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 1 (минуты)
#define LORASENS_CHARGE_LEVEL1                  1525 //Уровень заряда акб беспроводного датчика 1
#define LORASENS_TEMP_VALUE2                    1526 //Температура беспроводного датчика 2 (%)
#define LORASENS_EVENTS2                        1527 //Тревожные события беспроводного датчика 2: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI2                          1528 //Уровень сигнала беспроводного датчика 2 (дБм)
#define LORASENS_ONLINE_STATUS2                 1529 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 2 (минуты)
#define LORASENS_CHARGE_LEVEL2                  1530 //Уровень заряда акб беспроводного датчика 2
#define LORASENS_TEMP_VALUE3                    1531 //Температура беспроводного датчика 3 (%)
#define LORASENS_EVENTS3                        1532 //Тревожные события беспроводного датчика 3: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI3                          1533 //Уровень сигнала беспроводного датчика 3 (дБм)
#define LORASENS_ONLINE_STATUS3                 1534 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 3 (минуты)
#define LORASENS_CHARGE_LEVEL3                  1535 //Уровень заряда акб беспроводного датчика 3
#define LORASENS_TEMP_VALUE4                    1536 //Температура беспроводного датчика 4 (%)
#define LORASENS_EVENTS4                        1537 //Тревожные события беспроводного датчика 4: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI4                          1538 //Уровень сигнала беспроводного датчика 4 (дБм)
#define LORASENS_ONLINE_STATUS4                 1539 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 4 (минуты)
#define LORASENS_CHARGE_LEVEL4                  1540 //Уровень заряда акб беспроводного датчика 4
#define LORASENS_TEMP_VALUE5                    1541 //Температура беспроводного датчика 5 (%)
#define LORASENS_EVENTS5                        1542 //Тревожные события беспроводного датчика 5: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI5                          1543 //Уровень сигнала беспроводного датчика 5 (дБм)
#define LORASENS_ONLINE_STATUS5                 1544 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 5 (минуты)
#define LORASENS_CHARGE_LEVEL5                  1545 //Уровень заряда акб беспроводного датчика 5
#define LORASENS_TEMP_VALUE6                    1546 //Температура беспроводного датчика 6 (%)
#define LORASENS_EVENTS6                        1547 //Тревожные события беспроводного датчика 6: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI6                          1548 //Уровень сигнала беспроводного датчика 6 (дБм)
#define LORASENS_ONLINE_STATUS6                 1549 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 6 (минуты)
#define LORASENS_CHARGE_LEVEL6                  1550 //Уровень заряда акб беспроводного датчика 6
#define LORASENS_TEMP_VALUE7                    1551 //Температура беспроводного датчика 7 (%)
#define LORASENS_EVENTS7                        1552 //Тревожные события беспроводного датчика 7: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI7                          1553 //Уровень сигнала беспроводного датчика 7 (дБм)
#define LORASENS_ONLINE_STATUS7                 1554 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 7 (минуты)
#define LORASENS_CHARGE_LEVEL7                  1555 //Уровень заряда акб беспроводного датчика 7
#define LORASENS_TEMP_VALUE8                    1556 //Температура беспроводного датчика 8 (%)
#define LORASENS_EVENTS8                        1557 //Тревожные события беспроводного датчика 8: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI8                          1558 //Уровень сигнала беспроводного датчика 8 (дБм)
#define LORASENS_ONLINE_STATUS8                 1559 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 8 (минуты)
#define LORASENS_CHARGE_LEVEL8                  1560 //Уровень заряда акб беспроводного датчика 8
#define LORASENS_TEMP_VALUE9                    1561 //Температура беспроводного датчика 9 (%)
#define LORASENS_EVENTS9                        1562 //Тревожные события беспроводного датчика 9: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI9                          1563 //Уровень сигнала беспроводного датчика 9 (дБм)
#define LORASENS_ONLINE_STATUS9                 1564 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 9 (минуты)
#define LORASENS_CHARGE_LEVEL9                  1565 //Уровень заряда акб беспроводного датчика 9
#define LORASENS_TEMP_VALUE10                   1566 //Температура беспроводного датчика 10 (%)
#define LORASENS_EVENTS10                       1567 //Тревожные события беспроводного датчика 10: bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_RSSI10                         1568 //Уровень сигнала беспроводного датчика 10 (дБм)
#define LORASENS_ONLINE_STATUS10                1569 //Время, прошедшее с последнего радиообмена с беспроводным датчиком 10 (минуты)
#define LORASENS_CHARGE_LEVEL10                 1570 //Уровень заряда акб беспроводного датчика 10 (%)
#define LORASENS_VERSION1                       1571 //Версия прошивки беспроводного датчика 1
#define LORASENS_VERSION2                       1572 //Версия прошивки беспроводного датчика 2
#define LORASENS_VERSION3                       1573 //Версия прошивки беспроводного датчика 3
#define LORASENS_VERSION4                       1574 //Версия прошивки беспроводного датчика 4
#define LORASENS_VERSION5                       1575 //Версия прошивки беспроводного датчика 5
#define LORASENS_VERSION6                       1576 //Версия прошивки беспроводного датчика 6
#define LORASENS_VERSION7                       1577 //Версия прошивки беспроводного датчика 7
#define LORASENS_VERSION8                       1578 //Версия прошивки беспроводного датчика 8
#define LORASENS_VERSION9                       1579 //Версия прошивки беспроводного датчика 9
#define LORASENS_VERSION10                      1580 //Версия прошивки беспроводного датчика 10
#define LORASENS_COPROC_VERSION                 1581 //Версия прошивки сопроцессора беспроводных датчиков
#if (defined(EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT) || defined(IS_BEACON_LORA_BUILD))
#warning Используется пока только у Адвантум
//если включено то bit 5, 6, 7 - идентификатор рабочей оси акселерометра 0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z в LORASENS_EVENTSX сдесь.
#define LORASENS_AXIS1                          1582 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 1  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS2                          1583 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 2  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS3                          1584 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 3  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS4                          1585 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 4  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS5                          1586 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 5  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS6                          1587 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 6  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS7                          1588 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 7  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS8                          1589 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 8  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS9                          1590 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 9  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#define LORASENS_AXIS10                         1591 //bit 0 и 1 - идентификатор рабочей оси акселерометра датчика 10  0: ось не определена, 1: ось X, 2: ось Y, 3: ось Z.
#endif //EXTENDED_ADVANTUM_LORA_SENSORS_PRESENT

#define IQFREEZE_COOMUNICATION_STATE            1600 //Cвязь с IQFreeze: 0 - нет данных более заданного времени (по умолчанию 1 минута), 1 - данные есть, 2 - отключен  в настройках
#define IQFREEZE_MT                             1601 //Температура ХОУ, °С
#define IQFREEZE_T2                             1602 //Температура рефрижератора в секции 2, °С
#define IQFREEZE_T3                             1603 //Температура рефрижератора в секции 3, °С
#define IQFREEZE_SP                             1604 //Температура установленная, °С
#define IQFREEZE_SP2                            1605 //Температура установленная 2, °С
#define IQFREEZE_SP3                            1606 //Температура установленная 3, °С
#define IQFREEZE_AMBT                           1607 //Температура окр. воздуха, °С
#define IQFREEZE_AFZT                           1608 //Температура ОЖ, °С
#define IQFREEZE_RPM                            1609 //Обороты двигателя, об/мин
#define IQFREEZE_CONF                           1610 //Конфигурация компрессора (секция 1):  1 -  Start/Stop - режим с остановкой двигателя; 2 - Continuous - режим постоянной работы
#define IQFREEZE_STATE                          1611 //Состояние системы: 1 - Двигатель выключен; 2 - Нагрев; 3 - Охлаждение;4 - Оттайка
#define IQFREEZE_DR_BF                          1612 //Битовое поле состояний дверей секций: bit0 - Секция 1, bit1 - Секция 2, bit2 - Секция 3
#define IQFREEZE_BATV                           1613 //Напряжение аккумулятора, В
#define IQFREEZE_BATA                           1614 //Сила тока аккумулятора, А
#define IQFREEZE_HM                             1615 //Моточасы работы от двигателя, часы
#define IQFREEZE_HME                            1616 //Моточасы работы от сети, часы
#define IQFREEZE_REFSN                          1617 //Серийный номер установки
#define IQFREEZE_TRSN                           1618 //Серийный номер прицепа
#define IQFREEZE_ALCOUNT                        1619 //Количество ошибок
#define IQFREEZE_AL1                            1620 //Код самой важной ошибки
#define IQFREEZE_AL2                            1621 //Код 2й по важности ошибки
#define IQFREEZE_AL3                            1622 //Код 3й по важности ошибки
#define IQFREEZE_AL4                            1623 //Код 4й по важности ошибки
#define IQFREEZE_AL5                            1624 //Код 5й по важности ошибки
#define IQFREEZE_AL6                            1625 //Код 6й по важности ошибки
#define IQFREEZE_SN                             1626 //Серийный номер iQFreeze
#define IQFREEZE_VER                            1627 //Версия прошивки iQFreeze
#define IQFREEZE_REFTYPE                        1628 //Тип установки: 1 - Thermoking, 2 - Carier Supra\Maxima, 3 - Zanotti, 4 - Thermal Master, 5 - Carrier Vector (кроме 1350), 6 - Mitsubishi, 7 - Carrier Vector 1350
#define IQFREEZE_NO_CONNECT                     1629 //Отсутствие связи с ХОУ: 1 - связи нет; 0 - связь есть
#define IQFREEZE_ERR_BF                         1630 //Битовое поле ошибок: bit0 - Наличие ошибки на датчике 1, bit1 - Наличие ошибки на датчике 2, bit2 - Наличие ошибки на датчике 3, bit3 - Наличие ошибки на датчике 4, bit4 - Наличие ошибки на датчике 5, bit5 - Наличие ошибки на датчике 6, bit6 - Наличие ошибки на датчике влажности, bit7 - Наличие ошибки на внутренних часах
#define IQFREEZE_IN_BF                          1631 //Битовое поле дискретных входов:  bit0 - вход 1, bit1 - вход 2
#define IQFREEZE_HMT                            1632 //Моточасы общие, часы
#define IQFREEZE_LIC                            1633 //Тип лицензии 1 - PRO; 2 - STD; 3 - LITE
#define IQFREEZE_UPTIME                         1634 //Время с включения iQfreeze, с
//#define IQFREEZE_TEMP_PROBE                   1635 //Дискретный вх. 2. Аналоговый вход iQfreeze//убрать!!!
#define IQFREEZE_CONF2                          1635 //Конфигурация компрессора (секция 2): 1 - Start/Stop - режим с остановкой двигателя; 2 - Continuous - режим постоянной работы
#define IQFREEZE_CONF3                          1636 //Конфигурация компрессора (секция 3):  1 -  Start/Stop - режим с остановкой двигателя; 2 - Continuous - режим постоянной работы
#define IQFREEZE_STATE2                         1637 //Состояние системы (секция 2): 1 - Двигатель выключен; 2 - Нагрев; 3 - Охлаждение; 4 - Оттайка
#define IQFREEZE_STATE3                         1638 //Состояние системы (секция 3): 1 - Двигатель выключен; 2 - Нагрев; 3 - Охлаждение; 4 - Оттайка
#define IQFREEZE_AD1                            1639 //Данные с аналогового датчика температуры 1, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_AD2                            1640 //Данные с аналогового датчика температуры 2, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_AD3                            1641 //Данные с аналогового датчика температуры 3, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_AD4                            1642 //Данные с аналогового датчика температуры 4, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_AD5                            1643 //Данные с аналогового датчика температуры 5, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_AD6                            1644 //Данные с аналогового датчика температуры 6, либо код ошибки (0 - Аппаратная проблема; 1 - Температура выше 70 градусов по Цельсию, 2 - Температура ниже -30 градусов по Цельсию; 3 - Датчик отсутствует либо обрыв кабеля датчика; 4 - Короткое замыкание датчика; 5 - Аппаратная проблема датчика; 6 - Аппаратная проблема датчика)
#define IQFREEZE_HS                             1645 //Данные с датчик влажности
#define IQFREEZE_DEVTYPE                        1646 //Тип устройства iQFreeze: 1 - iQFreeze (без функционала регистратора); 2 - двухдатчиковый регистратор; 3 - шестидатчиковый регистратор
#define IQFREEZE_TIME                           1647 //Время по UTC (только в опорном кадре) (строка в формате чч:мм:сс ДД.ММ.ГГГГ)
#define IQFREEZE_VRN                            1648 //Гос. номер iQFreeze  (15 байт)
#define IQFREEZE_REGTIME                        1649 //Актуальное время регистрации последней записи (UTC) (строка в формате чч:мм:сс ДД.ММ.ГГГГ)
#define IQFREEZE_LAST_ID                        IQFREEZE_REGTIME

#define NRF_BEACONS_SCANNER_COMMUNICATION_STATE 1650 //Cвязь с NRF: 0 - нет данных, 1 - данные есть, 2 - отключен  в настройках
#define NRF_BEACONS_SCANNER_AUTORIZIED          1651 //Датчик авторизации NRF
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF1 1652 //Битовое поле 1, видимые NRF маяки 1-32
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF1 1653 //Битовое поле 1, низкий заряд батарейки, маяки 1-32
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF2 1654 //Битовое поле 2, видимые NRF маяки 33-64
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF2 1655 //Битовое поле 3, низкий заряд батарейки, маяки 33-64
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF3 1656 //Битовое поле 3, видимые NRF маяки 65-96
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF3 1657 //Битовое поле 3, низкий заряд батарейки, маяки 65-96
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF4 1658 //Битовое поле 4, видимые NRF маяки 97-128
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF4 1659 //Битовое поле 4, низкий заряд батарейки, маяки 97-128
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF5 1660 //Битовое поле 5, видимые NRF маяки 129-160
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF5 1661 //Битовое поле 5, низкий заряд батарейки, маяки 129-160
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF6 1662 //Битовое поле 6, видимые NRF маяки 161-192 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF6 1663 //Битовое поле 6, низкий заряд батарейки, маяки 161-192 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF7 1664 //Битовое поле 7, видимые NRF маяки 193-224 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF7 1665 //Битовое поле 7, низкий заряд батарейки, маяки 193-224 //пока custom!
//reserve
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_STR 1669 //Строка, видимые NRF маяки в формате XXXXXXXXYYYYYYYYZZZZZZZZ..., 0 - нет видимых меток

#define TENZO_M_WEIGHER_COMMUNICATION_STATE     1670 //Cвязь с весами: 0 - нет данных, 1 - данные есть, 2 - отключены  в настройках
#define TENZO_M_WEIGHER_NET_RAW                 1671 //Сырые данные веса нетто
#define TENZO_M_WEIGHER_GROSS_RAW               1672 //Сырые данные веса брутто

#define PV310_WEIGHER_COMMUNICATION_STATE       TENZO_M_WEIGHER_COMMUNICATION_STATE //Cвязь с весами: 0 - нет данных, 1 - данные есть, 2 - отключены  в настройках
#define PV310_WEIGHER_NET_RAW                   TENZO_M_WEIGHER_NET_RAW //Сырые данные веса

#define VEGA_KIMAX2_STRING                      1678//Строка данных со считвателя датчиков нагрузок на оси
#define VEGA_FMS_TCO1_VAL                       1679//Данные FMS TCO1
//данные CPC упаковываются в ЧЯ отдельно, через таблицу system осуществляется только передача по телематическим протоколам, эти параметры нельзя читать по протоколу Вега
#define VEGA_CONTI_CPC1                         1680//Данные CPC, PGN 0xFEF4
#define VEGA_CONTI_CPC2                         1681//Данные CPC, PGN 0xFC42
#define VEGA_CONTI_CPC3                         1682//Данные CPC, PGN 0xFE00
#define VEGA_CONTI_CPC4                         1683//Данные CPC, PGN 0xFF01
#define VEGA_CONTI_CPC5                         1684//Данные CPC, PGN 0xFF02
#define VEGA_CONTI_CPC6                         1685//Данные CPC, PGN 0xFF04

#define VEGA_CAN_DM1                            600
#define VEGA_LIAZ_FMS_1                         601//perv: 6001
#define VEGA_LIAZ_FMS_2                         602//perv: 6002
#define VEGA_LIAZ_FMS_3                         603//perv: 6003
#define VEGA_LIAZ_FMS_4                         604//perv: 6004
#define VEGA_LIAZ_FMS_5                         605//perv: 6005
#define VEGA_LIAZ_FMS_6                         606//perv: 6006
#define VEGA_LIAZ_FMS_7                         607//perv: 6007
#define VEGA_LIAZ_FMS_8                         608//perv: 6008

//временно!!!
#define VEGA_EXT_GSENS_COMM_STATE       1690
#define VEGA_EXT_GSENS_FLAGS            1691
#define VEGA_EXT_GSENS_MANEUVER_STR     1692

//временно!!!
#define VEGA_STRIZH_BS_COMM_STATE       1695
#define VEGA_STRIZH_BS_DATA             1696
// TOUCHPRINT THERMO KING
#define TOUCHPRINT_COOMUNICATION_STATE  1699 //Cвязь с терморегистратором TOUCHPRINT: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define TOUCHPRINT_AIN1_VALUE           1700    //TOUCHPRINT датчик температуры 1, °С
#define TOUCHPRINT_AIN2_VALUE           1701    //TOUCHPRINT датчик температуры 2, °С
#define TOUCHPRINT_AIN3_VALUE           1702    //TOUCHPRINT датчик температуры 3, °С
#define TOUCHPRINT_AIN4_VALUE           1703    //TOUCHPRINT датчик температуры 4, °С
#define TOUCHPRINT_AIN5_VALUE           1704    //TOUCHPRINT датчик температуры 5, °С
#define TOUCHPRINT_AIN6_VALUE           1705    //TOUCHPRINT датчик температуры 6, °С
#define TOUCHPRINT_DIN_VALUE            1706    //TOUCHPRINT цифровые входы 1..6:bit0 - вход1;bit1 - вход2;bit2 - вход3;bit3 - вход4;bit4 - вход5;bit5 - вход6;
#define TOUCHPRINT_HIN1_VALUE           1707    //TOUCHPRINT датчик влажности 1, %
#define TOUCHPRINT_HIN2_VALUE           1708    //TOUCHPRINT датчик влажности 2, %
#define TOUCHPRINT_HIN3_VALUE           1709    //TOUCHPRINT датчик влажности 3, %
#define TOUCHPRINT_HIN4_VALUE           1710    //TOUCHPRINT датчик влажности 4, %
#define TOUCHPRINT_HIN5_VALUE           1711    //TOUCHPRINT датчик влажности 5, %
#define TOUCHPRINT_HIN6_VALUE           1712    //TOUCHPRINT датчик влажности 6, %
#define TOUCHPRINT_IN1_CONF             1713    //TOUCHPRINT конфигурация входа 1: 0 - Disabled;1 - Switch (ON/OFF);2 - State (OPEN/CLOSE);3 - Open Door (OPEN/CLOSE);4 - Defrost (ON/OFF);5 - TK NTC;6 - Humidity sensor;7 - Reefer
#define TOUCHPRINT_IN2_CONF             1714    //TOUCHPRINT конфигурация входа 2
#define TOUCHPRINT_IN3_CONF             1715    //TOUCHPRINT конфигурация входа 3
#define TOUCHPRINT_IN4_CONF             1716    //TOUCHPRINT конфигурация входа 4
#define TOUCHPRINT_IN5_CONF             1717    //TOUCHPRINT конфигурация входа 5
#define TOUCHPRINT_IN6_CONF             1718    //TOUCHPRINT конфигурация входа 6
#define TOUCHPRINT_DSR_STATE            1719    //Состояние DSR: 0 - System in initialization;1 - Serial port not configured to work with VPRS.;2 - Variables value are valid.;3 - Timeout, variable not refreshed for more than 30 seconds
#define TOUCHPRINT_S1_PROBE             1720    //Датчик температуры щуп S1 , °С
#define TOUCHPRINT_S2_PROBE             1721    //Датчик температуры щуп S2 , °С
#define TOUCHPRINT_M_HOURS              1722    //Часы сервисного обслуживания, часы
#define TOUCHPRINT_T_HOURS              1723    //Общее время, часы
#define TOUCHPRINT_R_HOURS              1724    //Время в пути, часы
#define TOUCHPRINT_STBY_HOURS           1725    //Время в режиме ожидания, часы
#define TOUCHPRINT_ALRM_STATUS          1726    //Статусы тревог: bit0 - ALM_SOF Сбой программы;bit1 - ALM_OL Перегрузка электродвигателя;bit2 - ALM_DAL1 Отклонение температуры в 1-м отсеке;bit3 - ALM_DAL2 Отклонение температуры во 2-м отсеке;bit4 - ALM_ST1 Неисправность датчика температуры в 1-м отсеке;bit5 - ALM_ST2  Неисправность датчика температуры во 2-м отсеке;bit6 - ALM_SP1 Неисправен датчик высокого давления;bit7 - ALM_SV1 не исп-ся;bit8 - ALM_BAT Низкое Напряжение Батареи;bit9 - ALM_LP Сигнал о Падении Давления;bit10 - ALM_HP Сигнал о Превышении Давления;bit11 - ALM_TEP1 Сигнал тепловой защиты1;bit12 - ALM_TEP2 Сигнал тепловой защиты2;bit13 - ALM_DR1 Открыта дверь 1;bit14 - ALM_DR2 Открыта дверь 2;bit15 - ALM_BOTHVCC Включение зажигания при работе от электросети;
#define TOUCHPRINT_SET_POINT1           1727    //Установленная температура SP1 , °С
#define TOUCHPRINT_SET_POINT2           1728    //Установленная температура SP2 , °С
#define TOUCHPRINT_DSR_DINPUT           1729    //DSR цифровые входы 1 и 2: bit0 - DISTDBY electric standby; bit1 - DIACC on the road; bit2 -DIEX1 switch 1; bit3 - DIDSW1 door switch 1;bit4 - DIDK3 coil high temperature protection; bit5 - DIOL over load electric motor protector; bit6 - DILPCO low pressure cut-out switch; bit7 - DIDK1 defrost termination; bit8 - DIDSW2 door switch 2; bit9 - DIEX2 switch 2; bit10 - DIDK2 defrost termination; bit11 - DIDK4 coil high temperature protection; bit12 - DITH3 eutectic plates thermostat
#define TOUCHPRINT_DSR_STATUS           1730    //Статус DSR: 0 - turned off by the key; 1 - evacuation mode; 2 - manual off; 3 - alarm off; 4 - on, null; 5 - on, heat or cool; 6 - defrost; 7 - winter defrost
#define TOUCHPRINT_DSR_MODE_C1          1731    //Режим отсека 1: 0 - OFF;1 - HEAT;2 - COOL;3 - not used;4 - CYCLE;5 - IDLE;6 - not used;7 - DEFROST;8 - IDLE_C;9 - IDLE_H;10 - WINTER DEFROST;255 - Zone 1 Disable;
#define TOUCHPRINT_DSR_MODE_C2          1732    //Режим отсека 2: 0 - OFF;1 - HEAT;2 - COOL;3 - not used;4 - CYCLE;5 - IDLE;6 - not used;7 - DEFROST;8 - IDLE_C;9 - IDLE_H;10 - WINTER DEFROST;255 - Zone 1 Disable;
#define TOUCHPRINT_DOUT_STATE           1733    //DSR цифровые выходы 1,2,3,4: bit0 - relay 6; bit1 - relay 9; bit2 - relay 1; bit3 - relay 4; bit4 - relay 5; bit5 - relay 2; bit6 - relay 3; bit7 - relay 7; bit8 - relay 8; bit9 - relay 19; bit10 - relay 18; bit11 - relay 16; bit12 - relay 15; bit13 - relay 14; bit14 - relay 11; bit15 - relay 12; bit16 - relay 13; bit17 - relay 17; bit18 - relay 10
#define TOUCHPRINT_FMW_VERSION          1734    //Версия прошивки
#define TOUCHPRINT_FMW_RELEASE          1735    //Релиз прошивки

// i-BOX THERMO KING (48 параметров)
#define IBX_COOMUNICATION_STATE         1750    //Cвязь с i-BOX: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define IBX_FUEL_LEVEL                  1751    //Уровень топлива, в процентах  0.0 to 127.5% точность 0,5%, если >100 значение не действительно
#define IBX_BATTERY_POTENTIAL           1752    //Напряжение батареи, 0.0 to 3276.75V
#define IBX_SOFT_IDENT                  1753    //Идентификация программного обеспечения, ASCII
#define IBX_TOTAL_ELECTRIC_HOURS        1754    //Моточасы работы от сети,  Characters 1 - 4 = 0.0 to 214,748,364.8h
#define IBX_COMPONENT_IDENT             1755    //Идентификация марки, модели и серийного номера компонента.Characters specifying Make „TKING? for Thermo King Reefer Unit/Characters specifying Model Refers to reefer unit, Not used/Characters specifying Serial Number of reefer unit.
#define IBX_TOTAL_VEHICLE_HOURS         1756    //Моточасы работы автомобиля, Characters 1 - 4 = 0.0 to 214,748,364.8h
#define IBX_TOTAL_ENGINE_HOURS          1757    //Моточасы работы двигателя, Characters 1 - 4 = 0.0 to 214,748,364.8h
  //Trailer1 Zone1
#define IBX_T1_Z1_A_ZONES_ALRM_TYPE     1758    //Трейлер1 зона 1, активные зоны(0...15), тип тревоги (0...15); Bits 8-5: Active Zones 0000 – Not applicable/Not Reported,0001 – 1 Zone Only,0010 – 2 Active Zones, 0011 – 3 Active Zones и т.д.;Bits 4-1: Alarm Type: 00002 – No Alarm 00012 – Level 0 Alarm (Log-Stored / Routine Maintenance Required) 00102 – Level 1 Alarm (Low Fuel) 00112 – Level 2 Alarm (Maintenance Past Due) 01002 – Level 3 Alarm (Reserved for Future Use) 01012 – Level 4 Alarm (Reserved for Future Use) 01102 – Level 5 Alarm (Reserved for Future Use) 01112 – Level 6 Alarm (Reserved for Future Use) 10002 – Level 7 Alarm (Check / Immediate Attention Required) 10012 – Level 8 Alarm (Reserved for Future Use) 10102 – Level 9 Alarm (Reserved for Future Use) 10112 – Level 10 Alarm (Reserved for Future Use) 11002 – Level 11 Alarm (Reserved for Future Use) 11012 – Level 12 Alarm (Reserved for Future Use) 11102 – Level 13 Alarm (Reserved for Future Use) 11112 – Level 14 Alarm (Shutdown or Catastrophic System Failure)
#define IBX_T1_Z1_ALRM_CODE             1759    //Код аварийной сигнализации от 0 до 255 согласно 3rd Party Interface Software Design Specification Appendix E
                                                //1 = значение данных присутствует 0 = значение данных отсутствует / датчик не применяется. Если бит установлен в 0, то соответствующим ниже переменным будут присваиваться значения -150
#define IBX_T1_Z1_TEMP_SENSOR_ASSIGN    1760    //Настройки датчиков температуры  Bit8:RETURN_AIR1_TEMP; Bit7:SUPPLY1_TEMP; Bit6:TEMP_SETPOINT; Bit5:EVAPORATOR_COIL_TEMP; Bit4:RETURN_AIR2_TEMP; Bit3:SUPPLY2_TEMP; Bit2:OPERATING_MODE
#define IBX_T1_Z1_RETURN_AIR1_TEMP      1761    //Температура отточного воздуха 1 , °С
#define IBX_T1_Z1_SUPPLY1_TEMP          1762    //Температура приточного воздуха 1  , °С
#define IBX_T1_Z1_TEMP_SETPOINT         1763    //Установленная температура, °С
#define IBX_T1_Z1_EVAPORATOR_COIL_TEMP  1764    //Температура испарителя  , °С
#define IBX_T1_Z1_RETURN_AIR2_TEMP      1765    //Температура отточного воздуха 2 , °С
#define IBX_T1_Z1_SUPPLY2_TEMP          1766    //Температура приточного воздуха 2, °С
#define IBX_T1_Z1_OPERATING_MODE        1767    //Режим работы,циклический/продолжительный, High Speed / Door Status / Diesel vs. Electric; Bits 8-6: режим работы 000-питание выключено,001-охлаждение,010-нагрев,011-разморозка,100-недействительный(Null),101-предрейсовый(Pretrip),110-сон,111-реезерв; Bit5: 0-циклический/1-продолжительный режим; Bit4: 0- Engine is not in high speed 12 - Engine is in high speed; Bit3: 0 - Door Closed 1 - Door Open; Bit2: 0 - Diesel mode (default) 1- Electric mode; Bit1: -резерв
  //Trailer1 Zone2
#define IBX_T1_Z2_ALRM_TYPE             1768    //Трейлер1 зона 2, тип тревоги (0...15)Bits 4-1: Alarm Type: 00002 – No Alarm 00012 – Level 0 Alarm (Log-Stored / Routine Maintenance Required) 00102 – Level 1 Alarm (Low Fuel) 00112 – Level 2 Alarm (Maintenance Past Due) 01002 – Level 3 Alarm (Reserved for Future Use) 01012 – Level 4 Alarm (Reserved for Future Use) 01102 – Level 5 Alarm (Reserved for Future Use) 01112 – Level 6 Alarm (Reserved for Future Use) 10002 – Level 7 Alarm (Check / Immediate Attention Required) 10012 – Level 8 Alarm (Reserved for Future Use) 10102 – Level 9 Alarm (Reserved for Future Use) 10112 – Level 10 Alarm (Reserved for Future Use) 11002 – Level 11 Alarm (Reserved for Future Use) 11012 – Level 12 Alarm (Reserved for Future Use) 11102 – Level 13 Alarm (Reserved for Future Use) 11112 – Level 14 Alarm (Shutdown or Catastrophic System Failure)
#define IBX_T1_Z2_ALRM_CODE             1769    //Код аварийной сигнализации от 0 до 255 согласно 3rd Party Interface Software Design Specification Appendix E
                                                //1 = значение данных присутствует 0 = значение данных отсутствует / датчик не применяется. Если бит установлен в 0, то соответствующим ниже переменным будут присваиваться значения -150
#define IBX_T1_Z2_TEMP_SENSOR_ASSIGN    1770    //Настройки датчиков температуры  Bit8:RETURN_AIR1_TEMP; Bit7:SUPPLY1_TEMP; Bit6:SUPPLY1_TEMP; Bit5:TEMP_SETPOINT; Bit5:EVAPORATOR_COIL_TEMP; Bit4:RETURN_AIR2_TEMP; Bit3:SUPPLY2_TEMP; Bit2:OPERATING_MODE
#define IBX_T1_Z2_RETURN_AIR1_TEMP      1771    //Температура отточного воздуха 1 , °С
#define IBX_T1_Z2_SUPPLY1_TEMP          1772    //Температура приточного воздуха 1  , °С
#define IBX_T1_Z2_TEMP_SETPOINT         1773    //Установленная температура, °С
#define IBX_T1_Z2_EVAPORATOR_COIL_TEMP  1774    //Температура испарителя  , °С
#define IBX_T1_Z2_RETURN_AIR2_TEMP      1775    //Температура отточного воздуха 2 , °С
#define IBX_T1_Z2_SUPPLY2_TEMP          1776    //Температура приточного воздуха 2, °С
#define IBX_T1_Z2_OPERATING_MODE        1777    //Режим работы,циклический/продолжительный, High Speed / Door Status / Diesel vs. Electric; Bits 8-6: режим работы 000-пиатние выключено,001-охлаждение,010-нагрев,011-разморозка,100-недействительный(Null),101-предрейсовый(Pretrip),110-сон,111-реезерв; Bit5: 0-циклический/1-продолжительный режим; Bit4: 0- Engine is not in high speed 12 - Engine is in high speed; Bit3: 0 - Door Closed 1 - Door Open; Bit2: 0 - Diesel mode (default) 1- Electric mode; Bit1: -резерв
  //Trailer1 Zone3
#define IBX_T1_Z3_ALRM_TYPE             1778    //Трейлер1 зона 3, тип тревоги (0...15)Bits 4-1: Alarm Type: 00002 – No Alarm 00012 – Level 0 Alarm (Log-Stored / Routine Maintenance Required) 00102 – Level 1 Alarm (Low Fuel) 00112 – Level 2 Alarm (Maintenance Past Due) 01002 – Level 3 Alarm (Reserved for Future Use) 01012 – Level 4 Alarm (Reserved for Future Use) 01102 – Level 5 Alarm (Reserved for Future Use) 01112 – Level 6 Alarm (Reserved for Future Use) 10002 – Level 7 Alarm (Check / Immediate Attention Required) 10012 – Level 8 Alarm (Reserved for Future Use) 10102 – Level 9 Alarm (Reserved for Future Use) 10112 – Level 10 Alarm (Reserved for Future Use) 11002 – Level 11 Alarm (Reserved for Future Use) 11012 – Level 12 Alarm (Reserved for Future Use) 11102 – Level 13 Alarm (Reserved for Future Use) 11112 – Level 14 Alarm (Shutdown or Catastrophic System Failure)
#define IBX_T1_Z3_ALRM_CODE             1779    //Код аварийной сигнализации от 0 до 255 согласно 3rd Party Interface Software Design Specification Appendix E
                                                //1 = значение данных присутствует 0 = значение данных отсутствует / датчик не применяется. Если бит установлен в 0, то соответствующим ниже переменным будут присваиваться значения -150
#define IBX_T1_Z3_TEMP_SENSOR_ASSIGN    1780    //Настройки датчиков температуры  Bit8:RETURN_AIR1_TEMP; Bit7:SUPPLY1_TEMP; Bit6:SUPPLY1_TEMP; Bit5:TEMP_SETPOINT; Bit5:EVAPORATOR_COIL_TEMP; Bit4:RETURN_AIR2_TEMP; Bit3:SUPPLY2_TEMP; Bit2:OPERATING_MODE
#define IBX_T1_Z3_RETURN_AIR1_TEMP      1781    //Температура отточного воздуха 1 , °С
#define IBX_T1_Z3_SUPPLY1_TEMP          1782    //Температура приточного воздуха 1  , °С
#define IBX_T1_Z3_TEMP_SETPOINT         1783    //Установленная температура, °С
#define IBX_T1_Z3_EVAPORATOR_COIL_TEMP  1784    //Температура испарителя  , °С
#define IBX_T1_Z3_RETURN_AIR2_TEMP      1785    //Температура отточного воздуха 2 , °С
#define IBX_T1_Z3_SUPPLY2_TEMP          1786    //Температура приточного воздуха 2, °С
#define IBX_T1_Z3_OPERATING_MODE        1787    //Режим работы,циклический/продолжительный, High Speed / Door Status / Diesel vs. Electric; Bits 8-6: режим работы 000-пиатние выключено,001-охлаждение,010-нагрев,011-разморозка,100-недействительный(Null),101-предрейсовый(Pretrip),110-сон,111-реезерв; Bit5: 0-циклический/1-продолжительный режим; Bit4: 0- Engine is not in high speed 12 - Engine is in high speed; Bit3: 0 - Door Closed 1 - Door Open; Bit2: 0 - Diesel mode (default) 1- Electric mode; Bit1: -резерв
//DAS or Cargo Watch Sensors Information
#define IBX_T1_DIN0_3                   1788    //Флаги цифрового входов 0..3: 0-ошибка, 1-валидный  Bit8: Input0; Bit7: Input1; Bit6: Input2; Bit5: Input3;/Показание цифровых входв 0..3 Off = 0, ON = 1 Bit4: Input0; Bit3: Input1; Bit2: Input2; Bit1: Input3;
                                                //Биты, заданные в этом поле, определяют количество переменных, возвращаемых в ответных сообщениях ниже. Если бит установлен в 0, то соответствующие ответные сообщения не будут в этом PID и будут присваиваться значения -150
#define IBX_T1_SENSOR_ASSIGN            1789    //Настройки датчиков температуры/влажности/уровня топлива ON(1)/OFF(0) Bit8: SENSOR1; Bit7: SENSOR2;Bit6: SENSO3;Bit5: SENSOR4;Bit4: SENSOR5;Bit3:SENSOR6;Bit2: Humidity Sensor;Bit1: Fuel Level Sensor;
#define IBX_T1_TEMP_SENSOR1             1790    //Датчик температуры 1, °С
#define IBX_T1_TEMP_SENSOR2             1791    //Датчик температуры 2, °С
#define IBX_T1_TEMP_SENSOR3             1792    //Датчик температуры 3, °С
#define IBX_T1_TEMP_SENSOR4             1793    //Датчик температуры 4, °С
#define IBX_T1_TEMP_SENSOR5             1794    //Датчик температуры 5, °С Если датчик уровня топлива Fuel Level Sensor включен , SENSOR 5 не может быть включен
#define IBX_T1_TEMP_SENSOR6             1795    //Датчик температуры 6, °С Если датчик влажности Humidity Sensor включен, SENSOR 6 не может быть включен
#define IBX_T1_HUMIDITY_SENSOR          1796    //Датчик влажности (0 – 100 %) точность 0,5%, если >100 значение не действительно
#define IBX_T1_FUEL_LEVEL_SENSOR        1797    //Датчик уровня топлива в процентах, точность 0,5% если >100 значение не действительно
#define IBX_MID                         1798    //Идентификационный код сообщения: 147 Cargo Refrigeration/Heating, Trailer #1, 148 (Not Used)Cargo Refrigeration/Heating, Trailer #2, 149 (Not Used)Cargo Refrigeration/Heating, Trailer #3

#define FLOWMETER_COOMUNICATION_STATE  1801  //Cвязь с Delta RS: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define FLOWMETER_FUEL_VOLUME          1802  //Объем топлива от момента включения, л
#define FLOWMETER_FLOW_RATE            1803  //Текущая скорость потока, л/ч
#define FLOWMETER_STATUS               1804  //Статус"
#define FLOWMETER_FUEL_VOLUME_FC       1805  //Объем топлива камеры подачи от момента включения, л
#define FLOWMETER_FLOW_RATE_FC         1806  //Текущая скорость потока камеры подачи, л/ч
#define FLOWMETER_TEMP_FC              1807  //Температура камеры подачи, °С
#define FLOWMETER_FUEL_VOLUME_RC       1808  //Объем топлива камеры обратки от момента включения, л
#define FLOWMETER_FLOW_RATE_RC         1809  //Текущая скорость потока камеры обратки, л/ч
#define FLOWMETER_TEMP_RC              1810  //Температура камеры обратки, °С
#define FLOWMETER_ACC_FUEL_IDL         1811  //Накоп. объем топлива в режиме Холостой ход, л
#define FLOWMETER_ACC_FUEL_NOM         1812  //Накоп. объем топлива в режиме Номинальный,
#define FLOWMETER_ACC_FUEL_OVER        1813  //Накоп. объем топлива в режиме Перегрузка, л
#define FLOWMETER_ACC_FUEL_CH          1814  //Накоп. объем топлива в режиме Накрутка, л
#define FLOWMETER_ACC_FUEL_NEG         1815  //Накоп. объем топлива в режиме Отрицательный, л
#define FLOWMETER_ACC_FUEL_FC_IDL      1816  //Накоп. объем топлива камеры подачи в режиме Холостой ход, л
#define FLOWMETER_ACC_FUEL_FC_NOM      1817  //Накоп. объем топлива камеры подачи в режиме Номинальный, л
#define FLOWMETER_ACC_FUEL_FC_OV       1818  //Накоп. объем топлива камеры подачи в режиме Перегрузка, л
#define FLOWMETER_ACC_FUEL_FC_CH       1819  //Накоп. объем топлива камеры подачи в режиме Накрутка, л
#define FLOWMETER_ACC_FUEL_RC_IDL      1820  //Накоп. объем топлива камеры обратки в режиме Холостой ход, л
#define FLOWMETER_ACC_FUEL_RC_NOM      1821  //Накоп. объем топлива камеры обратки в режиме Номинальный, л
#define FLOWMETER_ACC_FUEL_RC_OV       1822  //Накоп. объем топлива камеры обратки в режиме Перегрузка, л
#define FLOWMETER_ACC_FUEL_RC_CH       1823  //Накоп. объем топлива камеры обратки в режиме Накрутка, л
#define FLOWMETER_TIME_IDL             1824  //Время нахождения в режиме Холостой ход, сек", "Time spent in idle, sec
#define FLOWMETER_TIME_NOM             1825  //Время нахождения в режиме Номинальный, сек
#define FLOWMETER_TIME_OV              1826  //Время нахождения в режиме Перегрузка, сек
#define FLOWMETER_TIME_CH              1827  //Время нахождения в режиме Накрутка, сек
#define FLOWMETER_TIME_NEG             1828  //Время нахождения в режиме Отрицательный, сек
#define FLOWMETER_TIME_FC_IDL          1829  //Время нахождения камеры подачи в режиме Холостой ход, сек
#define FLOWMETER_TIME_FC_NOM          1830  //Время нахождения камеры подачи в режиме Номинальный, сек
#define FLOWMETER_TIME_FC_OV           1831  //Время нахождения камеры подачи в режиме Перегрузка, сек
#define FLOWMETER_TIME_FC_CH           1832  //Время нахождения камеры подачи в режиме Накрутка, сек
#define FLOWMETER_TIME_RC_IDL          1833  //Время нахождения камеры обратки в режиме Холостой ход, сек
#define FLOWMETER_TIME_RC_NOM          1834  //Время нахождения камеры обратки в режиме Номинальный, сек
#define FLOWMETER_TIME_RC_OV           1835  //Время нахождения камеры обратки в режиме Перегрузка, сек
#define FLOWMETER_TIME_RC_CH           1836  //Время нахождения камеры обратки в режиме Накрутка, сек
#define FLOWMETER_TIME_INTERV          1837  //Время нахождения в режиме Вмешательство, сек
#define FLOWMETER_TIME_SENS            1838  //Время работы датчика, сек
#define FLOWMETER_SERIAL_NUM           1839  //Серийный номер прибора
#define FLOWMETER_DEVICE_TYPE          1840  //Тип прибора

#define TPMS_COMUNICATION_STATE         1801 //Cвязь с TPMS: 0 - нет данных более заданного времени (по умолчанию 1 минута), 1 - данные есть, 2 - отключен  в настройках
#define TPMS_ID1                        1802 //ID 1-я позиция колес
#define TPMS_PRESSURE1                  1803 //Давление Диапазон: 100-1400КРА (абсолютное)  Расчет: Относительное Давление=Р*5.5-101.3 КРА  если информация о давлении не поступает, Бит Данных будет 0хFF
#define TPMS_TEMPER1                    1804 //Температура Диапазон: -50° - +205°C  Расчет: Температура=Т-50 °С    Если информация о температуре не поступает, Бит Данных будет 0хFF
#define TPMS_FLAGS1                     1805 //флаги /Предупреждение о высоком/низком давлении (3 бита)/Предупреждение о высокой температуре (1 бит)/Предупреждение о быстрой утечке воздуха (1 бит)/Предупреждение о проблеме с датчиком (1 бит)
#define TPMS_ID2                        1806 //ID 2-я позиция колес
#define TPMS_PRESSURE2                  1807 //Давление 2-я позиция колес
#define TPMS_TEMPER2                    1808 //Температура 2-я позиция колес
#define TPMS_FLAGS2                     1809 //флаги 2-я позиция колес
#define TPMS_ID3                        1810 //ID 3-я позиция колес
#define TPMS_PRESSURE3                  1811 //Давление 3-я позиция колес
#define TPMS_TEMPER3                    1812 //Температура 3-я позиция колес
#define TPMS_FLAGS3                     1813 //флаги 3-я позиция колес
#define TPMS_ID4                        1814 //ID 4-я позиция колес
#define TPMS_PRESSURE4                  1815 //Давление 4-я позиция колес
#define TPMS_TEMPER4                    1816 //Температура 4-я позиция колес
#define TPMS_FLAGS4                     1817 //флаги 4-я позиция колес
#define TPMS_ID5                        1818 //...
#define TPMS_PRESSURE5                  1819 //...
#define TPMS_TEMPER5                    1820 //...
#define TPMS_FLAGS5                     1821 //...
#define TPMS_ID6                        1822
#define TPMS_PRESSURE6                  1823
#define TPMS_TEMPER6                    1824
#define TPMS_FLAGS6                     1825
#define TPMS_ID7                        1826
#define TPMS_PRESSURE7                  1827
#define TPMS_TEMPER7                    1828
#define TPMS_FLAGS7                     1829
#define TPMS_ID8                        1830
#define TPMS_PRESSURE8                  1831
#define TPMS_TEMPER8                    1832
#define TPMS_FLAGS8                     1833
#define TPMS_ID9                        1834
#define TPMS_PRESSURE9                  1835
#define TPMS_TEMPER9                    1836
#define TPMS_FLAGS9                     1837
#define TPMS_ID10                       1838
#define TPMS_PRESSURE10                 1839
#define TPMS_TEMPER10                   1840
#define TPMS_FLAGS10                    1841
#define TPMS_ID11                       1842
#define TPMS_PRESSURE11                 1843
#define TPMS_TEMPER11                   1844
#define TPMS_FLAGS11                    1845
#define TPMS_ID12                       1846
#define TPMS_PRESSURE12                 1847
#define TPMS_TEMPER12                   1848
#define TPMS_FLAGS12                    1849
#define TPMS_ID13                       1850
#define TPMS_PRESSURE13                 1851
#define TPMS_TEMPER13                   1852
#define TPMS_FLAGS13                    1853
#define TPMS_ID14                       1854
#define TPMS_PRESSURE14                 1855
#define TPMS_TEMPER14                   1856
#define TPMS_FLAGS14                    1857
#define TPMS_ID15                       1858
#define TPMS_PRESSURE15                 1859
#define TPMS_TEMPER15                   1860
#define TPMS_FLAGS15                    1861
#define TPMS_ID16                       1862
#define TPMS_PRESSURE16                 1863
#define TPMS_TEMPER16                   1864
#define TPMS_FLAGS16                    1865
#define TPMS_ID17                       1866
#define TPMS_PRESSURE17                 1867
#define TPMS_TEMPER17                   1868
#define TPMS_FLAGS17                    1869
#define TPMS_ID18                       1870
#define TPMS_PRESSURE18                 1871
#define TPMS_TEMPER18                   1872
#define TPMS_FLAGS18                    1873
#define TPMS_ID19                       1874
#define TPMS_PRESSURE19                 1875
#define TPMS_TEMPER19                   1876
#define TPMS_FLAGS19                    1877
#define TPMS_ID20                       1878
#define TPMS_PRESSURE20                 1879
#define TPMS_TEMPER20                   1880
#define TPMS_FLAGS20                    1881
#define TPMS_ID21                       1882
#define TPMS_PRESSURE21                 1883
#define TPMS_TEMPER21                   1884
#define TPMS_FLAGS21                    1885
#define TPMS_ID22                       1886
#define TPMS_PRESSURE22                 1887
#define TPMS_TEMPER22                   1888
#define TPMS_FLAGS22                    1889
#define TPMS_ID23                       1890
#define TPMS_PRESSURE23                 1891
#define TPMS_TEMPER23                   1892
#define TPMS_FLAGS23                    1893
#define TPMS_ID24                       1894
#define TPMS_PRESSURE24                 1895
#define TPMS_TEMPER24                   1896
#define TPMS_FLAGS24                    1897
#define TPMS_ID25                       1898
#define TPMS_PRESSURE25                 1899
#define TPMS_TEMPER25                   1900
#define TPMS_FLAGS25                    1901
#define TPMS_ID26                       1902
#define TPMS_PRESSURE26                 1903
#define TPMS_TEMPER26                   1904
#define TPMS_FLAGS26                    1905
#define TPMS_ID27                       1906
#define TPMS_PRESSURE27                 1907
#define TPMS_TEMPER27                   1908
#define TPMS_FLAGS27                    1909
#define TPMS_ID28                       1910
#define TPMS_PRESSURE28                 1911
#define TPMS_TEMPER28                   1912
#define TPMS_FLAGS28                    1913
#define TPMS_ID29                       1914
#define TPMS_PRESSURE29                 1915
#define TPMS_TEMPER29                   1916
#define TPMS_FLAGS29                    1917
#define TPMS_ID30                       1918
#define TPMS_PRESSURE30                 1919
#define TPMS_TEMPER30                   1920
#define TPMS_FLAGS30                    1921
#define TPMS_ID31                       1922
#define TPMS_PRESSURE31                 1923
#define TPMS_TEMPER31                   1924
#define TPMS_FLAGS31                    1925
#define TPMS_ID32                       1926
#define TPMS_PRESSURE32                 1927
#define TPMS_TEMPER32                   1928
#define TPMS_FLAGS32                    1929
#define TPMS_ID33                       1930
#define TPMS_PRESSURE33                 1931
#define TPMS_TEMPER33                   1932
#define TPMS_FLAGS33                    1933
#define TPMS_ID34                       1934
#define TPMS_PRESSURE34                 1935
#define TPMS_TEMPER34                   1936
#define TPMS_FLAGS34                    1937
#define TPMS_ID35                       1938
#define TPMS_PRESSURE35                 1939
#define TPMS_TEMPER35                   1940
#define TPMS_FLAGS35                    1941
#define TPMS_ID36                       1942
#define TPMS_PRESSURE36                 1943
#define TPMS_TEMPER36                   1944
#define TPMS_FLAGS36                    1945
#define TPMS_ID37                       1946
#define TPMS_PRESSURE37                 1947
#define TPMS_TEMPER37                   1948
#define TPMS_FLAGS37                    1949
#define TPMS_ID38                       1950
#define TPMS_PRESSURE38                 1951
#define TPMS_TEMPER38                   1952
#define TPMS_FLAGS38                    1953
#define TPMS_ID39                       1954
#define TPMS_PRESSURE39                 1955
#define TPMS_TEMPER39                   1956
#define TPMS_FLAGS39                    1957
#define TPMS_ID40                       1958
#define TPMS_PRESSURE40                 1959
#define TPMS_TEMPER40                   1960
#define TPMS_FLAGS40                    1961
#define TPMS_ID41                       1962
#define TPMS_PRESSURE41                 1963
#define TPMS_TEMPER41                   1964
#define TPMS_FLAGS41                    1965
#define TPMS_ID42                       1966 //ID 42-я позиция колес
#define TPMS_PRESSURE42                 1967 //Давление 42-я позиция колес
#define TPMS_TEMPER42                   1968 //Температура 42-я позиция колес
#define TPMS_FLAGS42                    1969 //флаги 42-я позиция колес
#define TPMS_LAST_ID                    TPMS_FLAGS42

#define IRIDIUM_COOMUNICATION_STATE     1979 //Cвязь с IRIDIUM: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define IRIDIUM_MESS_STATE              1980 //Попытка отправки через IRIDIUM успешна/неуспешна + код ошибки
#define IRIDIUM_TRAFFIC                 1981 //Передано байт на IRIDIUM

#define IAKM_COOMUNICATION_STATE        1983 //Cвязь с IAKM: 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define SCD30_COOMUNICATION_STATE       1984 //Cвязь с SCD30: 0 - не найден, 1 - найден, 2 - отключен  в настройках

#define DISPLAY_COOMUNICATION_STATE     1985 //Cвязь с OP320: 0 - не найден, 1 - найден, 2 - отключен  в настройках
// Сеть
#define VEGA_MCC                2001    //MCC
#define VEGA_MNC                2002    //MNC
#define VEGA_LAC                2003    //LAC
#define VEGA_CELLID             2004    //CELLID
#define VEGA_GSM_SIGNAL_LEVEL   2005    //Уровень сигнала
//#define VEGA_GSM_BALANCE      2006    //Баланс
#define VEGA_GSM_JAMMED         2007    //Датчик глушения GSM
#define VEGA_TX_DATA_SERV1      2008    //Сечтчик переданных данных для сервера 1
#define VEGA_TX_DATA_SERV2      2009    //Сечтчик переданных данных для сервера 2
#define VEGA_TX_DATA_SERV3      2010    //Сечтчик переданных данных для сервера 3
#define VEGA_TX_DATA_SERV4      2011    //Сечтчик переданных данных для сервера 4
#define VEGA_RX_DATA_SERV1      2012    //Сечтчик принятых данных для сервера 1
#define VEGA_RX_DATA_SERV2      2013    //Сечтчик принятых данных для сервера 2
#define VEGA_RX_DATA_SERV3      2014    //Сечтчик принятых данных для сервера 3
#define VEGA_RX_DATA_SERV4      2015    //Сечтчик принятых данных для сервера 4
#define VEGA_GSM_ACT            2016    //Технология доступа. GSM: 0, Unknown (reset state): 1, UTRAN: 2, GSM w/EGPRS: 3, UTRAN w/HSDPA: 4, UTRAN w/HSUPA: 5, UTRAN w/HSDPA and w/HSUPA: 6, E-UTRAN: 7
#define VEGA_EXT_SERVING_CELL_INF 2017  //Инженерная информация о базовых станциях GSM
#define VEGA_GSM_SCAN_MODE      2018    //Режим сканирования сети
#define VEGA_GSM_USED_SIM       2019    //Используемая симкарта, 0 - неизвестно, 1 - основная, 2 - резервная
#define VEGA_GSM_LBS            2020    //Набор параметров LBS
#define VEGA_GSM_SIM1_BALANCE   2021    //Баланс SIM1
#define VEGA_GSM_SIM2_BALANCE   2022    //Баланс SIM2

//bit 0 - цепь 1 0: замкнута 1: разомкнута; bit 1 - датчик Холла 1: 0: норма, 1: тревога; bit 2 - датчик Холла 2 0: норма, 1: тревога; bit 3 - датчик вскрытия корпуса 0: норма, 1: тревога; bit 4 - датчик отрыва 0: норма, 1: тревога
#define LORASENS_EVENTS1_0      2040    //Тревожные события беспроводного датчика 1  bit 0 - цепь
#define LORASENS_EVENTS1_1      2041    //Тревожные события беспроводного датчика 1  bit 1 - датчик Холла 1
#define LORASENS_EVENTS1_2      2042    //Тревожные события беспроводного датчика 1  bit 2 - датчик Холла 2
#define LORASENS_EVENTS1_3      2043    //Тревожные события беспроводного датчика 1  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS1_4      2044    //Тревожные события беспроводного датчика 1  bit 4 - датчик отрыва
#define LORASENS_EVENTS2_0      2045    //Тревожные события беспроводного датчика 2  bit 0 - цепь
#define LORASENS_EVENTS2_1      2046    //Тревожные события беспроводного датчика 2  bit 1 - датчик Холла 1
#define LORASENS_EVENTS2_2      2047    //Тревожные события беспроводного датчика 2  bit 2 - датчик Холла 2
#define LORASENS_EVENTS2_3      2048    //Тревожные события беспроводного датчика 2  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS2_4      2049    //Тревожные события беспроводного датчика 2  bit 4 - датчик отрыва
#define LORASENS_EVENTS3_0      2050    //Тревожные события беспроводного датчика 3  bit 0 - цепь
#define LORASENS_EVENTS3_1      2051    //Тревожные события беспроводного датчика 3  bit 1 - датчик Холла 1
#define LORASENS_EVENTS3_2      2052    //Тревожные события беспроводного датчика 3  bit 2 - датчик Холла 2
#define LORASENS_EVENTS3_3      2053    //Тревожные события беспроводного датчика 3  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS3_4      2054    //Тревожные события беспроводного датчика 3  bit 4 - датчик отрыва
#define LORASENS_EVENTS4_0      2055    //Тревожные события беспроводного датчика 4  bit 0 - цепь
#define LORASENS_EVENTS4_1      2056    //Тревожные события беспроводного датчика 4  bit 1 - датчик Холла 1
#define LORASENS_EVENTS4_2      2057    //Тревожные события беспроводного датчика 4  bit 2 - датчик Холла 2
#define LORASENS_EVENTS4_3      2058    //Тревожные события беспроводного датчика 4  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS4_4      2059    //Тревожные события беспроводного датчика 4  bit 4 - датчик отрыва
#define LORASENS_EVENTS5_0      2060    //Тревожные события беспроводного датчика 5  bit 0 - цепь
#define LORASENS_EVENTS5_1      2061    //Тревожные события беспроводного датчика 5  bit 1 - датчик Холла 1
#define LORASENS_EVENTS5_2      2062    //Тревожные события беспроводного датчика 5  bit 2 - датчик Холла 2
#define LORASENS_EVENTS5_3      2063    //Тревожные события беспроводного датчика 5  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS5_4      2064    //Тревожные события беспроводного датчика 5  bit 4 - датчик отрыва
#define LORASENS_EVENTS6_0      2065    //Тревожные события беспроводного датчика 6  bit 0 - цепь
#define LORASENS_EVENTS6_1      2066    //Тревожные события беспроводного датчика 6  bit 1 - датчик Холла 1
#define LORASENS_EVENTS6_2      2067    //Тревожные события беспроводного датчика 6  bit 2 - датчик Холла 2
#define LORASENS_EVENTS6_3      2068    //Тревожные события беспроводного датчика 6  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS6_4      2069    //Тревожные события беспроводного датчика 6  bit 4 - датчик отрыва
#define LORASENS_EVENTS7_0      2070    //Тревожные события беспроводного датчика 7  bit 0 - цепь
#define LORASENS_EVENTS7_1      2071    //Тревожные события беспроводного датчика 7  bit 1 - датчик Холла 1
#define LORASENS_EVENTS7_2      2072    //Тревожные события беспроводного датчика 7  bit 2 - датчик Холла 2
#define LORASENS_EVENTS7_3      2073    //Тревожные события беспроводного датчика 7  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS7_4      2074    //Тревожные события беспроводного датчика 7  bit 4 - датчик отрыва
#define LORASENS_EVENTS8_0      2075    //Тревожные события беспроводного датчика 8  bit 0 - цепь
#define LORASENS_EVENTS8_1      2076    //Тревожные события беспроводного датчика 8  bit 1 - датчик Холла 1
#define LORASENS_EVENTS8_2      2077    //Тревожные события беспроводного датчика 8  bit 2 - датчик Холла 2
#define LORASENS_EVENTS8_3      2078    //Тревожные события беспроводного датчика 8  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS8_4      2079    //Тревожные события беспроводного датчика 8  bit 4 - датчик отрыва
#define LORASENS_EVENTS9_0      2080    //Тревожные события беспроводного датчика 9  bit 0 - цепь
#define LORASENS_EVENTS9_1      2081    //Тревожные события беспроводного датчика 9  bit 1 - датчик Холла 1
#define LORASENS_EVENTS9_2      2082    //Тревожные события беспроводного датчика 9  bit 2 - датчик Холла 2
#define LORASENS_EVENTS9_3      2083    //Тревожные события беспроводного датчика 9  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS9_4      2084    //Тревожные события беспроводного датчика 9  bit 4 - датчик отрыва
#define LORASENS_EVENTS10_0     2085    //Тревожные события беспроводного датчика 10  bit 0 - цепь
#define LORASENS_EVENTS10_1     2086    //Тревожные события беспроводного датчика 10  bit 1 - датчик Холла 1
#define LORASENS_EVENTS10_2     2087    //Тревожные события беспроводного датчика 10  bit 2 - датчик Холла 2
#define LORASENS_EVENTS10_3     2088    //Тревожные события беспроводного датчика 10  bit 3 - датчик вскрытия корпуса
#define LORASENS_EVENTS10_4     2089    //Тревожные события беспроводного датчика 10  bit 4 - датчик отрыва
#define LORASENS_HUM_VALUE1     2090    //Влажность беспроводного датчика 1 (%)
#define LORASENS_HUM_VALUE2     2091    //Влажность беспроводного датчика 2 (%)
#define LORASENS_HUM_VALUE3     2092    //Влажность беспроводного датчика 3 (%)
#define LORASENS_HUM_VALUE4     2093    //Влажность беспроводного датчика 4 (%)
#define LORASENS_HUM_VALUE5     2094    //Влажность беспроводного датчика 5 (%)
#define LORASENS_HUM_VALUE6     2095    //Влажность беспроводного датчика 6 (%)
#define LORASENS_HUM_VALUE7     2096    //Влажность беспроводного датчика 7 (%)
#define LORASENS_HUM_VALUE8     2097    //Влажность беспроводного датчика 8 (%)
#define LORASENS_HUM_VALUE9     2098    //Влажность беспроводного датчика 9 (%)
#define LORASENS_HUM_VALUE10    2099    //Влажность беспроводного датчика 10 (%)

// CAN
// Общие
#define CAN_NUMERIC_FIRST_ID    2101	//Первый ID числовых параметров CAN
#define CAN_ENGNE_UPTIME        2101	//Суммарное время работы двигателя, минуты
#define CAN_ENGINE_UPTIME_P     2102	//Суммарное время работы двигателя (до сброса), минуты
#define CAN_ODOMETER_KM         2103	//Полный пробег транспортного средства, км
#define CAN_ODOMETER_P          2104	//Полный пробег транспортного средства (до сброса), км
#define CAN_CONSUMED_FUEL_L     2105	//Общее потребление топлива, л
#define CAN_CONSUMED_FUEL_P     2106	//Общее потребление топлива (до сброса), л
#define CAN_FUEL_LEVEL_P        2107	//Уровень топлива, в процентах
#define CAN_FUEL_LEVEL_L        2108	//Уровень топлива, в литрах
#define CAN_ENGINE_RPM          2109	//Обороты двигателя RPM
#define CAN_ENGINE_TEMP         2110	//Температура двигателя
#define CAN_SPEED               2111	//Скорость транспортного средства
#define CAN_AXLE_1              2112	//Нагрузка на ось 1, кг
#define CAN_AXLE_2              2113	//Нагрузка на ось 2, кг
#define CAN_AXLE_3              2114	//Нагрузка на ось 3, кг
#define CAN_AXLE_4              2115	//Нагрузка на ось 4, кг
#define CAN_AXLE_5              2116	//Нагрузка на ось 5, кг
#define CAN_FUEL_FLOW           2117	//Текущий (мгновенный) расход топлива, л/ч
#define CAN_ADBLUE_P            2118	//Уровень жидкости AdBlue, в процентах (мочевина)
#define CAN_ADBLUE_L            2119	//Уровень жидкости AdBlue, в литрах (мочевина)
#define CAN_HARVEST_TIME        2120	//Время сбора урожая, минуты
#define CAN_HARVEST_AREA        2121	//Убранная площадь, Га
#define CAN_HARVEST_EFF         2122	//Эффективность уборки, Га/ч
#define CAN_HARVEST_GRAIN       2123	//Количество убранного зерна, кг
#define CAN_BRAKE               2124	//Положение педали тормоза
#define CAN_ACCELERATOR         2125	//Положение педали акселератора в процентах
#define CAN_ENGINE_LOAD         2126	//Нагрузка двигателя в процентах
#define CAN_STEERING_ACCELERATION 2127	//Ускорение поворота руля
#define CAN_CONCAVE_CLR         2128	//Отброшенное состояние подбарабанья (зазор подбарабанья)
#define CAN_ODO_BEF_SERVICE     2129	//Пробег до очередного сервисного обслуживания
#define CAN_ODO_SERVICE_EX      2130	//Превышение пробега до очередного сервисного обслуживания
#define CAN_ODO_AFTER_SERVICE   2131	//Пробег после обслуживания
#define CAN_TIME_BEF_SERVICE    2132	//Время до очередного обслуживания
#define CAN_TIME_SERVICE_EX     2133	//Время превышения очередного обслуживания
#define CAN_TIME_AFTER_SERVICE  2134	//Время после обслуживания
#define CAN_BATTERY_CHARGE_LEVEL 2135	//Уровень заряда батареи
#define CAN_BATTERY_TEMPERATURE  2136	//Температура батареи
#define CAN_NUMERIC_LAST_ID     2136	//Последний ID числовых параметров CAN

// Приборная панель
#define CAN_DASH_FIRST_ID       2151	//Первый ID параметров CAN на приборной панели
#define CAN_STOP                2151    //СТОП
#define CAN_CHECK_OIL           2152    //Давление/уровень масла
#define CAN_CHECK_COOLANT       2153    //Температура/уровень хладагента
#define CAN_CHECK_HAND_BREAK    2154    //Система ручного тормоза
#define CAN_BATTERY             2155    //Зарядка батареи
#define CAN_AIRBAG              2156    //AIRBAG (подушка безопасности)
#define CAN_CHECK_ENGINE        2157    //ПРОВЕРЬТЕ ДВИГАТЕЛЬ
#define CAN_FAULT_LIGHTING      2158    //Неисправность освещения
#define CAN_INFLATION_PRESSURE  2159    //Низкое давление воздуха в шине
#define CAN_CHECK_BRAKE_PADS    2160    //Изношенные тормозные колодки
#define CAN_WARNING             2161    //Предупреждение
#define CAN_ABS                 2162    //ABS (антиблокировочная система)
#define CAN_FUEL_LEVEL          2163    //Низкий уровень топлива
#define SERVICE_MAINT           2164    //Предстоит сервисное обслуживание
#define CAN_ESP                 2165    //ESP (Электронный регулятор устойчивости)
#define CAN_SPARK_PLUG          2166    //Индикатор запальной свечи
#define CAN_FAP                 2167    //FAP (Фильтр макрочастиц)
#define CAN_PRESSURE_CONTROL    2168    //Электрическая регулировка давления
#define CAN_MARKER_LIGHTS       2169    //Габаритные огни
#define CAN_DIPPED_BEAM         2170    //Ближний свет фар
#define CAN_HIGH_BEAM           2171    //Дальний свет фар
#define CAN_PASSENGER_SAFE_BELT 2172    //Ремень безопасности пассажира
#define CAN_DRIVER_SAFE_BELT    2173    //Ремень безопасности водителя
#define CAN_READY_FOR_MOTION    2174    //Готовность начать движение
#define CAN_DASH_LAST_ID        2174	//Последний ID параметров CAN на приборной панели

// Охрана
#define CAN_GUARD_FIRST_ID      2201	//Первый ID параметров CAN охрана
#define CAN_KEY_IN_IGN          2201    //ключ в замке зажигания
#define CAN_IGNITION            2202    //зажигание
#define CAN_DYNAMIC_IGN         2203    //динамическое зажигание
#define CAN_WEBASTO             2204    //Webasto
#define CAN_CLOSED_BY_PULT      2205    //автомобиль закрыт с заводского пульта управления
#define CAN_ALARM_ACT           2206    //заводская сигнализация активирована (находится в режиме тревоги)
#define CAN_NATIVE_ALARM        2207    //заводская сигнализация эмулируется модулем
#define CAN_PARKING             2208    //рукоятка коробки переложения передачи переведена в положение «Парк» (для автоматических коробок передач)
#define CAN_HAND_BREAK          2209    //задействован ручной тормоз (информация доступна только с вкл. зажиг.)
#define CAN_PEDAL_BREAK         2210    //задействован ножной тормоз (информация доступна только с вкл. зажиг.)
#define CAN_ENGINE_IS_ON        2211    //двигатель работает (информация доступна только с вкл. зажиганием)
#define CAN_REVERSE_GEAR        2212    //включена задняя передача
#define CAN_DRIVER_DOOR         2213    //дверь водителя открыта
#define CAN_PASS_DOOR           2214    //пассажирская дверь открыта
#define CAN_L_REAR_DOOR         2215    //левая задняя дверь открыта
#define CAN_R_REAR_DOOR         2216    //правая задняя дверь открыта
#define CAN_HOOD                2217    //капот открыт
#define CAN_TRUNK               2218    //крышка багажника открыта
#define CAN_REMOTE_CONTROL      2219    //
  //0x01 – автомобиль был закрыт с заводского пульта управления,
  //0x02 – автомобиль был открыт с заводского пульта управления,
  //0x03 – крышка багажника была открыта с заводского пульта управления,
  //0x04 – модуль отправил сигнал перепостановки в охрану,
  //0x05 – автомобиль был троекратно закрыт штатным пультом
#define CAN_IN_SLEEP            2220    //CAN-модуль вошел в режим «sleep»
#define CAN_BATTERY_CHARGING    2221    //Зарядка аккумулятора
#define CAN_CHARGING_CABLE      2222    //Подключен кабель для зарядки
#define CAN_GUARD_LAST_ID       2222	//Последний ID параметров CAN охрана
#define CAN_KEY_IN_ACC          2223    //key is in ingection in ACC

// Спецтехника и агротехника
#define CAN_AGRO_FIRST_ID       2251	//Первый ID параметров CAN сельхоз
#define CAN_TRESHER_ON          2251    //Молотильный барабан включён
#define CAN_UNLOAD_TUBE_ON      2252    //Включена выгрузная труба
#define CAN_REAR_PTO_UNIT_ON    2253    //Включен задний блок отбора мощности
#define CAN_FRONT_PTO_UNIT_ON   2254    //Включен передний блок отбора мощности
#define CAN_TRESHER_GAP         2255    //Чрезмерный люфт под молотильным барабаном
#define CAN_GR_TNK_OPEN         2256    //Открыт вход в зерновой бункер
#define CAN_GR_TNK_100          2257    //Бункер зерна 100%
#define CAN_GR_TNK_70           2258    //Бункер зерна 70%
#define CAN_HYDR_FLTR_CLOG      2259    //Засорен фильтр масла гидравлической системы
#define CAN_HYDR_PRESS_LOW      2260    //Низкое давление масла гидравлической системы
#define CAN_HYDR_LEVEL_LOW      2261    //Низкий уровень масла гидравлического
#define CAN_BR_FLTR_CLOG        2262    //Засорен фильтр гидросистемы тормозов
#define CAN_OIL_FLTR_CLOG       2263    //Засорен масляный фильтр двигателя
#define CAN_FUEL_FLTR_CLOG      2264    //Засорен топливный фильтр
#define CAN_AIR_FLTR_CLOG       2265    //Засорен воздушный фильтр
#define CAN_HYDR_TEMP_ALERT     2266    //Аварийная температура масла в гидросистеме ходовой части
#define CAN_PCH_TEMP_ALERT      2267    //Аварийная температура масла в гидросистеме силовых цилиндров
#define CAN_OIL_PRESS_ALERT     2268    //Аварийное давление масла в двигателе
#define CAN_COOLANT_ALERT       2269    //Аварийный уровень охлаждающей жидкости
#define CAN_HBLOCK_SECTION      2270    //Переливная секция гидроблока
#define CAN_SCREW_ALERT         2271    //Включен привод выгрузного шнека при слож. выгрузн. трубе
#define CAN_NO_OPERATOR         2272    //Оператор отсутствует!
#define CAN_STRAW_ALERT         2273    //Забивание соломотряса
#define CAN_WATER_IN_FUEL       2274    //Наличие воды в топливе
#define CAN_CLEAR_FAN           2275    //Обороты вентилятора очистки
#define CAN_REEL                2276    //Обороты барабана
#define CAN_LOW_WATER           2277    //Низкий уровень воды в баке
#define CAN_AUTONOM_ENGINE      2278    //Автономный двигатель заведен
#define CAN_JOY_RIGHT_R         2279    //Правый джойстик вправо
#define CAN_JOY_LEFT_R          2280    //Правый джойстик влево
#define CAN_JOY_FRONT_R         2281    //Правый джойстик вперед
#define CAN_JOY_BACK_R          2282    //Правый джойстик назад
#define CAN_JOY_RIGHT_L         2283    //Правый джойстик вправо
#define CAN_JOY_LEFT_L          2284    //Правый джойстик влево
#define CAN_JOY_FRONT_L         2285    //Правый джойстик вперед
#define CAN_JOY_BACK_L          2286    //Правый джойстик назад
#define CAN_BRUSH_ON            2287    //Щетка включена
#define CAN_WATER_ON            2288    //Подача воды включена
#define CAN_VACCLEANER          2289    //Пылесос
#define CAN_BUNKER_UPLOAD       2290    //Выгрузка из бункера
#define CAN_KERCHER             2291    //Мойка высокого давления (Kерхер)
#define CAN_SALT_DIFFUSION      2292    //Рассеивание соли (песка) включено
#define CAN_SALT_LOW            2293    //Низкий уровень соли (песка) в баке
#define CAN_FRONT_HYDR_1        2294    //Включена первая передняя гидравлика
#define CAN_FRONT_HYDR_2        2295    //Включена вторая передняя гидравлика
#define CAN_FRONT_HYDR_3        2296    //Включена третья передняя гидравлика
#define CAN_FRONT_HYDR_4        2297    //Включена четвёртая передняя гидравлика
#define CAN_REAR_HYDR_1         2298    //Включение первой задней гидравлики
#define CAN_REAR_HYDR_2         2299    //Включение второй задней гидравлики
#define CAN_REAR_HYDR_3         2300    //Включение третьей задней гидравлики
#define CAN_REAR_HYDR_4         2301    //Включение четвертой задней гидравлики
#define CAN_FRONT_SUSP_SYS      2302    //Включёна передняя трехточечная система подвески
#define CAN_REAR_SUSP_SYS       2303    //Включёна задняя трехточечная система подвески
#define CAN_AGRO_LAST_ID        2303	//Последний ID параметров CAN сельхоз

#define CAN_TACHO_DRIVER_1_INF  2320    //Имя, фамилия, идентификатор водителя 1
#define CAN_TACHO_DRIVER_2_INF  2321    //Имя, фамилия, идентификатор водителя 2
#define CAN_TACHO_CARD_INFO     2322    //Наличие карты драйвера в тахографе

#if !defined(EXTENDED_ADVANTUM_CAN_PRESENT)
#define CAN_STAT_TRANSMISSION   2350
#endif

//MAN Truck & Bus
#if defined(EXTENDED_ADVANTUM_CAN_PRESENT)
#define MAN_CANLOG_FIRST_ID     2350
#define CAN_STAT_TRANSMISSION   2350    //Статус трансмиссии
                                        //  00 Трансмиссия отключена
                                        //  01 Трансмиссия включена
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_OTPUT_SPEED_KP      2351    //Частота вращения выходного вала КП, об/мин
#define CAN_CLUTCH_SLIP         2352    //Пробуксовка сцепления, %
#define CAN_INPUT_SPEED_KP      2353    //Частота вращения первичного вала КП, об/мин
#define CAN_SELECTED_GEAR       2354    //Выбранная передача, Диапазон = -125 ... 1251
#define CAN_GEAR_RATIO          2355    //Текущее передаточное число КП, 0,001 на бит Диапазон = 0 ...64,255
#define CAN_CURRENT_GEAR        2356    //Текущая/последняя передача, Диапазон = -125 ... 1251
                                        //Положительные числа характеризуют движение в прямом направлении, отрицательные –
                                        //движение задним ходом.
                                        //Число «0» применяется для характеристики нейтрали КП, число «126» - для состояние парковки(АКП).
#define CAN_SHIFT_FINGER_ST     2357    //Передача включена [shift_finger_status_1]
                                        //  00 Выкл
                                        //  01 Вкл.
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_NEUTRAL_IND_KP      2358    // Индикатор нейтрали КПП Transmission Neutral Indicator
                                        //  00 Выкл
                                        //  01 Вкл.
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_NMV_STATE           2359    //Статус механизма отбора мощности NMV [NMV_state]
                                        //x1 Активирован
                                        //1x Включен
#define CAN_PTO1_STATE          2360    //Статус механизма отбора мощности NA1 [PTO1_state]
                                        // 0x1 Активирован
                                        // 01x Включен
                                        // 1xx Не определен
#define CAN_PTO2_STATE          2361    //Статус механизма отбора мощности NA2 [PTO2_state]
                                        // 0x1 Активирован
                                        // 01x Включен
                                        // 1xx Не определен
                                        // Статус механизма отбора мощности определяется не по стандарту SAE 1939/71.
#define CAN_PARK_BRAKE_SW       2362    //Включение стояночного тормоза [park_brake_switch]
                                        // 00 Стояночный тормоз не включен
                                        // 01 Стояночный тормоз включен
                                        // 10 Ошибка
                                        // 11 Сигнал недоступен
#define CAN_CLUTCH_SW           2363    //Нажатие педали сцепления [clutch_switch]
                                        // 00 Педаль сцепления не нажата
                                        // 01 Педаль сцепления нажата
                                        // 10 Ошибка
                                        // 11 Сигнал недоступен
#define CAN_BRAKE_SW           2364    //Нажатие педали тормоза [brake_switch]
                                        // 00 Педаль тормоза не нажата
                                        // 01 Педаль тормоза нажата
                                        // 10 Ошибка
                                        // 11 Сигнал недоступен
#define CAN_CC_ACTIVE          2365     //Круиз-контроль активен [CC_active]
                                        // 00 Круиз-контроль выключен
                                        // 01 Круиз-контроль включен
                                        // 10 Ошибка
                                        // 11 Сигнал недоступен
#define CAN_PTO_STATE          2366     //Статус механизмов отбора мощности [PTO_state]
                                        //00000 Выключен.деактивирован
                                        //00101 Установлено
                                        //11111 Сигнал недоступен
#define CAN_ABS_ACTIVE         2367     //АБС активна [ABS_active]
                                        //00 АБС установлена, но не активна
                                        //01 АБС активна
                                        //10 Зарезервировано
                                        //11 Не реагировать
#define CAN_BP_POSITION        2368     //Положение педали тормоза [BP_position]
                                        //0,4% на бит, Range = 0% ... 100%
#define CAN_SHIFT_REAR_ST      2369     //Задняя передача включена
                                        //  00 Выкл
                                        //  01 Вкл.
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_FUEL_LEVEL_LOW     2370     //Информация о слишком низком уровне топлива в баке
                                        //  00 Выкл
                                        //  01 Вкл.
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_EMERGENCY_SHUTDOWN 2371     // Аварийное отключение Emergency shutdown
                                        //  00 Выкл
                                        //  01 Вкл.
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_ACT_ENG_TORQUE     2372     //Крутящий момент двигателя[act_eng_torque]
                                        //1% на бит, Диапазон [%] = -125...125
#define CAN_AP_KICKDOWN_SW     2373     //Режим Kickdown (полное нажатие педали акселератора)[AP_kickdown_sw]
                                        //  00 Режим Kickdown не активирован
                                        //  01 Режим Kickdown активирован
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_AP_LOW_IDLE_SW     2374     //Режим холостого хода [AP_low_idle_sw]
                                        //  00 Педаль не в положении холостого хода
                                        //  01 Педаль в положении холостого хода
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_LOAD_CURR_SPEED    2375     //Степень использования двигателя по мощности (load_curr_speed]
                                        //1% на бит, Диапазон [%] = 0...100
#define CAN_ENG_OIL_PRESS      2376     //Давление масла [eng_oil_press]
                                        // 40 мбар на бит, Диапазон [бар]= 0...10
#define CAN_FUEL_TEMP          2377     //Температура топлива [fuel_temp]
                                        //1 °C на бит, Диапазон [°C] = -40...210
#define CAN_ENG_OIL_TEMP       2378     //Температура моторного масла [eng_oil_temp]
                                        //0,03125 °C на бит Диапазон [°C] = -273...1735
#define CAN_P_SUPPLY_PRESS     2379     //Давление воздуха (не используется MAN) [pneu_supply_press]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_PARK_TR_PRESS      2380     //Давление воздуха в системе стояночного тормоза и/или в
                                        // магистрали для прицепа (MAN:контур 3 {23}) [park_trailer_press]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_SERV_BRAKE_PRESS1  2381     //Давление в рабочей тормозной системе, контур #1 (MAN:
                                        //контур 1 {21}) [serv_brake_press1]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_SERV_BRAKE_PRESS2  2382     //Давление в рабочей тормозной системе, контур #2 (MAN:
                                        //контур 2 {22}) [serv_brake_press2]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_AUX_EQUIP_PRESS    2383     //Давление воздуха для дополнительного оборудования (MAN:
                                        //контур 4 {24}) [aux_equip_press]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_AIR_SUSP_PRESS     2384     //Давление в пневмоподвеске (MAN: предварительный контур)
                                        //[air_susp_press]
                                        //80 мбар на бит, Диапазон [бар] = 0 ... 20
#define CAN_BAR_PRESS          2385     //Атмосферное давление [barometric_press]
                                        // 5 мбар на бит, Диапазон [бар] = 0...1,25
#define CAN_AMB_AIR_TEMP       2386     //Температура атмосферного воздуха [amb_air_temp]
                                        //0,03125 °C на бит Диапазон [°C] = -273...1735
#define CAN_SECONDS            2387     //Секунды [seconds] 0,25 с на бит, Диапазон [c] = 0 ...59,75
#define CAN_MINUTES            2388     //Минуты [minutes] 1 мин на бит, Диапазон [мин] = 0...59
#define CAN_HOURS              2389     //Часы [hours] 1 час на бит, Диапазон [ч] = 0 ...23
#define CAN_MONTH              2390     //Месяц [month] 1 месяц на бит, Диапазон [мес] = 0...12
#define CAN_DAY                2391     //День [day], 0,25 дня на бит, Диапазон [дней] = 0...31,75
#define CAN_YEAR               2392     //Год [year] 1 год на бит, Диапазон [год] = 1985 ... 2235
#define CAN_SH_MIN_GMT         2393     //Отличие местного времени от GMT(минуты) 1 мин на бит, Диапазон [мин] = –59 ... +59
#define CAN_SH_HRS_GMT         2394     //Отличие местного времени от GMT(часы) 1 час на бит, Диапазон [ч] = –23...+23
#define CAN_TRIP_DISTANCE      2395     //Счетчик суточного пробега [trip_distance] 5 м на бит, Диапазон [км] = 0...21 055 406
#define CAN_AXLE_LOC_EBS       2396     //Расположение оси [axle_location] 0000 -> Ось 1, 0001 -> Ось 2 ... 1111 -> Ось 16
#define CAN_AXLE_WEIGHT_EBS    2397     //Нагрузка на ось [axle_weight]5 кг на бит, Диапазон [кг] = 0 ...32127.5
#define CAN_AXLE_LOC_EACS      2398     //Расположение оси [axle_location] 0000 -> Ось 1, 0001 -> Ось 2 ... 1111 -> Ось 16
#define CAN_AXLE_WEIGHT_EACS   2399     //Нагрузка на ось [axle_weight]5 кг на бит, Диапазон [кг] = 0 ...32127.5
#define CAN_MOTION_DETECTION   2400     //Распознавание движения
                                        //  00 Выкл. / Движение автомобиля не распознается
                                        //  01 Вкл. / Движение автомобиля распознается
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_DRIVER2_STATUS     2401     //Статус водителя 2
                                        //000 Отдых
                                        //001 Готовность к работе
                                        //010 Работа
                                        //011 Управление автомобилем
                                        //100 Зарезервировано
                                        //101 Зарезервировано
                                        //110 Зарезервировано
                                        //111 Сигнал недоступен
#define CAN_DRIVER1_STATUS     2402     //Статус водителя 1
                                        //000 Отдых
                                        //001 Готовность к работе
                                        //010 Работа
                                        //011 Управление автомобилем
                                        //100 Зарезервировано
                                        //101 Зарезервировано
                                        //110 Зарезервировано
                                        //111 Сигнал недоступен
#define CAN_OVER_SPEED         2403     //Превышение скорости
                                        //  00 Нет превышения
                                        //  01 Превышение
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_DRIVER1_CARD       2404     //Карта водителя 1
                                        //  00 Карта отсутствует
                                        //  01 Карта вставлена
                                        //  10 Карта неисправна
                                        //  11 Сигнал недоступен
#define CAN_DRIVER1_DATA       2405     //Данные, связанные со временем работы водителя 1
                                        //0000 Нет предупреждений
                                        //0001 Предупреждение #1
                                        //0010 Предупреждение #2
                                        //0011 Предупреждение #3
                                        //0100 Предупреждение #4
                                        //0101 Предупреждение #5
                                        //0110...1101  Зарезервировано
                                        //1110 Ошибка
                                        //1111 Сигнал недоступен
#define CAN_DRIVER2_CARD       2406     //Карта водителя 2
                                        //  00 Карта отсутствует
                                        //  01 Карта вставлена
                                        //  10 Карта неисправна
                                        //  11 Сигнал недоступен
#define CAN_DRIVER2_DATA       2407     //Данные, связанные со временем работы водителя 2
                                        //0000 Нет предупреждений
                                        //0001 Предупреждение #1
                                        //0010 Предупреждение #2
                                        //0011 Предупреждение #3
                                        //0100 Предупреждение #4
                                        //0101 Предупреждение #5
                                        //0110...1101  Зарезервировано
                                        //1110 Ошибка
                                        //1111 Сигнал недоступен
#define CAN_SYSTEM_OPER        2408     //Работа системы System operation
                                        //  00 Система работает нормально
                                        //  01 Система неисправна
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_SERVICE_MESS       2409     //Служебные сообщения Service messages
                                        //  00 Нет служебных сообщений
                                        //  01 Служебное сообщение
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_SYSTEM_EVENTS      2410     //Системные события
                                        //  00 Нет системных событий
                                        //  01 Системное событие
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_VEH_SPEED_MTCO     2411     //Скорость автомобиля, записанная тахографом [veh_speed_MTCO]
                                        //  1/256 км/час на бит, Диапазон [км/ч] = 0...250,996
#define CAN_ACT_RX_TORQUE      2412     //Текущий тормозной момент [act_rx_torque] 1% на бит, Диапазон [%] =-125...0
#define CAN_QUERY_SUPPORT      2413     //Поддержка запросов Query support
                                        //  00 Запрос не поддерживается
                                        //  01 Запрос поддерживается
                                        //  10 Зарезервировано
                                        //  11 Не реагировать
#define CAN_DIAG_SUPPORT       2414     //Поддержка диагностики Diagnostic support
                                        //  00 Диагностика не поддерживается
                                        //  01 Диагностика поддерживается
                                        //  10 Зарезервировано
                                        //  11 Не реагировать
#define CAN_VER_SOFT           2415     //Поддерживаемая версия ПО
                                        //Версия ПО представлена с помощью кодировки ASCII в следующем формате: ab.cd
#define CAN_VIN_CAR            2416     //VIN: Идентификационный номер автомобиля  Байты 1-17 VIN ASCII
#define CAN_ACT_RET_TORQ_RE    2417     //Первичный ретардер Текущий тормозной момент [act_ret_torque] 1% на бит, Диапазон [%] =-125...0
#define CAN_ACT_RET_TORQ_RD    2418     //Вторичный ретардер Текущий тормозной момент [act_ret_torque] 1% на бит, Диапазон [%] =-125...0
#define CAN_FUEL_RATE          2419     //Удельный расход топлива [fuel_rate] 0,05 л/ч на бит, Диапазон [л/ч] = 0 ... 210 554 060,75
#define CAN_INS_FUEL_ECO       2420     //Путевой расход топлива [instant_fuel_eco] 1/512 км/л на бит, Диапазон [км/л]= 0... 125,5
#define CAN_LOW_OIL_PRESS      2421     //Предупреждающий сигнал о слишком низком давлении масла
                                        //  00 Выключен
                                        //  01 Включен
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
#define CAN_HIGH_COOLANT_T     2422     //Предупреждающий сигнал о слишком высокой температуре охлаждающей жидкости too high coolant temperature
                                        //  00 Выключен
                                        //  01 Включен
                                        //  10 Ошибка
                                        //  11 Сигнал недоступен
//
#define MAN_CANLOG_LAST_ID      2422
#warning Идет пересечение с NEW_CANLOG_FIRST_ID!!! NEW_CANLOG_FIRST_ID не менять!!!
#endif //EXTENDED_ADVANTUM_CAN_PRESENT

#define NEW_CANLOG_FIRST_ID     2350
// ID для CAN V4
#define CAN_V4_BOOT_FRAME 2350
#define CAN_V4_PROGRAM_NUMBER 2351
#define CAN_V4_FRAME_INTERVAL 2352
#define CAN_V4_UPDATE_PERCENT 2353
#define CAN_V4_INCOMPLETE_DATA_FLAGS 2354

#define CAN_V4_CONN_FLAGS_D0 2363
#define CAN_V4_CONN_FLAGS_D1 2364

#define CAN_V4_SECURITY_FL_D0 2370
#define CAN_V4_SECURITY_FL_D1 2371
#define CAN_V4_SECURITY_FL_D2 2372
#define CAN_V4_SECURITY_FL_D3 2373
#define CAN_V4_SECURITY_FL_D4 2374
#define CAN_V4_SECURITY_FL_D5 2375
#define CAN_V4_SECURITY_FL_D6 2376
#define CAN_V4_SECURITY_FL_D7 2377
#define CAN_V4_SECURITY_FL_D8 2378
#define CAN_V4_SECURITY_FL_D9 2379
#define CAN_V4_SECURITY_FL_D10 2380
#define CAN_V4_SECURITY_FL_D11 2381
#define CAN_V4_SECURITY_FL_D12 2382

#define CAN_V4_STATE_FL_D0 2387
#define CAN_V4_STATE_FL_D1 2388
#define CAN_V4_STATE_FL_D2 2389
#define CAN_V4_STATE_FL_D3 2390
#define CAN_V4_STATE_FL_D4 2391
#define CAN_V4_STATE_FL_D5 2392
#define CAN_V4_STATE_FL_D6 2393
#define CAN_V4_STATE_FL_D7 2394
#define CAN_V4_STATE_FL_D8 2395

#define CAN_V4_INDICATORS_FL_D0 2399
#define CAN_V4_INDICATORS_FL_D1 2400
#define CAN_V4_INDICATORS_FL_D2 2401
#define CAN_V4_INDICATORS_FL_D3 2402
#define CAN_V4_INDICATORS_FL_D4 2403
#define CAN_V4_INDICATORS_FL_D5 2404
#define CAN_V4_INDICATORS_FL_D6 2405
#define CAN_V4_INDICATORS_FL_D7 2406
#define CAN_V4_INDICATORS_FL_D8 2407
#define CAN_V4_INDICATORS_FL_D9 2408

//флаги агротеххники, диапазон 1
#define CAN_V4_AGRICULTURAL_FL_D0 2413
#define CAN_V4_AGRICULTURAL_FL_D1 2414
#define CAN_V4_AGRICULTURAL_FL_D2 2415
#define CAN_V4_AGRICULTURAL_FL_D3 2416
#define CAN_V4_AGRICULTURAL_FL_D4 2417
#define CAN_V4_AGRICULTURAL_FL_D5 2418
#define CAN_V4_AGRICULTURAL_FL_D6 2419
#define CAN_V4_AGRICULTURAL_FL_D7 2420
#define CAN_V4_AGRICULTURAL_FL_D8 2421
#define CAN_V4_AGRICULTURAL_FL_D9 2422
#define CAN_V4_AGRICULTURAL_FL_D10 2423
//CAN_V4_AGRICULTURAL_FL_D11-CAN_V4_AGRICULTURAL_FL_D20 в отдельном диаппозоне, резерва не хватает

#define CAN_V4_UTILITY_VEHICLES_FL_D0 2429
#define CAN_V4_UTILITY_VEHICLES_FL_D1 2430
#define CAN_V4_UTILITY_VEHICLES_FL_D2 2431
#define CAN_V4_UTILITY_VEHICLES_FL_D3 2432
#define CAN_V4_UTILITY_VEHICLES_FL_D4 2433

#define CAN_V4_CISTERNS_FL_D0 2439
#define CAN_V4_CISTERNS_FL_D1 2440

#define CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME 2446
#define CAN_V4_NUMERIC_TOTAL_ENG_UP_TIME_COUNTED 2447
#define CAN_V4_NUMERIC_ODOMETER 2448
#define CAN_V4_NUMERIC_ODOMETER_COUNTED 2449
#define CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION 2450
#define CAN_V4_NUMERIC_TOTAL_FUEL_CONSUMPTION_COUNTED 2451
#define CAN_V4_NUMERIC_FUEL_LEVEL_PERCENT 2452
#define CAN_V4_NUMERIC_FUEL_LEVEL_LITER 2453
#define CAN_V4_NUMERIC_ENGINE_RPM 2454
#define CAN_V4_NUMERIC_ENGINE_TEMP 2455
#define CAN_V4_NUMERIC_SPEED 2456
#define CAN_V4_NUMERIC_ACCELERATOR_POSITION 2457
#define CAN_V4_NUMERIC_ENGINE_LOAD 2458
#define CAN_V4_NUMERIC_AXLE_LOAD_1 2459
#define CAN_V4_NUMERIC_AXLE_LOAD_2 2460
#define CAN_V4_NUMERIC_AXLE_LOAD_3 2461
#define CAN_V4_NUMERIC_AXLE_LOAD_4 2462
#define CAN_V4_NUMERIC_AXLE_LOAD_5 2463
#define CAN_V4_NUMERIC_RETARDER_LOAD 2464
#define CAN_V4_NUMERIC_TOTAL_CNG_USE 2465
#define CAN_V4_NUMERIC_TOTAL_CNG_USE_COUNTED 2466
#define CAN_V4_NUMERIC_CNG_LEVEL_PERCENT 2467
#define CAN_V4_NUMERIC_CNG_LEVEL_LITER 2468
#define CAN_V4_NUMERIC_ADBLUE_LEVEL_PERCENT 2469
#define CAN_V4_NUMERIC_ADBLUE_LEVEL_LITER 2470
#define CAN_V4_NUMERIC_FUEL_FLOWMETER 2471
#define CAN_V4_NUMERIC_BATTERY_TEMPERATURE 2472
#define CAN_V4_NUMERIC_BATTERY_CHARGE_LEVEL 2473
#define CAN_V4_NUMERIC_BATTERY_VOLTAGE 2474
#define CAN_V4_NUMERIC_VEHICLES_RANGE 2475
#define CAN_V4_NUMERIC_BEF_SRVC_TIME 2476
#define CAN_V4_NUMERIC_EX_SRVC_TIME 2477
#define CAN_V4_NUMERIC_AFT_SRVC_TIME 2478
#define CAN_V4_NUMERIC_BEF_SRVC_ODO 2479
#define CAN_V4_NUMERIC_EX_SRVC_ODO 2480
#define CAN_V4_NUMERIC_AFT_SRVC_ODO 2481
#define CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_1 2482
#define CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_2 2483
#define CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_3 2484
#define CAN_V4_NUMERIC_TRAILER_AXLE_LOAD_4 2485
#define CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_1 2486
#define CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_1 2487
#define CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_2 2488
#define CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_2 2489
#define CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_3 2490
#define CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_3 2491
#define CAN_V4_PRESSURE_IN_LEFT_FIRST_WHEEL_TRAILER_AXLE_4 2492
#define CAN_V4_PRESSURE_IN_RIGHT_FIRST_WHEEL_TRAILER_AXLE_4 2493
#define CAN_V4_TRAILER_VIN 2494
#define CAN_V4_NUMERIC_TOTAL_TRAILER_AXLE_LOAD 2495
#define CAN_V4_NUMERIC_CARGO_WEIGHT 2496
#define CAN_V4_MAIN_FUEL_UP_TIME 2497
#define CAN_V4_DUAL_FUEL_UP_TIME 2498
#define CAN_V4_CNG_PRESSURE 2499

#define CAN_V4_AGR_NUMERIC_HARVEST_TIME 2507
#define CAN_V4_AGR_NUMERIC_HARVEST_AREA 2508
#define CAN_V4_AGR_NUMERIC_HARVEST_EFFICIENCY 2509
#define CAN_V4_AGR_NUMERIC_HARVESTED_GRAIN 2510
#define CAN_V4_AGR_NUMERIC_GRAIN_MOISTURE 2511
#define CAN_V4_AGR_NUMERIC_THRESHER_RPM 2512
#define CAN_V4_AGR_NUMERIC_CONCAVE_CLEARANCE 2513
#define CAN_V4_AGR_NUMERIC_ENGINE_PRESSURE 2514
#define CAN_V4_AGR_NUMERIC_CHASSIS_TEMP 2515
#define CAN_V4_AGR_NUMERIC_AUGER_RPM 2516
#define CAN_V4_AGR_NUMERIC_GRAIN_RPM 2517
#define CAN_V4_AGR_NUMERIC_SHREDDER_RPM 2518
#define CAN_V4_AGR_NUMERIC_RACK_RPM 2519
#define CAN_V4_AGR_NUMERIC_FAN_RPM 2520
#define CAN_V4_AGR_NUMERIC_FEED_ELEVATOR_RPM 2521
#define CAN_V4_AGR_NUMERIC_REEL_SPEED 2522
#define CAN_V4_AGR_NUMERIC_TAILINGS_ELEVATOR_PERCENT 2523
#define CAN_V4_AGR_NUMERIC_THRESHER_ON_CURRENT_TIME 2524
#define CAN_V4_AGR_NUMERIC_THRESHER_ON_TOTAL_TIME 2525
#define CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE 2526
#define CAN_V4_AGR_NUMERIC_AGR_TOTAL_DISTANCE 2527
#define CAN_V4_AGR_NUMERIC_AGR_CURRENT_DISTANCE_ON_WORK 2528
#define CAN_V4_AGR_NUMERIC_CURRENT_HARVEST_AREA 2529
#define CAN_V4_AGR_NUMERIC_TOTAL_HARVEST_AREA 2530
#define CAN_V4_AGR_TOTAL_TREATED_AREA 2531
#define CAN_V4_AGR_LEVEL_OF_LIQUID_IN_TANK 2532
#define CAN_V4_AGR_SPRAY_PRESSURE 2533
#define CAN_V4_AGR_ACTUAL_NORM_OF_LIQUID 2534
#define CAN_V4_AGR_TOTAL_AMOUNT_OF_LIQUID_USED 2535
#define CAN_V4_AGR_AREA_THAT_CAN_BE_TREATED_UNTIL_TANK_IS_EMPTY 2536
#define CAN_V4_AGR_DISTANCE_REMAINING_UNTIL_TANK_IS_EMPTY 2537
#define CAN_V4_AGR_TOTAL_WEIGHT_OF_SPREAD_MATERIAL 2538

#define CAN_V4_TACHO_SYSTEM_INFO 2542
#define CAN_V4_TACHO_CARDS_INFO 2543
#define CAN_V4_TACHO_DRIVER1_INFO_FIRST_NAME 2544
#define CAN_V4_TACHO_DRIVER2_INFO_FIRST_NAME 2545
#define CAN_V4_TACHO_DRIVER1_INFO_LAST_NAME 2546
#define CAN_V4_TACHO_DRIVER2_INFO_LAST_NAME 2547
#define CAN_V4_TACHO_DRIVER1_INFO_ID 2548
#define CAN_V4_TACHO_DRIVER2_INFO_ID 2549
#define CAN_V4_TACHO_DRIVER1_INFO_STATE 2550
#define CAN_V4_TACHO_DRIVER2_INFO_STATE 2551
#define CAN_V4_TACHO_DRIVER1_INFO_WORK_TIME 2552
#define CAN_V4_TACHO_DRIVER2_INFO_WORK_TIME 2553
#define CAN_V4_TACHO_DRIVER1_INFO_TOTAL_RELAX_TIME 2554
#define CAN_V4_TACHO_DRIVER2_INFO_TOTAL_RELAX_TIME 2555
#define CAN_V4_TACHO_DRIVER1_INFO_CURR_ACTIVITY_TIME 2556
#define CAN_V4_TACHO_DRIVER2_INFO_CURR_ACTIVITY_TIME 2557
#define CAN_V4_TACHO_DRIVER1_INFO_ACTIVITY_AT_LAST_WEEK_TIME 2558
#define CAN_V4_TACHO_DRIVER2_INFO_ACTIVITY_AT_LAST_WEEK_TIME 2559

#define NEW_CANLOG_LAST_ID      2559

#define CARRIER_COOMUNICATION_STATE  2560 //Cвязь с МП Carrier 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define CARRIER_OVERALL_STATUS       2561 //Overall Status общее состояние 00H = Alarm Shutdown,
                                                                         // 01H = Start / Stop Off Cycle,
                                                                         // 02H = Sleep Mode Off (Advance Only),
                                                                         // 03H = On – Running or Starting,
                                                                         // 04H = PC Mode (Advance Only),
                                                                         // 05H = Configuration Mode,
                                                                         // 06H = Data Recorder Only Mode (Advance Only)
                                                                         // 07H = Idle
#define CARRIER_OP_COMP1             2562 //Mode of Operation – Compartment 1
                                                                         // 00H = Off,  (compartment Off due to engine off)
                                                                         // 01H = Heat,
                                                                         // 02H = Cool,
                                                                         // 03H = Null,
                                                                         // 04H = Defrost
                                                                         // FFH = Compartment Not Enabled
#define CARRIER_OP_COMP2             2563 //Mode of Operation – Compartment 2
                                                                         // 00H = Off,  (compartment Off due to engine off)
                                                                         // 01H = Heat,
                                                                         // 02H = Cool,
                                                                         // 03H = Null,
                                                                         // 04H = Defrost
                                                                         // FFH = Compartment Not Enabled or, for Advance, not configured as multitemp 2 or 3 compartment unit.
#define CARRIER_OP_COMP3             2564 //Mode of Operation – Compartment 3
                                                                         // 00H = Off,  (compartment Off due to engine off)
                                                                         // 01H = Heat,
                                                                         // 02H = Cool,
                                                                         // 03H = Null,
                                                                         // 04H = Defrost
                                                                         // FFH = Compartment Not Enabled or, for Advance, not configured as multitemp 3 compartment unit.
#define CARRIER_ENG_STAT             2565 //Engine / Standby Status
                                                                         //Bit 0 State –      0 = Engine, 1 = Standby
                                                                         //Bit 1 Mode -     0 = Start/Stop, 1 = Continuous
                                                                         //Bit 2 engine speed – (only applicable if State = Engine in bit 0)     0=Low, 1=High
                                                                         //Bit 3 =0 and Bit 4 = 0, then 6 cylinder
                                                                         //Bit 3 = 1 and Bit 4 = 1, then 2 cylinder
                                                                         //Bit 3 = 0 and Bit 4 = 1, then 4 cylinder
                                                                         //Bit 3 = 1 and Bit 4 = 0, then 4 cylinder
                                                                         //Bit 5 –7 reserved – 0
                                                                         //*Note: Bit 3 & 4
#define CARRIER_ALRM_STAT            2566 //Alarm Status 00 – No Alarms, 01 – Alarm Shutdown, 02 –Non-Shutdown Alarms Active
#define CARRIER_NUM_ALRMS            2567 //Number of Active Alarms 0-16
#define CARRIER_ALRM1                2568 //Alarm Number 1
#define CARRIER_ALRM2                2569 //Alarm Number 2
#define CARRIER_ALRM3                2570 //Alarm Number 3
#define CARRIER_ALRM4                2571 //Alarm Number 4
#define CARRIER_ALRM5                2572 //Alarm Number 5
#define CARRIER_ALRM6                2573 //Alarm Number 6
#define CARRIER_ALRM7                2574 //Alarm Number 7
#define CARRIER_ALRM8                2575 //Alarm Number 8
#define CARRIER_ALRM9                2576 //Alarm Number 9
#define CARRIER_ALRM10               2577 //Alarm Number 10
#define CARRIER_ALRM11               2578 //Alarm Number 11
#define CARRIER_ALRM12               2579 //Alarm Number 12
#define CARRIER_ALRM13               2580 //Alarm Number 13
#define CARRIER_ALRM14               2581 //Alarm Number 14
#define CARRIER_ALRM15               2582 //Alarm Number 15
#define CARRIER_ALRM16               2583 //Alarm Number 16
#define CARRIER_NUM_INA_ALRMS        2584 //Number of Inactive Alarms 0-16
#define CARRIER_INA_ALRM1            2585 //Inactive Alarm Number 1
#define CARRIER_INA_ALRM2            2586 //Inactive Alarm Number 2
#define CARRIER_INA_ALRM3            2587 //Inactive Alarm Number 3
#define CARRIER_INA_ALRM4            2588 //Inactive Alarm Number 4
#define CARRIER_INA_ALRM5            2589 //Inactive Alarm Number 5
#define CARRIER_INA_ALRM6            2590 //Inactive Alarm Number 6
#define CARRIER_INA_ALRM7            2591 //Inactive Alarm Number 7
#define CARRIER_INA_ALRM8            2592 //Inactive Alarm Number 8
#define CARRIER_INA_ALRM9            2593 //Inactive Alarm Number 9
#define CARRIER_INA_ALRM10           2594 //Inactive Alarm Number 10
#define CARRIER_INA_ALRM11           2595 //Inactive Alarm Number 11
#define CARRIER_INA_ALRM12           2596 //Inactive Alarm Number 12
#define CARRIER_INA_ALRM13           2597 //Inactive Alarm Number 13
#define CARRIER_INA_ALRM14           2598 //Inactive Alarm Number 14
#define CARRIER_INA_ALRM15           2599 //Inactive Alarm Number 15
#define CARRIER_INA_ALRM16           2600 //Inactive Alarm Number 16
#define CARRIER_TRAILER_ID           2601 //Trailer Id in ASCII 11 bytes for Standard 10 bytes for Advance (last byte set to blank)
#define CARRIER_UNIT_SN              2602 //Unit Serial Number  in ASCII
#define CARRIER_SOFT_REV             2603 //Software Revision Byte 0 – xx Byte 1 – yy Byte 2 -  zz (Advance Only, Standard set to 0)
                                          //Where xx,yy, zz are unsigned characters Software Revision = xx.yy.zz for Advance Software Revision = xx.yy for Standard
#define CARRIER_COMP_SP1             2604 //Compartment 1 Setpoint
#define CARRIER_COMP_SP2             2605 //Compartment 2 Setpoint
#define CARRIER_COMP_SP3             2606 //Compartment 3 Setpoint
#define CARRIER_AMBIENT              2607 //Temperature Sensor Ambient
#define CARRIER_TEMP_COMP1_RET       2608 //Temperature Sensor Compartment 1 Return
#define CARRIER_TEMP_COMP1_SUPL      2609 //Temperature Sensor Compartment 1 Supply
#define CARRIER_TEMP_COMP2_RET       2610 //Temperature Sensor Compartment 2 Return
#define CARRIER_TEMP_COMP2_SUPL      2611 //Temperature Sensor Compartment 2 Supply
#define CARRIER_TEMP_COMP3_RET       2612 //Temperature Sensor Compartment 2 Return
#define CARRIER_TEMP_COMP3_SUPL      2613 //Temperature Sensor Compartment 2 Supply
#define CARRIER_REMOTE_SENS1         2614 //Remote Sensor 1
#define CARRIER_REMOTE_SENS2         2615 //Remote Sensor 2
#define CARRIER_REMOTE_SENS3         2616 //Remote Sensor 3
#define CARRIER_BATTERY_VOL          2617 //Battery Voltage
#define CARRIER_FUEL_LEVEL           2618 //Fuel Level  digital FF = No device
                                          // If digital – 0 – fuel level ok, 1 – fuel level low
                                          // (Advance Only, Standard set to FFH)
                                          // FFH - not used; FEH - no valid
#define CARRIER_DOOR_SW              2619 //Door Switch Status  0 = Closed 1 = Open FF = Not enabled or Not applicable based on model
                                          // NOTE: Bits Set based on configuration of switches, not state of the output
#define CARRIER_REMOTE_SW1           2620 //Remote Switch 1 0 = Closed 1 = Open FF = Not enabled or Not applicable based on model (Advance Only, Standard set to FFH)
#define CARRIER_REMOTE_SW2           2621 //Remote Switch 2 0 = Closed 1 = Open FF = Not enabled or Not applicable based on model (Advance Only, Standard set to FFH)
#define CARRIER_ENG_COOLANT          2622 //Engine Coolant
#define CARRIER_RPM                  2623 //RPM
#define CARRIER_REMOTE_SW3           2624 //Remote Switch 3 0 = Closed 1 = Open FF = Not enabled or Not applicable based on model  (APX only)
#define CARRIER_REMOTE_SW4           2625 //Remote Switch 4 0 = Closed 1 = Open FF = Not enabled or Not applicable based on model  (APX only)
#define CARRIER_ENG_HOURS            2626 //Total Engine Hours
#define CARRIER_STBY_HOURS           2627 //Total Standby Hours
#define CARRIER_SW_ON_HOURS          2628 //Total Switch On Hours
#define CARRIER_PREV_HOUR_M1         2629 //Preventative Maintenance Hour Meter 1 – Time to maintenance for Meter 1
#define CARRIER_PREV_HOUR_M2         2630 //Preventative Maintenance Hour Meter 2 – Time to maintenance for Meter 2
#define CARRIER_PREV_HOUR_M3         2631 //Preventative Maintenance Hour Meter 3 – Time to maintenance for Meter 3
#define CARRIER_PREV_HOUR_M4         2632 //Preventative Maintenance Hour Meter 4 – Time to maintenance for Meter 4
#define CARRIER_PREV_HOUR_M5         2633 //Preventative Maintenance Hour Meter 5 – Time to maintenance for Meter 5
#define CARRIER_ACT_INTELLISET       2634 //Active IntelliSet Name("" if not active and not modified)
#define CARRIER_INTELLISET_FNAME     2635 //IntelliSet File Name  20 bytes in ASCII
#define CARRIER_NUM_INTELLISET       2636 //Number of Intellisets ( 0 if Intelliset option not installed OR no intellisets loaded ORIntellisets are not valid for model)
#define CARRIER_INTELLISET1_NAME     2637 //Intelliset 1 Name  20 bytes in ASCII
#define CARRIER_INTELLISET2_NAME     2638 //Intelliset 2 Name  20 bytes in ASCII
#define CARRIER_INTELLISET3_NAME     2639 //Intelliset 3 Name  20 bytes in ASCII
#define CARRIER_INTELLISET4_NAME     2640 //Intelliset 4 Name  20 bytes in ASCII
#define CARRIER_INTELLISET5_NAME     2641 //Intelliset 5 Name  20 bytes in ASCII
#define CARRIER_INTELLISET6_NAME     2642 //Intelliset 6 Name  20 bytes in ASCII
#define CARRIER_INTELLISET7_NAME     2643 //Intelliset 7 Name  20 bytes in ASCII
#define CARRIER_INTELLISET8_NAME     2644 //Intelliset 8 Name  20 bytes in ASCII
#define CARRIER_INTELLISET9_NAME     2645 //Intelliset 9 Name  20 bytes in ASCII
#define CARRIER_INTELLISET10_NAME    2646 //Intelliset 10 Name  20 bytes in ASCII
#define CARRIER_INTELLISET11_NAME    2647 //Intelliset 11 Name  20 bytes in ASCII
#define CARRIER_INTELLISET12_NAME    2648 //Intelliset 12 Name  20 bytes in ASCII
#define CARRIER_INTELLISET13_NAME    2649 //Intelliset 13 Name  20 bytes in ASCII
#define CARRIER_INTELLISET14_NAME    2650 //Intelliset 14 Name  20 bytes in ASCII
#define CARRIER_INTELLISET15_NAME    2651 //Intelliset 15 Name  20 bytes in ASCII
#define CARRIER_INTELLISET16_NAME    2652 //Intelliset 16 Name  20 bytes in ASCII
#define CARRIER_INTELLISET17_NAME    2653 //Intelliset 17 Name  20 bytes in ASCII
#define CARRIER_INTELLISET18_NAME    2654 //Intelliset 18 Name  20 bytes in ASCII
#define CARRIER_INTELLISET19_NAME    2655 //Intelliset 19 Name  20 bytes in ASCII
#define CARRIER_INTELLISET20_NAME    2656 //Intelliset 20 Name  20 bytes in ASCII
#define CARRIER_INTELLISET21_NAME    2657 //Intelliset 21 Name  20 bytes in ASCII
#define CARRIER_INTELLISET22_NAME    2658 //Intelliset 22 Name  20 bytes in ASCII
#define CARRIER_INTELLISET23_NAME    2659 //Intelliset 23 Name  20 bytes in ASCII
#define CARRIER_INTELLISET24_NAME    2660 //Intelliset 24 Name  20 bytes in ASCII
#define CARRIER_INTELLISET25_NAME    2661 //Intelliset 25 Name  20 bytes in ASCII
#define CARRIER_INTELLISET26_NAME    2662 //Intelliset 26 Name  20 bytes in ASCII
#define CARRIER_INTELLISET27_NAME    2663 //Intelliset 27 Name  20 bytes in ASCII
#define CARRIER_INTELLISET28_NAME    2664 //Intelliset 28 Name  20 bytes in ASCII
#define CARRIER_INTELLISET29_NAME    2665 //Intelliset 29 Name  20 bytes in ASCII
#define CARRIER_INTELLISET30_NAME    2666 //Intelliset 30 Name  20 bytes in ASCII
#define CARRIER_INTELLISET31_NAME    2667 //Intelliset 31 Name  20 bytes in ASCII
#define CARRIER_C1_CONTR_PROBE       2668 //C1 Control Probe 0=Return, 1=Supply
#define CARRIER_TEMP_UNITS           2669 //Temperature Units 0=Fahrenheit, 1=Celcius
#define CARRIER_PRESS_UNITS          2670 //Pressure Units 0=psig, 1=bars
#define CARRIER_AIR_FLOW             2671 //Air Flow 0=normal, 1=high
#define CARRIER_DEFROST_INTERV       2672 //Defrost Interval 0=1.5hrs, 1=3hrs, 2=6hrs, 3=12hrs
#define CARRIER_FRESH_PROTECT        2673 //Fresh Protect 0-OFF, 1=A, 2=B, 3=C, 4=D, 5=E (Advance Only, Standard set to FFH)
#define CARRIER_C2_CONTR_PROBE       2674 //C2 Control Probe 0=Return, 1=Supply
#define CARRIER_AFAX_STATUS          2675 //AFAX status 0=not installed, 1=standard
#define CARRIER_AFAX_SETTING         2676 //AFAX setting 0=closed, 1= open, 2=variable
#define CARRIER_AFAX_CFM_CONTR       2677 //AFAX CFN control  0, 5-50
#define CARRIER_PRET_TEST_NUM        2678 //Pretrip Test Number
#define CARRIER_PRET_SUBTEST_N       2679 //Pretrip Sub-test Number
#define CARRIER_PRET_TIME_DISP       2680 //Pretrip Time Display Value
#define CARRIER_PRET_TYPE            2681 //Type 0=Short, 1=Long Currently, this will always return “Short”.
#define CARRIER_OVER_PRET_STAT       2682 //Overall Pretrip Status 0 = Pretrip Pass,
                                          //1 = Pretrip Failed and Completed,
                                          //2 = Pretrip Failed and Not Completed, 3 = Pretrip Cannot Start,
                                          //4 = Pretrip Aborted by User
                                          //5 = Pretrip In Progress
                                          //0xFF = Pretrip Never Performed
#define CARRIER_PRET_TEST1           2683 //Test 1   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST2           2684 //Test 2   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST3           2685 //Test 3   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST4           2686 //Test 4   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST5           2687 //Test 5   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST6           2688 //Test 6   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST7           2689 //Test 7   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST8           2690 //Test 8   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST9           2691 //Test 9   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST10          2692 //Test 10  00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST11          2693 //Test 11   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST12          2694 //Test 12   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST13          2695 //Test 13   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST14          2696 //Test 14   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST15          2697 //Test 15   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST16          2698 //Test 16   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST17          2699 //Test 17   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST18          2700 //Test 18   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST19          2701 //Test 19   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST20          2702 //Test 20   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST21          2703 //Test 21   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST22          2704 //Test 22   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST23          2705 //Test 23   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST24          2706 //Test 24   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_PRET_TEST25          2707 //Test 25   00 = fail,01 = pass,02 = aborted,03 = Not applicable
#define CARRIER_MODEL_NUM            2708 //Model Number
#define CARRIER_OPER_MODE            2709 //Operating Mode 0 –  Customized  1 –  Ecofuel 2 –  OptiCold
#define CARRIER_OPER_MODE_LOCK       2710 //Operating Mode Lock  0 – Unlock 1 -  Lock
#define CARRIER_C_PIEK_OV_STAT       2711 //City Piek Mode Override Status
#define CARRIER_C_PIEK_M_STAT        2712 //Current City Piek Mode Status
#define CARRIER_SUCT_PRESS           2713 //Compressor Sensors  Suction Pressure
#define CARRIER_DISCH_PRESS          2714 //Compressor Sensors  Discharge Pressure
#define CARRIER_DISCH_TEMP           2715 //Compressor Sensors  Discharge Temperature
#define CARRIER_SMV_POS              2716 //Compressor Sensors  SMV position
#define CARRIER_EXP_VALVE_POS        2717 //Evaporator Sensors  Expansion Valve Position
#define CARRIER_OUTL_TEMP            2718 //Evaporator Sensors  Outlet Temperature
#define CARRIER_OUTL_PRESS           2719 //Evaporator Sensors  Outlet Pressure
#define CARRIER_DTT1                 2720 //Defrost Termination Temperature (DTT) 1
#define CARRIER_DTT2                 2721 //Defrost Termination Temperature (DTT) 2
#define CARRIER_COMP2_DTT            2722 //Compartment 2 DTT
#define CARRIER_COMP3_DTT            2723 //Compartment 3 DTT
#define CARRIER_BAT_CURR             2724 //Battery DC Current
#define CARRIER_AC_CURR1             2725 //Total AC Current 1
#define CARRIER_AC_CURR2             2726 //Total AC Current 2
#define CARRIER_MAP_SENS             2727 //Manifold Atmospheric Pressure
#define CARRIER_LEN_A_ALARMS         2728 //Length of Active Alarm Queue/Index of Inactive Alarm Queue
#define CARRIER_A_ALRM1              2729 //Alarm Number 1 (APX/Zenith only)
#define CARRIER_A_ALRM2              2730 //Alarm Number 2 (APX/Zenith only)
#define CARRIER_A_ALRM3              2731 //Alarm Number 3 (APX/Zenith only)
#define CARRIER_A_ALRM4              2732 //Alarm Number 4 (APX/Zenith only)
#define CARRIER_A_ALRM5              2733 //Alarm Number 5 (APX/Zenith only)
#define CARRIER_A_ALRM6              2734 //Alarm Number 6 (APX/Zenith only)
#define CARRIER_A_ALRM7              2735 //Alarm Number 7 (APX/Zenith only)
#define CARRIER_A_ALRM8              2736 //Alarm Number 8 (APX/Zenith only)
#define CARRIER_A_ALRM9              2737 //Alarm Number 9 (APX/Zenith only)
#define CARRIER_A_ALRM10             2738 //Alarm Number 10 (APX/Zenith only)
#define CARRIER_A_ALRM11             2739 //Alarm Number 11 (APX/Zenith only)
#define CARRIER_A_ALRM12             2740 //Alarm Number 12 (APX/Zenith only)
#define CARRIER_A_ALRM13             2741 //Alarm Number 13 (APX/Zenith only)
#define CARRIER_A_ALRM14             2742 //Alarm Number 14 (APX/Zenith only)
#define CARRIER_A_ALRM15             2743 //Alarm Number 15 (APX/Zenith only)
#define CARRIER_A_ALRM16             2744 //Alarm Number 16 (APX/Zenith only)
#define CARRIER_KOHLER_PCOD1         2745 //5 bytes per PCode. Upto 16 PCodes (16x5 = 80)
#define CARRIER_KOHLER_PCOD2         2746 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD3         2747 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD4         2748 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD5         2749 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD6         2750 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD7         2751 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD8         2752 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD9         2753 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD10        2754 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD11        2755 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD12        2756 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD13        2757 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD14        2758 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD15        2759 //5 bytes per PCode.
#define CARRIER_KOHLER_PCOD16        2760 //5 bytes per PCode.
#define CARRIER_TYPE_MP              2761 // Type of the Microprocessor Controller  0 = CARRIER_STANDARD ,  1 = CARRIER_ADVANCE ,  2 = CARRIER_APX
#define CARRIER_FUEL_LEVEL_AN        2762 //Fuel Level analog
                                          // indicates fuel level (integer with range 0 – 100%)
                                          // Value 118- corresponds to -10% (Out of range low)
                                          // Value 110- corresponds to 110% (Out of range high)
                                          // (Advance Only, Standard set to FFH)
                                          // FFH - not used; FEH - no valid
#define CARRIER_COMMAND              2763 //Массив из 8-ми байт для формата команды
#define CARRIER_COMMAND_ANS          2764 // Массив из 5-ти байт для формата ответа на команду

#define MDAS9_COOMUNICATION_STATE    2770 //Cвязь с MDAS-9 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define MDAS9_SPEED                  2771 //Speed ( 0 ~ 255)
#define MDAS9_LEFT_TURN_SIGNAL       2772 //Left turn signal 0 - None, 1 - On
#define MDAS9_RIGHT_TURN_SIGNAL      2773 //Right turn signal 0 - None, 1 - On
#define MDAS9_BRAKE_SIGNAL           2774 //Brake signal 0 - None, 1 - On
#define MDAS9_RPM                    2775 // 0 ~ 65535 RPM[0] MSB / RPM[1] LSB
#define MDAS9_LDW_LEFT               2776 //LDW (Line Departure Warning) left 0x00 – None/ 0x01 – Recognized/ 0x02 – Left LDW event/ 0x03 – Function disabled
#define MDAS9_LDW_RIGHT              2777 //LDW (Line Departure Warning) right 0x00 – None/ 0x01 – Recognized/ 0x02 – Left LDW event/ 0x03 – Function disabled
#define MDAS9_LEFT_DISTANCE          2778 //Length of left lane (cm) Left[0] MSB / Left[1] LSB
#define MDAS9_RIGHT_DISTANCE         2779 //Length of right lane (cm) Right[0] MSB / Right[1] LSB
#define MDAS9_TTC                    2780 //TTC time  0 ~ 25.5 sec Ex) 125 => 12.5sec
#define MDAS9_SDA                    2781 //SDA (Safety Distance Alert)  0x00 – None/ 0x01 – Recognized (ahead vehicle)/ 0x02 – SDA event/ 0x03 – Function disabled
#define MDAS9_FVSA                   2782 //FVSA (Front Vehicle Start Alarm) 0x00 – None/  0x02 – FVSA event/   0x03 – Function disabled
#define MDAS9_FPW                    2783 //FPW (Forward Proximity Warning) 0x00 – None/ 0x02 – FPW event/  0x03 – Function disabled
#define MDAS9_FCW                    2784 //FCW (Forward Collision Warning) 0x00 – None/ 0x02 – FCW event/  0x03 – Function disabled
#define MDAS9_PCW                    2785 //PCW (Pedestrian Collision Warning) 0x00 – None/ 0x01 – Recognized/ 0x02 – PCW event/ 0x03 – Function disabled
#define MDAS9_RECORD                 2786 //Record  0x00 – None/ 0x01 – Recording (Mic off)/ 0x02 – Recording (Mic On)
#define MDAS9_ERROR                  2787 //Error Code 0x00 – None/ 0x01 – Low visibility/ 0x02 – Camera blocked
#define MDAS9_AHEAD_DISTANSE         2788 // 0m ~ 150m / 0x00 – 0x96 None : 0xff Only 0x91 / 0x92
#define MDAS9_AHEAD_SPEED            2789 // -128km/h ~ 0Km ~ 126Km 0x00 ~ 0x80 ~ 0xfe  None : 0xff Only 0x91 / 0x92
#define MDAS9_SLR_STATE              2790 //SLR (Speed Limit Recongnition) 0x00 – None 0x02 – Over speed Event 0x03 – Function Disabled
#define MDAS9_SLR_RECOGNIZE          2791 //0x00 - None/ 0x1E – 30Km/ 0x28 – 40Km/ 0x32 – 50Km/ 0x3C – 60Km/ 0x46 – 70Km/ 0x50 – 80Km/ 0x5A – 90Km/ 0x64 – 100Km/ 0x6E – 110Km/ 0x78 – 120Km
#define MDAS9_SLR_SENSITIVITY        2792 //0x00 – 0%/ 0x05 – 5%/ 0x0A – 10%/ 0x0F – 15%/ 0x14 – 20%/ 0xFF – Unknown

#define IAKM_TEMP_SENS               2793 //Температура, °C
#define IAKM_TEMP_ERROR              2794 //Коды ошибок канала температуры
#define IAKM_HUM_SENS                2795 //Относительная влажность, %
#define IAKM_HUM_ERROR               2796 //Коды ошибок канала относительной влажности
#define SCD30_TEMP_SENS              2797 //Температура, °C
#define SCD30_HUM_SENS               2798 //Относительная влажность, %
#define SCD30_CO2_SENS               2799 //CO2, ppm
/*
#define CAN_SECURITY_BITFIELD_0 2939   //Флаги состояния безопасности, битовое поле 0
#define CAN_SECURITY_BITFIELD_6 2945   //Флаги состояния безопасности, битовое поле 6
#define CAN_CONTROL_BITFIELD_0  2946   //Флаги состояния контроля, битовое поле 0
#define CAN_CONTROL_BITFIELD_15 2961   //Флаги состояния контроля, битовое поле 15
#define CAN_AGRO_BITFIELD_0     2962   //Флаги состояния сельхозтехники, битовое поле 0
#define CAN_AGRO_BITFIELD_11    2973   //Флаги состояния сельхозтехники, битовое поле 11
#define CAN_SPEC_BITFIELD_0     2974   //Специальные флаги, битовое поле 0
#define CAN_SPEC_BITFIELD_18    2993   //Специальные флаги, битовое поле 18
*/

#define CUSTOM_CAN_SENSOR_FIRST_ID      2800
#define CUSTOM_CAN_SENSOR_NUMBER_MAX_MAXIMORUM 128 //Предельное значение кастомных датчиков
#define CUSTOM_CAN_SENSOR_LAST_ID       (CUSTOM_CAN_SENSOR_FIRST_ID+CUSTOM_CAN_SENSOR_NUMBER_MAX_MAXIMORUM-1)
//reserve 48
#define CUSTOM_CAN_STR_SENSOR_FIRST_ID  2975
#define CUSTOM_CAN_STR_SENSOR_NUMBER_MAX_MAXIMORUM 4
#define CUSTOM_CAN_STR_SENSOR_LAST_ID   (CUSTOM_CAN_STR_SENSOR_FIRST_ID+CUSTOM_CAN_STR_SENSOR_NUMBER_MAX_MAXIMORUM-1)
//reserve 6
#define CAN_CUSTOM_SENSOR_BAD_CRC_BF    2985
#define ISOTP_CAN_CUSTOM_SENSOR_BAD_CRC_BF  2986
#define CAN_CUSTOM_SENSOR_SETTINGS_KEY_HASH 2987
#define ISOTP_CAN_SENSOR_SETTINGS_VERS  2988
#define CAN1_HW_STATE                   2989
#define CAN2_HW_STATE                   2990
#define CAN3_HW_STATE                   2991
#define CAN4_HW_STATE                   2992
#define CUSTOM_CAN_SENSOR_SETTINGS_VERS 2993

#define CAN_SPECIAL_FLAGS_BITFIELD  2994 //Битовое поле специальных флагов
                                         //0: Секция 1 – наличие жидкости в сливной трубе,  1: Секция 1 – полная,   2: Секция 1 – переполнена
                                         //3: Секция 2 – наличие жидкости в сливной трубе,  4: Секция 2 – полная,   5: Секция 2 – переполнена
                                         //6: Секция 3 – наличие жидкости в сливной трубе,  7: Секция 3 – полная,   8: Секция 3 – переполнена
                                         //9: Секция 4 – наличие жидкости в сливной трубе,  10: Секция 4 – полная,  11: Секция 4 – переполнена
                                         //12: Секция 5 – наличие жидкости в сливной трубе, 13: Секция 5 – полная,  14: Секция 5 – переполнена
                                         //15: Секция 6 – наличие жидкости в сливной трубе, 16: Секция 6 – полная,  17: Секция 6 – переполнена
                                         //18: Секция 7 – наличие жидкости в сливной трубе, 19: Секция 7 – полная,  20: Секция 7 – переполнена
                                         //21: Секция 8 – наличие жидкости в сливной трубе, 22: Секция 8 – полная,  23: Секция 8 – переполнена
#define CAN_SECURITY_NAVIS_BITFIELD 2995 //Флаги состояния безопасности для протоколов NAVIS и NDTP, битовое поле
#define CAN_CONTROL_NAVIS_BITFIELD  2996 //Флаги состояния контроля для протоколов NAVIS и NDTP, битовое поле
#define CAN_AGRO_NAVIS_BITFIELD     2997 //Флаги состояния сельхозтехники для протокола NAVIS, битовое поле

#define CAN_SYS_INF             2998     //Информация о загрузчике CAN
#define CAN_UPD_PCT             2999     //Процент обновления CAN процессора

////// Параметры конфигурации устройства ///////////////////////////////////////
// Соединение
#define VEGA_SETTING_START_ID           3000
#define VEGA_SETTING_SERVER_ADDR        3001    //Адрес сервера
#define VEGA_SETTING_APN                3002    //APN
#define VEGA_SETTING_BALANCE_CODE       3003    //Код запроса баланса
#define VEGA_SETTING_TRANSLATE_SENSORS  3004    //Настройки регулярной передачи информации с датчиков на сервер
#define VEGA_SETTING_NDTP_ADDRESS       3005    //Серийный номер устройства (для использования в протоколе NDTP)
#define VEGA_SETTING_USE_SERVER_PIN     3006    //Использовать авторизацию на сервере
#define VEGA_SETTING_SERVER_PIN         3007    //ПИН-код для авторизации на сервере
#define VEGA_MAIN_YANDEX_SERVER_ID      3008    //Allowable values 0 1 2 3

// Черный ящик
#define VEGA_SETTING_BLACKBOX           3100    //Настройки черного ящика

// Трек
#define VEGA_SETTING_TRACK_RECORD       3101	//Параметры записи трека
#define VEGA_SETTING_STOP_FILTER        3102	//Фильтрация трека на стоянках
#define VEGA_SETTING_INERTIAL_NAV       3103	//Использовать инерциальную навигацию
#define VEGA_SETTING_HDOP_FILTER        3104	//Фильтрация трека по HDOP
#define VEGA_SETTING_GPS_ODOMETER       3105	//Сбрасывать одометр GPSна стоянках
#define VEGA_SETTING_GPS_ALWAYS_LOCATE  3106	//Передавать последнюю валидную координату даже если нет решения
#define VEGA_SETTING_ODOMETER_BY_IGN    3107    //Инкрементировать одометр только при включенном зажигании
#define VEGA_SETTING_USED_NAV_SYSTEM    3108    //Используемая навигационная система
#define VEGA_SETTING_NAV_EXT_FILTERS    3109    //Расширенные настройки фильтров

// Энергосбережение
#define VEGA_SETTING_POWER_SAVING       3201	// Настройки энергосбережения
#define VEGA_SETTING_WAKEUP_BY_CAN      3202    // Просыпаться по активности на CAN-шине

// Безопасность
#define VEGA_SETTING_PIN_CODE           3251	//Пин-код  доступа к устройству
#define VEGA_SETTING_USE_PIN_CODE       3252	//Использовать парольный доступ
#define VEGA_SETTING_AUTORIZED_PHONE    3253	//Авторизованные телефоны
#define VEGA_SETTING_AUTORIZED_KEY      3254	//Авторизованные ключи

// Геозоны
#define VEGA_SETTING_GEOZONE            3301	//Настройки геозоны Х

// Датчики
#define VEGA_SETTING_PULSE_INPUT        3351	//Импульсный вход Х
#define VEGA_SETTING_FREQ_INPUT         3352	//Частотный вход X
#define VEGA_SETTING_FREQ_OUTPUT        3353	//Частотный выход Х
#define VEGA_SETTING_FUEL_LEVEL         3354	//Датчик уровня топлива Х
#define VEGA_SETTING_EXT_TEMP           3356	//Датчик температуры внешний Х (шина dallas)
#define VEGA_SETTING_IGNITION           3357	//Датчик зажигания
#define VEGA_SETTING_GSENSOR_MOVE       3359	//Датчик движения акселерометра
#define VEGA_SETTING_GPS_MOVE           3360	//Датчик движения GPS
#define VEGA_SETTING_ALARM_BUTTON       3361	//Тревожная кнопка
#define VEGA_SETTING_USE_CAN_IGN        3362    //Использовать показания зажигания с CAN-шины автомобиля
#define VEGA_SETTING_AUTORIZATION       3363	//Датчик авторизации
#define VEGA_SETTING_MOTOHOURS          3364	//Датчик моточасов
#define VEGA_SETTING_CAMERA             3365	//Фотокамера
#define VEGA_SETTING_CAMERA_TYPE        3366	//Тип фотокамеры
#define VEGA_SETTING_DIGITAL_INPUTS     3367	//Цифровые входы
#define VEGA_SETTING_TEMP_ADD_MODE      3368	//Режим добавления новых датчиков температуры
#define VEGA_SETTING_KEYS_ADD_MODE      3369	//Режим добавления новых ключей
#define VEGA_SETTING_CAN                3370    //Настройки CAN-процессора
#define VEGA_SETTING_MFI                3371    //Настройки мультифункциональных входов
#define VEGA_SETTING_ALARM_BUTTON_TIMEOUT 3372	//Длительность нажатия тревожной кнопки

#define VEGA_SETTING_TYPE_DAT           3373	//Тип темературных датчиков терморегистратора TR-1 1-LORA, 2-DALLAS, 3-аналоговый (терморезистор)
#define VEGA_SETTING_MAXNUMCOMPARTMENT  3374    //макс.кол-во отсеков
#define VEGA_SETTING_SENS_COMPARTMENT   3375	//Привязка датчиков к отсекам
#define VEGA_SETTING_PERIOD_BB_TR_TIME  3376    //периодичность считывания темп.датчиков 1...60мин
#define VEGA_SETTING_VIN_AUTO           3377    //VIN автомобиля
#define VEGA_SETTING_TR_HEADER          3378    //Текст заголовка
#define VEGA_SETTING_ID_OWNER           3379    //ID владельца
#define VEGA_SETTING_LORA_DDAT          3380    //Настройки цифровых датчиков LORA bit0-цепь, bit1-, bit2-датчик отрыва, bit3-датчик вскрытия, bit4-датчик температуры

#define VEGA_SETTING_FUEL_LEVEL_FORCE_READ  3390 // time in minutes for FUEL LEVEL updating
#define VEGA_SETTING_PUMP               3391

// Сценарии
#define VEGA_SETTING_SCENARIES          4001	//Настройка сценария Х
#define VEGA_SETTING_SCENARIES_I        4002	//Настройка сценария IRIDIUM

// Счетчик настроек + CRC
#define VEGA_SETTINGS_INFO                5000  // Только для блока. Не должен попадать в файл настроек от конфигуратора.

// Внешняя плата расширения
#define VEGA_SETTING_EXT_MFI_1_TYPE       5001  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_2_TYPE       5002  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_3_TYPE       5003  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_4_TYPE       5004  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_5_TYPE       5005  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_6_TYPE       5006  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_7_TYPE       5007  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_8_TYPE       5008  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_9_TYPE       5009  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_10_TYPE      5010  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_11_TYPE      5011  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_12_TYPE      5012  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_13_TYPE      5013  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_14_TYPE      5014  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_15_TYPE      5015  // Тип мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_1_POLARITY   5016  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_2_POLARITY   5017  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_3_POLARITY   5018  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_4_POLARITY   5019  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_5_POLARITY   5020  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_6_POLARITY   5021  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_7_POLARITY   5022  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_8_POLARITY   5023  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_9_POLARITY   5024  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_10_POLARITY  5025  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_11_POLARITY  5026  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_12_POLARITY  5027  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_13_POLARITY  5028  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_14_POLARITY  5029  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_MFI_15_POLARITY  5030  // Полярность мультифункционального входа платы расширения
#define VEGA_SETTING_EXT_BR_INTERFACE     5031  // Интерфейс к которому подключена внешняя плата расширения
// Carrier data cold 600
#define VEGA_SETTING_FRIDGE_INTERFACE     5032  // Интерфейс к которому подключен терморегистратор
#define VEGA_SETTING_FRIDGE_PROTOCOL      5033  // Протокол терморегистратора
// Радиометки
#define VEGA_SETTING_NRF_BEACONS_READER_INTERFACE 5034 // Интерфейс, к которому подключен считыватель радиометок
#define VEGA_SETTING_NRF_BEACON_ID       5035          // ID радиометки
// Весы тензо-м
#define VEGA_SETTING_TENZO_M_INTERFACE   5036   // Интерфейс, к которому подключены весы Тензо М
#define VEGA_SETTING_TENZO_M_ADDRESS     5037   // Адрес весов на интерфейсе
// Процессор весовой ПВ-310
#define VEGA_SETTING_PV310_INTERFACE     VEGA_SETTING_TENZO_M_INTERFACE   // Интерфейс, к которому подключены весы ПВ-310
#define VEGA_SETTING_PV310_ADDRESS       VEGA_SETTING_TENZO_M_ADDRESS     // Адрес весов на интерфейсе
// Считыватель датчиков LoRa
#define VEGA_SETTING_LORASENS_INTERFACE  5038
#define VEGA_SETTING_LORASENS            5039
// iQFreeze
#define VEGA_SETTING_IQFREEZE_INTERFACE    5040
#define VEGA_SETTING_IQFREEZE_POLLL_PERIOD 5041
// TOUCHPRINT
#define VEGA_SETTING_TOUCHPRINT_INTERFACE  5042
// IBOX
#define VEGA_SETTING_IBOX_INTERFACE        5043
// VOICE_CALL
#define VEGA_SETTING_VOICE_CALL            5044
// RESERVE
#define VEGA_SETTING_RESERVE_5045          5045  // Резерв
// FLOWMETER
#define VEGA_SETTING_FLOWMETER_INTERFACE   5046  // Интерфейс, к которому подключен расходомер eurosens Delta RS
#define VEGA_SETTING_FLOWMETER_ADDRESS     5047  // Адрес расходомера на интерфейсе
// TPMS tire pressure monitoring system
#define VEGA_SETTING_TPMS_INTERFACE        5046   // Интерфейс, к которому подключен TPMS
#define VEGA_SETTING_TPMS_POLL_PERIOD      5047
// CARRIER
#define VEGA_SETTING_CARRIER_INTERFACE     5048   // Интерфейс, к которому подключен Carrier
#define VEGA_SETTING_CARRIER_TYPE          5049
// MDAS-9
#define VEGA_SETTING_MDAS9_INTERFACE       5050   // Интерфейс, к которому подключен MDAS-9
// RS-232-2
#define VEGA_SETTING_RS232_2               5051   // Назначение 2-го интерфейса RS-232 0-отключен, 1-Телематика(с протоколом Vega для потребителей)/2-спутниковый модем Iridium/3-внешний дисплей
#define VEGA_SETTING_USE_READ_PARAM        5052   // Для 2-го интерфейса RS-232: 0-отключен, 1-В режиме Телематика допускается считывать параметры
#define VEGA_SETTING_USE_SET_PARAM         5053   // Для 2-го интерфейса RS-232: 0-отключен, 1-В режиме Телематика допускается устанавливать параметры
#define VEGA_SETTING_USE_SET_REFRIDGE      5054   // Для 2-го интерфейса RS-232: 0-отключен, 1-В режиме Телематика допускается устанавливать параметры для рефрижератов Carrier
//Датчик влажности и температуры  IAKM.00.F148.517.S53
#define VEGA_SETTING_HUM_SENSOR_IAKM_INTERFACE   5055  // Интерфейс, к которому подключен датчик
#define VEGA_SETTING_HUM_SENSOR_IAKM_ADDRESS     5056  // Адрес датчика Modbus
//Датчик CO2,влажности и температуры  Sensirion SCD30 Sensor Module
#define VEGA_SETTING_SCD30_INTERFACE             5057  // Интерфейс, к которому подключен датчик SCD30
//Порог напряжения питания на засыпание  Voltage threshold
#define VEGA_SETTING_VOLTAGE_TRESHOLD            5058
//Время на переход в режим сна, в сек
#define VEGA_SETTING_TIMER_SLEEPING_MODE         5059
//Настройки внешней BLE платы
#define VEGA_SETTING_BLE_EXT_BOARD               5070
//Настроки DM2002X
#define VEGA_SETTING_DM5002X                     5071
//Настроки BASE_STATION_BT
#define VEGA_SETTING_BS_BT                       5072
//Нстройки GSM модема
#define VEGA_SETTINGS_GSM_MODEM                  5073
//Нстройки датчиков BLE
#define VEGA_SETTINGS_BLE_SENSORS                5074
// OMNICOMM ICON
#define VEGA_SETTING_OMNICOMM_ICON               5075   // Интерфейс, к которому подключен OMNICOMM ICON
// MDSM-7
#define VEGA_SETTING_MDSM7_INTERFACE             5076   // Интерфейс, к которому подключен MDSM-7
//THERMALMASTER
#define VEGA_SETTING_THERMALMASTER_INTERFACE     5077   // Интерфейс, к которому подключен THERMAL MASTER

//canlog_v4 custom
#define VEGA_SETTING_RESERVE_5078                     5078  // Резерв
#define VEGA_SETTING_CANLOG_V4_CUSTOM_SENSORS_EXT     5079
#define VEGA_SETTING_CANLOG_V4_CUSTOM_SENSORS         5080

// ZANOTTI
#define VEGA_SETTING_ZANOTTI_INTERFACE                5081   // Интерфейс ZANOTTI
//ХОУ Thermo_King_SLX_T_UT
#define VEGA_SETTING_SR3_INTERFACE                    5082   //Интерфейс ХОУ Thermo_King_SLX_T_UT (CAN3)
//Vega can
#define VEGA_SETTING_CAN_CUSTOM_SENSORS_GROUP_NAME    5499
#define VEGA_SETTING_CAN_CUSTOM_SENSORS               5500
#define VEGA_SETTING_CAN_MODULS_SETTINGS              5501
#define VEGA_SETTING_CAN_TX_SCRIPT_SETTINGS           5502
#define VEGA_SETTING_ISOTP_CAN_SENSORS_SETTINGS       5503
#define VEGA_SETTING_IMMO_FLANKER_SETTINGS            5504 // Настройка обходчика immo
#define VEGA_SETTING_RS_TACHO_SETTINGS                5505 // Настройки тахо
#define VEGA_SETTING_CAN_CUSTOM_SENSORS_TRANS_TABLE   5506
#define VEGA_SETTING_CAN_EXTENDED_MODE                5507
#define VEGA_SETTING_SAVER_SETTINGS                   5507

//Custom scripts
#define VEGA_SETTINGS_SCRIPT_SCRIPTS                  5600
#define VEGA_SETTINGS_SCRIPT_COMMANDS                 5601
#define VEGA_SETTINGS_SCRIPT_CHECKS                   5602
#define VEGA_SETTINGS_SCRIPT_TRIGGERS                 5603
#define VEGA_SETTINGS_SCRIPT_NOTIFIES                 5604

#define VEGA_SETTING_LAST_ID                          6999 //32999
// -----------------------------------------------------------------------------
//Второй диапазон сенсоров
// -----------------------------------------------------------------------------
//флаги агротеххники, диапазон 2
#define CAN_V4_AGRICULTURAL_FL_D11                    7000
#define CAN_V4_AGRICULTURAL_FL_D12                    7001
#define CAN_V4_AGRICULTURAL_FL_D13                    7002
#define CAN_V4_AGRICULTURAL_FL_D14                    7003
#define CAN_V4_AGRICULTURAL_FL_D15                    7004
#define CAN_V4_AGRICULTURAL_FL_D16                    7005
#define CAN_V4_AGRICULTURAL_FL_D17                    7006
#define CAN_V4_AGRICULTURAL_FL_D18                    7007
#define CAN_V4_AGRICULTURAL_FL_D19                    7008
#define CAN_V4_AGRICULTURAL_FL_D20                    7009

#define BLE_SENSOR1_VISIBLE                           8000
#define BLE_SENSOR1_TIMER                             8001
#define BLE_SENSOR1_RSSI                              8002
#define BLE_SENSOR1_BATT                              8003
#define BLE_SENSOR1_U8                                8004
#define BLE_SENSOR1_I16_1                             8005
#define BLE_SENSOR1_I16_2                             8006
#define BLE_SENSOR1_U16_1                             8007
#define BLE_SENSOR1_U16_2                             8008
#define BLE_SENSOR1_RESERVE1                          8009
#define BLE_SENSOR1_RESERVE2                          8010
#define BLE_SENSOR1_RESERVE3                          8011
#define BLE_SENSOR1_RESERVE4                          8012

#define BLE_SENSOR2_VISIBLE                           8013
#define BLE_SENSOR2_TIMER                             8014
#define BLE_SENSOR2_RSSI                              8015
#define BLE_SENSOR2_BATT                              8016
#define BLE_SENSOR2_U8                                8017
#define BLE_SENSOR2_I16_1                             8018
#define BLE_SENSOR2_I16_2                             8019
#define BLE_SENSOR2_U16_1                             8020
#define BLE_SENSOR2_U16_2                             8021
#define BLE_SENSOR2_RESERVE1                          8022
#define BLE_SENSOR2_RESERVE2                          8023
#define BLE_SENSOR2_RESERVE3                          8024
#define BLE_SENSOR2_RESERVE4                          8025

#define BLE_SENSOR3_VISIBLE                           8026
#define BLE_SENSOR3_TIMER                             8027
#define BLE_SENSOR3_RSSI                              8028
#define BLE_SENSOR3_BATT                              8029
#define BLE_SENSOR3_U8                                8030
#define BLE_SENSOR3_I16_1                             8031
#define BLE_SENSOR3_I16_2                             8032
#define BLE_SENSOR3_U16_1                             8033
#define BLE_SENSOR3_U16_2                             8034
#define BLE_SENSOR3_RESERVE1                          8035
#define BLE_SENSOR3_RESERVE2                          8036
#define BLE_SENSOR3_RESERVE3                          8037
#define BLE_SENSOR3_RESERVE4                          8038

#define BLE_SENSOR4_VISIBLE                           8039
#define BLE_SENSOR4_TIMER                             8040
#define BLE_SENSOR4_RSSI                              8041
#define BLE_SENSOR4_BATT                              8042
#define BLE_SENSOR4_U8                                8043
#define BLE_SENSOR4_I16_1                             8044
#define BLE_SENSOR4_I16_2                             8045
#define BLE_SENSOR4_U16_1                             8046
#define BLE_SENSOR4_U16_2                             8047
#define BLE_SENSOR4_RESERVE1                          8048
#define BLE_SENSOR4_RESERVE2                          8049
#define BLE_SENSOR4_RESERVE3                          8050
#define BLE_SENSOR4_RESERVE4                          8051

#define BLE_SENSOR5_VISIBLE                           8052
#define BLE_SENSOR5_TIMER                             8053
#define BLE_SENSOR5_RSSI                              8054
#define BLE_SENSOR5_BATT                              8055
#define BLE_SENSOR5_U8                                8056
#define BLE_SENSOR5_I16_1                             8057
#define BLE_SENSOR5_I16_2                             8058
#define BLE_SENSOR5_U16_1                             8059
#define BLE_SENSOR5_U16_2                             8060
#define BLE_SENSOR5_RESERVE1                          8061
#define BLE_SENSOR5_RESERVE2                          8062
#define BLE_SENSOR5_RESERVE3                          8063
#define BLE_SENSOR5_RESERVE4                          8064

#define BLE_SENSOR6_VISIBLE                           8065
#define BLE_SENSOR6_TIMER                             8066
#define BLE_SENSOR6_RSSI                              8067
#define BLE_SENSOR6_BATT                              8068
#define BLE_SENSOR6_U8                                8069
#define BLE_SENSOR6_I16_1                             8070
#define BLE_SENSOR6_I16_2                             8071
#define BLE_SENSOR6_U16_1                             8072
#define BLE_SENSOR6_U16_2                             8073
#define BLE_SENSOR6_RESERVE1                          8074
#define BLE_SENSOR6_RESERVE2                          8075
#define BLE_SENSOR6_RESERVE3                          8076
#define BLE_SENSOR6_RESERVE4                          8077

#define BLE_SENSOR7_VISIBLE                           8078
#define BLE_SENSOR7_TIMER                             8079
#define BLE_SENSOR7_RSSI                              8080
#define BLE_SENSOR7_BATT                              8081
#define BLE_SENSOR7_U8                                8082
#define BLE_SENSOR7_I16_1                             8083
#define BLE_SENSOR7_I16_2                             8084
#define BLE_SENSOR7_U16_1                             8085
#define BLE_SENSOR7_U16_2                             8086
#define BLE_SENSOR7_RESERVE1                          8087
#define BLE_SENSOR7_RESERVE2                          8088
#define BLE_SENSOR7_RESERVE3                          8089
#define BLE_SENSOR7_RESERVE4                          8090

#define BLE_SENSOR8_VISIBLE                           8091
#define BLE_SENSOR8_TIMER                             8092
#define BLE_SENSOR8_RSSI                              8093
#define BLE_SENSOR8_BATT                              8094
#define BLE_SENSOR8_U8                                8095
#define BLE_SENSOR8_I16_1                             8096
#define BLE_SENSOR8_I16_2                             8097
#define BLE_SENSOR8_U16_1                             8098
#define BLE_SENSOR8_U16_2                             8099
#define BLE_SENSOR8_RESERVE1                          8100
#define BLE_SENSOR8_RESERVE2                          8101
#define BLE_SENSOR8_RESERVE3                          8102
#define BLE_SENSOR8_RESERVE4                          8103

#define BLE_SENSOR9_VISIBLE                           8104
#define BLE_SENSOR9_TIMER                             8105
#define BLE_SENSOR9_RSSI                              8106
#define BLE_SENSOR9_BATT                              8107
#define BLE_SENSOR9_U8                                8108
#define BLE_SENSOR9_I16_1                             8109
#define BLE_SENSOR9_I16_2                             8110
#define BLE_SENSOR9_U16_1                             8111
#define BLE_SENSOR9_U16_2                             8112
#define BLE_SENSOR9_RESERVE1                          8113
#define BLE_SENSOR9_RESERVE2                          8114
#define BLE_SENSOR9_RESERVE3                          8115
#define BLE_SENSOR9_RESERVE4                          8116

#define BLE_SENSOR10_VISIBLE                          8117
#define BLE_SENSOR10_TIMER                            8118
#define BLE_SENSOR10_RSSI                             8119
#define BLE_SENSOR10_BATT                             8120
#define BLE_SENSOR10_U8                               8121
#define BLE_SENSOR10_I16_1                            8122
#define BLE_SENSOR10_I16_2                            8123
#define BLE_SENSOR10_U16_1                            8124
#define BLE_SENSOR10_U16_2                            8125
#define BLE_SENSOR10_RESERVE1                         8126
#define BLE_SENSOR10_RESERVE2                         8127
#define BLE_SENSOR10_RESERVE3                         8128
#define BLE_SENSOR10_RESERVE4                         8129

#define BLE_SENSOR11_VISIBLE                          8130
#define BLE_SENSOR11_TIMER                            8131
#define BLE_SENSOR11_RSSI                             8132
#define BLE_SENSOR11_BATT                             8133
#define BLE_SENSOR11_U8                               8134
#define BLE_SENSOR11_I16_1                            8135
#define BLE_SENSOR11_I16_2                            8136
#define BLE_SENSOR11_U16_1                            8137
#define BLE_SENSOR11_U16_2                            8138
#define BLE_SENSOR11_RESERVE1                         8139
#define BLE_SENSOR11_RESERVE2                         8140
#define BLE_SENSOR11_RESERVE3                         8141
#define BLE_SENSOR11_RESERVE4                         8142

#define BLE_SENSOR12_VISIBLE                          8143
#define BLE_SENSOR12_TIMER                            8144
#define BLE_SENSOR12_RSSI                             8145
#define BLE_SENSOR12_BATT                             8146
#define BLE_SENSOR12_U8                               8147
#define BLE_SENSOR12_I16_1                            8148
#define BLE_SENSOR12_I16_2                            8149
#define BLE_SENSOR12_U16_1                            8150
#define BLE_SENSOR12_U16_2                            8151
#define BLE_SENSOR12_RESERVE1                         8152
#define BLE_SENSOR12_RESERVE2                         8153
#define BLE_SENSOR12_RESERVE3                         8154
#define BLE_SENSOR12_RESERVE4                         8155

//Датчики SAVER2021
#define SAVER2021_RAW_STATE                           8350
#define SAVER2021_DTC_STR                             8351

#define BASE_STATION_BT                               31000
//#define BS_BT_FIRST_SENSOR                            BASE_STATION_BT+4 // BASE_STATION_BT
#define BS_BT_LAST_SENSOR                             31593//(BS_BT_FIRST_SENSOR+15*10+11*40-1)
// -----------------------------------------------------------------------------

#define MDSM7_COOMUNICATION_STATE                     31600 //Cвязь с MDSM-7 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define MDSM7_SPEED                                   31601 //Speed ( 0 ~ 255)
#define MDSM7_DUMMY_CARINFO                           31602 //Dummy_CARINFO For Extension
#define MDSM7_DSM_EVENT                               31603 //DSM_EVENT
#define MDSM7_DRIVER_NAME                             31604 //Driver Name String ASCII
#define MDSM7_RECORD_STATUS                           31605 //Record Status 0x00- 0x02
#define MDSM7_GPS_STATUS                              31606 //GPS Status 0x00- 0x02
#define MDSM7_LATITUDE                                31607 //GPS Latitude Data/10000 (Decimal Point 4)
#define MDSM7_LONGITUDE                               31608 //GPS Longitude Data/10000 (Decimal Point 4)
#define MDSM7_ERROR_CODE                              31609 //Error Code
#define MDSM7_YEAR                                    31610 //
#define MDSM7_MON                                     31611 //
#define MDSM7_DAY                                     31612 //
#define MDSM7_HOUR                                    31613 //
#define MDSM7_MIN                                     31614 //
#define MDSM7_SEC                                     31615 //
#define MDSM7_G_SENSOR                                31616 //G-Sensor Event 0x00- 0x01
// -----------------------------------------------------------------------------
#define THERMALMASTER_COOMUNICATION_STATE             31620 //Cвязь с THERMAL MASTER 0 - не найден, 1 - найден, 2 - отключен  в настройках
#define THERMALMASTER_INSTEMP                         31621 //1.Current inside temperature
#define THERMALMASTER_OUTIND                          31622 //2.Output indication value
#define THERMALMASTER_VOLTAGE                         31623 //3.Voltage
#define THERMALMASTER_REFTEMP                         31624 //4.Current refrigerated temperature
#define THERMALMASTER_OPHOURSW                        31625 //5.Current operation hours
#define THERMALMASTER_DEFRTEMP                        31626 //6.Current defrost temperature
#define THERMALMASTER_SETTEMP                         31627 //7.Set temperature
#define THERMALMASTER_DEFRCYCLE                       31628 //8.Defrost cycle
#define THERMALMASTER_DEFRTIME                        31629 //9.Defrost time min*10
#define THERMALMASTER_ONOFF                           31630 //10.ON/OFF value
#define THERMALMASTER_TEMPCORR                        31631 //11.Temperature correction value
#define THERMALMASTER_STATUS                          31632 //12.Refrigeration unit status
// -----------------------------------------------------------------------------
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF8       31640 //Битовое поле 8, видимые NRF маяки 225-256 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF8       31641 //Битовое поле 8, низкий заряд батарейки, маяки 225-256 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF9       31642 //Битовое поле 9, видимые NRF маяки 257-288 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF9       31643 //Битовое поле 9, низкий заряд батарейки, маяки 257-288 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF10      31644 //Битовое поле 10, видимые NRF маяки 288-320 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF10      31645 //Битовое поле 10, низкий заряд батарейки, маяки 288-320 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF11      31646 //Битовое поле 11, видимые NRF маяки 321-352 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF11      31647 //Битовое поле 11, низкий заряд батарейки, маяки 321-352 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF12      31648 //Битовое поле 12, видимые NRF маяки 353-384 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF12      31649 //Битовое поле 12, низкий заряд батарейки, маяки 353-416 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF13      31650 //Битовое поле 13, видимые NRF маяки 385-416 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF13      31651 //Битовое поле 13, низкий заряд батарейки, маяки 385-416 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF14      31652 //Битовое поле 14, видимые NRF маяки 417-448 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF14      31653 //Битовое поле 14, низкий заряд батарейки, маяки 417-448 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF15      31654 //Битовое поле 15, видимые NRF маяки 449-480 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF15      31655 //Битовое поле 15, низкий заряд батарейки, маяки 449-480 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF16      31656 //Битовое поле 16, видимые NRF маяки 481-512 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF16      31657 //Битовое поле 16, низкий заряд батарейки, маяки 481-512 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF17      31658 //Битовое поле 16, видимые NRF маяки 513-544 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF17      31659 //Битовое поле 16, низкий заряд батарейки, маяки 513-544 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF18      31660 //Битовое поле 16, видимые NRF маяки 545-576 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF18      31661 //Битовое поле 16, низкий заряд батарейки, маяки 545-576 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF19      31662 //Битовое поле 16, видимые NRF маяки 577-608 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF19      31663 //Битовое поле 16, низкий заряд батарейки, маяки 577-608 //пока custom!
// -----------------------------------------------------------------------------
//Датчики ХОУ Zanotti
#define ZANOTTI_COOMUNICATION_STATE                   31670
#define ZANOTTI_MODE                                  31671
#define ZANOTTI_RTEMP                                 31672
#define ZANOTTI_TTEMP                                 31673
#define ZANOTTI_TIME_UPD                              31674
#define ZANOTTI_TIME_CURR                             31675
#define ZANOTTI_ERR_CNT                               31676
#define ZANOTTI_REG_ERROR1                            31677
#define ZANOTTI_REG_ERROR2                            31678
#define ZANOTTI_REG_ERROR3                            31679
#define ZANOTTI_REG_ERROR4                            31680
#define ZANOTTI_REG_ERROR5                            31681
#define ZANOTTI_REG_ERROR6                            31682
#define ZANOTTI_REG_ERROR7                            31683
#define ZANOTTI_REG_ERROR8                            31684
#define ZANOTTI_FLAGS                                 31685
// -----------------------------------------------------------------------------
//Датчики TACHO
#define TACHO_COMMAND                                 31699 //Команды тахо, 1 - выгрузить данные с карты 1, 2 - выгрузить данные с карты 2
#define TACHO_COMMUNICATION_STATE                     31700 //Состояние и тип тахографа
#define TACHO_DATETIME                                31701 //Дата и время создания записи
#define TACHO_VRN                                     31702 //Регистрационный номер ТС
#define TACHO_VIN                                     31703 //VIN номер TC
#define TACHO_DISTANCE                                31704 //Показания одометра, 0.1 км
#define TACHO_STATE_FLAGS                             31705 //Флаги состояния тахографа: bit0 - Зажигание, bit1 - Подсветка, bit2 - Масса отключена, bit3 - Паром/Поезд
#define TACHO_CARD1_STATE                             31706 //Состояние карты 1: 0 - Неизвестно, 1 – Отсутствует, 2 – Не авторизована, 3 – Авторизована, 4 – Не удалось извлечь
#define TACHO_CARD1_TYPE                              31707 //Тип карты в слоте 1: 0 - Неизвестно, 1 – Водитель, 2 – Мастер, 3 – Контролер, 4 - Предприятие
#define TACHO_CARD1_ACTIVITY                          31708 //Деятельность, карта 1: 0 - Неизвестно, 1 – Отдых, 2 – Готовность к работе, 3 – Работа не связанна управлением ТС, 4 – Управление ТС
#define TACHO_CARD1_NUMBER                            31709 //Номер карты в слоте 1
#define TACHO_CARD1_IDENT1                            31710 //Водитель 1, cтока идентификации 1
#define TACHO_CARD1_IDENT2                            31711 //Водитель 1, cтока идентификации 2
#define TACHO_CARD1_TIME_IN_CURRENT_MODE              31712 //Водитель 1, время нахождения в текущем режиме
#define TACHO_CARD1_DRIVE_TIME_OF_DAY                 31713 //Водитель 1, общее время управления за сутки
#define TACHO_CARD1_CONTINUIUS_DRIVE_TIME             31714 //Водитель 1, непрерывное время управления
#define TACHO_CARD2_STATE                             31715 //Состояние карты 2: 0 - Неизвестно, 1 – Отсутствует, 2 – Не авторизована, 3 – Авторизована, 4 – Не удалось извлечь
#define TACHO_CARD2_TYPE                              31716 //Тип карты в слоте 2: 0 - Неизвестно, 1 – Водитель, 2 – Мастер, 3 – Контролер, 4 - Предприятие
#define TACHO_CARD2_ACTIVITY                          31717 //Деятельность, карта 2: 0 - Неизвестно, 1 – Отдых, 2 – Готовность к работе, 3 – Работа не связанна управлением ТС, 4 – Управление ТС
#define TACHO_CARD2_NUMBER                            31718 //Номер карты в слоте 2
#define TACHO_CARD2_IDENT1                            31719 //Водитель 2, cтока идентификации 1
#define TACHO_CARD2_IDENT2                            31720 //Водитель 2, cтока идентификации 2
#define TACHO_CARD2_TIME_IN_CURRENT_MODE              31721 //Водитель 2, время нахождения в текущем режиме
#define TACHO_CARD2_DRIVE_TIME_OF_DAY                 31722 //Водитель 2, общее время управления за сутки
#define TACHO_CARD2_CONTINUIUS_DRIVE_TIME             31723 //Водитель 2, непрерывное время управления
#define TACHO_CARD_UPLOAD_STATE                       31724 //Статус выгрузки ddd файла на блок
// -----------------------------------------------------------------------------
//Датчики ХОУ Thermo_King_SLX_T_UT
#define SR3_COOMUNICATION_STATE                       31730 //0 - не найден, 1 - найден, 2 - отключен в настройках.
#define SR3_OP_COMP1                                  31731 //Mode of Operation – Compartment 1 Режим  отсека №1
#define SR3_OP_COMP2                                  31732 //Mode of Operation – Compartment 2 Режим  отсека №2
#define SR3_ENG_STAT                                  31733 //Engine / Standby Status Режим питания ХОУ Дизельный или электрический (запуск от дизеля\электромотора)
#define SR3_RUN_MODE                                  31734 //Режим поддержания Т Старт/стоп или непрерывный (режим старт-стоп\постоянный)
#define SR3_SPEED_MODE                                31735 //Скорость двигателя (режим медленный\бытрый)
#define SR3_ENG_COOLANT                               31736//Температура  двигателя (температура ОЖ ДВС)
#define SR3_ENG_RPM                                   31737//Обороты двигателя (Обороты ДВС)
#define SR3_ALRM_STAT                                 31738//Статус сигналов ХОУ 0 - нет активных сигналов, 1 - информационные сигналы, 2 - аварийное отключение (Статус сигналов ХОУ по ошибкам)
#define SR3_NUM_ALRMS                                 31739//Количество активных сигналов (Количество  ошибок)
#define SR3_SIGNAL1                                   31740//Сигнал №1 (ошибка 1)
#define SR3_SIGNAL2                                   31741//Сигнал №2 (ошибка 2)
#define SR3_SIGNAL3                                   31742//Сигнал №3 (ошибка 3)
#define SR3_SIGNAL4                                   31743//Сигнал №4 (ошибка N+1)
#define SR3_SIGNAL5                                   31744//Сигнал №5
#define SR3_COMP_SP1                                  31745//Заданная температура отсек №1 (Set point)
#define SR3_COMP_SP2                                  31746//Заданная температура отсек №2
#define SR3_AMBIENT_TEMP                              31747//Наружная температура (наружняя температура)
#define SR3_TEMP_COMP1_SUPL                           31748//Температура подачи отсек №1  (температура  на подаче )
#define SR3_TEMP_COMP1_RET                            31749//Температура возврата отсек №1 (температура на возрате )
#define SR3_TEMP_COMP2_SUPL                           31750//Температура подачи отсек №2
#define SR3_TEMP_COMP2_RET                            31751//Температура возврата отсек №2
#define SR3_DOOR_SW1                                  31752//Door Switch Status Состояние двери отсек №1  (статус двери кузова)
#define SR3_DOOR_SW2                                  31753//Состояние двери отсек №2
#define SR3_SW_ON_HOURS                               31754//Total Switch On Hours Общие часы ХОУ (общее время работы 2, общее время работы 1)
#define SR3_ENG_HOURS                                 31755//Total Engine Hours Дизель-часы ХОУ  (время работы дизель 2, время работы дизель 1)
#define SR3_STBY_HOURS                                31756//Total Standby Hours Электро-часы ХОУ (время работы сеть 2, время работы сеть 1)
#define SR3_PREV_HOUR_M_1                             31757//Preventative Maintenance Hour Meter 1 ТО по счетчику №1
#define SR3_PREV_HOUR_M_2                             31758//Preventative Maintenance Hour Meter 2 ТО по счетчику №2
#define SR3_LIM_HOUR_M_1                              31759//Выставленный предел в М\Ч до ТО счётчик №1
#define SR3_LIM_HOUR_M_2                              31760//Выставленный предел в М\Ч до ТО счётчик №2
#define SR3_SUCT_PRESS                                31761//Suction Pressure Давление всасывания компрессора (Давление хладогента на всасыва)
#define SR3_DISCH_PRESS                               31762//Discharge Pressure Давление нагнетания компрессора (Давление хладогента на нагнета)
#define SR3_LEVEL_COOLANT                             31763//Уровень ОЖ ДВС
#define SR3_LEVEL_OIL                                 31764//Уровень масла
#define SR3_OIL_PRESS                                 31765//Давление масла
#define SR3_ON_EL                                     31766//Электросеть подключена
#define SR3_MAX_DEFROST                               31767//Максимальное время оттайки
#define SR3_BATT_CURRENT                              31768//Battery DC Current Ток АКБ ХОУ (Ток заряда\разряда АКБ)
#define SR3_BATTERY_VOL                               31769//Напряжение АКБ ХОУ (напряжение АКБ)
#define SR3_OUTL_TEMP1                                31770//Температура испарителя 1
#define SR3_OUTL_TEMP2                                31771//Температура испарителя 2
#define SR3_SOFT_REV                                  31772//Версия ПО ХОУ
#define SR3_SOFT_RELEASE                              31773//Релиз ПО ХОУ
#define SR3_TYPE_MP                                   31774//ТИП МП ХОУ
// -----------------------------------------------------------------------------
//Максимальный номер датчика, который можно передать по WCOMBINE 32767, т.е. у всех датчиков ниже будет обрезан старший бит
// -----------------------------------------------------------------------------
#define BLE_EXT_BOARD_COMMUNICATION_STATE             33000 // Cвязь с платой BLE: 0 - плата не отвечает, 1 - Ok, 2 - отключена в настройках
#define BLE_EXT_BOARD_BOOT_VERS                       33001 // Версия загрузчика
#define BLE_EXT_BOARD_APP_VERS                        33002 // Версия прошивки
#define BLE_EXT_BOARD_MAC                             33003 // MAC адрес платы
#define BLE_EXT_BOARD_CONN_BLE_STATE                  33004 // Состояние соединения BLE
#define BLE_EXT_BOARD_FW_UPD_PCT                      33005 // Процент загрузки файла прошивки
#define BLE_EXT_BOARD_COMMAND_ANS_W_SINGN             33006 // Ответы на команды полученне по BLE плате
#define BLE_EXT_BOARD_VEGA_BLE_SESSION_SECURE_KEY     33007 // Сессионный ключ шифрования
//reserve8
#define BLE_EXT_BOARD_BEACONS_INFO1                   33016 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO2                   33017 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO3                   33018 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO4                   33019 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO5                   33020 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO6                   33021 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO7                   33022 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO8                   33023 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO9                   33024 // BLE beacons info, 6 шт.
#define BLE_EXT_BOARD_BEACONS_INFO10                  33025 // BLE beacons info, 6 шт.

/*
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF8       33100 //Битовое поле 8, видимые NRF маяки 225-256 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF8       33101 //Битовое поле 8, низкий заряд батарейки, маяки 225-256 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF9       33102 //Битовое поле 9, видимые NRF маяки 257-288 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF9       33103 //Битовое поле 9, низкий заряд батарейки, маяки 257-288 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF10      33104 //Битовое поле 10, видимые NRF маяки 288-320 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF10      33105 //Битовое поле 10, низкий заряд батарейки, маяки 288-320 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF11      33106 //Битовое поле 11, видимые NRF маяки 321-352 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF11      33107 //Битовое поле 11, низкий заряд батарейки, маяки 321-352 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF12      33108 //Битовое поле 12, видимые NRF маяки 353-384 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF12      33109 //Битовое поле 12, низкий заряд батарейки, маяки 353-416 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF13      33110 //Битовое поле 13, видимые NRF маяки 385-416 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF13      33111 //Битовое поле 13, низкий заряд батарейки, маяки 385-416 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF14      33112 //Битовое поле 14, видимые NRF маяки 417-448 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF14      33113 //Битовое поле 14, низкий заряд батарейки, маяки 417-448 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF15      33114 //Битовое поле 15, видимые NRF маяки 449-480 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF15      33115 //Битовое поле 15, низкий заряд батарейки, маяки 449-480 //пока custom!
#define NRF_BEACONS_SCANNER_VISIBLE_BEACONS_BF16      33116 //Битовое поле 16, видимые NRF маяки 481-512 //пока custom!
#define NRF_BEACONS_SCANNER_BATTLOW_BEACONS_BF16      33117 //Битовое поле 16, низкий заряд батарейки, маяки 481-512 //пока custom!
*/

#define DM5002X_FIRST_SENSOR                          33200 //
#define DM5002X_LAST_SENSOR                           (DM5002X_FIRST_SENSOR+13) //

#define VEGA_MODEM_FTP_DWN_STATE                      33219 //состояние загрузки по FTP
#define VEGA_OW_ANY_KEY_PRESENT                       33220 //Поднесен любой ключ 1-Wire (для работы сценариев)
#define VEGA_IMMO_FLANKER_CMD                         33221 //Команда обучения обходчика immo. 1 - шаг 1, 2 - шаг 2, 3- оставновить
#define VEGA_IMMO_FLANKER_LEARN_STATE                 33222 //Состояние обучения обходчика immo
// -----------------------------------------------------------------------------


#define VEGA_HARD_PASS_LEN                 16


// Сообщение протокола VEGA ////////////////////////////////////////////////////
// Возможные типы сообщений
#pragma pack(1)
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif
{
  COMMAND               = 0x01, // Команда
  COMMAND_ANS           = 0x02, // Ответ на команду
  FILE_CHUNK            = 0x03, // Файл от хоста устройству
  FILE_CHUNK_ANS        = 0x04, // Ответ на файл
  AUTORIZATION          = 0x05, // Авторизация
  AUTORIZATION_ANS      = 0x06, // Ответ на авторизацию
  //BLACK_BOX_MESSAGE   = 0x07, // Запись черного ящика
  GET_FILE              = 0x08, // Считать файл
  GET_FILE_ANS          = 0x09, // Файл от устройства хосту
  GET_DEV_INF           = 0x0A, // Пинг от сервера клиенту
  GET_DEV_INF_ANS       = 0x0B, // Ответ клиента на пинг
  GET_DEV_LIST          = 0x0C, // Запрос списка устройств у сервера
  GET_DEV_LIST_ANS      = 0x0D, // Список устройств от сервера клиенту
  CONNECT_TO_DEV        = 0x0E, // Запрос подключения к устройству на сервере
  CONNECT_TO_DEV_ANS    = 0x0F, // Ответ на запрос подключения к устройству
  DISCONNECT_FROM_DEV   = 0x10, // Запрос на отсоединение от устройства
  BBOX_MESSAGES         = 0x11, // Сообщения из черного ящика
  BBOX_MESSAGES_ANS     = 0x12, // Ответ на сообщения из черного ящика
  FILE_WHOLLY           = 0x13, // Файл целиком от хоста устройству
  FILE_WHOLLY_ANS       = 0x14, // Ответ на файл
  FILE_CLEAN            = 0x15, // Очистить файл на устройстве
  FILE_CLEAN_ANS        = 0x16, // Ответ на очистить файл на устройстве
  GET_FILE_REPORT       = 0x17, // Запрос  файла  отчета
  GET_FILE_REPORT_ANS   = 0x18, // Ответ на запрос файла отчета
  GET_STATUS_REPORT     = 0x19, // Запрос статуса файла  отчета
  GET_STATUS_REPORT_ANS = 0x1A, // Ответ на запрос на файл отчета
  TRANSP_DATA_TO_ITF    = 0x1B, // Данные для отправки в интерфейс
  TRANSP_DATA_FROM_ITF  = 0x1C, // Данные полученные из интерфейса
  FWD_DATA_TO_CAN       = 0x1D, // Данные для отправки в CAN интерфейс
  FWD_DATA_FROM_CAN     = 0x1E, // Данные полученные из CAN интерфейса
  FAST_DATA_MESS        = 0x1F, // Быстро меняющиеся данные
  COMMAND_W_NONCE       = 0x20, // Команда, требующая подпись в ответе подпись
  COMMAND_ANS_W_SINGN   = 0x21, // Ответ на команду с подписью
}EVega_message_type;

typedef  struct
{
  uint16_t            len;      // Длина полезной нагрузки
  EVega_message_type  type;     // Тип сообщения
}TVega_message;

// Сообщение типа команда //////////////////////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные коды команды
{
  RESTART                = 1, // Рестарт устройства
  SET_PARAM              = 2, // Установить один параметр
  GET_PARAM              = 3, // Считать один параметр (в ответете id, длинна)
  GET_EXT_PARAM          = 4, // Считать один параметр (в ответете id, subid, тип данных параметра, длинна)
  TOFACTORY              = 5, // Сброс к заводским настройкам
  CLEAN_BB               = 6, // Очистить черный ящик
  SET_OUTPUT             = 7, // Управление выходами
  TAKE_PHOTO             = 8, // Сделать фото
  BLINKER_FLASH          = 9, // Моргнуть поворотниками
  CLOSE_DOORS            = 10, // Закрыть все двери
  OPEN_DOORS             = 11, // Открыть все двери
  OPEN_DR_DOOR           = 12, // Открыть дверь водителя
  HORN                   = 13, // Клаксон
  TRUNK                  = 14, // Открыть багажник
  STOP_ENGINE            = 15, // Остановить двигатель
  START_ENGINE           = 16, // Запустить двигатель
  START_WEBASTO          = 17, // Запустить webasto
  STOP_WEBASTO           = 18, // Остановить webasto
  EMULATE_DRIVER_DOOR    = 19, // Эмулировать дверь водителя
  HORN_AND_BLINK         = 20, // Моргнуть и гудок
  WINDOWS_CLOSING_3S     = 21, //
  WINDOWS_CLOSING_7S     = 22, //
  WINDOWS_CLOSING_11S    = 23, //
  WINDOWS_CLOSING_15S    = 24, //
  WINDOWS_CLOSING_19S    = 25, //
  WINDOWS_CLOSING_23S    = 26, //
  WINDOWS_CLOSING_29S    = 27, //
  WINDOWS_OPENING_3S     = 28, //
  WINDOWS_OPENING_7S     = 29, //
  WINDOWS_OPENING_11S    = 30, //
  WINDOWS_OPENING_15S    = 31, //
  WINDOWS_OPENING_19S    = 32, //
  WINDOWS_OPENING_23S    = 33, //
  WINDOWS_OPENING_29S    = 34, //
  START_PROD_TESTS       = 35, // Команда на запуск производственного теста
  RESET_LORA_SENS_ALARMS = 36, // Команда на сброс тревог lora sens

  YADRIVE_WARMING        = 37, //
  YADRIVE_STOP_WARMING   = 38, //
  YADRIVE_START_OF_LEASE = 39, //
  YADRIVE_END_OF_LEASE   = 40, //
  YADRIVE_UNLOCK_HOOD    = 41, //
  YADRIVE_LOCK_HOOD      = 42, //
  YADRIVE_FORCED_END_OF_LEASE = 43, //
  YADRIVE_PANIC          = 44, //
  YADRIVE_AUDIO_COMMANDS = 45,
  YADRIVE_DTC_CLEAR      = 46, //
  YADRIVE_EMERGENCY_STOP = 47, // stop when speed = 0

  //48-58  reserve
  GNSS_COOLD_START       = 59,
  AUXILIARY_CAR_COMMANDS = 60, //Дополнительные команды управления авто, тип команды передается в аргументах

  INTERNAL_NRF_ADD_RELAY = 61, //Команда на добавление реле
  INTERNAL_NRF_DEL_RELAY = 62, //Команда на удаление реле
  INTERNAL_NRF_ADD_MARK  = 63, //Команда на добавление меток
  INTERNAL_NRF_DEL_MARK  = 64, //Команда на удаление меток

  CAN_VEGA_FWD_CONFIG    = 65, //Команда настройки перенаправление данных с CAN
  CAN_VEGA_OBD_COMMAND   = 66, //Команда OBD
  CAN_VEGA_TX_SCRIPT_COMMAND   = 67, //Команда CAN скриптов

  GSM_MODEM_COMMANDS     = 68, //Команды управления модемом, тип команды передается в аргументах.
                               //0 - сменить sim, 1 - обновить баланс, 2 - ftp ссылка на скачивание файла, 3 - перевести блок в режим обновления GSM модема

  FASTDATA_FWD_CONFIG    = 69, //Команды упраавления "быстрыми" данными

  BS_COMMANDS            = 70, //Команды BLE БС, тип команды передается в аргументах

  VEGA_BLE_COMMANS       = 71, //Команды BLE VEGA, тип команды передается в аргументах
}EVega_command_code;

// Команда
typedef struct
{
  uint32_t           uid;         // Уникальный идентификатор
  EVega_command_code code;        // Код команды
  uint8_t            arg_len;     // Длина аргументов команды
}TVega_command;

// Команда
typedef struct
{
  uint8_t            nonce[8];    // Уникальное число
  uint32_t           uid;         // Уникальный идентификатор
  EVega_command_code code;        // Код команды
  uint8_t            arg_len;     // Длина аргументов команды
}TVega_command_w_nonce;

// Аргументы команды паника
typedef struct
{
  uint8_t           type;        // 0 - остановить, 1 - звуковая, 2 - световая, 3 - свето-звуковая
  uint8_t           time;        // время паники в секундах
}TVega_panic_args;

// Аргументы команды установить параметр
typedef struct
{
  uint16_t           id;       // ID параметра
  uint16_t           subid;    // SUBID параметра
  uint8_t            len;      // Длина параметра
}TVega_set_param_args;

// Аргументы команды считать параметр
typedef struct
{
  uint16_t           id;         // ID параметра
  uint16_t           subid;      // Код команды
}TVega_get_param_args;

// Аргументы команды управление телематическими сообщениями
typedef struct
{
  uint8_t            state;      // Состояние (0-выкл 1-вкл)
}TVega_telematic_args;

// Аргументы команды управление выходами
typedef struct
{
  uint8_t            output_num;  // Порядковый номер выхода с 1 по 255
  uint8_t            state;       // Состояние (0-выкл 1-вкл)
}TVega_set_output_args;

// Сообщение типа ответ на команду /////////////////////////////////////////////
/// Additional parameters for protocol

// Аргументы команды управление миганием поворотников
typedef struct
{
  uint16_t            time;     // Общий таймаут отправки команды мигания поворотниками
  uint16_t            sampling;   // Пауза между миганиями
}TVega_set_blinker_flash_args;

////////////////////////////////////////////

// Сообщение типа ответ на команду /////////////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  DONE              = 0x01,  // Выполнена
  IN_PROCESS        = 0x02,  // В процессе выполнения
  READY_TO_CONTINUE = 0x03,  // Готова к продолжению
  COMM_ERROR        = 0x04,  // Ошибка
  UNKNOWN_PARAMETER = 0x05,  // Неизвестный параметр
  BUSY              = 0x06,  // Занято
  COMM_EXT_ERROR    = 0x07,  // Ошибка расширенная
}EVega_command_ans_result;

//Расширенный код ошибки для COMM_EXT_ERROR. Дополнительно в аргументах ответа
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint16_t
#endif // Возможные результаты ответа на команду
{
    BT_OFF             = 0x0001, // Bluetooth отключен в настройках
    BT_SCANER_OFF      = 0x0002, // ошибка конфигурация BLE (сканирование отключено)
    BT_MODEM_NOT_READY = 0x0003, // модем не готов
    BT_NOT_SUPPORTED   = 0x0004, // BLE не поддерживается
    BT_U16_MAX         = 0xFFFF, // Определяет размер enum в IAR
}EVega_ext_comm_err_t;

typedef struct
{
  uint32_t                 uid;       // Уникальный идентификатор
  EVega_command_ans_result result;    // Результат выполнения
  uint8_t                  arg_len;   // Длина аргументов ответа на команду
}TVega_command_ans;

typedef struct
{
  uint8_t                  mac[16];   // MAC, считается для ниже следующих байт + для arg_len байт, следующих за заголовком
  uint8_t                  nonce[8];  // Уникальное число, получено в запросе
  uint32_t                 uid;       // Уникальный идентификатор, получен в запросе
  EVega_command_ans_result result;    // Результат выполнения
  uint8_t                  arg_len;   // Длина аргументов ответа на команду
}TVega_command_ans_w_sign;

typedef struct
{
  uint16_t           id;       // ID параметра
  uint8_t            len;      // Длина параметра
}TVega_get_param_ans_args;

typedef struct
{
  uint16_t           id;        // ID параметра
  uint16_t           subid;     // SUBID параметра
  uint8_t            data_type; // Тип параметра, определен в system
  uint8_t            len;       // Длина параметра
}TVega_get_ext_param_ans_args;

// Сообщение типа файл от хоста устройству /////////////////////////////////////
typedef struct
{
  char     filename[10];   // Имя файла
  uint16_t chunk_len;      // Длина данных куска
  uint16_t chunk_num;      // Номер куска (нумерация с еденицы)
  uint16_t chunks_total;   // Всего кусков
}TVega_file_chunk;

typedef struct
{
  char     filename[10];   // Имя файла
  uint32_t filesize;       // Размер файла
  uint32_t filecrc;        // Контрольная сумма файла
}TVega_file_wholly;

// Сообщение типа ответ на файл ////////////////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  CHUNK_ANS_OK                = 0x00,  // Кусок принят успешно
  CHUNK_ANS_MEMORY_ERROR      = 0x01,  // Ошибка памяти
  CHUNK_ANS_SIGNATURE_ERROR   = 0x02,  // Ошибка цифровой подписи
  CHUNK_ANS_FILENAME_ERROR    = 0x03,  // Ошибка имени файла
  CHUNK_ANS_SEQUENCE_ERROR    = 0x04   // Ошибка последовательности кусков
}EVega_file_chunk_ans_result;

typedef struct
{
  char                         filename[10];   // Имя файла
  uint16_t                     chunk_num;      // Номер куска
  EVega_file_chunk_ans_result  result;         // Результат
}TVega_file_chunk_ans;


// Сообщение типа ответ на файл целиком////////////////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  FILE_WHOLLY_ANS_OK            = 0x00,  // Файл принят успешно
  FILE_WHOLLY_MEMORY_ERROR      = 0x01,  // Ошибка памяти
  FILE_WHOLLY_SIGNATURE_ERROR   = 0x02,  // Ошибка цифровой подписи
  FILE_WHOLLY_FILENAME_ERROR    = 0x03,  // Ошибка имени файла
  FILE_WHOLLY_CRC_ERROR         = 0x04   // Ошибка CRC
}EVega_file_wholly_ans_result;

typedef struct
{
  char     filename[10];                       // Имя файла
  EVega_file_wholly_ans_result  result;       // Результат
}TVega_file_wholly_ans;

// Сообщение типа считать файл с устройства ////////////////////////////////////
typedef struct
{
  char     filename[10];   // Имя файла
  uint32_t offset;        // Смещение
  uint16_t data_len;      // Длина данных куска
}TVega_get_file;

// Сообщение типа Файл от устройства хосту  ////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  GET_FILE_OK                = 0x00,  // Ок
  GET_FILE_BUSY              = 0x01,  // Файл занят
  GET_FILE_OUT_OF_DATA       = 0x02,  // Выход за праделы файла
  GET_FILE_MEMORY_ERROR      = 0x03,  // Ошибка памяти
  GET_FILE_FILENAME_ERROR    = 0x04,  // Ошибка имени файла
  GET_FILE_DATA_SIZE_ERROR   = 0x05   // Запрошенный кусок не помещается в буфер
}EVega_get_file_ans_result;

typedef struct
{
  char                       filename[10];   // Имя файла
  uint32_t                   filesize;       // Общий размер файла
  uint16_t                   data_size;      // Размер данных куска
  EVega_get_file_ans_result  result;         // Результат
}TVega_get_file_ans;

typedef struct
{
  char     filename[10];   // Имя файла
}TVega_file_clean;

#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  GET_FILE_REPORT_OK             = 0x00,   // Файл отчет готов
  GET_FILE_REPORT_ERROR          = 0x01,   // Ошибка памяти
  GET_FILE_REPORT_BUSY           = 0x02,   // Файл занят
  GET_FILE_REPORT_FILENAME_ERROR = 0x03,   // Ошибка имени файла
  GET_FILE_REPORT_EMPTY          = 0x04,   // Файл записей пустой
}EVega_file_report_ans_result;

typedef struct
{
  char                       filename[10];     // Имя файла
  uint32_t                   start_time_report;// Начало отчета
  uint32_t                   end_time_report;  // Конец  отчета
}TVega_get_file_report;                        //запрос на файл отчета (0х17)

typedef struct
{
  char                       filename[10];     // Имя файла
  uint8_t                    res_report;       // Результат операции 0 – ОК/1 – ошибка памяти устройства/2 – файл занят/3 – ошибка имени файла
}TVega_get_file_report_ans;                    // ответ на запрос на файл отчета (0х18)

typedef struct
{
  char                       filename[10];     // Имя файла
}TVega_status_file_report;                     // запрос статуса файла отчета (0х19)

typedef struct
{
  char                       filename[10];     // Имя файла
  uint32_t                   number_of_records;// Количество записей в заданном периоде
  uint8_t                    res_report;       // Результат операции  0 – ОК/1 – ошибка памяти устройства/2 – файл занят/3 – ошибка имени файла

}TVega_status_file_report_ans;                 // ответ на запрос на файл отчета (0х1A)


// Сообщение типа ответ на очистить файл на устройстве////////////////////////////////////////////////
#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  FILE_CLEAN_ANS_OK            = 0x00,  // Файл очищен
  FILE_CLEAN_MEMORY_ERROR      = 0x01,  // Ошибка памяти
  FILE_CLEAN_FILE_BUSY         = 0x02,  // Файл занят
  FILE_CLEAN_FILENAME_ERROR    = 0x03,  // Ошибка имени файла
}EVega_file_clean_ans_result;

typedef struct
{
  char     filename[10];                // Имя файла
  EVega_file_clean_ans_result  result;  // Результат
}TVega_file_clean_ans;

// Сообщение типа запись черного ящика /////////////////////////////////////////
typedef struct
{
  uint32_t time;  // Время в формате unixtime
  float lat;      // Широта
  float lon;      // Долгота
  int16_t alt;    // Высота
  uint16_t speed;
  uint16_t direction;
  uint8_t sat_count;
  uint16_t parameters_len:15;
  uint16_t pack_with_type:1;
}TVega_bb_message;

// Заголовок пакета с сообщениями черного ящика
typedef struct
{
  uint16_t pack_id;  // id пакета с сообщениями ЧЯ
  uint16_t mess_cnt; // Кол-во телематических записей в пакете
}TVega_bbox_pack_header;

#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  BBOX_ANS_OK               = 0x00,
  BBOX_ANS_ERROR            = 0xff,
}EVega_bbox_ans_res;

typedef struct
{
  char pass[4];
}TVega_auth_mess_legacy;

typedef struct
{
  char pass[4];
  uint8_t is_bbox_upload_enable;
}TVega_auth_mess;

typedef struct
{
  char pass[VEGA_HARD_PASS_LEN];
  uint8_t is_bbox_upload_enable;
}TVega_hard_auth_mess;

typedef struct
{
  uint16_t pack_id; // id пакета с сообщениями ЧЯ
  EVega_bbox_ans_res  result;
}TVega_bbox_pack_ans;

typedef struct
{
  char imei[16];        //нультерминированная строка
  uint8_t dev_type;     //тип устройсва
  uint8_t reserve[4];   //резерв
}TVega_get_dev_inf_ans;

typedef struct
{
  uint8_t  itf_id;      //0x01 - RS232, 0x02 - RS2485, 0x03 - RSUART, 0xFD - отладка GSM, 0xFE - BLE ADV

  union
  {
    struct
    {
      uint32_t reserve_2:8;
      uint32_t baudrate:17; //1200-115200
      uint32_t timeout:7;   //ожидание ответа, мс умноженные на 10, для 0xFD секунды
      uint8_t  reserve[3];
    }rs;

    struct
    {
      uint8_t first_id; //первый id из стаблицы сканирования
      uint8_t count;         //количество ble_scan_t

      uint8_t  reserve[5];
    }ble_adv;
  };

  //uint8_t  reserve[7];
  uint16_t data_len;
}TVega_itf_data;

typedef struct
{
  uint8_t frame_count; //количество TVega_can_frame
  uint8_t reserved[8]; //
}TVega_can_data_header;

typedef struct
{
  uint32_t time;       //messge time
  uint32_t id;         //CAN identifier
  uint8_t  itf_idx:3;  //CAN interface CAN1: 0, СAN2: 1, CAN3: 2, etc
  uint8_t  id_type:1;  //0-standart, 1-extended
  uint8_t  rtr:1;      //remote transmit request
  uint8_t  reserved:3; //reserved
  uint8_t  dlen;       //data len 0-8
  uint8_t  data[8];    //data
}TVega_rx_can_frame;

typedef struct
{
  uint32_t id;         //CAN identifier
  uint8_t  itf_idx:3;  //CAN interface CAN1: 0, СAN2: 1, CAN3: 2, etc
  uint8_t  id_type:1;  //0-standart, 1-extended
  uint8_t  rtr:1;      //remote transmit request
  uint8_t  reserved:3; //reserved
  uint8_t  dlen;       //data len 0-8
  uint8_t  data[8];    //data
}TVega_tx_can_frame;

typedef struct
{
  uint8_t count;    //количество TVega_fast_data
}TVega_fast_data_header;

typedef struct
{
  uint8_t struct_vers;      //всегда 0 для этой структуры

  uint32_t drop_counter;    //количество пропущенных сообщений (fifo переполнено)
  uint32_t tick_counter;    //внутренние тики, мс

  //сырые данные с акселерометра
  //перевод в g: (x>>6)/256.0
  struct
  {
    int16_t x;
    int16_t y;
    int16_t z;
  }accel;

  //нефильтрованные даныне с приемника
  struct
  {
    uint32_t time;          //время GNSS, unixtime
    float lon;              //долгота
    float lat;              //широта
    uint8_t valid;          //валидность
    uint8_t speed;          //скорость, км/ч
    uint16_t dir;           //курс, deg
    uint8_t is_on;          //приемник активен
  }gnss;

  //данные с CAN
  struct
  {
    uint8_t speed;                      //скорость, км/ч
    uint8_t accelerator;                //педаль акселератора 0-100%
    uint8_t brake;                      //педаль тормоза, 0-100%
    int16_t steering_wheel;             //положение руля, -100%-+100%
    uint16_t rpm;                       //оборотв двигателя, об/мин
    uint16_t steering_acceleration;     //ускорение поворота руля
  }can;
}TVega_fast_data;

typedef struct
{
  uint16_t mcc;
  uint16_t mnc;
  uint16_t lac;
  uint16_t cell_id;
  uint16_t rx_level;
  uint16_t ta;
} TVega_lbs_data;

#ifndef __ICCARM__
/** ***********************************************************************
 * @struct TDeviceListMessageHeader + TDeviceToConfigInfo(* количество устройств)
 * @brief Структуры для ответа на получение списка устройств от сервера
 ** ***********************************************************************/
struct TDeviceListMessageHeader {
    uint16_t totalCnt;
};

#define DEV_NAME_SIZE_MAX 40

struct TDeviceToConfigInfo {
    uint8_t imei[16];                   //нультерминированная строка
    uint8_t name[DEV_NAME_SIZE_MAX+1];  //нультерминированная строка
};

#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  CONNECT_OK                 = 0x00,  // успешное подключение к устройству
  CONNECT_FAIL               = 0x01,  // соединение не произошло
  CONNECT_NOT_FOUND          = 0x02,  // устройство не найдено
  CONNECT_USED               = 0x03,  // устройство уже используется
  CONNECT_UNKNOWN            = 0xff,  // неопределенное состояние
}EVega_connect_to_dev_res;

#ifdef __ICCARM__
typedef enum
#else
typedef enum : uint8_t
#endif // Возможные результаты ответа на команду
{
  EXTRA_DEV_CONFIG_DESKTOP   = 0xfe,  // успешное подключение к устройству
  EXTRA_DEV_CONFIG_MOBILE    = 0xfd,  // соединение не произошло
}EVega_extra_dev_type;

#endif

/** ***********************************************************************/

#pragma pack()

#ifdef __ICCARM__

#if defined(USE_SERVER_NOTIFY_IN_VEGA)
#include "mbedtls/poly1305.h"
#include "serv_protocols_lib/server_notifies.h"
#endif //USE_SERVER_NOTIFY_IN_VEGA

typedef struct
{
  uint8_t mess_cnt_out;                      //количество сообщений отправлено из bbox или express
  uint8_t is_wait_ack;                       //признак того, что запись подтверждена
  uint32_t end_wait_ack_time;                //время конца ожидания ответа на сообщение, если подтсерждение не получено в указанное время, необходимо установить сессию снова и повторить отправку
  //перепосылать нельзя, т.к. не поймем на какие именно зааписи пришел ответ
  uint16_t waiting_pack_id_counter;

  uint8_t find_wrong_mess_fmt_mode;          //признак принудительной отправки по одному сообщению
  uint8_t mess_counter_in_wrong_fmt_mode;
  uint8_t not_ack_counter;                   //счётчик не подтверждённых посылок
}vega_wait_ack_t;

typedef struct
{
  char    fname[10];            //имя (идентификатор) загружаемого файла (не слидим за нультерминированием)
  uint32_t data_size;           //полный размер принимаемых бинарных данных
  uint32_t wait_data_len;       //сколько осталось принять
  uint32_t recv_crc;            //сrc из пакета
  uint32_t calc_crc;            //cюда считаем crc по мере приёма
  uint32_t last_recv_chunk_time;//время, когда что-то было считанно
}vega_streaming_dwn_t;

#if defined(VEGA_SECURE_PRESENT)
//
#endif //defined(VEGA_SECURE_PRESENT)

#if defined(VEGA_ESECURE_PRESENT)
#include "mbedtls/chachapoly.h"

typedef uint16_t esecure_packet_len_t;
typedef uint8_t  esecure_mac_t[16];

typedef __packed struct
{
  uint32_t utime;
  uint8_t direction;
  uint8_t reserved[3];
  uint32_t counter;
}esescure_nonce_t;

typedef struct
{
  const uint8_t* chachapoly_key;

  struct
  {
    mbedtls_chachapoly_context chachapoly;
    esescure_nonce_t nonce;
    esecure_packet_len_t msg_len;
    uint8_t buff[1024+sizeof(esecure_mac_t)];
  }rx;

  struct
  {
    mbedtls_chachapoly_context chachapoly;
    esescure_nonce_t nonce;
    uint8_t buff[sizeof(esecure_packet_len_t)+1460+sizeof(esecure_mac_t)];
  }tx;

  uint8_t step;
}vega_esecure_ctx_t;

int16_t vega_esecure_tx_prepare(vega_esecure_ctx_t* sctx, const uint8_t* tx, const uint16_t tx_len);
#endif //defined(VEGA_ESECURE_PRESENT)

typedef struct
{
  uint8_t* parse_buff;       //указатель на буфер, который нужно разобрать (указатель смещается по мере разбора)
  uint16_t parse_len;        //длина буфера, который нужно разобрать (длина уменьшается по мере разбора)

  uint16_t rx_mem_size;      //размер памяти для приёма

  uint8_t* tx_mem;           //куча для формирования ответов
  uint16_t tx_mem_size;      //размер кучи

  uint16_t wait_out_len;     //данных в буфере, ожидающие отправку

  uint8_t conn_ctx_id;       //id tcp подключения
  uint8_t bbox_receiver;

  const uint8_t* use_passwd_opt;   //опция доступа без пин кода
  const char* passwd;              //пин доступа к устройству
  uint8_t dev_type;                //

#if defined(VEGA_USE_NONCE_AUTH)
  //
#endif //defined(VEGA_USE_NONCE_AUTH)

  const char*    dwn_fname;        //указатель на имя загружаемого файла
  uint16_t dwn_wait_chunk_num;     //ожидаемый номер куска файла на загрузку (нумерация с еденицы, 0 - нет актиыной загрузки)
  uint32_t dwn_chunk_write_offset; //смещение записи загружаемого файла
  vega_streaming_dwn_t streaming_dwn;

  uint8_t is_bbox_upload_enable;
  uint16_t bbox_pack_id_counter;
  vega_wait_ack_t bbox; //объект определяющий ожидание подтверждения для bbox сообщений

  uint8_t is_authenticated;  //признак успешной авторизации

  int8_t (*got_vega_packet_callback) (uint8_t conn_id, uint8_t* packet, uint8_t* ans_buff, uint16_t ans_buff_size, uint16_t* ans_len);

  const common_prot_const_t*  common_const; //указатель на внешнии фукции

#if defined(VEGA_SECURE_PRESENT)
  //
#endif //defined(VEGA_SECURE_PRESENT)

#if defined(VEGA_ESECURE_PRESENT)
  vega_esecure_ctx_t*   esecure;
#endif //defined(VEGA_ESECURE_PRESENT)
}vega_ctx_t;

void VegaResetCtxState(vega_ctx_t* ctx);
int16_t VegaRxProcessing(vega_ctx_t* ctx);
int16_t VegaBboxUploadHandle(vega_ctx_t* ctx);
void VegaDeInitCtx(vega_ctx_t* ctx);

#if defined(USE_SERVER_NOTIFY_IN_VEGA)
extern const uint8_t* get_cmd_ans_mac_key(void);
int16_t VegaNotifiesUploadHandle(vega_ctx_t* ctx);
EVega_command_ans_result Convert_notify_state_from_cmd_result(const notify_state_t notify_state);
#endif //USE_SERVER_NOTIFY_IN_VEGA

#if defined(ITF_TRANSPORT_PRESENT)
int16_t VegaFromItfDataHandle(vega_ctx_t* ctx);
#endif //defined(ITF_TRANSPORT_PRESENT)

#if defined(CAN_VEGA_FWD_PRESENT)
int16_t VegaCanMessUploadHandle(vega_ctx_t* ctx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(FASTDATA_PRESENT)
int16_t VegaFastDataUploadHandle(vega_ctx_t* ctx);
#endif //defined(FASTDATA_PRESENT)

#if defined(BLE_SENSORS_PRESENT)
//
#endif //defined(BLE_SENSORS_PRESENT)

#endif

#define VEGA_PACKET_LEN(payload_len)                (sizeof(TVega_message)+payload_len+sizeof(uint32_t))
#define VEGA_PACKET_CRC_OFFSET(payload_len)         (sizeof(TVega_message)+payload_len)
#define VEGA_PACKET_CRC_CALC_LEN(payload_len)       (VEGA_PACKET_CRC_OFFSET(payload_len))
#define VEGA_PACKET_PAYLOAD_OFFSET()                (sizeof(TVega_message))

#ifdef __cplusplus
}
#endif

#endif //VEGA_PROTOCOL_H
