/**
******************************************************************************
* File Name          : wialon_binary_protocol.h
* Description        :    wialon binary
*                      
*                      
******************************************************************************
*/
#ifndef __WIALON_BINARY_PROTOCOL_H
#define __WIALON_BINARY_PROTOCOL_H

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdarg.h>  
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "debug_port.h"

#include "serv_protocols_lib/serv_protocol_common.h"
#include "serv_protocols_lib/vega/vega_protocol.h"
#include "time_utilities/time_utilities.h"
#include "ext_string_lib/ext_string.h"

#define WIALON_BIN_MAX_PASSWD_LEN        16//  

#define WIALON_BIN_PROTOCOL_VERSION             1

#define LOGIN_WIALON_BIN_PACKET_TYPE            0
#define DATA_WIALON_BIN_PACKET_TYPE             1
#define KEEP_ALIVE_WIALON_BIN_PACKET_TYPE       2

typedef __big_endian __packed struct
{
  uint16_t head; //0x2424
  uint8_t type; //LOGIN_WIALON_BIN_PACKET_TYPE or DATA_WIALON_BIN_PACKET_TYPE or KEEP_ALIVE_WIALON_BIN_PACKET_TYPE
  uint16_t seq; //0-65535
  uint16_t len; //0-32767
}wialon_bin_header_t;
  
#define WIALON_BIN_UINT64_ID_NO_PWD             0x30
#define WIALON_BIN_UINT64_ID_STRING_PWD         0x34
typedef __big_endian __packed struct
{
  uint8_t version;
  uint8_t flags;      //0x34
  uint64_t id;        
  //char pwd[5];
}wialon_bin_login_t;

typedef __big_endian __packed struct
{
  uint8_t subrecord_type;//WIALON_BIN_PICTURE_SUBRECORD_TYPE
  uint16_t ind;   //(0-32767)|0x8000
  uint16_t len;   //0-32767
  uint16_t count; //(0-32767)|0x8000
  char name[6]; //fixed name len=5!
}wialon_bin_picture_header_t;

typedef __big_endian __packed struct
{
  uint8_t subrecord_type;//WIALON_BIN_TACHO_FILE_SUBRECORD_TYPE
  uint16_t ind;   //(0-32767)|0x8000
  uint16_t len;   //0-32767
  uint16_t count; //(0-32767)|0x8000        
}wialon_bin_tacho_file_header_t;

#define WIALON_BIN_TX_HEAD                      0x2424
#define WIALON_BIN_RX_HEAD                      0x4040

#define WIALON_BIN_PACKET_OK_RESP_CODE          0
#define WIALON_BIN_AUTH_ERR_RESP_CODE           1
#define WIALON_BIN_INVALID_PWD_RESP_CODE        2
#define WIALON_BIN_INVALID_PACKET_RESP_CODE     3
#define WIALON_BIN_INVALID_CRC_RESP_CODE        4
#define WIALON_BIN_CMD_TO_DEVICE_CODE           255

typedef __big_endian __packed struct
{
  uint16_t head;    //0x4040
  uint8_t code;     // 
}wialon_bin_server_packet_header_t;


typedef __big_endian __packed struct
{
  uint16_t head;    //0x4040
  uint8_t code;     // 
  uint16_t seq;     //   
}wialon_bin_serv_ack_t;

typedef __big_endian uint16_t wialon_bin_crc_t;

typedef __big_endian __packed struct
{
  uint16_t head;    //0x2424
  uint8_t type;     //KEEP_ALIVE_WIALON_BIN_PACKET_TYPE
  uint16_t seq;     //
}wialon_keepalive_t;

typedef struct
{
  uint8_t mess_cnt_out;                      //    bbox  express
  uint8_t is_wait_ack;                       // ,   
  uint32_t end_wait_ack_time;                //     ,       ,       
  // , ..        
  uint16_t waiting_rx_seq;
  
  uint8_t find_wrong_mess_fmt_mode;          //     
  uint8_t mess_counter_in_wrong_fmt_mode;
  uint8_t not_ack_counter;                   //   
}wialon_bin_wait_ack_t;

typedef __big_endian __packed struct
{
  uint8_t subrecord_type;     //WIALON_BIN_POS_DATA_SUBRECORD_TYPE
  int32_t lat;                //.  signed int.   1000000.
  int32_t lon;                //.  signed int.   1000000.
  uint16_t speed;
  uint16_t course;
  int16_t height;
  uint8_t sats;
  uint16_t hdop;              //Horizontal dilution of precision.   100.
}wialon_bin_pos_subrecord_t;

typedef __big_endian __packed struct
{
  uint8_t subrecord_type;     //WIALON_BIN_LBS_SUBRECORD_TYPE
  uint8_t count;              // 1
  uint16_t mcc;
  uint16_t mnc;
  uint16_t lac;
  uint16_t cell_id;
  uint16_t rx_level;
  uint16_t ta;
}wialon_bin_lbs_subrecord_t;

#define WIALON_BIN_CUSTOM_COMMAND_TYPE          0

#define WIALON_BIN_CUSTOM_PARAM_SUBRECORD_TYPE  0
#define WIALON_BIN_POS_DATA_SUBRECORD_TYPE      1
#define WIALON_BIN_PICTURE_SUBRECORD_TYPE       3
#define WIALON_BIN_LBS_SUBRECORD_TYPE           4
#define WIALON_BIN_TACHO_FILE_SUBRECORD_TYPE    11
#define WIALON_BIN_DRIVER_MESS_SUBRECORD_TYPE   12

#define WIALON_BIN_U8_TYPE                      0
#define WIALON_BIN_U16_TYPE                     1
#define WIALON_BIN_U32_TYPE                     2
#define WIALON_BIN_U64_TYPE                     3
#define WIALON_BIN_I8_TYPE                      4
#define WIALON_BIN_I16_TYPE                     5
#define WIALON_BIN_I32_TYPE                     6
#define WIALON_BIN_I64_TYPE                     7
#define WIALON_BIN_FLOAT_TYPE                   8
#define WIALON_BIN_DOUBLE_TYPE                  9
#define WIALON_BIN_STRING_TYPE                  10

#if !defined(WIALON_BIN_STRING_TYPE_MAX_SIZE)
#define WIALON_BIN_STRING_TYPE_MAX_SIZE         96//    ,  '\0'
#endif //!defined(WIALON_BIN_STRING_TYPE_MAX_SIZE)

typedef __big_endian __packed struct
{
  uint8_t subrecord_type;     //WIALON_BIN_CUSTOM_PARAM_SUBRECORD_TYPE
  uint16_t count;              //     (0-32767)|0x8000
}wialon_bin_custom_param_subrecord_header_t;

typedef __big_endian __packed struct
{
  uint8_t number;             // . //0-127    
  uint8_t type;               //WIALON_BIN_U8_TYPE, WIALON_BIN_U16_TYPE, WIALON_BIN_U32_TYPE, WIALON_BIN_STRING_TYPE
}wialon_bin_custom_param_subrecord_t;

typedef __big_endian __packed struct
{
  uint16_t number;            // . //(0-32767)|0x8000     
  uint8_t type;               //WIALON_BIN_U8_TYPE, WIALON_BIN_U16_TYPE, WIALON_BIN_U32_TYPE, WIALON_BIN_STRING_TYPE
}wialon_bin_custom_param_subrecord_ext_t;

typedef __big_endian uint8_t wialon_bin_u8_t;
typedef __big_endian uint16_t wialon_bin_u16_t;
typedef __big_endian uint32_t wialon_bin_u32_t;
typedef __big_endian int8_t wialon_bin_i8_t;
typedef __big_endian int16_t wialon_bin_i16_t;
typedef __big_endian int32_t wialon_bin_i32_t;
typedef __big_endian float wialon_bin_float_t;
typedef __packed __big_endian double wialon_bin_double_t;
typedef __packed __big_endian uint64_t wialon_bin_u64_t;
typedef __packed __big_endian int64_t wialon_bin_i64_t;

typedef __big_endian __packed struct
{
  uint16_t head; //WIALON_BIN_TX_HEAD
  uint8_t type; //DATA_WIALON_BIN_PACKET_TYPE
  uint16_t seq; //0-65535
  uint16_t len; //(0-32767)|0x8000
}wialon_bin_data_t;

typedef __big_endian __packed struct
{
  uint32_t time;
  uint8_t count;
}wialon_bin_data_header_t;

typedef struct
{
  uint32_t data_size;           //    
  uint32_t wait_data_len;       //  
  uint16_t recv_crc;            //rc  
  uint16_t calc_crc;            //c  crc   
  uint8_t  data_type;           // 
}wialon_bin_download_processing_t;

typedef struct
{
  uint16_t curr_chunk;
  uint16_t last_chunk;
  uint16_t last_chunk_len;
  uint32_t time_stamp;
  const char* name;
  
  uint32_t end_wait_ack_time;
  uint16_t waiting_rx_seq;
  uint8_t  is_wait_ack:4;
  uint8_t  file_type:4;         //0 -  , 1 - ddd 
}wialon_bin_file_upl_processing_t;

typedef struct
{
  uint8_t* parse_buff;                       //  ,    (    )
  uint16_t parse_len;                        // ,    (    )
  
  uint16_t rx_mem_size;                      //   
  
  uint8_t* tx_mem;                           //   
  uint16_t tx_mem_size;                      // 
  
  uint8_t  conn_ctx_id;                      //id tcp 
  uint8_t  bbox_receiver;
  
  //internal
  uint8_t is_authenticated:4;
  uint8_t is_wait_ping_ack:4;
  uint16_t wait_ping_ack_seq;
   
  uint16_t tx_seq; 
  wialon_bin_wait_ack_t bbox;                 //     bbox   
  
  wialon_bin_file_upl_processing_t upl;       //   
  wialon_bin_download_processing_t dwn;       //   
  
  uint64_t terminal_id;
  const uint8_t* use_passwd_opt;              //     
  const char* passwd;                            
  
  const common_prot_const_t*   common_const; //   
}wialon_bin_ctx_t;

void WialonBinResetCtxState(wialon_bin_ctx_t* ctx);
void WialonBinDeInitCtx(wialon_bin_ctx_t* ctx);
int16_t WialonBinRxProcessing(wialon_bin_ctx_t* ctx);
int16_t WialonBinSendAuthRequest(wialon_bin_ctx_t* ctx);
int16_t WialonBinBboxUploadHandle(wialon_bin_ctx_t* ctx);
int16_t WialonBinSendPing(wialon_bin_ctx_t* ctx);
int16_t WialonBinFileUploadHandle(wialon_bin_ctx_t* ctx);

#if defined(USE_SERVER_NOTIFY_IN_WCOMBINE)
int16_t WialonBinNotifiesUploadHandle(wialon_bin_ctx_t* ctx);
#endif //USE_SERVER_NOTIFY_IN_WCOMBINE

#define WIALON_BIN_TX_DATA_OFFSET()                (sizeof(wialon_bin_header_t))
#define WIALON_BIN_TX_CRC_OFFSET(data_len)         (WIALON_BIN_TX_DATA_OFFSET()+(data_len))
#define WIALON_BIN_TX_PACKET_SIZE(data_len)        (WIALON_BIN_TX_CRC_OFFSET(data_len)+sizeof(wialon_bin_crc_t))

#ifdef __cplusplus
}
#endif 

#endif /*__WIALON_BINARY_PROTOCOL_H*/
