/**
******************************************************************************
* File Name          : wialon_text_can_cmd.c
* Description        : 
*                      
******************************************************************************
*/

#include "serv_protocols_lib/wialon_text_can_cmd.h"
#include "serv_protocols_lib/serv_protocol_common.h"

static const struct wialon_text_can_command_table_struct
{
  const char* cmd;
  const uint8_t can_cmd;
  const char* verbose;
}wialon_text_can_command_table[]=
{
  {"#can_blinkerflasing#\r\n",          BLINKER_FLASHING_CAN_COMMAND,                   "blinker flasing"},
  {"#can_closealldoor#\r\n",            ALL_DOOR_CLOSING_CAN_COMMAND,                   "close all door"},
  {"#can_openalldoor#\r\n",             ALL_DOOR_OPENING_CAN_COMMAND,                   "open all door"},
  {"#can_opendriverdoor#\r\n",          DRIVER_DOOR_OPENING_CAN_COMMAND,                "open driver door"},
  
  //new commands
  {"#can_opentrunk#\r\n",               TRUNK_DOOR_OPENING_CAN_COMMAND,                 "open trunk door"},
  {"#can_stopengine#\r\n",              ENGINE_STOPING_CAN_COMMAND,                     "stop engine"},
  {"#can_startengine#\r\n",             ENGINE_STARTING_CAN_COMMAND,                    "start engine"},
  {"#can_driverdooremulation#\r\n",     EMULATION_DRIVER_DOOR_OPENING_CAN_COMMAND,      "emulation driver door"},
  {"#can_stopwebasto#\r\n",             WEBASTO_STOPPING_CAN_COMMAND,                   "stop webasto"},
  {"#can_startwebasto#\r\n",            WEBASTO_STARTING_CAN_COMMAND,                   "start webasto"},
  {"#can_horn#\r\n",                    HORN_SIGNALING_CAN_COMMAND,                     "horn signaling"},
  {"#can_hornblinker#\r\n",             HORN_W_BLINKER_SIGNALIG_CAN_COMMAND,            "horn and blinker"},
  {"#can_closewindows3#\r\n",           WINDOWS_CLOSING_3S_CAN_COMMAND,                 "close windows 3s"},
  {"#can_closewindows7#\r\n",           WINDOWS_CLOSING_7S_CAN_COMMAND,                 "close windows 7s"},
  {"#can_closewindows11#\r\n",          WINDOWS_CLOSING_11S_CAN_COMMAND,                "close windows 11s"},
  {"#can_closewindows15#\r\n",          WINDOWS_CLOSING_15S_CAN_COMMAND,                "close windows 15s"},
  {"#can_closewindows19#\r\n",          WINDOWS_CLOSING_19S_CAN_COMMAND,                "close windows 19s"},
  {"#can_closewindows23#\r\n",          WINDOWS_CLOSING_23S_CAN_COMMAND,                "close windows 23s"},
  {"#can_closewindows29#\r\n",          WINDOWS_CLOSING_29S_CAN_COMMAND,                "close windows 29s"},
  {"#can_openwindows3#\r\n",            WINDOWS_OPENING_3S_CAN_COMMAND,                 "open windows 3s"},
  {"#can_openwindows7#\r\n",            WINDOWS_OPENING_7S_CAN_COMMAND,                 "open windows 7s"},
  {"#can_openwindows11#\r\n",           WINDOWS_OPENING_11S_CAN_COMMAND,                "open windows 11s"},
  {"#can_openwindows15#\r\n",           WINDOWS_OPENING_15S_CAN_COMMAND,                "open windows 15s"},
  {"#can_openwindows19#\r\n",           WINDOWS_OPENING_19S_CAN_COMMAND,                "open windows 19s"},
  {"#can_openwindows23#\r\n",           WINDOWS_OPENING_23S_CAN_COMMAND,                "open windows 23s"},
  {"#can_openwindows29#\r\n",           WINDOWS_OPENING_29S_CAN_COMMAND,                "open windows 29s"},
  
  //yadrive commands
  {"#yadrive_warming#\r\n",             YADRIVE_WARMING_COMMAND,                        "yadrive_warming"},
  {"#yadrive_stop_warming#\r\n",        YADRIVE_STOP_WARMING_COMMAND,                   "yadrive_stop_warming"},
  {"#yadrive_start_of_lease#\r\n",      YADRIVE_START_OF_LEASE_COMMAND,                 "yadrive_start_of_lease"},
  {"#yadrive_end_of_lease#\r\n",        YADRIVE_END_OF_LEASE_COMMAND,                   "yadrive_end_of_lease"},
  {"#yadrive_forced_end_of_lease#\r\n", YADRIVE_FORCED_END_OF_LEASE_COMMAND,            "yadrive_forced_end_of_lease"},
  {"#yadrive_hood_unlock#\r\n",         YADRIVE_HOOD_UNLOCK_COMMAND,                    "yadrive_hood_unlock"},
  {"#yadrive_hood_lock#\r\n",           YADRIVE_HOOD_LOCK_COMMAND,                      "yadrive_hood_lock"},
  {"#yadrive_dtc_clear#\r\n",           YADRIVE_DTC_CLEAR_COMMAND,                      "yadrive_dtc_clear"},

  //temporarry taxi
  {"#taxi_unlock#\r\n",                 YADRIVE_START_OF_LEASE_COMMAND,                 "taxi unlock"},
  {"#taxi_soft_lock#\r\n",              YADRIVE_END_OF_LEASE_COMMAND,                   "taxi soft lock"},
  {"#taxi_hard_lock#\r\n",              YADRIVE_FORCED_END_OF_LEASE_COMMAND,            "taxi hard lock"},
};

static const uint8_t wialon_text_can_command_table_count=sizeof(wialon_text_can_command_table)/sizeof(wialon_text_can_command_table[0]);

static_assert(!(sizeof(wialon_text_can_command_table)/sizeof(wialon_text_can_command_table[0])>=UNKNOWN_CAN_CMD_TABLE_IDX),"max wialon_text_can_command_table_count is 254");

uint8_t is_can_cmd_in_sms(const char* pl, uint8_t* can_cmd, const char** verbose)
{
 
  for(uint8_t i=0; i<wialon_text_can_command_table_count; i++)
  {
   
    if(strlen(pl)==(strlen(wialon_text_can_command_table[i].cmd)-(sizeof("##\r\n")-1)) && NULL!=strstr(&wialon_text_can_command_table[i].cmd[1], pl))
    {
      *can_cmd=wialon_text_can_command_table[i].can_cmd;
      *verbose=wialon_text_can_command_table[i].verbose;
      return i;
    }
    
  }
  
  return UNKNOWN_CAN_CMD_TABLE_IDX;
}

//� ������ ������ ���������� idx �� �������, ����� UNKNOWN_CAN_CMD_TABLE_IDX
uint8_t get_wialon_can_cmd_table_idx(uint8_t is_wips, const char* pl, uint16_t pl_len, uint32_t* command_uuid, uint8_t* command_uuid_len)
{
  uint8_t cut_len;
  
  if(is_wips)   cut_len=1; //�� ��������� ������ \n 
  else          cut_len=0;
  
  if(command_uuid!=NULL) *command_uuid=0;
  if(command_uuid_len!=NULL) *command_uuid_len=0;  
  
  //���� ������� � UUID
  if(pl[0]=='/')
  {
    uint32_t uuid;
    uint16_t uuid_len;
    char* endptr=NULL;
    uuid=strtoul(&pl[1], &endptr, 16);
    if(endptr!=NULL && *endptr=='#' && endptr>pl && pl_len>(endptr-pl))
    {
      uuid_len=(endptr-pl);
      pl+=uuid_len;
      pl_len-=uuid_len;
      if(command_uuid!=NULL) *command_uuid=uuid;
      if(command_uuid_len!=NULL) *command_uuid_len=uuid_len;  
    }
    else
    {
      return UNKNOWN_CAN_CMD_TABLE_IDX;
    }
  }
  
  for(uint8_t i=0; i<wialon_text_can_command_table_count; i++)
  {
    uint8_t cmd_len=strlen(wialon_text_can_command_table[i].cmd);
    
    if(pl_len>=(cmd_len-cut_len) && strncmp(pl, wialon_text_can_command_table[i].cmd, cmd_len-cut_len)==0)
    {
      return i;
    }
    
  }
  
  return UNKNOWN_CAN_CMD_TABLE_IDX;
}

//���������� ����� ������� �� �������
uint8_t get_wialon_can_cmd_params(uint8_t is_wips, uint8_t table_idx, uint8_t* can_cmd, const char** verbose)
{
  uint8_t cut_len;
  
  if(table_idx>=wialon_text_can_command_table_count) return 0;
  
  if(is_wips)   cut_len=1; //�� ��������� ������ \n 
  else          cut_len=0;
  
  *can_cmd=wialon_text_can_command_table[table_idx].can_cmd;
  *verbose=wialon_text_can_command_table[table_idx].verbose;
  return (strlen(wialon_text_can_command_table[table_idx].cmd)-cut_len);
}

const char* get_verbose_from_can_cmd(const uint8_t can_cmd)
{
  for(uint8_t i=0; i<wialon_text_can_command_table_count; i++)
  {
    if(can_cmd==wialon_text_can_command_table[i].can_cmd) return wialon_text_can_command_table[i].verbose;
  }
  
  return "unknown";
}