/**
  ******************************************************************************
  * File Name          : wialon_text_can_cmd.h
  * Description        :
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __WIALON_TEXT_CAN_CMD_H
#define __WIALON_TEXT_CAN_CMD_H
#ifdef __cplusplus
extern "C" {
#endif 
  
#include <stdint.h> 
#include <stdlib.h>
#include <string.h>

//CAN_CONTROL_CMD_TYPE params:
#define BLINKER_FLASHING_CAN_COMMAND                    0
#define HORN_SIGNALING_CAN_COMMAND                      1
#define HORN_W_BLINKER_SIGNALIG_CAN_COMMAND             2
#define WINDOWS_CLOSING_1S_CAN_COMMAND                  3
#define WINDOWS_CLOSING_3S_CAN_COMMAND                  4
#define WINDOWS_CLOSING_5S_CAN_COMMAND                  5
#define WINDOWS_CLOSING_7S_CAN_COMMAND                  6
#define WINDOWS_CLOSING_9S_CAN_COMMAND                  7
#define WINDOWS_CLOSING_11S_CAN_COMMAND                 8
#define WINDOWS_CLOSING_13S_CAN_COMMAND                 9
#define WINDOWS_CLOSING_15S_CAN_COMMAND                 10
#define WINDOWS_CLOSING_17S_CAN_COMMAND                 11
#define WINDOWS_CLOSING_19S_CAN_COMMAND                 12
#define WINDOWS_CLOSING_21S_CAN_COMMAND                 13
#define WINDOWS_CLOSING_23S_CAN_COMMAND                 14
#define WINDOWS_CLOSING_25S_CAN_COMMAND                 15
#define WINDOWS_CLOSING_27S_CAN_COMMAND                 16
#define WINDOWS_CLOSING_29S_CAN_COMMAND                 17
#define WINDOWS_OPENING_1S_CAN_COMMAND                  18
#define WINDOWS_OPENING_3S_CAN_COMMAND                  19
#define WINDOWS_OPENING_5S_CAN_COMMAND                  20
#define WINDOWS_OPENING_7S_CAN_COMMAND                  21
#define WINDOWS_OPENING_9S_CAN_COMMAND                  22
#define WINDOWS_OPENING_11S_CAN_COMMAND                 23
#define WINDOWS_OPENING_13S_CAN_COMMAND                 24
#define WINDOWS_OPENING_15S_CAN_COMMAND                 25
#define WINDOWS_OPENING_17S_CAN_COMMAND                 26
#define WINDOWS_OPENING_19S_CAN_COMMAND                 27
#define WINDOWS_OPENING_21S_CAN_COMMAND                 28
#define WINDOWS_OPENING_23S_CAN_COMMAND                 29
#define WINDOWS_OPENING_25S_CAN_COMMAND                 30
#define WINDOWS_OPENING_27S_CAN_COMMAND                 31
#define WINDOWS_OPENING_29S_CAN_COMMAND                 32
#define ALL_DOOR_CLOSING_CAN_COMMAND                    33
#define DRIVER_DOOR_OPENING_CAN_COMMAND                 34
#define ALL_DOOR_OPENING_CAN_COMMAND                    35  
#define TRUNK_DOOR_OPENING_CAN_COMMAND                  36
#define ENGINE_STOPING_CAN_COMMAND                      37
#define ENGINE_STARTING_CAN_COMMAND                     38
#define EMULATION_DRIVER_DOOR_OPENING_CAN_COMMAND       39
#define WEBASTO_STOPPING_CAN_COMMAND                    40
#define WEBASTO_STARTING_CAN_COMMAND                    41

#define YADRIVE_WARMING_COMMAND                         42
#define YADRIVE_STOP_WARMING_COMMAND                    43
#define YADRIVE_START_OF_LEASE_COMMAND                  44
#define YADRIVE_END_OF_LEASE_COMMAND                    45
#define YADRIVE_HOOD_UNLOCK_COMMAND                     46
#define YADRIVE_HOOD_LOCK_COMMAND                       47
#define YADRIVE_FORCED_END_OF_LEASE_COMMAND             48
#define YADRIVE_DTC_CLEAR_COMMAND                       49

#define AUXILIARY_CAR_COMMAND_W_ARG_0                   60
#define AUXILIARY_CAR_COMMAND_W_ARG_1                   61
#define AUXILIARY_CAR_COMMAND_W_ARG_2                   62
#define AUXILIARY_CAR_COMMAND_W_ARG_3                   63
#define AUXILIARY_CAR_COMMAND_W_ARG_4                   64
#define AUXILIARY_CAR_COMMAND_W_ARG_5                   65

#define UNKNOWN_CAN_CMD_TABLE_IDX                       0xFF  
uint8_t get_wialon_can_cmd_table_idx(uint8_t is_wips, const char* pl, uint16_t pl_len, uint32_t* command_uuid, uint8_t* command_uuid_len);
uint8_t get_wialon_can_cmd_params(uint8_t is_wips, uint8_t table_idx, uint8_t* can_cmd, const char** verbose);
uint8_t is_can_cmd_in_sms(const char* pl, uint8_t* can_cmd, const char** verbose);
const char* get_verbose_from_can_cmd(const uint8_t can_cmd);

#ifdef __cplusplus
}
#endif 

#endif /*__WIALON_TEXT_CAN_CMD_H*/