#include "tea_crypt/tea.h"

void tea_encrypt (uint32_t* v, const uint32_t* k) 
{
  uint32_t v0=v[0], v1=v[1], sum=0, i;           /* set up */
  const uint32_t delta=0x9e3779b9;               /* a key schedule constant */
  uint32_t k0=k[0], k1=k[1], k2=k[2], k3=k[3];   /* cache key */
  for (i=0; i < 32; i++) 
  {                                              /* basic cycle start */
    sum += delta;
    v0 += ((v1<<4) + k0) ^ (v1 + sum) ^ ((v1>>5) + k1);
    v1 += ((v0<<4) + k2) ^ (v0 + sum) ^ ((v0>>5) + k3);  
  }                                              /* end cycle */
  v[0]=v0; v[1]=v1;
}

void tea_decrypt(uint32_t* v, const uint32_t* k) 
{
  const uint32_t delta=0x9e3779b9;                    /* a key schedule constant */
  uint32_t v0=v[0], v1=v[1], sum=0xC6EF3720, i;       /* set up */
  uint32_t k0=k[0], k1=k[1], k2=k[2], k3=k[3];        /* cache key */
  for (i=0; i<32; i++) {                              /* basic cycle start */
    v1 -= ((v0<<4) + k2) ^ (v0 + sum) ^ ((v0>>5) + k3);
    v0 -= ((v1<<4) + k0) ^ (v1 + sum) ^ ((v1>>5) + k1);
    sum -= delta;                                   
  }                                                   /* end cycle */
  v[0]=v0; v[1]=v1;
}

static void tea_block_certify(tea_context* ctx, uint8_t buf[8])
{
  ctx->cert[0] ^= (buf[0]<<24) | (buf[1]<<16) | (buf[2]<<8) | (buf[3]<<0);
  ctx->cert[1] ^= (buf[4]<<24) | (buf[5]<<16) | (buf[6]<<8) | (buf[7]<<0);
  tea_encrypt(ctx->cert, ctx->key);
}

void tea_certify_init(tea_context* ctx, const uint32_t key[4])
{
  ctx->key=key;
  ctx->block_pos=0;
  ctx->cert[0]=0;
  ctx->cert[1]=0;
}

void tea_certify_update(tea_context* ctx, uint8_t* buf, uint16_t len)
{
  if(!len) return;
  
  //    update
  if(ctx->block_pos)
  {
    uint8_t copy_len;
    copy_len=sizeof(ctx->block)-ctx->block_pos;
    if(copy_len>len) copy_len=(uint8_t)len;
    memcpy(&ctx->block[ctx->block_pos], buf, copy_len);
    ctx->block_pos+=copy_len;
    buf+=copy_len;
    len-=copy_len;
    if(ctx->block_pos>=sizeof(ctx->block)) ctx->block_pos=0;
    if(ctx->block_pos==0)
    {
      tea_block_certify(ctx, ctx->block);
      if(!len) return;
    }
    else 
      return;
  }

  uint16_t chunks=len/sizeof(ctx->block);
  while(chunks--)
  {
    tea_block_certify(ctx, buf);
    buf+=sizeof(ctx->block);
    len-=sizeof(ctx->block);
  }
  
  //     (   >=sizeof(ctx->block))
  if(len)
  {
    memcpy(ctx->block, buf, len);
    ctx->block_pos=(uint8_t)len;
  }
}

void tea_certify_finish(tea_context* ctx)
{
  if(ctx->block_pos!=0)
  {
    memset(&ctx->block[ctx->block_pos], 0, sizeof(ctx->block)-ctx->block_pos);
    tea_block_certify(ctx, ctx->block);
  }
}
