#ifndef __TEA_H
#define __TEA_H

#ifdef __cplusplus
extern "C" {
#endif
#include <stdint.h>
#include <string.h>
  
  typedef struct
  {
    const uint32_t* key;
    uint32_t        cert[2];
    uint8_t         block[8];
    uint8_t         block_pos;
  }
  tea_context;
  
  void tea_encrypt (uint32_t* v, const uint32_t* k);
  void tea_decrypt(uint32_t* v, const uint32_t* k);
  void tea_certify_init(tea_context* ctx, const uint32_t key[4]);
  void tea_certify_update(tea_context* ctx, uint8_t* buf, uint16_t len);
  void tea_certify_finish(tea_context* ctx);
  
#ifdef __cplusplus
}
#endif

#endif //__TEA_H

